/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TypeCheckingFilter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.CardinalityCheckingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.SingletonAtomizer;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.IntegerValue;

public final class CardinalityChecker
extends UnaryExpression {
    private int requiredCardinality = -1;
    private RoleLocator role;

    private CardinalityChecker(Expression sequence, int cardinality, RoleLocator role) {
        super(sequence);
        this.requiredCardinality = cardinality;
        this.role = role;
        this.adoptChildExpression(sequence);
    }

    public static Expression makeCardinalityChecker(Expression sequence, int cardinality, RoleLocator role) {
        UnaryExpression result;
        if (sequence instanceof Atomizer && !Cardinality.allowsMany(cardinality)) {
            Expression base = ((Atomizer)sequence).getBaseExpression();
            result = new SingletonAtomizer(base, role, Cardinality.allowsZero(cardinality));
        } else {
            result = new CardinalityChecker(sequence, cardinality, role);
        }
        ExpressionTool.copyLocationInfo(sequence, result);
        return result;
    }

    protected OperandRole getOperandRole() {
        return OperandRole.SAME_FOCUS_ACTION;
    }

    public int getRequiredCardinality() {
        return this.requiredCardinality;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.operand = visitor.typeCheck(this.operand, contextInfo);
        if (this.requiredCardinality == 57344 || Cardinality.subsumes(this.requiredCardinality, this.operand.getCardinality())) {
            return this.operand;
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        this.operand = visitor.optimize(this.operand, contextItemType);
        if (this.requiredCardinality == 57344 || Cardinality.subsumes(this.requiredCardinality, this.operand.getCardinality())) {
            return this.operand;
        }
        if ((this.operand.getCardinality() & this.requiredCardinality) == 0) {
            XPathException err = new XPathException("The " + this.role.getMessage() + " does not satisfy the cardinality constraints", this.role.getErrorCode());
            err.setLocator(this);
            err.setIsTypeError(true);
            throw err;
        }
        if (this.operand instanceof ItemChecker) {
            Expression base;
            ItemChecker checker = (ItemChecker)this.operand;
            this.operand = base = checker.getBaseExpression();
            checker.replaceOperand(base, this);
            checker.resetLocalStaticProperties();
            this.resetLocalStaticProperties();
            return checker;
        }
        return this;
    }

    public void setErrorCode(String code) {
        this.role.setErrorCode(code);
    }

    public RoleLocator getRoleLocator() {
        return this.role;
    }

    public int getImplementationMethod() {
        int m3 = 22;
        if (!Cardinality.allowsMany(this.requiredCardinality)) {
            m3 |= 1;
        }
        return m3;
    }

    public IntegerValue[] getIntegerBounds() {
        return this.operand.getIntegerBounds();
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator base = this.operand.iterate(context);
        if ((base.getProperties() & 2) != 0) {
            int count = ((LastPositionFinder)((Object)base)).getLength();
            if (count == 0 && !Cardinality.allowsZero(this.requiredCardinality)) {
                this.typeError("An empty sequence is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), context);
            } else if (count == 1 && this.requiredCardinality == 8192) {
                this.typeError("The only value allowed for the " + this.role.getMessage() + " is an empty sequence", this.role.getErrorCode(), context);
            } else if (count > 1 && !Cardinality.allowsMany(this.requiredCardinality)) {
                this.typeError("A sequence of more than one item is not allowed as the " + this.role.getMessage() + CardinalityChecker.depictSequenceStart(base.getAnother(), 2), this.role.getErrorCode(), context);
            }
            return base;
        }
        return new CardinalityCheckingIterator(base, this.requiredCardinality, this.role, this);
    }

    public static String depictSequenceStart(SequenceIterator seq, int max) {
        try {
            FastStringBuffer sb = new FastStringBuffer(64);
            int count = 0;
            sb.append(" (");
            while (true) {
                Item next;
                if ((next = seq.next()) == null) {
                    sb.append(") ");
                    return sb.toString();
                }
                if (count++ > 0) {
                    sb.append(", ");
                }
                if (count > max) {
                    sb.append("...) ");
                    return sb.toString();
                }
                sb.append(Err.depict(next));
            }
        }
        catch (XPathException e) {
            return "";
        }
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        Item second;
        SequenceIterator iter = this.operand.iterate(context);
        Item first = iter.next();
        if (first == null) {
            if (!Cardinality.allowsZero(this.requiredCardinality)) {
                this.typeError("An empty sequence is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), context);
                return null;
            }
        } else if (this.requiredCardinality == 8192) {
            this.typeError("An empty sequence is required as the " + this.role.getMessage(), this.role.getErrorCode(), context);
            return null;
        }
        if ((second = iter.next()) != null) {
            this.typeError("A sequence of more than one item is not allowed as the " + this.role.getMessage() + CardinalityChecker.depictSequenceStart(iter.getAnother(), 2), this.role.getErrorCode(), context);
            return null;
        }
        return first;
    }

    public void process(XPathContext context) throws XPathException {
        Expression next = this.operand;
        ItemType type = Type.ITEM_TYPE;
        if (next instanceof ItemChecker) {
            type = ((ItemChecker)next).getRequiredType();
            next = ((ItemChecker)next).getBaseExpression();
        }
        if ((next.getImplementationMethod() & 4) != 0 && !(type instanceof DocumentNodeTest)) {
            SequenceReceiver out = context.getReceiver();
            TypeCheckingFilter filter = new TypeCheckingFilter(out);
            filter.setRequiredType(type, this.requiredCardinality, this.role, this);
            context.setReceiver(filter);
            next.process(context);
            try {
                filter.close();
            }
            catch (XPathException e) {
                e.maybeSetLocation(this);
                throw e;
            }
            context.setReceiver(out);
        } else {
            super.process(context);
        }
    }

    public ItemType getItemType() {
        return this.operand.getItemType();
    }

    public int computeCardinality() {
        return this.requiredCardinality;
    }

    public int computeSpecialProperties() {
        return this.operand.getSpecialProperties();
    }

    public Expression copy() {
        return new CardinalityChecker(this.getBaseExpression().copy(), this.requiredCardinality, this.role);
    }

    public boolean equals(Object other) {
        return super.equals(other) && this.requiredCardinality == ((CardinalityChecker)other).requiredCardinality;
    }

    public int hashCode() {
        return super.hashCode() ^ this.requiredCardinality;
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("checkCardinality");
        out.emitAttribute("occurs", Cardinality.toString(this.requiredCardinality));
        this.operand.explain(out);
        out.endElement();
    }

    public String toString() {
        switch (this.requiredCardinality) {
            case 16384: {
                return "exactly-one(" + this.operand.toString() + ")";
            }
            case 24576: {
                return "zero-or-one(" + this.operand.toString() + ")";
            }
            case 49152: {
                return "one-or-more(" + this.operand.toString() + ")";
            }
            case 8192: {
                return "must-be-empty(" + this.operand.toString() + ")";
            }
        }
        return "check(" + this.operand.toString() + ")";
    }

    public String getExpressionName() {
        return "CheckCardinality";
    }

    public String toShortString() {
        return this.operand.toShortString();
    }
}

