/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.evpull.EmptyEventIterator;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.EventIteratorOverSequence;
import net.sf.saxon.evpull.SingletonEventIterator;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.SuppliedParameterReference;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.LocationMap;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeCheckerEnvironment;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.om.IdentityComparable;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeSetPattern;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntHashSet;
import net.sf.saxon.z.IntIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Expression
implements SourceLocator,
InstructionInfo,
IdentityComparable {
    public static final int EVALUATE_METHOD = 1;
    public static final int ITERATE_METHOD = 2;
    public static final int PROCESS_METHOD = 4;
    public static final int WATCH_METHOD = 8;
    public static final int ITEM_FEED_METHOD = 16;
    public static final int EFFECTIVE_BOOLEAN_VALUE = 32;
    protected int staticProperties = -1;
    protected int locationId = -1;
    private Container container;
    private int[] slotsUsed;
    private int evaluationMethod;
    public static final IntegerValue UNBOUNDED_LOWER = (IntegerValue)IntegerValue.makeIntegerValue(new DoubleValue(-1.0E100));
    public static final IntegerValue UNBOUNDED_UPPER = (IntegerValue)IntegerValue.makeIntegerValue(new DoubleValue(1.0E100));
    public static final IntegerValue MAX_STRING_LENGTH = Int64Value.makeIntegerValue(Integer.MAX_VALUE);
    public static final IntegerValue MAX_SEQUENCE_LENGTH = Int64Value.makeIntegerValue(Integer.MAX_VALUE);

    public String getExpressionName() {
        return this.getClass().getName();
    }

    public int getImplementationMethod() {
        if (Cardinality.allowsMany(this.getCardinality())) {
            return 2;
        }
        return 1;
    }

    public boolean implementsStaticTypeCheck() {
        return false;
    }

    public boolean hasVariableBinding(Binding binding) {
        return false;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        for (Operand o : this.operands()) {
            Expression f;
            Expression e = o.getExpression();
            if (e == (f = e.simplify(visitor))) continue;
            this.replaceOperand(e, f);
            this.adoptChildExpression(f);
        }
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        return this;
    }

    public Expression staticTypeCheck(SequenceType req, boolean backwardsCompatible, RoleLocator role, TypeCheckerEnvironment visitor) throws XPathException {
        throw new UnsupportedOperationException("staticTypeCheck");
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        return this;
    }

    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        return this;
    }

    public Expression unordered(boolean retainAllNodes, boolean forStreaming) throws XPathException {
        return this;
    }

    public final int getSpecialProperties() {
        if (this.staticProperties == -1) {
            this.computeStaticProperties();
        }
        return this.staticProperties & 0xFFF0000;
    }

    public int getCardinality() {
        if (this.staticProperties == -1) {
            this.computeStaticProperties();
        }
        return this.staticProperties & 0xE000;
    }

    public abstract ItemType getItemType();

    public int getDependencies() {
        if (this.staticProperties == -1) {
            this.computeStaticProperties();
        }
        return this.staticProperties & 0x10007FF;
    }

    public IntegerValue[] getIntegerBounds() {
        return null;
    }

    public Iterable<Operand> operands() {
        return Collections.emptyList();
    }

    protected List<Operand> operandList(Operand ... a) {
        return Arrays.asList(a);
    }

    public void setFlattened(boolean flattened) {
    }

    public void setFiltered(boolean filtered) {
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        return this.iterate(context).next();
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        Item value = this.evaluateItem(context);
        return SingletonIterator.makeIterator(value);
    }

    public EventIterator iterateEvents(XPathContext context) throws XPathException {
        int m3 = this.getImplementationMethod();
        if ((m3 & 1) != 0) {
            Item item = this.evaluateItem(context);
            if (item == null) {
                return EmptyEventIterator.getInstance();
            }
            return new SingletonEventIterator(item);
        }
        return new EventIteratorOverSequence(this.iterate(context));
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        return ExpressionTool.effectiveBooleanValue(this.iterate(context));
    }

    public CharSequence evaluateAsString(XPathContext context) throws XPathException {
        Item o = this.evaluateItem(context);
        StringValue value = (StringValue)o;
        if (value == null) {
            return "";
        }
        return value.getStringValueCS();
    }

    public void process(XPathContext context) throws XPathException {
        int m3 = this.getImplementationMethod();
        if ((m3 & 1) != 0) {
            Item item = this.evaluateItem(context);
            if (item != null) {
                context.getReceiver().append(item, this.locationId, 2);
            }
        } else if ((m3 & 2) != 0) {
            SequenceIterator iter = this.iterate(context);
            SequenceReceiver out = context.getReceiver();
            try {
                Item it;
                while ((it = iter.next()) != null) {
                    out.append(it, this.locationId, 2);
                }
            }
            catch (XPathException e) {
                e.maybeSetLocation(this);
                e.maybeSetContext(context);
                throw e;
            }
        } else {
            throw new AssertionError((Object)("process() is not implemented in the subclass " + this.getClass()));
        }
    }

    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        throw new UnsupportedOperationException("Expression " + this.getClass() + " is not an updating expression");
    }

    public String toString() {
        int dot;
        FastStringBuffer buff = new FastStringBuffer(64);
        String className = this.getClass().getName();
        while ((dot = className.indexOf(46)) >= 0) {
            className = className.substring(dot + 1);
        }
        buff.append(className);
        boolean first = true;
        for (Operand o : this.operands()) {
            buff.append(first ? "(" : ", ");
            buff.append(o.getExpression().toString());
            first = false;
        }
        if (!first) {
            buff.append(")");
        }
        return buff.toString();
    }

    public String toShortString() {
        return this.getExpressionName();
    }

    public abstract void explain(ExpressionPresenter var1);

    public final void explain(Logger out) {
        ExpressionPresenter ep = new ExpressionPresenter(this.getConfiguration(), out);
        this.explain(ep);
        ep.close();
    }

    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
    }

    public void setContainer(Container container) {
        this.container = container;
        if (container != null) {
            for (Operand o : this.operands()) {
                Expression child = o.getExpression();
                if (child == null || child.getContainer() == container || child.container != null && child.container.getContainerGranularity() >= container.getContainerGranularity()) continue;
                child.setContainer(container);
            }
        }
    }

    public Container getContainer() {
        return this.container;
    }

    public void adoptChildExpression(Expression child) {
        if (child == null) {
            return;
        }
        if (this.container == null) {
            this.container = child.container;
        } else {
            child.setContainer(this.container);
        }
        if (this.locationId == -1) {
            ExpressionTool.copyLocationInfo(child, this);
        } else if (child.locationId == -1) {
            ExpressionTool.copyLocationInfo(this, child);
        }
        this.resetLocalStaticProperties();
    }

    public void setLocationId(int id) {
        this.locationId = id;
    }

    public final int getLocationId() {
        return this.locationId;
    }

    @Override
    public int getLineNumber() {
        if (this.locationId == -1) {
            return -1;
        }
        return this.locationId & 0xFFFFF;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public String getSystemId() {
        if (this.locationId == -1) {
            return this.getContainer() == null ? null : this.getContainer().getSystemId();
        }
        LocationMap map = this.getContainer().getPackageData().getLocationMap();
        if (map == null) {
            return null;
        }
        return map.getSystemId(this.locationId);
    }

    @Override
    public final String getPublicId() {
        return null;
    }

    public Configuration getConfiguration() {
        if (this.getContainer() == null) {
            throw new NullPointerException("NullPointerException processing " + this.toShortString());
        }
        return this.getContainer().getConfiguration();
    }

    public final Expression doPromotion(Expression subexpression, PromotionOffer offer) throws XPathException {
        if (subexpression == null) {
            return null;
        }
        Expression e = subexpression.promote(offer, this);
        if (e != subexpression) {
            this.adoptChildExpression(e);
        } else if (offer.accepted) {
            this.resetLocalStaticProperties();
        }
        return e;
    }

    public final void computeStaticProperties() {
        this.staticProperties = this.computeDependencies() | this.computeCardinality() | this.computeSpecialProperties();
    }

    public void resetLocalStaticProperties() {
        this.staticProperties = -1;
    }

    protected abstract int computeCardinality();

    protected int computeSpecialProperties() {
        return 0;
    }

    public int computeDependencies() {
        int dependencies = this.getIntrinsicDependencies();
        for (Operand o : this.operands()) {
            dependencies |= o.getExpression().getDependencies();
        }
        return dependencies;
    }

    public int getIntrinsicDependencies() {
        return 0;
    }

    public void checkForUpdatingSubexpressions() throws XPathException {
        for (Operand o : this.operands()) {
            Expression sub = o.getExpression();
            sub.checkForUpdatingSubexpressions();
            if (!sub.isUpdatingExpression()) continue;
            XPathException err = new XPathException("Updating expression appears in a context where it is not permitted", "XUST0001");
            err.setLocator(sub);
            throw err;
        }
    }

    public boolean isUpdatingExpression() {
        for (Operand o : this.operands()) {
            if (!o.getExpression().isUpdatingExpression()) continue;
            return true;
        }
        return false;
    }

    public boolean isVacuousExpression() {
        return false;
    }

    public abstract Expression copy();

    public boolean replaceOperand(Expression original, Expression replacement) {
        throw new IllegalArgumentException("Invalid replacement");
    }

    public void suppressValidation(int parentValidationMode) {
    }

    public int markTailFunctionCalls(StructuredQName qName, int arity) {
        return 0;
    }

    public Pattern toPattern(Configuration config, boolean is30) throws XPathException {
        ItemType type = this.getItemType();
        if ((this.getDependencies() & 0xE) == 0 && (type instanceof NodeTest || this instanceof VariableReference)) {
            return new NodeSetPattern(this);
        }
        throw new XPathException("Cannot convert the expression {" + this.toString() + "} to a pattern");
    }

    public final synchronized int[] getSlotsUsed() {
        if (this.slotsUsed != null) {
            return this.slotsUsed;
        }
        IntHashSet slots = new IntHashSet(10);
        Expression.gatherSlotsUsed(this, slots);
        this.slotsUsed = new int[slots.size()];
        int i = 0;
        IntIterator iter = slots.iterator();
        while (iter.hasNext()) {
            this.slotsUsed[i++] = iter.next();
        }
        Arrays.sort(this.slotsUsed);
        return this.slotsUsed;
    }

    private static void gatherSlotsUsed(Expression exp, IntHashSet slots) {
        if (exp instanceof VariableReference) {
            int slot;
            Binding binding = ((VariableReference)exp).getBinding();
            if (binding == null) {
                throw new NullPointerException("Unbound variable at line " + exp.getLineNumber());
            }
            if (!binding.isGlobal() && (slot = ((LocalBinding)binding).getLocalSlotNumber()) != -1 && !slots.contains(slot)) {
                slots.add(slot);
            }
        } else if (exp instanceof SuppliedParameterReference) {
            int slot = ((SuppliedParameterReference)exp).getSlotNumber();
            slots.add(slot);
        } else {
            for (Operand o : exp.operands()) {
                Expression.gatherSlotsUsed(o.getExpression(), slots);
            }
        }
    }

    protected void dynamicError(String message, String code, XPathContext context) throws XPathException {
        XPathException err = new XPathException(message, this);
        err.setXPathContext(context);
        err.setErrorCode(code);
        throw err;
    }

    protected void typeError(String message, String errorCode, XPathContext context) throws XPathException {
        XPathException e = new XPathException(message, this);
        e.setIsTypeError(true);
        e.setErrorCode(errorCode);
        e.setXPathContext(context);
        throw e;
    }

    @Override
    public int getConstructType() {
        return 2098;
    }

    @Override
    public StructuredQName getObjectName() {
        return null;
    }

    @Override
    public Object getProperty(String name) {
        if (name.equals("expression")) {
            return this;
        }
        return null;
    }

    @Override
    public Iterator<String> getProperties() {
        return new MonoIterator<String>("expression");
    }

    public int getHostLanguage() {
        Container container = this.getContainer();
        if (container == null) {
            return 54;
        }
        return container.getHostLanguage();
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet attachmentPoint;
        boolean dependsOnFocus = ExpressionTool.dependsOnFocus(this);
        if (pathMapNodeSet == null) {
            if (dependsOnFocus) {
                ContextItemExpression cie = new ContextItemExpression();
                cie.setContainer(this.getContainer());
                pathMapNodeSet = new PathMap.PathMapNodeSet(pathMap.makeNewRoot(cie));
            }
            attachmentPoint = pathMapNodeSet;
        } else {
            attachmentPoint = dependsOnFocus ? pathMapNodeSet : null;
        }
        PathMap.PathMapNodeSet result = new PathMap.PathMapNodeSet();
        for (Operand o : this.operands()) {
            result.addNodeSet(o.getExpression().addToPathMap(pathMap, attachmentPoint));
        }
        if (this.getItemType() instanceof AtomicType) {
            return null;
        }
        return result;
    }

    public boolean isSubtreeExpression() {
        if (ExpressionTool.dependsOnFocus(this)) {
            if ((this.getIntrinsicDependencies() & 0x1E) != 0) {
                return false;
            }
            for (Operand o : this.operands()) {
                if (o.getExpression().isSubtreeExpression()) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public void setEvaluationMethod(int method) {
        this.evaluationMethod = method;
    }

    public int getEvaluationMethod() {
        return this.evaluationMethod;
    }

    @Override
    public boolean isIdentical(IdentityComparable other) {
        return this == other;
    }

    @Override
    public int identityHashCode() {
        return System.identityHashCode(this);
    }
}

