/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.SequenceExtent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FunctionCall
extends Expression {
    private StructuredQName name;
    protected Expression[] argument;

    public final void setFunctionName(StructuredQName name) {
        this.name = name;
    }

    public StructuredQName getFunctionName() {
        return this.name;
    }

    public final int getNumberOfArguments() {
        return this.argument.length;
    }

    public void setArguments(Expression[] args) {
        this.argument = args;
        for (Expression arg : args) {
            this.adoptChildExpression(arg);
        }
    }

    public Expression[] getArguments() {
        return this.argument;
    }

    protected final Expression simplifyArguments(ExpressionVisitor visitor) throws XPathException {
        for (int i = 0; i < this.argument.length; ++i) {
            Expression exp = visitor.simplify(this.argument[i]);
            if (exp == this.argument[i]) continue;
            this.adoptChildExpression(exp);
            this.argument[i] = exp;
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        boolean fixed = true;
        for (int i = 0; i < this.argument.length; ++i) {
            Expression exp = visitor.typeCheck(this.argument[i], contextInfo);
            if (exp != this.argument[i]) {
                this.adoptChildExpression(exp);
                this.argument[i] = exp;
            }
            if (this.argument[i] instanceof Literal) continue;
            fixed = false;
        }
        this.checkArguments(visitor);
        if (fixed) {
            try {
                return this.preEvaluate(visitor);
            }
            catch (NoDynamicContextException err) {
                return this;
            }
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        boolean fixed = true;
        for (int i = 0; i < this.argument.length; ++i) {
            Expression exp = visitor.optimize(this.argument[i], contextItemType);
            if (exp != this.argument[i]) {
                this.adoptChildExpression(exp);
                this.argument[i] = exp;
            }
            if (!fixed || this.argument[i] instanceof Literal) continue;
            fixed = false;
        }
        this.checkArguments(visitor);
        if (fixed) {
            return this.preEvaluate(visitor);
        }
        return this;
    }

    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        if (this.getIntrinsicDependencies() != 0) {
            return this;
        }
        try {
            Literal lit = Literal.makeLiteral(SequenceExtent.makeSequenceExtent(this.iterate(visitor.getStaticContext().makeEarlyEvaluationContext())), this.getContainer());
            ExpressionTool.copyLocationInfo(this, lit);
            return lit;
        }
        catch (NoDynamicContextException e) {
            return this;
        }
        catch (UnsupportedOperationException e) {
            if (e.getCause() instanceof NoDynamicContextException) {
                return this;
            }
            throw e;
        }
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        for (int i = 0; i < this.argument.length; ++i) {
            this.argument[i] = this.doPromotion(this.argument[i], offer);
        }
        return this;
    }

    protected abstract void checkArguments(ExpressionVisitor var1) throws XPathException;

    protected int checkArgumentCount(int min2, int max) throws XPathException {
        int numArgs = this.argument.length;
        String msg = null;
        if (min2 == max && numArgs != min2) {
            msg = "Function " + this.getDisplayName() + " must have " + min2 + FunctionCall.pluralArguments(min2);
        } else if (numArgs < min2) {
            msg = "Function " + this.getDisplayName() + " must have at least " + min2 + FunctionCall.pluralArguments(min2);
        } else if (numArgs > max) {
            msg = "Function " + this.getDisplayName() + " must have no more than " + max + FunctionCall.pluralArguments(max);
        }
        if (msg != null) {
            XPathException err = new XPathException(msg, "XPST0017");
            err.setIsStaticError(true);
            err.setLocator(this);
            throw err;
        }
        return numArgs;
    }

    private static String pluralArguments(int num) {
        return num == 1 ? " argument" : " arguments";
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> list = new ArrayList<Operand>();
        for (Expression e : this.argument) {
            list.add(new Operand(e, OperandRole.NAVIGATE));
        }
        return list;
    }

    @Override
    public boolean replaceOperand(Expression original, Expression replacement) {
        boolean found = false;
        for (int i = 0; i < this.argument.length; ++i) {
            if (this.argument[i] != original) continue;
            this.argument[i] = replacement;
            found = true;
        }
        return found;
    }

    public PathMap.PathMapNodeSet addExternalFunctionCallToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodes) {
        PathMap.PathMapNodeSet result = new PathMap.PathMapNodeSet();
        for (Operand o : this.operands()) {
            result.addNodeSet(o.getExpression().addToPathMap(pathMap, pathMapNodes));
        }
        result.setHasUnknownDependencies();
        return result;
    }

    @Override
    public final String getExpressionName() {
        return this.getDisplayName();
    }

    public final String getDisplayName() {
        StructuredQName fName = this.getFunctionName();
        return fName == null ? "(anonymous)" : fName.getDisplayName();
    }

    @Override
    public String toString() {
        FastStringBuffer buff = new FastStringBuffer(64);
        StructuredQName fName = this.getFunctionName();
        String f = fName == null ? "$anonymousFunction" : (fName.hasURI("http://www.w3.org/2005/xpath-functions") ? fName.getLocalPart() : fName.getEQName());
        buff.append(f);
        boolean first = true;
        for (Operand o : this.operands()) {
            buff.append(first ? "(" : ", ");
            buff.append(o.getExpression().toString());
            first = false;
        }
        buff.append(first ? "()" : ")");
        return buff.toString();
    }

    @Override
    public String toShortString() {
        StructuredQName fName = this.getFunctionName();
        return (fName == null ? "$anonFn" : fName.getDisplayName()) + "(" + (this.getArguments().length == 0 ? "" : "...") + ")";
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("functionCall");
        out.emitAttribute("name", this.getDisplayName());
        for (Expression anArgument : this.argument) {
            anArgument.explain(out);
        }
        out.endElement();
    }

    public boolean equals(Object o) {
        if (!(o instanceof FunctionCall)) {
            return false;
        }
        FunctionCall f = (FunctionCall)o;
        if (!this.getFunctionName().equals(f.getFunctionName())) {
            return false;
        }
        if (this.getNumberOfArguments() != f.getNumberOfArguments()) {
            return false;
        }
        for (int i = 0; i < this.getNumberOfArguments(); ++i) {
            if (this.argument[i].equals(f.argument[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h2 = this.getFunctionName().hashCode();
        for (int i = 0; i < this.getNumberOfArguments(); ++i) {
            h2 ^= this.argument[i].hashCode();
        }
        return h2;
    }
}

