/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.NumericValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerRangeTest
extends Expression {
    Expression value;
    Expression min;
    Expression max;

    public IntegerRangeTest(Expression value, Expression min2, Expression max) {
        this.value = value;
        this.min = min2;
        this.max = max;
    }

    public Expression getValueExpression() {
        return this.value;
    }

    public Expression getMinValueExpression() {
        return this.min;
    }

    public Expression getMaxValueExpression() {
        return this.max;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        return this;
    }

    @Override
    public ItemType getItemType() {
        return BuiltInAtomicType.BOOLEAN;
    }

    @Override
    public int computeCardinality() {
        return 16384;
    }

    @Override
    public Expression copy() {
        return new IntegerRangeTest(this.value.copy(), this.min.copy(), this.max.copy());
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(new Operand(this.value, OperandRole.SINGLE_ATOMIC), new Operand(this.min, OperandRole.SINGLE_ATOMIC), new Operand(this.max, OperandRole.SINGLE_ATOMIC));
    }

    @Override
    public boolean replaceOperand(Expression original, Expression replacement) {
        boolean found = false;
        if (this.value == original) {
            this.value = replacement;
            found = true;
        }
        if (this.min == original) {
            this.min = replacement;
            found = true;
        }
        if (this.max == original) {
            this.max = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        this.value = this.doPromotion(this.value, offer);
        this.min = this.doPromotion(this.min, offer);
        this.max = this.doPromotion(this.max, offer);
        return this;
    }

    @Override
    public BooleanValue evaluateItem(XPathContext c) throws XPathException {
        NumericValue v = (NumericValue)this.value.evaluateItem(c);
        if (v == null) {
            return BooleanValue.FALSE;
        }
        if (!v.isWholeNumber()) {
            return BooleanValue.FALSE;
        }
        NumericValue v2 = (NumericValue)this.min.evaluateItem(c);
        if (v.compareTo(v2) < 0) {
            return BooleanValue.FALSE;
        }
        NumericValue v3 = (NumericValue)this.max.evaluateItem(c);
        return BooleanValue.get(v.compareTo(v3) <= 0);
    }

    @Override
    public void explain(ExpressionPresenter destination) {
        destination.startElement("integerRangeTest");
        this.value.explain(destination);
        this.min.explain(destination);
        this.max.explain(destination);
        destination.endElement();
    }

    @Override
    public String toString() {
        return ExpressionTool.parenthesize(this.value) + " = (" + ExpressionTool.parenthesize(this.min) + " to " + ExpressionTool.parenthesize(this.max) + ")";
    }
}

