/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.evpull.EmptyEventIterator;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ComponentInvocation;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.UserFunctionReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;

public class UserFunctionCall
extends FunctionCall
implements UserFunctionReference,
ComponentInvocation {
    private SequenceType staticType;
    private UserFunction function;
    private int bindingSlot = -1;
    private int tailCall = 0;
    private int[] argumentEvaluationModes = null;
    public static final int NOT_TAIL_CALL = 0;
    public static final int FOREIGN_TAIL_CALL = 1;
    public static final int SELF_TAIL_CALL = 2;

    public void setStaticType(SequenceType type) {
        this.staticType = type;
    }

    public void setFunction(UserFunction compiledFunction) {
        this.function = compiledFunction;
    }

    public void setBindingSlot(int slot) {
        this.bindingSlot = slot;
    }

    public int getBindingSlot() {
        return this.bindingSlot;
    }

    public void checkFunctionCall(UserFunction compiledFunction, ExpressionVisitor visitor) throws XPathException {
        boolean isXSLT = compiledFunction.getPackageData().getHostLanguage() == 50;
        int n = compiledFunction.getNumberOfArguments();
        for (int i = 0; i < n; ++i) {
            Object name = compiledFunction.getFunctionName();
            if (name == null) {
                name = "";
            }
            RoleLocator role = new RoleLocator(0, name, i);
            if (isXSLT) {
                role.setErrorCode("XTTE0790");
            }
            this.argument[i] = TypeChecker.staticTypeCheck(this.argument[i], compiledFunction.getArgumentType(i), false, role, visitor);
        }
    }

    public UserFunction getFunction() {
        return this.function;
    }

    public boolean isTailCall() {
        return this.tailCall != 0;
    }

    public boolean isRecursiveTailCall() {
        return this.tailCall == 2;
    }

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
    }

    public final StructuredQName getFunctionName() {
        StructuredQName n = super.getFunctionName();
        if (n == null) {
            return this.function.getFunctionName();
        }
        return n;
    }

    public SymbolicName getSymbolicName() {
        return new SymbolicName(155, this.getFunctionName(), this.getNumberOfArguments());
    }

    public Component getTarget() {
        return this.function.getDeclaringComponent();
    }

    public int[] getArgumentEvaluationModes() {
        return this.argumentEvaluationModes;
    }

    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public ItemType getItemType() {
        if (this.staticType == null) {
            return AnyItemType.getInstance();
        }
        return this.staticType.getPrimaryType();
    }

    public int getIntrinsicDependencies() {
        return 256;
    }

    public boolean isUpdatingExpression() {
        return this.function.isUpdating();
    }

    protected int computeSpecialProperties() {
        if (this.function == null || this.function.getBody() == null) {
            return super.computeSpecialProperties();
        }
        ArrayList<UserFunction> calledFunctions = new ArrayList<UserFunction>();
        ExpressionTool.gatherCalledFunctions(this.function.getBody(), calledFunctions);
        if (calledFunctions.isEmpty()) {
            return this.function.getBody().computeSpecialProperties();
        }
        return super.computeSpecialProperties();
    }

    public Expression copy() {
        if (this.function == null) {
            throw new UnsupportedOperationException("UserFunctionCall.copy()");
        }
        UserFunctionCall ufc = new UserFunctionCall();
        ufc.setFunction(this.function);
        ufc.setStaticType(this.staticType);
        Expression[] a2 = new Expression[this.argument.length];
        for (int i = 0; i < this.argument.length; ++i) {
            a2[i] = this.argument[i].copy();
        }
        ufc.argument = a2;
        if (this.argumentEvaluationModes != null) {
            int[] am2 = new int[this.argumentEvaluationModes.length];
            System.arraycopy(this.argumentEvaluationModes, 0, am2, 0, am2.length);
            ufc.argumentEvaluationModes = am2;
        }
        return ufc;
    }

    public int computeCardinality() {
        if (this.staticType == null) {
            return 57344;
        }
        return this.staticType.getCardinality();
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression e = super.typeCheck(visitor, contextInfo);
        if (e != this) {
            return e;
        }
        if (this.function != null) {
            if (this.function.getFunctionName() == null) {
                this.checkFunctionCall(this.function, visitor);
                Expression body = this.function.getBody();
                body = body.typeCheck(visitor, ContextItemStaticInfo.ABSENT);
                RoleLocator role = new RoleLocator(5, "", 0);
                body = TypeChecker.staticTypeCheck(body, this.function.getResultType(), visitor.getStaticContext().isInBackwardsCompatibleMode(), role, visitor);
                this.function.setBody(body);
            }
            this.computeArgumentEvaluationModes();
            if (this.staticType == SequenceType.ANY_SEQUENCE) {
                this.staticType = this.function.getResultType();
            }
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        Expression e = super.optimize(visitor, contextItemType);
        if (e == this && this.function != null) {
            this.computeArgumentEvaluationModes();
            Expression e2 = visitor.getConfiguration().obtainOptimizer().tryInlineFunctionCall(this, visitor, contextItemType);
            if (e2 != this) {
                return visitor.optimize(e2, contextItemType);
            }
            return e2;
        }
        return e;
    }

    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        boolean changed = false;
        for (int i = 0; i < this.argument.length; ++i) {
            Expression a2 = this.doPromotion(this.argument[i], offer);
            changed |= a2 != this.argument[i];
            this.argument[i] = a2;
        }
        if (changed && this.function != null) {
            this.computeArgumentEvaluationModes();
        }
        return this;
    }

    public void computeArgumentEvaluationModes() {
        this.argumentEvaluationModes = new int[this.argument.length];
        for (int i = 0; i < this.argument.length; ++i) {
            int refs = this.function.getParameterDefinitions()[i].getReferenceCount();
            if (refs == 0) {
                this.argumentEvaluationModes[i] = 5;
                continue;
            }
            if (this.function.getParameterDefinitions()[i].isIndexedVariable()) {
                this.argumentEvaluationModes[i] = 12;
                continue;
            }
            if ((this.argument[i].getDependencies() & 0x100) != 0) {
                this.argumentEvaluationModes[i] = ExpressionTool.eagerEvaluationMode(this.argument[i]);
                continue;
            }
            int m3 = ExpressionTool.lazyEvaluationMode(this.argument[i]);
            if (m3 == 3 && refs > 1) {
                m3 = 4;
            }
            this.argumentEvaluationModes[i] = m3;
        }
    }

    public boolean replaceOperand(Expression original, Expression replacement) {
        boolean found = super.replaceOperand(original, replacement);
        if (found && this.argumentEvaluationModes != null) {
            this.computeArgumentEvaluationModes();
        }
        return found;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        return this.addExternalFunctionCallToPathMap(pathMap, pathMapNodeSet);
    }

    public int markTailFunctionCalls(StructuredQName qName, int arity) {
        this.tailCall = this.getFunctionName().equals(qName) && arity == this.getNumberOfArguments() ? 2 : 1;
        return this.tailCall;
    }

    public int getImplementationMethod() {
        if (Cardinality.allowsMany(this.getCardinality())) {
            return 6;
        }
        return 1;
    }

    public Item evaluateItem(XPathContext c) throws XPathException {
        return this.callFunction(c).head();
    }

    public SequenceIterator iterate(XPathContext c) throws XPathException {
        return this.callFunction(c).iterate();
    }

    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        Sequence[] actualArgs = this.evaluateArguments(context);
        XPathContextMajor c2 = context.newCleanContext();
        c2.setOrigin(this);
        this.function.callUpdating(actualArgs, c2, pul);
    }

    private Sequence callFunction(XPathContext c) throws XPathException {
        UserFunction targetFunction;
        Component targetComponent = null;
        if (this.bindingSlot == -1) {
            targetFunction = this.function;
            targetComponent = this.function.getDeclaringComponent();
        } else {
            targetComponent = c.getTargetComponent(this.bindingSlot);
            targetFunction = (UserFunction)targetComponent.getProcedure();
        }
        Sequence[] actualArgs = this.evaluateArguments(c);
        if (this.isTailCall()) {
            ((XPathContextMajor)c).requestTailCall(this.function, actualArgs);
            return EmptySequence.getInstance();
        }
        XPathContextMajor c2 = c.newCleanContext();
        c2.setOrigin(this);
        c2.setTemporaryOutputState(155);
        c2.setCurrentOutputUri(null);
        c2.setCurrentComponent(targetComponent);
        try {
            return targetFunction.call(c2, actualArgs);
        }
        catch (StackOverflowError err) {
            throw new XPathException("Too many nested function calls. May be due to infinite recursion.", this);
        }
    }

    public void process(XPathContext context) throws XPathException {
        UserFunction targetFunction;
        if (this.bindingSlot == -1) {
            targetFunction = this.function;
        } else {
            Component target = context.getTargetComponent(this.bindingSlot);
            targetFunction = (UserFunction)target.getProcedure();
        }
        Sequence[] actualArgs = this.evaluateArguments(context);
        if (this.isTailCall()) {
            ((XPathContextMajor)context).requestTailCall(this.function, actualArgs);
        } else {
            SequenceReceiver out = context.getReceiver();
            XPathContextMajor c2 = context.newCleanContext();
            c2.setReceiver(out);
            c2.setTemporaryOutputState(155);
            c2.setCurrentOutputUri(null);
            c2.setOrigin(this);
            c2.setCurrentComponent(this.function.getDeclaringComponent());
            targetFunction.process(actualArgs, c2);
        }
    }

    public EventIterator iterateEvents(XPathContext context) throws XPathException {
        Sequence[] actualArgs = this.evaluateArguments(context);
        if (this.isTailCall()) {
            ((XPathContextMajor)context).requestTailCall(this.function, actualArgs);
            return EmptyEventIterator.getInstance();
        }
        SequenceReceiver out = context.getReceiver();
        XPathContextMajor c2 = context.newCleanContext();
        c2.setReceiver(out);
        c2.setOrigin(this);
        return this.function.iterateEvents(actualArgs, c2);
    }

    public Sequence[] evaluateArguments(XPathContext c) throws XPathException {
        int numArgs = this.argument.length;
        Sequence[] actualArgs = new Sequence[numArgs];
        if (this.argumentEvaluationModes == null) {
            this.computeArgumentEvaluationModes();
        }
        for (int i = 0; i < numArgs; ++i) {
            int refs = this.function.getParameterDefinitions()[i].getReferenceCount();
            actualArgs[i] = ExpressionTool.evaluate(this.argument[i], this.argumentEvaluationModes[i], c, refs);
            if (actualArgs[i] == null) {
                actualArgs[i] = EmptySequence.getInstance();
            }
            if (refs <= 1 || !(actualArgs[i] instanceof Closure)) continue;
            actualArgs[i] = ((Closure)actualArgs[i]).reduce();
        }
        return actualArgs;
    }

    public Sequence dynamicCall(Sequence[] suppliedArguments, XPathContext context) throws XPathException {
        Sequence[] convertedArgs = new Sequence[suppliedArguments.length];
        XPathContextMajor c2 = context.newCleanContext();
        c2.setOrigin(this);
        c2.setCaller(context);
        c2.openStackFrame(suppliedArguments.length);
        for (int i = 0; i < suppliedArguments.length; ++i) {
            c2.setLocalVariable(i, suppliedArguments[i]);
            convertedArgs[i] = ExpressionTool.lazyEvaluate(this.argument[i], c2, 10);
        }
        XPathContextMajor c3 = c2.newCleanContext();
        c3.setOrigin(this);
        return this.function.call(c3, convertedArgs);
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("functionCall");
        if (this.getFunctionName() != null) {
            out.emitAttribute("name", this.getDisplayName());
            out.emitAttribute("tailCall", this.tailCall == 0 ? "false" : (this.tailCall == 2 ? "self" : "foreign"));
        }
        for (Expression anArgument : this.argument) {
            anArgument.explain(out);
        }
        if (this.getFunctionName() == null) {
            out.startElement("body");
            this.function.getBody().explain(out);
            out.endElement();
        }
        out.endElement();
    }

    public int getConstructType() {
        return 2009;
    }

    public Object getProperty(String name) {
        if (name.equals("target")) {
            return this.function;
        }
        return super.getProperty(name);
    }

    public StructuredQName getObjectName() {
        return this.getFunctionName();
    }
}

