/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.ITemplateCall;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.Template;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DecimalValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplyImports
extends Instruction
implements ITemplateCall {
    WithParam[] actualParams = WithParam.EMPTY_ARRAY;
    WithParam[] tunnelParams = WithParam.EMPTY_ARRAY;
    boolean allowAnyItem = false;

    public void setActualParameters(WithParam[] actualParams, WithParam[] tunnelParams) {
        this.actualParams = actualParams;
        this.tunnelParams = tunnelParams;
    }

    @Override
    public int getInstructionNameCode() {
        return 132;
    }

    @Override
    public int getImplementationMethod() {
        return super.getImplementationMethod() | 8;
    }

    @Override
    public WithParam[] getActualParams() {
        return this.actualParams;
    }

    @Override
    public WithParam[] getTunnelParams() {
        return this.tunnelParams;
    }

    public boolean isAllowAnyItem() {
        return this.allowAnyItem;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        WithParam.simplify(this.actualParams, visitor);
        WithParam.simplify(this.tunnelParams, visitor);
        this.allowAnyItem = visitor.getStaticContext().getXPathLanguageLevel().equals(DecimalValue.THREE);
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        WithParam.typeCheck(this.actualParams, visitor, contextInfo);
        WithParam.typeCheck(this.tunnelParams, visitor, contextInfo);
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        WithParam.optimize(visitor, this.actualParams, contextItemType);
        WithParam.optimize(visitor, this.tunnelParams, contextItemType);
        return this;
    }

    @Override
    public int getIntrinsicDependencies() {
        return 2;
    }

    @Override
    public Expression copy() {
        ApplyImports ai2 = new ApplyImports();
        ai2.setActualParameters(WithParam.copy(this.actualParams), WithParam.copy(this.tunnelParams));
        ai2.allowAnyItem = this.allowAnyItem;
        return ai2;
    }

    @Override
    public final boolean createsNewNodes() {
        return true;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        WithParam.promoteParams(this, this.actualParams, offer);
        WithParam.promoteParams(this, this.tunnelParams, offer);
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> list = new ArrayList<Operand>(10);
        WithParam.gatherOperands(this.actualParams, list);
        WithParam.gatherOperands(this.tunnelParams, list);
        return list;
    }

    @Override
    public boolean replaceOperand(Expression original, Expression replacement) {
        boolean found = false;
        if (WithParam.replaceXPathExpression(this.actualParams, original, replacement)) {
            found = true;
        }
        if (WithParam.replaceXPathExpression(this.tunnelParams, original, replacement)) {
            found = true;
        }
        return found;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        if (pathMapNodeSet == null) {
            ContextItemExpression cie = new ContextItemExpression();
            cie.setContainer(this.getContainer());
            pathMapNodeSet = new PathMap.PathMapNodeSet(pathMap.makeNewRoot(cie));
        }
        pathMapNodeSet.addDescendants();
        return new PathMap.PathMapNodeSet(pathMap.makeNewRoot(this));
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        ParameterSet params = ApplyImports.assembleParams(context, this.actualParams);
        ParameterSet tunnels = ApplyImports.assembleTunnelParams(context, this.tunnelParams);
        Rule currentTemplateRule = context.getCurrentTemplateRule();
        if (currentTemplateRule == null) {
            XPathException e = new XPathException("There is no current template rule");
            e.setXPathContext(context);
            e.setErrorCode("XTDE0560");
            e.setLocator(this);
            throw e;
        }
        int min2 = currentTemplateRule.getMinImportPrecedence();
        int max = currentTemplateRule.getPrecedence() - 1;
        Mode mode = context.getCurrentMode();
        if (mode == null) {
            mode = controller.getRuleManager().getUnnamedMode();
        }
        if (context.getCurrentIterator() == null) {
            XPathException e = new XPathException("Cannot call xsl:apply-imports when there is no context item");
            e.setXPathContext(context);
            e.setErrorCode("XTDE0565");
            e.setLocator(this);
            throw e;
        }
        Item currentItem = context.getCurrentIterator().current();
        if (!this.allowAnyItem && !(currentItem instanceof NodeInfo)) {
            XPathException e = new XPathException("Cannot call xsl:apply-imports when context item is not a node");
            e.setXPathContext(context);
            e.setErrorCode("XTDE0565");
            e.setLocator(this);
            throw e;
        }
        Rule rule = controller.getRuleManager().getTemplateRule(currentItem, mode, min2, max, context);
        if (rule == null) {
            mode.getBuiltInRuleSet().process(currentItem, params, tunnels, context, this.getLocationId());
        } else {
            XPathContextMajor c2 = context.newContext();
            Template nh = (Template)rule.getAction();
            c2.setOrigin(this);
            c2.setLocalParameters(params);
            c2.setTunnelParameters(tunnels);
            c2.openStackFrame(nh.getStackFrameMap());
            c2.setCurrentTemplateRule(rule);
            c2.setCurrentComponent(nh.getDeclaringComponent());
            nh.apply(c2);
        }
        return null;
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("applyImports");
        if (this.actualParams.length > 0) {
            out.startSubsidiaryElement("withParams");
            WithParam.explainParameters(this.actualParams, out);
            out.endSubsidiaryElement();
        }
        if (this.tunnelParams.length > 0) {
            out.startSubsidiaryElement("tunnelParams");
            WithParam.explainParameters(this.tunnelParams, out);
            out.endSubsidiaryElement();
        }
        out.endElement();
    }
}

