/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.SimpleNodeConstructor;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public final class Comment
extends SimpleNodeConstructor {
    public int getInstructionNameCode() {
        return 142;
    }

    public ItemType getItemType() {
        return NodeKindTest.COMMENT;
    }

    public int getCardinality() {
        return 16384;
    }

    public Expression copy() {
        Comment exp = new Comment();
        exp.setSelect(this.select.copy(), this.getContainer().getConfiguration());
        return exp;
    }

    public void localTypeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        String s2;
        String s22;
        if (this.select instanceof Literal && !(s22 = this.checkContent(s2 = ((Literal)this.select).getValue().getStringValue(), visitor.getStaticContext().makeEarlyEvaluationContext())).equals(s2)) {
            this.setSelect(new StringLiteral(s22, this.getContainer()), visitor.getConfiguration());
        }
    }

    public void processValue(CharSequence value, XPathContext context) throws XPathException {
        String comment = this.checkContent(value.toString(), context);
        SequenceReceiver out = context.getReceiver();
        out.comment(comment, this.locationId, 0);
    }

    protected String checkContent(String comment, XPathContext context) throws XPathException {
        if (this.isXSLT()) {
            return Comment.checkContentXSLT(comment);
        }
        try {
            return Comment.checkContentXQuery(comment);
        }
        catch (XPathException err) {
            err.setXPathContext(context);
            err.setLocator(this);
            throw err;
        }
    }

    public static String checkContentXSLT(String comment) {
        int hh;
        while ((hh = comment.indexOf("--")) >= 0) {
            comment = comment.substring(0, hh + 1) + ' ' + comment.substring(hh + 1);
        }
        if (comment.length() > 0 && comment.charAt(comment.length() - 1) == '-') {
            comment = comment + ' ';
        }
        return comment;
    }

    public static String checkContentXQuery(String comment) throws XPathException {
        if (comment.contains("--")) {
            throw new XPathException("Invalid characters (--) in comment", "XQDY0072");
        }
        if (comment.length() > 0 && comment.charAt(comment.length() - 1) == '-') {
            throw new XPathException("Comment cannot end in '-'", "XQDY0072");
        }
        return comment;
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("comment");
        this.getContentExpression().explain(out);
        out.endElement();
    }
}

