/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.ContextMappingFunction;
import net.sf.saxon.expr.ContextMappingIterator;
import net.sf.saxon.expr.ContextSwitchingExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.AtomicSortComparer;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.GroupAdjacentIterator;
import net.sf.saxon.expr.sort.GroupByIterator;
import net.sf.saxon.expr.sort.GroupEndingIterator;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.expr.sort.GroupStartingIterator;
import net.sf.saxon.expr.sort.SortKeyDefinition;
import net.sf.saxon.expr.sort.SortKeyEvaluator;
import net.sf.saxon.expr.sort.SortedGroupIterator;
import net.sf.saxon.functions.CurrentGroup;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.PatternSponsor;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForEachGroup
extends Instruction
implements SortKeyEvaluator,
ContextMappingFunction,
ContextSwitchingExpression {
    public static final int GROUP_BY = 0;
    public static final int GROUP_ADJACENT = 1;
    public static final int GROUP_STARTING = 2;
    public static final int GROUP_ENDING = 3;
    private Expression select;
    private Expression action;
    private byte algorithm;
    private Expression key;
    private Expression collationNameExpression;
    private int keyItemType;
    private URI baseURI;
    private StringCollator collator = null;
    private SortKeyDefinition[] sortKeyDefinitions = null;
    private transient AtomicComparer[] sortComparators = null;
    private boolean composite = false;

    public ForEachGroup(Expression select, Expression action, byte algorithm, Expression key, StringCollator collator, Expression collationNameExpression, URI baseURI, SortKeyDefinition[] sortKeys) {
        this.select = select;
        this.action = action;
        this.algorithm = algorithm;
        this.key = key;
        this.collator = collator;
        this.collationNameExpression = collationNameExpression;
        this.baseURI = baseURI;
        this.sortKeyDefinitions = sortKeys;
        for (Operand o : this.operands()) {
            this.adoptChildExpression(o.getExpression());
        }
    }

    @Override
    public int getInstructionNameCode() {
        return 154;
    }

    @Override
    public Expression getSelectExpression() {
        return this.select;
    }

    @Override
    public Expression getActionExpression() {
        return this.action;
    }

    public byte getAlgorithm() {
        return this.algorithm;
    }

    public Expression getGroupingKey() {
        return this.key;
    }

    public int getKeyItemType() {
        return this.keyItemType;
    }

    public SortKeyDefinition[] getSortKeyDefinitions() {
        return this.sortKeyDefinitions;
    }

    public AtomicComparer[] getSortKeyComparators() {
        return this.sortComparators;
    }

    public StringCollator getCollation() {
        return this.collator;
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public boolean isComposite() {
        return this.composite;
    }

    public void setComposite(boolean composite) {
        this.composite = composite;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.select = visitor.typeCheck(this.select, contextInfo);
        ItemType selectedItemType = this.select.getItemType();
        ContextItemStaticInfo cit = new ContextItemStaticInfo(selectedItemType, false, this.select);
        this.action = visitor.typeCheck(this.action, cit);
        this.key = visitor.typeCheck(this.key, cit);
        if (this.collationNameExpression != null) {
            this.collationNameExpression = visitor.typeCheck(this.collationNameExpression, contextInfo);
        }
        if (Literal.isEmptySequence(this.select)) {
            return this.select;
        }
        if (Literal.isEmptySequence(this.action)) {
            return this.action;
        }
        if (this.sortKeyDefinitions != null) {
            boolean allFixed = true;
            for (SortKeyDefinition sk : this.sortKeyDefinitions) {
                Expression sortKey = sk.getSortKey();
                sortKey = visitor.typeCheck(sortKey, cit);
                if (visitor.getStaticContext().isInBackwardsCompatibleMode()) {
                    sortKey = FirstItemExpression.makeFirstItemExpression(sortKey);
                } else {
                    RoleLocator role = new RoleLocator(4, "xsl:sort/select", 0);
                    role.setErrorCode("XTTE1020");
                    sortKey = CardinalityChecker.makeCardinalityChecker(sortKey, 24576, role);
                }
                sk.setSortKey(sortKey, true);
                sk.typeCheck(visitor, contextInfo);
                if (sk.isFixed()) {
                    AtomicComparer comp = sk.makeComparator(visitor.getStaticContext().makeEarlyEvaluationContext());
                    sk.setFinalComparator(comp);
                    continue;
                }
                allFixed = false;
            }
            if (allFixed) {
                this.sortComparators = new AtomicComparer[this.sortKeyDefinitions.length];
                for (int i = 0; i < this.sortKeyDefinitions.length; ++i) {
                    this.sortComparators[i] = this.sortKeyDefinitions[i].getFinalComparator();
                }
            }
        }
        this.keyItemType = this.key.getItemType().getPrimitiveType();
        for (Operand o : this.operands()) {
            ForEachGroup.fixupGroupReferences(this, this, selectedItemType, false);
        }
        return this;
    }

    private static void fixupGroupReferences(Expression exp, ForEachGroup feg, ItemType selectedItemType, boolean isInLoop) {
        block2: {
            block4: {
                ForEachGroup feg2;
                block5: {
                    block3: {
                        if (exp == null) break block2;
                        if (!(exp instanceof CurrentGroup)) break block3;
                        ((CurrentGroup)exp).setControllingInstruction(feg, selectedItemType, isInLoop);
                        break block2;
                    }
                    if (!(exp instanceof ForEachGroup)) break block4;
                    feg2 = (ForEachGroup)exp;
                    if (feg2 != feg) break block5;
                    ForEachGroup.fixupGroupReferences(feg2.getActionExpression(), feg, selectedItemType, false);
                    break block2;
                }
                ForEachGroup.fixupGroupReferences(feg2.getSelectExpression(), feg, selectedItemType, isInLoop);
                if (feg2.getSortKeyDefinitions() == null) break block2;
                for (SortKeyDefinition skd : feg2.getSortKeyDefinitions()) {
                    ForEachGroup.fixupGroupReferences(skd.getOrder(), feg, selectedItemType, isInLoop);
                    ForEachGroup.fixupGroupReferences(skd.getCaseOrder(), feg, selectedItemType, isInLoop);
                    ForEachGroup.fixupGroupReferences(skd.getDataTypeExpression(), feg, selectedItemType, isInLoop);
                    ForEachGroup.fixupGroupReferences(skd.getLanguage(), feg, selectedItemType, isInLoop);
                    ForEachGroup.fixupGroupReferences(skd.getCollationNameExpression(), feg, selectedItemType, isInLoop);
                    ForEachGroup.fixupGroupReferences(skd.getOrder(), feg, selectedItemType, isInLoop);
                }
                break block2;
            }
            for (Operand o : exp.operands()) {
                ForEachGroup.fixupGroupReferences(o.getExpression(), feg, selectedItemType, isInLoop || o.isEvaluatedRepeatedly());
            }
        }
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        this.select = visitor.optimize(this.select, contextItemType);
        ItemType selectedItemType = this.select.getItemType();
        ContextItemStaticInfo sit = new ContextItemStaticInfo(selectedItemType, false, this.select);
        this.action = this.action.optimize(visitor, sit);
        this.key = this.key.optimize(visitor, sit);
        this.adoptChildExpression(this.select);
        this.adoptChildExpression(this.action);
        this.adoptChildExpression(this.key);
        if (Literal.isEmptySequence(this.select)) {
            return this.select;
        }
        if (Literal.isEmptySequence(this.action)) {
            return this.action;
        }
        if (this.sortKeyDefinitions != null) {
            for (SortKeyDefinition skd : this.sortKeyDefinitions) {
                Expression sortKey = skd.getSortKey();
                sortKey = visitor.optimize(sortKey, sit);
                skd.setSortKey(sortKey, true);
            }
        }
        if (this.collationNameExpression != null) {
            this.collationNameExpression = visitor.optimize(this.collationNameExpression, contextItemType);
        }
        if (this.collator == null && this.collationNameExpression instanceof StringLiteral) {
            String collation = ((StringLiteral)this.collationNameExpression).getStringValue();
            try {
                URI collationURI = new URI(collation);
                if (!collationURI.isAbsolute()) {
                    collationURI = this.baseURI.resolve(collationURI);
                    String collationNameString = collationURI.toString();
                    this.collationNameExpression = new StringLiteral(collationNameString, this.getContainer());
                    this.collator = visitor.getConfiguration().getCollation(collationNameString);
                    if (this.collator == null) {
                        XPathException err = new XPathException("Unknown collation " + Err.wrap(collationURI.toString(), 7));
                        err.setErrorCode("XTDE1110");
                        err.setLocator(this);
                        throw err;
                    }
                }
            }
            catch (URISyntaxException err) {
                XPathException e = new XPathException("Collation name '" + this.collationNameExpression + "' is not a valid URI");
                e.setErrorCode("XTDE1110");
                e.setLocator(this);
                throw e;
            }
        }
        return this;
    }

    @Override
    public Expression copy() {
        SortKeyDefinition[] newKeyDef = null;
        if (this.sortKeyDefinitions != null) {
            newKeyDef = new SortKeyDefinition[this.sortKeyDefinitions.length];
            for (int i = 0; i < this.sortKeyDefinitions.length; ++i) {
                newKeyDef[i] = this.sortKeyDefinitions[i].copy();
            }
        }
        ForEachGroup feg = new ForEachGroup(this.select.copy(), this.action.copy(), this.algorithm, this.key.copy(), this.collator, this.collationNameExpression.copy(), this.baseURI, newKeyDef);
        feg.setComposite(this.isComposite());
        return feg;
    }

    @Override
    public ItemType getItemType() {
        return this.action.getItemType();
    }

    @Override
    public int computeDependencies() {
        int dependencies = 0;
        dependencies |= this.select.getDependencies();
        dependencies |= this.key.getDependencies() & 0xFFFFFFE1;
        dependencies |= this.action.getDependencies() & 0xFFFFFFC1;
        if (this.sortKeyDefinitions != null) {
            for (SortKeyDefinition skd : this.sortKeyDefinitions) {
                dependencies |= skd.getSortKey().getDependencies() & 0xFFFFFFE1;
                Expression e = skd.getCaseOrder();
                if (e != null && !(e instanceof Literal)) {
                    dependencies |= e.getDependencies();
                }
                if ((e = skd.getDataTypeExpression()) != null && !(e instanceof Literal)) {
                    dependencies |= e.getDependencies();
                }
                if ((e = skd.getLanguage()) == null || e instanceof Literal) continue;
                dependencies |= e.getDependencies();
            }
        }
        if (this.collationNameExpression != null) {
            dependencies |= this.collationNameExpression.getDependencies();
        }
        return dependencies;
    }

    @Override
    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p |= this.action.getSpecialProperties() & 0x4000000;
    }

    @Override
    public final boolean createsNewNodes() {
        int props = this.action.getSpecialProperties();
        return (props & 0x400000) == 0;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        this.select = this.doPromotion(this.select, offer);
        if (offer.action == 14) {
            this.action = this.doPromotion(this.action, offer);
            this.key = this.doPromotion(this.key, offer);
        }
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> list = new ArrayList<Operand>(8);
        list.add(new Operand(this.select, OperandRole.FOCUS_CONTROLLING_SELECT));
        list.add(new Operand(this.action, OperandRole.FOCUS_CONTROLLED_ACTION));
        list.add(new Operand(this.key, OperandRole.NEW_FOCUS_ATOMIC));
        if (this.collationNameExpression != null && !(this.collationNameExpression instanceof Literal)) {
            list.add(new Operand(this.collationNameExpression, OperandRole.SINGLE_ATOMIC));
        }
        if (this.sortKeyDefinitions != null) {
            for (SortKeyDefinition skd : this.sortKeyDefinitions) {
                list.add(new Operand(skd.getSortKey(), OperandRole.NEW_FOCUS_ATOMIC));
                Expression e = skd.getOrder();
                if (e != null && !(e instanceof Literal)) {
                    list.add(new Operand(e, OperandRole.SINGLE_ATOMIC));
                }
                if ((e = skd.getCaseOrder()) != null && !(e instanceof Literal)) {
                    list.add(new Operand(e, OperandRole.SINGLE_ATOMIC));
                }
                if ((e = skd.getDataTypeExpression()) != null && !(e instanceof Literal)) {
                    list.add(new Operand(e, OperandRole.SINGLE_ATOMIC));
                }
                if ((e = skd.getLanguage()) != null && !(e instanceof Literal)) {
                    list.add(new Operand(e, OperandRole.SINGLE_ATOMIC));
                }
                if ((e = skd.getCollationNameExpression()) == null || e instanceof Literal) continue;
                list.add(new Operand(e, OperandRole.SINGLE_ATOMIC));
            }
        }
        return list;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet target = this.select.addToPathMap(pathMap, pathMapNodeSet);
        if (this.collationNameExpression != null) {
            this.collationNameExpression.addToPathMap(pathMap, pathMapNodeSet);
        }
        if (this.sortKeyDefinitions != null) {
            for (SortKeyDefinition skd : this.sortKeyDefinitions) {
                skd.getSortKey().addToPathMap(pathMap, target);
                Expression e = skd.getOrder();
                if (e != null) {
                    e.addToPathMap(pathMap, pathMapNodeSet);
                }
                if ((e = skd.getCaseOrder()) != null) {
                    e.addToPathMap(pathMap, pathMapNodeSet);
                }
                if ((e = skd.getDataTypeExpression()) != null) {
                    e.addToPathMap(pathMap, pathMapNodeSet);
                }
                if ((e = skd.getLanguage()) != null) {
                    e.addToPathMap(pathMap, pathMapNodeSet);
                }
                if ((e = skd.getCollationNameExpression()) == null) continue;
                e.addToPathMap(pathMap, pathMapNodeSet);
            }
        }
        return this.action.addToPathMap(pathMap, target);
    }

    @Override
    public boolean replaceOperand(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        if (this.action == original) {
            this.action = replacement;
            found = true;
        }
        if (this.collationNameExpression == original) {
            this.collationNameExpression = replacement;
            found = true;
        }
        if (this.key == original) {
            this.key = replacement;
            found = true;
        }
        if (this.sortKeyDefinitions != null) {
            for (SortKeyDefinition skd : this.sortKeyDefinitions) {
                if (skd.getSortKey() == original) {
                    skd.setSortKey(replacement, true);
                    found = true;
                }
                if (skd.getOrder() == original) {
                    skd.setOrder(replacement);
                    found = true;
                }
                if (skd.getCaseOrder() == original) {
                    skd.setCaseOrder(replacement);
                    found = true;
                }
                if (skd.getDataTypeExpression() == original) {
                    skd.setDataTypeExpression(replacement);
                    found = true;
                }
                if (skd.getLanguage() != original) continue;
                skd.setLanguage(replacement);
                found = true;
            }
        }
        return found;
    }

    @Override
    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        this.action.checkPermittedContents(parentType, env, false);
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        GroupIterator groupIterator = this.getGroupIterator(context);
        FocusTrackingIterator focusIterator = new FocusTrackingIterator(groupIterator);
        XPathContextMajor c2 = context.newContext();
        c2.setOrigin(this);
        c2.setCurrentIterator(focusIterator);
        c2.setCurrentGroupIterator(groupIterator);
        c2.setCurrentTemplateRule(null);
        if (controller.isTracing()) {
            Item item;
            TraceListener listener = controller.getTraceListener();
            assert (listener != null);
            while ((item = focusIterator.next()) != null) {
                listener.startCurrentItem(item);
                this.action.process(c2);
                listener.endCurrentItem(item);
            }
        } else {
            while (focusIterator.next() != null) {
                this.action.process(c2);
            }
        }
        return null;
    }

    public Expression getCollationNameExpression() {
        return this.collationNameExpression;
    }

    private StringCollator getCollator(XPathContext context) throws XPathException {
        if (this.collationNameExpression != null) {
            StringValue collationValue = (StringValue)this.collationNameExpression.evaluateItem(context);
            assert (collationValue != null);
            String cname = collationValue.getStringValue();
            try {
                return context.getConfiguration().getCollation(cname, this.baseURI.toString(), "FOCH0002");
            }
            catch (XPathException e) {
                e.setLocator(this);
                throw e;
            }
        }
        return CodepointCollator.getInstance();
    }

    public AtomicComparer getAtomicComparer(XPathContext context) throws XPathException {
        StringCollator coll = this.collator;
        if (coll == null) {
            coll = this.getCollator(context);
        }
        return AtomicSortComparer.makeSortComparer(coll, this.keyItemType, context);
    }

    private GroupIterator getGroupIterator(XPathContext context) throws XPathException {
        GroupIterator groupIterator;
        FocusTrackingIterator population = new FocusTrackingIterator(this.select.iterate(context));
        switch (this.algorithm) {
            case 0: {
                StringCollator coll = this.collator;
                if (coll == null) {
                    coll = this.getCollator(context);
                }
                XPathContextMinor c2 = context.newMinorContext();
                c2.setCurrentIterator(population);
                groupIterator = new GroupByIterator(population, this.key, c2, coll, this.composite);
                break;
            }
            case 1: {
                StringCollator coll = this.collator;
                if (coll == null) {
                    coll = this.getCollator(context);
                }
                groupIterator = new GroupAdjacentIterator(population, this.key, context, coll, this.composite);
                break;
            }
            case 2: {
                groupIterator = new GroupStartingIterator(population, ((PatternSponsor)this.key).getPattern(), context);
                break;
            }
            case 3: {
                groupIterator = new GroupEndingIterator(population, ((PatternSponsor)this.key).getPattern(), context);
                break;
            }
            default: {
                throw new AssertionError((Object)"Unknown grouping algorithm");
            }
        }
        if (this.sortKeyDefinitions != null) {
            AtomicComparer[] comps = this.sortComparators;
            XPathContextMinor xpc = context.newMinorContext();
            if (comps == null) {
                comps = new AtomicComparer[this.sortKeyDefinitions.length];
                for (int s2 = 0; s2 < this.sortKeyDefinitions.length; ++s2) {
                    comps[s2] = this.sortKeyDefinitions[s2].makeComparator(xpc);
                }
            }
            groupIterator = new SortedGroupIterator(xpc, groupIterator, this, comps);
        }
        return groupIterator;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        GroupIterator master = this.getGroupIterator(context);
        FocusTrackingIterator focus = new FocusTrackingIterator(master);
        XPathContextMajor c2 = context.newContext();
        c2.setOrigin(this);
        c2.setCurrentIterator(focus);
        c2.setCurrentGroupIterator(master);
        c2.setCurrentTemplateRule(null);
        return new ContextMappingIterator(this, c2);
    }

    @Override
    public SequenceIterator map(XPathContext context) throws XPathException {
        return this.action.iterate(context);
    }

    @Override
    public AtomicValue evaluateSortKey(int n, XPathContext c) throws XPathException {
        return (AtomicValue)this.sortKeyDefinitions[n].getSortKey().evaluateItem(c);
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("forEachGroup");
        out.emitAttribute("algorithm", ForEachGroup.getAlgorithmName(this.algorithm));
        out.startSubsidiaryElement("select");
        this.select.explain(out);
        out.endSubsidiaryElement();
        out.startSubsidiaryElement("key");
        this.key.explain(out);
        out.endSubsidiaryElement();
        out.startSubsidiaryElement("return");
        this.action.explain(out);
        out.endSubsidiaryElement();
        out.endElement();
    }

    private static String getAlgorithmName(byte algorithm) {
        switch (algorithm) {
            case 0: {
                return "group-by";
            }
            case 1: {
                return "group-adjacent";
            }
            case 2: {
                return "group-starting-with";
            }
            case 3: {
                return "group-ending-with";
            }
        }
        return "** unknown algorithm **";
    }
}

