/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.sort.DocumentOrderIterator;
import net.sf.saxon.expr.sort.GlobalOrderComparer;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.RelativeURIResolver;
import net.sf.saxon.lib.StandardErrorHandler;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.One;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.NonDelegatingURIResolver;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.Statistics;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;

public class DocumentFn
extends SystemFunctionCall
implements Callable {
    private String expressionBaseURI = null;

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        if (this.expressionBaseURI == null) {
            super.checkArguments(visitor);
            this.expressionBaseURI = visitor.getStaticContext().getBaseURI();
            this.argument[0] = this.argument[0].unordered(false, false);
        }
    }

    public int computeCardinality() {
        Expression expression = this.argument[0];
        if (Cardinality.allowsMany(expression.getCardinality())) {
            return 57344;
        }
        return 24576;
    }

    public String getStaticBaseURI() {
        return this.expressionBaseURI;
    }

    public void setStaticBaseURI(String baseURI) {
        this.expressionBaseURI = baseURI;
    }

    public int computeSpecialProperties() {
        return 0x4A0000;
    }

    public Expression preEvaluate(ExpressionVisitor visitor) {
        Configuration config = visitor.getConfiguration();
        if (this.getNumberOfArguments() == 1 && ((Boolean)config.getConfigurationProperty("http://saxon.sf.net/feature/preEvaluateDocFunction")).booleanValue()) {
            try {
                AtomicValue hrefVal = (AtomicValue)this.argument[0].evaluateItem(null);
                if (hrefVal == null) {
                    return null;
                }
                String href = hrefVal.getStringValue();
                if (href.indexOf(35) >= 0) {
                    return this;
                }
                NodeInfo item = DocumentFn.preLoadDoc(href, this.expressionBaseURI, config, this);
                if (item != null) {
                    return Literal.makeLiteral(new One<NodeInfo>(item), this.getContainer());
                }
            }
            catch (Exception err) {
                return this;
            }
        }
        return this;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        return this.addDocToPathMap(pathMap, pathMapNodeSet);
    }

    public Expression copy() {
        DocumentFn d = (DocumentFn)super.copy();
        d.expressionBaseURI = this.expressionBaseURI;
        return d;
    }

    public boolean equals(Object o) {
        return o instanceof DocumentFn && super.equals(o) && DocumentFn.equalOrNull(this.expressionBaseURI, ((DocumentFn)o).expressionBaseURI);
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        NodeInfo base;
        int numArgs = this.argument.length;
        SequenceIterator hrefSequence = this.argument[0].iterate(context);
        String baseURI = null;
        if (numArgs == 2 && (baseURI = (base = (NodeInfo)this.argument[1].evaluateItem(context)).getBaseURI()) == null) {
            throw new XPathException("The second argument to document() is a node with no base URI", "XTDE1162");
        }
        DocumentMappingFunction map = new DocumentMappingFunction(context);
        map.baseURI = baseURI;
        map.stylesheetURI = this.expressionBaseURI;
        map.locator = this;
        ItemMappingIterator iter = new ItemMappingIterator(hrefSequence, map);
        Expression expression = this.argument[0];
        if (Cardinality.allowsMany(expression.getCardinality())) {
            return new DocumentOrderIterator(iter, GlobalOrderComparer.getInstance());
        }
        return iter;
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        NodeInfo base;
        int numArgs = this.argument.length;
        SequenceIterator hrefSequence = arguments[0].iterate();
        String baseURI = null;
        if (numArgs == 2 && (baseURI = (base = (NodeInfo)arguments[1].head()).getBaseURI()) == null) {
            throw new XPathException("The second argument to document() is a node with no base URI", "XTDE1162");
        }
        DocumentMappingFunction map = new DocumentMappingFunction(context);
        map.baseURI = baseURI;
        map.stylesheetURI = this.expressionBaseURI;
        map.locator = this;
        ItemMappingIterator iter = new ItemMappingIterator(hrefSequence, map);
        Expression expression = this.argument[0];
        if (Cardinality.allowsMany(expression.getCardinality())) {
            return SequenceTool.toLazySequence(new DocumentOrderIterator(iter, GlobalOrderComparer.getInstance()));
        }
        return SequenceTool.toLazySequence(iter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeInfo makeDoc(String href, String baseURI, XPathContext c, SourceLocator locator, boolean silent) throws XPathException {
        Controller controller;
        Configuration config = c.getConfiguration();
        int hash = href.indexOf(35);
        String fragmentId = null;
        if (hash >= 0) {
            if (hash == href.length() - 1) {
                href = href.substring(0, hash);
            } else {
                fragmentId = href.substring(hash + 1);
                href = href.substring(0, hash);
                if (!NameChecker.isValidNCName(fragmentId)) {
                    XPathException de = new XPathException("The fragment identifier " + Err.wrap(fragmentId) + " is not a valid NCName");
                    de.setErrorCode("XTRE1160");
                    de.setXPathContext(c);
                    de.setLocator(locator);
                    throw de;
                }
            }
        }
        if ((controller = c.getController()) == null) {
            throw new XPathException("doc() function is not available in this environment");
        }
        DocumentURI documentKey = DocumentFn.computeDocumentKey(href, baseURI, c);
        DocumentInfo doc = config.getGlobalDocumentPool().find(documentKey);
        if (doc != null) {
            return doc;
        }
        DocumentPool pool = controller.getDocumentPool();
        Controller controller2 = controller;
        synchronized (controller2) {
            doc = pool.find(documentKey);
            if (doc != null) {
                return DocumentFn.getFragment(doc, fragmentId, c, locator);
            }
            if (!controller.checkUniqueOutputDestination(documentKey)) {
                pool.markUnavailable(documentKey);
                XPathException err = new XPathException("Cannot read a document that was written during the same transformation: " + documentKey);
                err.setXPathContext(c);
                err.setErrorCode("XTRE1500");
                err.setLocator(locator);
                throw err;
            }
            if (pool.isMarkedUnavailable(documentKey)) {
                XPathException err = new XPathException("Document has been marked not available: " + documentKey);
                err.setXPathContext(c);
                err.setErrorCode("FODC0002");
                err.setLocator(locator);
                throw err;
            }
        }
        try {
            Object b;
            DocumentInfo newdoc;
            Source source = DocumentFn.resolveURI(href, baseURI, documentKey.toString(), c);
            source = config.getSourceResolver().resolveSource(source, config);
            if (source instanceof NodeInfo || source instanceof DOMSource) {
                NodeInfo startNode = controller.prepareInputTree(source);
                newdoc = startNode.getDocumentRoot();
            } else {
                PathMap.PathMapRoot pathRoot;
                b = controller.makeBuilder();
                if (b instanceof TinyBuilder) {
                    ((TinyBuilder)b).setStatistics(Statistics.SOURCE_DOCUMENT_STATISTICS);
                }
                Receiver s2 = b;
                ParseOptions options = new ParseOptions(((Builder)b).getPipelineConfiguration().getParseOptions());
                if (silent) {
                    StandardErrorHandler eh = new StandardErrorHandler(controller.getErrorListener());
                    eh.setSilent(true);
                    options.setErrorHandler(eh);
                }
                options.setStripSpace(4);
                if (controller.getExecutable().stripsInputTypeAnnotations()) {
                    s2 = controller.getConfiguration().getAnnotationStripper(s2);
                }
                options.setSchemaValidationMode(controller.getSchemaValidationMode());
                PathMap map = controller.getPathMapForDocumentProjection();
                if (map != null && (pathRoot = map.getRootForDocument(documentKey.toString())) != null && !pathRoot.isReturnable() && !pathRoot.hasUnknownDependencies()) {
                    options.addFilter(config.makeDocumentProjector(pathRoot));
                }
                s2.setPipelineConfiguration(((Builder)b).getPipelineConfiguration());
                try {
                    Sender.send(source, s2, options);
                    newdoc = (DocumentInfo)((Builder)b).getCurrentRoot();
                    ((Builder)b).reset();
                }
                finally {
                    if (options.isPleaseCloseAfterUse()) {
                        ParseOptions.close(source);
                    }
                }
            }
            b = controller;
            synchronized (b) {
                doc = pool.find(documentKey);
                if (doc != null) {
                    return DocumentFn.getFragment(doc, fragmentId, c, locator);
                }
                controller.registerDocument(newdoc, documentKey);
                controller.addUnavailableOutputDestination(documentKey);
            }
            return DocumentFn.getFragment(newdoc, fragmentId, c, locator);
        }
        catch (TransformerException err) {
            pool.markUnavailable(documentKey);
            XPathException xerr = XPathException.makeXPathException(err);
            xerr.maybeSetLocation(locator);
            String code = err.getException() instanceof URISyntaxException ? "FODC0005" : "FODC0002";
            xerr.maybeSetErrorCode(code);
            throw xerr;
        }
    }

    public static Source resolveURI(String href, String baseURI, String documentKey, XPathContext context) throws XPathException {
        Source source;
        URIResolver resolver = context.getURIResolver();
        if (baseURI == null) {
            try {
                URI uri = new URI(href);
                if (!uri.isAbsolute()) {
                    throw new XPathException("Relative URI passed to document() function (" + href + "); but no base URI is available", "XTDE1162");
                }
            }
            catch (URISyntaxException e) {
                throw new XPathException("Invalid URI passed to document() function: " + href, "FODC0005");
            }
        }
        try {
            source = resolver instanceof RelativeURIResolver && documentKey != null ? ((RelativeURIResolver)resolver).dereference(documentKey) : resolver.resolve(href, baseURI);
        }
        catch (Exception ex) {
            XPathException de = new XPathException("Exception thrown by URIResolver", ex);
            if (context.getConfiguration().getBooleanProperty("http://saxon.sf.net/feature/trace-external-functions")) {
                ex.printStackTrace();
            }
            throw de;
        }
        if (source == null && !(resolver instanceof NonDelegatingURIResolver)) {
            resolver = context.getController().getStandardURIResolver();
            try {
                source = resolver instanceof RelativeURIResolver && documentKey != null ? ((RelativeURIResolver)resolver).dereference(documentKey) : resolver.resolve(href, baseURI);
            }
            catch (TransformerException ex) {
                throw XPathException.makeXPathException(ex);
            }
        }
        return source;
    }

    protected static DocumentURI computeDocumentKey(String href, String baseURI, XPathContext c) throws XPathException {
        Controller controller = c.getController();
        URIResolver resolver = controller.getURIResolver();
        if (resolver == null) {
            resolver = controller.getStandardURIResolver();
        }
        return DocumentFn.computeDocumentKey(href, baseURI, resolver);
    }

    public static DocumentURI computeDocumentKey(String href, String baseURI, URIResolver resolver) throws XPathException {
        String documentKey;
        if (resolver instanceof RelativeURIResolver) {
            try {
                documentKey = ((RelativeURIResolver)resolver).makeAbsolute(href, baseURI);
            }
            catch (TransformerException e) {
                documentKey = '/' + href;
            }
        } else if (baseURI == null) {
            try {
                documentKey = new URI(href).toString();
            }
            catch (URISyntaxException err) {
                documentKey = '/' + href;
            }
        } else if (href.length() == 0) {
            documentKey = baseURI;
        } else {
            try {
                URI uri = new URI(baseURI).resolve(href);
                documentKey = uri.toString();
            }
            catch (URISyntaxException err) {
                documentKey = baseURI + "/../" + href;
            }
            catch (IllegalArgumentException err) {
                documentKey = baseURI + "/../" + href;
            }
        }
        return new DocumentURI(documentKey);
    }

    public static NodeInfo preLoadDoc(String href, String baseURI, Configuration config, SourceLocator locator) throws XPathException {
        String documentKey;
        int hash = href.indexOf(35);
        if (hash >= 0) {
            throw new XPathException("Fragment identifier not supported for preloaded documents");
        }
        URIResolver resolver = config.getURIResolver();
        if (resolver instanceof RelativeURIResolver) {
            try {
                documentKey = ((RelativeURIResolver)resolver).makeAbsolute(href, baseURI);
            }
            catch (TransformerException e) {
                documentKey = '/' + href;
                baseURI = "";
            }
        } else if (baseURI == null) {
            try {
                documentKey = new URI(href).toString();
            }
            catch (URISyntaxException err) {
                documentKey = '/' + href;
                baseURI = "";
            }
        } else if (href.length() == 0) {
            documentKey = baseURI;
        } else {
            try {
                URI uri = new URI(baseURI).resolve(href);
                documentKey = uri.toString();
            }
            catch (URISyntaxException err) {
                documentKey = baseURI + "/../" + href;
            }
            catch (IllegalArgumentException err) {
                documentKey = baseURI + "/../" + href;
            }
        }
        DocumentInfo doc = config.getGlobalDocumentPool().find(documentKey);
        if (doc != null) {
            return doc;
        }
        try {
            URIResolver r = resolver;
            Source source = null;
            if (r != null) {
                try {
                    source = r.resolve(href, baseURI);
                }
                catch (Exception ex) {
                    XPathException de = new XPathException("Exception thrown by URIResolver", ex);
                    if (config.getBooleanProperty("http://saxon.sf.net/feature/trace-external-functions")) {
                        ex.printStackTrace();
                    }
                    de.setLocator(locator);
                    throw de;
                }
            }
            if (source == null && !(r instanceof NonDelegatingURIResolver)) {
                r = config.getSystemURIResolver();
                source = r.resolve(href, baseURI);
            }
            source = config.getSourceResolver().resolveSource(source, config);
            DocumentInfo newdoc = config.buildDocument(source);
            config.getGlobalDocumentPool().add(newdoc, documentKey);
            return newdoc;
        }
        catch (TransformerException err) {
            XPathException xerr = XPathException.makeXPathException(err);
            xerr.setLocator(locator);
            xerr.setErrorCode("FODC0002");
            throw new XPathException(err);
        }
    }

    public void sendDocuments(XPathContext context, Receiver out) throws XPathException {
        Item href;
        SequenceIterator hrefSequence = this.argument[0].iterate(context);
        String explicitBaseURI = null;
        if (this.argument.length == 2) {
            NodeInfo base = (NodeInfo)this.argument[1].evaluateItem(context);
            explicitBaseURI = base.getBaseURI();
        }
        ParseOptions options = new ParseOptions();
        while ((href = hrefSequence.next()) != null) {
            String base = explicitBaseURI == null ? (href instanceof NodeInfo ? ((NodeInfo)href).getBaseURI() : this.expressionBaseURI) : explicitBaseURI;
            DocumentFn.sendDoc(href.getStringValue(), base, context, this, out, options);
        }
    }

    public static void sendDoc(String href, String baseURL, XPathContext c, SourceLocator locator, Receiver out, ParseOptions parseOptions) throws XPathException {
        String documentKey;
        PipelineConfiguration pipe = out.getPipelineConfiguration();
        if (pipe == null) {
            pipe = c.getController().makePipelineConfiguration();
            out.setPipelineConfiguration(pipe);
        }
        if (baseURL == null) {
            try {
                documentKey = new URI(href).toString();
            }
            catch (URISyntaxException err) {
                documentKey = '/' + href;
                baseURL = "";
            }
        } else if (href.length() == 0) {
            documentKey = baseURL;
        } else {
            try {
                URI url = new URI(baseURL).resolve(href);
                documentKey = url.toString();
            }
            catch (URISyntaxException err) {
                documentKey = baseURL + "/../" + href;
            }
            catch (IllegalArgumentException err) {
                documentKey = baseURL + "/../" + href;
            }
        }
        Controller controller = c.getController();
        DocumentInfo doc = controller.getDocumentPool().find(documentKey);
        Source source = null;
        if (doc != null) {
            source = doc;
        } else {
            try {
                URIResolver r = controller.getURIResolver();
                if (r != null) {
                    source = r.resolve(href, baseURL);
                }
                if (source == null) {
                    r = controller.getStandardURIResolver();
                    source = r.resolve(href, baseURL);
                }
                if (source instanceof NodeInfo || source instanceof DOMSource) {
                    NodeInfo startNode = controller.prepareInputTree(source);
                    source = startNode.getDocumentRoot();
                }
            }
            catch (TransformerException err) {
                XPathException xerr = XPathException.makeXPathException(err);
                xerr.setLocator(locator);
                xerr.maybeSetErrorCode("FODC0005");
                throw xerr;
            }
        }
        ParseOptions options = new ParseOptions(parseOptions);
        options.setStripSpace(4);
        if (controller.getExecutable().stripsInputTypeAnnotations()) {
            out = controller.getConfiguration().getAnnotationStripper(out);
        }
        out.setPipelineConfiguration(pipe);
        try {
            Sender.send(source, out, options);
        }
        catch (XPathException e) {
            e.maybeSetLocation(locator);
            e.maybeSetErrorCode("FODC0002");
            throw e;
        }
    }

    private static NodeInfo getFragment(DocumentInfo doc, String fragmentId, XPathContext context, SourceLocator locator) throws XPathException {
        if (fragmentId == null) {
            return doc;
        }
        if (!NameChecker.isValidNCName(fragmentId)) {
            XPathException err = new XPathException("Invalid fragment identifier in URI");
            err.setXPathContext(context);
            err.setErrorCode("XTRE1160");
            err.setLocator(locator);
            try {
                context.getController().recoverableError(err);
            }
            catch (XPathException dynamicError) {
                throw err;
            }
            return doc;
        }
        return doc.selectID(fragmentId, false);
    }

    private static class DocumentMappingFunction
    implements ItemMappingFunction {
        public String baseURI;
        public String stylesheetURI;
        public SourceLocator locator;
        public XPathContext context;

        public DocumentMappingFunction(XPathContext context) {
            this.context = context;
        }

        public Item mapItem(Item item) throws XPathException {
            String b = this.baseURI;
            if (b == null) {
                b = item instanceof NodeInfo ? ((NodeInfo)item).getBaseURI() : this.stylesheetURI;
            }
            try {
                return DocumentFn.makeDoc(item.getStringValue(), b, this.context, this.locator, false);
            }
            catch (XPathException xerr) {
                if (this.context.getController().getExecutable().isAllowXPath30()) {
                    if (xerr.getErrorCodeLocalPart().equals("XTRE1160")) {
                        xerr.setErrorCode("XTDE1160");
                    }
                    throw xerr;
                }
                if (!xerr.hasBeenReported()) {
                    xerr.maybeSetLocation(this.locator);
                    String code = xerr.getException() instanceof URISyntaxException ? "FODC0005" : "FODC0002";
                    xerr.maybeSetErrorCode(code);
                    try {
                        this.context.getController().recoverableError(xerr);
                    }
                    catch (XPathException err2) {
                        throw xerr;
                    }
                } else {
                    throw xerr;
                }
                return null;
            }
        }
    }
}

