/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.sort.DocumentOrderIterator;
import net.sf.saxon.expr.sort.LocalOrderComparer;
import net.sf.saxon.functions.StandardFunction;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.trans.KeyDefinitionSet;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DecimalValue;

public class KeyFn
extends SystemFunctionCall {
    private NamespaceResolver nsContext = null;
    private KeyDefinitionSet staticKeySet = null;
    private KeyManager keyManager = null;
    private transient boolean checked = false;
    private transient boolean internal = false;
    private boolean is30 = false;
    private static final StructuredQName FN_KEY = new StructuredQName("fn", "http://www.w3.org/2005/xpath-functions", "key");

    public StructuredQName getStaticKeyName() {
        return this.staticKeySet == null ? null : this.staticKeySet.getKeyName();
    }

    public KeyDefinitionSet getStaticKeySet() {
        return this.staticKeySet;
    }

    public KeyManager getKeyManager() {
        return this.keyManager;
    }

    public boolean getInternal() {
        return this.internal;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.nsContext;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        try {
            return super.typeCheck(visitor, contextInfo);
        }
        catch (XPathException err) {
            if ("XPDY0002".equals(err.getErrorCodeLocalPart()) && this.argument[2] instanceof RootExpression) {
                XPathException e = new XPathException("Cannot call the key() function when there is no context node");
                e.setErrorCode("XTDE1270");
                e.maybeSetLocation(this);
                throw e;
            }
            throw err;
        }
    }

    public static KeyFn internalKeyCall(KeyManager keyManager, KeyDefinitionSet keySet, String name, Expression value, Expression doc) {
        KeyFn k = new KeyFn();
        k.argument = new Expression[]{new StringLiteral(name, value.getContainer()), value, doc};
        k.keyManager = keyManager;
        k.staticKeySet = keySet;
        k.checked = true;
        k.internal = true;
        k.is30 = true;
        k.setDetails(StandardFunction.getFunction("key", 3));
        k.setFunctionName(FN_KEY);
        k.adoptChildExpression(value);
        k.adoptChildExpression(doc);
        return k;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        if (!this.internal && !(visitor.getStaticContext() instanceof ExpressionContext)) {
            throw new XPathException("The key() function is available only in XPath expressions within an XSLT stylesheet");
        }
        KeyFn f = (KeyFn)super.simplify(visitor);
        if (this.argument.length == 2) {
            f.addContextDocumentArgument(2, "key");
        }
        return f;
    }

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        if (this.checked) {
            return;
        }
        this.checked = true;
        super.checkArguments(visitor);
        this.argument[1] = this.argument[1].unordered(false, false);
        this.keyManager = visitor.getStaticContext().getKeyManager();
        if (this.argument[0] instanceof StringLiteral) {
            StructuredQName keyName;
            try {
                keyName = StructuredQName.fromLexicalQName(((StringLiteral)this.argument[0]).getStringValue(), false, true, visitor.getStaticContext().getNamespaceResolver());
            }
            catch (XPathException e) {
                XPathException err = new XPathException("Error in key name " + ((StringLiteral)this.argument[0]).getStringValue() + ": " + e.getMessage());
                err.setLocator(this);
                err.setErrorCode("XTDE1260");
                throw err;
            }
            this.staticKeySet = this.keyManager.getKeyDefinitionSet(keyName);
            if (this.staticKeySet == null) {
                XPathException err = new XPathException("Key " + ((StringLiteral)this.argument[0]).getStringValue() + " has not been defined");
                err.setLocator(this);
                err.setErrorCode("XTDE1260");
                throw err;
            }
            this.is30 = visitor.getStaticContext().getXPathLanguageLevel().equals(DecimalValue.THREE);
        } else {
            this.nsContext = visitor.getStaticContext().getNamespaceResolver();
        }
    }

    public int computeSpecialProperties() {
        int prop = 0xC20000;
        if (this.getNumberOfArguments() == 2 || (this.argument[2].getSpecialProperties() & 0x10000) != 0) {
            prop |= 0x10000;
        }
        return prop;
    }

    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        this.argument[0].addToPathMap(pathMap, pathMapNodeSet);
        this.argument[1].addToPathMap(pathMap, pathMapNodeSet);
        PathMap.PathMapNodeSet target = this.argument[2].addToPathMap(pathMap, pathMapNodeSet);
        target = target.createArc((byte)1, NodeKindTest.DOCUMENT);
        return target.createArc((byte)4, AnyNodeTest.getInstance());
    }

    public Expression copy() {
        KeyFn k = (KeyFn)super.copy();
        k.nsContext = this.nsContext;
        k.staticKeySet = this.staticKeySet;
        k.keyManager = this.keyManager;
        k.internal = this.internal;
        k.checked = this.checked;
        k.is30 = this.is30;
        return k;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator allResults;
        Expression expression;
        Item arg2;
        Controller controller = context.getController();
        try {
            arg2 = this.argument[2].evaluateItem(context);
        }
        catch (XPathException e) {
            String code = e.getErrorCodeLocalPart();
            if ("XPDY0002".equals(code) && this.argument[2] instanceof RootExpression) {
                this.dynamicError("Cannot call the key() function when there is no context node", "XTDE1270", context);
            } else if ("XPDY0050".equals(code)) {
                this.dynamicError("In the key() function, the node supplied in the third argument (or the context node if absent) must be in a tree whose root is a document node", "XTDE1270", context);
            } else if ("XPTY0020".equals(code) || "XPTY0019".equals(code)) {
                this.dynamicError("Cannot call the key() function when the context item is an atomic value", "XTDE1270", context);
            }
            throw e;
        }
        NodeInfo origin = (NodeInfo)arg2;
        NodeInfo root = origin.getRoot();
        if (root.getNodeKind() != 9) {
            this.dynamicError("In the key() function, the node supplied in the third argument (or the context node if absent) must be in a tree whose root is a document node", "XTDE1270", context);
            return null;
        }
        DocumentInfo doc = (DocumentInfo)root;
        KeyDefinitionSet selectedKeySet = this.staticKeySet;
        if (selectedKeySet == null) {
            String givenkeyname = this.argument[0].evaluateItem(context).getStringValue();
            StructuredQName qName = null;
            try {
                qName = StructuredQName.fromLexicalQName(givenkeyname, false, this.is30, this.nsContext);
            }
            catch (XPathException err) {
                this.dynamicError("Invalid key name: " + err.getMessage(), "XTDE1260", context);
            }
            selectedKeySet = controller.getKeyManager().getKeyDefinitionSet(qName);
            if (selectedKeySet == null) {
                this.dynamicError("Key '" + givenkeyname + "' has not been defined", "XTDE1260", context);
                return null;
            }
        }
        if (Cardinality.allowsMany((expression = this.argument[1]).getCardinality())) {
            final XPathContext keyContext = context;
            final DocumentInfo document = doc;
            final KeyManager keyManager = controller.getKeyManager();
            final KeyDefinitionSet keySet = selectedKeySet;
            MappingFunction<AtomicValue, NodeInfo> map = new MappingFunction<AtomicValue, NodeInfo>(){

                @Override
                public SequenceIterator map(AtomicValue item) throws XPathException {
                    return keyManager.selectByKey(keySet, document, item, keyContext);
                }
            };
            SequenceIterator keys = this.argument[1].iterate(context);
            MappingIterator<AtomicValue, NodeInfo> allValues = new MappingIterator<AtomicValue, NodeInfo>(keys, map);
            allResults = new DocumentOrderIterator(allValues, LocalOrderComparer.getInstance());
        } else {
            try {
                AtomicValue keyValue = (AtomicValue)this.argument[1].evaluateItem(context);
                if (keyValue == null) {
                    return EmptyIterator.getInstance();
                }
                KeyManager km3 = this.keyManager;
                if (km3 == null) {
                    km3 = controller.getKeyManager();
                }
                allResults = km3.selectByKey(selectedKeySet, doc, keyValue, context);
            }
            catch (XPathException e) {
                e.maybeSetLocation(this);
                throw e;
            }
        }
        if (origin == doc) {
            return allResults;
        }
        return new ItemMappingIterator<NodeInfo, NodeInfo>(allResults, new SubtreeFilter(origin));
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        throw new XPathException("Dynamic evaluation of fn:key() is not supported");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SubtreeFilter
    implements ItemMappingFunction<NodeInfo, NodeInfo> {
        private NodeInfo origin;

        public SubtreeFilter(NodeInfo origin) {
            this.origin = origin;
        }

        @Override
        public NodeInfo mapItem(NodeInfo item) throws XPathException {
            if (Navigator.isAncestorOrSelf(this.origin, item)) {
                return item;
            }
            return null;
        }
    }
}

