/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;

public class StringLength
extends SystemFunctionCall
implements Callable {
    boolean contextPossiblyUndefined = true;

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        return this.simplifyArguments(visitor);
    }

    public IntegerValue[] getIntegerBounds() {
        return new IntegerValue[]{Int64Value.ZERO, MAX_STRING_LENGTH};
    }

    public int getIntrinsicDependencies() {
        int d = super.getIntrinsicDependencies();
        if (this.argument.length == 0) {
            d |= 2;
        }
        return d;
    }

    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        if (this.argument.length == 0) {
            return this;
        }
        return Literal.makeLiteral(this.evaluateItem(visitor.getStaticContext().makeEarlyEvaluationContext()), this.getContainer());
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        if (this.argument.length == 0 && contextInfo == null) {
            XPathException err = new XPathException("The context item for string-length() is absent");
            err.setErrorCode("XPDY0002");
            err.setIsTypeError(true);
            err.setLocator(this);
            throw err;
        }
        if (contextInfo != null) {
            this.contextPossiblyUndefined = contextInfo.isPossiblyAbsent();
        }
        return super.typeCheck(visitor, contextInfo);
    }

    public boolean isContextPossiblyUndefined() {
        return this.contextPossiblyUndefined;
    }

    public Int64Value evaluateItem(XPathContext c) throws XPathException {
        AtomicValue sv;
        if (this.argument.length == 0) {
            Item contextItem = c.getContextItem();
            if (contextItem == null) {
                this.dynamicError("The context item for string-length() is not set", "XPDY0002", c);
                return null;
            }
            sv = StringValue.makeStringValue(contextItem.getStringValueCS());
        } else {
            sv = (AtomicValue)this.argument[0].evaluateItem(c);
        }
        if (sv == null) {
            return Int64Value.ZERO;
        }
        if (sv instanceof StringValue) {
            return Int64Value.makeIntegerValue(((StringValue)sv).getStringLength());
        }
        CharSequence s2 = sv.getStringValueCS();
        return Int64Value.makeIntegerValue(StringValue.getStringLength(s2));
    }

    public IntegerValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        AtomicValue sv;
        if (this.argument.length == 0) {
            Item contextItem = context.getContextItem();
            if (contextItem == null) {
                this.dynamicError("The context item for string-length() is not set", "XPDY0002", context);
                return null;
            }
            sv = StringValue.makeStringValue(contextItem.getStringValueCS());
        } else {
            sv = (AtomicValue)arguments[0].head();
        }
        if (sv == null) {
            return Int64Value.ZERO;
        }
        if (sv instanceof StringValue) {
            return Int64Value.makeIntegerValue(((StringValue)sv).getStringLength());
        }
        CharSequence s2 = sv.getStringValueCS();
        return Int64Value.makeIntegerValue(StringValue.getStringLength(s2));
    }
}

