/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.GlobalVariableReference;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.SimpleStepExpression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.LocationMap;
import net.sf.saxon.expr.instruct.SavedNamespaceContext;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.CodeInjector;
import net.sf.saxon.expr.parser.ExpressionLocation;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.ConstructorFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.Last;
import net.sf.saxon.functions.Position;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.SystemFunctionLibrary;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.Declaration;
import net.sf.saxon.query.ImportedFunctionLibrary;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.UnboundFunctionLibrary;
import net.sf.saxon.query.UndeclaredVariable;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.query.XQueryParser;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trace.TraceCodeInjector;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaComponentVisitor;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryModule
implements StaticContext {
    private boolean isMainModule;
    private Configuration config;
    private StaticQueryContext userQueryContext;
    private QueryModule topModule;
    private URI locationURI;
    private String baseURI;
    private String moduleNamespace;
    private HashMap<String, String> explicitPrologNamespaces;
    private Stack<ActiveNamespace> activeNamespaces;
    private HashMap<StructuredQName, GlobalVariable> variables;
    private HashMap<StructuredQName, GlobalVariable> libraryVariables;
    private HashMap<StructuredQName, UndeclaredVariable> undeclaredVariables;
    private HashSet<String> importedSchemata;
    private HashMap<String, HashSet<String>> loadedSchemata;
    private Executable executable;
    private List<QueryModule> importers;
    private FunctionLibraryList functionLibraryList;
    private XQueryFunctionLibrary globalFunctionLibrary;
    private int localFunctionLibraryNr;
    private int importedFunctionLibraryNr;
    private int unboundFunctionLibraryNr;
    private Set<String> importedModuleNamespaces;
    private boolean inheritNamespaces = true;
    private boolean preserveNamespaces = true;
    private int constructionMode = 3;
    private String defaultFunctionNamespace;
    private String defaultElementNamespace;
    private boolean preserveSpace = false;
    private boolean defaultEmptyLeast = true;
    private String defaultCollationName;
    private int revalidationMode = 4;
    private boolean isUpdating = false;
    private DecimalValue languageVersion = DecimalValue.ONE;
    private ItemType requiredContextItemType = AnyItemType.getInstance();
    private DecimalFormatManager decimalFormatManager = null;
    private CodeInjector codeInjector;
    private PackageData packageData;

    public QueryModule(StaticQueryContext sqc) throws XPathException {
        this.config = sqc.getConfiguration();
        this.isMainModule = true;
        this.topModule = this;
        this.activeNamespaces = new Stack();
        this.baseURI = sqc.getBaseURI();
        this.defaultCollationName = sqc.getDefaultCollationName();
        try {
            this.locationURI = this.baseURI == null ? null : new URI(this.baseURI);
        }
        catch (URISyntaxException err) {
            throw new XPathException("Invalid location URI: " + this.baseURI);
        }
        this.executable = sqc.makeExecutable();
        this.importers = null;
        this.init(sqc);
        Iterator<GlobalVariable> vars = sqc.iterateDeclaredGlobalVariables();
        while (vars.hasNext()) {
            this.declareVariable(vars.next());
        }
        PackageData pd = new PackageData(this.config);
        pd.setAllowXPath30(this.getXPathLanguageLevel().equals(DecimalValue.THREE));
        pd.setHostLanguage(51);
        pd.setSchemaAware(this.isSchemaAware());
        pd.setLocationMap(this.executable.getLocationMap());
        this.packageData = pd;
    }

    public QueryModule(Configuration config, QueryModule importer) {
        this.config = config;
        this.importers = null;
        if (importer == null) {
            this.topModule = this;
        } else {
            this.topModule = importer.topModule;
            this.userQueryContext = importer.userQueryContext;
            this.importers = new ArrayList<QueryModule>(2);
            this.importers.add(importer);
        }
        this.init(this.userQueryContext);
        this.packageData = importer.getPackageData();
        this.activeNamespaces = new Stack();
        this.executable = null;
    }

    private void init(StaticQueryContext sqc) {
        this.userQueryContext = sqc;
        this.variables = new HashMap(10);
        this.undeclaredVariables = new HashMap(5);
        if (this.isTopLevelModule()) {
            this.libraryVariables = new HashMap(10);
        }
        this.importedSchemata = null;
        this.importedModuleNamespaces = new HashSet<String>(5);
        this.moduleNamespace = null;
        this.activeNamespaces = new Stack();
        this.explicitPrologNamespaces = new HashMap(10);
        if (sqc != null) {
            this.inheritNamespaces = sqc.isInheritNamespaces();
            this.preserveNamespaces = sqc.isPreserveNamespaces();
            this.preserveSpace = sqc.isPreserveBoundarySpace();
            this.defaultEmptyLeast = sqc.isEmptyLeast();
            this.defaultFunctionNamespace = sqc.getDefaultFunctionNamespace();
            this.defaultElementNamespace = sqc.getDefaultElementNamespace();
            this.defaultCollationName = sqc.getDefaultCollationName();
            this.constructionMode = sqc.getConstructionMode();
            if (this.constructionMode == 3 && !sqc.isSchemaAware()) {
                this.constructionMode = 4;
            }
            this.requiredContextItemType = sqc.getRequiredContextItemType();
            this.isUpdating = sqc.isUpdatingEnabled();
            this.languageVersion = sqc.getLanguageVersion();
            this.codeInjector = sqc.getCodeInjector();
        }
        this.initializeFunctionLibraries(sqc);
    }

    public static QueryModule makeQueryModule(String baseURI, Executable executable, QueryModule importer, String query, String namespaceURI, boolean allowCycles) throws XPathException {
        Configuration config = executable.getConfiguration();
        QueryModule module = new QueryModule(config, importer);
        try {
            module.setLocationURI(new URI(baseURI));
        }
        catch (URISyntaxException e) {
            throw new XPathException("Invalid location URI " + baseURI, e);
        }
        module.setBaseURI(baseURI);
        module.setExecutable(executable);
        module.setModuleNamespace(namespaceURI);
        executable.addQueryLibraryModule(module);
        XQueryParser qp = (XQueryParser)config.newExpressionParser("XQ", importer.isUpdating(), importer.getLanguageVersion());
        if (importer.getCodeInjector() != null) {
            qp.setCodeInjector(importer.getCodeInjector());
        } else if (config.isCompileWithTracing()) {
            qp.setCodeInjector(new TraceCodeInjector());
        }
        qp.setDisableCycleChecks(allowCycles);
        qp.parseLibraryModule(query, module);
        String namespace = module.getModuleNamespace();
        if (namespace == null) {
            XPathException err = new XPathException("Imported module must be a library module");
            err.setErrorCode("XQST0059");
            err.setIsStaticError(true);
            throw err;
        }
        if (!namespace.equals(namespaceURI)) {
            XPathException err = new XPathException("Imported module's namespace does not match requested namespace");
            err.setErrorCode("XQST0059");
            err.setIsStaticError(true);
            throw err;
        }
        return module;
    }

    private void initializeFunctionLibraries(StaticQueryContext sqc) {
        Configuration config = this.getConfiguration();
        if (this.isTopLevelModule()) {
            this.globalFunctionLibrary = new XQueryFunctionLibrary(config);
        }
        int functionSet = 1;
        if (this.isUpdating()) {
            functionSet |= 8;
        }
        if (this.getLanguageVersion().equals(DecimalValue.THREE)) {
            functionSet |= 0x10;
        }
        this.functionLibraryList = new FunctionLibraryList();
        this.functionLibraryList.addFunctionLibrary(SystemFunctionLibrary.getSystemFunctionLibrary(functionSet));
        this.functionLibraryList.addFunctionLibrary(config.getVendorFunctionLibrary());
        this.functionLibraryList.addFunctionLibrary(new ConstructorFunctionLibrary(config));
        this.localFunctionLibraryNr = this.functionLibraryList.addFunctionLibrary(new XQueryFunctionLibrary(config));
        this.importedFunctionLibraryNr = this.functionLibraryList.addFunctionLibrary(new ImportedFunctionLibrary(this, this.getTopLevelModule().getGlobalFunctionLibrary()));
        if (sqc != null && sqc.getExtensionFunctionLibrary() != null) {
            this.functionLibraryList.addFunctionLibrary(sqc.getExtensionFunctionLibrary());
        }
        this.functionLibraryList.addFunctionLibrary(config.getIntegratedFunctionLibrary());
        config.addExtensionBinders(this.functionLibraryList);
        this.unboundFunctionLibraryNr = this.functionLibraryList.addFunctionLibrary(new UnboundFunctionLibrary());
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    public PackageData getPackageData() {
        return this.packageData;
    }

    public boolean isTopLevelModule() {
        return this == this.topModule;
    }

    public void setIsMainModule(boolean main) {
        this.isMainModule = main;
    }

    public boolean isMainModule() {
        return this.isMainModule;
    }

    public boolean mayImportModule(String namespace) {
        if (namespace.equals(this.moduleNamespace)) {
            return false;
        }
        if (this.importers == null) {
            return true;
        }
        for (QueryModule importer : this.importers) {
            if (importer.mayImportModule(namespace)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSchemaAware() {
        return this.executable.isSchemaAware();
    }

    public void setInheritNamespaces(boolean inherit) {
        this.inheritNamespaces = inherit;
    }

    public boolean isInheritNamespaces() {
        return this.inheritNamespaces;
    }

    public void setPreserveNamespaces(boolean inherit) {
        this.preserveNamespaces = inherit;
    }

    public boolean isPreserveNamespaces() {
        return this.preserveNamespaces;
    }

    public void setConstructionMode(int mode) {
        this.constructionMode = mode;
    }

    public int getConstructionMode() {
        return this.constructionMode;
    }

    public void setPreserveBoundarySpace(boolean preserve) {
        this.preserveSpace = preserve;
    }

    public boolean isPreserveBoundarySpace() {
        return this.preserveSpace;
    }

    public void setEmptyLeast(boolean least) {
        this.defaultEmptyLeast = least;
    }

    public boolean isEmptyLeast() {
        return this.defaultEmptyLeast;
    }

    public XQueryFunctionLibrary getGlobalFunctionLibrary() {
        return this.globalFunctionLibrary;
    }

    public ImportedFunctionLibrary getImportedFunctionLibrary() {
        return (ImportedFunctionLibrary)this.functionLibraryList.get(this.importedFunctionLibraryNr);
    }

    public void addImportedNamespace(String uri) {
        if (this.importedModuleNamespaces == null) {
            this.importedModuleNamespaces = new HashSet<String>(5);
        }
        this.importedModuleNamespaces.add(uri);
        this.getImportedFunctionLibrary().addImportedNamespace(uri);
    }

    public boolean importsNamespace(String uri) {
        return this.importedModuleNamespaces != null && this.importedModuleNamespaces.contains(uri);
    }

    public QueryModule getTopLevelModule() {
        return this.topModule;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public StaticQueryContext getUserQueryContext() {
        return this.userQueryContext;
    }

    @Override
    public LocationMap getLocationMap() {
        return this.executable.getLocationMap();
    }

    public void setModuleNamespace(String uri) {
        this.moduleNamespace = uri;
    }

    public String getModuleNamespace() {
        return this.moduleNamespace;
    }

    public void setLocationURI(URI uri) {
        this.locationURI = uri;
    }

    public URI getLocationURI() {
        return this.locationURI;
    }

    @Override
    public String getSystemId() {
        return this.locationURI == null ? null : this.locationURI.toString();
    }

    public void setBaseURI(String uri) {
        this.baseURI = uri;
    }

    @Override
    public String getBaseURI() {
        return this.baseURI;
    }

    public SlotManager getGlobalStackFrameMap() {
        return this.executable.getGlobalVariableMap();
    }

    public void declareVariable(GlobalVariable var) throws XPathException {
        GlobalVariable old;
        StructuredQName key = var.getVariableQName();
        if (this.variables.get(key) != null && (old = this.variables.get(key)) != var && old.getUltimateOriginalVariable() != var.getUltimateOriginalVariable()) {
            String oldloc = " (see line " + old.getLineNumber();
            String oldSysId = old.getSystemId();
            if (oldSysId != null && !oldSysId.equals(var.getSystemId())) {
                oldloc = oldloc + " in module " + old.getSystemId();
            }
            oldloc = oldloc + ")";
            XPathException err = new XPathException("Duplicate definition of global variable " + var.getVariableQName().getDisplayName() + oldloc);
            err.setErrorCode("XQST0049");
            err.setIsStaticError(true);
            ExpressionLocation loc = new ExpressionLocation();
            loc.setLineNumber(var.getLineNumber());
            loc.setSystemId(var.getSystemId());
            err.setLocator(loc);
            throw err;
        }
        this.variables.put(key, var);
        HashMap<StructuredQName, GlobalVariable> libVars = this.getTopLevelModule().libraryVariables;
        GlobalVariable old2 = libVars.get(key);
        if (old2 != null && old2 != var) {
            XPathException err = new XPathException("Duplicate definition of global variable " + var.getVariableQName().getDisplayName() + " (see line " + old2.getLineNumber() + " in module " + old2.getSystemId() + ')');
            err.setErrorCode("XQST0049");
            err.setIsStaticError(true);
            ExpressionLocation loc = new ExpressionLocation();
            loc.setLineNumber(var.getLineNumber());
            loc.setSystemId(var.getSystemId());
            err.setLocator(loc);
            throw err;
        }
        if (!this.isMainModule()) {
            libVars.put(key, var);
        }
    }

    public Iterator<GlobalVariable> getGlobalVariables() {
        return this.libraryVariables.values().iterator();
    }

    public List<GlobalVariable> fixupGlobalVariables(SlotManager globalVariableMap, GlobalVariable contextItemVar) throws XPathException {
        ArrayList<GlobalVariable> varDefinitions = new ArrayList<GlobalVariable>(20);
        ArrayList<Iterator<GlobalVariable>> iters = new ArrayList<Iterator<GlobalVariable>>();
        iters.add(this.variables.values().iterator());
        iters.add(this.libraryVariables.values().iterator());
        for (Iterator iterator : iters) {
            while (iterator.hasNext()) {
                Expression select;
                GlobalVariable var = (GlobalVariable)iterator.next();
                if (!varDefinitions.contains(var)) {
                    int slot = globalVariableMap.allocateSlotNumber(var.getVariableQName());
                    var.compile(this.getExecutable(), slot);
                    varDefinitions.add(var);
                }
                if ((select = var.getSelectExpression()) == null) continue;
                boolean changed = false;
                if (select instanceof Position) {
                    select = Literal.makeLiteral(IntegerValue.PLUS_ONE, var);
                    changed = true;
                } else if (select instanceof Last) {
                    select = Literal.makeLiteral(IntegerValue.PLUS_ONE, var);
                    changed = true;
                } else if (select instanceof ContextItemExpression) {
                    select = new GlobalVariableReference(contextItemVar);
                    changed = true;
                } else if (select instanceof AxisExpression) {
                    select = new SimpleStepExpression(new GlobalVariableReference(contextItemVar), select);
                    changed = true;
                } else if (select instanceof RootExpression) {
                    select = new SlashExpression(new GlobalVariableReference(contextItemVar), select);
                    changed = true;
                } else {
                    ExpressionTool.ExpressionSelector selector;
                    int dependencies = select.getDependencies();
                    if ((dependencies & 0x12) != 0) {
                        changed = ExpressionTool.factorOutDot(select, contextItemVar);
                    }
                    if ((dependencies & 4) != 0) {
                        selector = new ExpressionTool.ExpressionSelector(){

                            public boolean matches(Expression exp) {
                                return exp instanceof Position;
                            }
                        };
                        changed = ExpressionTool.replaceSelectedSubexpressions(select, selector, Literal.makeLiteral(IntegerValue.PLUS_ONE, select.getContainer()));
                    }
                    if ((dependencies & 8) != 0) {
                        selector = new ExpressionTool.ExpressionSelector(){

                            public boolean matches(Expression exp) {
                                return exp instanceof Last;
                            }
                        };
                        changed = ExpressionTool.replaceSelectedSubexpressions(select, selector, Literal.makeLiteral(IntegerValue.PLUS_ONE, select.getContainer()));
                    }
                }
                if (!changed) continue;
                var.setSelectExpression(select);
            }
        }
        return varDefinitions;
    }

    public void lookForModuleCycles(Stack<QueryModule> referees, int lineNumber) throws XPathException {
        String uri;
        if (referees.contains(this)) {
            int s2 = referees.indexOf(this);
            referees.push(this);
            String message = "Circular dependency between modules. ";
            for (int i = s2; i < referees.size() - 1; ++i) {
                QueryModule next = (QueryModule)referees.get(i + 1);
                message = i == s2 ? message + "Module " + this.getSystemId() + " references module " + next.getSystemId() : message + ", which references module " + next.getSystemId();
            }
            message = message + '.';
            XPathException err = new XPathException(message);
            err.setErrorCode("XQST0093");
            err.setIsStaticError(true);
            ExpressionLocation loc = new ExpressionLocation();
            loc.setSystemId(this.getSystemId());
            loc.setLineNumber(lineNumber);
            err.setLocator(loc);
            throw err;
        }
        referees.push(this);
        Iterator<GlobalVariable> viter = this.getModuleVariables();
        while (viter.hasNext()) {
            GlobalVariable gv = viter.next();
            Expression select = gv.getSelectExpression();
            if (select == null) continue;
            ArrayList<Binding> list = new ArrayList<Binding>(10);
            ExpressionTool.gatherReferencedVariables(select, list);
            for (Binding b : list) {
                QueryModule sqc;
                if (!(b instanceof GlobalVariable)) continue;
                String uri2 = ((GlobalVariable)b).getSystemId();
                StructuredQName qName = b.getVariableQName();
                boolean synthetic = qName.hasURI("http://saxon.sf.net/generated-global-variable");
                if (synthetic || uri2 == null || uri2.equals(this.getSystemId()) || (sqc = this.executable.getQueryModuleWithSystemId(uri2, this.topModule)) == null) continue;
                sqc.lookForModuleCycles(referees, ((GlobalVariable)b).getLineNumber());
            }
            ArrayList<UserFunction> fList = new ArrayList<UserFunction>(5);
            ExpressionTool.gatherCalledFunctions(select, fList);
            for (UserFunction f : fList) {
                QueryModule sqc;
                uri = f.getSystemId();
                if (uri == null || uri.equals(this.getSystemId()) || (sqc = this.executable.getQueryModuleWithSystemId(uri, this.topModule)) == null) continue;
                sqc.lookForModuleCycles(referees, f.getLineNumber());
            }
        }
        Iterator<XQueryFunction> fiter = this.getLocalFunctionLibrary().getFunctionDefinitions();
        while (fiter.hasNext()) {
            XQueryFunction gf = fiter.next();
            Expression body = gf.getUserFunction().getBody();
            if (body == null) continue;
            ArrayList<Binding> vList = new ArrayList<Binding>(10);
            ExpressionTool.gatherReferencedVariables(body, vList);
            for (Binding b : vList) {
                QueryModule sqc;
                if (!(b instanceof GlobalVariable)) continue;
                uri = ((GlobalVariable)b).getSystemId();
                StructuredQName qName = b.getVariableQName();
                boolean synthetic = qName.hasURI("http://saxon.sf.net/") && "gg".equals(qName.getPrefix());
                if (synthetic || uri == null || uri.equals(this.getSystemId()) || (sqc = this.executable.getQueryModuleWithSystemId(uri, this.topModule)) == null) continue;
                sqc.lookForModuleCycles(referees, ((GlobalVariable)b).getLineNumber());
            }
            ArrayList<UserFunction> fList = new ArrayList<UserFunction>(10);
            ExpressionTool.gatherCalledFunctions(body, fList);
            for (UserFunction f : fList) {
                QueryModule sqc;
                String uri3 = f.getSystemId();
                if (uri3 == null || uri3.equals(this.getSystemId()) || (sqc = this.executable.getQueryModuleWithSystemId(uri3, this.topModule)) == null) continue;
                sqc.lookForModuleCycles(referees, f.getLineNumber());
            }
        }
        referees.pop();
    }

    public Iterator<GlobalVariable> getModuleVariables() {
        return this.variables.values().iterator();
    }

    public void checkForCircularities(List<GlobalVariable> compiledVars, XQueryFunctionLibrary globalFunctionLibrary) throws XPathException {
        Iterator<GlobalVariable> iter = compiledVars.iterator();
        Stack<Container> stack = null;
        while (iter.hasNext()) {
            GlobalVariable gv;
            if (stack == null) {
                stack = new Stack<Container>();
            }
            if ((gv = iter.next()) == null) continue;
            gv.lookForCycles(stack, globalFunctionLibrary);
        }
    }

    public void typeCheckGlobalVariables(List<GlobalVariable> compiledVars) throws XPathException {
        ExpressionVisitor visitor = ExpressionVisitor.make(this);
        for (GlobalVariable compiledVar : compiledVars) {
            compiledVar.typeCheck(visitor);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Expression bindVariable(StructuredQName qName) throws XPathException {
        GlobalVariable var = this.variables.get(qName);
        if (var == null) {
            String uri = qName.getURI();
            if (!(uri.equals("") && this.isMainModule() || uri.equals(this.moduleNamespace) || this.importsNamespace(uri))) {
                XPathException err = new XPathException("Variable $" + qName.getDisplayName() + " has not been declared");
                err.setErrorCode("XPST0008");
                err.setIsStaticError(true);
                throw err;
            }
            QueryModule main = this.getTopLevelModule();
            var = main.libraryVariables.get(qName);
            if (var == null) {
                if (!this.getLanguageVersion().equals(DecimalValue.THREE)) {
                    XPathException err = new XPathException("Variable $" + qName.getDisplayName() + " has not been declared");
                    err.setErrorCode("XPST0008");
                    err.setIsStaticError(true);
                    throw err;
                }
                UndeclaredVariable uvar = this.undeclaredVariables.get(qName);
                if (uvar != null) {
                    GlobalVariableReference ref = new GlobalVariableReference();
                    uvar.registerReference(ref);
                    return ref;
                }
                uvar = new UndeclaredVariable();
                uvar.setPackageData(main.getPackageData());
                uvar.setVariableQName(qName);
                GlobalVariableReference ref = new GlobalVariableReference();
                uvar.registerReference(ref);
                this.undeclaredVariables.put(qName, uvar);
                return ref;
            }
            if (var.isPrivate()) {
                XPathException err = new XPathException("Variable $" + qName.getDisplayName() + " is private");
                err.setErrorCode("XPST0008");
                err.setIsStaticError(true);
                throw err;
            }
            this.checkImportedType(var.getRequiredType(), var);
        } else if (var.isPrivate() && !var.getSystemId().equals(this.getSystemId())) {
            XPathException err = new XPathException("Variable $" + qName.getDisplayName() + " is private");
            err.setErrorCode("XPST0008");
            err.setIsStaticError(true);
            throw err;
        }
        GlobalVariableReference vref = new GlobalVariableReference();
        var.registerReference(vref);
        return vref;
    }

    @Override
    public FunctionLibrary getFunctionLibrary() {
        return this.functionLibraryList;
    }

    public XQueryFunctionLibrary getLocalFunctionLibrary() {
        return (XQueryFunctionLibrary)this.functionLibraryList.get(this.localFunctionLibraryNr);
    }

    public void declareFunction(XQueryFunction function) throws XPathException {
        Configuration config = this.getConfiguration();
        if (function.getNumberOfArguments() == 1) {
            SchemaType t;
            StructuredQName name = function.getFunctionName();
            int fingerprint = config.getNamePool().getFingerprint(name.getURI(), name.getLocalPart());
            if (fingerprint != -1 && (t = config.getSchemaType(fingerprint)) != null && t.isAtomicType()) {
                XPathException err = new XPathException("Function name " + function.getDisplayName() + " clashes with the name of the constructor function for an atomic type");
                err.setErrorCode("XQST0034");
                err.setIsStaticError(true);
                throw err;
            }
        }
        XQueryFunctionLibrary local = this.getLocalFunctionLibrary();
        local.declareFunction(function);
        QueryModule main = this.getTopLevelModule();
        main.globalFunctionLibrary.declareFunction(function);
    }

    public void bindUnboundFunctionCalls() throws XPathException {
        UnboundFunctionLibrary lib = (UnboundFunctionLibrary)this.functionLibraryList.get(this.unboundFunctionLibraryNr);
        lib.bindUnboundFunctionReferences(this.functionLibraryList, this.getConfiguration());
    }

    public void fixupGlobalFunctions() throws XPathException {
        this.globalFunctionLibrary.fixupGlobalFunctions(this);
    }

    public void optimizeGlobalFunctions() throws XPathException {
        this.globalFunctionLibrary.optimizeGlobalFunctions();
    }

    public void explainGlobalFunctions(ExpressionPresenter out) {
        this.globalFunctionLibrary.explainGlobalFunctions(out);
    }

    public UserFunction getUserDefinedFunction(String uri, String localName, int arity) {
        return this.globalFunctionLibrary.getUserDefinedFunction(uri, localName, arity);
    }

    public void bindUnboundVariables() throws XPathException {
        for (UndeclaredVariable uv : this.undeclaredVariables.values()) {
            XPathException err;
            String uri;
            StructuredQName qName = uv.getVariableQName();
            GlobalVariable var = this.variables.get(qName);
            if (var == null && this.importsNamespace(uri = qName.getURI())) {
                QueryModule main = this.getTopLevelModule();
                var = main.libraryVariables.get(qName);
            }
            if (var == null) {
                err = new XPathException("Unresolved reference to variable $" + uv.getVariableQName().getDisplayName());
                err.setErrorCode("XPST0008");
                err.setIsStaticError(true);
                throw err;
            }
            if (var.isPrivate() && !var.getSystemId().equals(this.getSystemId())) {
                err = new XPathException("Cannot reference a private variable in a different module");
                err.setErrorCode("XPST0008");
                err.setIsStaticError(true);
                throw err;
            }
            this.checkImportedType(var.getRequiredType(), var);
            uv.transferReferences(var);
        }
    }

    public void addImportedSchema(String targetNamespace, String baseURI, List<String> locationURIs) {
        HashSet<String> entries;
        if (this.importedSchemata == null) {
            this.importedSchemata = new HashSet(5);
        }
        this.importedSchemata.add(targetNamespace);
        HashMap<String, HashSet<String>> loadedSchemata = this.getTopLevelModule().loadedSchemata;
        if (loadedSchemata == null) {
            loadedSchemata = new HashMap(5);
            this.getTopLevelModule().loadedSchemata = loadedSchemata;
        }
        if ((entries = loadedSchemata.get(targetNamespace)) == null) {
            entries = new HashSet(locationURIs.size());
            loadedSchemata.put(targetNamespace, entries);
        }
        for (String relative : locationURIs) {
            try {
                URI abs = ResolveURI.makeAbsolute(relative, baseURI);
                entries.add(abs.toString());
            }
            catch (URISyntaxException e) {}
        }
    }

    @Override
    public boolean isImportedSchema(String namespace) {
        return this.importedSchemata != null && this.importedSchemata.contains(namespace);
    }

    @Override
    public Set<String> getImportedSchemaNamespaces() {
        if (this.importedSchemata == null) {
            return Collections.emptySet();
        }
        return this.importedSchemata;
    }

    public void reportStaticError(XPathException err) {
        if (!err.hasBeenReported()) {
            if (this.userQueryContext == null) {
                this.config.getErrorListener().fatalError(err);
            } else {
                this.userQueryContext.getErrorListener().fatalError(err);
            }
            err.setHasBeenReported(true);
        }
    }

    public void checkImportedFunctionSignature(XQueryFunction fd) throws XPathException {
        this.checkImportedType(fd.getResultType(), fd);
        for (int a = 0; a < fd.getNumberOfArguments(); ++a) {
            SequenceType argType = fd.getArgumentTypes()[a];
            this.checkImportedType(argType, fd);
        }
    }

    public void checkImportedType(SequenceType importedType, final Declaration declaration) throws XPathException {
        ItemType type = importedType.getPrimaryType();
        type.visitNamedSchemaComponents(new SchemaComponentVisitor(){

            public void visitSchemaComponent(SchemaComponent component) throws XPathException {
                if (component instanceof SchemaDeclaration) {
                    int f = ((SchemaDeclaration)((Object)component)).getFingerprint();
                    QueryModule.this.checkSchemaNamespaceImported(f, declaration);
                } else if (component instanceof SchemaType) {
                    int f = ((SchemaType)component).getFingerprint();
                    QueryModule.this.checkSchemaNamespaceImported(f, declaration);
                }
            }
        });
    }

    @Override
    public XPathContext makeEarlyEvaluationContext() {
        return new EarlyEvaluationContext(this.getConfiguration());
    }

    @Override
    public StringCollator getCollation(String name) {
        if (name == null) {
            name = this.defaultCollationName;
        }
        try {
            return this.getConfiguration().getCollation(name);
        }
        catch (XPathException e) {
            this.issueWarning(e.getMessage(), null);
            return null;
        }
    }

    @Override
    public String getDefaultCollationName() {
        if (this.defaultCollationName == null) {
            this.defaultCollationName = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
        }
        return this.defaultCollationName;
    }

    public void setDefaultCollationName(String collation) {
        this.defaultCollationName = collation;
    }

    public void declarePrologNamespace(String prefix, String uri) throws XPathException {
        if (prefix == null) {
            throw new NullPointerException("Null prefix supplied to declarePrologNamespace()");
        }
        if (uri == null) {
            throw new NullPointerException("Null namespace URI supplied to declarePrologNamespace()");
        }
        if (prefix.equals("xml") != uri.equals("http://www.w3.org/XML/1998/namespace")) {
            XPathException err = new XPathException("Invalid declaration of the XML namespace");
            err.setErrorCode("XQST0070");
            err.setIsStaticError(true);
            throw err;
        }
        if (this.explicitPrologNamespaces.get(prefix) != null) {
            XPathException err = new XPathException("Duplicate declaration of namespace prefix \"" + prefix + '\"');
            err.setErrorCode("XQST0033");
            err.setIsStaticError(true);
            throw err;
        }
        this.explicitPrologNamespaces.put(prefix, uri);
    }

    public void declareActiveNamespace(String prefix, String uri) {
        if (prefix == null) {
            throw new NullPointerException("Null prefix supplied to declareActiveNamespace()");
        }
        if (uri == null) {
            throw new NullPointerException("Null namespace URI supplied to declareActiveNamespace()");
        }
        ActiveNamespace entry = new ActiveNamespace();
        entry.prefix = prefix;
        entry.uri = uri;
        this.activeNamespaces.push(entry);
    }

    public void undeclareNamespace() {
        this.activeNamespaces.pop();
    }

    @Override
    public String getURIForPrefix(String prefix) throws XPathException {
        String uri = this.checkURIForPrefix(prefix);
        if (uri == null) {
            XPathException err = new XPathException("Prefix " + prefix + " has not been declared");
            err.setErrorCode("XPST0081");
            err.setIsStaticError(true);
            throw err;
        }
        return uri;
    }

    public String checkURIForPrefix(String prefix) {
        if (this.activeNamespaces != null) {
            for (int i = this.activeNamespaces.size() - 1; i >= 0; --i) {
                if (!((ActiveNamespace)this.activeNamespaces.get((int)i)).prefix.equals(prefix)) continue;
                String uri = ((ActiveNamespace)this.activeNamespaces.get((int)i)).uri;
                if (uri.equals("") && !prefix.equals("")) {
                    return null;
                }
                return uri;
            }
        }
        if (prefix.length() == 0) {
            return this.defaultElementNamespace;
        }
        String uri = this.explicitPrologNamespaces.get(prefix);
        if (uri != null) {
            return uri.length() == 0 ? null : uri;
        }
        if (this.userQueryContext != null) {
            uri = this.userQueryContext.getNamespaceForPrefix(prefix);
            if (uri != null) {
                return uri;
            }
            NamespaceResolver externalResolver = this.userQueryContext.getExternalNamespaceResolver();
            if (externalResolver != null) {
                return externalResolver.getURIForPrefix(prefix, true);
            }
        }
        return null;
    }

    @Override
    public String getDefaultElementNamespace() {
        return this.checkURIForPrefix("");
    }

    public void setDefaultElementNamespace(String uri) {
        this.defaultElementNamespace = uri;
    }

    @Override
    public String getDefaultFunctionNamespace() {
        return this.defaultFunctionNamespace;
    }

    public void setDefaultFunctionNamespace(String uri) {
        this.defaultFunctionNamespace = uri;
    }

    public void setRevalidationMode(int mode) {
        if (mode != 1 && mode != 2 && mode != 4) {
            throw new IllegalArgumentException("Invalid mode " + mode);
        }
        this.revalidationMode = mode;
    }

    public int getRevalidationMode() {
        return this.revalidationMode;
    }

    public NamespaceBinding[] getActiveNamespaceCodes() {
        if (this.activeNamespaces == null) {
            return NamespaceBinding.EMPTY_ARRAY;
        }
        NamespaceBinding[] nsBindings = new NamespaceBinding[this.activeNamespaces.size()];
        int used = 0;
        HashSet<String> prefixes = new HashSet<String>(10);
        for (int n = this.activeNamespaces.size() - 1; n >= 0; --n) {
            ActiveNamespace an = (ActiveNamespace)this.activeNamespaces.get(n);
            if (prefixes.contains(an.prefix)) continue;
            prefixes.add(an.prefix);
            nsBindings[used++] = new NamespaceBinding(an.prefix, an.uri);
        }
        if (used < nsBindings.length) {
            NamespaceBinding[] nb2 = new NamespaceBinding[used];
            System.arraycopy(nsBindings, 0, nb2, 0, used);
            nsBindings = nb2;
        }
        return nsBindings;
    }

    @Override
    public NamespaceResolver getNamespaceResolver() {
        ArrayList<NamespaceBinding> externalNamespaceCodes = null;
        NamespaceResolver externalResolver = this.userQueryContext.getExternalNamespaceResolver();
        if (externalResolver != null) {
            externalNamespaceCodes = new ArrayList<NamespaceBinding>();
            Iterator<String> iter = externalResolver.iteratePrefixes();
            while (iter.hasNext()) {
                String prefix = iter.next();
                String uri = externalResolver.getURIForPrefix(prefix, true);
                NamespaceBinding nscode = new NamespaceBinding(prefix, uri);
                externalNamespaceCodes.add(nscode);
            }
        }
        HashMap<String, String> userDeclaredNamespaces = this.userQueryContext.getUserDeclaredNamespaces();
        ArrayList<NamespaceBinding> nsBindings = new ArrayList<NamespaceBinding>();
        for (Map.Entry<String, String> e : userDeclaredNamespaces.entrySet()) {
            nsBindings.add(new NamespaceBinding(e.getKey(), e.getValue()));
        }
        for (Map.Entry<String, String> e : this.explicitPrologNamespaces.entrySet()) {
            nsBindings.add(new NamespaceBinding(e.getKey(), e.getValue()));
        }
        if (this.defaultElementNamespace.length() != 0) {
            nsBindings.add(new NamespaceBinding("", this.defaultElementNamespace));
        }
        nsBindings.addAll(Arrays.asList(this.getActiveNamespaceCodes()));
        if (externalNamespaceCodes != null) {
            for (NamespaceBinding externalNamespaceCode : externalNamespaceCodes) {
                nsBindings.add(externalNamespaceCode);
            }
        }
        return new SavedNamespaceContext(nsBindings);
    }

    @Override
    public ItemType getRequiredContextItemType() {
        return this.requiredContextItemType;
    }

    @Override
    public DecimalFormatManager getDecimalFormatManager() {
        if (this.decimalFormatManager == null) {
            this.decimalFormatManager = new DecimalFormatManager();
        }
        return this.decimalFormatManager;
    }

    @Override
    public void issueWarning(String s2, SourceLocator locator) {
        XPathException err = new XPathException(s2);
        err.setLocator(locator);
        if (this.userQueryContext != null) {
            this.userQueryContext.getErrorListener().warning(err);
        } else {
            this.getConfiguration().getErrorListener().warning(err);
        }
    }

    @Override
    public int getLineNumber() {
        return -1;
    }

    @Override
    public boolean isInBackwardsCompatibleMode() {
        return false;
    }

    @Override
    public boolean isAllowedBuiltInType(BuiltInAtomicType type) {
        return type.getFingerprint() != 565 || this.config.getXsdVersion() == 11;
    }

    public boolean isUpdating() {
        return this.isUpdating;
    }

    public DecimalValue getLanguageVersion() {
        return this.languageVersion;
    }

    @Override
    public DecimalValue getXPathLanguageLevel() {
        return DecimalValue.THREE.equals(this.languageVersion) ? DecimalValue.THREE : DecimalValue.TWO;
    }

    public CodeInjector getCodeInjector() {
        return this.codeInjector;
    }

    private void checkSchemaNamespaceImported(int fingerprint, Declaration declaration) throws XPathException {
        String uri = this.getNamePool().getURI(fingerprint);
        if (!(uri.equals("http://www.w3.org/2001/XMLSchema") || uri.equals("http://ns.saxonica.com/anonymous-type") || uri.equals("http://saxon.sf.net/java-type") || this.isImportedSchema(uri))) {
            String msg = "Schema component " + this.getNamePool().getDisplayName(fingerprint) + " used in ";
            msg = declaration instanceof GlobalVariable ? msg + "declaration of imported variable " + ((GlobalVariable)declaration).getVariableQName().getDisplayName() : msg + "signature of imported function " + ((XQueryFunction)declaration).getDisplayName();
            msg = msg + " is not declared in any schema imported by ";
            String module = this.getModuleNamespace();
            msg = module == null ? msg + "the main query module" : msg + "query module " + module;
            XPathException err = new XPathException(msg);
            err.setErrorCode("XQST0036");
            err.setIsStaticError(true);
            err.setLocator(declaration);
            throw err;
        }
    }

    @Override
    public KeyManager getKeyManager() {
        return this.executable.getKeyManager();
    }

    private static class ActiveNamespace {
        public String prefix;
        public String uri;

        private ActiveNamespace() {
        }
    }
}

