/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import net.sf.saxon.regex.BMPString;
import net.sf.saxon.regex.GeneralUnicodeString;
import net.sf.saxon.regex.LatinString;
import net.sf.saxon.tree.util.FastStringBuffer;

public abstract class UnicodeString
implements CharSequence {
    public static UnicodeString EMPTY_STRING = new LatinString("");

    public static UnicodeString makeUnicodeString(CharSequence in) {
        if (in instanceof UnicodeString) {
            return (UnicodeString)in;
        }
        int width = UnicodeString.getMaxWidth(in);
        if (width == 1) {
            return new LatinString(in);
        }
        if (width == 2) {
            return new BMPString(in);
        }
        return new GeneralUnicodeString(in);
    }

    public static UnicodeString makeUnicodeString(int[] in) {
        for (int ch : in) {
            if (ch <= 65535) continue;
            return new GeneralUnicodeString(in, 0, in.length);
        }
        FastStringBuffer fsb = new FastStringBuffer(in.length);
        for (int ch : in) {
            fsb.append((char)ch);
        }
        return new BMPString(fsb);
    }

    public static boolean containsSurrogatePairs(CharSequence value) {
        if (value instanceof BMPString) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c < '\ud800' || c > '\udbff') continue;
            return true;
        }
        return false;
    }

    public static int getMaxWidth(CharSequence value) {
        if (value instanceof LatinString) {
            return 1;
        }
        if (value instanceof BMPString) {
            return 2;
        }
        if (value instanceof GeneralUnicodeString) {
            return 4;
        }
        boolean nonLatin = false;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c > '\u00ff') {
                nonLatin = true;
            }
            if (c < '\ud800' || c > '\udbff') continue;
            return 4;
        }
        return nonLatin ? 2 : 1;
    }

    public abstract UnicodeString uSubstring(int var1, int var2);

    public abstract int uIndexOf(int var1, int var2);

    public abstract int uCharAt(int var1);

    public abstract int uLength();

    public abstract boolean isEnd(int var1);

    public int hashCode() {
        int h2 = 0;
        for (int i = 0; i < this.uLength(); ++i) {
            h2 = 31 * h2 + this.uCharAt(i);
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UnicodeString)) {
            return false;
        }
        if (this.uLength() != ((UnicodeString)obj).uLength()) {
            return false;
        }
        for (int i = 0; i < this.uLength(); ++i) {
            if (this.uCharAt(i) == ((UnicodeString)obj).uCharAt(i)) continue;
            return false;
        }
        return true;
    }
}

