/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.util.Properties;
import javax.xml.transform.Result;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.serialize.CharacterMapIndex;
import net.sf.saxon.trans.XPathException;

public class ReconfigurableSerializer
extends ProxyReceiver {
    private Result destination;
    private Properties defaultOutputProperties;

    public ReconfigurableSerializer(Receiver next, Properties defaultOutputProperties, Result destination) {
        super(next);
        this.destination = destination;
        this.defaultOutputProperties = defaultOutputProperties;
    }

    public void reconfigure(Properties outputProperties, CharacterMapIndex charMapIndex) throws XPathException {
        SerializerFactory sf = this.getConfiguration().getSerializerFactory();
        Properties p = new Properties(this.defaultOutputProperties);
        for (String s2 : outputProperties.stringPropertyNames()) {
            p.setProperty(s2, outputProperties.getProperty(s2));
        }
        Receiver r = sf.getReceiver(this.destination, this.getPipelineConfiguration(), p, charMapIndex);
        this.setUnderlyingReceiver(r);
    }
}

