/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.StringTokenizer;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.SelectedElementsSpaceStrippingRule;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.pattern.LocalNameTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NamespaceTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trans.XPathException;

public class XSLPreserveSpace
extends StyleElement {
    private String elements;

    public boolean isDeclaration() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("elements")) {
                this.elements = atts.getValue(a);
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (this.elements == null) {
            this.reportAbsence("elements");
            this.elements = "*";
        }
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        this.checkEmpty();
        this.checkTopLevel("XTSE0010", false);
    }

    public void compileDeclaration(Compilation compilation, ComponentDeclaration decl) throws XPathException {
        Stripper.StripRuleTarget preserve = this.getFingerprint() == 190 ? Stripper.PRESERVE : Stripper.STRIP;
        StylesheetPackage psm = this.getCompilation().getStylesheetPackage();
        SpaceStrippingRule stripperRules = psm.getStripperRules();
        if (!(stripperRules instanceof SelectedElementsSpaceStrippingRule)) {
            stripperRules = new SelectedElementsSpaceStrippingRule(this.isXslt30Processor());
            psm.setStripperRules(stripperRules);
        }
        SelectedElementsSpaceStrippingRule rules = (SelectedElementsSpaceStrippingRule)stripperRules;
        StringTokenizer st = new StringTokenizer(this.elements, " \t\n\r", false);
        try {
            while (st.hasMoreTokens()) {
                String localName;
                String uri;
                String prefix;
                NodeTest nt;
                String s2 = st.nextToken();
                if (s2.equals("*")) {
                    nt = NodeKindTest.ELEMENT;
                    rules.addRule(nt, preserve, decl.getModule(), decl.getSourceElement().getLineNumber());
                    continue;
                }
                if (s2.endsWith(":*")) {
                    String uri2;
                    if (s2.length() == 2) {
                        this.compileError("No prefix before ':*'");
                    }
                    if ((uri2 = this.getURIForPrefix(prefix = s2.substring(0, s2.length() - 2), false)) == null) {
                        this.undeclaredNamespaceError(prefix, "XTSE0280");
                    }
                    nt = new NamespaceTest(this.getNamePool(), 1, uri2);
                    rules.addRule(nt, preserve, decl.getModule(), decl.getSourceElement().getLineNumber());
                    continue;
                }
                if (s2.startsWith("*:")) {
                    if (s2.length() == 2) {
                        this.compileError("No local name after '*:'");
                    }
                    String localname = s2.substring(2);
                    nt = new LocalNameTest(this.getNamePool(), 1, localname);
                    rules.addRule(nt, preserve, decl.getModule(), decl.getSourceElement().getLineNumber());
                    continue;
                }
                try {
                    String[] parts = NameChecker.getQNameParts(s2);
                    prefix = parts[0];
                    if (parts[0].equals("")) {
                        uri = this.getDefaultXPathNamespace();
                    } else {
                        uri = this.getURIForPrefix(prefix, false);
                        if (uri == null) {
                            this.undeclaredNamespaceError(prefix, "XTSE0280");
                        }
                    }
                    localName = parts[1];
                }
                catch (QNameException err) {
                    this.compileError("Element name " + s2 + " is not a valid QName", "XTSE0280");
                    return;
                }
                NamePool target = this.getNamePool();
                int nameCode = target.allocate("", uri, localName);
                nt = new NameTest(1, nameCode, this.getNamePool());
                rules.addRule(nt, preserve, decl.getModule(), decl.getSourceElement().getLineNumber());
            }
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            this.compileError(e);
        }
    }
}

