/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.Template;
import net.sf.saxon.expr.instruct.TraceExpression;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetComponent;
import net.sf.saxon.style.StylesheetModule;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.style.XSLLocalParam;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public final class XSLTemplate
extends StyleElement
implements StylesheetComponent {
    private String matchAtt = null;
    private String modeAtt = null;
    private String nameAtt = null;
    private String priorityAtt = null;
    private String asAtt = null;
    private String visibilityAtt = null;
    private StructuredQName[] modeNames;
    private String diagnosticId;
    private Pattern match;
    private boolean prioritySpecified;
    private double priority;
    private SlotManager stackFrameMap;
    private Template compiledTemplate = new Template();
    private SequenceType requiredType = null;
    private boolean hasRequiredParams = false;
    private boolean isTailRecursive = false;
    private Visibility visibility = Visibility.PRIVATE;

    public Template getCompiledProcedure() {
        return this.compiledTemplate;
    }

    public void setCompilation(Compilation compilation) {
        super.setCompilation(compilation);
        this.compiledTemplate.setPackageData(compilation.getPackageData());
    }

    public boolean isDeclaration() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    protected boolean mayContainParam(String attName) {
        return true;
    }

    protected boolean isPermittedChild(StyleElement child) {
        return child instanceof XSLLocalParam;
    }

    public StructuredQName getTemplateName() {
        try {
            String nameAtt;
            if (this.getObjectName() == null && (nameAtt = this.getAttributeValue("", "name")) != null) {
                this.setObjectName(this.makeQName(nameAtt));
            }
            return this.getObjectName();
        }
        catch (NamespaceException err) {
            return null;
        }
        catch (XPathException err) {
            return null;
        }
    }

    public SymbolicName getSymbolicName() {
        if (this.getTemplateName() == null) {
            return null;
        }
        return new SymbolicName(200, this.getTemplateName());
    }

    public void checkCompatibility(Component component) throws XPathException {
        NodeInfo param;
        Template other = (Template)component.getProcedure();
        if (!this.getSymbolicName().equals(other.getSymbolicName())) {
            throw new IllegalArgumentException();
        }
        if (!this.requiredType.equals(other.getRequiredType())) {
            this.compileError("The overriding template has a different required type from the overridden template", "XTSE3070");
        }
        List<LocalParam> otherParams = other.getLocalParams();
        HashSet<StructuredQName> overriddenParams = new HashSet<StructuredQName>();
        for (LocalParam lp0 : otherParams) {
            XSLLocalParam lp1 = this.getParam(lp0.getVariableQName());
            if (lp1 == null) {
                this.compileError("The overridden template declares a parameter " + lp0.getVariableQName().getDisplayName() + " which is not declared in the overriding template", "XTSE3070");
                return;
            }
            if (!lp1.getRequiredType().equals(lp0.getRequiredType())) {
                lp1.compileError("The parameter " + lp0.getVariableQName().getDisplayName() + " has a different required type in the overridden template", "XTSE3070");
                return;
            }
            if (lp1.isRequiredParam() != lp0.isRequiredParam()) {
                lp1.compileError("The parameter " + lp0.getVariableQName().getDisplayName() + " is " + (lp1.isRequiredParam() ? "required" : "optional") + " in the overriding template, but " + (lp0.isRequiredParam() ? "required" : "optional") + " in the overridden template", "XTSE3070");
                return;
            }
            if (lp1.isTunnelParam() != lp0.isTunnelParam()) {
                lp1.compileError("The parameter " + lp0.getVariableQName().getDisplayName() + " is a " + (lp1.isTunnelParam() ? "tunnel" : "non-tunnel") + " parameter in the overriding template, but " + (lp0.isTunnelParam() ? "tunnel" : "non-tunnel") + " parameter in the overridden template", "XTSE3070");
                return;
            }
            overriddenParams.add(lp0.getVariableQName());
        }
        AxisIterator params = this.iterateAxis((byte)3);
        while ((param = params.next()) != null) {
            if (!(param instanceof XSLLocalParam) || overriddenParams.contains(((XSLLocalParam)param).getObjectName()) || !((XSLLocalParam)param).isRequiredParam()) continue;
            ((XSLLocalParam)param).compileError("An overriding template cannot introduce a required parameter that is not declared in the overridden template", "XTSE3070");
        }
    }

    public XSLLocalParam getParam(StructuredQName name) {
        NodeInfo param;
        AxisIterator params = this.iterateAxis((byte)3);
        while ((param = params.next()) != null) {
            if (!(param instanceof XSLLocalParam) || !name.equals(((XSLLocalParam)param).getObjectName())) continue;
            return (XSLLocalParam)param;
        }
        return null;
    }

    protected ItemType getReturnedItemType() {
        if (this.requiredType == null) {
            return this.getCommonChildItemType();
        }
        return this.requiredType.getPrimaryType();
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("mode")) {
                this.modeAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("name")) {
                this.nameAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("match")) {
                this.matchAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("priority")) {
                this.priorityAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("as")) {
                this.asAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("visibility")) {
                this.visibilityAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        try {
            if (this.modeAtt == null) {
                if (this.matchAtt != null) {
                    StructuredQName defaultMode = this.getContainingStylesheet().getDefaultMode();
                    if (defaultMode == null) {
                        defaultMode = Mode.UNNAMED_MODE_NAME;
                    }
                    this.modeNames = new StructuredQName[1];
                    this.modeNames[0] = defaultMode;
                }
            } else {
                if (this.matchAtt == null) {
                    this.compileError("The mode attribute must be absent if the match attribute is absent", "XTSE0500");
                }
                int count = 0;
                boolean allModes = false;
                StringTokenizer st = new StringTokenizer(this.modeAtt, " \t\n\r", false);
                while (st.hasMoreTokens()) {
                    st.nextToken();
                    ++count;
                }
                if (count == 0) {
                    this.compileError("The mode attribute must not be empty", "XTSE0550");
                }
                this.modeNames = new StructuredQName[count];
                count = 0;
                st = new StringTokenizer(this.modeAtt, " \t\n\r", false);
                while (st.hasMoreTokens()) {
                    StructuredQName mname;
                    String s2 = st.nextToken();
                    if ("#default".equals(s2)) {
                        mname = this.getContainingStylesheet().getDefaultMode();
                        if (mname == null) {
                            mname = Mode.UNNAMED_MODE_NAME;
                        }
                    } else if ("#unnamed".equals(s2) && this.isXslt30Processor()) {
                        mname = Mode.UNNAMED_MODE_NAME;
                    } else if ("#all".equals(s2)) {
                        allModes = true;
                        mname = Mode.OMNI_MODE;
                    } else {
                        mname = this.makeQName(s2);
                    }
                    for (int e = 0; e < count; ++e) {
                        if (!this.modeNames[e].equals(mname)) continue;
                        this.compileError("In the list of modes, the value " + s2 + " is duplicated", "XTSE0550");
                    }
                    this.modeNames[count++] = mname;
                }
                if (allModes && count > 1) {
                    this.compileError("mode='#all' cannot be combined with other modes", "XTSE0550");
                }
            }
        }
        catch (NamespaceException err) {
            this.compileError(err.getMessage(), "XTSE0280");
        }
        catch (XPathException err) {
            err.maybeSetErrorCode("XTSE0280");
            if (err.getErrorCodeLocalPart().equals("XTSE0020")) {
                err.setErrorCode("XTSE0550");
            }
            err.setIsStaticError(true);
            this.compileError(err);
        }
        try {
            if (this.nameAtt != null) {
                StructuredQName qName = this.makeQName(this.nameAtt);
                this.setObjectName(qName);
                this.diagnosticId = this.nameAtt;
            }
        }
        catch (NamespaceException err) {
            this.compileError(err.getMessage(), "XTSE0280");
        }
        catch (XPathException err) {
            err.maybeSetErrorCode("XTSE0280");
            err.setIsStaticError(true);
            this.compileError(err);
        }
        boolean bl = this.prioritySpecified = this.priorityAtt != null;
        if (this.prioritySpecified) {
            if (this.matchAtt == null) {
                this.compileError("The priority attribute must be absent if the match attribute is absent", "XTSE0500");
            }
            try {
                if (!DecimalValue.castableAsDecimal(this.priorityAtt)) {
                    this.compileError("Invalid numeric value for priority (" + this.priority + ')', "XTSE0530");
                }
                this.priority = Double.parseDouble(this.priorityAtt);
            }
            catch (NumberFormatException err) {
                this.compileError("Invalid numeric value for priority (" + this.priority + ')', "XTSE0530");
            }
        }
        if (this.matchAtt != null) {
            this.match = this.makePattern(this.matchAtt);
            if (this.diagnosticId == null) {
                this.diagnosticId = "match=\"" + this.matchAtt + '\"';
                if (this.modeAtt != null) {
                    this.diagnosticId = this.diagnosticId + " mode=\"" + this.modeAtt + '\"';
                }
            }
        }
        if (this.match == null && this.nameAtt == null) {
            this.compileError("xsl:template must have a name or match attribute (or both)", "XTSE0500");
        }
        if (this.asAtt != null) {
            this.requiredType = this.makeSequenceType(this.asAtt);
        }
        if (this.visibilityAtt == null) {
            this.visibility = Visibility.PUBLIC;
        } else if (!this.isXslt30Processor()) {
            this.compileError("The xsl:template/@visibility attribute requires XSLT 3.0 to be enabled", "XTSE0020");
        } else {
            this.visibility = this.getVisibilityValue(this.visibilityAtt, "");
            if (this.nameAtt == null) {
                this.compileError("xsl:template/@visibility can be specified only if the template has a @name attribute", "XTSE0020");
            }
        }
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        NodeInfo param;
        this.stackFrameMap = this.getConfiguration().makeSlotManager();
        this.checkTopLevel("XTSE0010", true);
        if (this.match != null) {
            this.match = this.typeCheck("match", this.match);
            if (this.match.getItemType() instanceof ErrorType) {
                this.issueWarning(new XPathException("Pattern will never match anything", this));
            }
        }
        AxisIterator kids = this.iterateAxis((byte)3);
        boolean hasContent = false;
        while ((param = kids.next()) != null) {
            if (param instanceof XSLLocalParam) {
                if (!((XSLLocalParam)param).isRequiredParam()) continue;
                this.hasRequiredParams = true;
                continue;
            }
            if (!(param instanceof StyleElement)) continue;
            hasContent = true;
        }
        if (this.visibility == Visibility.ABSTRACT && hasContent) {
            this.compileError("A template with visibility='abstract' must have no body");
        }
    }

    public void postValidate() throws XPathException {
        this.isTailRecursive = this.markTailCalls();
    }

    public void index(ComponentDeclaration decl, StylesheetPackage top) throws XPathException {
        top.indexNamedTemplate(decl);
    }

    public boolean markTailCalls() {
        StyleElement last = this.getLastChildInstruction();
        return last != null && last.markTailCalls();
    }

    public void compileDeclaration(Compilation compilation, ComponentDeclaration decl) throws XPathException {
        Expression block = this.compileSequenceConstructor(compilation, decl, this.iterateAxis((byte)3), true);
        if (block == null) {
            block = Literal.makeEmptySequence(this);
        }
        this.compiledTemplate.setMatchPattern(this.match);
        this.compiledTemplate.setBody(block);
        this.compiledTemplate.setStackFrameMap(this.stackFrameMap);
        this.compiledTemplate.setSystemId(this.getSystemId());
        this.compiledTemplate.setLineNumber(this.getLineNumber());
        this.compiledTemplate.setHasRequiredParams(this.hasRequiredParams);
        this.compiledTemplate.setRequiredType(this.requiredType);
        this.compiledTemplate.setModeNames(this.modeNames);
        Expression exp = null;
        try {
            exp = this.makeExpressionVisitor().simplify(block);
        }
        catch (XPathException e) {
            this.compileError(e);
        }
        if (this.visibility != Visibility.ABSTRACT) {
            try {
                if (this.requiredType != null) {
                    RoleLocator role = new RoleLocator(7, this.diagnosticId, 0);
                    role.setErrorCode("XTTE0505");
                    exp = TypeChecker.staticTypeCheck(exp, this.requiredType, false, role, this.makeExpressionVisitor());
                }
            }
            catch (XPathException err) {
                this.compileError(err);
            }
        }
        this.compiledTemplate.setBody(exp);
        this.compiledTemplate.setTemplateName(this.getObjectName());
        if (this.getConfiguration().isCompileWithTracing()) {
            if ((exp = XSLTemplate.makeTraceInstruction(this, exp)) instanceof TraceExpression) {
                ((TraceExpression)exp).setProperty("match", this.matchAtt);
                ((TraceExpression)exp).setProperty("mode", this.modeAtt);
            }
            this.compiledTemplate.setBody(exp);
        }
    }

    public void register(ComponentDeclaration declaration) throws XPathException {
        if (this.match != null) {
            StylesheetModule module = declaration.getModule();
            RuleManager mgr = this.getCompilation().getStylesheetPackage().getRuleManager();
            ExpressionVisitor visitor = ExpressionVisitor.make(this.getStaticContext());
            boolean exclusive = this.modeNames.length == 1 && this.getTemplateName() == null;
            for (StructuredQName nc : this.modeNames) {
                Mode mode = mgr.getMode(nc, true);
                Pattern match2 = this.match;
                String typed = mode.getPropertyValue("typed");
                if ("strict".equals(typed) || "lax".equals(typed)) {
                    try {
                        match2 = this.match.convertToTypedPattern(typed);
                    }
                    catch (XPathException e) {
                        e.maybeSetLocation(this);
                        throw e;
                    }
                    if (match2 != this.match) {
                        ContextItemStaticInfo info = new ContextItemStaticInfo(AnyItemType.getInstance(), false);
                        match2.setPackageData(this.match.getPackageData());
                        match2.setOriginalText(this.match.toString());
                        match2.setSystemId(this.match.getSystemId());
                        match2.setLineNumber(this.match.getLineNumber());
                        match2 = match2.analyze(visitor, info);
                    }
                    if (this.modeNames.length == 1) {
                        this.match = match2;
                    }
                }
                mgr.setTemplateRule(match2, this.compiledTemplate, mode, module, this.prioritySpecified ? this.priority : Double.NaN);
                if (!mode.isDeclaredStreamable()) continue;
                this.compiledTemplate.setDeclaredStreamable(true);
            }
        }
    }

    public void allocatePatternSlotNumbers() throws XPathException {
        if (this.match != null) {
            int nextFree = 0;
            if ((this.match.getDependencies() & 1) != 0) {
                nextFree = 1;
            }
            int slots = this.match.allocateSlots(this.getSlotManager(), nextFree);
            RuleManager mgr = this.getCompilation().getStylesheetPackage().getRuleManager();
            for (StructuredQName nc : this.modeNames) {
                Mode mode = mgr.getMode(nc, true);
                mode.allocatePatternSlots(slots);
            }
            this.allocatePatternSlots(slots);
        }
    }

    public void optimize(ComponentDeclaration declaration) throws XPathException {
        ContextItemStaticInfo info;
        Pattern m22;
        Expression exp2;
        ContextItemStaticInfo cit;
        ItemType contextItemType = Type.ITEM_TYPE;
        if (this.getObjectName() == null) {
            contextItemType = this.match.getItemType();
            if (contextItemType.equals(ErrorType.getInstance())) {
                contextItemType = AnyItemType.getInstance();
            }
            cit = new ContextItemStaticInfo(contextItemType, false);
        } else {
            cit = new ContextItemStaticInfo(contextItemType, true);
        }
        Expression exp = this.compiledTemplate.getBody();
        ExpressionTool.resetPropertiesWithinSubtree(exp);
        ExpressionVisitor visitor = this.makeExpressionVisitor();
        visitor.setOptimizeForStreaming(this.compiledTemplate.isDeclaredStreamable());
        Optimizer opt = this.getConfiguration().obtainOptimizer();
        try {
            exp2 = visitor.typeCheck(exp, cit);
            if (opt.getOptimizationLevel() != 0) {
                exp2 = visitor.optimize(exp2, cit);
            }
            if (exp != exp2) {
                this.compiledTemplate.setBody(exp2);
                exp = exp2;
            }
        }
        catch (XPathException e) {
            this.compileError(e);
        }
        if (opt.getOptimizationLevel() != 0 && !this.getConfiguration().isCompileWithTracing() && (exp2 = opt.promoteExpressionsToGlobal(exp, this.getCompilation().getStylesheetPackage(), visitor)) != null) {
            this.compiledTemplate.setBody(visitor.optimize(exp2, cit));
            exp = exp2;
        }
        this.allocateSlots(exp);
        if (this.match != null && (m22 = this.match.analyze(visitor, info = new ContextItemStaticInfo(this.match.getItemType(), false, true))) != this.match) {
            this.match = m22;
            this.compiledTemplate.setMatchPattern(m22);
        }
        opt.checkStreamability(this, this.compiledTemplate);
        if (this.isExplaining()) {
            Logger err = this.getConfiguration().getLogger();
            err.info("Optimized expression tree for template at line " + this.getLineNumber() + " in " + this.getSystemId() + ':');
            exp.explain(err);
        }
    }

    public void generateByteCode(Optimizer opt) throws XPathException {
        if (this.getCompilation().getCompilerInfo().isGenerateByteCode() && !this.isTailRecursive && !this.compiledTemplate.isDeclaredStreamable()) {
            try {
                Expression exp = this.compiledTemplate.getBody();
                Expression cbody = opt.compileToByteCode(exp, this.nameAtt == null ? this.matchAtt : this.nameAtt, 4);
                if (cbody != null) {
                    this.compiledTemplate.setBody(cbody);
                }
            }
            catch (Exception e) {
                System.err.println("Failed while compiling template " + (this.nameAtt == null ? "match='" + this.matchAtt + "'" : this.nameAtt));
                e.printStackTrace();
                throw new XPathException(e);
            }
        }
    }

    public SlotManager getSlotManager() {
        return this.stackFrameMap;
    }

    public Template getCompiledTemplate() {
        return this.compiledTemplate;
    }

    public int getConstructType() {
        return 200;
    }
}

