/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import java.io.IOException;
import java.io.LineNumberReader;
import java.net.URI;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.functions.UnparsedTextFunction;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntPredicate;

public abstract class TextLinesIterator
implements SequenceIterator {
    protected LineNumberReader reader;
    protected IntPredicate checker;
    StringValue current = null;
    int position = 0;
    protected SourceLocator location;
    protected URI uri;

    protected TextLinesIterator() {
    }

    public TextLinesIterator(LineNumberReader reader, SourceLocator location, URI uri, IntPredicate checker) throws XPathException {
        this.reader = reader;
        this.location = location;
        this.uri = uri;
        this.checker = checker;
    }

    public StringValue next() throws XPathException {
        if (this.position < 0) {
            this.close();
            return null;
        }
        try {
            String s2 = this.reader.readLine();
            if (s2 == null) {
                this.current = null;
                this.position = -1;
                this.close();
                return null;
            }
            if (this.position == 0 && s2.startsWith("\ufeff")) {
                s2 = s2.substring(1);
            }
            this.checkLine(this.checker, s2);
            this.current = new StringValue(s2);
            ++this.position;
            return this.current;
        }
        catch (IOException err) {
            this.close();
            XPathException e = UnparsedTextFunction.handleIOError(this.uri, err, null);
            if (this.location != null) {
                e.setLocator(this.location);
            }
            throw e;
        }
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getProperties() {
        return 0;
    }

    private void checkLine(IntPredicate checker, String buffer) throws XPathException {
        int c = 0;
        while (c < buffer.length()) {
            int ch32;
            if (UTF16CharacterSet.isHighSurrogate(ch32 = buffer.charAt(c++))) {
                char low = buffer.charAt(c++);
                ch32 = UTF16CharacterSet.combinePair((char)ch32, low);
            }
            if (checker.matches(ch32)) continue;
            XPathException err = new XPathException("The unparsed-text file contains a character that is illegal in XML (line=" + this.position + " column=" + (c + 1) + " value=hex " + Integer.toHexString(ch32) + ')');
            err.setErrorCode("XTDE1190");
            err.setLocator(this.location);
            throw err;
        }
    }
}

