/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import java.util.ArrayList;
import java.util.Arrays;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.SystemIdMap;
import net.sf.saxon.tree.tiny.AppendableCharSequence;
import net.sf.saxon.tree.tiny.CharSlice;
import net.sf.saxon.tree.tiny.LargeStringBuffer;
import net.sf.saxon.tree.tiny.Statistics;
import net.sf.saxon.tree.tiny.TinyAttributeImpl;
import net.sf.saxon.tree.tiny.TinyCommentImpl;
import net.sf.saxon.tree.tiny.TinyDocumentImpl;
import net.sf.saxon.tree.tiny.TinyElementImpl;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyParentNodeImpl;
import net.sf.saxon.tree.tiny.TinyProcInstImpl;
import net.sf.saxon.tree.tiny.TinyTextImpl;
import net.sf.saxon.tree.tiny.WhitespaceTextImpl;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.z.IntArraySet;

public final class TinyTree
implements LocationProvider {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private Configuration config;
    private ArrayList<TinyDocumentImpl> documentList = new ArrayList(5);
    protected long documentNumber;
    protected AppendableCharSequence charBuffer;
    protected FastStringBuffer commentBuffer = null;
    protected int numberOfNodes = 0;
    public byte[] nodeKind;
    protected short[] depth;
    protected int[] next;
    protected int[] alpha;
    protected int[] beta;
    protected int[] nameCode;
    protected int[] prior = null;
    protected int[] typeCodeArray = null;
    protected AtomicSequence[] typedValueArray = null;
    private boolean allowTypedValueCache = true;
    public static final int TYPECODE_IDREF = 0x20000000;
    protected int numberOfAttributes = 0;
    protected int[] attParent;
    protected int[] attCode;
    protected CharSequence[] attValue;
    protected AtomicSequence[] attTypedValue;
    protected int[] attTypeCode;
    protected int numberOfNamespaces = 0;
    protected int[] namespaceParent;
    protected NamespaceBinding[] namespaceBinding;
    private int[] rootIndex = new int[5];
    protected int rootIndexUsed = 0;
    private int[] lineNumbers = null;
    private int[] columnNumbers = null;
    private SystemIdMap systemIdMap = null;
    protected boolean usesNamespaces = false;
    private boolean writingPriorIndex = false;

    public TinyTree(Configuration config, Statistics statistics) {
        int nodes = (int)statistics.getAverageNodes() + 1;
        int attributes = (int)statistics.getAverageAttributes() + 1;
        int namespaces = (int)statistics.getAverageNamespaces() + 1;
        int characters = (int)statistics.getAverageCharacters() + 1;
        this.nodeKind = new byte[nodes];
        this.depth = new short[nodes];
        this.next = new int[nodes];
        this.alpha = new int[nodes];
        this.beta = new int[nodes];
        this.nameCode = new int[nodes];
        this.numberOfAttributes = 0;
        this.attParent = new int[attributes];
        this.attCode = new int[attributes];
        this.attValue = new String[attributes];
        this.numberOfNamespaces = 0;
        this.namespaceParent = new int[namespaces];
        this.namespaceBinding = new NamespaceBinding[namespaces];
        this.charBuffer = characters > 65000 ? new LargeStringBuffer() : new FastStringBuffer(characters);
        this.setConfiguration(config);
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
        this.allowTypedValueCache = config.isLicensedFeature(1) && config.getBooleanProperty("http://saxon.sf.net/feature/use-typed-value-cache");
        this.addNamespace(0, NamespaceBinding.XML);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    private void ensureNodeCapacity(short kind) {
        if (this.nodeKind.length < this.numberOfNodes + 1) {
            int k = kind == 11 ? this.numberOfNodes + 1 : this.numberOfNodes * 2;
            byte[] nodeKind2 = new byte[k];
            int[] next2 = new int[k];
            short[] depth2 = new short[k];
            int[] alpha2 = new int[k];
            int[] beta2 = new int[k];
            int[] nameCode2 = new int[k];
            System.arraycopy(this.nodeKind, 0, nodeKind2, 0, this.numberOfNodes);
            System.arraycopy(this.next, 0, next2, 0, this.numberOfNodes);
            System.arraycopy(this.depth, 0, depth2, 0, this.numberOfNodes);
            System.arraycopy(this.alpha, 0, alpha2, 0, this.numberOfNodes);
            System.arraycopy(this.beta, 0, beta2, 0, this.numberOfNodes);
            System.arraycopy(this.nameCode, 0, nameCode2, 0, this.numberOfNodes);
            this.nodeKind = nodeKind2;
            this.next = next2;
            this.depth = depth2;
            this.alpha = alpha2;
            this.beta = beta2;
            this.nameCode = nameCode2;
            if (this.typeCodeArray != null) {
                int[] typeCodeArray2 = new int[k];
                System.arraycopy(this.typeCodeArray, 0, typeCodeArray2, 0, this.numberOfNodes);
                this.typeCodeArray = typeCodeArray2;
            }
            if (this.typedValueArray != null) {
                AtomicSequence[] typedValueArray2 = new AtomicSequence[k];
                System.arraycopy(this.typedValueArray, 0, typedValueArray2, 0, this.numberOfNodes);
                this.typedValueArray = typedValueArray2;
            }
            if (this.lineNumbers != null) {
                int[] lines2 = new int[k];
                System.arraycopy(this.lineNumbers, 0, lines2, 0, this.numberOfNodes);
                this.lineNumbers = lines2;
                int[] columns2 = new int[k];
                System.arraycopy(this.columnNumbers, 0, columns2, 0, this.numberOfNodes);
                this.columnNumbers = columns2;
            }
        }
    }

    private void ensureAttributeCapacity() {
        if (this.attParent.length < this.numberOfAttributes + 1) {
            int k = this.numberOfAttributes * 2;
            if (k == 0) {
                k = 10;
            }
            int[] attParent2 = new int[k];
            int[] attCode2 = new int[k];
            String[] attValue2 = new String[k];
            System.arraycopy(this.attParent, 0, attParent2, 0, this.numberOfAttributes);
            System.arraycopy(this.attCode, 0, attCode2, 0, this.numberOfAttributes);
            System.arraycopy(this.attValue, 0, attValue2, 0, this.numberOfAttributes);
            this.attParent = attParent2;
            this.attCode = attCode2;
            this.attValue = attValue2;
            if (this.attTypeCode != null) {
                int[] attTypeCode2 = new int[k];
                System.arraycopy(this.attTypeCode, 0, attTypeCode2, 0, this.numberOfAttributes);
                this.attTypeCode = attTypeCode2;
            }
            if (this.attTypedValue != null) {
                AtomicSequence[] attTypedValue2 = new AtomicSequence[k];
                System.arraycopy(this.attTypedValue, 0, attTypedValue2, 0, this.numberOfAttributes);
                this.attTypedValue = attTypedValue2;
            }
        }
    }

    private void ensureNamespaceCapacity() {
        if (this.namespaceParent.length < this.numberOfNamespaces + 1) {
            int k = this.numberOfNamespaces * 2;
            if (k == 0) {
                k = 10;
            }
            int[] namespaceParent2 = new int[k];
            NamespaceBinding[] namespaceCode2 = new NamespaceBinding[k];
            System.arraycopy(this.namespaceParent, 0, namespaceParent2, 0, this.numberOfNamespaces);
            System.arraycopy(this.namespaceBinding, 0, namespaceCode2, 0, this.numberOfNamespaces);
            this.namespaceParent = namespaceParent2;
            this.namespaceBinding = namespaceCode2;
        }
    }

    int addDocumentNode(TinyDocumentImpl doc) {
        this.documentList.add(doc);
        return this.addNode((short)9, 0, this.documentList.size() - 1, 0, -1);
    }

    int addNode(short kind, int depth, int alpha, int beta, int nameCode) {
        if (this.writingPriorIndex) {
            throw new AssertionError((Object)"Adding new node while writing prior index: see bug 2220");
        }
        this.ensureNodeCapacity(kind);
        this.nodeKind[this.numberOfNodes] = (byte)kind;
        this.depth[this.numberOfNodes] = (short)depth;
        this.alpha[this.numberOfNodes] = alpha;
        this.beta[this.numberOfNodes] = beta;
        this.nameCode[this.numberOfNodes] = nameCode;
        this.next[this.numberOfNodes] = -1;
        if (this.typeCodeArray != null) {
            this.typeCodeArray[this.numberOfNodes] = 630;
        }
        if (this.numberOfNodes == 0) {
            this.documentNumber = this.config.getDocumentNumberAllocator().allocateDocumentNumber();
        }
        if (depth == 0 && kind != 11) {
            if (this.rootIndexUsed == this.rootIndex.length) {
                int[] r2 = new int[this.rootIndexUsed * 2];
                System.arraycopy(this.rootIndex, 0, r2, 0, this.rootIndexUsed);
                this.rootIndex = r2;
            }
            this.rootIndex[this.rootIndexUsed++] = this.numberOfNodes;
        }
        return this.numberOfNodes++;
    }

    void appendChars(CharSequence chars) {
        if (this.charBuffer instanceof FastStringBuffer && this.charBuffer.length() > 65000) {
            LargeStringBuffer lsb = new LargeStringBuffer();
            lsb.append(this.charBuffer);
            this.charBuffer = lsb;
        }
        this.charBuffer.append(chars);
    }

    public int addTextNodeCopy(int depth, int existingNodeNr) {
        return this.addNode((short)3, depth, this.alpha[existingNodeNr], this.beta[existingNodeNr], -1);
    }

    void condense(Statistics statistics) {
        int k;
        if (this.rootIndexUsed > 1) {
            return;
        }
        if (this.numberOfNodes * 3 < this.nodeKind.length || this.nodeKind.length - this.numberOfNodes > 20000) {
            k = this.numberOfNodes + 1;
            byte[] nodeKind2 = new byte[k];
            int[] next2 = new int[k];
            short[] depth2 = new short[k];
            int[] alpha2 = new int[k];
            int[] beta2 = new int[k];
            int[] nameCode2 = new int[k];
            System.arraycopy(this.nodeKind, 0, nodeKind2, 0, this.numberOfNodes);
            System.arraycopy(this.next, 0, next2, 0, this.numberOfNodes);
            System.arraycopy(this.depth, 0, depth2, 0, this.numberOfNodes);
            System.arraycopy(this.alpha, 0, alpha2, 0, this.numberOfNodes);
            System.arraycopy(this.beta, 0, beta2, 0, this.numberOfNodes);
            System.arraycopy(this.nameCode, 0, nameCode2, 0, this.numberOfNodes);
            if (this.typeCodeArray != null) {
                int[] type2 = new int[k];
                System.arraycopy(this.typeCodeArray, 0, type2, 0, this.numberOfNodes);
                this.typeCodeArray = type2;
            }
            if (this.lineNumbers != null) {
                int[] lines2 = new int[k];
                System.arraycopy(this.lineNumbers, 0, lines2, 0, this.numberOfNodes);
                this.lineNumbers = lines2;
                int[] columns2 = new int[k];
                System.arraycopy(this.columnNumbers, 0, columns2, 0, this.numberOfNodes);
                this.columnNumbers = columns2;
            }
            this.nodeKind = nodeKind2;
            this.next = next2;
            this.depth = depth2;
            this.alpha = alpha2;
            this.beta = beta2;
            this.nameCode = nameCode2;
        }
        if (this.numberOfAttributes * 3 < this.attParent.length || this.attParent.length - this.numberOfAttributes > 1000) {
            k = this.numberOfAttributes;
            if (k == 0) {
                this.attParent = IntArraySet.EMPTY_INT_ARRAY;
                this.attCode = IntArraySet.EMPTY_INT_ARRAY;
                this.attValue = EMPTY_STRING_ARRAY;
                this.attTypeCode = null;
            }
            int[] attParent2 = new int[k];
            int[] attCode2 = new int[k];
            String[] attValue2 = new String[k];
            System.arraycopy(this.attParent, 0, attParent2, 0, this.numberOfAttributes);
            System.arraycopy(this.attCode, 0, attCode2, 0, this.numberOfAttributes);
            System.arraycopy(this.attValue, 0, attValue2, 0, this.numberOfAttributes);
            this.attParent = attParent2;
            this.attCode = attCode2;
            this.attValue = attValue2;
            if (this.attTypeCode != null) {
                int[] attTypeCode2 = new int[k];
                System.arraycopy(this.attTypeCode, 0, attTypeCode2, 0, this.numberOfAttributes);
                this.attTypeCode = attTypeCode2;
            }
        }
        if (this.numberOfNamespaces * 3 < this.namespaceParent.length) {
            k = this.numberOfNamespaces;
            int[] namespaceParent2 = new int[k];
            NamespaceBinding[] namespaceCode2 = new NamespaceBinding[k];
            System.arraycopy(this.namespaceParent, 0, namespaceParent2, 0, this.numberOfNamespaces);
            System.arraycopy(this.namespaceBinding, 0, namespaceCode2, 0, this.numberOfNamespaces);
            this.namespaceParent = namespaceParent2;
            this.namespaceBinding = namespaceCode2;
        }
        statistics.updateStatistics(this.numberOfNodes, this.numberOfAttributes, this.numberOfNamespaces, this.charBuffer.length());
    }

    void setElementAnnotation(int nodeNr, int typeCode) {
        if (typeCode != 630) {
            if (this.typeCodeArray == null) {
                this.typeCodeArray = new int[this.nodeKind.length];
                Arrays.fill(this.typeCodeArray, 0, this.nodeKind.length, 630);
            }
            assert (this.typeCodeArray != null);
            this.typeCodeArray[nodeNr] = typeCode;
        }
    }

    public int getTypeAnnotation(int nodeNr) {
        if (this.typeCodeArray == null) {
            return 630;
        }
        return this.typeCodeArray[nodeNr] & 0xFFFFF;
    }

    public AtomicSequence getTypedValueOfElement(TinyElementImpl element) throws XPathException {
        int nodeNr = element.nodeNr;
        if (this.typedValueArray == null || this.typedValueArray[nodeNr] == null) {
            int annotation = this.getTypeAnnotation(nodeNr);
            if (annotation == 630 || annotation == 631 || annotation == 572) {
                CharSequence stringValue = TinyParentNodeImpl.getStringValueCS(this, nodeNr);
                return new UntypedAtomicValue(stringValue);
            }
            if (annotation == 513) {
                CharSequence stringValue = TinyParentNodeImpl.getStringValueCS(this, nodeNr);
                return new StringValue(stringValue);
            }
            if (annotation == 529) {
                CharSequence stringValue = TinyParentNodeImpl.getStringValueCS(this, nodeNr);
                return new AnyURIValue(stringValue);
            }
            SchemaType stype = this.getConfiguration().getSchemaType(annotation);
            if (stype == null) {
                String typeName;
                try {
                    typeName = this.getNamePool().getDisplayName(annotation);
                }
                catch (Exception err) {
                    typeName = annotation + "";
                }
                throw new XPathException("Unknown type annotation " + Err.wrap(typeName) + " in document instance");
            }
            AtomicSequence value = stype.atomize(element);
            if (this.allowTypedValueCache) {
                if (this.typedValueArray == null) {
                    this.typedValueArray = new AtomicSequence[this.nodeKind.length];
                }
                this.typedValueArray[nodeNr] = value;
            }
            return value;
        }
        return this.typedValueArray[nodeNr];
    }

    public AtomicSequence getTypedValueOfElement(int nodeNr) throws XPathException {
        if (this.typedValueArray == null || this.typedValueArray[nodeNr] == null) {
            int annotation = this.getTypeAnnotation(nodeNr);
            if (annotation == 631 || annotation == 630) {
                CharSequence stringValue = TinyParentNodeImpl.getStringValueCS(this, nodeNr);
                return new UntypedAtomicValue(stringValue);
            }
            if (annotation == 513) {
                CharSequence stringValue = TinyParentNodeImpl.getStringValueCS(this, nodeNr);
                return new StringValue(stringValue);
            }
            if (annotation == 529) {
                CharSequence stringValue = TinyParentNodeImpl.getStringValueCS(this, nodeNr);
                return new AnyURIValue(stringValue);
            }
            SchemaType stype = this.getConfiguration().getSchemaType(annotation);
            if (stype == null) {
                String typeName;
                try {
                    typeName = this.getNamePool().getDisplayName(annotation);
                }
                catch (Exception err) {
                    typeName = annotation + "";
                }
                throw new XPathException("Unknown type annotation " + Err.wrap(typeName) + " in document instance");
            }
            TinyElementImpl element = new TinyElementImpl(this, nodeNr);
            AtomicSequence value = stype.atomize(element);
            if (this.allowTypedValueCache) {
                if (this.typedValueArray == null) {
                    this.typedValueArray = new AtomicSequence[this.nodeKind.length];
                }
                this.typedValueArray[nodeNr] = value;
            }
            return value;
        }
        return this.typedValueArray[nodeNr];
    }

    public AtomicSequence getTypedValueOfAttribute(TinyAttributeImpl att, int nodeNr) throws XPathException {
        if (this.attTypeCode == null) {
            return new UntypedAtomicValue(this.attValue[nodeNr]);
        }
        if (this.attTypedValue == null || this.attTypedValue[nodeNr] == null) {
            int annotation = this.getAttributeAnnotation(nodeNr);
            if (annotation == 631) {
                return new UntypedAtomicValue(this.attValue[nodeNr]);
            }
            if (annotation == 513) {
                return new StringValue(this.attValue[nodeNr]);
            }
            if (annotation == 529) {
                return new AnyURIValue(this.attValue[nodeNr]);
            }
            SchemaType stype = this.getConfiguration().getSchemaType(annotation);
            if (stype == null) {
                String typeName;
                try {
                    typeName = this.getNamePool().getDisplayName(annotation);
                }
                catch (Exception err) {
                    typeName = annotation + "";
                }
                throw new XPathException("Unknown attribute type annotation " + Err.wrap(typeName) + " in document instance");
            }
            if (att == null) {
                att = new TinyAttributeImpl(this, nodeNr);
            }
            AtomicSequence value = stype.atomize(att);
            if (this.allowTypedValueCache) {
                if (this.attTypedValue == null) {
                    this.attTypedValue = new AtomicSequence[this.attParent.length];
                }
                this.attTypedValue[nodeNr] = value;
            }
            return value;
        }
        return this.attTypedValue[nodeNr];
    }

    public int getNodeKind(int nodeNr) {
        int kind = this.nodeKind[nodeNr];
        return kind == 4 ? 3 : kind;
    }

    public int getNameCode(int nodeNr) {
        return this.nameCode[nodeNr];
    }

    void ensurePriorIndex() {
        if (this.prior == null || this.prior.length < this.numberOfNodes) {
            this.makePriorIndex();
        }
    }

    private synchronized void makePriorIndex() {
        this.writingPriorIndex = true;
        int[] p = new int[this.numberOfNodes];
        Arrays.fill(p, 0, this.numberOfNodes, -1);
        for (int i = 0; i < this.numberOfNodes; ++i) {
            int nextNode = this.next[i];
            if (nextNode <= i) continue;
            p[nextNode] = i;
        }
        this.prior = p;
        this.writingPriorIndex = false;
    }

    void addAttribute(NodeInfo root, int parent, int nameCode, int typeCode, CharSequence attValue, int properties) {
        this.ensureAttributeCapacity();
        this.attParent[this.numberOfAttributes] = parent;
        this.attCode[this.numberOfAttributes] = nameCode;
        this.attValue[this.numberOfAttributes] = attValue;
        if (typeCode == -1) {
            typeCode = 631;
        }
        if (typeCode != 631) {
            this.initializeAttributeTypeCodes();
        }
        if (this.attTypeCode != null) {
            this.attTypeCode[this.numberOfAttributes] = typeCode;
        }
        if (this.alpha[parent] == -1) {
            this.alpha[parent] = this.numberOfAttributes;
        }
        if (root instanceof TinyDocumentImpl) {
            boolean isID = false;
            if ((properties & 0x800) != 0) {
                isID = true;
            } else if ((nameCode & 0xFFFFF) == 388) {
                isID = true;
            } else if (this.config.getTypeHierarchy().isIdCode(typeCode)) {
                isID = true;
            }
            if (isID) {
                String id = Whitespace.trim(attValue);
                this.attValue[this.numberOfAttributes] = id;
                if (NameChecker.isValidNCName(id)) {
                    TinyNodeImpl e = this.getNode(parent);
                    ((TinyDocumentImpl)root).registerID(e, id);
                } else if (this.attTypeCode != null) {
                    this.attTypeCode[this.numberOfAttributes] = 631;
                }
            }
            if ((properties & 0x1000) != 0) {
                this.initializeAttributeTypeCodes();
                assert (this.attTypeCode != null);
                this.attTypeCode[this.numberOfAttributes] = typeCode | 0x20000000;
            }
        }
        ++this.numberOfAttributes;
    }

    private void initializeAttributeTypeCodes() {
        if (this.attTypeCode == null) {
            this.attTypeCode = new int[this.attParent.length];
            Arrays.fill(this.attTypeCode, 0, this.numberOfAttributes, 631);
        }
    }

    public void indexIDElement(NodeInfo root, int nodeNr) {
        String id = Whitespace.trim(TinyParentNodeImpl.getStringValueCS(this, nodeNr));
        if (root.getNodeKind() == 9 && NameChecker.isValidNCName(id)) {
            TinyNodeImpl e = this.getNode(nodeNr);
            ((TinyDocumentImpl)root).registerID(e, id);
        }
    }

    void addNamespace(int parent, NamespaceBinding binding) {
        this.ensureNamespaceCapacity();
        this.namespaceParent[this.numberOfNamespaces] = parent;
        this.namespaceBinding[this.numberOfNamespaces] = binding;
        if (this.beta[parent] == -1) {
            this.beta[parent] = this.numberOfNamespaces;
        }
        ++this.numberOfNamespaces;
        if (!binding.isXmlNamespace()) {
            this.usesNamespaces = true;
        }
    }

    public final TinyNodeImpl getNode(int nr) {
        switch (this.nodeKind[nr]) {
            case 9: {
                return this.documentList.get(this.alpha[nr]);
            }
            case 1: {
                return new TinyElementImpl(this, nr);
            }
            case 3: {
                return new TinyTextImpl(this, nr);
            }
            case 4: {
                return new WhitespaceTextImpl(this, nr);
            }
            case 8: {
                return new TinyCommentImpl(this, nr);
            }
            case 7: {
                return new TinyProcInstImpl(this, nr);
            }
            case 12: {
                throw new IllegalArgumentException("Attempting to treat a parent pointer as a node");
            }
        }
        throw new IllegalStateException("Unknown node kind");
    }

    AtomicValue getAtomizedValueOfUntypedNode(int nodeNr) {
        switch (this.nodeKind[nodeNr]) {
            case 1: 
            case 9: {
                int next;
                short level = this.depth[nodeNr];
                if (this.depth[next] <= level) {
                    return UntypedAtomicValue.ZERO_LENGTH_UNTYPED;
                }
                if (this.nodeKind[next] == 3 && this.depth[next + 1] <= level) {
                    int length = this.beta[next];
                    int start = this.alpha[next];
                    return new UntypedAtomicValue(this.charBuffer.subSequence(start, start + length));
                }
                if (this.nodeKind[next] == 4 && this.depth[next + 1] <= level) {
                    return new UntypedAtomicValue(WhitespaceTextImpl.getStringValueCS(this, next));
                }
                FastStringBuffer sb = null;
                for (next = nodeNr + 1; next < this.numberOfNodes && this.depth[next] > level; ++next) {
                    if (this.nodeKind[next] == 3) {
                        if (sb == null) {
                            sb = new FastStringBuffer(256);
                        }
                        sb.append(TinyTextImpl.getStringValue(this, next));
                        continue;
                    }
                    if (this.nodeKind[next] != 4) continue;
                    if (sb == null) {
                        sb = new FastStringBuffer(256);
                    }
                    WhitespaceTextImpl.appendStringValue(this, next, sb);
                }
                if (sb == null) {
                    return UntypedAtomicValue.ZERO_LENGTH_UNTYPED;
                }
                return new UntypedAtomicValue(sb.condense());
            }
            case 3: {
                return new UntypedAtomicValue(TinyTextImpl.getStringValue(this, nodeNr));
            }
            case 4: {
                return new UntypedAtomicValue(WhitespaceTextImpl.getStringValueCS(this, nodeNr));
            }
            case 7: 
            case 8: {
                int start2 = this.alpha[nodeNr];
                int len2 = this.beta[nodeNr];
                if (len2 == 0) {
                    return UntypedAtomicValue.ZERO_LENGTH_UNTYPED;
                }
                char[] dest = new char[len2];
                assert (this.commentBuffer != null);
                this.commentBuffer.getChars(start2, start2 + len2, dest, 0);
                return new StringValue(new CharSlice(dest, 0, len2));
            }
        }
        throw new IllegalStateException("Unknown node kind");
    }

    TinyAttributeImpl getAttributeNode(int nr) {
        return new TinyAttributeImpl(this, nr);
    }

    int getAttributeAnnotation(int nr) {
        if (this.attTypeCode == null) {
            return 631;
        }
        return this.attTypeCode[nr] & 0xDFFFFFFF;
    }

    public boolean isIdAttribute(int nr) {
        if (this.attTypeCode == null) {
            return false;
        }
        int tc = this.getAttributeAnnotation(nr);
        if (tc == 631) {
            return false;
        }
        if (tc == 560) {
            return true;
        }
        if (tc < 1024) {
            return false;
        }
        SchemaType type = this.getConfiguration().getSchemaType(tc);
        assert (type != null);
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        if (type.isAtomicType()) {
            return th.isSubType((AtomicType)type, BuiltInAtomicType.ID);
        }
        if (type instanceof ListType) {
            SimpleType itemType = ((ListType)type).getItemType();
            return itemType.isAtomicType() && th.isSubType((AtomicType)itemType, BuiltInAtomicType.ID);
        }
        return false;
    }

    public boolean isIdrefAttribute(int nr) {
        if (this.attTypeCode == null) {
            return false;
        }
        int tc = this.attTypeCode[nr];
        if ((tc & 0x20000000) != 0) {
            return true;
        }
        if (tc == 631) {
            return false;
        }
        if (tc == 561) {
            return true;
        }
        if (tc == 562) {
            return true;
        }
        if (tc < 1024) {
            return false;
        }
        SchemaType type = this.getConfiguration().getSchemaType(tc);
        assert (type != null);
        return type.isIdRefType();
    }

    public boolean isIdElement(int nr) {
        if (this.typeCodeArray == null) {
            return false;
        }
        int tc = this.typeCodeArray[nr];
        return (tc & 0x20000000) != 0 || this.getConfiguration().getTypeHierarchy().isIdCode(tc & 0xFFFFF);
    }

    public boolean isIdrefElement(int nr) {
        if (this.typeCodeArray == null) {
            return false;
        }
        int tc = this.typeCodeArray[nr];
        return (tc & 0x20000000) != 0 || this.getConfiguration().getTypeHierarchy().isIdrefsCode(tc & 0xFFFFF);
    }

    void setSystemId(int seq, String uri) {
        if (uri == null) {
            uri = "";
        }
        if (this.systemIdMap == null) {
            this.systemIdMap = new SystemIdMap();
        }
        this.systemIdMap.setSystemId(seq, uri);
    }

    public String getSystemId(int seq) {
        if (this.systemIdMap == null) {
            return null;
        }
        return this.systemIdMap.getSystemId(seq);
    }

    int getRootNode(int nodeNr) {
        for (int i = this.rootIndexUsed - 1; i >= 0; --i) {
            if (this.rootIndex[i] > nodeNr) continue;
            return this.rootIndex[i];
        }
        return 0;
    }

    public void setLineNumbering() {
        this.lineNumbers = new int[this.nodeKind.length];
        Arrays.fill(this.lineNumbers, -1);
        this.columnNumbers = new int[this.nodeKind.length];
        Arrays.fill(this.columnNumbers, -1);
    }

    void setLineNumber(int sequence, int line, int column) {
        if (this.lineNumbers != null) {
            assert (this.columnNumbers != null);
            this.lineNumbers[sequence] = line;
            this.columnNumbers[sequence] = column;
        }
    }

    public int getLineNumber(int sequence) {
        if (this.lineNumbers != null) {
            for (int i = sequence; i >= 0; --i) {
                int c = this.lineNumbers[i];
                if (c <= 0) continue;
                return c;
            }
        }
        return -1;
    }

    public int getColumnNumber(int sequence) {
        if (this.columnNumbers != null) {
            for (int i = sequence; i >= 0; --i) {
                int c = this.columnNumbers[sequence];
                if (c <= 0) continue;
                return c;
            }
        }
        return -1;
    }

    public long getDocumentNumber() {
        return this.documentNumber;
    }

    public boolean isNilled(int nodeNr) {
        return this.typeCodeArray != null && (this.typeCodeArray[nodeNr] & 0x20000000) != 0;
    }

    public void diagnosticDump() {
        int i;
        NamePool pool = this.config.getNamePool();
        System.err.println("    node    kind   depth    next   alpha    beta    name    type");
        for (i = 0; i < this.numberOfNodes; ++i) {
            System.err.println(TinyTree.n8(i) + TinyTree.n8(this.nodeKind[i]) + TinyTree.n8(this.depth[i]) + TinyTree.n8(this.next[i]) + TinyTree.n8(this.alpha[i]) + TinyTree.n8(this.beta[i]) + TinyTree.n8(this.nameCode[i]) + TinyTree.n8(this.getTypeAnnotation(i)) + (this.nameCode[i] == -1 ? "" : " " + pool.getDisplayName(this.nameCode[i])));
        }
        System.err.println("    attr  parent    name    value");
        for (i = 0; i < this.numberOfAttributes; ++i) {
            System.err.println(TinyTree.n8(i) + TinyTree.n8(this.attParent[i]) + TinyTree.n8(this.attCode[i]) + "    " + this.attValue[i]);
        }
        System.err.println("      ns  parent  prefix     uri");
        for (i = 0; i < this.numberOfNamespaces; ++i) {
            System.err.println(TinyTree.n8(i) + TinyTree.n8(this.namespaceParent[i]) + this.namespaceBinding[i].getPrefix() + "=" + this.namespaceBinding[i].getURI());
        }
    }

    public static synchronized void diagnosticDump(NodeInfo node) {
        if (node instanceof TinyNodeImpl) {
            TinyTree tree = ((TinyNodeImpl)node).tree;
            System.err.println("Tree containing node " + ((TinyNodeImpl)node).nodeNr);
            tree.diagnosticDump();
        } else {
            System.err.println("Node is not in a TinyTree");
        }
    }

    private static String n8(int val) {
        String s2 = "        " + val;
        return s2.substring(s2.length() - 8);
    }

    public void showSize() {
        System.err.println("Tree size: " + this.numberOfNodes + " nodes, " + this.charBuffer.length() + " characters, " + this.numberOfAttributes + " attributes");
    }

    public int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public int getNumberOfAttributes() {
        return this.numberOfAttributes;
    }

    public int getNumberOfNamespaces() {
        return this.numberOfNamespaces;
    }

    public byte[] getNodeKindArray() {
        return this.nodeKind;
    }

    public short[] getNodeDepthArray() {
        return this.depth;
    }

    public int[] getNameCodeArray() {
        return this.nameCode;
    }

    public int[] getTypeCodeArray() {
        return this.typeCodeArray;
    }

    public int[] getNextPointerArray() {
        return this.next;
    }

    public int[] getAlphaArray() {
        return this.alpha;
    }

    public int[] getBetaArray() {
        return this.beta;
    }

    public AppendableCharSequence getCharacterBuffer() {
        return this.charBuffer;
    }

    public CharSequence getCommentBuffer() {
        return this.commentBuffer;
    }

    public int[] getAttributeNameCodeArray() {
        return this.attCode;
    }

    public int[] getAttributeTypeCodeArray() {
        return this.attTypeCode;
    }

    public int[] getAttributeParentArray() {
        return this.attParent;
    }

    public CharSequence[] getAttributeValueArray() {
        return this.attValue;
    }

    public NamespaceBinding[] getNamespaceBindings() {
        return this.namespaceBinding;
    }

    public int[] getNamespaceParentArray() {
        return this.namespaceParent;
    }
}

