/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LOOKUPSWITCH;
import org.apache.bcel.generic.Select;
import org.apache.bcel.generic.TABLESWITCH;

public final class SWITCH
implements CompoundInstruction {
    private int[] match;
    private InstructionHandle[] targets;
    private Select instruction;
    private int matchLength;

    public SWITCH(int[] match, InstructionHandle[] targets, InstructionHandle target, int max_gap) {
        this.match = (int[])match.clone();
        this.targets = (InstructionHandle[])targets.clone();
        this.matchLength = match.length;
        if (this.matchLength < 2) {
            this.instruction = new TABLESWITCH(match, targets, target);
        } else {
            this.sort(0, this.matchLength - 1);
            if (this.matchIsOrdered(max_gap)) {
                this.fillup(max_gap, target);
                this.instruction = new TABLESWITCH(this.match, this.targets, target);
            } else {
                this.instruction = new LOOKUPSWITCH(this.match, this.targets, target);
            }
        }
    }

    public SWITCH(int[] match, InstructionHandle[] targets, InstructionHandle target) {
        this(match, targets, target, 1);
    }

    private void fillup(int max_gap, InstructionHandle target) {
        int max_size = this.matchLength + this.matchLength * max_gap;
        int[] m_vec = new int[max_size];
        InstructionHandle[] t_vec = new InstructionHandle[max_size];
        int count = 1;
        m_vec[0] = this.match[0];
        t_vec[0] = this.targets[0];
        for (int i = 1; i < this.matchLength; ++i) {
            int prev = this.match[i - 1];
            int gap = this.match[i] - prev;
            for (int j = 1; j < gap; ++j) {
                m_vec[count] = prev + j;
                t_vec[count] = target;
                ++count;
            }
            m_vec[count] = this.match[i];
            t_vec[count] = this.targets[i];
            ++count;
        }
        this.match = new int[count];
        this.targets = new InstructionHandle[count];
        System.arraycopy(m_vec, 0, this.match, 0, count);
        System.arraycopy(t_vec, 0, this.targets, 0, count);
    }

    private void sort(int l, int r) {
        int i = l;
        int j = r;
        int m3 = this.match[l + r >>> 1];
        while (true) {
            if (this.match[i] < m3) {
                ++i;
                continue;
            }
            while (m3 < this.match[j]) {
                --j;
            }
            if (i <= j) {
                int h2 = this.match[i];
                this.match[i] = this.match[j];
                this.match[j] = h2;
                InstructionHandle h22 = this.targets[i];
                this.targets[i] = this.targets[j];
                this.targets[j] = h22;
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (l < j) {
            this.sort(l, j);
        }
        if (i < r) {
            this.sort(i, r);
        }
    }

    private boolean matchIsOrdered(int max_gap) {
        for (int i = 1; i < this.matchLength; ++i) {
            if (this.match[i] - this.match[i - 1] <= max_gap) continue;
            return false;
        }
        return true;
    }

    @Override
    public InstructionList getInstructionList() {
        return new InstructionList(this.instruction);
    }

    public Instruction getInstruction() {
        return this.instruction;
    }
}

