/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.metadata;

import org.apache.maven.artifact.ArtifactScopeEnum;
import org.apache.maven.repository.metadata.ArtifactMetadata;

public class MetadataGraphVertex
implements Comparable<MetadataGraphVertex> {
    ArtifactMetadata md;
    private boolean compareVersion = false;
    private boolean compareScope = false;

    public MetadataGraphVertex(ArtifactMetadata md) {
        this.md = md;
    }

    public MetadataGraphVertex(ArtifactMetadata md, boolean compareVersion, boolean compareScope) {
        this(md);
        this.compareVersion = compareVersion;
        this.compareScope = compareScope;
    }

    public ArtifactMetadata getMd() {
        return this.md;
    }

    public void setMd(ArtifactMetadata md) {
        this.md = md;
    }

    public boolean isCompareVersion() {
        return this.compareVersion;
    }

    public void setCompareVersion(boolean compareVersion) {
        this.compareVersion = compareVersion;
    }

    public boolean isCompareScope() {
        return this.compareScope;
    }

    public void setCompareScope(boolean compareScope) {
        this.compareScope = compareScope;
    }

    public String toString() {
        return "[" + (this.md == null ? "no metadata" : this.md.toString()) + "]";
    }

    private static int compareStrings(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    @Override
    public int compareTo(MetadataGraphVertex vertex) {
        if (vertex == null || vertex.getMd() == null) {
            return 1;
        }
        ArtifactMetadata vmd = vertex.getMd();
        if (vmd == null) {
            if (this.md == null) {
                return 0;
            }
            return 1;
        }
        int g2 = MetadataGraphVertex.compareStrings(this.md.groupId, vmd.groupId);
        if (g2 == 0) {
            int a = MetadataGraphVertex.compareStrings(this.md.artifactId, vmd.artifactId);
            if (a == 0) {
                if (this.compareVersion) {
                    int v = MetadataGraphVertex.compareStrings(this.md.version, vmd.version);
                    if (v == 0) {
                        if (this.compareScope) {
                            String s1 = ArtifactScopeEnum.checkScope(this.md.artifactScope).getScope();
                            String s2 = ArtifactScopeEnum.checkScope(vmd.artifactScope).getScope();
                            return s1.compareTo(s2);
                        }
                        return 0;
                    }
                    return v;
                }
                return 0;
            }
            return a;
        }
        return g2;
    }

    public boolean equals(Object vo) {
        if (vo == null || !(vo instanceof MetadataGraphVertex)) {
            return false;
        }
        return this.compareTo((MetadataGraphVertex)vo) == 0;
    }

    public int hashCode() {
        if (this.md == null) {
            return super.hashCode();
        }
        StringBuilder hashString = new StringBuilder(128);
        hashString.append(this.md.groupId).append('|');
        hashString.append(this.md.artifactId).append('|');
        if (this.compareVersion) {
            hashString.append(this.md.version).append('|');
        }
        if (this.compareScope) {
            hashString.append((Object)this.md.getArtifactScope()).append('|');
        }
        return hashString.toString().hashCode();
    }
}

