/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Interface Declarations                                                     *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace mlir {
namespace omp {
class OutlineableOpenMPOpInterface;
namespace detail {
struct OutlineableOpenMPOpInterfaceInterfaceTraits {
  struct Concept {
    /// The methods defined by the interface.
    ::mlir::Block*(*getAllocaBlock)(const Concept *impl, ::mlir::Operation *);
  };
  template<typename ConcreteOp>
  class Model : public Concept {
  public:
    using Interface = ::mlir::omp::OutlineableOpenMPOpInterface;
    Model() : Concept{getAllocaBlock} {}

    static inline ::mlir::Block*getAllocaBlock(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
  };
  template<typename ConcreteOp>
  class FallbackModel : public Concept {
  public:
    using Interface = ::mlir::omp::OutlineableOpenMPOpInterface;
    FallbackModel() : Concept{getAllocaBlock} {}

    static inline ::mlir::Block*getAllocaBlock(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
  };
  template<typename ConcreteModel, typename ConcreteOp>
  class ExternalModel : public FallbackModel<ConcreteModel> {
  public:
    using ConcreteEntity = ConcreteOp;
  };
};template <typename ConcreteOp>
struct OutlineableOpenMPOpInterfaceTrait;

} // namespace detail
class OutlineableOpenMPOpInterface : public ::mlir::OpInterface<OutlineableOpenMPOpInterface, detail::OutlineableOpenMPOpInterfaceInterfaceTraits> {
public:
  using ::mlir::OpInterface<OutlineableOpenMPOpInterface, detail::OutlineableOpenMPOpInterfaceInterfaceTraits>::OpInterface;
  template <typename ConcreteOp>
  struct Trait : public detail::OutlineableOpenMPOpInterfaceTrait<ConcreteOp> {};
  /// Get alloca block
  ::mlir::Block*getAllocaBlock();
};
namespace detail {
  template <typename ConcreteOp>
  struct OutlineableOpenMPOpInterfaceTrait : public ::mlir::OpInterface<OutlineableOpenMPOpInterface, detail::OutlineableOpenMPOpInterfaceInterfaceTraits>::Trait<ConcreteOp> {
  };
}// namespace detail
} // namespace omp
} // namespace mlir
namespace mlir {
namespace omp {
class ReductionClauseInterface;
namespace detail {
struct ReductionClauseInterfaceInterfaceTraits {
  struct Concept {
    /// The methods defined by the interface.
    ::mlir::SmallVector<::mlir::Value> (*getAllReductionVars)(const Concept *impl, ::mlir::Operation *);
  };
  template<typename ConcreteOp>
  class Model : public Concept {
  public:
    using Interface = ::mlir::omp::ReductionClauseInterface;
    Model() : Concept{getAllReductionVars} {}

    static inline ::mlir::SmallVector<::mlir::Value> getAllReductionVars(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
  };
  template<typename ConcreteOp>
  class FallbackModel : public Concept {
  public:
    using Interface = ::mlir::omp::ReductionClauseInterface;
    FallbackModel() : Concept{getAllReductionVars} {}

    static inline ::mlir::SmallVector<::mlir::Value> getAllReductionVars(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
  };
  template<typename ConcreteModel, typename ConcreteOp>
  class ExternalModel : public FallbackModel<ConcreteModel> {
  public:
    using ConcreteEntity = ConcreteOp;
    ::mlir::SmallVector<::mlir::Value> getAllReductionVars(::mlir::Operation *tablegen_opaque_val) const;
  };
};template <typename ConcreteOp>
struct ReductionClauseInterfaceTrait;

} // namespace detail
class ReductionClauseInterface : public ::mlir::OpInterface<ReductionClauseInterface, detail::ReductionClauseInterfaceInterfaceTraits> {
public:
  using ::mlir::OpInterface<ReductionClauseInterface, detail::ReductionClauseInterfaceInterfaceTraits>::OpInterface;
  template <typename ConcreteOp>
  struct Trait : public detail::ReductionClauseInterfaceTrait<ConcreteOp> {};
  /// Get reduction vars
  ::mlir::SmallVector<::mlir::Value> getAllReductionVars();
};
namespace detail {
  template <typename ConcreteOp>
  struct ReductionClauseInterfaceTrait : public ::mlir::OpInterface<ReductionClauseInterface, detail::ReductionClauseInterfaceInterfaceTraits>::Trait<ConcreteOp> {
    /// Get reduction vars
    ::mlir::SmallVector<::mlir::Value> getAllReductionVars() {
      return (*static_cast<ConcreteOp *>(this)).getReductionVars();
    }
  };
}// namespace detail
} // namespace omp
} // namespace mlir
namespace mlir {
namespace omp {
class DeclareTargetInterface;
namespace detail {
struct DeclareTargetInterfaceInterfaceTraits {
  struct Concept {
    /// The methods defined by the interface.
    void (*setDeclareTarget)(const Concept *impl, ::mlir::Operation *, mlir::omp::DeclareTargetDeviceType, mlir::omp::DeclareTargetCaptureClause);
    bool (*isDeclareTarget)(const Concept *impl, ::mlir::Operation *);
    mlir::omp::DeclareTargetDeviceType (*getDeclareTargetDeviceType)(const Concept *impl, ::mlir::Operation *);
    mlir::omp::DeclareTargetCaptureClause (*getDeclareTargetCaptureClause)(const Concept *impl, ::mlir::Operation *);
  };
  template<typename ConcreteOp>
  class Model : public Concept {
  public:
    using Interface = ::mlir::omp::DeclareTargetInterface;
    Model() : Concept{setDeclareTarget, isDeclareTarget, getDeclareTargetDeviceType, getDeclareTargetCaptureClause} {}

    static inline void setDeclareTarget(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, mlir::omp::DeclareTargetDeviceType deviceType, mlir::omp::DeclareTargetCaptureClause captureClause);
    static inline bool isDeclareTarget(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline mlir::omp::DeclareTargetDeviceType getDeclareTargetDeviceType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline mlir::omp::DeclareTargetCaptureClause getDeclareTargetCaptureClause(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
  };
  template<typename ConcreteOp>
  class FallbackModel : public Concept {
  public:
    using Interface = ::mlir::omp::DeclareTargetInterface;
    FallbackModel() : Concept{setDeclareTarget, isDeclareTarget, getDeclareTargetDeviceType, getDeclareTargetCaptureClause} {}

    static inline void setDeclareTarget(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, mlir::omp::DeclareTargetDeviceType deviceType, mlir::omp::DeclareTargetCaptureClause captureClause);
    static inline bool isDeclareTarget(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline mlir::omp::DeclareTargetDeviceType getDeclareTargetDeviceType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline mlir::omp::DeclareTargetCaptureClause getDeclareTargetCaptureClause(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
  };
  template<typename ConcreteModel, typename ConcreteOp>
  class ExternalModel : public FallbackModel<ConcreteModel> {
  public:
    using ConcreteEntity = ConcreteOp;
    void setDeclareTarget(::mlir::Operation *tablegen_opaque_val, mlir::omp::DeclareTargetDeviceType deviceType, mlir::omp::DeclareTargetCaptureClause captureClause) const;
    bool isDeclareTarget(::mlir::Operation *tablegen_opaque_val) const;
    mlir::omp::DeclareTargetDeviceType getDeclareTargetDeviceType(::mlir::Operation *tablegen_opaque_val) const;
    mlir::omp::DeclareTargetCaptureClause getDeclareTargetCaptureClause(::mlir::Operation *tablegen_opaque_val) const;
  };
};template <typename ConcreteOp>
struct DeclareTargetInterfaceTrait;

} // namespace detail
class DeclareTargetInterface : public ::mlir::OpInterface<DeclareTargetInterface, detail::DeclareTargetInterfaceInterfaceTraits> {
public:
  using ::mlir::OpInterface<DeclareTargetInterface, detail::DeclareTargetInterfaceInterfaceTraits>::OpInterface;
  template <typename ConcreteOp>
  struct Trait : public detail::DeclareTargetInterfaceTrait<ConcreteOp> {};
  /// Set the declare target attribute on the current operation with the
  /// specified attribute arguments.
  void setDeclareTarget(mlir::omp::DeclareTargetDeviceType deviceType, mlir::omp::DeclareTargetCaptureClause captureClause);
  /// Checks if the declare target attribute has been applied and exists on the
  /// current operation. Returns true if it exists on it, otherwise returns
  /// false.
  bool isDeclareTarget();
  /// Returns the DeclareTargetDeviceType segment of the DeclareTarget attribute if it
  /// exists on the current operation. Otherwise it returns null.
  mlir::omp::DeclareTargetDeviceType getDeclareTargetDeviceType();
  /// Returns the DeclareTargetCaptureClause segment of the DeclareTarget attribute if it
  /// exists on the current operation. Otherwise it returns null.
  mlir::omp::DeclareTargetCaptureClause getDeclareTargetCaptureClause();
};
namespace detail {
  template <typename ConcreteOp>
  struct DeclareTargetInterfaceTrait : public ::mlir::OpInterface<DeclareTargetInterface, detail::DeclareTargetInterfaceInterfaceTraits>::Trait<ConcreteOp> {
    /// Set the declare target attribute on the current operation with the
    /// specified attribute arguments.
    void setDeclareTarget(mlir::omp::DeclareTargetDeviceType deviceType, mlir::omp::DeclareTargetCaptureClause captureClause) {
      (*static_cast<ConcreteOp *>(this))->setAttr("omp.declare_target",
                  mlir::omp::DeclareTargetAttr::get(
                      (*static_cast<ConcreteOp *>(this))->getContext(),
                      mlir::omp::DeclareTargetDeviceTypeAttr::get(
                          (*static_cast<ConcreteOp *>(this))->getContext(), deviceType),
                      mlir::omp::DeclareTargetCaptureClauseAttr::get(
                          (*static_cast<ConcreteOp *>(this))->getContext(), captureClause)));
    }
    /// Checks if the declare target attribute has been applied and exists on the
    /// current operation. Returns true if it exists on it, otherwise returns
    /// false.
    bool isDeclareTarget() {
      return (*static_cast<ConcreteOp *>(this))->hasAttr("omp.declare_target");
    }
    /// Returns the DeclareTargetDeviceType segment of the DeclareTarget attribute if it
    /// exists on the current operation. Otherwise it returns null.
    mlir::omp::DeclareTargetDeviceType getDeclareTargetDeviceType() {
      if (mlir::Attribute dTar = (*static_cast<ConcreteOp *>(this))->getAttr("omp.declare_target"))
          if (auto dAttr = llvm::dyn_cast_or_null<mlir::omp::DeclareTargetAttr>(dTar))
            return dAttr.getDeviceType().getValue();
        return {};
    }
    /// Returns the DeclareTargetCaptureClause segment of the DeclareTarget attribute if it
    /// exists on the current operation. Otherwise it returns null.
    mlir::omp::DeclareTargetCaptureClause getDeclareTargetCaptureClause() {
      if (mlir::Attribute dTar = (*static_cast<ConcreteOp *>(this))->getAttr("omp.declare_target"))
          if (auto dAttr = llvm::dyn_cast_or_null<mlir::omp::DeclareTargetAttr>(dTar))
            return dAttr.getCaptureClause().getValue();
        return {};
    }
  };
}// namespace detail
} // namespace omp
} // namespace mlir
namespace mlir {
namespace omp {
class OffloadModuleInterface;
namespace detail {
struct OffloadModuleInterfaceInterfaceTraits {
  struct Concept {
    /// The methods defined by the interface.
    void (*setIsTargetDevice)(const Concept *impl, ::mlir::Operation *, bool);
    bool (*getIsTargetDevice)(const Concept *impl, ::mlir::Operation *);
    void (*setIsGPU)(const Concept *impl, ::mlir::Operation *, bool);
    bool (*getIsGPU)(const Concept *impl, ::mlir::Operation *);
    mlir::omp::FlagsAttr (*getFlags)(const Concept *impl, ::mlir::Operation *);
    void (*setFlags)(const Concept *impl, ::mlir::Operation *, uint32_t, bool, bool, bool, bool, uint32_t, bool);
    mlir::omp::TargetAttr (*getTarget)(const Concept *impl, ::mlir::Operation *);
    void (*setTarget)(const Concept *impl, ::mlir::Operation *, llvm::StringRef, llvm::StringRef);
    void (*setHostIRFilePath)(const Concept *impl, ::mlir::Operation *, std::string);
    llvm::StringRef (*getHostIRFilePath)(const Concept *impl, ::mlir::Operation *);
    ::mlir::omp::ClauseRequires (*getRequires)(const Concept *impl, ::mlir::Operation *);
    void (*setRequires)(const Concept *impl, ::mlir::Operation *, ::mlir::omp::ClauseRequires);
  };
  template<typename ConcreteOp>
  class Model : public Concept {
  public:
    using Interface = ::mlir::omp::OffloadModuleInterface;
    Model() : Concept{setIsTargetDevice, getIsTargetDevice, setIsGPU, getIsGPU, getFlags, setFlags, getTarget, setTarget, setHostIRFilePath, getHostIRFilePath, getRequires, setRequires} {}

    static inline void setIsTargetDevice(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, bool isTargetDevice);
    static inline bool getIsTargetDevice(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline void setIsGPU(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, bool isGPU);
    static inline bool getIsGPU(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline mlir::omp::FlagsAttr getFlags(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline void setFlags(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, uint32_t debugKind, bool assumeTeamsOversubscription, bool assumeThreadsOversubscription, bool assumeNoThreadState, bool assumeNoNestedParallelism, uint32_t openmpDeviceVersion, bool noGPULib);
    static inline mlir::omp::TargetAttr getTarget(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline void setTarget(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, llvm::StringRef targetCPU, llvm::StringRef targetFeatures);
    static inline void setHostIRFilePath(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, std::string hostIRFilePath);
    static inline llvm::StringRef getHostIRFilePath(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline ::mlir::omp::ClauseRequires getRequires(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline void setRequires(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, ::mlir::omp::ClauseRequires clauses);
  };
  template<typename ConcreteOp>
  class FallbackModel : public Concept {
  public:
    using Interface = ::mlir::omp::OffloadModuleInterface;
    FallbackModel() : Concept{setIsTargetDevice, getIsTargetDevice, setIsGPU, getIsGPU, getFlags, setFlags, getTarget, setTarget, setHostIRFilePath, getHostIRFilePath, getRequires, setRequires} {}

    static inline void setIsTargetDevice(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, bool isTargetDevice);
    static inline bool getIsTargetDevice(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline void setIsGPU(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, bool isGPU);
    static inline bool getIsGPU(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline mlir::omp::FlagsAttr getFlags(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline void setFlags(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, uint32_t debugKind, bool assumeTeamsOversubscription, bool assumeThreadsOversubscription, bool assumeNoThreadState, bool assumeNoNestedParallelism, uint32_t openmpDeviceVersion, bool noGPULib);
    static inline mlir::omp::TargetAttr getTarget(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline void setTarget(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, llvm::StringRef targetCPU, llvm::StringRef targetFeatures);
    static inline void setHostIRFilePath(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, std::string hostIRFilePath);
    static inline llvm::StringRef getHostIRFilePath(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline ::mlir::omp::ClauseRequires getRequires(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline void setRequires(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, ::mlir::omp::ClauseRequires clauses);
  };
  template<typename ConcreteModel, typename ConcreteOp>
  class ExternalModel : public FallbackModel<ConcreteModel> {
  public:
    using ConcreteEntity = ConcreteOp;
    void setIsTargetDevice(::mlir::Operation *tablegen_opaque_val, bool isTargetDevice) const;
    bool getIsTargetDevice(::mlir::Operation *tablegen_opaque_val) const;
    void setIsGPU(::mlir::Operation *tablegen_opaque_val, bool isGPU) const;
    bool getIsGPU(::mlir::Operation *tablegen_opaque_val) const;
    mlir::omp::FlagsAttr getFlags(::mlir::Operation *tablegen_opaque_val) const;
    void setFlags(::mlir::Operation *tablegen_opaque_val, uint32_t debugKind, bool assumeTeamsOversubscription, bool assumeThreadsOversubscription, bool assumeNoThreadState, bool assumeNoNestedParallelism, uint32_t openmpDeviceVersion, bool noGPULib) const;
    mlir::omp::TargetAttr getTarget(::mlir::Operation *tablegen_opaque_val) const;
    void setTarget(::mlir::Operation *tablegen_opaque_val, llvm::StringRef targetCPU, llvm::StringRef targetFeatures) const;
    void setHostIRFilePath(::mlir::Operation *tablegen_opaque_val, std::string hostIRFilePath) const;
    llvm::StringRef getHostIRFilePath(::mlir::Operation *tablegen_opaque_val) const;
    ::mlir::omp::ClauseRequires getRequires(::mlir::Operation *tablegen_opaque_val) const;
    void setRequires(::mlir::Operation *tablegen_opaque_val, ::mlir::omp::ClauseRequires clauses) const;
  };
};template <typename ConcreteOp>
struct OffloadModuleInterfaceTrait;

} // namespace detail
class OffloadModuleInterface : public ::mlir::OpInterface<OffloadModuleInterface, detail::OffloadModuleInterfaceInterfaceTraits> {
public:
  using ::mlir::OpInterface<OffloadModuleInterface, detail::OffloadModuleInterfaceInterfaceTraits>::OpInterface;
  template <typename ConcreteOp>
  struct Trait : public detail::OffloadModuleInterfaceTrait<ConcreteOp> {};
  /// Set the attribute on the current module with the specified boolean
  /// argument.
  void setIsTargetDevice(bool isTargetDevice);
  /// Get the attribute on the current module if it exists and
  /// return its value, if it doesn't exist it returns false by default.
  bool getIsTargetDevice();
  /// Set the attribute on the current module with the specified boolean
  /// argument.
  void setIsGPU(bool isGPU);
  /// Get the attribute on the current module if it exists and
  /// return its value, if it doesn't exist it returns false by default.
  bool getIsGPU();
  /// Get the FlagsAttr attribute on the current module if it exists
  /// and return the attribute, if it doesn't exit it returns a nullptr
  mlir::omp::FlagsAttr getFlags();
  /// Apply an omp.FlagsAttr to a module with the specified values
  /// for the flags
  void setFlags(uint32_t debugKind, bool assumeTeamsOversubscription, bool assumeThreadsOversubscription, bool assumeNoThreadState, bool assumeNoNestedParallelism, uint32_t openmpDeviceVersion, bool noGPULib);
  /// Get the Target attribute on the current module if it exists
  /// and return the attribute, if it doesn't exist it returns a nullptr.
  mlir::omp::TargetAttr getTarget();
  /// Set the attribute target on the current module with the
  /// specified string arguments - name of cpu and corresponding features.
  void setTarget(llvm::StringRef targetCPU, llvm::StringRef targetFeatures);
  /// Set a StringAttr on the current module containing the host IR file path. This
  /// file path is used in two-phase compilation during the device phase to generate
  /// device side LLVM IR when lowering MLIR.
  void setHostIRFilePath(std::string hostIRFilePath);
  /// Find the host-ir file path StringAttr from the current module if it exists and
  /// return its contained value, if it doesn't exist it returns an empty string. This
  /// file path is used in two-phase compilation during the device phase to generate
  /// device side LLVM IR when lowering MLIR.
  llvm::StringRef getHostIRFilePath();
  /// Get the omp.requires attribute on the operator if it's present and
  /// return its value. If it doesn't exist, return `ClauseRequires::none` by
  /// default.
  ::mlir::omp::ClauseRequires getRequires();
  /// Set the omp.requires attribute on the operator to the specified clauses.
  void setRequires(::mlir::omp::ClauseRequires clauses);
};
namespace detail {
  template <typename ConcreteOp>
  struct OffloadModuleInterfaceTrait : public ::mlir::OpInterface<OffloadModuleInterface, detail::OffloadModuleInterfaceInterfaceTraits>::Trait<ConcreteOp> {
    /// Set the attribute on the current module with the specified boolean
    /// argument.
    void setIsTargetDevice(bool isTargetDevice) {
      (*static_cast<ConcreteOp *>(this))->setAttr(
          mlir::StringAttr::get((*static_cast<ConcreteOp *>(this))->getContext(), llvm::Twine{"omp.is_target_device"}),
            mlir::BoolAttr::get((*static_cast<ConcreteOp *>(this))->getContext(), isTargetDevice));
    }
    /// Get the attribute on the current module if it exists and
    /// return its value, if it doesn't exist it returns false by default.
    bool getIsTargetDevice() {
      if (Attribute isTargetDevice = (*static_cast<ConcreteOp *>(this))->getAttr("omp.is_target_device"))
          if (isTargetDevice.isa<mlir::BoolAttr>())
           return isTargetDevice.dyn_cast<BoolAttr>().getValue();
        return false;
    }
    /// Set the attribute on the current module with the specified boolean
    /// argument.
    void setIsGPU(bool isGPU) {
      (*static_cast<ConcreteOp *>(this))->setAttr(
          mlir::StringAttr::get((*static_cast<ConcreteOp *>(this))->getContext(), "omp.is_gpu"),
            mlir::BoolAttr::get((*static_cast<ConcreteOp *>(this))->getContext(), isGPU));
    }
    /// Get the attribute on the current module if it exists and
    /// return its value, if it doesn't exist it returns false by default.
    bool getIsGPU() {
      if (Attribute isTargetCGAttr = (*static_cast<ConcreteOp *>(this))->getAttr("omp.is_gpu"))
          if (auto isTargetCGVal = isTargetCGAttr.dyn_cast<BoolAttr>())
           return isTargetCGVal.getValue();
        return false;
    }
    /// Get the FlagsAttr attribute on the current module if it exists
    /// and return the attribute, if it doesn't exit it returns a nullptr
    mlir::omp::FlagsAttr getFlags() {
      if (Attribute flags = (*static_cast<ConcreteOp *>(this))->getAttr("omp.flags"))
          return ::llvm::dyn_cast_or_null<mlir::omp::FlagsAttr>(flags);
        return nullptr;
    }
    /// Apply an omp.FlagsAttr to a module with the specified values
    /// for the flags
    void setFlags(uint32_t debugKind, bool assumeTeamsOversubscription, bool assumeThreadsOversubscription, bool assumeNoThreadState, bool assumeNoNestedParallelism, uint32_t openmpDeviceVersion, bool noGPULib) {
      (*static_cast<ConcreteOp *>(this))->setAttr(("omp." + mlir::omp::FlagsAttr::getMnemonic()).str(),
                  mlir::omp::FlagsAttr::get((*static_cast<ConcreteOp *>(this))->getContext(), debugKind,
                      assumeTeamsOversubscription, assumeThreadsOversubscription,
                      assumeNoThreadState, assumeNoNestedParallelism, noGPULib, openmpDeviceVersion));
    }
    /// Get the Target attribute on the current module if it exists
    /// and return the attribute, if it doesn't exist it returns a nullptr.
    mlir::omp::TargetAttr getTarget() {
      if (Attribute flags = (*static_cast<ConcreteOp *>(this))->getAttr("omp.target"))
          return ::llvm::dyn_cast_or_null<mlir::omp::TargetAttr>(flags);
        return nullptr;
    }
    /// Set the attribute target on the current module with the
    /// specified string arguments - name of cpu and corresponding features.
    void setTarget(llvm::StringRef targetCPU, llvm::StringRef targetFeatures) {
      if (targetCPU.empty())
          return;
        (*static_cast<ConcreteOp *>(this))->setAttr(("omp." + mlir::omp::TargetAttr::getMnemonic()).str(),
                  mlir::omp::TargetAttr::get((*static_cast<ConcreteOp *>(this))->getContext(),
                                             targetCPU.str(),
                                             targetFeatures.str()));
    }
    /// Set a StringAttr on the current module containing the host IR file path. This
    /// file path is used in two-phase compilation during the device phase to generate
    /// device side LLVM IR when lowering MLIR.
    void setHostIRFilePath(std::string hostIRFilePath) {
      (*static_cast<ConcreteOp *>(this))->setAttr(
          mlir::StringAttr::get((*static_cast<ConcreteOp *>(this))->getContext(), llvm::Twine{"omp.host_ir_filepath"}),
            mlir::StringAttr::get((*static_cast<ConcreteOp *>(this))->getContext(), hostIRFilePath));
    }
    /// Find the host-ir file path StringAttr from the current module if it exists and
    /// return its contained value, if it doesn't exist it returns an empty string. This
    /// file path is used in two-phase compilation during the device phase to generate
    /// device side LLVM IR when lowering MLIR.
    llvm::StringRef getHostIRFilePath() {
      if (Attribute filepath = (*static_cast<ConcreteOp *>(this))->getAttr("omp.host_ir_filepath"))
          if (::llvm::isa<mlir::StringAttr>(filepath))
            return ::llvm::dyn_cast<mlir::StringAttr>(filepath).getValue();
        return {};
    }
    /// Get the omp.requires attribute on the operator if it's present and
    /// return its value. If it doesn't exist, return `ClauseRequires::none` by
    /// default.
    ::mlir::omp::ClauseRequires getRequires() {
      if (Attribute requiresAttr = (*static_cast<ConcreteOp *>(this))->getAttr("omp.requires"))
          if (auto requiresVal = requiresAttr.dyn_cast<mlir::omp::ClauseRequiresAttr>())
            return requiresVal.getValue();
        return mlir::omp::ClauseRequires::none;
    }
    /// Set the omp.requires attribute on the operator to the specified clauses.
    void setRequires(::mlir::omp::ClauseRequires clauses) {
      (*static_cast<ConcreteOp *>(this))->setAttr(mlir::StringAttr::get((*static_cast<ConcreteOp *>(this))->getContext(), "omp.requires"),
          mlir::omp::ClauseRequiresAttr::get((*static_cast<ConcreteOp *>(this))->getContext(), clauses));
    }
  };
}// namespace detail
} // namespace omp
} // namespace mlir
namespace mlir {
namespace omp {
class EarlyOutliningInterface;
namespace detail {
struct EarlyOutliningInterfaceInterfaceTraits {
  struct Concept {
    /// The methods defined by the interface.
    void (*setParentName)(const Concept *impl, ::mlir::Operation *, std::string);
    llvm::StringRef (*getParentName)(const Concept *impl, ::mlir::Operation *);
  };
  template<typename ConcreteOp>
  class Model : public Concept {
  public:
    using Interface = ::mlir::omp::EarlyOutliningInterface;
    Model() : Concept{setParentName, getParentName} {}

    static inline void setParentName(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, std::string parentName);
    static inline llvm::StringRef getParentName(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
  };
  template<typename ConcreteOp>
  class FallbackModel : public Concept {
  public:
    using Interface = ::mlir::omp::EarlyOutliningInterface;
    FallbackModel() : Concept{setParentName, getParentName} {}

    static inline void setParentName(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, std::string parentName);
    static inline llvm::StringRef getParentName(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
  };
  template<typename ConcreteModel, typename ConcreteOp>
  class ExternalModel : public FallbackModel<ConcreteModel> {
  public:
    using ConcreteEntity = ConcreteOp;
    void setParentName(::mlir::Operation *tablegen_opaque_val, std::string parentName) const;
    llvm::StringRef getParentName(::mlir::Operation *tablegen_opaque_val) const;
  };
};template <typename ConcreteOp>
struct EarlyOutliningInterfaceTrait;

} // namespace detail
class EarlyOutliningInterface : public ::mlir::OpInterface<EarlyOutliningInterface, detail::EarlyOutliningInterfaceInterfaceTraits> {
public:
  using ::mlir::OpInterface<EarlyOutliningInterface, detail::EarlyOutliningInterfaceInterfaceTraits>::OpInterface;
  template <typename ConcreteOp>
  struct Trait : public detail::EarlyOutliningInterfaceTrait<ConcreteOp> {};
  /// Set a StringAttr on an outlined target region function containing the
  /// name of the parent function where the target region was outlined
  /// from. The parent name is used to construct the kernel names for target
  /// regions.
  void setParentName(std::string parentName);
  /// Returns the parent function name from where the target op was outlined
  /// from. If it doesn't exist it returns an empty string.
  llvm::StringRef getParentName();
};
namespace detail {
  template <typename ConcreteOp>
  struct EarlyOutliningInterfaceTrait : public ::mlir::OpInterface<EarlyOutliningInterface, detail::EarlyOutliningInterfaceInterfaceTraits>::Trait<ConcreteOp> {
    /// Set a StringAttr on an outlined target region function containing the
    /// name of the parent function where the target region was outlined
    /// from. The parent name is used to construct the kernel names for target
    /// regions.
    void setParentName(std::string parentName) {
      (*static_cast<ConcreteOp *>(this))->setAttr(
          mlir::StringAttr::get((*static_cast<ConcreteOp *>(this))->getContext(),
                                llvm::Twine{"omp.outline_parent_name"}),
          mlir::StringAttr::get((*static_cast<ConcreteOp *>(this))->getContext(), parentName));
    }
    /// Returns the parent function name from where the target op was outlined
    /// from. If it doesn't exist it returns an empty string.
    llvm::StringRef getParentName() {
      if (Attribute parentName = (*static_cast<ConcreteOp *>(this))->getAttr("omp.outline_parent_name"))
          if (::llvm::isa<mlir::StringAttr>(parentName))
            return ::llvm::dyn_cast<mlir::StringAttr>(parentName).getValue();
        return {};
    }
  };
}// namespace detail
} // namespace omp
} // namespace mlir
namespace mlir {
namespace omp {
template<typename ConcreteOp>
::mlir::Block*detail::OutlineableOpenMPOpInterfaceInterfaceTraits::Model<ConcreteOp>::getAllocaBlock(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return &(llvm::cast<ConcreteOp>(tablegen_opaque_val)).getRegion().front();
}
template<typename ConcreteOp>
::mlir::Block*detail::OutlineableOpenMPOpInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getAllocaBlock(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getAllocaBlock(tablegen_opaque_val);
}
} // namespace omp
} // namespace mlir
namespace mlir {
namespace omp {
template<typename ConcreteOp>
::mlir::SmallVector<::mlir::Value> detail::ReductionClauseInterfaceInterfaceTraits::Model<ConcreteOp>::getAllReductionVars(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getAllReductionVars();
}
template<typename ConcreteOp>
::mlir::SmallVector<::mlir::Value> detail::ReductionClauseInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getAllReductionVars(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getAllReductionVars(tablegen_opaque_val);
}
template<typename ConcreteModel, typename ConcreteOp>
::mlir::SmallVector<::mlir::Value> detail::ReductionClauseInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::getAllReductionVars(::mlir::Operation *tablegen_opaque_val) const {
return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getReductionVars();
}
} // namespace omp
} // namespace mlir
namespace mlir {
namespace omp {
template<typename ConcreteOp>
void detail::DeclareTargetInterfaceInterfaceTraits::Model<ConcreteOp>::setDeclareTarget(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, mlir::omp::DeclareTargetDeviceType deviceType, mlir::omp::DeclareTargetCaptureClause captureClause) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).setDeclareTarget(deviceType, captureClause);
}
template<typename ConcreteOp>
bool detail::DeclareTargetInterfaceInterfaceTraits::Model<ConcreteOp>::isDeclareTarget(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).isDeclareTarget();
}
template<typename ConcreteOp>
mlir::omp::DeclareTargetDeviceType detail::DeclareTargetInterfaceInterfaceTraits::Model<ConcreteOp>::getDeclareTargetDeviceType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getDeclareTargetDeviceType();
}
template<typename ConcreteOp>
mlir::omp::DeclareTargetCaptureClause detail::DeclareTargetInterfaceInterfaceTraits::Model<ConcreteOp>::getDeclareTargetCaptureClause(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getDeclareTargetCaptureClause();
}
template<typename ConcreteOp>
void detail::DeclareTargetInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::setDeclareTarget(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, mlir::omp::DeclareTargetDeviceType deviceType, mlir::omp::DeclareTargetCaptureClause captureClause) {
  return static_cast<const ConcreteOp *>(impl)->setDeclareTarget(tablegen_opaque_val, deviceType, captureClause);
}
template<typename ConcreteOp>
bool detail::DeclareTargetInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::isDeclareTarget(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->isDeclareTarget(tablegen_opaque_val);
}
template<typename ConcreteOp>
mlir::omp::DeclareTargetDeviceType detail::DeclareTargetInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getDeclareTargetDeviceType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getDeclareTargetDeviceType(tablegen_opaque_val);
}
template<typename ConcreteOp>
mlir::omp::DeclareTargetCaptureClause detail::DeclareTargetInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getDeclareTargetCaptureClause(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getDeclareTargetCaptureClause(tablegen_opaque_val);
}
template<typename ConcreteModel, typename ConcreteOp>
void detail::DeclareTargetInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::setDeclareTarget(::mlir::Operation *tablegen_opaque_val, mlir::omp::DeclareTargetDeviceType deviceType, mlir::omp::DeclareTargetCaptureClause captureClause) const {
(llvm::cast<ConcreteOp>(tablegen_opaque_val))->setAttr("omp.declare_target",
                  mlir::omp::DeclareTargetAttr::get(
                      (llvm::cast<ConcreteOp>(tablegen_opaque_val))->getContext(),
                      mlir::omp::DeclareTargetDeviceTypeAttr::get(
                          (llvm::cast<ConcreteOp>(tablegen_opaque_val))->getContext(), deviceType),
                      mlir::omp::DeclareTargetCaptureClauseAttr::get(
                          (llvm::cast<ConcreteOp>(tablegen_opaque_val))->getContext(), captureClause)));
}
template<typename ConcreteModel, typename ConcreteOp>
bool detail::DeclareTargetInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::isDeclareTarget(::mlir::Operation *tablegen_opaque_val) const {
return (llvm::cast<ConcreteOp>(tablegen_opaque_val))->hasAttr("omp.declare_target");
}
template<typename ConcreteModel, typename ConcreteOp>
mlir::omp::DeclareTargetDeviceType detail::DeclareTargetInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::getDeclareTargetDeviceType(::mlir::Operation *tablegen_opaque_val) const {
if (mlir::Attribute dTar = (llvm::cast<ConcreteOp>(tablegen_opaque_val))->getAttr("omp.declare_target"))
          if (auto dAttr = llvm::dyn_cast_or_null<mlir::omp::DeclareTargetAttr>(dTar))
            return dAttr.getDeviceType().getValue();
        return {};
}
template<typename ConcreteModel, typename ConcreteOp>
mlir::omp::DeclareTargetCaptureClause detail::DeclareTargetInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::getDeclareTargetCaptureClause(::mlir::Operation *tablegen_opaque_val) const {
if (mlir::Attribute dTar = (llvm::cast<ConcreteOp>(tablegen_opaque_val))->getAttr("omp.declare_target"))
          if (auto dAttr = llvm::dyn_cast_or_null<mlir::omp::DeclareTargetAttr>(dTar))
            return dAttr.getCaptureClause().getValue();
        return {};
}
} // namespace omp
} // namespace mlir
namespace mlir {
namespace omp {
template<typename ConcreteOp>
void detail::OffloadModuleInterfaceInterfaceTraits::Model<ConcreteOp>::setIsTargetDevice(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, bool isTargetDevice) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).setIsTargetDevice(isTargetDevice);
}
template<typename ConcreteOp>
bool detail::OffloadModuleInterfaceInterfaceTraits::Model<ConcreteOp>::getIsTargetDevice(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getIsTargetDevice();
}
template<typename ConcreteOp>
void detail::OffloadModuleInterfaceInterfaceTraits::Model<ConcreteOp>::setIsGPU(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, bool isGPU) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).setIsGPU(isGPU);
}
template<typename ConcreteOp>
bool detail::OffloadModuleInterfaceInterfaceTraits::Model<ConcreteOp>::getIsGPU(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getIsGPU();
}
template<typename ConcreteOp>
mlir::omp::FlagsAttr detail::OffloadModuleInterfaceInterfaceTraits::Model<ConcreteOp>::getFlags(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getFlags();
}
template<typename ConcreteOp>
void detail::OffloadModuleInterfaceInterfaceTraits::Model<ConcreteOp>::setFlags(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, uint32_t debugKind, bool assumeTeamsOversubscription, bool assumeThreadsOversubscription, bool assumeNoThreadState, bool assumeNoNestedParallelism, uint32_t openmpDeviceVersion, bool noGPULib) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).setFlags(debugKind, assumeTeamsOversubscription, assumeThreadsOversubscription, assumeNoThreadState, assumeNoNestedParallelism, openmpDeviceVersion, noGPULib);
}
template<typename ConcreteOp>
mlir::omp::TargetAttr detail::OffloadModuleInterfaceInterfaceTraits::Model<ConcreteOp>::getTarget(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getTarget();
}
template<typename ConcreteOp>
void detail::OffloadModuleInterfaceInterfaceTraits::Model<ConcreteOp>::setTarget(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, llvm::StringRef targetCPU, llvm::StringRef targetFeatures) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).setTarget(targetCPU, targetFeatures);
}
template<typename ConcreteOp>
void detail::OffloadModuleInterfaceInterfaceTraits::Model<ConcreteOp>::setHostIRFilePath(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, std::string hostIRFilePath) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).setHostIRFilePath(hostIRFilePath);
}
template<typename ConcreteOp>
llvm::StringRef detail::OffloadModuleInterfaceInterfaceTraits::Model<ConcreteOp>::getHostIRFilePath(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getHostIRFilePath();
}
template<typename ConcreteOp>
::mlir::omp::ClauseRequires detail::OffloadModuleInterfaceInterfaceTraits::Model<ConcreteOp>::getRequires(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getRequires();
}
template<typename ConcreteOp>
void detail::OffloadModuleInterfaceInterfaceTraits::Model<ConcreteOp>::setRequires(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, ::mlir::omp::ClauseRequires clauses) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).setRequires(clauses);
}
template<typename ConcreteOp>
void detail::OffloadModuleInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::setIsTargetDevice(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, bool isTargetDevice) {
  return static_cast<const ConcreteOp *>(impl)->setIsTargetDevice(tablegen_opaque_val, isTargetDevice);
}
template<typename ConcreteOp>
bool detail::OffloadModuleInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getIsTargetDevice(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getIsTargetDevice(tablegen_opaque_val);
}
template<typename ConcreteOp>
void detail::OffloadModuleInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::setIsGPU(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, bool isGPU) {
  return static_cast<const ConcreteOp *>(impl)->setIsGPU(tablegen_opaque_val, isGPU);
}
template<typename ConcreteOp>
bool detail::OffloadModuleInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getIsGPU(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getIsGPU(tablegen_opaque_val);
}
template<typename ConcreteOp>
mlir::omp::FlagsAttr detail::OffloadModuleInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getFlags(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getFlags(tablegen_opaque_val);
}
template<typename ConcreteOp>
void detail::OffloadModuleInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::setFlags(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, uint32_t debugKind, bool assumeTeamsOversubscription, bool assumeThreadsOversubscription, bool assumeNoThreadState, bool assumeNoNestedParallelism, uint32_t openmpDeviceVersion, bool noGPULib) {
  return static_cast<const ConcreteOp *>(impl)->setFlags(tablegen_opaque_val, debugKind, assumeTeamsOversubscription, assumeThreadsOversubscription, assumeNoThreadState, assumeNoNestedParallelism, openmpDeviceVersion, noGPULib);
}
template<typename ConcreteOp>
mlir::omp::TargetAttr detail::OffloadModuleInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getTarget(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getTarget(tablegen_opaque_val);
}
template<typename ConcreteOp>
void detail::OffloadModuleInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::setTarget(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, llvm::StringRef targetCPU, llvm::StringRef targetFeatures) {
  return static_cast<const ConcreteOp *>(impl)->setTarget(tablegen_opaque_val, targetCPU, targetFeatures);
}
template<typename ConcreteOp>
void detail::OffloadModuleInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::setHostIRFilePath(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, std::string hostIRFilePath) {
  return static_cast<const ConcreteOp *>(impl)->setHostIRFilePath(tablegen_opaque_val, hostIRFilePath);
}
template<typename ConcreteOp>
llvm::StringRef detail::OffloadModuleInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getHostIRFilePath(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getHostIRFilePath(tablegen_opaque_val);
}
template<typename ConcreteOp>
::mlir::omp::ClauseRequires detail::OffloadModuleInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getRequires(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getRequires(tablegen_opaque_val);
}
template<typename ConcreteOp>
void detail::OffloadModuleInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::setRequires(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, ::mlir::omp::ClauseRequires clauses) {
  return static_cast<const ConcreteOp *>(impl)->setRequires(tablegen_opaque_val, clauses);
}
template<typename ConcreteModel, typename ConcreteOp>
void detail::OffloadModuleInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::setIsTargetDevice(::mlir::Operation *tablegen_opaque_val, bool isTargetDevice) const {
(llvm::cast<ConcreteOp>(tablegen_opaque_val))->setAttr(
          mlir::StringAttr::get((llvm::cast<ConcreteOp>(tablegen_opaque_val))->getContext(), llvm::Twine{"omp.is_target_device"}),
            mlir::BoolAttr::get((llvm::cast<ConcreteOp>(tablegen_opaque_val))->getContext(), isTargetDevice));
}
template<typename ConcreteModel, typename ConcreteOp>
bool detail::OffloadModuleInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::getIsTargetDevice(::mlir::Operation *tablegen_opaque_val) const {
if (Attribute isTargetDevice = (llvm::cast<ConcreteOp>(tablegen_opaque_val))->getAttr("omp.is_target_device"))
          if (isTargetDevice.isa<mlir::BoolAttr>())
           return isTargetDevice.dyn_cast<BoolAttr>().getValue();
        return false;
}
template<typename ConcreteModel, typename ConcreteOp>
void detail::OffloadModuleInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::setIsGPU(::mlir::Operation *tablegen_opaque_val, bool isGPU) const {
(llvm::cast<ConcreteOp>(tablegen_opaque_val))->setAttr(
          mlir::StringAttr::get((llvm::cast<ConcreteOp>(tablegen_opaque_val))->getContext(), "omp.is_gpu"),
            mlir::BoolAttr::get((llvm::cast<ConcreteOp>(tablegen_opaque_val))->getContext(), isGPU));
}
template<typename ConcreteModel, typename ConcreteOp>
bool detail::OffloadModuleInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::getIsGPU(::mlir::Operation *tablegen_opaque_val) const {
if (Attribute isTargetCGAttr = (llvm::cast<ConcreteOp>(tablegen_opaque_val))->getAttr("omp.is_gpu"))
          if (auto isTargetCGVal = isTargetCGAttr.dyn_cast<BoolAttr>())
           return isTargetCGVal.getValue();
        return false;
}
template<typename ConcreteModel, typename ConcreteOp>
mlir::omp::FlagsAttr detail::OffloadModuleInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::getFlags(::mlir::Operation *tablegen_opaque_val) const {
if (Attribute flags = (llvm::cast<ConcreteOp>(tablegen_opaque_val))->getAttr("omp.flags"))
          return ::llvm::dyn_cast_or_null<mlir::omp::FlagsAttr>(flags);
        return nullptr;
}
template<typename ConcreteModel, typename ConcreteOp>
void detail::OffloadModuleInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::setFlags(::mlir::Operation *tablegen_opaque_val, uint32_t debugKind, bool assumeTeamsOversubscription, bool assumeThreadsOversubscription, bool assumeNoThreadState, bool assumeNoNestedParallelism, uint32_t openmpDeviceVersion, bool noGPULib) const {
(llvm::cast<ConcreteOp>(tablegen_opaque_val))->setAttr(("omp." + mlir::omp::FlagsAttr::getMnemonic()).str(),
                  mlir::omp::FlagsAttr::get((llvm::cast<ConcreteOp>(tablegen_opaque_val))->getContext(), debugKind,
                      assumeTeamsOversubscription, assumeThreadsOversubscription,
                      assumeNoThreadState, assumeNoNestedParallelism, noGPULib, openmpDeviceVersion));
}
template<typename ConcreteModel, typename ConcreteOp>
mlir::omp::TargetAttr detail::OffloadModuleInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::getTarget(::mlir::Operation *tablegen_opaque_val) const {
if (Attribute flags = (llvm::cast<ConcreteOp>(tablegen_opaque_val))->getAttr("omp.target"))
          return ::llvm::dyn_cast_or_null<mlir::omp::TargetAttr>(flags);
        return nullptr;
}
template<typename ConcreteModel, typename ConcreteOp>
void detail::OffloadModuleInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::setTarget(::mlir::Operation *tablegen_opaque_val, llvm::StringRef targetCPU, llvm::StringRef targetFeatures) const {
if (targetCPU.empty())
          return;
        (llvm::cast<ConcreteOp>(tablegen_opaque_val))->setAttr(("omp." + mlir::omp::TargetAttr::getMnemonic()).str(),
                  mlir::omp::TargetAttr::get((llvm::cast<ConcreteOp>(tablegen_opaque_val))->getContext(),
                                             targetCPU.str(),
                                             targetFeatures.str()));
}
template<typename ConcreteModel, typename ConcreteOp>
void detail::OffloadModuleInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::setHostIRFilePath(::mlir::Operation *tablegen_opaque_val, std::string hostIRFilePath) const {
(llvm::cast<ConcreteOp>(tablegen_opaque_val))->setAttr(
          mlir::StringAttr::get((llvm::cast<ConcreteOp>(tablegen_opaque_val))->getContext(), llvm::Twine{"omp.host_ir_filepath"}),
            mlir::StringAttr::get((llvm::cast<ConcreteOp>(tablegen_opaque_val))->getContext(), hostIRFilePath));
}
template<typename ConcreteModel, typename ConcreteOp>
llvm::StringRef detail::OffloadModuleInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::getHostIRFilePath(::mlir::Operation *tablegen_opaque_val) const {
if (Attribute filepath = (llvm::cast<ConcreteOp>(tablegen_opaque_val))->getAttr("omp.host_ir_filepath"))
          if (::llvm::isa<mlir::StringAttr>(filepath))
            return ::llvm::dyn_cast<mlir::StringAttr>(filepath).getValue();
        return {};
}
template<typename ConcreteModel, typename ConcreteOp>
::mlir::omp::ClauseRequires detail::OffloadModuleInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::getRequires(::mlir::Operation *tablegen_opaque_val) const {
if (Attribute requiresAttr = (llvm::cast<ConcreteOp>(tablegen_opaque_val))->getAttr("omp.requires"))
          if (auto requiresVal = requiresAttr.dyn_cast<mlir::omp::ClauseRequiresAttr>())
            return requiresVal.getValue();
        return mlir::omp::ClauseRequires::none;
}
template<typename ConcreteModel, typename ConcreteOp>
void detail::OffloadModuleInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::setRequires(::mlir::Operation *tablegen_opaque_val, ::mlir::omp::ClauseRequires clauses) const {
(llvm::cast<ConcreteOp>(tablegen_opaque_val))->setAttr(mlir::StringAttr::get((llvm::cast<ConcreteOp>(tablegen_opaque_val))->getContext(), "omp.requires"),
          mlir::omp::ClauseRequiresAttr::get((llvm::cast<ConcreteOp>(tablegen_opaque_val))->getContext(), clauses));
}
} // namespace omp
} // namespace mlir
namespace mlir {
namespace omp {
template<typename ConcreteOp>
void detail::EarlyOutliningInterfaceInterfaceTraits::Model<ConcreteOp>::setParentName(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, std::string parentName) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).setParentName(parentName);
}
template<typename ConcreteOp>
llvm::StringRef detail::EarlyOutliningInterfaceInterfaceTraits::Model<ConcreteOp>::getParentName(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getParentName();
}
template<typename ConcreteOp>
void detail::EarlyOutliningInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::setParentName(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, std::string parentName) {
  return static_cast<const ConcreteOp *>(impl)->setParentName(tablegen_opaque_val, parentName);
}
template<typename ConcreteOp>
llvm::StringRef detail::EarlyOutliningInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getParentName(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getParentName(tablegen_opaque_val);
}
template<typename ConcreteModel, typename ConcreteOp>
void detail::EarlyOutliningInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::setParentName(::mlir::Operation *tablegen_opaque_val, std::string parentName) const {
(llvm::cast<ConcreteOp>(tablegen_opaque_val))->setAttr(
          mlir::StringAttr::get((llvm::cast<ConcreteOp>(tablegen_opaque_val))->getContext(),
                                llvm::Twine{"omp.outline_parent_name"}),
          mlir::StringAttr::get((llvm::cast<ConcreteOp>(tablegen_opaque_val))->getContext(), parentName));
}
template<typename ConcreteModel, typename ConcreteOp>
llvm::StringRef detail::EarlyOutliningInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::getParentName(::mlir::Operation *tablegen_opaque_val) const {
if (Attribute parentName = (llvm::cast<ConcreteOp>(tablegen_opaque_val))->getAttr("omp.outline_parent_name"))
          if (::llvm::isa<mlir::StringAttr>(parentName))
            return ::llvm::dyn_cast<mlir::StringAttr>(parentName).getValue();
        return {};
}
} // namespace omp
} // namespace mlir
