
# Autogenerated by mlir-tblgen; don't manually edit.

from ._ods_common import _cext as _ods_cext
from ._ods_common import (
    SubClassValueT as _SubClassValueT,
    equally_sized_accessor as _ods_equally_sized_accessor,
    get_default_loc_context as _ods_get_default_loc_context,
    get_op_result_or_op_results as _get_op_result_or_op_results,
    get_op_result_or_value as _get_op_result_or_value,
    get_op_results_or_values as _get_op_results_or_values,
    segmented_accessor as _ods_segmented_accessor,
)
_ods_ir = _ods_cext.ir

import builtins
from typing import Sequence as _Sequence, Union as _Union


@_ods_cext.register_dialect
class _Dialect(_ods_ir.Dialect):
  DIALECT_NAMESPACE = "gpu"
  pass


@_ods_cext.register_operation(_Dialect)
class AllReduceOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.all_reduce"

  _ODS_REGIONS = (1, True)

  def __init__(self, value, *, op=None, uniform=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(value))
    _ods_context = _ods_get_default_loc_context(loc)
    if op is not None: attributes["op"] = (op if (
        issubclass(type(op), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('GPU_AllReduceOperationAttr')) else
          _ods_ir.AttrBuilder.get('GPU_AllReduceOperationAttr')(op, context=_ods_context))
    if bool(uniform): attributes["uniform"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def value(self):
    return self.operation.operands[0]

  @builtins.property
  def op(self):
    if "op" not in self.operation.attributes:
      return None
    return self.operation.attributes["op"]

  @op.setter
  def op(self, value):
    if value is not None:
      self.operation.attributes["op"] = value
    elif "op" in self.operation.attributes:
      del self.operation.attributes["op"]

  @op.deleter
  def op(self):
    del self.operation.attributes["op"]

  @builtins.property
  def uniform(self):
    return "uniform" in self.operation.attributes

  @uniform.setter
  def uniform(self, value):
    if bool(value):
      self.operation.attributes["uniform"] = _ods_ir.UnitAttr.get()
    elif "uniform" in self.operation.attributes:
      del self.operation.attributes["uniform"]

  @uniform.deleter
  def uniform(self):
    del self.operation.attributes["uniform"]

  @builtins.property
  def result(self):
    return self.operation.results[0]

  @builtins.property
  def body(self):
    return self.regions[0]

def all_reduce(value, *, op=None, uniform=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(AllReduceOp(value=value, op=op, uniform=uniform, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AllocOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.alloc"

  _ODS_OPERAND_SEGMENTS = [-1,-1,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, memref, asyncToken, asyncDependencies, dynamicSizes, symbolOperands, *, hostShared=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(asyncDependencies))
    operands.append(_get_op_results_or_values(dynamicSizes))
    operands.append(_get_op_results_or_values(symbolOperands))
    _ods_context = _ods_get_default_loc_context(loc)
    if bool(hostShared): attributes["hostShared"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    results.append(memref)
    if asyncToken is not None: results.append(asyncToken)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def asyncDependencies(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def dynamicSizes(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def symbolOperands(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def hostShared(self):
    return "hostShared" in self.operation.attributes

  @hostShared.setter
  def hostShared(self, value):
    if bool(value):
      self.operation.attributes["hostShared"] = _ods_ir.UnitAttr.get()
    elif "hostShared" in self.operation.attributes:
      del self.operation.attributes["hostShared"]

  @hostShared.deleter
  def hostShared(self):
    del self.operation.attributes["hostShared"]

  @builtins.property
  def memref(self):
    return self.operation.results[0]

  @builtins.property
  def asyncToken(self):
    return None if len(self.operation.results) < 2 else self.operation.results[1]

def alloc(memref, async_token, async_dependencies, dynamic_sizes, symbol_operands, *, host_shared=None, loc=None, ip=None) -> _Sequence[_SubClassValueT]:
  return _get_op_result_or_op_results(AllocOp(memref=memref, asyncToken=async_token, asyncDependencies=async_dependencies, dynamicSizes=dynamic_sizes, symbolOperands=symbol_operands, hostShared=host_shared, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class BarrierOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.barrier"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

def barrier(*, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(BarrierOp(loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class BinaryOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.binary"

  _ODS_REGIONS = (0, True)

  def __init__(self, sym_name, objects, *, offloadingHandler=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    issubclass(type(sym_name), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    if offloadingHandler is not None: attributes["offloadingHandler"] = (offloadingHandler if (
        issubclass(type(offloadingHandler), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('AnyAttr')) else
          _ods_ir.AttrBuilder.get('AnyAttr')(offloadingHandler, context=_ods_context))
    attributes["objects"] = (objects if (
    issubclass(type(objects), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('GPUObjectArrayAttr')) else
      _ods_ir.AttrBuilder.get('GPUObjectArrayAttr')(objects, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def offloadingHandler(self):
    if "offloadingHandler" not in self.operation.attributes:
      return None
    return self.operation.attributes["offloadingHandler"]

  @offloadingHandler.setter
  def offloadingHandler(self, value):
    if value is not None:
      self.operation.attributes["offloadingHandler"] = value
    elif "offloadingHandler" in self.operation.attributes:
      del self.operation.attributes["offloadingHandler"]

  @offloadingHandler.deleter
  def offloadingHandler(self):
    del self.operation.attributes["offloadingHandler"]

  @builtins.property
  def objects(self):
    return self.operation.attributes["objects"]

  @objects.setter
  def objects(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["objects"] = value

def binary(sym_name, objects, *, offloading_handler=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(BinaryOp(sym_name=sym_name, objects=objects, offloadingHandler=offloading_handler, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class BlockDimOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.block_dim"

  _ODS_REGIONS = (0, True)

  def __init__(self, dimension, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dimension"] = (dimension if (
    issubclass(type(dimension), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('GPU_DimensionAttr')) else
      _ods_ir.AttrBuilder.get('GPU_DimensionAttr')(dimension, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def dimension(self):
    return self.operation.attributes["dimension"]

  @dimension.setter
  def dimension(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dimension"] = value

def block_dim(dimension, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(BlockDimOp(dimension=dimension, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class BlockIdOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.block_id"

  _ODS_REGIONS = (0, True)

  def __init__(self, dimension, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dimension"] = (dimension if (
    issubclass(type(dimension), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('GPU_DimensionAttr')) else
      _ods_ir.AttrBuilder.get('GPU_DimensionAttr')(dimension, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def dimension(self):
    return self.operation.attributes["dimension"]

  @dimension.setter
  def dimension(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dimension"] = value

def block_id(dimension, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(BlockIdOp(dimension=dimension, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ClusterDimOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.cluster_dim"

  _ODS_REGIONS = (0, True)

  def __init__(self, dimension, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dimension"] = (dimension if (
    issubclass(type(dimension), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('GPU_DimensionAttr')) else
      _ods_ir.AttrBuilder.get('GPU_DimensionAttr')(dimension, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def dimension(self):
    return self.operation.attributes["dimension"]

  @dimension.setter
  def dimension(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dimension"] = value

def cluster_dim(dimension, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(ClusterDimOp(dimension=dimension, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ClusterIdOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.cluster_id"

  _ODS_REGIONS = (0, True)

  def __init__(self, dimension, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dimension"] = (dimension if (
    issubclass(type(dimension), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('GPU_DimensionAttr')) else
      _ods_ir.AttrBuilder.get('GPU_DimensionAttr')(dimension, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def dimension(self):
    return self.operation.attributes["dimension"]

  @dimension.setter
  def dimension(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dimension"] = value

def cluster_id(dimension, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(ClusterIdOp(dimension=dimension, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class Create2To4SpMatOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.create_2to4_spmat"

  _ODS_REGIONS = (0, True)

  def __init__(self, spMat, asyncToken, asyncDependencies, rows, cols, memref, *, pruneFlag=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(asyncDependencies))
    operands.append(_get_op_result_or_value(rows))
    operands.append(_get_op_result_or_value(cols))
    operands.append(_get_op_result_or_value(memref))
    _ods_context = _ods_get_default_loc_context(loc)
    if pruneFlag is not None: attributes["pruneFlag"] = (pruneFlag if (
        issubclass(type(pruneFlag), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('GPU_Prune2To4SpMatFlagAttr')) else
          _ods_ir.AttrBuilder.get('GPU_Prune2To4SpMatFlagAttr')(pruneFlag, context=_ods_context))
    results.append(spMat)
    if asyncToken is not None: results.append(asyncToken)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def asyncDependencies(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def rows(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[1 + _ods_variadic_group_length - 1]

  @builtins.property
  def cols(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[2 + _ods_variadic_group_length - 1]

  @builtins.property
  def memref(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[3 + _ods_variadic_group_length - 1]

  @builtins.property
  def pruneFlag(self):
    return self.operation.attributes["pruneFlag"]

  @pruneFlag.setter
  def pruneFlag(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["pruneFlag"] = value

  @builtins.property
  def spMat(self):
    return self.operation.results[0]

  @builtins.property
  def asyncToken(self):
    return None if len(self.operation.results) < 2 else self.operation.results[1]

def create_2to4_spmat(sp_mat, async_token, async_dependencies, rows, cols, memref, *, prune_flag=None, loc=None, ip=None) -> _Sequence[_SubClassValueT]:
  return _get_op_result_or_op_results(Create2To4SpMatOp(spMat=sp_mat, asyncToken=async_token, asyncDependencies=async_dependencies, rows=rows, cols=cols, memref=memref, pruneFlag=prune_flag, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CreateBsrOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.create_bsr"

  _ODS_REGIONS = (0, True)

  def __init__(self, spmat, asyncToken, asyncDependencies, brows, bcols, bnnz, rBlockSize, cBlockSize, bRowPos, bColIdxs, values, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(asyncDependencies))
    operands.append(_get_op_result_or_value(brows))
    operands.append(_get_op_result_or_value(bcols))
    operands.append(_get_op_result_or_value(bnnz))
    operands.append(_get_op_result_or_value(rBlockSize))
    operands.append(_get_op_result_or_value(cBlockSize))
    operands.append(_get_op_result_or_value(bRowPos))
    operands.append(_get_op_result_or_value(bColIdxs))
    operands.append(_get_op_result_or_value(values))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(spmat)
    if asyncToken is not None: results.append(asyncToken)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def asyncDependencies(self):
    _ods_variadic_group_length = len(self.operation.operands) - 9 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def brows(self):
    _ods_variadic_group_length = len(self.operation.operands) - 9 + 1
    return self.operation.operands[1 + _ods_variadic_group_length - 1]

  @builtins.property
  def bcols(self):
    _ods_variadic_group_length = len(self.operation.operands) - 9 + 1
    return self.operation.operands[2 + _ods_variadic_group_length - 1]

  @builtins.property
  def bnnz(self):
    _ods_variadic_group_length = len(self.operation.operands) - 9 + 1
    return self.operation.operands[3 + _ods_variadic_group_length - 1]

  @builtins.property
  def rBlockSize(self):
    _ods_variadic_group_length = len(self.operation.operands) - 9 + 1
    return self.operation.operands[4 + _ods_variadic_group_length - 1]

  @builtins.property
  def cBlockSize(self):
    _ods_variadic_group_length = len(self.operation.operands) - 9 + 1
    return self.operation.operands[5 + _ods_variadic_group_length - 1]

  @builtins.property
  def bRowPos(self):
    _ods_variadic_group_length = len(self.operation.operands) - 9 + 1
    return self.operation.operands[6 + _ods_variadic_group_length - 1]

  @builtins.property
  def bColIdxs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 9 + 1
    return self.operation.operands[7 + _ods_variadic_group_length - 1]

  @builtins.property
  def values(self):
    _ods_variadic_group_length = len(self.operation.operands) - 9 + 1
    return self.operation.operands[8 + _ods_variadic_group_length - 1]

  @builtins.property
  def spmat(self):
    return self.operation.results[0]

  @builtins.property
  def asyncToken(self):
    return None if len(self.operation.results) < 2 else self.operation.results[1]

def create_bsr(spmat, async_token, async_dependencies, brows, bcols, bnnz, r_block_size, c_block_size, b_row_pos, b_col_idxs, values, *, loc=None, ip=None) -> _Sequence[_SubClassValueT]:
  return _get_op_result_or_op_results(CreateBsrOp(spmat=spmat, asyncToken=async_token, asyncDependencies=async_dependencies, brows=brows, bcols=bcols, bnnz=bnnz, rBlockSize=r_block_size, cBlockSize=c_block_size, bRowPos=b_row_pos, bColIdxs=b_col_idxs, values=values, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CreateCooAoSOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.create_coo_aos"

  _ODS_REGIONS = (0, True)

  def __init__(self, spmat, asyncToken, asyncDependencies, rows, cols, nnz, idxs, values, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(asyncDependencies))
    operands.append(_get_op_result_or_value(rows))
    operands.append(_get_op_result_or_value(cols))
    operands.append(_get_op_result_or_value(nnz))
    operands.append(_get_op_result_or_value(idxs))
    operands.append(_get_op_result_or_value(values))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(spmat)
    if asyncToken is not None: results.append(asyncToken)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def asyncDependencies(self):
    _ods_variadic_group_length = len(self.operation.operands) - 6 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def rows(self):
    _ods_variadic_group_length = len(self.operation.operands) - 6 + 1
    return self.operation.operands[1 + _ods_variadic_group_length - 1]

  @builtins.property
  def cols(self):
    _ods_variadic_group_length = len(self.operation.operands) - 6 + 1
    return self.operation.operands[2 + _ods_variadic_group_length - 1]

  @builtins.property
  def nnz(self):
    _ods_variadic_group_length = len(self.operation.operands) - 6 + 1
    return self.operation.operands[3 + _ods_variadic_group_length - 1]

  @builtins.property
  def idxs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 6 + 1
    return self.operation.operands[4 + _ods_variadic_group_length - 1]

  @builtins.property
  def values(self):
    _ods_variadic_group_length = len(self.operation.operands) - 6 + 1
    return self.operation.operands[5 + _ods_variadic_group_length - 1]

  @builtins.property
  def spmat(self):
    return self.operation.results[0]

  @builtins.property
  def asyncToken(self):
    return None if len(self.operation.results) < 2 else self.operation.results[1]

def create_coo_aos(spmat, async_token, async_dependencies, rows, cols, nnz, idxs, values, *, loc=None, ip=None) -> _Sequence[_SubClassValueT]:
  return _get_op_result_or_op_results(CreateCooAoSOp(spmat=spmat, asyncToken=async_token, asyncDependencies=async_dependencies, rows=rows, cols=cols, nnz=nnz, idxs=idxs, values=values, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CreateCooOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.create_coo"

  _ODS_REGIONS = (0, True)

  def __init__(self, spmat, asyncToken, asyncDependencies, rows, cols, nnz, rowIdxs, colIdxs, values, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(asyncDependencies))
    operands.append(_get_op_result_or_value(rows))
    operands.append(_get_op_result_or_value(cols))
    operands.append(_get_op_result_or_value(nnz))
    operands.append(_get_op_result_or_value(rowIdxs))
    operands.append(_get_op_result_or_value(colIdxs))
    operands.append(_get_op_result_or_value(values))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(spmat)
    if asyncToken is not None: results.append(asyncToken)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def asyncDependencies(self):
    _ods_variadic_group_length = len(self.operation.operands) - 7 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def rows(self):
    _ods_variadic_group_length = len(self.operation.operands) - 7 + 1
    return self.operation.operands[1 + _ods_variadic_group_length - 1]

  @builtins.property
  def cols(self):
    _ods_variadic_group_length = len(self.operation.operands) - 7 + 1
    return self.operation.operands[2 + _ods_variadic_group_length - 1]

  @builtins.property
  def nnz(self):
    _ods_variadic_group_length = len(self.operation.operands) - 7 + 1
    return self.operation.operands[3 + _ods_variadic_group_length - 1]

  @builtins.property
  def rowIdxs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 7 + 1
    return self.operation.operands[4 + _ods_variadic_group_length - 1]

  @builtins.property
  def colIdxs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 7 + 1
    return self.operation.operands[5 + _ods_variadic_group_length - 1]

  @builtins.property
  def values(self):
    _ods_variadic_group_length = len(self.operation.operands) - 7 + 1
    return self.operation.operands[6 + _ods_variadic_group_length - 1]

  @builtins.property
  def spmat(self):
    return self.operation.results[0]

  @builtins.property
  def asyncToken(self):
    return None if len(self.operation.results) < 2 else self.operation.results[1]

def create_coo(spmat, async_token, async_dependencies, rows, cols, nnz, row_idxs, col_idxs, values, *, loc=None, ip=None) -> _Sequence[_SubClassValueT]:
  return _get_op_result_or_op_results(CreateCooOp(spmat=spmat, asyncToken=async_token, asyncDependencies=async_dependencies, rows=rows, cols=cols, nnz=nnz, rowIdxs=row_idxs, colIdxs=col_idxs, values=values, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CreateCscOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.create_csc"

  _ODS_REGIONS = (0, True)

  def __init__(self, spmat, asyncToken, asyncDependencies, rows, cols, nnz, colPos, rowIdxs, values, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(asyncDependencies))
    operands.append(_get_op_result_or_value(rows))
    operands.append(_get_op_result_or_value(cols))
    operands.append(_get_op_result_or_value(nnz))
    operands.append(_get_op_result_or_value(colPos))
    operands.append(_get_op_result_or_value(rowIdxs))
    operands.append(_get_op_result_or_value(values))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(spmat)
    if asyncToken is not None: results.append(asyncToken)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def asyncDependencies(self):
    _ods_variadic_group_length = len(self.operation.operands) - 7 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def rows(self):
    _ods_variadic_group_length = len(self.operation.operands) - 7 + 1
    return self.operation.operands[1 + _ods_variadic_group_length - 1]

  @builtins.property
  def cols(self):
    _ods_variadic_group_length = len(self.operation.operands) - 7 + 1
    return self.operation.operands[2 + _ods_variadic_group_length - 1]

  @builtins.property
  def nnz(self):
    _ods_variadic_group_length = len(self.operation.operands) - 7 + 1
    return self.operation.operands[3 + _ods_variadic_group_length - 1]

  @builtins.property
  def colPos(self):
    _ods_variadic_group_length = len(self.operation.operands) - 7 + 1
    return self.operation.operands[4 + _ods_variadic_group_length - 1]

  @builtins.property
  def rowIdxs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 7 + 1
    return self.operation.operands[5 + _ods_variadic_group_length - 1]

  @builtins.property
  def values(self):
    _ods_variadic_group_length = len(self.operation.operands) - 7 + 1
    return self.operation.operands[6 + _ods_variadic_group_length - 1]

  @builtins.property
  def spmat(self):
    return self.operation.results[0]

  @builtins.property
  def asyncToken(self):
    return None if len(self.operation.results) < 2 else self.operation.results[1]

def create_csc(spmat, async_token, async_dependencies, rows, cols, nnz, col_pos, row_idxs, values, *, loc=None, ip=None) -> _Sequence[_SubClassValueT]:
  return _get_op_result_or_op_results(CreateCscOp(spmat=spmat, asyncToken=async_token, asyncDependencies=async_dependencies, rows=rows, cols=cols, nnz=nnz, colPos=col_pos, rowIdxs=row_idxs, values=values, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CreateCsrOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.create_csr"

  _ODS_REGIONS = (0, True)

  def __init__(self, spmat, asyncToken, asyncDependencies, rows, cols, nnz, rowPos, colIdxs, values, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(asyncDependencies))
    operands.append(_get_op_result_or_value(rows))
    operands.append(_get_op_result_or_value(cols))
    operands.append(_get_op_result_or_value(nnz))
    operands.append(_get_op_result_or_value(rowPos))
    operands.append(_get_op_result_or_value(colIdxs))
    operands.append(_get_op_result_or_value(values))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(spmat)
    if asyncToken is not None: results.append(asyncToken)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def asyncDependencies(self):
    _ods_variadic_group_length = len(self.operation.operands) - 7 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def rows(self):
    _ods_variadic_group_length = len(self.operation.operands) - 7 + 1
    return self.operation.operands[1 + _ods_variadic_group_length - 1]

  @builtins.property
  def cols(self):
    _ods_variadic_group_length = len(self.operation.operands) - 7 + 1
    return self.operation.operands[2 + _ods_variadic_group_length - 1]

  @builtins.property
  def nnz(self):
    _ods_variadic_group_length = len(self.operation.operands) - 7 + 1
    return self.operation.operands[3 + _ods_variadic_group_length - 1]

  @builtins.property
  def rowPos(self):
    _ods_variadic_group_length = len(self.operation.operands) - 7 + 1
    return self.operation.operands[4 + _ods_variadic_group_length - 1]

  @builtins.property
  def colIdxs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 7 + 1
    return self.operation.operands[5 + _ods_variadic_group_length - 1]

  @builtins.property
  def values(self):
    _ods_variadic_group_length = len(self.operation.operands) - 7 + 1
    return self.operation.operands[6 + _ods_variadic_group_length - 1]

  @builtins.property
  def spmat(self):
    return self.operation.results[0]

  @builtins.property
  def asyncToken(self):
    return None if len(self.operation.results) < 2 else self.operation.results[1]

def create_csr(spmat, async_token, async_dependencies, rows, cols, nnz, row_pos, col_idxs, values, *, loc=None, ip=None) -> _Sequence[_SubClassValueT]:
  return _get_op_result_or_op_results(CreateCsrOp(spmat=spmat, asyncToken=async_token, asyncDependencies=async_dependencies, rows=rows, cols=cols, nnz=nnz, rowPos=row_pos, colIdxs=col_idxs, values=values, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CreateDnTensorOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.create_dn_tensor"

  _ODS_OPERAND_SEGMENTS = [-1,1,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, dnTensor, asyncToken, asyncDependencies, memref, dims, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(asyncDependencies))
    operands.append(_get_op_result_or_value(memref))
    operands.append(_get_op_results_or_values(dims))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(dnTensor)
    if asyncToken is not None: results.append(asyncToken)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def asyncDependencies(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def memref(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0]

  @builtins.property
  def dims(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def dnTensor(self):
    return self.operation.results[0]

  @builtins.property
  def asyncToken(self):
    return None if len(self.operation.results) < 2 else self.operation.results[1]

def create_dn_tensor(dn_tensor, async_token, async_dependencies, memref, dims, *, loc=None, ip=None) -> _Sequence[_SubClassValueT]:
  return _get_op_result_or_op_results(CreateDnTensorOp(dnTensor=dn_tensor, asyncToken=async_token, asyncDependencies=async_dependencies, memref=memref, dims=dims, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class DeallocOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.dealloc"

  _ODS_REGIONS = (0, True)

  def __init__(self, asyncToken, asyncDependencies, memref, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(asyncDependencies))
    operands.append(_get_op_result_or_value(memref))
    _ods_context = _ods_get_default_loc_context(loc)
    if asyncToken is not None: results.append(asyncToken)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def asyncDependencies(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def memref(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1 + _ods_variadic_group_length - 1]

  @builtins.property
  def asyncToken(self):
    return None if len(self.operation.results) < 1 else self.operation.results[0]

def dealloc(async_token, async_dependencies, memref, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(DeallocOp(asyncToken=async_token, asyncDependencies=async_dependencies, memref=memref, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class DestroyDnTensorOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.destroy_dn_tensor"

  _ODS_REGIONS = (0, True)

  def __init__(self, asyncToken, asyncDependencies, dnTensor, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(asyncDependencies))
    operands.append(_get_op_result_or_value(dnTensor))
    _ods_context = _ods_get_default_loc_context(loc)
    if asyncToken is not None: results.append(asyncToken)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def asyncDependencies(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def dnTensor(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1 + _ods_variadic_group_length - 1]

  @builtins.property
  def asyncToken(self):
    return None if len(self.operation.results) < 1 else self.operation.results[0]

def destroy_dn_tensor(async_token, async_dependencies, dn_tensor, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(DestroyDnTensorOp(asyncToken=async_token, asyncDependencies=async_dependencies, dnTensor=dn_tensor, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class DestroySpMatOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.destroy_sp_mat"

  _ODS_REGIONS = (0, True)

  def __init__(self, asyncToken, asyncDependencies, spmat, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(asyncDependencies))
    operands.append(_get_op_result_or_value(spmat))
    _ods_context = _ods_get_default_loc_context(loc)
    if asyncToken is not None: results.append(asyncToken)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def asyncDependencies(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def spmat(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1 + _ods_variadic_group_length - 1]

  @builtins.property
  def asyncToken(self):
    return None if len(self.operation.results) < 1 else self.operation.results[0]

def destroy_sp_mat(async_token, async_dependencies, spmat, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(DestroySpMatOp(asyncToken=async_token, asyncDependencies=async_dependencies, spmat=spmat, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class DynamicSharedMemoryOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.dynamic_shared_memory"

  _ODS_REGIONS = (0, True)

  def __init__(self, resultMemref, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(resultMemref)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def resultMemref(self):
    return self.operation.results[0]

def dynamic_shared_memory(result_memref, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(DynamicSharedMemoryOp(resultMemref=result_memref, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class GPUFuncOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.func"

  _ODS_REGIONS = (1, True)

  def __init__(self, function_type, *, arg_attrs=None, res_attrs=None, workgroup_attrib_attrs=None, private_attrib_attrs=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["function_type"] = (function_type if (
    issubclass(type(function_type), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('anonymous_522')) else
      _ods_ir.AttrBuilder.get('anonymous_522')(function_type, context=_ods_context))
    if arg_attrs is not None: attributes["arg_attrs"] = (arg_attrs if (
        issubclass(type(arg_attrs), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DictArrayAttr')) else
          _ods_ir.AttrBuilder.get('DictArrayAttr')(arg_attrs, context=_ods_context))
    if res_attrs is not None: attributes["res_attrs"] = (res_attrs if (
        issubclass(type(res_attrs), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DictArrayAttr')) else
          _ods_ir.AttrBuilder.get('DictArrayAttr')(res_attrs, context=_ods_context))
    if workgroup_attrib_attrs is not None: attributes["workgroup_attrib_attrs"] = (workgroup_attrib_attrs if (
        issubclass(type(workgroup_attrib_attrs), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DictArrayAttr')) else
          _ods_ir.AttrBuilder.get('DictArrayAttr')(workgroup_attrib_attrs, context=_ods_context))
    if private_attrib_attrs is not None: attributes["private_attrib_attrs"] = (private_attrib_attrs if (
        issubclass(type(private_attrib_attrs), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DictArrayAttr')) else
          _ods_ir.AttrBuilder.get('DictArrayAttr')(private_attrib_attrs, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def function_type(self):
    return self.operation.attributes["function_type"]

  @function_type.setter
  def function_type(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["function_type"] = value

  @builtins.property
  def arg_attrs(self):
    if "arg_attrs" not in self.operation.attributes:
      return None
    return self.operation.attributes["arg_attrs"]

  @arg_attrs.setter
  def arg_attrs(self, value):
    if value is not None:
      self.operation.attributes["arg_attrs"] = value
    elif "arg_attrs" in self.operation.attributes:
      del self.operation.attributes["arg_attrs"]

  @arg_attrs.deleter
  def arg_attrs(self):
    del self.operation.attributes["arg_attrs"]

  @builtins.property
  def res_attrs(self):
    if "res_attrs" not in self.operation.attributes:
      return None
    return self.operation.attributes["res_attrs"]

  @res_attrs.setter
  def res_attrs(self, value):
    if value is not None:
      self.operation.attributes["res_attrs"] = value
    elif "res_attrs" in self.operation.attributes:
      del self.operation.attributes["res_attrs"]

  @res_attrs.deleter
  def res_attrs(self):
    del self.operation.attributes["res_attrs"]

  @builtins.property
  def workgroup_attrib_attrs(self):
    if "workgroup_attrib_attrs" not in self.operation.attributes:
      return None
    return self.operation.attributes["workgroup_attrib_attrs"]

  @workgroup_attrib_attrs.setter
  def workgroup_attrib_attrs(self, value):
    if value is not None:
      self.operation.attributes["workgroup_attrib_attrs"] = value
    elif "workgroup_attrib_attrs" in self.operation.attributes:
      del self.operation.attributes["workgroup_attrib_attrs"]

  @workgroup_attrib_attrs.deleter
  def workgroup_attrib_attrs(self):
    del self.operation.attributes["workgroup_attrib_attrs"]

  @builtins.property
  def private_attrib_attrs(self):
    if "private_attrib_attrs" not in self.operation.attributes:
      return None
    return self.operation.attributes["private_attrib_attrs"]

  @private_attrib_attrs.setter
  def private_attrib_attrs(self, value):
    if value is not None:
      self.operation.attributes["private_attrib_attrs"] = value
    elif "private_attrib_attrs" in self.operation.attributes:
      del self.operation.attributes["private_attrib_attrs"]

  @private_attrib_attrs.deleter
  def private_attrib_attrs(self):
    del self.operation.attributes["private_attrib_attrs"]

  @builtins.property
  def body(self):
    return self.regions[0]

def func(function_type, *, arg_attrs=None, res_attrs=None, workgroup_attrib_attrs=None, private_attrib_attrs=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(GPUFuncOp(function_type=function_type, arg_attrs=arg_attrs, res_attrs=res_attrs, workgroup_attrib_attrs=workgroup_attrib_attrs, private_attrib_attrs=private_attrib_attrs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class GPUModuleOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.module"

  _ODS_REGIONS = (1, True)

  def __init__(self, *, targets=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    if targets is not None: attributes["targets"] = (targets if (
        issubclass(type(targets), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('GPUTargetArrayAttr')) else
          _ods_ir.AttrBuilder.get('GPUTargetArrayAttr')(targets, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def targets(self):
    if "targets" not in self.operation.attributes:
      return None
    return self.operation.attributes["targets"]

  @targets.setter
  def targets(self, value):
    if value is not None:
      self.operation.attributes["targets"] = value
    elif "targets" in self.operation.attributes:
      del self.operation.attributes["targets"]

  @targets.deleter
  def targets(self):
    del self.operation.attributes["targets"]

  @builtins.property
  def bodyRegion(self):
    return self.regions[0]

def module(*, targets=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(GPUModuleOp(targets=targets, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class GlobalIdOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.global_id"

  _ODS_REGIONS = (0, True)

  def __init__(self, dimension, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dimension"] = (dimension if (
    issubclass(type(dimension), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('GPU_DimensionAttr')) else
      _ods_ir.AttrBuilder.get('GPU_DimensionAttr')(dimension, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def dimension(self):
    return self.operation.attributes["dimension"]

  @dimension.setter
  def dimension(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dimension"] = value

def global_id(dimension, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(GlobalIdOp(dimension=dimension, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class GridDimOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.grid_dim"

  _ODS_REGIONS = (0, True)

  def __init__(self, dimension, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dimension"] = (dimension if (
    issubclass(type(dimension), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('GPU_DimensionAttr')) else
      _ods_ir.AttrBuilder.get('GPU_DimensionAttr')(dimension, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def dimension(self):
    return self.operation.attributes["dimension"]

  @dimension.setter
  def dimension(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dimension"] = value

def grid_dim(dimension, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(GridDimOp(dimension=dimension, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class HostRegisterOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.host_register"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(value))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def value(self):
    return self.operation.operands[0]

def host_register(value, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(HostRegisterOp(value=value, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class HostUnregisterOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.host_unregister"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(value))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def value(self):
    return self.operation.operands[0]

def host_unregister(value, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(HostUnregisterOp(value=value, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class LaneIdOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.lane_id"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def result(self):
    return self.operation.results[0]

def lane_id(*, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(LaneIdOp(loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class LaunchFuncOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.launch_func"

  _ODS_OPERAND_SEGMENTS = [-1,1,1,1,1,1,1,0,0,0,0,-1,0,]

  _ODS_REGIONS = (0, True)

  def __init__(self, asyncToken, asyncDependencies, kernel, gridSizeX, gridSizeY, gridSizeZ, blockSizeX, blockSizeY, blockSizeZ, kernelOperands, *, clusterSizeX=None, clusterSizeY=None, clusterSizeZ=None, dynamicSharedMemorySize=None, asyncObject=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(asyncDependencies))
    operands.append(_get_op_result_or_value(gridSizeX))
    operands.append(_get_op_result_or_value(gridSizeY))
    operands.append(_get_op_result_or_value(gridSizeZ))
    operands.append(_get_op_result_or_value(blockSizeX))
    operands.append(_get_op_result_or_value(blockSizeY))
    operands.append(_get_op_result_or_value(blockSizeZ))
    operands.append(_get_op_result_or_value(clusterSizeX) if clusterSizeX is not None else None)
    operands.append(_get_op_result_or_value(clusterSizeY) if clusterSizeY is not None else None)
    operands.append(_get_op_result_or_value(clusterSizeZ) if clusterSizeZ is not None else None)
    operands.append(_get_op_result_or_value(dynamicSharedMemorySize) if dynamicSharedMemorySize is not None else None)
    operands.append(_get_op_results_or_values(kernelOperands))
    operands.append(_get_op_result_or_value(asyncObject) if asyncObject is not None else None)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["kernel"] = (kernel if (
    issubclass(type(kernel), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolRefAttr')) else
      _ods_ir.AttrBuilder.get('SymbolRefAttr')(kernel, context=_ods_context))
    if asyncToken is not None: results.append(asyncToken)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def asyncDependencies(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def gridSizeX(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0]

  @builtins.property
  def gridSizeY(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range[0]

  @builtins.property
  def gridSizeZ(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range[0]

  @builtins.property
  def blockSizeX(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 4)
    return operand_range[0]

  @builtins.property
  def blockSizeY(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 5)
    return operand_range[0]

  @builtins.property
  def blockSizeZ(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 6)
    return operand_range[0]

  @builtins.property
  def clusterSizeX(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 7)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def clusterSizeY(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 8)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def clusterSizeZ(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 9)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def dynamicSharedMemorySize(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 10)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def kernelOperands(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 11)
    return operand_range

  @builtins.property
  def asyncObject(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 12)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def kernel(self):
    return self.operation.attributes["kernel"]

  @kernel.setter
  def kernel(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["kernel"] = value

  @builtins.property
  def asyncToken(self):
    return None if len(self.operation.results) < 1 else self.operation.results[0]

def launch_func(async_token, async_dependencies, kernel, grid_size_x, grid_size_y, grid_size_z, block_size_x, block_size_y, block_size_z, kernel_operands, *, cluster_size_x=None, cluster_size_y=None, cluster_size_z=None, dynamic_shared_memory_size=None, async_object=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(LaunchFuncOp(asyncToken=async_token, asyncDependencies=async_dependencies, kernel=kernel, gridSizeX=grid_size_x, gridSizeY=grid_size_y, gridSizeZ=grid_size_z, blockSizeX=block_size_x, blockSizeY=block_size_y, blockSizeZ=block_size_z, kernelOperands=kernel_operands, clusterSizeX=cluster_size_x, clusterSizeY=cluster_size_y, clusterSizeZ=cluster_size_z, dynamicSharedMemorySize=dynamic_shared_memory_size, asyncObject=async_object, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class LaunchOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.launch"

  _ODS_OPERAND_SEGMENTS = [-1,1,1,1,1,1,1,0,0,0,0,]

  _ODS_REGIONS = (1, True)

  def __init__(self, asyncToken, asyncDependencies, gridSizeX, gridSizeY, gridSizeZ, blockSizeX, blockSizeY, blockSizeZ, *, clusterSizeX=None, clusterSizeY=None, clusterSizeZ=None, dynamicSharedMemorySize=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(asyncDependencies))
    operands.append(_get_op_result_or_value(gridSizeX))
    operands.append(_get_op_result_or_value(gridSizeY))
    operands.append(_get_op_result_or_value(gridSizeZ))
    operands.append(_get_op_result_or_value(blockSizeX))
    operands.append(_get_op_result_or_value(blockSizeY))
    operands.append(_get_op_result_or_value(blockSizeZ))
    operands.append(_get_op_result_or_value(clusterSizeX) if clusterSizeX is not None else None)
    operands.append(_get_op_result_or_value(clusterSizeY) if clusterSizeY is not None else None)
    operands.append(_get_op_result_or_value(clusterSizeZ) if clusterSizeZ is not None else None)
    operands.append(_get_op_result_or_value(dynamicSharedMemorySize) if dynamicSharedMemorySize is not None else None)
    _ods_context = _ods_get_default_loc_context(loc)
    if asyncToken is not None: results.append(asyncToken)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def asyncDependencies(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def gridSizeX(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0]

  @builtins.property
  def gridSizeY(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range[0]

  @builtins.property
  def gridSizeZ(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range[0]

  @builtins.property
  def blockSizeX(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 4)
    return operand_range[0]

  @builtins.property
  def blockSizeY(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 5)
    return operand_range[0]

  @builtins.property
  def blockSizeZ(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 6)
    return operand_range[0]

  @builtins.property
  def clusterSizeX(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 7)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def clusterSizeY(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 8)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def clusterSizeZ(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 9)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def dynamicSharedMemorySize(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 10)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def asyncToken(self):
    return None if len(self.operation.results) < 1 else self.operation.results[0]

  @builtins.property
  def body(self):
    return self.regions[0]

def launch(async_token, async_dependencies, grid_size_x, grid_size_y, grid_size_z, block_size_x, block_size_y, block_size_z, *, cluster_size_x=None, cluster_size_y=None, cluster_size_z=None, dynamic_shared_memory_size=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(LaunchOp(asyncToken=async_token, asyncDependencies=async_dependencies, gridSizeX=grid_size_x, gridSizeY=grid_size_y, gridSizeZ=grid_size_z, blockSizeX=block_size_x, blockSizeY=block_size_y, blockSizeZ=block_size_z, clusterSizeX=cluster_size_x, clusterSizeY=cluster_size_y, clusterSizeZ=cluster_size_z, dynamicSharedMemorySize=dynamic_shared_memory_size, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MemcpyOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.memcpy"

  _ODS_REGIONS = (0, True)

  def __init__(self, asyncToken, asyncDependencies, dst, src, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(asyncDependencies))
    operands.append(_get_op_result_or_value(dst))
    operands.append(_get_op_result_or_value(src))
    _ods_context = _ods_get_default_loc_context(loc)
    if asyncToken is not None: results.append(asyncToken)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def asyncDependencies(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def dst(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[1 + _ods_variadic_group_length - 1]

  @builtins.property
  def src(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[2 + _ods_variadic_group_length - 1]

  @builtins.property
  def asyncToken(self):
    return None if len(self.operation.results) < 1 else self.operation.results[0]

def memcpy(async_token, async_dependencies, dst, src, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(MemcpyOp(asyncToken=async_token, asyncDependencies=async_dependencies, dst=dst, src=src, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MemsetOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.memset"

  _ODS_REGIONS = (0, True)

  def __init__(self, asyncToken, asyncDependencies, dst, value, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(asyncDependencies))
    operands.append(_get_op_result_or_value(dst))
    operands.append(_get_op_result_or_value(value))
    _ods_context = _ods_get_default_loc_context(loc)
    if asyncToken is not None: results.append(asyncToken)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def asyncDependencies(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def dst(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[1 + _ods_variadic_group_length - 1]

  @builtins.property
  def value(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[2 + _ods_variadic_group_length - 1]

  @builtins.property
  def asyncToken(self):
    return None if len(self.operation.results) < 1 else self.operation.results[0]

def memset(async_token, async_dependencies, dst, value, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(MemsetOp(asyncToken=async_token, asyncDependencies=async_dependencies, dst=dst, value=value, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ModuleEndOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.module_end"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

def module_end(*, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(ModuleEndOp(loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class NumSubgroupsOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.num_subgroups"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def result(self):
    return self.operation.results[0]

def num_subgroups(*, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(NumSubgroupsOp(loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class PrintfOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.printf"

  _ODS_REGIONS = (0, True)

  def __init__(self, format, args, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(args))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["format"] = (format if (
    issubclass(type(format), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(format, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def args(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def format(self):
    return self.operation.attributes["format"]

  @format.setter
  def format(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["format"] = value

def printf(format, args, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(PrintfOp(format=format, args=args, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ReturnOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.return"

  _ODS_REGIONS = (0, True)

  def __init__(self, operands_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(operands_))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operands_(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def return_(operands_, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(ReturnOp(operands_=operands_, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SDDMMBufferSizeOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.sddmm_buffer_size"

  _ODS_REGIONS = (0, True)

  def __init__(self, bufferSz, asyncToken, asyncDependencies, dnmatA, dnmatB, spmatC, computeType, *, modeA=None, modeB=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(asyncDependencies))
    operands.append(_get_op_result_or_value(dnmatA))
    operands.append(_get_op_result_or_value(dnmatB))
    operands.append(_get_op_result_or_value(spmatC))
    _ods_context = _ods_get_default_loc_context(loc)
    if modeA is not None: attributes["modeA"] = (modeA if (
        issubclass(type(modeA), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('GPU_TransposeModeAttr')) else
          _ods_ir.AttrBuilder.get('GPU_TransposeModeAttr')(modeA, context=_ods_context))
    if modeB is not None: attributes["modeB"] = (modeB if (
        issubclass(type(modeB), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('GPU_TransposeModeAttr')) else
          _ods_ir.AttrBuilder.get('GPU_TransposeModeAttr')(modeB, context=_ods_context))
    attributes["computeType"] = (computeType if (
    issubclass(type(computeType), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypeAttr')) else
      _ods_ir.AttrBuilder.get('TypeAttr')(computeType, context=_ods_context))
    results.append(bufferSz)
    if asyncToken is not None: results.append(asyncToken)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def asyncDependencies(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def dnmatA(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[1 + _ods_variadic_group_length - 1]

  @builtins.property
  def dnmatB(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[2 + _ods_variadic_group_length - 1]

  @builtins.property
  def spmatC(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[3 + _ods_variadic_group_length - 1]

  @builtins.property
  def modeA(self):
    return self.operation.attributes["modeA"]

  @modeA.setter
  def modeA(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["modeA"] = value

  @builtins.property
  def modeB(self):
    return self.operation.attributes["modeB"]

  @modeB.setter
  def modeB(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["modeB"] = value

  @builtins.property
  def computeType(self):
    return self.operation.attributes["computeType"]

  @computeType.setter
  def computeType(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["computeType"] = value

  @builtins.property
  def bufferSz(self):
    return self.operation.results[0]

  @builtins.property
  def asyncToken(self):
    return None if len(self.operation.results) < 2 else self.operation.results[1]

def sddmm_buffer_size(buffer_sz, async_token, async_dependencies, dnmat_a, dnmat_b, spmat_c, compute_type, *, mode_a=None, mode_b=None, loc=None, ip=None) -> _Sequence[_SubClassValueT]:
  return _get_op_result_or_op_results(SDDMMBufferSizeOp(bufferSz=buffer_sz, asyncToken=async_token, asyncDependencies=async_dependencies, dnmatA=dnmat_a, dnmatB=dnmat_b, spmatC=spmat_c, computeType=compute_type, modeA=mode_a, modeB=mode_b, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SDDMMOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.sddmm"

  _ODS_REGIONS = (0, True)

  def __init__(self, asyncToken, asyncDependencies, dnmatA, dnmatB, spmatC, computeType, buffer, *, modeA=None, modeB=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(asyncDependencies))
    operands.append(_get_op_result_or_value(dnmatA))
    operands.append(_get_op_result_or_value(dnmatB))
    operands.append(_get_op_result_or_value(spmatC))
    operands.append(_get_op_result_or_value(buffer))
    _ods_context = _ods_get_default_loc_context(loc)
    if modeA is not None: attributes["modeA"] = (modeA if (
        issubclass(type(modeA), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('GPU_TransposeModeAttr')) else
          _ods_ir.AttrBuilder.get('GPU_TransposeModeAttr')(modeA, context=_ods_context))
    if modeB is not None: attributes["modeB"] = (modeB if (
        issubclass(type(modeB), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('GPU_TransposeModeAttr')) else
          _ods_ir.AttrBuilder.get('GPU_TransposeModeAttr')(modeB, context=_ods_context))
    attributes["computeType"] = (computeType if (
    issubclass(type(computeType), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypeAttr')) else
      _ods_ir.AttrBuilder.get('TypeAttr')(computeType, context=_ods_context))
    if asyncToken is not None: results.append(asyncToken)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def asyncDependencies(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def dnmatA(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[1 + _ods_variadic_group_length - 1]

  @builtins.property
  def dnmatB(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[2 + _ods_variadic_group_length - 1]

  @builtins.property
  def spmatC(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[3 + _ods_variadic_group_length - 1]

  @builtins.property
  def buffer(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[4 + _ods_variadic_group_length - 1]

  @builtins.property
  def modeA(self):
    return self.operation.attributes["modeA"]

  @modeA.setter
  def modeA(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["modeA"] = value

  @builtins.property
  def modeB(self):
    return self.operation.attributes["modeB"]

  @modeB.setter
  def modeB(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["modeB"] = value

  @builtins.property
  def computeType(self):
    return self.operation.attributes["computeType"]

  @computeType.setter
  def computeType(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["computeType"] = value

  @builtins.property
  def asyncToken(self):
    return None if len(self.operation.results) < 1 else self.operation.results[0]

def sddmm(async_token, async_dependencies, dnmat_a, dnmat_b, spmat_c, compute_type, buffer, *, mode_a=None, mode_b=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(SDDMMOp(asyncToken=async_token, asyncDependencies=async_dependencies, dnmatA=dnmat_a, dnmatB=dnmat_b, spmatC=spmat_c, computeType=compute_type, buffer=buffer, modeA=mode_a, modeB=mode_b, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SetCsrPointersOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.set_csr_pointers"

  _ODS_REGIONS = (0, True)

  def __init__(self, asyncToken, asyncDependencies, spmat, positions, coordinates, values, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(asyncDependencies))
    operands.append(_get_op_result_or_value(spmat))
    operands.append(_get_op_result_or_value(positions))
    operands.append(_get_op_result_or_value(coordinates))
    operands.append(_get_op_result_or_value(values))
    _ods_context = _ods_get_default_loc_context(loc)
    if asyncToken is not None: results.append(asyncToken)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def asyncDependencies(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def spmat(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[1 + _ods_variadic_group_length - 1]

  @builtins.property
  def positions(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[2 + _ods_variadic_group_length - 1]

  @builtins.property
  def coordinates(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[3 + _ods_variadic_group_length - 1]

  @builtins.property
  def values(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[4 + _ods_variadic_group_length - 1]

  @builtins.property
  def asyncToken(self):
    return None if len(self.operation.results) < 1 else self.operation.results[0]

def set_csr_pointers(async_token, async_dependencies, spmat, positions, coordinates, values, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(SetCsrPointersOp(asyncToken=async_token, asyncDependencies=async_dependencies, spmat=spmat, positions=positions, coordinates=coordinates, values=values, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SetDefaultDeviceOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.set_default_device"

  _ODS_REGIONS = (0, True)

  def __init__(self, devIndex, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(devIndex))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def devIndex(self):
    return self.operation.operands[0]

def set_default_device(dev_index, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(SetDefaultDeviceOp(devIndex=dev_index, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ShuffleOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.shuffle"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, offset, width, mode, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(value))
    operands.append(_get_op_result_or_value(offset))
    operands.append(_get_op_result_or_value(width))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["mode"] = (mode if (
    issubclass(type(mode), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('GPU_ShuffleModeAttr')) else
      _ods_ir.AttrBuilder.get('GPU_ShuffleModeAttr')(mode, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def value(self):
    return self.operation.operands[0]

  @builtins.property
  def offset(self):
    return self.operation.operands[1]

  @builtins.property
  def width(self):
    return self.operation.operands[2]

  @builtins.property
  def mode(self):
    return self.operation.attributes["mode"]

  @mode.setter
  def mode(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["mode"] = value

  @builtins.property
  def shuffleResult(self):
    return self.operation.results[0]

  @builtins.property
  def valid(self):
    return self.operation.results[1]

def shuffle(value, offset, width, mode, *, loc=None, ip=None) -> _Sequence[_SubClassValueT]:
  return _get_op_result_or_op_results(ShuffleOp(value=value, offset=offset, width=width, mode=mode, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SpGEMMCopyOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.spgemm_copy"

  _ODS_REGIONS = (0, True)

  def __init__(self, asyncToken, asyncDependencies, desc, spmatA, spmatB, spmatC, computeType, *, modeA=None, modeB=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(asyncDependencies))
    operands.append(_get_op_result_or_value(desc))
    operands.append(_get_op_result_or_value(spmatA))
    operands.append(_get_op_result_or_value(spmatB))
    operands.append(_get_op_result_or_value(spmatC))
    _ods_context = _ods_get_default_loc_context(loc)
    if modeA is not None: attributes["modeA"] = (modeA if (
        issubclass(type(modeA), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('GPU_TransposeModeAttr')) else
          _ods_ir.AttrBuilder.get('GPU_TransposeModeAttr')(modeA, context=_ods_context))
    if modeB is not None: attributes["modeB"] = (modeB if (
        issubclass(type(modeB), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('GPU_TransposeModeAttr')) else
          _ods_ir.AttrBuilder.get('GPU_TransposeModeAttr')(modeB, context=_ods_context))
    attributes["computeType"] = (computeType if (
    issubclass(type(computeType), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypeAttr')) else
      _ods_ir.AttrBuilder.get('TypeAttr')(computeType, context=_ods_context))
    if asyncToken is not None: results.append(asyncToken)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def asyncDependencies(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def desc(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[1 + _ods_variadic_group_length - 1]

  @builtins.property
  def spmatA(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[2 + _ods_variadic_group_length - 1]

  @builtins.property
  def spmatB(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[3 + _ods_variadic_group_length - 1]

  @builtins.property
  def spmatC(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[4 + _ods_variadic_group_length - 1]

  @builtins.property
  def modeA(self):
    return self.operation.attributes["modeA"]

  @modeA.setter
  def modeA(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["modeA"] = value

  @builtins.property
  def modeB(self):
    return self.operation.attributes["modeB"]

  @modeB.setter
  def modeB(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["modeB"] = value

  @builtins.property
  def computeType(self):
    return self.operation.attributes["computeType"]

  @computeType.setter
  def computeType(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["computeType"] = value

  @builtins.property
  def asyncToken(self):
    return None if len(self.operation.results) < 1 else self.operation.results[0]

def spgemm_copy(async_token, async_dependencies, desc, spmat_a, spmat_b, spmat_c, compute_type, *, mode_a=None, mode_b=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(SpGEMMCopyOp(asyncToken=async_token, asyncDependencies=async_dependencies, desc=desc, spmatA=spmat_a, spmatB=spmat_b, spmatC=spmat_c, computeType=compute_type, modeA=mode_a, modeB=mode_b, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SpGEMMCreateDescrOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.spgemm_create_descr"

  _ODS_REGIONS = (0, True)

  def __init__(self, desc, asyncToken, asyncDependencies, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(asyncDependencies))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(desc)
    if asyncToken is not None: results.append(asyncToken)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def asyncDependencies(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def desc(self):
    return self.operation.results[0]

  @builtins.property
  def asyncToken(self):
    return None if len(self.operation.results) < 2 else self.operation.results[1]

def spgemm_create_descr(desc, async_token, async_dependencies, *, loc=None, ip=None) -> _Sequence[_SubClassValueT]:
  return _get_op_result_or_op_results(SpGEMMCreateDescrOp(desc=desc, asyncToken=async_token, asyncDependencies=async_dependencies, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SpGEMMDestroyDescrOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.spgemm_destroy_descr"

  _ODS_REGIONS = (0, True)

  def __init__(self, asyncToken, asyncDependencies, desc, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(asyncDependencies))
    operands.append(_get_op_result_or_value(desc))
    _ods_context = _ods_get_default_loc_context(loc)
    if asyncToken is not None: results.append(asyncToken)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def asyncDependencies(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def desc(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1 + _ods_variadic_group_length - 1]

  @builtins.property
  def asyncToken(self):
    return None if len(self.operation.results) < 1 else self.operation.results[0]

def spgemm_destroy_descr(async_token, async_dependencies, desc, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(SpGEMMDestroyDescrOp(asyncToken=async_token, asyncDependencies=async_dependencies, desc=desc, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SpGEMMWorkEstimationOrComputeOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.spgemm_work_estimation_or_compute"

  _ODS_REGIONS = (0, True)

  def __init__(self, bufferSzNew, asyncToken, asyncDependencies, desc, spmatA, spmatB, spmatC, computeType, bufferSz, buffer, kind, *, modeA=None, modeB=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(asyncDependencies))
    operands.append(_get_op_result_or_value(desc))
    operands.append(_get_op_result_or_value(spmatA))
    operands.append(_get_op_result_or_value(spmatB))
    operands.append(_get_op_result_or_value(spmatC))
    operands.append(_get_op_result_or_value(bufferSz))
    operands.append(_get_op_result_or_value(buffer))
    _ods_context = _ods_get_default_loc_context(loc)
    if modeA is not None: attributes["modeA"] = (modeA if (
        issubclass(type(modeA), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('GPU_TransposeModeAttr')) else
          _ods_ir.AttrBuilder.get('GPU_TransposeModeAttr')(modeA, context=_ods_context))
    if modeB is not None: attributes["modeB"] = (modeB if (
        issubclass(type(modeB), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('GPU_TransposeModeAttr')) else
          _ods_ir.AttrBuilder.get('GPU_TransposeModeAttr')(modeB, context=_ods_context))
    attributes["computeType"] = (computeType if (
    issubclass(type(computeType), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypeAttr')) else
      _ods_ir.AttrBuilder.get('TypeAttr')(computeType, context=_ods_context))
    attributes["kind"] = (kind if (
    issubclass(type(kind), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('GPU_SpGEMMWorkEstimationOrComputeKindAttr')) else
      _ods_ir.AttrBuilder.get('GPU_SpGEMMWorkEstimationOrComputeKindAttr')(kind, context=_ods_context))
    results.append(bufferSzNew)
    if asyncToken is not None: results.append(asyncToken)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def asyncDependencies(self):
    _ods_variadic_group_length = len(self.operation.operands) - 7 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def desc(self):
    _ods_variadic_group_length = len(self.operation.operands) - 7 + 1
    return self.operation.operands[1 + _ods_variadic_group_length - 1]

  @builtins.property
  def spmatA(self):
    _ods_variadic_group_length = len(self.operation.operands) - 7 + 1
    return self.operation.operands[2 + _ods_variadic_group_length - 1]

  @builtins.property
  def spmatB(self):
    _ods_variadic_group_length = len(self.operation.operands) - 7 + 1
    return self.operation.operands[3 + _ods_variadic_group_length - 1]

  @builtins.property
  def spmatC(self):
    _ods_variadic_group_length = len(self.operation.operands) - 7 + 1
    return self.operation.operands[4 + _ods_variadic_group_length - 1]

  @builtins.property
  def bufferSz(self):
    _ods_variadic_group_length = len(self.operation.operands) - 7 + 1
    return self.operation.operands[5 + _ods_variadic_group_length - 1]

  @builtins.property
  def buffer(self):
    _ods_variadic_group_length = len(self.operation.operands) - 7 + 1
    return self.operation.operands[6 + _ods_variadic_group_length - 1]

  @builtins.property
  def modeA(self):
    return self.operation.attributes["modeA"]

  @modeA.setter
  def modeA(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["modeA"] = value

  @builtins.property
  def modeB(self):
    return self.operation.attributes["modeB"]

  @modeB.setter
  def modeB(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["modeB"] = value

  @builtins.property
  def computeType(self):
    return self.operation.attributes["computeType"]

  @computeType.setter
  def computeType(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["computeType"] = value

  @builtins.property
  def kind(self):
    return self.operation.attributes["kind"]

  @kind.setter
  def kind(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["kind"] = value

  @builtins.property
  def bufferSzNew(self):
    return self.operation.results[0]

  @builtins.property
  def asyncToken(self):
    return None if len(self.operation.results) < 2 else self.operation.results[1]

def spgemm_work_estimation_or_compute(buffer_sz_new, async_token, async_dependencies, desc, spmat_a, spmat_b, spmat_c, compute_type, buffer_sz, buffer, kind, *, mode_a=None, mode_b=None, loc=None, ip=None) -> _Sequence[_SubClassValueT]:
  return _get_op_result_or_op_results(SpGEMMWorkEstimationOrComputeOp(bufferSzNew=buffer_sz_new, asyncToken=async_token, asyncDependencies=async_dependencies, desc=desc, spmatA=spmat_a, spmatB=spmat_b, spmatC=spmat_c, computeType=compute_type, bufferSz=buffer_sz, buffer=buffer, kind=kind, modeA=mode_a, modeB=mode_b, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SpMMBufferSizeOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.spmm_buffer_size"

  _ODS_RESULT_SEGMENTS = [-1,0,]

  _ODS_REGIONS = (0, True)

  def __init__(self, bufferSzs, asyncToken, asyncDependencies, spmatA, dnmatB, dnmatC, computeType, *, modeA=None, modeB=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(asyncDependencies))
    operands.append(_get_op_result_or_value(spmatA))
    operands.append(_get_op_result_or_value(dnmatB))
    operands.append(_get_op_result_or_value(dnmatC))
    _ods_context = _ods_get_default_loc_context(loc)
    if modeA is not None: attributes["modeA"] = (modeA if (
        issubclass(type(modeA), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('GPU_TransposeModeAttr')) else
          _ods_ir.AttrBuilder.get('GPU_TransposeModeAttr')(modeA, context=_ods_context))
    if modeB is not None: attributes["modeB"] = (modeB if (
        issubclass(type(modeB), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('GPU_TransposeModeAttr')) else
          _ods_ir.AttrBuilder.get('GPU_TransposeModeAttr')(modeB, context=_ods_context))
    attributes["computeType"] = (computeType if (
    issubclass(type(computeType), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypeAttr')) else
      _ods_ir.AttrBuilder.get('TypeAttr')(computeType, context=_ods_context))
    results.append(bufferSzs)
    if asyncToken is not None: results.append(asyncToken)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def asyncDependencies(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def spmatA(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[1 + _ods_variadic_group_length - 1]

  @builtins.property
  def dnmatB(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[2 + _ods_variadic_group_length - 1]

  @builtins.property
  def dnmatC(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[3 + _ods_variadic_group_length - 1]

  @builtins.property
  def modeA(self):
    return self.operation.attributes["modeA"]

  @modeA.setter
  def modeA(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["modeA"] = value

  @builtins.property
  def modeB(self):
    return self.operation.attributes["modeB"]

  @modeB.setter
  def modeB(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["modeB"] = value

  @builtins.property
  def computeType(self):
    return self.operation.attributes["computeType"]

  @computeType.setter
  def computeType(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["computeType"] = value

  @builtins.property
  def bufferSzs(self):
    result_range = _ods_segmented_accessor(
         self.operation.results,
         self.operation.attributes["resultSegmentSizes"], 0)
    return result_range

  @builtins.property
  def asyncToken(self):
    result_range = _ods_segmented_accessor(
         self.operation.results,
         self.operation.attributes["resultSegmentSizes"], 1)
    return result_range[0] if len(result_range) > 0 else None

def spmm_buffer_size(buffer_szs, async_token, async_dependencies, spmat_a, dnmat_b, dnmat_c, compute_type, *, mode_a=None, mode_b=None, loc=None, ip=None) -> _Sequence[_SubClassValueT]:
  return _get_op_result_or_op_results(SpMMBufferSizeOp(bufferSzs=buffer_szs, asyncToken=async_token, asyncDependencies=async_dependencies, spmatA=spmat_a, dnmatB=dnmat_b, dnmatC=dnmat_c, computeType=compute_type, modeA=mode_a, modeB=mode_b, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SpMMOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.spmm"

  _ODS_OPERAND_SEGMENTS = [-1,1,1,1,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, asyncToken, asyncDependencies, spmatA, dnmatB, dnmatC, computeType, buffers, *, modeA=None, modeB=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(asyncDependencies))
    operands.append(_get_op_result_or_value(spmatA))
    operands.append(_get_op_result_or_value(dnmatB))
    operands.append(_get_op_result_or_value(dnmatC))
    operands.append(_get_op_results_or_values(buffers))
    _ods_context = _ods_get_default_loc_context(loc)
    if modeA is not None: attributes["modeA"] = (modeA if (
        issubclass(type(modeA), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('GPU_TransposeModeAttr')) else
          _ods_ir.AttrBuilder.get('GPU_TransposeModeAttr')(modeA, context=_ods_context))
    if modeB is not None: attributes["modeB"] = (modeB if (
        issubclass(type(modeB), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('GPU_TransposeModeAttr')) else
          _ods_ir.AttrBuilder.get('GPU_TransposeModeAttr')(modeB, context=_ods_context))
    attributes["computeType"] = (computeType if (
    issubclass(type(computeType), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypeAttr')) else
      _ods_ir.AttrBuilder.get('TypeAttr')(computeType, context=_ods_context))
    if asyncToken is not None: results.append(asyncToken)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def asyncDependencies(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def spmatA(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0]

  @builtins.property
  def dnmatB(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range[0]

  @builtins.property
  def dnmatC(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range[0]

  @builtins.property
  def buffers(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 4)
    return operand_range

  @builtins.property
  def modeA(self):
    return self.operation.attributes["modeA"]

  @modeA.setter
  def modeA(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["modeA"] = value

  @builtins.property
  def modeB(self):
    return self.operation.attributes["modeB"]

  @modeB.setter
  def modeB(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["modeB"] = value

  @builtins.property
  def computeType(self):
    return self.operation.attributes["computeType"]

  @computeType.setter
  def computeType(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["computeType"] = value

  @builtins.property
  def asyncToken(self):
    return None if len(self.operation.results) < 1 else self.operation.results[0]

def spmm(async_token, async_dependencies, spmat_a, dnmat_b, dnmat_c, compute_type, buffers, *, mode_a=None, mode_b=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(SpMMOp(asyncToken=async_token, asyncDependencies=async_dependencies, spmatA=spmat_a, dnmatB=dnmat_b, dnmatC=dnmat_c, computeType=compute_type, buffers=buffers, modeA=mode_a, modeB=mode_b, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SpMVBufferSizeOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.spmv_buffer_size"

  _ODS_REGIONS = (0, True)

  def __init__(self, bufferSz, asyncToken, asyncDependencies, spmatA, dnX, dnY, computeType, *, modeA=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(asyncDependencies))
    operands.append(_get_op_result_or_value(spmatA))
    operands.append(_get_op_result_or_value(dnX))
    operands.append(_get_op_result_or_value(dnY))
    _ods_context = _ods_get_default_loc_context(loc)
    if modeA is not None: attributes["modeA"] = (modeA if (
        issubclass(type(modeA), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('GPU_TransposeModeAttr')) else
          _ods_ir.AttrBuilder.get('GPU_TransposeModeAttr')(modeA, context=_ods_context))
    attributes["computeType"] = (computeType if (
    issubclass(type(computeType), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypeAttr')) else
      _ods_ir.AttrBuilder.get('TypeAttr')(computeType, context=_ods_context))
    results.append(bufferSz)
    if asyncToken is not None: results.append(asyncToken)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def asyncDependencies(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def spmatA(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[1 + _ods_variadic_group_length - 1]

  @builtins.property
  def dnX(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[2 + _ods_variadic_group_length - 1]

  @builtins.property
  def dnY(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[3 + _ods_variadic_group_length - 1]

  @builtins.property
  def modeA(self):
    return self.operation.attributes["modeA"]

  @modeA.setter
  def modeA(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["modeA"] = value

  @builtins.property
  def computeType(self):
    return self.operation.attributes["computeType"]

  @computeType.setter
  def computeType(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["computeType"] = value

  @builtins.property
  def bufferSz(self):
    return self.operation.results[0]

  @builtins.property
  def asyncToken(self):
    return None if len(self.operation.results) < 2 else self.operation.results[1]

def spmv_buffer_size(buffer_sz, async_token, async_dependencies, spmat_a, dn_x, dn_y, compute_type, *, mode_a=None, loc=None, ip=None) -> _Sequence[_SubClassValueT]:
  return _get_op_result_or_op_results(SpMVBufferSizeOp(bufferSz=buffer_sz, asyncToken=async_token, asyncDependencies=async_dependencies, spmatA=spmat_a, dnX=dn_x, dnY=dn_y, computeType=compute_type, modeA=mode_a, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SpMVOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.spmv"

  _ODS_REGIONS = (0, True)

  def __init__(self, asyncToken, asyncDependencies, spmatA, dnX, dnY, computeType, buffer, *, modeA=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(asyncDependencies))
    operands.append(_get_op_result_or_value(spmatA))
    operands.append(_get_op_result_or_value(dnX))
    operands.append(_get_op_result_or_value(dnY))
    operands.append(_get_op_result_or_value(buffer))
    _ods_context = _ods_get_default_loc_context(loc)
    if modeA is not None: attributes["modeA"] = (modeA if (
        issubclass(type(modeA), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('GPU_TransposeModeAttr')) else
          _ods_ir.AttrBuilder.get('GPU_TransposeModeAttr')(modeA, context=_ods_context))
    attributes["computeType"] = (computeType if (
    issubclass(type(computeType), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypeAttr')) else
      _ods_ir.AttrBuilder.get('TypeAttr')(computeType, context=_ods_context))
    if asyncToken is not None: results.append(asyncToken)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def asyncDependencies(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def spmatA(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[1 + _ods_variadic_group_length - 1]

  @builtins.property
  def dnX(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[2 + _ods_variadic_group_length - 1]

  @builtins.property
  def dnY(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[3 + _ods_variadic_group_length - 1]

  @builtins.property
  def buffer(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[4 + _ods_variadic_group_length - 1]

  @builtins.property
  def modeA(self):
    return self.operation.attributes["modeA"]

  @modeA.setter
  def modeA(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["modeA"] = value

  @builtins.property
  def computeType(self):
    return self.operation.attributes["computeType"]

  @computeType.setter
  def computeType(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["computeType"] = value

  @builtins.property
  def asyncToken(self):
    return None if len(self.operation.results) < 1 else self.operation.results[0]

def spmv(async_token, async_dependencies, spmat_a, dn_x, dn_y, compute_type, buffer, *, mode_a=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(SpMVOp(asyncToken=async_token, asyncDependencies=async_dependencies, spmatA=spmat_a, dnX=dn_x, dnY=dn_y, computeType=compute_type, buffer=buffer, modeA=mode_a, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SpMatGetSizeOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.spmat_get_size"

  _ODS_REGIONS = (0, True)

  def __init__(self, rows, cols, nnz, asyncToken, asyncDependencies, spmat, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(asyncDependencies))
    operands.append(_get_op_result_or_value(spmat))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(rows)
    results.append(cols)
    results.append(nnz)
    if asyncToken is not None: results.append(asyncToken)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def asyncDependencies(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def spmat(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1 + _ods_variadic_group_length - 1]

  @builtins.property
  def rows(self):
    return self.operation.results[0]

  @builtins.property
  def cols(self):
    return self.operation.results[1]

  @builtins.property
  def nnz(self):
    return self.operation.results[2]

  @builtins.property
  def asyncToken(self):
    return None if len(self.operation.results) < 4 else self.operation.results[3]

def spmat_get_size(rows, cols, nnz, async_token, async_dependencies, spmat, *, loc=None, ip=None) -> _Sequence[_SubClassValueT]:
  return _get_op_result_or_op_results(SpMatGetSizeOp(rows=rows, cols=cols, nnz=nnz, asyncToken=async_token, asyncDependencies=async_dependencies, spmat=spmat, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SubgroupIdOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.subgroup_id"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def result(self):
    return self.operation.results[0]

def subgroup_id(*, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(SubgroupIdOp(loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SubgroupMmaComputeOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.subgroup_mma_compute"

  _ODS_REGIONS = (0, True)

  def __init__(self, opA, opB, opC, *, a_transpose=None, b_transpose=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(opA))
    operands.append(_get_op_result_or_value(opB))
    operands.append(_get_op_result_or_value(opC))
    _ods_context = _ods_get_default_loc_context(loc)
    if bool(a_transpose): attributes["a_transpose"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(b_transpose): attributes["b_transpose"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def opA(self):
    return self.operation.operands[0]

  @builtins.property
  def opB(self):
    return self.operation.operands[1]

  @builtins.property
  def opC(self):
    return self.operation.operands[2]

  @builtins.property
  def a_transpose(self):
    return "a_transpose" in self.operation.attributes

  @a_transpose.setter
  def a_transpose(self, value):
    if bool(value):
      self.operation.attributes["a_transpose"] = _ods_ir.UnitAttr.get()
    elif "a_transpose" in self.operation.attributes:
      del self.operation.attributes["a_transpose"]

  @a_transpose.deleter
  def a_transpose(self):
    del self.operation.attributes["a_transpose"]

  @builtins.property
  def b_transpose(self):
    return "b_transpose" in self.operation.attributes

  @b_transpose.setter
  def b_transpose(self, value):
    if bool(value):
      self.operation.attributes["b_transpose"] = _ods_ir.UnitAttr.get()
    elif "b_transpose" in self.operation.attributes:
      del self.operation.attributes["b_transpose"]

  @b_transpose.deleter
  def b_transpose(self):
    del self.operation.attributes["b_transpose"]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def subgroup_mma_compute(op_a, op_b, op_c, *, a_transpose=None, b_transpose=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(SubgroupMmaComputeOp(opA=op_a, opB=op_b, opC=op_c, a_transpose=a_transpose, b_transpose=b_transpose, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SubgroupMmaConstantMatrixOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.subgroup_mma_constant_matrix"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, value, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(value))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def value(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def subgroup_mma_constant_matrix(res, value, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(SubgroupMmaConstantMatrixOp(res=res, value=value, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SubgroupMmaElementwiseOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.subgroup_mma_elementwise"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, args, opType, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(args))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["opType"] = (opType if (
    issubclass(type(opType), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('MMAElementWiseAttr')) else
      _ods_ir.AttrBuilder.get('MMAElementWiseAttr')(opType, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def args(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def opType(self):
    return self.operation.attributes["opType"]

  @opType.setter
  def opType(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["opType"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def subgroup_mma_elementwise(res, args, op_type, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(SubgroupMmaElementwiseOp(res=res, args=args, opType=op_type, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SubgroupMmaLoadMatrixOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.subgroup_mma_load_matrix"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, srcMemref, indices, leadDimension, *, transpose=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(srcMemref))
    operands.extend(_get_op_results_or_values(indices))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["leadDimension"] = (leadDimension if (
    issubclass(type(leadDimension), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('IndexAttr')) else
      _ods_ir.AttrBuilder.get('IndexAttr')(leadDimension, context=_ods_context))
    if bool(transpose): attributes["transpose"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def srcMemref(self):
    return self.operation.operands[0]

  @builtins.property
  def indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def leadDimension(self):
    return self.operation.attributes["leadDimension"]

  @leadDimension.setter
  def leadDimension(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["leadDimension"] = value

  @builtins.property
  def transpose(self):
    return "transpose" in self.operation.attributes

  @transpose.setter
  def transpose(self, value):
    if bool(value):
      self.operation.attributes["transpose"] = _ods_ir.UnitAttr.get()
    elif "transpose" in self.operation.attributes:
      del self.operation.attributes["transpose"]

  @transpose.deleter
  def transpose(self):
    del self.operation.attributes["transpose"]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def subgroup_mma_load_matrix(res, src_memref, indices, lead_dimension, *, transpose=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(SubgroupMmaLoadMatrixOp(res=res, srcMemref=src_memref, indices=indices, leadDimension=lead_dimension, transpose=transpose, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SubgroupMmaStoreMatrixOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.subgroup_mma_store_matrix"

  _ODS_REGIONS = (0, True)

  def __init__(self, src, dstMemref, indices, leadDimension, *, transpose=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(src))
    operands.append(_get_op_result_or_value(dstMemref))
    operands.extend(_get_op_results_or_values(indices))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["leadDimension"] = (leadDimension if (
    issubclass(type(leadDimension), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('IndexAttr')) else
      _ods_ir.AttrBuilder.get('IndexAttr')(leadDimension, context=_ods_context))
    if bool(transpose): attributes["transpose"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def src(self):
    return self.operation.operands[0]

  @builtins.property
  def dstMemref(self):
    return self.operation.operands[1]

  @builtins.property
  def indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[2:2 + _ods_variadic_group_length]

  @builtins.property
  def leadDimension(self):
    return self.operation.attributes["leadDimension"]

  @leadDimension.setter
  def leadDimension(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["leadDimension"] = value

  @builtins.property
  def transpose(self):
    return "transpose" in self.operation.attributes

  @transpose.setter
  def transpose(self, value):
    if bool(value):
      self.operation.attributes["transpose"] = _ods_ir.UnitAttr.get()
    elif "transpose" in self.operation.attributes:
      del self.operation.attributes["transpose"]

  @transpose.deleter
  def transpose(self):
    del self.operation.attributes["transpose"]

def subgroup_mma_store_matrix(src, dst_memref, indices, lead_dimension, *, transpose=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(SubgroupMmaStoreMatrixOp(src=src, dstMemref=dst_memref, indices=indices, leadDimension=lead_dimension, transpose=transpose, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SubgroupReduceOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.subgroup_reduce"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, op, *, uniform=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(value))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["op"] = (op if (
    issubclass(type(op), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('GPU_AllReduceOperationAttr')) else
      _ods_ir.AttrBuilder.get('GPU_AllReduceOperationAttr')(op, context=_ods_context))
    if bool(uniform): attributes["uniform"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def value(self):
    return self.operation.operands[0]

  @builtins.property
  def op(self):
    return self.operation.attributes["op"]

  @op.setter
  def op(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["op"] = value

  @builtins.property
  def uniform(self):
    return "uniform" in self.operation.attributes

  @uniform.setter
  def uniform(self, value):
    if bool(value):
      self.operation.attributes["uniform"] = _ods_ir.UnitAttr.get()
    elif "uniform" in self.operation.attributes:
      del self.operation.attributes["uniform"]

  @uniform.deleter
  def uniform(self):
    del self.operation.attributes["uniform"]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def subgroup_reduce(value, op, *, uniform=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(SubgroupReduceOp(value=value, op=op, uniform=uniform, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SubgroupSizeOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.subgroup_size"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def result(self):
    return self.operation.results[0]

def subgroup_size(*, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(SubgroupSizeOp(loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class TerminatorOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.terminator"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

def terminator(*, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(TerminatorOp(loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ThreadIdOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.thread_id"

  _ODS_REGIONS = (0, True)

  def __init__(self, dimension, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dimension"] = (dimension if (
    issubclass(type(dimension), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('GPU_DimensionAttr')) else
      _ods_ir.AttrBuilder.get('GPU_DimensionAttr')(dimension, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def dimension(self):
    return self.operation.attributes["dimension"]

  @dimension.setter
  def dimension(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dimension"] = value

def thread_id(dimension, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(ThreadIdOp(dimension=dimension, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class WaitOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.wait"

  _ODS_REGIONS = (0, True)

  def __init__(self, asyncToken, asyncDependencies, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(asyncDependencies))
    _ods_context = _ods_get_default_loc_context(loc)
    if asyncToken is not None: results.append(asyncToken)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def asyncDependencies(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def asyncToken(self):
    return None if len(self.operation.results) < 1 else self.operation.results[0]

def wait(async_token, async_dependencies, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(WaitOp(asyncToken=async_token, asyncDependencies=async_dependencies, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class YieldOp(_ods_ir.OpView):
  OPERATION_NAME = "gpu.yield"

  _ODS_REGIONS = (0, True)

  def __init__(self, values, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(values))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def values(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def yield_(values, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(YieldOp(values=values, loc=loc, ip=ip))
