
# Autogenerated by mlir-tblgen; don't manually edit.

from ._ods_common import _cext as _ods_cext
from ._ods_common import (
    SubClassValueT as _SubClassValueT,
    equally_sized_accessor as _ods_equally_sized_accessor,
    get_default_loc_context as _ods_get_default_loc_context,
    get_op_result_or_op_results as _get_op_result_or_op_results,
    get_op_result_or_value as _get_op_result_or_value,
    get_op_results_or_values as _get_op_results_or_values,
    segmented_accessor as _ods_segmented_accessor,
)
_ods_ir = _ods_cext.ir

import builtins
from typing import Sequence as _Sequence, Union as _Union


@_ods_cext.register_dialect
class _Dialect(_ods_ir.Dialect):
  DIALECT_NAMESPACE = "linalg"
  pass


@_ods_cext.register_operation(_Dialect)
class AbsOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.abs"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def abs(result_tensors, inputs, outputs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(AbsOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AddOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.add"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def add(result_tensors, inputs, outputs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(AddOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class BatchMatmulOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.batch_matmul"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def batch_matmul(result_tensors, inputs, outputs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(BatchMatmulOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class BatchMatmulTransposeAOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.batch_matmul_transpose_a"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def batch_matmul_transpose_a(result_tensors, inputs, outputs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(BatchMatmulTransposeAOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class BatchMatmulTransposeBOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.batch_matmul_transpose_b"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def batch_matmul_transpose_b(result_tensors, inputs, outputs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(BatchMatmulTransposeBOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class BatchMatvecOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.batch_matvec"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def batch_matvec(result_tensors, inputs, outputs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(BatchMatvecOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class BatchMmt4DOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.batch_mmt4d"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def batch_mmt4d(result_tensors, inputs, outputs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(BatchMmt4DOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class BatchReduceMatmulOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.batch_reduce_matmul"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def batch_reduce_matmul(result_tensors, inputs, outputs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(BatchReduceMatmulOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class BatchVecmatOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.batch_vecmat"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def batch_vecmat(result_tensors, inputs, outputs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(BatchVecmatOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class BroadcastOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.broadcast"

  _ODS_REGIONS = (1, True)

  def __init__(self, result, input, init, dimensions, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(input))
    operands.append(_get_op_result_or_value(init))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dimensions"] = (dimensions if (
    issubclass(type(dimensions), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(dimensions, context=_ods_context))
    results.extend(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def init(self):
    return self.operation.operands[1]

  @builtins.property
  def dimensions(self):
    return self.operation.attributes["dimensions"]

  @dimensions.setter
  def dimensions(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dimensions"] = value

  @builtins.property
  def result(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def broadcast(result, input, init, dimensions, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(BroadcastOp(result=result, input=input, init=init, dimensions=dimensions, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CeilOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.ceil"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def ceil(result_tensors, inputs, outputs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(CeilOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class Conv1DNcwFcwOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.conv_1d_ncw_fcw"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_639')) else
          _ods_ir.AttrBuilder.get('anonymous_639')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_639')) else
          _ods_ir.AttrBuilder.get('anonymous_639')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def conv_1d_ncw_fcw(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(Conv1DNcwFcwOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class Conv1DNwcWcfOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.conv_1d_nwc_wcf"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_639')) else
          _ods_ir.AttrBuilder.get('anonymous_639')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_639')) else
          _ods_ir.AttrBuilder.get('anonymous_639')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def conv_1d_nwc_wcf(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(Conv1DNwcWcfOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class Conv1DOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.conv_1d"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def conv_1d(result_tensors, inputs, outputs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(Conv1DOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class Conv2DNchwFchwOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.conv_2d_nchw_fchw"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def conv_2d_nchw_fchw(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(Conv2DNchwFchwOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class Conv2DNgchwFgchwOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.conv_2d_ngchw_fgchw"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def conv_2d_ngchw_fgchw(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(Conv2DNgchwFgchwOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class Conv2DNgchwGfchwOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.conv_2d_ngchw_gfchw"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def conv_2d_ngchw_gfchw(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(Conv2DNgchwGfchwOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class Conv2DNhwcFhwcOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.conv_2d_nhwc_fhwc"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def conv_2d_nhwc_fhwc(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(Conv2DNhwcFhwcOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class Conv2DNhwcFhwcQOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.conv_2d_nhwc_fhwc_q"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def conv_2d_nhwc_fhwc_q(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(Conv2DNhwcFhwcQOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class Conv2DNhwcHwcfOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.conv_2d_nhwc_hwcf"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def conv_2d_nhwc_hwcf(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(Conv2DNhwcHwcfOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class Conv2DNhwcHwcfQOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.conv_2d_nhwc_hwcf_q"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def conv_2d_nhwc_hwcf_q(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(Conv2DNhwcHwcfQOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class Conv2DOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.conv_2d"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def conv_2d(result_tensors, inputs, outputs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(Conv2DOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class Conv3DNcdhwFcdhwOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.conv_3d_ncdhw_fcdhw"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_674')) else
          _ods_ir.AttrBuilder.get('anonymous_674')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_674')) else
          _ods_ir.AttrBuilder.get('anonymous_674')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def conv_3d_ncdhw_fcdhw(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(Conv3DNcdhwFcdhwOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class Conv3DNdhwcDhwcfOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.conv_3d_ndhwc_dhwcf"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_674')) else
          _ods_ir.AttrBuilder.get('anonymous_674')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_674')) else
          _ods_ir.AttrBuilder.get('anonymous_674')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def conv_3d_ndhwc_dhwcf(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(Conv3DNdhwcDhwcfOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class Conv3DNdhwcDhwcfQOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.conv_3d_ndhwc_dhwcf_q"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_674')) else
          _ods_ir.AttrBuilder.get('anonymous_674')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_674')) else
          _ods_ir.AttrBuilder.get('anonymous_674')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def conv_3d_ndhwc_dhwcf_q(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(Conv3DNdhwcDhwcfQOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class Conv3DOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.conv_3d"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def conv_3d(result_tensors, inputs, outputs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(Conv3DOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CopyOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.copy"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, cast=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if cast is not None: attributes["cast"] = (cast if (
        issubclass(type(cast), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('TypeFnAttr')) else
          _ods_ir.AttrBuilder.get('TypeFnAttr')(cast, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def cast(self):
    if "cast" not in self.operation.attributes:
      return None
    return self.operation.attributes["cast"]

  @cast.setter
  def cast(self, value):
    if value is not None:
      self.operation.attributes["cast"] = value
    elif "cast" in self.operation.attributes:
      del self.operation.attributes["cast"]

  @cast.deleter
  def cast(self):
    del self.operation.attributes["cast"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def copy(result_tensors, inputs, outputs, *, cast=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(CopyOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, cast=cast, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class DepthwiseConv1DNcwCwOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.depthwise_conv_1d_ncw_cw"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_639')) else
          _ods_ir.AttrBuilder.get('anonymous_639')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_639')) else
          _ods_ir.AttrBuilder.get('anonymous_639')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def depthwise_conv_1d_ncw_cw(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(DepthwiseConv1DNcwCwOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class DepthwiseConv1DNwcWcOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.depthwise_conv_1d_nwc_wc"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_639')) else
          _ods_ir.AttrBuilder.get('anonymous_639')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_639')) else
          _ods_ir.AttrBuilder.get('anonymous_639')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def depthwise_conv_1d_nwc_wc(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(DepthwiseConv1DNwcWcOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class DepthwiseConv1DNwcWcmOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.depthwise_conv_1d_nwc_wcm"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_639')) else
          _ods_ir.AttrBuilder.get('anonymous_639')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_639')) else
          _ods_ir.AttrBuilder.get('anonymous_639')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def depthwise_conv_1d_nwc_wcm(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(DepthwiseConv1DNwcWcmOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class DepthwiseConv2DNchwChwOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.depthwise_conv_2d_nchw_chw"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def depthwise_conv_2d_nchw_chw(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(DepthwiseConv2DNchwChwOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class DepthwiseConv2DNhwcHwcOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.depthwise_conv_2d_nhwc_hwc"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def depthwise_conv_2d_nhwc_hwc(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(DepthwiseConv2DNhwcHwcOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class DepthwiseConv2DNhwcHwcQOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.depthwise_conv_2d_nhwc_hwc_q"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def depthwise_conv_2d_nhwc_hwc_q(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(DepthwiseConv2DNhwcHwcQOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class DepthwiseConv2DNhwcHwcmOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.depthwise_conv_2d_nhwc_hwcm"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def depthwise_conv_2d_nhwc_hwcm(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(DepthwiseConv2DNhwcHwcmOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class DepthwiseConv2DNhwcHwcmQOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.depthwise_conv_2d_nhwc_hwcm_q"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def depthwise_conv_2d_nhwc_hwcm_q(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(DepthwiseConv2DNhwcHwcmQOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class DepthwiseConv3DNcdhwCdhwOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.depthwise_conv_3d_ncdhw_cdhw"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_674')) else
          _ods_ir.AttrBuilder.get('anonymous_674')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_674')) else
          _ods_ir.AttrBuilder.get('anonymous_674')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def depthwise_conv_3d_ncdhw_cdhw(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(DepthwiseConv3DNcdhwCdhwOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class DepthwiseConv3DNdhwcDhwcOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.depthwise_conv_3d_ndhwc_dhwc"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_674')) else
          _ods_ir.AttrBuilder.get('anonymous_674')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_674')) else
          _ods_ir.AttrBuilder.get('anonymous_674')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def depthwise_conv_3d_ndhwc_dhwc(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(DepthwiseConv3DNdhwcDhwcOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class DepthwiseConv3DNdhwcDhwcmOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.depthwise_conv_3d_ndhwc_dhwcm"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_674')) else
          _ods_ir.AttrBuilder.get('anonymous_674')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_674')) else
          _ods_ir.AttrBuilder.get('anonymous_674')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def depthwise_conv_3d_ndhwc_dhwcm(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(DepthwiseConv3DNdhwcDhwcmOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class DivOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.div"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def div(result_tensors, inputs, outputs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(DivOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class DivUnsignedOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.div_unsigned"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def div_unsigned(result_tensors, inputs, outputs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(DivUnsignedOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class DotOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.dot"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def dot(result_tensors, inputs, outputs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(DotOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ElemwiseBinaryOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.elemwise_binary"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, fun=None, cast=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if fun is not None: attributes["fun"] = (fun if (
        issubclass(type(fun), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BinaryFnAttr')) else
          _ods_ir.AttrBuilder.get('BinaryFnAttr')(fun, context=_ods_context))
    if cast is not None: attributes["cast"] = (cast if (
        issubclass(type(cast), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('TypeFnAttr')) else
          _ods_ir.AttrBuilder.get('TypeFnAttr')(cast, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def fun(self):
    if "fun" not in self.operation.attributes:
      return None
    return self.operation.attributes["fun"]

  @fun.setter
  def fun(self, value):
    if value is not None:
      self.operation.attributes["fun"] = value
    elif "fun" in self.operation.attributes:
      del self.operation.attributes["fun"]

  @fun.deleter
  def fun(self):
    del self.operation.attributes["fun"]

  @builtins.property
  def cast(self):
    if "cast" not in self.operation.attributes:
      return None
    return self.operation.attributes["cast"]

  @cast.setter
  def cast(self, value):
    if value is not None:
      self.operation.attributes["cast"] = value
    elif "cast" in self.operation.attributes:
      del self.operation.attributes["cast"]

  @cast.deleter
  def cast(self):
    del self.operation.attributes["cast"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def elemwise_binary(result_tensors, inputs, outputs, *, fun=None, cast=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(ElemwiseBinaryOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, fun=fun, cast=cast, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ElemwiseUnaryOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.elemwise_unary"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, fun=None, cast=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if fun is not None: attributes["fun"] = (fun if (
        issubclass(type(fun), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('UnaryFnAttr')) else
          _ods_ir.AttrBuilder.get('UnaryFnAttr')(fun, context=_ods_context))
    if cast is not None: attributes["cast"] = (cast if (
        issubclass(type(cast), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('TypeFnAttr')) else
          _ods_ir.AttrBuilder.get('TypeFnAttr')(cast, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def fun(self):
    if "fun" not in self.operation.attributes:
      return None
    return self.operation.attributes["fun"]

  @fun.setter
  def fun(self, value):
    if value is not None:
      self.operation.attributes["fun"] = value
    elif "fun" in self.operation.attributes:
      del self.operation.attributes["fun"]

  @fun.deleter
  def fun(self):
    del self.operation.attributes["fun"]

  @builtins.property
  def cast(self):
    if "cast" not in self.operation.attributes:
      return None
    return self.operation.attributes["cast"]

  @cast.setter
  def cast(self, value):
    if value is not None:
      self.operation.attributes["cast"] = value
    elif "cast" in self.operation.attributes:
      del self.operation.attributes["cast"]

  @cast.deleter
  def cast(self):
    del self.operation.attributes["cast"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def elemwise_unary(result_tensors, inputs, outputs, *, fun=None, cast=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(ElemwiseUnaryOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, fun=fun, cast=cast, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ExpOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.exp"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def exp(result_tensors, inputs, outputs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(ExpOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FillOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.fill"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def fill(result_tensors, inputs, outputs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(FillOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FillRng2DOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.fill_rng_2d"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def fill_rng_2d(result_tensors, inputs, outputs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(FillRng2DOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FloorOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.floor"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def floor(result_tensors, inputs, outputs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(FloorOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class GenericOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.generic"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, indexing_maps, iterator_types, *, doc=None, library_call=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["indexing_maps"] = (indexing_maps if (
    issubclass(type(indexing_maps), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('AffineMapArrayAttr')) else
      _ods_ir.AttrBuilder.get('AffineMapArrayAttr')(indexing_maps, context=_ods_context))
    attributes["iterator_types"] = (iterator_types if (
    issubclass(type(iterator_types), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('IteratorTypeArrayAttr')) else
      _ods_ir.AttrBuilder.get('IteratorTypeArrayAttr')(iterator_types, context=_ods_context))
    if doc is not None: attributes["doc"] = (doc if (
        issubclass(type(doc), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(doc, context=_ods_context))
    if library_call is not None: attributes["library_call"] = (library_call if (
        issubclass(type(library_call), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(library_call, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def indexing_maps(self):
    return self.operation.attributes["indexing_maps"]

  @indexing_maps.setter
  def indexing_maps(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["indexing_maps"] = value

  @builtins.property
  def iterator_types(self):
    return self.operation.attributes["iterator_types"]

  @iterator_types.setter
  def iterator_types(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["iterator_types"] = value

  @builtins.property
  def doc(self):
    if "doc" not in self.operation.attributes:
      return None
    return self.operation.attributes["doc"]

  @doc.setter
  def doc(self, value):
    if value is not None:
      self.operation.attributes["doc"] = value
    elif "doc" in self.operation.attributes:
      del self.operation.attributes["doc"]

  @doc.deleter
  def doc(self):
    del self.operation.attributes["doc"]

  @builtins.property
  def library_call(self):
    if "library_call" not in self.operation.attributes:
      return None
    return self.operation.attributes["library_call"]

  @library_call.setter
  def library_call(self, value):
    if value is not None:
      self.operation.attributes["library_call"] = value
    elif "library_call" in self.operation.attributes:
      del self.operation.attributes["library_call"]

  @library_call.deleter
  def library_call(self):
    del self.operation.attributes["library_call"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def generic(result_tensors, inputs, outputs, indexing_maps, iterator_types, *, doc=None, library_call=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(GenericOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, indexing_maps=indexing_maps, iterator_types=iterator_types, doc=doc, library_call=library_call, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class IndexOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.index"

  _ODS_REGIONS = (0, True)

  def __init__(self, dim, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dim"] = (dim if (
    issubclass(type(dim), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(dim, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def dim(self):
    return self.operation.attributes["dim"]

  @dim.setter
  def dim(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dim"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def index(dim, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(IndexOp(dim=dim, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SoftmaxOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.softmax"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, input, output, dimension, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(input))
    operands.append(_get_op_result_or_value(output))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dimension"] = (dimension if (
    issubclass(type(dimension), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(dimension, context=_ods_context))
    results.extend(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def output(self):
    return self.operation.operands[1]

  @builtins.property
  def dimension(self):
    return self.operation.attributes["dimension"]

  @dimension.setter
  def dimension(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dimension"] = value

  @builtins.property
  def result(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

def softmax(result, input, output, dimension, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(SoftmaxOp(result=result, input=input, output=output, dimension=dimension, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class YieldOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.yield"

  _ODS_REGIONS = (0, True)

  def __init__(self, values, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(values))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def values(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def yield_(values, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(YieldOp(values=values, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class LogOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.log"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def log(result_tensors, inputs, outputs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(LogOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MapOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.map"

  _ODS_REGIONS = (1, True)

  def __init__(self, result, inputs, init, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    operands.append(_get_op_result_or_value(init))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def init(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1 + _ods_variadic_group_length - 1]

  @builtins.property
  def result(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def mapper(self):
    return self.regions[0]

def map(result, inputs, init, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(MapOp(result=result, inputs=inputs, init=init, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MatmulOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.matmul"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, cast=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if cast is not None: attributes["cast"] = (cast if (
        issubclass(type(cast), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('TypeFnAttr')) else
          _ods_ir.AttrBuilder.get('TypeFnAttr')(cast, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def cast(self):
    if "cast" not in self.operation.attributes:
      return None
    return self.operation.attributes["cast"]

  @cast.setter
  def cast(self, value):
    if value is not None:
      self.operation.attributes["cast"] = value
    elif "cast" in self.operation.attributes:
      del self.operation.attributes["cast"]

  @cast.deleter
  def cast(self):
    del self.operation.attributes["cast"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def matmul(result_tensors, inputs, outputs, *, cast=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(MatmulOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, cast=cast, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MatmulTransposeAOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.matmul_transpose_a"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, cast=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if cast is not None: attributes["cast"] = (cast if (
        issubclass(type(cast), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('TypeFnAttr')) else
          _ods_ir.AttrBuilder.get('TypeFnAttr')(cast, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def cast(self):
    if "cast" not in self.operation.attributes:
      return None
    return self.operation.attributes["cast"]

  @cast.setter
  def cast(self, value):
    if value is not None:
      self.operation.attributes["cast"] = value
    elif "cast" in self.operation.attributes:
      del self.operation.attributes["cast"]

  @cast.deleter
  def cast(self):
    del self.operation.attributes["cast"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def matmul_transpose_a(result_tensors, inputs, outputs, *, cast=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(MatmulTransposeAOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, cast=cast, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MatmulTransposeBOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.matmul_transpose_b"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, cast=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if cast is not None: attributes["cast"] = (cast if (
        issubclass(type(cast), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('TypeFnAttr')) else
          _ods_ir.AttrBuilder.get('TypeFnAttr')(cast, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def cast(self):
    if "cast" not in self.operation.attributes:
      return None
    return self.operation.attributes["cast"]

  @cast.setter
  def cast(self, value):
    if value is not None:
      self.operation.attributes["cast"] = value
    elif "cast" in self.operation.attributes:
      del self.operation.attributes["cast"]

  @cast.deleter
  def cast(self):
    del self.operation.attributes["cast"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def matmul_transpose_b(result_tensors, inputs, outputs, *, cast=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(MatmulTransposeBOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, cast=cast, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MatmulUnsignedOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.matmul_unsigned"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def matmul_unsigned(result_tensors, inputs, outputs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(MatmulUnsignedOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MatvecOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.matvec"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def matvec(result_tensors, inputs, outputs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(MatvecOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MaxOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.max"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def max(result_tensors, inputs, outputs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(MaxOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class Mmt4DOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.mmt4d"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def mmt4d(result_tensors, inputs, outputs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(Mmt4DOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MulOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.mul"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def mul(result_tensors, inputs, outputs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(MulOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class NegfOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.negf"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def negf(result_tensors, inputs, outputs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(NegfOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class PoolingNchwMaxOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.pooling_nchw_max"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def pooling_nchw_max(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(PoolingNchwMaxOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class PoolingNchwSumOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.pooling_nchw_sum"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def pooling_nchw_sum(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(PoolingNchwSumOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class PoolingNcwMaxOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.pooling_ncw_max"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_639')) else
          _ods_ir.AttrBuilder.get('anonymous_639')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_639')) else
          _ods_ir.AttrBuilder.get('anonymous_639')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def pooling_ncw_max(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(PoolingNcwMaxOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class PoolingNcwSumOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.pooling_ncw_sum"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_639')) else
          _ods_ir.AttrBuilder.get('anonymous_639')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_639')) else
          _ods_ir.AttrBuilder.get('anonymous_639')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def pooling_ncw_sum(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(PoolingNcwSumOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class PoolingNdhwcMaxOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.pooling_ndhwc_max"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_674')) else
          _ods_ir.AttrBuilder.get('anonymous_674')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_674')) else
          _ods_ir.AttrBuilder.get('anonymous_674')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def pooling_ndhwc_max(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(PoolingNdhwcMaxOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class PoolingNdhwcMinOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.pooling_ndhwc_min"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_674')) else
          _ods_ir.AttrBuilder.get('anonymous_674')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_674')) else
          _ods_ir.AttrBuilder.get('anonymous_674')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def pooling_ndhwc_min(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(PoolingNdhwcMinOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class PoolingNdhwcSumOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.pooling_ndhwc_sum"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_674')) else
          _ods_ir.AttrBuilder.get('anonymous_674')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_674')) else
          _ods_ir.AttrBuilder.get('anonymous_674')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def pooling_ndhwc_sum(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(PoolingNdhwcSumOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class PoolingNhwcMaxOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.pooling_nhwc_max"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def pooling_nhwc_max(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(PoolingNhwcMaxOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class PoolingNhwcMaxUnsignedOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.pooling_nhwc_max_unsigned"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def pooling_nhwc_max_unsigned(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(PoolingNhwcMaxUnsignedOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class PoolingNhwcMinOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.pooling_nhwc_min"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def pooling_nhwc_min(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(PoolingNhwcMinOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class PoolingNhwcMinUnsignedOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.pooling_nhwc_min_unsigned"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def pooling_nhwc_min_unsigned(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(PoolingNhwcMinUnsignedOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class PoolingNhwcSumOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.pooling_nhwc_sum"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_649')) else
          _ods_ir.AttrBuilder.get('anonymous_649')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def pooling_nhwc_sum(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(PoolingNhwcSumOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class PoolingNwcMaxOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.pooling_nwc_max"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_639')) else
          _ods_ir.AttrBuilder.get('anonymous_639')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_639')) else
          _ods_ir.AttrBuilder.get('anonymous_639')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def pooling_nwc_max(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(PoolingNwcMaxOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class PoolingNwcMaxUnsignedOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.pooling_nwc_max_unsigned"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_639')) else
          _ods_ir.AttrBuilder.get('anonymous_639')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_639')) else
          _ods_ir.AttrBuilder.get('anonymous_639')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def pooling_nwc_max_unsigned(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(PoolingNwcMaxUnsignedOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class PoolingNwcMinOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.pooling_nwc_min"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_639')) else
          _ods_ir.AttrBuilder.get('anonymous_639')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_639')) else
          _ods_ir.AttrBuilder.get('anonymous_639')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def pooling_nwc_min(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(PoolingNwcMinOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class PoolingNwcMinUnsignedOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.pooling_nwc_min_unsigned"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_639')) else
          _ods_ir.AttrBuilder.get('anonymous_639')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_639')) else
          _ods_ir.AttrBuilder.get('anonymous_639')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def pooling_nwc_min_unsigned(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(PoolingNwcMinUnsignedOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class PoolingNwcSumOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.pooling_nwc_sum"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if strides is not None: attributes["strides"] = (strides if (
        issubclass(type(strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_639')) else
          _ods_ir.AttrBuilder.get('anonymous_639')(strides, context=_ods_context))
    if dilations is not None: attributes["dilations"] = (dilations if (
        issubclass(type(dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_639')) else
          _ods_ir.AttrBuilder.get('anonymous_639')(dilations, context=_ods_context))
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def strides(self):
    if "strides" not in self.operation.attributes:
      return None
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is not None:
      self.operation.attributes["strides"] = value
    elif "strides" in self.operation.attributes:
      del self.operation.attributes["strides"]

  @strides.deleter
  def strides(self):
    del self.operation.attributes["strides"]

  @builtins.property
  def dilations(self):
    if "dilations" not in self.operation.attributes:
      return None
    return self.operation.attributes["dilations"]

  @dilations.setter
  def dilations(self, value):
    if value is not None:
      self.operation.attributes["dilations"] = value
    elif "dilations" in self.operation.attributes:
      del self.operation.attributes["dilations"]

  @dilations.deleter
  def dilations(self):
    del self.operation.attributes["dilations"]

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def pooling_nwc_sum(result_tensors, inputs, outputs, *, strides=None, dilations=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(PoolingNwcSumOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, strides=strides, dilations=dilations, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class QuantizedBatchMatmulOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.quantized_batch_matmul"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def quantized_batch_matmul(result_tensors, inputs, outputs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(QuantizedBatchMatmulOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class QuantizedMatmulOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.quantized_matmul"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def quantized_matmul(result_tensors, inputs, outputs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(QuantizedMatmulOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ReduceOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.reduce"

  _ODS_REGIONS = (1, True)

  def __init__(self, result, inputs, inits, dimensions, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    operands.extend(_get_op_results_or_values(inits))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dimensions"] = (dimensions if (
    issubclass(type(dimensions), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(dimensions, context=_ods_context))
    results.extend(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    start, pg = _ods_equally_sized_accessor(operation.operands, 2, 0, 0)
    return self.operation.operands[start:start + pg]

  @builtins.property
  def inits(self):
    start, pg = _ods_equally_sized_accessor(operation.operands, 2, 0, 1)
    return self.operation.operands[start:start + pg]

  @builtins.property
  def dimensions(self):
    return self.operation.attributes["dimensions"]

  @dimensions.setter
  def dimensions(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dimensions"] = value

  @builtins.property
  def combiner(self):
    return self.regions[0]

def reduce(result, inputs, inits, dimensions, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(ReduceOp(result=result, inputs=inputs, inits=inits, dimensions=dimensions, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SubOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.sub"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def sub(result_tensors, inputs, outputs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(SubOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class TransposeOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.transpose"

  _ODS_REGIONS = (1, True)

  def __init__(self, result, input, init, permutation, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(input))
    operands.append(_get_op_result_or_value(init))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["permutation"] = (permutation if (
    issubclass(type(permutation), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(permutation, context=_ods_context))
    results.extend(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def init(self):
    return self.operation.operands[1]

  @builtins.property
  def permutation(self):
    return self.operation.attributes["permutation"]

  @permutation.setter
  def permutation(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["permutation"] = value

  @builtins.property
  def result(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def transpose(result, input, init, permutation, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(TransposeOp(result=result, input=input, init=init, permutation=permutation, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VecmatOp(_ods_ir.OpView):
  OPERATION_NAME = "linalg.vecmat"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result_tensors, inputs, outputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(inputs))
    operands.append(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result_tensors)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def outputs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def result_tensors(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def vecmat(result_tensors, inputs, outputs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(VecmatOp(result_tensors=result_tensors, inputs=inputs, outputs=outputs, loc=loc, ip=ip))
