
# Autogenerated by mlir-tblgen; don't manually edit.

from ._ods_common import _cext as _ods_cext
from ._ods_common import (
    SubClassValueT as _SubClassValueT,
    equally_sized_accessor as _ods_equally_sized_accessor,
    get_default_loc_context as _ods_get_default_loc_context,
    get_op_result_or_op_results as _get_op_result_or_op_results,
    get_op_result_or_value as _get_op_result_or_value,
    get_op_results_or_values as _get_op_results_or_values,
    segmented_accessor as _ods_segmented_accessor,
)
_ods_ir = _ods_cext.ir

import builtins
from typing import Sequence as _Sequence, Union as _Union


@_ods_cext.register_dialect
class _Dialect(_ods_ir.Dialect):
  DIALECT_NAMESPACE = "llvm"
  pass


@_ods_cext.register_operation(_Dialect)
class AShrOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.ashr"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def ashr(lhs, rhs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(AShrOp(lhs=lhs, rhs=rhs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AddOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.add"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, overflowFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    if overflowFlags is not None: attributes["overflowFlags"] = (overflowFlags if (
        issubclass(type(overflowFlags), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_IntegerOverflowFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_IntegerOverflowFlagsAttr')(overflowFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def overflowFlags(self):
    return self.operation.attributes["overflowFlags"]

  @overflowFlags.setter
  def overflowFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["overflowFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def add(lhs, rhs, *, overflow_flags=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(AddOp(lhs=lhs, rhs=rhs, overflowFlags=overflow_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AddrSpaceCastOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.addrspacecast"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, arg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(arg))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def addrspacecast(res, arg, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(AddrSpaceCastOp(res=res, arg=arg, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AddressOfOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.mlir.addressof"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, global_name, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["global_name"] = (global_name if (
    issubclass(type(global_name), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
      _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(global_name, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def global_name(self):
    return self.operation.attributes["global_name"]

  @global_name.setter
  def global_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["global_name"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def mlir_addressof(res, global_name, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(AddressOfOp(res=res, global_name=global_name, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AllocaOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.alloca"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, arraySize, elem_type, *, alignment=None, inalloca=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(arraySize))
    _ods_context = _ods_get_default_loc_context(loc)
    if alignment is not None: attributes["alignment"] = (alignment if (
        issubclass(type(alignment), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(alignment, context=_ods_context))
    attributes["elem_type"] = (elem_type if (
    issubclass(type(elem_type), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypeAttr')) else
      _ods_ir.AttrBuilder.get('TypeAttr')(elem_type, context=_ods_context))
    if bool(inalloca): attributes["inalloca"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arraySize(self):
    return self.operation.operands[0]

  @builtins.property
  def alignment(self):
    if "alignment" not in self.operation.attributes:
      return None
    return self.operation.attributes["alignment"]

  @alignment.setter
  def alignment(self, value):
    if value is not None:
      self.operation.attributes["alignment"] = value
    elif "alignment" in self.operation.attributes:
      del self.operation.attributes["alignment"]

  @alignment.deleter
  def alignment(self):
    del self.operation.attributes["alignment"]

  @builtins.property
  def elem_type(self):
    return self.operation.attributes["elem_type"]

  @elem_type.setter
  def elem_type(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["elem_type"] = value

  @builtins.property
  def inalloca(self):
    return "inalloca" in self.operation.attributes

  @inalloca.setter
  def inalloca(self, value):
    if bool(value):
      self.operation.attributes["inalloca"] = _ods_ir.UnitAttr.get()
    elif "inalloca" in self.operation.attributes:
      del self.operation.attributes["inalloca"]

  @inalloca.deleter
  def inalloca(self):
    del self.operation.attributes["inalloca"]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def alloca(res, array_size, elem_type, *, alignment=None, inalloca=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(AllocaOp(res=res, arraySize=array_size, elem_type=elem_type, alignment=alignment, inalloca=inalloca, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AndOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.and"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def and_(lhs, rhs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(AndOp(lhs=lhs, rhs=rhs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AtomicCmpXchgOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.cmpxchg"

  _ODS_REGIONS = (0, True)

  def __init__(self, ptr, cmp, val, success_ordering, failure_ordering, *, syncscope=None, alignment=None, weak=None, volatile_=None, access_groups=None, alias_scopes=None, noalias_scopes=None, tbaa=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(ptr))
    operands.append(_get_op_result_or_value(cmp))
    operands.append(_get_op_result_or_value(val))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["success_ordering"] = (success_ordering if (
    issubclass(type(success_ordering), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('AtomicOrdering')) else
      _ods_ir.AttrBuilder.get('AtomicOrdering')(success_ordering, context=_ods_context))
    attributes["failure_ordering"] = (failure_ordering if (
    issubclass(type(failure_ordering), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('AtomicOrdering')) else
      _ods_ir.AttrBuilder.get('AtomicOrdering')(failure_ordering, context=_ods_context))
    if syncscope is not None: attributes["syncscope"] = (syncscope if (
        issubclass(type(syncscope), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(syncscope, context=_ods_context))
    if alignment is not None: attributes["alignment"] = (alignment if (
        issubclass(type(alignment), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(alignment, context=_ods_context))
    if bool(weak): attributes["weak"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(volatile_): attributes["volatile_"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if access_groups is not None: attributes["access_groups"] = (access_groups if (
        issubclass(type(access_groups), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AccessGroupArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AccessGroupArrayAttr')(access_groups, context=_ods_context))
    if alias_scopes is not None: attributes["alias_scopes"] = (alias_scopes if (
        issubclass(type(alias_scopes), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AliasScopeArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AliasScopeArrayAttr')(alias_scopes, context=_ods_context))
    if noalias_scopes is not None: attributes["noalias_scopes"] = (noalias_scopes if (
        issubclass(type(noalias_scopes), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AliasScopeArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AliasScopeArrayAttr')(noalias_scopes, context=_ods_context))
    if tbaa is not None: attributes["tbaa"] = (tbaa if (
        issubclass(type(tbaa), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_TBAATagArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_TBAATagArrayAttr')(tbaa, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def ptr(self):
    return self.operation.operands[0]

  @builtins.property
  def cmp(self):
    return self.operation.operands[1]

  @builtins.property
  def val(self):
    return self.operation.operands[2]

  @builtins.property
  def success_ordering(self):
    return self.operation.attributes["success_ordering"]

  @success_ordering.setter
  def success_ordering(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["success_ordering"] = value

  @builtins.property
  def failure_ordering(self):
    return self.operation.attributes["failure_ordering"]

  @failure_ordering.setter
  def failure_ordering(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["failure_ordering"] = value

  @builtins.property
  def syncscope(self):
    if "syncscope" not in self.operation.attributes:
      return None
    return self.operation.attributes["syncscope"]

  @syncscope.setter
  def syncscope(self, value):
    if value is not None:
      self.operation.attributes["syncscope"] = value
    elif "syncscope" in self.operation.attributes:
      del self.operation.attributes["syncscope"]

  @syncscope.deleter
  def syncscope(self):
    del self.operation.attributes["syncscope"]

  @builtins.property
  def alignment(self):
    if "alignment" not in self.operation.attributes:
      return None
    return self.operation.attributes["alignment"]

  @alignment.setter
  def alignment(self, value):
    if value is not None:
      self.operation.attributes["alignment"] = value
    elif "alignment" in self.operation.attributes:
      del self.operation.attributes["alignment"]

  @alignment.deleter
  def alignment(self):
    del self.operation.attributes["alignment"]

  @builtins.property
  def weak(self):
    return "weak" in self.operation.attributes

  @weak.setter
  def weak(self, value):
    if bool(value):
      self.operation.attributes["weak"] = _ods_ir.UnitAttr.get()
    elif "weak" in self.operation.attributes:
      del self.operation.attributes["weak"]

  @weak.deleter
  def weak(self):
    del self.operation.attributes["weak"]

  @builtins.property
  def volatile_(self):
    return "volatile_" in self.operation.attributes

  @volatile_.setter
  def volatile_(self, value):
    if bool(value):
      self.operation.attributes["volatile_"] = _ods_ir.UnitAttr.get()
    elif "volatile_" in self.operation.attributes:
      del self.operation.attributes["volatile_"]

  @volatile_.deleter
  def volatile_(self):
    del self.operation.attributes["volatile_"]

  @builtins.property
  def access_groups(self):
    if "access_groups" not in self.operation.attributes:
      return None
    return self.operation.attributes["access_groups"]

  @access_groups.setter
  def access_groups(self, value):
    if value is not None:
      self.operation.attributes["access_groups"] = value
    elif "access_groups" in self.operation.attributes:
      del self.operation.attributes["access_groups"]

  @access_groups.deleter
  def access_groups(self):
    del self.operation.attributes["access_groups"]

  @builtins.property
  def alias_scopes(self):
    if "alias_scopes" not in self.operation.attributes:
      return None
    return self.operation.attributes["alias_scopes"]

  @alias_scopes.setter
  def alias_scopes(self, value):
    if value is not None:
      self.operation.attributes["alias_scopes"] = value
    elif "alias_scopes" in self.operation.attributes:
      del self.operation.attributes["alias_scopes"]

  @alias_scopes.deleter
  def alias_scopes(self):
    del self.operation.attributes["alias_scopes"]

  @builtins.property
  def noalias_scopes(self):
    if "noalias_scopes" not in self.operation.attributes:
      return None
    return self.operation.attributes["noalias_scopes"]

  @noalias_scopes.setter
  def noalias_scopes(self, value):
    if value is not None:
      self.operation.attributes["noalias_scopes"] = value
    elif "noalias_scopes" in self.operation.attributes:
      del self.operation.attributes["noalias_scopes"]

  @noalias_scopes.deleter
  def noalias_scopes(self):
    del self.operation.attributes["noalias_scopes"]

  @builtins.property
  def tbaa(self):
    if "tbaa" not in self.operation.attributes:
      return None
    return self.operation.attributes["tbaa"]

  @tbaa.setter
  def tbaa(self, value):
    if value is not None:
      self.operation.attributes["tbaa"] = value
    elif "tbaa" in self.operation.attributes:
      del self.operation.attributes["tbaa"]

  @tbaa.deleter
  def tbaa(self):
    del self.operation.attributes["tbaa"]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def cmpxchg(ptr, cmp, val, success_ordering, failure_ordering, *, syncscope=None, alignment=None, weak=None, volatile_=None, access_groups=None, alias_scopes=None, noalias_scopes=None, tbaa=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(AtomicCmpXchgOp(ptr=ptr, cmp=cmp, val=val, success_ordering=success_ordering, failure_ordering=failure_ordering, syncscope=syncscope, alignment=alignment, weak=weak, volatile_=volatile_, access_groups=access_groups, alias_scopes=alias_scopes, noalias_scopes=noalias_scopes, tbaa=tbaa, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AtomicRMWOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.atomicrmw"

  _ODS_REGIONS = (0, True)

  def __init__(self, bin_op, ptr, val, ordering, *, syncscope=None, alignment=None, volatile_=None, access_groups=None, alias_scopes=None, noalias_scopes=None, tbaa=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(ptr))
    operands.append(_get_op_result_or_value(val))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["bin_op"] = (bin_op if (
    issubclass(type(bin_op), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('AtomicBinOp')) else
      _ods_ir.AttrBuilder.get('AtomicBinOp')(bin_op, context=_ods_context))
    attributes["ordering"] = (ordering if (
    issubclass(type(ordering), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('AtomicOrdering')) else
      _ods_ir.AttrBuilder.get('AtomicOrdering')(ordering, context=_ods_context))
    if syncscope is not None: attributes["syncscope"] = (syncscope if (
        issubclass(type(syncscope), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(syncscope, context=_ods_context))
    if alignment is not None: attributes["alignment"] = (alignment if (
        issubclass(type(alignment), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(alignment, context=_ods_context))
    if bool(volatile_): attributes["volatile_"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if access_groups is not None: attributes["access_groups"] = (access_groups if (
        issubclass(type(access_groups), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AccessGroupArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AccessGroupArrayAttr')(access_groups, context=_ods_context))
    if alias_scopes is not None: attributes["alias_scopes"] = (alias_scopes if (
        issubclass(type(alias_scopes), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AliasScopeArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AliasScopeArrayAttr')(alias_scopes, context=_ods_context))
    if noalias_scopes is not None: attributes["noalias_scopes"] = (noalias_scopes if (
        issubclass(type(noalias_scopes), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AliasScopeArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AliasScopeArrayAttr')(noalias_scopes, context=_ods_context))
    if tbaa is not None: attributes["tbaa"] = (tbaa if (
        issubclass(type(tbaa), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_TBAATagArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_TBAATagArrayAttr')(tbaa, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def ptr(self):
    return self.operation.operands[0]

  @builtins.property
  def val(self):
    return self.operation.operands[1]

  @builtins.property
  def bin_op(self):
    return self.operation.attributes["bin_op"]

  @bin_op.setter
  def bin_op(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["bin_op"] = value

  @builtins.property
  def ordering(self):
    return self.operation.attributes["ordering"]

  @ordering.setter
  def ordering(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["ordering"] = value

  @builtins.property
  def syncscope(self):
    if "syncscope" not in self.operation.attributes:
      return None
    return self.operation.attributes["syncscope"]

  @syncscope.setter
  def syncscope(self, value):
    if value is not None:
      self.operation.attributes["syncscope"] = value
    elif "syncscope" in self.operation.attributes:
      del self.operation.attributes["syncscope"]

  @syncscope.deleter
  def syncscope(self):
    del self.operation.attributes["syncscope"]

  @builtins.property
  def alignment(self):
    if "alignment" not in self.operation.attributes:
      return None
    return self.operation.attributes["alignment"]

  @alignment.setter
  def alignment(self, value):
    if value is not None:
      self.operation.attributes["alignment"] = value
    elif "alignment" in self.operation.attributes:
      del self.operation.attributes["alignment"]

  @alignment.deleter
  def alignment(self):
    del self.operation.attributes["alignment"]

  @builtins.property
  def volatile_(self):
    return "volatile_" in self.operation.attributes

  @volatile_.setter
  def volatile_(self, value):
    if bool(value):
      self.operation.attributes["volatile_"] = _ods_ir.UnitAttr.get()
    elif "volatile_" in self.operation.attributes:
      del self.operation.attributes["volatile_"]

  @volatile_.deleter
  def volatile_(self):
    del self.operation.attributes["volatile_"]

  @builtins.property
  def access_groups(self):
    if "access_groups" not in self.operation.attributes:
      return None
    return self.operation.attributes["access_groups"]

  @access_groups.setter
  def access_groups(self, value):
    if value is not None:
      self.operation.attributes["access_groups"] = value
    elif "access_groups" in self.operation.attributes:
      del self.operation.attributes["access_groups"]

  @access_groups.deleter
  def access_groups(self):
    del self.operation.attributes["access_groups"]

  @builtins.property
  def alias_scopes(self):
    if "alias_scopes" not in self.operation.attributes:
      return None
    return self.operation.attributes["alias_scopes"]

  @alias_scopes.setter
  def alias_scopes(self, value):
    if value is not None:
      self.operation.attributes["alias_scopes"] = value
    elif "alias_scopes" in self.operation.attributes:
      del self.operation.attributes["alias_scopes"]

  @alias_scopes.deleter
  def alias_scopes(self):
    del self.operation.attributes["alias_scopes"]

  @builtins.property
  def noalias_scopes(self):
    if "noalias_scopes" not in self.operation.attributes:
      return None
    return self.operation.attributes["noalias_scopes"]

  @noalias_scopes.setter
  def noalias_scopes(self, value):
    if value is not None:
      self.operation.attributes["noalias_scopes"] = value
    elif "noalias_scopes" in self.operation.attributes:
      del self.operation.attributes["noalias_scopes"]

  @noalias_scopes.deleter
  def noalias_scopes(self):
    del self.operation.attributes["noalias_scopes"]

  @builtins.property
  def tbaa(self):
    if "tbaa" not in self.operation.attributes:
      return None
    return self.operation.attributes["tbaa"]

  @tbaa.setter
  def tbaa(self, value):
    if value is not None:
      self.operation.attributes["tbaa"] = value
    elif "tbaa" in self.operation.attributes:
      del self.operation.attributes["tbaa"]

  @tbaa.deleter
  def tbaa(self):
    del self.operation.attributes["tbaa"]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def atomicrmw(bin_op, ptr, val, ordering, *, syncscope=None, alignment=None, volatile_=None, access_groups=None, alias_scopes=None, noalias_scopes=None, tbaa=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(AtomicRMWOp(bin_op=bin_op, ptr=ptr, val=val, ordering=ordering, syncscope=syncscope, alignment=alignment, volatile_=volatile_, access_groups=access_groups, alias_scopes=alias_scopes, noalias_scopes=noalias_scopes, tbaa=tbaa, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class BitcastOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.bitcast"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, arg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(arg))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def bitcast(res, arg, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(BitcastOp(res=res, arg=arg, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class BrOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.br"

  _ODS_REGIONS = (0, True)

  def __init__(self, destOperands, dest, *, loop_annotation=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(destOperands))
    _ods_context = _ods_get_default_loc_context(loc)
    if loop_annotation is not None: attributes["loop_annotation"] = (loop_annotation if (
        issubclass(type(loop_annotation), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LoopAnnotationAttr')) else
          _ods_ir.AttrBuilder.get('LoopAnnotationAttr')(loop_annotation, context=_ods_context))
    _ods_successors = []
    _ods_successors.append(dest)
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def destOperands(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def loop_annotation(self):
    if "loop_annotation" not in self.operation.attributes:
      return None
    return self.operation.attributes["loop_annotation"]

  @loop_annotation.setter
  def loop_annotation(self, value):
    if value is not None:
      self.operation.attributes["loop_annotation"] = value
    elif "loop_annotation" in self.operation.attributes:
      del self.operation.attributes["loop_annotation"]

  @loop_annotation.deleter
  def loop_annotation(self):
    del self.operation.attributes["loop_annotation"]

def br(dest_operands, dest, *, loop_annotation=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(BrOp(destOperands=dest_operands, dest=dest, loop_annotation=loop_annotation, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CallIntrinsicOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.call_intrinsic"

  _ODS_REGIONS = (0, True)

  def __init__(self, results_, intrin, args, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(args))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["intrin"] = (intrin if (
    issubclass(type(intrin), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(intrin, context=_ods_context))
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        issubclass(type(fastmathFlags), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    if results_ is not None: results.append(results_)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def args(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def intrin(self):
    return self.operation.attributes["intrin"]

  @intrin.setter
  def intrin(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["intrin"] = value

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def results_(self):
    return None if len(self.operation.results) < 1 else self.operation.results[0]

def call_intrinsic(results_, intrin, args, *, fastmath_flags=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(CallIntrinsicOp(results_=results_, intrin=intrin, args=args, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CallOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.call"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, callee_operands, *, callee_type=None, callee=None, fastmathFlags=None, branch_weights=None, CConv=None, access_groups=None, alias_scopes=None, noalias_scopes=None, tbaa=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(callee_operands))
    _ods_context = _ods_get_default_loc_context(loc)
    if callee_type is not None: attributes["callee_type"] = (callee_type if (
        issubclass(type(callee_type), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_756')) else
          _ods_ir.AttrBuilder.get('anonymous_756')(callee_type, context=_ods_context))
    if callee is not None: attributes["callee"] = (callee if (
        issubclass(type(callee), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
          _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(callee, context=_ods_context))
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        issubclass(type(fastmathFlags), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    if branch_weights is not None: attributes["branch_weights"] = (branch_weights if (
        issubclass(type(branch_weights), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(branch_weights, context=_ods_context))
    if CConv is not None: attributes["CConv"] = (CConv if (
        issubclass(type(CConv), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('CConv')) else
          _ods_ir.AttrBuilder.get('CConv')(CConv, context=_ods_context))
    if access_groups is not None: attributes["access_groups"] = (access_groups if (
        issubclass(type(access_groups), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AccessGroupArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AccessGroupArrayAttr')(access_groups, context=_ods_context))
    if alias_scopes is not None: attributes["alias_scopes"] = (alias_scopes if (
        issubclass(type(alias_scopes), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AliasScopeArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AliasScopeArrayAttr')(alias_scopes, context=_ods_context))
    if noalias_scopes is not None: attributes["noalias_scopes"] = (noalias_scopes if (
        issubclass(type(noalias_scopes), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AliasScopeArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AliasScopeArrayAttr')(noalias_scopes, context=_ods_context))
    if tbaa is not None: attributes["tbaa"] = (tbaa if (
        issubclass(type(tbaa), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_TBAATagArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_TBAATagArrayAttr')(tbaa, context=_ods_context))
    if result is not None: results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def callee_operands(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def callee_type(self):
    if "callee_type" not in self.operation.attributes:
      return None
    return self.operation.attributes["callee_type"]

  @callee_type.setter
  def callee_type(self, value):
    if value is not None:
      self.operation.attributes["callee_type"] = value
    elif "callee_type" in self.operation.attributes:
      del self.operation.attributes["callee_type"]

  @callee_type.deleter
  def callee_type(self):
    del self.operation.attributes["callee_type"]

  @builtins.property
  def callee(self):
    if "callee" not in self.operation.attributes:
      return None
    return self.operation.attributes["callee"]

  @callee.setter
  def callee(self, value):
    if value is not None:
      self.operation.attributes["callee"] = value
    elif "callee" in self.operation.attributes:
      del self.operation.attributes["callee"]

  @callee.deleter
  def callee(self):
    del self.operation.attributes["callee"]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def branch_weights(self):
    if "branch_weights" not in self.operation.attributes:
      return None
    return self.operation.attributes["branch_weights"]

  @branch_weights.setter
  def branch_weights(self, value):
    if value is not None:
      self.operation.attributes["branch_weights"] = value
    elif "branch_weights" in self.operation.attributes:
      del self.operation.attributes["branch_weights"]

  @branch_weights.deleter
  def branch_weights(self):
    del self.operation.attributes["branch_weights"]

  @builtins.property
  def CConv(self):
    return self.operation.attributes["CConv"]

  @CConv.setter
  def CConv(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["CConv"] = value

  @builtins.property
  def access_groups(self):
    if "access_groups" not in self.operation.attributes:
      return None
    return self.operation.attributes["access_groups"]

  @access_groups.setter
  def access_groups(self, value):
    if value is not None:
      self.operation.attributes["access_groups"] = value
    elif "access_groups" in self.operation.attributes:
      del self.operation.attributes["access_groups"]

  @access_groups.deleter
  def access_groups(self):
    del self.operation.attributes["access_groups"]

  @builtins.property
  def alias_scopes(self):
    if "alias_scopes" not in self.operation.attributes:
      return None
    return self.operation.attributes["alias_scopes"]

  @alias_scopes.setter
  def alias_scopes(self, value):
    if value is not None:
      self.operation.attributes["alias_scopes"] = value
    elif "alias_scopes" in self.operation.attributes:
      del self.operation.attributes["alias_scopes"]

  @alias_scopes.deleter
  def alias_scopes(self):
    del self.operation.attributes["alias_scopes"]

  @builtins.property
  def noalias_scopes(self):
    if "noalias_scopes" not in self.operation.attributes:
      return None
    return self.operation.attributes["noalias_scopes"]

  @noalias_scopes.setter
  def noalias_scopes(self, value):
    if value is not None:
      self.operation.attributes["noalias_scopes"] = value
    elif "noalias_scopes" in self.operation.attributes:
      del self.operation.attributes["noalias_scopes"]

  @noalias_scopes.deleter
  def noalias_scopes(self):
    del self.operation.attributes["noalias_scopes"]

  @builtins.property
  def tbaa(self):
    if "tbaa" not in self.operation.attributes:
      return None
    return self.operation.attributes["tbaa"]

  @tbaa.setter
  def tbaa(self, value):
    if value is not None:
      self.operation.attributes["tbaa"] = value
    elif "tbaa" in self.operation.attributes:
      del self.operation.attributes["tbaa"]

  @tbaa.deleter
  def tbaa(self):
    del self.operation.attributes["tbaa"]

  @builtins.property
  def result(self):
    return None if len(self.operation.results) < 1 else self.operation.results[0]

def call(result, callee_operands, *, callee_type=None, callee=None, fastmath_flags=None, branch_weights=None, c_conv=None, access_groups=None, alias_scopes=None, noalias_scopes=None, tbaa=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(CallOp(result=result, callee_operands=callee_operands, callee_type=callee_type, callee=callee, fastmathFlags=fastmath_flags, branch_weights=branch_weights, CConv=c_conv, access_groups=access_groups, alias_scopes=alias_scopes, noalias_scopes=noalias_scopes, tbaa=tbaa, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ComdatOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.comdat"

  _ODS_REGIONS = (1, True)

  def __init__(self, sym_name, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    issubclass(type(sym_name), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def body(self):
    return self.regions[0]

def comdat(sym_name, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(ComdatOp(sym_name=sym_name, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ComdatSelectorOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.comdat_selector"

  _ODS_REGIONS = (0, True)

  def __init__(self, sym_name, comdat, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    issubclass(type(sym_name), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    attributes["comdat"] = (comdat if (
    issubclass(type(comdat), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Comdat')) else
      _ods_ir.AttrBuilder.get('Comdat')(comdat, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def comdat(self):
    return self.operation.attributes["comdat"]

  @comdat.setter
  def comdat(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["comdat"] = value

def comdat_selector(sym_name, comdat, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(ComdatSelectorOp(sym_name=sym_name, comdat=comdat, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CondBrOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.cond_br"

  _ODS_OPERAND_SEGMENTS = [1,-1,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, condition, trueDestOperands, falseDestOperands, trueDest, falseDest, *, branch_weights=None, loop_annotation=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(condition))
    operands.append(_get_op_results_or_values(trueDestOperands))
    operands.append(_get_op_results_or_values(falseDestOperands))
    _ods_context = _ods_get_default_loc_context(loc)
    if branch_weights is not None: attributes["branch_weights"] = (branch_weights if (
        issubclass(type(branch_weights), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(branch_weights, context=_ods_context))
    if loop_annotation is not None: attributes["loop_annotation"] = (loop_annotation if (
        issubclass(type(loop_annotation), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LoopAnnotationAttr')) else
          _ods_ir.AttrBuilder.get('LoopAnnotationAttr')(loop_annotation, context=_ods_context))
    _ods_successors = []
    _ods_successors.append(trueDest)
    _ods_successors.append(falseDest)
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def condition(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def trueDestOperands(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def falseDestOperands(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def branch_weights(self):
    if "branch_weights" not in self.operation.attributes:
      return None
    return self.operation.attributes["branch_weights"]

  @branch_weights.setter
  def branch_weights(self, value):
    if value is not None:
      self.operation.attributes["branch_weights"] = value
    elif "branch_weights" in self.operation.attributes:
      del self.operation.attributes["branch_weights"]

  @branch_weights.deleter
  def branch_weights(self):
    del self.operation.attributes["branch_weights"]

  @builtins.property
  def loop_annotation(self):
    if "loop_annotation" not in self.operation.attributes:
      return None
    return self.operation.attributes["loop_annotation"]

  @loop_annotation.setter
  def loop_annotation(self, value):
    if value is not None:
      self.operation.attributes["loop_annotation"] = value
    elif "loop_annotation" in self.operation.attributes:
      del self.operation.attributes["loop_annotation"]

  @loop_annotation.deleter
  def loop_annotation(self):
    del self.operation.attributes["loop_annotation"]

def cond_br(condition, true_dest_operands, false_dest_operands, true_dest, false_dest, *, branch_weights=None, loop_annotation=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(CondBrOp(condition=condition, trueDestOperands=true_dest_operands, falseDestOperands=false_dest_operands, trueDest=true_dest, falseDest=false_dest, branch_weights=branch_weights, loop_annotation=loop_annotation, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ConstantOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.mlir.constant"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, value, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["value"] = (value if (
    issubclass(type(value), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('AnyAttr')) else
      _ods_ir.AttrBuilder.get('AnyAttr')(value, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def value(self):
    return self.operation.attributes["value"]

  @value.setter
  def value(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["value"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def mlir_constant(res, value, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(ConstantOp(res=res, value=value, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ExtractElementOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.extractelement"

  _ODS_REGIONS = (0, True)

  def __init__(self, vector, position, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(vector))
    operands.append(_get_op_result_or_value(position))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def vector(self):
    return self.operation.operands[0]

  @builtins.property
  def position(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def extractelement(vector, position, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(ExtractElementOp(vector=vector, position=position, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ExtractValueOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.extractvalue"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, container, position, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(container))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["position"] = (position if (
    issubclass(type(position), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(position, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def container(self):
    return self.operation.operands[0]

  @builtins.property
  def position(self):
    return self.operation.attributes["position"]

  @position.setter
  def position(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["position"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def extractvalue(res, container, position, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(ExtractValueOp(res=res, container=container, position=position, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FAddOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.fadd"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        issubclass(type(fastmathFlags), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def fadd(lhs, rhs, *, fastmath_flags=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(FAddOp(lhs=lhs, rhs=rhs, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FCmpOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.fcmp"

  _ODS_REGIONS = (0, True)

  def __init__(self, predicate, lhs, rhs, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["predicate"] = (predicate if (
    issubclass(type(predicate), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('FCmpPredicate')) else
      _ods_ir.AttrBuilder.get('FCmpPredicate')(predicate, context=_ods_context))
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        issubclass(type(fastmathFlags), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def predicate(self):
    return self.operation.attributes["predicate"]

  @predicate.setter
  def predicate(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["predicate"] = value

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def fcmp(predicate, lhs, rhs, *, fastmath_flags=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(FCmpOp(predicate=predicate, lhs=lhs, rhs=rhs, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FDivOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.fdiv"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        issubclass(type(fastmathFlags), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def fdiv(lhs, rhs, *, fastmath_flags=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(FDivOp(lhs=lhs, rhs=rhs, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FMulOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.fmul"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        issubclass(type(fastmathFlags), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def fmul(lhs, rhs, *, fastmath_flags=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(FMulOp(lhs=lhs, rhs=rhs, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FNegOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.fneg"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        issubclass(type(fastmathFlags), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def fneg(operand, *, fastmath_flags=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(FNegOp(operand=operand, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FPExtOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.fpext"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, arg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(arg))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def fpext(res, arg, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(FPExtOp(res=res, arg=arg, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FPToSIOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.fptosi"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, arg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(arg))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def fptosi(res, arg, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(FPToSIOp(res=res, arg=arg, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FPToUIOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.fptoui"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, arg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(arg))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def fptoui(res, arg, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(FPToUIOp(res=res, arg=arg, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FPTruncOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.fptrunc"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, arg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(arg))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def fptrunc(res, arg, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(FPTruncOp(res=res, arg=arg, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FRemOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.frem"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        issubclass(type(fastmathFlags), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def frem(lhs, rhs, *, fastmath_flags=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(FRemOp(lhs=lhs, rhs=rhs, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FSubOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.fsub"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        issubclass(type(fastmathFlags), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def fsub(lhs, rhs, *, fastmath_flags=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(FSubOp(lhs=lhs, rhs=rhs, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FenceOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.fence"

  _ODS_REGIONS = (0, True)

  def __init__(self, ordering, *, syncscope=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["ordering"] = (ordering if (
    issubclass(type(ordering), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('AtomicOrdering')) else
      _ods_ir.AttrBuilder.get('AtomicOrdering')(ordering, context=_ods_context))
    if syncscope is not None: attributes["syncscope"] = (syncscope if (
        issubclass(type(syncscope), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(syncscope, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def ordering(self):
    return self.operation.attributes["ordering"]

  @ordering.setter
  def ordering(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["ordering"] = value

  @builtins.property
  def syncscope(self):
    if "syncscope" not in self.operation.attributes:
      return None
    return self.operation.attributes["syncscope"]

  @syncscope.setter
  def syncscope(self, value):
    if value is not None:
      self.operation.attributes["syncscope"] = value
    elif "syncscope" in self.operation.attributes:
      del self.operation.attributes["syncscope"]

  @syncscope.deleter
  def syncscope(self):
    del self.operation.attributes["syncscope"]

def fence(ordering, *, syncscope=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(FenceOp(ordering=ordering, syncscope=syncscope, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FreezeOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.freeze"

  _ODS_REGIONS = (0, True)

  def __init__(self, val, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(val))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def val(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def freeze(val, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(FreezeOp(val=val, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class GEPOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.getelementptr"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, base, dynamicIndices, rawConstantIndices, elem_type, *, inbounds=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(base))
    operands.extend(_get_op_results_or_values(dynamicIndices))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["rawConstantIndices"] = (rawConstantIndices if (
    issubclass(type(rawConstantIndices), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(rawConstantIndices, context=_ods_context))
    attributes["elem_type"] = (elem_type if (
    issubclass(type(elem_type), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypeAttr')) else
      _ods_ir.AttrBuilder.get('TypeAttr')(elem_type, context=_ods_context))
    if bool(inbounds): attributes["inbounds"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def base(self):
    return self.operation.operands[0]

  @builtins.property
  def dynamicIndices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def rawConstantIndices(self):
    return self.operation.attributes["rawConstantIndices"]

  @rawConstantIndices.setter
  def rawConstantIndices(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["rawConstantIndices"] = value

  @builtins.property
  def elem_type(self):
    return self.operation.attributes["elem_type"]

  @elem_type.setter
  def elem_type(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["elem_type"] = value

  @builtins.property
  def inbounds(self):
    return "inbounds" in self.operation.attributes

  @inbounds.setter
  def inbounds(self, value):
    if bool(value):
      self.operation.attributes["inbounds"] = _ods_ir.UnitAttr.get()
    elif "inbounds" in self.operation.attributes:
      del self.operation.attributes["inbounds"]

  @inbounds.deleter
  def inbounds(self):
    del self.operation.attributes["inbounds"]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def getelementptr(res, base, dynamic_indices, raw_constant_indices, elem_type, *, inbounds=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(GEPOp(res=res, base=base, dynamicIndices=dynamic_indices, rawConstantIndices=raw_constant_indices, elem_type=elem_type, inbounds=inbounds, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class GlobalCtorsOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.mlir.global_ctors"

  _ODS_REGIONS = (0, True)

  def __init__(self, ctors, priorities, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["ctors"] = (ctors if (
    issubclass(type(ctors), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('FlatSymbolRefArrayAttr')) else
      _ods_ir.AttrBuilder.get('FlatSymbolRefArrayAttr')(ctors, context=_ods_context))
    attributes["priorities"] = (priorities if (
    issubclass(type(priorities), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32ArrayAttr')) else
      _ods_ir.AttrBuilder.get('I32ArrayAttr')(priorities, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def ctors(self):
    return self.operation.attributes["ctors"]

  @ctors.setter
  def ctors(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["ctors"] = value

  @builtins.property
  def priorities(self):
    return self.operation.attributes["priorities"]

  @priorities.setter
  def priorities(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["priorities"] = value

def mlir_global_ctors(ctors, priorities, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(GlobalCtorsOp(ctors=ctors, priorities=priorities, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class GlobalDtorsOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.mlir.global_dtors"

  _ODS_REGIONS = (0, True)

  def __init__(self, dtors, priorities, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dtors"] = (dtors if (
    issubclass(type(dtors), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('FlatSymbolRefArrayAttr')) else
      _ods_ir.AttrBuilder.get('FlatSymbolRefArrayAttr')(dtors, context=_ods_context))
    attributes["priorities"] = (priorities if (
    issubclass(type(priorities), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32ArrayAttr')) else
      _ods_ir.AttrBuilder.get('I32ArrayAttr')(priorities, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def dtors(self):
    return self.operation.attributes["dtors"]

  @dtors.setter
  def dtors(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dtors"] = value

  @builtins.property
  def priorities(self):
    return self.operation.attributes["priorities"]

  @priorities.setter
  def priorities(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["priorities"] = value

def mlir_global_dtors(dtors, priorities, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(GlobalDtorsOp(dtors=dtors, priorities=priorities, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class GlobalOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.mlir.global"

  _ODS_REGIONS = (1, True)

  def __init__(self, global_type, sym_name, linkage, *, constant=None, dso_local=None, thread_local_=None, value=None, alignment=None, addr_space=None, unnamed_addr=None, section=None, comdat=None, dbg_expr=None, visibility_=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["global_type"] = (global_type if (
    issubclass(type(global_type), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypeAttr')) else
      _ods_ir.AttrBuilder.get('TypeAttr')(global_type, context=_ods_context))
    if bool(constant): attributes["constant"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    attributes["sym_name"] = (sym_name if (
    issubclass(type(sym_name), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(sym_name, context=_ods_context))
    attributes["linkage"] = (linkage if (
    issubclass(type(linkage), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Linkage')) else
      _ods_ir.AttrBuilder.get('Linkage')(linkage, context=_ods_context))
    if bool(dso_local): attributes["dso_local"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(thread_local_): attributes["thread_local_"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if value is not None: attributes["value"] = (value if (
        issubclass(type(value), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('AnyAttr')) else
          _ods_ir.AttrBuilder.get('AnyAttr')(value, context=_ods_context))
    if alignment is not None: attributes["alignment"] = (alignment if (
        issubclass(type(alignment), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(alignment, context=_ods_context))
    if addr_space is not None: attributes["addr_space"] = (addr_space if (
        issubclass(type(addr_space), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I32Attr')) else
          _ods_ir.AttrBuilder.get('I32Attr')(addr_space, context=_ods_context))
    if unnamed_addr is not None: attributes["unnamed_addr"] = (unnamed_addr if (
        issubclass(type(unnamed_addr), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('UnnamedAddr')) else
          _ods_ir.AttrBuilder.get('UnnamedAddr')(unnamed_addr, context=_ods_context))
    if section is not None: attributes["section"] = (section if (
        issubclass(type(section), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(section, context=_ods_context))
    if comdat is not None: attributes["comdat"] = (comdat if (
        issubclass(type(comdat), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefAttr')(comdat, context=_ods_context))
    if dbg_expr is not None: attributes["dbg_expr"] = (dbg_expr if (
        issubclass(type(dbg_expr), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_DIGlobalVariableExpressionAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_DIGlobalVariableExpressionAttr')(dbg_expr, context=_ods_context))
    if visibility_ is not None: attributes["visibility_"] = (visibility_ if (
        issubclass(type(visibility_), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Visibility')) else
          _ods_ir.AttrBuilder.get('Visibility')(visibility_, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def global_type(self):
    return self.operation.attributes["global_type"]

  @global_type.setter
  def global_type(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["global_type"] = value

  @builtins.property
  def constant(self):
    return "constant" in self.operation.attributes

  @constant.setter
  def constant(self, value):
    if bool(value):
      self.operation.attributes["constant"] = _ods_ir.UnitAttr.get()
    elif "constant" in self.operation.attributes:
      del self.operation.attributes["constant"]

  @constant.deleter
  def constant(self):
    del self.operation.attributes["constant"]

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def linkage(self):
    return self.operation.attributes["linkage"]

  @linkage.setter
  def linkage(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["linkage"] = value

  @builtins.property
  def dso_local(self):
    return "dso_local" in self.operation.attributes

  @dso_local.setter
  def dso_local(self, value):
    if bool(value):
      self.operation.attributes["dso_local"] = _ods_ir.UnitAttr.get()
    elif "dso_local" in self.operation.attributes:
      del self.operation.attributes["dso_local"]

  @dso_local.deleter
  def dso_local(self):
    del self.operation.attributes["dso_local"]

  @builtins.property
  def thread_local_(self):
    return "thread_local_" in self.operation.attributes

  @thread_local_.setter
  def thread_local_(self, value):
    if bool(value):
      self.operation.attributes["thread_local_"] = _ods_ir.UnitAttr.get()
    elif "thread_local_" in self.operation.attributes:
      del self.operation.attributes["thread_local_"]

  @thread_local_.deleter
  def thread_local_(self):
    del self.operation.attributes["thread_local_"]

  @builtins.property
  def value(self):
    if "value" not in self.operation.attributes:
      return None
    return self.operation.attributes["value"]

  @value.setter
  def value(self, value):
    if value is not None:
      self.operation.attributes["value"] = value
    elif "value" in self.operation.attributes:
      del self.operation.attributes["value"]

  @value.deleter
  def value(self):
    del self.operation.attributes["value"]

  @builtins.property
  def alignment(self):
    if "alignment" not in self.operation.attributes:
      return None
    return self.operation.attributes["alignment"]

  @alignment.setter
  def alignment(self, value):
    if value is not None:
      self.operation.attributes["alignment"] = value
    elif "alignment" in self.operation.attributes:
      del self.operation.attributes["alignment"]

  @alignment.deleter
  def alignment(self):
    del self.operation.attributes["alignment"]

  @builtins.property
  def addr_space(self):
    return self.operation.attributes["addr_space"]

  @addr_space.setter
  def addr_space(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["addr_space"] = value

  @builtins.property
  def unnamed_addr(self):
    if "unnamed_addr" not in self.operation.attributes:
      return None
    return self.operation.attributes["unnamed_addr"]

  @unnamed_addr.setter
  def unnamed_addr(self, value):
    if value is not None:
      self.operation.attributes["unnamed_addr"] = value
    elif "unnamed_addr" in self.operation.attributes:
      del self.operation.attributes["unnamed_addr"]

  @unnamed_addr.deleter
  def unnamed_addr(self):
    del self.operation.attributes["unnamed_addr"]

  @builtins.property
  def section(self):
    if "section" not in self.operation.attributes:
      return None
    return self.operation.attributes["section"]

  @section.setter
  def section(self, value):
    if value is not None:
      self.operation.attributes["section"] = value
    elif "section" in self.operation.attributes:
      del self.operation.attributes["section"]

  @section.deleter
  def section(self):
    del self.operation.attributes["section"]

  @builtins.property
  def comdat(self):
    if "comdat" not in self.operation.attributes:
      return None
    return self.operation.attributes["comdat"]

  @comdat.setter
  def comdat(self, value):
    if value is not None:
      self.operation.attributes["comdat"] = value
    elif "comdat" in self.operation.attributes:
      del self.operation.attributes["comdat"]

  @comdat.deleter
  def comdat(self):
    del self.operation.attributes["comdat"]

  @builtins.property
  def dbg_expr(self):
    return self.operation.attributes["dbg_expr"]

  @dbg_expr.setter
  def dbg_expr(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dbg_expr"] = value

  @builtins.property
  def visibility_(self):
    return self.operation.attributes["visibility_"]

  @visibility_.setter
  def visibility_(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["visibility_"] = value

  @builtins.property
  def initializer(self):
    return self.regions[0]

def mlir_global(global_type, sym_name, linkage, *, constant=None, dso_local=None, thread_local_=None, value=None, alignment=None, addr_space=None, unnamed_addr=None, section=None, comdat=None, dbg_expr=None, visibility_=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(GlobalOp(global_type=global_type, sym_name=sym_name, linkage=linkage, constant=constant, dso_local=dso_local, thread_local_=thread_local_, value=value, alignment=alignment, addr_space=addr_space, unnamed_addr=unnamed_addr, section=section, comdat=comdat, dbg_expr=dbg_expr, visibility_=visibility_, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ICmpOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.icmp"

  _ODS_REGIONS = (0, True)

  def __init__(self, predicate, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["predicate"] = (predicate if (
    issubclass(type(predicate), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('ICmpPredicate')) else
      _ods_ir.AttrBuilder.get('ICmpPredicate')(predicate, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def predicate(self):
    return self.operation.attributes["predicate"]

  @predicate.setter
  def predicate(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["predicate"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def icmp(predicate, lhs, rhs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(ICmpOp(predicate=predicate, lhs=lhs, rhs=rhs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class InlineAsmOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.inline_asm"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, operands_, asm_string, constraints, *, has_side_effects=None, is_align_stack=None, asm_dialect=None, operand_attrs=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(operands_))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["asm_string"] = (asm_string if (
    issubclass(type(asm_string), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(asm_string, context=_ods_context))
    attributes["constraints"] = (constraints if (
    issubclass(type(constraints), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(constraints, context=_ods_context))
    if bool(has_side_effects): attributes["has_side_effects"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(is_align_stack): attributes["is_align_stack"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if asm_dialect is not None: attributes["asm_dialect"] = (asm_dialect if (
        issubclass(type(asm_dialect), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('AsmATTOrIntel')) else
          _ods_ir.AttrBuilder.get('AsmATTOrIntel')(asm_dialect, context=_ods_context))
    if operand_attrs is not None: attributes["operand_attrs"] = (operand_attrs if (
        issubclass(type(operand_attrs), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('ArrayAttr')) else
          _ods_ir.AttrBuilder.get('ArrayAttr')(operand_attrs, context=_ods_context))
    if res is not None: results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operands_(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def asm_string(self):
    return self.operation.attributes["asm_string"]

  @asm_string.setter
  def asm_string(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["asm_string"] = value

  @builtins.property
  def constraints(self):
    return self.operation.attributes["constraints"]

  @constraints.setter
  def constraints(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["constraints"] = value

  @builtins.property
  def has_side_effects(self):
    return "has_side_effects" in self.operation.attributes

  @has_side_effects.setter
  def has_side_effects(self, value):
    if bool(value):
      self.operation.attributes["has_side_effects"] = _ods_ir.UnitAttr.get()
    elif "has_side_effects" in self.operation.attributes:
      del self.operation.attributes["has_side_effects"]

  @has_side_effects.deleter
  def has_side_effects(self):
    del self.operation.attributes["has_side_effects"]

  @builtins.property
  def is_align_stack(self):
    return "is_align_stack" in self.operation.attributes

  @is_align_stack.setter
  def is_align_stack(self, value):
    if bool(value):
      self.operation.attributes["is_align_stack"] = _ods_ir.UnitAttr.get()
    elif "is_align_stack" in self.operation.attributes:
      del self.operation.attributes["is_align_stack"]

  @is_align_stack.deleter
  def is_align_stack(self):
    del self.operation.attributes["is_align_stack"]

  @builtins.property
  def asm_dialect(self):
    if "asm_dialect" not in self.operation.attributes:
      return None
    return self.operation.attributes["asm_dialect"]

  @asm_dialect.setter
  def asm_dialect(self, value):
    if value is not None:
      self.operation.attributes["asm_dialect"] = value
    elif "asm_dialect" in self.operation.attributes:
      del self.operation.attributes["asm_dialect"]

  @asm_dialect.deleter
  def asm_dialect(self):
    del self.operation.attributes["asm_dialect"]

  @builtins.property
  def operand_attrs(self):
    if "operand_attrs" not in self.operation.attributes:
      return None
    return self.operation.attributes["operand_attrs"]

  @operand_attrs.setter
  def operand_attrs(self, value):
    if value is not None:
      self.operation.attributes["operand_attrs"] = value
    elif "operand_attrs" in self.operation.attributes:
      del self.operation.attributes["operand_attrs"]

  @operand_attrs.deleter
  def operand_attrs(self):
    del self.operation.attributes["operand_attrs"]

  @builtins.property
  def res(self):
    return None if len(self.operation.results) < 1 else self.operation.results[0]

def inline_asm(res, operands_, asm_string, constraints, *, has_side_effects=None, is_align_stack=None, asm_dialect=None, operand_attrs=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(InlineAsmOp(res=res, operands_=operands_, asm_string=asm_string, constraints=constraints, has_side_effects=has_side_effects, is_align_stack=is_align_stack, asm_dialect=asm_dialect, operand_attrs=operand_attrs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class InsertElementOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.insertelement"

  _ODS_REGIONS = (0, True)

  def __init__(self, vector, value, position, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(vector))
    operands.append(_get_op_result_or_value(value))
    operands.append(_get_op_result_or_value(position))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def vector(self):
    return self.operation.operands[0]

  @builtins.property
  def value(self):
    return self.operation.operands[1]

  @builtins.property
  def position(self):
    return self.operation.operands[2]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def insertelement(vector, value, position, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(InsertElementOp(vector=vector, value=value, position=position, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class InsertValueOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.insertvalue"

  _ODS_REGIONS = (0, True)

  def __init__(self, container, value, position, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(container))
    operands.append(_get_op_result_or_value(value))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["position"] = (position if (
    issubclass(type(position), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(position, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def container(self):
    return self.operation.operands[0]

  @builtins.property
  def value(self):
    return self.operation.operands[1]

  @builtins.property
  def position(self):
    return self.operation.attributes["position"]

  @position.setter
  def position(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["position"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def insertvalue(container, value, position, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(InsertValueOp(container=container, value=value, position=position, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class IntToPtrOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.inttoptr"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, arg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(arg))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def inttoptr(res, arg, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(IntToPtrOp(res=res, arg=arg, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class InvokeOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.invoke"

  _ODS_OPERAND_SEGMENTS = [-1,-1,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, result, callee_operands, normalDestOperands, unwindDestOperands, normalDest, unwindDest, *, callee_type=None, callee=None, branch_weights=None, CConv=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(callee_operands))
    operands.append(_get_op_results_or_values(normalDestOperands))
    operands.append(_get_op_results_or_values(unwindDestOperands))
    _ods_context = _ods_get_default_loc_context(loc)
    if callee_type is not None: attributes["callee_type"] = (callee_type if (
        issubclass(type(callee_type), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_756')) else
          _ods_ir.AttrBuilder.get('anonymous_756')(callee_type, context=_ods_context))
    if callee is not None: attributes["callee"] = (callee if (
        issubclass(type(callee), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
          _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(callee, context=_ods_context))
    if branch_weights is not None: attributes["branch_weights"] = (branch_weights if (
        issubclass(type(branch_weights), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(branch_weights, context=_ods_context))
    if CConv is not None: attributes["CConv"] = (CConv if (
        issubclass(type(CConv), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('CConv')) else
          _ods_ir.AttrBuilder.get('CConv')(CConv, context=_ods_context))
    results.extend(result)
    _ods_successors = []
    _ods_successors.append(normalDest)
    _ods_successors.append(unwindDest)
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def callee_operands(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def normalDestOperands(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def unwindDestOperands(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def callee_type(self):
    if "callee_type" not in self.operation.attributes:
      return None
    return self.operation.attributes["callee_type"]

  @callee_type.setter
  def callee_type(self, value):
    if value is not None:
      self.operation.attributes["callee_type"] = value
    elif "callee_type" in self.operation.attributes:
      del self.operation.attributes["callee_type"]

  @callee_type.deleter
  def callee_type(self):
    del self.operation.attributes["callee_type"]

  @builtins.property
  def callee(self):
    if "callee" not in self.operation.attributes:
      return None
    return self.operation.attributes["callee"]

  @callee.setter
  def callee(self, value):
    if value is not None:
      self.operation.attributes["callee"] = value
    elif "callee" in self.operation.attributes:
      del self.operation.attributes["callee"]

  @callee.deleter
  def callee(self):
    del self.operation.attributes["callee"]

  @builtins.property
  def branch_weights(self):
    if "branch_weights" not in self.operation.attributes:
      return None
    return self.operation.attributes["branch_weights"]

  @branch_weights.setter
  def branch_weights(self, value):
    if value is not None:
      self.operation.attributes["branch_weights"] = value
    elif "branch_weights" in self.operation.attributes:
      del self.operation.attributes["branch_weights"]

  @branch_weights.deleter
  def branch_weights(self):
    del self.operation.attributes["branch_weights"]

  @builtins.property
  def CConv(self):
    return self.operation.attributes["CConv"]

  @CConv.setter
  def CConv(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["CConv"] = value

def invoke(result, callee_operands, normal_dest_operands, unwind_dest_operands, normal_dest, unwind_dest, *, callee_type=None, callee=None, branch_weights=None, c_conv=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(InvokeOp(result=result, callee_operands=callee_operands, normalDestOperands=normal_dest_operands, unwindDestOperands=unwind_dest_operands, normalDest=normal_dest, unwindDest=unwind_dest, callee_type=callee_type, callee=callee, branch_weights=branch_weights, CConv=c_conv, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class LLVMFuncOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.func"

  _ODS_REGIONS = (1, True)

  def __init__(self, sym_name, function_type, *, sym_visibility=None, linkage=None, dso_local=None, CConv=None, comdat=None, personality=None, garbageCollector=None, passthrough=None, arg_attrs=None, res_attrs=None, function_entry_count=None, memory=None, visibility_=None, arm_streaming=None, arm_locally_streaming=None, arm_streaming_compatible=None, arm_new_za=None, arm_preserves_za=None, arm_shared_za=None, section=None, unnamed_addr=None, alignment=None, vscale_range=None, frame_pointer=None, target_features=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    issubclass(type(sym_name), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(sym_name, context=_ods_context))
    if sym_visibility is not None: attributes["sym_visibility"] = (sym_visibility if (
        issubclass(type(sym_visibility), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(sym_visibility, context=_ods_context))
    attributes["function_type"] = (function_type if (
    issubclass(type(function_type), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('anonymous_756')) else
      _ods_ir.AttrBuilder.get('anonymous_756')(function_type, context=_ods_context))
    if linkage is not None: attributes["linkage"] = (linkage if (
        issubclass(type(linkage), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Linkage')) else
          _ods_ir.AttrBuilder.get('Linkage')(linkage, context=_ods_context))
    if bool(dso_local): attributes["dso_local"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if CConv is not None: attributes["CConv"] = (CConv if (
        issubclass(type(CConv), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('CConv')) else
          _ods_ir.AttrBuilder.get('CConv')(CConv, context=_ods_context))
    if comdat is not None: attributes["comdat"] = (comdat if (
        issubclass(type(comdat), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefAttr')(comdat, context=_ods_context))
    if personality is not None: attributes["personality"] = (personality if (
        issubclass(type(personality), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
          _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(personality, context=_ods_context))
    if garbageCollector is not None: attributes["garbageCollector"] = (garbageCollector if (
        issubclass(type(garbageCollector), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(garbageCollector, context=_ods_context))
    if passthrough is not None: attributes["passthrough"] = (passthrough if (
        issubclass(type(passthrough), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('ArrayAttr')) else
          _ods_ir.AttrBuilder.get('ArrayAttr')(passthrough, context=_ods_context))
    if arg_attrs is not None: attributes["arg_attrs"] = (arg_attrs if (
        issubclass(type(arg_attrs), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DictArrayAttr')) else
          _ods_ir.AttrBuilder.get('DictArrayAttr')(arg_attrs, context=_ods_context))
    if res_attrs is not None: attributes["res_attrs"] = (res_attrs if (
        issubclass(type(res_attrs), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DictArrayAttr')) else
          _ods_ir.AttrBuilder.get('DictArrayAttr')(res_attrs, context=_ods_context))
    if function_entry_count is not None: attributes["function_entry_count"] = (function_entry_count if (
        issubclass(type(function_entry_count), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(function_entry_count, context=_ods_context))
    if memory is not None: attributes["memory"] = (memory if (
        issubclass(type(memory), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_MemoryEffectsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_MemoryEffectsAttr')(memory, context=_ods_context))
    if visibility_ is not None: attributes["visibility_"] = (visibility_ if (
        issubclass(type(visibility_), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Visibility')) else
          _ods_ir.AttrBuilder.get('Visibility')(visibility_, context=_ods_context))
    if bool(arm_streaming): attributes["arm_streaming"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(arm_locally_streaming): attributes["arm_locally_streaming"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(arm_streaming_compatible): attributes["arm_streaming_compatible"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(arm_new_za): attributes["arm_new_za"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(arm_preserves_za): attributes["arm_preserves_za"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(arm_shared_za): attributes["arm_shared_za"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if section is not None: attributes["section"] = (section if (
        issubclass(type(section), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(section, context=_ods_context))
    if unnamed_addr is not None: attributes["unnamed_addr"] = (unnamed_addr if (
        issubclass(type(unnamed_addr), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('UnnamedAddr')) else
          _ods_ir.AttrBuilder.get('UnnamedAddr')(unnamed_addr, context=_ods_context))
    if alignment is not None: attributes["alignment"] = (alignment if (
        issubclass(type(alignment), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(alignment, context=_ods_context))
    if vscale_range is not None: attributes["vscale_range"] = (vscale_range if (
        issubclass(type(vscale_range), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_VScaleRangeAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_VScaleRangeAttr')(vscale_range, context=_ods_context))
    if frame_pointer is not None: attributes["frame_pointer"] = (frame_pointer if (
        issubclass(type(frame_pointer), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('FramePointerKindAttr')) else
          _ods_ir.AttrBuilder.get('FramePointerKindAttr')(frame_pointer, context=_ods_context))
    if target_features is not None: attributes["target_features"] = (target_features if (
        issubclass(type(target_features), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_TargetFeaturesAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_TargetFeaturesAttr')(target_features, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def sym_visibility(self):
    if "sym_visibility" not in self.operation.attributes:
      return None
    return self.operation.attributes["sym_visibility"]

  @sym_visibility.setter
  def sym_visibility(self, value):
    if value is not None:
      self.operation.attributes["sym_visibility"] = value
    elif "sym_visibility" in self.operation.attributes:
      del self.operation.attributes["sym_visibility"]

  @sym_visibility.deleter
  def sym_visibility(self):
    del self.operation.attributes["sym_visibility"]

  @builtins.property
  def function_type(self):
    return self.operation.attributes["function_type"]

  @function_type.setter
  def function_type(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["function_type"] = value

  @builtins.property
  def linkage(self):
    return self.operation.attributes["linkage"]

  @linkage.setter
  def linkage(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["linkage"] = value

  @builtins.property
  def dso_local(self):
    return "dso_local" in self.operation.attributes

  @dso_local.setter
  def dso_local(self, value):
    if bool(value):
      self.operation.attributes["dso_local"] = _ods_ir.UnitAttr.get()
    elif "dso_local" in self.operation.attributes:
      del self.operation.attributes["dso_local"]

  @dso_local.deleter
  def dso_local(self):
    del self.operation.attributes["dso_local"]

  @builtins.property
  def CConv(self):
    return self.operation.attributes["CConv"]

  @CConv.setter
  def CConv(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["CConv"] = value

  @builtins.property
  def comdat(self):
    if "comdat" not in self.operation.attributes:
      return None
    return self.operation.attributes["comdat"]

  @comdat.setter
  def comdat(self, value):
    if value is not None:
      self.operation.attributes["comdat"] = value
    elif "comdat" in self.operation.attributes:
      del self.operation.attributes["comdat"]

  @comdat.deleter
  def comdat(self):
    del self.operation.attributes["comdat"]

  @builtins.property
  def personality(self):
    if "personality" not in self.operation.attributes:
      return None
    return self.operation.attributes["personality"]

  @personality.setter
  def personality(self, value):
    if value is not None:
      self.operation.attributes["personality"] = value
    elif "personality" in self.operation.attributes:
      del self.operation.attributes["personality"]

  @personality.deleter
  def personality(self):
    del self.operation.attributes["personality"]

  @builtins.property
  def garbageCollector(self):
    if "garbageCollector" not in self.operation.attributes:
      return None
    return self.operation.attributes["garbageCollector"]

  @garbageCollector.setter
  def garbageCollector(self, value):
    if value is not None:
      self.operation.attributes["garbageCollector"] = value
    elif "garbageCollector" in self.operation.attributes:
      del self.operation.attributes["garbageCollector"]

  @garbageCollector.deleter
  def garbageCollector(self):
    del self.operation.attributes["garbageCollector"]

  @builtins.property
  def passthrough(self):
    if "passthrough" not in self.operation.attributes:
      return None
    return self.operation.attributes["passthrough"]

  @passthrough.setter
  def passthrough(self, value):
    if value is not None:
      self.operation.attributes["passthrough"] = value
    elif "passthrough" in self.operation.attributes:
      del self.operation.attributes["passthrough"]

  @passthrough.deleter
  def passthrough(self):
    del self.operation.attributes["passthrough"]

  @builtins.property
  def arg_attrs(self):
    if "arg_attrs" not in self.operation.attributes:
      return None
    return self.operation.attributes["arg_attrs"]

  @arg_attrs.setter
  def arg_attrs(self, value):
    if value is not None:
      self.operation.attributes["arg_attrs"] = value
    elif "arg_attrs" in self.operation.attributes:
      del self.operation.attributes["arg_attrs"]

  @arg_attrs.deleter
  def arg_attrs(self):
    del self.operation.attributes["arg_attrs"]

  @builtins.property
  def res_attrs(self):
    if "res_attrs" not in self.operation.attributes:
      return None
    return self.operation.attributes["res_attrs"]

  @res_attrs.setter
  def res_attrs(self, value):
    if value is not None:
      self.operation.attributes["res_attrs"] = value
    elif "res_attrs" in self.operation.attributes:
      del self.operation.attributes["res_attrs"]

  @res_attrs.deleter
  def res_attrs(self):
    del self.operation.attributes["res_attrs"]

  @builtins.property
  def function_entry_count(self):
    if "function_entry_count" not in self.operation.attributes:
      return None
    return self.operation.attributes["function_entry_count"]

  @function_entry_count.setter
  def function_entry_count(self, value):
    if value is not None:
      self.operation.attributes["function_entry_count"] = value
    elif "function_entry_count" in self.operation.attributes:
      del self.operation.attributes["function_entry_count"]

  @function_entry_count.deleter
  def function_entry_count(self):
    del self.operation.attributes["function_entry_count"]

  @builtins.property
  def memory(self):
    if "memory" not in self.operation.attributes:
      return None
    return self.operation.attributes["memory"]

  @memory.setter
  def memory(self, value):
    if value is not None:
      self.operation.attributes["memory"] = value
    elif "memory" in self.operation.attributes:
      del self.operation.attributes["memory"]

  @memory.deleter
  def memory(self):
    del self.operation.attributes["memory"]

  @builtins.property
  def visibility_(self):
    return self.operation.attributes["visibility_"]

  @visibility_.setter
  def visibility_(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["visibility_"] = value

  @builtins.property
  def arm_streaming(self):
    return "arm_streaming" in self.operation.attributes

  @arm_streaming.setter
  def arm_streaming(self, value):
    if bool(value):
      self.operation.attributes["arm_streaming"] = _ods_ir.UnitAttr.get()
    elif "arm_streaming" in self.operation.attributes:
      del self.operation.attributes["arm_streaming"]

  @arm_streaming.deleter
  def arm_streaming(self):
    del self.operation.attributes["arm_streaming"]

  @builtins.property
  def arm_locally_streaming(self):
    return "arm_locally_streaming" in self.operation.attributes

  @arm_locally_streaming.setter
  def arm_locally_streaming(self, value):
    if bool(value):
      self.operation.attributes["arm_locally_streaming"] = _ods_ir.UnitAttr.get()
    elif "arm_locally_streaming" in self.operation.attributes:
      del self.operation.attributes["arm_locally_streaming"]

  @arm_locally_streaming.deleter
  def arm_locally_streaming(self):
    del self.operation.attributes["arm_locally_streaming"]

  @builtins.property
  def arm_streaming_compatible(self):
    return "arm_streaming_compatible" in self.operation.attributes

  @arm_streaming_compatible.setter
  def arm_streaming_compatible(self, value):
    if bool(value):
      self.operation.attributes["arm_streaming_compatible"] = _ods_ir.UnitAttr.get()
    elif "arm_streaming_compatible" in self.operation.attributes:
      del self.operation.attributes["arm_streaming_compatible"]

  @arm_streaming_compatible.deleter
  def arm_streaming_compatible(self):
    del self.operation.attributes["arm_streaming_compatible"]

  @builtins.property
  def arm_new_za(self):
    return "arm_new_za" in self.operation.attributes

  @arm_new_za.setter
  def arm_new_za(self, value):
    if bool(value):
      self.operation.attributes["arm_new_za"] = _ods_ir.UnitAttr.get()
    elif "arm_new_za" in self.operation.attributes:
      del self.operation.attributes["arm_new_za"]

  @arm_new_za.deleter
  def arm_new_za(self):
    del self.operation.attributes["arm_new_za"]

  @builtins.property
  def arm_preserves_za(self):
    return "arm_preserves_za" in self.operation.attributes

  @arm_preserves_za.setter
  def arm_preserves_za(self, value):
    if bool(value):
      self.operation.attributes["arm_preserves_za"] = _ods_ir.UnitAttr.get()
    elif "arm_preserves_za" in self.operation.attributes:
      del self.operation.attributes["arm_preserves_za"]

  @arm_preserves_za.deleter
  def arm_preserves_za(self):
    del self.operation.attributes["arm_preserves_za"]

  @builtins.property
  def arm_shared_za(self):
    return "arm_shared_za" in self.operation.attributes

  @arm_shared_za.setter
  def arm_shared_za(self, value):
    if bool(value):
      self.operation.attributes["arm_shared_za"] = _ods_ir.UnitAttr.get()
    elif "arm_shared_za" in self.operation.attributes:
      del self.operation.attributes["arm_shared_za"]

  @arm_shared_za.deleter
  def arm_shared_za(self):
    del self.operation.attributes["arm_shared_za"]

  @builtins.property
  def section(self):
    if "section" not in self.operation.attributes:
      return None
    return self.operation.attributes["section"]

  @section.setter
  def section(self, value):
    if value is not None:
      self.operation.attributes["section"] = value
    elif "section" in self.operation.attributes:
      del self.operation.attributes["section"]

  @section.deleter
  def section(self):
    del self.operation.attributes["section"]

  @builtins.property
  def unnamed_addr(self):
    if "unnamed_addr" not in self.operation.attributes:
      return None
    return self.operation.attributes["unnamed_addr"]

  @unnamed_addr.setter
  def unnamed_addr(self, value):
    if value is not None:
      self.operation.attributes["unnamed_addr"] = value
    elif "unnamed_addr" in self.operation.attributes:
      del self.operation.attributes["unnamed_addr"]

  @unnamed_addr.deleter
  def unnamed_addr(self):
    del self.operation.attributes["unnamed_addr"]

  @builtins.property
  def alignment(self):
    if "alignment" not in self.operation.attributes:
      return None
    return self.operation.attributes["alignment"]

  @alignment.setter
  def alignment(self, value):
    if value is not None:
      self.operation.attributes["alignment"] = value
    elif "alignment" in self.operation.attributes:
      del self.operation.attributes["alignment"]

  @alignment.deleter
  def alignment(self):
    del self.operation.attributes["alignment"]

  @builtins.property
  def vscale_range(self):
    if "vscale_range" not in self.operation.attributes:
      return None
    return self.operation.attributes["vscale_range"]

  @vscale_range.setter
  def vscale_range(self, value):
    if value is not None:
      self.operation.attributes["vscale_range"] = value
    elif "vscale_range" in self.operation.attributes:
      del self.operation.attributes["vscale_range"]

  @vscale_range.deleter
  def vscale_range(self):
    del self.operation.attributes["vscale_range"]

  @builtins.property
  def frame_pointer(self):
    if "frame_pointer" not in self.operation.attributes:
      return None
    return self.operation.attributes["frame_pointer"]

  @frame_pointer.setter
  def frame_pointer(self, value):
    if value is not None:
      self.operation.attributes["frame_pointer"] = value
    elif "frame_pointer" in self.operation.attributes:
      del self.operation.attributes["frame_pointer"]

  @frame_pointer.deleter
  def frame_pointer(self):
    del self.operation.attributes["frame_pointer"]

  @builtins.property
  def target_features(self):
    if "target_features" not in self.operation.attributes:
      return None
    return self.operation.attributes["target_features"]

  @target_features.setter
  def target_features(self, value):
    if value is not None:
      self.operation.attributes["target_features"] = value
    elif "target_features" in self.operation.attributes:
      del self.operation.attributes["target_features"]

  @target_features.deleter
  def target_features(self):
    del self.operation.attributes["target_features"]

  @builtins.property
  def body(self):
    return self.regions[0]

def func(sym_name, function_type, *, sym_visibility=None, linkage=None, dso_local=None, c_conv=None, comdat=None, personality=None, garbage_collector=None, passthrough=None, arg_attrs=None, res_attrs=None, function_entry_count=None, memory=None, visibility_=None, arm_streaming=None, arm_locally_streaming=None, arm_streaming_compatible=None, arm_new_za=None, arm_preserves_za=None, arm_shared_za=None, section=None, unnamed_addr=None, alignment=None, vscale_range=None, frame_pointer=None, target_features=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(LLVMFuncOp(sym_name=sym_name, function_type=function_type, sym_visibility=sym_visibility, linkage=linkage, dso_local=dso_local, CConv=c_conv, comdat=comdat, personality=personality, garbageCollector=garbage_collector, passthrough=passthrough, arg_attrs=arg_attrs, res_attrs=res_attrs, function_entry_count=function_entry_count, memory=memory, visibility_=visibility_, arm_streaming=arm_streaming, arm_locally_streaming=arm_locally_streaming, arm_streaming_compatible=arm_streaming_compatible, arm_new_za=arm_new_za, arm_preserves_za=arm_preserves_za, arm_shared_za=arm_shared_za, section=section, unnamed_addr=unnamed_addr, alignment=alignment, vscale_range=vscale_range, frame_pointer=frame_pointer, target_features=target_features, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class LShrOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.lshr"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def lshr(lhs, rhs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(LShrOp(lhs=lhs, rhs=rhs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class LandingpadOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.landingpad"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, _gen_arg_1, *, cleanup=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(_gen_arg_1))
    _ods_context = _ods_get_default_loc_context(loc)
    if bool(cleanup): attributes["cleanup"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def cleanup(self):
    return "cleanup" in self.operation.attributes

  @cleanup.setter
  def cleanup(self, value):
    if bool(value):
      self.operation.attributes["cleanup"] = _ods_ir.UnitAttr.get()
    elif "cleanup" in self.operation.attributes:
      del self.operation.attributes["cleanup"]

  @cleanup.deleter
  def cleanup(self):
    del self.operation.attributes["cleanup"]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def landingpad(res, _gen_arg_1, *, cleanup=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(LandingpadOp(res=res, _gen_arg_1=_gen_arg_1, cleanup=cleanup, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class LinkerOptionsOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.linker_options"

  _ODS_REGIONS = (0, True)

  def __init__(self, options, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["options"] = (options if (
    issubclass(type(options), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrArrayAttr')) else
      _ods_ir.AttrBuilder.get('StrArrayAttr')(options, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def options(self):
    return self.operation.attributes["options"]

  @options.setter
  def options(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["options"] = value

def linker_options(options, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(LinkerOptionsOp(options=options, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class LoadOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.load"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, addr, *, alignment=None, volatile_=None, nontemporal=None, invariant=None, ordering=None, syncscope=None, access_groups=None, alias_scopes=None, noalias_scopes=None, tbaa=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(addr))
    _ods_context = _ods_get_default_loc_context(loc)
    if alignment is not None: attributes["alignment"] = (alignment if (
        issubclass(type(alignment), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(alignment, context=_ods_context))
    if bool(volatile_): attributes["volatile_"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(nontemporal): attributes["nontemporal"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(invariant): attributes["invariant"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if ordering is not None: attributes["ordering"] = (ordering if (
        issubclass(type(ordering), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('AtomicOrdering')) else
          _ods_ir.AttrBuilder.get('AtomicOrdering')(ordering, context=_ods_context))
    if syncscope is not None: attributes["syncscope"] = (syncscope if (
        issubclass(type(syncscope), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(syncscope, context=_ods_context))
    if access_groups is not None: attributes["access_groups"] = (access_groups if (
        issubclass(type(access_groups), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AccessGroupArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AccessGroupArrayAttr')(access_groups, context=_ods_context))
    if alias_scopes is not None: attributes["alias_scopes"] = (alias_scopes if (
        issubclass(type(alias_scopes), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AliasScopeArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AliasScopeArrayAttr')(alias_scopes, context=_ods_context))
    if noalias_scopes is not None: attributes["noalias_scopes"] = (noalias_scopes if (
        issubclass(type(noalias_scopes), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AliasScopeArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AliasScopeArrayAttr')(noalias_scopes, context=_ods_context))
    if tbaa is not None: attributes["tbaa"] = (tbaa if (
        issubclass(type(tbaa), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_TBAATagArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_TBAATagArrayAttr')(tbaa, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def addr(self):
    return self.operation.operands[0]

  @builtins.property
  def alignment(self):
    if "alignment" not in self.operation.attributes:
      return None
    return self.operation.attributes["alignment"]

  @alignment.setter
  def alignment(self, value):
    if value is not None:
      self.operation.attributes["alignment"] = value
    elif "alignment" in self.operation.attributes:
      del self.operation.attributes["alignment"]

  @alignment.deleter
  def alignment(self):
    del self.operation.attributes["alignment"]

  @builtins.property
  def volatile_(self):
    return "volatile_" in self.operation.attributes

  @volatile_.setter
  def volatile_(self, value):
    if bool(value):
      self.operation.attributes["volatile_"] = _ods_ir.UnitAttr.get()
    elif "volatile_" in self.operation.attributes:
      del self.operation.attributes["volatile_"]

  @volatile_.deleter
  def volatile_(self):
    del self.operation.attributes["volatile_"]

  @builtins.property
  def nontemporal(self):
    return "nontemporal" in self.operation.attributes

  @nontemporal.setter
  def nontemporal(self, value):
    if bool(value):
      self.operation.attributes["nontemporal"] = _ods_ir.UnitAttr.get()
    elif "nontemporal" in self.operation.attributes:
      del self.operation.attributes["nontemporal"]

  @nontemporal.deleter
  def nontemporal(self):
    del self.operation.attributes["nontemporal"]

  @builtins.property
  def invariant(self):
    return "invariant" in self.operation.attributes

  @invariant.setter
  def invariant(self, value):
    if bool(value):
      self.operation.attributes["invariant"] = _ods_ir.UnitAttr.get()
    elif "invariant" in self.operation.attributes:
      del self.operation.attributes["invariant"]

  @invariant.deleter
  def invariant(self):
    del self.operation.attributes["invariant"]

  @builtins.property
  def ordering(self):
    return self.operation.attributes["ordering"]

  @ordering.setter
  def ordering(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["ordering"] = value

  @builtins.property
  def syncscope(self):
    if "syncscope" not in self.operation.attributes:
      return None
    return self.operation.attributes["syncscope"]

  @syncscope.setter
  def syncscope(self, value):
    if value is not None:
      self.operation.attributes["syncscope"] = value
    elif "syncscope" in self.operation.attributes:
      del self.operation.attributes["syncscope"]

  @syncscope.deleter
  def syncscope(self):
    del self.operation.attributes["syncscope"]

  @builtins.property
  def access_groups(self):
    if "access_groups" not in self.operation.attributes:
      return None
    return self.operation.attributes["access_groups"]

  @access_groups.setter
  def access_groups(self, value):
    if value is not None:
      self.operation.attributes["access_groups"] = value
    elif "access_groups" in self.operation.attributes:
      del self.operation.attributes["access_groups"]

  @access_groups.deleter
  def access_groups(self):
    del self.operation.attributes["access_groups"]

  @builtins.property
  def alias_scopes(self):
    if "alias_scopes" not in self.operation.attributes:
      return None
    return self.operation.attributes["alias_scopes"]

  @alias_scopes.setter
  def alias_scopes(self, value):
    if value is not None:
      self.operation.attributes["alias_scopes"] = value
    elif "alias_scopes" in self.operation.attributes:
      del self.operation.attributes["alias_scopes"]

  @alias_scopes.deleter
  def alias_scopes(self):
    del self.operation.attributes["alias_scopes"]

  @builtins.property
  def noalias_scopes(self):
    if "noalias_scopes" not in self.operation.attributes:
      return None
    return self.operation.attributes["noalias_scopes"]

  @noalias_scopes.setter
  def noalias_scopes(self, value):
    if value is not None:
      self.operation.attributes["noalias_scopes"] = value
    elif "noalias_scopes" in self.operation.attributes:
      del self.operation.attributes["noalias_scopes"]

  @noalias_scopes.deleter
  def noalias_scopes(self):
    del self.operation.attributes["noalias_scopes"]

  @builtins.property
  def tbaa(self):
    if "tbaa" not in self.operation.attributes:
      return None
    return self.operation.attributes["tbaa"]

  @tbaa.setter
  def tbaa(self, value):
    if value is not None:
      self.operation.attributes["tbaa"] = value
    elif "tbaa" in self.operation.attributes:
      del self.operation.attributes["tbaa"]

  @tbaa.deleter
  def tbaa(self):
    del self.operation.attributes["tbaa"]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def load(res, addr, *, alignment=None, volatile_=None, nontemporal=None, invariant=None, ordering=None, syncscope=None, access_groups=None, alias_scopes=None, noalias_scopes=None, tbaa=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(LoadOp(res=res, addr=addr, alignment=alignment, volatile_=volatile_, nontemporal=nontemporal, invariant=invariant, ordering=ordering, syncscope=syncscope, access_groups=access_groups, alias_scopes=alias_scopes, noalias_scopes=noalias_scopes, tbaa=tbaa, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MulOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.mul"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, overflowFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    if overflowFlags is not None: attributes["overflowFlags"] = (overflowFlags if (
        issubclass(type(overflowFlags), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_IntegerOverflowFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_IntegerOverflowFlagsAttr')(overflowFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def overflowFlags(self):
    return self.operation.attributes["overflowFlags"]

  @overflowFlags.setter
  def overflowFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["overflowFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def mul(lhs, rhs, *, overflow_flags=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(MulOp(lhs=lhs, rhs=rhs, overflowFlags=overflow_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class NoneTokenOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.mlir.none"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def res(self):
    return self.operation.results[0]

def mlir_none(*, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(NoneTokenOp(loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class OrOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.or"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def or_(lhs, rhs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(OrOp(lhs=lhs, rhs=rhs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class PoisonOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.mlir.poison"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def res(self):
    return self.operation.results[0]

def mlir_poison(res, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(PoisonOp(res=res, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class PtrToIntOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.ptrtoint"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, arg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(arg))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def ptrtoint(res, arg, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(PtrToIntOp(res=res, arg=arg, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ResumeOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.resume"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(value))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def value(self):
    return self.operation.operands[0]

def resume(value, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(ResumeOp(value=value, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ReturnOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.return"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, arg=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    if arg is not None: operands.append(_get_op_result_or_value(arg))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arg(self):
    return None if len(self.operation.operands) < 1 else self.operation.operands[0]

def return_(*, arg=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(ReturnOp(arg=arg, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SDivOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.sdiv"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def sdiv(lhs, rhs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(SDivOp(lhs=lhs, rhs=rhs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SExtOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.sext"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, arg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(arg))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def sext(res, arg, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(SExtOp(res=res, arg=arg, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SIToFPOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.sitofp"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, arg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(arg))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def sitofp(res, arg, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(SIToFPOp(res=res, arg=arg, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SRemOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.srem"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def srem(lhs, rhs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(SRemOp(lhs=lhs, rhs=rhs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SelectOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.select"

  _ODS_REGIONS = (0, True)

  def __init__(self, condition, trueValue, falseValue, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(condition))
    operands.append(_get_op_result_or_value(trueValue))
    operands.append(_get_op_result_or_value(falseValue))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        issubclass(type(fastmathFlags), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def condition(self):
    return self.operation.operands[0]

  @builtins.property
  def trueValue(self):
    return self.operation.operands[1]

  @builtins.property
  def falseValue(self):
    return self.operation.operands[2]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def select(condition, true_value, false_value, *, fastmath_flags=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(SelectOp(condition=condition, trueValue=true_value, falseValue=false_value, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ShlOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.shl"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, overflowFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    if overflowFlags is not None: attributes["overflowFlags"] = (overflowFlags if (
        issubclass(type(overflowFlags), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_IntegerOverflowFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_IntegerOverflowFlagsAttr')(overflowFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def overflowFlags(self):
    return self.operation.attributes["overflowFlags"]

  @overflowFlags.setter
  def overflowFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["overflowFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def shl(lhs, rhs, *, overflow_flags=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(ShlOp(lhs=lhs, rhs=rhs, overflowFlags=overflow_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ShuffleVectorOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.shufflevector"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, v1, v2, mask, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(v1))
    operands.append(_get_op_result_or_value(v2))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["mask"] = (mask if (
    issubclass(type(mask), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(mask, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def v1(self):
    return self.operation.operands[0]

  @builtins.property
  def v2(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.attributes["mask"]

  @mask.setter
  def mask(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["mask"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def shufflevector(res, v1, v2, mask, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(ShuffleVectorOp(res=res, v1=v1, v2=v2, mask=mask, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class StoreOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.store"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, addr, *, alignment=None, volatile_=None, nontemporal=None, ordering=None, syncscope=None, access_groups=None, alias_scopes=None, noalias_scopes=None, tbaa=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(value))
    operands.append(_get_op_result_or_value(addr))
    _ods_context = _ods_get_default_loc_context(loc)
    if alignment is not None: attributes["alignment"] = (alignment if (
        issubclass(type(alignment), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(alignment, context=_ods_context))
    if bool(volatile_): attributes["volatile_"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(nontemporal): attributes["nontemporal"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if ordering is not None: attributes["ordering"] = (ordering if (
        issubclass(type(ordering), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('AtomicOrdering')) else
          _ods_ir.AttrBuilder.get('AtomicOrdering')(ordering, context=_ods_context))
    if syncscope is not None: attributes["syncscope"] = (syncscope if (
        issubclass(type(syncscope), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(syncscope, context=_ods_context))
    if access_groups is not None: attributes["access_groups"] = (access_groups if (
        issubclass(type(access_groups), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AccessGroupArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AccessGroupArrayAttr')(access_groups, context=_ods_context))
    if alias_scopes is not None: attributes["alias_scopes"] = (alias_scopes if (
        issubclass(type(alias_scopes), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AliasScopeArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AliasScopeArrayAttr')(alias_scopes, context=_ods_context))
    if noalias_scopes is not None: attributes["noalias_scopes"] = (noalias_scopes if (
        issubclass(type(noalias_scopes), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AliasScopeArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AliasScopeArrayAttr')(noalias_scopes, context=_ods_context))
    if tbaa is not None: attributes["tbaa"] = (tbaa if (
        issubclass(type(tbaa), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_TBAATagArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_TBAATagArrayAttr')(tbaa, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def value(self):
    return self.operation.operands[0]

  @builtins.property
  def addr(self):
    return self.operation.operands[1]

  @builtins.property
  def alignment(self):
    if "alignment" not in self.operation.attributes:
      return None
    return self.operation.attributes["alignment"]

  @alignment.setter
  def alignment(self, value):
    if value is not None:
      self.operation.attributes["alignment"] = value
    elif "alignment" in self.operation.attributes:
      del self.operation.attributes["alignment"]

  @alignment.deleter
  def alignment(self):
    del self.operation.attributes["alignment"]

  @builtins.property
  def volatile_(self):
    return "volatile_" in self.operation.attributes

  @volatile_.setter
  def volatile_(self, value):
    if bool(value):
      self.operation.attributes["volatile_"] = _ods_ir.UnitAttr.get()
    elif "volatile_" in self.operation.attributes:
      del self.operation.attributes["volatile_"]

  @volatile_.deleter
  def volatile_(self):
    del self.operation.attributes["volatile_"]

  @builtins.property
  def nontemporal(self):
    return "nontemporal" in self.operation.attributes

  @nontemporal.setter
  def nontemporal(self, value):
    if bool(value):
      self.operation.attributes["nontemporal"] = _ods_ir.UnitAttr.get()
    elif "nontemporal" in self.operation.attributes:
      del self.operation.attributes["nontemporal"]

  @nontemporal.deleter
  def nontemporal(self):
    del self.operation.attributes["nontemporal"]

  @builtins.property
  def ordering(self):
    return self.operation.attributes["ordering"]

  @ordering.setter
  def ordering(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["ordering"] = value

  @builtins.property
  def syncscope(self):
    if "syncscope" not in self.operation.attributes:
      return None
    return self.operation.attributes["syncscope"]

  @syncscope.setter
  def syncscope(self, value):
    if value is not None:
      self.operation.attributes["syncscope"] = value
    elif "syncscope" in self.operation.attributes:
      del self.operation.attributes["syncscope"]

  @syncscope.deleter
  def syncscope(self):
    del self.operation.attributes["syncscope"]

  @builtins.property
  def access_groups(self):
    if "access_groups" not in self.operation.attributes:
      return None
    return self.operation.attributes["access_groups"]

  @access_groups.setter
  def access_groups(self, value):
    if value is not None:
      self.operation.attributes["access_groups"] = value
    elif "access_groups" in self.operation.attributes:
      del self.operation.attributes["access_groups"]

  @access_groups.deleter
  def access_groups(self):
    del self.operation.attributes["access_groups"]

  @builtins.property
  def alias_scopes(self):
    if "alias_scopes" not in self.operation.attributes:
      return None
    return self.operation.attributes["alias_scopes"]

  @alias_scopes.setter
  def alias_scopes(self, value):
    if value is not None:
      self.operation.attributes["alias_scopes"] = value
    elif "alias_scopes" in self.operation.attributes:
      del self.operation.attributes["alias_scopes"]

  @alias_scopes.deleter
  def alias_scopes(self):
    del self.operation.attributes["alias_scopes"]

  @builtins.property
  def noalias_scopes(self):
    if "noalias_scopes" not in self.operation.attributes:
      return None
    return self.operation.attributes["noalias_scopes"]

  @noalias_scopes.setter
  def noalias_scopes(self, value):
    if value is not None:
      self.operation.attributes["noalias_scopes"] = value
    elif "noalias_scopes" in self.operation.attributes:
      del self.operation.attributes["noalias_scopes"]

  @noalias_scopes.deleter
  def noalias_scopes(self):
    del self.operation.attributes["noalias_scopes"]

  @builtins.property
  def tbaa(self):
    if "tbaa" not in self.operation.attributes:
      return None
    return self.operation.attributes["tbaa"]

  @tbaa.setter
  def tbaa(self, value):
    if value is not None:
      self.operation.attributes["tbaa"] = value
    elif "tbaa" in self.operation.attributes:
      del self.operation.attributes["tbaa"]

  @tbaa.deleter
  def tbaa(self):
    del self.operation.attributes["tbaa"]

def store(value, addr, *, alignment=None, volatile_=None, nontemporal=None, ordering=None, syncscope=None, access_groups=None, alias_scopes=None, noalias_scopes=None, tbaa=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(StoreOp(value=value, addr=addr, alignment=alignment, volatile_=volatile_, nontemporal=nontemporal, ordering=ordering, syncscope=syncscope, access_groups=access_groups, alias_scopes=alias_scopes, noalias_scopes=noalias_scopes, tbaa=tbaa, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SubOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.sub"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, overflowFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    if overflowFlags is not None: attributes["overflowFlags"] = (overflowFlags if (
        issubclass(type(overflowFlags), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_IntegerOverflowFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_IntegerOverflowFlagsAttr')(overflowFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def overflowFlags(self):
    return self.operation.attributes["overflowFlags"]

  @overflowFlags.setter
  def overflowFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["overflowFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def sub(lhs, rhs, *, overflow_flags=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(SubOp(lhs=lhs, rhs=rhs, overflowFlags=overflow_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SwitchOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.switch"

  _ODS_OPERAND_SEGMENTS = [1,-1,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, value, defaultOperands, caseOperands, case_operand_segments, defaultDestination, caseDestinations, *, case_values=None, branch_weights=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(value))
    operands.append(_get_op_results_or_values(defaultOperands))
    operands.append(_get_op_results_or_values(caseOperands))
    _ods_context = _ods_get_default_loc_context(loc)
    if case_values is not None: attributes["case_values"] = (case_values if (
        issubclass(type(case_values), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('AnyIntElementsAttr')) else
          _ods_ir.AttrBuilder.get('AnyIntElementsAttr')(case_values, context=_ods_context))
    attributes["case_operand_segments"] = (case_operand_segments if (
    issubclass(type(case_operand_segments), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(case_operand_segments, context=_ods_context))
    if branch_weights is not None: attributes["branch_weights"] = (branch_weights if (
        issubclass(type(branch_weights), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(branch_weights, context=_ods_context))
    _ods_successors = []
    _ods_successors.append(defaultDestination)
    _ods_successors.extend(caseDestinations)
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def value(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def defaultOperands(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def caseOperands(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def case_values(self):
    if "case_values" not in self.operation.attributes:
      return None
    return self.operation.attributes["case_values"]

  @case_values.setter
  def case_values(self, value):
    if value is not None:
      self.operation.attributes["case_values"] = value
    elif "case_values" in self.operation.attributes:
      del self.operation.attributes["case_values"]

  @case_values.deleter
  def case_values(self):
    del self.operation.attributes["case_values"]

  @builtins.property
  def case_operand_segments(self):
    return self.operation.attributes["case_operand_segments"]

  @case_operand_segments.setter
  def case_operand_segments(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["case_operand_segments"] = value

  @builtins.property
  def branch_weights(self):
    if "branch_weights" not in self.operation.attributes:
      return None
    return self.operation.attributes["branch_weights"]

  @branch_weights.setter
  def branch_weights(self, value):
    if value is not None:
      self.operation.attributes["branch_weights"] = value
    elif "branch_weights" in self.operation.attributes:
      del self.operation.attributes["branch_weights"]

  @branch_weights.deleter
  def branch_weights(self):
    del self.operation.attributes["branch_weights"]

def switch(value, default_operands, case_operands, case_operand_segments, default_destination, case_destinations, *, case_values=None, branch_weights=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(SwitchOp(value=value, defaultOperands=default_operands, caseOperands=case_operands, case_operand_segments=case_operand_segments, defaultDestination=default_destination, caseDestinations=case_destinations, case_values=case_values, branch_weights=branch_weights, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class TruncOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.trunc"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, arg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(arg))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def trunc(res, arg, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(TruncOp(res=res, arg=arg, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class UDivOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.udiv"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def udiv(lhs, rhs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(UDivOp(lhs=lhs, rhs=rhs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class UIToFPOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.uitofp"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, arg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(arg))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def uitofp(res, arg, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(UIToFPOp(res=res, arg=arg, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class URemOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.urem"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def urem(lhs, rhs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(URemOp(lhs=lhs, rhs=rhs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class UndefOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.mlir.undef"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def res(self):
    return self.operation.results[0]

def mlir_undef(res, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(UndefOp(res=res, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class UnreachableOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.unreachable"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

def unreachable(*, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(UnreachableOp(loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class XOrOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.xor"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def xor(lhs, rhs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(XOrOp(lhs=lhs, rhs=rhs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ZExtOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.zext"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, arg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(arg))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def zext(res, arg, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(ZExtOp(res=res, arg=arg, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ZeroOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.mlir.zero"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def res(self):
    return self.operation.results[0]

def mlir_zero(res, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(ZeroOp(res=res, loc=loc, ip=ip))
