/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util.date;

import io.ktor.util.date.GMTDate;
import io.ktor.util.date.GMTDateBuilder;
import io.ktor.util.date.InvalidDateStringException;
import io.ktor.util.date.Month;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003J\u001c\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/ktor/util/date/GMTDateParser;", "", "pattern", "", "(Ljava/lang/String;)V", "parse", "Lio/ktor/util/date/GMTDate;", "dateString", "handleToken", "", "Lio/ktor/util/date/GMTDateBuilder;", "type", "", "chunk", "Companion", "ktor-utils"})
@SourceDebugExtension(value={"SMAP\nGMTDateParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GMTDateParser.kt\nio/ktor/util/date/GMTDateParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,128:1\n1#2:129\n1064#3,2:130\n*S KotlinDebug\n*F\n+ 1 GMTDateParser.kt\nio/ktor/util/date/GMTDateParser\n*L\n89#1:130,2\n*E\n"})
public final class GMTDateParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String pattern;
    public static final char SECONDS = 's';
    public static final char MINUTES = 'm';
    public static final char HOURS = 'h';
    public static final char DAY_OF_MONTH = 'd';
    public static final char MONTH = 'M';
    public static final char YEAR = 'Y';
    public static final char ZONE = 'z';
    public static final char ANY = '*';

    public GMTDateParser(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        this.pattern = pattern;
        if (!(((CharSequence)this.pattern).length() > 0)) {
            boolean bl = false;
            String string = "Date parser pattern shouldn't be empty.";
            throw new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public final GMTDate parse(@NotNull String dateString) {
        Intrinsics.checkNotNullParameter(dateString, "dateString");
        GMTDateBuilder builder = new GMTDateBuilder();
        int start2 = 0;
        char current = this.pattern.charAt(start2);
        int chunkStart = 0;
        int index = 1;
        try {
            while (index < this.pattern.length()) {
                if (this.pattern.charAt(index) == current) {
                    ++index;
                    continue;
                }
                int chunkEnd = chunkStart + index - start2;
                String string = dateString.substring(chunkStart, chunkEnd);
                Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                this.handleToken(builder, current, string);
                chunkStart = chunkEnd;
                start2 = index;
                current = this.pattern.charAt(index);
                ++index;
            }
            if (chunkStart < dateString.length()) {
                String string = dateString.substring(chunkStart);
                Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
                this.handleToken(builder, current, string);
            }
        }
        catch (Throwable _) {
            throw new InvalidDateStringException(dateString, chunkStart, this.pattern);
        }
        return builder.build();
    }

    private final void handleToken(GMTDateBuilder $this$handleToken, char type2, String chunk) {
        char c = type2;
        if (c == 's') {
            $this$handleToken.setSeconds(Integer.parseInt(chunk));
        } else if (c == 'm') {
            $this$handleToken.setMinutes(Integer.parseInt(chunk));
        } else if (c == 'h') {
            $this$handleToken.setHours(Integer.parseInt(chunk));
        } else if (c == 'd') {
            $this$handleToken.setDayOfMonth(Integer.parseInt(chunk));
        } else if (c == 'M') {
            $this$handleToken.setMonth(Month.Companion.from(chunk));
        } else if (c == 'Y') {
            $this$handleToken.setYear(Integer.parseInt(chunk));
        } else if (c == 'z') {
            if (!Intrinsics.areEqual(chunk, "GMT")) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
        } else if (c != '*') {
            boolean bl;
            block18: {
                CharSequence $this$all$iv = chunk;
                boolean $i$f$all = false;
                for (int i = 0; i < $this$all$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$all$iv.charAt(i);
                    boolean bl2 = false;
                    if (it == type2) continue;
                    bl = false;
                    break block18;
                }
                bl = true;
            }
            if (!bl) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/ktor/util/date/GMTDateParser$Companion;", "", "()V", "ANY", "", "DAY_OF_MONTH", "HOURS", "MINUTES", "MONTH", "SECONDS", "YEAR", "ZONE", "ktor-utils"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

