/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.streams;

import io.ktor.utils.io.core.BytePacketBuilder;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.Input;
import io.ktor.utils.io.core.InputArraysKt;
import io.ktor.utils.io.core.Output;
import io.ktor.utils.io.core.OutputKt;
import java.io.EOFException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u001a\u0012\u0010\b\u001a\u00020\u0004*\u00020\u00032\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u000b\u001a\u00020\u0004*\u00020\u00032\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\f\u001a\u00020\u0004*\u00020\u00032\u0006\u0010\t\u001a\u00020\n\u001a\u001c\u0010\r\u001a\u00020\u0004*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0002\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0004\u001a#\u0010\u0012\u001a\u00020\u0013*\u00020\u00062\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00130\u0015\u00a2\u0006\u0002\b\u0016\u001a\u0012\u0010\u0012\u001a\u00020\u0013*\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0004\u001a\n\u0010\u0018\u001a\u00020\u0019*\u00020\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"SkipBuffer", "", "inputStream", "Ljava/io/InputStream;", "Lio/ktor/utils/io/core/ByteReadPacket;", "outputStream", "Ljava/io/OutputStream;", "Lio/ktor/utils/io/core/BytePacketBuilder;", "readPacketAtLeast", "n", "", "readPacketAtMost", "readPacketExact", "readPacketImpl", "min", "max", "readerUTF8", "Ljava/io/Reader;", "writePacket", "", "builder", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "packet", "writerUTF8", "Ljava/io/Writer;", "ktor-io"})
@SourceDebugExtension(value={"SMAP\nStreams.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Streams.kt\nio/ktor/utils/io/streams/StreamsKt\n+ 2 Builder.kt\nio/ktor/utils/io/core/BuilderKt\n+ 3 Packet.kt\nio/ktor/utils/io/core/PacketKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n12#2,11:156\n43#3:167\n1#4:168\n*S KotlinDebug\n*F\n+ 1 Streams.kt\nio/ktor/utils/io/streams/StreamsKt\n*L\n11#1:156,11\n23#1:167\n*E\n"})
public final class StreamsKt {
    @NotNull
    private static final char[] SkipBuffer = new char[8192];

    public static final void writePacket(@NotNull OutputStream $this$writePacket, @NotNull Function1<? super BytePacketBuilder, Unit> builder) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter($this$writePacket, "<this>");
        Intrinsics.checkNotNullParameter(builder, "builder");
        OutputStream outputStream2 = $this$writePacket;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            builder.invoke(builder$iv);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        StreamsKt.writePacket(outputStream2, byteReadPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writePacket(@NotNull OutputStream $this$writePacket, @NotNull ByteReadPacket packet) {
        Intrinsics.checkNotNullParameter($this$writePacket, "<this>");
        Intrinsics.checkNotNullParameter(packet, "packet");
        long s = packet.getRemaining();
        if (s == 0L) {
            return;
        }
        byte[] buffer = new byte[(int)RangesKt.coerceAtMost(s, 4096L)];
        try {
            while (true) {
                ByteReadPacket $this$isNotEmpty$iv = packet;
                boolean $i$f$isNotEmpty = false;
                if (!$this$isNotEmpty$iv.getEndOfInput()) {
                    int size2 = InputArraysKt.readAvailable$default((Input)packet, buffer, 0, 0, 6, null);
                    $this$writePacket.write(buffer, 0, size2);
                    continue;
                }
                break;
            }
        }
        finally {
            packet.release();
        }
    }

    @NotNull
    public static final ByteReadPacket readPacketExact(@NotNull InputStream $this$readPacketExact, long n) {
        Intrinsics.checkNotNullParameter($this$readPacketExact, "<this>");
        return StreamsKt.readPacketImpl($this$readPacketExact, n, n);
    }

    @NotNull
    public static final ByteReadPacket readPacketAtLeast(@NotNull InputStream $this$readPacketAtLeast, long n) {
        Intrinsics.checkNotNullParameter($this$readPacketAtLeast, "<this>");
        return StreamsKt.readPacketImpl($this$readPacketAtLeast, n, Long.MAX_VALUE);
    }

    @NotNull
    public static final ByteReadPacket readPacketAtMost(@NotNull InputStream $this$readPacketAtMost, long n) {
        Intrinsics.checkNotNullParameter($this$readPacketAtMost, "<this>");
        return StreamsKt.readPacketImpl($this$readPacketAtMost, 1L, n);
    }

    private static final ByteReadPacket readPacketImpl(InputStream $this$readPacketImpl, long min, long max) {
        if (!(min >= 0L)) {
            boolean $i$a$-require-StreamsKt$readPacketImpl$32 = false;
            String $i$a$-require-StreamsKt$readPacketImpl$32 = "min shouldn't be negative";
            throw new IllegalArgumentException($i$a$-require-StreamsKt$readPacketImpl$32.toString());
        }
        if (!(min <= max)) {
            boolean $i$a$-require-StreamsKt$readPacketImpl$42 = false;
            String $i$a$-require-StreamsKt$readPacketImpl$42 = "min shouldn't be greater than max: " + min + " > " + max;
            throw new IllegalArgumentException($i$a$-require-StreamsKt$readPacketImpl$42.toString());
        }
        byte[] buffer = new byte[(int)RangesKt.coerceAtMost(max, 4096L)];
        BytePacketBuilder builder = new BytePacketBuilder(null, 1, null);
        try {
            int rc2;
            for (long read2 = 0L; read2 < min || read2 == min && min == 0L; read2 += (long)rc2) {
                int remInt = (int)Math.min(max - read2, Integer.MAX_VALUE);
                rc2 = $this$readPacketImpl.read(buffer, 0, Math.min(remInt, buffer.length));
                if (rc2 == -1) {
                    throw new EOFException("Premature end of stream: was read " + read2 + " bytes of " + min);
                }
                OutputKt.writeFully((Output)builder, buffer, 0, rc2);
            }
        }
        catch (Throwable t) {
            builder.release();
            throw t;
        }
        return builder.build();
    }

    @NotNull
    public static final InputStream inputStream(@NotNull ByteReadPacket $this$inputStream) {
        Intrinsics.checkNotNullParameter($this$inputStream, "<this>");
        return new InputStream($this$inputStream){
            final /* synthetic */ ByteReadPacket $this_inputStream;
            {
                this.$this_inputStream = $receiver;
            }

            public int read() {
                ByteReadPacket $this$isEmpty$iv = this.$this_inputStream;
                boolean $i$f$isEmpty = false;
                if ($this$isEmpty$iv.getEndOfInput()) {
                    return -1;
                }
                return this.$this_inputStream.readByte() & 0xFF;
            }

            public int available() {
                long $this$coerceAtMostMaxInt$iv = this.$this_inputStream.getRemaining();
                boolean $i$f$coerceAtMostMaxInt = false;
                return (int)Math.min($this$coerceAtMostMaxInt$iv, Integer.MAX_VALUE);
            }

            public void close() {
                this.$this_inputStream.release();
            }
        };
    }

    @NotNull
    public static final Reader readerUTF8(@NotNull ByteReadPacket $this$readerUTF8) {
        Intrinsics.checkNotNullParameter($this$readerUTF8, "<this>");
        return new Reader($this$readerUTF8){
            final /* synthetic */ ByteReadPacket $this_readerUTF8;
            {
                this.$this_readerUTF8 = $receiver;
            }

            public void close() {
                this.$this_readerUTF8.release();
            }

            public long skip(long n) {
                int size2;
                long skipped;
                int rc2;
                char[] buffer = StreamsKt.access$getSkipBuffer$p();
                int bufferSize = buffer.length;
                for (skipped = 0L; skipped < n && (rc2 = this.read(buffer, 0, size2 = (int)Math.min((long)bufferSize, n - skipped))) != -1; skipped += (long)rc2) {
                }
                return skipped;
            }

            public int read(@NotNull char[] cbuf, int off, int len) {
                Intrinsics.checkNotNullParameter(cbuf, "cbuf");
                return this.$this_readerUTF8.readAvailableCharacters$ktor_io(cbuf, off, len);
            }
        };
    }

    @NotNull
    public static final OutputStream outputStream(@NotNull BytePacketBuilder $this$outputStream) {
        Intrinsics.checkNotNullParameter($this$outputStream, "<this>");
        return new OutputStream($this$outputStream){
            final /* synthetic */ BytePacketBuilder $this_outputStream;
            {
                this.$this_outputStream = $receiver;
            }

            public void write(int b) {
                this.$this_outputStream.writeByte((byte)b);
            }

            public void write(@NotNull byte[] b, int off, int len) {
                Intrinsics.checkNotNullParameter(b, "b");
                OutputKt.writeFully((Output)this.$this_outputStream, b, off, len);
            }

            public void close() {
            }
        };
    }

    @NotNull
    public static final Writer writerUTF8(@NotNull BytePacketBuilder $this$writerUTF8) {
        Intrinsics.checkNotNullParameter($this$writerUTF8, "<this>");
        return new Writer($this$writerUTF8){
            final /* synthetic */ BytePacketBuilder $this_writerUTF8;
            {
                this.$this_writerUTF8 = $receiver;
            }

            public void write(@NotNull char[] cbuf, int off, int len) {
                Intrinsics.checkNotNullParameter(cbuf, "cbuf");
                this.$this_writerUTF8.append(cbuf, off, off + len);
            }

            public void flush() {
            }

            public void close() {
            }
        };
    }

    public static final /* synthetic */ char[] access$getSkipBuffer$p() {
        return SkipBuffer;
    }
}

