// Copyright (c) 2015, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

library test.src.task.test_all;

import 'package:unittest/unittest.dart';

import 'dart_test.dart' as dart_test;
import 'dart_work_manager_test.dart' as dart_work_manager_test;
import 'driver_test.dart' as driver_test;
import 'general_test.dart' as general_test;
import 'html_test.dart' as html_test;
import 'html_work_manager_test.dart' as html_work_manager_test;
import 'incremental_element_builder_test.dart'
    as incremental_element_builder_test;
import 'inputs_test.dart' as inputs_test;
import 'manager_test.dart' as manager_test;
import 'model_test.dart' as model_test;

/// Utility for manually running all tests.
main() {
  groupSep = ' | ';
  group('task tests', () {
    dart_test.main();
    dart_work_manager_test.main();
    driver_test.main();
    general_test.main();
    html_test.main();
    html_work_manager_test.main();
    incremental_element_builder_test.main();
    inputs_test.main();
    manager_test.main();
    model_test.main();
  });
}
