// Copyright (c) 2015, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

library dart2js.js_emitter.headers;
import '../dart2jslib.dart' show Compiler;

String generatedBy(Compiler compiler, {String flavor: ""}) {
  String suffix = '';
  if (compiler.hasBuildId) suffix = ' version: ${compiler.buildId}';
  if (flavor != "") flavor = " ($flavor)";
  return '// Generated by dart2js$flavor, '
      'the Dart to JavaScript compiler$suffix.';
}

const String HOOKS_API_USAGE = """
// The code supports the following hooks:
// dartPrint(message):
//    if this function is defined it is called instead of the Dart [print]
//    method.
//
// dartMainRunner(main, args):
//    if this function is defined, the Dart [main] method will not be invoked
//    directly. Instead, a closure that will invoke [main], and its arguments
//    [args] is passed to [dartMainRunner].
//
// dartDeferredLibraryLoader(uri, successCallback, errorCallback):
//    if this function is defined, it will be called when a deferered library
//    is loaded. It should load and eval the javascript of `uri`, and call
//    successCallback. If it fails to do so, it should call errorCallback with
//    an error.
""";
