docgen
======

A documentation generator for Dart.
- - -
The docgen tool takes in a file or directory as input and produces documentation
for all `.dart` file it finds as YAML or JSON files. This outputs information 
about all classes, variables, functions, and methods defined in the library and 
its imported libraries.

### Quick Start: Common Commands 

##### To only generate documentation, while standing in the `bin` directory:

`dartdoc.py` generates all documentation and runs a local server with your html
pages.

`dartdoc.py -d` ONLY generates documentation for the SDK and all packages (no
html pages generated and no server).

`dartdoc.py -d -o package/to/document` ONLY generates documenation for the
specified package.

##### To generate documentation and view it through the webpage:
- Install [Google App Engine SDK for Python][GAE] (one time setup) and agree to
   add symlinks so that dev\_appserver.py can be found on your PATH.
- Run `dartdoc.py`.

### Generating files & uploading to Cloud Storage

The viewer uses YAML files generated by the docgen package as the data 
being displayed. These files are stored in Google Cloud Storage.

 - Run `python upload_docgen.py` to generate these files and upload them to 
 Cloud Storage as a new version.
- - -
These tasks can be done separately if necessary:

##### 

#### Generating YAML files

YAML files can be generated using the docgen package in the dart repository. 

###### Usage 

Run  `dart docgen.dart [OPTIONS] <path to directory or file>`

###### Options available

- `-h`, `--help` Prints help and usage information.
- `-v`, `--verbose` Output more logging information.
- `-j`, `--[no-]json` Outputs to JSON. Files are outputted to YAML by default. 
If `--append` is used, it takes the file-format of the previous run stated in 
library_list.json ignoring the flag.
- `--include-private` Flag to include private declarations.
- `--include-sdk` Flag to parse SDK Library files imported.
- `--parse-sdk` Parses the SDK libraries only. (Ignores the path passed in.)
- `--package-root` Sets the package root of the library being analyzed.
- `--append` Appends to the docs folder, library_list.json, and index.txt.
- `--introduction` Adds the provided markdown text file as the introduction
for the outputted documentation.


###### Output directory
Documented libraries will be located at bin/docs in either YAML or JSON format 
depending on options specified. There will also be a library\_list.json, 
containing a list of all the libraries inside the docs folder. 

To get more information on how to use the outputted documentation with 
dartdoc-viewer, please take a look at the 
[dartdoc-viewer documentation][dartdoc-viewer].

#### Uploading to Cloud Storage

To push new files to Google Cloud Storage for use by the viewer, use the 
`gsutil` tool located at third_party/gsutil/gsutil in the Dart repository.

 - Run `python gsutil -m cp -q -a public-read -r <folder> gs://dartlang-docgen`
 to upload the specified folder to the viewer's bucket. Be sure to also upload 
 a new VERSION file if the uploaded folder is to be used.**

**Note that the bucket contains several numbered folders for each version of 
the documentation. Run `python gsutil ls gs://dartlang-docgen` to see the file 
layout. Follow this convention and update a new VERSION file when uploading 
a new version of documentation. You can see the format of the VERSION file 
by running `python gsutil cat gs://dartlang-docgen/VERSION`.

### Viewing generated documentation

Docgen's generated YAML files can be used by the 
[Dart Documentation Viewer][dartdoc-viewer] for easy viewing and navigation 
through a project. 

---

#### Using dartdoc.py

The `dartdoc.py` script located in the `bin` directory is a useful tool for 
creating documentation for a Dart project and running it locally. 

##### Setup

The `dartdoc.py` script makes use of the 
[Google App Engine SDK for Python][GAE]'s development server to serve the 
documentation viewer. Install a recent version of the SDK before running 
`dartdoc.py`.

##### Running dartdoc.py

######Common Options

The following options are the most used:

    python dartdoc.py --gae-sdk=<path to SDK>
      --options=<path to files>
      --options=--parse-sdk
      --options='--include-sdk <path to files>'
      --options='--append <path to files>'

######All Options

Run `python dartdoc.py -h` from the `bin` directory for all available options. 
The two required options are as follows:
 
 1. The `--options` option describes any options being passed into `docgen.dart`.
 If more then one option is desired, separate the options with a space 
 (ex. `--options='--include-sdk files'`).
 2. The `--gae-sdk` option gives the absolute path to the 
 [Google App Engine SDK][GAE]. 

Running `python dartdoc.py --options=<docgen options> --gae-sdk=<path to SDK>` 
will serve files generated by `docgen.dart` in your browser.

[dartdoc-viewer]: https://github.com/dart-lang/dartdoc-viewer "Dartdoc-Viewer"
[GAE]: https://developers.google.com/appengine/downloads#Google_App_Engine_SDK_for_Python  "Google App Engine SDK for Python"

