# Copyright (c) 2012 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

# Copyright (c) 2012, the Dart project authors.  Please see the AUTHORS file
# for details. All rights reserved. Use of this source code is governed by a
# BSD-style license that can be found in the LICENSE file.

# This file is a modified copy of Chromium's deps/third_party/nss/nss.gyp.
# Revision 291806 (this should agree with "nss_rev" in DEPS).
{
  # Added by Dart. All Dart comments refer to the following block or line.
  'includes': [
    '../../tools/gyp/runtime-configurations.gypi',
    '../../tools/gyp/nss_configurations.gypi',
  ],
  'variables': {
    # Added by Dart.
    'nss_directory': '../../../third_party/nss',
    'conditions': [
      ['OS=="ios"', {
        'exclude_nss_root_certs%': 0,
        'exclude_nss_libpkix%': 0,
      }, {
        'exclude_nss_root_certs%': 1,
        'exclude_nss_libpkix%': 1,
      }],
    ],
  },
  'target_defaults': {
    'configurations': {
      'Debug': {
        'defines': [
          'DEBUG',
          '_DEBUG',
        ],
      },
      'Release': {
        'defines': [
          'NDEBUG',
        ],
      },
      # Added by Dart.
      'Dart_ia32_Base': {
        'defines': [
          'NSS_X86_OR_X64',
          'NSS_X86',
          '_X86_',
        ],
      },
      # Added by Dart.
      'Dart_x64_Base': {
        'defines': [
          'NSS_X86_OR_X64',
          'NSS_X64',
          'NSS_USE_64',
        ],
      },
      # Added by Dart.
      'Dart_simarm64_Base': {
        'defines': [
          'NSS_X86_OR_X64',
          'NSS_X64',
          'NSS_USE_64',
        ],
      },
      'Dart_arm64_Base': {
        'defines': [
          'NSS_USE_64',
        ],
      },
    },
    'conditions': [
      ['OS=="win"', {
        'configurations': {
          'Common_Base': {
            'msvs_configuration_attributes': {
              # Do not compile NSPR and NSS with /D _UNICODE /D UNICODE.
              'CharacterSet': '0'
            }
          },
          # Added by Dart. All target_arch specific defines are taken
          # from below.
          'Dart_ia32_Base': {
            'defines': [
              'NSS_X86_OR_X64',
              'NSS_X86',
              '_X86_',
              'MP_ASSEMBLY_MULTIPLY',
              'MP_ASSEMBLY_SQUARE',
              'MP_ASSEMBLY_DIV_2DX1D',
              'MP_USE_UINT_DIGIT',
              'MP_NO_MP_WORD',
            ],
          },
          'Dart_x64_Base': {
            'defines': [
              'NSS_USE_64',
              'NSS_X86_OR_X64',
              'NSS_X64',
              '_AMD64_',
              'MP_CHAR_STORE_SLOW',
              'MP_IS_LITTLE_ENDIAN',
              'WIN64',
            ],
          },
        },
        'defines!': [
          'WIN32_LEAN_AND_MEAN',
        ],
      }],
    ],
  },
  # Added by Dart.  We do not indent, so diffs with the original are clearer.
  'conditions': [[ 'dart_io_support==1', {
  'targets': [
    {
      'target_name': 'nspr_dart',  # Added by Dart (the _dart postfix)
      'product_name': 'crnspr',
      'type': '<(component)',
      'toolsets':['host','target'],
      # Changed by Dart: '<(nss_directory)/' added to all paths.
      'sources': [
        # Added by Dart.
        'os_linux.S',
        '<(nss_directory)/nspr/lib/ds/plarena.c',
        '<(nss_directory)/nspr/lib/ds/plarena.h',
        '<(nss_directory)/nspr/lib/ds/plarenas.h',
        '<(nss_directory)/nspr/lib/ds/plhash.c',
        '<(nss_directory)/nspr/lib/ds/plhash.h',
        '<(nss_directory)/nspr/lib/libc/include/plbase64.h',
        '<(nss_directory)/nspr/lib/libc/include/plerror.h',
        '<(nss_directory)/nspr/lib/libc/include/plgetopt.h',
        '<(nss_directory)/nspr/lib/libc/include/plstr.h',
        '<(nss_directory)/nspr/lib/libc/src/base64.c',
        '<(nss_directory)/nspr/lib/libc/src/plerror.c',
        '<(nss_directory)/nspr/lib/libc/src/plgetopt.c',
        '<(nss_directory)/nspr/lib/libc/src/strcase.c',
        '<(nss_directory)/nspr/lib/libc/src/strcat.c',
        '<(nss_directory)/nspr/lib/libc/src/strchr.c',
        '<(nss_directory)/nspr/lib/libc/src/strcmp.c',
        '<(nss_directory)/nspr/lib/libc/src/strcpy.c',
        '<(nss_directory)/nspr/lib/libc/src/strdup.c',
        '<(nss_directory)/nspr/lib/libc/src/strlen.c',
        '<(nss_directory)/nspr/lib/libc/src/strpbrk.c',
        '<(nss_directory)/nspr/lib/libc/src/strstr.c',
        '<(nss_directory)/nspr/lib/libc/src/strtok.c',
        '<(nss_directory)/nspr/pr/include/md/prosdep.h',
        '<(nss_directory)/nspr/pr/include/md/_darwin.cfg',
        '<(nss_directory)/nspr/pr/include/md/_darwin.h',
        # Added by Dart.
        '<(nss_directory)/nspr/pr/include/md/_linux.cfg',
        # Added by Dart.
        '<(nss_directory)/nspr/pr/include/md/_linux.h',
        '<(nss_directory)/nspr/pr/include/md/_pcos.h',
        '<(nss_directory)/nspr/pr/include/md/_pth.h',
        '<(nss_directory)/nspr/pr/include/md/_unixos.h',
        '<(nss_directory)/nspr/pr/include/md/_unix_errors.h',
        '<(nss_directory)/nspr/pr/include/md/_win32_errors.h',
        '<(nss_directory)/nspr/pr/include/md/_win95.cfg',
        '<(nss_directory)/nspr/pr/include/md/_win95.h',
        '<(nss_directory)/nspr/pr/include/nspr.h',
        '<(nss_directory)/nspr/pr/include/obsolete/pralarm.h',
        '<(nss_directory)/nspr/pr/include/obsolete/probslet.h',
        '<(nss_directory)/nspr/pr/include/obsolete/protypes.h',
        '<(nss_directory)/nspr/pr/include/obsolete/prsem.h',
        '<(nss_directory)/nspr/pr/include/pratom.h',
        '<(nss_directory)/nspr/pr/include/prbit.h',
        '<(nss_directory)/nspr/pr/include/prclist.h',
        '<(nss_directory)/nspr/pr/include/prcmon.h',
        '<(nss_directory)/nspr/pr/include/prcountr.h',
        '<(nss_directory)/nspr/pr/include/prcpucfg.h',
        '<(nss_directory)/nspr/pr/include/prcvar.h',
        '<(nss_directory)/nspr/pr/include/prdtoa.h',
        '<(nss_directory)/nspr/pr/include/prenv.h',
        '<(nss_directory)/nspr/pr/include/prerr.h',
        '<(nss_directory)/nspr/pr/include/prerror.h',
        '<(nss_directory)/nspr/pr/include/prinet.h',
        '<(nss_directory)/nspr/pr/include/prinit.h',
        '<(nss_directory)/nspr/pr/include/prinrval.h',
        '<(nss_directory)/nspr/pr/include/prio.h',
        '<(nss_directory)/nspr/pr/include/pripcsem.h',
        '<(nss_directory)/nspr/pr/include/private/pprio.h',
        '<(nss_directory)/nspr/pr/include/private/pprmwait.h',
        '<(nss_directory)/nspr/pr/include/private/pprthred.h',
        '<(nss_directory)/nspr/pr/include/private/primpl.h',
        '<(nss_directory)/nspr/pr/include/private/prpriv.h',
        '<(nss_directory)/nspr/pr/include/prlink.h',
        '<(nss_directory)/nspr/pr/include/prlock.h',
        '<(nss_directory)/nspr/pr/include/prlog.h',
        '<(nss_directory)/nspr/pr/include/prlong.h',
        '<(nss_directory)/nspr/pr/include/prmem.h',
        '<(nss_directory)/nspr/pr/include/prmon.h',
        '<(nss_directory)/nspr/pr/include/prmwait.h',
        '<(nss_directory)/nspr/pr/include/prnetdb.h',
        '<(nss_directory)/nspr/pr/include/prolock.h',
        '<(nss_directory)/nspr/pr/include/prpdce.h',
        '<(nss_directory)/nspr/pr/include/prprf.h',
        '<(nss_directory)/nspr/pr/include/prproces.h',
        '<(nss_directory)/nspr/pr/include/prrng.h',
        '<(nss_directory)/nspr/pr/include/prrwlock.h',
        '<(nss_directory)/nspr/pr/include/prshm.h',
        '<(nss_directory)/nspr/pr/include/prshma.h',
        '<(nss_directory)/nspr/pr/include/prsystem.h',
        '<(nss_directory)/nspr/pr/include/prthread.h',
        '<(nss_directory)/nspr/pr/include/prtime.h',
        '<(nss_directory)/nspr/pr/include/prtpool.h',
        '<(nss_directory)/nspr/pr/include/prtrace.h',
        '<(nss_directory)/nspr/pr/include/prtypes.h',
        '<(nss_directory)/nspr/pr/include/prvrsion.h',
        '<(nss_directory)/nspr/pr/include/prwin16.h',
        '<(nss_directory)/nspr/pr/src/io/prdir.c',
        '<(nss_directory)/nspr/pr/src/io/prfdcach.c',
        '<(nss_directory)/nspr/pr/src/io/prfile.c',
        '<(nss_directory)/nspr/pr/src/io/prio.c',
        '<(nss_directory)/nspr/pr/src/io/priometh.c',
        '<(nss_directory)/nspr/pr/src/io/pripv6.c',
        '<(nss_directory)/nspr/pr/src/io/prlayer.c',
        '<(nss_directory)/nspr/pr/src/io/prlog.c',
        '<(nss_directory)/nspr/pr/src/io/prmapopt.c',
        '<(nss_directory)/nspr/pr/src/io/prmmap.c',
        '<(nss_directory)/nspr/pr/src/io/prmwait.c',
        '<(nss_directory)/nspr/pr/src/io/prpolevt.c',
        '<(nss_directory)/nspr/pr/src/io/prprf.c',
        '<(nss_directory)/nspr/pr/src/io/prscanf.c',
        '<(nss_directory)/nspr/pr/src/io/prsocket.c',
        '<(nss_directory)/nspr/pr/src/io/prstdio.c',
        '<(nss_directory)/nspr/pr/src/linking/prlink.c',
        '<(nss_directory)/nspr/pr/src/malloc/prmalloc.c',
        '<(nss_directory)/nspr/pr/src/malloc/prmem.c',
        '<(nss_directory)/nspr/pr/src/md/prosdep.c',
        '<(nss_directory)/nspr/pr/src/md/unix/darwin.c',
        # Added by Dart.
        '<(nss_directory)/nspr/pr/src/md/unix/linux.c',
        '<(nss_directory)/nspr/pr/src/md/unix/os_Darwin.s',
        '<(nss_directory)/nspr/pr/src/md/unix/os_Darwin_x86.s',
        '<(nss_directory)/nspr/pr/src/md/unix/os_Darwin_x86_64.s',
        # Added by Dart.
        '<(nss_directory)/nspr/pr/src/md/unix/os_Linux_x86.s',
        # Added by Dart.
        '<(nss_directory)/nspr/pr/src/md/unix/os_Linux_x86_64.s',
        '<(nss_directory)/nspr/pr/src/md/unix/unix.c',
        '<(nss_directory)/nspr/pr/src/md/unix/unix_errors.c',
        '<(nss_directory)/nspr/pr/src/md/unix/uxproces.c',
        '<(nss_directory)/nspr/pr/src/md/unix/uxrng.c',
        '<(nss_directory)/nspr/pr/src/md/unix/uxshm.c',
        '<(nss_directory)/nspr/pr/src/md/unix/uxwrap.c',
        '<(nss_directory)/nspr/pr/src/md/windows/ntgc.c',
        '<(nss_directory)/nspr/pr/src/md/windows/ntinrval.c',
        '<(nss_directory)/nspr/pr/src/md/windows/ntmisc.c',
        '<(nss_directory)/nspr/pr/src/md/windows/ntsec.c',
        '<(nss_directory)/nspr/pr/src/md/windows/ntsem.c',
        '<(nss_directory)/nspr/pr/src/md/windows/w32ipcsem.c',
        '<(nss_directory)/nspr/pr/src/md/windows/w32poll.c',
        '<(nss_directory)/nspr/pr/src/md/windows/w32rng.c',
        '<(nss_directory)/nspr/pr/src/md/windows/w32shm.c',
        '<(nss_directory)/nspr/pr/src/md/windows/w95cv.c',
        '<(nss_directory)/nspr/pr/src/md/windows/w95dllmain.c',
        '<(nss_directory)/nspr/pr/src/md/windows/w95io.c',
        '<(nss_directory)/nspr/pr/src/md/windows/w95sock.c',
        '<(nss_directory)/nspr/pr/src/md/windows/w95thred.c',
        '<(nss_directory)/nspr/pr/src/md/windows/win32_errors.c',
        '<(nss_directory)/nspr/pr/src/memory/prseg.c',
        '<(nss_directory)/nspr/pr/src/memory/prshm.c',
        '<(nss_directory)/nspr/pr/src/memory/prshma.c',
        '<(nss_directory)/nspr/pr/src/misc/pralarm.c',
        '<(nss_directory)/nspr/pr/src/misc/pratom.c',
        '<(nss_directory)/nspr/pr/src/misc/praton.c',
        '<(nss_directory)/nspr/pr/src/misc/prcountr.c',
        '<(nss_directory)/nspr/pr/src/misc/prdtoa.c',
        '<(nss_directory)/nspr/pr/src/misc/prenv.c',
        '<(nss_directory)/nspr/pr/src/misc/prerr.c',
        '<(nss_directory)/nspr/pr/src/misc/prerror.c',
        '<(nss_directory)/nspr/pr/src/misc/prerrortable.c',
        '<(nss_directory)/nspr/pr/src/misc/prinit.c',
        '<(nss_directory)/nspr/pr/src/misc/prinrval.c',
        '<(nss_directory)/nspr/pr/src/misc/pripc.c',
        '<(nss_directory)/nspr/pr/src/misc/pripcsem.c',
        '<(nss_directory)/nspr/pr/src/misc/prlog2.c',
        '<(nss_directory)/nspr/pr/src/misc/prlong.c',
        '<(nss_directory)/nspr/pr/src/misc/prnetdb.c',
        '<(nss_directory)/nspr/pr/src/misc/prolock.c',
        '<(nss_directory)/nspr/pr/src/misc/prrng.c',
        '<(nss_directory)/nspr/pr/src/misc/prsystem.c',
        '<(nss_directory)/nspr/pr/src/misc/prthinfo.c',
        '<(nss_directory)/nspr/pr/src/misc/prtime.c',
        '<(nss_directory)/nspr/pr/src/misc/prtpool.c',
        '<(nss_directory)/nspr/pr/src/misc/prtrace.c',
        '<(nss_directory)/nspr/pr/src/pthreads/ptio.c',
        '<(nss_directory)/nspr/pr/src/pthreads/ptmisc.c',
        '<(nss_directory)/nspr/pr/src/pthreads/ptsynch.c',
        '<(nss_directory)/nspr/pr/src/pthreads/ptthread.c',
        '<(nss_directory)/nspr/pr/src/threads/combined/prucpu.c',
        '<(nss_directory)/nspr/pr/src/threads/combined/prucv.c',
        '<(nss_directory)/nspr/pr/src/threads/combined/prulock.c',
        '<(nss_directory)/nspr/pr/src/threads/combined/prustack.c',
        '<(nss_directory)/nspr/pr/src/threads/combined/pruthr.c',
        '<(nss_directory)/nspr/pr/src/threads/prcmon.c',
        '<(nss_directory)/nspr/pr/src/threads/prcthr.c',
        '<(nss_directory)/nspr/pr/src/threads/prdump.c',
        '<(nss_directory)/nspr/pr/src/threads/prmon.c',
        '<(nss_directory)/nspr/pr/src/threads/prrwlock.c',
        '<(nss_directory)/nspr/pr/src/threads/prsem.c',
        '<(nss_directory)/nspr/pr/src/threads/prtpd.c',
      ],
      'defines': [
        '_NSPR_BUILD_',
        'FORCE_PR_LOG',
      ],
      'include_dirs': [
        '<(nss_directory)/nspr/pr/include',
        '<(nss_directory)/nspr/pr/include/private',
        '<(nss_directory)/nspr/lib/ds',
        '<(nss_directory)/nspr/lib/libc/include',
      ],
      'direct_dependent_settings': {
        'defines': [
          'NO_NSPR_10_SUPPORT',
        ],
        'include_dirs': [
          '<(nss_directory)/nspr/pr/include',
          '<(nss_directory)/nspr/lib/ds',
          '<(nss_directory)/nspr/lib/libc/include',
        ],
      },
      # TODO(wtc): suppress C4244 and C4554 in prdtoa.c.
      'msvs_disabled_warnings': [4018, 4244, 4554, 4267,],
      'variables': {
        'clang_warning_flags': [
          # nspr passes "const char*" through "void*".
          '-Wno-incompatible-pointer-types',
          # nspr passes "int*" through "unsigned int*".
          '-Wno-pointer-sign',
        ],
      },
      'conditions': [
        ['OS=="mac" or OS=="ios"', {
          'defines': [
            'XP_UNIX',
            'DARWIN',
            'XP_MACOSX',
            '_PR_PTHREADS',
            'HAVE_BSD_FLOCK',
            'HAVE_CRT_EXTERNS_H',
            'HAVE_DLADDR',
            'HAVE_LCHOWN',
            'HAVE_SOCKLEN_T',
            'HAVE_STRERROR',
          ],
          # Changed by Dart:
          # nss_directory contains .., which is bad in a regular expression.
          # So we use the partial match by dropping '^' from '^nspr/...
          'sources/': [
            ['exclude', 'nspr/pr/src/md/windows/'],
            ['exclude', 'nspr/pr/src/threads/combined/'],
          ],
          'sources!': [
            # Added by Dart.
            'os_linux.S',
            '<(nss_directory)/nspr/pr/src/io/prdir.c',
            '<(nss_directory)/nspr/pr/src/io/prfile.c',
            '<(nss_directory)/nspr/pr/src/io/prio.c',
            '<(nss_directory)/nspr/pr/src/io/prsocket.c',
            # os_Darwin_x86.s and os_Darwin_x86_64.s are included by
            # os_Darwin.s.
            # Added by Dart.
            '<(nss_directory)/nspr/pr/src/md/unix/linux.c',
            '<(nss_directory)/nspr/pr/src/md/unix/os_Darwin_x86.s',
            '<(nss_directory)/nspr/pr/src/md/unix/os_Darwin_x86_64.s',
            # Added by Dart.
            '<(nss_directory)/nspr/pr/src/md/unix/os_Linux_x86.s',
            # Added by Dart.
            '<(nss_directory)/nspr/pr/src/md/unix/os_Linux_x86_64.s',
            '<(nss_directory)/nspr/pr/src/misc/pripcsem.c',
            '<(nss_directory)/nspr/pr/src/threads/prcthr.c',
            '<(nss_directory)/nspr/pr/src/threads/prdump.c',
            '<(nss_directory)/nspr/pr/src/threads/prmon.c',
            '<(nss_directory)/nspr/pr/src/threads/prsem.c',
          ],
        }],
        # Added by Dart.
        ['OS=="linux"', {
          'defines': [
            'HAVE_VISIBILITY_HIDDEN_ATTRIBUTE=1',
            'HAVE_VISIBILITY_PRAGMA=1',
            'XP_UNIX=1',
            '_GNU_SOURCE=1',
            'HAVE_FCNTL_FILE_LOCKING=1',
            'LINUX=1',
            'i386=1',
            'HAVE_LCHOWN=1',
            'HAVE_STRERROR=1',
            'HAVE_DLADDR=1',
            'HAVE_SETPRIORITY=1',
            'HAVE_SYSCALL=1',
            '_REENTRANT=1',
             'FORCE_PR_LOG',
            '_PR_PTHREADS',
            '_NSPR_BUILD_',
          ],
          'sources/': [
            ['exclude', 'nspr/pr/src/md/windows/'],
            ['exclude', 'nspr/pr/src/threads/combined/'],
          ],
          'sources!': [
            '<(nss_directory)/nspr/pr/src/md/unix/darwin.c',
            '<(nss_directory)/nspr/pr/src/md/unix/os_Darwin.s',
            '<(nss_directory)/nspr/pr/src/md/unix/os_Darwin_x86.s',
            '<(nss_directory)/nspr/pr/src/md/unix/os_Darwin_x86_64.s',
            # os_Linux_x86.s and os_Linux_x86_64.s are included by
            # runtime/bin/net/os_Linux.S.
            '<(nss_directory)/nspr/pr/src/md/unix/os_Linux_x86.s',
            '<(nss_directory)/nspr/pr/src/md/unix/os_Linux_x86_64.s',
            '<(nss_directory)/nspr/pr/src/misc/pripcsem.c',
            '<(nss_directory)/nspr/pr/src/threads/prcthr.c',
            '<(nss_directory)/nspr/pr/src/threads/prdump.c',
            '<(nss_directory)/nspr/pr/src/threads/prmon.c',
            '<(nss_directory)/nspr/pr/src/threads/prsem.c',
            '<(nss_directory)/nspr/pr/src/io/prdir.c',
            '<(nss_directory)/nspr/pr/src/io/prfile.c',
            '<(nss_directory)/nspr/pr/src/io/prio.c',
            '<(nss_directory)/nspr/pr/src/io/prsocket.c',
          ],
        }],
        ['OS=="mac"', {
          'link_settings': {
            'libraries': [
              '$(SDKROOT)/System/Library/Frameworks/CoreFoundation.framework',
              '$(SDKROOT)/System/Library/Frameworks/CoreServices.framework',
            ],
          },
        }],
        ['OS=="ios"', {
          'defines!': [
            'HAVE_CRT_EXTERNS_H',
          ],
        }],
        ['OS=="win"', {
          'defines': [
            'XP_PC',
            'WIN32',
            'WIN95',
            '_PR_GLOBAL_THREADS_ONLY',
            '_CRT_SECURE_NO_WARNINGS',
            '_CRT_NONSTDC_NO_WARNINGS',
          ],
          'sources!': [
            # Added by Dart.
            'os_linux.S',
          ],
          # Changed by Dart:
          # nss_directory contains .., which is bad in a regular expression.
          # So we use the partial match by dropping '^' from '^nspr/...
          'sources/': [
            ['exclude', 'nspr/pr/src/md/unix/'],
            ['exclude', 'nspr/pr/src/pthreads/'],
          ],
          # Changed by Dart. We don't use target_arch.
          # 'conditions': [
          #  ['target_arch=="ia32"', {
          #    'defines': [
          #      '_X86_',
          #    ],
          #  }],
          # ],
        }],
        ['component == "static_library"', {
          'defines': [
            'NSPR_STATIC',
          ],
          'direct_dependent_settings': {
            'defines': [
              'NSPR_STATIC',
            ],
          },
        }],
        ['clang==1', {
          'xcode_settings': {
            'WARNING_CFLAGS': [
              # nspr uses a bunch of deprecated functions (NSLinkModule etc) in
              # prlink.c on mac.
              '-Wno-deprecated-declarations',
            ],
          },
        }],
      ],
    },
    {
      'target_name': 'nss_dart',  # Added by Dart (the _dart postfix)
      'product_name': 'crnss',
      'type': '<(component)',
      'toolsets':['host','target'],
      'dependencies': [
        'nss_static_dart',  # Added by Dart (the _dart postfix)
      ],
      'export_dependent_settings': [
        'nss_static_dart',  # Added by Dart (the _dart postfix)
      ],
      'sources': [
        # Ensure at least one object file is produced, so that MSVC does not
        # warn when creating the static/shared library. See the note for
        # the 'nssckbi' target for why the 'nss' target was split as such.
        '<(nss_directory)/nss/lib/nss/nssver.c',
      ],
      'conditions': [
        ['exclude_nss_root_certs==0', {
          'dependencies': [
            'nssckbi_dart',  # Added by Dart (the _dart postfix)
          ],
          'export_dependent_settings': [
            'nssckbi_dart',  # Added by Dart (the _dart postfix)
          ],
        }],
        ['OS == "mac" and component == "shared_library"', {
          'xcode_settings': {
            'OTHER_LDFLAGS': ['-all_load'],
          },
        }],
        ['OS == "win" and component == "shared_library"', {
          'sources': [
            '<(nss_directory)/nss/exports_win.def',
          ],
        }],
      ],
    },
    {
      # This is really more of a pseudo-target to work around the fact that
      # a single static_library target cannot contain two object files of the
      # same name (hash.o / hash.obj). Logically, this is part of the
      # 'nss_static' target. By separating it out, it creates a possible
      # circular dependency between 'nss_static' and 'nssckbi' when
      # 'exclude_nss_root_certs' is not specified, as 'nss_static' depends on
      # the 'builtinsC_GetFunctionList' exported by this target. This is an
      # artifact of how NSS is being statically built, which is not an
      # officially supported configuration - normally, 'nssckbi.dll/so' would
      # depend on libnss3.dll/so, and the higher layer caller would instruct
      # libnss3.dll to dynamically load nssckbi.dll, breaking the circle.
      #
      # TODO(rsleevi): http://crbug.com/128134 - Break the circular dependency
      # without requiring nssckbi to be built as a shared library.
      'target_name': 'nssckbi_dart',  # Added by Dart (the _dart postfix)
      'product_name': 'crnssckbi',
      'type': 'static_library',
      'toolsets':['host','target'],
      # This target is an implementation detail - the public dependencies
      # should be on 'nss'.
      'suppress_wildcard': 1,
      'sources': [
        '<(nss_directory)/nss/lib/ckfw/builtins/anchor.c',
        '<(nss_directory)/nss/lib/ckfw/builtins/bfind.c',
        '<(nss_directory)/nss/lib/ckfw/builtins/binst.c',
        '<(nss_directory)/nss/lib/ckfw/builtins/bobject.c',
        '<(nss_directory)/nss/lib/ckfw/builtins/bsession.c',
        '<(nss_directory)/nss/lib/ckfw/builtins/bslot.c',
        '<(nss_directory)/nss/lib/ckfw/builtins/btoken.c',
        '<(nss_directory)/nss/lib/ckfw/builtins/builtins.h',
        '<(nss_directory)/nss/lib/ckfw/builtins/certdata.c',
        '<(nss_directory)/nss/lib/ckfw/builtins/ckbiver.c',
        '<(nss_directory)/nss/lib/ckfw/builtins/constants.c',
        '<(nss_directory)/nss/lib/ckfw/builtins/nssckbi.h',
        '<(nss_directory)/nss/lib/ckfw/ck.h',
        '<(nss_directory)/nss/lib/ckfw/ckfw.h',
        '<(nss_directory)/nss/lib/ckfw/ckfwm.h',
        '<(nss_directory)/nss/lib/ckfw/ckfwtm.h',
        '<(nss_directory)/nss/lib/ckfw/ckmd.h',
        '<(nss_directory)/nss/lib/ckfw/ckt.h',
        '<(nss_directory)/nss/lib/ckfw/crypto.c',
        '<(nss_directory)/nss/lib/ckfw/find.c',
        '<(nss_directory)/nss/lib/ckfw/hash.c',
        '<(nss_directory)/nss/lib/ckfw/instance.c',
        '<(nss_directory)/nss/lib/ckfw/mechanism.c',
        '<(nss_directory)/nss/lib/ckfw/mutex.c',
        '<(nss_directory)/nss/lib/ckfw/nssck.api',
        '<(nss_directory)/nss/lib/ckfw/nssckepv.h',
        '<(nss_directory)/nss/lib/ckfw/nssckft.h',
        '<(nss_directory)/nss/lib/ckfw/nssckfw.h',
        '<(nss_directory)/nss/lib/ckfw/nssckfwc.h',
        '<(nss_directory)/nss/lib/ckfw/nssckfwt.h',
        '<(nss_directory)/nss/lib/ckfw/nssckg.h',
        '<(nss_directory)/nss/lib/ckfw/nssckmdt.h',
        '<(nss_directory)/nss/lib/ckfw/nssckt.h',
        '<(nss_directory)/nss/lib/ckfw/object.c',
        '<(nss_directory)/nss/lib/ckfw/session.c',
        '<(nss_directory)/nss/lib/ckfw/sessobj.c',
        '<(nss_directory)/nss/lib/ckfw/slot.c',
        '<(nss_directory)/nss/lib/ckfw/token.c',
        '<(nss_directory)/nss/lib/ckfw/wrap.c',
      ],
      'dependencies': [
        'nss_static_dart',  # Added by Dart (the _dart postfix)
      ],
      'export_dependent_settings': [
        'nss_static_dart',  # Added by Dart (the _dart postfix)
      ],
      'include_dirs': [
        '<(nss_directory)/nss/lib/ckfw',
      ],
      'direct_dependent_settings': {
        'include_dirs': [
          '<(nss_directory)/nss/lib/ckfw/builtins',
        ],
      },
    },
    # Removed by Dart: the target nss_static_avx_dart.
    # This is an optimization of AES on 32 bit Windows using new
    # Intel assembly instructions.  Not enabling it on Dart.
    {
      'target_name': 'nss_static_dart',  # Added by Dart (the _dart postfix)
      'type': 'static_library',
      'toolsets':['host','target'],
      # This target is an implementation detail - the public dependencies
      # should be on 'nss'.
      'suppress_wildcard': 1,
      'sources': [
        'os_windows.c',
        '<(nss_directory)/nss/lib/base/arena.c',
        '<(nss_directory)/nss/lib/base/base.h',
        '<(nss_directory)/nss/lib/base/baset.h',
        '<(nss_directory)/nss/lib/base/error.c',
        '<(nss_directory)/nss/lib/base/errorval.c',
        '<(nss_directory)/nss/lib/base/hash.c',
        '<(nss_directory)/nss/lib/base/hashops.c',
        '<(nss_directory)/nss/lib/base/item.c',
        '<(nss_directory)/nss/lib/base/libc.c',
        '<(nss_directory)/nss/lib/base/list.c',
        '<(nss_directory)/nss/lib/base/nssbase.h',
        '<(nss_directory)/nss/lib/base/nssbaset.h',
        '<(nss_directory)/nss/lib/base/nssutf8.c',
        '<(nss_directory)/nss/lib/base/tracker.c',
        '<(nss_directory)/nss/lib/certdb/alg1485.c',
        '<(nss_directory)/nss/lib/certdb/cert.h',
        '<(nss_directory)/nss/lib/certdb/certdb.c',
        '<(nss_directory)/nss/lib/certdb/certdb.h',
        '<(nss_directory)/nss/lib/certdb/certi.h',
        '<(nss_directory)/nss/lib/certdb/certt.h',
        '<(nss_directory)/nss/lib/certdb/certv3.c',
        '<(nss_directory)/nss/lib/certdb/certxutl.c',
        '<(nss_directory)/nss/lib/certdb/certxutl.h',
        '<(nss_directory)/nss/lib/certdb/crl.c',
        '<(nss_directory)/nss/lib/certdb/genname.c',
        '<(nss_directory)/nss/lib/certdb/genname.h',
        '<(nss_directory)/nss/lib/certdb/polcyxtn.c',
        '<(nss_directory)/nss/lib/certdb/secname.c',
        '<(nss_directory)/nss/lib/certdb/stanpcertdb.c',
        '<(nss_directory)/nss/lib/certdb/xauthkid.c',
        '<(nss_directory)/nss/lib/certdb/xbsconst.c',
        '<(nss_directory)/nss/lib/certdb/xconst.c',
        '<(nss_directory)/nss/lib/certdb/xconst.h',
        '<(nss_directory)/nss/lib/certhigh/certhigh.c',
        '<(nss_directory)/nss/lib/certhigh/certhtml.c',
        '<(nss_directory)/nss/lib/certhigh/certreq.c',
        '<(nss_directory)/nss/lib/certhigh/certvfy.c',
        '<(nss_directory)/nss/lib/certhigh/certvfypkix.c',
        '<(nss_directory)/nss/lib/certhigh/certvfypkixprint.c',
        '<(nss_directory)/nss/lib/certhigh/crlv2.c',
        '<(nss_directory)/nss/lib/certhigh/ocsp.c',
        '<(nss_directory)/nss/lib/certhigh/ocsp.h',
        '<(nss_directory)/nss/lib/certhigh/ocspi.h',
        '<(nss_directory)/nss/lib/certhigh/ocspt.h',
        '<(nss_directory)/nss/lib/certhigh/ocspti.h',
        '<(nss_directory)/nss/lib/certhigh/xcrldist.c',
        '<(nss_directory)/nss/lib/cryptohi/cryptohi.h',
        '<(nss_directory)/nss/lib/cryptohi/cryptoht.h',
        '<(nss_directory)/nss/lib/cryptohi/dsautil.c',
        '<(nss_directory)/nss/lib/cryptohi/key.h',
        '<(nss_directory)/nss/lib/cryptohi/keyhi.h',
        '<(nss_directory)/nss/lib/cryptohi/keyi.h',
        '<(nss_directory)/nss/lib/cryptohi/keyt.h',
        '<(nss_directory)/nss/lib/cryptohi/keythi.h',
        '<(nss_directory)/nss/lib/cryptohi/sechash.c',
        '<(nss_directory)/nss/lib/cryptohi/sechash.h',
        '<(nss_directory)/nss/lib/cryptohi/seckey.c',
        '<(nss_directory)/nss/lib/cryptohi/secsign.c',
        '<(nss_directory)/nss/lib/cryptohi/secvfy.c',
        '<(nss_directory)/nss/lib/dev/ckhelper.c',
        '<(nss_directory)/nss/lib/dev/ckhelper.h',
        '<(nss_directory)/nss/lib/dev/dev.h',
        '<(nss_directory)/nss/lib/dev/devm.h',
        '<(nss_directory)/nss/lib/dev/devslot.c',
        '<(nss_directory)/nss/lib/dev/devt.h',
        '<(nss_directory)/nss/lib/dev/devtm.h',
        '<(nss_directory)/nss/lib/dev/devtoken.c',
        '<(nss_directory)/nss/lib/dev/devutil.c',
        '<(nss_directory)/nss/lib/dev/nssdev.h',
        '<(nss_directory)/nss/lib/dev/nssdevt.h',
        '<(nss_directory)/nss/lib/freebl/aeskeywrap.c',
        '<(nss_directory)/nss/lib/freebl/alg2268.c',
        '<(nss_directory)/nss/lib/freebl/alghmac.c',
        '<(nss_directory)/nss/lib/freebl/alghmac.h',
        '<(nss_directory)/nss/lib/freebl/arcfive.c',
        '<(nss_directory)/nss/lib/freebl/arcfour.c',
        '<(nss_directory)/nss/lib/freebl/blapi.h',
        '<(nss_directory)/nss/lib/freebl/blapii.h',
        '<(nss_directory)/nss/lib/freebl/blapit.h',
        '<(nss_directory)/nss/lib/freebl/camellia.c',
        '<(nss_directory)/nss/lib/freebl/camellia.h',
        '<(nss_directory)/nss/lib/freebl/chacha20/chacha20.c',
        '<(nss_directory)/nss/lib/freebl/chacha20/chacha20.h',
        '<(nss_directory)/nss/lib/freebl/chacha20/chacha20_vec.c',
        '<(nss_directory)/nss/lib/freebl/chacha20poly1305.c',
        '<(nss_directory)/nss/lib/freebl/chacha20poly1305.h',
        '<(nss_directory)/nss/lib/freebl/ctr.c',
        '<(nss_directory)/nss/lib/freebl/ctr.h',
        '<(nss_directory)/nss/lib/freebl/cts.c',
        '<(nss_directory)/nss/lib/freebl/cts.h',
        '<(nss_directory)/nss/lib/freebl/des.c',
        '<(nss_directory)/nss/lib/freebl/des.h',
        '<(nss_directory)/nss/lib/freebl/desblapi.c',
        '<(nss_directory)/nss/lib/freebl/dh.c',
        '<(nss_directory)/nss/lib/freebl/drbg.c',
        '<(nss_directory)/nss/lib/freebl/dsa.c',
        '<(nss_directory)/nss/lib/freebl/ec.c',
        '<(nss_directory)/nss/lib/freebl/ec.h',
        '<(nss_directory)/nss/lib/freebl/ecdecode.c',
        '<(nss_directory)/nss/lib/freebl/ecl/ec2.h',
        '<(nss_directory)/nss/lib/freebl/ecl/ecl-curve.h',
        '<(nss_directory)/nss/lib/freebl/ecl/ecl-exp.h',
        '<(nss_directory)/nss/lib/freebl/ecl/ecl-priv.h',
        '<(nss_directory)/nss/lib/freebl/ecl/ecl.c',
        '<(nss_directory)/nss/lib/freebl/ecl/ecl.h',
        '<(nss_directory)/nss/lib/freebl/ecl/ecl_curve.c',
        '<(nss_directory)/nss/lib/freebl/ecl/ecl_gf.c',
        '<(nss_directory)/nss/lib/freebl/ecl/ecl_mult.c',
        '<(nss_directory)/nss/lib/freebl/ecl/ecp.h',
        '<(nss_directory)/nss/lib/freebl/ecl/ecp_256.c',
        '<(nss_directory)/nss/lib/freebl/ecl/ecp_256_32.c',
        '<(nss_directory)/nss/lib/freebl/ecl/ecp_384.c',
        '<(nss_directory)/nss/lib/freebl/ecl/ecp_521.c',
        '<(nss_directory)/nss/lib/freebl/ecl/ecp_aff.c',
        '<(nss_directory)/nss/lib/freebl/ecl/ecp_jac.c',
        '<(nss_directory)/nss/lib/freebl/ecl/ecp_jm.c',
        '<(nss_directory)/nss/lib/freebl/ecl/ecp_mont.c',
        '<(nss_directory)/nss/lib/freebl/ecl/ec_naf.c',
        '<(nss_directory)/nss/lib/freebl/gcm.c',
        '<(nss_directory)/nss/lib/freebl/gcm.h',
        # Changed by Dart: intel-aes assembly language files dropped.
        '<(nss_directory)/nss/lib/freebl/hmacct.c',
        '<(nss_directory)/nss/lib/freebl/hmacct.h',
        '<(nss_directory)/nss/lib/freebl/jpake.c',
        '<(nss_directory)/nss/lib/freebl/md2.c',
        '<(nss_directory)/nss/lib/freebl/md5.c',
        '<(nss_directory)/nss/lib/freebl/mpi/logtab.h',
        '<(nss_directory)/nss/lib/freebl/mpi/mpcpucache.c',
        '<(nss_directory)/nss/lib/freebl/mpi/mpi-config.h',
        '<(nss_directory)/nss/lib/freebl/mpi/mpi-priv.h',
        '<(nss_directory)/nss/lib/freebl/mpi/mpi.c',
        '<(nss_directory)/nss/lib/freebl/mpi/mpi.h',
        '<(nss_directory)/nss/lib/freebl/mpi/mpi_amd64.c',
        '<(nss_directory)/nss/lib/freebl/mpi/mpi_x86_asm.c',
        '<(nss_directory)/nss/lib/freebl/mpi/mplogic.c',
        '<(nss_directory)/nss/lib/freebl/mpi/mplogic.h',
        '<(nss_directory)/nss/lib/freebl/mpi/mpmontg.c',
        '<(nss_directory)/nss/lib/freebl/mpi/mpprime.c',
        '<(nss_directory)/nss/lib/freebl/mpi/mpprime.h',
        '<(nss_directory)/nss/lib/freebl/mpi/mp_gf2m-priv.h',
        '<(nss_directory)/nss/lib/freebl/mpi/mp_gf2m.c',
        '<(nss_directory)/nss/lib/freebl/mpi/mp_gf2m.h',
        '<(nss_directory)/nss/lib/freebl/mpi/primes.c',
        '<(nss_directory)/nss/lib/freebl/nss_build_config_mac.h',
        '<(nss_directory)/nss/lib/freebl/poly1305/poly1305-donna-x64-sse2-incremental-source.c',
        '<(nss_directory)/nss/lib/freebl/poly1305/poly1305.c',
        '<(nss_directory)/nss/lib/freebl/poly1305/poly1305.h',
        '<(nss_directory)/nss/lib/freebl/pqg.c',
        '<(nss_directory)/nss/lib/freebl/pqg.h',
        '<(nss_directory)/nss/lib/freebl/rawhash.c',
        '<(nss_directory)/nss/lib/freebl/rijndael.c',
        '<(nss_directory)/nss/lib/freebl/rijndael.h',
        '<(nss_directory)/nss/lib/freebl/rijndael32.tab',
        '<(nss_directory)/nss/lib/freebl/rsa.c',
        '<(nss_directory)/nss/lib/freebl/rsapkcs.c',
        '<(nss_directory)/nss/lib/freebl/secmpi.h',
        '<(nss_directory)/nss/lib/freebl/secrng.h',
        '<(nss_directory)/nss/lib/freebl/seed.c',
        '<(nss_directory)/nss/lib/freebl/seed.h',
        '<(nss_directory)/nss/lib/freebl/sha256.h',
        '<(nss_directory)/nss/lib/freebl/sha512.c',
        '<(nss_directory)/nss/lib/freebl/sha_fast.c',
        '<(nss_directory)/nss/lib/freebl/sha_fast.h',
        '<(nss_directory)/nss/lib/freebl/shsign.h',
        '<(nss_directory)/nss/lib/freebl/shvfy.c',
        '<(nss_directory)/nss/lib/freebl/sysrand.c',
        '<(nss_directory)/nss/lib/freebl/tlsprfalg.c',
        '<(nss_directory)/nss/lib/freebl/unix_rand.c',
        '<(nss_directory)/nss/lib/freebl/win_rand.c',
        '<(nss_directory)/nss/lib/libpkix/include/pkix.h',
        '<(nss_directory)/nss/lib/libpkix/include/pkix_certsel.h',
        '<(nss_directory)/nss/lib/libpkix/include/pkix_certstore.h',
        '<(nss_directory)/nss/lib/libpkix/include/pkix_checker.h',
        '<(nss_directory)/nss/lib/libpkix/include/pkix_crlsel.h',
        '<(nss_directory)/nss/lib/libpkix/include/pkix_errorstrings.h',
        '<(nss_directory)/nss/lib/libpkix/include/pkix_params.h',
        '<(nss_directory)/nss/lib/libpkix/include/pkix_pl_pki.h',
        '<(nss_directory)/nss/lib/libpkix/include/pkix_pl_system.h',
        '<(nss_directory)/nss/lib/libpkix/include/pkix_results.h',
        '<(nss_directory)/nss/lib/libpkix/include/pkix_revchecker.h',
        '<(nss_directory)/nss/lib/libpkix/include/pkix_sample_modules.h',
        '<(nss_directory)/nss/lib/libpkix/include/pkix_util.h',
        '<(nss_directory)/nss/lib/libpkix/include/pkixt.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/certsel/pkix_certselector.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/certsel/pkix_certselector.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/certsel/pkix_comcertselparams.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/certsel/pkix_comcertselparams.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/checker/pkix_basicconstraintschecker.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/checker/pkix_basicconstraintschecker.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/checker/pkix_certchainchecker.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/checker/pkix_certchainchecker.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/checker/pkix_crlchecker.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/checker/pkix_crlchecker.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/checker/pkix_ekuchecker.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/checker/pkix_ekuchecker.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/checker/pkix_expirationchecker.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/checker/pkix_expirationchecker.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/checker/pkix_namechainingchecker.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/checker/pkix_namechainingchecker.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/checker/pkix_nameconstraintschecker.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/checker/pkix_nameconstraintschecker.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/checker/pkix_ocspchecker.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/checker/pkix_ocspchecker.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/checker/pkix_policychecker.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/checker/pkix_policychecker.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/checker/pkix_revocationchecker.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/checker/pkix_revocationchecker.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/checker/pkix_revocationmethod.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/checker/pkix_revocationmethod.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/checker/pkix_signaturechecker.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/checker/pkix_signaturechecker.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/checker/pkix_targetcertchecker.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/checker/pkix_targetcertchecker.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/crlsel/pkix_comcrlselparams.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/crlsel/pkix_comcrlselparams.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/crlsel/pkix_crlselector.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/crlsel/pkix_crlselector.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/params/pkix_procparams.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/params/pkix_procparams.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/params/pkix_resourcelimits.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/params/pkix_resourcelimits.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/params/pkix_trustanchor.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/params/pkix_trustanchor.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/params/pkix_valparams.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/params/pkix_valparams.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/results/pkix_buildresult.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/results/pkix_buildresult.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/results/pkix_policynode.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/results/pkix_policynode.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/results/pkix_valresult.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/results/pkix_valresult.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/results/pkix_verifynode.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/results/pkix_verifynode.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/store/pkix_store.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/store/pkix_store.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/top/pkix_build.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/top/pkix_build.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/top/pkix_lifecycle.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/top/pkix_lifecycle.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/top/pkix_validate.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/top/pkix_validate.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/util/pkix_error.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/util/pkix_error.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/util/pkix_errpaths.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/util/pkix_list.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/util/pkix_list.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/util/pkix_logger.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/util/pkix_logger.h',
        '<(nss_directory)/nss/lib/libpkix/pkix/util/pkix_tools.c',
        '<(nss_directory)/nss/lib/libpkix/pkix/util/pkix_tools.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_aiamgr.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_aiamgr.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_colcertstore.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_colcertstore.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_httpcertstore.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_httpcertstore.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_httpdefaultclient.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_httpdefaultclient.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_ldapcertstore.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_ldapcertstore.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_ldapdefaultclient.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_ldapdefaultclient.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_ldaprequest.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_ldaprequest.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_ldapresponse.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_ldapresponse.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_ldapt.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_ldaptemplates.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_nsscontext.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_nsscontext.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_pk11certstore.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_pk11certstore.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_socket.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_socket.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_basicconstraints.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_basicconstraints.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_cert.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_cert.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_certpolicyinfo.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_certpolicyinfo.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_certpolicymap.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_certpolicymap.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_certpolicyqualifier.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_certpolicyqualifier.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_crl.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_crl.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_crldp.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_crldp.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_crlentry.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_crlentry.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_date.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_date.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_generalname.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_generalname.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_infoaccess.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_infoaccess.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_nameconstraints.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_nameconstraints.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_ocspcertid.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_ocspcertid.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_ocsprequest.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_ocsprequest.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_ocspresponse.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_ocspresponse.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_publickey.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_publickey.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_x500name.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki/pkix_pl_x500name.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/system/pkix_pl_bigint.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/system/pkix_pl_bigint.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/system/pkix_pl_bytearray.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/system/pkix_pl_bytearray.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/system/pkix_pl_common.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/system/pkix_pl_common.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/system/pkix_pl_error.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/system/pkix_pl_hashtable.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/system/pkix_pl_hashtable.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/system/pkix_pl_lifecycle.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/system/pkix_pl_lifecycle.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/system/pkix_pl_mem.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/system/pkix_pl_mem.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/system/pkix_pl_monitorlock.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/system/pkix_pl_monitorlock.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/system/pkix_pl_mutex.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/system/pkix_pl_mutex.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/system/pkix_pl_object.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/system/pkix_pl_object.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/system/pkix_pl_oid.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/system/pkix_pl_oid.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/system/pkix_pl_primhash.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/system/pkix_pl_primhash.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/system/pkix_pl_rwlock.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/system/pkix_pl_rwlock.h',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/system/pkix_pl_string.c',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/system/pkix_pl_string.h',
        '<(nss_directory)/nss/lib/nss/nss.h',
        '<(nss_directory)/nss/lib/nss/nssinit.c',
        '<(nss_directory)/nss/lib/nss/nssrenam.h',
        '<(nss_directory)/nss/lib/nss/utilwrap.c',
        '<(nss_directory)/nss/lib/pk11wrap/debug_module.c',
        '<(nss_directory)/nss/lib/pk11wrap/dev3hack.c',
        '<(nss_directory)/nss/lib/pk11wrap/dev3hack.h',
        '<(nss_directory)/nss/lib/pk11wrap/pk11akey.c',
        '<(nss_directory)/nss/lib/pk11wrap/pk11auth.c',
        '<(nss_directory)/nss/lib/pk11wrap/pk11cert.c',
        '<(nss_directory)/nss/lib/pk11wrap/pk11cxt.c',
        '<(nss_directory)/nss/lib/pk11wrap/pk11err.c',
        '<(nss_directory)/nss/lib/pk11wrap/pk11func.h',
        '<(nss_directory)/nss/lib/pk11wrap/pk11kea.c',
        '<(nss_directory)/nss/lib/pk11wrap/pk11list.c',
        '<(nss_directory)/nss/lib/pk11wrap/pk11load.c',
        '<(nss_directory)/nss/lib/pk11wrap/pk11mech.c',
        '<(nss_directory)/nss/lib/pk11wrap/pk11merge.c',
        '<(nss_directory)/nss/lib/pk11wrap/pk11nobj.c',
        '<(nss_directory)/nss/lib/pk11wrap/pk11obj.c',
        '<(nss_directory)/nss/lib/pk11wrap/pk11pars.c',
        '<(nss_directory)/nss/lib/pk11wrap/pk11pbe.c',
        '<(nss_directory)/nss/lib/pk11wrap/pk11pk12.c',
        '<(nss_directory)/nss/lib/pk11wrap/pk11pqg.c',
        '<(nss_directory)/nss/lib/pk11wrap/pk11pqg.h',
        '<(nss_directory)/nss/lib/pk11wrap/pk11priv.h',
        '<(nss_directory)/nss/lib/pk11wrap/pk11pub.h',
        '<(nss_directory)/nss/lib/pk11wrap/pk11sdr.c',
        '<(nss_directory)/nss/lib/pk11wrap/pk11sdr.h',
        '<(nss_directory)/nss/lib/pk11wrap/pk11skey.c',
        '<(nss_directory)/nss/lib/pk11wrap/pk11slot.c',
        '<(nss_directory)/nss/lib/pk11wrap/pk11util.c',
        '<(nss_directory)/nss/lib/pk11wrap/secmod.h',
        '<(nss_directory)/nss/lib/pk11wrap/secmodi.h',
        '<(nss_directory)/nss/lib/pk11wrap/secmodt.h',
        '<(nss_directory)/nss/lib/pk11wrap/secmodti.h',
        '<(nss_directory)/nss/lib/pk11wrap/secpkcs5.h',
        '<(nss_directory)/nss/lib/pkcs7/certread.c',
        '<(nss_directory)/nss/lib/pkcs7/p7common.c',
        '<(nss_directory)/nss/lib/pkcs7/p7create.c',
        '<(nss_directory)/nss/lib/pkcs7/p7decode.c',
        '<(nss_directory)/nss/lib/pkcs7/p7encode.c',
        '<(nss_directory)/nss/lib/pkcs7/p7local.c',
        '<(nss_directory)/nss/lib/pkcs7/p7local.h',
        '<(nss_directory)/nss/lib/pkcs7/pkcs7t.h',
        '<(nss_directory)/nss/lib/pkcs7/secmime.c',
        '<(nss_directory)/nss/lib/pkcs7/secmime.h',
        '<(nss_directory)/nss/lib/pkcs7/secpkcs7.h',
        '<(nss_directory)/nss/lib/pki/asymmkey.c',
        '<(nss_directory)/nss/lib/pki/certdecode.c',
        '<(nss_directory)/nss/lib/pki/certificate.c',
        '<(nss_directory)/nss/lib/pki/cryptocontext.c',
        '<(nss_directory)/nss/lib/pki/nsspki.h',
        '<(nss_directory)/nss/lib/pki/nsspkit.h',
        '<(nss_directory)/nss/lib/pki/pki.h',
        '<(nss_directory)/nss/lib/pki/pki3hack.c',
        '<(nss_directory)/nss/lib/pki/pki3hack.h',
        '<(nss_directory)/nss/lib/pki/pkibase.c',
        '<(nss_directory)/nss/lib/pki/pkim.h',
        '<(nss_directory)/nss/lib/pki/pkistore.c',
        '<(nss_directory)/nss/lib/pki/pkistore.h',
        '<(nss_directory)/nss/lib/pki/pkit.h',
        '<(nss_directory)/nss/lib/pki/pkitm.h',
        '<(nss_directory)/nss/lib/pki/symmkey.c',
        '<(nss_directory)/nss/lib/pki/tdcache.c',
        '<(nss_directory)/nss/lib/pki/trustdomain.c',
        '<(nss_directory)/nss/lib/smime/cms.h',
        '<(nss_directory)/nss/lib/smime/cmslocal.h',
        '<(nss_directory)/nss/lib/smime/cmsreclist.h',
        '<(nss_directory)/nss/lib/smime/cmst.h',
        '<(nss_directory)/nss/lib/smime/smime.h',
        '<(nss_directory)/nss/lib/softoken/fipsaudt.c',
        '<(nss_directory)/nss/lib/softoken/fipstest.c',
        '<(nss_directory)/nss/lib/softoken/fipstokn.c',
        '<(nss_directory)/nss/lib/softoken/jpakesftk.c',
        '<(nss_directory)/nss/lib/softoken/lgglue.c',
        '<(nss_directory)/nss/lib/softoken/lgglue.h',
        '<(nss_directory)/nss/lib/softoken/lowkey.c',
        '<(nss_directory)/nss/lib/softoken/lowkeyi.h',
        '<(nss_directory)/nss/lib/softoken/lowkeyti.h',
        '<(nss_directory)/nss/lib/softoken/lowpbe.c',
        '<(nss_directory)/nss/lib/softoken/lowpbe.h',
        '<(nss_directory)/nss/lib/softoken/padbuf.c',
        '<(nss_directory)/nss/lib/softoken/pkcs11.c',
        '<(nss_directory)/nss/lib/softoken/pkcs11c.c',
        '<(nss_directory)/nss/lib/softoken/pkcs11i.h',
        '<(nss_directory)/nss/lib/softoken/pkcs11ni.h',
        '<(nss_directory)/nss/lib/softoken/pkcs11u.c',
        '<(nss_directory)/nss/lib/softoken/sdb.c',
        '<(nss_directory)/nss/lib/softoken/sdb.h',
        '<(nss_directory)/nss/lib/softoken/sftkdb.c',
        '<(nss_directory)/nss/lib/softoken/sftkdb.h',
        '<(nss_directory)/nss/lib/softoken/sftkdbt.h',
        '<(nss_directory)/nss/lib/softoken/sftkdbti.h',
        '<(nss_directory)/nss/lib/softoken/sftkhmac.c',
        '<(nss_directory)/nss/lib/softoken/sftkpars.c',
        '<(nss_directory)/nss/lib/softoken/sftkpars.h',
        '<(nss_directory)/nss/lib/softoken/sftkpwd.c',
        '<(nss_directory)/nss/lib/softoken/softkver.c',
        '<(nss_directory)/nss/lib/softoken/softkver.h',
        '<(nss_directory)/nss/lib/softoken/softoken.h',
        '<(nss_directory)/nss/lib/softoken/softoknt.h',
        '<(nss_directory)/nss/lib/softoken/tlsprf.c',
        '<(nss_directory)/nss/lib/ssl/sslerr.h',
        '<(nss_directory)/nss/lib/util/SECerrs.h',
        '<(nss_directory)/nss/lib/util/base64.h',
        '<(nss_directory)/nss/lib/util/ciferfam.h',
        '<(nss_directory)/nss/lib/util/derdec.c',
        '<(nss_directory)/nss/lib/util/derenc.c',
        '<(nss_directory)/nss/lib/util/dersubr.c',
        '<(nss_directory)/nss/lib/util/dertime.c',
        '<(nss_directory)/nss/lib/util/errstrs.c',
        '<(nss_directory)/nss/lib/util/hasht.h',
        '<(nss_directory)/nss/lib/util/nssb64.h',
        '<(nss_directory)/nss/lib/util/nssb64d.c',
        '<(nss_directory)/nss/lib/util/nssb64e.c',
        '<(nss_directory)/nss/lib/util/nssb64t.h',
        '<(nss_directory)/nss/lib/util/nssilckt.h',
        '<(nss_directory)/nss/lib/util/nssilock.c',
        '<(nss_directory)/nss/lib/util/nssilock.h',
        '<(nss_directory)/nss/lib/util/nsslocks.h',
        '<(nss_directory)/nss/lib/util/nssrwlk.c',
        '<(nss_directory)/nss/lib/util/nssrwlk.h',
        '<(nss_directory)/nss/lib/util/nssrwlkt.h',
        '<(nss_directory)/nss/lib/util/nssutil.h',
        '<(nss_directory)/nss/lib/util/oidstring.c',
        '<(nss_directory)/nss/lib/util/pkcs11.h',
        '<(nss_directory)/nss/lib/util/pkcs11f.h',
        '<(nss_directory)/nss/lib/util/pkcs11n.h',
        '<(nss_directory)/nss/lib/util/pkcs11p.h',
        '<(nss_directory)/nss/lib/util/pkcs11t.h',
        '<(nss_directory)/nss/lib/util/pkcs11u.h',
        '<(nss_directory)/nss/lib/util/pkcs1sig.c',
        '<(nss_directory)/nss/lib/util/pkcs1sig.h',
        '<(nss_directory)/nss/lib/util/portreg.c',
        '<(nss_directory)/nss/lib/util/portreg.h',
        '<(nss_directory)/nss/lib/util/quickder.c',
        '<(nss_directory)/nss/lib/util/secalgid.c',
        '<(nss_directory)/nss/lib/util/secasn1.h',
        '<(nss_directory)/nss/lib/util/secasn1d.c',
        '<(nss_directory)/nss/lib/util/secasn1e.c',
        '<(nss_directory)/nss/lib/util/secasn1t.h',
        '<(nss_directory)/nss/lib/util/secasn1u.c',
        '<(nss_directory)/nss/lib/util/seccomon.h',
        '<(nss_directory)/nss/lib/util/secder.h',
        '<(nss_directory)/nss/lib/util/secdert.h',
        '<(nss_directory)/nss/lib/util/secdig.c',
        '<(nss_directory)/nss/lib/util/secdig.h',
        '<(nss_directory)/nss/lib/util/secdigt.h',
        '<(nss_directory)/nss/lib/util/secerr.h',
        '<(nss_directory)/nss/lib/util/secitem.c',
        '<(nss_directory)/nss/lib/util/secitem.h',
        '<(nss_directory)/nss/lib/util/secoid.c',
        '<(nss_directory)/nss/lib/util/secoid.h',
        '<(nss_directory)/nss/lib/util/secoidt.h',
        '<(nss_directory)/nss/lib/util/secport.c',
        '<(nss_directory)/nss/lib/util/secport.h',
        '<(nss_directory)/nss/lib/util/sectime.c',
        '<(nss_directory)/nss/lib/util/templates.c',
        '<(nss_directory)/nss/lib/util/utf8.c',
        '<(nss_directory)/nss/lib/util/utilmod.c',
        '<(nss_directory)/nss/lib/util/utilmodt.h',
        '<(nss_directory)/nss/lib/util/utilpars.c',
        '<(nss_directory)/nss/lib/util/utilpars.h',
        '<(nss_directory)/nss/lib/util/utilparst.h',
        '<(nss_directory)/nss/lib/util/utilrename.h',
      ],
      'sources!': [
        # mpi_arm.c is included by mpi_arm_mac.c.
        # NOTE: mpi_arm.c can be used directly on Linux. mpi_arm.c will need
        # to be excluded conditionally if we start to build NSS on Linux.
        '<(nss_directory)/nss/lib/freebl/mpi/mpi_arm.c',
        # primes.c is included by mpprime.c.
        '<(nss_directory)/nss/lib/freebl/mpi/primes.c',
        # unix_rand.c and win_rand.c are included by sysrand.c.
        '<(nss_directory)/nss/lib/freebl/unix_rand.c',
        '<(nss_directory)/nss/lib/freebl/win_rand.c',
        # debug_module.c is included by pk11load.c.
        '<(nss_directory)/nss/lib/pk11wrap/debug_module.c',
      ],
      'dependencies': [
        'nspr_dart',  # Added by Dart (the _dart postfix)
        # Removed by Dart: nss_static_avx target dependency.
        'sqlite.gyp:sqlite_dart',  # Changed by Dart prefix ../sqllite removed _dart postfix added.
      ],
      'export_dependent_settings': [
        'nspr_dart',  # Added by Dart (the _dart postfix)
      ],
      'defines': [
        'MP_API_COMPATIBLE',
        'NSS_DISABLE_DBM',
        'NSS_STATIC',
        'NSS_USE_STATIC_LIBS',
        'RIJNDAEL_INCLUDE_TABLES',
        'SHLIB_VERSION=\"3\"',
        'SOFTOKEN_SHLIB_VERSION=\"3\"',
        'USE_UTIL_DIRECTLY',
      ],
      'include_dirs': [
        '<(nss_directory)/nss/lib/base',
        '<(nss_directory)/nss/lib/certdb',
        '<(nss_directory)/nss/lib/certhigh',
        '<(nss_directory)/nss/lib/cryptohi',
        '<(nss_directory)/nss/lib/dev',
        '<(nss_directory)/nss/lib/freebl',
        '<(nss_directory)/nss/lib/freebl/ecl',
        '<(nss_directory)/nss/lib/freebl/mpi',
        '<(nss_directory)/nss/lib/libpkix/include',
        '<(nss_directory)/nss/lib/libpkix/pkix/certsel',
        '<(nss_directory)/nss/lib/libpkix/pkix/checker',
        '<(nss_directory)/nss/lib/libpkix/pkix/crlsel',
        '<(nss_directory)/nss/lib/libpkix/pkix/params',
        '<(nss_directory)/nss/lib/libpkix/pkix/results',
        '<(nss_directory)/nss/lib/libpkix/pkix/store',
        '<(nss_directory)/nss/lib/libpkix/pkix/top',
        '<(nss_directory)/nss/lib/libpkix/pkix/util',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/pki',
        '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/system',
        '<(nss_directory)/nss/lib/nss',
        '<(nss_directory)/nss/lib/pk11wrap',
        '<(nss_directory)/nss/lib/pkcs7',
        '<(nss_directory)/nss/lib/pki',
        '<(nss_directory)/nss/lib/smime',
        '<(nss_directory)/nss/lib/softoken',
        '<(nss_directory)/nss/lib/ssl',
        '<(nss_directory)/nss/lib/util',
      ],
      'direct_dependent_settings': {
        'defines': [
          'NSS_STATIC',
          'NSS_USE_STATIC_LIBS',
          'USE_UTIL_DIRECTLY',
        ],
        'include_dirs': [
          '<(nss_directory)/nspr/pr/include',
          '<(nss_directory)/nspr/lib/ds',
          '<(nss_directory)/nspr/lib/libc/include',
          '<(nss_directory)/nss/lib/base',
          '<(nss_directory)/nss/lib/certdb',
          '<(nss_directory)/nss/lib/certhigh',
          '<(nss_directory)/nss/lib/cryptohi',
          '<(nss_directory)/nss/lib/dev',
          '<(nss_directory)/nss/lib/freebl',
          '<(nss_directory)/nss/lib/freebl/ecl',
          '<(nss_directory)/nss/lib/nss',
          '<(nss_directory)/nss/lib/pk11wrap',
          '<(nss_directory)/nss/lib/pkcs7',
          '<(nss_directory)/nss/lib/pki',
          '<(nss_directory)/nss/lib/smime',
          '<(nss_directory)/nss/lib/softoken',
          '<(nss_directory)/nss/lib/util',
        ],
      },
      'msvs_disabled_warnings': [4018, 4101, 4267, ],
      'variables': {
        'clang_warning_flags': [
          # nss doesn't explicitly cast between different enum types.
          '-Wno-conversion',
          # nss passes "const char*" through "void*".
          '-Wno-incompatible-pointer-types',
          # nss prefers `a && b || c` over `(a && b) || c`.
          '-Wno-logical-op-parentheses',
          # nss doesn't use exhaustive switches on enums
          '-Wno-switch',
          # nss has some `unsigned < 0` checks.
          '-Wno-tautological-compare',
        ],
      },
      'conditions': [
        ['exclude_nss_root_certs==1', {
          'defines': [
            'NSS_DISABLE_ROOT_CERTS',
          ],
        }],
        ['exclude_nss_libpkix==1', {
          'defines': [
            'NSS_DISABLE_LIBPKIX',
          ],
          # Changed by Dart:
          # nss_directory contains .., which is bad in a regular expression.
          # So we use the partial match by dropping '^' from '^nss/...
          'sources/': [
            ['exclude', 'nss/lib/libpkix/'],
          ],
          'sources!': [
            '<(nss_directory)/nss/lib/certhigh/certvfypkix.c',
            '<(nss_directory)/nss/lib/certhigh/certvfypkixprint.c',
          ],
          # Changed by Dart:
          # nss_directory contains .., which is bad in a regular expression.
          # So we use the partial match by dropping '^' from '^nss/...
          'include_dirs/': [
            ['exclude', 'nss/lib/libpkix/'],
          ],
        }, { # else: exclude_nss_libpkix==0
          # Disable the LDAP code in libpkix.
          'defines': [
            'NSS_PKIX_NO_LDAP',
          ],
          'sources!': [
            '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_ldapcertstore.c',
            '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_ldapcertstore.h',
            '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_ldapdefaultclient.c',
            '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_ldapdefaultclient.h',
            '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_ldaprequest.c',
            '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_ldaprequest.h',
            '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_ldapresponse.c',
            '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_ldapresponse.h',
            '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_ldapt.h',
            '<(nss_directory)/nss/lib/libpkix/pkix_pl_nss/module/pkix_pl_ldaptemplates.c',
          ],
        }],
        ['target_arch=="ia32"', {
          'sources!': [
            '<(nss_directory)/nss/lib/freebl/mpi/mpi_amd64.c',
          ],
        }],
        # Added by Dart.
        ['OS=="linux"', {
          'defines': [
            'XP_UNIX',
            'HAVE_STRERROR',
            'SHLIB_SUFFIX=\"so\"',
            'SHLIB_PREFIX=\"lib\"',
            'SHLIB_VERSION=\"3\"',
            'SOFTOKEN_SHLIB_VERSION=\"3\"',
            'SOFTOKEN_LIB_NAME=\"libsoftokn3.so\"',
          ],
          'sources!': [
            '<(nss_directory)/nss/lib/freebl/mpi/mpi_amd64.c',
            '<(nss_directory)/nss/lib/freebl/mpi/mpi_x86_asm.c',
          ],
        }],
        ['target_arch=="x64" and OS!="win"', {
          'sources!': [
            '<(nss_directory)/nss/lib/freebl/chacha20/chacha20.c',
            '<(nss_directory)/nss/lib/freebl/poly1305/poly1305.c',
            ],
        }, { # else: target_arch!="x64" or OS=="win"
          'sources!': [
            '<(nss_directory)/nss/lib/freebl/chacha20/chacha20_vec.c',
            '<(nss_directory)/nss/lib/freebl/poly1305/poly1305-donna-x64-sse2-incremental-source.c',
            ],
        }],
        ['OS=="mac" or OS=="ios"', {
          'defines': [
            'XP_UNIX',
            'DARWIN',
            'HAVE_STRERROR',
            'HAVE_BSD_FLOCK',
            'SHLIB_SUFFIX=\"dylib\"',
            'SHLIB_PREFIX=\"lib\"',
            'SOFTOKEN_LIB_NAME=\"libsoftokn3.dylib\"',
          ],
          'sources!': [
            '<(nss_directory)/nss/lib/freebl/mpi/mpi_amd64.c',
            '<(nss_directory)/nss/lib/freebl/mpi/mpi_x86_asm.c',
          ],
          'variables': {
            'forced_include_file': 'nss_build_config_mac.h',
          },
          'xcode_settings': {
            'conditions': [
              ['component == "shared_library"', {
                'GCC_SYMBOLS_PRIVATE_EXTERN': 'NO',  # no -fvisibility=hidden
              }],
            ],
            # Define processor architecture specific macros in
            # <(forced_include_file).
            'OTHER_CFLAGS': [
              '-include', '<(forced_include_file)',
            ],
          },
        }, { # else: OS!="mac" and OS!="ios"
          'sources!': [
            '<(nss_directory)/nss/lib/freebl/mpi/mpi_arm_mac.c',
          ],
        }],
        ['OS=="win"', {
          'defines': [
            'SHLIB_SUFFIX=\"dll\"',
            'SHLIB_PREFIX=\"\"',
            'SOFTOKEN_LIB_NAME=\"softokn3.dll\"',
            'XP_PC',
            'WIN32',
            'WIN95',
            '_WINDOWS',
          ],
          'direct_dependent_settings': {
            'defines': [
              '_WINDOWS',
            ],
          },
          'sources!': [
            '<(nss_directory)/nss/lib/freebl/mpi/mpi_amd64.c',
            # If needed it will be included by os_windows.c.
            '<(nss_directory)/nss/lib/freebl/mpi/mpi_x86_asm.c',
          ],
          # Changed by Dart. We don't use target_arch. This was moved into
          # configurations instead.
          # 'conditions': [
          #   ['target_arch=="ia32"', {
          #     'defines': [
          #       'NSS_X86_OR_X64',
          #       'NSS_X86',
          #       '_X86_',
          #       'MP_ASSEMBLY_MULTIPLY',
          #       'MP_ASSEMBLY_SQUARE',
          #       'MP_ASSEMBLY_DIV_2DX1D',
          #       'MP_USE_UINT_DIGIT',
          #       'MP_NO_MP_WORD',
          # Changed by Dart: 'USE_HW_AES' and 'INTEL_GCM' are not enabled.
          #       'USE_HW_AES',
          #       'INTEL_GCM',
          #     ],
          #   }],
          #   'msvs_settings': {
          #     'MASM': {
          #       'UseSafeExceptionHandlers': 'true',
          #     },
          #   },
          #   ['target_arch=="x64"', {
          #     'defines': [
          #       'NSS_USE_64',
          #       'NSS_X86_OR_X64',
          #       'NSS_X64',
          #       '_AMD64_',
          #       'MP_CHAR_STORE_SLOW',
          #       'MP_IS_LITTLE_ENDIAN',
          #       'WIN64',
          #     ],
          #     'sources!': [
          #       '<(nss_directory)/nss/lib/freebl/mpi/mpi_amd64.c',
          #       '<(nss_directory)/nss/lib/freebl/mpi/mpi_x86_asm.c',
          #     ],
          #    }],
          # ],
        }, { # else: OS!="win"
          'sources!': [
            'os_windows.c',
            # mpi_x86_asm.c contains MSVC inline assembly code.
            '<(nss_directory)/nss/lib/freebl/mpi/mpi_x86_asm.c',
          ],
        }],
      ],
    },
  ],
  }]],
}
