// Copyright (c) 2014, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

#ifndef PLATFORM_MEMORY_SANITIZER_H_
#define PLATFORM_MEMORY_SANITIZER_H_

#include "platform/globals.h"

// Allow the use of Msan (MemorySanitizer). This is needed as Msan needs to be
// told about areas that are initialized by generated code.
#if defined(__has_feature)
#if __has_feature(memory_sanitizer)
extern "C" void __msan_unpoison(void *, size_t);
#define MSAN_UNPOISON(ptr, len) __msan_unpoison(ptr, len)
#else  // __has_feature(memory_sanitizer)
#define MSAN_UNPOISON(ptr, len) do {} while (false && (ptr) == 0 && (len) == 0)
#endif  // __has_feature(memory_sanitizer)
#else  // defined(__has_feature)
#define MSAN_UNPOISON(ptr, len) do {} while (false && (ptr) == 0 && (len) == 0)
#endif  // defined(__has_feature)

#endif  // PLATFORM_MEMORY_SANITIZER_H_
