/*
 * Copyright (c) 2011, the Dart project authors.  Please see the AUTHORS file
 * for details. All rights reserved. Use of this source code is governed by a
 * BSD-style license that can be found in the LICENSE file.
 */
/**
 * @assertion The for statement supports iteration.
 * forStatement:
 *   for '(' forLoopParts ')' statement
 * ;
 * forLoopParts:
 *   forInitializerStatement expression? ';' expressionList? |
 *   declaredIdentifier in expression |
 *   identifier in expression
 * ;
 * forInitializerStatement:
 *   initializedVariableDeclaration ';' |
 *   expression? ';'
 * ;
 * @description Checks that it is a compile-time error when the loop variable
 * in a 'id in expression' is not a simple variable.
 * @compile-error
 * @author kaigorodov
 * @reviewer iefremov
 */

class C {
  int i;
}

main() {
  try {
    C c=new C();
    for (c.i in new List(100)) break;
  } catch(x){}
}
