/*
 * Copyright (c) 2011, the Dart project authors.  Please see the AUTHORS file
 * for details. All rights reserved. Use of this source code is governed by a
 * BSD-style license that can be found in the LICENSE file.
 */
/**
 * @assertion It is a static type warning if the type of e may not be assigned
 * to the declared return type of the immediately enclosing function.
 * @description Checks that a static type warning occurs if the type of e may 
 * not be assigned to the declared return type of the immediately enclosing function.
 * @static-warning
 * @author vasya
 * @reviewer rodionov
 * @reviewer iefremov
 */
import "../../Utils/dynamic_check.dart";

int foo() {
  return "0";  /// static type warning
}

main() {
  checkTypeError(() => foo());
}
