/*
 * Copyright (c) 2011, the Dart project authors.  Please see the AUTHORS file
 * for details. All rights reserved. Use of this source code is governed by a
 * BSD-style license that can be found in the LICENSE file.
 */
/**
 * @assertion An import specifies a library to be used in the scope of another library.
 * libraryImport:
 *   metadata import uri (as identifier)? combinator* `;'
 * ;
 * combinator:
 *   show identifierList |
 *   hide identifierList
 * ;
 * identifierList:
 *   identifier (, identifier)*
 * ;
 * @description Checks that it is a compile-time error if the parts of an import directive are specified
 * in the wrong order.
 * @compile-error
 * @author rodionov
 * @reviewer kaigorodov
 */

import show foo hide someVar "1_Imports_lib.dart" as prfx;

main() {
  try {
    someVar = 0;
  } catch(e) {}
}
