/*
 * Copyright (c) 2011, the Dart project authors.  Please see the AUTHORS file
 * for details. All rights reserved. Use of this source code is governed by a
 * BSD-style license that can be found in the LICENSE file.
 */
/**
 * @assertion An import specifies a library to be used in the scope of another library.
 * libraryImport:
 *   metadata import uri (as identifier)? combinator* `;'
 * ;
 * combinator:
 *   show identifierList |
 *   hide identifierList
 * ;
 * identifierList:
 *   identifier (, identifier)*
 * ;
 * @description Checks that it is not an error if the arguments of show/hide
 * combinators include identifiers named 'hide' and 'show' and that filtering
 * of the imported names is done correctly
 * @static-warning
 * @author rodionov
 * @reviewer kaigorodov
 */
import "../../Utils/expect.dart";

import "1_Imports_lib.dart" show hide hide show;

main() {
  Expect.equals(hide, "hide");

  try {
    Expect.equals(show, "show"); /// static type warning cannot resolve
    Expect.fail("NoSuchMethodError expected");
  } on NoSuchMethodError catch(ok) {}

  try {
    var x = foo; /// static type warning cannot resolve
    Expect.fail("NoSuchMethodError expected");
  } on NoSuchMethodError catch(ok) {}
}
