/*
 * Copyright (c) 2014, the Dart project authors.  Please see the AUTHORS file
 * for details. All rights reserved. Use of this source code is governed by a
 * BSD-style license that can be found in the LICENSE file.
 */
/**
 * @description Test to make sure background-position is parsed correctly.
 */
import "dart:html";
import "../../testcommon.dart";
import "../../../Utils/async_utils.dart";
import "pwd.dart";

main() {
  var testContainer = document.createElement("div");
  document.body.append(testContainer);

  testContainer.innerHtml = '<div style="width:500px;height:500px"><div id="test">hello</div></div>';

  var e = document.getElementById('test');
  var style = e.style;
  var computedStyle = e.getComputedStyle();

  style.backgroundImage = "url($root/resources/diamond.png)";
  style.backgroundRepeat = "no-repeat";

  debug("background-position with one value");
  // Initial test.
  shouldBe(computedStyle.backgroundPosition, '0% 0%');

  style.backgroundPosition = "70%";
  // Second value is assuming to be 'center'
  shouldBe(style.backgroundPosition, '70% 50%');
  shouldBe(computedStyle.backgroundPosition, '70% 50%');

  style.backgroundPosition = "84px";
  shouldBe(style.backgroundPosition, '84px 50%');
  shouldBe(computedStyle.backgroundPosition, '84px 50%');

  style.backgroundPosition = "left";
  shouldBe(style.backgroundPosition, '0% 50%');
  shouldBe(computedStyle.backgroundPosition, '0% 50%');

  style.backgroundPosition = "right";
  shouldBe(style.backgroundPosition, '100% 50%');
  shouldBe(computedStyle.backgroundPosition, '100% 50%');

  style.backgroundPosition = "bottom";
  shouldBe(style.backgroundPosition, '50% 100%');
  shouldBe(computedStyle.backgroundPosition, '50% 100%');

  style.backgroundPosition = "top";
  shouldBe(style.backgroundPosition, '50% 0%');
  shouldBe(computedStyle.backgroundPosition, '50% 0%');

  style.backgroundPosition = "center";
  shouldBe(style.backgroundPosition, '50% 50%');
  shouldBe(computedStyle.backgroundPosition, '50% 50%');

  debug("background-position with two values");
  style.backgroundPosition = "left bottom";
  shouldBe(style.backgroundPosition, '0% 100%');
  shouldBe(computedStyle.backgroundPosition, '0% 100%');

  style.backgroundPosition = "bottom left";
  shouldBe(style.backgroundPosition, '0% 100%');
  shouldBe(computedStyle.backgroundPosition, '0% 100%');

  style.backgroundPosition = "100% bottom";
  shouldBe(style.backgroundPosition, '100% 100%');
  shouldBe(computedStyle.backgroundPosition, '100% 100%');

  style.backgroundPosition = "100% top";
  shouldBe(style.backgroundPosition, '100% 0%');
  shouldBe(computedStyle.backgroundPosition, '100% 0%');

  style.backgroundPosition = "54px bottom";
  shouldBe(style.backgroundPosition, '54px 100%');
  shouldBe(computedStyle.backgroundPosition, '54px 100%');

  style.backgroundPosition = "center center";
  shouldBe(style.backgroundPosition, '50% 50%');
  shouldBe(computedStyle.backgroundPosition, '50% 50%');

  style.backgroundPosition = "5% bottom";
  shouldBe(style.backgroundPosition, '5% 100%');
  shouldBe(computedStyle.backgroundPosition, '5% 100%');

  style.backgroundPosition = "30pt -20px";
  shouldBe(style.backgroundPosition, '30pt -20px');
  shouldBe(computedStyle.backgroundPosition, '40px -20px');

  style.backgroundPosition = "right center";
  shouldBe(style.backgroundPosition, '100% 50%');
  shouldBe(computedStyle.backgroundPosition, '100% 50%');

  style.backgroundPosition = "100% 0";
  shouldBe(style.backgroundPosition, '100% 0px');
  shouldBe(computedStyle.backgroundPosition, '100% 0px');

  style.backgroundPosition = "center right";
  shouldBe(style.backgroundPosition, '100% 50%');
  shouldBe(computedStyle.backgroundPosition, '100% 50%');

  style.backgroundPosition = "center 50%";
  shouldBe(style.backgroundPosition, '50% 50%');
  shouldBe(computedStyle.backgroundPosition, '50% 50%');

  style.backgroundPosition = "center left";
  shouldBe(style.backgroundPosition, '0% 50%');
  shouldBe(computedStyle.backgroundPosition, '0% 50%');

  style.backgroundPosition = "-20% center";
  shouldBe(style.backgroundPosition, '-20% 50%');
  shouldBe(computedStyle.backgroundPosition, '-20% 50%');

  style.backgroundPosition = "top right";
  shouldBe(style.backgroundPosition, '100% 0%');
  shouldBe(computedStyle.backgroundPosition, '100% 0%');

  style.backgroundPosition = "50% center";
  shouldBe(style.backgroundPosition, '50% 50%');
  shouldBe(computedStyle.backgroundPosition, '50% 50%');

  debug("background-position invalid with one or two values, no change expected");
  style.backgroundPosition = "5 right";
  shouldBe(style.backgroundPosition, '50% 50%');
  shouldBe(computedStyle.backgroundPosition, '50% 50%');

  style.backgroundPosition = "0 right";
  shouldBe(style.backgroundPosition, '50% 50%');
  shouldBe(computedStyle.backgroundPosition, '50% 50%');

  style.backgroundPosition = "0px right";
  shouldBe(style.backgroundPosition, '50% 50%');
  shouldBe(computedStyle.backgroundPosition, '50% 50%');

  style.backgroundPosition = "top 108px";
  shouldBe(style.backgroundPosition, '50% 50%');
  shouldBe(computedStyle.backgroundPosition, '50% 50%');

  style.backgroundPosition = "top 100%";
  shouldBe(style.backgroundPosition, '50% 50%');
  shouldBe(computedStyle.backgroundPosition, '50% 50%');

  style.backgroundPosition = "60 50%";
  shouldBe(style.backgroundPosition, '50% 50%');
  shouldBe(computedStyle.backgroundPosition, '50% 50%');

  style.backgroundPosition = "hidden";
  shouldBe(style.backgroundPosition, '50% 50%');
  shouldBe(computedStyle.backgroundPosition, '50% 50%');

  style.backgroundPosition = "hidden solid";
  shouldBe(style.backgroundPosition, '50% 50%');
  shouldBe(computedStyle.backgroundPosition, '50% 50%');

  style.backgroundPosition = "bottombottom";
  shouldBe(style.backgroundPosition, '50% 50%');
  shouldBe(computedStyle.backgroundPosition, '50% 50%');

  style.backgroundPosition = "left left";
  shouldBe(style.backgroundPosition, '50% 50%');
  shouldBe(computedStyle.backgroundPosition, '50% 50%');

  style.backgroundPosition = "left right";
  shouldBe(style.backgroundPosition, '50% 50%');
  shouldBe(computedStyle.backgroundPosition, '50% 50%');

  style.backgroundPosition = "top top";
  shouldBe(style.backgroundPosition, '50% 50%');
  shouldBe(computedStyle.backgroundPosition, '50% 50%');

  style.backgroundPosition = "50% left";
  shouldBe(style.backgroundPosition, '50% 50%');
  shouldBe(computedStyle.backgroundPosition, '50% 50%');

  style.backgroundPosition = "50";
  shouldBe(style.backgroundPosition, '50% 50%');
  shouldBe(computedStyle.backgroundPosition, '50% 50%');

  style.backgroundPosition = "1px+1px";
  shouldBe(style.backgroundPosition, '1px 1px');
  shouldBe(computedStyle.backgroundPosition, '1px 1px');

  debug("background-position with CSS3 comma separator, one or two values");
  style.backgroundImage = "url($root/resources/diamond.png), url($root/resources/ring.png)";
  style.backgroundRepeat = "no-repeat";

  style.backgroundPosition = "50%, 100%";
  shouldBe(style.backgroundPosition, '50% 50%, 100% 50%');
  shouldBe(computedStyle.backgroundPosition, '50% 50%, 100% 50%');

  style.backgroundPosition = "top, bottom";
  shouldBe(style.backgroundPosition, '50% 0%, 50% 100%');
  shouldBe(computedStyle.backgroundPosition, '50% 0%, 50% 100%');

  style.backgroundPosition = "right center, 5px bottom";
  shouldBe(style.backgroundPosition, '100% 50%, 5px 100%');
  shouldBe(computedStyle.backgroundPosition, '100% 50%, 5px 100%');

  style.backgroundPosition = "top left, bottom right";
  shouldBe(style.backgroundPosition, '0% 0%, 100% 100%');
  shouldBe(computedStyle.backgroundPosition, '0% 0%, 100% 100%');

  debug("background-position with CSS3 comma separator, with invalid one or two values, no change expected");
  style.backgroundPosition = "0 center, right right";
  shouldBe(style.backgroundPosition, '0% 0%, 100% 100%');
  shouldBe(computedStyle.backgroundPosition, '0% 0%, 100% 100%');

  style.backgroundPosition = "center right, right right";
  shouldBe(style.backgroundPosition, '0% 0%, 100% 100%');
  shouldBe(computedStyle.backgroundPosition, '0% 0%, 100% 100%');

  style.backgroundPosition = "center 20px, solid 20px";
  shouldBe(style.backgroundPosition, '0% 0%, 100% 100%');
  shouldBe(computedStyle.backgroundPosition, '0% 0%, 100% 100%');

  debug("background-position with CSS3 four values");
  style.backgroundImage = "url($root/resources/diamond.png)";
  style.backgroundPosition = "left 10px top 15px";
  shouldBe(style.backgroundPosition, 'left 10px top 15px');
  shouldBe(computedStyle.backgroundPosition, 'left 10px top 15px');

  style.backgroundPosition = "left 10% top 30%";
  shouldBe(style.backgroundPosition, 'left 10% top 30%');
  shouldBe(computedStyle.backgroundPosition, 'left 10% top 30%');

  style.backgroundPosition = "top 10% left 30%";
  shouldBe(style.backgroundPosition, 'left 30% top 10%');
  shouldBe(computedStyle.backgroundPosition, 'left 30% top 10%');

  style.backgroundPosition = "right top 15px";
  shouldBe(style.backgroundPosition, 'right 0% top 15px');
  shouldBe(computedStyle.backgroundPosition, 'right 0% top 15px');

  style.backgroundPosition = "left 10px center";
  shouldBe(style.backgroundPosition, 'left 10px top 50%');
  shouldBe(computedStyle.backgroundPosition, 'left 10px top 50%');

  style.backgroundPosition = "center top 20px";
  shouldBe(style.backgroundPosition, 'left 50% top 20px');
  shouldBe(computedStyle.backgroundPosition, 'left 50% top 20px');

  style.backgroundPosition = "top 20px center";
  shouldBe(style.backgroundPosition, 'left 50% top 20px');
  shouldBe(computedStyle.backgroundPosition, 'left 50% top 20px');

  style.backgroundPosition = "center left 30px";
  shouldBe(style.backgroundPosition, 'left 30px top 50%');
  shouldBe(computedStyle.backgroundPosition, 'left 30px top 50%');

  style.backgroundPosition = "";
  shouldBe(style.backgroundPosition, '');
  shouldBe(computedStyle.backgroundPosition, '0% 0%');

  style.backgroundPosition = "left 20% top";
  shouldBe(style.backgroundPosition, 'left 20% top 0%');
  shouldBe(computedStyle.backgroundPosition, 'left 20% top 0%');

  debug("background-position with CSS3 invalid four values, no change expected");
  style.backgroundPosition = "left center top";
  shouldBe(style.backgroundPosition, 'left 20% top 0%');
  shouldBe(computedStyle.backgroundPosition, 'left 20% top 0%');

  style.backgroundPosition = "0px right top";
  shouldBe(style.backgroundPosition, 'left 20% top 0%');
  shouldBe(computedStyle.backgroundPosition, 'left 20% top 0%');

  style.backgroundPosition = "left center top center";
  shouldBe(style.backgroundPosition, 'left 20% top 0%');
  shouldBe(computedStyle.backgroundPosition, 'left 20% top 0%');

  style.backgroundPosition = "left center top 20%";
  shouldBe(style.backgroundPosition, 'left 20% top 0%');
  shouldBe(computedStyle.backgroundPosition, 'left 20% top 0%');

  style.backgroundPosition = "center bottom top 20%";
  shouldBe(style.backgroundPosition, 'left 20% top 0%');
  shouldBe(computedStyle.backgroundPosition, 'left 20% top 0%');

  style.backgroundPosition = "right bottom top";
  shouldBe(style.backgroundPosition, 'left 20% top 0%');
  shouldBe(computedStyle.backgroundPosition, 'left 20% top 0%');

  style.backgroundPosition = "right bottom solid";
  shouldBe(style.backgroundPosition, 'left 20% top 0%');
  shouldBe(computedStyle.backgroundPosition, 'left 20% top 0%');

  style.backgroundPosition = "20px bottom top";
  shouldBe(style.backgroundPosition, 'left 20% top 0%');
  shouldBe(computedStyle.backgroundPosition, 'left 20% top 0%');

  style.backgroundPosition = "20px bottom hidden";
  shouldBe(style.backgroundPosition, 'left 20% top 0%');
  shouldBe(computedStyle.backgroundPosition, 'left 20% top 0%');

  style.backgroundPosition = "solid dotted bottom top";
  shouldBe(style.backgroundPosition, 'left 20% top 0%');
  shouldBe(computedStyle.backgroundPosition, 'left 20% top 0%');

  style.backgroundPosition = "top top top top";
  shouldBe(style.backgroundPosition, 'left 20% top 0%');
  shouldBe(computedStyle.backgroundPosition, 'left 20% top 0%');

  style.backgroundPosition = "left 0px right 20%";
  shouldBe(style.backgroundPosition, 'left 20% top 0%');
  shouldBe(computedStyle.backgroundPosition, 'left 20% top 0%');

  style.backgroundPosition = "left 30% top 20% center";
  shouldBe(style.backgroundPosition, 'left 20% top 0%');
  shouldBe(computedStyle.backgroundPosition, 'left 20% top 0%');

  style.backgroundPosition = "20px 30% bottom";
  shouldBe(style.backgroundPosition, 'left 20% top 0%');
  shouldBe(computedStyle.backgroundPosition, 'left 20% top 0%');

  style.backgroundPosition = "top 0px bottom";
  shouldBe(style.backgroundPosition, 'left 20% top 0%');
  shouldBe(computedStyle.backgroundPosition, 'left 20% top 0%');

  style.backgroundPosition = "left 0px right";
  shouldBe(style.backgroundPosition, 'left 20% top 0%');
  shouldBe(computedStyle.backgroundPosition, 'left 20% top 0%');

  style.backgroundPosition = "top 0px bottom 30px top";
  shouldBe(style.backgroundPosition, 'left 20% top 0%');
  shouldBe(computedStyle.backgroundPosition, 'left 20% top 0%');

  style.backgroundPosition = "left 10px center 15px";
  shouldBe(style.backgroundPosition, 'left 20% top 0%');
  shouldBe(computedStyle.backgroundPosition, 'left 20% top 0%');

  style.backgroundPosition = "left 10px top center";
  shouldBe(style.backgroundPosition, 'left 20% top 0%');
  shouldBe(computedStyle.backgroundPosition, 'left 20% top 0%');

  style.backgroundPosition = "center right top 20px";
  shouldBe(style.backgroundPosition, 'left 20% top 0%');
  shouldBe(computedStyle.backgroundPosition, 'left 20% top 0%');

  style.backgroundPosition = "center 10px center 10px";
  shouldBe(style.backgroundPosition, 'left 20% top 0%');
  shouldBe(computedStyle.backgroundPosition, 'left 20% top 0%');

  style.backgroundPosition = "top center center";
  shouldBe(style.backgroundPosition, 'left 20% top 0%');
  shouldBe(computedStyle.backgroundPosition, 'left 20% top 0%');

  style.backgroundPosition = "center 10px center";
  shouldBe(style.backgroundPosition, 'left 20% top 0%');
  shouldBe(computedStyle.backgroundPosition, 'left 20% top 0%');

  style.backgroundPosition = "center center 10px";
  shouldBe(style.backgroundPosition, 'left 20% top 0%');
  shouldBe(computedStyle.backgroundPosition, 'left 20% top 0%');

  style.backgroundPosition = "center 0px left 20%";
  shouldBe(style.backgroundPosition, 'left 20% top 0%');
  shouldBe(computedStyle.backgroundPosition, 'left 20% top 0%');

  style.backgroundPosition = "left center top";
  shouldBe(style.backgroundPosition, 'left 20% top 0%');
  shouldBe(computedStyle.backgroundPosition, 'left 20% top 0%');

  style.backgroundPosition = "center center center";
  shouldBe(style.backgroundPosition, 'left 20% top 0%');
  shouldBe(computedStyle.backgroundPosition, 'left 20% top 0%');

  style.backgroundPosition = "top left 50% 50%";
  shouldBe(style.backgroundPosition, 'left 20% top 0%');
  shouldBe(computedStyle.backgroundPosition, 'left 20% top 0%');

  style.backgroundPosition = "center center center center";
  shouldBe(style.backgroundPosition, 'left 20% top 0%');
  shouldBe(computedStyle.backgroundPosition, 'left 20% top 0%');

  debug("background-position with CSS3 four values and comma");
  style.backgroundImage = "url($root/resources/diamond.png), url($root/resources/ring.png)";

  style.backgroundPosition = "center, left bottom 20px";
  shouldBe(style.backgroundPosition, '50% 50%, left 0% bottom 20px');
  shouldBe(computedStyle.backgroundPosition, '50% 50%, left 0% bottom 20px');

  style.backgroundPosition = "right 20px bottom 20px, center left";
  shouldBe(style.backgroundPosition, 'right 20px bottom 20px, 0% 50%');
  shouldBe(computedStyle.backgroundPosition, 'right 20px bottom 20px, 0% 50%');

  style.backgroundPosition = "left 10px top 15px, right 20% bottom 20px";
  shouldBe(style.backgroundPosition, 'left 10px top 15px, right 20% bottom 20px');
  shouldBe(computedStyle.backgroundPosition, 'left 10px top 15px, right 20% bottom 20px');

  style.backgroundPosition = "left 10% top, top 0px right";
  shouldBe(style.backgroundPosition, 'left 10% top 0%, right 0% top 0px');
  shouldBe(computedStyle.backgroundPosition, 'left 10% top 0%, right 0% top 0px');

  style.backgroundPosition = "right top 15px, bottom right 20px";
  shouldBe(style.backgroundPosition, 'right 0% top 15px, right 20px bottom 0%');
  shouldBe(computedStyle.backgroundPosition, 'right 0% top 15px, right 20px bottom 0%');

  debug("background-position with invalid CSS3 four values and comma, no change expected");
  style.backgroundPosition = "right top 15px, left right 20px";
  shouldBe(style.backgroundPosition, 'right 0% top 15px, right 20px bottom 0%');
  shouldBe(computedStyle.backgroundPosition, 'right 0% top 15px, right 20px bottom 0%');

  style.backgroundPosition = "right left 15px, left bottom 20px";
  shouldBe(style.backgroundPosition, 'right 0% top 15px, right 20px bottom 0%');
  shouldBe(computedStyle.backgroundPosition, 'right 0% top 15px, right 20px bottom 0%');

  style.backgroundPosition = "solid, left bottom 20px";
  shouldBe(style.backgroundPosition, 'right 0% top 15px, right 20px bottom 0%');
  shouldBe(computedStyle.backgroundPosition, 'right 0% top 15px, right 20px bottom 0%');

  debug("background-position inside the background shorthand");
  style.background = "top 10% left 30% / 10em gray round fixed border-box";
  shouldBe(style.background, 'left 30% top 10% / 10em round fixed border-box border-box gray');
  shouldBe(computedStyle.background, 'rgb(128, 128, 128) none round fixed left 30% top 10% / 160px border-box border-box');

  style.background = "right top 15px / 10em gray round fixed border-box";
  shouldBe(style.background, 'right 0% top 15px / 10em round fixed border-box border-box gray');
  shouldBe(computedStyle.background, 'rgb(128, 128, 128) none round fixed right 0% top 15px / 160px border-box border-box');

  style.background = "left 10px center / 10em gray round fixed border-box";
  shouldBe(style.background, 'left 10px top 50% / 10em round fixed border-box border-box gray');
  shouldBe(computedStyle.background, 'rgb(128, 128, 128) none round fixed left 10px top 50% / 160px border-box border-box');

  style.background = "left 10px center round fixed border-box";
  shouldBe(style.background, 'left 10px top 50% round fixed border-box border-box');
  shouldBe(computedStyle.background, 'rgba(0, 0, 0, 0) none round fixed left 10px top 50% / auto border-box border-box');

  style.background = "center top 20px round fixed border-box";
  shouldBe(style.background, 'left 50% top 20px round fixed border-box border-box');
  shouldBe(computedStyle.background, 'rgba(0, 0, 0, 0) none round fixed left 50% top 20px / auto border-box border-box');

  style.background = "top 20px center round fixed border-box";
  shouldBe(style.background, 'left 50% top 20px round fixed border-box border-box');
  shouldBe(computedStyle.background, 'rgba(0, 0, 0, 0) none round fixed left 50% top 20px / auto border-box border-box');

  style.background = "top center round fixed border-box";
  shouldBe(style.background, '50% 0% round fixed border-box border-box');
  shouldBe(computedStyle.background, 'rgba(0, 0, 0, 0) none round fixed 50% 0% / auto border-box border-box');

  style.background = "50px 60px / 50px round fixed border-box";
  shouldBe(style.background, '50px 60px / 50px round fixed border-box border-box');
  shouldBe(computedStyle.background, 'rgba(0, 0, 0, 0) none round fixed 50px 60px / 50px border-box border-box');

  style.background = "50px / 50px round fixed border-box";
  shouldBe(style.background, '50px 50% / 50px round fixed border-box border-box');
  shouldBe(computedStyle.background, 'rgba(0, 0, 0, 0) none round fixed 50px 50% / 50px border-box border-box');

  style.background = "left top 60px / 50px round fixed border-box";
  shouldBe(style.background, 'left 0% top 60px / 50px round fixed border-box border-box');
  shouldBe(computedStyle.background, 'rgba(0, 0, 0, 0) none round fixed left 0% top 60px / 50px border-box border-box');

  style.background = "left -20px top 60px / 50px round fixed border-box";
  shouldBe(style.background, 'left -20px top 60px / 50px round fixed border-box border-box');
  shouldBe(computedStyle.background, 'rgba(0, 0, 0, 0) none round fixed left -20px top 60px / 50px border-box border-box');

  style.background = "border-box left 20px top / 50px round fixed";
  shouldBe(style.background, 'left 20px top 0% / 50px round fixed border-box border-box');
  shouldBe(computedStyle.background, 'rgba(0, 0, 0, 0) none round fixed left 20px top 0% / 50px border-box border-box');

  style.background = "border-box round fixed left 20px top / 50px";
  shouldBe(style.background, 'left 20px top 0% / 50px round fixed border-box border-box');
  shouldBe(computedStyle.background, 'rgba(0, 0, 0, 0) none round fixed left 20px top 0% / 50px border-box border-box');

  style.background = "border-box round fixed left 20px top 40px / 50px";
  shouldBe(style.background, 'left 20px top 40px / 50px round fixed border-box border-box');
  shouldBe(computedStyle.background, 'rgba(0, 0, 0, 0) none round fixed left 20px top 40px / 50px border-box border-box');

  style.background = "border-box round fixed left 20px top 40px";
  shouldBe(style.background, 'left 20px top 40px round fixed border-box border-box');
  shouldBe(computedStyle.background, 'rgba(0, 0, 0, 0) none round fixed left 20px top 40px / auto border-box border-box');

  style.background = "top 10% left 30% gray round fixed border-box";
  shouldBe(style.background, 'left 30% top 10% round fixed border-box border-box gray');
  shouldBe(computedStyle.background, 'rgb(128, 128, 128) none round fixed left 30% top 10% / auto border-box border-box');

  debug("background-position inside the background shorthand, some invalid cases, no changes expected");
  style.background = "";
  style.background = "top 10% left 30% 50% gray round fixed border-box";
  shouldBe(style.background, '');
  // This is the default computed style.
  shouldBe(computedStyle.background, 'rgba(0, 0, 0, 0) none repeat scroll 0% 0% / auto padding-box border-box');

  style.background = "top 10% solid 30% gray round fixed border-box";
  shouldBe(style.background, '');
  shouldBe(computedStyle.background, 'rgba(0, 0, 0, 0) none repeat scroll 0% 0% / auto padding-box border-box');

  style.background = "top 10% left round gray round fixed border-box";
  shouldBe(style.background, '');
  shouldBe(computedStyle.background, 'rgba(0, 0, 0, 0) none repeat scroll 0% 0% / auto padding-box border-box');

  style.background = "top 10% top 30% gray round fixed border-box";
  shouldBe(style.background, '');
  shouldBe(computedStyle.background, 'rgba(0, 0, 0, 0) none repeat scroll 0% 0% / auto padding-box border-box');

  style.background = "center center center / 10em gray round fixed border-box";
  shouldBe(style.background, '');
  shouldBe(computedStyle.background, 'rgba(0, 0, 0, 0) none repeat scroll 0% 0% / auto padding-box border-box');

  style.background = "center center 30px / 10em gray round fixed border-box";
  shouldBe(style.background, '');
  shouldBe(computedStyle.background, 'rgba(0, 0, 0, 0) none repeat scroll 0% 0% / auto padding-box border-box');

  style.background = "top center left / 10em gray round fixed border-box";
  shouldBe(style.background, '');
  shouldBe(computedStyle.background, 'rgba(0, 0, 0, 0) none repeat scroll 0% 0% / auto padding-box border-box');

  style.background = "50% left / 10em gray round fixed border-box";
  shouldBe(style.background, '');
  shouldBe(computedStyle.background, 'rgba(0, 0, 0, 0) none repeat scroll 0% 0% / auto padding-box border-box');

  style.background = "solid / 10em gray round fixed border-box";
  shouldBe(style.background, '');
  shouldBe(computedStyle.background, 'rgba(0, 0, 0, 0) none repeat scroll 0% 0% / auto padding-box border-box');

  style.background = "top 10% left 20px 50% 50px gray round fixed border-box";
  shouldBe(style.background, '');
  shouldBe(computedStyle.background, 'rgba(0, 0, 0, 0) none repeat scroll 0% 0% / auto padding-box border-box');

  style.background = "20px 20px 30px / 40px gray round fixed border-box";
  shouldBe(style.background, '');
  shouldBe(computedStyle.background, 'rgba(0, 0, 0, 0) none repeat scroll 0% 0% / auto padding-box border-box');

  style.background = "20px 20px 30px 60px / 40px gray round fixed border-box";
  shouldBe(style.background, '');
  shouldBe(computedStyle.background, 'rgba(0, 0, 0, 0) none repeat scroll 0% 0% / auto padding-box border-box');

  style.background = "20px 20px 30px 60px 70px / 40px gray round fixed border-box";
  shouldBe(style.background, '');
  shouldBe(computedStyle.background, 'rgba(0, 0, 0, 0) none repeat scroll 0% 0% / auto padding-box border-box');

  style.background = "20px 20px 30px / 40px gray top left round fixed border-box";
  shouldBe(style.background, '');
  shouldBe(computedStyle.background, 'rgba(0, 0, 0, 0) none repeat scroll 0% 0% / auto padding-box border-box');

  testContainer.remove();
}
