/*
 * Copyright (c) 2014, the Dart project authors.  Please see the AUTHORS file
 * for details. All rights reserved. Use of this source code is governed by a
 * BSD-style license that can be found in the LICENSE file.
 */
/** 
 * @description Test that color values are properly clamped (R, G, B should be
 * 0-255), alpha 0.0-1.0
 */
import "dart:html";
import "dart:math" as Math;
import "../../testcommon.dart";
import "../../../Utils/async_utils.dart";

main() {
  var ctx = createContext2d("canvas");

  ctx.shadowColor = 'rgba(0,0,0,0)';
  shouldBe(ctx.shadowColor, 'rgba(0, 0, 0, 0)');
  ctx.shadowColor = 'rgb(0,0,0)';
  shouldBe(ctx.shadowColor, '#000000');
  ctx.shadowColor = 'rgb(0,999,0)'; 
  shouldBe(ctx.shadowColor, '#00ff00');
  ctx.shadowColor = 'rgb(0,999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999,0)';
  shouldBe(ctx.shadowColor, '#00ff00');
  ctx.shadowColor = 'rgb(0,0,256)';
  shouldBe(ctx.shadowColor, '#0000ff');
  ctx.shadowColor = 'rgb(999999999999999999999999,0,-9999999999999999999999999999)';
  shouldBe(ctx.shadowColor, '#ff0000');
  ctx.shadowColor = 'rgba(9999999999999999999999999999999999999999999999999999999999999999999999999999999999,9,0,1)';
  shouldBe(ctx.shadowColor, '#ff0900');
  ctx.shadowColor = 'rgba(9999999999999999999999999999999999999999999999999999999999999999999999999999999999,9,0,-99999999999999999999999999999999999999)';
  shouldBe(ctx.shadowColor, 'rgba(255, 9, 0, 0)');
  ctx.shadowColor = 'rgba(7,9999999999999999999999999999999999999999999999999999999999999999999999999999999999,0,99999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999)';
  shouldBe(ctx.shadowColor, '#07ff00');
  ctx.shadowColor = 'rgba(-7,9999999999999999999999999999999999999999999999999999999999999999999999999999999999,0,99999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999)';
  shouldBe(ctx.shadowColor, '#00ff00');
  ctx.shadowColor = 'rgba(0%,100%,0%,0.4)';
  shouldBe(ctx.shadowColor, 'rgba(0, 255, 0, 0.4)');
}

