/*
 * Copyright (c) 2014, the Dart project authors.  Please see the AUTHORS file
 * for details. All rights reserved. Use of this source code is governed by a
 * BSD-style license that can be found in the LICENSE file.
 */
/** 
 * @description 
 */
import "dart:html";
import "../../testcommon.dart";
import "../../../Utils/async_utils.dart";
import "pwd.dart";

getComputedStyle(x, [pseudoElement]) => x.getComputedStyle(pseudoElement);

main() {
  var meta = new Element.html('''
      <meta http-equiv="cONtENT-LAnguAGE" content="ja-JP">
      ''', treeSanitizer: new NullTreeSanitizer());
  document.head.append(meta);

  document.body.setInnerHtml('''
      <p>Test for <a href="https://bugs.webkit.org/show_bug.cgi?id=76701">bug 76701</a>:
      map content-language to -webkit-locale. This particular test tests that the
      matching of the http-equiv attribute to the content-language state is case
      insensitive.
      </p>
      <div id="console"></div>
      <div id="x"></div>
      ''', treeSanitizer: new NullTreeSanitizer());

  languageOfNode(id) {
    var element = document.getElementById(id);
    //return getComputedStyle(element).webkitLocale;
    return getComputedStyle(element).getPropertyValue('-webkit-locale');
  }
  shouldBeEqualToString(languageOfNode('x'), "ja-JP");
}
