/*
 * Copyright (c) 2014, the Dart project authors.  Please see the AUTHORS file
 * for details. All rights reserved. Use of this source code is governed by a
 * BSD-style license that can be found in the LICENSE file.
 */
/** 
 * @description 
 */
import "dart:html";
import "../../testcommon.dart";
import "../../../Utils/async_utils.dart";
import "pwd.dart";

main() {
  document.body.setInnerHtml('''
      <div>
      Tests error recovery in @-rules.
      </div>

      <div>
      <style>@foo #; #test1{display: none}</style>
      <div id="test1"></div>

      <style>@foo {#} #test2{display: none}</style>
      <div id="test2"></div>

      <style>@media #; #test3{display: none}</style>
      <div id="test3"></div>

      <style>@media {#} #test4{display: none}</style>
      <div id="test4"></div>

      <style>@supports #; #test5{display: none}</style>
      <div id="test5"></div>

      <style>@supports (display: block) {#} #test6{display: none}</style>
      <div id="test6"></div>

      <style>@-webkit-keyframes #; #test7{display: none}</style>
      <div id="test7"></div>

      <style>@-webkit-keyframes x {#} #test8{display: none}</style>
      <div id="test8"></div>

      <style>@page #; #test9{display: none}</style>
      <div id="test9"></div>

      <style>@page x {#} #test10{display: none}</style>
      <div id="test10"></div>

      <style>@-webkit-viewport #; #test11{display: none}</style>
      <div id="test11"></div>

      <style>@-webkit-viewport {#} #test12{display: none}</style>
      <div id="test12"></div>

      <style>@-webkit-region #; #test13{display: none}</style>
      <div id="test13"></div>

      <style>@-webkit-region x {#} #test14{display: none}</style>
      <div id="test14"></div>

      <style>@font-face #; #test15{display: none}</style>
      <div id="test15"></div>

      <style>@font-face x {#} #test16{display: none}</style>
      <div id="test16"></div>

      <style>@top-left #; #test17{display: none}</style>
      <div id="test17"></div>

      <style>@top-left x {#} #test18{display: none}</style>
      <div id="test18"></div>

      <style>@-webkit-filter #; #test19{display: none}</style>
      <div id="test19"></div>

      <style>@-webkit-filter x {#} #test20{display: none}</style>
      <div id="test20"></div>

      <style>@import url("") {} #test21{display: none}</style>
      <div id="test21"></div>

      <style>@namespace url("") {} #test22{display: none}</style>
      <div id="test22"></div>

      <style>@-webkit-region x{div::-moz-{}} #test23{display: none}</style>
      <div id="test23"></div>

      <style>@-webkit-region x{@{}} #test24{display: none}</style>
      <div id="test24"></div>

      <style>@media all {@keyframes;} #test25{display: none}</style>
      <div id="test25"></div>

      <style>@media all {@page;} #test26{display: none}</style>
      <div id="test26"></div>

      <style>@media all {@font-face;} #test27{display: none}</style>
      <div id="test27"></div>

      <style>@media all {@supports;} #test28{display: none}</style>
      <div id="test28"></div>

      <style>@media all {@viewport;} #test29{display: none}</style>
      <div id="test29"></div>

      <style>@media all {@-webkit-filter;} #test30{display: none}</style>
      <div id="test30"></div>

      <style>@media all {@xxx;} #test31{display: none}</style>
      <div id="test31"></div>

      <style>@-webkit-region x {@keyframes;} #test32{display: none}</style>
      <div id="test32"></div>

      <style>@-webkit-region x {@page;} #test33{display: none}</style>
      <div id="test33"></div>

      <style>@-webkit-region x {@font-face;} #test34{display: none}</style>
      <div id="test34"></div>

      <style>@-webkit-region x {@supports;} #test35{display: none}</style>
      <div id="test35"></div>

      <style>@-webkit-region x {@viewport;} #test36{display: none}</style>
      <div id="test36"></div>

      <style>@-webkit-region x {@-webkit-filter;} #test37{display: none}</style>
      <div id="test37"></div>

      <style>@-webkit-region x {@xxx;} #test38{display: none}</style>
      <div id="test38"></div>

      <style>@media all {@keyframes} #test39{display: none}</style>
      <div id="test39"></div>

      <style>@media all {@page*} #test40{display: none}</style>
      <div id="test40"></div>

      <style>@media all {@font-face x (;)} #test41{display: none}</style>
      <div id="test41"></div>

      <style>@media all {@supports not (display: none)} #test42{display: none}</style>
      <div id="test42"></div>

      <style>@media all {@viewport ?} #test43{display: none}</style>
      <div id="test43"></div>

      <style>@media all {x {} @-webkit-filter} #test44{display: none}</style>
      <div id="test44"></div>

      <style>@media all {@xxx} #test45{display: none}</style>
      <div id="test45"></div>

      <style>@-webkit-region x {@keyframes} #test46{display: none}</style>
      <div id="test46"></div>

      <style>@-webkit-region x {@page*} #test47{display: none}</style>
      <div id="test47"></div>

      <style>@-webkit-region x {@font-face x(;)} #test48{display: none}</style>
      <div id="test48"></div>

      <style>@-webkit-region x {@supports not (display: none)} #test49{display: none}</style>
      <div id="test49"></div>

      <style>@-webkit-region x {@viewport ?} #test50{display: none}</style>
      <div id="test50"></div>

      <style>@-webkit-region x {x {} @-webkit-filter} #test51{display: none}</style>
      <div id="test51"></div>

      <style>@-webkit-region x {@xxx} #test52{display: none}</style>
      <div id="test52"></div>

      <style>@media all {@media all} #test53{display: none}</style>
      <div id="test53"></div>

      <style>@media all {@media all;} #test54{display: none}</style>
      <div id="test54"></div>

      <style>@media all {@import} #test59{display: none}</style>
      <div id="test59"></div>

      <style>@media all {@import;} #test60{display: none}</style>
      <div id="test60"></div>

      <style>@media all {@import url("")} #test61{display: none}</style>
      <div id="test61"></div>

      <style>@media all {@import url("");} #test62{display: none}</style>
      <div id="test62"></div>

      </div>
      ''', treeSanitizer: new NullTreeSanitizer());

  var tests = document.querySelectorAll("[id^=test]");
  for (var i = 0; i < tests.length; i++)
    tests[i].text = "FAIL";
}
