/*
 * Copyright (c) 2014, the Dart project authors.  Please see the AUTHORS file
 * for details. All rights reserved. Use of this source code is governed by a
 * BSD-style license that can be found in the LICENSE file.
 */
/**
 * @description Test for the list attribute.
 * @static-warning
 */
import "dart:html";
import "../../../testcommon.dart";
import "../../../../Utils/async_utils.dart";

main() {
  document.body.setInnerHtml('''
      <div style="display:none">
        <!-- No list attribute -->
        <input type="text" id="i1">
        <!-- Empty list -->
        <input type="text" id="i2" list="">
        <!-- Non-existent ID -->
        <input type="text" id="i3" list="nonexist">
        <!-- ID confilict -->
        <input type="text" id="i4" list="dl2">
        <!-- supported type -->
        <input type="text" id="text" list="dl1">
        <input type="search" id="search" list="dl1">
        <input type="url" id="url" list="dl1">
        <input type="telephone" id="telephone" list="dl1">
        <input type="email" id="email" list="dl1">
        <input type="datetime" id="datetime" list="dl1">
        <input type="date" id="date" list="dl1">
        <input type="month" id="month" list="dl1">
        <input type="week" id="week" list="dl1">
        <input type="time" id="time" list="dl1">
        <input type="datetime-local" id="datetime-local" list="dl1">
        <input type="number" id="number" list="dl1">
        <input type="range" id="range" list="dl1">
        <input type="color" id="color" list="dl1">
        <!-- Unsupported type -->
        <input type="hidden" id="hidden" list="dl1">
        <input type="password" id="password" list="dl1">
        <input type="checkbox" id="checkbox" list="dl1">
        <input type="radio" id="radio" list="dl1">
        <input type="file" id="file" list="dl1">
        <input type="submit" id="submit" list="dl1">
        <input type="image" id="image" list="dl1">
        <input type="reset" id="reset" list="dl1">
        <input type="button" id="button" list="dl1">
      </div>

      <datalist id="dl1">
       <option>value1</option>
      </datalist>

      <datalist id="dl2" class="former">
       <option>value1</option>
      </datalist>
      <datalist id="dl2" class="latter">
       <option>value1</option>
      </datalist>
      ''', treeSanitizer: new NullTreeSanitizer());

  var input = document.getElementById('i1');
  shouldBeNull(input.list);

  input = document.getElementById('i2');
  shouldBeNull(input.list);

  input = document.getElementById('i3');
  shouldBeNull(input.list);

  var datalist = document.getElementById('i4').list;
  shouldBe(datalist.className, "former");

  shouldBe(document.getElementById("text").list, document.getElementById("dl1"));
  shouldBe(document.getElementById("search").list, document.getElementById("dl1"));
  shouldBe(document.getElementById("url").list, document.getElementById("dl1"));
  shouldBe(document.getElementById("telephone").list, document.getElementById("dl1"));
  shouldBe(document.getElementById("email").list, document.getElementById("dl1"));
  shouldBe(document.getElementById("datetime").list, document.getElementById("dl1"));
  shouldBe(document.getElementById("date").list, document.getElementById("dl1"));
  shouldBe(document.getElementById("month").list, document.getElementById("dl1"));
  shouldBe(document.getElementById("week").list, document.getElementById("dl1"));
  shouldBe(document.getElementById("time").list, document.getElementById("dl1"));
  shouldBe(document.getElementById("datetime-local").list, document.getElementById("dl1"));
  shouldBe(document.getElementById("number").list, document.getElementById("dl1"));
  shouldBe(document.getElementById("range").list, document.getElementById("dl1"));
  shouldBe(document.getElementById("color").list, document.getElementById("dl1"));

  shouldBeNull(document.getElementById("hidden").list);
  shouldBeNull(document.getElementById("password").list);
  shouldBeNull(document.getElementById("checkbox").list);
  shouldBeNull(document.getElementById("radio").list);
  shouldBeNull(document.getElementById("file").list);
  shouldBeNull(document.getElementById("submit").list);
  shouldBeNull(document.getElementById("image").list);
  shouldBeNull(document.getElementById("reset").list);
  shouldBeNull(document.getElementById("button").list);
}
