/*
 * Copyright (c) 2014, the Dart project authors.  Please see the AUTHORS file
 * for details. All rights reserved. Use of this source code is governed by a
 * BSD-style license that can be found in the LICENSE file.
 */
/**
 * @description This test aims to check for typeMismatch flag with type=date
 * input fields
 */
import "dart:html";
import "../../../testcommon.dart";
import "../../../../Utils/async_utils.dart";

main() {
  var i = document.createElement('input');
  i.type = 'date';

  check(value, [disabled=false]) {
    i.value = value;
    i.disabled = disabled;

    if (i.validity.typeMismatch)
      testFailed('"' + value + '" had typeMismatch. This should not happen with sanitization.');
  }

  shouldBeValid(value) {
    check(value);
    if ((value == '' && i.value == '') || (value != '' && i.value != ""))
      testPassed('"' + value + '" is a correct valid date string.');
    else
      testFailed('"' + value + '" is a valid date string that failed to be set on the input.');
  }

  shouldBeInvalid(value, [disabled=false]) {
    check(value, disabled);
    if (i.value == '')
      testPassed('"' + value + '" is an invalid date string and was sanitized' + (disabled ? ' while disabled' : '') + '.');
    else
      testFailed('"' + value + '" is an invalid date string and was not sanitized' + (disabled ? ' while disabled' : '') + '.');
  }

  // Valid values
  shouldBeValid('');
  shouldBeValid('2009-09-07');
  shouldBeValid('9999-12-31');
  shouldBeValid('275760-09-13');
  shouldBeValid('1582-10-15');
  shouldBeValid('0001-01-01');
  shouldBeValid('2009-01-31');
  shouldBeValid('2009-02-28');
  shouldBeValid('2009-03-31');
  shouldBeValid('2009-04-30');
  shouldBeValid('2009-05-31');
  shouldBeValid('2009-06-30');
  shouldBeValid('2009-07-31');
  shouldBeValid('2009-08-31');
  shouldBeValid('2009-09-30');
  shouldBeValid('2009-10-31');
  shouldBeValid('2009-11-30');
  shouldBeValid('2009-12-31');
  shouldBeValid('2008-02-29');
  shouldBeValid('2000-02-29');

  // Invalid values
  shouldBeInvalid(' 2009-09-07 ');
  shouldBeInvalid('a');
  shouldBeInvalid('-1-09-07');
  shouldBeInvalid('0000-12-31');
  shouldBeInvalid('0000-01-01');
  shouldBeInvalid('275760-09-14');
  shouldBeInvalid('2147483648-12-31');
  shouldBeInvalid('2009/09/07');
  shouldBeInvalid('20090907');
  shouldBeInvalid('2009--2-07');
  shouldBeInvalid('2009-00-07');
  shouldBeInvalid('2009-13-07');
  shouldBeInvalid('2009-xx-30');
  shouldBeInvalid('2009-01-32');
  shouldBeInvalid('2009-02-29');
  shouldBeInvalid('2009-03-32');
  shouldBeInvalid('2009-04-31');
  shouldBeInvalid('2009-05-32');
  shouldBeInvalid('2009-06-31');
  shouldBeInvalid('2009-07-32');
  shouldBeInvalid('2009-08-32');
  shouldBeInvalid('2009-09-31');
  shouldBeInvalid('2009-10-32');
  shouldBeInvalid('2009-11-31');
  shouldBeInvalid('2009-12-32');
  shouldBeInvalid('2100-02-29');
  shouldBeInvalid('2009-09-00');
  shouldBeInvalid('2009-09-');
  shouldBeInvalid('2009-09-7');
  shouldBeInvalid('2009-09-001');
  shouldBeInvalid('2009-09-xx');
  shouldBeInvalid('2009-09');
  shouldBeInvalid('2009');

  // Disabled
  shouldBeInvalid('2009-09', true);
}
