/*
 * Copyright (c) 2014, the Dart project authors.  Please see the AUTHORS file
 * for details. All rights reserved. Use of this source code is governed by a
 * BSD-style license that can be found in the LICENSE file.
 */
/**
 * @assertion 
 * @description 
 */
import "dart:html";
import "../../resources/check-layout.dart";

const String htmlEL1 = r'''
<style type="text/css">
.container
{
    width:300px;
    height:400px;
    font:16px/1 Ahem;
    background-color:#999999;
}

.child
{
    display:table;
    height:100%;
    background-color:green;
}
.fixed-table
{
    table-layout:fixed;
}
</style>
''';

const String htmlEL2 = r'''
<div> Testcase for Bug <a href="http://wkbug.com/98633">http://wkbug.com/98633</a>. The testcase checks if the height of a 
css table does not exceed the max-height value. The height of the table can be greater than max-height value when either
min-height is greater than max-height or computed height of the content is greater than the max-height.
</div>
<br>
<div class="container">
    <div id="maxGreatThanMinHeightAutoLayout" class="child" style="min-height:100px; max-height:200px;" data-expected-height=200>
        This sub-test checks that when min-height is lesser than max-height, max-height is applied to a table with auto layout.
    </div>
</div>
<div class="container">
    <div class="child" style="min-height:200px; max-height:100px;" data-expected-height=200>
        This sub-test checks that when min-height is greater than max-height, min-height is applied to a table with auto layout.
    </div>
</div>
<div class="container">
    <div class="child" style="max-height:200px;" data-expected-height=200>
        This sub-test checks that max-height with fixed value is applied to a table with auto layout.
    </div>
</div>
<div class="container">
    <div class="child" style="max-height:50%;" data-expected-height=200>
        This sub-test checks that max-height with percent value is applied to a table with auto layout.
    </div>
</div>
<div class="container">
    <div class="child" style="max-height:50vh;" data-expected-height=300>
        This sub-test checks that max-height with viewport percent height value is applied to a table with auto layout.
    </div>
</div>
<div class="container">
    <div class="child" style="max-height:25vw;" data-expected-height=200>
        This sub-test checks that max-height with viewport percent width value is applied to a table with auto layout.
    </div>
</div>
<div class="container">
    <div class="child" style="max-height:100px;" data-expected-height=192>
        This sub-test checks that when content height is greater than max-height, content height is applied to the table with auto layout.
        <br><br>FILLER TEXT TO INCREASE CONTENT HEIGHT.
    </div>
</div>
<div class="container">
    <div class="child fixed-table" style="height:auto;">
        This test checks that when height of an auto-table is auto, there is are no asserts. No crash means the test passed.
    </div>
</div>
<div class="container">
    <div class="child fixed-table" style="min-height:100px; max-height:200px;" data-expected-height=200>
        This sub-test checks that when min-height is lesser than max-height, max-height is applied to a table with fixed layout.
    </div>
</div>
<div class="container">
    <div class="child fixed-table" style="min-height:200px; max-height:100px;" data-expected-height=200>
        This sub-test checks that when min-height is greater than max-height, min-height is applied to a table with fixed layout.
    </div>
</div>
<div class="container">
    <div class="child fixed-table" style="max-height:200px;" data-expected-height=200>
        This sub-test checks that max-height with fixed value is applied to a table with fixed layout.
    </div>
</div>
<div class="container">
    <div class="child fixed-table" style="max-height:50%;" data-expected-height=200>
        This sub-test checks that max-height with percent value is applied to a table with fixed layout.
    </div>
</div>
<div class="container">
    <div class="child fixed-table" style="max-height:50vh;" data-expected-height=300>
        This sub-test checks that max-height with viewport percent height value is applied to a table with fixed layout.
    </div>
</div>
<div class="container">
    <div class="child fixed-table" style="max-height:25vw;" data-expected-height=200>
        This sub-test checks that max-height with viewport percent width value is applied to a table with fixed layout.
    </div>
</div>
<div class="container">
    <div class="child fixed-table" style="max-height:100px;" data-expected-height=192>
        This sub-test checks that when content height is greater than max-height, content height is applied to a table with fixed layout.
        <br><br>FILLER TEXT TO INCREASE CONTENT HEIGHT.
    </div>
</div>
<div class="container">
    <div class="child fixed-table" style="height:auto;">
        This test checks that when height of a fixed table is auto, there is are no asserts. No crash means the test passed.
    </div>
</div>
''';

void runTest(e) {
    checkLayout('.child');
}
void main() {
    document.head.appendHtml(htmlEL1);
    document.body.appendHtml(htmlEL2);
    window.onLoad.listen(runTest);

}
