/*
 * Copyright (c) 2014, the Dart project authors.  Please see the AUTHORS file
 * for details. All rights reserved. Use of this source code is governed by a
 * BSD-style license that can be found in the LICENSE file.
 */
/**
 * @assertion
 * @description Test for <a href="http://bugs.webkit.org/show_bug.cgi?id=12359">bug 12359</a>:
 * XPathEvaluator may return some nodes more than once in a result set.
 */
import "dart:html";
import "../../../Utils/expect.dart";

const String htmlEL = r'''
    <p></p>

    <div>
      <div>
        <div></div>
      </div>
    </div>
''';

void main() {
    document.body.appendHtml(htmlEL);
    XPathEvaluator evaluator=new XPathEvaluator();
    var result = evaluator.evaluate("//div//div | //div/div", document, null, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null);
    Expect.equals(2, result.snapshotLength);
}