/*
 * Copyright (c) 2011, the Dart project authors.  Please see the AUTHORS file
 * for details. All rights reserved. Use of this source code is governed by a
 * BSD-style license that can be found in the LICENSE file.
 */
/**
 * @assertion abstract dynamic fold(initialValue, combine(previousValue, E element))
 * Reduces a collection to a single value by iteratively combining each element of
 * the collection with an existing value using the provided function.
 * Use initialValue as the initial value, and the function combine to create a new
 * value from the previous one and an element.
 * @description Checks that the result is correct for simple functions.
 * @author kaigorodov
 */
import "dart:math";
import "../../../Utils/expect.dart";

check(List a, var init, combine, num expected) {
  num actual=a.fold(init, combine);
  Expect.equals(expected, actual);
}	

main() {
  check([1,2,-3], 0, (value, element) => value+element, 0);
  check([1,2,-3], 1, (value, element) => value*element, -6);
  check([0,2,-3], 1, (value, element) => value*element, 0);
  check(const[1,2,-5,-6], -1000, (value, element) => max(value,element), 2);
}
