/*
 * Copyright (c) 2011, the Dart project authors.  Please see the AUTHORS file
 * for details. All rights reserved. Use of this source code is governed by a
 * BSD-style license that can be found in the LICENSE file.
 */
/**
 * @assertion abstract void sort([int compare(E a, E b)])
 * Sorts the list according to the order specified by the compare function.
 * The compare function must act as a Comparator.
 * The default List implementations use Comparable.compare if compare is omitted.
 * @description Checks sorting integer arrays longer than 511 (512, 513, 1023).
 * @author iefremov
 * @reviewer msyabro
 */
library sort_A01_t05;

import "../../../Utils/expect.dart";

test(List create([int length])) {

  void check(var actual0, var expected) {
    List actual=create();
    actual.addAll(actual0);
    int c(var a, var b) {
      return a < b ? -1 : (a == b ? 0 : 1);
    }
    actual.sort(c);
    Expect.listEquals(expected, actual);
  }

//length == 512
  check([ 13, -15, -05,  15, -04, -24, -04,  17, -13, -13,  18,  02, -05, -04, -22, -22, -23,  12, -16, -23, -12,  07, -10,  05, -03,  02,  22,  21,  13, -04, -23,  01,  08, -02, -07, -19, -01,  15,  24,  11, -21,  19, -10, -01, -10, -06,  04, -08, -17,  16, -04, -04, -02,  14, -22,  22, -09, -23,  20, -18, -02,  23,  10, -16, -04, -21, -10,  22,  21, -09,  10, -25, -15, -25,  01,  00, -04, -18,  20,  06,  23, -09, -22, -03, -18, -17, -06, -01, -14, -10,  08,  11, -12, -07,  20,  11, -03, -12,  08, -05,  04, -07, -05,  15, -05,  21, -08,  17, -21, -11, -02, -21,  06,  03,  01,  13,  14,  21, -11, -25, -12,  22,  13,  03, -09,  11, -11,  15,  24,  24, -14,  03, -08,  08, -05,  12,  07,  15,  06,  13, -21, -18,  17,  12,  10, -06,  03, -01, -08,  17,  01,  07,  17, -10, -15, -15, -24,  01, -23, -23,  00, -10,  07,  19,  24, -20,  06,  06,  20, -10, -06,  24, -03, -12,  14, -16,  07, -08,  09, -24, -16, -13,  08, -22,  02,  20, -12,  05, -04, -09,  09,  23,  06, -08,  17,  05, -03,  01, -12, -06,  16,  09, -07, -10,  23, -18, -01,  07,  01, -15,  11,  11, -02, -06,  14, -23, -08, -20,  10,  15, -04, -06,  14, -23,  13,  08,  10, -15, -16,  23,  04, -23,  10, -25, -08,  10, -16,  19, -08,  11, -21, -22, -01,  04,  00, -12,  07,  19, -05, -08,  09,  16,  13, -02,  21,  02, -16,  06,  14, -07,  06, -06, -02, -07, -04,  17, -22,  05,  11, -04, -09,  18,  01,  15, -03, -22, -19, -21,  22,  01, -02,  07, -05, -11, -18, -09,  16, -09,  24,  05,  12,  07, -24, -15, -24, -03, -23, -19, -22,  16,  04, -04,  09, -19, -11, -19, -14, -03, -12, -16, -25,  13,  18, -05, -21, -23,  13,  20, -04,  14,  03, -17, -03,  06, -05,  00, -21, -01,  06, -16, -08, -12,  07, -24, -06,  21, -15,  05, -07,  00,  16, -04, -10,  11,  16, -05,  14,  07, -08, -15, -04,  20, -05,  20,  02,  17, -03,  08, -07, -21,  17,  11, -08, -01,  14,  13, -02,  24, -05,  18,  01, -11, -11,  17, -25, -17, -13,  14,  15,  04, -24, -14,  02, -02, -16, -19, -08,  06,  14,  11,  12,  06, -01, -19, -18, -12,  19,  05, -10, -08, -01,  16,  06,  15,  10,  06,  23,  24, -02,  13,  06,  01, -23, -17, -23, -14, -09, -06,  17, -20, -18,  07,  13,  08,  13,  22,  22,  10,  05, -11, -23, -21, -18,  10,  21,  18, -07,  20,  19,  16,  08,  00, -05,  12,  10, -03, -25, -24,  18,  18, -17, -22,  02,  21,  11, -10,  19,  10, -25, -01,  24, -21,  05, -18,  14,  03, -23, -17, -02,  21, -24, -16, -03, -02,  21, -16,  22,  22, -14,  16,  17, -06,  21, -06, -07,  09,  11, -11, -05,  12,  15, -04,  16, -03,  05,  08, -25,  07,  16, -01,  04,  19,  08, -22, -07,  06, -13, -10,  05,  00, -17, -03],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([ 22, -19,  18, -10,  16,  05,  04, -12, -06, -04,  11, -15,  18, -08,  20,  18, -24,  13, -06,  05,  08, -23,  10, -22,  11, -25, -07, -09,  00,  04,  14, -03,  10,  09,  14,  03, -11, -07,  18,  10,  16,  05,  23,  09,  22,  18,  05,  23,  07,  24,  06, -10, -23, -07, -07,  15, -07,  13, -19,  21, -06,  22, -07, -20,  07, -17,  10,  23,  03,  04,  09, -05, -14,  07, -19, -17,  02,  11, -17, -16,  11,  16,  01,  15, -13,  19,  05,  05,  10,  13,  01, -21,  11,  22, -14, -05, -18,  22, -07,  10,  03, -21, -18,  14,  13, -11,  24, -09, -25, -16,  00,  13, -22, -21,  03, -10,  23, -15,  20,  10,  24, -01,  15,  10, -04, -24, -20,  03, -25,  00, -10,  03,  07,  00, -06, -05,  14, -07,  13,  16,  05, -09,  05,  08, -05, -15,  23, -05, -04,  20, -19, -05, -06,  21, -18,  17,  24, -13, -03, -25,  14,  13,  05, -04, -12, -23,  19, -21, -05,  07,  22, -23, -25,  04,  10, -05,  15,  10,  18, -12,  06,  24,  08, -25,  22,  15,  20,  21, -21, -08,  23,  20, -20,  06, -08, -05,  08, -12,  01, -20,  22, -01, -17,  23, -22,  20, -05,  20,  06, -12, -17, -13, -11,  18, -11, -14,  10, -16, -15,  14,  02, -15,  10,  09,  16, -21, -18, -01, -08,  08,  07, -09, -16,  15, -11, -12,  10,  12, -17, -09, -25, -06,  05, -08, -13,  20,  03,  23, -21,  15,  14,  08, -24,  01, -05,  17,  07,  02, -06,  24, -15, -22, -07, -03,  18,  07,  10,  05, -06,  20,  24, -03, -09,  04,  14,  04,  01, -06,  04,  08, -15, -05, -09, -12,  22,  11, -18,  04, -10,  01,  06,  03,  04,  24, -25, -01,  08,  10, -18, -20,  07, -19,  04,  24,  12, -07,  05, -09,  14, -16,  24, -24,  06, -08, -11,  03, -19, -03, -15, -04, -25,  16,  24,  07,  17, -24, -17,  00,  13, -10,  07, -04, -02, -14, -03, -12,  06, -21,  04, -04, -10,  05, -01,  21,  24,  16,  00, -20, -12,  10,  04, -10,  03,  03,  22, -05,  07, -17,  22, -05, -02,  05,  16,  24,  16, -10, -13, -02, -06,  18,  21,  09, -02, -05,  06, -03, -14, -19,  05,  01,  18, -16,  19, -04,  14,  18,  18, -04, -24,  17,  17,  00, -03,  10,  01, -09, -24,  13,  14, -03,  06,  12, -18, -19, -16,  13,  05, -04,  21, -13,  24,  16, -04,  18, -11, -12,  14, -16,  09,  15, -24,  03, -08, -01, -11,  18,  15, -08,  08,  06,  14, -09, -05,  23, -03,  04,  13, -20, -23,  11, -06, -23,  02,  16,  22,  18, -19,  11, -23,  15,  04, -21, -06,  21,  05,  10,  17, -03, -21,  00, -22,  18,  17, -02,  19, -09, -21,  07, -04, -18, -06,  18, -16,  23,  09, -17,  17,  15,  22,  19,  07,  01, -25, -22, -01,  05,  15, -09, -23,  19,  17, -18,  15,  09,  07,  09, -25,  12, -07, -01,  19,  12, -08, -20,  13, -22, -12,  05,  20, -13,  01,  04],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([ 13,  04,  08, -12, -16,  00,  04, -11, -05, -02, -02, -13, -18, -19,  23, -15,  20, -09,  09,  16, -19, -22,  21,  19, -17, -14,  01, -22, -01, -21,  09, -11,  08, -06,  02,  20,  20, -16, -16, -08,  07,  09,  04,  15,  17,  02, -23,  12,  20,  13,  03, -24,  16,  01,  20, -24,  13, -02, -19, -11,  03,  15,  03, -14, -15, -19, -19, -20, -08, -08, -01,  24, -23, -22,  16,  19,  07,  18,  09,  02,  08, -11,  04, -01,  16,  01,  02,  06, -25,  08,  20,  05, -01, -02,  16,  11,  06, -25,  18,  23, -06, -08, -25, -02, -05,  18, -07, -23,  14, -21,  06, -03, -07, -13,  24, -16,  14,  01,  17,  16, -15,  12, -04,  11, -12, -11, -03,  19, -09, -10,  20,  11,  09,  22, -16, -21,  15,  04, -17,  04,  10,  16, -23, -21, -21, -24, -10,  18,  02, -17,  11,  14,  22, -18,  00, -15, -02,  24, -20,  15, -09, -23,  03, -25,  24,  12, -19,  14, -06, -09, -06, -21, -17, -02, -15, -13, -01,  03, -18, -22,  11,  18,  18,  08, -23, -05,  19,  02, -03, -24, -08,  15, -22,  20,  16, -21,  10,  24,  18, -19, -09, -11, -13,  01,  12, -02,  15, -12, -22,  24, -06,  14,  17, -11, -01,  21,  09, -05, -02, -17, -04,  18,  24,  01,  15,  17,  05,  02,  16,  01,  08, -16,  17,  23,  12,  05, -02,  02,  20,  01,  01, -11, -10, -05,  05,  16, -07, -08, -13,  17,  00,  10,  12,  01, -13,  02, -07,  19, -20, -13, -05,  15, -04, -12,  13, -14,  20, -14,  15,  17,  12, -06, -16, -21,  14,  14,  23, -15, -19, -15, -21,  09,  20,  16, -15, -16, -07,  04, -21,  00,  16,  01, -09, -11,  14, -19,  00,  11, -07, -09,  04, -18,  10,  13, -11,  01,  04, -13,  13,  11, -01,  17, -05, -04,  10,  05,  06, -21, -14,  12,  06, -23, -12,  24, -06, -20, -19,  19,  16,  01, -13, -03,  08,  24, -13,  24,  03,  17, -12, -09,  05,  12, -16, -25, -16,  21,  07,  17, -25,  21,  06,  09, -25,  21,  08, -06, -24,  14, -09,  20, -10,  05, -06, -24,  05,  07, -23, -15,  01, -09,  01, -19, -22,  12, -17, -11,  09,  17, -17,  11,  13,  14, -03,  14,  11, -19, -17,  14,  22,  01,  11, -10, -18, -19, -07,  12,  15, -05,  22, -09,  11,  00, -03,  17, -10,  07, -19,  24, -01, -08,  12, -12, -17, -15, -21,  21, -07, -11,  11, -10,  16, -03,  05,  23,  05,  23,  12, -05, -06,  11,  11, -18, -14, -15,  24,  03,  17, -17,  02, -08,  00, -08,  07,  08,  02,  11,  05,  20, -25, -07, -13,  18,  17,  20,  16, -02,  18,  03,  18, -11, -11,  05, -01,  03,  17, -02, -19,  10,  06,  11, -23, -17, -22,  11,  19,  07, -03,  01,  04, -01,  19,  16, -07,  11,  11, -14, -14,  07,  15, -20,  23, -19,  12, -03,  11,  04,  23,  20, -09,  06,  06, -07,  15,  11, -19,  09, -05,  05, -15,  24, -20, -19],
          [-25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([ 17,  00,  19,  06,  11, -19, -12,  03, -12, -12,  12, -25,  13, -02,  06,  13, -07,  23, -06, -24, -07, -14,  14,  00,  20, -16, -18, -18, -15, -13, -10, -22,  14, -15,  09,  01, -09,  24, -19,  06, -11,  18,  08, -23, -06, -11,  17,  12, -11, -13,  16,  10, -02,  05, -13, -04,  17, -06,  05, -23,  07,  21, -20, -02, -19,  16, -24, -01,  15, -17, -18, -18, -24,  15, -14, -03, -21, -21, -13, -04, -09, -22, -19,  16,  10, -07, -13,  02,  12,  18,  05, -04,  16,  12,  20,  24,  06,  23, -02, -02, -19,  05,  05, -15, -03,  17,  07,  01,  21,  19,  24, -11,  24, -20, -20,  10,  00, -05, -13, -12, -10,  19,  11, -19,  09,  08, -20, -10,  07,  05,  13,  15, -13, -06, -25,  09, -12,  10, -13, -16,  04, -13,  00,  06, -08,  05, -09,  20, -23,  05, -15, -08,  02,  21, -02, -14,  07,  03,  01, -11, -15, -09, -21, -03,  10, -18, -17, -25,  17, -04, -16, -02,  08,  11, -19, -23, -08, -03,  22, -06, -20, -16,  14,  07, -19, -13,  18,  15,  18, -04, -21, -22,  14, -15,  03,  02, -06,  11,  02, -12, -18,  14,  14,  17,  00,  20,  22,  19, -05,  21, -09,  00, -19, -20, -18, -11, -08, -23, -21, -13,  00, -15, -09, -11, -05,  21,  16,  17,  07, -04, -20,  17, -15,  21,  11,  10,  17,  08,  05, -13,  05,  21,  14,  13, -22,  21, -23, -05, -25, -19,  10,  02, -09, -24,  18,  13,  22,  12,  07,  06, -17,  13, -02, -07,  09, -15, -20,  03,  20,  10,  17,  02,  08,  06, -10,  13,  02, -08, -16,  04,  00,  21, -17,  18,  22, -23,  09,  21,  14, -09,  04,  22, -19, -22, -08,  18, -10, -03, -04, -13, -15, -11,  15,  20,  20, -20,  09,  00,  00,  20, -19, -23,  16, -10,  23,  15, -08,  07,  11, -17,  23, -10, -18, -20, -05, -01, -25,  12,  23, -04, -25, -17,  12,  17, -19,  08,  24,  15, -15, -01,  12, -07,  04,  03,  08,  02, -07, -23, -16, -19, -13, -16, -02, -06, -09,  21,  20, -09,  10,  19,  15,  10, -21,  02,  02, -15, -13,  02, -23, -03, -22,  14,  16,  09, -08,  01, -14,  12,  06, -03,  20,  18,  09, -04, -12, -25, -08, -17, -06, -21, -21, -16,  15, -16,  11, -06, -06,  24,  23, -03, -02, -21, -14, -09,  13,  06,  20, -23, -05,  01,  01, -07, -06, -15,  14,  09, -12, -17,  20,  07, -13,  24,  16, -21, -17,  04, -01,  03,  05, -01, -23, -19,  03, -10, -01, -08,  23, -06, -06, -06,  22,  20,  12, -06, -17,  03, -22, -04,  11,  23, -22, -25,  23,  21, -20, -19,  02,  06,  11, -17, -20,  15, -11,  09, -19,  13, -22, -21, -15, -01,  00, -18, -04, -13,  01,  04,  15,  07, -25,  03,  05, -20,  04,  05, -22,  09,  14,  06, -08,  00,  16, -03, -07, -18, -17, -01,  20, -14,  05, -18,  10, -19, -10, -18, -07,  18,  13, -14,  00,  16,  14, -17],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24]);
  check([ 23, -05,  13, -23, -19,  02,  10, -02, -20,  01,  21,  00,  08, -21,  24,  05, -07,  04,  13, -20,  12, -20, -11, -17, -25, -22, -06,  03,  19, -15,  11,  17,  08,  01,  21,  14, -19,  06, -12, -12, -16, -16,  13,  19, -10,  12,  00,  10, -07, -10,  16, -17, -03, -20, -09, -01, -15,  12, -23, -19,  22,  15, -24,  05, -08,  22, -03, -02,  06,  10,  11,  17,  21, -01,  12, -12, -12, -11,  24,  08,  04,  15,  18, -22,  22, -16,  02, -17,  21,  07, -11,  21, -03, -10,  03,  14, -10, -25, -11,  21,  10, -23,  15,  08,  03,  02,  22,  18,  16,  21,  04, -03,  13, -03,  00,  10,  07, -20,  20,  03,  12, -15, -01, -16,  02, -20, -24,  17, -20, -10,  15,  18, -07,  06,  01,  21, -15,  00,  17, -23, -02, -04, -01, -14,  18, -23,  24,  00, -18,  19, -19,  19, -19,  07, -22,  11,  12, -21,  03,  18, -03, -04,  11,  17, -21, -11,  15, -11,  15,  07, -09, -10, -22,  18,  02,  22,  20,  03, -01, -23, -01,  05,  21,  06, -12, -24, -06, -25, -17,  24,  20,  07, -05,  08, -01, -01,  23, -11,  16,  15,  22, -18, -20, -23, -23,  09,  24,  22, -13, -01,  24,  12, -19,  22, -05, -06, -24,  16, -03, -14,  15, -08,  18, -14, -24, -08,  12,  24,  06,  03,  16,  05,  13,  23,  08,  15,  08,  09,  13,  22, -15,  14,  11, -08,  14, -17,  13,  15,  24, -15, -24,  15,  03,  21, -24,  04, -12,  15,  05,  21, -06, -02,  02, -18, -04, -13,  22, -21,  23,  12, -21, -14,  02,  15,  03, -09,  24, -07, -17,  23,  04, -14,  13, -16, -18,  16,  15, -03,  07, -03, -07, -24,  20,  22, -15, -07, -14, -16,  00, -15,  22,  04, -04,  01, -06, -24,  19, -05, -04, -21, -06, -25, -10, -16, -14, -01, -24, -24,  21,  08,  00, -09,  11, -05, -11,  23,  16,  00, -18, -09,  12, -19,  20, -15,  07, -09, -12,  03,  12,  10,  07, -19,  12,  24, -10,  24, -02, -07, -23, -04, -24,  05,  13,  14, -25, -21,  14,  18,  06,  22, -16, -04, -20, -19,  06,  15, -02,  22, -07, -15,  07, -22, -07, -04, -23,  10, -05,  03, -21,  00,  24, -18, -20,  14,  24, -18,  18,  13, -24,  02,  12, -13,  23,  18, -06,  06,  08,  17,  03, -22, -21, -15, -19, -03,  07, -16, -16, -21,  12, -12,  06,  13, -02,  13,  03, -03,  23, -02, -15, -24, -25,  23, -12, -25,  18,  07,  07,  01,  01, -15,  06,  05, -02,  13, -21, -20,  24, -11, -14,  13,  04,  20,  03, -23,  08, -17, -01,  06,  07,  12,  09,  09,  10,  23,  10,  05,  07, -06, -17, -14,  04,  14,  18, -23,  04,  23, -16,  05, -11, -02, -07,  20, -07,  24,  23, -22, -18, -01,  12,  16, -14, -04,  01,  23, -04, -12,  03, -19,  09,  11, -08, -12,  03, -15, -07, -18, -15,  04,  13,  01, -21, -17, -03, -03, -16, -03,  03, -08,  23, -10, -17, -15],
          [-25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([ 13,  11, -15, -15, -24,  16, -09,  10,  04,  10, -24, -18,  20, -04, -08, -17, -25, -18,  11, -18, -10, -17,  06,  00,  07, -16,  19,  06, -01, -21,  18, -10,  16, -20,  00,  19,  21,  18,  05,  01,  03,  08,  10,  00, -21, -21,  10, -19, -14, -03, -12,  04,  07,  20, -19, -10, -21, -25,  23,  06, -21,  16,  21,  22,  21, -02,  19,  20, -09, -01, -02,  21, -16, -17, -04, -12, -12, -18, -06,  01,  06,  08, -20, -12,  03, -14,  05,  07, -12,  03, -10, -05, -04, -14, -08, -05,  09, -14, -08, -23,  12,  15,  23,  21, -25, -03, -14, -10,  06,  06,  17, -13, -11,  24,  02,  19, -12, -17,  03,  01,  13,  19,  21, -13, -18, -09,  09,  19,  04, -22,  21, -06,  18,  22, -10,  20, -06,  04, -12, -23, -15, -18, -09,  01, -19,  18, -05, -06, -22,  23,  23,  19,  19,  19, -17, -23, -15,  17,  21,  17,  20,  19, -14,  15,  16,  03,  12, -13, -18, -25, -09, -08, -16,  07,  18, -09,  01, -10,  12,  06, -09,  10,  02, -15,  07,  10, -11,  19,  04, -13,  11,  01, -18,  24, -07, -25,  03, -19, -10,  10, -17,  06, -22, -07, -11,  23,  11,  17, -09,  00,  00,  07, -14, -22,  19,  20,  13, -14,  16, -05, -02,  03,  21,  07,  02, -10,  08, -18, -02, -25,  18,  06,  06,  23,  24,  22,  23,  12,  16, -11, -12, -06,  23,  01, -03,  18, -04, -13, -21, -13,  07,  04,  17,  06, -13, -03,  21,  20,  04, -04,  22, -03, -23,  05, -03, -21,  05, -04,  16, -04,  10, -21,  17,  09,  05, -09,  04, -24,  04,  10, -09, -12, -11, -15,  21,  01,  09,  19, -02, -11, -10, -05,  13, -07, -24, -14, -03,  06,  09, -12, -21, -06, -05,  24, -20, -25, -10,  11, -21,  21, -04, -03, -13,  11,  07, -17, -11, -08, -22,  13,  08, -05, -15, -04,  13, -12,  09, -13,  21, -05,  03, -22,  15,  23, -23,  22, -25, -08,  09, -21, -09, -18,  01,  03,  20, -14,  11, -15,  03,  16, -25, -12, -13, -15,  11, -23, -01, -04, -08, -03,  16,  20,  00,  08,  20,  02,  08,  20,  22, -06, -23, -12,  01,  05,  18, -03,  16,  04,  09, -04, -02,  09,  09,  12,  21, -04,  14, -03,  19, -19,  20,  12, -22, -05, -02,  23, -25, -19,  21,  24,  02,  23, -11, -22,  03, -18,  02, -05,  13, -14,  18, -12,  22,  03, -25,  19, -24,  15, -09,  22,  23, -12,  09, -23,  11, -16, -23,  13, -08,  23,  12,  19,  21, -22,  23,  00, -13,  02,  22, -25,  16,  17, -11,  13, -03, -09,  09, -02, -19, -24, -03, -18, -09, -18, -16, -23, -07, -14,  15,  11, -15,  04,  05, -17,  07,  05,  10,  21, -17,  09,  22,  24,  02, -12,  14,  24,  04, -01,  00,  13,  02,  22,  20,  18, -19, -19,  21,  00, -08,  13, -14,  04, -05,  18,  15, -23, -01,  00,  24,  07, -13,  23,  08,  14, -12, -03,  15,  17,  21, -10,  05, -02],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([-10,  02, -08, -04,  08, -10,  21, -22, -22, -16,  09, -02, -22, -01,  03,  02, -23,  04, -14, -11,  04,  19, -20,  17, -07,  20,  11, -10, -12, -06,  13,  03,  21, -18,  24,  07, -01,  23,  12,  03, -18, -04, -22, -13,  23,  08,  16, -23, -11, -21, -07,  18, -25, -02,  12, -06, -07, -01,  09,  08,  20, -01, -14,  16,  09, -14,  00, -17, -14, -13,  13, -07,  11,  17,  08,  09,  02, -01,  13,  19,  04, -19,  12,  04,  04,  02, -25,  24, -22,  09,  08,  23, -14,  19,  16,  20, -18, -08, -22, -07,  04,  17,  14, -10,  11, -03, -24, -10,  23,  16, -16,  04,  22,  24, -14,  03,  01, -14,  05,  04,  23, -12,  04, -16, -16, -05, -21, -06,  12, -16,  14, -06, -22,  03,  11,  14, -23,  13, -20, -22,  04, -09,  09,  04, -10,  20, -18,  16, -16,  12, -03, -18, -23, -24, -09, -11, -01, -03,  08, -14,  08, -03,  05,  12, -22, -08,  03, -18, -18,  10, -15,  13, -23,  20, -06, -08,  17,  04, -14, -24, -09,  10, -17, -04,  14,  01,  10, -12, -25, -05, -01,  09,  19, -18, -02,  22,  01, -24, -18,  10,  12, -08,  00,  14, -11,  20, -17, -18, -01, -06, -17,  17, -20, -06, -12,  19,  22, -25, -18,  23, -05,  08,  09, -10,  17, -16, -11, -05, -15, -04, -20,  24,  16,  08,  15, -18,  03,  24, -11, -21, -05,  00,  21,  00,  21, -13, -04,  18, -13,  05,  18,  10, -09,  04, -23, -17,  13, -07,  06,  24,  17,  13, -25,  10, -04,  16,  17, -24,  17, -16, -20, -13,  09, -21,  15,  07, -09, -14,  02,  05,  19, -04, -08, -15, -23, -06, -05,  16,  15, -24,  17,  07,  15,  17, -08, -12,  10, -16, -10,  02, -05, -05,  17, -19, -01,  07,  13,  17,  20, -09,  00,  14,  14,  17, -24,  16, -13, -03,  09, -23, -02,  01,  11, -10, -06, -22,  04, -19, -11,  19,  09,  10, -09,  01,  16,  18, -15,  07,  10, -20, -25, -15,  22,  14, -22,  23,  07, -08, -05, -08, -04,  21,  18, -18, -12, -11, -13,  17, -04,  03,  13, -18, -12, -20,  10, -18,  23,  22,  14,  10, -23,  14,  23, -24,  05, -22, -25, -13, -03, -03,  06,  18, -05,  00, -23,  09,  16, -11,  01, -11,  19, -10, -02, -17, -03, -17, -08, -05, -20, -17, -18, -15,  22, -20, -12,  04, -17, -12,  18,  05,  13,  00,  00, -17, -23,  02,  17,  18,  18, -06, -15,  13,  11,  08,  23, -17,  19, -08,  05, -24,  00,  12, -12, -01,  20,  02, -22, -20,  17,  23,  13,  05, -02, -12,  14,  00,  18,  06, -04,  13, -23,  08,  03,  15, -07,  03, -25, -13,  20,  05, -09, -03, -05,  04,  21, -08, -17, -24, -03, -24, -25, -15,  06, -02,  01, -03, -24, -04, -19, -01, -14, -17, -18,  17, -24,  00, -03, -24,  15, -05,  07, -17,  17, -21,  14,  16, -04,  23,  17,  20, -24,  19, -19,  09, -05,  09, -18, -04, -18, -12,  22, -05],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24]);
  check([-02, -19, -11,  01,  08,  12,  03,  00, -18, -13,  08,  24, -09, -02,  17,  12, -02,  10,  09, -01,  06,  15, -17, -24,  01, -08, -01,  10,  07, -04, -17, -17,  04, -03,  09, -12, -16, -13,  13, -07, -01, -03, -05,  17,  22, -13,  06, -05,  24, -09,  19,  06, -17, -21,  07,  12, -01, -18, -03, -19,  05,  05, -11, -15, -20, -24, -02, -09, -12, -12,  10,  15,  12, -18,  07,  09, -06, -11, -21, -06,  05, -25, -23,  13, -18,  09,  00,  06,  18, -25,  14, -01,  07, -21,  11,  14, -20, -16, -19, -05, -03,  18, -15, -15, -25,  20,  21, -06, -16, -22,  15,  16, -20,  17,  06, -13,  04, -16,  20, -03, -16,  10,  23,  18,  16,  09,  08,  23,  20,  16, -07, -05,  09,  06,  07,  09,  01,  03, -22,  10,  06,  21,  03,  14,  13, -16, -24, -06, -07,  24,  19,  04,  09,  17,  00,  02,  04, -15,  00, -01, -24,  18,  21,  10,  01,  03, -06, -23, -18, -01,  14,  15, -03, -08,  04, -12,  02,  08,  07,  22,  07,  01,  04, -07, -04, -21,  20, -23, -09, -03,  03, -08, -08,  00, -21,  19, -22,  00,  21, -13, -24,  11, -22, -01, -22,  09,  12,  07, -08, -06,  07, -24,  23, -14, -04, -04, -08, -07,  00,  10,  15, -22, -23, -17,  05, -17, -23,  09,  08, -25,  23,  09,  11, -22, -15,  17,  13,  22,  01, -18, -06, -17, -14, -06, -04,  07,  15,  15, -24, -10,  02,  16, -05,  06, -24, -24,  14, -22,  12, -01, -21,  10, -14,  17,  16, -04,  11,  04, -06, -12,  13,  15, -02,  24, -16,  22,  07, -24,  14,  10, -07, -08,  01,  15,  23,  03,  16,  13,  08,  03, -13,  14, -09,  00,  09, -18,  22, -05,  13, -07,  10,  01, -17, -16,  03, -06, -19, -15, -05,  22,  22,  15, -11, -02,  05, -12, -22, -01, -22,  14, -21, -08,  03, -05,  18, -13,  04,  15,  10, -08, -17, -05,  21, -07,  04, -01,  14,  12,  11, -14,  10,  08, -24, -24, -17,  08, -11, -11, -18, -06, -22, -13,  12,  06,  09,  05,  21, -11, -05,  06,  08,  05, -24,  06, -25,  08, -18,  14, -03,  20, -25, -16,  05, -22, -14,  14,  11,  02, -22,  21,  22, -17, -17,  09,  16,  19, -11,  12, -17,  11, -05,  19, -07, -01,  00, -05, -16,  10, -16,  06,  05, -14,  16, -14, -09, -21, -23, -23,  06, -18, -25,  03, -10, -17, -13, -19, -20,  03,  21, -12, -09, -07, -16,  09,  19,  12, -21, -22, -03, -10,  12, -23,  03,  05, -12,  19,  09, -08,  24, -10, -01,  24,  19,  14, -15, -17,  23, -10,  14,  19,  05, -20, -13,  17,  17, -18,  04,  23, -13, -24, -11,  24, -20,  19,  04, -04,  16, -12,  13,  15,  06, -12,  16,  02, -21, -22,  10, -23, -05, -01,  21, -24,  07, -14,  20, -01, -05, -01, -03,  09,  02,  13,  09,  09,  08, -10, -20, -01,  06,  21, -09, -13, -16, -16,  16, -12, -12,  01, -07,  08, -22, -09],
          [-25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24]);
  check([ 11,  10,  04,  06, -14,  24, -20,  08,  11,  09, -01, -05, -06, -16,  12, -01,  10, -07, -05, -24,  07,  06, -15, -02,  22, -02, -23, -10, -16, -18,  06,  20,  19, -14,  02, -20, -13,  09,  15,  23, -06, -09, -05,  13,  00, -17, -11, -15,  03,  12, -14, -12, -07, -01,  13, -10,  24,  17,  07, -17,  24, -11, -21,  20,  02,  08, -25,  14, -08,  18,  15,  11, -16, -15,  01,  12, -05,  16,  22, -24,  03, -14, -11,  21,  10, -21, -11,  11,  22,  21,  20,  23, -13, -24,  19,  14,  09,  21,  04, -24,  16, -06,  13, -22,  06, -11,  15, -23, -18,  14, -22,  10, -25, -06,  09,  12,  00,  23, -01, -01,  21, -04, -02, -16, -03, -06, -25, -19, -10,  06, -18, -16, -25,  22, -13,  09, -11, -23,  13, -04,  16,  18, -16,  19, -11,  18,  06,  14,  18, -18, -11,  16,  05,  14, -23, -23, -15, -22, -17,  02,  09, -07,  11,  12, -10,  23, -04,  06, -25, -16, -22,  19, -23, -11,  13, -09, -16, -04, -18, -23,  06, -02,  20, -14, -11,  23, -11, -01, -24, -01, -23,  12,  17,  13, -01, -15,  14,  22,  16,  14, -17,  21,  10, -13, -15, -02,  05, -06,  22,  13, -02,  03, -12, -04,  16,  03, -06, -18, -21, -03,  07, -17, -16,  01,  24,  11,  11,  13,  08,  05,  04,  17,  03, -10, -21,  14,  15,  12, -15,  12,  00,  11, -08,  15, -18, -16, -05,  03, -09,  00, -25, -25,  08, -16,  02,  07,  22, -10, -05,  06,  20, -25,  00, -01, -10,  06, -10, -18, -07,  02,  20,  20, -10, -11,  11, -01,  00, -19, -23,  17,  08, -21,  19, -08, -09, -04, -24, -12,  12, -03,  19,  09, -01, -06, -15,  16, -22,  02,  23, -04, -18,  20, -06, -01, -15, -20,  24,  10, -12, -22,  04,  22, -17, -01, -09, -01,  22, -08,  12,  11,  16,  07, -02, -08, -22,  08, -15, -19, -12, -16,  05, -03, -19,  24,  21, -07, -19,  20, -19, -04,  24,  12, -05, -16, -14,  11,  08, -14, -19, -05,  22,  22, -21, -05, -08, -15, -19,  02, -07, -04,  13,  23,  18,  20,  24,  14, -12, -18,  12, -04,  04,  11, -16,  24,  20, -03,  13,  05,  08,  19, -25,  08,  18, -18, -20, -15, -08, -14,  15,  10,  09,  03,  11,  02,  00,  12, -08,  16,  20, -21, -13,  01,  17, -04,  02,  14,  19, -10, -06,  04, -14, -04, -13, -20,  03, -07, -08,  22,  06, -16,  10, -09,  13, -04,  20, -12, -15, -13, -21, -20, -07, -06,  08, -13,  15, -14, -22,  11,  01, -01, -09,  15,  21,  05,  22,  01, -25, -11,  01,  09,  01, -14, -25, -11,  07,  22,  04,  17, -15,  11, -25,  05, -20,  08,  20,  22,  21,  23,  11,  00, -02, -21, -10, -06,  09, -13,  22,  12,  03, -02, -04, -21,  09, -02, -05, -07, -05, -25, -12,  07,  13, -10, -10,  20, -25, -15,  19,  22, -17,  05, -03,  06,  09,  12, -23, -04, -24, -23, -15,  04,  02,  06],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([ 09, -11, -19, -21,  07,  03, -19,  22, -14,  21, -13,  03,  16, -12,  13,  11, -13,  21, -09,  09,  05, -22, -02,  09,  01,  01,  11,  11, -20, -09, -06,  16,  05,  00,  23, -13, -22, -19, -13, -09, -22,  01,  19,  19,  16,  09,  05, -22,  08,  24,  14, -12, -21, -11,  24,  05,  15,  13, -09,  21, -21,  10,  14,  09, -15,  12,  23, -10,  21, -15,  09,  24,  14,  03,  18,  05, -12,  01,  09,  21,  02, -02, -14,  06,  15, -15, -14,  05, -25,  02,  03, -21, -13, -07,  15, -01, -18,  14,  16, -22, -24,  00, -23,  15, -21,  23, -02, -06,  01, -18, -08, -22,  07,  03,  09, -03,  15,  20, -20,  18, -01,  08,  22,  13, -22,  13, -13, -12,  04, -22, -09,  05,  04, -04, -02,  10, -04,  21, -19,  22, -20, -02, -23,  14, -22,  11, -13,  20,  08, -06,  13, -18, -23,  11,  20, -19,  01, -16, -06, -20, -11,  12,  12,  20, -15, -13,  05,  08, -17,  13,  07, -10, -14,  09, -20, -09, -05, -06, -13, -20,  13, -23, -11,  15,  15, -16,  23, -09, -05, -06, -02,  10, -16, -12,  05, -04,  00, -12, -20,  11, -24,  12, -24, -10, -03, -19,  06,  19,  00,  20, -23, -12,  23, -09, -19,  15,  03, -21, -18,  23,  01,  07,  10,  10,  20, -07, -19, -04,  08, -12, -18,  09, -24, -15, -24,  00, -08,  10, -04,  17,  05, -02, -17,  05,  15, -11, -04, -07, -05,  05, -07,  21, -13, -21,  08, -15, -01,  17,  08, -18, -20,  17,  18, -17, -23,  20,  10, -04,  07, -18, -11, -13,  07, -01,  20, -01,  13, -07,  17, -17,  23, -12, -20, -13, -06,  15, -03,  18,  07, -18, -23,  15,  24,  20,  23, -21,  17,  11,  00, -01,  20,  16,  14,  02, -10,  11, -23, -22, -21,  21, -11, -23, -16, -04, -09,  03, -14,  16, -02,  19,  23,  00,  11, -25, -02,  09, -19, -10, -03,  06,  17, -08, -02,  06,  20,  15, -08,  24,  21, -02,  20, -15,  02, -20,  06,  18,  10,  19,  09, -14,  15,  08,  11,  01,  10, -16, -12,  16,  02,  10, -01, -06, -22,  24, -23, -25,  15, -04,  24,  11,  19,  19,  21, -04, -24,  04, -11,  14,  00, -24, -25, -09,  11,  11,  17, -04,  23, -20, -11,  00,  18,  13,  21,  21,  13,  23,  21,  03, -06,  20, -09, -10,  16, -11,  11,  18,  20, -23,  07, -05, -22,  07,  11,  16, -05,  06, -13, -05,  11,  03,  22,  06, -08,  18,  02, -20,  18,  00,  10, -13, -03, -24,  04, -11, -08, -10, -16, -13, -05,  16,  07,  00,  00, -06, -08,  22, -25,  06, -07,  13, -15, -08, -05,  02, -14,  24,  09, -21,  00, -04, -06,  24, -01,  23, -12,  16, -09, -03, -22,  13, -10,  10, -12,  17, -19,  07,  15, -17, -11, -15,  22,  01,  02, -06, -20,  15, -07,  14,  22,  20, -13, -07,  20,  11, -07, -15,  02,  11,  08,  05, -01, -25, -08,  15,  18, -01, -01,  08,  07,  13,  20,  06],
          [-25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24]);


//length == 513
  check([-01, -23,  23,  05, -25,  10,  15, -25,  08, -22, -24,  10,  17,  05, -02,  20, -19,  06,  07,  12,  24, -12, -06,  19, -13, -03,  00, -21, -18,  11, -10,  08,  13, -12, -09,  13, -24, -19,  14,  09, -16,  17, -04, -22,  00,  20, -24,  06,  03,  08, -07,  02,  23,  15, -02, -13, -13,  23, -08, -03,  12,  07, -20,  00,  22, -04, -11,  23,  02, -20,  10,  14,  24, -19,  19, -01, -22,  20, -18,  07,  05,  03, -14,  05, -05,  10,  18,  07,  10, -13, -19, -03,  21, -13, -25,  18,  10, -11,  19, -12, -04,  06, -21, -05,  12, -25,  22,  18,  21, -19,  02,  03,  09,  13, -14, -21,  00, -19,  14, -14, -05,  20,  10, -09, -16,  10, -14,  20, -24, -18, -15, -01,  13, -09,  20,  03, -09,  19, -04, -11, -23,  23,  18,  12,  11, -19,  18, -13, -13,  09,  00,  09,  07, -13, -25,  16, -25, -12,  13, -24, -04,  23,  01, -14, -11, -02,  14,  06, -06, -15,  20, -04, -17,  15, -15,  22,  23, -19, -14, -13,  15,  13,  21, -03, -25,  21, -09, -25, -13, -21, -21,  10, -20,  07,  21, -04, -18,  11, -23,  03,  21, -25, -24, -18,  17, -13, -21,  16, -07, -10, -22, -15, -20, -25,  10, -20,  23, -24, -17, -15, -18, -11,  20, -13,  23,  19,  11, -18,  05,  13,  10,  03,  15,  11,  12,  10, -25,  18,  01, -05, -15,  06,  06, -10,  08, -07, -04,  07, -06,  06,  19,  03,  22,  17,  18,  20,  11,  04, -23, -07, -06,  14,  23, -13,  02,  11,  22,  03,  04,  00,  23,  15, -19,  06, -20,  17, -24,  03,  01, -03, -14, -05, -24, -17, -11,  19, -20, -23,  00, -16, -05,  19,  23, -06, -19,  01, -18, -20, -19,  11,  05, -19,  03,  14,  13,  11,  06,  16, -11, -16, -11,  01,  06, -10,  11,  21, -14,  17,  23,  11, -24, -04,  07, -25,  17,  16,  03,  24,  21,  09,  12,  02,  15, -07, -07,  05, -21, -24, -03, -05, -15,  11,  23,  16, -22,  10,  12, -11,  04,  13, -23,  05, -14,  09,  07, -22,  02, -13, -21, -01,  21,  18, -22,  14, -14, -04, -04, -08, -03,  18,  13,  07,  06,  11, -02,  09, -02, -12, -25, -23, -22, -23,  10, -11,  14, -08, -06, -09,  05, -02,  17,  03, -07,  20, -06,  07, -09,  16,  24,  13,  11,  14, -03, -07,  03,  21, -21, -24, -14, -20, -19, -11, -16,  16,  03, -25, -15,  22, -06,  17, -03, -14, -04,  15, -18,  17, -03,  00,  08, -03, -09, -05, -12,  13,  15,  16,  11,  19,  20,  22, -24, -24, -14, -12,  19,  16, -12, -21,  15,  09,  22, -13,  21, -05, -22, -20, -11,  02,  05,  23, -24,  21, -07, -10,  12, -15, -19, -02, -21, -24, -04, -17, -21,  09, -04,  23,  01,  11, -20, -09, -04, -21,  06, -06, -01,  11, -01,  15, -12, -19,  13, -10, -20, -17,  05,  17, -07,  13, -10,  00,  17,  13,  08,  21,  00, -21,  22, -24,  15, -23, -06, -12, -19],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24]);
  check([-23,  07,  07,  13, -17, -03, -23, -10, -14, -08, -03, -04,  24, -11,  15,  14,  06, -10,  06, -05, -25,  05,  22, -21,  02, -25,  21,  04, -06, -13,  10, -01,  19, -08, -13, -20,  14, -11, -03, -23,  08,  19, -01,  09, -15, -09, -01,  16,  08, -20, -12,  08,  10, -15,  14, -13, -15,  12,  18,  07,  24,  03, -19,  21,  20, -07, -24,  12,  10, -02,  14, -05, -06, -10, -20,  04,  06,  06, -05, -11,  11,  11,  22, -01,  21,  11,  13, -16,  01,  09,  18,  00, -13,  24, -04, -15, -06, -01,  24, -19,  24,  13,  02, -07, -21,  09,  22,  12, -10, -05, -23, -22, -19,  24,  04, -21,  13, -05, -10, -11, -21, -17,  16, -09, -18, -10,  03,  04,  14,  02,  10,  16, -07, -11, -16, -01,  23, -16, -14, -10,  04, -12, -06,  12, -10,  23,  16, -22, -07, -18, -06, -03, -10, -15,  16,  00,  00, -06, -19, -08,  22,  18, -17, -10, -17, -08,  16, -17,  03, -23, -01, -18, -09,  20,  21,  06,  18,  15,  11, -11,  24, -20,  13, -09, -08,  04,  16,  18,  24,  22, -13,  23,  16, -05, -10, -24,  14, -19, -16, -07, -17,  10,  02,  01,  05, -01, -16, -01, -11,  20,  15, -12, -23,  03,  04, -05, -17, -02, -10, -16, -03,  02, -16, -10,  24, -01, -07,  13,  07,  03, -17,  17, -10,  13, -06,  21, -11,  03, -03,  05, -01, -13,  20,  01,  17,  01,  23, -25,  24, -12, -14, -01,  15, -05,  16,  14,  19, -15,  05,  03,  15,  15, -04, -20,  03,  15, -24,  19, -05,  00, -01,  21,  14, -06,  00,  07,  21, -02,  07,  22,  12,  21, -02,  04, -09, -10, -04, -12,  00, -24,  16, -10,  18, -11, -05, -01, -21, -01, -07,  00,  24,  18, -02,  14, -13,  23, -04, -15, -03, -20, -15, -14, -22,  08,  15, -05,  23, -14,  10, -02, -11,  03,  15, -17,  18, -12,  07,  24,  12, -25,  01,  13,  20, -25,  04, -17,  23, -23, -05, -05, -15,  05,  06, -12, -11, -01,  10, -11,  10, -05,  15, -25, -24,  05, -15,  19,  18,  17,  18,  07,  19, -05, -04,  15, -03, -23, -25, -05, -20, -05,  18, -10, -22,  01,  03, -06, -25, -09,  08,  11,  13, -02,  13,  14, -19,  23,  08,  24,  17,  04,  09,  11, -24, -18,  03, -02, -16,  03,  20, -11, -24,  13,  06, -21, -10, -15,  00, -10,  03, -17, -22, -09,  09,  18, -19,  15,  16,  16,  16,  10, -05,  00, -01, -02,  07, -23,  23,  17,  06,  19, -17,  07,  09,  15,  13, -24, -23, -12, -06,  05, -02, -03,  21, -18, -09, -23,  22, -16,  19,  16,  22, -09, -09, -04,  17,  24, -02,  17,  18, -21,  11, -24,  13, -02,  16,  03, -01,  18,  18,  18, -02, -08, -07, -05,  01,  11, -01,  01,  22, -05, -08,  19,  14,  08, -10,  06,  09,  14, -02,  02,  20, -13,  04,  11,  12, -03, -11, -14, -09, -17, -18,  16,  02,  00, -14, -22, -14,  13,  06, -17, -17,  23, -22],
          [-25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([ 24,  09, -05,  05, -07, -16, -19,  21, -18, -05,  02,  18, -18,  24, -16, -07, -08, -08,  00, -16,  21, -23, -03, -23, -10, -15,  08, -01, -04,  09,  04, -05, -07,  24, -22,  11, -14, -16,  09, -07,  04, -14, -12,  13, -12, -03, -19,  05,  17,  09,  14,  13,  11, -11,  17, -23, -01,  03,  03,  22, -13, -16, -07,  07, -15, -04, -07, -02,  07, -20,  18, -12, -07, -19, -24,  06,  04, -16, -11, -04,  18, -22, -14,  07, -08, -19,  11,  19,  09, -09,  16,  23,  00, -14,  05,  10,  07, -25, -14, -09, -20, -21,  04, -01, -14,  05, -20,  17,  15, -06, -10,  10,  00,  01, -08,  19,  09, -20,  15, -07, -04,  07, -07,  21,  18,  23,  09,  03,  24,  20,  19, -19,  24,  01,  05, -13, -19,  13, -21,  23, -16, -06,  09,  11,  23, -22,  06,  07, -16, -02, -22,  05, -18, -04,  04, -24, -03, -10,  06, -02, -15,  02,  04, -14, -22, -13, -01, -15, -25,  03, -15, -16, -25,  19,  23,  23, -25,  06,  07, -16, -21,  10,  16, -13, -16, -05, -10,  08,  10,  21, -19,  22, -02,  12, -14,  02,  24,  10,  14,  24, -10,  24, -14, -10,  21, -14, -10,  23,  17,  23, -18,  21,  10, -25, -17,  19, -04,  00,  02, -17, -04,  10, -17,  22, -02, -06,  01, -03, -19, -08, -01, -04, -09,  12,  14, -11,  23, -19, -13,  17, -21, -04,  13,  17, -03,  24,  13,  20, -01, -07, -20,  23, -22, -12,  22,  01,  09, -02, -24,  15,  15,  02, -11, -17, -09, -22,  00, -09, -16,  14, -17, -09, -14,  21, -17,  10,  22,  21,  07, -01, -11,  12, -03, -05, -22, -04,  23,  14,  19, -24,  05,  11,  03,  19,  19,  21,  24, -04, -13, -17, -14, -05,  01, -01, -06,  11, -16, -09,  10,  18,  15, -24,  07, -11, -04,  12,  10, -03,  02,  06, -02, -18, -08, -21, -22, -11, -25, -23,  10, -12, -13,  21,  08,  14, -03, -23,  02,  08, -04, -13,  01, -12, -09, -16,  03,  12,  21, -10, -14,  00,  22,  10,  09, -09,  14,  12,  05,  14,  14, -07, -21, -23, -09,  15,  18,  14,  17, -03, -03, -10,  10, -24,  04, -24, -15, -16,  15, -17,  01, -21,  11, -02,  14, -05,  17,  05, -17, -03, -04,  24,  17,  01, -22, -16, -09,  21,  23, -15, -04, -03,  01, -19, -02, -18, -16,  10, -07, -24,  21,  19, -20,  07, -05,  21, -23, -13,  01, -13,  11,  23, -13,  04,  01, -08,  13,  17, -09,  13, -21,  12, -15,  07,  18,  09,  14, -21, -04, -18, -18, -08, -23, -10, -24, -01, -14, -19,  11,  13, -07, -03,  13,  07, -24, -11, -25,  16, -19, -09,  04, -13, -20,  15,  20, -25,  01,  11, -21,  22,  19, -12, -08,  23,  03, -07, -03,  15, -01, -15,  03,  18,  09, -07,  02,  11,  07,  04,  04,  15,  22, -16, -23, -23, -24,  22, -23,  02,  09, -17,  01,  05, -03,  18,  05, -25, -13, -21,  15,  11, -11, -05,  06,  23,  13],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([-14,  11, -03,  15, -09, -13,  13,  02, -10,  17,  03, -13,  20, -18,  23, -20,  10,  03,  02,  04, -15,  05,  18, -11, -05,  04,  03,  18, -12,  02,  08, -01, -10, -19, -11,  06, -07, -21, -17,  10,  24,  13, -25,  21,  22,  23, -24,  08,  04,  04, -11,  14, -16, -18, -21,  06,  11,  07,  01, -24, -14, -13,  00,  02, -07,  17, -15,  13,  23, -04, -01,  22, -14, -01,  18, -16, -01,  20,  17, -22,  01, -19,  18,  12, -10,  24, -05, -24,  08,  22, -20,  20, -14,  05, -01,  04, -01,  09, -06, -02, -20,  20, -03, -08, -06, -09,  03,  19, -12, -03,  24,  14,  05,  19,  03,  20,  18,  23,  23,  02,  22, -22, -01, -17,  09,  23,  14, -15,  07, -16,  08,  15, -21, -19, -16,  01, -01,  14, -03,  14, -14, -04,  05,  16, -09, -17,  13, -14, -19,  11,  13, -19,  15, -13, -11,  01, -13, -21,  11,  22, -10, -03,  12, -06,  05,  23,  22, -19,  12, -06,  20, -25,  18,  00,  16, -16,  08,  06, -03,  16, -08, -12,  22, -16,  02, -11,  10,  15, -05, -01,  12,  10,  21,  01, -19,  03, -01, -21,  09, -12, -02,  04, -12, -09, -19, -19,  02,  14,  12, -25,  07, -21, -12,  07, -11,  17,  21, -24,  07, -09,  00, -06, -24, -02,  20, -16, -22, -04, -12,  12,  09,  12, -07,  22, -20, -01, -20,  08, -10,  17,  10,  23,  24, -25,  05, -10,  17,  03, -09,  02,  21,  19,  21,  24, -06,  19, -17, -02, -10, -03, -13, -25, -14,  08,  24, -09, -18, -20, -24, -02,  22,  13, -02,  23,  15, -20, -12,  10,  08,  07, -13,  06,  03, -17,  05,  24, -21,  13, -01, -05, -15,  12, -05, -04, -05, -04,  15,  04,  01,  18, -21,  01,  07,  02,  01, -03,  09,  15, -18, -06, -01, -04, -25, -21,  07,  05, -22,  11, -06,  03, -19,  06, -08,  03, -22,  14, -25,  20, -07,  03,  13, -02, -21, -03, -23,  06,  20,  12, -02, -21, -19,  24,  03, -18, -22, -15,  12, -17,  21, -17,  13, -22,  15, -20,  06,  18,  19,  08,  15, -10, -13,  03,  13, -07, -24,  15,  24,  23,  04, -01, -21,  11, -02,  07,  20,  03,  19,  07,  12,  16,  16,  00,  21,  06,  08,  04,  01,  02, -12, -07,  19,  00,  21,  07,  18,  24,  00,  20,  24, -19, -04, -19,  17,  20,  15,  12,  00,  10, -03, -13,  01, -10,  15, -01,  23, -02, -22,  01, -23, -09,  19,  22,  18,  17,  06,  14,  17, -17,  09,  18, -10, -18,  24, -16, -23,  17,  22,  03,  02, -04,  17, -20,  13,  09,  04,  11, -18,  07, -11, -13, -24, -17, -14,  19, -23,  17,  08,  21, -24, -06,  15, -07,  02,  16,  02,  06,  08,  01, -14, -13,  24, -21, -08,  12,  15,  23,  00,  23,  06,  14, -13,  09,  24, -02,  03, -23, -08, -11, -25, -05,  08,  15,  13, -13,  09, -09,  19, -08,  19, -18,  05,  19, -12,  24,  06, -21,  23, -16, -23,  06, -25, -09, -10],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([-25,  14,  20, -21, -17, -16, -21,  04,  20,  22, -08, -16,  06,  10, -22, -25,  05, -14,  05,  01, -01,  07, -18,  03,  07, -09,  07, -12, -06, -25,  05, -06,  16,  00,  00, -25,  12,  06,  04,  09,  03,  23,  18, -14,  09,  24, -13, -09, -13,  19,  17,  13,  03, -24, -06, -15, -05, -24, -02,  14, -21, -20, -15,  20,  08,  10,  20, -03, -07, -01, -19,  24, -02, -24, -15, -16, -25, -01,  00, -13, -04, -08, -24,  24, -05, -05, -15,  15, -02,  10,  04,  02,  18,  14, -02,  01,  01, -05,  23,  20,  20, -19,  19, -05, -18, -19,  04, -17,  08, -19, -05, -21,  00, -02, -20,  20,  20, -08,  11, -06, -20, -08,  23,  23, -18, -02, -01,  10,  19, -01,  05,  16,  05,  01, -12,  12,  10,  19,  22, -07, -25, -05, -01,  00,  18,  04, -03,  14,  24, -17, -15, -21,  01, -17, -21,  10,  09,  05, -05,  03, -21, -22, -04,  11,  04,  09,  00, -11,  03, -02,  09,  03,  20, -17, -20,  13,  15,  02,  04,  14,  13,  16,  20, -09, -23,  24, -22,  11,  06,  00, -11,  12,  03,  12, -02, -15, -04, -25, -01,  24, -02, -14,  04, -07, -06,  11, -16, -14, -10,  15, -23, -22,  07,  22, -04,  09,  23, -01, -03,  04, -25,  11, -09,  05, -02,  16,  15,  21,  17, -08,  22, -08,  03,  01,  13,  24, -11,  24, -14,  04,  14, -12,  10, -02, -12, -19, -16, -14,  08,  06,  18,  10, -06, -14, -10,  19, -20, -19,  15,  22,  00,  12, -11, -22, -10, -21, -23,  04, -22, -10, -14,  20,  04,  21, -07,  17, -23,  05, -20,  12, -12, -25, -03,  08, -13,  15,  02, -08,  21, -05, -09, -02, -16,  05,  01,  00,  12,  05, -19,  15,  21, -08,  10,  00, -12, -19, -06, -07,  11, -01, -18,  24,  00,  05,  09,  14, -05, -11, -17, -07,  09, -01,  16,  18, -19, -06, -05,  18, -24,  04,  09,  22,  21, -06, -01, -13,  02,  20,  07, -12, -05,  14, -10,  22, -04,  24,  13,  18, -12,  21, -14,  24, -05, -21,  18,  01, -02, -10, -05,  00,  19, -19, -01,  18,  00, -24, -18, -22,  21,  16, -07, -07,  05,  08, -10, -21,  10, -20,  22,  23, -24, -16,  23, -04, -10,  18, -25,  16, -17, -05, -07, -20,  01,  17,  23, -22,  18, -18, -17,  17,  23,  04, -15,  05, -13,  01,  09,  24,  06,  09,  23,  10,  20,  23, -17, -15,  18, -17, -24, -24,  05, -04, -17, -17, -09, -19, -13, -16, -12, -03, -24, -12, -24, -11,  19, -09,  15,  05, -10, -02, -11, -10, -15, -16, -10, -06, -05, -17,  02, -02, -13, -17,  20, -05, -09, -14,  04,  05, -03,  19, -20,  01, -17, -17,  15, -23, -01,  07,  09,  17, -18,  24, -16, -07, -17,  00,  12,  05,  10, -09, -21,  22, -01, -24, -05,  18, -11,  24,  00,  11,  18,  05, -11, -24,  14, -21, -20, -10,  13,  15, -16,  21,  16, -06, -09,  24,  21, -20,  05,  06, -04,  11,  06],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([ 23,  12, -24,  18, -24, -25, -07,  14,  20, -24, -21,  24,  17, -15, -19, -16, -24,  23, -06,  24,  14,  13, -10,  14,  09, -05, -04, -08,  16, -18,  23,  16,  21,  24,  09,  24, -24, -20,  13,  22, -19,  19,  23,  23, -18, -21, -16, -17, -22,  03, -18,  17, -09, -01,  08, -23,  19, -21, -05,  12, -12, -07,  04, -16, -05, -10, -17, -04, -05,  24, -05,  01,  18, -05,  01, -25,  00,  11, -15,  05, -11, -08, -01,  08,  16, -17,  12,  12, -11, -16,  00,  03,  03, -19,  12, -25, -04,  23, -02,  17,  22,  19, -05,  15, -09,  24,  18,  18,  10, -22, -02, -24, -02, -25,  11, -11, -17,  01, -23, -01,  10,  04, -23, -12,  12,  17, -10, -17,  17,  14, -23,  14,  10,  00,  06, -24, -01, -01,  20, -14,  03, -05, -11, -22, -05, -24, -08,  05,  02, -04, -18, -13, -23, -16,  03,  14, -22,  20, -25,  20,  09, -21,  11, -04,  04, -07, -02, -22,  17, -05, -11, -03,  17,  04,  00, -12,  07,  20,  20, -14, -07, -23,  00, -04, -11, -20, -13, -08, -24, -13, -10,  12, -08, -24, -16,  21, -06,  09, -23, -11, -19, -07,  13,  23,  24, -11, -14,  06, -14, -16,  19,  04, -14, -03, -23,  02,  02, -10,  22,  05,  04, -13, -05,  21, -10,  06,  20,  10, -10,  24, -24, -04, -08,  14, -06, -08, -20,  08, -25, -09,  19,  22,  23, -18, -06, -25,  10,  23, -10,  07,  06,  20,  21, -24,  18, -14,  07,  15,  21,  24,  14,  24, -03, -16,  14,  18,  01,  19,  03,  03, -12, -03,  00, -14,  05,  21, -14, -08,  20,  02,  24,  03, -01,  20,  04, -08, -19, -12, -15, -20, -11,  24, -21,  11, -17,  20,  04,  11,  15, -17, -08, -22,  07,  19, -11, -11,  16,  02,  06,  13, -21,  05, -09,  05,  02,  22,  23,  11, -13, -17,  18,  01, -16,  22, -13, -05,  20,  18, -17,  10, -22,  00,  15,  13, -05, -19, -23, -12,  08,  09, -24,  13, -09, -06, -07,  21, -09, -07,  07,  03,  03,  00, -19,  15, -01, -07, -15, -06, -12, -07, -19, -06,  21,  21, -18, -07, -23, -16,  06,  13,  18,  07,  03, -13, -24,  23, -17, -06, -08,  17,  24,  22, -06, -20,  12,  20,  00,  24, -10,  13, -05, -02, -18, -09, -05, -09,  09, -01,  01, -08, -11, -04, -24,  17,  10, -23,  16,  18, -02, -15,  12, -03, -18, -19,  02,  22, -23, -23,  21, -06,  17, -07,  17, -23,  11, -11, -07, -03,  16,  19,  14, -20, -07,  15,  23, -22,  19,  16,  22, -08, -24,  11,  14, -15,  18, -07, -18,  22, -05, -19, -09, -12,  01, -17, -10, -12,  00,  08,  10, -09,  05,  00, -02,  23, -08, -04, -24, -13, -11, -25,  04, -10,  14, -04,  01,  07,  14,  10,  04, -13,  18,  22,  02, -05, -20,  19,  10,  05,  02, -05,  23, -16,  22, -03, -16, -10,  20, -12,  04, -15, -10, -15,  02, -21,  06, -20,  13, -02,  18, -06,  12,  11, -09],
          [-25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([-11, -17, -01, -17,  18, -19,  12, -09, -20,  24, -12,  04, -17,  05, -01, -04, -16,  11,  14, -05, -11,  18, -22, -06,  07,  03, -11, -24, -10, -24, -07,  06, -14,  17,  14, -20, -25,  04, -02, -20,  03,  11,  09,  11, -06, -14, -15,  03,  22,  24, -25, -12,  19, -19,  10,  03,  09,  24,  05, -25, -23, -25,  08, -11,  19, -02, -04,  19, -23,  19, -23,  07,  07,  13, -05, -24,  24,  05,  07,  24,  06,  07, -13,  01,  13,  22, -19,  00,  24,  11,  02, -24,  13, -15, -10,  09,  08,  13,  06,  12,  07,  08, -04, -10, -02,  17, -07, -02, -01, -25, -03, -17,  10,  11,  11,  00,  11,  17, -25,  10,  06,  02,  13, -06,  15, -19, -19, -02,  19,  12, -12,  04, -03,  09,  21,  20,  03, -11, -05, -22, -08,  17, -14, -23,  06,  22,  04, -08,  14,  07, -21, -03, -14,  17,  17, -24, -25, -25,  00,  20,  12,  15,  01, -14,  01, -03, -17, -18,  11,  04, -15, -20, -02, -02, -18, -21, -03,  14, -02, -12, -04,  02,  11,  07, -03,  05,  09, -01,  05, -14, -04, -06, -22,  22,  05,  04, -06,  15,  11, -17, -06,  23, -12,  18, -02, -02,  22,  22, -13, -02, -14,  08, -25,  24, -08, -01,  04, -22,  24, -14, -11, -05,  07, -06, -05, -11,  24,  14, -21,  12,  22, -01,  13, -14, -08, -12,  09, -09, -14,  21,  14, -01,  06,  17,  00, -25, -07, -19, -21, -06, -08, -05,  17,  24,  15, -13, -12,  16, -24, -06,  05, -24,  18, -05, -13, -13,  09,  23,  04,  22,  21, -05, -04,  04, -13,  23,  04,  08, -21,  10, -23, -04, -19,  19, -03,  23, -17,  12,  16, -15, -19, -04, -12, -25,  17,  00, -11,  03,  00,  18,  00, -04, -11,  23, -25,  03,  21,  06, -12, -25, -06, -09, -02,  02, -13,  22,  00, -04,  11, -09,  08,  17,  14,  21,  19,  06, -02, -16, -14,  23, -21,  11, -04, -05,  11, -02, -24,  09, -19, -11,  11,  00,  07, -14, -23,  20, -17,  04, -07,  19,  20, -24,  14,  10,  24,  10, -07, -03,  19,  05, -03, -24, -07,  20, -04, -20, -07, -01,  14, -01,  14,  03, -23, -04,  14, -21, -07,  23,  09,  11,  19,  06,  12,  10, -07,  11, -04,  12, -15, -08, -08,  09, -07,  10,  04,  17,  17,  22, -09,  09, -01, -18, -13,  03,  06, -22,  09,  24, -24, -07,  11,  23, -23, -02,  08, -05, -13, -19, -18, -03, -01,  01, -18,  19, -11,  11,  13, -17,  11, -18,  17, -13, -11, -19,  17,  22, -15,  01,  22, -12,  22,  08, -12,  24, -17,  24, -06, -05, -20,  04,  20,  06, -20, -23,  03, -04,  15, -09,  05,  03, -02, -03,  17,  15,  06,  09,  14,  16, -12,  11, -19, -15, -06, -05, -16,  03, -06,  05, -25,  01, -16,  20, -17, -08,  24,  11,  13,  17, -21, -05, -05,  05,  20, -10, -03,  01, -24, -14, -06, -09,  23,  02,  01, -08,  22,  12,  22, -07, -05,  23,  20,  06,  20],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([-20,  23,  20,  18,  14,  12,  22, -16, -16,  02, -19,  01,  24,  07,  03, -14, -22,  19, -14,  06, -02,  05,  03, -15,  03,  24,  05,  03,  21, -13, -02, -24, -13, -05,  19, -22, -18,  16, -10, -06, -04, -04,  20, -03, -19,  00,  10, -16, -03,  21,  15,  22,  02, -04, -16, -18, -03,  17,  12, -07, -21, -13, -06, -07,  08, -10, -01,  17, -17,  14, -12,  04, -13, -14, -21, -07,  11,  14,  03, -15,  11, -05, -18, -10,  18, -08, -01, -10, -16, -14,  10, -10,  00, -19,  10, -15, -04, -16, -20,  05, -25, -07, -14, -12,  04, -10,  06, -07, -18, -14,  03,  18,  09,  13, -15,  04, -20,  11,  22, -09,  24,  07,  08, -01,  14, -07,  10, -15,  05,  15,  17,  05, -15, -19,  18,  15, -04,  02, -17,  05,  15,  13,  00, -01,  01,  10, -21,  08, -04, -24,  24, -05,  10,  07,  22, -01, -22,  09,  12,  08, -01,  04, -10,  11,  10, -14,  01, -16,  15,  11,  14,  05,  00, -10, -18, -24, -23, -14,  10,  01, -11,  11,  23,  24, -04,  20,  01,  01,  04, -12, -16, -20,  19,  01,  17,  05,  12, -05,  16,  02, -18,  07, -15,  07,  24, -08,  10, -23,  05, -03,  05,  19, -16,  03,  20,  05, -01, -04, -19, -22,  11, -08, -14,  06,  20, -22, -12,  10, -02, -19, -11,  05,  13, -01, -11,  13,  16, -25,  17, -04, -03, -03, -08,  08, -25, -10, -10,  01,  13, -02,  07,  00,  17,  18, -17,  13,  23, -04, -02, -02,  02,  14, -19, -08, -11, -05, -18, -18, -03,  24,  06,  22, -02, -25,  05,  01, -10,  23, -21, -19, -04,  11,  08, -11,  06,  16, -21,  04, -13,  04, -22,  16, -07, -16, -17,  09,  06, -07,  17, -21, -06,  00, -22,  18,  00,  10, -04,  16,  08,  00,  24, -20, -11,  07, -04,  20, -02,  00,  02,  12, -21,  05,  03, -01,  16,  13, -16, -03, -19, -22,  03,  01,  03,  06, -04, -22, -08,  19,  21, -23, -04,  20, -18,  10,  02,  05,  08, -25, -20, -13,  14, -14,  19, -08,  13,  10, -17,  22, -16, -09, -23,  15,  19,  05, -04, -08,  08,  15, -14,  07,  18,  08,  02, -23, -05, -18,  08, -20, -18,  15, -08,  24, -21, -14, -09,  17,  21,  01,  16, -17,  20,  18,  23,  14,  00, -04, -16, -15, -13, -05,  17, -18, -20, -03, -16,  03,  04,  19,  08,  13,  10, -24,  12,  16, -13, -19,  08, -14,  09,  01, -04,  04, -04, -06, -04,  21,  15,  05, -17, -21, -23, -22, -12, -17,  00,  00,  11, -19, -06, -06,  21, -19, -03,  09,  22,  12,  17,  07, -25,  01, -15, -04, -17,  06,  17,  04,  04,  09, -14,  15,  16, -12,  18, -21, -04, -05,  04, -16,  01, -24,  06, -03, -18, -22, -17, -18,  17, -25,  14,  17,  04, -23, -12,  12,  08, -18, -07, -10,  17,  04, -20,  08,  17,  23,  12, -09, -05, -06,  00,  21, -05, -19, -05,  04, -13,  04,  11, -21,  06,  03,  22, -15,  05],
          [-25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([-13,  24, -10, -05, -06,  05, -11,  23,  12,  22,  18,  12,  11, -14, -18, -18,  11, -22,  02,  20, -01, -18, -18, -20,  18, -12,  11, -02, -15,  24, -22,  00,  23, -06,  22, -07, -24, -14, -07,  16, -15, -12,  03,  23, -01,  13, -19, -12,  16,  08, -17, -08,  17, -08, -01,  13,  05, -14, -14,  16, -13, -08, -07, -15,  11, -10,  05,  14,  03, -24,  05,  13, -11, -14,  11,  16,  24,  17, -21,  17,  03, -13, -13, -05,  04,  11, -15, -16,  24, -03, -23, -14,  14, -05, -03,  02,  12, -21, -07, -10, -18,  24, -22, -01, -13,  17, -10, -14,  09, -06, -22, -11,  08, -10,  12, -11, -23,  22, -02, -24, -04,  03, -12, -13, -25,  12,  14,  13,  18, -15, -22, -24, -14, -18,  00, -02, -24,  15,  09,  12, -14,  12, -23,  19, -22,  14, -17, -18,  13,  08, -15, -15, -14,  00, -03, -13, -13, -11, -23, -17, -01, -20, -16,  10, -11,  11, -17, -10,  03,  19, -22,  16,  06, -18,  12,  11,  21,  22,  20,  09,  05, -19,  19,  19,  06, -06, -17,  21,  08, -15, -21, -18, -08, -10,  19,  07, -22, -21,  24,  08,  23, -21, -01,  06, -14, -14, -05, -18, -17, -10,  19,  15, -02,  15,  11, -20, -16,  19, -22,  19, -19, -16, -24, -01,  01,  22, -17,  04, -24, -18, -13,  24, -13,  13,  08, -02,  24, -22,  08, -16, -07,  04,  24,  19, -04,  11,  24,  08,  07, -21,  02,  14, -12,  06, -10,  14,  03, -02, -05,  07,  07,  09,  08,  21, -03, -09, -03, -02, -06, -20,  07,  15,  11,  08,  09, -18, -04,  10,  17, -19,  16, -05,  20, -21, -22, -13,  20,  08,  12, -10, -10, -04,  24, -24, -07, -02, -08,  15,  21,  12,  22,  05,  04,  10, -12, -10,  17,  12, -25,  12,  18,  16, -16,  15,  22, -13, -21,  17,  22,  16, -16, -10, -13, -15, -09,  07,  08,  08, -03,  04, -03, -04, -16, -22, -19, -01, -07, -24, -12, -05,  13, -19, -12,  22,  23, -15, -14, -23, -21, -15,  18, -10,  00, -17,  00,  18,  15, -17,  02, -10,  14, -24,  11, -25, -20,  18,  02,  00,  19,  15,  21,  09,  24, -14,  08,  22, -01,  19, -25,  03, -19,  18,  21,  07, -22, -04,  00,  19,  07, -21, -16, -04, -17,  22, -03, -10,  15,  24,  15,  11,  16,  13, -03,  15, -25, -20,  13, -01, -24,  13, -21, -17,  08, -25,  17,  12, -01, -08,  08, -19, -01,  17,  02,  07,  16, -24,  22,  07, -23,  14, -05,  21,  03,  18,  11,  05, -25, -01, -19, -23, -11, -13, -13,  23, -12, -21,  12,  12, -02, -05,  20,  22, -11, -03,  04, -20,  01,  03,  14,  05, -07, -15,  01,  23, -20, -12,  03, -18,  14,  11, -14, -21,  23, -02, -21, -12,  04,  18, -25, -22, -12,  20, -23,  04, -05,  07,  09,  23, -13, -01,  03,  07,  11, -20,  05,  18, -05, -15, -23, -16,  21, -11, -10,  22,  14, -04, -15, -06, -11, -12, -01,  04, -15],
          [-25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([ 01, -17,  05, -15,  20,  05, -02, -06, -14, -20, -18, -09,  13, -23,  13,  23, -21,  24,  22, -05, -08,  19, -15,  13, -19,  06, -20, -06, -20,  09,  05,  08,  20, -13,  19,  15,  18, -06, -14, -21,  01, -05, -03, -11, -03, -15, -10,  03, -14, -11,  24,  03, -17, -14, -08, -11,  19, -01,  09, -24, -15, -09,  09, -20,  03,  05,  22, -04,  24, -15,  02,  03,  05,  24,  17, -21, -14, -16,  10, -02, -02,  11, -24,  08,  24, -05, -25,  18,  19,  11,  19, -20, -23,  05, -13,  05, -14, -15, -21, -13, -03,  06,  15, -22,  06,  10, -16,  19,  19,  21, -08, -05,  07, -04, -22,  06,  16, -22, -01,  13,  14, -05,  18,  18, -22, -18, -01, -11, -06,  03,  03,  17, -16, -04,  20,  17, -17, -19,  12, -21, -22, -19, -01,  10,  04,  03, -06, -02,  08,  20, -14,  00, -07, -19, -07, -04, -12,  17,  10,  08, -03, -10,  00,  09,  13, -03,  03,  21,  05, -08, -24,  08, -01,  00, -04, -20, -20,  15,  03,  16,  12,  14, -09, -20,  20,  11,  01, -14,  06, -12,  21, -22,  04, -04,  14, -08,  20, -07, -09,  00,  10, -08, -16, -14,  19,  07, -08, -23, -01,  22,  18, -14,  12, -14, -08,  09,  22,  20,  22,  03, -16,  18,  09,  15, -09, -02, -16, -14,  16,  00,  12,  04,  19,  23,  17,  16,  07, -14,  18, -19, -16,  13, -08,  21,  24,  11,  07,  23,  07,  05,  02,  18, -02, -14,  08,  15,  11,  19, -24,  05, -05,  15, -14, -09,  15, -22, -18, -03, -10, -25,  05, -01,  15, -25, -05,  14,  11, -21,  13, -05,  09, -08, -10, -15,  05, -25, -25, -09,  20, -22,  23, -08,  21, -16,  10,  11, -12,  18, -14,  03,  20,  16, -21,  11,  16,  01,  02,  05,  05, -10, -23, -10,  09, -07,  02, -11, -05,  02,  08, -10,  07,  06,  09,  03,  16, -05, -08, -19, -12,  03,  11, -15, -04,  15,  21, -12, -09,  01,  20,  23,  16,  22, -10,  03, -08,  17,  17,  13, -06,  00, -20, -23, -16,  15,  07, -23, -13,  24, -15,  00,  02,  21,  12,  24,  13,  09, -11, -19, -13, -14, -21, -22, -17, -05,  06,  03, -13,  01, -07,  09, -22,  00,  13, -13, -10, -03, -09,  04, -03,  01, -19, -24, -01,  19, -23, -13,  05, -07, -07,  17,  04, -02,  22,  15,  20,  06, -07, -16, -18,  13,  20, -13, -12,  10,  02,  06, -17,  18, -15,  07, -05, -08,  08,  21, -14,  11, -16,  18, -19,  02,  10,  11, -23,  07,  01,  24, -12,  19, -14, -03,  09, -19,  10,  22,  19, -13,  05, -23, -18,  16,  11,  04, -15, -06,  01, -04, -18,  10, -09, -11, -11, -24, -25, -06,  10,  03, -07,  24, -01,  06, -02, -17,  13, -17, -18,  09, -03,  13,  11,  05,  04, -03, -16,  14,  18,  10, -13, -22, -05,  03, -08,  12,  06, -06, -19, -09,  22,  01, -08, -04, -17,  16,  06,  23, -24,  13,  07, -01,  01, -05, -21, -20,  19],
          [-25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);


//length == 1023
  check([-16, -04, -03,  03, -13,  17,  01,  13, -22, -03,  05, -04, -20, -15, -20, -05, -10, -04,  18, -22, -02,  19, -18,  08, -11, -13, -07,  03,  04, -05,  22,  15,  18, -06, -06, -18, -13,  20,  21, -08, -08,  03,  13,  00,  15,  18,  20, -20, -08,  15, -15,  17,  10, -07,  00, -24,  07,  18,  06, -12, -10,  04, -21, -16,  23, -02, -07, -13, -05, -11,  05,  12,  20, -05, -11,  10, -11, -14,  18,  08, -23, -22,  00,  14, -02, -22,  17, -20,  21, -01, -06, -11, -22,  00,  00, -22,  23,  18, -09, -07, -15,  23, -18, -20, -07, -01,  15,  09,  10,  10, -08,  14,  14,  20,  05, -13,  23, -02, -05,  21,  22,  16, -13, -23, -09,  14, -20, -09,  10, -02,  09,  20, -04,  18, -23,  17, -08,  19,  01, -22,  05,  21,  19, -04,  18,  00,  08,  16,  23, -20,  14,  22,  23, -21, -24, -09,  18, -17,  07,  03,  07, -07, -02, -22, -11,  02,  20,  06, -03, -01,  11, -23, -05,  06, -02, -10, -17, -17, -19, -19, -09,  22, -20, -11, -24, -19,  08,  22, -11, -08,  00,  21,  11, -24, -23, -25,  03,  24,  08, -23, -02, -03, -21,  20, -20,  04, -15, -12,  15, -07, -04, -19, -07,  01, -03, -04,  09, -20, -07, -25, -02,  21,  24, -14,  24, -24, -12,  04, -23,  23,  07,  03, -05,  11,  00,  02, -07,  13,  17, -17, -17, -12, -11,  01,  16,  13,  23,  02,  21, -07,  03, -04, -09,  02,  07, -10,  05,  22,  20,  07,  20,  02, -13, -07, -10,  13,  20,  08,  01,  15,  18,  09, -22, -16, -12,  22,  23, -12, -01,  19,  06, -23, -10,  23,  04,  24, -10, -16,  21, -15,  19,  18,  14, -17, -14, -20,  21, -16,  15, -01,  24,  09, -14, -21,  18, -01, -24,  18,  12,  01,  14, -05,  05, -19, -05, -15, -20,  11, -04, -22,  23, -08,  22,  13,  01, -15,  18, -01, -04,  10,  24, -03, -06, -13,  04, -10,  11,  05, -15,  00, -17, -25,  22,  14, -19, -05, -24, -11, -19, -01, -06, -19,  17, -07,  19, -05,  06,  14,  19, -23,  00,  20,  02,  21, -18, -19, -12,  18,  13, -01, -05,  24,  01, -05,  15,  09,  15,  16,  23,  23, -08, -07, -21, -16,  11, -24,  06, -08,  15,  01, -03, -08, -04, -24, -09,  04, -16,  04, -01,  22, -20,  20,  23,  08, -08,  13, -07, -18,  04, -09, -20,  24,  11, -14, -17,  00, -13,  17,  19, -22, -07, -07, -03,  16, -06,  13, -05,  03, -05,  22,  03,  00,  19,  01, -16, -14, -10,  04, -07,  21,  20,  00,  20,  09,  11, -19, -14,  24,  23, -20, -21, -07,  01,  01, -16,  20, -10,  07,  01,  10,  04, -21, -13, -02,  07, -02,  09,  24, -23, -23,  23, -25,  04,  18,  09, -10, -24,  22, -11, -24, -23, -07, -06,  05,  22,  04,  01, -13, -14, -21,  24,  17, -15, -14, -10,  17,  12,  24,  19,  14, -22,  17,  14,  07,  12,  00,  22,  14, -03, -11,  15,  02,  09, -13, -18,  06,  18,  10,  20, -19,  14,  19,  23, -24, -17, -12,  19,  20, -13,  15,  11, -08,  07,  03,  24, -06, -20,  23, -17,  03, -13, -24, -18,  22, -10, -09,  05, -17, -21,  01, -11,  20, -03, -13,  22,  05,  02,  16,  02,  16,  08, -11, -17, -10,  17, -18,  09,  24, -20,  20,  04, -07,  23,  11, -08, -12, -20,  24, -04, -16,  00,  12, -21, -25, -24, -24,  05,  03,  19, -15, -06,  02, -01,  02,  19, -07,  09,  04, -08,  16,  01,  22, -14, -01,  10,  05,  14,  17,  05, -15, -24, -18,  24, -17, -18, -25, -14,  15,  03, -17, -25,  22,  10,  01,  01,  05,  21, -15, -14, -12, -22,  14, -13, -10, -12, -25,  22, -23,  17,  02, -11,  21,  12, -12, -19,  21, -12, -08,  11,  18,  00,  13,  15, -12, -11, -09,  20, -15,  03, -17,  01,  08,  22,  15, -25, -15,  15,  23, -11,  10,  00,  05,  08, -11,  18,  14, -14, -17, -19,  22, -22,  09,  13,  20,  22, -23, -12,  19, -12,  16, -23,  16,  01,  24,  06,  02, -14, -01,  00,  00, -16, -23, -18,  17, -08, -23,  08,  05, -15,  16,  04, -10,  00, -08, -15, -01, -05, -02, -07,  10, -09, -03,  01,  17, -02, -16, -04,  09,  08,  21, -14,  17, -24, -07,  11, -05, -05, -06, -25,  07, -14,  06,  22,  13,  24, -18, -12, -04,  05,  08, -19,  23, -17,  09,  16,  06,  18, -13, -09,  02, -14,  02, -04, -13,  23, -15,  09, -07,  04,  09, -22,  17, -10, -25,  06, -09, -15,  21,  12,  17,  06,  20,  16,  14,  04,  09, -04,  00,  23,  14, -21, -16, -09,  02, -02, -09,  12, -18,  10, -06,  18,  15, -14, -14,  15,  19,  02, -23,  15, -08,  20, -03, -13,  13, -14,  19, -03,  09, -06, -05, -02,  00,  07,  17, -23, -20, -17,  17, -10,  20, -14, -17,  10, -03, -04,  01, -08,  24,  05, -16, -07,  00,  06,  05, -12,  20, -01,  12,  04,  20, -17, -22, -05,  15,  20,  00,  22, -22, -08, -13,  24,  03, -04,  09, -23,  17, -13, -04,  18,  18,  08, -14, -05, -11,  19,  11, -14, -05, -02,  16, -09,  06,  19,  13, -02,  16, -12, -04,  19,  07,  08,  20, -13, -19,  07, -08, -24,  21,  15,  21,  14, -02, -15, -13,  15, -21,  23, -24, -01, -04,  17,  17, -20,  13,  06,  03,  04,  21, -24, -01,  06,  12, -04,  20,  20, -22, -13,  21, -25, -22,  20,  16,  03, -20, -22, -07, -14, -24, -05,  12,  00, -11,  05,  05, -22, -12, -15,  07, -14, -13, -17,  19, -24,  05,  15,  21,  08, -23,  20,  10, -18,  15,  02,  11,  22,  05, -19, -17,  09,  03,  22, -16,  18,  02,  14,  21,  17, -24,  05, -19, -12,  14, -25, -11, -06,  15, -12, -21,  20, -17,  15, -23,  23, -08,  15,  22,  24,  24, -18,  08,  02, -21,  19, -05,  09,  10, -07,  01,  12,  24,  07, -23,  15,  10, -06, -16,  00,  07, -10, -05,  15, -20,  00],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([ 15, -01, -08,  12,  01, -09,  19, -14,  19, -25, -19, -09,  09,  18,  10, -12,  05,  11,  22,  10,  01,  07, -21,  12, -17,  11, -21,  05,  01, -13, -20, -07,  11, -02, -20, -13,  16, -24, -01,  10, -24,  07, -23,  13,  00,  14, -24, -17,  02,  23,  18, -20,  06,  22,  17,  16,  10,  23, -04, -14, -15,  04,  06,  22, -21,  11, -14,  20,  14,  12,  06,  17, -06,  10,  05,  22,  01,  06, -20, -22,  07,  23, -15, -10,  22, -21, -19,  07, -23,  04,  20, -12, -15,  01, -13, -11, -11, -02, -15, -22, -12,  18,  20,  07,  03,  03,  04, -19, -16,  11, -14,  18,  11, -04, -17,  08,  00, -09, -08,  04,  23, -13,  17, -17,  15, -19, -02, -21,  07,  10, -16,  20,  03, -18,  04, -17,  10, -14, -11,  21,  22,  02,  15,  09, -25, -25, -06,  02, -06,  12, -19, -06, -24, -24,  02,  17, -18, -23,  23,  14,  14, -15,  09, -08, -08, -11,  02, -23,  02,  16, -25, -01, -05,  17, -15, -05,  18,  05,  22, -11, -08, -21,  10, -07, -20, -11, -13, -11, -08, -12, -21, -17, -02,  15,  01,  15, -19, -22,  19,  08,  22,  19, -17, -08,  12, -07,  15,  07, -25,  12,  23, -08,  18,  08,  13, -25,  22, -23, -10, -09, -10, -04,  00,  15, -14, -24,  05, -07, -19,  01, -24, -20, -04, -14, -02, -15,  07, -10,  17,  07, -21,  17, -23, -25,  00,  17, -25, -03,  21, -08,  16, -13,  13, -09, -23, -25, -06,  10, -05,  00, -14, -04,  06,  09,  10, -19,  19, -08, -02,  13, -24,  02,  05, -22,  02, -18,  20,  05,  07,  19,  22, -02, -19,  13,  14, -15,  13, -15,  22, -15,  10, -14,  06, -07,  20, -09,  01,  17,  10,  24,  05,  12,  04, -12,  17, -17, -05,  15,  13, -23,  09,  13,  00,  15,  01, -09, -23, -09,  01, -23,  01, -11, -12, -16,  09, -15,  03, -14, -23, -12, -13,  10, -23,  16,  23,  20, -23, -05,  10,  15, -02, -06,  05, -25, -14, -19, -08, -12, -01,  20, -08, -25, -16,  05, -13,  19,  18,  15, -20,  22, -22, -06,  07, -19, -12,  07, -22, -10, -22,  13, -18,  01, -18,  13,  03, -07,  21,  20,  08, -04,  16, -24, -02, -23,  08,  10,  21,  01,  02, -22, -01,  08, -02, -17,  14,  13,  16,  19, -22,  21,  07, -13, -03,  14, -25, -23, -16,  24,  23,  17, -03,  16,  18,  20,  18,  04,  08,  17, -20, -15,  20,  06,  18, -05,  15,  09, -15,  08,  03, -12,  04, -13,  03, -22, -24,  03, -20, -15,  04, -20, -22, -24,  23,  23,  24,  17,  02,  07,  11,  10,  19,  06, -07,  15, -21, -15,  01, -11,  18, -18,  05, -01, -06, -17,  04, -04,  13,  10,  08, -07,  17,  13, -04,  16,  12, -05,  10, -09, -23, -04, -22,  24, -21, -03,  14, -15,  07, -08,  00,  03, -01, -18, -21,  19, -10,  09, -10, -20, -06, -25, -02, -12,  14,  20, -21,  03, -10,  16,  19, -05, -13, -25, -04, -06, -03, -13,  04, -19,  04, -19,  11, -21, -12,  16,  23,  03,  00, -10,  09,  21, -10, -16, -16, -21, -19, -09,  07, -01, -16,  04,  21, -01,  06, -08,  18, -20,  06, -01, -14, -15,  06, -25, -11,  19,  16, -11,  00, -09,  04, -16, -11,  22, -05,  00, -24,  04,  18,  11, -20, -22, -08, -24,  02,  23, -05, -05, -20, -24,  19, -09, -14,  00, -07,  03, -03, -16,  19,  22,  02,  01, -17,  16, -02,  03, -06,  01, -16, -13, -11, -11, -10,  06, -10,  17,  06,  12, -11,  11,  13, -14, -20, -23,  13, -02,  07, -15,  10,  01, -18, -13, -23, -08, -19,  02,  23,  00, -21, -18,  14, -07, -03, -20, -23,  14,  24,  08,  02, -11, -03, -08,  02,  04, -06, -10, -21, -22,  03,  14,  07,  12, -21,  11, -20, -13, -11, -22,  14, -07, -13,  03,  11,  09,  10,  13, -01,  10, -01, -22, -24,  23, -05,  05,  04,  17,  22,  08,  22,  00,  00,  04, -10,  06, -09, -03,  18,  05,  00,  09, -25,  12, -13,  11, -01, -25,  02, -25,  10, -22, -22,  13, -24,  00, -07,  07, -06, -10, -10, -08,  18,  17,  23, -17, -02, -11,  05, -07,  21, -18, -23,  23,  21, -08,  12, -05, -08, -11, -03, -21, -06,  02,  17, -03, -22, -15, -21, -01,  02, -04,  16, -05, -11,  17,  05,  14, -17, -13, -17, -20, -06, -13, -22, -07,  04,  15,  15,  23, -19, -12, -23,  02,  15,  19,  24,  20, -19, -22, -05,  09,  00, -12, -19,  16, -18,  12,  05, -09,  24,  15, -02, -04, -22,  01,  14,  09, -06,  06,  08,  02,  19,  10, -20,  12,  07, -21,  09,  13, -15, -19, -03,  12, -03,  04,  03,  04, -07, -15,  20, -06, -22, -07,  15, -17,  22,  06,  17, -07, -12,  02,  20, -16, -12, -23,  23,  20, -16,  08,  10, -04,  16, -15, -17, -12,  14,  13,  18, -16, -25,  13,  03, -22, -18, -06, -14, -21, -23, -19, -01, -08,  08, -06,  02,  21, -01,  02,  18,  08, -13,  04, -19, -21,  14, -11, -08,  05, -21, -15,  16, -21,  24, -06, -17, -17,  15, -04, -11,  20,  02,  13, -13, -14, -16,  16, -16,  08, -06, -20, -07,  06,  11, -01,  10,  02,  15, -22, -16,  19, -12, -25,  24, -11, -06, -16, -01, -13,  07,  13, -18, -13,  03, -06, -02,  13, -14,  09, -02,  07,  14,  17, -12,  02, -07,  24, -21, -16, -21, -12, -20, -06, -12, -19,  11,  10, -08, -15,  24, -25, -24, -19, -13,  04,  02,  12, -08,  15, -02,  16, -03, -12,  10,  11,  17, -22,  12,  22, -11,  18, -13, -05, -13,  01,  01,  23, -12,  19, -14, -13,  21, -13, -05, -15,  16,  22,  22, -16,  13, -05, -23, -15,  10,  12,  23,  03,  17,  12,  02, -18,  05,  14,  04,  18, -08, -18,  18,  05, -22, -21,  19, -24, -09, -11, -14, -17, -11, -17, -06, -21,  06, -04, -11, -07, -15, -10,  23, -23, -23,  00, -14,  08, -10,  17,  03,  07, -25],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([-04, -10, -20,  01, -16, -18,  19,  01, -07, -21,  15,  04, -02,  19, -13,  21, -15,  05, -19,  00,  04, -16,  05, -19, -05, -10, -02, -10,  18, -19, -10, -11, -02, -03,  17,  07,  04,  12, -15, -25,  18, -25,  06, -08,  19,  18, -12, -18,  00, -05,  07, -19,  06, -11, -10, -22,  04,  13, -07, -03,  21,  10,  14, -06, -17,  06, -21,  14, -05, -11,  14, -11, -10, -05,  08, -14, -10,  23, -07,  18, -07, -22, -24, -24, -08, -09, -20,  24, -20,  00, -04, -24, -14, -15, -02, -06,  19,  02, -17, -09,  16, -25,  05, -17, -03, -10, -03,  15, -11,  15,  10,  07,  20,  11,  11, -12, -22,  16, -11, -15, -07,  10, -12,  04,  23,  11, -25,  19, -10, -14, -15, -16, -14,  18, -06,  10, -17,  16,  00, -03,  07, -15, -18,  04,  24,  18,  19, -23,  11, -17, -11, -21,  21,  02,  11,  19, -09,  11,  15,  06,  22, -25,  17, -15,  18, -13,  21, -21, -22, -02,  01,  12,  09,  10, -08,  08,  05, -14,  12, -09, -03, -22, -02, -07,  07, -16, -11,  23,  22, -21,  07,  22, -21, -01, -18, -25,  13, -20, -19,  17,  04,  07,  06, -10, -05,  23,  23, -25, -13,  12, -06,  09,  15,  17, -23, -03, -22, -09, -02, -23, -03, -18,  24,  03,  08, -18,  03, -03, -11,  09, -09,  18, -06,  22, -17,  14,  23, -17,  16, -15,  20, -15,  21,  12, -21, -25, -13, -18, -07,  12, -13,  15,  19, -14, -07,  04, -05,  24, -24,  10,  10, -06,  05, -21, -08,  14,  20, -10,  22,  12,  02,  20,  22,  00,  07, -21,  00,  19, -14,  18,  08,  00,  08,  02,  12, -24, -18, -16, -23, -15,  19,  13,  05,  00,  17,  24, -09,  15, -11, -12,  02,  18, -15,  01, -07,  18,  05,  18,  14,  19,  13, -02, -06, -04, -23, -17, -01, -14, -07,  02, -03, -11, -10, -23,  16, -16, -24, -18,  24, -08, -02,  03, -13,  10, -18,  07,  05,  12,  02, -05,  08, -10,  20, -20,  13,  24, -12, -13, -14,  08,  16,  10,  23, -17,  14,  16, -05,  15, -24, -06, -16, -01, -25, -02, -16, -18, -20,  15,  19,  09, -13,  05,  24, -16,  10,  12, -15,  23, -24, -04,  09,  20, -17,  09, -22,  22,  00, -02,  14,  01,  20,  23, -23,  20, -02, -11, -21,  05, -19, -25, -11, -07,  05, -12,  04, -10, -23,  14, -09, -19, -12, -23, -22, -04,  11, -19, -06, -14,  07, -15,  13,  04, -14,  17,  01,  09, -19,  05, -10, -13,  05,  06,  07, -12,  22, -14,  05,  24, -22,  21, -18, -07,  23, -15,  16,  11, -06, -13,  23, -22, -02,  13,  09,  09,  05, -15, -05,  12,  17,  10,  24, -01, -06,  09,  12, -09,  22, -07, -08, -25, -09,  00, -05, -08,  12, -11, -22, -19,  03, -24, -14, -24,  16,  20,  12, -03, -18, -17, -14,  24,  20, -13, -01, -11,  21, -12,  07,  19,  06, -25,  21, -25,  02, -06, -08, -11,  08, -05, -04, -14, -01,  09, -10, -10,  05, -21,  14,  12, -13, -25,  14, -15, -12, -10,  01, -14,  03, -16, -20, -13, -16, -23, -13,  11, -02,  06, -23, -19, -22,  00, -06,  02, -15,  11,  20,  15,  16,  09,  04, -22,  12, -07, -10, -25,  10,  17, -14, -09, -22, -06,  03, -11, -02,  17, -25,  21,  00, -21, -23,  03,  05, -02, -17,  15, -15, -22,  07, -24,  12, -14, -19, -01,  07, -01,  01, -06, -09,  15,  10, -04, -16, -10,  10,  07, -18,  12,  03,  09,  16,  07, -12, -04, -20, -04, -12, -08,  01,  20, -05, -10, -16,  02,  17,  18, -24, -07, -13, -06, -15,  23,  15, -06, -12,  02, -22, -02, -11,  06, -18, -20, -10, -03,  04, -04,  20,  17,  15, -04,  13, -14,  12,  22,  15,  04,  17,  16,  24, -21, -13, -15, -21, -21,  06, -05,  06,  10,  18,  20, -09, -23, -23,  07,  02,  06, -20, -03,  01,  22,  21, -11, -17,  08, -12,  23, -11, -20,  16, -10, -14, -20,  00, -09, -14, -16,  11,  17,  19,  06,  14, -13,  10,  19,  21, -13,  00, -22,  12, -24, -24,  08, -08, -14, -07,  07, -13,  09,  14, -20,  24, -24, -14,  02, -06, -03,  11, -20, -08,  05,  11, -17,  17, -02, -23,  14,  11,  05,  17, -02,  08,  18, -17, -24, -18,  01,  08, -06, -13,  00, -01, -14,  01,  10,  13,  20, -15, -01, -23,  04, -21,  15,  12,  24, -12,  15,  13,  24, -03,  07, -01, -20,  03,  09, -17,  10, -13,  19, -21, -01, -06,  03,  11,  20, -09,  01,  17,  03, -24,  19, -18, -18,  09,  21, -17,  22,  13,  23,  24, -15,  06,  00, -07, -16, -15,  01,  21, -01, -05, -25,  24,  14,  05,  12,  11,  23, -12,  03,  01, -09, -03,  10,  01, -19,  09,  09, -19, -03,  08, -20,  10, -11,  07, -22,  00,  19,  04, -04, -06, -25, -02, -05,  16, -20, -18,  03, -21, -03, -19,  07,  16,  04, -05, -08,  12, -21, -24,  18,  03,  11, -25, -12, -23,  10, -07,  02,  04,  23, -25, -25, -25, -02, -05,  16,  06,  04, -06,  12, -21,  03, -06,  20, -16,  16, -13,  21,  22, -10,  17,  01, -23,  19,  16, -21,  04, -15,  09, -16, -15,  09, -14, -13, -15,  07, -22,  16, -12,  00,  03, -08, -22,  24, -13, -13,  18,  01, -15,  15,  17, -21, -09,  21,  24, -15, -25,  03, -03,  11,  14,  07, -02, -24,  19,  08,  10,  24,  01,  23,  01, -19, -09,  06, -18,  05,  20, -25, -18, -19,  16,  24, -15, -16,  20, -14, -06,  22,  17,  16,  11,  06,  00, -16,  09, -04,  17, -06, -02, -05, -05,  24,  01,  11,  08,  08, -09,  03,  09,  00,  11,  02, -01,  22,  11, -04, -15, -19, -04, -23,  24, -18,  11,  02, -09, -05, -25, -15,  17, -02,  07, -11,  00, -17, -23, -17,  18, -05,  11,  04,  21, -02, -19, -05, -03,  18,  19,  09, -24, -10,  12, -23, -01, -02,  06,  17,  20,  07, -23,  14, -18,  11, -22,  07,  21, -20,  17],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([ 14,  01,  06, -04, -03, -19,  04,  19,  05, -01,  13, -11,  00, -20, -24,  05,  04,  01, -14, -04, -03,  20,  00, -12, -22, -14, -08,  12, -16, -03,  05,  24, -25, -12, -03, -03, -06, -24, -06,  24,  01, -18, -12, -22, -10, -08,  08,  19,  18,  22, -07, -08,  17,  20,  06,  22, -16,  23,  10, -07, -03, -08, -06,  00,  05,  16,  22,  24,  20, -07,  23, -04,  01, -12,  01,  16,  05, -13,  12,  01, -16, -18,  18, -22, -22, -01, -24, -13, -01,  13,  05,  24, -20, -25, -01,  12,  18, -02,  11,  13,  17,  11, -14, -05, -24,  15, -12,  07, -23, -23, -17, -14, -15, -22, -09, -12,  05, -06,  02, -19, -18, -16, -20, -11, -16,  06, -24, -20, -18,  14,  20,  24,  02, -18, -04,  04,  22,  11, -12, -24,  13, -02, -11, -25,  01,  05, -10, -17, -25,  17, -10, -16, -23, -03, -01, -12, -21,  02, -07, -14, -08, -11, -13,  21, -02,  10,  02, -03, -04,  15, -02, -14, -10,  12, -13,  19, -08,  02, -23, -06, -05, -06,  04, -01,  17, -20,  12,  23,  07, -17, -14, -24, -01,  00, -25,  22, -15,  02, -04,  08, -07,  19,  19,  10,  06, -17,  04, -25,  11,  07, -03, -17, -24, -24,  07,  20, -17, -04,  18,  15,  06, -19,  19, -20,  06,  19, -21,  18, -04,  00,  01,  16, -04, -02,  02, -21,  06, -19, -18, -08,  15,  04,  02,  17,  07, -14,  14,  15,  08,  08,  07, -11,  16,  01, -03, -02, -03,  01, -09,  19, -21,  20,  12,  00, -07, -11,  05,  24, -02,  12, -06, -12, -07,  21, -18, -25, -17,  22,  17,  18,  07, -01, -16,  00, -22,  06,  23,  02, -15, -08, -04, -11, -11, -14,  16,  07,  02, -04,  08, -25, -15, -21, -09,  05, -22,  00,  05, -12, -01, -01, -19, -17, -24, -08,  09, -21,  24,  07,  06, -16, -24, -20,  00, -10, -07, -09,  24,  20,  15,  08,  21, -23,  14, -11,  08,  17,  14, -10, -20, -11,  15, -12, -03,  16,  06, -19,  22,  05,  16,  05,  16,  19,  12, -07, -15, -20,  09, -14, -24,  01,  21,  24,  06,  11, -12, -11,  03, -23,  06,  11, -07, -02,  24,  16, -11,  05,  24, -12, -13,  15,  21, -20,  12,  08, -02,  24,  14, -15, -15,  15,  11, -18,  16, -08,  18, -21,  08, -02, -17, -10, -16,  02,  15, -16, -05, -18,  14, -06, -05, -21, -13, -09, -16,  24, -25,  08,  23,  16,  18, -17,  08,  06, -08, -01, -24, -15,  05,  09,  11,  13, -24,  20, -08,  17, -21,  12,  24,  21, -18, -04, -25, -04,  15, -14, -03,  15,  19, -05,  08,  14,  05, -09, -02,  23,  15, -01, -15, -05, -15,  23, -15, -11,  19,  03, -17, -25, -10, -16,  23, -01,  05, -25,  20, -03, -13, -08, -13, -17,  14,  22, -25, -03, -12, -02, -03, -20,  24,  07,  02, -14,  08,  13,  02,  02, -07,  10,  04,  08,  21,  03, -15,  04,  03, -18, -24,  17,  02, -09, -24, -07, -12, -22,  15,  04,  03, -13,  09,  02,  22, -11,  15,  05, -21, -07, -16, -03, -20,  13, -18, -21, -09, -08,  08,  22,  02,  09,  14, -21, -25,  17, -03, -09,  20, -12,  20, -02,  02,  04, -23, -01,  20,  20, -21,  24, -12, -12, -04, -05, -23,  04, -01, -05,  23, -18, -06,  00,  19, -16,  06,  19, -22, -19, -13,  24, -04, -18, -01,  23,  14,  04, -02,  09, -01,  04,  09,  14,  20, -18, -16,  24,  11,  11, -06,  12,  18,  14, -11,  14, -25,  23,  11, -22, -21,  23, -21,  00, -19,  06, -02,  20, -15,  23,  04,  09,  03, -10,  00, -02, -02,  09, -01, -14, -05,  18,  23, -09,  09, -10, -18,  11, -12,  18,  17, -08,  17,  21,  17,  23,  04, -08,  20,  16, -09,  01,  02,  21,  17, -23, -04, -10,  12,  20,  01, -16,  15,  00,  02,  02,  17,  10, -12, -20,  05, -20, -03, -03, -21, -09, -03,  10,  08, -08,  02, -24,  21, -21,  24,  13, -18, -05, -22,  21, -08,  04, -18, -15, -19,  12,  12,  23, -03, -23, -20, -21, -15,  02,  02, -11,  20, -24, -24,  06, -04,  03,  09, -08,  08,  09, -20,  17, -19, -15,  13,  01,  14,  22,  11,  23,  09,  00,  23, -17,  02, -21, -12,  12,  06,  17, -22,  04,  18, -20, -15, -11,  08,  19,  06, -07,  03,  13, -15,  12,  23, -25, -12,  15, -25, -24,  13,  09,  01,  13,  18, -22,  17, -17,  18,  01, -25,  21, -20,  18, -24, -10, -15,  12, -14,  18, -18,  17,  07, -05,  04,  07, -03,  19, -03, -03,  20, -13, -16, -04, -24, -23, -01,  18, -13, -08, -06, -13, -09,  01, -18, -06,  16, -08, -19, -20, -14, -09,  22,  20,  11,  01,  04, -17, -05, -21,  06, -10, -09,  15,  11, -06,  19, -13, -10, -19,  07,  09, -05, -25, -12,  02, -06, -19,  22,  03, -14, -15,  19, -17, -18,  05,  09,  11,  13, -19,  15, -04, -02, -18, -14, -14,  03, -18, -01,  18, -12, -17,  05,  10, -17,  18, -12,  02,  24, -13, -18, -14, -03, -24, -04,  04,  06, -19, -08, -03, -11, -17,  18,  13, -08, -18,  24,  20, -11,  00,  14,  05,  08, -06, -10,  18, -11,  05, -02, -12,  17,  05,  01, -09,  07,  23,  20, -10, -19, -12,  14, -05, -02,  10, -15,  15,  17, -15,  12, -19,  12,  03,  11, -02,  24, -23, -09, -12,  09,  14,  04,  02, -05, -20,  18, -21, -22,  16, -04, -14, -19, -12,  09,  04,  23,  19, -04,  15, -19, -15,  23,  19,  14,  10, -08,  13,  14,  08, -23, -02,  00,  08, -23,  22,  13,  21, -22,  19,  14,  01, -20,  20,  14,  16,  01,  12,  11,  24,  04,  17, -16,  03,  13, -25, -10, -18,  14, -19,  18,  18,  04, -07,  01,  09, -10, -09,  05, -05, -13, -04,  21, -05, -07,  11, -14,  21,  00,  22,  22, -20,  17, -19,  10,  07, -16, -25,  15, -25, -19,  08,  20,  12, -22, -02, -04, -05,  14, -22,  15, -23,  01,  11, -01,  19, -01],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([ 10,  15, -25,  10,  12, -18,  04,  21,  17, -14, -18,  17, -22, -18, -25,  11, -23,  14,  14,  00, -14, -14, -09, -09, -24, -07,  18,  15,  19,  12, -11,  05,  05, -11, -10, -06, -02,  21, -08, -10, -18, -01, -16, -14,  06, -16,  24,  08, -24,  16, -15, -13, -23,  02,  05, -19,  22, -02,  21,  17, -12, -15, -01,  18,  02,  16, -11, -25,  12,  07, -07,  19, -19,  02, -18,  13,  14, -16, -02,  15, -25,  11, -21, -21, -12,  09, -15, -15, -15, -17, -21, -02, -04,  03, -07, -25, -06,  07, -23, -19, -09, -05, -22, -02,  23, -13, -12,  14, -04,  13,  04, -02, -01,  10,  05,  12, -06,  17, -25,  06, -24, -21, -21, -01,  08, -01, -01, -21, -16,  01, -14,  00,  22, -09, -25,  22,  03, -12,  11, -23, -23, -08,  02,  03, -23, -18, -09, -02, -23, -09, -20, -22, -03, -14,  04, -18,  13, -22, -13,  22,  04,  00, -01,  03,  16,  00,  00, -04,  15, -12,  00,  17,  05, -22, -02,  09, -13,  14, -17, -09, -18, -10, -04,  04,  01, -25,  14, -11, -22, -24, -12,  10,  01,  13, -12, -06, -10,  16,  17, -20, -21, -07, -25,  12, -02, -02, -04,  12, -11,  04, -21, -04,  19,  00, -23, -02,  01,  16,  14,  06,  19, -20, -09, -05,  18,  05,  16, -15, -02,  09, -10,  02, -23, -10, -11,  02,  15,  11, -11, -21, -08, -07,  00, -11,  21,  05,  12, -03, -04,  03, -22, -09,  08, -03,  13,  03, -21,  05,  13,  02, -11, -21, -19, -07, -04, -04,  20, -13, -16, -14, -09,  03,  05,  19,  17,  03, -01,  06, -25,  22, -13, -20, -10,  20,  04, -21,  01,  08,  11, -11, -13, -23, -05, -06, -05,  19,  17, -08, -17, -22,  03,  01,  06, -15, -05,  01,  15,  21, -18,  17,  19, -04,  23, -14, -08,  04, -10,  18, -12, -22, -16,  00, -20,  05,  19,  02,  01,  13,  21,  09,  16,  00, -15, -02,  12,  06,  24,  03,  04, -17, -05,  00,  05, -05,  12,  24, -25, -23,  19, -10, -17, -22,  17, -12,  10,  14,  18, -14,  02,  14,  20, -06, -09, -19,  19, -19,  14,  20,  11, -07, -20, -19,  19,  12,  04,  08,  11,  06,  12,  05,  23,  20,  11,  15, -14, -04,  04, -21,  10, -18,  20,  07,  03, -13,  13, -03, -07,  04, -08, -19, -25, -03, -11,  21, -15,  18,  04,  23,  01, -09,  06, -01, -11, -08, -10,  00,  15,  21,  06,  00, -22,  01, -17,  08,  15,  23, -20, -15,  05, -01, -09,  05,  24,  06,  03, -14,  01, -16, -16, -22,  02,  15,  02,  16, -16,  19, -09, -25,  16,  24,  02,  21,  01,  12,  05, -09,  11,  12,  02, -09, -13,  18,  23, -14,  01,  03, -03, -22,  12,  08, -19, -11,  01,  10, -17,  10,  07, -01,  12,  00,  01, -10, -02, -23, -23, -22, -05,  15,  18,  24, -17, -20,  20, -19, -07, -04,  11,  17, -01, -02,  00,  07,  15, -24, -05,  23,  14, -23, -01,  01,  02, -25,  16, -25, -23,  21, -19,  00,  11,  24, -01,  20, -19, -06, -22,  01,  16,  15, -07, -08, -10,  20, -25, -20,  22, -05, -20,  11, -01,  05, -13, -22,  05, -19, -20,  10, -21, -14, -13,  15, -13,  11,  12, -05, -19,  16,  21,  24,  08, -11, -07,  23, -15, -05, -19, -16,  15, -14,  22, -09,  16, -14, -06, -01, -06,  00, -14, -02,  13, -02, -11, -22, -16, -24,  00, -08,  19, -03, -07,  02,  13,  12,  03, -25, -18,  09, -14, -25,  20, -17, -07,  14, -03,  15, -10,  16, -08,  01, -10, -18, -24,  06, -15, -13,  09,  11,  07,  04, -15, -25, -17, -25,  14,  11, -22,  24, -05, -11, -24, -07,  00, -04, -16,  22, -14, -01,  13,  03, -23, -20,  11, -22,  11,  23, -08, -04,  11,  24, -25,  21, -23, -15,  24,  16,  22, -23,  17, -08, -09,  20,  12,  16, -08,  21,  13,  03, -03,  04, -16,  01,  09,  20,  06, -02,  18,  24,  19,  05,  23,  21,  03, -25, -19,  02,  19, -22,  04,  11, -02,  23,  09, -13,  14, -24, -14,  05,  06,  10, -14,  15, -13,  22,  12,  18, -05,  08,  17, -09, -12,  16, -13,  18,  18, -04, -04,  12,  01, -23,  01, -24, -25, -15, -09,  17, -12,  02, -03,  19, -13,  10,  12,  01,  07, -01, -05, -22, -18, -11, -04, -03, -20,  11, -09,  24, -18,  14,  13,  10,  18, -11,  14,  19, -01, -20,  13,  12,  07, -15,  09,  21,  22, -04, -02,  04,  22,  20,  09, -20, -16, -19,  02, -08,  17,  20, -09, -24,  11, -19,  11,  05, -04,  00,  01,  22,  05, -11,  12, -11,  01, -04, -12, -02,  19,  11, -23,  16,  08,  14,  23,  17,  20,  01, -16,  14, -02,  02,  15, -15,  09,  03,  15, -18, -21, -07, -21,  11,  07,  18, -22, -15, -09, -09,  08, -15, -21,  12, -21,  12,  01, -23,  04, -02,  05,  16, -13, -21, -07, -23, -09, -21,  06, -17, -14,  12,  01, -07,  00, -15, -14,  05, -05,  03,  21, -22,  15, -23,  17,  19,  14, -04,  24, -04,  19,  06, -13, -16,  12,  07, -14, -22,  12,  19, -14, -25,  08,  14, -07, -14,  24,  05,  16, -06, -15,  13, -01, -25,  17, -08,  22,  09,  13,  21, -20,  07,  04, -06,  18, -08, -22, -18, -05,  15, -24,  09,  18,  12,  00, -14,  23,  00,  18,  14,  19, -22,  04, -04, -21, -03,  13, -22, -19,  01,  24, -12, -15,  05,  09, -21,  22,  12, -14, -05,  05, -11, -19, -02, -22,  06,  09, -24, -19,  05,  18, -22,  08, -01, -01,  14,  23, -11,  17, -19,  15,  18, -06, -23, -01, -20, -17, -04,  18, -04,  16, -02,  13,  24,  23,  16,  06,  09,  20,  14, -11,  13,  17,  23, -11, -07,  12, -12,  07,  07, -06, -01,  00,  16,  04,  24,  21,  12, -02,  16, -16, -09, -09,  22, -09, -11,  15,  22, -24,  10,  11, -10,  00,  06, -10,  15,  24, -20, -20,  09,  12,  01, -17, -13, -08,  12, -11, -09,  00,  12, -16],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([ 11, -22,  01,  10, -04,  17,  00, -07,  18, -12, -18, -14,  13,  13,  01,  03,  12,  08,  10, -04, -05, -13,  07,  10,  06, -06, -24,  24,  21,  15, -16,  09,  20,  10, -04, -08,  04,  22,  10, -02, -13,  17,  09, -25,  07, -13,  06, -03,  21, -09,  18, -07,  05,  02, -20, -13,  24, -19, -14,  22,  21, -03,  07,  17, -18, -22, -16,  12, -23,  21, -13, -11,  16,  23, -08, -02, -15,  23,  20, -17, -09,  16,  02,  22, -05,  07, -16, -06,  16, -03, -08,  14,  20,  24,  06, -21, -21,  17,  18, -16,  16, -20,  00,  09, -20,  17, -16, -09,  17, -20,  01, -16,  23, -22, -19, -07,  13, -08,  15,  06,  16, -18, -05,  11, -17, -21,  18, -11,  21,  11, -02,  14,  19, -24, -02,  24,  18,  08, -08,  11,  15,  19,  22,  15,  24, -22, -15,  14, -03, -25, -05, -12, -18,  16, -23, -08,  20,  22,  07,  18,  10, -18,  10,  04, -17, -17,  06, -21,  18, -25,  15,  10,  21,  12,  00,  23,  17,  11,  12, -11,  11, -17,  04,  21, -24,  08, -10,  23,  05,  22,  16, -09, -18,  01,  22, -10,  12,  05, -06,  05,  06, -14, -09,  04, -25,  18,  02,  17,  04, -10, -17, -07,  00,  15, -09,  01, -02,  06, -01, -19,  06, -08, -03,  13,  21, -04, -22,  08, -23,  00, -10,  10,  11,  08, -11,  12,  02,  19,  06, -17, -16,  17,  01,  11,  07,  19, -13, -18,  01,  13, -12, -18, -18,  12,  22, -22, -16, -23,  13, -12,  02, -19,  23, -09,  14, -11, -20, -07, -17,  11,  02, -06,  05, -20, -20, -13, -25, -06, -05,  03, -16,  10,  12, -06, -02,  09, -03,  07,  11, -12,  20, -09, -06,  20,  09, -17, -14,  14,  02, -03,  02, -19,  18, -17, -14,  24, -05, -12, -05,  17,  16,  07,  03,  03, -24, -24, -11,  00,  10, -22,  13,  07, -04, -18,  04, -20, -07,  15,  19,  22, -13, -02, -22, -19,  06, -09, -18, -21,  05,  04,  23, -04, -12,  01, -23, -09,  04, -09,  17, -09, -04,  07,  23,  17,  17,  04,  22, -15, -05,  18, -16,  09, -08, -13,  17, -25,  03, -24, -21, -17,  08, -20,  07,  21,  06,  09, -10, -12, -23, -18,  06, -01,  16,  07, -09,  08, -14, -09,  20,  08, -16, -21, -05,  01, -09, -11,  02,  22, -09,  08, -18, -24,  13,  14,  24, -03,  00, -11,  12,  05, -02, -07, -21, -10, -25, -03,  23, -11,  13,  19,  22,  23, -25, -08, -01, -06,  07, -22, -09, -25,  14,  00, -22,  04, -08, -23, -24,  17, -08,  15, -03,  15, -16,  03, -18, -14, -24, -17,  00,  14, -23,  00,  14, -21,  19, -11, -02,  03, -06,  16,  03, -15, -08,  06,  15,  09,  11,  16,  03, -20,  09, -22,  22,  18,  08, -20, -19,  09, -12,  07,  01, -08, -16, -10, -04, -22,  06,  20,  07, -22,  13, -13, -12, -20,  21, -22,  16,  07,  22, -03,  12,  06,  02,  09,  01, -15,  16,  07,  22, -21, -09,  00, -02,  02,  15,  20,  06, -01,  17, -12,  02,  05,  00,  17,  13, -04,  21,  06, -20,  20, -22,  17,  03,  07,  04, -21,  20, -05,  13,  19,  02, -18, -06, -25,  09, -14,  22, -08,  10,  16,  05, -11, -01, -17, -18, -13,  06, -20,  18,  12, -23,  24,  06,  05,  08, -15,  11,  03,  08,  01, -03, -13,  10,  18, -11, -03, -20, -11,  14,  17, -20, -05, -16,  04,  05, -07,  16, -14,  00,  12,  23,  02,  13,  05, -16, -02,  17,  22, -21,  02,  00,  03,  14, -12, -03, -19,  10,  04, -05, -01, -04,  00,  21,  07, -18,  03, -25, -25,  15,  00,  14,  15, -21,  02, -05, -10, -22, -10, -11, -18,  17,  15,  10,  09, -22, -18,  17,  15,  11, -13, -09, -15,  14, -10,  19,  21,  18,  20,  24,  08, -03,  13, -01,  04, -09,  21,  19, -06, -12, -14,  03, -17, -22, -12,  19, -17, -04,  11,  23, -16, -25, -11, -04,  14,  06, -09,  13,  00, -12,  12, -15,  10,  00,  11, -09,  18,  10, -12, -11,  23, -01,  17, -19,  02, -17, -25,  10,  04,  13,  10,  15,  13, -24, -11,  05,  08,  05, -07, -17,  18, -18, -05,  05,  09, -18,  22,  03,  17, -13,  19,  17,  11,  14,  24, -10,  22, -24, -25,  03,  15,  10, -07,  03,  13,  09, -17, -04, -11,  03,  06, -16,  10, -23,  17, -05, -16,  16, -25, -22, -22,  21,  20,  16,  10,  21, -19,  07,  23, -19, -15,  13,  18,  06, -09,  06, -08,  02, -20,  07, -20,  11,  18,  18,  13,  12, -10,  24,  03, -08, -23,  08, -12, -25, -01,  24,  21,  05,  08,  19,  13,  21,  07,  08,  04, -24, -08,  21,  05, -03,  05,  12, -17,  01,  05,  22, -12,  20,  21,  19, -13, -24,  02,  03, -24, -21,  02,  22,  09, -13,  19,  00, -17,  03, -17,  14,  06,  00,  11, -14,  22, -09,  24, -19,  17,  06, -20, -17,  04, -22, -23,  18, -21,  04, -04, -20,  10, -25, -20, -05, -12, -24,  20, -02,  04, -20, -12, -14,  08,  24, -01,  05, -08,  00,  13, -13, -18,  20, -05,  11,  24, -03,  04, -22, -22, -24, -14,  14, -22, -07, -14, -09, -06, -17,  15, -25, -12, -20, -12,  21, -21,  13,  04, -02, -12, -08,  10, -03, -12, -20, -17, -11,  02,  15, -08,  08,  18,  05, -03,  21,  23,  08, -12, -06,  16, -20, -05, -19, -15,  08, -22, -09, -02,  09,  16,  14, -22,  02, -14, -09,  09, -03,  07, -11, -13, -25,  22, -20,  05, -06, -24,  06, -21, -09, -25,  22, -02, -03, -22,  08, -19, -17, -24,  06,  17,  18, -05,  21, -03,  09, -11, -19, -19,  22, -05, -05,  24, -08,  00,  06,  13,  03, -13,  19,  20, -12,  16, -07,  12,  22, -21,  18, -20, -18,  02, -25, -25,  24,  23, -01,  08, -11,  06,  16, -12, -24, -14, -13, -04,  11,  19, -14, -10, -17, -19, -13, -02,  24,  05, -14,  21,  11, -19, -23,  19,  08, -21,  21,  08, -23, -04, -07, -07, -23],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([-15,  07, -20, -02,  19,  03, -15,  15,  15,  02,  24,  23,  16, -01,  22, -02,  10,  19, -15,  17,  23, -21,  02, -21, -23, -13, -17, -02,  08,  01,  02,  20, -17,  08, -07, -20, -12,  05,  20, -20, -18,  21, -22, -25, -04, -24, -01, -17,  22,  09, -23,  22,  15,  05, -24,  17,  19, -16, -09,  02,  10,  20, -03,  21,  03,  16, -24,  19, -04,  23,  24,  06,  20, -22,  06, -07, -19, -18,  03, -20,  16,  06, -23,  08, -12, -22,  01, -18, -11,  19,  12,  24,  14, -16,  20, -05, -23,  23, -11,  01,  22, -10, -16,  19, -05,  17, -11,  01, -25,  17,  08,  16,  00,  10,  02,  13,  15, -22,  23, -19,  24,  10, -19,  13,  21, -22, -17,  24, -23, -01,  02, -24,  15,  11,  20, -13,  03, -16,  16,  03, -24, -01, -03,  02, -13,  24, -08, -23, -21, -10, -16, -22, -23, -08,  16,  24, -03, -23, -25,  01,  03,  04,  02, -05, -10, -01,  08,  20,  08, -01,  01,  12,  23,  23, -09, -13,  24,  08, -10, -22, -24,  01, -17, -20,  20, -24, -19, -06, -20, -19,  21,  09,  12,  00, -19, -23, -25,  14, -25,  10, -10,  01, -01, -09,  01,  15,  03,  00,  01,  20,  05,  04, -04,  15,  09, -07,  16,  16,  13,  22,  24,  11,  08,  14, -14,  14,  16, -12,  04,  18, -24,  21, -06,  00, -13,  20, -07,  16, -03,  21,  11, -21,  00, -15,  19, -14,  03,  13, -21, -07,  10, -19, -21, -07,  20, -09, -18,  13,  06,  13,  07,  07,  10, -22, -17,  24,  24,  03,  15, -02, -01,  04,  03, -24,  14, -01, -13, -06, -13, -06,  13,  24,  00,  17, -06, -03, -15,  02, -15,  17, -08,  19, -01, -21,  23,  09, -21,  24, -13,  21, -03,  11,  00, -23,  14, -09,  04, -21,  13,  16, -02,  03,  18, -25, -05, -13, -01,  08,  16,  09,  02, -16,  06, -22, -10,  04,  13, -04,  03, -23, -07, -23,  16,  20, -20,  05, -11,  09,  09, -23,  02, -16,  05, -05, -14, -23,  10,  10,  12,  01, -03, -11,  10, -22, -07, -22,  09, -17, -01, -11, -15,  17, -09, -24,  15, -02,  09, -21, -16, -05, -17,  14,  05,  15, -14,  16,  19,  21,  02,  07, -02,  24,  23, -15, -21, -07, -12,  13,  01,  13, -23,  14,  07, -05,  17, -03,  19,  01,  03, -22,  22,  13,  19,  04,  03, -19, -05,  00, -23,  24, -16,  00, -25, -18,  11, -21,  03,  24,  17, -21,  14,  21,  20, -03, -08,  13,  19, -14, -09,  00, -09, -12, -12, -12,  19,  19, -06, -08, -06, -04, -09,  05,  24, -06,  14,  12, -02, -08,  13, -07, -01,  03, -09, -06, -25,  08, -18,  21,  21, -01, -02, -10,  14,  12,  03,  11,  08,  22, -22, -23, -05, -04,  09, -06,  15, -02, -19, -09,  16,  20,  11, -10,  00, -23,  11,  00,  13,  19, -02,  11, -05,  22, -24, -14,  11,  06,  22, -06,  05, -23, -02, -24, -01, -18, -03, -09,  05,  06,  09, -02,  03, -05,  13, -22,  00,  00,  05, -10, -04, -20, -24,  18, -23, -20, -21,  15,  11, -21, -14, -06, -19,  09, -03,  05,  16,  19,  24, -01,  00,  08,  22, -20, -19,  13, -17,  06, -10,  13,  23,  13,  19,  24,  06,  23, -19,  12,  16,  20,  16, -23, -11,  23,  12,  11,  05,  05,  07,  04, -19, -15, -12, -19, -10, -06,  19, -01, -23, -14, -11, -25,  24, -15, -24,  07, -16, -17, -06, -25, -22, -12, -23, -06, -12,  16, -20,  18, -01,  14, -02,  05,  24,  13,  11, -10, -16,  07,  16, -14,  18, -20, -12,  19, -09, -09,  03,  02, -01, -25,  04,  04, -12,  08,  23,  01,  00, -20, -06, -24,  20,  19,  06,  19,  09, -05, -14,  18, -23, -23, -19,  23, -15, -06,  17,  03,  11, -04, -18, -13, -02,  11,  19,  11, -06,  19, -11,  21, -23,  10,  22,  22,  07,  06,  18, -09, -24, -18, -15, -20, -14, -09, -22, -04,  13,  23, -24, -01, -06, -17,  13,  19,  19,  09,  05, -09,  04,  21, -13,  06,  06, -13,  05, -12,  20,  00,  07,  21,  07,  17, -24,  21, -17, -18, -08,  23, -20, -04, -01,  01,  04, -12, -05,  01,  22, -23,  17,  03,  23, -19, -16,  06, -05,  16,  20, -10, -08,  04, -12, -24, -04, -08,  22,  06, -01, -08,  05,  04,  13, -21, -20, -06, -06,  00,  20, -06,  02,  14,  22,  00,  23, -16, -19, -07, -25, -22,  11, -08,  07,  24, -06, -20, -09, -09,  12,  15,  08, -06, -06, -02,  00,  01,  18,  20, -24,  15, -09,  03,  05, -12, -20,  03, -03, -11,  23,  00, -06,  11,  17, -21,  11, -12, -16, -21,  05,  23,  22, -10, -08, -07,  16,  20,  20,  09,  15,  21, -01, -17,  02, -19, -04,  07,  11,  21,  21,  10, -04, -07, -02, -10, -03, -14,  04,  06, -09, -14,  05, -10,  03,  24,  08, -06,  19,  05, -22,  11,  02,  05,  19, -19,  11, -07,  13, -02, -11,  12, -15,  12, -20,  08, -23,  02,  22,  06, -15, -12,  19,  17,  03, -02,  17, -12,  17,  13,  19,  23,  00, -02,  03, -04,  04, -09,  14, -06,  16, -20, -17, -22,  17, -12,  14,  22,  17,  11,  03, -20, -24,  00,  22,  06,  23,  16,  19,  15,  05,  15,  13, -18, -12, -07,  05,  19,  10, -05, -11,  03,  02, -03,  07, -03,  13, -02, -06,  07, -16,  24,  14, -15, -01,  12,  16, -03,  05,  12, -10, -15,  03, -22, -06,  18, -01, -25,  13, -14, -03, -21,  14,  24,  03, -02, -02, -09,  21,  17, -24, -18,  19,  15, -06, -07,  04, -13,  18, -15, -25, -17, -03,  05, -14,  17,  00,  10,  19, -10,  23, -07, -06,  13, -06,  23, -12,  18, -09, -15,  10, -08, -06,  04, -17,  14, -25,  12, -22,  18,  24, -22, -24, -03,  10, -11, -09, -14, -23, -15,  01, -25,  03,  23,  13,  24,  21, -21,  17, -13, -11,  05,  07,  10, -16,  15,  01, -14,  04,  05, -21,  04,  10, -20, -22, -04, -03, -06,  09, -01,  06],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([-13, -01, -14, -13, -10, -15, -17, -04, -22, -02,  10,  08, -20, -03,  19,  22,  24, -19,  03,  04, -13, -16, -11, -05, -13,  12,  17,  08, -02, -09, -11,  13,  17,  02, -25, -16,  13, -14,  05,  16,  09, -08,  01,  16,  17, -03,  15,  16,  03, -07, -03,  16,  05,  11, -12,  19,  01, -20,  03,  24, -02,  19,  14, -08, -03,  15,  04, -15, -24, -14, -22,  12,  04,  06,  03, -02, -22, -05, -11,  07,  15,  11,  00, -05, -01,  13, -08, -23,  20,  20, -21, -07,  16,  18,  12, -12,  08, -09,  00,  11,  03,  05, -02, -16, -14, -22,  07, -10, -02,  21,  24, -11,  09,  01,  11, -15, -09, -22, -12, -14, -25, -06,  06,  17, -13, -07, -18,  23,  10,  10,  09, -10, -10, -15, -01,  04, -12, -19,  21,  14, -21,  22, -22,  15, -02,  16, -23,  16,  20, -08, -21,  22,  11,  10,  14,  24, -20,  24,  24,  17,  09,  08, -18,  24,  20,  06,  05, -16,  14,  01,  23,  20, -02, -22,  12,  23,  19,  15,  14,  16, -18,  18,  14,  19,  05,  05,  20,  11,  04,  19,  03, -12,  04,  13, -10,  00, -06,  22,  11, -14, -01,  11, -17,  24,  16,  23,  23,  12,  15,  14,  04,  22,  08, -05,  18, -10, -25,  15, -24,  07,  11,  07,  22, -09, -05, -11,  18,  16, -13,  06, -21,  13, -08, -10,  12, -17, -12,  10,  20, -22,  00,  01, -23, -15,  23,  23,  02,  24,  15,  04,  08,  02, -12,  05,  20,  10,  22,  13,  01, -16, -06,  08,  22,  13,  23,  11,  21, -12, -03,  18, -07,  24, -05, -03, -14, -07, -05,  13, -06, -14, -06, -21,  15,  07,  12,  10, -06,  09, -02,  23,  20,  19,  06,  19,  07,  06,  05,  05,  19, -21, -02, -11, -20,  20,  11, -09, -09, -18, -18,  10, -05,  01,  17, -15, -14,  04,  22,  05, -12, -05,  03, -17, -09, -14, -21, -25,  17,  09,  05,  13,  14, -20, -23,  21, -24,  14, -12, -06,  23, -05, -19, -05,  23,  23,  07, -14,  02,  04,  17,  17, -24, -03, -25, -08,  09, -19, -06,  03,  16,  24, -08,  07, -19, -04,  03, -16, -13,  18,  03, -15, -10,  10,  07, -09,  10, -11,  02, -12,  18, -06, -20,  19,  19, -17, -12,  03, -11,  07, -17, -18,  08,  02,  14,  17,  24, -05, -24, -14, -10,  05, -01,  06, -08, -17,  22, -23, -02, -01, -08, -07,  21,  00, -12,  15,  10,  03, -05, -24, -12,  03, -14,  21, -19, -25,  13, -18, -03,  17, -07,  13, -01,  19, -04,  16, -22, -07,  20,  03,  19, -10,  21,  15,  17, -14,  05,  02,  15, -23,  05, -22,  08,  16, -24,  14,  19,  17,  21, -09,  09, -09, -19, -17, -12,  02, -24, -09,  20,  23,  19,  15, -12,  15,  07, -18, -23, -10,  09,  19, -08, -08,  24, -25, -17, -25,  16, -23,  17,  14, -04,  03, -19,  02,  11, -04, -18,  14,  12, -21,  13,  08,  21, -22,  00,  04, -14,  04,  19,  22, -02, -14, -11, -03, -11,  00,  00, -20,  02, -06,  22, -25,  23, -20,  05,  09,  01,  12,  01, -10,  18, -11,  23,  15, -08,  00, -06,  05, -20, -10,  03,  05,  01,  19, -20,  17, -06,  05, -25,  22,  24,  22,  24,  24, -23,  04,  11,  03, -07, -13,  20, -13,  01,  18, -23,  20, -05, -02,  01,  00,  13, -19, -17, -09, -25, -12, -16, -05,  20, -14, -06,  19, -17, -05,  21, -13, -23,  07,  17, -05,  19,  12,  09, -03,  07,  13, -08, -23, -14,  20,  05,  24, -22,  13, -07, -19, -24,  04,  01,  21,  15,  22,  17, -25, -06,  13, -13, -04, -03, -21,  19, -09,  18,  03,  13,  00, -08, -17,  04,  05, -22, -16,  05, -18,  24, -25, -12, -23,  04,  16, -25, -06,  15,  20, -06, -16,  10,  06,  08, -17,  12,  02, -01,  07, -20, -12, -16, -01, -04,  13, -20,  01, -25,  12,  10, -24,  12, -25, -21, -09,  18, -21,  10,  10,  24, -19,  22,  10,  12,  05,  18,  01, -18, -06, -17, -11,  09, -06,  14, -18, -18,  19,  09, -16,  06, -04, -12, -05, -03, -08,  11, -08, -02, -02, -22,  00,  04, -25, -15, -09,  05, -20,  19,  14,  01, -21, -22, -14, -02,  19, -07,  07,  13, -21,  19, -04,  03, -18,  16, -25,  01,  04, -06,  24, -23, -03, -01,  06, -01,  11,  24, -21,  18,  18,  20, -05,  24,  24,  08, -01,  20, -22, -18,  09, -17, -22, -18,  11, -15, -24,  13,  11,  05, -18,  12,  08,  07, -13, -09, -19, -25, -09, -12,  19, -14, -17, -09, -12, -16,  24,  12, -20, -23,  19,  16, -13,  24,  23, -25, -16, -24,  13,  22,  07,  23,  10, -08,  07,  22,  10,  13,  22, -24, -24,  18, -10, -13, -16,  03, -04, -15, -10,  01, -12, -13, -06,  02, -14, -05,  03, -02, -04, -07, -05, -20, -09, -20, -03,  23, -21, -17,  14, -21, -14,  15,  22,  03, -23, -16, -17,  01, -06, -01, -21,  09,  13, -01, -13, -24,  19,  15,  01, -10, -17,  22, -04,  02, -21,  20,  02, -14, -20, -09, -10, -06, -16, -11,  22, -14, -02, -19,  14,  20,  07,  19,  04, -03, -07,  16,  00, -11,  06, -23,  06,  17, -24, -23, -06, -20, -25,  21, -09, -18, -10,  08,  03, -01,  23,  01,  12, -02,  09,  02, -07, -07, -04,  23,  17,  16,  14, -06, -20, -02, -04,  11, -08, -03,  16,  13,  05,  18,  11,  23, -25, -24,  07,  04,  00,  07, -18, -12, -20,  18,  17, -01, -12, -10, -03, -18, -19, -12,  01, -12,  13, -25,  24, -20, -03,  17,  18, -21,  10,  05, -20,  13,  08,  12, -06, -16, -04,  03, -01,  01, -04, -07, -25,  11,  08, -01,  18,  14,  13, -04, -21,  01, -04, -20,  09,  21,  23,  02, -25,  10, -16, -18,  00,  18,  19,  19, -21, -08, -01,  05,  19,  22,  23,  21,  08,  06, -04,  03, -03, -16, -25,  01,  12, -02,  08, -04, -06,  06, -24, -03, -06, -13,  04,  21, -20,  01,  18, -14,  18, -08,  16,  12],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([-10,  16,  09, -25, -01, -20,  04,  23, -09,  06,  01, -20, -21, -15,  04, -01,  18,  05,  23, -13,  19,  02, -14, -23, -22, -21, -12,  24, -04, -18,  13,  11,  23, -03,  12,  00,  04, -07, -02,  22, -24, -25, -20, -20, -13,  09,  06, -20, -09,  04, -05, -15, -16,  06, -13, -11,  10,  03, -12, -19,  10, -23,  20,  10,  01,  09, -15, -19, -23,  11, -20, -22,  13, -15, -15, -25,  19,  19, -20, -15, -02,  02, -02,  07, -17,  12,  24,  20, -10, -13, -21, -25, -11,  24,  13,  16,  10, -25,  24,  14,  11, -19,  19,  01, -08, -21,  01, -12,  23,  09,  01, -01, -12,  24, -17, -03,  11, -18, -06, -21, -05, -02, -19,  11, -01,  19,  04, -16,  22,  05, -25,  10,  12,  19, -13, -19, -24,  15, -06, -24, -01,  20,  00,  13,  21,  11, -13,  10,  18,  08,  14, -10, -18,  20, -21,  08,  17,  10,  20,  14, -09,  20, -01, -20,  17,  13, -14,  18,  04,  07,  19, -20,  03, -03,  20,  01, -17, -18, -12, -22,  18, -23, -06, -23, -25,  00,  10,  19, -15,  07,  10,  03,  03, -16,  08, -05, -25,  21, -12,  04,  04, -16,  09, -16,  06,  05,  10,  14,  14, -24,  20,  07, -20, -11,  09, -20,  16, -03, -24, -24, -21,  11,  07,  07,  23, -10, -21,  23, -13, -06,  02,  18,  04, -12, -23, -13,  18,  14, -21,  10,  15,  24, -08,  21, -10, -21, -22, -19,  01, -20, -16,  07,  16,  16, -08,  16, -16, -04,  14, -02,  18, -07, -09, -01,  07, -05,  11,  02, -16,  17, -13, -23,  16,  07,  23, -17,  11, -22, -09, -11, -17,  01,  21, -23, -06, -12,  20,  05,  12,  10, -20,  05, -20, -02, -21,  12,  18,  17, -08, -20,  10,  06, -16,  03, -12, -18,  14, -24, -13, -20, -10, -04,  08, -11,  00, -20,  02, -05,  10, -09, -18,  18,  21, -12, -09, -23, -23, -13,  22, -04, -06,  07, -22,  03, -13, -09,  12, -24, -07,  24, -18,  10, -03,  17,  24,  24,  22,  04, -05,  10,  20,  04,  03,  19,  19,  21,  23,  22, -17,  20, -05,  04,  04, -02, -18,  17,  15,  19,  20, -15,  21, -23,  22, -07,  20,  22, -05,  19,  03,  17,  04, -02, -04, -18, -06, -09, -21, -07, -10, -11, -10,  10,  19,  20, -14, -22,  12, -22, -25,  07, -12,  21,  12, -15, -09,  09, -16,  11,  03,  12,  03, -17, -12, -23, -08,  09, -07, -02, -23,  10,  15, -05, -03,  11, -10,  08,  14, -21,  11,  16,  13, -24,  12,  00, -13, -19, -14, -02,  19,  15, -14, -02, -25,  01,  02, -06, -15,  22,  18, -10,  07,  08,  10, -19, -06, -25,  15, -15, -21,  01, -23,  17,  05,  16, -05,  19,  22,  08, -08,  19, -02,  05, -06,  00, -19,  21,  20, -08,  18,  15,  07,  02, -02, -06,  08,  19, -06, -02, -19,  00, -23, -15, -06,  07, -23,  16,  01, -24,  00,  20,  20, -25,  01, -11,  01,  07, -15, -02, -24, -20, -12,  10,  07,  13, -21, -09,  07,  00,  16,  15, -23,  18, -24, -03,  02, -22, -10, -20, -19,  15, -22, -21,  18,  04, -05, -06, -12,  08,  19, -10,  13, -18, -23, -04,  20, -16,  14,  04,  09,  05, -06,  12,  01, -05, -14, -20,  00,  01, -14,  09, -06, -11,  13, -13,  20, -15,  08, -17,  18,  02,  00,  07,  09,  05, -20,  06,  14,  19, -15, -02, -01,  06, -13, -23, -23,  00, -17,  04, -23, -06, -12, -02,  10, -22,  12,  07, -11, -05,  17, -18,  24, -07,  16,  08,  23,  21, -09,  14,  17,  01, -13, -08, -18,  02, -06, -14, -23,  02,  18, -19,  23, -17,  04,  10, -11, -09, -06,  03,  13, -13,  12,  12,  07,  06, -03,  07,  04,  13, -04, -03, -09,  10,  16,  01, -13, -15,  14, -10,  15,  07, -02,  15,  16, -20,  03, -18, -04,  22,  10, -15, -14, -01,  24,  18, -18, -03,  00,  12, -15,  21, -16,  04,  07, -25, -20,  21, -13,  19, -12, -21,  04,  12,  22, -03,  17,  00,  04, -10, -01, -09,  02,  11,  17,  02,  04, -25,  24, -20,  12, -14, -22,  23,  15,  10, -25,  22,  07, -13,  19,  20, -06, -02,  09, -09,  22,  01,  16,  01,  17, -08,  17, -06, -20,  09,  23,  10,  11,  22,  17, -02, -14,  22, -02, -22,  08, -02, -24, -08,  13,  22, -11, -18, -03,  24, -02, -06,  02, -09,  20, -04,  08,  14,  16,  14, -02,  14,  01, -15,  14, -05,  10, -23, -08, -14, -20, -23,  09, -17, -04, -03, -18,  11,  04,  04,  12, -23,  23, -11, -07,  18,  11, -21,  07,  04,  20, -17, -05, -04, -05, -14,  18, -18, -12, -15, -07, -04, -10, -22,  06,  11,  00,  14, -03, -18, -07, -14, -14, -08,  01,  07, -13, -11,  11,  22,  20,  06, -20, -08, -21,  02,  04,  24,  09,  19, -14, -22, -10,  01, -17,  22, -12,  10,  13,  12,  17, -19,  24, -21,  00,  02,  11,  13,  16, -01,  12,  13, -18,  17, -20, -12, -04,  09, -13, -20,  04, -02, -15,  21, -25, -07,  20, -10, -21,  08, -23,  21,  17, -24, -23, -08,  03,  15, -18, -04, -09,  19, -16, -02,  13, -10,  11, -16, -24, -25, -10,  07,  01,  02,  06,  03,  21,  01,  18, -25, -13,  20,  23, -21,  22, -22, -04,  02,  18,  04,  24, -13,  00, -15,  10, -11,  02, -01, -02,  04,  01,  15, -12, -23, -07,  19,  05, -11, -02, -02, -09,  10, -04, -09,  16, -07, -06, -11,  22, -10,  20,  23,  02, -04, -16, -11,  10,  11,  13, -17, -08, -08, -24,  08, -06, -06,  02, -23,  10, -23,  00, -22,  14,  21, -06,  05, -09,  16,  22, -09, -17,  17, -11,  12, -12, -02, -24, -25, -13,  17, -16,  06, -16, -13, -11,  05,  06,  19,  07, -07,  21, -15, -04,  13, -17,  17, -05,  02,  10, -08,  18,  20, -15, -18,  07,  00,  08,  11,  01,  22,  05,  12,  03,  16,  24,  20, -02,  07,  14, -19, -25,  12, -07, -02,  00,  01, -08,  21, -22],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([-20, -12,  23, -25,  00, -17,  10, -22,  18, -02,  04,  15, -20, -07, -05,  21, -08, -08, -06, -24, -19,  02, -22,  21,  20,  03, -04, -01,  22, -06,  04, -23,  10,  03, -20, -15,  13,  17, -12,  06, -08,  19, -02, -03, -13,  20, -07,  06, -12,  14,  09, -04, -06,  12, -08, -11, -08,  16,  13, -10, -13, -07, -06,  22,  23, -01, -15,  11, -07, -02, -08,  10, -05,  17, -16,  09,  12,  04, -07, -23, -06, -23, -01,  13,  17,  18, -21, -16,  11,  20, -01,  24, -10,  19,  23, -12, -05, -17,  24,  16,  09, -07,  03, -21, -13,  13,  15,  24, -08, -17, -21,  13, -14,  03,  01, -20, -02,  08, -11, -13,  03,  14, -12,  18,  10, -14, -19, -18, -05, -18,  23, -19,  02,  02, -13,  16, -10, -23,  15,  07, -14,  21, -04, -01,  01,  24,  06, -25,  07,  20, -11, -13,  11,  02, -20, -04,  13, -12,  04, -15, -03,  02, -07, -24, -19,  05,  17, -04,  08,  10, -19,  21,  06,  04, -03, -17,  05, -22, -15, -12, -25, -01,  00,  12, -24,  08, -17,  16,  21,  14, -21, -04, -06, -03, -03,  00, -22, -10,  24,  13, -25, -20,  11,  06,  11, -17,  16, -09, -12, -24,  04, -12,  00, -18, -25,  03,  17, -14, -05,  15, -23,  01, -14, -04, -25,  09,  24, -22, -24,  23,  18, -24, -20,  04,  09,  16,  14,  01, -18, -23,  02,  14, -09, -20,  23, -07,  08,  15,  06, -20,  05,  09,  06,  17, -20,  07,  03, -21,  12,  04, -21,  08,  07, -16, -13, -09, -25, -23,  19, -15, -19, -03,  24, -01,  02,  24,  20, -15,  14,  01, -07, -04, -15,  24, -10, -07,  08,  18, -01, -02, -03,  04, -19, -19,  15, -05, -02,  18, -03, -06, -22,  06,  16, -21, -18, -05, -22, -23,  08,  19,  04, -24, -10,  16, -23,  06, -16,  11,  01,  09, -14, -24, -10, -08, -18, -18,  12,  07, -25, -13, -23, -20,  20,  18, -14, -23, -09, -11, -20,  24, -15,  11, -23,  01,  02, -21, -16,  12,  17,  10, -02, -20,  11,  15, -03,  19,  22, -13,  01, -25, -01,  03, -20, -06, -01, -08, -04,  15,  08,  03,  16,  19, -11,  20, -03,  17, -24,  06,  06,  19, -09, -19,  24, -20,  21, -01,  24,  20,  11,  02,  20, -13, -19, -24,  08,  07, -05, -19, -01, -20,  10, -10,  24,  24, -15, -02,  18, -12, -21, -01, -18, -02,  07, -16,  03,  03,  10,  04, -01, -02, -19, -04,  10, -11, -01, -07,  21,  19,  01, -05, -25, -14,  12, -24, -12,  24,  00, -17, -12,  06,  10, -03, -21, -08,  08,  09,  21, -07, -12, -03,  18, -03,  18,  03,  11, -07,  23,  10, -11,  00, -18, -11,  13,  22, -07, -22,  23,  18, -13, -14,  01,  22,  11,  08, -11, -06, -08, -13,  15,  08,  09,  10, -18,  05, -11,  20,  23, -11,  05, -11,  16,  15,  06,  07,  12,  24,  10,  10,  19,  22,  24, -05,  21,  10, -22, -14, -19, -02, -02,  23, -19, -15,  09, -12,  15, -25, -17,  15, -09,  16, -21, -17,  06,  10,  17, -05,  11,  02, -20,  05,  02, -19, -22, -02,  18, -19,  11, -25,  04, -15, -25,  12, -03,  11, -23, -11,  13, -12, -21, -20, -21, -15, -10,  12,  23, -18, -18,  11,  09, -11, -08, -12, -04, -03,  12, -11,  03, -02, -09, -15,  10, -06,  24, -18, -20, -23, -02,  19, -08,  04,  24, -04,  15, -09, -15,  15, -02, -06,  01, -16,  08,  20, -02, -19, -06, -15, -02,  23,  10,  14, -15, -04, -17, -14,  05, -09, -12, -21, -13,  07,  08, -12, -22,  00,  04, -10, -08, -23,  09,  21, -14, -05,  18,  11,  01, -12,  23,  24, -12,  09,  16,  00, -18, -24,  11,  14, -06, -23,  18,  06,  09,  04,  19,  13, -19, -02, -20, -01,  02,  15, -05,  16, -15, -10,  02,  13,  03,  01,  13,  16, -13,  06, -09, -06,  07, -22, -17, -23, -20, -21,  10,  14,  10,  05,  04,  16, -22,  12, -10,  08,  02,  12, -01,  14, -22, -24,  02,  06,  02, -08,  00,  14, -25,  18, -15,  10,  21, -04,  14, -22,  00, -01,  20, -15, -21,  01, -24, -15, -12, -06,  18,  17, -17, -08,  06, -14, -05, -14,  20,  23,  05, -03,  14,  06, -10, -23, -09, -11, -02, -20, -08,  23,  04, -11, -15,  11,  18, -12,  23, -19,  07,  16,  24,  16, -15,  07, -21,  05,  18, -24,  05, -01, -02, -03, -18,  14, -01, -02, -22,  22,  05, -03,  22, -14,  14, -18,  22,  07, -03,  20,  15, -20,  13,  14,  23, -25, -01, -21,  08, -06, -19, -12,  20,  04,  12, -23, -05, -14,  00,  00, -15, -18,  23, -16, -06,  14, -07, -09, -04,  16, -11, -14,  21, -21, -22,  21, -20,  02, -25,  13,  21, -17, -22,  19,  13,  18,  21, -15, -21, -01,  11, -08,  06,  11,  01, -25,  00,  22, -06,  23,  13,  10, -14,  11,  14, -11,  07,  21,  18,  09,  11,  17,  18,  17,  11,  08,  10,  09,  18,  16, -17,  04, -17,  15, -10,  12,  17,  17,  09, -12,  15, -03,  23, -23, -15,  15, -07,  17,  11, -11,  03, -02, -17, -02, -08,  19, -19, -23,  03, -25,  18,  14,  06, -21,  06,  24,  18,  00,  16,  04,  14,  07, -24,  12,  11, -12,  02, -19, -20, -09, -05,  10,  16,  03, -16, -17, -01, -10, -13, -20, -08, -20,  19,  24, -14,  00, -25, -21, -23,  16,  08,  16,  00,  11,  06, -14, -24, -15, -07, -19,  01,  15,  19, -08, -06, -22,  02,  20, -05,  14, -25,  13,  22,  21,  14, -15, -02,  14, -10,  01,  07, -25, -08, -17,  14,  23, -04,  15, -16,  16,  24,  12,  07,  20, -18, -22,  23,  09,  23, -07,  01, -24, -17, -02,  22,  24,  08, -04,  13, -25,  22, -02, -22, -09,  06,  19, -10, -23,  11,  01,  21,  10, -10,  03,  05, -03,  08,  05, -18,  08, -24,  08,  09, -16, -17,  09, -16,  16, -20,  24,  19, -21, -03,  22, -05, -20,  16,  12, -15,  04, -10, -19, -08],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);


//length == 1024
  check([-15, -22, -10, -01,  15,  21, -14,  13, -14, -10, -22,  18, -05, -11,  00,  15,  12, -14, -09,  12,  18, -07,  20, -17, -11, -19, -05, -17, -18, -02, -02, -05,  04,  13,  19, -04,  12, -17, -14,  23,  00, -11,  18,  20,  04, -05,  10, -09,  06, -22, -20,  01, -01, -23,  10,  13, -16, -20,  22, -07,  06, -05,  15, -13, -15,  10,  08,  24,  20,  19,  22, -05, -14,  17, -08,  15, -12, -22, -17,  19, -17, -09, -02,  07, -07, -17, -02,  04, -10, -03, -25,  21,  19,  15, -15, -21,  02,  18, -21, -03,  15, -22,  19, -24,  23, -13,  18, -14, -08, -24, -18,  00, -06,  05, -15,  15,  15,  08, -06, -19, -18, -04, -21, -24, -11, -10, -20,  16, -15, -14, -09, -23, -08, -13, -22, -10, -01,  21,  03,  16, -25,  12, -06, -06, -07,  04, -16, -17, -11,  06, -09, -04, -21, -04, -03, -07,  11,  04, -15,  23,  18,  03, -24, -15,  15, -19,  02, -08, -20, -20, -17, -20,  17,  04,  01, -13, -17,  13, -02, -01, -04,  14,  20,  00, -15, -06,  19,  23, -24, -19,  22,  19,  11, -25, -19,  01, -19,  08,  18, -14,  15, -21, -07,  09,  08,  22,  24,  19,  12, -03, -07, -17, -14, -09,  10, -01,  12,  04, -01,  13,  12, -04,  07, -02, -02,  15, -25,  05,  00,  20,  18, -10,  24, -11, -23,  10, -14, -24,  04,  23,  00,  24, -17,  13, -08,  18, -13, -20,  00,  12,  18, -13, -15,  03,  11,  11, -07,  13, -09,  19,  08, -14, -14,  10,  00, -10, -03,  11, -09, -22,  11,  18, -23,  19,  07, -03,  15,  19,  02, -10,  08, -03,  02,  21, -25, -10,  07, -04, -22, -25, -10,  14, -14,  03,  01,  14,  19,  23,  02, -13, -24, -11, -19, -20, -15,  13,  02, -25,  09, -19, -10, -05,  04,  20, -09,  04, -15,  23, -25, -09, -25, -08, -20, -14,  23,  08, -25,  19,  06,  05, -19,  09,  19, -11,  16, -19, -23, -04, -16,  14,  02,  01, -16, -19, -04,  02,  13,  09,  02,  15, -25,  02, -15, -18,  15, -17,  15,  18, -23, -02, -02, -15, -16, -06,  00, -25,  00,  04, -04,  09, -05,  24, -14,  06, -18,  09, -17,  20, -07,  10,  13, -07, -11,  23,  02, -20, -17, -06,  23, -13,  17, -02, -03, -24,  17,  24, -23, -08,  06,  00, -21, -24,  01, -08,  08,  09, -24,  18,  06, -05,  06, -06,  15,  20, -06, -05, -23,  02,  14, -23,  14,  07,  00, -11,  10, -06, -10,  14,  14,  21, -10,  18, -25,  16, -13,  08,  02, -12,  03, -16,  10, -16,  05,  03, -18, -25,  23, -14,  02,  14, -09, -06, -02,  16,  08, -16, -12,  23,  23, -23,  20, -10,  22,  20, -16, -16,  05,  11, -01, -15,  20, -13, -03,  03,  15,  04,  03,  15,  17, -20,  04, -17, -01, -22, -23, -16, -11, -10, -17, -11, -06, -20,  05, -09, -23,  14,  02,  09,  00, -24,  19, -02, -12, -09, -24, -20,  22,  06,  20,  15,  13,  02, -25, -10,  07, -23, -01,  21, -08,  09, -15,  13,  14,  15, -21,  18,  06,  08,  02, -16,  10, -01,  09, -25,  17,  12, -17,  17, -07, -22,  09, -19,  07,  09, -04, -11,  12,  23, -15, -19,  07, -04,  20, -01, -12, -24, -08,  22,  10,  22, -19, -03, -04,  15, -01, -12,  02,  07, -20,  22,  11,  14, -20, -07,  01,  04,  08, -10,  02,  20, -04, -14, -07, -07,  10,  09, -03, -22,  06, -18, -25,  12,  06, -02,  04, -20,  11, -17,  13,  19, -18,  01,  10, -13,  19, -12,  16,  04,  03, -05,  02, -23,  07,  20, -05, -08,  04,  19, -03, -15, -24, -01,  24,  09,  22,  05,  15,  11,  15,  03,  07,  22, -21, -08, -15, -25,  06, -22,  07, -14, -01, -16, -12, -19, -21,  11, -02,  11,  05,  23,  23,  07, -03, -25, -09, -05,  05, -17, -19, -04,  11,  13, -07,  15, -18,  05,  18,  15,  09,  00, -23, -17,  09, -08, -09,  15, -22,  16,  01,  09,  14,  02, -07, -13,  02,  09,  09, -16,  20,  15,  05,  06,  05, -24, -01,  14,  06, -08,  07, -08,  17,  11,  02,  03, -22,  18, -07, -18,  10,  22,  16, -01, -01, -16,  13, -22,  20, -03, -13,  15, -11,  20, -03,  19,  21,  21,  11,  04, -10, -07,  24, -18, -21,  01,  12, -18, -05, -20, -11, -20, -21, -18,  04,  05, -09, -05,  08, -13,  17,  23, -23, -18,  18,  01, -22,  14, -01,  14, -05,  14, -16, -06,  23, -12,  23,  10, -02, -07,  18,  14, -02,  24,  22, -21,  05, -10, -01, -12,  02, -06, -12,  07,  01, -19, -17,  04,  22,  10, -04, -07,  01,  05,  14,  00,  21,  12, -13, -04, -18, -18, -13,  07, -18, -16,  14,  14,  02, -10, -21, -21,  09, -07,  13, -15, -01,  24,  17, -03,  09, -10,  17, -15,  20,  06,  12,  18, -04, -23, -09,  05, -16,  04, -12, -07,  15, -23, -18, -08, -08, -13, -01, -23,  05, -13, -11, -21, -14, -17,  01,  20,  00, -05, -17, -02, -21,  20, -09,  00,  22,  08, -20, -16, -11, -05,  02, -21, -03,  10, -03,  17,  22,  21,  21,  04, -17, -13,  08, -03, -04, -13, -08,  21,  07,  02, -06,  11, -02,  13, -12, -03, -02, -04,  06,  12,  16, -16,  16, -09,  21, -12, -17,  18, -14, -21, -01, -05, -09, -18,  19,  14, -04, -14,  13, -19,  14, -18,  19, -11,  22, -17,  11, -05,  06, -07, -16, -01,  04, -24,  15,  00, -09,  23, -05,  03, -23,  19, -25, -04, -24,  19, -15,  00, -18,  23,  06,  23, -17,  00, -13, -20,  10, -24,  03, -09, -06,  12,  16,  23,  15,  08,  00, -18,  07,  20,  12,  11,  14,  12, -18,  17,  08, -07, -08,  17, -07, -25,  16,  01,  01, -20,  09, -12, -19, -13,  07,  02, -24,  00,  02,  17, -17, -23, -24,  15,  22,  13,  02,  11,  02,  11,  04, -13, -21,  23, -21, -02,  24,  20, -24,  02, -22,  10,  15, -16,  24, -03,  14, -24,  24, -09,  20, -17, -04,  21],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([-25, -07,  11,  02, -18, -12, -09,  13,  00, -03,  11,  04,  22,  10,  02,  24, -11,  05,  09, -20,  16,  11,  04,  05,  12,  06,  24,  09,  14, -05,  05,  14,  15, -09, -06,  22,  06,  10,  12, -17, -18, -01,  12, -20, -14, -09, -21,  01,  23,  15,  08,  15,  01, -11, -03, -10,  20, -02,  24,  09,  20,  06,  01,  11,  24,  20,  10,  05,  07, -02,  13,  14,  24,  03,  21, -15,  21, -23,  13,  20,  18, -02,  12, -04,  13, -14,  14,  10,  10,  15, -05,  07, -01,  23, -05, -02,  18, -17, -19,  00,  08,  21, -09,  07,  01, -12,  19, -02, -10,  10, -05, -15, -17, -18,  09,  21, -05,  00,  07, -20, -10, -21,  15,  14, -23, -15, -10,  22, -07, -04, -01, -24, -06,  15,  08,  21, -20,  05, -06, -02, -10,  16,  08, -02, -25, -06, -03, -05,  19, -19,  03, -13, -13, -07, -22, -09,  03, -07, -12,  24,  16,  14, -25, -14,  04,  11, -18,  10, -09,  03, -17,  08, -04,  18, -19, -04, -10,  05,  16, -16,  13, -04, -02, -25,  14,  02, -09, -05,  22,  06, -06,  14, -05, -04, -23, -23, -18, -16,  14,  00,  14,  24, -17, -15,  17, -08,  06, -18,  24, -01, -06,  13,  23,  19,  13,  12, -04, -18, -16, -04,  15,  05, -15, -14, -23, -11, -10, -14,  00, -21,  12, -11, -22,  20,  01,  22, -11, -16, -18, -11,  10,  03, -23,  08, -03,  17, -02,  21, -24,  07, -08,  17, -12,  04, -20, -08,  18, -05,  03, -07,  01, -10,  09,  04, -12, -15,  03,  04, -04,  12,  18, -19, -10,  22,  15,  15,  15, -12,  11,  16,  22, -22,  10, -15,  09,  15,  04,  02, -15, -17,  22,  13,  00,  06, -08,  15,  18,  23, -05, -11,  10, -10, -05, -22, -12, -15,  18, -20,  00,  04,  23, -02,  09,  09,  10, -07,  01, -10,  22,  14,  00,  19,  02, -25,  00,  22,  18, -07,  20, -12,  07,  07,  05, -21,  10,  20, -08,  05, -25,  17, -16, -24, -08,  20,  12, -22, -12, -12, -07, -15, -23,  18, -21,  05,  20,  06,  04,  13,  24, -01, -22,  08, -17,  09,  13,  19,  06, -20, -01,  09,  24,  11,  10, -08,  08, -03, -05,  24,  12,  15, -14,  17,  10, -07, -01,  07,  24, -22, -04, -24,  04,  01,  09,  12, -13, -01,  08,  19,  06, -15,  03,  06,  23, -10, -25,  06,  14, -03,  05,  01, -13,  17, -07,  24, -15,  17,  06, -14,  20, -23, -13, -01,  06,  24, -11,  18, -02,  22,  12, -18, -16, -08,  15, -18,  07,  15,  14, -04, -13, -04, -25,  01, -10, -07,  00,  00, -12, -19,  12, -17, -14, -24,  10,  19, -25, -24,  12,  01,  23,  02,  08, -17,  19, -02, -08,  04, -10, -17, -25,  02,  05, -25, -20,  20, -04,  07, -02,  09,  13, -13,  19, -24, -12,  06,  20, -09,  07,  10,  17,  08, -13,  00,  18, -17, -25, -15,  12, -10, -06,  15,  19, -24,  17,  24,  23, -12,  06, -04,  24, -04,  10,  19,  00, -24,  00, -05, -08, -15, -18, -14,  18, -06,  11,  11,  05,  13,  21, -08, -22, -08, -18,  22, -07, -23,  23, -08, -10,  04,  15, -08, -25,  01, -12,  02,  02,  15, -25,  21, -25, -18, -18,  18,  04,  20,  06, -16,  08,  03,  01,  13,  22,  11,  10, -09,  15,  08,  10, -18, -11,  00, -01, -11, -24,  12,  19,  05,  03,  19,  01,  05, -24,  10, -01,  05,  05, -20,  14, -12,  10, -07, -24,  08, -19,  13, -24,  21, -02,  11, -22,  12, -14,  03, -21, -10, -08,  23,  20,  22,  17, -01,  03,  18, -16, -21, -01,  15, -14, -10, -20,  22,  10, -16,  07,  16,  24,  08,  12, -02, -06,  18, -15,  07, -02, -11,  22,  15, -13,  20,  15, -21, -06, -07, -25,  03, -03,  01, -05,  08,  16,  03,  07,  02,  14, -11, -05,  13,  24, -15, -14, -07, -22, -01, -22,  01,  13, -25, -07, -22,  20, -15, -18, -11,  03, -16,  20, -23,  10, -08,  13,  04,  22, -05, -17,  11,  12,  03,  02,  11,  13,  13, -18,  18, -13, -15, -04, -22, -15,  17, -19, -17, -23, -10, -01,  06,  00, -04,  10, -13,  16, -02,  16,  13,  19,  24,  02,  08,  05, -21, -06, -07,  19,  01, -13, -18,  13,  10, -13,  24,  02, -07, -16,  05,  10,  08, -12, -15, -20,  23, -02,  21, -01, -09,  09, -07, -07, -12, -22,  23, -08, -03, -09, -13, -24,  05, -04,  14, -09,  08,  15,  20, -22,  24,  00,  13,  10,  15, -24,  15,  14,  01,  11, -12,  17, -03,  08, -15,  13,  13, -17, -20, -15,  02, -06, -12, -16,  15, -22,  00,  00,  20, -02,  05,  22,  23, -06,  07,  16, -05, -03,  07,  23, -15,  22,  15,  09,  07, -22, -03, -05, -12,  05,  05,  15,  24,  21, -23,  17, -24,  02, -06,  21, -23, -25,  18, -22, -04,  02,  19,  16, -24,  01,  16, -14, -02,  06,  23, -20,  11, -03,  00, -25, -23, -18,  17, -21, -22,  19,  23, -21, -01, -06, -22,  01, -06,  23,  04,  15,  01,  00,  08,  02, -24, -01,  16,  01, -17,  16,  06,  21, -12, -17,  21, -07, -09,  16, -01, -04,  10, -01,  01, -14,  18,  06,  13, -10,  04, -06, -18, -18,  20,  18,  10,  23, -08,  03,  00,  02, -06, -17, -01,  09, -08, -03, -23,  08, -12,  03, -19, -24, -23,  09, -13,  21, -10, -23, -14,  22, -01, -07, -21, -04, -14,  16, -06,  06, -06,  21, -15,  15, -20,  11,  00, -03, -16,  04, -18, -01, -17, -12,  02, -15,  23,  17, -19, -10,  19, -06, -13, -05,  15, -08,  16, -22, -17, -12,  09,  05, -16,  22, -05, -11,  08,  20,  13,  19,  00,  20, -04,  10, -14,  23,  20, -14,  15, -21,  01,  12,  00,  14, -16, -10, -17, -24, -06, -07, -09, -20,  23,  02, -21, -06,  19,  13, -09,  07,  09,  18,  05, -20,  03,  16, -19,  01, -23,  21,  05,  05,  10, -20, -04,  20, -02,  04,  23,  19,  23, -11, -24,  23,  16, -19, -06,  12,  19],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([ 13, -05,  05,  06, -25,  11, -13,  18,  17,  13,  22,  15, -05,  02,  01,  02,  24, -02, -25,  05, -04,  21,  05,  10,  23,  06,  03, -21, -25, -09, -25,  13,  13,  05, -03,  15, -07,  09,  08, -13, -01,  05, -20,  19, -16,  06, -02, -15, -21,  01,  16,  02, -03, -02, -11, -05, -21,  17,  01, -20, -15,  03,  20, -25, -16, -08,  15,  04, -22, -02,  19,  02, -20,  24, -04, -10,  07,  22,  00,  13, -02, -07, -10,  20,  19,  04, -07,  23, -04,  19, -20,  09, -02, -22,  09,  09, -05,  02, -10, -01, -25, -16, -22, -19, -17,  02, -02,  17, -01, -25,  05,  22, -06,  20,  17, -10, -01, -13, -12,  23, -18, -04,  09,  07,  01, -07, -07,  21,  20,  08, -03,  23,  20,  01, -19, -22, -22,  04,  23,  02,  06,  03,  01, -25, -01, -07, -10,  23,  06,  06,  23,  15, -21,  07, -01,  05, -22,  17,  03, -25,  02, -24,  23, -03,  04, -19,  03,  09,  12,  01, -14, -06, -21,  12, -04,  03, -18,  12,  04,  15, -05,  04,  07,  01, -13, -17, -19, -10, -25,  09, -08,  03,  12, -07, -23, -09, -01,  05, -25, -11, -19, -12,  08, -14, -23, -21,  16, -13,  18, -03, -23, -10, -23,  12,  16, -09,  20,  24,  08,  23,  11, -25,  01, -02, -07,  05,  17,  20, -14,  19, -16, -08, -17,  19,  05, -13, -25, -01, -01,  21,  23,  04, -14, -25, -07, -20, -07, -12, -21, -24, -14,  17, -21,  14, -09, -01, -05, -15, -06,  06, -21,  05, -25, -11,  01,  08,  02,  02, -18, -22,  00, -18,  09,  13, -15, -23,  18,  03, -09, -25,  07,  04,  17,  11, -06, -15, -15,  16, -05,  07, -01,  00, -11,  01,  16,  16, -16, -07, -05, -07, -01,  20,  01, -17,  08,  11, -14,  04, -09,  04,  06,  23, -17,  00,  09,  02,  11,  22, -05, -17,  04,  19,  10,  18, -04,  02,  09,  07,  22, -19, -24, -04, -24,  04,  07,  12, -10,  18, -07,  08, -03,  24,  07,  05,  01, -07, -15, -11, -10,  05, -02,  21,  02, -15,  15, -25,  12,  01,  07,  12,  08,  08, -17,  11, -13,  15,  00,  04,  10,  18, -12, -16,  19,  22,  15, -04, -10, -23,  12,  08,  09, -15,  04, -12, -02, -04, -12, -15,  23,  21,  22,  08,  06, -17, -04,  19, -25,  22,  00,  13,  15,  13,  22,  12,  12,  14, -17, -22,  16,  22,  11,  03, -15, -08,  16,  08,  14, -18,  20,  14, -22,  18, -01,  09, -22,  20,  05, -20,  19, -17,  18,  12,  21,  16, -01,  11,  05,  09,  14, -01,  06,  02, -21,  16,  21,  20, -01,  10, -23, -05,  01, -18, -10, -25,  19, -05,  23,  01,  00,  17,  09, -06,  06,  08, -13, -20, -06,  17,  16, -15, -07,  00,  12, -03, -09,  08, -05,  18, -04, -01, -10,  22,  07,  07, -25,  03, -23,  23, -21,  04,  17,  16,  23,  01, -01, -15,  06,  20, -20,  00, -20, -02, -25,  19,  23, -07,  02, -07, -12, -25,  17,  03, -25,  01, -13, -25, -21, -11, -25, -14,  21,  19, -23,  19, -05,  01, -18, -21, -04, -11,  04,  03,  12,  06, -03,  12,  24, -24, -20, -12, -23,  23,  18, -21, -01, -19, -21,  04, -03, -19,  17, -07, -23,  19, -10, -02, -03, -01,  04,  20,  13, -17, -02,  02,  16,  22, -10,  15,  23, -05, -20, -25, -05, -24, -19,  20, -18, -13,  01,  06, -07, -07, -25, -04, -11, -08,  21,  11,  16,  00,  08,  04,  10, -17, -17,  01, -20, -02, -07, -22,  21,  01, -19, -09,  02, -13, -12,  11,  00,  14, -08,  20, -16, -06, -07, -02,  11, -11, -14,  02,  16,  19, -17,  01, -21, -06, -21, -16,  17,  00, -10,  15, -24, -04, -16,  03,  10, -03, -11, -15, -13,  08, -17, -04, -22,  01,  22,  14,  16, -17, -06,  09, -20,  02, -14, -14,  23, -08, -04,  16,  17,  11,  08,  18, -16,  17, -02,  19, -10,  14, -18,  04, -02, -10, -23,  03,  16,  24, -08,  09, -15,  11, -06, -08, -09,  07,  03, -11, -24, -24, -18,  19,  14,  18,  14,  23,  10, -10,  18, -23, -19, -25,  08,  04, -10,  11, -16, -17,  12,  02,  20,  24, -10, -09, -07,  08,  23,  24, -25, -24, -25, -16,  20,  15, -23,  12,  13,  15, -23,  08,  19, -17,  10,  03,  15, -25, -09,  24, -14, -20,  03, -19, -20,  21, -03,  00,  06, -03, -01,  06, -02,  02,  18, -04, -08,  22, -15, -18,  12, -11,  18,  09, -03,  03, -11, -11,  06,  05, -09,  17,  10,  21, -25,  17,  17, -01, -07, -01,  21,  17, -18, -04, -04, -25,  17,  13,  23, -23,  23,  12, -09,  18, -04,  16, -04,  10, -18, -23, -08,  00,  21, -20, -03,  21,  22, -11, -03, -08,  15, -07, -13,  23,  17,  08,  23,  09, -01,  23,  14, -01,  11, -18, -08, -16, -25,  13,  20, -15,  18, -11,  10,  14, -04, -18,  13, -04, -01, -15,  13, -09,  06, -25, -11, -02,  11, -10, -16, -15, -12, -25,  09, -24, -15, -24, -14, -15,  16, -17, -03,  09, -03, -17, -01,  19, -08, -11, -10,  18, -01, -20, -15, -18, -17,  01,  05,  19,  18,  15, -19, -18,  17,  15, -15, -23,  18, -04, -10,  09,  04,  12, -06, -21,  22,  20,  23, -10, -14, -10, -15,  12, -03, -05,  20,  05,  24,  00, -01,  17, -08,  05, -24, -13, -03, -13, -11, -08,  08,  04, -23, -12, -08, -02, -08, -09, -05, -08,  06,  06,  09,  17, -07, -19, -11, -12,  12, -12,  16, -12, -19, -15,  21, -18, -03, -05, -06,  14,  13, -20, -07,  15, -07,  12, -10,  12, -21,  10, -19,  12, -07,  15,  06,  13,  21,  21, -21,  10, -14,  22, -24, -06, -18,  22,  04,  07, -08, -25, -04, -18, -20,  16,  22, -02,  06, -11, -13,  12, -24, -07, -01, -06, -17, -17, -17, -18, -19, -13,  19, -08, -16,  20,  12, -07,  19, -07, -23, -11, -07,  00, -04, -01, -06, -04,  24, -25,  12, -13,  14,  14,  05, -12, -17,  16, -02, -07],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([-25,  04,  07,  19,  22,  18,  17,  11, -11,  13, -19, -09, -21, -01,  19,  03,  23, -12, -24,  23, -12,  13, -13, -21,  02,  19, -06,  13,  10,  18, -19,  10, -03,  16,  07, -04,  09,  01, -16, -25, -11, -10, -08, -04,  15, -12, -24,  15,  01, -23,  15,  16,  15, -23,  20, -05,  22, -11, -17,  09, -18, -09, -03,  07, -18, -19, -22,  19,  07, -10,  21,  23,  07, -10, -06, -03,  03, -05, -10, -21, -01, -20,  20, -08, -15,  17,  12, -16, -18,  22,  20, -09, -12, -08,  23, -02, -02, -21, -06, -18, -06, -10, -19, -24,  06,  02,  01, -14,  23,  18, -09, -01, -25, -12,  16, -15, -19,  03, -04, -12,  02, -06,  06,  18,  13,  05, -07, -13,  09,  12, -04, -20, -21,  02, -17,  12, -20,  09,  24, -20,  02, -10,  04,  03,  05, -02,  15,  11, -22, -11, -24,  06,  08,  08, -01, -04, -10,  17,  10,  24,  06, -18, -19,  10,  11, -11,  00,  16,  24, -01,  23,  03,  16,  03, -17, -04, -22, -24, -15, -19, -08, -14,  12, -25,  21, -12, -02, -14, -20, -14, -13,  13, -07, -07, -01, -19,  08, -24,  23,  09,  00,  23, -11, -07,  03,  00,  14,  06,  03, -24,  13,  20, -10,  00,  22, -14,  16, -05,  00,  21,  06,  12,  10, -24, -17, -14, -17,  18, -13, -17,  04,  14, -17,  18, -18,  12, -05,  23, -07,  23, -23, -19,  18, -08,  09,  15,  03,  00, -12, -20, -02,  21,  18, -15,  23, -24, -02, -17,  19,  12, -07, -02,  01,  01, -07,  10, -12,  16,  09,  09,  14,  11,  15,  10, -20,  01,  00,  08, -22,  15,  14,  04,  12,  09,  14,  10,  12, -10,  20,  08, -23, -12, -17,  04,  16,  01, -11, -18, -06, -25,  16, -16,  13,  06,  19,  18, -15, -04,  04, -10, -13, -05,  19, -24, -21,  11,  13,  16, -24,  08, -01, -22,  23,  07,  09,  14, -15,  24,  23,  05, -24,  14,  16,  15, -02,  12,  10,  08, -15, -11, -25, -01,  09,  20,  00,  13,  08, -12,  06,  09,  21, -20,  14,  21,  14, -01,  13, -23,  00,  11,  07,  03,  01,  00, -07,  24, -13, -21,  09, -03, -05,  09,  22, -20,  06, -03,  20, -11,  11,  02,  23,  09,  09,  15,  06,  01, -11, -04,  03,  16, -18, -15, -06,  08,  10,  15,  09,  24,  21, -05, -04, -09, -20, -07, -02,  11,  18, -06, -22,  06,  21, -22, -10,  07,  18,  23, -17, -16, -06,  11, -25,  04,  23, -03, -11,  10, -11,  24,  09, -15, -06, -19,  03,  01,  01, -23, -10, -04, -02, -07, -23, -04, -04, -05, -22, -10, -05, -13,  01,  17, -25,  02, -04,  24, -24,  10,  09, -10,  11, -04,  02, -17,  02, -20,  09, -20, -16, -24,  02,  07, -06,  06, -22,  18, -22, -16, -15, -01, -02,  11, -09, -02, -10,  14, -01, -09, -01, -14,  08, -12,  07, -15, -04, -14, -07, -18, -09,  04, -16,  20, -13,  05,  04, -08, -02,  07,  03,  08, -17, -24, -03,  01,  02,  12, -10, -24, -19,  17, -13,  14, -20,  21, -23,  03, -18, -05,  10,  01,  24,  21, -04, -12,  04, -23,  08, -23,  12, -12,  13,  20, -10, -15, -03,  19,  24,  14,  20, -20,  06, -15,  20,  13, -17,  22, -09, -09, -06, -23,  17, -05, -25, -10,  11,  04, -07, -06,  09, -20,  07, -01, -23,  24,  11, -01,  18,  10, -09,  16,  16,  22, -22,  13,  11, -14,  12, -23,  02, -17, -19, -04,  03, -16,  12, -11,  13, -18,  10, -01, -11, -05,  23, -09, -04,  11,  18, -10, -03, -16, -17, -10, -19, -14, -20,  19, -01,  17,  22, -21, -25, -20,  00,  05, -11, -11,  20, -20, -02,  07,  06,  12, -23,  05, -21, -01, -09,  22,  16,  15, -19,  24, -18, -11, -13, -13, -16,  11, -19, -17,  17, -17, -10, -07,  16,  07,  09,  13,  14, -17, -05, -05,  20,  00, -23, -24,  24, -04,  23,  17, -14, -19,  18, -04, -02, -20,  10,  09,  18,  17,  19,  11, -23, -16, -19,  18,  18,  17,  06,  07, -25, -21, -20,  21,  04, -18,  24,  05,  03,  23, -03,  17, -19, -10, -10,  06, -03, -25, -10, -08,  17, -14, -20,  22, -02, -14,  15, -09, -21, -01, -24, -19,  03, -19, -21, -18, -10, -21,  12,  19, -21, -14,  13, -15,  01, -22,  19, -25, -22, -14, -08,  23, -02, -02,  22,  21,  11,  14, -11,  17, -12, -10, -24,  18, -02, -20, -23,  14, -16,  14,  10, -12, -23, -02,  01,  05,  03, -03,  05,  08,  08, -25,  08, -19,  00,  05, -21, -12, -05, -06, -19,  10,  09, -18,  04, -17, -11,  06,  24, -01, -02,  09,  14,  00, -18, -08, -19,  12,  14,  13, -05, -02,  13, -21,  04, -12,  09,  11,  04, -19, -20,  12,  17,  16,  19, -02, -24, -15, -21, -25,  09,  04,  09,  01, -18,  18,  18, -12,  05,  08, -24, -22, -17,  17, -18,  12, -18,  18,  00,  11, -25,  05, -02,  19, -03, -06, -08,  00,  05, -02,  01, -09, -20, -13,  19, -13, -19,  13,  00,  13, -02,  03,  16,  06, -03, -25, -05,  05,  19,  21, -07,  21,  01,  19,  17, -25, -12, -16,  01,  20,  09, -21, -11,  14, -09, -17, -24, -01,  21,  03, -12, -06, -16, -21, -23,  06, -20, -02, -12, -24, -06,  09,  22,  22,  03,  14,  23,  18, -25,  01,  14,  11,  05, -22,  03,  21, -12,  06, -02, -13, -15,  11,  08, -04,  17,  11, -23,  24, -16, -07, -25,  03, -23,  24,  02,  05,  15,  00, -02,  17, -24, -11,  06,  08, -06, -16,  07,  08,  15, -20,  20, -23,  16,  05, -02,  10, -09,  03,  12,  02,  21,  14, -18, -25,  14,  10,  05,  06, -15, -20,  01, -11, -03, -18,  22,  16, -07,  04,  01, -17,  09, -02, -12,  02, -21,  11, -10, -05, -11, -23,  23, -13,  16, -20, -13,  07,  17,  19, -09, -22, -25,  17, -08, -03, -24, -11, -10, -06,  21,  17,  04,  05, -08,  17, -15, -04,  04,  00,  19,  20,  02,  19, -17, -07, -24, -05],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([-22,  19, -10, -06,  24, -08, -14, -09,  16, -11,  07, -19,  08,  03, -25, -11, -14, -07, -18, -04,  16,  13,  21,  10,  10,  00,  06,  18,  18,  08, -09,  21,  04,  08, -08,  03, -25,  03,  21,  16,  19,  05,  24,  02, -16, -25,  19, -03, -05, -22,  18, -14,  18,  16,  24,  03, -09,  05, -01, -14, -10,  17, -15,  19,  00,  02, -01,  02, -17, -05, -07, -23, -24, -06,  07, -13, -06,  01,  11,  16,  06,  06, -22, -01, -03, -23, -21,  15,  07,  03, -22, -25, -03, -12,  19,  22,  18, -04, -01, -24,  18,  19, -20,  19, -11,  12, -17,  10, -10,  21,  02,  21,  02,  05, -03, -24,  09,  02,  18, -09, -18,  22, -07,  05, -15, -10,  02, -22,  11, -21, -19,  04,  23, -13,  01, -13, -24,  11, -25, -08,  08,  02, -10, -13, -18,  13, -11,  18, -10, -18, -14, -03, -21,  05, -21, -08,  20,  07, -03,  06,  11,  04, -15,  11,  18,  13, -24,  19,  00, -24, -14, -17,  03,  02, -05,  12, -08,  11,  05,  07,  21,  16, -19, -25, -02, -14, -06, -07,  20,  17,  24,  06, -02, -13, -06, -09, -25, -05, -13,  02, -04,  01,  10, -24, -22, -17,  15, -05,  21, -03, -21,  17, -09, -15,  20,  14, -02, -11, -17, -07, -17, -16, -24,  08, -04, -04,  24, -01,  18, -11, -24, -08,  15,  14, -05,  20,  24, -14, -08,  20,  08, -04,  13,  24,  08,  08,  16, -18,  24,  24,  02, -17, -17,  04,  16,  07, -23,  18, -19,  20, -16, -16, -13,  24,  23,  08,  19,  22,  21, -14,  20,  06,  09,  08,  06, -06, -07, -01,  03, -06, -02, -19,  04,  08,  12, -04, -10,  14, -09, -02,  11,  00,  10,  24,  01,  08,  09, -03,  08,  07,  10,  03, -12, -06, -12,  21,  15,  06, -05, -06, -23,  18,  00,  07,  04, -13, -20,  21, -22, -04, -03,  14,  23, -18,  15,  01,  17,  01,  23,  02, -17,  08, -20, -03, -23, -07, -07,  19, -24,  16, -12, -21,  11,  15,  11, -10, -21,  16, -11, -18, -11,  11,  24, -11,  20,  14,  15,  12, -09,  13, -10,  01, -02, -03,  23,  02,  16, -06, -04,  19, -15,  10, -25,  23,  00,  13, -11,  05,  06,  03,  14,  22, -09,  13, -14, -14,  05, -22,  23,  21,  18, -10, -01, -09,  13,  00,  18,  06,  19, -10,  02, -19, -23,  03, -21,  04, -09, -05, -16, -25, -25, -24,  22, -09,  14, -16,  02, -04, -11,  03, -06, -17,  18,  19, -01,  08, -06, -05, -11, -10,  12,  17, -04,  14, -03,  02, -07,  15,  23,  05,  15, -25,  08,  13, -08, -01,  24,  21,  21, -12, -01, -10, -02, -07, -16, -25, -24,  03, -05, -07,  18, -16, -15, -09, -25,  07,  19, -07, -03,  19, -25, -10,  19,  08, -22, -12, -17, -21, -15, -19, -06,  09, -04,  18, -21,  06,  18, -17, -14, -10,  01, -18,  01,  13, -02,  01, -03, -06,  21,  21, -10,  24, -14, -15,  07, -09,  00,  17, -05,  10,  23,  15, -05, -03,  08, -01, -20,  03,  09, -09,  20, -15,  00, -02, -25, -24,  24, -03, -05,  20, -06,  13,  21,  07, -25,  04,  24,  00, -02, -06, -14, -01, -14,  06,  21,  19, -18, -22, -01,  17, -06, -04, -21,  22,  19, -18,  23,  18,  04, -05,  16, -25, -17,  12,  10, -17, -07,  09,  11,  19, -20,  22, -05, -08,  05, -09, -12,  12, -04,  13,  06,  17, -14,  13,  14, -19,  20,  12, -24,  01, -15,  19,  04, -05,  09, -09,  06, -21, -25, -08,  23, -20, -11, -07, -01,  19,  11,  13,  08, -18,  03, -08, -25,  14, -18,  16,  22, -21,  06, -24,  07,  16,  20, -12, -14,  06,  04,  17,  11,  04, -16,  11,  12,  00, -20, -14, -04,  18,  24, -18, -22,  02,  01, -20, -06,  08,  21, -09,  14,  02, -06, -04, -05, -08,  10,  09,  23, -11,  03,  09,  21,  15, -04,  08, -10,  03,  21,  14, -02,  23,  21,  01,  02, -01,  06,  21, -18,  05, -10,  23, -18,  09, -06,  05, -24, -21, -11, -23, -04,  17,  13, -08,  07, -16, -23, -25,  14,  23,  14, -12,  21,  12,  16, -01, -14,  00, -03, -05, -20,  14, -07, -11, -01,  14,  19,  02,  19, -15,  04, -08, -22, -07,  09,  12,  04,  11,  12, -04,  11,  03,  11,  10, -10,  02, -14,  03, -23,  08, -25, -16, -02, -05, -01,  24, -15, -05,  03, -19,  06, -17, -02,  11,  03, -16, -02, -16,  22, -12,  07,  08,  16, -07, -07, -16,  23,  04,  14, -23, -10,  15, -13,  15, -15,  13,  14, -03, -17, -08,  03,  14,  02, -22,  00, -18, -13, -24, -06, -16, -11, -24,  20, -18, -03, -10, -07, -03,  22, -17, -01, -13, -25,  13, -23, -15,  03,  18,  10,  12, -15, -12,  03,  15, -08, -19,  22,  06, -18, -09,  16, -02, -05,  11,  05,  19, -22,  24, -09, -25, -16,  17, -13, -16,  06, -09, -04, -14, -16, -19,  23, -05, -03,  04, -15,  14,  10, -16, -05,  19,  03, -12, -08, -25, -24,  22,  19, -20,  23, -15, -20, -18, -23, -05, -07,  10,  11,  15,  22,  21,  21,  22, -07, -07,  01,  05, -16, -12,  16,  07, -18, -06,  20, -01, -06,  24, -01, -12, -19, -01, -02, -14,  09,  03,  08, -23, -12, -05,  17, -13, -07,  16, -15,  11, -16,  13, -07, -06, -21, -16, -22, -14,  04, -25,  13, -25,  24, -11, -09, -20,  15,  14, -06, -01, -06, -23,  02,  08, -03, -04,  20,  17, -13, -18,  03, -01,  23,  21,  20, -23, -17,  23, -12,  12,  23, -22,  14, -25, -08, -20, -20, -15,  22,  01,  09, -09,  04, -12,  24, -22,  12,  22,  21,  24, -19,  01,  00, -21,  00, -05, -19,  08, -05, -03, -03, -06,  02, -14, -06,  20, -06,  01, -18, -09, -20,  16,  07,  09, -18,  09,  14,  19,  08,  12,  20,  14, -11, -04,  21,  16,  18, -21, -01, -11,  01,  23,  08, -21, -14, -21, -24,  05,  07, -17,  21,  12, -24,  06, -02, -17, -08, -10, -23, -25, -23, -25],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([ 16, -07, -04,  12, -16, -11,  17,  10,  03, -05,  08, -12,  01,  20, -06,  02,  02, -23,  12,  01,  16,  14, -18, -10,  22, -01,  05, -23,  01,  09, -23, -08, -22,  00, -18, -11,  16, -24, -25, -05, -02,  10,  10, -25,  07, -20,  02, -15, -16, -08,  11, -25, -19,  20, -10, -20, -04,  22, -16,  22,  07, -14, -09,  12,  13,  00, -24,  05,  03, -24, -23, -23,  14,  12, -23, -04,  19,  06,  06, -22,  23, -06, -21, -19, -11, -04, -13,  12, -06, -02,  09, -22,  10, -22,  15, -02,  03,  16, -20, -18,  20, -18, -14,  09,  20, -12, -20,  14,  21,  14,  18,  22, -17,  24, -22,  00, -05, -08, -13,  16,  16,  24,  19,  03, -23,  09, -22,  07,  01, -16,  16, -02, -09, -23, -18, -12, -10, -13, -22, -11, -24,  23, -14, -13,  24, -11,  14, -06,  09, -22, -14,  00, -21, -20, -20, -17,  17, -17,  16, -05, -08,  07,  18,  11,  10, -25,  24, -23, -13, -21, -09, -09, -21,  02,  05, -22,  19, -04, -02,  03,  01,  11, -20,  06,  16, -15,  14,  10, -05,  07, -20,  15, -10,  23,  01, -23,  23,  02, -19, -12,  07, -02,  06,  13, -23, -12,  17,  21,  09, -08,  01, -13, -22,  06,  18,  21,  18,  10,  07, -09, -08,  12, -17,  09,  13,  11,  13,  13, -12,  20, -24,  22, -07,  09,  11, -05,  22,  05, -06,  08,  22,  20,  21, -25,  04,  16,  21, -01,  03,  03,  17,  23, -07, -25,  07, -19,  11, -04,  19, -25, -09,  23,  24,  11,  07,  10, -17,  07, -10,  02, -08, -11,  00, -12, -11, -21, -18, -14,  05,  12,  16, -02,  10, -16, -02, -07, -08, -15,  16, -13, -15, -16, -15, -16,  20,  19,  22, -22,  03, -11,  06,  21,  04, -19, -14,  20, -13, -07, -17,  17, -19, -25, -10,  18, -14,  14, -14,  04, -24, -21,  18, -14, -12, -20, -03, -17, -24, -04, -11,  05,  13,  20,  01, -08, -22,  12, -11, -08, -17, -02, -16, -09, -02,  02, -16,  11, -07, -04, -10, -06,  02, -15,  07,  16, -10, -19,  24, -08,  03, -12,  22, -09, -15,  00,  10, -10, -13, -24,  07, -05, -01,  19,  11,  22, -04,  21,  09,  14, -06, -24, -15,  21, -13,  17,  12,  04,  23,  14,  23,  03, -21,  22,  21, -08, -03,  08,  07,  10,  10, -08, -20, -16, -14,  19, -16,  07,  15,  20, -02, -14,  21,  08, -18, -15,  02,  22,  17,  02,  13,  15, -19,  17,  13, -21, -14, -13,  15,  19,  22,  00, -14, -20,  11, -01, -24,  20, -17,  16,  15,  06, -21,  14, -09, -14, -24,  20, -15,  20, -03,  23,  13,  05,  16,  03,  12, -23,  15,  02,  23,  13, -23, -14,  20,  15,  10,  21,  11,  18,  14,  03,  01,  18, -06,  19, -19, -02,  14, -08, -07, -11, -08, -19,  21, -17,  09,  08, -12,  00, -13, -12, -10, -09,  00, -13, -18, -13, -17,  18, -17,  24, -02,  11,  19,  20,  06, -23, -07, -03, -06,  13,  13,  12,  20,  10,  22,  06, -05, -13, -17,  08,  01,  00,  24, -22,  12, -19, -08,  22, -24,  00,  21,  02, -11,  17, -03,  20,  20,  17, -06, -09,  05, -15, -20,  02,  22, -20, -16, -08, -08, -06, -23,  20,  20, -21, -25,  09, -13, -05,  07, -09,  22,  05,  18, -14, -02, -08, -17, -05, -16,  03,  11,  16,  13,  19, -06,  10,  24,  05, -21, -07, -24, -16, -09,  21, -12, -09,  06,  02,  13, -10,  18,  11,  20,  13,  22, -05, -18, -19,  15, -09,  11,  04, -15,  01, -02,  04, -12, -01, -14, -06,  17, -13,  03, -15, -16,  18,  04,  17, -04, -08, -18, -09, -22, -21, -20, -24,  02, -13, -18, -06,  06,  20,  23,  16, -04, -02, -03,  09,  22,  08, -22,  17,  20,  09, -23, -19,  02,  06, -25, -25,  24, -16, -08, -21, -11, -01, -20,  16,  11, -11, -15, -06, -16, -14, -15,  07,  11,  09, -07,  11, -08, -03,  03, -10, -17,  07, -02,  10, -09, -01,  11, -08,  08, -22, -04,  24,  02,  04,  17, -10,  18, -20,  12, -20, -09,  24,  12, -21,  09, -19,  15, -24,  05, -05, -07,  13, -20,  17,  00, -04, -09, -14,  15, -24, -09, -12, -22,  20,  17,  20, -12,  13, -23, -25,  18, -05,  24,  07,  00,  08,  13, -10,  12, -05,  13, -20, -15,  18,  24,  11, -09, -08,  24, -19, -04, -09, -04, -01, -12, -09, -04,  03, -21, -01,  03,  24,  21,  05,  06, -04, -10, -03,  14, -23,  17,  02, -15, -22, -03, -16,  16,  13,  04,  15,  21, -25, -17, -08, -01, -01,  08,  22, -23,  14, -02,  08,  13, -05, -12, -05,  18,  03,  19,  07,  08,  13, -14,  20,  18,  08, -19,  09, -02,  10,  02, -06,  12,  10,  12, -14, -16, -03, -16, -11, -13,  07,  22, -25, -21, -13, -03,  23,  17, -07,  07,  00, -18,  19, -03, -25,  04,  06,  12, -22, -07, -11, -01, -19, -24, -12, -08, -12,  11,  03,  02, -25, -12, -01, -23, -08,  11,  02, -08,  03,  20, -25, -19, -21,  21,  05, -18,  00, -14,  19,  05,  05, -15, -20,  11, -14, -07, -20, -01, -19,  11, -24, -19, -24,  02, -16, -05, -10,  11,  13,  19,  08,  13, -23,  13,  11,  07,  20, -12,  21,  16,  19,  03, -24, -24, -11, -13, -04, -04,  14,  03, -16,  17,  11, -15, -05,  22,  06,  10,  10, -06,  06, -06, -16,  10, -16,  20, -05, -21, -15, -09,  20, -21,  19,  23, -18, -15, -13,  06,  08, -24, -16,  18,  19,  22, -22, -09,  20,  09, -22,  07, -20,  12, -24, -09, -03, -15, -14,  19, -09, -03, -15, -12,  03, -19, -14,  13, -07, -01, -06, -23,  00,  05,  22, -04,  02, -25,  14, -01,  12,  20, -18,  19,  07, -15, -14, -19, -02, -03, -24,  14,  21, -12, -22,  02, -03, -09, -08,  17,  15,  11,  21, -07, -07,  18,  16,  20,  21,  08, -03,  08,  03,  04,  02, -15,  16,  13, -07, -11, -12, -04, -21, -14,  12, -16,  15, -16,  02, -18, -22],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([-07,  20, -25,  13, -12,  18,  06, -14,  14, -11,  08, -01,  17, -11, -21, -21, -20,  19, -02, -03, -18,  21,  01, -04,  08,  12, -14,  19, -11, -04,  23,  09, -07,  23, -01,  07,  18, -19,  20,  08, -05,  05, -16, -10,  21, -12, -04, -22, -17,  21,  00, -08,  18, -22,  13,  01,  15, -23, -02, -18,  00, -04,  16,  18, -04, -09,  02, -11, -01, -03,  22,  21, -23, -18, -14,  23, -03,  08, -23,  05,  04,  02,  23, -01,  06,  13, -24, -02,  17, -01,  05, -08,  22, -01, -12, -07,  15,  15,  07, -09, -10,  07, -13, -08,  16, -01, -07, -12, -16, -03,  19,  15, -24,  19, -10,  09,  09, -07, -17,  02,  19,  15,  21,  16, -11, -14, -14, -19, -23,  18, -03, -06,  02,  10,  11, -07, -14, -19,  07, -03,  03,  03, -11,  07, -01,  06, -09, -17,  24,  01,  12,  20, -08,  09,  13,  06,  22,  24,  15,  24,  20, -13, -07, -03,  24, -18,  16, -15, -10,  00,  09,  21, -22,  24,  03,  02,  05,  21,  12,  07, -02,  00,  02,  15, -14, -09, -02, -17, -08, -12, -15, -11,  01,  05,  12,  00,  14,  05,  13, -20, -18, -03, -22, -15, -04,  08,  14, -23,  04,  01,  11, -23, -22, -12,  19, -11,  06, -07,  00,  24,  08,  10, -10, -16, -10, -23,  12, -18,  09,  00, -11,  16,  24, -08, -22, -04, -23,  17,  00,  06, -04, -14,  11, -01,  01,  07,  16, -17, -23, -09, -16,  11, -22,  01,  20, -05,  06,  09,  02, -10, -14,  16, -16, -14, -15, -13,  09, -13, -18, -14,  21,  05, -01,  09, -19, -25, -09,  22, -15, -04, -10, -04, -18, -07,  23, -21,  14,  04,  14, -07,  21, -25, -13, -20, -14, -03, -05,  22,  12,  04, -17,  10, -16,  07, -04, -08,  10,  14, -08,  20, -15,  07, -06, -08, -22, -08, -03,  19,  23, -12, -13,  19, -12, -01, -23,  02,  24, -03, -01,  13, -24,  10, -02, -13, -08,  21,  04, -23,  10,  21, -25,  21,  06, -04, -10,  09,  13,  14,  05,  13, -23,  17,  07, -09, -06,  09,  20, -05, -17, -04, -17, -14, -19,  08, -02,  01,  04, -20,  05, -11, -22,  05, -13,  09, -24,  05, -05,  16, -06, -25,  04, -03,  20, -11,  15, -11, -25,  10,  09, -14, -19,  19, -03, -10,  02,  23,  16, -17, -20, -04, -01, -17, -21,  12,  20, -18, -08, -08,  24,  13, -07,  05, -15, -10,  21, -25,  06,  24,  12, -10, -15,  19, -14,  07, -16,  13,  05, -23,  21,  12, -02, -03,  21,  02, -16,  18,  10,  03, -15,  11, -08,  05, -07,  04,  20, -08,  05,  01, -09, -08,  18,  01, -12, -21, -15, -01,  19,  18,  01,  17,  05, -23, -10,  01,  04,  01, -06, -09, -18,  07, -21, -01, -13, -02, -20, -15,  15,  10,  13, -19, -20,  09,  09, -07,  13,  19,  20,  10,  12, -02,  02, -07,  00,  17,  21, -20, -06, -07, -02,  03, -25,  03, -23, -11, -24, -16,  01,  18,  20, -10, -24, -23,  24,  10, -03,  14,  06, -08, -01, -06,  16, -21,  14, -09,  23,  10, -02, -06, -20,  22,  22, -20,  02,  24, -03,  03, -14,  23, -02, -19, -12, -01, -15, -11, -14,  07, -21,  17, -23,  05, -12,  18,  09, -21, -14,  10,  15,  12, -21,  20,  11, -23, -22, -12, -22,  00,  18, -11,  00, -09, -03,  16,  17,  07, -20, -22, -10, -14,  22, -06,  19, -12, -11,  05, -08,  02, -10, -16, -11, -05, -18, -25, -03, -15, -10,  00,  12, -17,  15, -11,  01, -11, -20, -05,  22, -12,  00, -11, -01, -02,  08, -05,  13,  22, -24, -20, -01, -07, -10,  16,  13, -03,  18, -13,  09, -16,  15, -02, -06,  07,  12,  23,  21,  20, -07,  18, -17,  19, -16,  09, -06,  17, -20, -18,  16, -17, -13, -07,  01,  04, -16, -08, -22, -23,  06,  14, -12, -04, -13,  10, -22, -23,  08, -23,  22, -24,  20, -20,  22, -20,  16, -09,  24,  21, -02,  16, -19,  13, -14,  10, -06, -05, -21, -02, -01,  10, -13,  15, -16,  02,  00, -11,  06, -17, -09,  03, -14, -11,  10, -16, -04,  01,  00, -05,  00, -24, -12,  06,  16, -01, -09, -15,  21, -05,  10, -02, -17, -25, -12, -08,  02,  15,  08, -17,  23, -25,  13, -14, -11, -02, -05,  10, -24,  23, -18,  01,  24, -04, -17,  17,  22,  01, -23,  21,  24,  13, -06, -16,  13,  09,  03, -08, -01, -14,  02, -03, -12, -10,  08,  04,  15, -19, -11,  16, -21, -01, -07, -20,  22,  03,  22,  19, -19, -24,  15, -18,  16, -14, -09,  04,  20,  19,  23, -06, -17,  00,  18, -04,  15,  04, -24,  05,  10, -08, -03,  16,  16,  17,  23,  13, -03,  22,  10,  03,  23,  02,  11,  15,  14, -21, -04,  09,  24, -05, -21, -18,  20,  24,  05,  13,  03,  06, -05, -12,  24,  17, -19,  17,  11, -21,  08, -17, -24, -07,  14, -23,  20,  00,  19,  11,  04, -10, -04,  05,  12,  02,  14,  10,  01, -05, -02, -20, -22,  18, -05, -21,  13,  04,  22, -01,  10,  07,  10,  14, -25, -01,  16,  22, -24,  12,  11,  05, -23, -18, -12,  17,  11, -23,  02, -13, -01, -25, -06,  03,  20,  17,  07,  08, -02,  04, -15, -17, -14,  22,  22, -12, -02,  15, -12, -01,  02,  24, -19,  07, -17, -06, -01,  19, -01, -24, -17,  23, -22,  05,  01,  23, -01, -16,  09,  22,  15,  21, -20, -21,  18, -20, -06, -09,  20,  09,  17, -02,  10,  23, -20,  18, -05,  04,  14,  19,  07,  23,  17,  10,  05, -04,  10, -21,  05, -04, -24, -03, -08, -19,  03, -13, -12,  23,  05, -16,  09, -03,  09, -05, -04,  14, -10,  18, -05, -20,  12, -21, -20,  06,  16,  10, -23,  01,  14,  09,  23,  17, -16, -08, -25,  12,  05, -11,  12, -15, -02, -03,  10, -18,  19, -19,  23, -16, -24, -05, -11,  13,  01, -04, -06, -08, -19, -01,  18,  22, -17,  18,  14, -08, -14,  17, -18,  16, -19,  19, -22,  06, -07,  13],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([ 15, -13,  21,  13, -01,  22, -15,  15,  12,  11, -13, -18, -22, -07,  08,  23, -07,  18,  17, -16, -14, -20, -24, -05,  21, -18, -09,  24,  13,  10,  15,  03,  24,  11, -07, -02,  09,  05, -11, -04, -07,  03,  05, -04,  21, -10, -03, -11, -16, -09, -01, -03, -04,  02,  17, -08,  10, -17, -07,  00,  20, -17, -19,  20,  22,  01, -05,  08, -18,  11, -21,  00, -11,  12,  24, -12, -23, -04,  04, -12,  12, -20,  10, -17,  08,  02,  02, -07,  13,  22,  20,  08, -17, -24,  05, -20,  03, -24,  13,  10,  14,  19, -13, -19,  08, -14, -06,  13,  09,  23, -24, -02, -19,  14,  08,  14, -09, -13, -16, -21, -15, -21,  13, -05, -19, -05,  02,  11, -04, -08, -02, -12, -12,  10, -06,  22,  24,  15,  12,  10,  15,  15, -14,  21,  04,  19,  10,  23, -16,  21, -23, -04, -24,  17,  16, -16, -12, -07,  20,  11,  10, -05, -24,  23, -18, -05,  22, -17, -15,  11,  19, -22,  02, -18,  24, -19, -22,  12, -21, -13,  08, -16,  08,  09, -22, -01,  20, -07,  19,  17, -18,  06, -13, -17,  07, -03,  06,  04,  05,  16, -09,  01,  21,  20,  08,  21, -22,  12,  08, -15, -24, -09, -04,  10, -22, -01, -14, -25,  20, -19,  18, -23,  14, -18, -13, -04,  04,  18, -22, -13,  12, -04,  13,  08, -09, -03,  04, -06, -14, -11,  06, -13,  08, -23,  24,  13,  02, -14,  13, -01, -06,  08,  01, -17,  16,  13,  05, -03,  09,  08,  09, -04, -21, -02, -21, -03,  22,  11,  16, -15, -25,  00, -01,  08,  02, -01, -04, -21,  10, -13,  05, -19,  20, -19, -11,  11,  22,  19, -14,  06,  04,  20, -21,  10, -07, -17, -18, -08,  19, -24,  02,  22,  01, -21,  07, -22,  03, -21, -15, -10, -07,  15, -04, -12,  24,  10, -23,  21,  07, -12,  04, -14, -17,  10,  24,  04,  18, -19,  23,  15, -18,  03,  14,  10,  07, -04,  14, -15,  02,  24,  00,  20,  16,  21, -16,  15,  08, -14,  13, -10,  01, -06,  04,  11, -21,  03, -08, -25,  11, -09,  15,  19,  19,  06,  06,  03, -23, -05,  13,  05, -04, -10,  00, -10, -12,  11, -20,  23,  24,  21, -11,  02, -10,  20, -11, -05,  00,  06, -03, -14,  22, -13, -18,  18,  20,  14, -04,  22, -14, -14,  04,  08,  03, -18,  23,  16,  18, -20,  15,  20, -24, -19, -03, -08, -22,  11,  14,  03, -07, -14,  14, -08,  00,  22, -12, -05,  13,  11, -06,  24,  23,  24,  09,  03, -19,  07, -05, -24,  15, -13,  21,  16, -05, -06, -15, -02, -18, -24, -22,  02, -11,  17,  22,  16,  16, -15, -12,  04,  21,  08,  06,  21,  07, -10,  00,  15, -25,  22,  16,  15, -14,  13,  08,  06, -16,  21, -19, -09,  24, -16,  21, -11, -22,  18, -20,  22, -22, -06,  01, -24, -21, -18,  23,  11,  00, -02,  03,  00, -03, -06, -10,  08, -16, -25, -09, -05,  21, -01,  12,  21,  10,  10, -15,  13,  03, -08,  10,  08,  13, -11,  11,  17, -02,  09,  05,  23, -16, -17, -02,  06,  05,  15, -09,  14,  16,  07, -15,  14, -19,  24,  10,  16,  09,  22,  07, -11, -08, -06,  24, -20,  10,  10, -25, -14, -05,  05, -16,  06,  16,  10, -10, -04,  02,  06, -13, -07, -11, -03, -17, -03, -02,  20, -09, -16,  20,  23, -02, -13, -06, -03, -06, -20, -15, -06, -09,  07, -23,  02, -12,  18, -11,  03, -11,  17, -13,  01, -15,  03, -24, -05, -25, -01, -07, -07,  09, -12, -07, -16,  00,  13,  09,  19,  20,  19, -09, -12,  01, -07,  15,  16, -14, -20, -03,  02,  24,  09, -20, -16, -11, -19,  07, -11,  08, -23,  10, -06, -10, -22,  03,  17,  16, -13,  13,  13, -17, -21, -24,  11, -01,  17,  03,  10,  24, -23, -11,  23,  11, -03, -16, -23,  03,  18, -09, -12,  20, -22,  07, -15, -18, -14, -21,  23,  00,  18,  14,  09,  22,  15, -05, -03,  09, -25, -16,  08, -23,  01,  08,  15,  23,  20,  17,  03,  15, -14,  17,  11, -11, -01,  23, -04,  12, -22, -03, -12,  23, -14,  24,  20, -24, -06, -06,  11, -03,  06, -04, -01, -16, -18, -10, -18, -21, -18,  10,  19, -07,  04,  07,  10, -19,  08, -19,  18,  11,  05, -17,  09,  16, -18,  06,  20,  04, -22,  08, -24,  11, -19,  02,  20, -10,  17, -23, -06, -23,  14, -09, -05, -06,  23, -18,  02,  06, -11, -05, -06,  21,  06, -20,  13,  15,  14,  10, -04,  19, -05, -03,  05,  01, -25,  00,  17,  19,  04, -12,  21, -05,  04, -06,  16,  05,  01, -07, -12,  17,  14,  08,  14, -03,  15,  02, -13,  04, -11,  09, -02,  09, -17, -20, -13, -15,  05, -19, -20, -14, -05, -24,  07, -24, -03, -02,  08,  24,  19,  22,  16,  08,  05,  07, -18, -05, -14, -06, -23,  00, -22,  00, -16, -11,  06, -03, -01, -12,  03,  04,  02, -25,  08, -14, -21, -18,  11,  12, -19,  05,  09, -25, -10, -11,  07, -03,  12,  19,  17,  14, -04,  22, -09,  06, -14,  22, -20,  13, -12,  10, -06,  15,  13, -21, -24,  17, -13,  12,  04, -05, -07, -09, -05,  08,  07, -20, -17, -06,  24, -25, -15, -05,  24,  02, -22, -12,  01, -15, -22,  16,  23, -03,  06,  11,  02,  09,  05,  16, -01, -14, -14,  19,  02,  07,  04, -15,  14,  12,  06,  13,  14,  17, -15,  16, -04, -09, -21,  24,  01, -18,  16,  01,  06, -01, -11, -15, -14,  19, -24,  10, -17, -12,  04,  10,  22, -15,  20,  11,  23,  04,  01,  12, -04,  11,  03,  19, -23,  09,  18,  06,  18,  11, -16,  00, -14, -01,  10, -01, -07,  12, -16,  01, -23,  15, -11,  24, -25, -14,  10, -25,  15, -14,  13, -12,  24, -07, -18, -21, -20, -22,  12,  23,  16,  21,  00, -21, -05, -12,  03,  16, -23,  12, -06, -21,  04,  08, -20,  07,  20,  17,  07,  12, -22, -05, -24, -21,  16, -15, -17,  23, -12],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([ 20,  23, -20,  17, -01, -14, -11,  14,  15, -20,  16,  04,  00,  22, -16, -17, -23,  16, -20,  19, -02,  18,  24,  21,  19, -22,  14, -21, -11,  12, -05, -16,  10,  02, -22, -14,  13, -07, -25,  05,  00,  16, -15, -25,  15, -04, -14,  17, -11, -09,  11,  14, -14,  12,  12, -18,  16,  01, -11, -20, -10,  09, -09, -22, -12, -03, -11, -22,  17, -08,  09, -08, -15,  21, -05, -24, -08,  06,  18,  06,  24,  07, -03, -12, -06, -15, -05, -13,  11,  09, -08, -21, -07,  11, -18,  08, -17, -02,  14, -25,  15, -02, -08, -24, -04,  12, -23,  13, -05,  22, -04, -03,  04,  18,  10,  24, -20, -20, -14,  17,  15,  06,  21, -15, -08, -20,  19,  02,  03,  08,  02, -04, -17,  19, -03,  04,  09,  01, -06, -19, -02,  17,  03, -22,  12, -12, -21,  18, -06, -08,  12, -14, -25,  10, -04, -06,  15, -08,  21, -05, -23, -02,  16, -13, -05, -10,  18, -21,  16, -11, -13, -08, -19,  16, -03,  21, -21,  01,  14,  00,  20,  03,  13,  23, -12, -13, -08, -22,  04, -09,  00,  09,  16, -08,  21, -14,  07,  17, -08,  01, -19,  05,  18, -10, -04, -10, -14,  02,  18, -23, -20,  15,  05,  18,  15,  18, -20, -15,  23,  12,  01, -02, -04, -08,  17, -06,  04,  02, -12,  23, -22, -05,  03,  23,  10, -24, -10,  23,  06, -17, -25,  11, -25,  05,  06,  16, -02,  12, -24, -02,  01,  04,  21,  24,  21,  16, -05,  02, -07,  09,  03, -02, -21, -17, -02,  16, -15,  13,  14,  16,  23,  16,  04,  23, -04, -15,  16,  21,  24,  19, -06,  00, -02, -08,  01, -03, -17,  22, -24,  03,  06,  06, -24,  12,  15, -01,  03, -23, -11, -06,  18, -13, -15, -01, -12,  08,  09, -21,  04,  11, -24, -25, -14,  01, -06,  13, -25,  03,  12, -23, -17, -07,  10, -13, -20,  00,  13,  10,  02, -22, -19, -03, -10, -09,  21,  05, -24,  06,  10,  07, -08,  13,  07,  05, -11, -22, -05, -10,  08, -18, -06,  17,  02, -21, -21,  07,  07,  17, -06, -16,  20,  00,  07, -12,  18,  05,  18,  19, -12,  05,  01,  07, -07, -15, -10,  10, -11,  10, -25,  22,  20, -04,  16, -03,  00,  20, -18, -16,  15,  01, -06,  12, -21, -22, -25,  22,  10,  21,  19,  24,  01, -03,  06,  22,  08,  21,  07,  24,  09,  09,  23,  04, -20,  15, -24,  07,  12, -15,  17,  02,  12, -12, -10,  16, -07, -08,  15, -22, -12,  09, -23,  15, -18,  11,  14,  17,  07, -02,  18, -07, -18,  16,  22, -11,  08, -24,  21, -02, -14,  15, -25, -25, -20, -08,  18, -02,  10,  09,  02,  23, -05,  06,  15,  04, -08,  06, -02, -23, -21, -09, -05, -14, -15, -05,  02,  20, -04, -01, -07,  09, -09, -04,  12, -03,  13,  05,  22,  00, -09, -01,  01,  14, -17, -07, -07,  00, -25,  19,  02, -21, -15, -25, -07, -03, -05,  20, -07,  18, -04,  11,  04,  15, -18, -09, -11,  23,  24, -14, -02, -08,  11,  24, -19,  21, -07,  02, -04, -05, -04, -24,  01,  08, -22,  19, -19, -02,  17,  01, -07, -10, -13,  22, -18, -03, -09, -04, -03, -10,  08,  20,  09, -04,  22,  18, -08, -08, -03,  13,  12,  18,  16, -12,  03,  19, -15,  11, -06, -23, -13,  12, -06,  02,  12,  02, -24, -22,  23, -02, -05,  08, -05, -21, -21, -08,  22, -04,  09, -06, -13, -04, -11, -20,  12,  18, -25,  22,  06, -04, -24,  19, -16, -05, -02,  23,  24, -01, -24, -25,  24, -04,  08, -06,  00,  13,  14, -02, -14, -02,  19, -02,  22, -16,  04,  09, -21,  06,  06,  10, -23,  09,  06, -12, -21, -19, -14, -19,  05, -13, -19,  06,  10,  14, -22, -14,  02,  17,  11,  14, -08,  05, -11, -11,  16,  20, -25,  20,  01,  08,  08,  06, -08, -11,  19, -01, -04, -19,  05, -22, -05,  11,  12, -19,  00,  15, -06, -20,  07, -20,  21,  24,  12, -15, -09,  04, -19, -07, -01,  09, -23, -16, -10, -06, -01, -15,  18,  22, -07,  00, -23,  13, -14,  14,  21,  14,  04, -10,  21, -12, -03,  17, -10, -15, -23,  08,  16, -15, -24, -08,  20, -22,  02, -15,  00, -22, -03, -07, -25,  15,  21, -21,  06, -18,  19,  04,  23,  00,  20,  19,  14, -06,  13, -19,  04,  18,  14, -03, -22,  15,  15, -25,  19, -06, -12, -06, -03,  10,  14, -01,  03,  10,  03, -14,  20, -03,  15,  20, -25,  12,  17,  16, -18,  05,  22,  13, -02,  11, -14,  04,  03, -22,  04, -03, -03,  19,  18,  19,  07,  10, -05, -15, -03,  23, -02, -06, -02, -12, -08, -02, -24, -16, -11, -17,  14, -12,  21, -10,  24, -16,  19,  02, -13,  00, -23,  09, -03,  22,  05, -21,  09, -25, -09, -18,  24,  14,  03, -03, -21,  20,  22, -20, -21, -12, -10,  21,  01, -11, -12,  00, -02, -16, -21,  13,  09, -17, -03, -19, -17, -20, -13,  17, -20,  03, -24, -19, -06,  05,  05, -01,  02,  02,  04,  09,  15,  22,  05, -09, -12,  18,  18,  11, -21, -25, -01,  13, -15,  24,  22, -07, -21, -14, -12, -14,  15, -11, -07, -16,  21,  23,  08, -01,  03, -10, -17, -07, -11,  15,  12,  02,  10,  07, -10,  14,  09,  17,  04,  20,  16,  03, -10,  22,  15,  03, -17,  07,  18,  01,  16,  16,  02,  02, -10, -20,  19, -02,  00, -15, -10, -11,  12, -25,  24, -23,  14,  08,  21, -06,  03,  12,  22,  21,  11,  14, -01,  22, -04, -06,  00, -10, -14, -23,  17,  01, -16,  13, -23,  10,  23, -08, -24,  10, -07, -25,  14, -16,  09,  11,  03, -11,  00,  03, -15, -11, -08,  10, -14,  14, -19,  11, -19, -08,  16,  23,  19, -25,  13,  23,  12,  11, -10,  14, -02,  10,  14, -11,  20,  00, -23,  00,  15,  05, -20, -23,  19, -02,  12, -18, -11,  19,  20, -05, -12,  13, -05, -18,  14, -17, -18,  03,  21, -02, -08, -04, -15, -16],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([ 10, -20,  09,  15,  08, -01, -03,  13,  02, -07, -12, -09,  00,  02, -13, -03,  24,  01, -14, -06,  10, -25,  04,  18,  05,  02, -07,  23,  23,  03, -16,  11,  11,  18,  03, -04, -05, -25, -16,  24, -07, -02, -08,  18, -23,  05, -10, -23, -17,  01, -02,  20,  03, -20,  15, -16,  07, -17, -16,  08,  14, -07, -06,  02, -12,  22,  23,  08,  24, -16,  09, -08,  07, -23, -13,  12,  09,  02,  16,  17, -19, -09,  14,  11, -04,  05,  22, -19,  15, -19,  14,  04,  01, -15, -19,  17, -16, -19,  02, -17, -09, -13,  00, -25, -11,  12,  12,  23, -09,  05,  17, -01,  22,  06, -14, -05, -12, -17,  01, -21, -08, -08,  08,  20,  02,  17,  14,  11, -25, -08,  19, -09,  04, -06, -08,  20, -17, -19,  18,  00,  14,  12,  24,  11, -07, -15, -17,  07, -04,  12,  11,  15, -21, -04,  12,  07, -10,  02, -05, -09,  19, -10,  07,  00,  11, -24, -05,  20, -15, -10, -05,  24, -23, -04,  12, -03,  09,  20, -21, -20,  07,  17,  22,  14, -09,  09, -04,  06, -14,  16,  24, -18, -17,  09,  07,  20,  10, -21,  17,  22, -06, -13,  23, -04,  10,  10,  21, -06,  08, -25,  01, -08,  20, -02, -19, -12, -15,  04,  21, -02, -02,  21,  06,  06,  05, -10,  01, -08, -05, -05, -08,  16,  07, -10, -10, -07, -22, -14,  14,  11, -12, -09, -20, -17,  14, -11, -02,  24,  18, -05,  00, -09, -09, -19, -25,  23, -02,  03, -08,  18,  24,  09,  10,  08, -25, -23, -22, -22, -12,  18,  16,  01, -16,  23,  12, -25, -13, -15, -23, -19,  05,  02, -01,  23,  08, -01,  23, -17, -20, -09, -23, -21, -25,  14,  12, -23,  16,  16, -18, -21,  11, -25,  07,  20,  24, -06,  20, -14,  05,  22, -06, -13,  01,  19, -14, -14, -05, -14, -05,  00,  02, -03,  06,  05, -12, -04,  07, -19, -13,  17, -13,  23,  17,  19,  20,  16, -09,  17, -20,  21,  17, -01, -15, -07, -07, -02,  05,  16,  10, -25, -07, -13, -01, -23,  19,  12, -02,  02,  20,  12, -04, -18,  10, -10, -22,  07, -18, -06, -01, -13, -08, -09,  11,  03,  10, -18, -24, -08, -25,  13, -08, -05, -24,  16, -03,  20,  05,  20, -01,  02,  07,  22,  11, -06, -12,  14, -24, -03, -14,  03,  09,  05,  19, -03, -15,  06,  06, -11,  23,  08, -23, -08, -21, -20, -15,  03, -24,  17,  01,  02, -06, -17,  00, -20,  05,  15,  22,  08, -13, -17, -14,  23,  13, -17, -03,  24,  16, -21, -10,  15,  14, -08, -16,  20, -02, -05, -01,  01, -13, -25, -22,  07, -15,  05,  14,  17, -05,  11,  01,  09,  19,  14,  07,  10,  22, -20,  11,  14, -14, -24,  06, -25, -07,  15,  21,  18, -13, -03, -06,  00, -01, -02, -16,  09, -20,  23,  02,  03,  10, -20, -13,  06,  19,  20, -07,  17, -23, -21,  08, -12, -18, -11, -12,  03, -19, -14, -04, -04,  08,  16,  23, -16, -09, -18,  19, -04, -18, -02,  24,  19,  03, -11,  03, -03, -14,  21, -09, -12, -22,  24,  01, -13, -10,  16,  15, -01, -20, -13,  20,  15, -22,  18, -25, -04, -23,  19,  17, -16, -06,  19, -19,  22, -17,  09, -04, -04,  07,  13,  09,  12,  14, -13, -25, -18, -22,  15,  06, -15, -21,  03, -24, -16, -04, -24,  05, -02,  22,  00,  09, -09, -06,  17, -10,  04,  01,  11, -25, -14,  01,  11,  23, -07,  23, -25,  00, -22,  16, -17, -11,  22,  11, -10, -18, -16, -07,  12,  07, -10, -13, -07,  08,  08, -14,  23, -11,  14,  11, -11, -25, -10, -23, -24,  10, -25, -24, -13, -21,  19, -05, -07,  17, -17,  10,  24, -08, -22,  13, -24, -05, -22, -06, -22,  11,  05, -22, -24, -05,  16, -08, -03, -17, -05, -02,  18, -05,  02, -18,  01, -04,  04,  21, -10,  12,  08, -11, -19,  11, -20, -18, -17, -17,  02, -12,  19, -16, -07,  20,  06, -15, -10, -21, -05,  10,  04, -09, -18, -19, -02,  09,  05, -22,  07,  20,  15, -09, -15,  24, -21, -08, -19, -12,  00,  10,  01, -06,  20,  20, -08,  01, -18,  07,  07,  02, -08, -13,  18,  01, -07, -08, -13, -25, -03,  20,  21, -11, -12, -17, -12, -08,  00, -05,  05, -25, -18, -16, -06, -21, -19,  13,  08, -12, -05, -10,  17,  14,  04,  11, -07, -25, -20,  05, -25,  04,  00,  21,  18,  13, -21, -18, -17,  04,  04,  13,  06,  11,  24, -22,  16, -20,  16, -01, -07, -11,  16, -12, -22, -04, -24, -04, -04, -19, -21, -04,  12,  04, -07,  05, -05, -01,  12,  03, -19, -09, -07,  12, -22, -05,  17,  21,  00,  09, -03,  21,  23, -12, -16, -22,  09, -15,  02, -18, -07,  06,  04, -20, -13,  24,  12,  09, -02,  00, -11,  06,  18,  10, -04,  23, -20, -12,  19,  07,  22, -09,  03,  22,  07,  14, -24, -07, -24,  05,  01, -04, -14, -20,  03,  00, -19, -09, -15,  06,  18,  01, -12,  11, -14,  11,  10, -07,  24,  06, -24,  24, -25,  06,  21,  07, -04,  24, -23, -01,  06,  03,  23,  19,  10,  01, -05,  16,  19,  07, -02,  12, -17,  13,  01, -03, -01, -12,  15,  00,  21,  18, -01,  21,  00, -02,  05,  23, -01,  08, -03, -19, -12, -03, -25,  24,  24, -03,  17,  20, -21, -08,  10, -10, -20, -14,  14,  06,  01,  04, -18, -03, -02,  08, -04, -25, -19, -24,  23,  08,  11, -03,  14, -25,  20,  16, -24,  21, -11,  18,  16, -07, -12,  01,  10, -07,  14, -01, -23, -08, -19, -14,  15,  04,  19, -14,  06, -22, -11,  04,  11, -24, -24,  02, -22,  23, -07, -19,  19,  07,  24,  13, -22, -13, -09,  13,  08, -17, -12,  12,  00, -04,  23, -10, -25,  17,  03,  06,  22,  20, -13,  08,  21, -10, -13, -24, -11,  06, -18, -15, -12, -17,  23, -07, -02, -10, -18, -17, -02, -03,  20, -25,  18,  20, -07,  20,  14,  21,  03,  12,  16,  15, -03],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);


//length == 1025
  check([ 13,  12, -23, -12, -22,  08, -12, -07, -08, -04, -14, -09,  05,  16,  15,  20, -21,  10,  24,  17,  07, -20, -24,  05, -13,  09, -14,  21, -14, -08, -11, -25, -19, -08, -12, -16, -23,  03,  04, -06, -23,  16,  13,  09,  07,  03,  06,  13, -11,  06,  07,  21,  13,  08,  02, -22, -07,  13, -24,  06, -18, -09,  06, -12,  10,  21, -03,  12,  00, -22, -19,  04,  19,  19, -12,  03, -02,  19, -07,  12,  02, -25,  10, -09,  11, -11, -04, -19, -21, -03,  12, -14,  13, -04, -01, -02, -06,  23, -13,  21, -23, -06,  00,  23, -10,  13,  04,  15,  10,  22,  04, -13, -25, -08,  05,  13,  06, -24,  19,  11, -01,  08,  24, -11, -19, -01,  15,  01, -01, -23, -03,  03, -04,  23,  04,  14,  13, -15,  04, -02, -18, -14,  13, -16,  03, -07,  22, -16, -05,  16,  22,  21,  02,  22, -13,  08, -02, -23, -16,  24, -20,  09,  03,  01,  09, -16, -08, -03, -06,  24,  23,  03, -15,  13,  13,  13, -19,  12,  24,  03,  04,  22,  01, -17,  21,  14,  16, -06,  16, -22, -07,  21,  12,  23,  00, -02, -18,  19,  22,  03,  18,  20, -18, -22,  08,  22,  18,  17,  09,  18, -03, -10,  17,  24, -02,  13,  13, -08, -16,  06, -03,  02,  03, -16,  01, -20,  07,  10,  24,  04, -11,  18,  02, -02,  23, -13, -03,  19, -19, -19,  14,  04, -01,  06,  03,  22, -04, -07, -09,  05,  24,  13, -16,  04,  24,  10,  11,  08, -02,  11, -10,  14,  06,  17, -11,  04, -19,  11, -02, -12,  17, -13,  17, -09,  20, -03, -09, -07,  15,  09,  23,  16, -02, -17, -02, -03,  20, -16, -19, -05,  20, -04, -16,  03, -10, -02, -17, -02, -16,  08,  11, -21,  23,  05, -03,  20, -21,  15, -11,  21,  00, -13,  13,  23, -03, -14, -03, -05, -03,  03,  15, -05, -24, -23,  23, -07,  00, -17,  17,  12,  17,  05,  18,  17, -12, -10,  12, -08, -17, -22, -11,  08, -09, -23,  06,  15, -10, -22, -15,  12,  09, -24, -16,  12, -22, -17, -17,  05, -09, -25, -06, -15,  07, -13, -21,  20,  05,  17, -12,  13,  20,  02, -02, -12,  06, -21, -21,  21, -16, -09,  10,  20, -06,  22,  10, -01, -20,  18, -20, -02,  20,  01,  09,  02,  16,  13,  00, -04,  07,  13, -14,  05, -08,  09,  18,  23,  15,  24,  21, -24, -07,  08,  22,  12,  05,  09, -13,  10,  02, -06, -14, -01,  20,  20, -22,  11,  10,  03, -16, -07, -09, -03,  23,  08, -17,  18,  08,  23,  20,  04, -23, -10, -10, -24, -23,  20,  10, -09,  08, -13,  10,  19,  13,  06,  16,  16, -08,  01, -05,  04,  21,  13, -24,  21, -01, -15,  15, -18, -17,  12,  14, -15, -23, -21, -14, -19, -24,  23, -02,  11, -13, -17,  05, -25,  16, -02,  17, -14, -25, -13,  15,  21, -23,  16,  18,  01, -24,  10,  09, -13, -01,  00, -01,  01,  06,  11,  09,  07,  11, -18, -06,  24, -07, -24,  24, -16,  00,  18, -05,  02, -18, -15,  00, -15, -23, -07,  11, -22, -20, -03, -10,  04,  22,  15, -18,  03,  03,  17, -12, -09, -24,  09, -10, -06,  10, -08,  04, -13, -15, -24,  14, -07, -13, -10,  03, -09,  10, -11, -04,  16,  14,  14, -03,  13,  06,  07, -06, -16, -01,  07,  02,  02, -09,  18,  22, -22, -15,  03, -09, -03,  04, -20,  15,  18, -03, -05, -16, -17,  12,  06, -24,  01, -05, -02, -11, -24, -20,  08, -13,  06, -08,  14, -16,  08,  09, -17,  12,  21,  11, -20, -06, -08, -15, -14, -14,  10,  07, -05,  18, -06, -22,  19,  20, -02, -06, -14, -01,  02,  20,  13, -15, -11,  05, -04,  23, -11,  04,  12, -14, -08,  17,  07,  12, -21,  18,  23,  14,  00, -05,  09,  21, -01,  05,  16,  22, -25, -20, -01,  04, -23, -11,  14, -09,  19, -14, -09, -16,  17, -22, -03, -13,  22, -21,  24, -23,  22,  22,  18,  00, -08,  03, -04,  18, -17, -10,  16, -15, -05, -08,  14, -03,  06,  06,  15,  01,  19, -18,  12,  11, -15, -16, -25, -15, -10,  24, -11, -13,  23, -18,  14, -07,  12, -14, -14,  23,  01, -21, -15,  23, -02, -23, -03, -20,  08, -13,  08,  02, -06, -03, -10,  07,  08, -09,  19,  23, -08, -17, -13, -09, -10, -23,  11, -20, -12,  22, -20,  16, -21, -10,  14,  02, -08, -12,  07, -23,  00, -08,  04,  22,  16,  22,  06, -01, -12,  00, -03,  05,  08,  10,  23, -25,  12,  09, -18, -23,  09, -13,  18,  13,  05,  09, -10,  22,  22, -25, -23, -01, -06,  08, -02, -14,  05, -21,  10,  20,  06, -15,  03, -09,  20,  01, -06,  09, -12,  03,  11,  22,  16,  06,  10, -02, -08, -25, -03, -11, -23, -01,  15, -03, -17, -11,  08,  13, -05, -05,  09, -21,  05, -13, -05,  00,  15,  16, -14, -22, -05,  24, -25, -12,  07,  12,  11,  24,  15, -17, -10,  17,  08, -19, -09,  18, -05,  24,  06,  17, -03, -08,  21, -23,  06, -06,  05, -03, -15,  16,  00,  07,  18,  03,  20,  00, -08,  08,  00, -18,  17,  15, -23,  02,  23, -07, -05, -05, -05, -22, -12,  17, -04, -16,  19, -21,  05,  01,  01,  16, -07, -21, -02, -12,  09, -04,  13, -24, -21, -10, -16,  23, -19, -12,  00, -21,  06,  22,  02, -24, -22,  15,  20,  01, -24,  15,  05,  07, -09, -18,  00,  11, -12, -25,  24,  22, -02,  15,  23,  03, -20, -16,  03, -12, -03, -19, -05, -19, -22,  22, -18, -17,  14, -22,  09,  15,  20, -10, -01, -12, -01, -24, -23,  12, -23, -22,  09,  00,  18,  09, -20, -24,  19,  09, -11, -07,  15,  09, -01,  20,  08,  09, -21, -03,  14,  15, -12,  09, -18,  14,  24,  06,  16, -24, -07,  20, -18, -21, -03, -23,  16,  05, -22,  10, -11, -07, -20, -19, -21,  05, -22,  13, -11, -16, -13, -20, -25,  00,  14, -18, -08,  15,  16, -17,  19, -16, -20, -24, -09,  02],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([-22, -18, -18, -18,  19, -02,  02,  24,  04,  08,  06,  10, -04,  22,  19,  11, -23,  21, -12,  18, -21,  05,  09,  20,  15,  05, -19,  20,  06, -01, -02,  11,  06,  07,  18,  02, -19, -03,  04,  12, -19, -15, -03,  04, -15, -06, -10, -13, -10,  04, -17, -04, -14,  19, -07, -23, -01,  02,  22, -20, -24, -03,  18,  10, -20,  12, -13, -12, -14,  18, -23, -08, -19,  02,  24, -09,  21, -11,  05, -12,  20,  13,  10, -18,  09, -20, -16, -17,  07, -17, -10,  11,  08, -16, -04,  13,  23,  10, -22, -16,  04, -20,  04,  10,  07,  03, -22,  05,  19,  08,  19,  15, -01,  06,  24, -17,  13, -17, -06, -04, -07,  09, -16, -24,  20,  05,  16,  20, -08,  19, -18,  23, -23,  11,  10,  11, -09,  13, -06, -13, -01, -10, -21,  23,  23, -22, -17,  11, -12,  02, -16,  07, -11, -07,  10, -14, -25,  02, -18, -07, -02, -11, -09,  02, -23, -21, -11, -05,  17,  10,  07, -09, -25,  12, -09,  23,  15,  02,  09, -21, -19,  21,  13, -03, -11, -02,  09, -10, -25,  18,  10,  01, -16, -22, -22, -14, -18, -06,  06, -23, -21, -12, -07, -19, -25,  12, -21,  18, -11,  16,  24, -05,  12,  12,  18, -24, -15,  04, -07, -12, -03, -22,  16,  08, -18,  19,  21, -09, -09,  02, -07, -05,  17,  14,  02,  20,  01,  08,  15,  17, -01,  14, -13, -12,  01, -18, -10,  13,  13,  10, -22, -15,  14,  21,  20,  23,  16,  16, -11, -16, -05,  08,  06, -12, -03, -17, -15, -25,  19, -23,  17, -05,  16, -19,  09, -06, -09,  24, -16, -21,  09, -12, -08,  00, -16, -13, -02, -23, -21,  15, -12, -01,  00,  20,  14,  22, -20, -24,  24,  24, -22,  18, -05,  21,  24, -21, -10, -08, -20,  00, -03,  16,  15,  16, -08, -24, -22,  17, -19, -16,  07, -06,  09, -18, -11,  00, -19, -05,  02, -18, -06,  07, -25,  16,  04, -23,  20,  19, -04, -23, -04,  18,  19, -14,  11, -12, -10,  15, -20, -04,  24,  15,  15,  10,  24, -18, -14, -17,  02,  15, -08,  23, -03, -05,  17, -22, -03,  14,  23,  18,  17, -04,  14,  13,  08,  00, -24, -25, -08, -17, -04, -08, -25, -12, -21, -23, -05, -10, -15,  24, -20,  04, -25,  05,  24,  17,  08, -04,  08,  08, -08,  00, -20, -17, -12,  15,  10, -09,  15, -22,  00, -12, -03,  02,  01,  01,  04,  24,  19,  14, -25, -24, -04, -23,  08, -05,  19, -08,  17,  03, -23, -14, -20, -18, -04, -04,  24, -19,  12,  16, -14, -11, -21,  10,  17,  08, -11, -04,  09, -17, -12,  09, -14,  09,  14,  20, -21,  10, -13,  23, -12, -11, -14, -04, -01,  07,  17,  00,  16,  06, -08, -23,  23, -04,  15,  15, -19, -21, -12,  15, -11,  03,  02,  00, -11, -09, -05, -06, -24,  09, -06, -08, -24,  08,  15,  00, -10,  07, -25, -17, -10, -06, -12, -12,  16, -22, -20,  24, -18, -06,  15, -04,  22, -06,  23, -13,  10, -06,  08,  13, -22, -21, -18, -21,  12,  22,  06, -20,  06,  09, -10,  22, -22,  03, -15,  21,  08, -09,  21,  17,  12,  13, -10,  11, -18, -11,  23,  19,  08,  08,  09,  13,  13,  17,  20,  02,  14,  03,  09, -04, -13, -25, -05, -07,  03,  07, -11, -11, -25, -13, -19,  12, -25, -03, -01, -16,  11, -01, -22, -04, -17,  15, -16,  23,  07, -19,  02, -02,  10, -13,  21,  22, -11, -09, -10,  19,  24,  07, -17,  24,  19, -10,  14,  20,  12, -12, -19, -02,  14, -13,  19,  24, -23, -20,  22,  11, -13,  02, -16,  22,  16, -19,  19, -20, -01, -13,  24,  00,  19, -17,  00,  15, -02, -09,  10, -15,  06,  17,  10, -05, -19,  04, -05, -17,  11, -06,  19,  23,  21, -20,  20,  14, -12,  17,  19,  13, -19,  21, -12, -25, -21,  15,  15,  04, -19,  03,  16,  12, -03,  01, -15,  03, -18,  05,  13,  18, -24,  07,  17, -25,  14,  14,  14, -22,  06,  09,  16,  12,  05, -21,  14,  11,  22,  07, -10, -22, -13, -17,  18,  09,  09, -22, -11,  18,  10, -23,  13,  11,  11,  05,  11,  00, -03,  03,  03, -20, -13, -04,  20,  19,  03,  09,  07,  00, -07,  22,  05,  05, -20, -02, -09,  16,  03,  05,  11, -10,  09, -01, -23, -03, -18,  15,  23,  04, -07,  03,  09,  07, -25,  06,  01,  03, -09, -17, -20,  11, -18,  10, -08, -11, -14,  10, -18,  16, -09,  18, -18, -23, -07, -16,  00,  00, -24,  00, -19, -05, -22,  17, -23, -20, -01,  06,  08,  17,  16,  13,  03, -24,  01,  22, -08,  12,  08,  00,  03, -24, -05,  10, -22,  13,  21,  05, -10,  23, -20, -02, -07, -16, -09, -03, -11,  15, -20, -25,  07,  22,  15, -13, -25, -09, -15, -08, -20,  20,  17,  09,  21, -12, -04, -24, -22, -07,  07, -04, -07,  14,  21,  13,  23, -13, -13, -10, -23, -07, -08,  11, -08, -18,  24, -08,  01, -14,  09,  06, -19,  04, -08, -23,  19,  14, -20,  24, -16,  12, -03,  04,  02, -06, -08,  02,  06,  04,  19,  11,  22, -14, -01, -09, -04, -02,  08,  22,  11, -05,  03,  17,  24,  21,  21,  20,  12, -23,  19,  23,  16, -06,  02, -05,  13,  19, -25, -04,  00,  19, -18,  00, -19,  07,  16,  04, -18,  00,  01,  21,  22, -19,  13,  23, -23,  12,  18,  16,  14,  14,  14,  05, -17, -07, -22,  21, -13, -22, -07,  13,  22,  02, -10, -20, -14, -19,  09, -04,  08, -13, -08,  05, -06, -18,  03, -02,  19, -04, -10,  08, -14, -19, -09, -04,  00, -06, -05,  14, -01,  13,  04, -04, -08,  19,  04,  04, -24, -10, -23,  09,  03, -06, -10,  22,  01,  20, -05, -04, -08,  12, -19,  05,  19, -01, -22, -04,  20, -02, -15, -06, -14,  15,  18,  06,  11, -01, -13,  12,  14, -11, -01, -08,  08,  16, -09, -14,  11,  12,  09, -20, -01,  18,  12, -05, -08,  16,  16, -12, -11, -23,  09],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([ 03,  19,  04, -16,  05, -22, -02, -05,  18,  12,  19, -15, -03,  12,  04,  10, -02, -09, -05,  06,  17, -12, -07, -12,  07, -16, -21,  22,  01, -17,  09, -21, -21, -12, -10,  10, -08,  13, -18, -15,  02, -22, -03,  24,  15, -24,  09, -10, -06, -19,  21, -13, -04, -08,  00, -21,  03,  06, -22, -21,  17,  12, -15,  21, -24,  02,  08, -07, -08,  17,  05,  19,  20, -23,  20,  12, -19,  05, -22,  00,  11, -24,  12, -17, -07, -11, -11,  24,  23, -08, -22,  15, -18, -09,  13, -17,  18, -03,  03, -12, -09, -17, -18, -13, -13, -22,  24, -07,  10, -21,  19, -02, -17,  08,  08,  01, -25,  22,  02,  23, -08,  06,  15, -01,  24,  03,  09,  17, -23, -13, -20, -06, -03, -10,  08,  09, -05,  07, -22, -18,  14,  24,  05,  22,  09, -11,  00,  09, -12, -22,  07,  07,  09, -01, -17,  08, -22,  17,  02, -18, -19,  10,  01,  03, -23, -16, -10, -03,  19, -05,  04,  08, -04, -14,  07, -20,  00, -18,  17,  16, -15, -01, -02,  21,  24,  07,  06, -21,  01, -14, -14,  10,  21,  15, -10,  23, -24,  05, -03,  22, -23, -22,  07, -02, -11, -11,  04,  17, -03, -04,  08,  09,  22, -17,  06,  23,  17, -13, -21, -04,  00, -07, -19, -04, -15, -02, -04, -14, -21,  20, -14, -19,  23,  18,  07, -10, -17, -12, -18,  07,  11,  17, -09,  10, -23,  24,  11,  20, -11,  15, -07,  14, -15,  01, -12, -05,  24,  09,  09, -20,  07,  20, -11,  05,  15,  21,  22, -25, -16, -19,  07,  22,  23, -24,  07, -22, -23, -07, -25, -09, -14, -07, -17, -04,  19, -04,  17,  20, -18,  01, -24,  14, -02, -10, -03, -12, -12, -04, -11, -03,  03,  23, -04,  03, -24, -22,  06, -21, -01,  06, -03,  10, -24,  05, -19,  22, -22,  23,  18, -12,  01,  21, -23, -24, -14,  01, -10, -01,  23,  06,  23,  03,  04, -06, -19,  08, -01,  13,  12,  23, -04, -16,  08,  00,  17,  17, -01,  22,  17, -06, -15, -06, -10, -12, -05,  03,  16,  12, -23,  16, -07, -23, -06, -25, -02,  01,  08,  23, -09, -03,  23,  14,  08,  09, -11,  00,  01,  16, -02, -07, -15,  08,  14,  01,  23, -13, -21,  17,  24, -16,  08, -05, -14, -20, -03,  12,  06, -18,  12,  24,  04,  10,  13, -13, -06, -20,  15,  22,  23, -12, -09, -17,  23, -20,  09,  24, -06,  16,  16, -06, -25,  01,  16, -12,  06, -12, -25, -11, -05,  12, -10, -24,  00, -19, -12,  21, -12, -20,  19, -14, -05, -13, -06, -06, -06, -21, -05,  14,  22, -12, -17,  22,  14, -24, -15, -02, -11, -12,  14,  11, -25, -20,  14,  02, -14, -21, -01, -01, -15, -07,  10,  05,  07, -21, -24, -24, -15, -02,  15, -18,  11, -25, -19,  03, -24, -06, -24, -08,  07,  17, -20,  09,  22,  19, -13, -15, -24,  11,  09, -14, -19, -04,  18,  13,  03,  20,  16,  15, -07,  07, -25, -18,  09, -17,  10,  13,  02,  13, -18, -16,  05, -12,  19,  05, -16, -17,  17, -15,  21,  02, -02, -21, -25, -08,  19,  05, -13,  10, -04,  07, -06, -02,  16, -21,  06,  01,  17, -16, -09,  24, -05,  24, -11, -11,  06,  01, -01, -02,  11, -05, -23, -15, -01, -22,  02, -07,  08,  16, -19, -19,  00,  00,  06, -08,  04, -12,  20, -02, -01, -11,  00,  19, -12,  14, -16,  19, -10,  10, -08, -21, -19, -05, -09,  07,  00,  20, -24, -15,  13, -18, -06, -12,  09, -25,  07, -11, -12,  05,  14,  14,  19, -11,  09, -16, -19,  20, -22, -02,  05, -03,  04,  11,  17,  20, -04, -06,  17, -03,  07,  05,  06, -24,  21, -10, -24,  05,  06, -08, -15, -02, -19, -19,  12,  15, -10,  20,  12, -07, -04, -07,  16, -25, -19,  10,  21,  02, -18,  15, -24,  14, -04,  07,  15, -08, -25,  18,  22,  08, -13, -17, -19, -04, -09,  21, -12,  07,  16, -24, -25, -13, -06,  18, -10,  00,  06, -12, -22,  13, -22, -21,  04, -01,  14, -06,  16,  16, -11,  16, -01,  02, -24,  08,  23, -08,  04, -14,  24, -03, -13, -23,  12,  08,  20, -23, -16,  03, -10, -11, -07, -05, -05,  22,  20, -14, -07,  13, -23,  08,  04,  04, -13,  07, -13, -13, -25,  16, -02,  24, -10,  13, -22, -23, -04,  24, -19,  07,  04, -02,  23,  23,  19, -06,  22,  14,  05, -09,  04,  10, -24, -16, -11, -12,  16,  01,  00,  18, -06, -25,  20,  11,  13,  23,  14, -13,  24,  20,  21,  04, -06,  20,  04, -12, -09,  01, -21,  23,  17,  08,  08,  18,  19,  24, -17,  13,  02,  10,  06,  21,  11,  01,  08,  01,  00, -01,  15, -01, -04,  12, -20,  17,  07,  09, -18,  23, -12, -14,  21, -20,  22,  07, -24,  16,  06, -14,  04, -16,  22, -12, -18,  10,  14,  17, -14, -09, -07, -23,  18,  15,  16,  23,  07, -02,  10,  15, -02,  23, -22, -04, -20, -25, -22, -17,  17,  12, -05, -02,  21, -08,  11, -20, -21,  01,  23, -10,  19, -09, -06,  12, -17, -15,  13,  16,  10,  00,  08, -17, -02,  11,  07,  05,  12,  10,  14,  06, -03, -14, -21, -05,  03,  16,  03,  09, -06,  03,  24, -12,  21, -04, -22, -20,  08,  16,  23, -06, -09,  06,  04,  16, -06, -14, -04, -19,  22, -13,  14, -04, -02,  19,  19, -22,  12, -03,  12, -17, -25,  14, -02,  21, -15,  01, -24,  18, -08, -24, -11,  10,  07,  19,  03, -23, -18, -25, -15, -19, -11, -25,  03,  13,  21, -01,  18,  10,  21,  06,  18,  23, -05, -09,  19,  07,  18,  23,  02, -13,  24,  17, -25,  09,  13,  03,  13,  20,  05,  23, -21,  20, -25,  09,  10,  23, -17,  03,  08, -19, -14,  03, -21,  06,  20, -25, -10,  15, -25,  18, -21, -23,  12, -21,  11,  02,  10, -01, -01, -10, -01,  03, -13,  00, -13,  24,  00, -03,  03, -16,  03,  14,  12,  09, -02,  09,  10,  15,  01,  10,  10],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([ 06,  12, -01,  10,  00, -24, -03, -24,  03,  13,  01, -17, -23, -22, -02, -23,  03,  20,  07,  14,  01, -02,  04, -15,  23, -12,  20,  14,  15,  08, -01, -04, -03,  24, -17, -25, -23,  06, -24,  07, -04,  02,  16,  00,  07, -11,  04, -14, -14, -12, -23,  12,  12,  06,  23,  12,  20,  20,  03,  12,  03, -22, -15, -22, -21, -05, -22, -17, -22, -21,  16,  01,  09,  09, -23, -09,  23,  06,  04, -16,  20,  07,  24,  09, -12,  22, -04, -15,  17, -23,  24, -02, -18, -14,  01, -14,  07,  04, -04,  10,  08, -11, -13, -06,  23, -09,  11,  23,  22, -10, -17,  19,  24, -18,  05, -10, -19, -21,  00,  23, -19,  02, -04, -12,  13,  22,  01, -05,  03,  22, -17, -11, -11, -03,  08, -13,  13, -04, -14,  12,  14, -04,  09,  13,  05, -11, -22,  11, -07,  06,  09,  01, -15, -17,  14,  23, -18, -10, -04,  11, -10,  04, -25,  04, -24,  08,  16,  16, -20, -21,  03,  21,  00, -13,  09, -20,  04,  15,  16,  24, -04,  03,  01,  06,  13, -08,  06,  20,  10, -23,  06, -25,  08,  08,  06,  09, -08, -01,  02, -01,  04, -19, -05, -19, -05, -19, -13, -24,  21, -20, -24, -06,  10,  04, -23, -02,  21,  09, -06,  06,  13, -25,  08, -03,  09, -11, -17, -22,  16,  11,  04, -05,  19, -24,  01, -11, -18,  15, -07, -19,  21, -04,  02,  08, -25,  05, -18,  23, -09,  01,  07, -21,  03, -10,  01, -11,  07,  12, -08, -02, -02,  23,  20, -08,  24, -02,  08, -16, -11, -24, -08, -13, -03,  19,  20, -01,  01, -23, -02,  17,  05, -20,  24, -16, -03,  02, -02, -19, -11,  18,  06,  14,  16,  01, -19,  18, -25,  17, -21, -09,  18, -02,  05, -07, -08,  00,  17,  21,  05, -10,  15, -15, -03,  16, -04,  22, -06,  20, -22,  10,  15,  10,  00,  06, -12,  08,  01, -10,  00,  07,  06, -04, -20, -12,  14,  00,  14,  06, -04, -04,  24, -12,  08, -04, -20, -20, -05, -01, -23, -01, -14,  17, -14,  11,  00, -01, -03, -23,  15,  22,  09, -02, -07,  17,  12, -16, -08,  03,  16,  15, -24,  17, -22,  09, -12, -17,  14,  11,  09,  16, -15,  21,  08, -04,  09, -16,  22, -17, -12,  14, -19,  24, -10,  01,  16, -21,  11, -15,  07,  04, -25,  08, -04, -19, -06,  11, -11, -16, -03, -24, -25,  09,  22,  11, -20,  08,  22, -20,  17, -13,  19, -25, -14, -16,  03, -20, -12, -11, -10,  22,  20, -07,  07, -09, -01, -23, -22,  15, -12,  02,  16, -12, -13,  15, -24, -06, -01, -25, -01, -07, -13, -04, -07, -01,  05,  21,  06,  21, -12,  23,  18, -17, -09,  03,  02,  17,  05,  05,  08,  18, -16,  01, -17, -02, -08, -13,  18,  18, -13, -06, -14,  00,  15,  06, -24, -02,  02,  07, -06,  17,  05, -11, -24,  24,  19,  03,  16,  01, -15,  01, -04, -06, -22,  07,  18, -03,  19,  13, -10, -17, -18,  01,  08, -25, -18,  11, -02,  11, -05,  19,  04, -24, -15,  05, -23, -20, -15,  18,  08, -05, -03, -20,  16,  02,  12,  11,  24,  06,  01, -11,  16,  09,  17,  02,  09, -24, -12, -16,  14,  09, -20, -07,  12, -08, -25,  14, -01, -15,  09, -17,  07, -17, -12,  01,  10, -25, -11,  11,  08,  16, -25, -01,  00,  19, -24, -14,  22, -08, -03,  12, -22,  04, -20,  15,  21, -17,  06, -04, -07, -08,  04, -22,  01,  19,  06, -14,  19,  20,  23,  04,  11, -25, -20, -12,  22, -16,  01,  19,  03,  23,  06,  06,  04,  14, -02,  01,  22, -21,  22, -08, -04,  03, -03,  24, -03, -22, -12, -07,  24, -12,  22,  12, -12, -21, -24, -13, -12,  04, -16,  16,  05,  15, -01, -16,  06,  22,  10,  03, -24,  07,  23,  00, -13, -05, -01,  09,  01,  12, -23,  02, -23, -24, -11, -07, -19, -08,  05, -04,  24,  14, -10,  04,  07,  14,  13, -12,  12, -01,  19,  15, -17,  19, -08, -04, -09,  19, -18,  17,  08, -15, -04,  11, -14,  13, -21, -06, -20,  09,  18, -19,  01, -15,  10, -15,  24, -01,  00,  13, -25, -04,  06, -15, -10,  23,  08,  09,  17,  16,  01,  01, -24, -25, -11, -11,  13, -07,  11,  20, -21,  04, -23,  05,  14,  12,  15,  15, -12, -09,  06, -12,  12, -13,  01, -20, -13, -16,  14, -18, -25, -08,  10, -22, -08,  24, -07, -20, -06, -19, -24, -02,  10, -20, -19,  01,  17,  23, -07, -17, -11,  24, -02, -21, -12,  24, -14,  03, -16, -25,  12, -14, -06, -03, -10,  12, -02,  10,  19,  17,  16,  22, -08,  01, -23, -02, -21,  22, -03, -03, -20,  13, -01,  05,  19,  12,  05, -20, -08,  16, -18, -21, -23,  02,  03, -08, -09, -24, -23, -15,  20,  18, -17, -10, -04, -13,  13,  00, -16, -13, -25, -09, -22, -01,  22,  22, -12,  04, -20,  06, -05, -11,  10, -03,  16, -11,  17, -18, -08,  21, -05, -10,  17,  05,  05, -12,  17, -05,  16, -21,  08,  18, -03,  11, -06, -04,  10,  07, -25,  17, -10, -05, -18, -22,  20,  23, -06,  14, -17,  11,  10,  05, -24,  04, -15,  08,  18, -21, -21,  11, -17,  14,  06,  08,  00, -25, -21, -13,  07, -20, -20, -25,  02, -13, -22, -03, -13, -03, -12, -03, -15,  24, -23, -13,  05, -11,  22,  00, -06, -24, -14,  04,  15,  19, -13, -08,  19, -06,  07,  04, -01,  12,  04, -24, -24,  07,  01, -10, -19,  14,  15, -09,  15,  17,  05, -04, -16,  03,  21,  05,  06, -15, -14, -03, -21, -01,  16, -24,  20, -02,  05, -06, -13, -14, -03, -10,  20,  23,  08, -24,  15, -02, -06,  05, -08, -25, -22,  01,  03, -23, -19, -14, -13, -07,  10, -07,  19,  02, -06,  14, -23, -24, -15, -08, -13,  07,  09, -16,  08, -08, -15, -02,  15,  05, -20, -17,  07, -14,  11, -13, -12,  20, -02,  02, -10, -16,  22, -16,  13, -06, -25,  17, -05, -13, -14,  10,  21],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([ 21,  19,  04, -12, -18, -21, -19,  14, -15, -11, -02, -02, -25,  10,  11,  20, -17, -10, -15, -06, -13, -04, -16,  06, -02, -23, -21,  12, -10,  16,  09, -14,  12, -12,  02,  21, -07,  08,  10,  05,  22, -17, -22,  24,  20,  14,  22, -19, -19, -18,  00, -07,  06,  12, -23, -19,  14, -17,  19, -19,  24,  03, -07,  13,  18,  20,  10, -14,  03, -03,  16,  02,  08,  19,  01,  03,  10, -02,  09,  18,  08, -15, -11, -09,  22, -09, -01,  13,  01, -07,  21,  02,  23, -11, -10,  17, -14, -23, -22,  16,  00,  22, -07, -17,  18,  22,  11,  06, -03, -02, -01, -18,  08,  13,  00,  07, -19, -25, -03,  07, -07, -07, -14, -06,  10,  04, -14,  23,  06, -09,  15, -19, -10, -15, -09, -16, -18, -20,  17,  07,  03, -09,  16, -12, -18, -08,  22, -10, -08, -06, -25,  12,  14, -14, -19,  01,  15, -08,  00, -03,  11, -08,  05, -24,  02,  22, -13,  12, -23, -21, -06,  05, -02, -13,  20,  07,  04,  17,  22,  21, -12,  22,  11, -21, -14,  17,  06, -24, -13, -17,  00, -25,  00, -17, -24, -23, -20, -11,  14, -16, -05, -15,  16,  20, -02,  11,  02, -21,  03,  02, -24,  18, -01,  14,  22,  10,  06,  03,  14,  20,  13, -09,  20, -12, -01,  24, -07,  04, -10, -16,  15,  10, -05,  08,  08,  20, -04, -13,  24, -24,  14, -23,  19, -09,  18,  17, -22,  00, -03,  19, -03, -14, -14, -05, -01,  10, -06,  19, -08,  09, -21, -18, -04,  01,  18, -21, -02, -11, -08, -01, -07, -17,  02, -13,  01, -05, -19,  05,  22,  04, -01, -03,  15,  10,  17, -09, -02, -14, -14,  15,  20, -08,  24, -07,  18,  17, -02, -09, -16,  17,  15,  02, -23, -06,  16,  04,  17,  23, -14,  16,  02,  12, -10, -06, -02, -18,  12,  23, -07, -25,  13, -10, -08,  12,  09, -13,  07, -16,  05,  18, -22, -02, -03, -20,  17, -12,  09,  11, -12,  22,  05,  17,  10,  20, -14, -15, -20, -24, -17,  00, -24,  21,  16, -06,  10,  02,  08, -06,  13, -11, -13,  16,  12,  09,  23,  06,  23,  10, -05, -14,  07, -25, -21, -08,  22, -08,  02, -23, -07,  10,  03, -05,  08, -04,  16, -06, -25,  01,  13,  13,  15, -22,  06,  02,  12,  06, -14,  12, -09,  06,  24,  24,  08, -20, -07,  07, -01,  21,  12,  20,  08, -10, -08, -08,  13, -17,  13,  13,  11,  03,  03,  02,  06, -14, -19, -06,  17, -06, -19, -14, -25, -18, -13,  10, -11,  05, -07,  16,  03, -20,  11, -13, -03, -22,  06, -13, -12, -06, -25,  24,  24,  05,  01,  06,  18,  10, -23,  12, -21, -15,  23, -18, -05, -15,  17,  11,  16, -13,  02, -06, -06, -10,  08,  18, -07, -11, -20,  06,  10, -18,  08,  10,  12, -14, -07,  07,  21, -03, -05, -22,  09, -07, -15, -19,  04, -21,  18, -03, -08, -03,  18,  13,  15,  04,  07, -17,  20,  14,  17,  06,  22,  00, -07,  11,  11,  13, -06,  10, -13,  14,  13,  21, -16,  23, -22,  15, -21,  23, -13, -04, -03, -17, -13, -13,  14,  21, -02,  09,  10, -10, -08,  09,  17,  10, -04,  05,  00,  15, -08,  12,  06, -20,  11,  15, -20,  16,  06, -15,  14,  20,  08, -12, -20,  20,  03,  19,  18, -24,  04,  04, -07,  21, -10, -15,  09,  11,  17, -16,  03, -15,  24, -16, -08,  10, -23,  00,  01,  08,  10, -08,  05, -05,  05,  11, -07, -15,  05, -14, -14, -14,  17,  04, -17, -17,  16,  17,  21,  09, -22,  00,  21, -23,  11, -12,  12,  13,  13, -10, -02,  00,  07, -21,  21, -10,  15, -11,  00, -03,  02,  12,  09, -05, -07,  19,  05, -15,  13,  01,  21,  16, -22,  19,  21,  15, -18,  10,  05,  23, -24, -19, -02,  08, -15, -04, -25, -23,  12,  01,  01, -10, -10, -15,  12,  10, -19, -08,  20,  19,  20,  18,  13,  24,  12,  09,  16,  22, -06, -04,  20, -05,  02, -05, -19,  14,  19, -17,  18,  06,  09, -05,  23, -24,  07,  12,  12,  14, -21,  09,  08, -23,  03, -02, -24, -08, -18,  17, -11,  04, -10, -14, -24,  20,  09, -18,  09,  03, -07,  05, -14, -21, -23, -13, -19,  09,  24,  20,  00, -19,  04, -14, -17, -16,  09, -16,  04,  17, -22,  20, -04, -07, -18, -03, -12,  18,  07, -25, -02, -23,  07,  09, -19,  09,  23, -13, -07,  23, -16,  21, -19,  14, -18, -11, -25,  16,  00,  04,  10,  03,  00, -17,  23,  09,  08, -11,  02, -08, -09, -25, -06,  23,  11,  00,  07,  12,  15, -23,  12,  24,  23,  18,  15, -18, -18,  16, -24,  09, -03,  11, -11,  24,  22, -13,  08,  05,  03, -13,  22,  19, -11, -07,  19, -22,  18,  03,  15,  10,  06,  02,  10,  06, -05,  00,  14,  04, -09,  17, -12,  16,  05,  02,  15,  02,  16, -01, -16, -05,  11, -17, -09, -22,  01, -14, -19, -03,  16,  21, -18, -03,  00,  17, -19,  22, -07,  22,  01,  11,  14,  14,  02, -06, -07, -07,  22, -16,  19, -17,  06,  07, -08,  23,  10,  18, -14,  16, -10, -23,  14, -02,  02, -09, -10,  08, -12,  10,  07,  14, -03, -04,  05, -24,  17,  23, -04,  16, -15, -10, -25,  16, -25, -08,  14,  10, -15, -23,  04,  01, -18, -05, -24,  09,  12, -09, -06, -23, -21, -24,  19,  01, -03, -01,  04, -09,  00, -24, -17,  10, -07, -17,  03, -07,  00, -05, -19,  10, -03,  10, -12,  04, -18, -11, -10,  21,  08,  09,  24,  12,  12,  18, -10, -14, -06,  19,  03,  21,  22,  11,  08, -09,  19, -13,  11, -06,  07,  17, -19, -19,  04, -03,  11,  12,  11, -22,  10, -06,  13,  09, -17,  02,  04, -02,  14,  24, -05, -08,  22, -08, -22,  06,  10,  22,  20, -03, -07,  02, -09,  01,  08,  23,  23, -04,  10,  12,  00, -05, -17, -10, -18, -08,  17,  11,  15,  06,  12, -15,  23,  10,  05, -22, -07, -10, -23, -12,  14, -03,  15],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([-19,  24,  00, -21,  24,  24,  16,  11,  01, -12,  20,  16, -03, -13,  10, -16, -21, -06,  23, -08, -06,  10,  22, -02, -22, -11,  02, -09, -21, -25, -17, -13,  24,  09, -07,  23,  10, -16,  12, -14, -01,  07, -21,  22,  21,  16, -17, -23, -15, -17, -04,  07,  19, -07, -18,  22,  10,  09, -11,  14,  09, -01, -22,  10, -17, -04,  11,  20,  07, -02, -19, -17, -18, -15, -18, -22, -21, -08, -18, -11,  01,  04,  23, -05,  24, -20, -08,  09,  15,  08,  00,  01, -17,  03, -13, -07, -24,  23, -11,  10, -02, -05,  19,  05,  08, -22,  10,  12, -04,  17, -22,  22, -04, -23, -08, -04, -16,  11, -18,  24, -05,  08,  03,  05, -12,  17,  23, -08,  17, -13, -23, -10,  10,  23,  20, -05, -23,  05, -16, -02, -01, -11, -03,  21, -07,  14, -06,  03,  00,  01,  04,  22, -14, -18,  02,  00,  24,  03,  19,  16,  17,  21, -17,  02,  22, -20,  24,  24,  12, -15, -01, -13,  00,  21, -15,  18,  12,  04, -04, -11, -18, -24, -11, -04, -15,  18,  23, -15, -04,  17, -22, -11,  15, -13,  18,  12, -06,  20,  13, -18, -20, -11, -06,  05, -13,  06,  01,  24, -13,  22, -09, -06, -25,  05,  15, -14, -02,  15, -02,  22,  07,  03, -14, -02,  17, -19, -15, -13, -24,  24, -06, -18, -12,  15,  14,  03, -04, -10,  02,  08, -10,  20, -21, -08,  02,  22,  03, -22,  12, -22, -25, -05,  07, -12,  18, -01, -06, -20,  13, -04, -19, -18,  05, -03,  24, -06, -25, -05,  12,  04, -20, -21,  00, -15, -04, -21, -16, -23, -18,  21, -20, -18, -07,  14, -05, -12, -09,  17, -06, -21, -10,  02, -13,  20,  24, -12, -09,  24,  09, -22,  06,  16, -18, -17, -24,  04, -13, -15,  08, -05, -16,  13,  04,  02,  05, -23,  16,  21,  19, -13, -25, -16,  14, -11, -19,  14,  03, -03,  15, -11,  01, -02, -20,  10,  06, -16, -09,  19, -04,  24, -09,  05,  15,  20, -15, -05,  24, -22, -09,  18, -10, -07, -21, -21,  10, -15,  20, -12,  10,  13,  04, -14, -14,  09,  23,  18,  20, -08,  14, -08, -09, -20,  24, -19, -23, -16,  03, -23, -11,  21,  22,  04, -10, -21,  11, -25, -09,  08, -10, -24, -04,  19, -11,  10,  05, -12,  05,  01,  05, -04,  20,  23,  03,  19, -18,  05, -19,  10,  09, -05,  09,  09, -23, -24,  13,  13, -22, -21, -04, -07, -19,  20, -11, -05,  07,  21,  10, -13, -01, -08,  08, -06, -09, -14, -09, -02,  18, -01, -15,  03,  21,  19, -13,  23,  20, -23,  13, -25, -19, -13, -07, -11, -18,  09,  10,  14,  06, -03, -22, -20,  15,  11,  02, -19,  22,  18,  06,  15, -08,  18, -05, -12,  15,  09, -11,  12,  11, -23,  13,  18, -11, -19, -18, -04,  18,  19, -13, -01, -06, -10,  06, -16, -22, -17, -08, -25, -22,  23,  18, -05,  18, -10,  11,  08, -25, -25, -04,  11, -21, -14,  06, -06, -06,  16,  17, -13,  12, -18,  13, -19, -03, -05, -10,  03,  03,  07,  03,  07,  07, -02, -21,  03,  14,  17, -14,  16,  19,  09,  02,  24,  20, -16, -05, -10, -23, -13,  04,  14, -06, -07,  21,  19,  13, -12, -03, -07,  23, -23, -25,  07,  03, -18, -15, -08, -24, -01, -17,  21, -15,  12,  22, -19,  23, -08, -02, -25,  06, -23,  17, -24, -05,  13,  22, -15, -22, -04,  04, -24, -02,  06,  09, -24,  13,  21, -05,  15, -05,  05,  13,  06, -05,  10,  14, -07, -21, -11, -04,  10, -09, -12,  13,  14, -22,  10,  24, -19, -19,  03, -15,  07, -15,  21,  10, -25,  17, -17,  17, -10,  15,  07,  23, -15, -08,  14,  04, -04, -22, -23, -16, -04, -10,  22, -13, -07,  08, -13,  01,  16,  17,  11, -02, -21,  07, -14, -18,  00, -06, -24,  17, -16,  09,  15, -03, -24,  06, -22,  00,  09, -20,  09, -18, -03,  08, -05,  15, -09,  09, -07, -15,  03, -20,  10,  10,  12,  21,  17, -11, -08,  18, -17,  04,  02, -25, -24,  06,  06, -21, -17, -08, -16,  19,  00,  06,  02,  22, -02,  21,  08,  16, -19, -14,  23,  18,  21,  13,  17,  15, -23, -16,  11, -12,  13, -10, -12,  16,  23,  20,  20, -19, -11, -19, -23,  16,  14,  05,  13, -11,  03, -04, -17,  11,  10, -19,  04,  08,  19, -04,  01,  24,  06, -13, -13, -04,  04,  02, -10,  03, -03, -15,  11,  14, -06,  14,  05, -15, -04, -06,  02,  24,  17,  10,  10,  04,  18, -11, -12,  15,  13,  16,  14, -06, -22, -22,  17,  09,  05, -18, -13, -20, -05,  24,  19,  16,  15, -01, -22, -14,  20,  05, -15,  15, -10,  20, -04, -14, -14,  09, -24,  24,  00,  15, -05,  05,  20, -10, -10,  00, -01,  04,  07,  19,  05,  01,  12, -05, -22,  16,  06, -25, -02,  18,  17,  14,  15, -11, -25, -23, -25, -24, -22,  03,  18, -01, -17,  13,  14,  00, -10, -10, -18,  23, -15,  12, -01,  24, -15,  04,  17,  18,  05, -09,  12, -01, -18,  02,  13, -18,  06,  14, -15,  10, -08, -20, -14,  02,  18, -23, -20, -17, -08, -13, -17,  04, -24,  08,  04, -12, -11, -02, -18,  21,  14,  21, -04,  21,  00, -16, -20, -18, -25, -08,  19, -08, -03, -18,  22, -08, -16, -23,  03,  03, -09,  11, -17, -06, -06,  14,  08,  11, -13,  17,  07, -21,  13, -22, -25, -12, -10, -17, -03, -10,  00, -07,  10,  23,  00,  07, -08,  09,  11,  20, -12, -21,  07, -02,  00, -22, -13, -17,  14,  01, -23, -03,  05,  15,  02,  08, -19,  17,  18,  03, -15, -07,  24,  20, -07, -01,  04,  11, -14, -08,  06,  01, -04, -12,  24,  21, -06, -12, -18, -17,  14, -16,  07, -03, -23, -15, -18, -15, -21, -25,  13, -11, -05,  14, -14,  14, -11,  15,  02,  00, -18, -15, -24,  05,  01, -23,  04,  20, -08,  13, -22, -17,  24,  13,  05, -24,  23,  14, -14, -21,  14, -23, -06, -15],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([ 16,  07, -24, -18, -02,  03,  07,  07,  13,  10, -10, -11,  14,  19, -14, -19,  07, -10, -10,  06, -22,  22,  10, -22,  12,  23, -16,  03, -23,  05,  15,  19, -12,  16, -24,  13, -04,  11, -05, -15, -02,  10,  01, -10,  06,  13, -04, -10, -20,  13,  22, -15,  11,  09, -10,  00,  07, -01, -22,  10, -20,  19,  06, -07,  12,  09, -19, -16, -03,  03, -04,  21, -09,  22, -14,  22,  12,  09, -12,  17, -02, -13, -23, -14,  21, -08,  13,  05,  17,  18, -10,  24,  14,  23, -08,  02,  08,  00,  11, -20, -22, -16, -22, -04, -19, -09, -06,  19, -22,  09,  13,  03,  21,  16,  14,  19, -15,  04, -01, -21, -03,  17, -22, -13,  15, -05,  16,  00,  22,  04,  08, -22,  13,  11, -01,  19, -20,  20,  15, -17,  04,  04,  11,  02, -03,  02, -02,  07, -19, -25,  12,  03,  17,  15,  15,  09, -12,  08, -13, -13, -13,  20, -10, -25,  08,  15,  20,  13,  12,  12,  21, -08, -07,  07,  21,  15, -16, -05, -02, -08, -03, -13,  21, -09, -21,  13, -23, -08, -03, -11,  05,  09, -14,  22,  10,  20,  12,  07,  08,  00, -04,  07,  19,  15, -09,  17,  05,  03, -11, -20,  20,  11, -08,  16, -23, -03,  07, -20,  16, -21, -06, -02,  15,  06, -04,  02,  03, -15, -16, -14,  12,  08,  20,  06, -02, -13,  01, -20,  15,  15, -14,  10,  02,  05,  04,  04, -21, -14,  09,  23, -08, -19, -04, -18,  12,  19,  10, -10, -20,  21,  03,  17,  06,  01,  01, -21,  13, -23, -15,  05,  17, -02, -10, -06, -20,  21, -24, -13, -18,  10, -15, -01,  16,  08,  09,  05,  03, -04,  22,  08, -06,  03,  02, -24, -21, -20, -18,  17, -18, -06, -01, -23,  19,  14, -02, -25,  13, -01, -13,  20, -13, -03, -03, -22, -20, -17,  11,  10,  04,  08, -07, -25, -14,  23, -22, -10, -22, -14, -16, -12,  05,  08, -10,  00,  00,  15,  02, -12, -10,  14, -15,  02, -12,  09,  07, -05,  17, -05, -19, -02, -21,  01, -01, -08, -01,  02,  10,  05,  15,  19,  18, -02,  05, -15, -25, -18, -25,  02, -03, -08, -07,  09,  19,  06, -06,  04, -22, -12, -24, -16,  12, -20,  13, -12,  00, -13,  17, -15,  19,  10, -19,  12, -17,  13,  24, -17,  22, -25,  10, -06, -08, -20, -19, -11,  11,  00,  20,  14,  15,  21, -24,  02, -21,  14,  17,  04, -22,  10,  14,  23, -05,  22,  12,  05,  11,  12,  13,  08,  14,  00, -20, -19,  05, -14, -03, -07,  13, -08, -18,  03, -09, -15, -19, -05,  24, -25, -24, -22,  12,  17, -22, -18,  14,  15,  14,  02,  04,  02, -14, -07, -21, -07,  02,  09,  04, -24, -21, -08, -06, -13,  20,  12, -03, -22, -16, -01, -21, -15,  02,  16, -23,  05, -24,  18, -03,  17, -04, -23, -05,  09, -03,  01, -23, -24, -12,  06, -22, -08, -25, -01,  06,  22, -14, -19, -22, -05,  05, -16,  07, -18, -25,  09,  14, -22,  02, -12,  21, -25, -10, -07,  09,  15,  21,  11,  16, -16, -06,  21,  02, -04, -05, -17, -06,  08, -11, -01, -20,  21,  08,  12, -20,  08, -02,  19,  14, -24, -17,  12, -22,  00, -18,  13, -08, -22,  01, -14, -12,  23, -18,  17, -06,  05, -23,  15, -12, -06, -11, -06, -10,  22, -17, -04,  08,  07, -08, -01,  10,  00, -14,  13, -22, -05,  01, -05,  00, -22,  08,  15, -24,  16,  07, -03, -04,  10, -12,  11, -21,  04, -18, -04,  02, -09,  17, -13,  23, -15,  11,  08,  12,  24, -04,  17, -04, -25, -10,  21, -20,  23,  12, -17,  14, -06,  05, -13, -19,  20, -24, -13,  00, -17,  09, -21, -01,  01, -07, -01,  13, -21, -18,  01, -20,  06, -07,  01,  06,  08, -03,  13,  09, -16,  21, -02,  06,  01,  13,  12, -01,  14, -25,  24,  22,  11, -20, -01, -13, -02,  23, -24,  04, -17,  04,  09,  16,  24, -15, -01,  10,  07, -13, -06,  19, -17,  19,  00,  11,  07, -13, -15, -02, -11, -14, -02, -25, -07,  24, -10,  16,  22, -07, -03, -18,  24, -19, -25,  23, -07, -01,  08, -22,  13, -23,  22,  23,  22, -03,  10,  06,  11,  22, -20, -22, -16,  05, -20,  04,  04, -03, -02,  01,  15,  20,  11,  14, -21,  13,  13, -03, -12, -02,  00, -22,  01, -01, -23, -02,  23,  12, -21,  10,  11, -14,  15,  20,  16,  22,  00, -05, -05, -25,  24, -13,  20,  12, -23,  24,  00,  17, -01,  15, -10,  24,  19,  18, -01,  21, -07, -03,  10,  00, -16, -04,  11, -24, -06,  05,  24,  21, -25, -04,  21, -24,  08,  16,  13,  10,  18, -11,  04, -08, -21,  22, -09, -25,  15,  17,  21, -16, -08,  06,  09,  03, -20, -03,  05, -01, -23,  06, -05, -20, -23, -09, -19,  10, -16,  22, -02, -23, -12, -21, -04, -06, -24,  15, -05,  19,  07, -09, -20, -24, -25,  16,  05, -20, -10, -13,  06, -07,  18, -24,  00,  20, -06,  08,  07,  05,  05, -20,  08,  18, -15, -21, -12, -12,  19,  08, -16,  04, -24, -09,  05, -22, -18, -13, -17,  00, -01,  16,  20, -06,  19, -05, -09, -12, -22,  24,  19,  11, -19,  04,  06, -09,  10,  19,  07,  07,  04,  18, -12,  08, -15,  20,  11, -06, -17,  22,  19,  09,  13,  14, -21,  08, -14, -05,  23, -08, -06,  17, -22,  01, -02,  11,  19, -16,  08,  03,  18, -13, -03, -19,  22,  09, -24,  09, -22, -16,  06, -25,  21, -04,  16, -25, -19, -22, -05, -20, -03,  17,  24,  02, -05, -02, -12, -09,  09,  21,  20,  02, -14, -06,  10, -17, -20,  11,  17, -17,  23,  00, -15,  19,  24, -23,  21, -20, -18, -07, -15,  04, -15, -15, -19,  07,  10, -04,  24, -06, -07,  21,  23,  04, -08,  08,  12, -03, -06,  05,  07, -06, -18,  18, -12, -19,  22, -16, -13, -21,  03, -03,  10,  15,  09,  18, -02, -06, -11, -01,  13,  07, -05,  11, -14,  12, -06,  24, -16,  16],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([ 06,  16, -15,  15,  11,  01,  22,  08,  12, -14,  14, -10,  10, -01, -17, -05, -08,  08,  16,  07, -18,  07, -09,  02, -05,  03, -09,  15,  04,  02,  08, -13, -05,  20, -21, -18, -04, -24,  15, -16, -11,  07,  01, -25, -19,  09, -03,  01, -08, -12, -15,  01,  20,  01, -22, -09, -19, -04, -17,  12,  23,  18, -24, -06,  13, -19,  01, -15, -16, -07, -06, -01, -23,  22,  01, -16,  07,  23,  12, -24, -12,  22,  03, -16,  00,  08,  02,  09, -18,  12, -04, -20,  05,  00, -01, -07,  06, -23,  03,  17, -02,  24, -07,  02,  24,  19,  11,  08,  19,  00,  09, -17, -01, -11, -06, -25, -25,  23,  09, -18,  10, -18, -11, -10,  07,  16,  08, -10,  18, -11, -15, -07, -10,  03,  21, -11,  00,  09,  22, -04, -13,  09,  06,  11, -25, -23,  13, -23, -25, -03, -16,  10,  07,  01, -23, -09, -08,  11,  09, -15, -23,  19,  06, -06, -01,  04,  11,  24, -10,  10, -04,  02, -06, -21, -09, -03, -18, -21,  01, -18,  04,  11,  18, -14, -13,  20,  04,  04,  08, -12,  16,  12, -18, -01, -18,  07, -20,  18,  08, -02,  03, -21, -23, -25, -16, -07, -01, -07, -02, -25,  00, -23,  13, -05, -10, -23, -07,  19,  08, -24, -17,  02,  16, -08, -22, -25,  24, -16,  20,  08,  09,  00,  14,  11,  00, -25, -20, -24, -07,  05, -21,  21,  07,  17, -09,  24,  22,  09,  18,  05,  13, -22, -18,  06, -04, -12,  06, -03, -01,  01, -18, -17, -24,  24,  19,  04, -24,  24,  07, -03,  06,  11, -07, -10,  04,  11, -11,  01, -04, -15, -17, -14, -12, -07,  17,  11,  06,  00, -14, -20, -24, -05, -12, -21, -06, -16,  08, -02, -14, -09,  20,  17, -23, -10, -17,  08, -24, -03, -14, -01,  09, -03,  12, -25,  15,  06,  11, -02, -19,  24,  03, -18, -05,  18, -13,  16, -23,  22, -11, -12, -10, -14, -17, -05,  03, -09, -20,  07,  15, -08, -17,  00,  16,  21,  00,  06,  02, -12, -21,  11, -10,  09,  20,  10,  04, -16,  03,  06, -18,  18,  22, -01, -19, -20,  19,  10, -02, -25, -08, -10, -06,  00,  15, -15, -02, -08,  18, -22,  08,  24,  14,  23,  10,  09,  10, -11,  21, -12,  22, -22, -17,  21,  04, -08, -22, -01, -23,  01,  01, -06,  17,  22,  21,  09, -16, -05, -21, -23,  00,  12, -22, -11,  12,  13, -25, -03, -21,  21,  12, -24, -24,  23, -25,  06, -10, -22, -18, -06,  05,  08,  15, -01,  05,  11, -15,  16, -17, -11,  18,  08, -24,  23,  24,  15,  13, -23, -11,  17,  23, -23,  20, -23, -23,  20,  10, -06,  24,  17,  13,  06,  00,  03, -18, -18, -11, -08,  23,  00,  07,  18, -15,  10,  18, -15,  01,  06, -11,  15,  00, -13,  19, -05, -09,  21, -07, -24, -10, -06,  18, -20, -25, -05,  08, -16,  04, -25,  01,  02,  00, -15, -03,  12,  21, -10,  22, -03,  21, -14, -11, -02,  01, -16,  21,  19, -18, -11,  21,  00,  08,  16,  05,  10, -13, -11,  21,  16, -09, -03, -04,  18,  10,  18,  05,  06, -14,  03, -20, -16,  16, -06,  08, -06,  05,  04, -11,  15,  20, -13, -10,  05, -20,  20, -08, -08, -14, -12, -14,  04,  12,  09, -03, -03,  04, -22, -22,  17,  08, -15, -23,  01,  07,  12,  21, -13, -09, -13, -21, -12,  01, -06,  18,  06, -08, -15, -24,  05,  00, -11, -15, -13,  23,  07,  10,  04,  12,  15, -03, -05, -24, -01,  22,  10, -12,  20,  24,  04, -16, -21,  19,  10, -02,  12, -07,  15,  24, -06, -02,  01,  08,  08,  13,  08, -08,  00, -10, -20, -09,  12,  00, -06, -12, -01, -21,  01, -04, -22, -18,  05, -18, -24, -08,  08,  15,  11,  00,  16, -18,  23, -08,  18,  08, -18,  03, -24,  08,  18, -19,  24,  07,  08, -05,  22, -17, -01,  00,  06,  04,  09, -11,  14,  12,  06, -01,  04, -06,  24, -05,  04, -25,  14, -03,  08,  22, -23,  09,  07,  21,  17,  08,  05,  01, -22,  05,  11,  04, -18, -08, -15,  17,  06, -24,  06, -10,  00, -14,  11,  02,  08, -10,  02,  00,  14, -15, -01,  17,  22, -19,  15,  14,  14, -03, -10,  19, -21, -22,  00, -13, -04,  10, -19, -21,  12,  12, -04, -11, -25, -15,  16,  09,  00, -07, -14, -08,  06,  10, -14,  05,  18, -24, -06,  09,  00,  12,  03,  05,  15, -20,  17, -12,  15,  23, -05,  04,  12,  18,  19,  13, -22,  10, -01,  06, -19,  10,  23,  14, -03, -16, -06, -10, -13,  15,  24,  12,  02,  04, -08, -05,  09, -14,  10,  01, -14, -18, -17,  24, -24, -23,  14, -19,  14, -10,  12,  22, -23,  10,  11, -01,  19, -18,  14, -17,  23,  15,  21,  00, -06, -10,  22, -20,  02,  10,  06,  15,  17,  14,  16,  20,  18,  05, -23,  10,  20,  14,  07,  22,  00, -04, -02, -04,  03, -11,  05,  01, -21,  03, -21,  00,  18, -24,  07, -03,  11, -11, -12,  06, -20, -19,  01, -24,  12,  03,  11,  09, -07, -05,  09,  18,  16, -16, -09, -05, -01,  23,  23,  03,  01, -23, -19, -03, -19,  13,  21,  19, -21, -14,  00, -13, -07, -23, -12, -18,  05, -24,  16,  23, -04,  02,  18, -12,  12, -13,  10, -14, -15,  10,  16,  14,  13,  24, -12,  21,  13, -16,  15,  19, -02, -09, -19,  16, -05, -04,  23, -25, -03,  16, -24,  19, -04,  21, -16, -17, -17,  21, -04, -04,  06, -11, -13, -04, -11,  00, -08, -21,  11, -15, -25, -16,  03, -16, -23,  23,  05, -23, -25, -22,  19, -24,  22, -08, -25, -17,  02, -17, -21, -25,  06,  10, -11,  20, -16,  05, -03,  01,  11, -16,  11,  12, -05, -11,  21, -02, -11,  03,  02, -10,  06, -04, -09,  05,  15, -09,  13, -08,  02,  17, -08, -15,  05,  09, -19,  14, -11,  03, -08, -22,  14, -19,  17, -15, -03,  15,  10,  12, -07, -13, -23, -25,  11, -05,  07,  01,  14, -04,  21, -07],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([-10, -10,  03,  20,  24,  11,  11, -09, -08, -21, -06, -19, -13, -12, -07,  09, -22, -20, -02, -02, -05,  00,  00, -19,  23, -17,  09,  14,  04,  07, -18,  21,  23,  12,  19,  22, -01,  05, -10,  16,  11,  09,  24,  23,  24, -07,  10, -23,  00, -17,  03,  20,  11, -22, -22,  09, -14,  13, -02,  17, -03,  07,  14, -05, -06,  08, -05,  18, -10,  10,  11, -21, -03,  13, -21, -04, -19,  14,  01,  08,  23, -21,  04,  11, -18,  07, -05, -06, -03,  20, -12,  20,  02, -21, -08,  23,  14,  12,  19, -20,  00,  05, -16,  22, -07, -10, -07,  01, -20,  19, -15, -20,  23,  16,  16, -17, -02, -12,  02,  21, -15,  17,  18,  12,  22, -15,  12,  11, -25,  06,  18,  00, -13, -21, -03,  07, -05,  17, -14,  00,  12, -02,  07,  12, -11,  00,  20,  12,  13, -01,  10,  23, -06,  05,  12, -09,  18, -01, -21,  18, -19,  23, -05, -05, -23,  17, -21, -03,  11, -10,  24,  00,  15,  08, -12, -21, -17, -15,  19,  23,  12,  04,  21, -19, -13,  10, -03, -20, -13,  01,  23, -05,  01, -07,  15,  04, -13,  21, -22,  23, -11, -22,  01, -21,  11,  14, -16,  22, -24, -20,  20,  13,  11,  19,  19,  23,  04, -07, -22,  18,  22, -22, -12, -02, -02, -20, -23,  10, -23, -17,  11, -07, -14, -13, -03,  24, -22,  08,  21, -21,  13,  17,  20,  00,  11,  16,  00, -08, -15,  04, -14, -16,  07, -01,  07, -17,  05,  12,  20,  09,  20,  06, -23, -17,  20, -01, -18, -25, -15, -19, -18, -25,  23, -23,  00,  11,  20, -24, -22, -20,  07, -11, -11, -09,  16,  24, -01, -02,  13, -05, -18,  10, -22, -16,  18, -24,  10, -23, -24,  20, -17, -15,  21, -17, -13, -02,  21, -17,  01, -25, -10, -15, -09,  07,  04, -16,  08, -22,  07, -04,  00,  14, -19,  04, -25, -24,  07,  13, -20,  08,  10, -11,  19,  08, -01, -17, -18, -04, -07,  10, -02,  11,  23,  16, -05,  02, -24, -22,  05,  08,  01, -17,  00,  09,  14,  02,  10, -04, -10,  15, -19, -24, -19, -23,  09,  06, -12,  18, -21,  06,  06,  02, -06,  04, -07,  14, -19, -04,  19,  13, -18, -05,  23,  07, -21,  12, -16,  16, -17,  02,  09, -10,  03,  15, -08, -11, -02,  05, -17,  04, -11,  14, -17,  10, -05,  02,  00,  03, -25, -04, -07, -18,  17, -08,  14,  23, -21, -24,  15, -12,  03,  01,  03, -17, -09,  22, -03,  17,  05,  07, -04,  19, -02,  05,  04,  18, -16, -19, -02, -14,  03,  17, -06, -03, -16, -15, -05, -12, -14, -13,  01,  16,  13, -19, -24, -18, -19,  01, -24,  11, -17, -01,  05,  09, -19, -14,  04, -08, -07, -22,  04,  23,  20,  23, -05, -21, -17,  17, -06, -03, -18,  23, -10,  20, -21, -06, -21, -13,  20, -18,  23, -22,  07,  05,  14,  13,  19, -06, -19, -11, -03,  10, -13, -08,  10,  09, -02,  20,  01,  17, -06,  08,  15,  10,  06,  22, -21,  12, -16, -24,  20, -15, -19,  02,  15,  21, -08,  09, -10, -02,  23,  12, -15, -13, -19,  22,  21,  06,  18,  00, -02, -13, -15, -09,  24,  16, -12, -20,  04, -01, -19,  01,  09, -12, -22,  02, -14, -05, -12,  01,  21, -13, -10, -17,  01, -02, -19, -02, -21,  24, -25,  02, -12, -15,  20, -12, -21, -15, -05,  08,  10,  02, -16, -04,  17, -11,  23, -20,  11, -13,  06,  07,  01,  23,  18, -23, -04,  24,  02,  00, -25,  02, -21, -12,  15, -25,  03,  19, -13,  24,  04,  22,  03,  15, -06, -03, -21, -06,  02,  17,  06, -15,  02, -16, -17, -05, -13,  06, -06,  16, -17, -06, -04, -13,  07, -14, -11, -12, -20,  02, -13,  11,  01,  17,  01,  22, -11,  07, -08,  18, -01,  23, -22, -24, -15, -12, -04, -03,  21,  15, -12, -21, -14,  11, -07,  21,  22,  08, -16, -21, -13, -02,  15,  13, -10, -09,  11,  06,  23, -20,  01, -02, -20,  06,  01, -10,  21,  23,  12,  17,  15, -22,  21, -21,  14, -11, -25,  14,  24, -14,  18, -12,  09,  11, -23, -24, -23,  15,  09, -22,  20, -13,  03, -23,  18, -21, -07,  14, -21, -18,  06,  20, -15,  04,  24, -23,  20, -24,  18,  20, -13,  13, -17,  23, -01, -13, -24,  04, -21,  12,  07, -24,  24, -15, -21,  17, -09, -03,  08, -04,  04, -11, -09,  17,  20, -08,  21,  15, -05,  14,  12,  07,  02,  23,  07, -21, -15,  10,  08, -08, -03, -08, -07, -02,  02, -03, -08,  20,  21, -25, -09,  03, -11,  09, -05, -14, -22, -07, -24, -02, -16,  14, -18,  13,  14,  14,  17, -24,  01,  00, -07, -25,  17,  12, -02, -04, -14,  15, -08, -15,  15,  10,  13, -19, -05, -15, -08, -02,  03, -04,  22,  12, -13, -21,  00, -24,  21, -05, -23, -03,  22, -04, -02,  15, -15,  23, -12, -02,  16,  07,  08,  08, -07, -02,  15,  13,  08, -16, -14, -12,  05, -15, -25,  17, -08,  03,  20, -12,  23,  23,  12,  20, -04, -13,  12,  08, -14, -22, -19, -21,  10,  17,  12, -20, -10,  02,  18, -24,  14, -18, -11, -06, -06, -08, -11,  11,  20, -16,  24,  20, -16,  14,  17,  05, -24,  07, -10, -11,  12, -03, -07, -03, -09, -19,  05,  08,  10, -02,  09, -01,  07,  24,  19, -23, -09, -15,  15, -12, -04,  15, -15,  06,  06, -21, -12,  07,  11,  04,  22, -02, -22, -10,  23, -06, -02,  03, -23, -16, -22,  12,  08,  13,  13,  04,  17, -19,  14,  07, -04, -12, -01,  06,  19, -20,  12, -16,  13,  01,  13,  12, -24,  16, -21, -24, -15,  03,  04, -10,  14,  10, -23, -03,  00,  17, -21, -08,  23,  20,  24, -04, -17,  01, -23, -23,  06,  16, -13, -04, -08, -23, -15, -06,  19, -10, -05, -19,  20, -23, -02,  09,  14,  02, -17, -11, -06, -11,  06, -06, -15,  07,  15, -07, -15,  19, -02,  19,  11,  12, -10, -22,  14,  03, -01,  10,  20],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
  check([ 20,  19,  15,  24, -08,  01,  13,  22,  11, -23, -09, -24,  10,  11, -14, -06,  01,  06,  05, -02, -21, -01, -16,  18,  16, -11,  10, -06,  14, -03, -11,  11, -07, -19,  10,  13,  09,  00,  10, -04,  04, -24, -01, -11,  14,  12,  08, -07, -07, -10,  16,  00,  14, -25, -07,  06, -09, -20, -23, -20,  03, -06,  18,  21,  00,  05,  09, -13, -20, -06,  08,  11, -02, -16, -25, -13,  21,  11,  05, -11, -24, -02,  14,  18,  00, -15,  01,  17, -10,  03,  24,  20,  22,  18,  17,  00,  00,  03,  12,  08, -25, -03, -06, -02,  06, -03,  12,  02, -15, -05,  18, -12,  18,  10, -19, -06,  20,  07, -12, -13, -12, -13, -15, -15, -18, -21,  10,  08,  07, -03, -07,  09,  19,  12, -18,  02, -14,  22, -21, -04, -08,  23,  10, -15,  10,  18,  06,  05,  03,  19,  19,  16, -18, -19, -22, -09, -15,  14,  24,  18, -12, -08,  02, -15, -18,  12,  12, -07,  09,  17,  17, -22,  17,  02, -10,  02, -03,  22, -16, -25,  18, -20,  18, -23, -13,  22, -06, -03,  11, -05, -08, -24,  15,  22, -14,  22,  11,  24, -08, -05,  18, -16, -02,  12,  13,  15, -09, -14,  12,  02, -12,  06,  07, -18,  08,  21, -21, -21, -04,  17,  00,  13,  20, -10,  12, -18, -13, -02, -17,  06,  20, -22,  16, -05,  15,  06, -14, -19,  19,  23,  08, -17,  06, -08, -08, -08, -11, -02, -04,  12, -08,  21,  02, -13, -14, -10, -04,  00,  13,  04, -18,  11,  07, -25, -19, -03,  08, -08,  05,  03, -07, -10,  13, -24,  08, -20, -07,  24,  05,  17,  13,  22,  13, -10, -16, -23,  05,  06,  02, -04, -13,  11, -18,  20,  13, -10, -06, -01,  10, -25, -23, -22, -08,  15, -21, -23,  22,  00, -22,  02, -08,  16, -01, -18, -18,  10, -16,  14, -07,  14, -13,  06,  02, -04,  01, -07,  12,  22,  17, -03,  24,  19,  02, -08,  11,  08, -04,  08, -15,  00, -13,  02, -07,  11,  12,  02, -02,  21, -08,  17,  12,  06, -02, -10, -22, -24,  08,  17,  23,  02, -09, -25, -02,  18, -08, -16,  03,  15,  19,  14, -10, -19, -07,  09,  19, -20, -14, -08, -21,  05, -14,  16, -13,  11, -19, -08,  12,  16, -16,  13, -05,  00,  13,  18, -05, -18, -21,  23,  22, -25,  14, -10, -19, -15,  24, -23, -10, -13, -03, -06,  20,  08, -14, -18, -05, -06, -01, -16, -12,  08,  24,  08, -15,  12,  04,  05,  21,  08,  05,  21,  09, -03, -14,  17,  07, -13,  22,  22,  01, -06, -06, -04, -23,  07,  03, -01, -22, -21,  11, -09,  14,  10, -23,  24,  00,  08,  06, -04, -07, -11, -06, -21,  11,  05,  24, -07,  19,  21, -08, -04, -10,  13,  17, -06, -05, -02,  21,  01,  04,  07,  19, -06, -08,  21, -07,  17,  06, -23, -09, -25, -09,  10, -19, -21, -07, -20, -03, -13, -24,  16,  10, -09,  05,  05,  13, -23, -20,  09,  03,  09, -09, -02, -22,  10, -04, -01,  03, -20,  01,  19, -18,  19,  04, -12,  23,  24, -06, -03, -13, -05, -12,  24,  12,  20,  04,  02, -25,  09, -14,  05, -04,  04, -20, -01, -11,  04, -25,  19,  09,  03,  13,  16, -03, -05, -21, -03, -06, -02,  19,  08,  19, -15,  08,  08, -18, -11, -13, -18,  24, -02,  15, -03, -21,  20,  21, -07, -01,  24, -12, -15,  02, -22, -24, -25,  00, -17, -01,  20,  08, -06,  05,  02,  06, -12, -13,  13,  05, -01,  23,  06,  24,  13, -22, -22,  10,  24, -01, -13,  23,  14, -03,  03,  19,  01,  03, -05,  11, -21, -08, -06, -02,  22,  24, -21, -12, -14,  20,  18,  13,  18, -01,  14,  08,  02,  20, -05,  03, -04,  07,  04, -15, -18, -18, -19,  10,  12,  01, -04,  16,  20,  17, -10,  20,  16, -04, -17, -20, -09, -24,  18, -14,  02,  09,  19, -19,  04, -10,  09, -25,  24, -12, -13, -17, -03, -06,  18, -16,  22, -09, -24,  18, -16, -07,  13, -25,  14,  23, -20, -17, -24, -25, -04,  03,  10, -07,  09, -09,  10, -05, -08,  09,  11,  04,  18, -17,  23,  13, -07,  23, -20, -06,  18, -11,  14,  08, -09,  05,  06, -01,  15,  07, -01, -13, -13, -14,  05,  23,  03, -10, -05,  20, -24, -19,  01,  19, -10,  02,  08,  08,  00,  15, -21, -07, -21,  18, -22, -03, -02,  09,  21, -11, -07, -02,  03,  07,  09, -17,  07, -11,  00, -23, -14,  01, -16,  15, -02, -01, -08, -17, -18,  19,  23, -12, -13, -21, -17, -10,  01,  08, -24,  00,  24, -04,  23,  02, -22,  09,  10,  10, -24, -13,  12, -13,  14,  21, -23, -13, -03, -04, -03,  06, -10, -05,  19,  04,  01, -23,  21, -21,  11,  22,  04,  10, -07,  02, -10, -02, -13, -23, -17, -12, -10,  23,  02, -21,  21,  07, -07, -06, -22,  17, -25, -06, -13,  22,  23,  15, -24,  20,  19,  14,  19, -01,  02, -12, -24,  17,  13, -10,  19,  24,  05, -14,  22, -15, -08,  20,  17,  10, -11,  20,  04, -08, -09,  16, -09, -10,  08, -06, -15,  03, -16, -21, -21,  11, -06, -20,  05, -17, -02,  01, -16, -20,  13, -19, -10, -20, -22, -16,  18, -05, -20, -03,  14, -04, -09, -20,  13,  24, -01, -25,  04,  10, -18,  08, -04,  01,  16, -22,  11, -11,  05,  20, -04, -07, -22,  14, -02, -18,  23, -09,  02, -20,  16, -09,  02, -18, -02, -08, -17,  22, -07,  13,  08,  00, -04, -19, -22, -13, -15,  17,  03,  17,  12, -25, -15,  18,  14,  10, -23,  12, -21,  04,  20,  20,  22, -03, -21, -05,  16, -13, -06, -16, -25, -21,  11, -03, -14,  15,  11, -02,  09, -10, -10, -02, -10,  02, -09, -19, -11, -07,  20, -07,  24,  15, -10,  21, -11, -06, -07, -19,  07,  13, -08,  09,  19, -19, -19, -18,  23,  18,  05,  07, -15,  22, -20,  02,  01, -01,  10,  16,  19,  05, -14,  19, -02,  02,  17,  14,  21, -12,  22,  05, -24, -10],
          [-25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24]);
}
