/*
 * Copyright (c) 2011, the Dart project authors.  Please see the AUTHORS file
 * for details. All rights reserved. Use of this source code is governed by a
 * BSD-style license that can be found in the LICENSE file.
 */
/**
 * @assertion abstract void sort([int compare(E a, E b)])
 * Sorts the list according to the order specified by the compare function.
 * The compare function must act as a Comparator.
 * The default List implementations use Comparable.compare if compare is omitted.
 * @description Checks sorting long integer arrays (lenghts: 32767, 32768, 32769).
 * @author iefremov
 * @reviewer msyabro
 */
library sort_A01_t06;

import "../../../Utils/expect.dart";

test(List create([int length])) {

  int c(var a, var b) {
    return a < b ? -1 : (a == b ? 0 : 1);
  }

  void check(var actual0, var expected) {
    List actual=create();
    actual.addAll(actual0);
    actual.sort(c);
    Expect.listEquals(expected, actual);
  }

//length == 32767
  check([ 112,  241, -432, -380,  52,  176, -176, -411,  64,  20,  307,  28, -404, -253, -312,  81, -282, -147, -214,  330, -97, -119,  119,  131, -292, -96,  337, -217, -289, -05, -80,  324, -263, -12, -204, -359,  17,  472,  82, -419, -07,  241,  462,  441, -160,  02,  22,  58,  356,  308, -111,  111,  41, -492, -258,  249,  264, -69, -467,  476, -221,  305, -348,  368,  145,  300, -491, -338, -376,  443,  96,  469,  184,  58,  411, -123, -440, -67,  435, -232,  94,  176,  380, -13, -463, -26,  89,  301,  406,  474, -371,  37,  279,  133, -95,  276, -67,  266,  439,  410,  209,  387,  379,  245, -55,  290, -378,  357,  76, -442, -22,  22, -414, -142, -491, -377,  332,  98, -223, -410,  72, -94,  127,  203, -108, -116, -20,  325, -350, -81,  235,  359,  158,  467,  105, -397,  257, -421, -188,  185, -11,  290, -293,  76,  00,  69,  199, -167, -333, -172,  275, -408,  235,  255,  295, -21, -361,  127, -196, -210, -454, -108,  01, -444,  211, -42, -341, -32,  38,  324, -346, -473,  114,  213,  103, -385, -218,  155,  300,  302,  483,  427, -254, -430, -466, -459,  49, -326,  169, -294,  316, -433,  450, -183, -376,  161,  276,  135, -19,  166,  311,  487,  193, -74,  201,  149,  393, -165, -196, -455, -11,  139,  472,  235,  210, -493, -371,  111,  33, -350, -331,  201,  69, -381, -130,  193, -368, -354,  181,  114, -336, -08,  101,  358, -230,  154,  359,  15,  490,  15,  60,  331, -346,  385,  67, -284, -256,  196, -320,  277, -302, -151,  330,  267, -31, -300,  313,  101,  199, -06,  67,  363, -162, -331, -427,  461,  323,  432, -24, -335, -53, -463, -151,  454, -226,  416, -330,  18,  464, -150,  147, -338,  200, -23,  429,  21,  177, -406, -26, -124,  88, -458,  92, -221, -289,  165, -260, -114,  98,  216,  404, -103, -395, -247, -149, -121,  21,  374,  397,  337, -276,  44,  499, -224, -127, -220,  297, -449, -125,  124,  279, -185,  166, -129,  446, -271, -111, -314,  467,  487, -245,  371,  236,  212, -24, -412, -408,  497,  462, -159,  334,  38, -262, -315, -333,  111,  318, -184, -486,  45,  440, -354, -288,  106,  369, -341,  335, -242,  197, -345, -255,  452, -474, -166,  165,  355, -78, -391,  352,  236,  302, -461,  126, -460,  76,  293, -496,  246, -390, -130, -209, -98,  16,  356, -491, -114, -485, -304,  496, -436, -149,  94, -483,  230,  428, -466,  85, -150, -05,  289, -62, -203,  328, -436, -162,  257,  358,  194,  03, -180, -436, -353,  222,  433, -145, -417,  171, -130,  132,  167, -66,  483, -239,  303, -435, -311, -311,  150,  391,  184,  292, -171,  482,  472,  246,  172,  229,  456, -134,  85,  128,  282,  232, -150, -433, -413,  286,  238,  309, -82,  258,  95,  253, -129,  251,  319,  413,  440,  321,  304,  125,  113, -14,  459,  86,  84,  131,  167,  40, -151, -248, -332, -369, -164,  370,  51,  275,  156, -211,  436, -74, -101,  384, -320,  271,  135, -149, -464,  427, -328, -308,  404, -362, -470,  363, -424,  114, -06,  243,  06, -305, -152, -474, -173,  184, -251, -270,  312, -243,  371,  248,  184, -229,  132,  364, -106,  119,  67, -70,  47, -409,  122, -49, -271,  153,  167,  157,  119,  13,  253, -22,  209, -399,  04, -112, -363,  253,  118,  449, -489, -11, -450,  195,  260,  182,  411,  06,  154, -22, -212,  53,  421,  411, -144, -349,  416, -477, -340,  387,  37,  413, -135, -254, -486,  370,  134,  04,  475,  104, -47, -162, -407,  03, -115, -294,  38, -204,  212, -308, -374, -499,  245, -452, -236, -399,  51,  32, -23,  211, -81, -486,  477,  285,  112,  491, -493,  98,  347, -166, -298, -199,  173, -205, -344, -442,  01,  194,  207,  66, -262, -315,  67, -165,  85, -317,  289, -12,  215, -234,  52, -366,  132,  29, -229, -256,  372,  130,  342,  220, -183, -456, -479,  490,  191, -323, -100, -307, -276, -393,  259,  314,  145,  178, -350, -270,  361,  439,  219,  428,  57, -229, -86, -311, -348, -462,  285, -476,  168,  127,  244, -163, -477, -383, -173,  214,  147, -420, -241, -277, -313, -130, -463, -316, -452, -313,  267, -239, -22,  338, -311, -113, -39,  104,  428,  113,  142,  213,  137,  162,  192,  234, -500,  215,  351,  179, -70,  350,  259,  189, -427, -201, -440, -389, -17, -40,  150, -250, -426, -19, -412, -237,  368,  49, -281, -351,  14, -287,  362, -348,  376,  55, -262, -272,  122, -59,  407, -448, -208,  167, -406,  217,  466,  06, -320,  301, -182,  331, -96, -108,  164, -08, -492,  384, -106, -273, -467,  408, -59,  396, -88,  169,  303,  150,  397, -75, -56,  304,  330,  236,  323, -224,  305, -359, -366,  486,  443, -48, -331, -153, -303,  333, -309, -295,  217,  85, -68,  251,  346, -275,  499,  110,  394, -346, -239,  291,  79, -443,  448,  261, -355,  271, -463,  450,  413,  23,  436, -292,  476, -43,  55,  25, -210,  246,  230, -140,  184,  14, -37,  382, -408, -38, -08,  486,  116, -395, -370,  47, -338, -70,  161, -193,  53, -450, -242,  318,  74,  46, -474,  402, -496,  433, -73,  146, -468,  09, -494,  216, -477, -31,  450, -385, -217, -58, -46, -249,  48,  436, -349, -438, -134,  312, -130,  419,  362,  480,  238,  288,  378,  264,  190, -266,  198, -31,  381, -418,  478,  387, -350, -146,  209, -400,  321,  492,  394,  127,  96, -58,  63,  247,  357,  429,  59,  79,  349,  273,  411,  439,  62,  289, -445,  104, -124, -395, -426, -243, -313, -96, -04, -163,  258,  57, -63,  432,  50, -168,  59, -02, -374, -377, -255, -165, -448, -344,  414, -247,  429,  325,  44,  343,  467,  100, -52, -157,  205,  22,  452,  393, -222, -52, -270, -463, -494, -480, -179,  408,  204,  380, -94, -318, -497, -497,  18, -92, -341, -68, -487, -412,  110,  58,  432,  77, -342,  232, -228,  363,  106, -276, -392,  384, -476,  191, -227, -118, -437,  94,  142,  267, -25, -100,  449,  330, -97,  319, -262,  414, -248, -248, -497, -286, -338, -213,  291, -180, -481, -85,  35,  125,  491,  496,  361, -485,  187, -365,  250, -398,  229,  244,  369, -296, -355, -330, -113,  400,  490,  125,  315,  94, -271,  318,  308, -109, -43,  451, -437,  328,  218,  99,  305,  209,  447,  166, -424,  134,  301,  326,  236,  383,  71,  457, -61, -432, -21,  326,  468,  321, -48,  283,  267, -467,  453,  427, -75,  262,  378, -12,  90,  448, -61, -105,  157, -114, -86,  234, -128,  67,  412, -40, -50,  335, -83,  390,  403, -251,  216,  372, -78,  20, -493, -310,  54,  461, -383, -169,  223, -152,  319,  166, -204, -241, -87, -194,  497,  327, -108, -130, -105, -196,  330, -303, -360,  100, -413, -457,  349, -344, -233, -229, -472, -225,  313,  434,  88,  431, -235,  163,  131, -415, -171,  427,  196, -405,  85,  193,  422,  477, -437,  169, -218, -254,  367,  274,  346, -194,  317, -453,  314, -63,  170,  343, -436, -16, -371,  152,  267, -105,  167, -102,  332, -151,  177,  28, -56, -237, -279,  218, -260,  137,  240,  22,  383,  107, -204, -419, -235, -34, -372, -68, -245,  298,  127, -181, -218,  256, -177, -99, -349,  490,  299,  483, -161, -23,  363, -365,  240, -63,  354,  480, -426,  94,  355, -191,  53, -349, -110, -330,  469,  18,  102, -276,  168, -271,  43, -197,  486, -282,  204, -11, -291,  04, -27,  400, -167,  188, -464, -427, -375, -258, -95,  51,  336, -240,  360,  241,  264,  102,  411,  233, -380,  366, -190, -359, -405, -295, -56, -67, -76,  00,  423,  485, -496,  248,  385,  189, -64, -227,  262,  414,  15,  20, -35,  203,  280, -174, -56,  44,  428,  208,  130, -99,  74,  440,  42, -479, -03, -162,  307,  421,  338, -418,  406, -305,  330, -356,  384,  118, -83,  499,  32,  433,  19,  498,  488,  151,  176,  285,  48,  104,  345, -322, -143,  271, -30, -249,  292, -181,  89,  99, -259,  280,  181, -01,  475,  363,  143, -289,  334, -439, -290, -134, -154, -419,  216, -166,  233, -108, -29,  133, -151, -184, -337,  206, -413,  485,  458,  380, -196,  399,  331,  45,  179,  365, -103, -494, -420, -460,  70,  414, -47, -368,  133, -349, -286,  201, -14, -201, -406, -191,  432,  295,  126, -53,  353,  213, -68, -337,  445,  236, -437, -371,  134, -406, -154, -469, -47, -74, -77, -477,  193,  377,  07,  178, -120,  221, -121,  366, -128,  325,  28,  156,  472, -346, -397,  326,  367,  35,  489, -335,  124, -96, -206, -242,  351,  140,  141, -196, -82, -84,  179, -37,  145, -314, -359, -474, -240,  373, -256,  484,  198,  272,  493,  171,  426, -404, -03, -354,  484,  338, -189,  460, -257,  457, -282, -406,  449, -289,  250,  219,  127,  281, -317, -227, -181,  176, -201,  431,  49,  395,  416, -252,  168,  409, -229,  94, -143, -380, -408,  193,  458,  255,  153,  53, -436, -277,  499, -487, -66,  249,  233, -86,  382, -232, -461, -298,  444,  190, -367, -06,  85, -99, -406, -247,  162, -135, -300, -480, -15, -208, -435,  295, -100,  219, -151, -36,  442,  200, -22,  229,  302,  63, -05,  184,  331,  34, -262, -373, -276,  224,  121, -339, -375,  215, -85,  288, -68,  467, -340, -231,  111, -275, -435, -489, -204,  266, -24,  91, -34, -194, -180, -232, -279,  315, -195, -96,  201,  43,  31,  425, -233,  05, -414,  245,  72,  353,  385, -495,  320, -455, -226,  284,  122,  191,  295, -229,  309,  123,  362,  128, -219, -318, -252,  354, -151,  53, -242, -450, -51, -358, -173,  216,  499,  265, -39,  71,  471, -154,  428, -357,  243, -297,  427,  218, -254, -425,  489, -444,  198,  351,  184, -168, -115, -216, -314, -414,  338,  297, -12, -213, -209,  315, -145, -210,  432, -331, -287,  403,  367, -358, -453,  463,  197, -174,  181,  443, -99, -478, -149, -48, -275, -113,  284,  110,  172, -178, -452,  362, -29,  36, -351,  262,  203,  356, -96,  135, -123,  118,  391, -255, -388,  438, -292,  309, -236, -259, -396,  166, -237, -44, -30,  340, -305, -246, -50,  367,  428,  350,  229, -100, -114, -270,  14, -411, -61,  419,  224,  316,  389,  115, -439, -499,  405,  121,  310,  22, -286,  414,  40,  329,  222, -490,  169,  418,  116, -29, -363,  44, -179, -281,  444,  207,  301, -41, -352, -260,  230,  373, -443,  119,  340, -30,  472, -402, -56, -366,  472,  158, -452,  12, -12, -377,  374,  09, -107, -10,  481,  30, -114, -198,  249, -169, -138,  403, -358,  10, -357, -276,  235,  52, -305,  428, -477, -333, -122,  319, -199, -150, -23,  201, -286, -183, -324, -60,  327,  69,  430, -340, -400,  168,  314, -299,  499, -324, -396, -07, -461,  100, -431,  274, -348, -236, -446,  27,  283, -68, -154, -64, -366, -324, -10, -152,  345,  166,  288, -476, -264, -430, -316,  188,  239, -149,  389, -410,  379, -154,  436,  418, -202, -495, -455, -50,  122, -401, -170, -95,  384, -472,  342, -482, -296, -168,  219, -98, -150,  359, -74,  86, -218,  463, -226, -127, -186,  16,  315, -307, -286,  251, -388,  12, -391,  09, -186, -417,  460,  144, -12, -304, -475,  182, -285,  81, -134, -214,  483,  217, -355, -90,  155,  279, -127, -218, -348, -461,  298,  468, -268, -488, -429,  196,  376,  32, -295, -310,  115,  18, -313, -44,  214, -288, -10, -219,  293, -291,  67, -371, -222, -435,  391,  433,  344, -236, -285, -151,  155, -135,  169,  387,  229, -408,  84,  105,  125, -359,  296,  92, -489, -165, -100,  226,  47, -257, -493,  192, -48,  427,  321,  230,  492, -436,  163, -312, -172, -269,  389, -165,  96,  58, -277, -174,  151, -341, -217,  128,  152, -421,  72,  164, -86, -175, -110, -187,  68,  249, -142, -480,  176,  31,  250, -480,  96,  265, -291, -224,  496, -402,  112,  445, -491,  335,  123,  160, -154,  406,  140,  498, -162, -288, -486, -396,  37, -96, -82, -43, -346, -372, -23, -318,  159,  79, -297,  107, -155,  264,  384,  193, -286,  348,  138, -277, -465, -239, -265, -119, -332,  375,  231,  06, -60,  246,  110, -171, -350, -120, -361,  156,  08,  116, -309,  20, -304, -106, -373,  393,  10, -137,  86,  224, -289, -275,  448, -254,  338,  35,  127, -142,  263, -141, -284,  55, -43, -321, -264,  107,  59, -125,  116, -80,  492, -341, -208,  40,  53, -81, -67, -85, -365, -481, -361, -154,  96, -61,  93,  287,  475,  72, -355,  238, -217,  214, -207,  240,  393,  381,  200,  304, -243,  168,  76, -251,  327,  368, -359,  232,  140,  74, -353,  275,  445,  138, -27,  42, -422, -434,  181, -95,  491,  326, -357,  126,  392,  288, -133,  285, -479, -81,  90, -222, -413,  18,  379, -234, -113, -480, -150, -121,  94, -03, -346,  392, -13,  127, -66,  65, -454, -385, -178, -111, -207,  317, -485, -314,  457,  234, -177,  479, -347, -235, -243,  92,  284, -363, -290,  23,  09,  60,  402, -396, -91, -444, -152,  397, -465,  282,  314, -67, -251, -363,  322,  394, -194, -310, -68, -236,  424,  256, -257, -70, -127,  00, -478, -343,  489, -267,  180, -01, -355,  82,  455,  55,  490, -197,  304, -122, -63,  470, -337, -462, -41,  486,  432,  266,  28,  217, -470, -48, -27, -227,  382, -302, -375, -243, -144, -33,  342, -112, -182,  487, -177,  125,  394, -187,  428,  198, -457,  217,  169, -293,  255, -372,  45, -461,  394, -427,  256, -224,  25,  81,  401,  260,  280, -121, -483, -12,  346, -289,  376,  16, -302, -301, -359, -407,  365, -431, -357, -240, -362, -336, -33, -255,  145, -136, -216,  391, -63, -107, -332, -185, -174, -431, -425, -42,  300, -56,  446,  146,  155, -325, -338, -295,  226,  155,  150,  443, -424,  294, -296, -286, -190, -477, -41,  455, -112, -404,  347, -323,  341, -485, -08, -333, -64,  419,  126, -263,  215,  424, -265,  222, -401,  250,  428,  326, -95,  78, -379, -18,  224, -175,  196, -113,  201,  08, -158, -411,  104, -311,  118, -55,  56, -389,  464, -155, -118,  442,  82, -402,  367, -331,  320,  466,  419, -400, -356, -175, -469,  118, -341, -393,  443, -293, -06,  496, -433,  337, -63, -477, -122, -444,  320,  435,  19,  285, -220,  401,  227, -286,  499,  94, -117, -328,  413,  155, -228, -91, -168,  155, -473, -09,  263, -177,  198, -243, -181, -382, -54, -391, -359,  325, -335,  462, -388,  184,  247,  244,  85, -26,  458,  437, -79,  193, -39,  186, -152, -415, -405,  180,  241, -25,  23,  04, -350,  74, -387,  321,  192,  60,  430,  333,  237, -405,  295,  349, -369,  42,  445,  217, -131, -245, -494, -358,  448, -33,  328,  149,  404, -225, -171,  145,  250,  353,  01, -248, -73,  467, -426, -381,  379, -496, -196,  116, -48, -400,  317,  83,  494,  262,  152, -137, -483,  158,  357, -183, -23,  185,  466, -118, -187,  148, -121, -85,  01,  381,  168, -220, -300,  242,  251, -421, -402, -445,  195,  50,  07,  12, -14,  02,  126, -362, -283,  495, -351, -425, -188,  126, -388, -221, -140, -75,  427,  240, -307,  280,  473,  361, -88,  25,  455, -337,  104, -447,  70, -201,  104, -422, -337, -410,  80, -359,  80, -351, -364,  229, -276,  300,  208,  189, -421, -432, -34, -142, -340,  159, -10, -15,  20,  402, -490, -25, -83,  466,  29, -160, -235, -15, -82,  280,  427, -150, -227,  07, -01, -91,  89, -424, -290, -203,  265,  141,  217, -269, -148, -270,  391,  342,  215,  263, -403, -422, -261,  366, -104, -380, -294,  162,  457,  476,  294,  384,  178, -432,  243,  30,  329, -168,  458, -109,  129, -425, -115, -153,  158,  237,  77,  401,  431,  144,  165, -120, -426, -244, -253, -29,  228,  305, -15,  185, -366,  131,  69, -336, -449, -188, -454, -267,  497, -496,  124,  126, -421, -491, -175, -410, -402, -246,  491, -470, -249, -492, -90,  177, -236, -491, -352,  492, -333,  485, -471,  153,  469,  450,  317, -480,  115,  364, -247,  112, -280, -270, -262,  152,  91,  416,  242,  190, -330, -415, -428, -79, -406,  334, -401,  210, -304,  99, -445, -137,  437, -416, -484,  406, -465, -315,  426,  150, -99,  32, -238,  474, -386,  352,  126,  205,  268,  220,  247, -209,  305,  319, -436, -249,  154,  15,  462,  350, -385, -483,  65, -96, -47,  433, -190, -12, -382,  88, -10,  372, -28,  252,  346,  86,  457, -28,  144,  225,  44, -109, -132, -151,  63, -67,  101, -283,  448,  63, -81, -85,  432,  484,  319, -115, -231, -19, -274, -113, -430,  216,  111,  42, -31, -43, -19, -74, -219, -375,  03,  325,  368, -276,  27, -69, -491, -20,  148,  457, -105, -81,  225, -173,  255,  396, -436, -476, -122, -210,  264, -52, -493, -125, -158,  328, -315,  323,  106,  318,  448, -391,  496,  317,  185,  23, -252,  194, -497, -251, -496,  250, -480,  229, -423,  276,  477, -07, -348, -145,  284,  416,  303,  291, -208, -354,  119,  329, -179, -275,  147, -230,  186,  143, -61,  224, -334, -461, -82,  21,  140, -78, -229,  161,  03,  200,  289, -19, -306,  441,  336, -170,  358,  492, -379,  02, -10, -408,  183,  311,  169, -170, -67,  207,  474, -276, -69, -08, -236,  350, -134, -244,  124,  489, -231, -20, -458, -442,  461, -264, -148, -351,  418,  62, -07, -461, -84, -165, -17, -401, -353, -348, -71,  432, -289,  255, -343,  143,  100,  273,  345, -182, -119,  321,  159,  151, -199,  201, -439,  114, -211,  265, -384, -293, -173,  109,  98,  243,  445, -419, -306, -56,  85,  124,  228,  297,  231, -263,  292,  183, -490,  137, -147,  244,  310, -487, -105, -388,  214,  308, -422, -496,  74, -306,  63,  401, -344, -338,  497, -47,  95, -309,  397, -319, -333,  477, -170, -249, -285, -378, -214,  77, -389,  140, -179,  421,  153, -432, -115, -133,  377,  316,  223,  303, -490, -213,  204,  18,  301, -447,  471, -104,  97, -280,  429,  264, -302, -241, -133,  265,  233,  154, -158,  344, -206,  164, -382,  447, -416,  355,  166,  461,  171,  242,  264, -466, -119,  321,  404, -318, -274,  376,  430,  323, -52,  360,  440,  498, -381, -193,  263,  353,  461, -42, -451,  107, -26, -333,  406,  58, -125,  425,  372, -454,  167,  136, -68, -100,  309, -163,  434, -464,  65,  364, -289, -135, -424, -349, -136, -304, -41, -21, -99,  272,  437, -50,  232, -89,  470,  138, -178,  197,  415, -306, -405,  434, -318,  28, -166,  492, -283,  120, -120,  282, -15,  91, -353,  61, -405,  363, -391,  406, -157,  362, -470,  132, -187,  262, -104,  135,  253,  218, -168,  168, -236, -73,  103, -54, -193, -211,  290,  24,  410, -330,  158,  247, -386,  306,  160,  61, -479, -378, -33,  216,  484, -03, -151,  149,  112,  245, -216,  217,  315,  468, -115, -421,  248, -160,  25, -445,  482,  168,  80, -256, -310, -262, -157,  156, -104, -497, -283, -82, -375,  184, -366, -38,  34,  335, -389, -02,  432,  248, -285, -401,  216,  452, -322, -36,  145, -444,  372,  479,  224, -48, -277, -234, -458,  66,  423,  291,  421, -360,  61, -101, -323, -453,  361, -437,  383, -176,  61, -333, -428, -372, -233, -359, -68,  297,  457, -423,  353,  329, -444,  429,  133,  131, -304, -472,  49, -381,  319, -29,  111,  232, -278,  288,  279, -65, -297, -486,  259,  264, -318, -316, -256, -51, -175,  177, -254,  134, -394, -48,  316, -337,  233,  301, -354,  429,  329,  196, -100, -500,  19, -136,  232,  241, -348,  364,  28, -144,  378, -213, -28, -440, -29, -431,  361, -352,  246, -40, -365,  352,  412,  451, -133,  145, -396,  14,  427,  434,  62,  179, -214, -67, -457, -129,  26,  48, -265, -446, -244, -35, -159, -420,  26, -335, -351,  239,  165,  395, -301,  300, -400, -37, -397, -33, -39, -292, -167, -112, -06, -253, -81, -368, -468,  315,  03,  58, -137, -410,  112,  471,  56, -194, -449, -66,  323,  53,  25,  340, -52,  225,  141,  400,  40, -404, -132, -499,  156, -447,  241,  02,  153, -339,  135,  185,  476, -10, -256,  191,  433, -292, -486, -11,  366, -435, -225, -459,  118,  300,  382, -81,  377,  375, -181, -82, -177, -461,  271,  480, -55,  13, -18, -402,  174, -31, -365, -498,  460, -121, -455,  393,  440, -441,  234, -342, -24, -139, -300, -405,  13, -66,  366,  243, -191,  37, -339,  132,  429, -216,  464,  226,  297, -53, -324, -29, -232, -189,  325, -272, -457,  370, -27,  483,  429,  59, -07, -94, -228,  193,  353,  286, -373, -429,  29,  288,  460, -458,  273,  389, -174,  237,  467, -376, -316, -357,  447,  305, -45,  273, -115, -02,  495,  359,  333,  425,  270, -174,  183, -457, -128,  388, -319, -01, -189,  210,  140, -229, -396, -87,  13,  282, -350, -20,  406,  187,  124, -294, -08, -69, -169,  377,  429, -174, -412, -386,  103, -289, -60,  138, -246,  312,  26,  287,  164,  337,  349,  156, -391,  453, -431,  474, -413, -281, -46,  494, -242, -70,  52,  250,  361,  383,  480, -358,  61, -432, -244, -335, -221, -451,  303,  385, -287,  182, -476,  377,  371,  373,  33,  480, -322,  454, -194, -234,  26,  261,  112,  284,  43, -336,  387, -95, -101, -281,  399,  460, -213,  08, -23,  419,  57,  133, -344,  270, -185,  33, -500, -314, -94,  385,  19,  85,  340, -323, -297,  218,  438,  315,  354, -18, -169,  241, -261,  230, -188, -362, -458,  100,  146,  372,  371,  55,  05, -121, -174, -328,  412,  178,  210,  171,  63,  81,  108,  255,  259,  311,  325, -451,  126,  180,  31,  457,  273, -378,  187, -414,  113, -419, -462,  111,  453,  409, -333, -42,  140,  345,  482,  405,  23,  193,  76, -62, -226, -316,  46, -115,  495, -129, -65,  473, -449, -182,  430,  325, -59,  469,  411, -446, -98, -199, -483, -144,  62, -316, -334, -298, -471, -351, -41,  404, -306, -465,  195, -32,  71, -259, -294,  418,  112,  141,  391, -484,  459, -327, -307,  252, -358, -396,  306,  45,  257, -324, -247, -181, -140, -81,  21,  242,  420, -167,  146, -386, -132, -159,  435, -208,  434, -359, -290,  47,  282, -46,  63,  241,  127, -392, -06, -378, -288,  152, -481, -179,  328, -228,  140,  41,  191,  13, -217,  112,  346, -219, -422, -285,  475, -487,  359,  409, -346, -431,  308,  436,  375,  223, -470,  03,  331,  376,  125, -105,  380,  144,  216, -439, -232, -144,  102, -189,  370, -263, -225,  216,  18, -146, -217, -07, -133, -358,  255,  22,  64,  63,  310, -61, -213,  340, -206, -382,  216, -229,  14,  449, -233, -270, -490,  35,  87,  112,  347, -43,  349, -378,  25,  219, -24,  309,  65,  344, -197, -180,  218, -281,  383,  28, -489, -330, -131, -195,  141, -63,  429, -345, -114, -304, -115, -104,  232, -176, -140,  431, -367,  61, -95,  159, -219,  382,  320, -302, -422, -377,  18,  296,  195,  253,  176,  206, -224, -455, -137,  417,  335, -208, -428,  73, -11, -43,  470,  73,  282,  182,  356,  415, -256, -239,  426,  377, -357,  246, -425,  73, -278,  445,  221,  417,  198, -102,  475,  474,  295, -162,  391,  130,  131,  463, -296, -28,  273,  26, -103,  407, -292, -247, -326,  304,  14, -399,  181, -490, -301, -392,  83, -79, -447, -195,  190,  252, -445,  165,  226,  350, -496,  470,  333,  487,  433, -463, -41,  206,  415,  356,  465, -25, -391, -360, -220,  123, -259, -187,  485, -60, -78,  69, -286, -25, -274,  404,  79, -219,  70,  158, -17,  74,  128, -184,  61,  61,  205, -128,  120,  120, -272,  85, -404,  189,  225,  228, -188, -182, -459,  150, -389,  315, -281, -175, -209,  297, -271, -278, -70, -349,  380,  413, -423,  08,  82,  490, -430, -213, -138, -458,  408,  442,  479, -144,  131,  205, -416, -204, -125, -375,  446, -14,  441,  17, -337,  84, -186,  245,  306,  244,  396, -461, -491,  474,  47,  91,  464,  469,  379, -173, -489, -361, -231,  491, -05, -247, -452,  431,  49,  275, -92, -05, -238,  201, -488,  277, -215,  178,  22, -56, -78, -81, -17,  283,  245, -118,  227,  209, -148,  458, -112, -137, -403, -490,  206,  444, -237, -394,  375,  312,  382,  135,  159, -04, -163,  171, -227,  122, -151,  296, -82, -377,  67, -247, -242, -188,  136,  485, -479, -160,  443,  262,  203, -108,  272,  262,  188, -113,  368,  63, -301,  250, -301, -290, -254,  388,  381,  20,  362,  82,  168, -219, -443, -265,  386,  167,  47,  22,  153,  420,  362,  448, -466,  418,  193,  306, -468, -119,  45,  400, -203, -404, -497,  348, -194, -251,  236,  39, -379,  98, -27,  289,  379,  30, -124, -382, -302, -225,  140, -297, -304,  355,  03, -270, -375, -304, -111, -343,  78,  434, -91,  375, -469, -88,  223, -163,  162,  311, -271, -365, -91,  202, -223,  141, -267,  153,  259,  283,  429,  251,  486, -23,  458,  341, -441, -417, -462,  300,  92,  116,  235, -498,  343, -382,  266,  418,  307,  280,  229, -464,  416, -362,  239, -307, -369,  472, -302,  390, -393, -21,  494, -55,  456,  452, -214, -132, -112, -176, -332, -168, -208,  403,  186, -365, -127, -47, -95, -319, -267, -366, -283, -351,  125,  456,  194, -392, -220,  393,  499,  239, -128, -155, -316,  181,  149, -29, -451, -111, -353, -283,  222, -60, -27, -92,  427,  346,  361, -167, -121, -53,  319,  97,  96, -56,  405,  143,  53,  38,  388,  404, -223, -240,  101, -38, -207, -250, -215,  194,  140, -68,  412,  214, -276,  237, -378, -348,  435, -164,  337, -185,  283,  156, -236,  231, -47,  21, -126, -142, -441, -238,  114, -163,  375, -285, -349,  20,  317, -64, -285, -43, -280, -21, -329, -55, -284,  146,  449,  03,  482,  286, -330, -383,  294, -66,  348,  99,  456,  75,  457, -485, -311,  423,  204, -84, -362,  355,  437,  456, -209, -348,  265,  12,  483, -211, -191,  51, -213, -242, -446, -231, -104, -275,  238, -310, -489,  86, -358,  467,  13, -401, -165,  203, -477, -109, -29,  13, -253, -92,  321,  390,  412,  439, -98,  395, -272,  211, -54,  15, -179,  353, -364,  217, -422, -274, -240, -411,  312, -98, -91,  178,  353, -404,  233, -272, -13, -296, -406, -414,  113,  415,  477,  377,  354, -121,  273, -66, -57,  71, -199, -384, -76,  289,  334,  354, -485, -54,  444, -320, -300,  205,  358, -447, -347,  91,  134,  140,  295,  228,  227,  260,  143,  204,  138,  350, -65,  263, -216, -270, -166,  438, -153, -389,  227,  33,  465,  243, -169, -239,  423,  31,  466, -367,  436, -381,  224,  70, -388,  371, -202, -309,  132, -206,  395,  122, -04,  182, -115, -368, -235, -429, -430,  464, -318, -350, -03,  00,  393, -320,  261, -332,  211, -420, -199,  147,  51, -475,  70, -485, -252, -280, -294,  380,  366, -47,  354, -138, -364, -261,  347, -99,  163,  417,  217, -303, -433,  66,  197, -188,  246,  311, -20,  309,  391,  281,  308,  294, -342, -122,  310, -93,  451, -484,  139,  317, -30, -06,  32,  458, -415, -121,  211,  248, -204, -72,  446,  216,  494,  495, -472,  240,  306,  09,  49,  197,  142,  209, -08,  301, -412, -198,  60, -109,  170, -301, -292, -360,  193,  240, -402,  279, -381,  309,  379,  268,  89,  325,  336,  83,  321,  364,  175,  127,  225,  76,  177,  220, -214, -331,  373,  226,  323, -67, -383, -07,  132,  177,  486,  178, -82, -64, -43,  389,  98, -164, -491, -313,  14,  345,  271, -165, -438,  298, -186, -361,  227,  491,  359, -487,  12,  232, -409,  187,  17, -292,  33, -350,  385,  19,  328,  155,  455,  137,  397,  53, -175, -242,  241,  339, -396,  364,  26,  18, -486, -307, -491,  241,  36,  369, -394, -451,  453, -303, -412, -29,  257,  121,  473,  495, -08,  301,  150, -52,  290,  399, -147, -385, -342, -54,  455,  114,  162,  333, -368,  177, -474, -359,  270,  63, -138,  377,  112,  168, -74, -448, -09, -316,  174, -36, -321,  18,  117, -319,  466, -93, -67,  172,  374,  91, -382,  329, -295, -367,  163,  189,  310,  189, -318,  432, -248,  397, -339, -284,  417,  88,  121, -92,  272, -205, -276, -197, -335,  341,  336, -16,  100, -231, -344, -26, -288,  126,  156,  269,  259, -181, -42,  421, -140,  493,  354,  465,  390, -485,  33,  307,  103, -346,  67,  227,  301,  291, -118,  467,  132,  71, -49,  84,  340,  107, -442, -95, -267, -434, -326, -155, -115,  485, -234, -402,  478, -28, -437, -280, -12,  448, -121, -57, -397,  446,  23,  404,  237, -243, -277,  221,  328,  174,  157, -479,  133,  215, -74, -281,  282,  100,  64,  19,  85, -318,  469,  415,  155, -116, -365, -05, -167,  14,  438,  288,  312,  313,  192,  49, -429, -232,  122,  399, -206, -221,  420,  428, -153, -154, -01, -19, -201, -85, -148, -264,  97, -178, -348, -248,  206,  139, -401, -461, -346, -462,  327, -182,  351,  372, -280,  422, -08,  342, -326,  286, -26, -406,  214,  321,  293, -287,  154, -56,  480, -494,  180,  78, -172, -316, -318, -465,  324, -218, -74, -170,  172,  106,  148,  375,  330,  368, -350, -178,  211, -176, -392,  37,  270, -325, -142,  63,  240, -488, -493,  221, -482, -460, -201,  199, -276,  333,  234, -452, -385,  12, -122, -361, -30, -473, -485, -200,  395, -335,  474,  458,  341, -65, -05,  111,  110, -295,  27, -150,  69,  386, -77,  88,  426,  222,  139, -349,  408,  225,  51, -125, -263,  430,  15, -440, -191,  382, -140,  56, -101,  187,  15, -260, -378, -138, -297,  232,  68,  230, -66, -363,  117,  358, -423,  395,  432,  216, -102,  340, -59,  450, -284, -469, -268, -417, -409,  41,  465,  303, -51, -136,  342,  464,  104,  464,  179,  307, -452,  99,  390,  335, -412,  07,  193, -334,  254,  477, -266, -347,  318, -472, -397, -114, -89,  187,  321,  354, -272,  286,  157,  177, -350,  352,  494, -394,  316, -475, -235, -283,  124,  07, -448,  212, -134,  245, -270, -379, -426,  317, -226,  392,  345,  229,  130,  108, -84, -49, -38,  496,  89, -29, -475, -409, -177, -129,  49, -08, -104,  315,  209, -480,  174,  261, -415, -459,  358, -185, -338,  432, -368,  288, -323, -171,  17, -341,  437, -215,  111, -101, -219,  52,  371,  158,  144,  46, -470, -307, -462, -74, -140,  247,  299, -465,  360,  384, -424, -430,  51, -262, -497,  184, -122,  32, -135,  395,  191, -197,  32,  154, -446,  313, -293, -223,  323, -297,  324,  353, -104,  362,  132,  257,  462,  283, -356, -326,  167, -280, -255,  70,  310,  100,  106, -312, -368,  472, -65, -325, -225,  467, -318, -171, -368,  241,  459,  455,  444,  283, -339,  192,  497,  293,  301, -189,  76,  445, -14,  95, -335, -417, -335,  475,  183,  272,  15, -333, -404,  450,  194, -129, -231, -272, -448, -99,  469, -489,  209, -235, -354,  370,  458, -04, -485,  259,  307,  443,  205,  145,  38, -278, -420, -445, -302, -385, -321, -435,  134, -225, -484, -171,  498,  137,  57, -97, -461,  379,  266, -400, -356,  413, -178, -398,  261, -163, -286,  68, -220,  419,  66, -330, -07,  146, -275,  191,  262,  257, -391, -104, -116, -23, -423, -117, -386,  135,  286,  05,  366,  404,  105, -490, -331,  427, -35,  430,  116, -469, -01,  396, -198, -83, -82,  295, -437,  144,  339,  325,  253,  448,  74, -363, -75,  151,  20,  391,  138,  158, -103,  04,  63, -146,  367, -416, -218,  184, -485, -250,  215,  14, -353, -131,  431,  65, -336, -154,  61, -497,  24,  166, -197, -402,  304,  228,  249,  176,  120, -112, -165, -131, -256, -250,  223, -37, -166, -143, -353,  201,  108, -286,  67, -393,  83,  350, -476, -400, -303,  86, -397,  221, -248,  259,  319, -92, -13,  420, -415, -41,  160,  272,  328,  405, -126,  404, -132, -440, -239,  368,  262,  369, -66, -171, -172, -482, -320, -147, -30, -123, -209,  73, -50,  395,  184, -231, -196, -328, -311,  241,  483, -298,  13, -336, -393, -261, -432,  327, -201,  181, -453, -439,  51, -18,  243, -269,  00,  423,  84,  470,  152,  375,  395, -398,  271,  80,  223, -73, -396, -236, -332, -61, -34, -467,  103,  425, -228, -477,  253,  71,  205,  300,  485,  108, -218, -420,  339, -366, -145,  276, -44, -493,  151,  204, -39,  274,  136,  36, -299, -408, -348,  221,  31,  119,  254, -13,  396, -474,  362, -499,  450,  67, -346,  435,  27, -64, -485,  219,  423, -130, -05,  231,  229, -354, -65,  42, -227, -77, -70,  326,  15,  82,  48, -453,  53, -198,  386, -50,  181,  248, -49,  131,  168,  105,  418, -305, -106,  433,  414,  169,  155,  261, -100,  236, -240, -312,  130,  33,  111, -440, -141, -373,  142, -241,  26, -304,  62, -88,  498,  95,  12, -51, -274,  32, -93, -356,  228, -347, -71,  494,  322, -64, -392,  74, -328, -132,  262,  302,  401, -126,  362,  112,  353,  356,  372, -121, -96,  286, -357, -98, -119, -493, -296,  107,  40,  111, -397,  120,  264,  32,  466,  438, -180, -426,  12,  344, -58, -225,  146,  195, -499,  360,  160,  354, -432,  32,  85, -27,  170, -420,  375, -449, -413, -421, -490,  127, -458, -35,  99,  306, -151,  66,  244,  169,  492, -243,  13, -65,  384,  11, -18,  385,  223, -358, -409,  291, -474,  176, -236,  196,  256, -360, -401, -305,  71, -391, -325,  114,  426,  274,  272, -225,  192,  369,  444,  185, -22, -43, -28, -138,  468,  454,  99,  191, -51,  190,  335, -25,  218, -401,  24, -26,  91,  123,  169, -337, -415,  344, -371, -489,  471,  401, -213,  163,  270, -269, -152, -252, -459, -328,  110, -491, -373,  61, -447,  428, -249,  388, -97,  469, -161,  427,  295,  431,  403,  317, -54,  488, -487,  75,  499,  484,  328, -214, -500,  99,  370,  200, -301,  411,  373, -338, -228, -148,  223,  177, -220, -173,  65, -465, -204, -243,  463, -56, -312,  366, -239,  486, -294,  126,  413, -295,  463,  241,  344,  463,  192, -434,  163,  392,  477,  36, -446,  101,  388, -371, -221,  20, -44, -304,  56, -395, -47,  371,  49,  493, -411, -338,  479, -205,  288, -256,  352, -397,  486, -452, -434, -470, -386,  230,  422, -57,  118, -172, -455,  359, -42, -176, -121, -234,  372, -213, -129, -174, -342,  420,  171, -253, -66, -497,  42,  75, -253, -105,  178,  85,  295,  245,  116,  410,  327,  390, -147,  297,  71, -102, -492, -471, -426,  240,  147,  447, -473, -481,  125, -314, -209, -204, -67,  226, -201, -172,  153,  47, -425, -169, -16,  370, -72, -400,  280,  107,  491, -14, -95,  62,  384,  265,  443, -189,  05,  90,  110,  33,  461, -265,  219, -247,  383,  04,  479, -317,  332,  132, -418,  407, -185,  66,  278,  244, -481,  410, -149, -138, -104, -392,  424,  133,  374, -281,  444, -121, -339,  406, -236, -377, -07,  483,  228, -124, -12,  207,  411, -180,  191, -155,  80, -142, -236,  210, -46, -217,  120, -342,  145, -483, -234,  421, -498, -08, -360,  446, -276,  153, -296, -12, -372,  197,  324,  356, -75, -188,  415, -163,  484,  458,  182,  416, -183,  446,  126,  271,  81, -253,  429, -274,  116,  48, -353,  118, -108,  139,  416,  468,  145, -380, -43,  273, -331,  133,  130,  94,  445,  45, -217, -219,  356, -182,  50, -327,  116, -324, -204, -302,  275,  78, -76,  243, -22,  424, -139,  370,  415,  129,  339,  60, -399,  148,  186, -230, -219, -184, -283,  78, -287,  00, -289, -431,  318,  261,  94,  287, -210,  391,  485, -435,  321,  261, -339, -201,  185,  22,  21,  453,  04,  212,  13,  105,  212, -301, -272, -155,  367,  297, -225, -67,  149, -13,  02, -32,  100, -51, -245,  390,  192,  92, -192,  13, -147, -31, -336, -109, -157,  185,  196, -301, -102, -291, -343, -38,  261,  237,  308,  480,  34, -417, -87, -317,  422, -232, -497,  23,  217,  110,  265,  261, -298, -75, -226,  408,  394, -62,  151,  90, -25, -153,  289, -275,  408,  446,  188, -479,  183, -04, -498,  69,  431,  267,  253,  354, -465,  256,  229, -396,  219, -06,  365,  421,  420, -09, -319, -334, -219,  332, -392,  257,  31,  398,  482, -60, -304, -478, -39, -268,  370,  315,  301,  302,  83,  54,  156,  470,  163, -115, -73, -118, -269, -208,  155,  03, -364,  337,  170, -83, -479,  278, -326,  53, -472,  09, -155, -275,  31, -342,  309,  254,  474,  110,  56,  409,  17, -288, -269,  32,  449,  158,  414, -320, -197,  421,  184, -61, -390,  206, -292, -368,  336,  235, -463,  365, -256, -118, -58, -373,  40,  103,  381,  366, -287, -63, -373, -418, -499, -141,  114, -198, -131,  380,  335, -476,  302,  19,  315,  412,  77, -476, -104, -87,  259, -67,  130, -145,  315, -76,  334,  208, -473,  216,  74, -259,  05, -446,  175,  359, -87, -210,  13, -366, -330, -152,  11,  472, -281, -174, -263,  296,  202,  133,  62, -39, -433, -308, -332, -266,  469, -497,  442,  496, -429,  369,  89,  428,  423, -235, -361,  188,  55,  153,  322,  225, -499, -167, -450, -279, -488, -213, -131,  214, -228,  431,  28, -161, -24,  196,  74, -55,  199,  368,  293, -378,  237, -117, -449, -488,  148, -310,  200,  55,  343,  375,  132, -303,  60,  182, -82,  72, -179, -361,  139,  446, -429, -333, -215,  399,  363, -289,  196,  415, -68, -11, -463, -331,  372, -60, -318,  372,  483, -266, -73, -322, -391, -440, -125,  170, -406, -355,  94,  268, -215, -267,  214,  208, -100, -149,  459,  116,  415,  155,  383, -153, -356,  420,  368, -131,  213, -98, -259,  196,  137,  169,  374,  246, -419,  102,  268, -325,  247, -137, -205, -116,  96, -491, -56, -151,  213, -97,  465,  128, -442,  348,  475,  55, -380, -305,  424, -315,  98,  17,  381, -265, -314, -392,  481,  119,  210,  250, -353,  309, -35, -58,  46, -439,  304,  490, -90,  17, -106,  227, -03,  304,  427,  324, -141, -452, -481, -217, -267,  117,  301, -33,  352, -161,  427, -314, -189,  489, -212, -42,  298,  253, -248, -156, -334, -444,  187,  429,  425, -419,  156, -78,  385,  84, -254, -255,  484, -234,  380, -283, -265, -467, -464, -412,  225,  463, -226, -464,  452,  62,  346, -397,  167, -402,  299,  333, -345, -14,  262, -68,  419, -81, -293,  305, -145, -47, -98, -161, -429,  134,  408, -193, -480,  445,  247,  245, -240, -127, -367,  65,  435,  479, -480,  102, -423,  319,  287,  84,  158,  50, -483,  429, -179, -276, -414,  176, -471, -12, -133, -47, -25, -225, -388, -05,  72, -289, -260, -315,  84, -127,  250,  371, -148,  270,  325,  281,  441,  112, -134,  451, -338,  235,  381,  335, -189,  467,  11,  192,  308, -270, -03, -217,  358,  109,  278, -70, -328, -130,  467,  256, -405,  217,  127,  299,  339, -48,  80, -367, -435, -202, -416,  79, -467, -183, -85,  196,  137, -222,  241, -55,  09, -262, -420, -133, -300, -290, -351, -128,  80, -383, -371, -473, -314,  256,  326, -122,  61, -94,  11,  478,  205,  447,  57, -410,  117, -176, -361, -246,  455,  380, -449, -36, -382, -369, -317,  170, -159,  184, -457, -227,  301, -328, -200, -160, -220, -374,  218, -307,  384,  81, -329,  441,  28, -419, -116, -03, -95,  23,  251, -140,  255,  302, -324, -275,  433, -141,  396,  126, -456,  439,  399, -303, -37,  51,  389, -405, -471,  107, -211,  414, -312, -40,  355, -431,  393, -261,  66, -201, -386,  170, -489,  369, -28, -312, -405,  258,  399,  491,  236, -205, -218,  488,  345, -403,  39,  234, -308,  69, -158, -19,  335,  382, -206,  190, -197, -313, -218, -278,  338, -104,  392,  350, -234,  216, -110,  213,  326, -211, -444,  63,  437, -162,  51,  282, -65, -58,  16,  479, -489, -290,  313, -302, -55, -41,  389, -400,  498, -329,  174,  337,  419,  418, -461,  37,  135, -71, -250,  313, -430, -194, -124, -493,  496, -221, -359,  283,  222, -490,  263, -415,  72,  76, -216, -483, -465,  25, -30, -467, -452, -356, -278,  467, -437, -239,  05, -450, -458, -393, -285, -35,  266,  92,  324,  262, -277,  466,  398,  445,  476, -487, -117,  400,  89,  167,  418,  476,  44,  240, -139,  92,  384,  436,  59, -201, -303, -84,  201,  92,  24,  417, -443, -210,  09, -267, -96, -416, -301,  154, -470,  27,  167,  265,  280, -244,  284,  198,  84, -172, -62, -202,  420,  174, -266,  331,  474,  283, -252, -473, -125,  272,  444,  284, -86,  305, -130, -330,  390,  421,  325, -228,  301, -08, -463,  81, -399,  321, -221, -463,  01, -431, -165, -79, -405,  421, -248, -79,  205,  352, -51, -68,  476, -107,  69,  242,  51,  439,  413, -59,  360, -410,  213,  161,  434, -398, -258, -113, -225,  373, -75,  276, -206, -388,  49, -110, -114, -347,  311, -409, -494,  112,  23,  482, -142, -408,  225,  409, -469,  490, -150, -256, -420, -85,  405, -134,  369, -352,  254, -04, -479,  31, -228, -184,  495, -327, -442, -119, -174, -279,  324,  184,  334, -152, -481, -308,  292,  244, -47, -324, -414,  303, -80,  18,  70,  177,  384,  291,  325,  490, -213, -301,  373,  411,  367,  369, -416,  425,  102,  262, -354, -73, -53,  480, -373, -34,  24, -229,  62,  477, -53, -500, -368, -281,  18, -446, -251, -98,  345, -426,  245, -16,  125,  118, -105, -08, -13,  331,  269, -58,  94,  416,  369, -107, -252, -152, -289, -375,  119, -375, -398, -81, -375,  87,  490,  143,  141, -261, -103,  339,  166, -358, -177, -209,  261,  219, -364,  100,  402,  405, -106, -04,  321, -237, -259, -78,  463, -48,  47,  83,  77, -499, -146,  202,  440, -156,  197,  434,  436, -405,  273,  102, -263, -52,  393, -150,  19, -119, -197, -78, -213,  197,  418, -40, -187,  12,  382, -224,  464,  281, -289,  394, -365,  65,  448, -425, -238,  146, -139, -302,  241, -366,  300, -170,  83, -455,  181, -46, -73, -164,  376,  214, -467, -353, -326,  198,  159, -91,  475,  123,  42, -314,  369,  177, -396,  318, -395, -134, -36, -34,  64,  57,  453,  216,  387,  388,  261,  420, -158,  40, -244, -281, -246,  142, -134,  281, -160, -475,  42, -185, -500, -416,  354,  370, -386, -190, -460,  71,  176,  04, -463,  92, -439,  490,  160,  448,  378, -79, -279,  73,  462, -23,  292,  68, -381,  10,  201,  312,  35,  95, -21,  387, -468,  185, -391, -354,  495, -351,  217, -477,  153, -394,  467, -434, -403,  127, -485, -173, -99,  88,  400, -137, -435, -456, -217,  37,  54, -163, -151, -59,  432, -320, -171,  464,  366, -62, -390,  361,  88, -321, -263,  93, -214, -296,  160,  235, -316, -473, -86,  85,  115,  167, -200, -468, -437,  83,  69,  118, -228, -230, -89, -295, -49, -408, -331,  169,  383,  132,  30,  323, -337, -381, -84, -51,  176, -424,  36,  360, -45, -197, -55, -430,  470, -403, -397, -467, -468, -476, -497, -195, -205,  267,  10, -402,  359, -469,  267,  242,  163,  149,  65,  327,  269, -166,  128,  297,  262,  17,  157, -282,  320, -46,  140, -358,  51, -405,  27,  83, -380,  383,  388,  267,  150,  250, -283,  361,  282,  484,  104,  297,  485,  21,  124, -394, -293,  105,  403,  470, -26,  412, -312, -206, -134, -320,  288, -231, -224, -185,  353, -104,  50, -407,  15, -300, -304,  232, -86,  478, -432, -482,  275, -447,  391,  252, -340, -401,  209, -85, -431, -317, -172,  109,  329,  194,  289,  117,  464, -83, -216, -331,  313,  335, -238,  180, -113, -42, -88,  301,  288, -20, -329,  416,  34, -85,  168, -454,  366,  229, -39, -213,  412,  289,  396, -407,  336, -463, -438,  300, -45, -154,  469,  120,  33,  83, -199,  421, -106, -435, -426, -318,  46,  98, -50, -68, -487, -30, -22,  379, -301, -209, -334, -37, -419, -86,  56,  417,  303,  118, -431,  110, -183, -110,  83,  350, -175, -264, -377,  219, -199,  50, -246,  347, -352,  204,  131,  13,  27, -391,  244,  226,  253,  410,  42,  334,  176, -50, -397, -21, -79,  24, -58,  238,  414, -475,  440, -261, -239, -84, -189,  62, -182,  417,  262, -34,  473, -107, -169,  00,  355, -425,  79,  108, -163, -379,  294, -487,  71,  397, -08,  492, -79, -214,  230,  187, -189, -477, -222,  72, -61,  89, -365,  257,  358, -251,  75,  332,  142, -242, -168,  349, -167,  411, -43,  170, -116, -249,  183,  456,  00,  27,  448, -227,  314, -469, -188, -375, -446,  91, -450,  345,  32,  37,  454, -109,  286,  381, -277,  280, -361,  407,  130,  324, -329, -413, -06,  55,  191,  29,  363,  43, -444,  312,  317, -278, -305, -371,  200,  101, -428,  250,  298,  105, -213, -396,  496, -75, -163,  71, -295, -24,  330, -313, -200, -147,  127, -354, -239,  170,  175, -376, -287, -417, -212, -470, -194,  335,  12, -142, -64,  84, -392,  86,  41,  247,  190,  37,  24, -473, -40, -419,  355,  143, -231,  07,  496, -252,  153,  109,  418,  180, -414, -369,  264,  226,  14, -78,  62, -122, -368, -150, -186,  92,  437,  356,  191,  127,  245, -285, -493, -294, -204,  362, -299,  417, -130,  49, -335, -125, -341, -65, -92, -255,  67,  24,  471, -67,  446,  385,  311, -70, -264, -375, -478, -327,  481,  213, -348,  227, -220, -341, -215,  76, -478, -14,  346,  244, -113, -137, -381,  46,  299,  27, -357,  218, -449, -33, -349, -151, -148, -186, -369,  88, -61, -347, -387,  273, -282, -234,  352, -02, -75, -11, -425, -53, -173, -227,  43,  214,  488,  163,  113, -361,  42,  256,  357,  446,  75, -140,  147,  428,  174, -369,  368, -34, -216,  482,  91,  03, -252,  295, -499,  173, -216, -72, -27,  463, -447, -484,  177, -458, -469,  142, -319,  426,  251, -109, -276, -174, -397, -277,  106,  278, -146, -25,  96,  139, -43,  39, -06, -443,  186, -05,  230, -178, -224,  55, -215, -171,  72, -186,  223,  455,  457,  405,  381,  208,  148, -395, -466,  251,  181,  493,  381, -465, -32,  329,  174, -223,  220,  20, -166, -94, -484, -84,  228,  144,  472, -487, -175,  396, -172, -451,  351,  137, -194, -415,  197,  454,  42, -417, -443, -277, -424,  439, -241,  44,  268, -215,  321, -11,  306,  07, -253, -326, -224,  476, -330, -252,  489, -05, -04,  169,  44,  199,  158,  350, -364, -145, -344,  179, -61, -286, -246,  15, -347,  13, -88, -227, -349,  85, -386, -191, -407, -138, -17, -131, -162,  153,  469,  179, -352,  317,  201, -455,  16, -141,  395,  153, -433, -96,  184,  06,  118,  438, -127, -377,  304,  285, -104, -193, -129,  363,  116,  316, -275, -49,  37,  415, -396,  06,  94,  104,  175,  147,  149, -309, -141,  397, -304, -74, -199, -268, -216, -229,  23,  157, -106, -173,  295, -358,  486,  18, -495,  102, -166,  82, -447,  371, -03,  09,  229, -56, -35, -96, -409, -33,  447, -50,  216, -04, -272, -131,  228,  12,  140, -249,  22, -114,  430, -183,  28,  416,  335,  386,  370,  21, -32, -225, -108,  466, -364, -27, -90,  102,  377,  353, -79, -324,  156, -11,  172,  384,  358, -99,  249,  350, -496, -229,  88,  435,  88, -32, -297,  275, -146, -74, -204,  323,  201, -460, -359, -310,  13,  403,  292,  242, -392,  65,  418,  264, -446,  91, -499, -236, -156,  250, -34, -152, -479, -446,  135,  461,  22, -309, -412, -271,  117, -116, -96,  170, -76,  45,  360, -211,  300, -496, -469,  408,  69,  449,  173,  475,  392, -474,  91, -264,  276, -443,  85, -351, -389,  72, -390,  486,  263,  50, -285,  232,  434,  119, -97,  210, -336, -237,  499, -184, -232, -118, -276, -311, -169, -251,  17, -276, -225, -392, -40, -449, -334, -103,  52,  129, -178, -486,  115, -63,  64,  330, -330, -02, -51,  425,  60,  465, -312,  411, -219,  308, -207,  358, -150,  477, -393, -281, -299,  235, -173, -487, -362,  345,  263,  191, -25, -63,  205, -58,  374, -230, -227, -456, -380, -426, -179, -467, -460,  362,  444,  173,  170,  90,  31, -128,  67,  491,  91, -380,  226, -229, -15,  364, -32, -252,  55,  443,  185,  113,  238,  412,  383, -137, -192, -145,  289,  130, -112, -319, -08,  185,  355, -338,  127,  238,  387, -306,  229,  330,  166, -45, -399, -349,  172,  70,  252,  79,  365,  289, -308,  455,  201, -73, -182, -490, -365, -392,  140,  23, -211, -368,  60, -04,  146, -313, -265,  385,  233,  464,  216, -101,  272, -331,  51, -56, -409,  155, -477,  457, -56,  68,  412, -354,  495,  83,  08, -370, -457, -352, -494,  184,  132,  66, -319, -222, -394, -84, -336,  339,  232, -268,  91,  04, -99, -06, -200, -07, -351,  176,  302,  445, -256, -434, -57,  91, -499,  451,  222, -456, -49, -420,  229, -417,  498,  410,  214, -396,  178, -270, -204,  262, -38,  387, -233, -285,  233,  419,  208,  382,  95,  362,  327,  339,  429, -229,  283, -218,  74,  05, -173, -474,  437, -92, -391,  435, -182,  323, -108, -152, -447, -460, -390,  367,  427,  229, -417, -488,  149, -357,  394,  96, -142, -427,  288,  139,  196,  71,  421, -229, -72, -252, -203, -135,  156, -94,  152, -174,  82, -456, -474,  487, -416, -363,  355, -137, -282, -210, -125,  367,  285,  121,  316, -357,  195,  104,  282, -109, -325,  204, -486,  103, -196, -189, -180, -187, -430,  472,  491,  152, -131, -482,  491,  305, -345,  346,  21, -127, -12,  396,  93, -226,  370,  261,  269,  417, -135,  404,  160,  40,  460,  175, -05, -236,  486, -333,  429, -444, -361,  421, -440,  360,  439, -448,  166, -54, -250, -313, -329, -409, -65, -384,  217, -195,  377, -14,  74, -258,  242, -265, -366,  202,  410,  481, -181, -252, -352, -252,  157,  140,  21,  217,  00, -40, -379, -334, -242, -128, -147, -70,  315, -359,  46,  32, -54,  276, -482, -479, -482,  261,  108,  05,  315,  18,  338, -366, -382,  487,  235,  275,  479, -244, -07, -21, -431,  466,  498, -173,  190,  203, -391,  05,  344, -492, -463, -209,  284, -92,  164, -346,  21, -228,  159, -164, -358, -02,  323, -240,  337,  58, -464,  316, -334,  381,  147,  87,  347,  145,  415,  390, -151, -124, -105, -307, -116, -67,  336, -332,  341,  352,  175,  214, -376, -166, -450,  118, -316,  373,  379, -127,  283, -233,  41, -198,  00, -311,  389,  199,  334, -344,  89,  35,  33,  485,  229,  417,  270,  417, -62,  463,  270, -387,  177, -254,  299,  227, -283, -164,  453, -52,  209, -412,  215, -249, -110,  67,  292,  132, -234,  478,  288,  356,  14,  173,  341,  95,  91,  111,  364, -119,  74,  134,  346,  103, -267,  145, -170, -50, -167,  135,  398, -457,  224,  465,  146, -34,  32,  290, -402,  298,  268, -261, -494, -218,  412,  347, -271,  355,  310, -406, -264,  236, -420, -418, -161, -187, -420, -478, -385, -87,  157, -135,  308,  233, -170,  306, -300, -286,  96,  150, -135, -135,  389, -129,  499,  302,  71,  81, -491,  233,  175,  98, -30,  255,  180, -339, -79, -388,  35,  388,  378,  45, -246,  186, -222,  436,  345,  330, -349, -59, -19,  16, -342,  222, -261,  10,  376,  310, -409,  386,  44,  266, -16, -134,  373,  16,  379,  146,  481, -85,  35,  359,  460, -359,  397,  90, -423,  242, -79,  80,  36, -246, -52, -454, -172,  188,  56, -295, -02,  147, -409, -106,  265,  427,  260,  139,  295,  492,  137,  276, -93,  24,  135,  219,  165,  385,  161,  243,  479, -66, -177,  15,  188, -376,  62, -483,  312, -382,  74,  162, -382, -483, -443,  383,  444, -331,  374,  239, -339,  12,  368,  420, -464,  355,  139,  202,  240, -199,  297,  220,  235, -28,  87,  276,  96,  01, -355, -92,  472,  219, -77, -410,  236, -20,  473, -468, -499, -300, -377, -337,  212,  491, -417, -400,  347, -425, -346,  87,  228,  451,  159,  315,  276,  99,  443, -128, -400, -412, -367, -428, -341,  56, -338, -253, -464, -12, -221, -463,  188,  255,  52,  252,  246,  488, -296,  445, -437, -141,  385,  291,  162,  44,  458, -62, -357,  402, -337, -256,  490, -204,  168,  02,  352, -317,  249, -260,  171, -119, -223,  211, -364, -318,  315,  382, -330, -129,  328,  85, -418, -435,  228,  245,  109,  186,  35, -395,  88,  198,  201,  431,  494, -131, -67, -302,  52,  34, -62,  75,  415, -432,  138, -449, -250,  305, -214,  272, -323, -34, -143, -241,  31, -415, -144, -08,  271, -256,  97,  212, -206,  150,  495, -211, -128, -72,  339, -224, -186, -222,  352, -270, -154,  342,  133,  448, -500,  419,  220, -323,  237, -71,  288, -232,  14, -03, -387,  137,  241, -438, -151, -465,  213, -156,  176, -415, -376,  16, -139, -61,  294,  65, -479, -08,  260,  154, -60,  260,  426,  12,  437,  163,  441, -423, -216,  307,  74, -103, -56, -185, -41, -354,  203,  24,  342, -121,  109, -181,  395,  471, -390, -459,  388, -369,  385,  148, -363,  177, -92, -437, -311,  197, -421, -18,  275,  215, -211, -151, -388, -414, -483,  423, -268,  220, -52, -426, -49, -91,  245,  199, -120,  355, -408,  121,  486,  478, -231, -24,  155,  178,  391, -303,  227,  470, -469,  02, -463, -179, -296, -351, -93,  73, -75,  491, -207, -275, -435,  244,  134,  311,  295, -133, -482,  388,  488, -143,  366, -243,  333,  373, -213,  224, -78, -485, -453, -46,  369, -416,  275, -75,  86,  34,  498, -137,  25, -209,  88,  442, -112, -278, -395,  35,  89, -376, -77,  429, -19, -211,  39, -186,  15, -322, -110,  437,  45,  289,  243, -85,  374,  18,  340,  312, -96,  339, -325, -219, -18, -385, -276, -278, -163,  181,  258, -221,  305,  33,  60,  138, -325, -401, -196,  190, -222,  195,  479,  323, -16,  223,  90,  210,  93,  283,  22,  498,  474, -451, -221,  308, -336,  355, -117,  354,  37, -07, -367,  194, -474,  193, -167, -299, -355,  489,  391, -77,  184,  371,  98,  21,  446,  41,  83,  39, -176, -42,  37,  150,  07, -331, -42, -476, -476,  341,  378,  413, -166, -137,  460,  213, -92, -207,  414,  53, -218, -342, -172, -181, -119, -221, -308, -173,  320, -373,  366, -04,  85,  256, -02, -55,  425,  456, -31, -199, -350,  199,  67,  336, -86,  27,  49,  322,  320,  316,  228, -46,  474, -92, -375, -145,  187,  169,  182,  359,  297,  400,  207,  234,  156, -295, -321,  81,  14, -500, -265,  164, -449,  302,  00, -35, -171, -98,  140,  01, -282, -132, -193, -308,  276, -67,  399,  316, -46,  433, -473, -249,  333,  235, -162, -10, -208,  17, -429,  306,  370,  158, -30,  421, -40, -177,  239,  289, -423, -121, -210, -205, -401,  98,  339, -273, -117,  238, -457,  337,  171, -429, -59,  04, -342,  279, -154, -50,  148,  270,  109,  18, -72, -69,  292,  389, -394,  31,  178, -317, -238, -179,  330, -139,  419,  169,  88,  154,  259,  484, -09,  282, -93, -216,  139,  65, -437,  485, -133, -436,  255,  476,  434, -316,  260,  226, -75,  366,  109, -397, -450,  371,  276,  380,  84,  195,  50, -327, -151,  161, -343, -307, -56,  64, -23, -417, -19,  393, -432, -300,  457, -324,  29,  391, -140, -211,  470,  285, -345,  79, -260, -295,  303, -483, -62, -113, -436, -160,  412,  266, -499, -79, -189, -55, -163,  288,  28, -330, -467,  449, -129,  490, -375,  400, -266,  337, -311, -296,  474, -156, -365,  66,  402, -210,  83,  192,  178, -500, -468,  442, -382, -467,  216, -71,  331, -447,  69,  211,  76,  103,  160,  447,  93, -363, -301, -321,  474, -112,  235, -200, -416,  371,  367, -162, -339,  302, -470, -309,  302, -438, -366, -228, -52, -298,  201, -221, -245, -229, -158,  331,  374, -497, -370,  319, -08, -171,  499,  319, -431,  234, -381, -346,  457,  486,  344, -381,  289,  375,  162,  443, -211, -352, -284,  237, -150,  417, -132,  458,  40,  211, -359, -86, -434, -228,  86,  410,  453,  437,  229, -477, -477,  349,  29,  481, -313, -127, -48, -172,  100, -34, -228,  390,  115,  340,  479,  465, -391, -152, -225,  150, -89, -83, -84,  329, -459, -146,  239,  494, -209, -31, -483,  167,  170,  46, -500,  357,  420, -48, -314,  372, -230,  310,  262,  385, -498,  242, -297, -389, -58, -22, -387, -295, -253,  382, -466, -212, -264,  273, -217,  380,  94,  152,  47, -236, -301,  47, -26, -29, -149, -488, -157,  121,  322, -42,  359,  324,  52, -438, -213,  494,  392, -99,  51, -08, -217,  85,  280,  371,  210, -85,  251,  157, -432, -202,  421,  119, -303,  247, -58,  48,  259,  285,  22,  433, -257, -119,  257, -353,  295, -103, -07, -461, -350, -456,  31, -67,  481,  164,  156, -456, -421,  260,  201, -01, -90,  474, -30,  108,  222,  412,  08,  333,  198, -470,  267, -207, -89,  376, -59,  58, -227,  434,  98, -77, -169, -371, -292, -188, -355,  365, -144,  77,  125, -91, -424, -465, -116,  47,  495, -394,  311,  04, -209,  09,  34, -442, -345, -202,  435,  448,  356, -292, -266,  306,  484,  65, -212, -308, -270, -67, -91,  438, -490, -114, -152, -61,  274,  232, -162,  269, -310, -351, -227, -19, -489, -340,  40, -334,  310,  327, -34,  166, -465,  200, -27, -129,  118,  261,  64,  348,  46, -175,  286,  409,  212, -366, -152, -14, -282, -462, -245, -92,  39,  381,  390,  50, -459,  282, -432,  351,  109,  386,  369,  496,  87,  194, -132, -295,  307, -216, -95, -146,  109,  43, -237, -179,  178,  463,  307,  396, -147, -85,  157,  392, -204,  47,  295,  189,  181, -285,  392, -210, -398, -387,  138, -459,  308, -142,  98,  467,  142, -497, -179, -248,  398,  436,  425,  76, -249, -415,  325,  104,  00, -18,  349, -352, -119,  496, -311, -86,  63, -67, -444,  165,  46,  194, -442,  206, -447,  156, -474, -453, -489,  199, -201,  410,  136,  77,  338, -261,  162, -485, -304, -338,  349, -455,  162,  82, -107,  351,  496,  456,  136, -448,  474,  34,  247, -468, -259, -348, -459, -233, -301, -96,  466,  351,  166,  454, -72,  357, -306, -410,  372,  242,  104,  222, -361, -234, -196,  32, -31, -199, -12, -395,  205,  314,  139, -48, -301, -268,  456, -260,  351, -344,  496, -330, -141,  163, -24,  287,  20, -478, -271, -108,  264,  333, -34,  403, -49, -377, -65, -228,  276, -224,  229, -19, -410, -132, -214, -211,  453, -258,  381, -344,  250,  378, -174, -391,  393,  303, -252, -87,  325, -23, -343,  90,  162,  476,  345, -387, -401, -219,  237, -273,  409, -34, -440, -149,  335, -154,  493, -360,  441,  374, -204, -457, -396,  475,  05,  497,  278,  253,  262,  455,  83, -228,  397,  97, -252,  243, -437,  199, -124,  300, -222, -215, -233, -162,  136, -46,  185,  129,  94,  478,  04, -258, -127,  460, -283,  378, -190,  495,  484, -428, -197,  419,  196, -300,  16,  444,  443,  79,  495,  171, -120, -227,  456,  147,  112,  93, -47,  149, -278, -453,  479, -422, -211, -148, -109,  07, -269,  201,  354,  67, -375,  09, -14,  322,  210, -146, -382, -495,  434, -386,  177,  166,  239,  133,  165,  203,  78, -382,  204, -347, -335,  183,  83,  306, -112,  474,  165,  471, -473,  372,  38, -347, -119, -124, -173, -57,  230, -55, -51, -484,  411, -22,  182, -497, -37, -153, -442, -106, -35,  263,  47,  482,  298, -370, -359, -314, -43, -342,  09, -16, -470, -101,  489,  264,  275, -184, -293,  358, -386, -492,  374, -123, -14,  409,  232, -198, -244,  291,  196, -426,  54, -257, -92,  204,  225,  49, -257,  34,  208,  252, -481, -410, -348, -140,  354, -221, -471, -86, -363, -357, -78, -136,  372, -239, -227,  105,  63,  381, -104,  111,  455, -198, -294, -136, -142,  431,  413,  101, -34,  473, -146,  337, -436,  358, -303, -230, -363, -274,  184, -225,  221, -393,  139,  446,  220, -236,  51,  135, -355, -201, -254, -399,  453, -48,  317, -189,  235,  230, -235,  53, -444,  471, -110, -28,  329,  440,  242,  466,  18, -73,  93,  92,  386,  84,  38,  458,  348, -59,  93,  494, -408,  339, -53, -103, -209, -236, -440, -122, -154, -175,  432, -98, -204,  174,  374, -23,  114,  469, -56, -15,  248, -111, -423,  134,  474,  467,  92,  322, -92,  37, -332,  352, -124,  467, -251, -481, -269, -191, -103,  430,  487, -171,  184,  135, -496,  411, -387,  470,  380,  409, -45,  128, -202,  384,  114, -228,  351,  58, -53,  111, -405,  467, -37,  323,  435,  212,  342,  18, -126, -261, -52,  213,  421, -367, -152, -223, -456,  313, -253, -224,  222, -445,  404, -127,  439,  370,  497, -357, -72,  296,  254,  375,  264, -282,  198, -449, -218,  40,  421, -492, -369, -130,  221, -448,  355, -78,  181, -249, -265,  429,  27, -190, -164, -69, -465,  127,  153, -468,  270, -67, -319,  25, -192,  445, -405, -142, -152, -123,  398, -231, -114, -119,  491, -41,  286,  346,  381, -33, -403, -31,  248,  124, -369, -64, -93, -334, -436, -440,  50, -314,  345,  231,  211, -347, -472, -342,  11, -124,  36,  261,  498, -226, -05,  489,  233, -219, -312,  467,  248,  137, -64,  349,  114,  67, -215, -479, -415, -151, -66,  135,  36, -221,  219,  99,  285,  247, -390,  148, -24,  146, -90,  326, -228, -243, -333, -495,  38, -145,  472,  138,  493,  260, -13,  107, -173, -375,  480,  264,  326,  266, -100,  214, -102, -29,  166, -317, -282,  276, -317, -454,  274,  93,  372, -454,  350, -460, -97,  240,  247, -124, -121, -408, -12, -282,  199,  316,  195, -468,  432,  22, -350, -168, -264,  48,  303, -246, -417, -126, -470, -233, -80,  304, -288,  145,  350, -85,  185, -246, -345, -68,  482,  386,  25, -30, -43,  76,  138, -348,  460,  71, -474, -389, -245, -237, -489, -89,  369, -405, -363,  400,  214,  57,  204,  426,  54,  407, -159, -261,  13,  349, -476,  347, -413,  401, -183,  44,  329, -192,  197,  290, -269,  223, -247, -14, -162,  116, -251, -292,  211, -114, -40,  277, -204, -336,  204,  350, -77, -103, -410, -212,  98, -34, -365,  186, -133,  305, -270, -304, -387, -221, -162, -156, -145,  443, -318, -455,  60, -68, -247,  123, -330, -435, -99, -34, -270, -43, -183, -495, -294,  259, -206, -343, -275, -71,  343,  444,  86, -75, -08,  199, -443, -317, -105, -88, -374,  430, -43,  186,  214, -437,  162,  384, -372, -437, -149,  210,  372,  168, -432, -70, -73,  214,  87, -496, -05, -70, -200, -418, -292,  292, -367, -235,  475,  381, -471, -398,  311,  338, -360,  25,  401,  302, -91, -118, -283, -388, -56, -411, -368,  364,  372,  411,  78, -41,  415, -426, -258, -285, -344, -50, -140, -211, -433, -165, -330, -404,  289, -167,  434,  430,  358, -312, -416,  120,  422, -198, -416,  218,  243, -283,  83,  115, -372, -339, -73, -104,  87,  169,  463,  243, -29, -177, -115,  38,  159,  407,  134,  300, -259,  420,  230, -49, -392, -333, -77, -470, -31,  08, -399,  64, -423,  184,  32, -295,  345,  459,  453, -67,  480,  417,  28, -49, -260, -235,  489, -249, -327,  475, -448, -86,  395, -366, -283, -496, -199,  141, -114, -378,  01, -13,  187,  78, -329,  71,  283, -131,  30,  237, -346,  10, -494, -466, -187, -254, -200, -198,  350,  325, -223,  402,  91, -328, -112,  308,  28,  190,  301, -233, -336, -198,  254, -297,  380, -222,  274, -484,  499,  156, -395,  05, -334, -389,  391, -21,  209, -309, -367,  59, -132,  262,  313,  459,  435, -298,  268,  315, -256,  69, -418, -92, -276, -311,  464, -396,  319,  238, -28,  318, -105,  429,  175,  413, -108,  66,  245, -398, -390,  378, -487, -22,  141, -321, -62,  428,  233,  58, -405,  477, -21, -322,  237,  203,  219,  201, -340,  38,  292,  132, -144, -313,  414, -117, -48, -194, -199, -303,  260,  263, -72,  274, -258, -79, -195, -468,  201, -462,  442,  296, -133, -79, -174, -396, -375, -455, -342, -215,  83, -198, -231, -209,  341, -317, -474, -207, -10, -172,  343, -250, -409, -229, -124,  185, -456,  181, -431,  245,  219, -489,  393, -414, -67,  72,  43,  410,  117, -447, -305,  53, -145,  316, -304, -304, -500, -277,  341, -10,  403,  184, -408,  494, -193, -31, -468, -149,  02, -399, -52,  74, -387,  194,  160,  398, -234,  55,  308, -265,  108, -145, -360, -185, -329,  189,  363, -329,  412,  205, -487, -333,  241, -42, -339, -451, -221, -307,  252,  281,  147,  53, -145,  260, -253, -132, -490,  365,  423,  318, -48,  384,  25,  445, -301, -452,  134, -437, -280,  398, -380,  85, -435,  361, -457,  78, -238, -178, -376, -485, -44,  271,  68,  311,  383, -333, -321,  393, -468, -45, -437,  336, -161,  88,  281,  38,  136, -85,  453, -292,  165, -75, -354,  230,  139,  41, -191,  401,  364,  285,  416, -180,  56,  336, -17, -61, -497, -485,  184, -113, -30,  247, -276,  309,  187, -143,  199,  175, -375, -495, -264,  290, -70, -118,  373, -431,  423,  34, -177, -361, -181, -261,  311,  375, -72, -205,  166, -69,  162, -150, -329, -368, -403,  247,  441, -364, -396,  492,  311,  81,  497, -453,  224,  280,  281,  97,  349, -443, -369,  24, -304, -50,  264, -492,  177, -308,  155, -157,  475, -183, -455, -354,  301, -06, -255,  242,  130,  202,  234,  293, -217, -416, -307, -493,  364,  474,  104, -435, -469, -413,  90,  80,  389, -146,  440,  66,  398,  447, -239, -275, -236, -194,  224, -83, -348,  469, -341,  282,  171, -255,  76, -193, -171, -379, -186, -307, -405, -229, -241, -21,  210,  349, -89,  452,  55, -149,  370,  305, -202, -368, -118,  414,  290, -394, -169,  443, -72,  342, -423, -49, -413, -495, -390,  269, -374,  277, -186,  74, -100,  73, -95, -390,  274,  316, -438,  181, -333,  433,  338,  317, -83, -279,  231,  59,  179, -86,  354, -41, -244, -216, -237,  195, -211, -127, -36,  268, -350,  279, -158,  50,  204,  247, -487,  331,  415, -73,  364, -418,  212,  203, -249, -19,  424,  482, -459,  455, -104, -253, -85,  152,  31, -470,  199,  321, -97, -336,  89,  406, -205, -217,  308, -149, -118, -327, -318, -203,  101, -453,  231,  165, -398,  482, -353, -122, -184, -312, -167, -436,  287, -400,  216, -181, -370,  267, -360,  386,  431, -419, -356,  78,  216,  452,  430, -402, -374, -36,  247, -421,  363,  330, -404,  465, -336, -257, -157, -20,  283,  177,  44,  71, -371,  112,  390, -240, -121, -118, -02,  163, -37,  142, -259, -321,  94, -329,  129, -428,  488, -124,  03,  351,  58,  100,  317,  222, -305, -340, -298,  479, -311, -402,  402, -181,  210,  292,  431, -59, -326, -71, -396,  489, -77,  198,  20, -131, -279, -351,  294, -291,  377, -203, -439, -65, -251,  378,  09, -55, -110,  211,  276,  80, -339,  178, -249, -277,  322, -318,  164, -152,  463, -379,  189, -114,  319, -291,  255, -108,  210,  49,  102,  439, -301,  163,  226,  300,  393, -265,  97, -217, -202, -127, -285, -41, -97, -34, -466, -275, -500,  198,  425,  463, -329,  114,  201, -158, -325,  309,  235,  385,  210,  189, -324, -239, -148,  402, -438,  97, -11,  159, -268,  287, -115, -52,  98,  288, -234,  132, -134, -233,  183,  143,  82,  354, -242,  136,  49, -67,  297, -216,  171,  07,  473, -301, -379,  177, -398, -317,  126,  443, -306,  358, -417,  431,  158,  181,  220,  425,  166, -62,  44,  201, -419, -374,  407,  191, -386, -44, -23,  411,  240, -352,  271, -435, -153,  392, -406,  301, -73,  220,  245,  121,  79, -320,  53, -263, -287,  125,  14,  379, -85, -442,  80,  348,  37, -12,  40,  151, -204, -483,  415, -111,  17,  186, -46, -284,  78,  401, -130, -143,  121, -33, -170,  52,  147,  383, -358,  360,  360, -492, -408,  127, -433,  172, -24,  104,  12, -132,  107,  309,  237,  22,  50,  106,  60, -144,  322, -362, -243, -308,  347, -269, -489, -322, -365,  158, -87,  129,  19, -226,  138,  111, -247,  205,  135,  229,  161,  00, -51,  120,  161, -314, -357, -289,  292,  203,  67,  467, -306, -323,  11, -459, -92,  23,  71,  43, -319,  485, -327, -448, -241,  311, -485,  12,  368, -497,  94,  381,  03, -457,  01,  16,  82,  496,  227,  226,  200,  146,  193, -254,  323,  57,  139,  83, -420, -289, -373,  113, -304,  152, -482,  307, -37, -467,  171,  183, -464,  117,  64,  391,  161, -435, -93,  95, -438, -14, -179, -386, -367, -133,  212, -192, -224,  203,  392, -144,  414, -129, -179, -38, -477, -161, -231,  338, -127,  441,  21,  261,  58, -63,  153,  71,  02, -440,  18,  416,  47, -308, -118, -468,  59, -54, -160,  335, -350,  84,  43, -84,  455, -284,  379,  478,  56, -352,  316, -219, -59,  189, -106, -148, -374, -453, -225,  481, -40,  294, -251, -493,  486,  484, -109,  397, -70, -417, -416,  80,  168,  479,  497,  475, -305, -272,  454,  251, -124, -378, -116, -330, -336,  279,  22, -210,  326, -351, -229,  138,  443,  373,  145, -219,  357, -112,  30, -213, -28,  114, -280, -08,  93,  69, -33,  289,  297,  273,  392,  25, -252,  129, -453, -88, -92,  421, -446,  86, -429,  178, -275, -134,  51, -278,  148, -92,  463, -322, -453,  287, -355,  119, -221,  238,  40, -402,  379,  189, -276, -376, -285,  324,  253, -238, -264,  13, -316,  142, -49,  107, -180, -472,  473,  371,  103,  473,  131,  66, -348,  179, -147,  149,  150,  484,  239, -309, -418,  471,  380,  158, -405, -53, -18, -300, -438, -430, -435,  98,  213,  16, -295, -467,  397, -322,  405,  00, -348,  36, -82,  156,  67,  271, -195, -282, -393, -456, -91,  41, -485,  141, -300, -38, -411,  182, -486, -349,  253, -421,  249, -34,  448,  454, -01,  345, -16,  256, -155,  136,  145, -385,  144,  64, -262,  449,  282, -155, -154,  43,  386,  213, -315, -414,  28, -226, -379,  42, -75,  374,  122, -326,  192,  70, -20,  43,  267,  464, -200, -36,  453, -203,  79,  97,  361,  317,  399,  144, -338,  97,  39, -452,  162,  224, -13, -310, -150,  108, -415, -373,  334, -441,  153,  26,  481, -367, -431,  248, -402, -131, -288, -449, -482,  291, -500,  380,  460,  399,  376, -26, -04, -85,  22, -341, -08, -139,  201, -306,  469,  286, -178,  303,  345,  475,  181,  326, -391,  251,  74,  59, -28, -362,  462, -09, -219,  462, -129, -259,  362,  99,  215,  210, -486,  90,  369,  358,  451,  71, -447, -227,  209, -125, -72,  55,  202, -390, -119, -337,  361, -192,  222, -167, -54, -464, -324,  228, -149,  399,  469,  65, -02,  185, -225,  365,  127, -03,  223,  430, -80, -372, -297, -371,  03,  132,  184,  58, -406, -434,  221,  455, -126, -56,  140, -328,  332,  317,  400, -317,  216,  370,  248,  67,  407, -476, -68,  386,  373, -345,  316, -207, -216, -480, -78, -361, -496, -393,  197, -402,  25, -81, -95, -249, -285, -455, -77, -101, -286,  176,  83, -217,  46,  183,  350,  305, -441, -218,  191,  432,  289,  07,  77, -75,  379, -500,  417, -265, -41,  466, -167, -164,  237,  238,  439, -196, -364,  214,  204,  202, -110,  139,  485, -212, -178, -313, -407,  234,  321, -364,  166,  463,  496, -256, -112,  375,  96,  157, -389, -93,  124,  296,  243, -139,  387,  182,  166, -477,  248,  222, -423, -361, -139, -85, -73, -465,  102,  373, -379, -76, -491, -360, -113, -495,  236, -373, -267, -168,  285,  196,  239,  261, -08,  334, -378, -121,  368, -360,  254,  116, -286,  332, -393,  75, -253,  35,  463, -299,  260, -416,  477,  269, -276,  216, -373, -188,  344,  212,  144,  481, -92,  235,  242,  400,  69,  364, -220,  289, -143, -114,  258,  71,  70,  365, -01,  317,  252,  314, -129,  12, -250, -152,  134,  327, -435,  261, -361, -239,  325,  284, -258, -267,  371,  484, -367,  293, -300,  265,  82,  409, -348, -160, -19,  222,  58, -168,  392, -190, -354, -237,  323, -104,  463, -43,  75, -120,  70,  215,  141, -105,  351, -265,  128,  222,  71, -387,  367,  272,  379, -50, -467, -469, -358,  366, -395,  200, -302, -151, -489, -156,  464, -314, -407,  428,  495,  168, -192,  65,  235, -198, -188,  86,  37, -208,  161, -39, -95,  28,  85, -216, -170,  118,  167,  325, -15, -375,  25,  183, -26,  388, -120, -61, -74,  325,  219, -79,  345, -121,  486,  81,  181,  150,  19,  71,  442,  32, -468, -152, -439,  117,  484,  243,  87, -496,  68, -428, -371, -54, -392,  103,  186, -12, -106, -387,  165, -387,  34,  362, -07,  373,  295, -326,  23, -185, -403,  318,  347, -19, -334, -240, -50,  02, -496, -462,  06,  424, -390,  135, -130,  70,  91, -443, -90,  485, -330, -425, -401, -444,  438,  92,  429,  233, -382,  305, -100,  68,  123,  100, -451,  289, -288,  352, -209, -284,  390, -350, -07, -148,  285,  363,  423, -124, -228, -167,  214,  294, -91,  313,  351,  199,  257,  280,  284, -273,  85,  37,  295, -292, -363, -303, -151, -151, -451,  493,  418,  439, -357, -89,  143, -220,  126,  66, -491,  399,  400,  223,  193,  161,  36,  44,  212,  145,  177, -04,  372,  114, -467, -480, -325,  22, -283,  376,  372, -234, -279, -358,  57, -136,  53, -300,  497, -321, -381, -494, -70, -481,  229, -24, -468,  117, -480,  244, -238, -451,  92, -14,  164,  478,  06, -309,  00, -425, -433,  224, -159, -211,  366, -250, -495,  271,  303, -498, -197,  422, -140,  233, -207, -59, -291,  177, -442,  82,  273,  172,  483,  217,  11,  499,  195, -483, -310,  48, -407,  110, -228,  286,  399, -09, -111, -244, -238,  44,  111,  65,  318, -177,  151, -37,  265, -288, -360, -325, -354, -235,  348, -370,  482,  211, -371, -470,  228,  172,  78, -327, -218, -298, -188,  33,  193,  201, -359, -192, -255,  252, -275, -437, -424, -272,  26, -307, -59, -482, -132,  439, -217,  68, -431,  117, -221,  51,  147, -492, -277, -275,  33,  357,  280,  345,  242,  325,  398,  383, -15, -357,  136,  211,  58, -436, -209, -64, -243, -416,  306,  125, -476, -59, -306, -55, -441, -27,  496,  206,  333,  71, -216,  219,  280, -436,  64,  22, -259, -37, -94,  227,  458, -106,  290,  369, -42, -419,  157, -433, -334,  316, -456,  42, -243,  90,  487, -184, -436, -164, -125, -251,  407,  159,  468,  188, -425,  385,  62,  168, -152,  468, -105,  158, -138, -315,  27, -328,  119,  37, -261, -363, -147, -216,  179,  110,  374,  166, -221, -210, -498,  154,  392, -238,  165, -288, -198, -408, -403,  364,  260,  297, -315,  08, -44,  47, -455, -165,  220,  164,  372, -189,  301, -275,  447,  332, -312, -326, -01, -33,  316,  353, -27,  208, -33, -362, -227, -379, -270, -130, -162, -158, -332,  23,  350,  124, -430,  396,  459, -358,  412, -316,  306, -434,  261,  253,  398,  449, -221,  249,  268, -404,  455, -259, -344, -78,  231, -71,  396, -187,  300, -266,  156, -180,  257,  358,  444, -321,  254, -245, -178, -481,  291, -20, -415,  53, -267,  483,  354,  13,  233,  123,  461,  188, -284, -383, -38,  448,  399, -142,  113,  199,  92, -231, -129,  201, -20, -185,  381,  86,  422,  55,  105,  214, -465,  190,  119,  120, -474, -27, -15,  259, -404, -54,  299,  165,  416,  113,  465,  315,  472,  78,  366,  416, -300, -263,  118,  180,  404,  351,  118,  326, -94, -276,  392,  293,  414,  11, -87,  440,  485,  399, -449, -67,  197, -298, -50,  113,  316, -85,  280,  288, -154,  146, -444,  46,  383,  174,  78,  287,  377, -304,  466, -217,  272,  358, -72,  187,  222,  342,  479,  207, -407, -117, -08,  290,  85,  443,  256, -99, -142,  36,  41, -444,  35,  98,  102,  270,  124,  32,  410,  354, -419,  376, -11,  353, -414,  418,  392,  308, -388,  372,  367, -295,  107,  212, -153,  44,  155, -45, -202, -135,  492,  339, -78,  379,  289, -124,  149,  266,  409,  59,  120, -158,  287, -39, -305,  374, -121, -412, -466, -09, -188, -246, -452, -229,  466, -104,  315,  121,  351, -387, -162, -305, -195, -388, -426, -54, -11, -424, -288,  250,  135, -316, -408, -77,  146, -213,  149, -123,  227,  183,  369, -461, -211,  417, -190, -245,  165, -22, -272,  17,  91,  67, -436,  396,  179, -09, -157,  20,  67,  407, -230,  54, -56, -138, -171, -58, -498,  478,  319, -419, -486, -460, -27, -197,  458, -365,  411,  475,  113, -361,  344, -295, -442,  409, -47, -410,  252, -352,  462,  171, -444, -267, -275,  352,  447,  407, -206, -199,  385, -387, -117, -249,  06,  356,  407, -36,  491,  318,  291,  105, -191,  136, -338,  220,  45,  467, -338,  149, -384, -376, -180,  24,  209,  45, -124,  157,  304,  170, -190,  190, -365,  193, -207,  141,  401,  52, -43,  393,  222, -251,  350, -468, -263, -136, -396,  282, -169, -234,  283, -53, -110, -397, -177, -400, -500,  199, -391,  305,  221, -81,  347, -291, -35, -360,  350, -134,  193,  160,  111,  267, -239, -39,  299, -02,  325, -245,  132,  09,  21, -85,  456, -236,  18,  132,  216,  18, -169, -323, -177, -95,  96, -330,  114, -87,  163,  316,  280,  208, -24, -109, -25, -411, -295,  127,  87, -118,  382, -281,  391,  256,  486, -300, -480,  04,  332, -412, -125, -337, -235,  198,  68, -287, -279,  34,  127, -264, -149, -93,  444,  327, -350, -81,  417, -145, -102,  356,  238, -219, -72,  129, -463, -86,  329, -91,  419,  161, -03,  146, -323,  262,  196, -403,  475,  417,  132,  102, -347,  483, -139, -51, -338,  12, -279, -69,  367,  119, -212,  457, -248,  216,  87, -211, -370,  268,  198, -99,  282, -305, -453, -189, -191,  244, -92, -215, -487, -108, -261,  19,  227,  101,  468,  390, -35,  41, -179, -168, -339,  461,  142, -87,  177, -271, -445, -340, -151, -395,  413, -369,  153,  461, -58,  462, -443, -297,  99, -78,  95, -309,  441,  175,  292, -238,  65,  109,  303, -262, -207, -184,  52,  435, -418, -271, -336, -363,  241,  366, -258,  155,  497, -253,  468,  292, -290, -475, -153, -339, -53, -206, -148,  241,  469, -04, -497,  34, -395, -342, -375, -101, -25,  177, -166,  409, -242,  351, -454, -500,  217,  140, -493, -434, -260,  475, -290, -50, -148,  57,  111, -349,  352, -184,  392,  321,  312, -253,  208,  418,  258, -315,  169,  85,  362, -497, -06, -28, -294,  392,  324, -225,  384,  331, -158, -376, -342,  404,  426,  10, -38,  390,  162,  166, -294,  406, -13, -482,  06,  47, -212, -236,  232,  457, -299,  446, -187,  195,  271,  19,  439,  95,  295,  323, -73, -11, -200,  85, -107, -274, -52, -293, -384, -38,  373,  174, -132,  213,  193, -274,  112, -167, -10,  197,  143,  191,  495,  456,  238,  266,  327,  177, -138,  474,  353,  289,  315, -347,  226,  61, -121, -326,  268,  348,  136,  494,  22, -143,  207,  67,  83,  171, -247, -74, -132,  396, -31, -136, -296,  60, -370, -117,  89, -08, -142, -58,  133, -327,  95,  212, -414, -173,  386,  355,  27,  375,  349, -451,  84,  408,  469,  19,  79, -278, -203, -200, -30, -381,  164,  174,  179,  294, -443, -232,  139,  267, -437,  124, -207,  158, -164, -121, -163,  75,  86,  364,  302,  287, -234, -114,  195, -265,  405,  127,  309,  55,  427, -221,  174,  91, -195,  205,  237,  214,  473,  228, -18, -464, -147,  275, -453,  189, -346,  236,  116, -407,  101, -82,  380, -281,  304,  76,  306, -438,  55,  115,  117, -18, -254,  143, -75,  403, -152,  14,  117,  173, -257, -401, -438,  448, -274, -39,  489,  233, -303,  106,  326,  298, -476,  206, -131, -319,  134, -325, -257, -311, -358, -288, -477,  240, -293,  300,  143,  55, -185, -239,  80,  410,  212,  142, -290,  439, -397, -301,  172, -199, -343, -02, -49, -318,  56, -327,  215, -309, -152,  458,  232, -09,  22, -392, -269, -419,  408, -273,  488,  75, -12,  68,  337, -300, -289, -453, -361,  166,  99, -337, -181,  256, -487, -377, -210,  70, -204, -495, -387,  144, -185, -303, -13, -311, -195, -429, -230, -286, -202, -242, -359, -362,  327,  479,  190, -110, -122, -318, -92, -171, -155,  228, -414,  211, -297,  228, -219, -01, -414,  246, -05, -99,  443, -165,  443,  101,  258, -287, -333, -92,  324, -192,  46,  151,  139, -264, -107, -130, -82, -347,  199, -384,  381, -363,  327, -64,  366, -40,  435,  452,  58,  283,  205,  01, -382,  148, -46,  376, -286,  121, -216, -462, -218, -318,  189,  421,  270, -66, -209,  41,  87, -157,  157,  321, -20,  336, -243, -154, -204,  45,  150,  354, -172,  208,  207,  298, -144,  14,  174,  422, -365, -190,  460, -83, -08, -499,  191, -238, -65, -166, -345, -125,  177,  312,  48,  10,  148, -343,  356, -204,  202,  359,  02, -118,  67,  62, -320, -225, -424,  354, -302,  63,  16, -342, -167, -492,  12, -476,  123,  447,  210,  278,  174,  240,  443, -278, -250,  443, -120, -42,  92, -66, -183, -406,  317, -264, -492,  497,  364, -416, -296, -86, -500,  220,  424, -167, -419, -64,  209, -444,  236, -81, -314, -90, -341, -371,  485,  261, -75,  217, -280, -483, -349,  389, -37,  468, -22, -28, -182, -158,  408,  22, -392,  408,  94, -468,  93,  175,  321, -198, -417,  57,  222, -230, -181, -267,  251,  156,  495,  28, -127, -285,  45,  25, -44, -139,  345,  434, -315, -337, -224, -55,  185,  236,  206, -220,  269, -201, -193,  442,  102, -109,  351,  176, -487,  22, -239,  264, -321, -244, -207,  52,  323, -310, -71, -220,  51, -225,  66, -412, -62,  343,  34, -24,  431, -260, -392,  200,  39, -85,  494, -07, -342,  345, -331, -329, -132, -69,  436,  399, -461,  81, -49, -285,  271, -267, -05,  175,  08, -439, -385, -202, -244,  149,  274, -312, -259,  382, -260, -367, -202,  87,  126,  308, -68, -352,  480, -348,  79, -232, -449,  470,  349,  355, -315,  472, -412, -468,  147,  448, -54, -385, -254, -446,  264, -479,  94, -142,  403, -313, -09,  53,  274, -383, -138,  58,  117,  194, -437, -304,  462, -34,  19,  311, -179,  204,  283,  261,  237,  283,  209,  35,  398,  456,  89, -486, -171, -316, -128,  84, -129, -285, -10, -03,  185, -296, -445, -198,  398, -30,  351,  360,  437, -130, -477, -242, -74,  306, -128,  15,  441, -67, -450, -309,  241,  492,  58, -430, -324, -218, -493,  399, -02, -03,  248, -317,  201, -345,  337,  99,  126,  188,  311,  63, -442,  334, -327, -15,  492,  397, -148,  434, -169, -97, -23, -428, -105, -113, -05,  423,  170,  02, -326,  20,  499,  422, -445, -448, -71,  392,  151, -445,  81, -38,  118,  491,  148, -356,  328,  140, -459, -319,  426, -128,  84, -96,  297, -169, -357, -208,  106,  313, -354,  280, -167, -03, -446, -112,  49, -17, -219,  52,  39, -286, -134,  09, -295, -486,  153, -114,  154, -453,  67,  81, -81,  03, -163,  68, -314, -20, -288,  292,  146, -142,  72, -169,  355,  478, -428,  256, -39,  205, -192, -500,  419, -474,  362, -24, -460,  367,  362, -453,  414,  281,  480,  186,  136,  169, -246,  322,  01,  319,  114, -353, -323,  38,  331, -115,  16,  403, -359,  478,  108,  302, -170,  379,  328,  44,  207, -279, -88,  70,  120,  178,  203,  100, -136, -160, -231,  471, -338, -378,  290, -371,  122,  467,  167, -47,  204, -316,  208, -302,  14,  168, -148, -304,  47,  32,  241, -246,  253, -347, -324, -127,  331, -268, -175,  48,  72,  446,  19, -414, -431,  161, -285, -457,  480, -265, -04,  185,  271, -296, -265, -215, -276,  87,  333,  271, -381,  74, -123,  373, -421,  406,  98, -237, -10, -224,  311, -438, -278,  182,  00,  143,  195, -432,  186,  175, -197,  34,  212, -426,  238,  447,  211, -186,  34,  44, -415,  154, -381,  315,  379,  50, -427,  329,  313,  63, -395,  476,  477,  180, -490, -23, -177,  205,  45, -138, -119, -300,  396, -407, -226,  487, -107,  485, -199,  427,  382,  239,  433, -147,  406, -336,  403,  479,  494, -431,  394, -401, -455,  371, -369, -444,  200, -45,  261,  98, -331, -06,  298, -435,  440, -427, -96, -167, -90,  206,  112,  144, -55,  46,  497, -149, -438, -247,  182, -444, -178,  76,  08, -133,  299,  139,  275, -01, -54,  389, -403,  115, -117,  396, -467,  175, -179, -63, -492,  231, -05,  473, -124,  440,  371,  225,  143,  433,  478,  177,  490, -200, -247,  350, -480, -448, -11,  295,  52, -212, -464, -499, -245, -80,  397,  140, -405, -282, -422, -44, -198,  73, -71, -470,  366, -200, -393,  361, -267, -414,  39,  75,  238,  292, -75,  258, -303, -233,  406, -399,  55,  442, -398, -338,  214, -148,  303, -338,  422, -267,  470,  76,  306, -101,  458, -476, -449, -434,  386,  136,  04,  277, -288, -258,  421,  489, -147, -382, -244,  111,  71, -337,  405,  174,  178,  120, -122, -19, -366, -200,  214, -396, -271,  372,  355, -313, -251, -242, -247, -13,  394,  257, -236, -42, -148, -315, -52,  205,  156, -444,  168, -273,  72,  73, -247,  102,  45,  483, -417,  179, -216, -351, -365,  13, -127, -158,  200,  122,  100, -194, -39, -05, -85,  225,  453,  267, -237,  253,  324, -229, -338, -08,  350, -414, -434, -396,  188,  463, -413, -377,  143,  223,  124, -370,  88,  497, -27,  141,  472, -427,  447, -67,  420, -138,  11, -274, -18,  274, -169, -194, -455, -07,  299, -253,  431, -283, -149,  471, -320,  291, -406, -325,  366,  218, -194, -45,  216, -369, -404, -460,  56, -105, -27, -23, -391,  484, -445,  91, -390, -114,  398,  07, -268,  197,  255,  15, -234, -42, -13, -54, -251,  81,  122, -384,  152, -220,  423,  220, -89, -129,  260,  467,  266, -267,  296,  375,  70, -297, -33,  180,  90,  217, -312, -326,  266, -205,  189, -468,  253, -324, -22, -497, -390, -400, -29,  262, -120,  246, -18, -357, -383, -258, -37,  383,  327,  111, -390,  249,  315,  429, -70, -95,  146,  470,  431, -88, -235,  120, -56, -130, -351,  423, -127, -241, -125, -304, -479, -392, -206,  355, -249, -89, -51, -434,  146,  128,  178,  257, -122, -07,  186, -340, -250, -167, -18, -319, -403, -401,  301,  42, -31, -198,  317, -305,  61,  44,  243,  434,  152, -462,  289, -244, -51,  90, -178, -404, -281, -500,  353,  97, -07,  391, -391, -405,  76,  91, -224,  174, -458, -70,  68,  11,  232, -115,  206,  146, -219, -50,  80,  434, -12, -130, -310, -211,  460,  364, -115,  31,  365,  90, -20,  210, -18,  89,  306, -90,  32, -418, -416,  74,  364, -496, -62,  97, -111, -356,  95,  171,  446, -325,  457,  286,  397, -01, -424, -290, -137, -39,  241, -272, -96, -278, -209, -262, -337, -403,  148, -452,  31, -415,  122, -104, -411, -88, -155,  331,  57,  440,  354,  355, -33,  311,  142, -135, -190,  218,  75, -475, -321,  168,  106,  435, -258,  397, -327, -94,  494,  322, -46,  377,  407, -72,  125,  496, -307,  470,  327,  250, -238,  181,  105,  230,  344,  99, -53,  06, -183, -478,  32,  349, -458, -362,  284, -215, -465,  458,  191, -119,  280, -03, -242, -461, -223,  384, -113, -30, -294,  67,  72,  321,  100,  30,  403, -55, -371, -150,  451, -53,  224,  335,  148, -382,  473, -68, -97, -140, -110, -54,  241,  22, -205, -148,  413,  425,  88, -199,  247,  294,  368, -180,  467, -32, -298, -278, -235, -169,  424, -283, -370,  148, -96, -370, -381, -122,  63,  22,  238, -195,  469,  332,  328, -236, -316,  241, -311,  272, -106,  437,  418, -238,  109, -262, -417,  311, -40, -152, -06, -115,  417,  477, -115, -178, -393,  04,  200, -478, -473,  290, -172, -152,  122,  08,  464, -342,  101,  06, -218,  496, -57, -299,  110, -96,  291,  193,  67, -249, -458, -87,  136,  459,  242, -126,  133,  350,  378, -167, -276, -243, -24,  404,  105, -402, -88,  70, -243, -134, -72,  39, -138,  371, -408, -176,  127,  383, -482,  46, -13, -88,  459, -377,  223,  202, -03, -143,  404,  228,  190, -372,  485, -334, -467,  443,  117,  297,  365, -274, -337, -207, -383,  377,  16,  62, -298, -05, -55, -280, -459,  432,  484, -500, -92,  207, -446, -243, -436,  458,  485,  255, -61, -177, -227,  324,  118, -258,  121, -17, -32, -363, -372,  438, -486,  144,  00,  68, -361,  445, -360, -320, -270, -376,  32,  490,  332,  87, -253,  396,  45,  85,  151, -164, -240, -223, -340,  378,  19, -366,  213, -160, -229,  341, -222,  137, -15,  278, -294,  476, -425, -154, -344, -195, -29,  188,  147, -197, -225,  395,  51, -327,  332, -297,  09, -408,  332, -478,  470,  203, -344,  183, -457,  279,  24,  173,  268, -139,  303,  474, -163,  379,  173,  345,  36, -04,  33, -316, -349, -339, -69,  202,  186, -237, -243, -305, -145, -59, -283,  177, -355,  225,  212,  40,  04, -264, -286,  125,  449, -483,  99, -214, -252,  124, -17,  285, -28, -132, -179,  475,  29,  252,  178,  67, -485, -213, -385,  222,  229,  184, -101,  374, -90, -389,  266, -234,  199, -168,  391,  148,  202,  343, -214,  450,  319,  269, -413, -208, -363, -92, -233, -481, -340, -203,  438,  27,  85, -447, -251, -186,  238,  148,  40, -352, -389,  158,  266,  310,  491,  158,  310, -455,  353, -404,  495,  172, -283, -65, -184,  207,  343,  436, -422, -144, -267, -484, -265, -330, -430, -15,  336, -340, -15,  228, -192,  97, -113, -74, -93,  230, -64,  70,  275, -211, -482, -378, -186, -264,  57,  130, -205,  253,  418, -127, -39, -348,  241,  196, -178, -337,  33, -341, -177, -481,  387,  483,  116,  126,  262, -125, -144, -302, -203, -17, -12, -184,  106, -346,  52,  15, -364, -301, -232, -445,  424, -419, -293,  165,  278,  381, -319, -189, -108,  356,  182,  132,  340,  150, -242,  454, -122,  467, -348,  175, -50,  492,  491, -92, -354,  395,  424, -217, -406,  44, -162, -482,  126,  397, -464,  256,  278, -283, -433,  23, -75, -398, -345,  117,  252,  265,  71, -18,  232,  224, -342,  35,  216,  01,  443, -285, -103,  367, -02,  343, -88, -312, -286, -462, -415, -250,  294, -285,  319, -287,  238, -256,  167, -255,  362,  272, -489, -67, -246, -405, -343, -88,  130, -274, -234,  74, -59,  163,  293, -209,  358, -295, -21, -428,  95,  416, -178,  241, -369, -359, -193, -278,  238,  474, -33,  100,  246,  330, -467, -499,  426,  43,  265,  56, -379, -469, -18,  414, -454, -224, -295,  405,  333, -464,  477, -71, -196,  152,  22, -65,  293,  329, -491,  383,  304,  329, -17,  50,  159,  369,  403,  85,  264,  169, -358,  385, -448,  476, -349, -401, -248,  208, -496, -62,  244, -167,  367, -100,  485,  241, -313, -369,  71, -303, -486, -125, -474, -02, -223,  185,  219,  33, -229, -17,  54,  265,  220,  106, -407,  371, -443, -154,  431, -439,  284, -473,  247, -497, -73,  232,  244,  114,  363,  167,  311,  378, -106, -311,  228,  172, -273, -53,  57,  350,  430, -389,  115, -498, -431, -440, -275, -373, -94, -344,  40,  42, -317, -213,  397,  110, -480,  494,  76,  383,  161,  240, -387, -444,  429,  341, -420, -344, -212,  489, -494,  70, -400,  473,  424,  21, -466, -351,  148,  292, -195, -311,  187,  340, -24,  84,  302,  348,  430, -121,  232,  444, -381,  345, -500, -100, -461, -68,  409, -173, -79,  415, -250,  373, -259, -326, -106, -225, -176, -457, -81,  481,  84, -394, -326, -440, -457,  476,  409,  473,  207,  493,  417, -322, -310, -231,  431, -271, -447,  340,  409, -26,  255, -341, -153, -152, -167,  242,  123, -491, -363, -457,  491,  221,  01,  17, -367,  396, -07, -106, -278,  53,  239, -09,  231,  430,  261, -486,  11,  314,  354, -80,  141,  110,  431,  488,  458, -235, -418,  434,  126,  71, -171,  469,  144, -318, -14,  278, -421,  480,  24, -199,  385, -236,  292,  468,  46,  405,  483, -443,  220,  337,  330, -139,  299,  261,  201, -390, -122, -364, -104, -495,  207,  225,  474, -148, -241, -39, -18, -162,  293, -494,  139, -470,  122,  284,  498,  20,  189,  481,  78, -91, -329,  260, -378,  470,  373, -324, -68, -248, -188,  328,  109, -129,  405,  83,  223, -335, -104,  57,  03,  41,  416, -05,  71,  38, -221,  422, -441,  468, -245,  489,  230, -74, -399,  352,  249,  474, -120, -319, -274,  192, -138,  335, -436, -233,  271, -361,  284,  19,  197, -212, -439,  113, -365,  484,  03,  266,  406,  414,  234, -338,  403,  316,  440, -144, -479,  189, -169, -99, -277,  409, -406,  85, -403,  10,  352,  368,  149,  137,  239,  198, -223, -348,  163,  264, -363, -333,  30, -105, -419,  116,  57, -163, -67, -02,  193, -46,  39, -124,  355,  262, -214, -199, -153, -117, -337,  52,  103, -335, -311, -158,  363,  318, -05,  27,  434,  484, -454, -36, -121, -21, -420, -211,  316,  365,  287,  362, -181, -174, -262,  27, -411,  376, -320,  288, -241, -156, -160, -286,  361,  381,  409, -424,  199, -96,  455,  485,  240, -499, -51, -381, -19,  382, -92,  149, -401,  47,  11, -81, -274, -398, -202,  167,  478,  330, -45,  90, -326,  296,  304, -113, -471,  213, -36, -419, -31, -81, -434, -291,  273,  16,  181, -246,  250, -59,  403,  349,  489,  267,  120, -285, -279,  418, -266, -301,  249,  189, -359, -225,  337, -202, -485,  367, -137, -21, -200, -315, -250, -134,  246, -477, -266, -73, -223,  484,  369,  33, -314, -290,  152,  306,  277,  373, -423, -489, -76, -322, -448,  66,  305, -258, -284,  320, -39,  79,  151,  261,  264,  402, -373,  11,  425, -138, -210,  55,  198,  11, -60,  384,  221, -408, -457,  350, -183, -28, -287,  241, -498, -234,  159,  307,  360,  375,  480, -179,  307,  131, -66,  423,  385,  413,  286,  311,  127, -423,  218, -174,  440, -342,  62,  162, -250,  457,  364,  67, -71, -422,  160, -69,  196, -180,  91,  56,  47,  71, -271,  206,  54, -485,  130,  292,  428, -84,  103,  56,  345, -179, -266,  286,  331,  296,  300, -419, -394,  164, -500,  35, -406,  160, -181,  290, -168,  410,  198,  380,  333, -221,  86,  239, -206, -284,  31, -277,  485, -14, -369,  330, -341, -135,  116,  490,  13,  268, -77,  119, -67, -77,  07,  27, -416,  326,  170, -84, -412, -132,  148, -227,  148, -265, -488,  442,  303,  396,  17,  288, -118,  148,  471,  394, -135,  439,  384,  379,  208, -192, -02, -359, -417, -495, -480,  19, -317,  190,  436, -229, -89,  436,  44, -89,  23,  409, -147, -173, -343, -277, -33,  391,  371,  290,  285, -263,  230, -478, -32, -62,  182,  466,  431,  265, -176, -197, -215,  07, -154,  73, -369,  257,  361, -473, -332, -115,  436,  373,  212, -55, -52,  31, -163,  172, -178, -378,  409, -448, -04,  229,  342, -322, -453, -375, -204, -129, -72,  433, -269,  274,  06,  214,  383,  219,  241, -97, -396, -470,  129, -332, -25, -423,  200,  312,  249, -126, -213, -490,  278,  283,  239,  120,  462,  287,  245, -242,  10,  25, -309, -407, -200, -451,  307,  35,  268,  49, -209,  373,  79,  420, -107, -446, -151, -407, -281, -401,  319,  06, -39,  97, -211,  53, -283, -249,  192, -186,  361,  54,  340, -96,  148, -08, -47, -45, -473,  74, -144, -182,  299,  435,  90, -308, -158,  440,  138,  61, -109, -43, -433, -296, -445, -144,  257,  124,  460,  301,  439, -327, -144, -369,  78, -496,  123, -117,  311,  150,  457, -332, -179, -392, -45, -237, -199,  297,  55, -209,  210, -202, -400, -371,  03,  07, -14,  112, -368,  298, -86, -77,  471,  270,  54,  49, -374, -323, -215,  437, -321, -258, -395,  352,  203,  413, -32, -144, -438, -477,  147,  273, -178,  247,  402, -323, -245,  240,  289,  239,  390, -297, -338, -286, -175, -432,  263, -49,  97, -100,  241, -372,  143, -302, -167,  198, -389,  301, -446, -326, -324,  201, -201, -02,  300,  53,  175, -93,  146, -35, -02,  36, -480, -488,  250,  198, -420,  366,  01, -471, -234, -258, -342, -239, -59,  343,  459,  52,  144, -487, -422,  320, -434,  229,  171, -281, -217, -154,  126,  429, -337, -375,  317,  36, -363,  68, -266,  70,  286,  235,  99, -448, -170, -391,  166,  271,  452,  125,  175,  448,  491,  254,  269, -91,  335, -60,  128, -382, -362, -245, -101,  154,  232, -283, -310, -279, -363,  276, -357,  423,  363,  243, -173, -307, -296,  493, -184, -343,  471,  492, -43,  462, -402, -274, -129,  433, -482, -500, -96,  09,  107,  303,  15,  191, -480, -443, -236, -343,  333, -92, -420, -452,  03,  260,  94,  207,  253,  410, -284,  224,  402,  174, -462, -148, -248,  262, -214,  123, -386, -458, -368, -427,  345,  147,  264,  366,  204, -472, -125,  389,  288,  308,  437, -209,  68,  383, -149, -179,  294,  67, -102, -452,  93, -64, -99,  346, -302, -461, -31,  164, -419,  453,  237,  426,  452,  01, -356,  156,  382,  20,  397, -478, -172, -314, -186,  396, -430, -483,  69,  364,  436,  467,  412,  30,  256,  165,  228, -194,  204,  49,  471,  285,  02,  208, -436,  306,  62, -292, -38,  296, -420,  211,  318,  260,  397, -16, -492, -181,  353,  78, -317,  290,  397, -52,  172, -495, -387, -100, -188, -330,  449,  135, -193,  303,  195, -129,  109,  109,  432, -77,  257, -136, -366,  428, -375, -117,  264, -367,  203,  118, -437, -262, -92, -187, -462, -420, -182,  04,  332,  482,  174, -367,  469, -167,  436,  165, -443,  45,  126,  489, -180, -116,  205,  306, -188,  330, -311, -424, -184, -256,  194,  231,  335, -46, -456,  373,  386, -137, -123,  218,  197, -449,  351,  167, -115, -361, -168, -58, -464, -190,  283, -144,  194, -12,  14, -494,  171,  204, -65, -161, -200, -19, -430, -365,  436, -385, -491, -326,  330, -114,  393,  27,  290, -404, -306,  27,  88,  378, -179,  124, -311, -44, -167,  383, -204,  347, -258,  467,  403,  177,  158, -296, -342,  229,  191, -54, -304,  200,  121, -474, -61,  366,  405,  81, -186, -48, -392,  402, -170,  281,  379,  371, -263,  64, -393,  33, -89, -151,  353,  167, -122,  11, -277,  388, -260,  414,  187,  288,  467, -192, -334, -94,  26, -428, -161,  340,  24, -53, -405, -294, -272, -174, -422,  317,  390,  37, -150,  153,  386, -297, -180,  116,  215,  395,  356, -193, -338,  43, -404, -371, -297, -238,  387,  229,  186, -274,  422,  62, -475, -131,  269,  105,  195, -301, -78,  85,  236,  272,  90,  474, -172,  411,  442, -105, -342,  298,  202, -180,  194, -350, -51,  397,  265,  188,  479, -49,  414, -247, -486, -209,  122, -365,  396,  169,  186,  170, -246, -78,  295,  344,  248, -377, -393,  190,  18, -234,  340,  72,  438,  34,  223,  240,  284, -12, -72,  263, -209,  195, -132,  157,  486,  490,  292, -265, -489,  330, -243, -235, -248, -448, -39, -148,  27,  421, -106, -103,  39, -265,  470, -23,  269, -455, -283,  405,  385,  146, -480, -324,  193, -112,  334,  179,  230,  478, -234,  241,  309,  24, -142, -87,  428,  320, -382, -44,  241,  12, -295,  132,  247,  27, -391,  369,  72,  179,  274,  309,  177,  295,  486, -130,  35, -328, -99, -234,  02,  168, -141,  163,  44,  218, -71, -28,  38,  47, -220,  131, -441, -14,  115, -341, -487,  224, -120,  438,  255, -346,  247, -68, -199, -415,  302, -311, -243,  56, -45, -388, -276,  314,  275, -380,  32,  56,  92, -78, -397,  373, -95,  15,  211, -480, -474,  224, -403, -94,  162,  352,  412,  262,  137,  66,  347, -61,  255, -43, -153, -290,  69,  71, -124,  196, -457, -239, -247,  136, -465,  208,  361, -59,  75,  424,  313,  101,  148, -238, -493,  163, -385, -228, -75,  252,  338, -228,  43,  93, -419,  391, -345,  150,  314,  383,  199,  358, -356, -196,  346,  32, -488, -441, -175,  440,  483, -362,  41,  483, -99,  401,  498,  368, -327,  275,  472, -137, -100,  15, -192, -19,  258, -37, -16,  425,  198, -317, -365, -305, -13, -167,  227,  351, -108, -448,  291,  227,  42,  185, -438,  443,  438, -87, -337, -37, -312, -365,  326,  88, -497, -366, -78,  261,  449,  406, -462,  147, -59, -327, -306, -220,  06,  421, -369, -250, -175, -225,  477,  368, -188, -108, -337, -250,  305,  179,  213, -155,  314,  391, -214, -331, -475,  208, -217, -174,  466, -179, -175, -93, -05,  20,  187, -147,  293, -330,  104, -29,  297,  433,  191, -39, -175, -294,  211, -370,  385,  276, -24, -448,  167, -386, -279, -456,  322,  04, -130,  288, -322,  196,  47,  173,  68,  86, -122, -139, -392,  482, -316,  406,  416,  375,  219, -259, -418, -69,  224,  467,  59,  52, -129, -273,  166,  445, -229,  340, -51,  494,  480,  479, -458,  27,  152,  110, -35, -469, -177,  73, -135,  08,  331, -219, -117,  51,  375,  317, -166,  99, -363,  393,  03,  08, -28,  21, -47, -404, -139, -245, -410, -159, -266, -368, -280, -261, -406,  185,  122, -83, -242,  487,  425, -58,  121,  161,  493, -04, -22, -173, -53,  115,  72,  450, -24, -455, -29,  429, -359,  332,  36,  83,  25,  271, -433,  245, -138, -339, -70,  484,  78, -460, -177,  356, -18,  444,  369,  327, -60,  199, -346,  387,  167, -421, -311, -357, -24,  160, -76,  469,  344, -187,  52, -131, -416,  471, -34, -54, -368, -252,  282, -438, -211, -395, -230, -377, -450, -361,  451, -10, -309, -43,  230,  358,  36,  419, -147, -488,  80, -371,  481,  276, -58,  385, -02,  26,  356,  464, -176,  488, -287, -394, -97,  02,  64,  173,  477,  114, -335,  428, -44,  208, -114, -314,  66,  422, -42, -229, -213, -110, -100,  120, -334,  343,  06,  164, -131, -138,  129, -454,  203, -306,  04, -394, -452, -432, -369, -475, -466,  148,  454, -09, -144,  192, -471, -226,  466, -13,  45, -247,  377,  446,  374, -456,  289,  232, -440,  10, -406,  189,  408, -351, -265, -87,  107, -217,  333, -409, -191,  368,  239, -237, -141, -52,  455, -112, -426,  421,  376,  120,  27, -395,  418,  253, -351, -441, -15,  62,  421,  79, -249,  330, -419,  339,  95,  188, -378, -72,  279, -69, -204,  19, -454,  155, -181, -147, -104, -107,  127,  124, -135, -346,  229, -217,  407, -269,  194, -108,  293,  116, -177, -104, -54, -96, -265, -459, -407, -142, -31, -276,  289, -382,  243, -312, -375, -86,  41,  21, -340, -332, -355,  25, -178, -273, -339,  81, -42,  355, -175,  103,  323, -499,  499, -231, -95,  87,  162,  350, -203, -16, -425, -62,  102, -330,  126, -421,  437, -332,  101, -403, -164, -402,  122, -489, -175, -365,  444, -365, -157, -230, -410, -334, -229, -58,  288, -472, -471,  302, -269, -174, -214, -194,  264, -260,  328,  243, -180,  265,  411, -227,  362,  99, -129,  337,  110, -451, -176,  407,  36,  167, -323,  479, -314,  300, -79,  474,  328,  302,  276, -441, -20, -85,  217, -256, -493,  398,  487,  179,  163, -250, -196,  378,  350, -472, -433,  312, -71, -109,  219,  465, -89, -252, -204,  97, -452,  217,  423, -271,  19,  199, -212, -149, -34, -142,  96,  326, -244,  435,  05, -229,  38, -338,  01,  240, -310,  420,  52,  119,  164,  124,  436, -425, -276, -267, -476, -227, -198,  447,  354, -326,  498, -358,  25, -35,  352, -379,  143, -40, -91,  00, -416, -201,  162,  85, -461,  352,  06,  443, -29,  22,  419, -92,  97, -356,  493,  121,  269, -205,  420,  123, -31,  418, -383,  495,  235,  470, -32, -122, -70,  377,  379,  14, -324,  393, -48,  67,  246, -190,  11,  69,  332, -70,  477,  281,  74, -178,  254,  195,  118,  174, -182, -413,  444, -64, -418,  180, -94,  403, -90, -312, -368, -211, -445, -191, -317,  359, -272, -219, -331,  239,  350, -147,  22, -320, -366, -404,  02,  388,  292, -380,  414, -38, -292,  358,  398,  142,  38,  156,  45,  449, -303,  178,  90, -248, -161, -375, -37,  67, -94,  132,  159, -243,  485, -319, -63, -29,  129,  439, -141,  273, -88, -227, -264,  472, -17, -366,  114, -478, -357,  12, -177, -160,  42,  413,  444, -267, -461, -93, -348,  297, -461, -337, -446, -124, -156,  343,  347, -174, -365,  58, -401,  47, -317, -165,  371,  166,  322, -15, -460,  465, -151, -137, -195, -257,  129,  101, -24, -480, -492,  481,  317, -101, -356, -276,  275,  341, -81,  474, -333,  406,  384, -234,  305, -433,  454,  176, -415,  276,  14, -374, -407,  363,  341,  250, -41,  322, -149, -213, -306, -141, -232, -136,  258, -87,  440,  385, -246, -141, -289, -79, -234, -405, -461, -429,  14,  493,  248,  99,  269, -238, -423, -286, -23, -229,  464,  436, -55, -185,  76,  140, -474,  344, -496, -364,  109,  444, -127, -285,  155,  84,  488,  421, -469, -472, -155,  45, -127, -55, -03, -05, -441,  426,  209,  388,  49,  174, -323,  495,  489,  253,  135, -132,  449,  139,  04,  59,  435,  378, -374,  90,  314, -385,  364,  346, -05, -291, -109,  368, -494, -260, -137, -83, -333, -427,  157,  216,  247,  334,  211, -412,  439,  198, -44,  389,  189, -187,  300,  124, -309,  426, -285, -495, -107, -421, -297,  388,  140,  95,  257,  146, -313, -28, -85,  206,  397, -428, -77,  496, -241, -14, -415, -302,  37,  393, -61, -274,  58, -261,  351, -399, -334, -434, -393,  411, -03,  162,  300, -363,  109,  409, -365,  297, -119,  50,  03,  131,  122, -222,  127,  381, -383,  212, -68,  154,  458,  371,  380,  16, -389,  231,  470,  129, -351, -71,  40,  146, -409,  192,  283,  201,  101,  418, -02, -165,  320, -147,  466,  295,  132,  93, -472,  249,  158, -40,  255,  468, -168,  135,  336,  295,  219,  306,  276, -280, -265,  168,  367, -173, -139, -498, -472, -186, -227,  378, -499, -407, -269, -181,  388, -285, -235,  417, -184, -225,  229, -429, -257, -87,  207, -69, -292,  278,  90, -164,  498, -323, -495, -283,  04,  218, -280,  384, -116,  345, -386, -114,  438,  198, -443, -321,  413, -178, -52, -270,  97, -323, -199, -308,  91, -140,  476, -349, -362,  66,  340, -11,  243,  345,  206,  100,  415, -222,  336, -201, -377,  451, -463, -86, -499, -405,  445,  414, -83, -107, -356, -133,  422,  298,  59,  13, -342,  387, -483,  149, -47,  357, -362,  49, -446, -304, -351, -179, -25, -163,  120,  450,  140, -490, -136,  141, -395, -191,  56,  22, -446, -448, -259,  477,  350, -347,  342, -139, -460, -289, -490,  346, -80,  00, -105,  326,  196,  396, -353,  23, -267, -380, -26,  374, -370,  338,  367, -265,  00, -77, -391,  406,  328,  203,  383,  178,  356,  226, -109,  396, -211,  253,  242,  210, -247, -11,  36, -198, -115,  184,  325,  471, -344, -201, -303, -214, -10, -436,  373, -158, -12, -166, -252, -184, -463, -16, -154,  393,  62,  238, -358,  351,  343, -264,  61, -403,  226, -402,  251, -37, -366,  76, -66, -210, -272,  483,  428, -430, -452,  301, -88,  388, -13, -488,  56,  377, -04, -246,  270, -442,  492, -236,  410,  336,  353,  323, -215,  79, -227, -464, -106, -93,  464, -319, -451, -308, -336,  477, -238,  64, -370, -474, -48,  470, -109, -492,  347,  387, -237,  117, -202,  107, -266, -292,  295, -413, -117, -68, -482,  157,  320,  264, -436,  285,  445, -34, -171, -38, -57,  444, -474,  426, -178,  331,  396,  213, -309,  243,  101,  306,  212,  399, -86,  446, -41,  61, -115,  342, -154,  255,  351, -334,  20, -232, -197, -35,  234,  133, -221,  29,  429, -194, -45, -249, -363, -149,  465, -172, -54,  66, -365, -341,  317,  401, -43,  128,  314, -305,  322, -340,  450,  174,  179, -30,  442,  482, -212,  176,  467,  67, -295,  396, -275, -487, -352,  214,  216, -387, -457, -337, -469,  30,  174, -300,  283, -17,  328,  97,  178,  150, -390,  129, -176,  289, -49,  118, -377, -409, -206, -409,  159,  352,  487, -264,  365, -13,  451,  81,  452, -154, -404,  483,  376,  270, -317, -489, -246, -137,  108, -216, -486, -430,  413,  190, -289,  217, -191, -165,  308,  455, -74,  319, -341,  265, -444, -476,  105, -141,  458,  57,  205, -446,  41,  433, -323, -424,  444,  283, -60,  404, -433,  306,  475, -167,  348, -314, -450, -343,  373, -290, -35,  151, -118,  124, -83,  290, -499, -478, -351,  459,  431,  354, -135, -28,  287,  42,  401, -417,  177,  193,  487,  245,  351, -186, -422,  199,  01, -372, -291, -126,  190,  174, -474, -428, -202,  295,  362, -201, -331, -489,  110, -400, -283,  476,  425, -144,  370, -322, -61,  48,  371,  279, -207, -426, -407,  223,  273,  94,  351,  482, -179,  393,  156,  199,  466, -193,  346,  328,  458, -133, -308,  69, -33,  261,  397,  244, -382, -381, -226,  409, -481, -03,  188,  164,  71,  282, -113, -155,  228,  90, -173, -99, -16, -164, -48, -50,  495, -202,  130,  453,  165, -326,  374, -15,  436, -377,  81, -94, -257,  356,  167, -238, -147, -144, -221,  425, -10,  166,  122,  70, -243, -199,  472, -407,  137,  276,  395,  132, -425,  25,  438, -408, -448, -336,  429, -160, -212,  11, -402,  383,  219,  265, -03, -76, -379,  276,  201,  463, -57, -177,  34, -448,  125,  358, -355,  114,  486, -460,  99, -439,  417,  37,  06, -179, -447, -65,  161, -159, -202,  259, -276, -131,  377,  222,  294, -150, -02, -05, -186, -207, -329, -300,  197,  296, -90,  342,  262, -104, -266, -139,  310,  04, -250,  168,  325, -196, -45,  339,  497,  254,  450, -278, -25,  327, -204, -231, -322,  294, -383,  344, -60,  140, -104, -363,  288,  306, -168,  50,  54,  66,  412, -136, -78,  14, -468, -252,  318, -12, -61,  316,  94, -111, -110, -431,  69,  186,  191, -401,  332, -340,  443, -228,  300, -161,  262,  88, -03, -406, -362, -449, -488, -98, -84, -65,  417,  300, -465,  235,  140, -26,  403,  86, -285, -207,  156, -364,  479,  199, -265, -336,  359,  30, -64, -489,  369,  50,  99,  218,  496, -411,  270, -491, -08,  38,  296, -91,  190,  331, -04, -169,  157,  252,  417, -276, -455,  425, -139, -123,  124,  96,  41,  335, -373, -171,  346, -152,  380,  297, -433,  376,  387, -311, -263, -121,  227, -467, -360, -83, -284,  488,  248,  373,  240, -482, -402, -362, -205, -41,  15,  420, -93, -444, -393,  386,  237, -194,  87,  469, -397,  154, -302, -158, -305, -65, -427,  422,  321,  65, -161, -463,  54, -60,  411, -206,  310, -139,  284, -395, -328, -201, -123,  431,  207,  337,  318, -55, -357, -95,  266,  98, -89,  464,  441,  106,  252, -486,  380,  73,  80, -281,  110, -14, -489,  373, -368, -327,  86,  417, -221,  258, -284, -492,  190, -224,  345,  360, -427, -160,  117,  339,  439, -472,  304, -268,  486,  408, -254,  366, -19, -322, -63, -409,  164, -51, -183,  297,  474,  403, -434,  105, -486, -218,  114, -444,  410,  311,  416,  483, -348,  33,  323, -57,  413,  479,  175,  399,  387, -227,  265,  220, -48, -298, -337, -32, -497, -20,  117,  478,  236,  183,  435,  250, -182,  401, -342, -272,  213, -74, -288, -283, -189, -113,  160, -276, -134,  187, -25,  105,  460, -260, -175,  264,  294,  340, -267, -350, -179,  350, -20, -443,  386, -85, -341, -296, -183,  169, -68, -118, -405,  144,  99, -94, -469,  111,  482,  249, -202, -43,  206, -242, -451, -117, -125, -305, -276,  108, -155,  397,  310,  325, -194,  196, -259,  317, -248,  410, -14,  185, -208,  433,  181,  391, -161, -435,  02,  173, -334, -348, -18,  373,  262,  31,  108, -363,  226, -316, -403, -76, -419,  408, -251, -113,  456,  342, -296, -291,  252, -458, -254, -456,  475,  427,  435,  166,  492,  289, -161, -341,  441,  321, -116, -444,  204, -156, -307,  283,  29, -209, -293,  110,  51, -44, -150,  359, -201,  54, -432, -449,  449,  166, -404,  424,  446, -117,  91,  438, -327, -218, -51, -34, -396, -315,  22, -340,  30, -432,  443, -441, -141, -350, -479, -238,  107, -129, -379, -242, -222,  42, -191, -273, -292,  257, -349, -346, -07, -406, -55,  166, -123, -254, -16,  333,  284, -141,  493, -186, -73, -211,  225,  286, -61,  246, -452, -102, -30,  21,  156,  248, -437, -182,  475, -228, -73, -22,  278,  420,  73, -277,  438, -198,  322, -77, -13,  106,  282,  332, -228,  61, -379, -151, -153,  61, -405,  247,  459,  417, -232,  468,  165, -168, -214,  492,  456,  213, -29, -414,  134, -104,  162,  72, -450, -16, -153,  37, -58, -19, -131,  214, -458, -09, -437,  241, -96,  10, -12, -137, -72, -391, -169, -55,  293,  469, -62, -399,  183, -239, -313,  169, -491,  349,  93, -89,  185,  441, -200, -373,  274, -479, -307,  317,  364,  108,  58, -232, -381, -101,  484,  399,  360,  167,  196, -495,  137, -14, -394,  172, -401,  145,  193, -40, -05, -214,  371,  32,  79,  23, -488,  206,  45, -295,  23, -91,  314, -67, -470, -215, -316, -486,  36, -456, -467, -268, -99,  170,  219,  07,  194,  318, -347, -113, -221, -500, -474,  02,  384,  457, -474,  396,  163,  423, -398,  38,  184, -232, -176,  214,  53,  08, -420, -411,  405, -386, -179, -194, -364, -108,  314, -317,  63, -181,  70,  342,  171,  448,  196,  55, -242,  222, -48,  421,  497,  54, -40,  182,  322,  284,  248,  227,  144,  329,  316,  49, -205, -11, -292,  283, -266, -126,  466,  297,  193,  389,  139,  216,  337,  187, -229, -405,  262,  223, -131,  259,  129, -319, -59,  303, -183, -310,  382,  461, -129,  198,  363, -482,  40, -429,  301,  274, -55,  268,  71, -10,  157,  62, -294,  346,  101, -23,  442, -137,  53,  163, -377,  34,  344,  416, -162, -339, -42,  72, -26, -319,  123, -163, -301, -337,  260, -499, -211, -295,  269, -288, -453,  278, -374, -247,  124,  227, -417,  418, -409,  136,  81,  66,  22, -75, -18, -288,  438, -207,  285, -87, -26, -92, -398, -474,  423,  363, -473, -288, -80, -352,  276, -32,  426,  402,  221,  402,  129, -344, -327, -428,  292,  254,  138,  167,  32, -27,  379, -30, -382,  164, -265,  92, -428,  190,  118,  495,  53,  497,  59, -175, -03, -165,  293,  275, -263,  367,  178, -281, -477,  351,  143, -332,  457, -218,  335, -11, -393,  214, -188, -275,  231,  399, -331, -345,  89, -360, -349, -06, -11, -438,  320,  487, -102,  113,  262,  487,  332,  292,  58,  356,  143, -298, -124,  453,  336, -289, -58,  443, -223, -394,  20, -492, -494, -459, -336,  447,  33,  167, -58, -477,  229,  114, -490, -21, -273, -376, -33, -440,  417, -475, -232,  412,  79,  144,  365, -85, -293, -192,  210, -16,  266,  82,  345, -376,  124, -139, -428, -343, -472,  366, -320, -391, -20,  42,  89, -441,  167, -444, -29,  84, -67,  239, -04, -487,  235, -138, -72,  442, -478, -09,  279, -360, -427,  124, -235,  197,  485,  189, -293, -135,  55,  239, -26, -113, -218, -437, -54, -199, -29,  418, -263,  405, -491, -415, -230,  245,  299,  198, -461,  321, -311,  318, -186,  115, -58,  79,  164,  279, -232,  371, -356, -325,  463,  471,  62, -255, -466, -492,  398,  358, -222, -365, -385, -212, -280, -115, -115, -128, -417,  276, -307,  125,  95,  359,  92, -111, -62, -244,  21, -442, -20,  165, -267, -57,  136,  295, -460, -477, -344,  438, -267, -66, -75, -152, -426,  497,  233,  311, -131, -332,  88,  415, -355,  35,  274,  237,  424,  65,  494, -55,  123, -26, -37,  357, -231, -49,  152, -191,  326, -340, -253, -441,  95, -476, -93, -479, -479, -360,  333, -109, -191,  273,  158,  306, -192, -68,  44,  84,  497,  390, -470,  121,  216,  345,  330,  485, -204,  334, -206, -25,  495,  393,  34,  442,  417,  442,  463,  438, -66, -352,  181, -405,  421, -161,  402, -271, -376, -54,  314, -27,  188, -304, -54, -96, -107, -224,  241,  189, -37, -465, -336, -42,  428, -449,  252, -303, -155,  215, -365,  279, -284, -331,  375, -363,  360, -371,  219, -164,  427,  385,  310,  115, -67, -244, -129,  326,  385, -388,  367,  200, -353, -116, -342, -73, -65, -238,  124,  280,  477, -389,  411,  45, -220, -362, -465, -07, -233,  254,  329, -306,  491,  139,  309, -76, -252, -320,  102, -15,  144, -31, -315,  291, -295,  195,  70,  140,  457,  46,  272, -214,  158,  184,  332, -210,  322,  367,  283, -58,  473,  465,  136, -184,  104,  298, -408, -296, -170,  194, -459,  475,  15,  78, -382,  221, -227,  189,  213,  82, -265,  338, -279, -255,  374, -95,  36, -452,  124,  171, -10,  97,  136, -373, -235,  93, -223, -143, -351,  107, -449, -309,  82,  418,  269,  201,  491, -105,  242,  205, -171,  477,  395,  50, -277,  269,  455, -389,  317,  79,  282, -192,  28,  271,  287,  293, -136, -436, -350,  365,  171,  53, -92, -246, -28,  30, -193, -37,  425, -451,  20, -246, -122, -85, -343,  101, -316, -388, -436, -498,  192,  347, -190,  72,  470, -403, -134,  186, -339,  16,  51, -316, -78,  460,  290,  394, -10, -403,  209,  267, -02, -270, -127,  377,  145,  30,  330,  330,  495,  395, -316,  187, -406,  346,  111, -436, -205,  477,  250,  308,  346,  153,  492, -232,  465,  283,  14,  307, -268, -277,  74,  231, -47, -200,  108, -401,  330,  290, -219,  325,  185, -35,  364,  279,  163, -24, -305,  458,  305, -203,  266, -497,  451, -390, -229, -232,  393,  285, -424, -374, -491, -498, -291,  314, -198,  317, -235, -15,  459,  46,  162,  145, -137,  379,  276, -122,  207,  472, -164,  12,  121, -46,  16,  72,  65, -361, -307, -42, -223, -231,  436,  138,  123, -03, -48,  426,  166,  218,  263,  126,  116, -75, -229, -168, -196, -453,  210, -489, -129, -453,  376,  493,  01,  244,  417, -82,  383, -390, -271, -340,  231, -335,  298, -145,  163,  103,  133, -171, -179, -104, -193,  437, -327,  78,  121, -22,  478, -168,  341, -151, -121, -431,  194, -268,  313,  112,  151,  197, -426,  380, -291,  306, -103, -492, -339, -88,  111, -354, -406, -216,  42, -99,  73,  215,  480, -305,  45, -190,  27,  239,  159, -242,  308, -146,  342,  474, -182, -07, -477, -108,  225, -268, -302, -25,  92,  211,  387,  55,  357, -167, -309,  251,  235,  265,  319, -433, -188,  216, -123,  339,  307, -112, -51,  468, -406, -209,  442, -88, -363,  465,  305, -286,  49, -145,  189, -358, -81,  429, -451,  128, -238, -259, -120,  497, -142,  51, -84,  170, -233,  293,  09, -73,  34, -190, -105,  128,  101, -163, -459, -410,  154, -302, -195,  55,  405,  494,  197, -176,  423, -401,  453, -314,  192,  185,  35, -450, -264,  452,  220,  355, -403,  81, -218,  131,  391,  177, -240, -08, -134,  153,  83, -128, -297,  388,  428, -392, -266,  477, -67, -342, -424, -114,  196,  268, -429,  83,  318,  159,  35,  38,  14,  485, -381, -351,  116, -138, -322, -272,  355,  45, -267,  290, -231, -64, -470, -303,  45,  116, -325, -170, -374,  103, -432,  322, -128, -361, -94,  42, -350, -207, -67, -484, -222,  404, -335, -253, -233, -156,  327, -26, -259, -439,  116,  10, -03,  146,  208, -106, -238, -265, -424,  241,  338, -356,  63,  62,  135, -179, -395,  285,  467,  38,  302,  97,  294, -181,  344, -439, -485,  172,  387, -244, -415,  03, -381,  434,  01, -321,  181, -384, -86,  257,  357, -248,  402, -80,  315,  37, -406, -228, -177, -87, -338, -23, -490,  456,  296, -293, -130,  312,  379, -243, -80, -184, -387,  39, -250,  114,  218,  431,  230, -16,  189,  87, -411,  443, -140, -244, -20,  306,  28, -345, -281,  190,  132, -271,  498, -71, -64,  220,  93,  167, -170, -487,  483, -57,  405,  86, -91,  475,  369, -360, -40,  58, -421,  49,  01,  291,  305, -166,  97,  185, -11,  316,  227, -378, -102, -423,  403, -314,  298, -04, -294, -372,  361, -311,  423,  266, -373, -168,  242,  497,  324,  54,  407,  404, -45,  261,  195, -240, -405, -207, -203,  436, -39, -476, -442, -289, -399, -187, -102,  399, -339,  104, -121, -477, -355, -198, -359, -227,  487, -265,  122,  311,  289,  381,  215,  96,  142,  263,  356, -411, -92,  05, -474,  369,  29, -64, -419,  483,  250,  331, -266, -237, -65,  114, -214,  432, -232,  280,  57,  107, -133, -321, -81,  09, -439, -14, -395, -445, -251, -186, -355,  157,  319,  23,  379, -151,  459, -188,  184, -439, -357,  418, -175,  430,  384,  463,  362,  05, -405, -80, -388, -37,  451,  31,  472, -136, -482, -423, -80, -233,  243,  417, -223,  63,  292, -344, -236, -397, -32,  448, -335,  111,  366,  342,  41, -397, -343,  255,  108, -247,  27,  220,  216, -21, -248, -460, -305,  122, -31,  467, -259, -287,  384,  18,  276, -472,  174, -108, -368, -358, -160,  149, -395,  58, -09,  498,  161,  148,  254, -231, -247,  133,  490, -179, -388,  94, -139,  160,  68, -317,  127,  309,  248,  364, -172,  24,  392, -498, -232, -476, -03,  108,  173,  102,  18,  16,  101, -320,  17,  207, -51,  270, -160,  291, -408,  305,  237,  305, -35, -195, -160, -408, -385, -412,  456,  295,  464, -299, -351, -268, -275,  146, -308, -249,  101,  211,  267, -298,  391, -216, -239,  192, -93,  453,  336,  351,  258,  425, -492,  75, -269, -151, -480,  198,  289, -172,  345,  254,  29,  494, -162, -393,  141,  31, -142, -258, -258, -23,  296, -15, -386, -91,  29,  373, -138, -135,  224, -27, -209,  232, -452,  374, -67, -80,  424, -277,  249,  269, -171,  130,  263,  167,  237, -96,  50, -53,  498, -356, -223, -354,  129, -109,  55,  11, -236,  418,  376, -160,  243,  19, -76, -357, -107,  358,  64, -183, -67,  165, -414, -386, -205,  350, -367, -115,  106, -464, -316,  457, -320, -39, -397, -338,  352, -489,  173, -32, -219,  401,  308, -476, -79, -267, -333, -334, -57, -417, -16, -272, -400,  422,  194,  248, -376,  327, -367, -417,  363, -183, -460, -104, -369, -05,  58,  483,  06,  83,  304,  287, -16,  112, -337, -243, -303,  183, -76,  492, -382,  408,  72, -281, -318, -234,  467, -193, -54, -48,  242, -191, -379,  282, -443, -248,  129,  115,  88, -12,  50, -108,  127, -465, -496,  291, -208,  54,  326,  216,  46,  444,  476, -381, -337,  11,  237, -18, -330, -317,  434,  412,  345, -444, -454,  402,  160,  175,  370, -252, -337, -80,  140,  291,  307,  497,  434, -400,  51,  260, -332, -403,  204, -03,  68, -280, -492, -194,  202, -322, -11,  489, -410, -166, -103, -364,  89, -443, -337, -41, -194, -173,  379, -202, -30, -461, -205, -96, -361,  346,  16,  159, -204, -280, -344, -284,  292, -336,  374, -05,  194, -136,  336,  284, -450, -267, -228,  491, -210, -64, -50,  448, -385,  182, -253,  85,  221,  394, -159, -288,  241,  357,  371, -111, -71, -120,  457, -278,  44,  332, -431,  91,  48,  405, -125,  98, -10, -500,  442,  280,  288, -108, -419,  403, -74,  180,  340, -01,  74, -319, -437,  167, -110,  435, -92, -329, -185, -134, -107, -289, -302,  314,  302,  246,  219,  30,  196,  61,  382,  138,  194,  170, -117,  275,  425, -339,  307,  265,  161,  233, -202,  224,  253, -460, -489, -339, -289,  178,  379,  105,  390, -423,  271, -456, -325,  343,  426,  372, -96,  308,  362, -402, -22,  97,  373, -97,  259, -468,  20,  272,  266, -330,  348,  19, -290, -288, -468, -78,  390,  412, -121, -368, -159, -350,  29,  17,  493, -45,  241, -102, -236,  455, -04, -406,  53,  222,  350,  164, -394,  222, -64, -276,  393,  136,  243, -397,  348, -372,  377, -409, -108, -244, -277,  233,  259,  252,  102, -396,  60,  195,  02,  324, -497, -149, -230,  56, -75, -380,  72,  383,  343, -492, -392,  236,  496, -297, -309,  345, -169, -431,  436,  223,  177,  11,  309, -64,  116,  263,  41, -324,  311, -105, -148,  314, -402,  122, -130,  375,  243, -206,  259,  438,  154,  367,  174,  150, -430, -283,  347,  254,  138, -365,  329, -184,  147,  490, -396, -237,  254,  497,  291,  65,  245, -357, -121, -305,  265, -399, -429,  360, -105,  330,  298, -451, -451,  324, -449, -29, -458,  399, -275,  180, -466, -93, -152, -467, -103,  305,  148, -349, -346, -61, -432,  399,  434,  299, -405,  200,  400,  18,  412,  147,  200,  211, -452,  249,  35, -400, -280,  429, -149,  298,  462,  237, -295, -190,  271,  454, -33, -81, -42,  122, -289,  26,  373, -355, -174, -180, -303,  78,  338, -390, -274,  38, -327,  126,  139,  208, -422,  360,  490, -71, -490,  452, -333,  67,  114, -210,  21, -418, -439,  479, -444, -228,  358,  429,  270,  36,  102, -181, -386, -60,  281,  192, -169,  454, -181,  470, -485, -103, -318, -495, -321, -308,  457, -154, -389,  423,  488,  133, -495, -451,  464, -87,  174, -326,  195,  296,  210, -203, -385,  325,  237,  397,  17, -80,  351,  336, -109,  366,  86,  73, -277,  265,  266,  32, -37, -271, -44, -49, -286, -39,  00, -321, -273,  26, -147,  422, -178, -84, -281, -62, -259, -192,  187, -390,  229,  38,  447, -380,  257,  33, -455, -168,  150, -337,  365, -387, -107, -179,  64,  107, -366, -84,  286, -139,  443, -08, -217, -235,  408,  354, -445,  01, -337,  242,  111, -256,  133,  410, -136, -110,  295, -91,  222, -55,  425,  439,  58, -182, -240, -26,  425, -105,  391, -436,  256,  334,  408, -108, -49, -332, -254,  07,  169, -91,  101,  132,  153, -266,  43, -131,  476, -162, -369, -449, -364, -444,  490,  194, -126, -249, -331,  151,  146, -88,  215,  254,  98,  123, -354, -99, -357,  245, -240,  312, -346,  362,  297, -340, -404, -160,  29, -427, -470, -488, -24, -334, -432, -34, -287,  294,  217,  234, -54,  215, -354,  13,  322,  244, -363, -180, -355,  132, -435, -94, -55,  72,  120,  94,  232, -432,  434,  113, -07,  464,  126,  469, -17, -454, -64,  196, -307,  05, -70,  139, -279,  428, -348, -105, -476,  141,  215,  21, -226,  281, -221, -429, -147,  399,  165, -63,  468,  451, -450, -39, -233, -472, -69,  250, -73, -281,  298,  120,  224,  80, -241, -203,  08,  263,  192,  384,  257,  260, -94, -469,  393,  185, -46,  98,  437, -29, -465,  405, -78, -63,  218, -459, -34,  01,  292,  393,  220,  442,  365,  297,  23, -24, -406, -117, -261, -361, -232,  496, -249,  174, -121, -356,  211, -315,  242,  148,  156, -371,  405, -70,  66,  476, -28, -116, -23,  116,  129,  50,  58, -06, -153, -67,  470,  293,  317,  62, -216, -415,  58,  35, -389, -210,  179,  322, -25,  273,  323, -16,  402,  228,  414,  321,  204,  238, -295,  34,  206, -313, -416, -235,  181, -69, -450,  152,  76,  367,  66,  361, -196, -376, -104, -85,  266, -72,  90, -258,  53, -87, -422, -44, -07, -156,  129, -302, -417, -314, -416,  289, -127, -332, -94, -445,  451, -43, -441,  27,  176,  125,  240,  481, -399, -363, -104,  368,  417, -162, -38, -30,  251,  40, -222, -255,  384,  407,  295, -181, -406,  379, -39, -33, -101, -281,  374, -150,  176,  433, -271, -147,  410,  470,  186, -488, -41, -66, -268, -124,  273,  194,  346,  24,  86, -375, -379,  322, -116,  416, -06,  330, -353,  455,  150,  46, -326,  24, -252, -297,  310, -22,  408,  220, -52,  446, -416,  407, -120,  168,  135, -347,  214, -19,  178, -200,  458, -349, -25,  195, -432,  469,  25,  67, -224, -325, -386,  302, -448, -138, -143,  362, -308, -235,  434,  140, -289, -129,  399,  444, -461,  34, -403,  254, -132, -373, -94,  178, -221,  381,  225,  199, -298,  103, -234, -22,  278,  232, -219, -318, -405,  490, -456, -213, -244,  479, -220,  319,  202,  31, -385,  241, -82, -287,  347, -362, -160, -246,  316,  471, -13,  394,  170,  190, -03, -211,  20, -225, -479, -347, -42, -32, -356,  354, -392,  252, -315, -112,  423,  387, -229, -461,  481,  189, -248,  328,  327,  444, -418,  496, -232,  70,  390,  438,  112, -113,  79, -368, -486,  101, -214,  324, -431, -70, -469,  29,  34, -284, -231, -43, -44,  41, -04, -63,  82, -400, -235, -90, -455, -152,  258, -187, -230, -500,  103,  382, -113, -317, -134,  253, -364,  152,  430,  57, -66,  461, -413,  468, -323, -144,  278,  133, -251, -226, -78,  332, -125,  188,  94,  272, -464,  204, -63,  158,  204, -108,  392, -57,  427, -242,  48, -437,  411, -22,  473,  197, -61, -440, -482,  469,  268,  296,  454, -130, -78, -123, -298, -351, -435, -352,  421, -47,  352,  210, -389,  408, -45, -497, -149, -118,  113,  399,  298,  376,  230,  271,  74, -331, -317,  444, -10, -197,  240, -55,  173, -338,  322, -273, -188, -261,  227,  85, -456,  79,  148, -345,  339, -397,  10,  42,  337, -377,  294,  135, -500,  24,  258,  426,  193,  441,  370, -316, -255,  462,  481, -230, -24, -345, -02, -360, -106, -275,  226, -62, -343,  226,  445,  496, -319,  307,  391, -482, -218,  185, -494,  134, -291,  264,  412,  402, -442,  282, -62,  155, -404, -81,  425,  73,  426, -77,  213, -180, -499,  291, -390, -342,  17, -93,  06, -450,  66, -103, -79,  349, -418,  279,  335, -209,  395,  248,  46,  453,  382,  484,  108,  479,  256,  386,  52,  182, -191,  117, -145, -190, -91,  317,  320, -222, -275, -173,  181,  291,  224, -398,  492, -341,  381, -320, -50,  276,  428,  496, -418, -338, -167, -458, -359, -59,  428, -455, -25,  90,  163,  330, -248, -76,  148, -75, -446, -275,  252,  235, -132,  328,  337,  213,  487, -430,  393,  290, -301, -327, -362, -219, -165, -29, -177,  329, -236,  104,  374,  240,  46,  389,  422, -350,  165,  70,  75,  220, -353, -173, -45,  16,  08,  145,  81,  347,  215, -26,  137,  414,  147,  276,  47,  482,  99, -277,  311, -284,  327, -462,  456,  225, -221,  378,  375,  445,  301, -49,  165,  448, -370, -28,  316,  138, -383, -103, -14,  333, -277, -25, -401, -278,  103,  147, -295,  55,  370, -132,  271, -451,  258,  227,  274, -462,  457,  149, -165,  258, -400, -148, -441,  83,  324, -273, -279,  442,  477, -441, -373, -300,  35, -274, -77, -10, -275,  480, -455, -405,  200, -332, -04,  311,  395, -230, -299, -295, -228,  36, -185,  224,  388,  226, -193, -436,  454,  381, -494, -217,  440, -15, -17,  327, -436, -242, -182, -211,  90,  215,  237, -209,  384, -267, -398, -369,  04,  155, -164, -372, -309, -496,  352, -69,  230, -340, -05, -464, -459,  354, -181, -167, -161, -345, -339, -97, -87,  331, -455, -496,  398,  282,  147,  282, -133, -399, -234, -277,  256,  454, -149, -201,  458, -296,  230, -459,  216, -275, -423, -391, -421, -103, -58,  271,  52,  455, -326, -183,  286,  71,  173,  185,  205, -180,  319, -427,  273, -415, -204,  29, -460, -500,  328,  498,  56,  410, -461, -228, -364, -31, -119,  67,  366, -325, -162,  270, -369,  365, -413,  417, -64, -387,  454, -358, -67,  274,  67,  59,  359, -285, -60, -249, -285,  121, -250,  271,  31,  141, -105, -481, -390, -372,  87, -172, -196,  425, -50, -65,  290,  390,  204,  79, -497,  159, -427,  288,  285,  140, -153,  144,  355,  288,  396, -77,  261, -02, -306, -208, -09,  442, -188,  454, -430, -249, -218, -126, -324,  233,  309, -181,  123,  366, -250,  478,  25, -177,  266, -190,  463, -34, -194, -330,  106,  54,  93, -133, -96, -360,  159,  396, -418, -177,  350, -348,  74, -16,  379, -397,  69, -460,  274,  44,  406, -476,  22, -69, -153,  141, -407,  162, -393,  252,  332,  213, -194,  278, -420, -437,  418, -409,  459, -500, -85, -339,  04, -159,  497, -117,  296,  67,  276,  422, -37,  182,  446,  486, -34,  145,  127,  411, -193,  234,  163, -08, -53, -178, -230,  379, -115, -312,  470,  196,  40,  237, -291, -104, -69, -294, -368,  79, -375,  408,  02,  89,  90, -52,  427, -92, -406,  54, -180,  253,  140,  483,  97, -61, -195,  367, -182,  190, -93,  140,  238,  447, -122,  447,  196, -339,  06,  328,  240,  131,  236, -258,  72, -174, -457, -01,  235, -11, -95, -93, -258, -455, -110,  340,  336, -452, -441,  06, -410, -33, -353,  329,  266,  377, -372, -38, -462,  134, -210, -370,  118, -474, -127, -310,  205,  268,  190,  292, -243, -53, -301,  351,  345,  441, -457,  181,  489, -397, -312, -420,  422,  187,  409,  188,  416, -463,  03, -194,  172,  293, -64, -210, -328, -339,  332, -271,  429,  374, -127, -314, -178,  424, -110, -333,  365, -67,  348,  355,  36, -112,  435, -42, -73, -304, -01, -157,  85, -498, -499,  109, -353, -62, -249, -181,  451, -416,  400, -267,  458, -227, -81, -220, -303, -339, -53, -437,  95,  148, -230, -369, -112,  57,  442,  316,  253, -59,  11, -162, -57,  13,  448,  90, -197,  51, -238,  106,  135, -338,  339,  94,  288,  111, -274,  485,  272, -474, -100, -133,  174,  170,  351, -438, -273,  293, -270, -168,  86, -406,  171, -119,  459,  471,  471,  114,  22,  85, -280,  10, -400, -88, -396,  388, -477,  182,  373,  295,  208, -226,  15, -118, -204,  218,  297,  24,  11, -121,  356, -51,  325,  379,  330,  284, -298, -347,  250, -423,  239, -177,  87, -309,  235, -457, -421, -390,  225, -196,  405, -66,  430,  272, -332, -273, -10, -183, -397, -147, -451, -189,  302,  374, -309,  484, -489,  245, -362, -387,  322, -271, -64, -91, -80,  23, -48,  351,  133, -322, -345,  39,  464, -414,  163, -16,  165,  06,  302,  268,  359, -297, -69, -486, -423,  474,  498, -60,  220, -12,  54,  42,  217, -158,  452, -11,  366,  256, -160, -01, -214,  348, -110, -250, -214, -94,  235,  451,  412,  389, -429, -377, -56,  02, -363,  373, -23, -12, -186,  49,  476, -280, -409, -454,  414, -105,  387,  280,  04, -272,  132,  290, -72, -478, -107,  214, -72, -20,  165, -160, -131, -412,  316,  313,  442,  453,  186,  271,  293, -148, -180,  270,  424,  264, -332,  339,  11, -445,  471, -485,  135,  103,  306, -85,  126, -301, -371, -94,  179, -354, -401, -100, -266,  415,  65,  29, -280,  103, -200, -486, -192,  473, -364, -268,  237, -196, -429, -252,  211, -105, -236,  199,  498, -78, -386,  476,  121,  96, -117,  152,  242,  334, -448, -171,  249,  469,  358, -179,  72,  10, -165,  380, -17, -29, -35, -280, -373,  388,  321, -309, -217, -63, -258, -218,  359, -144,  110, -20,  452,  493, -16, -453, -321,  388, -124, -220,  357,  86,  102,  281, -404,  437, -486,  80,  261, -21, -348, -260, -133,  473,  283, -497, -90, -475,  137, -231,  234, -253, -399, -462,  93,  437, -415,  272,  325, -39, -447,  182, -453,  155, -36, -04,  444,  330, -424, -443, -191,  80,  150, -472,  406, -67, -469, -184, -41,  168,  438,  45,  416, -109,  83,  09, -171,  169,  133,  06, -18,  186, -311,  382,  193, -495, -122,  138,  335,  306,  195, -04, -114, -155,  24,  144, -369,  56, -187,  442,  76, -249, -13,  344,  494, -430,  205,  175,  239, -161, -318, -278, -475,  223, -396, -429,  228,  334,  209,  415,  140,  256, -89, -122, -46,  435, -477,  85,  343, -164,  379,  272,  439, -134,  116, -215, -64, -178,  461,  28, -487, -05, -398, -462, -282,  58, -391, -202, -108, -330, -287, -116, -221,  124, -386,  233,  411, -363,  170, -393,  325,  49,  379, -384, -233,  347, -98, -445, -331, -137,  83, -318,  358, -463,  73, -72,  95, -466,  226, -161,  57,  439, -425,  336,  415, -310,  421, -322,  179,  91, -215,  05, -08,  16,  473,  259, -136, -125,  314,  385, -410,  250, -432, -200, -361,  493,  228, -413, -121, -46, -74,  436,  245,  354, -376,  160, -456, -455, -309, -425,  488, -24,  432, -20, -155,  406,  91,  209, -219,  258,  94, -128,  360, -486,  172,  499, -141, -99, -414,  239, -293,  365, -473,  453,  219, -348,  465, -385, -303, -344, -310, -314,  485, -377, -482,  182, -119,  462, -109,  162,  220, -163, -114,  432,  204, -89,  431, -437, -336, -130,  302, -129, -265,  330,  176, -194,  482,  142, -79,  31, -350,  463, -431, -13, -62, -412, -331,  319, -450,  412,  334, -378, -250, -280, -446,  454,  131, -163, -483,  295,  207, -328,  19, -206, -146, -305,  100, -164, -311, -127, -281, -160,  189, -211, -321, -373, -123, -151, -201,  279, -239, -367, -247,  363,  205, -193,  317,  189,  496, -313, -16, -444,  211, -145, -150, -435,  51, -197,  253, -408, -472,  472,  284,  217, -239,  464, -303,  490, -187, -04, -379,  74,  129, -126, -62, -166, -467,  107, -477, -470, -354,  360, -414,  357,  67,  288,  422, -30, -57,  175,  63, -28, -500, -153, -311, -239, -189, -114,  104,  476, -266, -423,  403,  363,  304,  193,  50,  337, -200,  425, -281, -53, -363,  157,  156,  205, -54,  79, -325,  389,  106, -410,  213,  106, -62,  403, -280, -399,  141,  324, -422,  376, -247,  481, -409, -443, -474,  493,  395, -174, -229, -34, -375, -92, -376,  282, -35,  422,  213,  493,  311, -181, -417,  25, -222,  373,  280, -02, -173,  273,  174,  257, -499,  427, -410, -55,  485, -384, -62, -268,  294, -439,  198,  420, -30, -326, -446, -213, -404, -381, -220, -240,  290,  216, -363, -432,  441,  417,  66, -232, -458, -260, -475, -104,  20, -385,  341,  05, -269,  131, -411, -474,  193, -361, -202,  15, -186,  204,  302,  262,  323, -65, -478,  113,  03, -341, -466, -56, -72,  100,  213,  323, -307, -410, -281,  213, -294, -440,  70,  289,  191,  159,  315,  236,  298, -35, -249, -36, -331, -94, -273, -156, -307, -251, -190,  196,  261, -156, -08, -311, -204, -295, -488, -11,  148,  83, -298,  354,  143,  272,  495,  187,  283, -337, -77,  82,  128, -473, -454, -350,  285,  125, -06, -170,  375, -344, -122,  136,  352,  370, -323, -351, -72,  42,  490, -424, -375, -307, -218, -379, -183, -223,  308, -47, -60,  83, -465, -431,  462, -67, -281,  247, -441, -435, -423, -214,  74, -45, -226, -74,  178, -49,  75, -394, -155,  66, -318, -29, -389, -36,  92,  280, -407,  252, -267,  34, -165,  120,  455, -202, -94,  26, -103,  317,  91,  327, -397,  17, -218, -123,  444, -188, -320,  19, -82,  26, -63,  452, -151,  400,  268,  441,  181,  362, -455,  414, -104, -120,  387, -149, -470, -207,  377, -72, -390,  320, -245,  65, -162,  389, -206, -218, -298, -26, -347,  120, -148,  443,  425,  201,  343,  193,  494,  24,  55, -461,  291, -197, -80, -470,  154, -50, -177,  383, -270,  285, -444, -15,  202,  246,  227,  496, -472,  429,  322,  33,  401, -325,  328,  326,  376,  172,  372,  371,  48, -73,  410,  191,  231,  182,  221,  237, -15, -456,  473,  215, -319, -471,  53,  383,  275,  132,  379, -345,  413, -446, -460,  314, -271,  369,  493, -395,  393,  365, -172, -59,  144,  91, -367,  227, -227,  354,  317, -390, -249, -358, -322,  284, -329, -417,  168, -202,  215,  399,  305,  128,  453, -303,  294, -318, -82, -361,  140, -189, -144, -180, -395, -499,  411,  90, -420,  37,  296, -251,  147, -101, -109,  325, -316,  62,  408,  352, -288,  123, -397, -131,  103, -91,  67, -102,  443, -163,  389,  83, -499, -254, -244, -394,  99, -333, -452, -469, -444, -304, -219,  204,  96,  172,  381,  280,  87, -358,  484, -349, -383, -61,  21,  221,  348, -60, -29,  292,  277, -140,  227,  278,  458,  483, -264,  57,  03,  136,  89,  59,  333, -278,  115, -71,  394, -03,  61, -19,  139,  45,  133,  256,  484,  06,  329, -315,  446,  152,  477, -425, -487,  204,  354, -177,  188, -58, -267, -309, -421,  322, -398,  412, -456,  218,  193, -210,  67, -246,  272,  58, -349,  257,  166, -13, -237, -04,  172, -291, -352,  149, -216,  13, -146, -10,  337, -106,  433, -430,  85, -136, -256,  187, -224,  140,  257,  469,  430, -176, -277, -446,  382,  226,  311,  49, -287, -74, -103,  386,  487,  45,  387, -228, -89, -259, -386,  100,  487, -101, -478,  72,  263,  118,  112, -461, -242,  221, -140,  40, -454,  435,  447, -220,  161, -390, -319, -273,  37,  78, -387,  24, -24, -148, -352, -261,  446,  115,  339,  433, -486, -287,  358, -370,  331, -30,  21, -59,  43,  382, -167,  441, -331, -220, -278,  331,  243, -97, -90,  132, -166,  23,  08,  310, -273, -491, -451, -327,  124,  388, -393,  490, -47,  465, -380, -216,  287,  142,  225, -170,  24, -442, -228, -455,  191,  346,  376,  286, -251, -214, -82,  83, -339,  426,  245, -111,  435,  294,  414,  411, -466, -479,  402, -13,  486, -478, -377,  273,  164,  348, -44,  40, -241,  228,  86, -198,  426,  314, -412, -325, -47,  358, -389,  466, -364, -292,  207, -428, -145,  122, -165, -111,  143, -263, -271,  482,  112, -148,  255,  128,  53,  63,  21, -336, -209, -393,  318, -283, -227, -242,  245, -422, -384, -292, -455, -248,  268, -396,  176, -377,  226, -136,  365,  222,  453, -406,  204,  65,  298,  311,  46,  203, -125, -433, -281, -482,  26, -463,  88,  299,  147,  185, -270,  263, -255, -225, -132, -487, -121, -104, -363, -42, -388, -498,  32, -434, -52, -264,  131,  98, -101, -323, -198, -374, -256,  21, -03, -378,  411, -63,  422,  58, -378, -348,  174,  219,  279, -106,  232,  10, -358, -279, -180, -245,  75,  352, -179, -477, -60, -196,  122, -308,  334, -224, -182, -70, -351, -333,  53, -440,  104,  327,  471, -422,  479,  497,  297, -390,  243,  30,  472, -263, -397, -207, -08,  179, -355, -335,  202,  438, -30,  176, -370,  156,  452,  300, -414, -398,  468,  139,  14,  72, -34,  337,  151,  297,  334, -52, -241,  429, -170, -268, -333, -66,  25,  159, -35, -478, -323, -333,  460,  499, -304, -58,  155, -352, -257,  241, -250, -289,  233, -383,  283, -301,  454,  286, -151, -359,  87,  108, -430, -231,  340, -263, -445,  217, -251,  20,  240,  278,  188, -448,  277,  384, -05,  284, -116,  238,  377,  487, -199,  110, -396, -64, -338, -90, -277,  11,  51, -338, -29,  122, -69,  164, -289, -13, -119, -40, -493, -27, -262, -453,  378, -133, -217,  225, -349,  168,  315, -471, -493, -384,  139, -37,  52, -347,  373, -373,  164, -75, -211, -12, -453, -427, -348, -242,  60,  385, -429,  419, -141,  161,  467,  89, -471,  102, -186, -320,  122, -371, -291,  129,  97, -299, -408,  01, -146,  466,  129, -129, -109, -230,  359,  290,  195, -137, -100, -245, -252, -29,  27,  459, -367, -06,  48,  14, -52, -286,  194, -429, -157, -244, -448, -208, -43, -355,  294, -337, -37,  275,  34, -294, -455,  245, -152, -407, -392,  248, -152, -143,  72,  375, -184, -443,  221, -283,  71, -330, -69,  117,  93, -373,  373,  145, -81,  182, -358, -287,  346,  105,  488,  232, -337, -114, -22,  11, -21,  438, -240, -321, -205, -316, -93,  464, -259, -372,  33,  312,  150,  464, -71,  95, -409,  155, -259,  11, -163,  235, -424,  35, -159, -435, -232,  356, -49, -402, -132, -218, -464,  480, -39,  184, -336,  368,  148, -95, -151, -319,  69, -149, -03, -150,  447,  89, -143,  40, -48,  195, -225,  28,  82,  468,  93,  350,  325, -104,  448,  45,  178, -163,  25, -360, -479,  189, -140, -479, -54,  209, -298, -133, -439,  199, -431, -492,  140, -73,  400, -408, -26, -325,  473, -444, -04,  418,  407,  173, -185, -293, -282, -155,  396,  243,  337,  417, -68, -302,  438, -270,  407, -08,  449, -180,  44, -482,  180, -316, -55,  80,  129,  419, -392,  454, -172,  456,  372, -265,  129,  39,  294,  347, -263,  191,  90, -426,  460, -126,  124,  399,  104,  32, -109,  405, -296,  435,  423,  385, -28,  221,  317, -47,  140, -223, -93,  468, -267, -221,  55,  362, -329,  202,  209, -92,  245,  151, -18,  205, -475, -393,  456,  481,  491, -152,  386,  47,  135,  310,  284, -41,  31,  102,  412,  23, -269,  171,  344, -35,  451,  251,  179, -26, -47, -111,  382,  50, -460,  216, -244, -82, -325, -288,  251,  18,  412,  138, -434,  400,  300,  350, -141,  183,  304,  124,  58, -464, -205,  254,  353,  98,  06,  32, -428, -189,  421, -194, -286, -186, -125, -30, -416,  50, -466,  335, -431,  447,  325, -13,  347,  477,  189,  58, -488, -06,  34,  71,  382, -318,  177,  235,  280,  35, -233, -295,  347,  41,  363, -87,  355, -262,  383, -209, -359,  417, -22,  62, -284, -196, -451, -85,  133,  238, -174,  146,  84,  360,  69, -34, -458, -254, -299, -325, -366,  321,  232,  481, -138,  95,  246,  69, -314,  129,  360, -173,  398, -162, -259, -385,  494, -210,  30,  128, -120,  356,  126, -183, -431, -305, -365, -37,  293,  189,  138,  427,  10,  222, -240,  372, -182, -494, -59,  356,  487,  153,  35,  386,  491,  276, -147, -162, -434,  383,  466,  298, -408,  444, -33,  13, -361,  103,  476, -216, -208,  467,  64,  302,  189,  324, -474, -141, -317,  319, -285, -330, -28, -398, -444,  315,  378,  261,  05, -204,  145, -29, -405, -411, -85,  414,  454,  406,  17, -218,  43,  309, -251, -393,  463, -209,  431,  489,  150, -34, -340, -282,  137,  484, -180, -455,  300, -301,  307, -195,  347,  304, -371, -206, -255,  396, -291, -301, -345,  226,  333,  198,  388, -417, -343,  351, -126, -412, -307, -124,  407, -147,  446,  44,  190, -233,  441, -10,  318, -400, -353, -483,  404,  128, -188,  01,  377,  21, -448, -116,  99,  386, -418, -13,  469,  91,  191,  195,  179,  384, -429,  438,  89, -482, -18, -221,  137,  276, -379,  307,  376,  121,  324,  281,  101, -364,  134,  330, -491,  187, -286,  109,  73,  148, -52,  42, -261, -361,  89, -229, -125, -488, -291, -183, -470, -456,  448, -481,  320, -78,  326, -452, -105, -497, -319,  496, -09,  316,  327,  01,  03, -107, -390, -424, -458,  58,  470,  133, -450,  59,  404, -75,  71, -34,  242,  454,  10, -457,  473,  182, -35, -348,  230,  360,  07,  412,  356,  498,  228, -465, -01,  83,  281,  461,  159,  323,  372,  129,  308,  422,  40,  213,  199, -389, -321, -58, -435, -459, -15, -109, -425, -198,  395,  305, -338,  254, -431, -130,  252, -351,  258,  104,  232,  39,  65,  243,  214,  289,  224,  22,  211, -236,  87, -89, -124,  266, -295,  293, -341, -458,  36, -266, -156,  283, -108,  358,  37, -39, -272,  142,  463,  486, -254, -453,  377, -337,  291,  91,  453,  15, -386, -484,  280,  201, -73,  08,  320,  484,  153, -169, -122,  42,  418,  222,  177, -190,  432,  67, -377, -339, -291, -414, -01,  307, -14, -123, -178, -223, -180, -225, -356,  286, -208, -224,  340, -429, -364, -488, -92,  290, -157,  286,  184, -239,  361, -139,  423,  293,  428, -453,  454, -11, -15,  306,  148,  471,  35,  471, -252,  355,  98,  245,  494,  390, -479,  334, -186, -342,  346,  222, -200,  41,  08,  484, -345,  221,  197, -422,  15,  478, -375,  321, -33,  463,  127, -32,  434,  14, -61,  35,  222, -463, -220,  216, -220, -199,  402,  446,  311,  248,  168, -389,  141,  28, -405,  296, -250,  293, -273, -383,  271,  204,  438,  90,  167,  418, -90,  102, -68,  349, -11, -346, -261, -379, -278,  371,  274, -376,  317,  86, -276,  337,  197,  366,  217, -355, -486, -181, -210, -259, -64, -87,  446, -125, -145,  113, -207,  266,  67, -423,  467, -92,  84,  58,  29,  306, -71, -196,  431,  98, -258, -345,  287, -209, -127,  05, -64, -112,  324, -422,  129,  113, -09,  427,  488,  347,  393,  133,  465,  312, -438,  432, -279,  146, -09, -398, -47, -228,  258, -116,  371, -500,  391,  158, -208, -235,  15, -420, -495,  192, -341,  486, -195,  150,  414,  145,  349, -341,  130,  314,  471,  192, -401,  44, -161,  90,  147, -356,  362,  257,  380, -415,  258,  271, -404, -98, -112,  111,  334, -107, -197,  493, -120,  108,  496,  146, -247, -303,  305,  383, -136, -372,  428, -37,  173, -233, -95,  172,  263,  119, -71,  143,  205,  39,  266,  301, -207, -345, -88, -372,  400, -432, -27,  132,  176,  321, -222, -218, -129, -65, -335,  235,  416, -55, -302,  89,  212,  455,  113, -25,  74, -458, -30, -221,  434, -263, -68, -273,  244, -303,  207,  144, -235,  33, -223,  441, -146,  407, -277,  225,  195,  241,  312,  111, -314, -138, -300, -249, -183, -335, -422,  392, -293,  49,  23, -07, -362,  456, -427,  382, -347, -368,  26, -82,  165, -345,  211, -128, -437, -213, -403, -390, -472, -238,  221,  66,  124, -227, -331,  442, -62, -252, -314,  497, -351,  209, -09, -213, -483,  416, -331,  22, -452, -453, -208,  214, -297, -496, -414,  118, -209,  35,  228,  171,  297, -51,  89, -78,  222,  259,  216,  12, -141, -246,  09,  08,  463, -148, -353, -167, -232, -184,  355, -183,  215, -352, -117,  418,  04, -31,  36,  295, -144,  116,  318, -346, -435, -93,  428, -361,  18,  496,  151,  377, -250,  13,  237,  65,  365,  384,  398, -14,  52, -394, -345, -232,  106,  38, -314, -390, -141, -425, -243,  215,  191, -425, -279, -391,  334,  01,  100,  205, -03,  104,  434, -401, -383,  172,  165, -166,  408,  415, -328, -39, -479, -173,  229,  479, -283, -233, -411,  428,  194, -154,  496,  238,  273, -283, -301,  460,  219,  299, -483,  68,  255,  451, -480, -276,  123,  185,  59,  384,  452, -417, -155, -174,  263, -74, -195,  480, -455, -105, -239, -408, -407, -243,  330,  367, -26, -471, -321,  45, -320, -304, -34,  436, -353, -14, -340, -377,  23, -429, -493, -25, -345,  204,  301, -230, -18, -393, -250,  27,  02,  363,  119,  95, -380,  301,  314,  95, -318, -155, -08, -137,  41,  458,  151, -459, -56, -337,  16, -181, -265,  375,  295,  242,  79,  96, -488, -87,  203,  114,  440,  57, -22,  412,  05,  98, -435,  171,  45, -252, -483, -462,  463,  410, -152,  114,  451, -355,  277, -33, -36, -136, -158, -241, -394, -227, -292, -30,  186, -237, -63,  479,  321,  415, -257,  178,  365, -192, -151,  263,  408,  218,  301,  371,  129, -351,  337,  432,  146,  467,  252, -389, -169, -54,  222,  290,  220,  430,  112,  258, -306, -451, -411, -485, -184, -168, -455,  34,  493,  246, -203, -247, -35, -50, -23, -54,  99, -186,  230,  98,  133, -18,  209,  465,  429, -69, -393, -499, -138, -429, -389,  56, -379, -299,  423,  289,  385, -180,  175, -270, -434,  472, -16,  383, -78,  461, -171, -126,  127, -440,  472, -239,  394,  181,  78, -325, -36, -463,  28, -322, -392,  492, -414,  81, -307, -139,  223, -70,  181, -102, -487,  248, -129,  349,  483,  293,  310, -187,  19,  289,  225, -09, -98,  471,  24,  480, -353, -159, -483, -473,  19, -22, -481,  106, -441,  64,  467,  282,  495, -499,  33, -140, -399,  404, -291, -416, -451, -481,  249,  69, -340, -26, -88,  63,  298, -211,  43,  445,  130,  413,  472, -351,  243,  492,  255, -346,  56, -425, -211,  403, -424,  322, -237, -323,  226, -28,  113, -373,  343, -137, -452, -144, -311,  313,  419,  487, -398,  314, -216,  232, -421, -243,  381,  322,  101,  489,  477,  09, -84, -234, -87,  344, -60, -472, -479,  18,  353,  486,  145, -452, -151, -454, -96,  39,  359, -177,  26,  461, -362,  311,  193, -283, -80,  426, -108, -127, -233, -131,  382,  183,  487,  147,  379, -73, -472, -248,  445,  381, -261,  442,  429,  88,  488,  186, -21,  347, -491, -494,  308, -01, -331,  353, -431,  441, -368, -39, -186, -101, -318,  48, -65, -331,  48, -186,  448,  76,  67, -255,  309,  306, -313,  238,  246,  28, -76, -274, -125,  286,  84,  36, -215, -395,  241, -146, -102,  373, -333,  212,  125, -151,  112, -440,  370, -340,  226,  318,  236,  145, -85,  45,  303,  103,  136,  50, -369, -88, -372,  358,  50, -436,  246,  336, -331, -12,  42,  67, -139,  210,  131,  486, -89,  95, -102, -218,  256, -23, -48,  344, -378,  368,  242, -222,  323, -122, -320,  454, -358, -192, -336,  193, -128,  411,  381,  393,  251, -77, -40, -388, -15, -57, -49,  397, -462, -299, -321, -354,  178,  483,  491, -347,  351, -415, -69,  174,  315,  111,  480,  457, -229, -355, -498,  143, -92,  383,  388, -341,  159, -152,  123, -356, -357, -74, -107,  33,  128,  72,  180,  158,  56, -477, -337,  259, -392,  94, -66,  423,  57, -86, -268,  328,  411, -265,  323, -181, -382,  211,  330,  277, -89, -46, -226,  54, -268,  167, -60,  360,  92, -380,  371,  00, -05, -466, -241,  103,  481,  193,  378,  38, -40, -390,  219, -129, -155,  42, -457,  316,  106,  373,  93, -131,  179, -281,  424,  412,  387,  216, -376, -21,  336,  495,  479,  183, -118, -262, -214, -137,  432,  16, -247,  244,  126,  472, -385, -176,  367, -342, -360,  325, -116, -415, -306, -437, -195, -30,  475, -308, -314, -48, -477, -126,  299, -498, -443, -319, -260,  195,  396,  24, -289,  02, -232, -310,  326,  236,  14, -455,  394, -494,  370, -222, -409, -83,  194,  248,  387,  169, -208, -74, -27, -185,  300, -227, -183, -290,  306,  410,  405, -445, -66, -383,  57, -445, -193, -117,  291, -327, -71, -463, -321,  151,  168,  122, -432, -138, -129, -192, -117, -485,  234,  357, -169,  386, -370, -500, -404, -212,  410, -498, -157,  197, -29, -248,  252, -370,  136,  395, -197, -83, -216, -18, -80,  452, -44, -11, -186,  327, -351,  198,  343,  383,  55,  26,  269, -463,  26,  366,  177, -63, -280, -479, -14,  191, -227,  90, -327, -239, -15, -24, -470, -379, -190, -49, -426,  266, -208, -112,  446, -59, -62, -359, -176, -155,  167, -55, -118,  45,  163, -88, -166,  383,  285,  320,  426, -90, -90, -401,  172, -253,  427,  202, -131, -263,  05, -57, -144,  297, -317, -198, -262,  122,  295,  414,  467,  314, -140,  202, -141, -477, -386, -454,  407, -249,  366, -315,  161,  129,  137, -167,  376,  64, -112,  97,  302, -255, -108,  10, -457,  76, -336, -219,  50,  459, -304,  17,  273,  408,  71, -16,  431, -463,  30, -310, -212,  249, -124,  450, -122, -135,  135,  106,  429, -125, -296, -417,  121,  96,  93,  164,  24,  257, -203, -426, -432,  345,  92,  341,  253,  15,  178,  185,  53,  60, -273,  341, -191,  455, -357,  187, -180,  279, -206, -250, -346, -02, -167, -373, -54, -221,  291,  471, -464, -59, -455, -43, -214,  489, -202, -460,  05, -172, -423, -90,  389, -196, -249, -302, -240, -105,  386,  80,  26,  32, -318, -468, -118,  368, -340,  328, -353,  451, -349,  35, -108,  49,  492, -469,  38,  143, -429, -105,  471, -352,  305, -288, -48, -91, -89, -436, -344,  149,  497, -466,  33, -321, -434,  415, -453, -274, -405, -306,  30, -253, -418, -226,  296, -426, -195,  186,  217, -124, -66,  189,  376,  91, -247, -171, -500,  164,  245,  08,  165,  242,  42, -302, -226,  461, -387, -179, -313,  61,  368,  217,  308,  450, -156,  456, -124,  149,  494, -406, -122, -72, -365, -246, -480, -112,  83, -128, -95,  181, -267, -430, -77, -373,  121,  197, -412,  234, -129, -224,  147,  91, -155, -45,  393,  189,  263, -231,  191,  258, -137, -431,  38,  350, -177,  410,  91, -241, -217,  496,  440,  16, -82,  215,  143, -461, -87, -416,  274, -364, -140, -79,  227, -443, -271,  120, -401, -156, -259,  290, -46,  457,  359,  493,  307,  34,  403, -102,  293,  38,  246, -415, -94, -335,  301, -98, -296,  66, -14, -170,  202, -302, -396,  281, -245, -167,  253,  206, -471,  494, -04, -16,  451,  207,  329, -389,  94, -416,  361, -113,  123,  108, -27, -119,  273,  126,  283,  477, -308, -231, -192,  394,  319, -88,  175, -73, -403, -72, -367, -22,  274,  482,  462, -422, -459, -357, -311,  135, -272, -98, -125, -297, -490, -300,  84, -365,  326, -132, -387, -482,  489,  273,  412,  309,  37,  439, -264,  486,  219,  221, -36, -07,  203,  279,  423, -403,  422, -388,  232, -350,  15, -41,  205,  377,  159, -210, -487, -15,  158, -22,  03,  499, -249,  267,  308, -360,  206, -104, -22,  277, -30,  442,  123,  25, -427,  46,  122,  496,  159,  207, -02,  26, -334, -296, -97,  326, -06,  268,  163,  04, -254, -333,  03,  349, -214,  164,  489, -155, -88,  319, -378,  382,  262,  245, -92, -313, -208, -118, -317, -197, -411, -466, -319, -244, -262,  84, -66, -416,  205, -403,  440,  451,  116,  295,  301,  403,  311, -358, -252, -276,  462,  222, -42, -424, -32, -282, -237, -388,  101,  299, -85,  190,  333,  96, -202, -77,  32,  232,  359, -263, -318,  299,  41,  298,  446,  194, -447,  258,  336, -199, -166, -350, -124,  292,  78,  344, -489, -306,  456,  112, -155,  223,  154, -322,  171,  453,  453, -297, -463,  312,  293, -281,  463,  186, -130, -239, -120, -77, -481,  68, -423, -147,  219, -47, -02,  149,  149,  09, -305,  457, -27,  40,  180, -373, -430, -149, -68, -477,  406,  322, -313, -449, -107,  02,  237,  263,  264, -383,  39, -365,  186,  468, -11,  257,  273,  487,  258, -78,  348,  454, -121, -179, -06, -89,  300,  65,  262,  85,  440, -480, -93, -372, -428,  300,  482,  309,  416,  246, -221,  307,  382,  465, -373,  223, -426,  400, -438,  332,  174,  410,  286, -95,  83,  133,  316,  235, -302,  430, -180, -362,  450, -421,  118, -126,  380,  101, -316, -352,  199,  315, -193,  433, -368, -66,  156, -294, -166, -430, -110, -492, -168,  29, -87,  415, -338,  81, -497,  212,  363, -177, -298,  313, -97, -327,  40,  135,  274, -424, -365,  325,  391, -58,  259, -477,  376,  267, -271, -290,  338,  471,  70,  22,  00, -165, -62,  162, -232,  293,  226, -369, -384,  429, -204,  371, -398,  336,  358, -272,  412,  493, -447,  303,  287, -336,  326,  163,  432, -93, -275, -378, -121, -353,  144,  379, -18, -66,  394, -398, -273,  472, -267,  196,  401,  30,  419, -145, -134,  278,  435, -221, -377, -159, -66,  411,  05,  113,  426,  289, -128,  04, -237, -397,  151,  408, -165, -14,  194, -271,  88,  422, -299,  322,  470, -45,  204, -259, -338, -430, -481, -402,  201, -05,  291, -12,  258,  148, -399, -464, -62, -27,  40, -447,  429, -308,  461, -236, -470, -492, -07,  118, -218, -454,  292, -248,  353, -04, -07, -484,  419,  365, -34,  120,  212,  109, -40,  322, -243,  61,  358, -453, -113,  251, -399, -184,  443, -86,  80,  473, -78, -75,  443,  204,  323,  236, -192,  177,  84, -346, -455,  03, -129,  363, -24, -417,  324,  436,  405, -419,  350, -385, -19,  89,  366,  434,  405, -339, -152,  337, -14, -377,  114, -70, -321,  289,  18, -12,  318, -398,  142, -285,  106, -487, -422, -418, -52,  402, -482,  205, -164, -280,  320,  317,  309,  187, -397, -434, -300, -49, -245,  187,  74,  369, -31, -394, -489,  487,  94,  329, -411,  88, -103, -453,  453,  327, -371,  253,  230,  00, -42, -82,  220, -222,  87,  30, -183,  190,  448,  370, -07, -296,  57, -80, -75, -474,  26, -64, -487, -28,  118, -46, -440, -485,  02, -135,  342,  483, -382,  424,  335,  76, -158,  56, -294, -219, -62,  376, -177, -114,  246,  317,  442, -197, -263, -132,  181,  263,  304, -454, -265,  274,  00,  147,  289, -146, -488,  484,  190, -18,  408,  25, -442,  103, -67,  116, -264, -277, -08,  60,  462, -262, -123,  404,  393,  114, -228,  74,  229, -71,  472, -184,  55,  325,  463, -155, -321, -173,  181, -279,  309,  89,  247, -281,  44,  32,  335,  281,  256, -172, -159, -430,  418,  218,  474,  312,  184,  99,  238, -87, -120, -437,  229,  435,  388, -456,  132, -81, -129, -187,  141,  32, -245,  240,  251,  299, -228,  86,  432, -120, -234, -227, -50, -315,  491,  277, -151, -473,  228, -61, -60, -40,  02,  21, -105, -110,  417, -120,  310,  140, -455,  303, -328,  152,  43, -225,  304,  315,  362,  236, -304, -20, -490,  498, -483, -147,  275, -134, -119,  355, -342, -327, -185, -488, -453, -437,  255, -184, -57,  65,  457,  340,  220, -19, -07, -237,  257, -203, -70,  471, -115,  478, -49, -105,  477, -31,  249, -396, -313, -18,  460,  197,  155, -225,  210, -446, -162, -35, -129, -367, -118, -172, -174, -398, -339, -329, -135, -230,  320,  295, -259, -295, -374, -455,  101, -397,  366,  202, -293, -95, -316,  19, -397, -309, -353, -335,  98,  337,  130,  469,  471, -136,  149,  149, -34,  310,  320, -317, -67,  140, -170,  174, -303, -44, -429,  298,  411,  437,  352, -29, -157, -112,  490,  298,  432, -363,  463,  30,  475,  445, -01, -202, -191,  00,  447,  275,  162, -381, -190, -405, -389,  140, -378, -192, -51, -307, -41, -140, -17, -189,  331, -322, -448, -326,  476,  484, -189, -209,  14,  138, -264, -135, -212,  45,  365,  87, -180,  379, -442,  482,  475, -331,  122, -403, -22, -77,  142, -211,  284, -375,  452,  467, -197, -496, -359, -221,  488, -47,  70,  02, -57, -342, -281, -416,  203, -416,  171, -125,  464,  230, -143, -209, -249, -168, -112, -419,  255, -470, -130,  391,  08, -177,  359,  311, -173, -500, -57,  168,  305, -135,  22,  101,  24,  242,  185, -273,  326,  208,  103, -358, -62, -188, -67, -458,  144, -327, -377,  252,  56, -06,  495, -436, -331,  354,  375, -04,  355, -182, -336, -488,  184,  187,  113, -292,  281,  150,  287,  107, -141, -110,  250, -351, -445,  35, -309, -449,  209, -185, -345, -235, -339, -349, -171, -170, -495,  56, -322, -288,  375,  195, -275,  411,  234, -310, -381,  15,  341,  406, -378,  52,  149, -276,  201, -444, -388, -255, -393,  321,  412, -237, -62, -427, -86, -381, -97,  271,  175,  81,  484,  402, -224,  61,  313, -490, -397,  432,  25, -204, -309, -500,  348, -308,  76,  402, -252,  188, -353, -145,  361, -441,  470, -201, -368, -116, -82,  387,  08, -54, -32, -08, -152, -403, -95, -338, -393,  08, -54,  485, -343,  137, -163, -495,  329,  413,  407, -423,  102, -94,  285, -37, -35,  255,  263,  449, -08,  33,  336, -500,  479,  157,  344,  180,  254,  101,  342, -287, -391, -212,  50,  118, -222,  387,  124, -41,  301,  383,  37, -97, -210,  174, -282, -393, -71,  481, -443, -227,  367, -255, -227, -302,  402, -31,  378,  156, -430, -428, -278,  32,  213,  272, -350,  491, -488, -374,  302,  313, -490, -161,  68, -200, -135,  286,  259,  295, -380,  316, -80, -161, -438,  194,  37,  464,  15,  268,  473,  86, -308,  47, -382,  405,  171,  120, -252,  183,  247, -449,  348,  257,  242,  268, -91, -392,  55, -332, -245, -473, -163, -473, -134, -101, -427, -245,  215,  89, -125, -460, -325,  420,  439,  145, -323,  111, -235, -74,  146, -488,  329,  347,  269,  423,  115, -322, -117,  22,  199,  490,  49, -464, -482, -233,  287, -409,  375,  02,  180,  102,  395,  355,  22,  334,  352,  200,  297, -382, -22, -56, -370, -193,  143, -248,  82, -242,  282,  466,  281, -19,  456, -170,  369, -174,  450,  156, -82,  325,  11, -402, -73, -94, -194,  450,  92,  10, -498, -110,  128, -20, -314, -389,  287,  329, -137,  221, -61, -355,  187, -280,  479,  496,  403,  348, -178,  353,  05,  240, -470, -132, -309, -43,  274,  349,  259,  218, -141,  261, -40, -160, -259,  498, -49, -120, -321,  314, -398,  119,  459, -359,  339,  438, -363, -406, -361,  312,  447,  144,  404,  477, -136, -405,  287, -362, -204,  398, -292, -492, -488,  169, -152,  105, -481,  299, -162, -301,  113, -60,  318,  424,  433, -491, -285, -77, -396, -146, -265, -97, -150, -361,  233,  214,  87,  372, -296,  383,  270, -88,  391,  282, -67, -261,  240,  305, -110, -422, -496, -145,  370, -326, -220,  303, -317,  347, -274,  139, -299, -39, -457,  403,  453,  276,  117,  40, -500, -327,  275,  270,  437,  167,  405,  223, -242,  145,  28, -499,  223,  32, -144,  93, -442,  136,  248, -259,  335,  475, -267, -464,  288, -224, -209, -407, -96, -240,  133,  256, -67, -91,  26,  223, -72,  283, -54, -462, -72,  474, -461,  03,  358, -104, -52,  416, -116, -303,  09, -280,  24,  242,  108,  164, -130,  400,  258, -374, -340, -109,  382,  446, -348,  261,  169,  432,  44, -385,  471, -175, -59, -490,  328, -201,  258,  129,  67, -05, -322, -424,  215,  202,  319,  175,  218,  41,  427, -24,  168, -412, -280,  402, -114, -128,  163, -445, -195, -292, -330,  128,  33,  463,  490,  213, -238,  249, -158,  329, -256,  20, -243, -189,  74, -72, -162, -207,  470, -234,  269,  490,  206, -159,  392, -408, -434,  408, -353,  223, -384,  169, -149, -499,  132, -159,  214, -254, -58, -91, -73,  186, -219,  184, -151,  356, -387,  188,  01, -65, -194, -230, -75, -488,  464,  169, -396, -470,  77, -249,  253,  193, -228, -44, -454,  404,  297, -387,  02, -260,  22,  429, -222, -345,  465,  480, -489, -422, -480,  12,  365, -174, -365, -210,  190, -401, -188,  294, -19,  389, -103, -266,  435,  169, -458,  481,  425,  339, -54, -73, -69,  468,  208,  210, -24,  173, -458, -13, -396, -438, -148,  469,  240,  339,  112, -70, -210,  424,  76,  271,  313,  473, -143, -400,  494, -101, -418, -229,  90,  28, -450, -478,  349,  258, -416,  177, -69, -22,  16,  35,  40,  368,  357,  132, -441, -31, -438, -151,  245,  138, -28,  410,  463, -319, -489, -191,  432, -55,  80,  23, -175,  130,  397,  26, -112, -167, -297, -329,  311,  220, -441,  203,  440,  416, -165, -500,  237,  249,  201,  334,  239,  26,  244,  202,  207, -393, -137,  140,  404,  443, -337,  82,  73, -88, -40, -187,  245, -484, -16,  56, -412,  395,  111, -472,  311,  446, -120,  400, -453, -66,  234,  286,  460,  331,  340,  167, -210, -297,  159,  47, -02,  322, -19, -77,  86,  441,  236, -169,  457,  72, -261, -455,  320,  350, -74,  131, -352, -342,  384,  47,  92,  470,  185,  404, -347,  377,  424,  296, -420,  83, -157,  430,  258,  324, -147, -156, -383, -59, -472, -425, -134, -233, -28, -314, -30, -250, -331,  470, -91, -95,  18, -147, -124, -297,  110,  381, -419,  34,  177,  13, -31, -128,  296, -273,  48, -351,  72,  166,  443,  452, -407,  161, -281,  417, -301, -459, -332, -132, -488,  429, -374,  30,  134,  02, -415, -256,  235, -334, -370, -87, -468,  100, -363,  328,  327,  186, -171,  251,  204,  124,  203, -351, -215, -225, -434, -16, -184,  86, -295, -172,  15, -169, -290,  02, -315, -204,  246, -228,  314, -271, -463,  346,  329, -325, -474, -492, -287, -144,  260,  417, -168,  315, -434,  118, -410, -16, -46,  259, -429, -489, -413,  438,  194, -202, -60, -269,  446,  39,  04,  260,  268,  393,  459,  97, -432,  485,  457,  133,  193, -431,  50, -474,  385,  468,  496, -173, -47,  302, -414,  376, -334,  26,  314,  360, -324, -245, -56, -378,  294, -200, -266,  62, -307,  45,  11,  114,  31, -32, -253,  76,  38, -350,  102,  275, -382,  450, -46,  423,  253,  393,  299,  419, -81,  114, -369,  447,  369,  427, -79, -485, -273,  155,  77,  273, -299, -60, -113, -416, -240,  134,  160, -350,  284,  115,  425, -245,  417, -120, -322,  170, -227,  478,  441, -456,  444, -75,  491, -335, -148, -88, -320,  432, -81, -391,  205,  472,  401, -408, -92, -339, -422, -79, -188,  363, -464,  89, -30,  453,  469,  148,  476,  94,  478, -231,  490, -226, -454,  481, -61,  251,  245,  119,  183,  17, -420,  240,  341,  481, -316, -250, -357, -238,  171,  307, -23, -441, -104,  447, -136, -134,  448,  192, -188,  426, -186, -197, -299, -140,  136,  492, -389,  234,  464, -354, -249, -456, -262, -408, -474, -78,  194,  21, -463, -135, -172,  366, -76,  224,  314,  289, -58, -386,  333,  255, -460, -353, -90,  93,  08, -454,  438,  471,  280,  402, -30, -117,  446,  208,  328, -176, -17,  22, -303,  20,  388,  25, -114,  164,  102,  52,  305, -456,  166,  139, -349, -441,  286,  413, -496,  146,  460,  442,  118, -408,  344, -412,  328, -357, -352,  156,  319,  131, -322, -483,  03, -82,  394,  390, -417, -04,  294,  388,  393, -39,  379, -456,  20,  166,  458,  24, -188, -230,  319, -218,  214,  163,  222,  42, -342,  371, -302,  478,  354, -123, -153, -142,  295, -259,  100, -270,  238, -106, -29,  131, -293, -150, -473,  227, -484, -163,  104,  181,  459,  275, -185,  174,  290, -462, -284,  449, -239,  267, -221, -33, -356,  126, -323, -209, -281, -371,  374,  457,  24, -155,  440, -417,  195, -180, -337, -436, -491,  267, -403,  469,  42, -88,  143,  184, -50, -289,  133, -437,  478, -236,  31, -26,  390, -440,  266, -390, -310,  492, -81,  214, -163,  212, -351, -468, -116, -188, -52, -107, -69,  45, -138, -175,  458, -495, -490,  260, -283,  143, -324,  47,  408, -441, -478, -350, -381, -360,  112, -191, -368, -468, -125, -31, -404,  25,  353, -20,  337,  154,  373, -231, -301, -264,  94,  09,  93,  104,  122, -338,  100,  298,  210,  360,  357, -416, -490, -172, -276,  123,  138, -144, -493, -487, -323, -397,  38, -118,  83, -124, -464,  308,  497,  88, -456,  91, -51,  490,  48, -429, -348, -352, -279, -286, -492, -70, -202, -482,  259,  22,  493, -103, -270, -148, -90,  259, -45, -199, -06, -110, -471,  30, -301, -474, -30,  95,  469,  420,  85,  17, -157, -410, -483,  65, -196, -475,  495,  103, -104, -394, -23, -111,  03, -440, -406, -234, -329,  49,  67,  165, -208,  448,  48,  343, -174, -482, -62, -205, -210, -124, -335,  134, -34, -318, -301, -378, -292,  46,  225,  456,  153,  55, -155, -344,  115, -61,  274,  286, -159,  193,  304,  485,  141, -148,  328,  467, -130, -234,  115, -487,  494,  280,  147, -40,  462,  346,  83,  22,  244,  160, -22, -103,  67, -324,  406,  34,  467,  180,  173,  160, -126, -23,  145, -133,  329, -27, -165,  51, -408, -198,  64, -414, -418,  63,  399, -104, -91, -18, -229, -346, -06,  249,  403, -438, -223,  309,  448, -255,  342,  121,  405,  68, -402,  403,  435, -221, -124,  122, -317, -32,  424, -401,  407, -142,  163,  306,  255, -76,  140, -474,  78, -14, -373,  334,  400, -95,  143,  349, -498,  337, -30, -241, -95,  421, -338, -159, -300,  39,  463,  235, -141, -260,  335,  118,  98, -02, -76,  205,  422, -84,  231,  353,  403, -289,  187,  303,  468,  182,  152,  470,  20, -25, -271,  425, -104,  244,  118,  448,  135,  434,  184, -154, -326,  19,  465,  272, -483, -111, -22, -209, -342,  61, -356, -439, -376, -317,  364, -408, -282,  369, -438, -410, -156,  144, -133, -408,  240,  486, -460, -125,  420,  224,  221, -406, -257,  186, -282,  112, -72,  196, -244,  86,  110,  252,  147,  234, -212,  363,  327,  06, -416, -259,  96, -72, -263,  463,  20,  477, -199,  413,  204, -279,  137, -74,  167, -267, -36, -262, -303,  392, -214, -47,  330,  396, -294,  329,  131, -06, -455,  310, -148, -371, -97,  448,  410,  141, -237,  282,  470,  65,  195,  175, -362, -167, -399, -342,  418,  417, -104, -385, -338, -466,  69,  492,  431, -373, -326,  414,  473, -281, -424,  177,  200, -21,  125,  110, -28, -260, -107, -57, -343, -60, -382,  148,  273,  71, -342,  191, -12,  406, -341, -498,  440, -420,  495,  371,  59,  21, -363,  32,  240, -287, -291, -60,  193, -314, -97, -335,  278, -352,  460,  436,  88, -70,  436,  214, -147, -406,  257, -306, -500,  416, -304,  440,  496, -309,  312,  55, -436,  449, -61,  304,  15, -500,  97, -292,  38, -148,  225, -183,  00, -462,  105, -60, -32,  41, -346,  322,  135,  412, -484,  135, -320, -288,  75, -323,  256,  239, -416,  320, -459,  376,  477,  408,  376,  426, -384, -85, -222, -307, -416, -370, -269,  189,  70, -448, -270,  225, -274,  365,  489, -258,  352, -331,  306,  279,  198,  62,  371,  283,  235,  412, -489, -436,  320,  387,  490, -212,  154,  120,  333,  238, -398, -83, -73, -476,  321,  157, -399, -453,  374, -410, -211,  226, -240, -405,  06, -190, -490,  229, -55, -403,  141, -44, -339,  313, -156,  03, -47, -150, -25,  138, -411,  429, -445,  368,  453,  376,  378, -445, -225,  252, -355,  64,  331,  257, -488,  189, -432, -126, -82,  13, -29, -89, -178,  484,  76, -482,  339, -471, -132, -186, -481,  309, -257, -425, -470,  48, -197,  408,  103,  431, -488, -399, -05,  343, -290,  359,  384,  130, -267, -198, -04, -444,  213,  318, -108,  141,  336, -269, -478, -296,  397, -458, -134, -08, -31, -104, -459, -376, -196,  496, -445, -184, -403,  51,  12,  160,  262, -104, -210,  496,  199,  286, -96,  264,  104,  297,  258,  292, -120,  280, -151,  130,  322,  215, -378, -209, -37,  15, -84,  267,  364, -29, -65, -187, -126, -201,  473, -363,  196, -236, -15,  247, -450,  389,  363, -493, -462,  121,  299, -81, -98, -352, -99, -276, -285,  375,  16,  178, -109, -216,  297,  107,  255, -267,  420, -370,  32,  394, -233,  80,  10, -396, -173,  412,  493,  43,  419, -468, -336, -429,  303,  418,  71, -296, -357, -361, -421, -489,  317,  322,  147,  467, -71, -98,  52,  202,  384, -64,  448,  03, -483, -42,  107,  196, -130,  453, -261,  142,  485,  256, -435, -360,  174,  488,  196, -331, -373, -373,  32, -203, -198, -321, -236, -417,  434, -332,  285, -330,  104,  233,  174,  121, -309,  133,  170,  414,  86, -239,  56,  423, -131,  473, -85, -456,  461, -389,  65, -411,  91, -50,  238,  393,  481, -146,  476, -233,  22, -386, -62, -374,  347, -36, -400, -109, -51, -378, -195, -464, -117, -287, -189,  253,  38, -421, -351, -01, -310, -434,  440, -367,  16,  178, -474, -02, -116, -145, -383,  406, -31,  55, -467,  168, -481, -15, -441,  321,  107,  216,  357,  490, -219,  20, -405,  319,  99,  96,  171, -358,  163,  111, -225,  31,  142,  154, -119, -474, -139, -01, -215,  330, -446,  170,  350, -74, -345,  410, -253,  262,  478, -44, -396,  112,  476,  52,  283,  428, -352, -46, -430,  311, -434,  197,  195, -440, -149, -424, -414,  212,  75, -129,  394,  130, -459,  245, -92,  48, -493,  155,  162, -163, -37, -381,  449,  291,  171,  233,  219, -329, -313,  289, -165,  105, -13, -470,  165, -310, -394, -396, -245,  182,  327,  01,  164, -279, -254, -428,  269, -247, -421,  284,  443,  394,  403,  392,  185,  426,  477, -95, -403, -335,  46, -68, -378, -115,  314, -360,  76,  421, -256, -317,  455, -429,  184,  119,  144,  431, -457,  266,  36, -26,  50,  331, -132,  305,  224, -447,  231,  201,  310,  328, -282, -143,  113,  193,  242,  279,  333,  170,  200, -423,  353, -493,  00,  390,  478, -03, -327, -127, -237, -439,  347,  313,  393,  67,  118,  117,  473,  201,  170,  283,  381, -259, -08,  346,  434, -265,  126,  267, -243,  178, -304, -389,  186, -452, -147,  164,  45,  26, -110,  308,  87, -263,  473, -20, -343,  443, -51, -18,  144, -28, -235,  26, -435,  258,  224,  499, -155, -150, -382,  102, -471,  166, -435,  215,  214, -82,  231,  112, -204, -379,  272,  384,  211, -402,  216, -280, -459,  18,  202, -462, -158, -181,  416, -93, -71,  140,  258,  274,  491, -272,  229, -128,  394, -354, -61,  460,  65,  22,  424, -287,  496,  197, -51,  207,  295, -334, -221, -312, -464,  481,  78,  230, -200, -06, -363,  230, -13, -253,  356,  330, -25,  85, -298,  221,  232,  493, -467,  149,  15,  458,  362,  11, -493, -188,  70, -346,  330,  349, -158, -282,  330,  421,  448, -369,  267, -415, -287,  106,  184, -431, -64, -341,  155,  490,  380,  239,  483,  413, -112, -01,  371, -250, -490, -270,  414,  81, -116,  244, -70,  227, -186,  113, -500, -238, -404, -381,  199, -191,  226, -117, -122,  14,  42, -115,  05,  274, -376,  340,  188,  12,  191,  411, -385, -446, -06, -119,  135,  378, -22, -83,  105,  292, -118,  457, -445, -22, -71, -394,  287,  07, -10, -334, -479, -116,  51,  378, -341, -472,  219, -301,  392, -90, -38, -493, -36,  456,  241, -49,  335, -281, -279,  292, -489,  455, -398, -82, -66,  31,  25, -279, -462, -133,  239, -89,  251,  143, -210,  410,  171, -139, -39,  63, -377,  424,  423,  440, -268,  164,  243, -81, -265, -184, -288, -254, -228,  166, -483,  206, -303,  42, -221,  87,  409, -481,  498, -488, -486,  140,  423,  185, -499,  236,  100, -23, -488,  23,  269, -255,  39,  12,  164,  274,  329, -272, -127, -47,  394, -110, -341, -57, -216,  290, -470,  45,  309, -119,  57,  323, -479,  332,  360, -125,  69, -39, -296,  81, -164,  473, -322, -272, -15,  343, -498,  166, -77, -125, -381,  170, -383,  130, -387, -99, -79, -04,  446,  82,  377,  356,  258, -250,  188,  118,  477, -243, -69, -319,  339, -380, -346, -131, -152,  140, -288,  202,  158,  488, -422, -370,  158,  47,  260, -377, -199,  33,  119, -253, -384,  348, -397,  374, -401,  292,  344, -72, -99,  128,  110,  92,  248,  264,  462, -52,  256,  26, -350, -85,  14,  80,  45,  24, -372,  157, -500, -71, -309,  119, -472, -193,  320, -16,  33, -229,  128, -123,  199, -119, -143, -191,  474, -43, -426,  436,  405, -318,  314, -92,  97,  181, -160, -06, -295,  320, -348,  57,  101,  195, -323,  482, -498, -151, -34,  35,  120, -54, -236,  171,  327,  474,  481, -347, -69, -93, -411,  189,  89, -244, -51,  39,  437,  289, -467, -06,  110,  37, -448,  63, -268,  81,  45,  86,  430, -489, -27,  402,  309, -410,  73,  137, -436,  406,  290,  347, -187, -268,  36, -245,  340, -163,  294,  277, -373, -321,  123, -411, -431,  175,  152,  153,  108, -302, -260,  390,  61,  213,  292, -129, -345,  218, -140, -281,  124,  02, -81, -210,  234, -193,  45,  74,  145,  191,  203,  272,  370, -173, -287, -209, -146, -283,  445, -185, -85, -315, -295, -171, -250,  498,  200, -94,  216, -88,  477,  192,  414, -104,  482, -499,  204,  379,  427, -151,  70,  483, -27,  293,  162, -462, -416, -484, -245, -471, -169,  171,  66,  389, -500, -331,  387, -448,  75,  455,  316,  404,  499,  230, -199,  482, -417, -495,  361, -489,  206,  284, -154, -321,  77, -492, -283, -487, -124, -28, -457, -440, -05,  461,  449,  347, -370, -312, -249, -443, -357, -433,  462, -06, -350,  115,  328, -267,  120,  190,  96, -174,  326,  442,  357, -97, -198, -426, -84,  179,  398,  311,  239,  246, -375,  188,  93,  107,  376,  345,  165, -129, -236,  479,  365, -86,  94,  194, -500,  66,  236,  96, -256,  62,  391, -399, -183, -307,  27,  233,  372, -75,  397,  111, -329, -478,  151, -383,  129,  27, -186,  146, -250,  78,  477, -384,  493,  423, -338, -155, -11, -250,  441,  233,  312, -316,  334, -371,  230,  213, -286,  102, -361, -37,  66,  162,  337,  69, -369,  319, -403, -55, -35,  199, -476,  295,  315, -131,  218, -171,  214, -292,  79, -493, -207,  243,  44, -20,  372, -226, -307, -61, -272,  184, -246, -354, -153, -408,  216,  330,  411, -335, -224, -124,  364,  152,  23, -468, -479, -258, -139, -413,  302, -207, -406, -405, -464,  490,  75, -239, -236,  269,  200, -07, -47, -194,  491, -348, -102,  207,  483, -191,  372,  111, -462, -411, -237,  61, -379, -216, -345,  334,  223,  457, -373, -331, -95, -336, -340, -168, -75, -76, -399, -23, -231,  407,  283, -239, -89, -318,  468,  246,  343, -307, -143,  381, -218,  472,  295,  255,  108,  450,  89, -169,  408,  217,  01,  165, -267,  161,  497, -490, -63, -401,  339,  207, -142,  122, -180, -379, -344,  140, -280, -148,  333,  429, -267, -33,  402, -472,  74,  10,  479, -336, -306, -261, -267,  195,  404,  318,  208,  401,  328, -03, -148,  167, -296, -438,  141,  376,  36, -350,  17,  256,  02, -150, -463, -413, -330,  439, -384,  244,  302, -53, -240,  496, -462, -07, -457, -206,  163, -397,  47, -09,  100, -248,  10,  305, -186, -348,  181, -298,  154,  50, -190, -344,  401, -152, -257, -77, -213,  211,  19, -59,  10,  280, -63,  400,  125,  332, -306, -211,  435, -406, -368,  36, -154,  143,  193, -488, -353,  226, -285,  301, -223,  25, -191,  30,  373,  404,  453,  13,  468, -28,  454, -22, -248,  244,  231, -270,  76, -223,  19,  12, -129,  151, -100,  217, -206, -407, -418,  293,  319, -203,  94, -52, -326,  403,  478, -100, -340, -217,  413, -372,  256, -281,  458, -140,  463,  189,  90,  392,  467, -39,  256, -162, -35, -344, -92,  259,  101, -10,  405,  272, -361, -01, -279, -187,  255,  51, -435, -233,  335, -170, -105,  91,  50, -147, -197,  365, -457, -254, -391, -138,  207,  365,  200, -328, -127, -40, -216,  474, -198,  41, -401, -59, -460, -180, -393, -353,  371, -328, -86, -442,  03, -339,  149, -95,  15, -195, -230,  410,  51, -120, -228,  110,  97, -176, -365,  471,  285,  271, -203, -413, -188,  248,  381,  204, -432,  488, -296, -208,  12,  470, -150, -485, -368, -148, -80,  147, -491, -457,  409,  412,  275, -319,  374,  224,  357, -491,  195,  142, -368, -155, -418, -56, -407, -185,  01,  14, -197,  205, -342,  315,  175,  360, -317,  307,  64,  455,  306,  73, -150,  215,  337, -375, -252,  212,  350, -394,  221,  397, -400,  354,  94,  34,  150, -460,  349, -349,  54, -348,  356, -436, -180,  32,  424,  355,  191,  341,  310, -02, -86, -339,  65, -248,  138,  314,  464, -12, -228, -463,  238, -128, -257, -168,  407,  394, -128,  256, -103, -222, -239,  106, -158,  433, -10,  119,  288, -319, -40,  98, -469, -274, -389,  97,  330,  250,  263,  294, -262, -465, -316, -172,  259, -73, -487, -482,  173, -115, -373, -77, -484, -112, -471, -142,  173,  19, -171, -39,  200,  289, -89, -416, -484,  23, -467,  346, -227, -352,  493,  363, -317,  29, -308, -206, -192,  57, -187, -166, -206, -60,  257, -190, -320,  286, -479, -295,  157, -150,  166,  209, -08, -71,  293,  360,  452,  326, -442,  77,  474, -97, -59,  09,  432,  485, -344,  93,  394,  321,  427, -312,  113, -464, -01,  293, -326,  372,  498,  331,  74, -484,  40, -434,  297,  186, -222,  250,  364, -163,  179, -309,  240, -28, -448, -475,  309, -292,  470,  203, -471,  397,  392,  142,  433,  243,  287, -393,  115, -363, -210,  41,  05,  330,  460, -197,  368, -262, -95,  233,  75, -416,  424,  168,  57,  476, -455, -134, -315, -485, -430,  66, -236, -186,  61,  49, -91, -152,  156, -124,  338, -202,  417, -157, -372,  377,  146,  497, -384, -449, -418, -457, -12, -494, -437, -455,  482, -392,  263,  19, -25, -315, -62,  239,  351,  499, -212, -240,  199, -204,  136,  37,  446,  54,  381, -425, -69,  379, -76,  399, -217,  06,  443,  271,  364, -142, -332, -302, -33,  431, -430, -206, -31,  08, -114, -180,  07, -474,  81, -294, -177,  69,  244, -231, -377,  477,  196,  407,  356, -28, -342, -09, -170, -47, -238,  46,  312,  282,  245,  131, -434,  315,  425,  35, -177, -189, -293, -318,  190, -360,  240, -135,  210,  336,  486,  333,  313,  183, -408, -478,  07, -249,  365, -310,  204, -20,  236,  368, -238, -19, -01, -172,  148,  277, -285, -177, -60,  275,  05, -370,  415,  98, -05,  125, -66, -18,  311,  100,  17,  403,  474, -124,  06,  339,  66,  63, -181,  155, -69,  434, -12,  431,  114, -363, -440, -318, -40,  00,  457, -182,  131,  372,  416, -374, -02,  202,  460, -191,  154, -23,  64,  128,  354, -77,  320,  272,  486, -09, -73,  269,  277,  416, -448, -108, -95, -388,  74, -283,  113,  31,  35,  96,  255,  303, -426, -247,  358, -465,  414,  12,  364,  331, -07,  218, -246,  165,  343,  92,  08, -230, -139, -214,  38,  266, -470,  443,  378,  104, -339, -09, -13, -452, -61, -258, -296,  14,  348, -438,  49, -386,  426, -87,  445,  271, -16,  51,  288, -173, -05, -203,  449, -291,  83, -12,  475,  113, -69,  353,  69,  444,  197, -92, -155, -364,  150,  49, -498,  350,  463,  51,  465, -259, -183, -238, -487,  301, -334,  301, -20,  161, -402, -71,  370, -467, -231, -303,  498, -447, -97,  67,  497, -400, -173, -158,  88,  478, -257,  91, -320, -294, -06, -355, -52,  311,  260, -39,  464,  426,  114, -56,  87, -435, -274,  310, -402, -05, -493, -51,  48, -90, -132,  398,  362,  196,  92,  303, -474,  336, -106, -294, -458,  388,  204, -10, -448, -36, -197, -132, -110, -230,  313,  477, -165, -109, -361,  285, -262, -01, -266, -361, -239,  103, -463, -376, -201,  481,  427, -175,  317,  173,  383, -288,  413,  87, -446, -183, -449, -142,  186, -59,  480,  351,  271, -185, -258,  410, -400,  332, -91,  187,  471,  171, -210, -140, -353,  89, -158, -74, -234, -341, -49, -351, -129, -136,  237, -74,  182,  288, -364, -132,  82, -32, -281, -147,  283,  313,  115, -265,  145, -475,  422,  469, -452,  64, -171,  47, -347, -477,  473,  271, -317, -76, -227,  406, -360, -490,  184,  322, -350, -328,  42, -416,  140, -387, -63,  275,  426, -95, -489,  424, -70, -215,  393,  330,  350,  74, -123, -145,  98,  202, -373, -367, -22,  252, -109,  118,  262, -72,  293, -236,  100,  187,  201,  93,  301, -362,  220, -421,  395,  231, -145,  177, -131, -252,  07, -281, -325, -264,  426,  273,  438, -447,  406,  268, -343, -203, -113,  419,  225, -320,  36,  178, -281, -263,  123, -480,  227, -157, -48,  123, -73,  307, -200,  296, -92, -340, -133,  83,  248, -207,  208,  187,  199,  114,  307,  356, -237, -306, -372, -159,  226,  164, -129,  446, -247, -154, -182, -168,  189,  270, -193, -384,  430,  460, -236,  190, -28,  131,  125, -280,  425, -167, -241,  476, -201, -433,  332,  414, -239,  460,  107,  488,  476,  478, -214,  81, -176,  104, -234, -134,  227,  73, -18, -491,  385, -401,  199, -143,  230, -176,  78, -493,  157,  337,  483,  456,  404, -332, -278, -334, -20,  330,  06,  309,  308, -356, -110, -15, -400, -492,  351,  327,  82,  185,  336, -33,  284,  35,  325,  367, -289, -97,  374,  368,  92, -290, -324, -03,  230, -101, -485, -290,  81,  373, -481, -111, -483,  262, -274, -383,  270, -423, -203,  204, -385, -367,  24,  399, -479, -151,  266, -268, -396,  493, -47,  196,  55,  129,  45, -215, -120,  60,  347, -187, -67, -281, -445, -50,  481, -219,  420, -397,  211, -283,  308,  326, -150,  184, -423,  223, -467, -304,  456, -11,  41, -91,  37, -404, -110, -417,  233, -377,  143,  432, -64, -423, -349, -09,  379, -16, -375,  299,  440,  336, -484, -400, -486,  219,  284, -409,  294,  317,  139,  250,  158, -320,  11, -305,  128, -246, -222, -139,  229,  422,  146,  17, -149,  297, -139, -270,  134, -14, -118,  74,  174,  250,  174,  188,  321, -42, -369,  116,  127,  271, -134, -215,  451, -270,  332,  80,  336, -389, -207,  65, -467,  439, -418,  236, -411,  295,  466,  223, -219,  200,  149,  455, -49, -177,  143, -228, -367, -373, -260,  260,  398,  459, -103,  349, -311, -271,  281, -123, -160, -73,  442,  225,  218, -124, -39,  307, -328,  280,  382,  305, -20,  31,  261, -217, -294,  256,  408,  191,  383, -352, -49, -367, -393, -300,  483,  148,  282, -384, -475, -378,  43,  467, -300,  114,  196, -487, -79, -280, -355,  156, -475,  478,  39, -362, -239, -402,  395,  21,  289, -370,  170,  93, -236,  277,  293,  99,  278,  75, -433,  303, -450,  111, -377,  102, -275,  319,  115,  498, -109, -387, -494, -84, -409,  398,  55,  204,  496,  302, -274,  285,  432,  396, -122, -304, -475,  24, -353,  303, -401, -285,  107,  01, -322, -418, -397,  255,  401, -429, -395,  144, -316, -388, -440,  127, -490,  115, -169, -494, -83,  57, -357,  202, -47,  374, -250,  331, -102, -102,  134,  349,  465,  93,  203, -357,  175, -342,  398,  428, -271, -497,  72,  265, -33,  485, -108,  329,  452,  224, -313,  222, -219, -169, -76, -413,  57,  174,  418,  455, -76,  404, -344,  241, -02,  359,  384,  25, -482, -366,  306,  99, -10,  230, -135, -191,  215, -391, -361,  168, -315, -174, -110,  319,  157,  314,  406, -286,  340, -324,  21,  117, -68, -470, -142, -218,  389,  95,  308, -241, -419,  114, -289,  71,  196,  76,  381, -88, -463, -480, -420, -277,  198,  322, -458,  208,  488, -200,  422, -320,  328,  296,  297, -240, -322,  08,  43, -433, -45,  203,  179,  36,  169,  390, -40, -135,  318,  193,  277, -293, -435, -291, -70,  263, -469,  324, -29, -481, -24,  246, -300, -196,  394, -151,  417, -428,  357, -40, -09,  164, -337, -330,  53,  332, -88, -487,  49,  82, -442, -173,  290, -377,  36,  72,  386,  68,  249,  210,  87, -275, -44, -361,  382,  202, -11,  299,  274,  198,  111, -235, -137, -374,  288, -232, -190,  52, -219,  359, -365, -161, -314, -223,  314, -425, -299, -448,  495,  450,  262,  82,  28,  70, -426,  262, -228,  63,  413, -454, -239,  24,  164,  476,  150,  304, -256, -188, -144,  377, -329,  343,  68,  210, -380, -118,  285,  174, -65,  280,  124,  49,  214,  04, -28,  288, -234,  244, -149, -321, -357,  465, -445, -341,  441, -443,  463,  38, -131, -181, -85,  41,  15,  484,  103,  487,  218, -112,  161, -347,  20,  138, -445,  86, -06,  27, -125,  261,  123, -422, -208,  266, -105,  200, -223, -163,  257, -260, -273, -21,  412,  142, -480, -73,  478,  475, -86,  197, -137, -72, -298, -265, -434, -243,  321,  60, -364,  48,  173,  260,  127, -182,  378, -478, -482, -344,  211,  275, -104,  438, -246, -192,  433,  126, -413,  411,  101,  354,  460, -184, -218, -337,  403, -152,  272,  225, -240,  409, -227, -214,  169, -248,  104,  47,  127,  122, -445, -162,  249, -48,  129, -144, -388,  414, -166, -300,  325, -212, -446, -362,  456,  188, -199,  360, -112, -427,  437,  148, -166,  62,  434, -145,  315,  390, -245, -58,  12, -190, -368,  114,  262, -387,  470, -273, -473,  156,  279, -295,  444,  333, -157,  401,  373,  496, -387, -239, -431, -450, -239,  256,  112,  48, -389,  279, -62, -134,  73, -197,  177,  206, -231,  291,  319,  91, -482, -301, -253,  297, -96, -308,  482,  247, -55,  355,  243,  58, -32, -336,  460,  230, -228,  72,  130, -116,  204, -432, -398, -223,  223, -369,  483,  492,  423, -345,  83, -207, -146,  331, -57, -390, -125, -75, -291,  320,  133, -196,  230, -47,  320,  190,  35, -407,  114, -335,  329, -182,  86,  431,  448, -191, -437,  431, -198, -162, -62, -263,  131, -356, -432, -426, -246,  295,  352, -37,  467,  337,  267,  197,  142,  88,  239, -322, -467,  206, -157,  362, -476, -219,  293,  472,  91, -292, -244, -255,  46, -454, -18,  30, -309,  403,  104,  297, -450,  308, -239, -482,  497, -120, -433,  492, -180,  307, -330, -147,  13,  365, -285,  389, -353, -139, -286, -410,  69,  322, -165, -384, -280, -331,  146, -89, -76,  102,  61, -25,  263,  322,  345, -388,  54,  412, -396, -273, -429,  126,  80,  436, -08, -352, -322,  491,  361,  244, -419, -70,  66,  268,  398,  286, -211,  396,  50, -434,  351, -389,  41,  466, -215,  238, -422, -309,  150,  35, -82,  222, -339, -149,  158,  153,  351, -312,  496,  212,  432, -71, -06, -02,  49, -107,  137, -309,  141,  39, -243,  344,  150, -350,  310, -213,  388, -259, -22,  38,  276, -251,  112, -211,  100,  123, -205, -49,  311, -209, -337,  244,  221,  157,  94,  122, -98,  83,  313, -104, -378, -430,  92, -376,  72, -97,  263, -40,  496, -258, -149, -376,  343, -185, -87, -57,  438,  208,  394, -398, -148, -91, -302, -75, -82, -356, -453, -327,  228,  361,  69, -298, -217, -339,  179,  356,  416, -58,  168,  412, -464, -481, -112,  379,  187,  302, -178,  477,  362,  68, -421, -286,  477,  129,  139,  248, -374,  187,  421,  354,  400, -10, -92, -317, -497, -413, -109, -228,  382, -440,  36,  418, -69,  425, -350, -382, -421,  324, -404,  441, -107,  27, -344,  222, -343,  295, -30, -217, -18, -109, -11, -118, -267, -251,  418,  89, -163, -191,  361,  71,  221,  249,  341, -347,  174,  491, -229,  253,  316, -133,  195,  61,  395,  351, -217, -96,  146, -394,  187, -19,  349,  28, -285, -65,  277, -15, -476, -34,  295, -263, -463,  368,  486,  379, -479,  161, -278, -207,  266, -462, -488, -39,  99, -241,  164, -265,  163,  163, -159,  202, -04, -310, -270,  211,  125, -140,  49, -499,  326, -156, -262, -284, -288,  77, -405,  86,  90,  169, -269, -144, -440, -257, -330,  159,  03, -314, -254, -334,  349,  439, -279, -155, -370, -49, -91, -393,  311,  458, -39,  490,  154, -449, -294, -282,  128,  153, -344,  70, -178, -113,  427, -118,  131, -51, -106, -14,  135,  140,  152, -15,  80, -275, -318, -438,  177,  443,  21,  340, -247,  482,  330, -241, -114, -464,  330, -134,  189,  486,  437, -136, -126, -284,  246, -495,  165, -360, -09, -200, -367, -05, -363, -435,  221,  172, -373,  250,  467, -500,  90, -279, -165,  273, -20,  221,  309, -190, -413,  351, -203, -124, -285, -477,  92, -187, -472, -243,  306,  371,  410, -209,  218, -453, -144,  291, -429,  335,  41, -461,  335, -16,  112, -330, -243, -408, -257, -82,  255,  183,  121, -96, -441, -312, -73, -496,  02,  307,  113, -192, -470,  23,  99,  248,  423, -193,  40,  494, -358, -67, -115,  477, -231,  497,  00,  26, -58, -405, -203,  49,  278,  418, -195, -310, -41,  232, -306,  461,  391,  307,  121,  421,  183,  72, -479,  106,  379,  413,  452, -127,  199,  190,  202,  468,  187, -298, -05, -371,  150, -356, -470,  280, -86, -165,  470,  373, -81,  16, -314, -190,  176,  307,  83,  211,  231,  457,  169,  110,  370,  121,  483,  69,  163, -462,  38, -149,  92, -115,  332, -258,  381,  363, -477, -205,  50, -155,  21,  470,  362,  207, -220,  390,  367, -284,  101,  98, -327, -230,  61, -105, -257,  44, -183,  407,  434, -293, -242,  27,  444, -58,  269,  325,  157,  292, -28, -292, -362, -155,  30, -148, -447, -338, -258,  420, -122,  343,  370,  403, -387, -69,  151, -144, -172,  468,  115, -238,  27, -275,  289, -29,  168,  59,  148,  177,  203, -380, -263, -307, -34,  267,  45,  371,  430, -361, -357,  160,  482, -487,  64, -53,  297,  67, -344, -375,  35,  271, -113, -86,  497, -323,  385, -483, -412,  33, -454, -357, -495, -216, -163,  323, -97, -266, -454, -167, -126, -311, -154, -144,  55, -238, -344, -148,  329, -188, -23,  216, -65, -284, -370, -68,  245, -485,  301,  333,  400,  348,  477,  405, -16,  166,  229,  387,  400,  275,  73, -226, -183, -229,  483, -276,  33, -361,  76,  214,  303, -95, -70, -262,  121,  60, -477, -133,  427,  324,  52, -321, -476,  381, -416,  360,  47, -335, -400, -52, -207, -475, -426,  462, -204, -443, -314, -319,  48,  262,  395, -149,  19, -175,  90, -360, -263,  113,  359,  16,  289, -88,  195,  314,  145, -369, -474, -307, -203, -374,  493,  442,  03, -433,  404,  299, -23, -410,  480, -475, -296,  375, -123,  223,  52,  467, -285, -359,  432, -425,  157,  221,  339,  204,  387, -16,  336,  414,  177, -15, -108, -478,  279,  396, -58,  183, -453,  419, -375, -472, -204, -171, -245, -475, -96, -340,  492,  119, -199, -224,  194, -189,  498,  33, -485, -263, -130, -297, -349, -453,  188,  396, -78, -33, -356,  364,  02, -309, -365,  127,  71, -69, -192, -321, -43,  212, -161,  301,  184,  492, -422,  230, -197, -72, -236, -181,  165,  486,  374, -331, -467,  63, -83, -45, -118,  61,  171,  385,  252,  306,  364, -176, -262, -327,  355, -453, -263, -306,  348,  421, -314, -222,  152, -10, -442, -232, -339, -424, -246, -465,  97,  139,  450, -486, -53, -167,  75, -30,  70,  179, -223, -66, -145,  367,  459, -290,  414,  49,  256, -386,  322,  443,  245,  326,  285,  303, -54, -202, -269, -448,  185,  328,  192,  136, -306, -09, -179, -379,  461, -257,  301,  90,  177,  08, -43,  489, -429, -129,  38,  327,  338,  212, -378,  83,  39,  407,  238,  485,  57, -178, -462, -257, -350, -418, -269, -155,  73,  52, -34,  386,  295,  119, -23,  324, -372,  434, -335,  51,  158, -445, -122,  348,  268,  01,  283, -193,  260,  21, -208, -182, -305, -170,  61,  198,  264, -356, -457, -163,  196,  361,  76,  343,  333, -447, -481, -187, -161,  37,  364,  497,  92, -258,  345,  212, -405,  128, -481,  356,  02,  164,  26, -451, -154, -61,  247, -389,  83, -358,  300,  131, -496, -124,  326, -311, -71, -303,  02,  269,  234,  218, -382, -173,  460, -184, -109, -92, -204, -89,  116, -350, -73, -358, -300,  273,  81,  447,  384, -336, -410, -463, -353, -54, -87,  473,  487,  343, -330, -11,  464,  405, -293, -66,  84,  19, -398,  475, -221,  251,  238,  395,  401, -335, -463, -47, -209,  470,  253,  27, -14, -305,  64,  133,  493,  478,  106,  480, -327, -371,  321, -11, -114, -472, -225,  470,  399, -122, -203, -321, -19, -112, -74, -118,  405, -36, -312, -304,  286, -207,  224, -227, -12, -212,  406, -19,  118,  365,  313,  291,  494,  134,  132, -120, -486,  408,  202,  413,  138, -149, -56, -381,  239,  371,  353,  145,  187, -459, -307, -27, -166,  417,  246, -326,  58, -495,  155,  28,  370,  320, -180,  364, -46,  452,  96, -32, -288, -202,  234,  350,  149,  30,  469,  241,  253,  323,  238, -60, -284,  431, -234,  51, -299, -136,  225, -389, -131,  233,  139,  91,  53, -189, -45, -492, -236, -97,  328,  328,  201,  414,  179,  203, -55,  148,  296, -302,  323,  34,  139, -460, -35, -243,  443, -482,  121,  168, -371, -157,  253,  269,  434,  159, -420,  242, -481,  196, -355,  347,  25, -301,  262,  56, -246, -293,  56, -450,  257, -120,  84,  248,  272, -99, -495,  215, -80,  479,  235,  401, -178, -11,  170,  108, -352, -397,  202, -333, -349, -300, -134, -472, -101, -20,  84, -495, -461, -07, -445,  297,  373,  491,  45,  145, -108,  403,  212, -336,  382, -53, -434,  56,  436, -412,  16, -64, -309, -281,  455,  195, -81, -178,  223, -330,  302,  160, -325,  342, -347, -270,  491, -122,  73,  36, -125,  465, -61, -413, -18,  173,  34,  48, -271,  323,  136,  246, -241, -320, -183, -285,  375,  236,  389,  98,  406,  191,  110, -67,  385,  263,  163, -272, -359,  88,  265,  16,  405,  56,  103, -113,  82, -10,  435, -337, -187,  424, -239,  72, -44,  78, -361, -169, -186, -472, -219,  72, -428,  392, -495, -191,  155, -480,  38, -351,  108,  155, -483,  14, -289,  473, -247, -355, -37,  41, -191,  276, -35,  70,  200,  421,  01,  340,  104,  315, -280,  385,  240, -208,  277,  245,  102,  285, -382, -360, -214, -422,  295, -197,  444, -142, -224, -302,  04,  239,  239, -335,  367,  56,  235,  420, -23,  88, -388, -67,  256, -168, -182, -04,  125, -52,  93,  79,  85,  211,  219,  371, -358,  366, -326, -414, -276, -49, -216, -420,  42, -477, -255,  262,  79, -167,  182, -92,  421,  294,  341,  177, -374,  12,  25, -397,  460, -381,  182,  45, -318,  253, -84,  176,  119,  442,  263, -304,  245, -453,  128, -212, -77,  374, -98, -146,  59, -64,  263,  332,  82,  456,  362, -440, -32,  239, -336,  280, -290, -302,  177,  245,  452, -55, -79,  71, -112, -316, -381, -367, -268,  248,  273, -493,  474,  27, -139,  33,  463, -376,  217,  45, -67,  431,  106, -247,  171, -378, -114,  381, -180, -437,  126,  124,  361, -100,  48, -251,  84,  167,  234, -332, -85,  360, -325, -111,  239,  37, -226,  203, -487, -156,  100, -54, -225,  58, -448, -202,  180, -62,  32, -147,  353,  10,  477,  214,  410,  377, -185, -05,  45, -98,  163, -188, -238, -309, -446, -499,  228,  180, -444, -407, -476, -491,  392,  152,  67,  444, -198,  100,  234,  334, -195,  87, -155,  134,  154, -245,  12,  469, -398, -443,  223,  266,  221, -163,  457,  275,  191, -463, -44,  247, -370,  332, -392, -478, -16,  176, -182,  287,  128, -448,  473,  433,  492, -182,  419,  146,  426, -69,  467, -472,  340,  191,  294,  62, -472, -397,  189,  219, -08, -355,  319,  475,  478,  427,  497,  314,  455,  168,  101,  83, -428,  75,  368, -436, -255,  288, -438, -329,  71, -470, -300,  264, -427, -154,  178, -399,  302, -133, -327, -206,  13,  492,  121,  343, -229,  119,  157, -273,  139,  111,  310,  211,  38, -469,  276,  283, -329,  338, -193,  242, -280,  07,  358, -207, -295,  36,  247, -493, -244,  420,  154,  269, -236, -225,  464,  35, -254,  121,  262, -263, -268,  425,  449, -378,  456, -423,  406, -21, -233, -287,  73, -12, -428, -68, -367,  129, -180,  380,  489,  76, -348,  143,  197, -84, -230,  161, -196,  369,  135, -82, -394, -281, -157, -93, -158,  151, -16,  100, -18,  252,  313, -444, -260, -263, -12, -127,  366, -340,  106,  355,  237,  258,  350, -66,  27, -27, -404,  331, -158, -417, -251,  300, -198,  445, -292,  144,  448,  192, -256, -69,  296, -91, -13, -112,  498, -173, -386, -283, -13,  220, -428, -276, -22, -225,  159, -495, -400, -393, -312, -58,  42, -62,  94,  344, -117,  302,  341, -169,  347, -415, -386,  495,  347,  101, -116,  345,  428, -02, -86, -84, -282, -13,  140, -452, -386,  151, -94, -286, -390,  94, -492,  152, -116,  102, -03, -381,  257, -162,  303,  456,  275,  417,  451,  474,  19, -165, -328, -53,  333,  86, -285, -97, -75,  356, -48,  39,  359, -290, -395,  470, -344, -387,  122,  41, -432, -29,  160, -323, -339,  315, -367, -211,  233, -416, -237,  104,  272,  287, -97,  457, -126,  119, -139,  299,  327, -335,  191,  186,  227,  296, -492,  383, -238,  483, -76,  182, -46, -63,  359,  468, -248, -156, -243, -163,  280,  372,  441,  52,  160, -155,  10, -114,  464, -277, -315, -357,  240, -272,  329, -33, -123,  338, -150,  491,  321, -373,  173,  127,  416,  384,  95,  20, -272, -296,  358, -492, -423,  299,  413, -411, -04,  275, -25,  312,  498, -488,  455, -410,  93,  285,  57,  470,  475, -241, -187,  296,  238,  486,  275,  154, -278, -129, -325, -50,  427, -467,  310, -144, -316,  223, -55, -467, -02, -228,  345,  348,  137, -347,  438, -270,  438,  347, -300, -235, -41,  365, -87, -303,  351, -312,  352, -75,  411, -121,  375,  339,  264,  185,  47, -200,  261,  493, -167,  111,  117,  31, -40, -246,  184,  250, -16,  474,  98, -464, -261, -443,  401,  152,  106, -396, -308,  310,  29, -44, -311,  256, -205,  453,  294,  342, -246,  55, -313,  439, -334,  305, -30,  478, -441, -346,  229,  396, -372,  179,  432, -133,  236,  334, -129,  194, -210,  416,  05,  320, -128, -454,  76, -481, -500, -130],
        [-500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -241, -241, -241, -241, -241, -241, -241, -241, -241, -241, -241, -241, -241, -241, -241, -241, -241, -241, -241, -241, -241, -241, -241, -241, -241, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -111, -111, -111, -111, -111, -111, -111, -111, -111, -111, -111, -111, -111, -111, -111, -111, -111, -111, -111, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -76, -76, -76, -76, -76, -76, -76, -76, -76, -76, -76, -76, -76, -76, -76, -76, -76, -76, -76, -76, -76, -76, -76, -76, -76, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  107,  107,  107,  107,  107,  107,  107,  107,  107,  107,  107,  107,  107,  107,  107,  107,  107,  107,  107,  107,  107,  107,  107,  107,  107,  107,  107,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  180,  180,  180,  180,  180,  180,  180,  180,  180,  180,  180,  180,  180,  180,  180,  180,  180,  180,  180,  180,  180,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  277,  277,  277,  277,  277,  277,  277,  277,  277,  277,  277,  277,  277,  277,  277,  277,  277,  277,  277,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  281,  281,  281,  281,  281,  281,  281,  281,  281,  281,  281,  281,  281,  281,  281,  281,  281,  281,  281,  281,  281,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  495,  495,  495,  495,  495,  495,  495,  495,  495,  495,  495,  495,  495,  495,  495,  495,  495,  495,  495,  495,  495,  495,  495,  495,  495,  495,  495,  495,  495,  495,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  499,  499,  499,  499,  499,  499,  499,  499,  499,  499,  499,  499,  499,  499,  499,  499,  499,  499,  499,  499,  499,  499]);


//length == 32768
  check([ 368,  322,  64, -403, -267,  251, -169, -446, -172,  48,  434,  53, -463,  02, -34, -379,  138,  65,  289,  232,  312,  468,  369,  382, -247,  441,  166,  292,  140, -27, -110,  360,  147,  454, -191, -268,  206,  140, -214, -466,  41,  72,  87,  430, -425, -447, -448, -435,  471, -307,  297, -365, -339,  166, -483,  266,  460, -465,  58,  100,  08,  449,  312,  07,  403, -379,  239,  109, -386, -123,  496, -493,  450,  83,  437, -123,  489, -159, -58, -188,  35, -260, -53, -452,  406,  316,  315, -282,  351, -127, -330,  211,  174,  482, -282,  430, -44, -191,  39,  70,  186,  387,  429,  136,  323,  366, -135, -336, -292,  308, -24, -405, -452,  423, -357, -194, -409,  458,  377,  442,  184, -453,  153, -142, -470, -277, -212, -14,  32, -320, -92, -282, -81,  189, -293, -258,  55,  72, -94, -385, -120, -266, -290,  280,  09, -146, -61,  100,  164, -184,  42, -152, -137,  47, -441,  245,  270,  199,  83, -198, -269, -157,  373,  151, -468, -68, -255,  440, -496,  152, -445,  237, -262,  118,  369,  248, -176,  160, -152, -160,  476, -257,  189,  192,  290, -400, -63,  413, -349, -127, -285, -117,  216, -60, -466,  249,  372,  131,  189, -271, -217, -404,  466,  22, -434, -313,  122, -110,  348, -178, -417, -324,  65,  272,  368,  208, -276,  158,  121, -125, -469, -312,  258, -401,  481, -356,  348,  353,  276,  389, -418, -89, -162, -100, -215, -96,  440,  407, -353,  288,  82, -270,  464, -353, -146, -315, -293,  430, -305, -320, -195, -274,  221, -84, -175,  202,  412,  26,  407,  188,  267,  490, -48, -395,  242,  237,  10,  182,  497, -491,  322,  431, -261,  287, -422,  445, -176,  138,  375,  19,  318,  32, -403,  39,  448,  274, -259,  361, -200, -351,  401, -432, -09, -147, -327,  85, -57, -465,  120,  292, -104, -58,  223,  487, -271, -347,  432,  405,  291, -341, -76,  110,  192,  373,  01,  140,  148, -405,  01,  448,  96, -97, -132, -61, -392,  394, -476,  51,  429,  144,  195, -174, -413, -82, -187,  168,  72,  98,  426,  215,  257, -150,  177, -51, -276, -321, -58,  372, -226,  443, -328, -278,  198,  41,  161, -341,  287,  185, -438,  216,  182,  258, -106, -379,  28, -440, -359, -48, -490, -433, -332,  267,  270,  345,  69,  494, -124, -489, -282, -498, -194,  242, -276, -143,  135,  385,  16, -78,  423,  78, -09,  105,  188, -263, -422, -283,  149, -281,  169,  159, -213, -311,  279, -443, -113,  200, -97,  263,  211,  473,  266, -483, -433, -158, -126,  203, -272, -258, -23,  03,  321, -180, -392,  09,  58,  38, -422,  59,  257,  248,  71, -456, -211, -150, -47,  176, -450,  356,  292, -387, -319,  410, -18, -251, -248, -291,  452, -20, -49,  281,  483,  124, -398, -57, -14,  160,  481,  64,  71, -409,  164, -358, -365, -194, -08,  441,  482,  394,  297,  274, -141, -169,  184,  342,  80,  437, -97,  384,  269,  354,  165, -395,  331,  267,  400, -183,  279,  382, -267, -149,  473, -250, -07, -40,  56, -162, -99,  38, -268,  51,  165,  444,  382,  201,  286,  314,  490, -311,  198,  260, -105, -137, -283, -274, -369, -383,  395,  410, -149, -19,  113, -176,  231, -393, -363, -213, -55,  390, -323, -471,  293,  342,  473, -473,  44, -389,  341,  386,  152,  39,  498, -452,  403, -285,  126, -114, -167,  374,  148,  184, -145, -238, -139, -414,  221,  350,  225,  18,  240,  402,  47,  386,  245,  373,  413,  141, -164,  255,  27,  489,  146,  26, -111,  49,  241, -133,  435, -74, -259,  436, -37,  448, -302,  324, -114,  419,  174, -389, -63,  266, -486, -164,  152,  259,  61,  66,  252, -250,  173,  131, -261, -181, -343,  480, -279, -249, -153,  08, -471,  441, -56, -08,  389,  142,  168, -224,  413, -158, -113,  202, -39, -99, -109, -387,  12,  452, -469,  116, -298, -444, -252,  293, -124,  257,  273,  449, -140, -27, -43,  242, -86,  402, -266, -197,  396,  403,  431, -338,  97,  171,  364, -442, -76, -245,  24,  437,  60,  55,  405,  262,  112,  05,  408, -160,  115,  181, -211,  475, -346, -402, -431,  420, -148,  156,  76, -251,  411,  07,  263,  08, -322,  127,  419,  103, -265, -57,  392,  295, -150, -351,  409, -186,  155,  317,  154, -230,  351, -205,  97, -143, -106,  167, -222,  246,  175, -294, -153,  86,  213, -390, -406, -256, -410, -135, -301, -175, -340, -57, -380,  11,  92, -471,  325,  99, -301,  332,  369, -450, -373,  319,  259,  21,  338, -463,  120,  13, -257,  467, -401, -191, -70,  45,  405,  20,  411, -396,  345, -77,  47, -183,  434, -361, -154, -388, -409,  397, -204,  460, -201, -77, -369, -441, -203,  469, -52, -231,  334, -456, -264,  433, -147,  166,  331, -242, -314, -406,  214, -117,  17, -239,  200,  304,  252, -101, -232,  343, -204,  64, -344,  96, -161,  139,  155,  136,  109, -45, -243,  295, -01, -06, -419,  352,  12,  412, -38, -449, -494, -324, -66,  375,  289, -13, -469,  42,  386, -201,  237,  34,  363, -255, -370,  55,  385, -363,  43,  346,  93,  301,  141, -408,  147,  222, -203, -341,  486, -389,  62, -156, -212, -151, -280, -423,  336, -249,  471, -426,  403, -439,  108, -382, -194, -409,  173,  43, -272, -283, -111, -327, -482, -469,  118,  165, -395, -233, -324, -408, -122, -409,  288, -482, -60, -492, -52,  128,  112,  271,  202,  15,  332, -190,  133, -09, -99,  159, -466,  482,  376, -76,  07, -254,  307, -23, -237, -236,  244,  291,  208, -25,  382, -03, -07, -178,  357,  441,  450, -31,  213, -496, -164,  397, -185,  470,  240, -432,  129,  275, -98,  357,  51, -238, -397,  210, -409,  218,  474, -312,  09,  183,  163, -108, -320,  08, -434, -463, -50, -483,  359,  15, -127, -305,  264,  188,  17,  05, -391, -02,  132,  363,  207, -317, -23, -338,  393,  69,  380, -281,  257, -110, -246,  272, -366,  286, -220, -300, -324, -418, -283, -465,  449,  91,  82,  214,  131, -400,  71, -408,  450, -297, -192,  158,  238,  285, -328,  483,  206, -447, -298, -37,  295, -43,  87,  429,  95,  368, -371,  271,  450,  199,  306,  400,  142, -111,  466,  125,  341,  389, -430, -357, -408, -122, -347, -318,  15, -174, -335, -278, -121,  219, -463,  26,  28,  477, -45, -376,  345,  84,  395, -353,  135, -446, -101, -223,  295, -135, -245,  488,  106, -175, -369, -450, -445, -215, -268,  70,  463,  249, -356,  194,  321,  34, -280, -151,  11,  175,  325,  208,  111, -427,  355, -253, -21, -245,  376, -226,  472, -17, -238,  79,  308, -107,  129,  363, -470, -286,  286,  493,  463, -218, -461,  284,  316, -241, -14,  179,  434,  163, -113,  398, -412,  95, -03,  67, -298,  225,  341, -326, -291, -397, -395, -483,  349,  235, -267, -269, -199, -481,  77, -236, -199,  116, -99, -30,  376, -261,  01, -338, -246, -259, -440, -157,  336,  409, -238, -462,  135, -396,  64,  344,  59,  170, -287,  260,  257, -54, -156, -442,  317,  421,  174, -29,  37, -73,  441,  265, -482,  294, -220, -227, -465, -160,  468, -277,  102, -270,  113, -263,  186,  30, -67,  98, -300,  146,  210, -191, -407, -446,  219, -238,  475, -107,  233,  365, -327, -474,  482, -309,  321, -238, -36, -292,  455,  284,  284,  57, -133,  249, -354, -95, -221,  79, -497,  331, -275,  214, -08,  170, -380, -289,  433, -52,  105,  166, -187,  278,  193,  147, -179,  366, -238, -362, -426, -283,  422, -290, -374,  141,  460, -228, -453,  91,  351, -450, -77, -72, -384,  415, -401, -263, -21, -468,  185, -416, -450, -150, -286,  243, -151,  35,  109,  111, -475, -464,  328,  448, -254,  454,  89, -294,  78,  488,  298, -71, -461,  73,  358,  07,  340, -191, -404, -181,  193, -367,  255,  243, -17,  469, -13, -315,  357, -52,  296, -266, -16,  477, -318, -417, -217, -376, -211,  362, -388, -61,  143,  03, -488,  01, -137, -295, -338, -41,  24,  355,  93, -220,  99, -72,  101, -62,  113,  310, -262, -90, -455,  223, -113,  79, -342,  170, -445, -53,  384,  20, -261,  28, -477,  103, -119,  238,  308,  44, -302,  185, -101, -357,  465, -150,  71,  418,  288, -315,  229, -473,  447, -374, -398,  186,  205, -240,  208,  261, -441,  93, -219, -202, -379,  156, -246,  02,  247, -438, -102,  445,  247, -350, -412, -436,  00, -489,  483,  141,  48, -436,  168, -05, -310, -378, -319, -253,  234,  390, -492,  293, -17,  141, -56,  456,  150, -450,  310, -103, -36, -291,  194,  64, -141, -366,  128, -289, -03,  463,  352, -454, -473,  372,  41,  69,  494, -425,  317, -420,  465, -323, -274,  300, -329, -478, -392, -327, -428,  418,  70,  36, -373,  116, -400,  338, -398, -419, -450,  99, -456,  402,  145, -76,  275,  39, -155, -379,  114,  14, -298,  431,  192, -72, -417,  363,  302, -309, -464,  374, -391,  458, -90, -263,  426,  363, -425, -472,  444, -23,  127, -160, -120,  125, -384,  07, -336,  314,  128,  278, -172, -318, -439, -480,  462, -356, -265,  264, -165,  123,  138, -56,  433, -99, -467,  359,  116, -39, -261,  412,  438, -281, -248,  170,  344,  221, -323, -140,  35, -342, -10,  363, -160,  51, -264,  155,  195,  323, -81, -118,  299, -90, -322,  232, -337, -288,  444,  279, -475, -317,  191, -185, -98, -205,  486,  98, -484, -337,  458,  403, -179, -52, -381, -486, -149, -145,  169, -454,  30, -60,  280, -171,  350,  459, -438, -487,  23, -494, -356,  48,  41,  335,  363, -204, -17, -299, -254,  351, -135, -295,  255, -462, -495, -274, -448, -143,  433, -427,  255, -37,  14,  36,  293,  216, -05, -293, -418, -482,  65, -274,  418, -394, -86,  281,  254,  397,  483, -499, -400,  200,  58, -293, -410,  63, -67, -05,  420, -134,  68,  176,  330, -66,  64,  475, -349, -441, -318, -267, -71,  247,  311, -153, -295, -275, -20, -188, -26,  315, -187,  427,  15,  371, -366,  106,  286,  68, -399, -441,  434, -479, -413, -384, -44,  151, -409,  107,  210,  125, -308, -09,  224, -497,  338, -218,  81, -182,  94, -445, -366, -241,  482, -499, -18, -383,  459, -232, -463, -88, -173, -177, -66,  266, -60, -258, -83,  383,  349, -21,  361, -107,  470,  85, -104,  308,  367,  477, -21,  313, -115,  465, -428,  219, -182,  54, -312, -222, -325, -275, -458,  02,  401, -24,  121, -159, -430, -462,  76, -229,  18, -63,  164,  340, -477, -87, -499, -258, -110,  332, -444, -373,  297, -372, -301, -385, -465, -113,  245, -290,  465,  288, -436,  366,  116,  185,  59,  187, -424, -13,  458,  446,  425,  123,  286, -200, -112, -361,  42,  278,  471,  450, -242,  268, -69, -43, -264, -34, -304,  481, -472, -339, -379, -408, -121,  238, -370,  438,  277, -294, -74,  235, -348,  203,  210, -210, -497, -402, -70,  397, -271, -99, -300, -13,  22,  131, -204,  258, -403, -08, -409, -23,  154,  65,  69, -115, -197, -449, -176, -420, -243, -398, -333,  261, -343, -270, -448,  12, -172, -18, -91,  409, -265,  109,  248,  257,  92, -456,  367, -459,  389, -189,  18,  43,  376, -60, -220,  31, -09,  456,  111, -399, -442, -370, -286,  67, -140, -234, -421, -459, -400,  341,  450,  188,  302, -449,  297, -105, -53,  165, -64, -164,  476, -193, -269, -296,  247,  12,  235,  90, -32,  198, -457,  379,  328, -242, -54,  41,  376,  26,  82, -171, -133,  384, -483,  21, -213,  314,  416,  235,  331,  205, -429, -341, -136, -197, -137, -37,  315, -50, -447,  135, -352, -51,  14, -171,  207,  461,  370,  435, -13,  304, -236, -294, -460,  133,  227, -172,  300,  496, -437,  131, -447, -366,  291, -83,  289,  06,  380,  456,  457, -215,  92, -43,  234, -394,  286,  293, -433,  156,  229,  406, -40, -155, -36,  01,  479,  44, -319,  279,  392, -256, -90,  445,  230,  53, -138,  372, -88,  94,  328,  221,  379, -80, -322,  466,  379,  465,  259, -202,  473, -12, -295,  286,  334, -479,  139, -335,  65,  320,  444,  309, -84,  206,  254, -354,  112, -32, -482, -124, -438, -301, -403, -206,  471,  127, -240,  350,  444, -129, -351,  418,  360,  206,  204, -454, -421,  195, -289,  497,  15,  07,  306,  431, -287,  61, -71, -323, -119,  300,  53,  296,  499, -498, -410,  470,  130,  202, -327,  426, -427,  174,  344, -215,  232,  400,  183,  311,  95, -254, -340, -38,  253,  467, -107, -181,  380,  323, -04, -239,  123, -98, -91,  474,  256, -01,  444, -114,  53, -31, -187,  479, -05,  09, -236, -273,  262,  448, -109, -143, -306,  51,  320, -200,  18,  65,  119,  250, -112, -33, -488, -137, -279,  273, -163,  478, -227,  134,  216, -322, -45, -471, -343,  451,  391,  274, -322,  153, -426,  421, -138,  120, -27,  34,  420, -157, -400,  391, -406,  340, -141, -42,  56,  80, -269, -255,  410,  356,  379,  127, -465, -165, -492,  44,  138,  399, -182, -332,  404,  244, -410, -233, -135,  63, -347, -215,  406, -247,  29, -500, -54,  388,  310, -498,  320, -458, -253,  231,  398, -21,  210, -215, -334,  218,  330,  304,  118,  00,  472,  374, -255, -438, -359,  110,  477,  147, -253,  384,  400, -372, -264, -154, -484, -101,  200, -311, -59, -200, -228,  191,  279,  482,  477,  445, -448, -341, -399,  170,  159, -427,  397, -244, -12, -110, -282, -35, -463,  318,  201,  438,  446, -210,  136, -185,  189,  189,  04, -18,  489, -372, -327, -380, -38, -350, -435,  14,  161,  18,  37, -179,  443, -66,  429, -69,  324, -352, -251, -286,  466, -198,  04,  412,  92, -08, -273,  133, -319, -417, -385,  22,  63, -211,  142, -475,  291, -441,  392, -47,  77, -71, -374,  21, -285, -445, -196, -109, -297,  53,  105,  21, -292, -391, -66,  300,  454, -487,  286, -365, -51,  401,  158, -488,  42, -200, -110,  186, -140,  134, -361, -211, -85, -235,  310,  130,  172, -385, -127,  376, -480, -169,  249, -272,  292, -317, -119,  246,  49, -333,  382,  498, -80,  392, -138, -185,  44,  252, -499,  404, -114, -360, -306, -347,  257, -144,  283,  281, -29,  09, -491,  344,  340,  259, -428,  132,  442,  305,  231, -09, -176,  465,  341,  245,  357, -296, -440, -99, -192, -87,  158, -453,  53, -296, -300,  162,  60, -164, -57, -116,  345, -47,  80, -463,  64, -496,  169,  06,  310,  252, -150, -366,  217,  43, -269,  74,  247,  143, -172, -92, -444,  486, -45,  461, -310, -493,  475, -398, -157,  271,  338, -312, -276, -82, -275, -360, -77, -253,  146,  85,  499, -152, -429,  217, -256,  155,  143, -157, -202,  471,  251,  207,  457, -294, -480, -01,  66,  496,  454,  409,  267, -356, -50, -157,  63,  175, -17, -162, -226, -19, -225,  126, -318, -154,  195, -74, -147, -162,  269, -496, -190,  21,  211,  119, -421,  231, -29,  145, -421,  277,  407,  346,  421, -143,  41,  336, -468, -476,  26,  159,  358,  301, -215, -460,  00,  480,  318,  353, -182,  87,  357,  480, -40,  420,  452,  40, -496, -77,  37, -417, -300, -56, -218, -27,  301,  323, -190, -314, -300,  336,  345, -442,  138, -18, -50, -10, -38, -232,  195, -368, -293,  53, -35,  168,  325, -83,  60,  329, -308, -403, -235,  244,  394,  399,  69, -453,  222,  379, -267, -226,  216, -70,  184,  206,  412, -14,  48,  226,  254, -257, -289,  462, -352, -472,  482,  474,  297,  42, -345,  489,  491,  272, -415,  385,  171,  154,  433, -106,  386,  18, -480,  102,  449,  205,  160, -287, -309, -292, -208, -202,  303,  03,  112,  452,  31,  94, -222,  180, -364, -67, -479, -21, -294, -394, -135, -271, -388,  150,  475,  498, -332,  496,  452, -383, -447,  464,  183,  96,  24,  475,  394, -172,  330,  358,  132,  213, -48,  410, -107,  440,  195, -86, -80,  401,  372, -363, -369,  484,  287, -42, -165,  455, -46,  139, -75,  07,  456, -392, -44, -20, -417, -150, -340, -235,  61,  292,  478, -135,  202, -129,  158, -102,  285, -422,  151,  157,  67, -366,  493, -146,  93,  180,  161, -453,  172, -414,  407,  128,  46, -137, -392,  481, -435, -231, -254,  478, -87, -276, -156, -384,  95, -498,  366,  232, -68,  17,  241,  499, -496,  235,  205,  97,  267, -134,  496, -61,  305, -245, -433, -149,  470,  28, -167, -112, -351,  79, -134,  62, -344,  210, -470, -397,  212,  396,  336, -356,  266,  77, -05,  270,  164, -300,  219, -68,  67,  215, -277, -128, -177,  143,  223, -207, -329, -92,  181, -180, -160, -452, -266, -04,  258, -235,  451,  323, -339,  287, -181, -221,  217,  315, -451, -119, -485,  268, -335,  82,  336,  241, -194, -341, -116, -118, -48,  55,  290, -14, -273, -18,  34, -39, -170,  144, -422, -218,  319,  92, -431, -361,  371,  286,  454,  421,  20,  469, -459, -463,  404,  377,  278, -290, -464, -338,  444,  341, -431,  235, -173, -204,  69, -287, -390,  400, -291, -312, -318, -119, -368,  103,  20, -496,  242,  326, -223, -238, -353, -182,  151, -449, -304, -70,  114,  84,  92,  410, -75, -486,  145, -396, -190,  67, -183,  272, -33,  379, -187, -499, -240, -55,  104, -368, -51,  198,  458,  226, -188, -395, -103,  464,  09,  93, -106, -25, -323, -162, -115,  455, -148, -117, -441, -485,  450,  229,  287,  269,  460, -400,  270,  72,  46,  226,  204, -153, -75,  162, -74,  237, -381,  323,  201,  480, -84, -405,  307,  445,  286, -307, -248, -362,  428,  164, -347,  378,  245,  441,  499,  205, -107,  269, -223, -209, -05, -167,  139,  420, -153, -83, -490,  318, -260,  211,  299, -492, -341,  106, -195,  445, -349,  58, -417, -421,  74, -263, -191, -181,  30, -192, -124, -225, -71, -495,  67,  425, -162,  58, -303, -463,  475, -293,  355,  67, -229,  154,  75, -70,  113, -268,  227, -384, -358,  310,  48,  216, -101, -291, -113, -219,  18,  263,  57, -201, -380, -24, -276,  310, -466,  274,  347, -139, -167,  203,  428,  104,  209,  355, -466,  174, -61, -387,  291,  82,  424, -161,  150,  175,  48, -462, -191, -82, -347,  366,  218, -226, -158, -206, -64,  228, -80, -216, -411,  254,  487, -131, -142, -452,  76,  245,  223, -485,  358,  14,  97, -366, -295, -252, -338,  253,  138, -29,  24,  291, -163,  94, -83, -469, -260,  354,  259,  161, -10, -300, -85, -23,  69, -375,  377, -355, -278,  100,  12, -419, -34, -390,  67,  171,  210,  229,  277, -152, -300, -199, -09,  389,  395, -239, -228, -13, -385, -117, -352,  105,  83,  415, -66,  04, -459, -189, -499, -237, -236,  14,  196,  230,  476,  116, -98,  186, -155, -321, -466,  398,  332,  377, -361, -421, -362, -88,  66, -247,  295,  215, -290,  231,  130,  496,  87, -477,  160,  89,  139,  424, -45, -165, -494, -69,  451, -92, -383,  149,  439,  03,  399, -377, -120, -462, -298,  19,  302, -379, -376,  450, -312,  187,  181, -330,  183, -232, -306, -157, -291,  333,  119, -484,  20,  126, -53,  324, -114,  416,  325,  178,  271,  224,  301,  04, -386, -144, -477, -231, -23, -01, -281, -483, -314, -248, -313, -278,  372, -119,  417, -66,  66,  37, -50, -61,  15, -250, -237, -247,  18, -412, -217, -210, -336, -415, -354,  130,  293,  21,  399,  122, -480, -30,  139,  59,  222,  326,  281,  447,  60,  198, -119, -374,  87, -317,  65, -46,  285, -320, -440, -196, -232, -157,  446,  284,  280, -408, -85,  73,  113,  166,  47,  485, -363, -314,  44, -289, -135,  177,  10,  425,  228, -257, -449,  167, -73,  469, -378, -288, -351,  34,  368,  270,  377,  314,  406, -490,  406, -179,  435,  371, -160, -17,  357, -23,  169,  253, -460, -466, -69,  51,  459, -341,  294, -137,  326,  73,  184, -200, -362, -315,  334, -494, -193, -436, -327, -286, -426, -69,  387, -491, -197, -273,  344,  12, -444,  14, -235, -403,  400, -452, -500, -288, -293, -354,  427, -114,  220,  463, -462, -290, -352, -275, -284,  308, -211,  241, -478,  215, -327,  409, -424,  328, -11,  421, -160,  45,  287,  457,  142,  187, -494,  142, -249,  65,  289, -322,  451,  361, -359,  490, -429,  142, -285,  139, -50,  356, -119,  324,  423,  54, -415, -149,  234,  74, -228, -426, -380, -89, -469, -386, -49, -111,  257,  202,  455,  398, -267,  406, -389,  226, -252, -318,  220,  315, -327,  22, -477,  54, -154, -202, -40, -68,  150, -306, -494, -226,  120, -374,  186, -496, -259, -11,  245, -150, -309,  200,  100,  276,  459,  211,  355,  59, -255,  75, -125,  270, -402,  250,  177,  296, -451, -11, -272,  199, -464,  87,  473,  156, -435, -489, -488,  158,  00,  258, -492, -456, -42,  460, -328,  269, -477, -473, -171,  120,  455, -444, -109, -95,  306, -432, -299,  355,  57, -70,  406,  93, -131, -268,  102, -66, -257,  114, -407, -404,  224, -47, -360, -317, -86,  164, -196, -63,  192,  133, -90,  147,  189,  301, -448,  348, -279, -247,  203,  278, -465,  462,  224, -96, -306, -174, -309,  289, -208, -216,  385, -483,  237, -123, -300, -349, -458,  356,  441, -414, -10, -149,  233,  31,  04, -363, -121,  225,  242, -65,  355, -370, -103,  79,  386,  443,  405, -423, -416, -302, -139, -178, -285, -401, -449,  267,  102, -407,  475,  395,  31, -35,  98,  116, -151, -398,  253,  228, -321,  348,  15, -465,  478, -236,  114,  364, -293,  372, -206, -208, -78,  155,  114,  489, -394,  165,  256,  209, -389,  231,  456,  494,  49,  55,  111,  398, -491,  216,  478, -311,  64, -06,  76,  394,  258, -310, -389, -182, -86, -95,  462,  336, -88,  428,  325,  19,  445,  433,  80, -444, -483,  36, -97,  418, -57, -486, -332, -47, -418, -354,  494,  499,  492,  70,  393, -397, -388, -144, -79,  379,  261, -117, -433,  26, -189, -255, -455, -244, -322,  477,  165,  47,  13, -432,  317, -191, -66,  485, -386,  368, -16, -40,  367, -24, -118, -387,  79,  346, -31, -500,  225,  83,  235,  293, -391, -102, -462,  06,  155,  68, -17,  172, -32,  496, -408, -215,  157,  378, -229,  271,  246,  255,  83,  114,  83,  465,  227, -337,  312,  48,  15,  37, -369,  103,  182,  92, -499, -428, -402, -492,  141,  81, -468, -391,  430, -376,  246,  87, -498, -483,  211,  249, -376, -206,  215, -440, -240, -58,  75, -428,  490, -410,  461, -26, -455,  496, -434, -101, -432, -335, -93,  209,  246, -60, -330, -472,  416,  417,  116, -229, -214,  179, -480, -89,  473,  235, -29,  85,  29, -102, -491,  371, -12,  471, -155,  386,  467,  264, -215, -465, -219, -456, -403, -473,  336, -233, -444,  253,  36, -476, -476,  323,  203, -104,  86, -472, -17, -91,  114, -136,  307,  123, -265,  147,  446,  433,  33, -235,  197, -330,  153,  478, -285,  250, -143, -97, -131,  265, -344,  406, -359,  32, -419,  344, -220,  167, -275,  263, -424,  339, -373, -265,  314,  215,  382, -387,  148,  268, -122,  197,  438, -117,  175, -347, -15, -116,  409,  355,  02, -435, -387,  143,  450,  46,  340, -270, -287, -435, -154,  141, -244,  325,  376, -78,  40, -390,  35, -312,  378, -234, -263,  317,  149,  412, -178, -365,  149, -269, -158, -349,  149,  307, -354,  451, -147,  486, -319,  418, -97,  379,  59, -489,  205,  287, -66,  97, -251, -179, -362, -372,  87, -125, -203,  89,  140,  119,  224, -211, -297, -82,  292,  352, -275,  438,  303,  78, -223, -164, -04, -468,  68, -93, -456, -227,  46, -22, -278,  295,  299, -140, -225,  239,  236,  72, -172, -124,  44, -96, -483,  247,  322, -339,  451, -453, -401, -394,  477,  228,  294,  325,  261, -138,  84, -343,  487, -370,  135, -290, -223,  286,  422,  53,  377,  158, -23, -295, -114, -479,  461, -97, -380,  283,  416, -77, -318, -484,  381, -341, -404,  176,  484, -291, -110,  68, -134,  230, -450, -147, -208,  180, -08, -286, -267, -131, -275, -438,  427,  463, -64,  388,  219,  56, -476,  135, -168, -294, -497, -287,  218, -400, -259,  202, -191,  484,  123, -472, -434, -475, -119, -142,  205, -275,  424, -210,  447,  01, -147,  374, -35, -359, -386, -316,  197, -362,  319, -119,  197,  323,  95, -85, -225, -312, -31,  436,  24, -56,  464,  90, -30,  198, -200, -325, -225,  77,  318, -278, -422,  23, -404,  395,  164,  63, -421, -139, -447, -249, -405,  250, -426,  190, -335,  201, -270,  487,  137,  255, -69,  102, -155,  401,  152,  146, -71,  427, -277, -253, -350,  153,  270,  98,  49, -66,  13,  480, -353,  67, -269, -258, -183,  157, -216,  335, -142,  15,  322,  496,  122, -247,  450, -181,  07,  102,  465,  436,  381,  40,  35, -117,  46, -195, -166, -405,  239,  347, -425, -262, -86, -193, -19, -416,  464, -383, -229, -177,  484, -55,  171,  106, -450,  121,  426,  57,  75, -257,  345, -44, -364, -120, -308,  182,  185,  26, -371,  276, -127, -296, -485, -360,  363,  348, -276, -320, -183,  347,  355, -198, -208,  26,  408, -158, -01, -314, -248, -426, -70, -403,  382,  66, -22, -426, -252, -337,  100, -123, -208, -174,  433,  159, -34, -351,  359, -458, -171, -324,  389,  36, -22,  33, -438,  239,  375,  413,  425, -373,  487, -145,  77,  369, -227, -445,  444,  21,  70,  396, -250,  362, -278,  36,  373,  188,  185,  232, -418, -134,  409,  471,  402,  239,  356, -184, -22, -416, -271, -96, -289, -284, -389, -360, -63, -115, -305,  233, -242,  266,  130,  361,  480,  352, -103,  354,  393, -66,  438,  475,  300, -301, -201,  202,  439, -345, -130, -83, -261,  99, -327,  303, -333, -215,  443,  456,  170, -09,  190,  428, -243, -180,  289,  89, -328,  38,  295, -83,  472,  234, -107,  272,  433,  192,  326, -276, -301,  48,  494,  291, -353, -333,  94,  166,  304,  389,  123, -26, -120, -187,  255,  489,  485,  396,  431,  09,  287,  226,  427,  259,  312, -180,  384, -402, -136, -438, -178,  415,  111, -184,  206, -390,  336, -200,  277,  140,  42, -100, -33,  422, -435,  74, -236, -450, -30, -305,  59, -243, -227,  338, -131, -414, -342,  105, -316,  374,  167,  358,  290, -222,  27, -04,  241, -137, -351,  18, -145,  191, -230,  322,  465, -165,  248,  81,  237, -281,  276,  148,  328, -450, -13,  49, -12,  497, -346, -476,  372,  322,  382, -486, -48, -91,  362, -307, -376, -489, -437,  332, -446, -167, -494, -128, -480,  255,  453,  257, -174, -418, -94, -346, -16,  393,  204,  472,  390, -290,  496, -386, -116, -270, -372,  337,  140,  491, -118, -384, -146,  298,  448,  261, -369, -193, -367, -348, -438, -62, -239, -112,  20, -481,  394, -496, -236,  450, -172,  07, -339, -176,  121,  45,  55, -398,  234,  47, -407, -31, -485,  299, -233, -184,  60, -102,  123, -455,  402,  185, -16,  16, -75, -144,  35, -181, -139, -348, -230, -459,  159,  283,  218, -220, -172,  125,  234, -85, -328, -321,  384,  39,  479, -349,  355,  39,  401,  330,  437, -344,  367, -79, -476, -208,  277,  411,  464, -10, -437,  86,  32,  222, -131, -250, -145, -451,  375, -411, -36, -101, -231, -152, -210,  100,  351, -354, -09,  253, -172, -72, -239, -304,  349, -215,  340,  479, -304, -344, -31, -240,  242, -147, -166, -37,  103, -459,  13,  330, -369,  477,  81,  252,  178,  372, -148,  29, -482, -305, -218,  198,  124,  43, -254,  325, -320, -61,  304, -123,  95,  126,  489,  190,  479, -177,  05,  435, -135, -482,  265,  348, -152, -153,  452, -474, -281,  156,  55,  89,  351, -310,  139,  327, -415,  386,  153, -234, -175,  309,  143, -228, -65,  484, -186,  267, -193,  320,  202, -476, -310, -33, -276,  38, -334, -324,  64,  237,  332, -380,  178, -464, -190, -182,  363,  247,  56,  368, -487, -267,  178, -492,  357, -35,  492, -328, -268,  152, -156,  434, -472,  34,  254, -247, -427, -228, -71,  137, -490,  114, -391, -460,  150,  271, -142,  365,  19, -234,  234,  32, -01, -88,  393, -143,  377,  385,  29, -38,  37,  373,  248,  66, -93,  02, -329,  332, -373,  452, -30, -11,  66,  431,  29,  68, -445, -260, -66,  74,  06, -332, -42, -494,  432, -149, -137, -339,  89, -256,  123, -22, -31, -128, -104, -272, -274,  67, -439, -147,  20,  383,  342, -62,  314, -128, -493,  369,  112, -59,  295, -382,  461,  106, -24,  393,  457,  339, -446,  398, -65,  178, -123,  404, -98,  273, -367,  480,  193, -306, -166, -287, -71,  28,  151,  95,  400,  158,  317,  364, -49,  112, -165, -88, -282, -337,  157,  28, -497,  212,  278,  290,  242, -345,  195, -04, -219, -320, -24,  474, -126,  310, -313, -345, -161, -310,  250,  91, -299,  67,  308,  152,  32, -05, -83, -398,  158, -426,  130, -487,  286, -91,  304,  380,  416,  351, -124, -303, -469,  353, -329,  257, -485,  210,  412,  206,  401,  162, -202, -398,  82, -42, -394, -386, -195,  23, -284,  463,  450, -301,  477,  236,  460, -367,  469,  376,  484, -155, -74, -485,  50,  97,  272,  66,  160,  184, -228,  61,  198,  422, -485, -220,  232, -379,  246, -463,  145, -185, -499,  95,  14, -170,  183,  326,  315,  152,  202,  299, -150, -20, -334,  400, -70,  438, -34, -410,  474, -409,  151, -476, -487,  166,  157, -402, -361, -97, -365,  284, -430, -12,  231,  84,  318,  267, -90,  485,  271, -35,  284, -379, -203, -198, -126,  227,  92, -308,  317,  66,  135,  320,  443,  149,  338,  100,  247,  478, -145, -266, -386, -74,  223, -302, -138,  393,  465,  273,  379, -412,  90, -485, -290,  387, -182,  436,  115,  410, -20,  284,  329, -384,  105,  272, -383, -57, -128, -284,  273, -421, -50,  388,  05, -327, -414,  368, -433, -97,  493, -202, -09,  435, -187, -447,  322,  131,  489,  289,  394, -30,  74,  223,  438,  31, -05, -445, -174, -281, -229, -400, -202, -427,  488, -344, -253, -74, -476,  166,  329, -131, -184, -180, -196,  129, -126, -374,  113,  215, -232,  07,  37,  342, -270, -25,  225, -423,  382, -449, -204, -347, -349,  446, -273, -09, -398,  326,  417, -22,  344, -402,  347, -340,  271, -349,  289, -03,  130,  254,  64,  398, -239, -398, -408,  343,  429,  317, -228, -336,  368,  420, -183, -128,  367,  396,  363, -179, -426, -367,  300, -230,  83,  147, -70, -146,  299,  72, -297, -71, -174,  268,  179,  440, -278,  271, -365,  03,  88, -92,  167,  308, -172, -163, -320,  47,  85, -104,  369,  160,  381,  169,  430,  316,  168,  213,  23,  319,  137,  226,  100,  463,  346, -221, -245, -432, -450,  243,  72,  490, -349,  91,  299,  331,  428, -169,  231,  14, -421,  100,  26,  460,  121,  308, -371,  141,  21,  152, -39, -342,  230, -439, -26,  77, -159, -419,  497,  243,  324,  69,  234, -173,  13,  33,  11, -59, -284, -258, -193, -204, -306,  333,  108, -333,  142,  237,  308,  15, -111, -231, -474, -380,  183,  352, -451, -476,  433, -454,  267, -390,  468,  01, -63, -19, -114,  448,  422,  103,  42, -270,  399,  236, -85,  07, -245, -443,  97, -436,  425,  486,  185,  451, -42, -132,  303,  07,  244, -412,  54,  12, -302,  374, -135,  488, -145,  252,  436,  129,  207,  331, -289,  458,  419,  127,  317, -325, -464, -86, -261, -187, -99, -224, -236, -289,  145, -81,  219, -111,  360,  125, -247, -442,  351,  119, -102, -294,  223, -165,  335, -70,  18, -101,  240, -63, -474,  57,  112, -86,  472, -297,  228,  225, -20, -156,  436, -23, -384, -493, -282,  476,  484, -28, -114,  335, -57,  285, -459, -334, -28, -271,  448,  490,  128,  188, -73, -494,  97, -460,  272,  69,  95,  00, -206, -425, -303, -269,  404, -187, -262, -377, -211, -277,  95, -473, -90, -110,  312, -48,  56,  136, -467,  356,  126,  161,  396, -94, -481, -07,  298,  291, -85, -107,  144,  209,  321,  341, -208,  225, -346,  383,  348,  295, -42,  295,  322,  368, -315,  487,  172, -407,  123,  205, -199, -250,  218, -303, -492,  237, -457,  306,  381,  310, -301,  25,  19, -480, -134, -336, -402,  372, -453,  446,  167,  357, -406,  341,  225, -221,  328, -102,  225, -48, -45, -474, -446, -326,  76, -438,  411,  471, -280, -356,  281,  271,  169,  152,  292, -113,  316, -258,  111, -285, -312,  130, -428,  134, -28, -350,  414,  152,  400,  491, -44, -145, -483,  10,  29,  445,  424,  293,  416, -04, -211, -451, -232, -189,  202, -88, -450,  370,  154,  162, -62, -306, -208,  362,  329, -384, -488, -405,  269, -236, -414, -275,  472, -45, -412,  01, -99, -136,  146,  169,  361, -212,  219, -371,  99,  273,  41,  149,  143, -305,  163, -419,  241,  456,  444,  70, -76, -192, -483, -307,  73, -397,  271,  45,  411,  359, -102,  164, -277, -103, -167, -64,  185, -96,  65,  136, -323, -42, -215, -327, -495,  449, -246,  247, -243,  50,  169, -467,  359,  187, -273,  284, -358,  498,  181, -447, -291, -421, -431,  284,  328, -97, -279,  13, -341, -362,  01, -163,  97,  287,  362,  102, -412, -384,  201,  197, -481, -129,  230,  378, -90, -191, -486,  52,  159,  195,  458,  368, -374, -473, -495,  455,  282, -274,  320,  442,  216, -178,  131, -187, -39, -07, -232,  49,  461, -179,  98,  480, -456, -172, -290, -46,  490,  76, -141,  149, -229, -183,  370, -102,  196, -273,  205,  331,  305,  25, -375,  21,  347, -392, -313,  160,  453,  307, -291,  414, -372, -341, -253,  25,  340,  309,  479,  330, -114, -162,  331, -491, -493, -447,  259, -444, -220, -36,  387, -415,  490, -488,  459, -311, -380, -354,  350, -427, -195, -89, -161,  285,  71,  438, -190, -89, -400, -210,  93, -14,  480,  276,  347,  488,  330,  107, -456, -38, -429, -217,  400, -87, -205,  359,  103,  267, -143,  305,  340,  162,  68,  31, -53, -09, -30,  258,  402,  70, -100,  347, -92,  232,  124, -245,  220, -46, -286, -384, -232, -214,  251, -332,  199, -454, -473,  154,  313, -116,  311, -495, -102, -120,  37, -302,  371, -493, -192, -374,  429,  208, -175, -163, -60,  449,  444,  13,  255, -341,  481, -476, -55,  233, -308, -04, -369,  72,  03, -203, -192,  166, -198,  207, -102,  339, -243,  122, -302,  65, -400, -373,  125, -75, -36, -83,  227,  261,  430,  334,  420, -236,  358,  217, -151, -97,  65, -20, -173, -432,  277,  135, -413, -68,  194, -15, -229,  451, -393, -30,  368, -293,  97, -07,  485, -86,  411,  212, -325, -307,  46, -53,  309,  257, -336, -342,  12,  229,  491, -309, -350, -380, -322, -263,  52,  373,  222, -324, -324, -318,  146, -103,  241,  95,  390,  226, -139, -347,  290,  388, -153, -163, -165, -344, -54, -01,  167, -190,  81,  158,  01,  231, -370,  179,  468,  183,  404, -458, -289, -67, -276, -291,  330, -182,  304, -428, -456,  18, -274,  335, -94,  73,  24, -406, -419, -178,  445,  248,  132,  26, -94, -15,  109,  389,  16,  77,  72, -79,  472, -365, -294,  48, -156, -464,  366,  00, -392,  411, -482, -166, -402,  277, -241,  474,  371, -159,  148, -332, -411,  132, -453,  348, -383,  156,  237,  133,  86,  161, -94,  58,  296,  112, -394, -360, -500,  473,  140, -391, -264,  159,  295,  186,  288, -445, -488, -489,  248,  160, -321,  337, -208, -274,  185,  261, -265,  274,  246,  321, -65, -347,  231, -269, -383,  337,  223, -382, -338, -136,  79, -102, -125, -126, -64, -337,  281, -52,  26,  29, -392,  205,  219,  252, -216,  256,  365,  371,  31,  112,  192,  466, -383, -77,  50, -266,  112, -227,  204,  275,  137, -217,  25, -136,  158,  462,  27,  291,  262, -95, -179, -277, -389, -460,  475,  247,  296,  341,  470,  179,  305,  162,  146, -226, -63,  48,  08, -451,  321,  65, -324,  311,  348,  202, -325,  358, -484, -445,  150,  278, -40,  471, -499,  423, -137, -171, -478,  11,  22,  492, -309, -173, -494, -311,  453, -57,  237, -39,  345,  410, -122, -127, -427, -273, -73, -251, -415, -57,  156, -413,  74, -32, -90,  427,  244,  273, -244,  266,  137, -370, -389,  328,  309, -383, -131,  262,  413, -394,  76, -390, -132,  454, -17, -58, -319,  411, -457,  119,  206,  199, -442,  132, -333, -31,  60, -237,  94, -332, -470, -269, -201, -07, -89, -392,  110,  280,  371,  375, -262, -53,  485,  107, -99,  321, -451,  435,  232, -408,  406,  290, -357,  464, -77,  162, -67, -165,  426, -120,  03, -192,  111,  302,  301, -125, -237, -89, -345, -366,  139,  246,  433,  124, -147, -166, -55,  254,  121,  29, -302,  27, -180, -159,  344, -405, -497,  129, -70, -219, -491,  433,  89,  473, -412, -110, -152, -149, -346,  355,  337,  293,  101,  270,  269, -194, -396, -285, -440, -422,  244, -242,  105, -84,  451,  301,  363, -193, -69, -207,  88, -60,  79, -322, -87, -481,  420,  261, -130, -74,  117,  59, -281,  70, -171, -159,  377,  285,  56,  437,  363,  152,  48,  321, -79, -01,  122, -216,  306, -447,  430,  247,  346,  361, -223, -241,  380, -303, -127,  102,  476, -158, -339,  47,  412,  342,  388,  289,  127,  296, -421,  343, -51,  127,  164, -278, -22,  138,  358,  137,  192,  288, -116,  38,  149, -487, -351,  381, -290,  22, -17, -314,  364,  496,  234,  277,  338,  474,  418, -34,  271,  497, -191,  72,  476, -175,  294,  307,  463,  152, -56, -493,  293, -320,  397,  294, -307, -453,  176,  255,  69, -341, -206,  286, -344, -120,  415, -154, -146,  333,  312, -375, -317, -27,  197, -341,  298, -09, -182, -386, -04,  262, -379, -211, -206, -481, -417, -13, -434, -389,  95,  487,  123,  389, -375,  279, -231, -460, -23,  123, -274, -210,  249, -91, -385,  298,  420, -234, -210, -261, -120, -362, -147,  353,  279,  148,  372, -286, -13, -210, -174, -418,  130,  449, -177,  255, -420,  92, -352,  57,  68, -126, -301,  169, -365, -185, -33, -93,  433, -391,  498, -187, -253, -148, -334, -122, -148, -109,  93, -309,  181,  419,  126,  163, -280,  449, -81,  152,  394,  419, -291,  314,  145,  261, -17,  280, -424, -198,  39, -139, -88,  38,  174, -489, -258, -308, -110,  94,  435, -165, -363,  469,  106,  263,  132,  326, -435, -97, -22, -189, -178, -461, -375,  467,  300,  108, -401, -272,  410,  139,  89,  174,  29,  115, -462,  271, -340,  280,  217, -405, -385,  354, -436,  221,  470,  197,  399, -465, -400,  229, -154,  275,  268, -29, -406,  421, -69, -306, -351,  193, -315, -409,  220,  214,  206,  258, -15,  366,  38, -298,  462,  153, -92, -474,  226, -122, -425,  477, -87,  28,  206, -389, -197,  326,  434, -103,  247, -135,  443, -251, -89, -372, -160, -369,  342, -102,  389,  179, -235,  279, -267,  79,  284,  142,  457,  362, -480, -467,  339,  286,  61,  45,  397, -284,  223, -316,  465, -29,  49,  409,  220, -188, -111, -88, -57,  84,  310,  184, -237, -73, -37,  349, -494,  99, -09, -184, -39,  363, -151, -200,  149, -238, -303,  399,  330,  421, -417,  295,  244,  484, -444,  316, -203,  298, -272, -408, -118, -462,  277,  497, -34,  92,  346,  324,  44, -163, -360, -495,  53,  341,  158, -298, -45,  355, -47,  137, -372,  388,  285,  372,  373,  341,  188,  22,  139, -232,  114, -127, -193,  243, -129, -375,  188, -283, -199, -268,  407,  294,  89, -40,  487, -253, -486, -57, -45,  320, -68,  435,  208, -283,  308,  81, -441,  348, -397, -450, -383, -430, -76,  276, -335,  295, -247,  353, -136,  54, -63,  123,  200, -121, -417,  188,  126, -50, -369, -67, -230,  63, -131,  478,  281,  29,  412, -308, -123, -133,  94,  346, -63, -482,  474,  455, -335, -273, -340,  382, -366,  98,  05,  334,  477,  441,  22,  455, -109, -495, -111, -487,  421, -390,  491, -446,  139,  403,  98, -132,  123, -308,  67, -440,  63,  41, -133,  228, -379,  28,  462, -245, -374, -32, -59, -45,  261,  464, -90, -348, -179, -349,  17, -258, -239,  08, -204, -248,  264,  394,  121, -113, -61, -312,  299, -498, -419,  19, -418, -298, -453, -455,  309,  25,  13, -249,  480, -226,  67,  242,  278,  388, -254, -205, -17,  07, -345, -369,  260, -229, -474,  233, -490,  317, -227,  310,  319, -146, -171,  401,  57,  228,  446, -134, -247,  311,  469, -267, -63,  36, -173,  67, -75,  73,  362, -240, -67, -130, -109, -307,  141,  269, -222,  152,  86,  51,  314, -95,  405, -05,  159,  314, -277,  105, -319, -24,  269,  02, -439, -294, -461,  240,  274,  316, -186,  488, -424,  247, -142, -33, -208, -148, -263,  70, -496,  323, -27, -330,  81, -122,  165, -260, -307, -260, -303,  226, -432,  466,  80, -19,  25,  119, -279,  151,  287,  35,  139,  363, -218, -150,  183,  426,  202,  420,  348, -442, -405, -179, -272, -472, -448,  393, -232, -255, -15,  318, -177,  53, -364,  403, -466,  161,  375, -245, -188,  162, -357, -196,  378,  277,  154,  61,  204, -144,  333,  52, -86, -220, -274,  142, -191, -222,  387,  429,  375,  224,  247, -302, -223,  384, -47,  163,  397, -172, -230, -290, -157, -87,  14, -279, -309,  20, -366, -253,  376, -181, -349,  142,  99, -123,  136, -240,  155,  375, -310,  30,  99, -211, -420,  376,  25,  34,  391, -77, -286, -339,  485,  409,  75,  351, -18, -382, -129,  116,  217,  99, -213,  368,  93,  387,  98, -271, -01, -247, -396,  189, -364,  203, -169, -284,  431,  356, -398,  322,  131,  169, -165,  116,  78, -238,  319, -439, -120, -310, -471, -51, -359, -183, -182,  234,  56, -232,  463, -445,  373, -81, -403, -491, -26,  280,  78, -95,  136, -468,  79,  120,  201,  415, -264,  132,  29, -444, -455, -238,  98, -426,  211,  240,  243, -119, -26,  151,  149,  290,  207,  23, -291, -344,  32,  184,  436, -38, -59,  424, -05, -127,  44,  48,  140, -367, -320, -331,  41, -275, -69, -09,  152, -357, -269, -105,  24, -442, -101,  26,  348, -394, -451, -91,  114,  433, -407,  402, -104,  35,  326, -257, -240,  223,  291,  400, -292,  472, -431,  249, -303,  01, -260, -299,  496,  324,  449,  20, -266, -152, -454, -418, -46, -53, -09, -80, -119,  437, -178, -371,  324, -352, -128, -416, -277, -337,  484, -69, -13, -447, -320, -463,  406,  273, -262,  402,  449, -313,  275, -317,  35,  321,  117, -159,  121, -40,  261, -498, -103, -417, -17, -279,  84,  355,  157,  307, -130,  141, -261,  358, -453,  271,  395,  453,  396, -367, -292,  345, -179,  483, -120, -292, -344, -151,  50,  277,  310, -189, -369,  59,  247,  114, -367, -169,  321,  290, -10, -308,  284,  229, -98,  331,  353, -203, -364,  249,  282, -156,  447, -45, -173,  179,  164, -16, -471,  66,  113, -309,  377,  245,  250,  124,  211,  383, -193,  33, -474,  298, -423,  310,  379,  331,  493,  232, -20, -371,  334, -238,  326, -367, -430, -347,  312, -414,  489, -307,  152,  455, -116,  381, -448, -365,  358,  263, -130, -335,  148,  248, -185,  225,  58,  47,  408,  403,  131, -112, -467, -35,  151, -289,  450, -427,  216,  263, -341,  206,  456, -337, -487, -159, -456, -435,  328,  402, -320,  50, -80,  329, -201,  235,  406, -291,  134,  315, -387, -234, -297, -02, -417, -294,  209, -466, -221, -75,  297,  290, -17, -395,  453, -04,  298,  498,  413,  478, -248, -406,  29,  172,  423, -320,  260,  329, -111, -106,  496,  02,  160, -300, -148, -404, -94, -439, -370, -462, -13, -221,  328,  470, -116, -366,  319,  35, -368,  232,  13, -116,  326, -106, -91,  249,  74, -331,  431, -184,  415,  427, -330,  428, -21,  23, -476, -262,  84, -346, -224, -77, -67, -44, -106, -331,  90,  65, -444, -426, -203,  422,  311, -24,  168, -280,  77,  95,  241,  08,  411,  156,  288, -419,  84, -233,  456,  108,  05,  41, -386, -367,  464,  399,  442,  210, -79,  32,  127, -23,  107,  425,  251,  270,  253, -80,  490, -170, -485, -417,  339, -222,  239,  479,  211,  176, -254,  168,  136, -396,  61, -397,  89,  377, -498,  31,  440,  275, -436,  67, -247, -477,  344, -144,  293,  97,  276, -365,  428, -357, -282, -381,  273, -191, -402, -15, -163,  196,  05, -174,  300, -434, -71,  242,  443, -69, -227,  383, -293,  189,  303,  312,  212,  147,  20,  357,  97,  149, -156,  377,  292,  414,  496,  66,  76, -54, -97,  413, -358,  408, -261, -205,  474,  168, -463, -231, -48,  162,  05, -489, -148, -192, -325, -84, -193,  195,  126, -244, -156,  470, -367, -11, -263, -19, -93,  313,  427,  310,  226, -430, -430, -182,  217, -104, -162,  254,  165, -358, -84,  22, -347, -380, -318,  180,  37, -10,  228, -337, -402, -76, -15, -268,  413,  222,  213,  172,  35,  141,  334,  114, -437,  404,  432,  280, -200, -230,  386, -182, -87, -198,  340,  418, -77, -477,  99, -188,  365,  179, -25,  463, -397, -188,  47, -131, -465, -239, -459,  70, -246,  376,  36, -183, -368, -32, -403,  285, -409, -165, -397,  356,  489, -205,  274,  264,  170,  225, -424,  387,  256,  403,  351,  360, -284,  250, -271, -249, -489, -230, -327, -235, -02,  210,  434,  131,  30, -117,  268,  473,  218,  371,  329,  208,  18,  456, -28,  41, -467,  401, -72,  290,  304,  131,  150, -480, -118,  379,  123,  245,  01, -351, -137, -500, -289, -203,  483, -407,  181,  251, -433,  251,  474,  396, -41,  344,  352, -216, -115,  386, -315,  314,  176,  489,  297,  178, -138, -321,  57, -163,  425, -90, -14, -212,  262, -451,  437,  245, -357,  118,  348, -290,  222, -326, -42,  33, -129,  163,  317,  256,  49, -498,  422,  77, -156,  220, -245, -442, -249, -336, -105, -324,  74, -266,  316, -163, -217,  254, -66,  278,  224,  135, -160,  298, -339,  299, -168,  32, -38, -351, -211, -137,  04,  63, -208, -300,  135,  47, -242,  387, -437,  153, -85,  489, -261,  84,  178,  375,  190, -35,  153, -86, -400, -154, -287, -239, -03,  397, -354,  459, -454, -65,  174,  402, -150,  466, -398,  486,  365, -140,  373,  428, -134,  140, -231,  457, -276,  448,  332,  414, -87,  338,  181,  365, -316, -254, -22,  181, -357,  124,  492, -311, -89,  166, -56,  262,  484,  46, -400, -299, -241,  473, -19,  125,  465,  250,  82, -310,  198,  267, -44, -37,  105, -363, -172, -359, -117,  307,  322,  378, -69, -334, -80,  343, -316,  364,  457, -332, -90, -443, -131,  169, -118,  350,  146, -153,  452,  81,  389,  151, -152, -154, -34,  453,  335,  295, -54, -281,  454, -232, -51, -115, -66,  369,  80,  118,  233,  37, -362, -356,  94,  359, -335, -172, -439,  312,  176, -487,  245,  65, -484, -407, -237, -17, -102, -401, -222,  344,  170, -268, -36, -381,  469, -250,  489,  402, -280,  222, -61, -142, -282, -114,  69, -116,  214,  130,  48,  242,  143, -207, -192,  160,  238,  423, -357, -12, -478,  273, -168,  192, -143, -352,  312, -174, -102,  301, -272,  118,  375, -480, -172, -406,  258,  397,  330,  324,  27, -122,  67,  22, -477, -273, -318,  261, -350,  177, -251, -327, -50,  433,  365,  307, -419, -471, -14,  331, -318, -434,  301, -442, -414, -19, -348, -304,  230,  482, -479, -243,  212,  88, -369,  235,  315, -186,  348,  465,  491, -51, -10, -58,  234, -144,  101, -333,  237, -413,  498,  420, -346, -349,  478,  92,  132, -18, -359, -138,  316, -338,  471,  28, -398, -398,  115,  417,  268,  315, -266,  260,  116,  225,  54, -150, -67,  07,  17, -330,  447,  367, -410, -47, -482, -80, -455, -498, -246,  38, -136, -430,  200, -165,  450,  302,  289,  417, -429,  58, -416, -194,  170,  200, -117,  76, -450,  316, -65,  419, -162, -118,  286,  281,  335, -344, -299, -267, -342,  308,  271,  22, -270,  324, -291,  33,  126,  499, -50, -450,  409,  387,  208,  431,  87, -409,  07,  138, -241,  442,  409,  97,  177,  196, -122,  12,  352,  432,  245, -489, -408,  17,  385, -178, -159, -405,  355, -181, -54,  158,  221,  207,  45, -71,  138, -16,  372, -03, -26, -369,  291, -116, -419, -32, -420,  311,  481, -216,  243, -422,  147,  335,  447,  33,  10,  140,  480, -135,  460, -74, -125, -467, -15, -228, -37, -377,  257, -165,  120, -269,  319, -89,  467,  400,  380, -101,  211, -287,  184,  307, -209, -169,  494, -261, -284,  04,  379, -304, -278, -309,  474,  449, -275, -41, -278, -460,  82, -169,  227,  54,  414,  46, -182,  382,  298, -302,  133,  362,  263, -183, -479, -446, -499, -133,  145, -283,  372,  377,  266, -54, -432, -408,  247,  145,  404, -179,  185,  338,  152,  265, -107,  419,  163,  211, -347, -38, -239,  286,  176, -476, -44, -451, -70, -43, -84, -424, -474,  140,  453, -356, -414, -127, -263, -314, -129, -359,  07, -92,  479,  12, -327,  224, -69,  337, -65,  436, -201,  196, -426, -173, -428,  30, -124,  03, -161,  292,  431, -134, -67, -264,  10,  371,  109, -401, -443, -168,  92,  417,  241,  72, -71,  414, -204, -288,  251, -416, -352, -98, -368, -278,  229,  57, -395, -43, -440, -56, -250, -157,  310, -465,  79,  173,  406,  40, -376, -184,  373,  217, -267,  114, -211,  162,  28,  437, -274,  132, -127, -126, -466,  06,  448, -384, -437, -447,  73, -25,  350, -325,  318,  160, -290,  249,  185, -31, -211,  310, -363,  14,  27, -130, -20, -332, -116, -491, -43,  110,  141,  331, -164, -473,  189,  136, -357,  252, -458, -431,  79,  392, -256,  249,  52,  307, -02,  90, -224, -361, -100, -87, -494, -221, -365, -14, -53,  19, -05, -244, -19, -12, -413,  317,  368,  276,  305, -489,  380,  347, -68, -41,  239,  177, -292,  144, -16, -442, -266, -388, -302,  486,  377, -296, -235, -488, -458, -436,  383,  38, -180, -136, -122,  260,  33,  98,  388, -162,  462,  269, -314, -106,  80,  425, -429,  289,  421,  407, -301, -345, -129,  249, -359, -252,  453,  258, -240, -152, -326, -357,  386,  347,  359,  116,  107,  244, -285, -05, -417, -323, -236,  121,  71,  345,  398,  495,  486,  320, -246, -315,  475,  126,  435, -31,  374, -260, -273, -13,  88,  254,  130,  326,  101,  342,  295, -292,  86, -138, -445, -479,  39, -180,  142, -38,  17,  41,  309,  355, -139, -84, -108,  188, -458,  179, -343, -232,  420,  237,  255,  360,  343,  238, -461, -56,  80,  334,  152,  18, -304, -441,  40, -413,  231, -318,  401, -252,  223, -437, -45, -64, -21,  348, -23,  21,  27,  486,  289,  299,  223,  45, -488,  66, -217, -449, -138, -285, -263, -134,  233,  285, -74, -227,  372, -343,  308, -375,  258,  383, -312, -287, -180,  167, -87,  297, -312, -207,  283, -170, -408,  359, -273, -396,  277,  362,  07, -360, -423,  244,  358, -338,  29, -216, -64,  253,  294, -256,  379,  52, -373, -433, -383,  299, -413,  31,  448,  127,  324, -416,  457, -232,  443, -316,  225, -428, -454, -268,  64, -25,  477, -77,  138,  358, -441, -74,  112,  353, -478,  343, -95,  01, -238,  23, -199, -151, -94,  101,  477,  82,  185,  434,  350,  480, -29,  427, -447,  369, -340,  469,  197, -11, -108, -165, -153,  304, -387, -189,  157, -365,  06, -85,  136,  269, -210, -211, -30,  196,  391, -53,  130,  76,  234,  332,  57,  57,  260,  462, -74,  420,  431, -377,  261,  176,  310, -40, -20,  423,  272, -11, -442,  130,  404, -453, -101, -306, -164,  370, -258, -273,  169,  372,  304, -97,  205,  213,  460,  317,  175,  239, -411,  458, -286,  350,  486, -123, -190,  318, -200, -66, -192,  211, -435, -288,  258,  316,  259, -54, -462, -499,  174,  208,  374,  330, -37,  431,  43,  276, -400,  70,  15, -311,  28, -419, -461,  367, -42, -151,  185, -389, -364,  493, -326, -299,  58, -216, -483, -183,  230, -444,  170, -96, -384,  396,  86,  79, -321, -19, -145, -221, -449, -278, -32,  432,  156,  07,  299, -386, -291,  336,  77, -155,  330,  251,  46,  240, -465,  415, -91,  266, -177, -421,  22, -61,  476, -39, -481, -345,  442,  226, -65,  494,  449,  403, -222,  105,  263, -71, -429,  472, -235,  149, -183, -53,  252, -285, -313,  288, -370,  96,  406,  306, -472,  280, -255, -496, -259, -236,  11, -316, -157, -202,  30, -208,  54, -340, -251, -183,  89, -180,  141, -294, -179, -190,  154, -426,  25,  341, -286, -493,  290, -28,  313,  318, -248, -89, -326,  346, -473, -463, -118, -130, -164, -236,  162, -258, -76, -237,  59, -135,  436, -300,  71, -243,  10, -275,  183, -113, -81,  397,  246,  61,  221,  60,  231,  474,  471,  405, -328,  498, -206,  54, -131,  130,  318, -117, -276,  94,  147,  283,  459,  83, -165,  30, -308, -303, -392,  376,  436,  27, -375,  183, -412,  347, -257,  319, -327,  66, -424,  197,  416, -130, -249,  137, -147, -79, -479,  77, -133, -480,  213, -174,  455, -100, -292, -01,  98,  168,  227,  34, -305,  353,  69,  135, -448, -336,  306,  77,  230, -266, -226,  499,  457,  377,  136,  162,  150, -491,  91, -483, -119,  156,  195,  188, -443, -245, -312, -493,  424,  415,  393, -29, -380, -37, -41,  24,  127,  117, -47,  210,  352, -421,  209, -339, -192, -155,  323,  458,  207, -86, -173, -412, -77, -478, -371, -20,  130, -183, -13,  54,  84, -120, -123,  205,  343,  336,  81,  323,  306, -465,  33,  158, -34, -258,  319,  275,  439,  494,  233,  498,  260, -87, -413, -317,  287, -284,  163, -83,  385,  02, -177, -31,  383, -447,  26, -422, -259, -392, -247, -453, -05,  286,  205,  461, -120,  376, -412, -180,  370, -326, -182,  131,  87,  257,  314, -126, -175,  330, -356,  62, -168, -33, -468,  67,  372,  410,  498, -386, -130, -249, -339, -283, -110, -281, -321,  270, -405, -233, -410, -182, -59,  261,  449, -120,  370, -385,  255,  48, -203, -249, -390,  482, -430, -06,  401,  443, -95,  399, -443, -373,  03, -282, -155,  393, -63,  376,  163,  385, -05, -394, -297, -211, -281,  04,  169, -411,  471,  276,  489, -231, -473, -400,  103, -402,  94,  04, -107, -149,  256, -50, -21, -241, -480, -324, -348,  310, -448, -333,  195,  47,  125, -250,  336,  344,  254,  06, -214,  225, -218, -225, -154,  162,  227,  449, -388,  174, -46,  05, -475, -290, -193,  356,  321, -173, -468, -175, -11, -416,  344,  36,  484, -30,  286,  320,  166,  392,  178, -196,  470, -187,  80, -184,  475,  159,  118, -61, -167, -76,  444, -141,  486, -249,  67,  307,  430,  452, -16, -80, -112, -172,  456, -128,  298, -405,  45,  317,  487, -277, -379,  457,  36, -447, -226,  363,  213, -256, -198, -454,  168,  98,  257,  154,  349, -175,  313,  280, -223, -203,  52,  165,  125,  360, -110,  276,  455,  435,  445,  443, -342, -434,  400, -453, -380,  26,  410, -315,  270,  65, -269, -62, -337, -159, -56, -135,  166,  109, -03, -205,  406, -451, -188,  384,  409,  202, -488,  365,  137,  457,  308, -352, -477, -440, -305, -05,  87, -43,  180,  209, -478, -236,  00,  38,  105,  444,  403,  123,  406, -100,  418,  312, -51,  82, -452,  210, -215, -88,  75, -226, -131,  235,  274,  245, -352,  469,  92, -413,  279, -227,  296, -347,  389, -204,  191, -06,  93,  94, -383, -01, -154, -113,  163, -353, -179, -436,  358,  106, -24,  285, -267,  346,  373, -493,  443, -479, -171,  35, -392, -392, -340, -244, -239, -451,  53, -195,  395, -02,  399, -136, -151,  98, -397, -488,  245, -75, -424,  103, -117,  53,  241,  116,  251,  114,  476,  194,  487,  157,  81, -53, -383, -406,  203,  230, -05,  108, -465, -109, -394, -213, -393, -45,  385, -289,  320,  130,  136,  396,  86, -481,  301, -173,  488,  52, -207, -184,  98, -220,  473, -320,  227, -410,  126, -70,  320, -379, -109, -292,  12, -03, -05,  120, -195, -120,  331, -375, -138,  319, -127, -200,  338, -325,  479,  326, -421, -228, -06,  178,  52, -33, -290,  131,  409,  336, -86,  230,  457,  305, -210,  322,  154,  285,  294,  459,  17,  477, -64, -269,  296,  310,  32,  486, -163,  11, -335, -84, -364,  159, -54,  188, -373, -492,  172, -464,  344, -414, -382, -346,  391, -92, -172,  45,  45, -378,  357, -438, -401,  145,  146, -253,  307, -322, -267, -356, -459, -102,  413, -323, -442, -141, -282,  37, -132,  390,  425,  64,  476, -456, -430, -281,  304, -102, -384,  202,  20, -175, -384,  471,  471,  262, -282,  278, -208, -48, -225, -166,  350, -312,  363, -240,  399, -419,  297, -233, -177,  223, -316, -201, -381, -246,  370, -225,  153,  487,  477,  25,  164, -406, -03,  135, -292,  215,  266,  01, -333, -459, -313, -130,  81, -450,  482, -20, -16,  280, -400,  307,  355, -216, -41, -174,  390,  181,  101,  43,  168,  431, -431,  185, -123,  418, -180,  85,  133, -62, -414, -347,  331,  125,  375, -88,  176,  357,  393,  12,  137, -155, -181,  344,  129, -370, -330,  371,  312, -376, -85,  332, -445,  336,  17, -68,  254, -310, -131,  239,  128,  308,  392, -40, -67,  267, -276, -391,  125, -31,  473,  114,  314, -207, -41,  295, -77,  129,  167,  87,  253, -66, -80, -340, -230,  437,  444, -124, -21, -186, -385, -392, -378, -492,  420,  55, -373, -04, -483,  252,  466,  490, -133,  280,  135, -322,  428, -89, -341,  95,  498, -235, -471,  270, -75,  151,  208, -130, -473, -313, -464, -06,  147, -342,  354,  419, -435,  482, -84, -66,  234, -118,  277, -47,  14, -88,  483, -58, -325, -357, -111, -326, -92, -82,  444, -315, -79, -496,  407,  300,  44,  443, -205,  43, -47, -351, -37,  19, -369, -269,  453, -282,  465, -418, -477,  331, -05, -493, -226,  170,  02,  163, -304, -238, -66, -07, -53,  355,  349, -145,  156, -107,  150,  451, -211, -396, -48, -396,  475,  84, -165, -220, -346,  152, -137, -323, -17, -290,  36, -391,  380, -462,  273, -71, -200,  59, -226, -400, -86, -377,  307, -78,  369, -43,  225, -342,  413, -322,  114,  388, -386, -199, -331, -232,  453,  32, -55,  288,  242, -166,  398,  474, -128, -477,  255, -475,  82, -471, -23, -152,  05, -216,  271,  226,  241, -04, -264,  155, -474,  350,  395, -360, -349, -84, -92, -44,  448, -294, -256, -458,  40, -358, -131, -236, -335, -24,  141, -401,  358, -382, -52, -137,  254,  71, -411, -04, -81, -175,  03, -54, -325,  250,  86,  178, -333, -153, -366, -33,  405, -122,  10,  297,  373, -269, -87, -110,  207, -445,  342,  65,  25, -210, -220, -220, -287, -131, -372,  132, -454,  483, -70,  73,  233, -131, -249,  400,  216,  237, -132,  473, -32, -270,  270, -159,  313, -317, -417,  372,  90,  425,  290, -384,  67, -430,  248,  280,  292, -272,  265, -310, -289, -305,  264,  444,  64, -133, -303,  132, -395,  417,  105,  73, -01, -125, -234, -188,  411,  201,  36,  01,  127, -174,  469,  46,  249,  217,  179,  41,  445, -56,  231,  08,  139, -05,  305,  56, -285, -498, -312, -180, -229,  294,  393,  270,  21,  11, -66, -68, -288,  470,  434, -309, -203, -245,  238, -102, -175, -83,  439,  122, -287, -478, -369, -296,  370,  436,  260, -415, -210, -199, -95,  61, -405,  150, -169,  468, -339,  265, -99,  225, -413,  187,  417,  236,  442,  155, -366, -233, -76, -427,  390,  137, -52, -479, -307, -182, -191,  454, -97,  99, -245, -340, -340,  202, -338, -09,  170,  175,  108, -77, -100,  195, -390, -183, -68, -447, -176,  66, -180,  248,  492, -290,  237, -60,  83,  431, -390,  392, -263,  365, -09,  344, -475,  151,  46, -313, -06,  68, -286, -46,  492,  114, -350, -46, -216,  434,  07,  108,  352, -320,  209, -304,  242,  298,  488, -174,  229, -402,  70, -182,  463, -86, -338, -160, -83, -440,  379,  412,  481, -407,  218,  473, -440,  368,  279, -156, -346, -213,  452, -141, -33,  161,  55,  61, -40,  44, -261,  41,  494,  310,  360, -190, -276, -126, -498,  141, -65, -266,  405, -84, -173,  124,  241,  239,  344,  20, -417, -149, -341, -464,  210,  478, -451,  117,  40,  361,  13,  279,  255,  08,  89,  467, -330, -335, -159, -328, -341, -372,  258, -84,  44, -414, -460,  137,  325, -263, -342, -239,  88,  169,  149,  150,  148,  198, -233, -312,  412,  281,  467, -481,  141,  409,  486, -337, -74, -173,  187,  85,  308, -54, -498, -148,  384, -106, -158, -439,  131,  352, -178,  71,  21,  471, -279, -331, -478,  341,  209,  434,  474,  177,  453,  115,  438, -209, -370,  216,  470,  317, -198,  278, -237,  156, -17, -01, -98,  325,  61, -114,  177,  383,  457,  50, -293,  31,  220, -271,  224, -71,  15,  198, -42,  320,  165,  248, -389,  295, -35, -419,  112, -381, -288, -272, -373,  195,  227,  29,  372, -212,  415,  49,  24, -275, -49,  231, -392, -329, -188,  332,  453,  327,  30,  263,  499, -305,  12, -390,  490, -171,  43,  454, -52, -393,  34,  75,  302, -238, -44,  174,  402,  224,  75,  278,  449, -473,  09, -443,  50,  321, -259,  03, -500,  271, -233,  499, -182, -369, -39,  160, -40, -495,  114, -240, -36,  01, -313, -233, -385,  143, -207, -483, -133, -279,  296,  168,  100,  157, -423, -350,  331, -182, -494,  331, -59,  125, -317,  259,  256,  144, -81,  68, -499, -114,  328, -34,  387, -485, -415, -498, -490, -122, -129,  230,  99, -333, -102, -301, -323,  328,  202, -492, -354,  208,  339,  88,  185, -126,  199, -59, -481, -381, -491, -480,  05, -311,  338,  244, -296,  423,  246, -286, -198, -383, -204, -247,  137,  195,  305,  314,  375,  359, -326, -127,  67, -135,  461, -248,  240, -487, -455,  259, -368, -94, -369,  489,  95, -178,  233,  299, -255,  331, -135,  399,  448,  162,  05,  437,  209, -190, -397,  84, -331, -223,  457, -412,  495, -229,  192,  235, -216,  237,  346,  268, -357, -171,  257, -410,  151, -10,  389, -251, -179,  106, -352,  121, -232, -495,  411, -171, -185, -486, -235,  336,  144, -277, -224,  139,  346,  468,  226, -18, -443,  72, -250,  52, -247, -141,  142, -243,  349,  383,  06,  22, -10, -494, -05, -390, -488, -94, -60,  179, -79,  205,  16, -83, -220,  292, -92, -22, -387, -366,  460, -330, -442,  62, -425, -189,  421,  217,  68, -378,  101, -74,  144, -57, -67, -360,  405, -55,  398, -155, -376,  171, -97,  492, -412, -465,  285, -04,  366, -250,  482, -322, -80, -460,  241, -05,  204, -486,  65,  124, -363,  18, -449, -367,  461,  336,  125,  366, -219,  24,  64,  257, -305, -181,  250,  136,  206,  387, -16,  72, -363, -33,  251,  409,  359,  344,  257,  415,  358, -178,  392,  495,  340, -205, -19, -347, -369, -394, -481,  264,  130,  435,  373, -322,  106,  123, -334, -187,  362,  150, -263, -149, -31, -160, -239,  181, -316, -482,  448, -457,  192,  340, -110,  32, -365,  371,  185,  118,  478, -444, -118,  460, -156, -244, -362,  450, -269, -196,  115, -406, -193, -295,  297,  276,  45, -442,  309,  230, -72,  258, -375, -380,  98,  15, -496, -414, -113,  189,  204, -135, -402, -61,  177,  294, -453,  316, -404, -222, -28,  212,  224, -369, -231,  22,  408,  314,  432, -431,  396, -139,  327, -479,  333,  278,  389,  338, -284, -224,  379,  420,  493,  477,  211,  170, -377,  258,  338, -280, -111,  163, -216, -387,  294,  53,  487, -446,  219, -228, -376,  468,  133, -197,  489,  318, -419,  378,  156, -203,  06,  388,  70, -01, -283,  133,  22, -159, -108, -140,  61,  281, -477,  345, -254, -330,  250,  86, -276, -31,  358,  200, -63,  343, -496,  279,  161, -63, -491,  170,  235,  16,  410,  157, -133, -373, -210,  389, -32, -466,  102, -119, -333,  477,  78,  266, -353, -172, -148,  224,  298, -290, -76,  87, -95,  280,  218, -434, -282,  228, -412, -195,  96,  498,  462,  463, -374,  104, -295,  446,  139,  307,  180, -342,  284, -242,  424, -216,  87, -224, -140,  237,  338, -364,  176, -257,  417, -105,  162, -365, -377, -398, -60,  219, -399,  254, -466,  79,  210, -261,  377,  201, -454,  57,  360, -317,  316,  284,  319,  255, -87, -321,  344,  103, -185,  20, -301,  84,  415,  361, -429, -110,  463,  11, -39, -84,  117, -04, -153, -172,  235, -275, -471, -366,  282, -259,  169,  450, -474, -12, -443,  291, -481,  401, -106,  186,  274,  93, -229, -459,  306, -158, -68, -378, -294,  393,  38, -325, -111,  386,  355, -23, -37, -263,  111,  97, -22, -220,  400,  356,  268,  457,  499, -361, -289, -106,  325,  485, -161, -52, -474, -02, -357,  310,  120, -151,  204,  10,  376, -55,  248,  232,  422, -289,  469,  33,  309,  299,  313,  209,  156,  433, -482,  155, -428, -271, -99, -250,  66, -407, -450,  93,  91, -307, -97,  63,  394, -41, -427,  271,  405, -326,  03,  327, -115,  324,  213,  46,  123,  378,  107,  131,  312,  478,  139, -264, -293, -460,  338, -374, -15,  389, -429, -424, -418,  326,  139,  477, -214, -435, -400,  43, -261,  103,  222,  124,  279, -65,  23, -98,  166, -18, -114,  330, -40, -475, -434, -480, -83, -243, -354,  403, -354, -283,  479,  80, -105,  471,  409,  181, -464, -491,  76, -225,  464, -201, -249,  243, -414,  274, -02, -396, -243,  384,  434, -431,  409, -499, -411,  178,  110, -265,  81,  256,  304,  61,  188, -300,  32,  98, -267,  420,  459,  310, -305,  424, -39,  298, -481,  399,  425,  17, -496, -318,  253,  438, -249, -486, -209,  193,  193,  401,  428, -226, -491, -415, -313, -450, -215, -429,  148,  18,  491,  459,  180,  38, -265, -07, -163, -245,  245, -238, -376,  249,  296,  378, -461, -101,  392,  183, -408,  437,  436, -479, -288, -202, -394, -101, -152,  243, -29, -152,  113,  314, -193,  146, -147,  43, -361, -458, -350,  384, -196, -226,  485, -400,  04, -123, -01,  249, -440,  444,  186, -152, -183,  398,  146,  275,  150,  494,  18, -27,  194, -17, -213, -146, -371,  492, -251, -231, -466, -101,  05, -162, -475, -09,  290,  30,  368,  142, -221, -220,  86,  465,  480,  403, -284,  127, -470,  366,  473,  48, -161, -480, -469,  478, -126,  13,  471,  123,  282, -495, -478,  139,  196, -101, -18,  338,  429, -150,  332,  60,  482, -82,  26,  463,  173,  242,  442,  203,  460, -233,  103,  151, -213,  487,  129,  161,  00,  452,  136,  134, -190,  158, -227, -494, -442,  256, -304, -161, -42, -471,  400,  293,  299,  278, -392, -27,  372, -450,  28,  332,  169, -16, -17,  457, -29, -36,  470,  471, -83,  107,  457,  227,  117, -270, -415, -473, -162,  133, -133,  297,  162,  119,  90, -38, -103, -450, -213, -231, -48, -333, -47, -379,  151, -212, -70, -26,  252,  253,  297,  21,  212,  254, -252, -171, -163,  185,  209,  175, -181, -72,  324, -167, -453, -86,  295,  296,  316, -66, -435, -232,  102,  370, -110,  105, -342, -328, -68,  410,  425, -271, -68,  137,  484, -468, -181,  173, -430, -472, -152, -111, -44, -327,  222,  355,  439,  370,  151,  256,  156, -432, -476,  110, -210,  266, -284, -52,  439,  148,  210, -284, -271, -06,  354,  65,  379,  25, -262,  449,  53,  87,  190, -139, -388, -88,  68, -449,  134,  71, -341, -209,  491,  36,  401, -219, -198, -31, -419,  93, -31,  291,  310,  199, -214, -484,  116,  17,  41,  355, -34, -54,  294, -344, -341,  406,  420,  227, -191,  407, -202,  321, -302,  141, -143, -49,  422, -489, -227, -497,  105,  242, -354,  267,  293, -68, -365, -90, -199,  176,  117,  267, -26, -89, -225,  133,  169, -304, -140, -170, -397, -490, -349,  153,  151,  08, -396,  425,  20,  229,  428, -23, -28, -426, -256,  117,  359, -121, -121,  12, -93, -152, -220,  381,  259,  55,  14,  280, -397, -274, -389, -294,  88, -238, -289, -261,  271,  168,  16,  143, -103,  296, -380, -279, -278,  216,  339, -67, -405,  70,  446,  354,  419, -274,  235, -470, -367,  101,  311, -263,  327,  422,  295, -85, -316, -493, -494, -193,  175,  374,  450, -428,  170, -78, -206,  392, -362, -15, -174,  85, -445, -228, -61, -174,  350,  26, -143,  483, -373, -332,  72, -194, -58, -132, -427,  478, -125, -69, -214, -98, -195,  88, -26,  475, -489, -380, -280, -351,  105,  398,  235, -487,  22,  26, -161, -128, -447, -452,  207, -320,  68, -220, -13, -490, -500,  412, -159,  227, -156,  127, -371,  149,  67,  103,  477,  430, -424, -303, -68,  181, -405,  19, -454,  117, -455,  238, -159, -402,  286, -100,  131, -145, -468, -30,  217, -468, -118, -442,  259, -422, -463,  388,  228,  105,  344,  205,  387,  420, -246, -181,  453,  201,  338, -500,  170,  384,  238, -137, -166,  24,  263, -183, -269,  296, -361,  449, -320,  374, -493,  440,  452, -455, -320,  180, -498, -124,  237,  389, -204, -157, -291, -250, -456, -453,  102, -434, -217, -160, -71,  470, -284, -307,  139,  300, -159,  279,  249,  21, -495,  256,  313,  457, -347, -154,  490, -345,  222,  227, -455, -129, -77,  106,  473, -33, -495,  75,  34,  141, -233, -185,  463,  335,  08,  102,  135, -299,  233,  236, -425,  238,  345, -260,  196,  498,  86, -462,  06,  161,  265,  403, -468, -312,  361, -143, -492,  366, -216,  394,  07,  403, -291, -30, -410, -430, -75, -422, -229,  10,  314, -154, -251, -489,  87, -203, -490,  25, -165,  368, -314, -48, -377,  70,  493,  484, -221, -147,  350,  63, -253,  210,  318,  308,  32,  409,  378, -191,  487,  02,  320,  301,  348, -79,  313,  287,  218, -325,  165, -95, -105, -297, -291,  18, -374,  54,  02, -95,  407,  204, -179,  06, -86, -361, -185, -201, -452,  45,  108, -113, -453, -72,  41, -252,  349,  206, -113,  419, -267, -448,  176,  128, -244,  386, -02,  234, -60, -148, -361,  200, -444,  312, -294,  323, -196,  373, -378, -148, -81, -418, -408, -34,  11,  133, -434,  212, -161, -46,  132,  72,  06, -192,  52, -386,  46, -450,  348,  487,  254, -160, -461,  310,  04, -255,  485,  308, -29, -393,  13,  390, -310,  105,  208, -447, -262,  275,  265,  429, -271,  249,  353, -413, -90,  257, -298,  456, -341, -98, -205,  413, -406, -166,  223,  99,  432,  209, -93, -97, -332,  420,  145,  210,  25, -147,  263, -385, -372,  381, -104,  209,  130, -251,  297, -460, -494,  499, -151, -335,  253,  144, -422,  348, -169, -346,  299, -237, -285, -294, -482, -117, -21,  163, -406, -496, -484, -291, -28, -03, -410,  368, -294, -427, -30, -497, -35, -24, -146,  314,  494, -392,  311, -76, -192, -358,  430, -393,  257, -355,  165,  275,  381, -356, -62, -173,  01,  306,  36, -175, -197,  479, -307,  10, -96,  163,  13,  369, -08, -280, -464,  338, -172,  347,  114,  488, -159,  45, -53, -402, -458, -388, -275,  423,  109,  163, -250, -390,  321, -361, -65, -375, -382,  480,  487,  374,  496,  00,  243,  340, -428, -369,  178,  252, -170, -208,  240,  171, -311, -313, -379, -268,  152, -154,  07, -239, -139, -390,  223, -317, -251,  10,  160,  219, -10,  147,  93, -14, -01,  188, -174,  72,  320, -144, -176, -350, -499, -83, -326,  42,  456, -205, -374,  108,  494,  134, -279,  207,  244,  444, -258, -155,  306,  402, -436, -203,  401,  157, -365, -99, -155,  314, -175,  17,  22,  149,  168,  23, -82,  342, -434, -125, -11, -308, -165,  335, -322,  57,  43, -226,  353,  285,  119,  160, -460,  183, -191,  441,  192, -56, -158, -462,  110, -481,  407, -367,  169,  75, -492, -61,  269, -426,  314,  111,  119, -350, -54, -351,  207, -159, -76,  412, -373, -457,  72, -333,  227, -267, -40, -81, -470, -345,  309,  140, -326,  217, -375, -305,  144, -366,  135,  266,  60, -51,  229,  31,  451, -325,  181,  158,  369, -395,  423,  496, -352, -05,  15, -273,  229,  475,  499,  259, -370, -340,  251,  157,  377,  377,  352,  374, -137, -13,  492,  423, -211,  221, -45, -260, -252, -12,  399, -383,  93, -326, -35, -407,  169, -168, -179,  250, -192, -180,  361,  290, -20,  465, -53,  210, -306,  152,  436,  57, -361, -220, -20, -72, -499, -213,  169,  101,  275,  420, -429,  220, -406,  36,  314, -385,  369, -365, -282,  29,  307, -69,  171,  139, -104, -381,  201,  90, -377,  489, -353, -238, -231,  480,  191,  122,  119,  212, -276,  247,  132, -205, -33, -422, -317, -219, -307, -448,  268,  263,  433,  427, -305,  105,  419,  91, -424,  120,  34, -301,  462,  181, -39, -269, -487,  04, -294,  485,  68, -70,  232,  52, -423, -301,  130, -240, -19, -324,  165,  101,  439,  450,  29, -366,  55, -52, -422,  131, -80,  112, -318,  234,  145,  496, -182,  159,  352,  24,  496, -79, -194,  228,  473, -117,  427,  456,  495,  260, -16, -488,  214, -77,  463, -257,  410,  18, -457,  488,  02,  315,  100, -464,  50,  97, -468, -280, -244,  385,  244, -248,  158, -450, -168,  483,  285,  112,  439,  280, -128,  275, -355, -414, -301, -392,  181, -39,  478, -424,  301,  332, -256,  253,  369, -354, -150, -247, -134,  459, -10, -38, -289, -352,  12,  396, -368, -203,  08, -77, -71, -268, -301,  74,  171,  250, -466,  204,  63, -135,  281, -136,  49, -123, -383, -82,  375, -33, -476,  93, -74,  14, -445,  490, -485,  67,  386, -01, -284,  246, -226,  497,  478, -27,  424,  149,  75,  458, -146, -362,  175, -13,  02, -275, -284,  471,  495, -409, -61, -481,  184, -283,  386, -409,  59, -247,  158, -55,  252, -274,  43, -474, -277,  22,  352, -353, -329,  279, -42,  377,  418, -15, -136,  272,  210,  80, -404, -442, -477,  387, -71,  207, -396,  167, -350,  164,  420,  308, -39, -476, -114, -495, -449,  462,  379, -245, -391, -450, -466,  419,  428, -196, -95,  144, -71, -33, -275,  25,  377,  100,  264, -193,  160,  368,  474,  310,  384,  395,  471,  198,  419, -143, -445, -178, -181,  434,  429,  281, -164, -184, -448,  116,  472,  309, -239, -99,  129,  338, -222,  06, -62, -458,  313, -402, -237,  288,  409, -01, -465,  380, -303, -194,  89,  104,  481,  409,  38,  410, -458,  375,  78, -406, -09,  51, -244, -396,  452,  385,  442,  83, -109, -119,  477, -295,  331,  92, -155,  240, -408,  232,  472,  141, -110,  62, -254, -129,  323, -364,  134,  365, -137, -288, -189, -293,  263,  67, -189, -432, -48,  106,  151,  344, -161,  480, -99, -330,  73, -402,  411,  165, -318, -265, -194,  72,  297,  404,  444,  120, -459,  430,  337,  256, -358, -351,  463, -242,  216, -225, -174,  21, -267, -171,  217,  72, -191, -30,  242,  382,  68, -495,  47, -398, -259, -294,  174, -110, -38,  470, -137,  355,  400, -300,  112, -105, -151,  75,  153, -82, -298,  479, -209, -65, -192, -492, -493,  469,  330, -398,  352, -102, -393,  251,  352, -152, -191,  26, -409,  272,  349, -46,  479, -399,  154,  91, -04, -144,  19,  01, -374,  221, -20, -83,  09, -360,  277,  368, -390,  107,  470, -186, -143, -422, -435, -291,  278,  227, -413, -279, -01, -212,  175, -22, -110, -170, -78,  386, -462,  441,  240,  16, -486, -280,  433,  375,  213, -438,  244, -325, -479, -434, -11,  230, -04,  406, -209, -225,  133, -122, -04, -16,  167,  24, -185, -91, -294,  237,  147, -256, -470, -113,  260, -104,  460, -455, -228,  173, -41, -132,  348, -20, -66,  189,  62,  431,  447,  353,  58,  81, -269, -94, -83, -250,  430,  232,  159, -364,  321,  159,  232,  351, -454, -08, -252, -494,  389,  372,  179, -152, -260,  379, -320,  174,  420,  242,  105,  368,  95, -337,  301, -321,  70, -282,  281,  352,  451,  293,  489,  272, -48,  221,  476, -02,  66,  76,  05, -45, -52,  36, -344, -460,  268, -164,  214, -460, -69,  172,  408, -122, -313,  209,  409, -391, -220,  191,  462, -269, -16,  451, -145,  436, -476,  183,  286,  90, -241,  143, -102, -441, -320,  54, -401, -200, -258, -334, -160, -475,  338,  101, -96, -123,  162, -187, -13,  442, -496,  301,  25,  340,  252, -267, -372, -372,  416,  415, -429,  28,  410, -31,  87, -410, -125, -461,  242,  117, -295, -65,  495, -105, -464, -101,  272,  198, -436,  111,  493, -431, -88,  18, -239,  16,  251, -110,  497, -480,  157, -432,  48,  67,  37, -13, -490, -236,  26, -396, -267, -417,  39, -272,  330,  75,  127,  455,  126,  192,  66,  119, -387, -169, -363,  226,  347, -259, -384,  344, -239, -375, -236, -339, -455, -347,  148, -445, -83,  27,  11,  151,  462, -449,  379,  293,  126,  07,  248,  104,  51,  166, -277, -484,  497,  213,  242, -303,  454,  359, -107,  67, -164,  158, -420, -119,  311,  228,  288,  81,  107, -200, -268,  70,  203, -389,  215,  181,  470,  315, -214,  373, -19,  09,  389,  331,  74,  132, -120,  380,  343,  273, -53, -321,  283,  379,  413,  447,  460, -447,  380,  67,  205, -388, -11, -92,  75, -296, -410,  46, -481,  228, -81,  353,  89, -191,  184, -336, -207, -84, -456, -364,  41,  344, -185, -175,  223,  80,  124,  183,  134,  04,  103, -161,  468, -408, -400,  43,  149, -310, -59, -480, -230, -287,  373,  359,  374,  409, -477, -333, -175, -432, -197, -281, -236,  470,  44,  487,  51,  20, -477, -315, -124,  126,  376, -156, -430,  476, -261,  219,  18,  181,  240,  288,  394,  465,  148,  268, -273,  171,  435,  404, -409, -262, -377, -145, -292, -481,  195, -389,  39,  218, -204, -233, -156, -327,  111, -86,  01,  351, -14, -480,  384,  78, -340,  278,  43,  308,  46,  270,  332,  333,  175,  423, -77,  298,  131,  483,  318, -174, -405,  209, -456, -109,  477,  240,  416,  440,  06,  270, -357, -156,  290, -473,  422,  450,  305, -34, -389,  203,  88,  443,  388,  115,  366, -189,  266,  349, -205,  436, -325, -110,  497,  71, -367,  474,  163, -98, -233, -330, -328, -90,  14,  462,  290,  289, -236,  95, -245, -125,  151, -305,  170,  391,  311,  389, -297,  429,  238,  350,  365,  414, -260,  362,  337,  225, -311,  01, -373, -44,  171, -201, -282,  37,  113, -492, -174, -270,  456,  433,  105,  459, -371,  128,  350, -208,  17, -95,  73, -245, -245, -62, -331,  347,  152, -493,  73, -307,  360,  200, -499,  31, -148, -280, -80,  465,  80,  247,  47,  388,  180, -347,  347, -339,  281, -450,  305,  150, -45,  230,  405,  211,  20, -73,  58, -327,  286, -17,  218,  146,  36,  220, -323,  388, -208,  449, -295,  372,  196, -395, -387,  229, -242, -188, -258, -109, -138, -100, -459,  318, -370, -202,  381,  151,  225,  291, -324,  11, -225,  394, -343, -337,  114,  186, -97, -242,  136,  460, -17,  184, -435,  96,  265, -177,  408, -492, -434, -229, -92, -41, -59,  390, -390, -178,  41,  335, -387,  217, -153,  240,  112,  356,  403,  78,  395, -194,  337,  31, -233, -180,  67, -168, -232, -167, -492, -324, -159, -74,  299, -399, -262, -260,  491, -152,  414,  385,  35, -120,  454, -266, -380,  418, -409, -124, -03, -162, -466,  186, -279,  153, -142,  288, -162,  126, -379,  198, -346,  314, -24,  454, -233, -434,  46,  111, -86, -39, -04,  450,  341,  302, -316, -187,  221,  127, -459,  70,  465, -72, -244, -314, -419,  466, -173,  271,  444, -52,  321, -402,  115, -202, -96,  382, -136,  451, -07, -369, -88, -159, -419,  105, -356,  117,  418, -283,  97, -188,  287,  62,  240, -105, -399, -327, -139, -72, -203, -195, -272, -382,  255,  343, -84, -340,  226, -367, -389,  71, -236,  23, -235,  197, -20,  261,  166,  250,  478, -237, -438,  265, -322,  302,  12, -221, -172,  373, -441,  125,  30, -213,  243, -215, -369,  12, -55, -291,  497,  56, -368,  113, -69, -103,  162,  411,  10, -172,  162, -12,  444, -424,  105, -378, -269, -383,  253,  59, -158,  312,  36,  372, -401,  131,  10,  82, -05,  455,  291, -08,  364,  424, -43,  147,  173, -381,  411,  36,  300,  425, -476,  244, -499,  482,  366,  84, -49,  471, -357,  294,  283, -469,  166, -266,  163, -324,  317, -342, -16,  460, -497,  200,  384, -40, -153,  410,  432, -242, -54,  232,  35,  322, -24,  37, -344,  194, -379,  108, -483,  117, -98,  300,  148, -80, -114,  163,  449, -297, -326, -67, -336,  29, -367, -100, -159,  332,  162, -227, -57, -392, -495,  478, -217,  333,  367, -61,  379,  489, -453,  396,  458,  301,  196,  458, -278, -417,  474, -329,  138, -352,  456, -346,  177, -59,  55, -482, -227, -283,  144,  216,  178,  149, -453, -187, -17,  414,  252, -138, -245, -348,  111, -287, -195, -193,  24,  27,  242, -02, -450,  233,  498, -142,  387,  175,  299,  294, -455, -75, -488,  189, -07, -458,  191,  40,  207,  26, -45, -41, -260,  210,  463,  351, -224, -231,  11,  300, -352, -247, -202, -301, -162,  148,  57, -274, -177,  209, -480,  220, -366, -116, -90,  127,  278, -47,  20, -15,  479,  475, -203, -281,  185,  112, -429, -187,  381,  82, -387, -118, -313,  263,  433,  26, -89,  342, -396, -414,  51, -24,  307, -463, -287,  69,  165,  491, -126, -315,  329, -147,  12, -374,  424,  49, -410,  495,  363, -176,  429,  476,  206, -31, -408,  139, -153,  355, -19, -49,  442, -115, -221, -399, -78, -08, -478, -61,  336, -104,  476,  165, -399, -12, -357, -475, -462,  85, -127,  401,  409, -198, -271,  115, -377, -179,  106, -30,  29, -60, -227, -29,  325,  53,  424,  99, -455,  446, -461, -267,  194, -485,  398,  295,  04, -107,  320,  394,  479, -307,  295, -260,  348, -124, -292,  471, -450,  314,  294,  79,  106, -433, -98,  283,  120, -174, -117, -482,  124,  274, -249, -182,  289,  02, -387,  145, -253, -215,  39,  78,  331,  186,  319,  179, -437, -473, -498, -35, -307,  296, -456, -348, -284, -54,  435,  336, -376,  170,  354,  248, -56, -394, -434,  86,  460,  31, -269, -293, -332, -377,  286,  499,  309,  105, -470, -276,  484, -115,  189, -323,  33, -415, -171,  249,  31,  117,  86, -493, -213,  292,  255, -416, -250, -327,  170, -290, -444, -247, -82, -275, -124,  56, -276,  38, -339,  107,  262, -355,  492,  304,  174,  25,  389, -144, -225,  273,  473, -287,  280,  112, -495,  388,  196, -244, -439,  218,  318, -30, -176, -264,  195,  200, -356, -229,  90, -195,  378,  205,  302,  370,  361,  329,  248,  250, -315, -125,  375,  10,  88, -492, -378,  445,  396, -329, -299, -191, -259, -480, -369,  65,  108,  326,  118,  253, -402, -292, -90, -172, -235,  65, -301, -374,  246, -201, -271,  431,  174, -396,  293,  114, -388,  415,  59, -140, -62, -387, -478,  180, -15, -347, -255, -407, -168,  363, -302,  282, -76,  461, -390,  189,  378,  161, -332,  124,  460, -103,  407,  486,  01,  200,  100,  466,  467, -340,  178, -94,  125, -448, -62, -390,  58,  183, -297,  390,  399,  254, -476,  175, -433, -366,  216, -203,  296,  384,  421,  256, -219, -320, -405, -365, -268,  195, -399, -301, -293, -369,  457,  332,  36,  247,  442, -406, -69, -02, -164,  182,  104, -140, -143, -477, -06, -427, -180,  142,  458,  93,  251,  91,  273,  346,  226, -143,  393, -321,  408, -47, -189,  366, -215,  347,  113,  80, -207, -104, -70,  481, -70, -114,  193,  287, -91,  39, -287,  229, -318,  23,  174,  433, -386, -53,  279,  341, -344, -476, -128, -436, -23,  183, -218, -385,  382,  396,  195,  27,  144, -23,  08, -425,  363, -299, -286,  124,  241,  279,  205,  423, -198, -121, -292,  269, -322, -161,  462, -166, -137, -166, -102,  341, -130,  181,  456, -248,  429, -497, -368,  425, -20,  140, -148,  195, -306,  419,  171, -213,  198, -124, -290, -147,  255,  270, -378, -215, -391, -416,  119, -28,  270, -131, -187, -360, -98,  121,  245,  183,  124,  377,  109, -44,  369, -187,  03, -437, -268, -326, -150,  431,  50,  412, -216,  157, -466,  258,  442, -357,  342,  413,  468,  464, -217, -219, -395, -463, -245, -298,  221,  379, -69,  182, -164, -200, -153,  339,  216,  80, -134, -82,  363,  416,  183, -01,  74,  217, -243,  368,  361, -49,  282,  329, -85, -83, -38,  372,  306,  217, -426,  379,  449,  05,  61,  137, -342, -239,  328,  374,  341, -306, -208,  204, -389,  475, -297, -463,  193,  312, -243,  406, -237, -461, -413, -470,  308,  401,  403,  115,  471,  477, -06,  420,  335, -92,  409,  493,  169,  237,  367,  362,  432,  11,  418, -105,  339, -27,  284,  32, -215, -459,  290,  400, -67,  377,  430, -259, -370,  333, -292, -399, -337, -445, -479,  498,  315,  430, -157,  336, -480, -290,  198,  452, -427,  116,  199,  412, -59, -17,  296,  226,  24,  86,  126, -191,  315,  408,  51,  446,  242, -389, -453, -243,  18, -79, -245, -167,  203,  450, -331, -425,  12, -281, -121,  85, -313, -422, -02,  128,  413, -206,  206,  290, -267,  184, -401, -100,  93, -498, -154,  187, -386,  246,  444,  132,  19,  51, -182,  74,  01,  339,  150, -487, -441, -471,  98,  98, -392, -52,  79, -479, -405, -215,  311, -172, -178, -237,  228,  415, -235, -73,  454, -121,  25,  398, -136, -456,  301,  182,  118, -198,  373,  120, -185,  432,  150, -235,  383, -390, -434, -38, -17, -339,  247,  147, -11, -79,  410,  69, -164, -325, -152, -210,  407,  373,  40, -229,  417, -159, -195,  388,  495, -322,  08, -190, -37,  10,  428, -154,  120,  494, -340, -396, -345, -241,  251,  496,  181,  161,  417, -483, -312, -234,  160, -405, -361,  52, -134, -91,  394, -477,  149, -259, -298, -343,  404,  165,  168,  332, -137,  140, -322,  23,  244,  185,  282,  347, -467, -37,  08,  450,  333,  197,  68,  345, -356, -440,  249,  11, -31,  495,  386, -382, -263, -412,  127, -359, -395,  147,  473,  320, -212,  03, -157, -116, -312, -22, -268, -279, -207, -408,  23, -22, -359, -408,  175, -214, -348, -75, -351,  473, -80, -465, -57,  157, -24, -78,  298,  81, -430, -377, -98,  210,  126, -403, -406, -334,  427,  178, -113, -279,  271,  411, -449,  412, -145,  227,  50,  07, -348,  199,  332,  424, -413, -225,  82,  63,  197,  232, -356, -381, -292,  398,  329,  334, -152, -224, -499, -225, -194,  240,  348, -423, -497,  400, -158, -142,  479,  392, -283, -369,  444, -451, -93, -469,  176, -159,  94,  226, -426, -410,  345,  134, -159, -473, -32,  189,  155,  321,  464,  461,  414,  313, -109,  417, -435,  233, -224, -456,  477,  345,  27,  421, -253,  434, -196,  423, -224,  398,  149,  202, -159,  347, -164,  182, -274, -344, -129,  381, -170,  187, -306, -256,  352,  85,  13,  417,  170, -359, -187,  148,  487,  340,  421, -266, -373, -274,  09,  255, -24, -341,  309,  317, -142, -03,  351,  84, -495,  74, -35, -165, -238, -489,  431, -34,  97, -55,  236, -233,  86, -451, -233,  425, -258, -311, -341,  221, -85,  169, -24,  391, -320,  137, -439,  390, -366,  412, -26, -361,  339, -209,  327, -399, -198, -390,  419, -249,  407,  155,  19,  346, -443, -362,  271, -201, -173, -217, -128, -406, -196,  348,  486,  336,  337, -101,  226,  471,  163, -300, -38,  02,  343,  141,  455, -355, -396,  375,  249, -489,  382, -232,  357,  439,  258,  481,  90, -414,  116,  462, -320,  420, -338,  18, -392,  499, -231,  334, -178,  433, -114, -363, -65, -271, -370, -109,  226, -266, -234, -25, -254, -352, -405, -45, -60,  354, -64, -470, -208, -448, -155,  324, -176,  07,  195, -68,  359,  464,  118,  33, -251, -496,  170,  185,  85, -347, -72,  164, -113,  194, -09,  133, -306,  439, -59,  486,  293, -271, -131, -63, -218,  214,  113,  458,  73, -192,  243, -68,  125, -139,  466,  374,  218,  488,  59, -197, -359,  487, -181,  381, -467,  311,  14,  80,  250, -193,  66,  395,  37,  435,  184, -329, -499, -203, -371,  75,  106,  372, -141,  83,  86,  177, -43, -196,  166, -131,  459, -341, -144, -221, -460,  242, -58,  407,  174, -308, -286,  92, -413, -397,  380,  271, -226,  381, -80,  256, -44, -474,  480, -332,  109,  66,  345, -81, -278,  363,  288, -318, -477, -04,  313, -85, -262, -245,  174, -236,  299, -259,  357, -262, -156,  237, -139,  471,  118,  281,  227, -73, -340,  207,  95, -379,  126,  292,  40, -300,  156, -172, -118, -469,  325,  47, -54, -85,  302, -379,  180,  101, -138,  389,  339, -442,  126, -300, -471,  96, -166,  256, -125, -06,  316, -178,  115,  294, -385, -344,  494,  271,  336,  229,  302, -487, -224,  100, -71, -69, -427, -39, -468, -65,  202, -276,  346, -172,  276,  375, -224, -390,  132,  152,  104,  300,  474, -280,  94, -59,  228,  88,  64,  64, -183,  218,  78,  446, -181, -141, -123,  244, -328,  261, -320,  374, -163, -474, -298, -386, -247,  330,  76,  385, -18, -319, -463,  309,  253,  131,  102,  333,  72, -333, -103, -259, -263, -173, -313,  408,  186,  64,  153,  358,  178, -315,  232, -485,  63, -214, -371,  316, -383, -442, -446,  451,  91, -409, -388, -156,  223,  215, -323,  147, -266,  426,  388, -29, -246, -424, -120,  440,  492, -115, -349,  170,  70, -265, -462, -367,  22, -333,  449,  491,  77, -497, -206, -332, -53, -93,  12,  22, -26, -459, -331, -440, -180, -443,  31,  74, -15, -237,  366, -22,  148, -483,  00,  70, -247,  38,  203, -373, -442, -495, -30,  135, -140,  264,  304,  307,  23,  168, -171,  497,  210, -02, -443, -470,  408,  441,  456, -107,  56,  322,  371,  57, -308,  224, -373,  297, -238,  331,  424, -180, -312, -106, -192,  48,  10, -388, -144, -466,  280, -463, -117,  342,  36, -59, -276, -56,  234,  32,  337, -210, -145, -439,  347,  399, -363, -173,  196, -101,  10,  120, -428,  198, -134, -120, -254,  376,  344,  454, -238,  476,  492,  146, -329,  28, -61, -105, -176,  25,  428,  13, -333,  135,  426, -133,  34, -437,  194, -270,  315, -296, -298,  387,  402,  420,  119, -352,  296,  315, -397, -89,  291, -405, -91, -186,  475,  348,  210,  151, -127,  490,  16,  40,  477, -57,  407,  11,  358,  453, -407,  173, -343, -205,  412, -441, -285,  31,  60, -137,  198, -485, -374, -10, -38,  35,  304,  289, -117,  366, -60, -392, -292,  456, -499, -315,  251, -240, -452,  110, -286, -359,  135, -129,  288,  48,  283, -145, -69,  195, -429, -370,  210, -303,  472,  24, -415, -372, -187,  320, -153, -395,  429,  55, -87, -218, -407, -335,  394, -359, -373, -392,  135, -386,  332,  275,  162,  467, -17, -406,  162,  54, -276,  224, -397,  48, -252,  40,  176,  413, -139, -477, -482,  142,  431, -69, -224, -476,  448, -330,  17, -73, -221,  04,  42, -37, -220, -296, -70,  263,  150, -56,  169, -274,  20, -376,  274, -380, -483,  303, -467, -122,  326, -97, -480, -391,  334, -204, -15, -365,  318, -497,  62, -403,  07, -44,  412, -361,  161, -158, -246,  163, -362, -225,  390, -490,  252, -484, -370,  269,  319,  15, -353,  498,  418,  19, -393, -395, -333,  93, -260,  485,  448, -346, -65,  307,  111, -153, -201,  124, -458,  53,  139,  32,  329,  29,  43,  433,  398,  173,  202,  217,  41, -299, -433, -41,  220,  27,  64, -261, -28, -344,  76, -80,  163, -489,  79,  126,  211,  378,  102, -395, -68, -259,  137,  113, -377, -320,  46, -479, -294,  100, -410,  247,  301, -342,  58,  373, -463, -25, -36,  09,  131, -460, -219,  146, -96,  360, -228, -33,  239,  374,  72,  23, -32, -291, -12,  91,  242, -114,  464, -200, -162, -446, -453, -361,  64,  457, -136,  453, -68,  328, -38, -84, -280,  243, -438,  124,  456, -165, -409, -453,  61, -485,  422, -471, -275, -90,  472, -181, -352, -212,  119, -14,  195, -482,  477, -241,  475,  193, -287, -92,  21, -473,  324,  241,  271, -262,  218,  227,  425, -339,  274, -13, -323, -452,  368,  254, -42, -307, -427,  458, -19,  192,  296, -324, -438, -375,  288, -463,  318, -147,  297,  191, -120,  473, -68,  03, -288,  02,  82, -363,  164,  208,  476, -307,  256, -303,  447,  66,  242, -128,  376, -277, -436,  172,  252, -22,  297,  40,  15,  467, -255,  165,  158,  477,  138, -409,  333, -298,  445, -85,  192,  461, -24, -480, -346, -268,  69, -47, -349, -189,  325, -473,  387, -259,  200,  139,  219,  349,  31,  87,  317, -372, -248, -25, -395, -258,  418,  438,  297,  364,  206, -11, -323, -318,  361, -168,  266, -69, -363,  417,  242,  463,  445,  481, -296,  497,  120, -224,  346,  03,  363, -485,  131, -33, -09,  237, -439,  261, -473,  358,  477,  233,  199, -345,  415,  413,  339,  182, -156,  476,  99, -62,  439,  396, -80, -04,  393, -108, -376, -408,  396, -161, -41,  27, -342,  450,  116, -281, -436,  144, -70, -459, -123, -19, -304,  145, -106, -465, -173, -410, -136, -222,  29,  155, -325, -199,  03, -80,  193,  127,  364,  441,  466, -176, -31, -24,  126, -63,  196,  190, -419, -22,  232,  311,  459, -220, -44,  206,  168,  283,  296, -468, -87,  177, -461,  88, -170,  43, -139, -476, -330, -275,  465, -11,  49,  286,  465, -324, -276, -487,  366,  157, -09,  450, -32,  303,  83, -224,  361, -249, -89, -491,  135,  325,  187,  174, -87, -483,  69, -374, -107,  240, -148,  211,  81,  401, -03,  398, -71, -427,  412, -204, -417,  255,  98,  403,  410, -319, -320,  271,  284,  91,  281, -81, -84,  320, -54, -318, -311, -485,  160,  83, -393, -488,  146,  188, -234, -357,  439,  195,  69,  351, -157,  152,  458,  442,  407,  369, -25, -413,  492, -240, -469, -375, -469,  299, -203, -23, -167, -13,  345,  494, -78,  452, -142, -432,  493,  124,  63,  432,  172, -368, -365, -485, -364, -407, -191, -456, -186,  285, -17, -193, -103,  366,  284, -72,  166, -418, -242, -149,  69, -45, -155, -157, -93,  204, -89,  252,  180,  474,  184, -148, -41,  319, -132,  447, -235, -471, -157,  79, -334, -321, -262,  63, -455, -477, -156, -437, -43,  454, -85, -474, -91, -388,  221, -332, -332, -368,  421,  349, -42,  457,  53,  417, -371, -227, -283, -106, -197,  60, -175, -31,  239,  416, -115, -363, -209,  229, -300,  248, -465,  115, -374, -56, -420,  347,  112, -252, -169,  385, -403,  289,  343, -497, -441,  472, -224, -224,  218,  79,  336, -457, -99,  428, -189,  286, -435,  102,  367, -235,  202,  402, -267,  328,  198, -187, -473,  162,  61, -142,  48, -489, -352,  243, -486, -293,  215, -210,  335, -67, -278,  171,  328,  123,  451, -08, -91, -484, -406,  128,  134,  297,  30,  367,  477,  80,  32, -143, -258, -55,  215, -358,  308, -285,  385, -326,  274,  100,  317,  109, -115, -461,  133,  66, -486,  84, -442, -77,  453,  04, -97,  87,  153, -215,  306,  131,  365,  190,  488, -393, -365, -445, -250,  444, -229, -365, -382, -455, -412,  435, -493,  325, -174,  140, -109, -160, -276, -51, -385,  29, -194,  18, -384,  459,  303, -226,  442,  168,  464, -218, -372, -48, -162,  230, -104,  461,  365,  366, -142, -195, -346, -135, -369, -20, -495,  22, -327,  82, -176, -212, -389,  130, -341,  80,  441, -186,  354,  384, -165, -329, -334, -37,  123,  356, -307, -129,  317, -90,  89, -324,  216,  243,  393, -301,  76,  399,  221, -399,  333, -103,  241, -204, -121,  400,  376, -179, -285, -417,  57,  402, -246, -425, -135, -271,  432,  410,  100, -399, -180, -311, -223, -112, -215,  23,  87, -287, -78,  161, -186,  107, -90, -445,  403,  290, -192,  280, -37,  23, -285, -480, -75,  321, -53, -358, -450, -121, -448, -498, -19,  224,  43, -390, -387, -320,  133, -448, -107, -93,  213,  207, -134, -376, -385, -230, -234, -77, -98,  229, -202,  117, -399, -425,  290,  48, -283,  340, -220,  121, -306, -387, -155, -411, -277,  310, -230, -291,  363,  163,  468,  428,  223, -165, -96,  338,  457,  170, -239, -141,  251,  59, -172, -296,  486, -30, -395, -297, -190, -115, -324,  356, -02,  21,  445, -427,  184, -285,  134,  399, -269,  103,  327,  454, -210,  84, -356, -253,  106, -95,  458,  210, -184,  138,  414, -198, -392, -481,  357,  270,  256, -467,  126,  106,  406,  71,  180,  90, -361, -186,  341, -130, -231, -479,  176,  59,  105,  320,  306, -289,  77,  264,  421,  393,  254, -312,  47,  362,  59,  256,  132, -184, -359, -242,  422, -453, -318,  454,  490, -179, -231,  331, -457,  390, -296,  219, -50,  309,  39, -244, -127, -384, -127,  146, -139, -373,  334, -240, -158, -106, -484,  474, -438,  09, -267, -164,  408, -85, -209,  398, -412,  412, -418, -369,  302, -214,  350,  104, -52,  241,  361,  321,  357,  86, -33,  70, -435,  154,  330, -93, -100, -302, -118, -38,  207,  467,  298,  467,  234, -59,  366,  322,  205, -200, -195,  08,  438,  07, -388,  238, -252, -175,  59, -43, -237, -121, -473,  181, -467,  357, -60, -67, -93, -326, -253, -34, -359, -103, -67, -273,  339,  151, -99,  44, -197,  206, -96, -258,  65,  369,  480,  313,  46,  392, -230,  310,  123, -203,  343, -492,  06, -217,  293,  413, -42, -460, -121,  451, -63,  313, -321,  128, -36,  432,  25,  268,  139,  429, -138, -296, -350,  194, -130,  197,  438,  140,  07,  61, -210,  202,  69,  296,  485, -138,  210,  295,  254, -59,  247,  44,  106, -222, -328, -77,  62,  197,  43,  53,  479,  405,  258, -371,  451, -20, -322,  390, -28,  185,  303,  262,  239, -127,  59,  225, -413,  121,  20,  342, -86,  119, -114, -479, -251,  410, -56,  312,  460,  487, -135, -209, -256, -25, -80, -305, -193,  99, -63,  280,  136, -259,  42, -124,  466, -47, -47, -447, -426, -175, -253, -11, -203,  485,  362,  46,  396, -194,  210, -292,  145, -72, -01,  389, -245,  419, -416,  63,  370,  22, -157,  359, -385,  385,  87, -419, -161, -460, -366,  265,  217,  234,  106, -486,  219, -32,  413,  467, -374,  123, -325,  271, -97,  174,  160,  159,  446, -403, -278, -332,  471,  417, -473, -414, -346,  466,  19,  345, -142,  153,  111, -424, -113,  69, -410, -41, -110, -145, -74,  16, -169,  102, -212,  234, -224, -200,  245,  74,  249, -181,  243, -428, -264, -378,  10, -109, -411, -471,  88, -53, -465, -301,  375,  274, -379, -182, -267,  11,  173,  160, -473, -496,  114,  167,  239, -258, -180,  336,  317, -79, -344,  60,  346, -108, -466, -144, -365, -25, -114,  224,  423,  273, -225, -350,  47, -104, -32,  281, -241, -358,  293, -213, -354, -93, -194, -263,  149,  478, -426, -34, -100, -270, -122, -254,  474,  265,  454, -38, -260,  192, -314,  15, -35,  313,  166, -487,  62, -366,  294,  321, -224,  439, -40,  275, -154,  267, -136,  495, -403, -62,  314, -03, -480,  44, -405,  495, -191, -450, -43,  50,  242,  495, -435, -292, -340,  231,  73,  222, -282,  219,  44,  346,  158, -496,  121, -496, -377,  486, -149, -279,  276, -335, -430, -351,  210, -334, -356, -481,  68,  453,  421, -190, -200,  487,  370, -40, -430,  295, -317, -212,  14, -421, -365, -328, -65, -392,  28,  411, -54,  380, -16, -277, -103,  54, -128, -41, -428,  368, -21,  492, -327,  252,  155, -27,  239,  25, -215,  310, -179,  320, -402, -313,  399, -267,  212,  187, -158, -260,  98, -360, -28, -418, -137,  370,  488, -413,  181, -87, -193, -340, -95, -20,  413, -440, -195, -496,  438,  443,  314,  111,  263, -235,  298, -485,  350,  10,  202,  44, -397,  152,  185,  427,  234, -100, -351, -426, -12,  331, -13,  295, -157,  393,  128,  108, -195, -215,  113, -257, -272,  279,  354,  492, -456,  153, -141,  395,  15, -439,  291,  470,  213, -24,  398,  299,  377, -453, -275,  217,  378, -435,  364, -278, -190, -08,  330,  115,  278,  295,  359, -142,  75,  213,  202,  471,  218, -439, -282,  86, -26, -490,  56,  39, -14, -46,  190,  215,  02,  416, -68,  232,  481, -203, -194, -209, -359, -363,  406, -229, -216, -383,  130,  359, -317,  184,  331,  401,  246, -99, -13,  72, -89, -104, -388, -250,  350,  302,  465,  204, -430,  250, -63, -97, -101, -405,  194,  40, -268,  453,  312,  369, -78,  294,  228,  105, -22,  411,  359,  76, -187, -154, -351, -424, -406,  113, -174,  445,  267,  144, -499,  338,  246,  290, -259, -355,  386, -212,  185, -30,  93,  349, -161, -485,  143, -80,  121, -26, -169, -20, -98,  496, -322,  51, -75, -227,  16,  251,  70, -216,  247,  71, -378, -07, -138,  215,  138, -252, -145,  176,  218,  448,  25, -442, -184,  21, -22, -211,  495, -339,  269, -103,  10, -201, -199,  435,  424,  317, -462,  346, -47, -362, -82,  427,  131, -368,  143,  122, -120, -150, -202, -50,  151, -325,  360,  467,  196,  190, -244, -457,  352, -123,  293,  214, -472, -54, -499,  453,  115, -461,  299, -431, -323,  69,  496, -339,  201,  491, -365, -67, -158, -67, -264,  493,  108, -404, -188,  157,  287,  68,  200,  491,  445,  345, -443,  473, -209, -442, -222,  407, -403, -70,  476,  127, -149, -176, -360, -447, -184, -225,  338, -490, -440, -426, -145,  168,  23,  167,  177, -190, -265,  230,  153,  32,  75,  210,  357,  367,  268, -364, -374, -283,  418, -398, -304, -231,  278, -164,  174, -406,  463,  365, -44, -477,  439,  311, -456, -38, -22,  221, -376, -435, -49,  277,  449, -473,  339,  307, -254,  107, -205, -128,  325,  65,  326, -127,  334,  104,  210,  361, -449, -475,  226,  359, -451, -483,  171, -407,  332,  01, -334, -192,  419,  118, -414,  368,  497, -223, -473,  95,  385, -178, -181, -438,  387, -355, -65, -426, -399, -03, -213,  04,  23, -135, -136,  424, -118, -113, -131,  66,  388,  35,  375,  307,  05, -187, -472,  354,  90, -445, -51, -25, -122,  268,  389,  117, -235, -175, -457,  219, -326,  182, -277,  197, -453,  439,  121, -70, -174, -158,  496, -285,  378, -277, -126,  235,  36, -98,  90, -373, -42, -109,  454, -312,  12,  344, -343, -371, -331,  53,  348, -157, -265, -76, -107, -217, -137, -134, -435, -458,  209, -87,  109,  439,  137,  483,  174, -327,  238,  116, -200, -304, -492, -245,  236,  372, -401, -255, -499,  120,  298, -298, -185, -114,  126, -440,  169, -159, -73,  234, -117, -12, -353,  492, -73,  284, -172, -47, -190, -434, -430,  110,  114, -70, -283,  202, -198,  168,  447,  155,  140, -402,  357,  456, -16,  335, -484, -347, -323,  295, -261,  412,  135,  238, -243, -438,  375,  85,  368, -315, -497, -210, -353,  469,  220,  217,  171, -126, -115,  470, -119, -474, -432, -261, -166,  404, -426,  202, -443,  103,  350,  148,  16, -15, -113,  273,  400,  114,  210,  268,  299, -435, -442, -202, -466, -370, -485, -443,  356,  253, -121,  89, -369,  300,  328,  317,  204, -245,  19,  262, -290,  221,  262,  226, -293,  01,  351, -393, -385,  413,  375, -234,  478, -215,  65, -136,  267,  432,  273,  475,  185,  05,  64,  316, -195,  245,  133, -491, -148,  05, -377,  62, -274,  386,  141,  285,  239, -08,  392,  355,  258, -381, -379, -412,  256, -462,  305,  23,  471,  78, -02, -492, -417, -437,  325,  240,  308,  310,  250, -340,  167,  373, -426, -254, -389,  215, -469,  351,  60,  424, -442, -182, -105,  31, -94, -348,  70, -289,  175,  41, -358,  26,  49,  77,  89,  226, -182,  249,  389, -80, -239,  408,  145, -165, -346, -391, -449, -314,  460,  111, -38, -130, -219,  357,  401, -461, -491, -29, -249,  185, -136,  245, -289, -234,  174, -348, -156,  492, -247, -267,  264,  14, -358, -90, -299,  148,  19,  104,  334,  331,  67,  148,  53,  348,  06, -46,  388,  367, -222, -09,  52,  142,  88, -385, -240, -238,  119,  105,  107, -276, -310, -129,  238,  184, -367, -208, -167, -496, -252,  19, -313,  316, -332,  240, -484,  174, -305, -244,  393, -27,  247, -54, -33,  187,  413,  228,  450,  385, -167,  57, -391,  23, -220, -300, -292, -86,  344,  393, -82, -408, -88,  106,  408,  80, -154, -223,  106,  393,  33,  00,  218,  133, -202, -314, -180,  63, -234, -230,  300,  99, -321,  410, -26, -40, -38, -466, -274, -194,  427,  144, -102, -160,  102,  159, -228, -199,  436, -269,  46, -31, -417, -235, -46, -119, -49,  275, -204,  217, -455, -403,  168, -275, -141, -06, -463, -327,  29, -237, -21,  308, -241, -271,  00,  362, -260,  273,  15, -324, -144, -439,  498, -61, -174, -48, -328, -371,  79, -32, -302,  125,  417, -282, -298, -224,  213,  91,  301,  94,  354, -220, -98, -35,  362, -245,  179, -398, -120, -306,  131,  236,  108,  481, -325,  434,  285, -153, -84, -135, -333,  114, -158, -415, -315,  396,  213,  398, -13,  15,  344,  193,  295,  98, -342, -491,  353,  338, -36, -267, -116, -53,  469,  492,  280, -04,  427,  417,  343,  195,  134, -489,  161,  476, -52,  346, -276, -339, -404,  211,  176,  440,  256,  324,  391, -233,  333,  244, -395,  149,  478, -11, -404, -201,  334,  376,  296, -387, -354,  491,  308,  280, -146, -31,  257,  302,  168, -167,  464,  264, -103,  140, -443, -347, -36,  448, -80,  150, -456,  377, -201, -126,  219,  248,  174,  53,  124,  322,  166, -378,  313, -26,  403, -332, -205,  160, -178, -185, -155, -214, -68,  242, -221,  341,  396, -405, -359,  168,  245, -315,  46, -455,  60, -235, -355, -266, -330, -379, -92,  336, -256, -279,  162, -353,  241, -191, -341, -436,  125,  04,  202, -91, -253, -167, -250, -05, -71, -109, -337, -326,  76, -439,  71, -12,  178,  216,  222,  348,  338, -18, -464, -418,  204, -450,  81,  297, -140,  240, -287, -163, -256,  416,  246, -09, -251, -152, -162, -470,  239,  02,  57,  167,  63, -20, -344, -258, -303, -270, -58, -113,  213, -21,  321,  269,  29, -98,  66, -259, -06,  280,  78,  238, -452,  176,  82, -203, -476,  420,  180, -385,  274, -263,  283, -162,  217,  439,  432, -234,  21, -126, -495, -266,  353,  326, -497,  235,  80,  70,  476, -426, -150,  55, -335, -102,  83,  247, -453,  460, -481, -421, -425,  294, -184, -290, -16, -114,  01, -84,  152, -477, -358,  158, -243, -152,  336,  113, -417, -83, -317, -441,  343,  385,  466, -492,  135,  402, -393, -466,  362, -21, -386, -211,  125,  282,  00, -391, -332, -499,  377,  321, -124, -481,  331,  134, -133,  167,  99,  302, -64,  282, -286, -220, -481, -320,  140, -494, -418,  248, -108, -204,  79,  358,  86, -296,  141, -62, -187, -339,  291, -310, -166, -332,  61, -335, -346, -219,  333,  253, -65, -231,  387,  149,  49,  406,  330,  42, -236, -236, -210,  156,  413,  369,  367,  351, -75,  08, -211,  238, -479, -68, -220, -144,  100, -307,  21,  254,  326, -146,  359, -238,  476,  246,  411,  377, -496, -407, -81, -232, -142, -439, -223,  123, -218, -356, -26,  207, -496, -385,  297, -475,  47, -423, -119,  00,  123, -245,  106, -51,  109, -34,  211,  437, -288,  123,  315, -283,  216,  86,  337, -74,  148, -34, -451,  430,  462,  375,  490, -182,  490,  287, -156,  390, -283, -423, -110,  340, -168,  496,  141, -206,  314, -147,  83, -473, -172, -102,  96, -104,  485, -67,  323,  485, -248, -276, -233, -286, -400, -243,  33, -58, -455, -271,  184,  114,  158, -426,  306, -157, -77, -53,  489, -263, -348,  72,  116, -20,  471, -288,  377, -192,  498, -448,  145, -250, -224,  412,  316,  228, -330,  201,  23,  67, -218, -293, -319,  441,  134, -161,  136, -91,  286,  125,  498,  439, -303,  115, -81,  20, -321,  148, -320,  29,  200,  325, -369, -171,  238,  448, -91, -240, -499,  432,  327, -216, -360, -140, -275, -374,  199, -287,  35,  337,  338,  385,  276, -465,  00,  48,  408, -468,  48, -412,  61, -251,  414,  193,  430,  152,  493, -161,  412,  494, -228, -409, -222,  264, -49,  355, -258,  02, -432, -371, -161, -242, -486, -384, -206,  367, -484, -298,  399,  64, -210,  312, -335, -296,  357, -405, -292,  350,  287, -28, -303, -89,  63, -25, -325, -134,  183,  269,  368, -397,  398,  60, -138,  412, -472,  156,  279, -456, -290, -470,  108,  352, -305, -374, -91, -448, -279,  117,  403, -492, -58, -48,  271, -495,  427, -202, -128,  462, -433,  92, -434,  465, -348, -72, -270, -320, -64, -139,  76,  498, -108,  37,  350,  87,  163, -241,  491, -264, -271,  394,  97, -477, -154, -132, -472,  126,  167,  252,  440,  234,  197, -494, -448, -299,  286, -218,  234, -278,  143, -190, -280, -113,  347, -429, -174,  10,  182, -182,  247, -237,  64, -156, -214, -237,  212,  167, -259,  231, -81, -319, -34, -32, -312,  18,  170,  474, -348, -96,  49, -353, -434,  269,  35,  414, -308, -287,  276, -273,  31,  375, -10, -404,  71, -371,  211,  136,  296,  452, -133,  67, -15,  333, -464,  173,  203, -442, -500, -293, -38,  49, -145,  28,  170, -258,  294, -285, -45,  71, -58,  487,  298,  432, -65, -130, -87, -02, -494, -291, -50, -127,  277,  435,  59, -335,  461,  114, -277, -187,  322,  185, -286,  29,  65,  384,  271,  212, -401, -274, -217,  41,  65, -419,  326, -500,  303, -261, -02,  309,  301, -200,  35,  78,  88, -54, -405,  49, -440, -182,  362, -266, -145, -424,  263, -228, -188,  386,  484, -88, -387, -233, -195,  178,  201, -17, -469,  356,  223,  381,  166,  376, -318,  53, -46, -378,  499,  401,  171, -89, -281,  385,  146,  74, -187,  261,  346,  125,  148,  331, -111, -387, -50, -453, -357,  03,  30,  26, -140,  105, -92, -122, -19,  442,  431, -213, -436, -218, -312, -413,  193, -93,  472,  191, -167,  137,  305,  32, -238, -47,  215, -496,  418,  17, -449, -87, -127,  433,  440, -415,  391, -152, -37, -128,  142,  246, -488,  206, -120,  52,  293, -427, -188, -383, -383,  145,  254,  422,  29, -132,  227, -256,  224,  145,  262, -373, -442, -365, -439, -150,  72, -196,  198, -465,  176,  192, -367, -460, -102,  13,  93,  43,  438,  405, -488, -445,  402, -382, -171, -68,  339, -444, -472,  63, -447,  290,  191, -36, -223, -396,  314,  349, -92,  365, -264, -64,  57,  221,  329, -192,  86, -78, -297,  25, -173,  68,  432,  81,  186, -238, -487,  25,  170, -458, -59,  224, -316, -16, -312,  314,  440, -146, -485,  200, -281,  104, -364, -371, -175,  465, -63,  412,  239,  492,  289, -82,  60, -427, -500, -253, -165, -487, -376, -142, -93,  65, -418,  444, -99,  122,  258, -159,  476, -375, -459, -304,  229,  30, -175, -445, -05, -386, -181,  87, -394, -40, -495, -481,  33, -495, -234, -279, -129,  242,  79, -370,  160,  161, -426, -439, -217, -316, -97,  111, -190,  296,  307, -461, -174, -16, -54, -326,  98, -383,  261, -443,  77, -382, -424, -37, -376,  194,  184,  347,  288, -237, -171, -52, -224, -96,  362,  411,  440, -235,  374, -250, -87,  182,  142,  240, -334, -60,  414, -383,  410,  175,  26, -13,  293,  102,  450, -231,  148,  486, -32, -64,  101,  298, -263, -271,  54, -401, -08, -06,  216, -133, -403, -371, -451, -409,  369,  67,  383,  283, -464,  293,  310,  62, -219,  456,  16,  83,  77,  16,  70, -102,  453, -329,  48,  42, -99, -398,  141,  393,  448, -143,  112, -103, -14,  161,  340, -144,  81,  224, -09,  117,  17,  154,  32, -350,  462, -100,  234,  391,  417,  156, -211, -278, -321,  337,  264,  432, -209, -95, -322, -260,  262,  290,  489,  100,  304,  330, -192, -115,  54, -348, -146, -77,  306,  386,  74, -380, -213,  160, -489, -296,  168, -199,  278,  347, -362,  42, -368,  282,  447, -190, -478, -439, -48, -137, -487, -244, -307,  174,  141, -401,  326, -152,  23,  484, -266, -51, -396,  373, -39, -33, -423, -371,  268,  355, -172, -241,  249, -40, -459, -452, -378, -85, -39,  75,  278, -25,  331, -176, -351,  325,  275, -173, -327, -202, -189,  259, -401,  267,  133,  60, -266, -438,  189, -145, -230, -482,  114, -481,  330, -493, -432,  453,  274,  381,  28,  404,  208,  211, -272, -291,  388, -144,  36, -87, -494,  347, -327, -394,  466,  306,  166, -299,  368,  208,  56, -362, -422,  22,  10,  408,  29,  430, -287, -197,  311, -407,  59,  20,  305,  288,  229, -455, -356,  118, -41,  02,  317,  132,  108,  284,  290,  127,  485,  158,  187,  393, -351,  265, -85, -489, -475, -204,  441,  91,  451, -396,  184,  10,  476, -11,  150, -442,  35, -354,  176,  494,  149, -07,  478, -243,  129,  268, -264,  114,  278,  423,  359, -221, -460, -226, -210, -82,  422,  83, -491,  373,  188,  193, -116, -484, -317, -466, -426, -430, -319, -398, -84,  330,  448, -106, -61,  77,  14,  176,  44, -208,  99, -97,  72,  140, -470,  362, -442,  452,  298, -433,  326,  338,  260, -290,  354, -205, -256, -219,  217,  277, -117, -367,  107,  183,  379, -453, -239, -107,  223,  305,  186,  174,  60,  110,  166,  90,  324, -424,  43,  122, -357, -131, -40, -244,  431, -185,  403,  27,  448,  121, -195,  183, -394, -236, -133,  486,  163,  128,  231,  238,  285,  269, -87, -155, -121, -421, -212, -296, -344,  331,  326,  151,  52,  139, -241,  335, -194,  15, -138, -246, -364, -481,  437,  94,  136, -196,  432, -201, -216,  164, -462, -79, -67, -49,  267, -335,  382, -445,  221, -110, -262,  47, -106, -358,  38,  153,  477,  344, -332,  191, -402,  156,  211, -112, -249,  199, -456,  35,  498, -171, -301, -464,  250,  485,  339,  369, -350, -426, -224,  371, -36,  14,  270,  358, -492, -191,  364,  485,  05, -116,  177,  104, -459,  240, -156,  144,  291, -112, -321,  289,  217, -121, -322,  320,  216, -483, -459, -282, -57, -182, -59,  408, -316, -289, -382, -307,  372,  482, -322, -122, -133, -293, -166,  260, -201,  178, -96, -410, -82,  435, -268, -364,  166, -90, -192, -118,  279, -151,  100, -277,  167, -459, -17, -296,  105,  101, -103,  329,  436,  427,  59, -197, -13,  393, -85,  286,  423,  319, -271,  194, -394,  313,  330,  273, -277, -10, -345, -498,  339, -392,  77,  359, -351, -440, -437, -394,  162,  312,  436,  98,  239, -05, -247, -274,  241, -480, -135, -484, -309,  446,  210, -203,  259,  392, -430,  482, -118, -274, -164,  74,  186,  414,  285, -313, -174, -300, -206,  488, -488, -270,  438, -397, -423,  43,  182,  318,  415, -453,  335, -394, -155,  397, -96, -396,  290, -26, -62,  24, -448, -374, -402,  238, -108, -265, -222,  219, -65,  72, -441,  299, -346, -150,  403, -269, -255,  85, -98, -339,  484,  89, -233, -171, -14,  171,  285,  128, -02, -277, -347,  402,  201, -249,  493, -406,  339, -229,  313, -226,  343, -276, -426, -151,  74, -171,  432,  320,  414,  186,  481, -250,  127,  100,  79, -34,  124,  216, -406, -26,  439, -253, -124,  140,  351, -131, -414,  190,  492,  399, -184, -313, -376,  242,  36, -450, -429,  321,  370, -163,  07, -297,  87, -365, -344,  18,  101,  280, -266, -453,  106,  25, -205,  482,  18, -02,  204,  104,  40,  196,  356,  356, -264, -168,  99,  272,  234, -478,  445,  105, -140, -47, -340, -201,  440,  168,  318,  41,  300, -96,  88, -94, -218, -265, -111,  300, -415, -55,  256,  125, -07,  464,  334,  229,  148,  285,  354, -117,  307,  299, -160,  19, -248,  352,  319, -308,  21,  489, -415, -179,  245, -474,  228, -473,  113, -31, -321,  199,  414, -212,  176, -93, -248,  10, -363,  401, -205, -157, -216, -45, -358,  476,  474,  247,  328, -355,  439, -151, -366, -123,  171, -268,  255,  251, -241, -132, -280,  291, -81, -366, -421, -404,  393, -169,  458, -118,  84,  106,  225, -280, -439,  368, -304, -465,  467, -475,  33, -242,  226,  167,  135,  249,  399,  242,  00,  11, -37,  220, -198,  382, -294, -119, -170, -48, -436, -211,  334,  149,  395,  412, -279, -192, -368, -82, -157, -401,  295,  376, -143,  21,  396, -155, -229, -353, -413, -377, -490,  50,  344, -188,  285, -98, -455, -385,  354, -390,  256, -459, -389,  151,  453, -168, -189, -415,  250,  155,  36,  397,  383,  393,  271, -369, -262, -458,  131,  178,  17,  141,  80, -139, -194, -135,  264, -149,  333,  470, -39,  89, -489,  72,  93,  464,  405,  404, -99, -493,  411, -211, -243, -353, -317, -472, -222,  273, -430,  409,  303,  87,  403, -116, -199, -291,  249, -83,  60,  434,  239, -126,  24,  251, -202, -383, -433,  55, -127,  321,  63, -215, -390, -328, -68,  145, -300, -438, -81,  122, -176,  74,  61, -273,  458,  362, -64, -440,  131, -152,  494, -129,  222,  370, -26, -479,  487,  41,  428, -139, -138,  343,  498, -27, -485, -70, -30, -285, -08,  389,  337, -332,  316, -101, -105,  274,  113, -317, -314, -255,  32,  33,  468,  106, -97, -58,  479, -109,  483,  408, -396,  198,  251, -46,  23,  267,  384,  493,  482,  228, -265,  320,  397, -449, -281,  144, -323, -316,  328, -136, -71, -140,  397, -103, -182, -200, -309, -202, -457,  27, -294, -01, -275,  457,  453,  248, -424, -311, -407, -441,  418, -172, -269, -333, -121,  302,  311,  57,  486,  491, -227, -84,  203,  22, -335, -478,  322, -143, -180, -282, -264,  378,  217, -39,  335,  171,  61, -236,  360,  154, -177, -370,  483,  54,  149,  214, -144, -39,  123, -158, -48,  396, -390,  08, -82,  128,  30,  93, -163, -298,  311,  73, -420,  28, -466, -233,  51,  95,  31,  264,  101,  354,  394,  84,  260,  396, -201, -32, -143, -226,  311, -339, -329, -227, -479,  441,  401,  51,  34, -262,  253, -155,  311,  333, -274,  345, -47, -371,  292,  484,  393, -106, -309, -360, -170,  451, -464,  481, -80,  245, -244,  83, -242,  279,  356, -220,  220,  258,  331, -245,  496,  437,  452,  308, -378,  30, -495,  75,  160,  298,  60,  53,  44, -397,  193,  374, -446, -419,  356,  326,  326, -36, -91, -63, -257,  118,  217,  463, -124,  400,  70,  224,  337,  23,  384,  460, -447,  390,  35,  213, -460, -53,  119,  436,  50,  164,  310,  457,  246, -482,  283,  424, -18,  45, -139, -423,  15, -422, -459, -257,  479,  111,  467, -332, -14, -296, -372,  40, -406, -484,  105, -14, -37, -276, -78, -134, -259,  84, -177, -161,  455, -42, -237,  289, -145,  477,  367,  370, -93,  408, -387,  238,  371, -67,  407, -142,  137, -113, -250, -417, -97,  355,  421, -281, -68, -157,  85, -475, -221,  408, -136, -266,  218,  127, -124, -426,  456, -257,  444, -136,  03, -90, -398, -126,  343, -491, -416, -20, -103, -166,  415, -348,  42,  336, -129, -174,  31,  456, -149,  310, -284,  215, -103,  435,  194,  273, -139,  151, -132, -195, -133,  371, -433, -31,  97,  410,  331,  182,  242,  80, -132,  157,  232,  410, -07, -44,  88, -124,  264,  439, -313, -167, -494,  436, -232, -447, -439,  481,  204, -71, -214, -77,  152, -146,  392, -251,  116, -425,  431, -141,  155,  152, -132,  240,  62, -286, -304,  03,  90, -188, -58,  277,  145,  301, -435, -235,  354, -374, -254,  410,  407,  385, -167,  59,  91,  77, -339, -293,  153, -408,  418,  160,  244, -213, -100,  159,  01,  448, -338, -409, -239,  456, -279, -242, -391,  138,  24,  463, -383,  270, -275, -476, -493,  58,  436,  98, -12, -403,  306, -359,  41, -424,  301,  138, -137,  54,  149, -284,  02, -337,  160, -385, -381, -267, -126, -271,  371, -250,  44, -160, -128,  270,  217, -120,  180,  153,  478, -332, -398, -364, -191,  143, -287, -37,  133,  428, -483, -218, -03,  371, -55,  09, -161,  417, -406, -435, -02, -183, -185, -458,  158,  187, -336, -125, -81,  345, -120, -102, -135, -18,  386, -473, -23, -49, -10, -389,  232,  359,  245,  81,  230, -309, -410, -431, -40, -316, -366,  458,  01,  301, -148,  11, -11,  17,  386, -240,  214, -234, -490, -421, -400,  397, -394,  78,  200,  448, -459, -68,  307,  286, -487,  38, -171, -45,  459,  289,  491, -406, -401,  345, -253, -48, -144, -412, -179,  95, -151, -113,  361, -141, -34, -186,  108,  425,  392, -191,  373, -215, -407,  181, -429, -41,  71, -99,  414,  30,  42, -242,  476,  494, -397, -276,  298,  311, -188, -381, -94, -487,  06,  120, -127, -176,  434,  481, -251, -322, -210, -25, -37, -116, -344,  34, -305, -421, -213, -391,  109, -318,  219,  438, -324,  322, -338,  474,  134,  326, -55, -460,  340, -197,  160,  65,  127,  446,  46, -271, -376, -311, -444,  87,  425, -288, -378, -380, -209,  261,  81, -248,  443, -199, -310, -29, -25,  204,  297, -39,  383, -258,  02,  223,  397,  14,  140,  377,  313, -314, -42,  437,  227,  14,  25, -496, -422,  499, -376,  221, -388, -442,  473, -92,  211,  16,  379, -314,  72,  177,  148, -45, -229,  02,  30,  21, -132, -330, -102, -319,  209,  356, -29, -64, -130,  496,  293, -52, -153,  417, -331, -41, -173, -06,  367, -462, -490,  247,  77,  83,  276,  77, -110, -101, -421,  421,  420,  299, -409, -182, -167, -348,  26,  304,  441,  396,  300,  234,  196, -01, -497,  365,  458, -169, -140,  326,  221,  222,  425, -202,  157, -447,  375, -452,  304, -194,  469, -423, -394, -88,  247, -61,  417, -226, -257,  358,  22, -105,  92, -281,  394,  95, -416,  352,  426,  296, -470,  148,  371, -193,  446,  380,  212, -326,  428,  17, -20, -251,  446,  86, -486,  193, -123,  431,  467,  120,  289, -10, -133, -119,  209, -239,  476, -355, -34, -245, -206,  348, -245,  17,  08, -299, -103, -280,  227,  178, -411, -292, -221, -113, -354, -207, -419,  24,  76, -100, -04,  217,  390,  364, -402,  451, -23, -73, -51, -205, -466, -405, -04, -211,  464, -496,  342,  213,  76,  70, -109, -482, -370,  171, -95, -224, -184, -14, -348, -255,  387,  149,  462, -371,  365, -87, -67,  194, -308, -266,  490, -274, -171,  338,  15,  145,  342, -143, -142,  270,  427, -398,  288, -91, -375, -306,  186, -59, -468,  338, -462, -229,  339, -499,  253, -444,  266, -314,  251,  458, -80, -407, -316, -399, -217,  199,  246, -375, -92, -44,  395,  188,  58, -464, -403,  183,  82,  283, -23,  114,  474,  15, -262, -335,  368,  491, -278,  134, -323, -175,  92,  449,  270, -372, -98, -447,  327,  00,  30,  88,  456,  277, -224,  15,  313, -127,  50, -105,  09, -473, -138,  335,  43,  100, -500,  263,  91,  74, -102, -380, -249, -158, -431, -479, -29,  323, -74,  150, -177,  456, -262, -221,  234,  366, -354,  399,  92,  197, -205, -47, -424, -491, -212,  119,  109,  140,  235,  52,  67, -367,  172,  318,  327, -407, -308, -202, -232,  118, -199,  91,  427,  391,  370, -487,  258, -131,  412, -150, -82,  59,  303, -06,  68, -57, -34,  29, -65, -299, -419, -498,  186, -395, -327,  13,  50, -135, -336,  318, -165, -35, -91, -238,  208,  132,  127, -34, -147,  40, -332,  271, -49, -177, -235, -128,  266,  231,  401,  54,  432, -165,  56,  470,  292,  229, -16, -157, -54, -500,  13,  282,  317, -225, -104,  25, -241, -476, -156,  112,  416,  12, -117, -133,  336, -500, -409,  454,  232,  493,  08, -484,  180, -435,  487, -28, -354,  323, -333,  93, -325, -467, -125,  492, -192,  271,  369,  67,  295, -287, -321, -437,  226,  414, -69,  62,  414,  22,  368,  498,  367, -123, -485,  399,  294, -146, -128, -208, -323,  391,  385, -148,  424,  112,  196, -268,  236,  65,  299,  383,  279, -170,  447,  357, -256, -122,  271,  11, -248,  139,  09, -28, -132,  24, -129, -338, -270, -405, -45,  259,  487,  192, -37, -237, -195, -341, -04, -459, -423,  147,  424,  356, -170,  371, -435,  426,  101,  336, -63, -294, -25,  447,  178,  344,  323, -451, -142, -446, -03, -335,  313, -16,  358, -223,  247,  15,  288,  95,  408,  365,  95, -316, -427,  425, -444, -362,  351, -491, -174,  141,  67,  302,  88, -255,  498,  263,  147,  208,  317, -356, -274,  483,  480, -64,  112, -421,  451, -100,  175,  359,  118,  122, -457, -457,  47, -49,  34,  250,  313,  360, -109, -120, -486, -169,  478, -136, -405,  477, -427, -236, -27, -201, -253,  305,  235, -289,  384, -462,  464,  411, -251,  82,  33,  144,  125, -68, -52,  11,  35, -239, -128,  426,  493, -114,  110, -177,  251,  205,  152, -324,  469, -23, -25,  69, -218,  62,  280,  19,  100,  244, -70, -299,  178, -184,  345,  156,  248, -207, -333, -217,  406,  39,  62, -248, -222, -328,  427, -471, -271,  80, -295, -302, -443, -468, -381, -160,  94,  400,  359,  46,  496,  141,  247,  175,  457,  444,  183, -442, -262,  350,  193, -04,  242, -245,  248, -480,  279,  176, -451, -492, -244,  106, -293,  165,  138, -174, -143,  84,  78,  68, -370,  427, -290, -271,  454,  19, -327,  137,  77,  263,  339, -229, -240,  81,  378, -492,  453,  158,  184, -146,  166, -208,  460, -275,  458,  450,  404,  167,  34,  334, -264, -484,  261,  298, -255,  215, -183,  271, -148, -253,  34,  44,  370,  294, -23,  248, -345, -69, -94, -309,  285, -75, -16, -402,  150,  294, -452,  406,  313,  83,  241, -451,  99,  02,  347, -303, -282,  17,  468,  422,  264,  02, -34,  134,  149,  444, -118,  304,  227, -359,  495,  364,  418,  331,  462,  68,  477, -489,  327,  291,  446,  68, -308,  45, -430, -460,  242,  140,  409, -438,  415,  173,  417,  233,  159,  66, -471, -107,  222,  256,  34, -431,  121, -48, -247,  435, -127, -270,  446, -300, -127, -256,  268,  66,  290, -310,  458,  384, -317,  367,  447, -402,  40, -284,  331,  51,  282, -287,  444,  356,  469, -21,  425,  442, -217, -322,  378, -492,  261, -324,  60, -366, -79, -172, -448,  63,  371, -490,  299, -446, -271, -402,  04, -379, -186,  187,  172, -404,  400,  117,  452, -278, -52, -270,  16, -417,  260, -106, -408,  21,  423,  152, -492, -156, -167, -88, -241,  56,  275, -442,  462, -496, -343, -34, -374, -29,  05,  298,  420, -94, -85, -276,  480, -285, -46, -04, -201,  67, -257,  243, -60, -334,  247,  300,  362, -420, -287, -27,  136,  488,  31,  98,  492, -460, -84, -382,  364,  422, -231,  284,  180, -464, -140,  160, -248, -333,  08,  403,  234,  251,  146, -326, -231, -107,  475, -17,  326,  40,  456,  314,  28,  340,  265,  372,  380, -319, -157, -404, -45,  112,  380, -365,  148,  93, -353, -248,  260,  156, -345, -06,  259, -347, -480, -471,  399, -153,  364, -423,  387,  321,  391, -85, -487, -492,  140, -255, -310,  483, -158,  145,  95,  74, -367, -257, -333, -220,  348,  427,  436, -497,  273,  196,  09,  294, -423,  260, -359,  441,  337, -119, -386,  228,  296, -373,  237,  288, -127, -221,  271, -433, -224, -134,  141, -91,  462,  309, -458,  310,  236, -170, -335,  10, -122, -474,  156, -45,  286, -351,  249,  123,  30,  363,  204,  179, -157,  293, -33, -432, -76, -261, -365,  200,  105,  276, -38,  419,  85,  356,  229,  174, -314, -253, -316,  65, -227, -308, -128, -440, -159, -27, -465,  372,  189,  239,  51, -468,  384, -482, -48, -192,  109,  87, -139,  67,  215,  323, -14,  153,  179,  68, -173, -283,  315,  363, -366, -60, -445,  07,  352, -104,  480,  388, -232,  169,  479, -329, -447,  364,  42,  357,  24, -349, -56,  385,  218,  12, -440,  57, -335, -409, -375, -08, -191,  440, -145, -57,  232, -90, -198,  85, -342, -217,  325,  279, -196,  304,  450,  210, -480,  344,  67,  397,  496, -136,  282, -434,  376, -305,  123, -107, -214, -400,  385,  95, -108,  92, -109, -375, -498,  193,  210,  12, -172,  35, -209,  485,  191, -258,  195, -436, -62,  114,  461,  286, -170,  243,  353, -294,  438,  328,  99,  77,  429,  336,  24, -179, -72,  415,  298,  282,  461,  08, -205, -211, -105,  86,  126, -413, -320,  173, -349,  119, -212, -388, -95,  118, -293,  110, -323, -02,  291, -372, -73, -428,  465,  451, -107,  245,  367, -308,  28, -320, -448, -325,  321, -52, -387, -52,  387,  146, -379, -110,  117,  261,  354, -126,  232, -87, -163, -239, -237, -372, -111,  190, -300,  206,  142,  445,  304,  361, -11, -168, -459,  394,  359,  362,  194,  472, -190,  81,  470,  284, -177,  87,  45, -323,  462,  129,  442, -201,  390, -294,  279,  132,  396,  479,  190,  38, -224, -06, -101, -382, -322,  292, -488, -111,  155,  206,  214,  465,  139,  184, -399,  462, -228,  499, -361,  86,  128, -419, -263,  371,  139, -484,  355,  36, -153,  397, -74,  475, -108,  326, -407,  422,  470, -395, -188,  125,  311, -474,  443, -50, -438, -456,  264,  186, -457,  403, -228, -476, -163,  361, -253, -172, -271, -398,  364,  76, -149, -209,  404, -405, -31,  497, -482, -61, -397,  182, -435, -234, -440, -140, -431, -378, -96,  333,  309,  300, -411, -67,  324,  278, -205, -429, -394,  24,  25,  471, -47,  376,  114, -143, -176, -65,  206, -158,  374,  309, -124, -209, -72,  288,  151, -03,  410, -92, -170, -429, -292, -81,  05, -116, -303, -348,  307, -196, -472,  184,  127, -19,  412, -259, -310, -264, -472,  397,  430,  402, -442,  158,  46, -14, -54,  49, -165, -143, -191,  166, -72,  369, -415, -215, -247,  135, -63, -88, -209,  318, -404,  418,  151, -139,  11,  342,  449,  39, -409,  380,  293,  01,  38, -161, -160,  485, -259,  175,  194,  50, -159, -26, -80,  279, -388, -475, -86,  401, -62,  205,  219,  386,  475, -129,  99, -14,  65,  49, -123, -492, -71, -330,  09, -181,  362,  349,  156, -397,  25,  202, -495, -282, -323, -75,  497, -211,  303,  263,  42,  93,  320, -238,  331,  295,  485, -69,  133,  50,  480, -490,  58,  261,  33, -433, -68, -105, -231, -411,  350, -354, -357,  355, -136, -180,  133, -138,  461,  288, -23,  04, -119, -202, -382, -288, -407, -397,  495,  227,  153,  475, -411,  63, -412,  122,  130,  21, -131, -249,  462,  71, -103, -395,  279,  262,  278, -88, -24, -409,  52,  453,  447,  433, -249, -435, -03,  197, -332, -07,  276, -327,  320,  365,  236,  409,  340,  219,  282, -291,  470,  244, -367,  220, -299,  412, -18, -169, -176, -190, -77,  376, -237, -130, -339,  15, -64,  158, -288,  456, -349,  488, -18,  472, -295, -282, -267, -455, -211, -485,  107,  112, -389,  240, -168,  164, -496, -334,  496, -172, -24, -81,  56, -409,  289, -431,  106,  77, -421, -330,  386,  83,  10, -132,  55, -432,  438, -360, -35, -272,  07, -76, -308,  118,  16,  376, -218,  20, -458,  130,  348,  370, -451,  256,  461, -309, -323,  420, -380, -243, -58, -494,  340,  453, -126,  247, -127, -187,  387,  338,  393, -106, -237, -415, -136,  279,  461,  498, -200, -145,  129,  00, -275, -470,  109,  38,  73,  286, -42,  194, -105,  401, -448, -265, -294, -73, -166,  79, -408, -279, -83, -163,  467, -468, -78,  183,  312,  235,  182, -36, -58,  163,  464, -481, -455,  73,  57,  119,  212, -132,  165, -393, -231,  217,  195,  327, -04, -471, -94,  88,  103, -325, -223,  70, -292,  199,  106, -128,  286, -212,  336,  80, -197, -348,  99, -152, -422,  09, -181,  290, -271,  484, -251,  350, -446,  444,  177,  50, -174, -65, -09,  429,  462,  268,  351,  22,  320, -43,  394,  458, -403, -418,  39,  252, -265, -10, -399, -187, -149,  272, -45,  80,  257, -444, -70, -337, -147, -41,  213,  179,  394,  56,  108,  357,  177,  311,  231, -03, -231,  126,  307,  218, -440, -154, -29, -205, -311,  424,  460,  392,  196,  267, -27,  305,  324, -245,  468, -323,  215, -466,  356,  461,  442,  316, -330,  119,  127,  402, -32, -252,  380, -224,  467,  440,  474,  290,  88,  15,  214,  400, -92,  262, -480,  381,  68,  344, -12,  388, -127,  55,  422,  81,  369,  365,  249, -461,  336, -124, -207, -195,  477, -327,  81, -204, -34,  407, -414, -94, -77, -348, -194,  331, -234,  178, -436,  334,  22,  52, -425, -253, -392, -151,  328,  477,  66,  429, -132, -97, -194, -486,  208,  135,  39,  141,  431, -495,  400, -131,  263, -177,  373, -78, -346, -361, -400,  70, -174,  475, -377, -99, -278,  83, -398, -97,  412,  169, -168,  132, -428,  490,  146, -368,  125, -314, -375,  408,  43, -475, -223, -193, -151,  02,  229,  355,  494,  329, -74,  172,  304,  401, -427, -121,  336,  27,  282,  248, -304, -34,  232, -232, -43, -121, -100, -66,  417,  377, -157, -40,  403,  472,  267,  104, -25,  348, -41,  321,  178, -263, -07,  334, -362,  418,  65,  474, -55,  199, -426,  142, -334,  307,  410,  475,  38,  163, -91, -45,  392,  252,  415,  295,  225,  183, -101,  52,  383,  359, -127,  413, -52, -282, -400,  87, -364,  165,  61,  81, -135,  488, -277,  383,  295, -14,  358, -167,  01, -233,  288, -107, -128,  203,  41, -51,  238,  440, -499,  122, -349,  226,  35,  100,  444,  487,  39, -68,  153, -400, -487, -130, -412,  89, -247, -265, -425, -389,  68,  428,  230,  208,  173, -398,  264, -286,  51,  354,  07,  404,  328, -490,  482,  216,  462, -222,  203,  01,  210, -144,  454,  224,  226, -106, -187, -169,  130,  240, -58,  50, -480,  25,  111,  193,  127, -125, -240, -321, -271,  267, -65, -442, -371, -82,  274, -408,  196, -23,  93, -93, -314,  47, -17, -236,  442, -352,  96,  424,  388, -462,  326, -240,  63, -63,  453,  43,  312,  65, -426, -106,  184,  09,  304,  314, -221,  78,  406,  476, -93,  351,  235,  445, -101, -282, -290,  193, -134,  306,  469,  106, -304,  295, -282, -388, -267, -329,  155, -103, -411,  229, -357,  273,  90,  447,  87,  370,  377,  345, -302, -215,  197,  433,  82, -52,  03,  292, -07, -279,  98, -38, -321,  295,  109, -103,  407, -306,  420,  62,  92, -491,  143, -413, -365,  85, -465, -426, -45,  412,  420, -495,  49,  469, -210, -368,  269,  293,  424,  114, -134,  375, -72,  397,  170, -463,  146,  429, -268,  67,  343, -324,  428, -14, -237, -85, -429,  150, -10,  379,  63,  262,  384, -388, -417, -325,  96,  352, -180,  373, -34, -461,  248,  394,  436, -82, -217,  435,  199,  367,  02,  42, -105,  282, -120, -489, -302,  303,  161, -460,  182,  76,  302,  419,  189, -263, -54,  137, -411, -382,  10,  407, -343, -242, -347, -54, -472, -64, -119,  227,  156, -265,  121, -449, -131, -499, -438,  67,  305, -424,  459,  339,  152, -387, -390,  193, -150,  56, -169,  291, -473, -307,  198, -316, -48, -297,  482,  332,  492,  215,  412,  148, -198,  33, -449,  172,  387, -34,  91, -456,  42,  51,  383, -306,  164,  494,  388, -133,  402,  71, -342,  429,  264, -291, -34,  68, -88,  300, -99,  256,  368, -187,  256, -330, -302,  308, -306, -415, -226,  286, -371, -332,  189, -135,  214,  205,  211,  454, -428,  465,  25, -269,  395,  142, -60,  213, -290, -296,  13,  463,  461, -119,  128, -431,  404,  327,  377, -402, -236,  03, -264,  246, -477,  425, -389,  238,  131,  322,  192,  203,  287,  70, -214, -466, -288,  226,  247, -78, -217,  113, -114,  96, -154, -486,  165,  102, -307,  395,  201, -42, -102,  437, -296, -78, -285, -185,  12,  346, -11, -296,  401,  128,  274, -312, -485,  486, -234, -386,  261,  49,  227, -01, -355, -74,  13, -337, -472,  207, -442, -419,  17, -44, -129,  221, -270,  86, -112, -406,  284, -271, -201,  185, -291, -75, -275, -276,  264, -08, -161,  25, -107, -82, -476,  391,  344,  389, -446, -275,  448, -388,  158, -35,  420, -471,  38,  03,  467, -222,  97,  251,  359,  396,  289, -431,  174, -486, -207, -62,  358,  484,  463, -248, -97, -161, -357,  99, -272,  49, -324, -323,  161,  335,  142,  433, -284,  33, -64, -316,  311, -466, -213, -477, -218, -424, -408,  456, -409,  237, -106, -199,  222, -143,  53, -23,  196, -452, -424, -223,  97, -247, -46,  110, -60, -52,  44,  156,  481,  480, -308, -355, -134, -20, -332,  149,  408,  112,  105, -149, -151, -500,  153, -77,  209,  58,  400,  258,  107, -171, -465,  56,  82, -11,  19, -126, -211, -437, -118, -229, -105,  427,  268,  262,  259, -212, -89,  167,  400, -132, -481,  101,  220, -476, -475, -70,  82, -223, -312,  41,  106,  75, -50,  40, -84,  469,  414,  205, -468,  149, -172,  279,  76, -404,  393, -165, -116, -196, -498,  136, -475, -127,  90,  245,  249,  115, -325,  184, -256,  215, -275,  351,  142,  175,  243, -442,  496,  158,  264, -120, -193, -408, -340, -265,  41, -447,  70, -223,  210,  424, -234,  235, -202,  356, -20, -101,  323, -492, -417, -433, -425, -191,  418,  218, -164, -486,  276, -167,  172,  392, -435, -169, -163, -275,  66, -270,  131, -12,  07, -159, -88,  273, -72, -438,  481,  408, -38,  304, -232,  45,  372, -156, -294, -358, -86,  43, -344,  42, -272, -320, -65, -207,  363, -376,  371,  281, -146,  02, -231, -287,  343,  182, -161, -229,  244, -180,  31, -294, -375, -348, -396, -151, -04, -190, -09,  410, -295,  148, -48, -67, -320, -261, -421, -456, -137, -198,  325, -431,  304, -405, -217,  499, -371,  474,  122,  373, -206,  05, -68,  271,  157,  36, -380, -347, -302,  112, -85, -96,  112, -280, -311,  292,  311, -232,  336,  27,  422,  162,  96,  226, -391, -269, -423, -262, -295,  199, -37,  352, -295, -253,  123,  362, -365, -404, -132, -166, -440, -365,  238,  172,  207,  427,  316,  19,  48, -495, -454,  322, -481,  494,  49, -372,  78,  478, -134,  283,  178, -319,  487, -265, -71,  463, -51,  64, -441,  317,  398, -29, -195,  488, -05, -488, -232, -189,  31, -332,  168,  429,  490,  187, -224,  391,  315,  354,  370,  33,  489,  48,  215,  477, -365, -04,  440,  84, -440, -149, -98, -189, -326,  207,  151,  169, -429,  419, -168,  103, -413, -499,  384, -70,  188, -340, -179,  356, -486, -309,  241, -144,  239, -44, -167,  374, -196,  125,  311, -135, -172, -287, -472,  02, -228,  179, -329, -157,  99,  03, -202, -462,  356,  35, -32,  45,  195,  290,  253, -438,  481, -06, -82, -427, -197, -397, -201,  107, -420, -390, -176, -92,  175, -148, -238, -201, -468, -67,  143,  483, -212, -207, -127, -355,  328, -306, -458,  376,  484,  295, -210, -183,  141, -440,  242,  444, -337, -106,  52,  95,  356,  376, -497,  384,  81, -235, -317,  465, -450, -322,  448,  190, -28,  173, -313, -200,  367,  81,  28, -297,  228,  318,  373, -130,  378,  115, -186, -107, -139, -282,  488,  70, -53, -157, -46, -472,  460,  489,  493, -138, -332, -207, -95,  140,  466,  92, -208, -314,  26,  321, -111, -246,  491, -238,  476, -278, -270,  143,  467,  443,  361,  456,  13, -192,  151, -181,  188,  112, -191, -467, -174, -23,  178,  231, -383,  497,  176,  261, -317, -298,  434,  72,  308,  426, -313,  285, -352,  269, -72, -385,  212,  141, -77, -274, -198, -73,  45, -158, -109, -294, -124,  217,  183, -446,  301, -348, -449, -23,  414,  86, -469,  348,  11, -309, -374,  198,  476,  126,  319,  256, -406,  31,  250,  17, -391, -448, -204, -493, -106,  187, -287, -378, -95,  397, -323,  58, -451,  80, -465, -185, -333, -82,  16,  178,  109,  142,  228,  438, -231,  47, -454, -137, -70,  296, -268,  40,  348,  381,  399,  95,  68, -388,  217, -175, -139, -254,  383,  263, -321, -230, -422,  198,  188,  94, -124,  150,  89, -44,  88, -290, -145,  134,  425,  285, -69,  09,  177,  131, -110,  76,  78,  459,  189,  148,  136, -98,  394,  20, -335, -75, -358, -256, -377,  331, -310,  351, -19, -369, -193, -79, -159, -486, -445, -234, -348,  338,  276,  329,  322, -334, -94, -100, -23, -53, -452, -386,  349, -205,  486, -485,  220, -372,  111,  344, -189, -347,  195, -356, -215, -145,  65,  478,  221,  473, -255,  373,  311, -127,  203,  133,  391, -39, -114, -131,  408, -66,  335, -391, -419,  321, -376,  302, -199, -413,  498,  113, -259, -455,  257,  378,  252, -177,  356, -26, -204, -47, -153, -41,  326, -98, -55,  218,  363,  331, -61, -377,  117, -226, -267,  199, -53, -143,  01,  248,  297, -01,  213, -110,  396, -29, -232,  149, -354, -24, -377,  294,  430,  322,  105,  256, -275, -450,  326, -412,  381, -235, -288,  351,  39, -55,  50, -162, -346, -97, -413,  451,  402, -348, -159, -350,  123,  461,  299, -379, -62,  422,  415, -132,  245,  21, -24, -178,  423, -197,  262, -343,  420, -174, -492, -40, -377,  58, -350, -222,  461,  89,  81, -285,  242, -225, -135, -135,  88, -335,  339, -474, -61, -394,  246,  36,  479,  75,  358,  403,  378,  473, -440,  298, -201, -432,  110, -77,  478, -387, -447,  439,  202,  134,  06, -56, -239,  371, -338,  350, -112, -499, -272,  328, -393, -173,  216, -413,  402,  75, -158, -368,  48, -98,  430, -301,  322,  393,  122,  300, -494,  175, -409, -440,  162,  97,  05,  423,  320, -481, -375, -291, -128,  206, -111, -21, -467, -395,  418,  435, -468,  112, -433,  432, -486, -151, -368, -312,  94,  254,  488,  452,  282, -421, -487, -56, -472,  370,  219,  349,  389,  345, -442, -239,  51, -53, -408,  84,  404, -137,  371,  437,  475, -210,  369, -158,  491, -147,  30,  86, -40,  19,  38, -258,  450,  403,  186,  479,  273, -95,  328,  162,  102, -262, -225,  05,  185, -132, -59,  441, -417, -188,  378, -442,  454, -400, -100,  446, -47, -217,  32,  413, -346, -78,  07, -44,  178, -307, -65, -49,  451,  115, -34,  405,  353,  241, -89,  390, -39,  352,  332,  44,  17, -438,  455, -29, -338,  207,  269,  468,  490, -199, -267, -356, -424,  241,  101,  254, -214, -112,  57, -263, -144, -477, -05,  61, -383,  406, -48,  78, -390,  136, -25,  127, -450, -70, -49, -287, -363, -280,  33, -372,  374,  266,  124, -198,  07,  77, -92,  294, -182,  465, -117,  174, -159,  378, -265,  310,  284, -461,  240, -253, -473, -285,  374, -422,  497,  177,  143, -365,  398, -324,  115, -376,  442,  91, -74,  302, -331,  334,  96, -13, -349,  479,  13, -08, -290,  248, -198, -154, -360, -457,  93, -333,  110,  320,  97,  108, -03, -260,  243,  247,  268,  210,  371, -437, -199,  149,  365,  322,  335,  313,  161, -161, -356, -326,  331, -146,  423, -14,  201, -85,  381, -206,  82,  343, -386, -320, -49,  464,  272,  46,  211,  41, -244,  435,  104,  410,  436,  321,  232, -376,  134, -106, -37,  278,  420,  146, -15, -305, -16, -314,  110, -135,  332, -307, -291,  447,  225, -488, -237, -03,  411,  474, -110,  19, -239, -154, -71, -302, -333,  14,  174, -347, -240, -363,  432, -320,  283, -83, -124, -232,  455,  486,  485,  287,  31,  46, -414, -244,  59, -151, -394, -30,  176,  348, -159,  437, -305,  271, -13, -138,  137, -339,  16,  397, -202,  300, -71, -66,  69,  305,  202,  376, -356,  187,  163,  175, -266, -398, -216, -355, -49,  242,  467, -373,  90, -192, -83,  285, -69, -244,  00, -432, -82, -132,  465, -432,  20, -105,  02, -411,  52,  56, -183,  196, -256,  480,  224,  330, -418, -492,  475,  386, -398, -206, -135,  192,  102,  282,  330, -466, -461,  182, -398,  309, -450, -80,  377,  422, -333,  232, -137,  219, -212,  180,  268,  32,  160, -08,  214, -405,  352,  189, -167,  454, -165,  198,  498,  438,  333, -320,  472,  372, -286, -74, -467, -236,  346, -238,  38, -487,  494,  401, -415, -217,  81,  353, -333,  94,  197,  382,  189,  49,  423, -126,  355,  111, -428, -295,  49,  405, -114,  373, -371,  100, -201,  14, -283, -02,  277,  255,  363,  271,  157,  448, -94, -262, -347,  74,  332,  350,  308,  373,  251, -417, -253,  106,  194,  172,  312,  95,  429,  50, -32, -89,  02,  268,  425,  219, -234,  202,  327, -371,  326,  336, -70, -268, -426,  83, -342, -241,  286, -182, -16,  37,  254, -416, -04, -52, -392, -192, -104, -463, -290,  364, -52,  212,  484,  226, -68,  102, -72,  111, -416, -246, -53,  14,  339,  373, -51,  497, -16,  87, -184,  469, -375, -430, -95,  473,  370,  13,  133, -234,  402,  343, -17, -149,  55, -33, -71, -161, -78, -291, -198,  06,  316,  249, -128,  155,  123,  321, -496, -41, -91, -180, -72,  386,  242, -315, -289,  113,  198,  344, -269,  101,  187, -434, -196,  94,  386, -415, -214, -192, -206,  88,  314, -390,  190, -314, -383, -187, -141, -378,  272, -380,  294,  53, -142,  37, -410,  69,  02,  289,  265, -415,  242, -48, -348, -102, -101, -462, -17, -463,  198,  277,  125,  12, -260, -185, -450,  209,  480,  261,  331, -395,  382,  126, -490,  92,  15, -400, -338, -483, -259,  427, -398,  483,  232,  106,  233, -17,  144, -284,  20,  194, -154, -355,  58,  86,  313,  108, -205,  293,  222, -21, -250,  104, -43, -240, -304,  472,  213,  210,  489,  454,  138, -57, -210,  222, -450, -477, -295, -454,  92,  225,  241,  438, -278, -201,  376, -465, -240,  23, -319,  482, -146, -69,  438,  311, -456, -366,  283,  257, -303,  272, -437,  335,  68, -147,  409,  118,  229, -34,  164,  173, -309,  257,  111,  265, -443,  339, -347, -183,  214, -166,  151, -431, -383,  89,  380,  13, -425, -484, -230, -228, -360,  186, -41,  208, -461, -132, -174, -380,  334, -157,  293, -123, -400,  256, -05, -343,  447,  148,  326,  162, -166,  329,  231, -49, -82,  463,  465,  346,  479,  87, -382, -380, -227,  430,  328,  165, -202,  07, -363, -15,  350,  431, -286, -198, -461,  209,  312,  487, -143,  490,  149,  191,  320,  232, -05,  90,  195,  312, -64, -473,  251,  407, -353, -123,  337, -173, -106, -13,  334,  31,  472, -464,  314,  39, -161,  354, -252, -349,  341,  458, -359,  342, -499, -187,  74,  348,  404,  121,  160, -160,  148,  264,  99, -353, -359, -64,  327,  35,  424, -487, -434, -252, -450,  381, -361,  241, -413,  240, -256,  428,  198, -115,  270, -449,  199,  196,  400,  455, -183,  412,  147, -182,  176, -253, -35,  317, -465,  144,  204,  459,  158,  271,  60, -440, -496,  199,  301, -409, -61, -455, -129, -11,  282, -07,  41,  333, -311, -59, -360,  358, -147,  288, -324, -470, -113,  494, -301, -78,  138,  404, -118,  148, -473, -206,  208, -469,  493,  361, -26,  285, -242, -303, -226, -459,  190,  315, -274,  379,  108, -133, -411, -186,  07, -234,  196,  394,  112,  395, -184, -250, -349, -450,  399, -322, -156,  459,  61,  190,  321, -113, -25, -421,  84, -399, -28, -226, -231,  199,  05, -271, -82,  95,  43, -223, -287, -261, -329,  325, -13,  339, -73,  490,  390,  178, -331,  86,  138, -418, -224, -41, -30, -397,  38, -446, -295, -137,  181,  326, -438, -314, -445,  332, -367,  99, -391,  198, -310,  132,  23, -471, -29, -197, -480, -139,  481,  41, -200,  119,  123,  76, -70, -407, -468, -179, -352,  89,  184, -319, -85, -402,  219, -30, -218,  353, -79,  243,  51,  112, -125, -73,  141,  346, -418, -487,  60, -437,  54, -288, -465, -322,  288,  317, -229, -328, -362,  271,  261, -326, -196,  28, -228, -476,  499,  54,  377, -80,  149,  280, -116, -476,  59, -122, -277,  493, -109, -365, -443,  446, -153, -56, -24, -13, -239, -401,  160,  252, -277,  273,  426,  27, -198,  51,  51,  153, -43,  280, -427, -393,  413,  310, -369, -28, -312,  206,  318,  431,  341,  375, -271, -312,  171,  205,  176, -216,  305, -164, -464, -120, -39, -185,  407,  263,  366,  311, -84,  175,  91,  342,  282,  04, -496, -234, -171, -308,  472, -353, -377,  314, -126, -147, -498, -455, -90, -470,  181,  67, -134,  218,  447,  328, -115, -293,  443,  103, -482,  212, -222,  109,  406, -87, -34,  410,  179,  295, -398, -497, -206,  77, -331,  168, -218,  24, -435,  193,  54,  246,  112, -227,  316,  60, -47, -299, -381, -104, -344, -363, -40, -65,  246, -134,  348, -288, -224,  379, -141,  230, -266,  153, -192,  256,  173,  442, -220, -410,  487, -314, -311,  100,  311, -495,  12, -236,  59,  131, -487,  215,  268, -27,  02,  366, -308,  202, -69, -32,  433,  290, -301, -332,  296,  359, -224,  321,  301,  408,  412,  289, -406, -47,  241, -242, -42,  105,  22, -131, -264,  387, -415, -144,  213,  439, -278,  405,  142,  153, -127,  75,  296,  424, -405,  444,  283, -129,  265,  437, -221, -471, -422,  226, -18, -329,  484, -207,  276,  358, -486, -488, -402, -49, -132,  311, -109,  442,  216, -467,  96, -59,  460,  244,  218, -92,  188,  353,  279,  305,  290, -89, -313, -280, -11,  169, -109,  325, -186,  19,  183, -171,  31, -367,  280, -249,  444,  23,  46, -488,  408, -358, -46,  369, -262, -328, -223,  426, -475, -92, -417, -332, -329, -230,  240,  160,  440, -16,  337,  106, -497,  373, -213,  387, -494, -80, -10,  451,  443, -464,  463,  352,  30,  269, -427,  268,  441, -150, -454, -181, -390, -370,  339, -218, -100,  431,  442,  192, -85, -368, -201,  271, -495,  438,  158, -489, -142, -352,  462,  154,  37, -222,  06, -433, -453,  431,  336, -159, -219,  382, -488, -109, -488, -297, -475, -87, -366,  468, -395,  402, -48,  256,  173, -43,  195,  183, -32, -95, -317,  283, -441,  220, -439,  417,  288, -392,  348,  124,  301, -371,  358,  313,  373,  371, -484,  398,  136,  03, -282, -407, -95,  170,  350, -422, -21,  397, -387,  448, -198, -204,  231, -138, -483, -356, -221,  305,  104, -372,  281, -94,  109,  139, -281,  334,  362,  88, -415,  350, -409,  155,  444, -04,  178,  294,  426, -343,  191, -461, -395, -155, -165, -312,  207,  204, -168, -161,  09,  437,  319,  142,  195, -72,  134,  414,  115, -04,  354,  200, -153,  445,  207, -209,  293, -115, -63, -429,  43, -20, -38, -500,  325, -350, -311,  385,  354,  373, -276,  216, -338, -457,  210,  357,  323, -156, -376,  290,  341, -170,  342,  40, -224,  50, -317, -79,  435,  472,  345,  330, -48, -193,  331,  129,  309, -128,  366, -484,  97, -58,  232,  260, -15, -58,  469,  161,  287, -55, -49,  480,  276,  146,  372, -96, -304, -445, -323, -17, -473, -478, -186,  331,  182, -355,  312, -09,  369,  179,  07, -34, -379,  91,  78,  459, -114,  400,  472,  25, -155,  275,  05, -27, -79, -123,  377,  117,  284, -445, -399, -337, -71,  267,  494, -389,  412, -342,  455, -367,  337,  314,  99, -189, -94, -322,  122,  292, -70,  94, -183,  275,  221, -326,  101, -357,  403, -22, -388,  187,  385,  65,  350,  167, -168, -304, -370,  96, -146, -415,  229,  44,  400, -171,  355, -194,  359,  329, -50, -211,  275, -381, -84, -04, -207, -483,  139, -304,  348,  252, -265, -415, -183, -415,  252, -498,  133,  383,  98,  487, -180, -172,  31, -280, -491,  238,  378, -280,  419,  180,  361,  194,  299, -223, -309, -56,  147,  330,  492, -05,  434, -273,  432,  104,  164,  185,  106, -203,  420,  56,  137, -260, -264,  20,  313, -255,  111,  191,  317,  30,  224,  178, -275,  23, -192,  268,  468, -193,  450,  460,  302,  385,  40, -414,  341, -296,  271,  299,  354,  191, -145, -09, -216,  92, -489, -403, -311,  122, -360, -493,  05,  364, -463,  230, -112,  197, -02,  208, -496, -52, -480, -342,  185,  60, -255,  26, -383, -484,  177,  471, -440, -467,  314,  196,  477,  325,  293, -334,  300,  433,  25,  157,  298,  415,  239,  38,  112,  89,  98,  117, -111,  118,  275, -425, -321, -128,  453, -204, -111,  131,  119,  301, -484, -67, -03,  493,  110,  142,  11,  262,  427, -463, -81,  225,  452, -342,  115,  64,  247, -287,  33, -363,  332,  161,  64, -137, -467,  369, -489,  274,  00,  130,  75,  368, -437, -76,  361,  173, -82,  225,  288, -154,  262, -293, -77, -434,  218, -461,  482,  317,  104,  16,  454, -64, -323,  370, -349, -290,  240, -338,  485,  92,  292,  412, -39, -293,  189,  174, -267, -393, -101, -479, -47,  13,  80, -271,  79, -202, -232,  414, -384,  372, -70, -78,  161,  459,  145,  312,  21, -115,  475,  06, -171, -381,  271,  290,  179, -40,  317,  412,  419,  68, -215,  225, -418,  365,  454, -487,  16, -278,  427,  484, -54,  209,  258, -393, -480, -97, -228,  42, -360,  99, -100, -30,  218, -329,  112,  249,  483, -71,  161,  403, -150, -202,  128, -68, -336,  82,  297, -468, -344, -423, -484,  454, -362,  274, -438, -341, -322,  186,  201, -182, -215, -399, -360, -145,  125,  253, -395,  108,  34,  266,  11,  384, -435, -09,  168,  81, -75, -34,  113,  433,  395,  129,  388, -467,  255, -198,  44, -215,  488, -255,  456, -227,  199, -404,  128,  176, -299,  233, -216,  236,  352, -352,  120, -231,  491, -211, -298, -83, -393, -333,  202, -498, -352,  90, -113,  403,  392,  432, -311, -268, -323, -355,  05, -272,  93, -14,  404,  295,  71,  41,  31,  275,  189,  03, -104, -468, -356,  98,  301, -249,  265,  04, -247,  413, -406,  141,  317, -161,  425, -142,  423, -398,  355,  281,  183,  300, -233,  439,  95, -310, -20, -22,  466,  21, -166, -138,  406, -22,  461,  207,  230, -422, -289, -165,  492,  158, -172, -339, -151, -247,  371, -228,  208, -422, -447,  243,  378,  172,  182,  326,  363,  15, -196,  329, -112,  138,  43, -206, -31,  356, -498, -301,  435, -287,  386, -221,  371, -285,  292,  72,  320,  163,  345,  28,  241,  398,  123,  119,  423, -194, -55,  286,  321, -398,  115,  61, -408,  10,  356,  61, -133,  358, -388, -198, -77,  499,  81,  147,  66,  225, -281, -114, -112, -436, -233, -19, -185,  390, -48, -262,  48,  398, -124, -131, -148, -157,  431, -56,  353, -361, -142, -280,  497, -30,  22, -80, -31, -45, -433, -465, -320, -213,  274,  420,  203, -459, -99, -130, -217,  354,  460,  332, -396, -164,  53,  308,  179,  336, -248,  33,  475,  462, -395,  472, -67,  480,  245, -246, -65, -336, -210,  468,  303, -84, -260,  07, -43,  142, -271, -408,  348, -310,  424, -196,  26, -22, -388,  58, -186,  216, -57, -210,  179,  48,  114, -388,  28,  211, -134, -184,  376, -492,  136,  179, -76,  376,  38, -267,  370, -380, -174, -430, -190,  102, -126, -312, -420, -14,  246,  247, -297,  41, -111, -266, -410, -145, -154,  118, -433, -436, -214, -205, -75,  422, -174,  349,  299, -283, -65, -479, -163, -387, -408,  147,  215, -34, -313, -352, -195, -214,  395,  360,  327,  136, -406,  417,  491,  292,  388, -90, -292, -326,  205,  133, -51, -468,  335,  100, -251, -230,  121,  86, -117, -435,  85, -50,  32,  272,  98, -311, -442,  345, -99, -262, -19,  347, -345, -27,  139, -105,  383, -301,  70,  441,  333, -129,  473,  168,  471,  74,  438,  92,  12,  173, -490, -51, -377,  394, -279, -426, -417,  132,  419, -16,  370, -99, -169, -123,  374, -178,  273, -391,  21,  195, -450,  206, -82, -125, -126, -111, -199,  164, -167,  313,  189, -157, -238, -335, -263,  336, -261,  172,  320, -342, -344, -458,  411,  339,  271, -363,  13,  44, -253, -465,  91,  149,  241, -139, -475, -32,  250, -174, -368, -416, -08, -326,  279, -394, -161, -483,  442,  78,  189, -386, -412, -302, -344, -500, -111,  428, -363,  403,  324,  236, -210,  268, -114, -117, -371,  263,  351,  380, -411, -164, -184,  433,  10, -405, -460, -299, -36,  482,  279,  06, -403, -281,  204,  105, -281, -407,  33,  209, -152, -142, -55,  138, -22, -317, -126,  107,  446, -275,  339, -112,  413, -345, -179,  275,  103, -139,  476, -81,  196, -393,  425, -355,  179,  481,  250,  398, -73,  136,  459,  275, -154, -95,  266,  324,  88, -360, -69,  387,  217, -229, -225,  483,  278,  96,  258, -119, -190, -413,  301, -494,  46, -422,  03, -275, -440, -247, -24, -13, -259, -65,  114,  87, -308, -120, -89, -367,  20,  343, -480,  90, -34,  147,  73, -256, -257,  183,  478,  405,  270, -369, -237,  169, -291,  266,  394, -231, -128,  222, -392,  113,  10,  223, -299,  202, -397,  464, -313,  476,  307,  59,  66,  125, -294, -09,  370,  302, -326, -300, -441, -203, -169, -177,  466,  40, -411, -288, -338, -39,  435, -230, -73, -55,  493,  480, -01, -51,  444,  187, -75, -396,  98, -157,  229, -343,  334,  451,  459, -140, -349, -130,  157, -18,  193,  475, -477,  283, -312,  37,  96, -377,  307, -125,  420,  301, -145, -81,  102, -200, -42, -473,  256, -91,  222, -15,  66,  408,  289,  377, -232,  440, -253, -222, -77,  441, -247,  298, -424,  293, -165, -476, -232, -06,  252, -312,  147, -393,  460, -251,  259,  270,  128,  367, -321, -150, -147, -403, -242, -358, -174,  379, -66,  74,  09, -291,  367,  262, -493, -205,  56,  194,  171,  324, -311, -77, -135,  336,  383,  177, -62,  494, -53, -434,  362,  479, -83, -285, -72, -473,  209,  255, -242, -357, -171,  267,  205,  48,  30, -436,  343, -62,  259,  14,  114, -200, -210, -169, -12, -327, -492,  426, -333,  308,  493, -471,  287,  262,  96,  67,  289,  157, -178, -452, -347, -497,  315,  358,  51,  197,  422, -106, -13, -467, -239, -46, -167,  51,  285, -326,  224, -354, -400, -257,  454, -55, -227, -407, -293, -279,  160,  497,  379,  483, -103, -468,  486,  64,  390,  390, -238,  312, -216, -399,  346,  397,  55,  31, -52,  193,  205,  24,  339, -342,  268, -355,  103, -107, -262,  311,  114, -250, -340, -07,  85,  409,  25,  424, -27,  267,  314, -413,  80, -50, -311,  278, -152, -404, -191, -352, -359, -133,  173, -168,  25,  293, -23, -20, -314, -433,  143, -348,  170, -345,  146, -245, -436,  23, -321,  38, -209,  493,  477, -277, -56,  18, -499,  292,  115,  162, -208, -392, -119,  465, -59,  406,  258, -230,  239, -204, -162, -118, -51, -492,  38, -53,  115,  102,  470,  295, -08,  113, -360, -30,  336,  436, -160, -311,  228,  455, -296, -127, -84,  85, -162,  357,  344, -51, -373,  83, -403,  317,  465,  398, -323,  355, -155,  293,  310,  168,  440, -198,  133, -420, -376, -30, -483, -35, -489, -403,  272, -285, -30, -312,  301, -339, -103,  145,  110,  377,  80, -441,  194,  397,  458, -276,  253,  155, -483,  415,  175, -191, -283, -191, -111,  194, -369,  258, -341, -358, -292, -217,  210,  178,  324,  11, -309, -279,  08, -347, -402, -60, -287, -355, -163,  23,  221, -58, -322, -410, -143, -294, -101,  427,  367, -360,  473, -150,  399, -368,  344, -393,  267,  54, -363,  91, -83, -171, -335, -223,  334,  115,  217, -453,  260, -93,  70,  333, -299, -399,  423,  411,  159, -178,  338,  26, -37,  311,  376,  214, -205,  220, -327, -86,  127, -190, -494, -456,  491,  23, -178,  326, -362, -109, -275, -249, -350, -352, -416, -148,  101, -492, -237, -240,  182, -47, -362, -355,  116, -134, -289, -237, -62, -116,  177, -435, -453, -465, -390, -462,  58,  284, -284, -451, -325,  294, -200, -174, -206,  236, -470,  395, -404, -207,  07,  279, -402,  145, -224,  214, -137, -12, -171,  301,  372, -494,  367,  419, -106, -171, -190, -196, -387,  378, -147,  140,  172, -495, -182,  466, -406, -152, -287, -310,  493,  220,  469, -409,  217, -254, -343, -420,  234,  338, -266,  458,  345, -399,  378,  91,  282,  40, -253,  395, -82,  101,  35, -57,  458, -294, -91, -448,  54,  475,  95,  48,  195,  64,  491,  265, -338,  01, -303,  396, -161, -69,  355,  36,  384, -415, -21,  166,  125,  227,  61, -457,  180, -51, -14,  138,  155, -252, -457,  61, -277,  138, -391, -230,  54, -47, -465,  217, -194, -267,  113,  145,  164,  320,  34,  49, -243, -487, -285,  382,  240, -371, -222, -80,  78, -384, -89,  85,  216, -46, -354,  439, -56,  108,  62,  498, -87,  97,  215,  219,  330,  181, -136,  347,  353, -250,  248, -389, -236, -185, -155, -496, -56,  475,  277, -126, -408, -312,  459,  308,  494, -42, -400, -62, -434,  162,  288, -21,  111,  04,  50,  294,  37,  414,  141, -110, -335,  241,  353,  281, -444, -301, -363,  01, -326,  414, -273,  118, -46,  39,  279,  300,  497,  379,  90, -85,  393, -121, -254,  04, -265,  296, -202,  272, -438, -209, -338,  79, -468, -484, -140, -59,  67,  350, -206, -407, -384,  21,  212,  71, -440,  343,  223, -443, -426, -186,  324,  467,  193, -430,  323, -220, -282, -26, -448, -219, -383,  66,  360, -350,  434,  73,  443,  01, -77, -263,  447,  39,  258, -489, -38,  319,  354, -314, -272,  428,  352, -447, -253,  397, -25, -430, -323,  194,  396, -271,  475, -486,  295, -313,  16,  230, -388, -41,  83,  387,  196,  30,  279,  306,  41,  93,  477,  247, -369, -294,  175,  483,  111,  422,  380, -414, -155, -443, -368, -259,  138, -41, -245,  286,  499,  271,  368, -389,  82,  303, -149, -222, -166, -370, -63, -273, -425, -86,  475, -293,  120,  150, -310,  83,  425, -77, -478,  122, -20, -346,  363, -29,  114, -29,  109,  113,  94, -23, -424, -323, -220, -73,  307,  466,  409, -256, -306,  485,  159, -331,  44,  131, -329,  234, -285, -52, -343,  89, -430,  490,  243, -214,  313,  209, -391, -78,  174,  203, -249, -397, -268,  31,  382, -108, -02, -356,  136, -456, -19,  147,  65, -475, -221, -412, -389,  346,  37, -231, -65,  459,  111,  30,  97,  276, -260,  206, -302, -234,  262, -51, -131, -154, -168,  104,  238, -318,  248, -125,  78, -271, -478, -357, -246,  153, -268, -135, -01, -379,  486, -214, -68,  449,  317, -470,  225, -91, -412, -225, -473, -298,  224,  249,  49, -91, -147,  139,  91, -399, -134, -330, -170,  241,  165,  84, -106, -251, -199, -254,  222, -212,  32, -345,  89,  201,  37, -185, -38,  125,  90, -10, -320,  167, -261, -419, -424,  92,  220, -481,  193, -413,  41, -125,  328,  59, -189, -278,  308,  112,  320,  31, -248, -147, -462,  342, -94,  75,  09,  369,  52, -401, -141,  232,  266,  450,  313, -306,  42,  386,  66,  87,  473, -393,  462,  301,  166, -227, -125,  327, -263, -304, -142,  342,  401, -104, -464,  159, -177,  45,  28,  375,  144, -261,  460,  263, -311, -375, -191, -417, -489,  375,  170,  484,  483,  484, -363, -499,  109,  13,  328, -301, -439, -314, -459, -186,  434, -423,  473,  109,  122,  354, -15,  118, -407,  297,  233,  135,  422, -457,  218,  434,  418,  241,  418, -247,  225, -444, -245,  187,  421, -417,  386, -166,  122,  427,  148,  408, -144,  473,  18,  478,  327, -145,  448, -227, -348,  182, -240, -426,  225,  478, -492,  143, -429,  427,  397, -351, -165,  04,  336,  108,  87,  222,  442,  61, -499,  442, -30, -143, -233,  488,  187, -53, -157,  135, -428,  347, -183, -168,  421, -106, -190,  430, -110,  234, -291, -213,  383,  396, -357,  219,  04, -418,  293,  298,  144, -354, -408, -386,  355,  211, -46,  42, -342, -351,  29, -270,  496,  347,  62, -231,  93, -275, -301,  483,  459,  260,  122, -306,  156,  265, -235,  12,  348, -90,  162, -08,  56, -394,  458, -89,  318,  264, -195, -172, -235,  334,  59,  113, -467, -27,  382,  127, -450, -418,  110, -139, -306, -267,  55,  351, -150,  320,  215, -302, -270, -122, -458, -362, -16, -148,  401, -198, -384, -294,  483,  233, -459,  42, -154, -74, -133, -271, -95,  270,  163, -484, -369,  357,  101,  187, -440, -197,  359,  276,  354, -58,  06,  396,  80, -158,  101, -18,  145, -431, -460,  480,  303, -419,  22, -351,  360, -259, -122, -235, -489, -459,  133, -357, -249,  86, -318, -189,  390, -107, -61,  244,  335, -203,  492,  268,  140,  93, -250,  137,  163, -210,  117, -34,  224, -09,  467,  436,  232, -154, -299, -404,  239,  335,  91,  490, -79, -375,  154,  163,  18, -55, -93,  206,  243, -100, -26,  235, -155, -424, -128, -140, -134,  489, -322, -58, -20, -354, -122,  64, -08,  432, -488,  83,  267,  103,  74,  40, -420,  80, -296,  99, -475,  463, -195, -380,  215, -369,  355, -87, -293,  79,  273,  73,  68,  452, -132, -100, -402, -402, -183,  442, -470, -171,  25, -351, -215, -401, -458, -135, -469,  98, -184, -91,  61,  121,  381,  129,  252,  237, -458,  459,  168,  315,  385, -263, -381,  105,  489, -283,  203, -194, -341, -414,  488, -463, -265,  125, -12,  129,  490,  20, -273, -193, -219,  289, -220, -338,  270, -115, -249,  312,  196,  420,  479,  81,  09, -401,  38, -02,  168,  94, -343, -320,  180, -03, -283, -233, -378,  205,  397, -36,  77, -376,  271,  358, -235, -96, -479, -465,  289, -228,  347, -15,  44, -321, -81, -447, -222,  457,  404,  446,  51, -439, -22,  83,  410,  195,  351, -116,  253, -400,  348, -170, -276,  120, -311, -10, -124,  62,  377, -335, -314,  225,  150,  231,  404, -79,  284,  34,  231,  188,  332,  134, -399, -189, -282, -137, -494, -79,  247,  259,  21,  96, -58,  245,  68,  131,  87,  444,  45, -35, -391,  231,  42, -389, -38,  298,  385,  99, -168,  116, -213, -336, -250,  241, -25,  320, -44,  334, -259, -296,  445,  262,  300, -113,  360,  220, -130,  299,  164,  415,  116, -375,  147, -342,  88, -39,  456, -27, -440,  140, -59,  200,  305, -456, -59,  132,  364,  397, -34, -42, -47,  264,  72, -247, -349, -68, -175,  22,  84,  489,  289, -300, -34,  288, -141, -445, -250,  167,  380, -190, -192,  174, -490, -35,  218,  303, -403,  434,  201,  416, -108,  06,  180,  465, -388,  331,  249, -63,  205, -167, -73,  347,  386,  393,  135,  97, -200,  385, -236,  33, -304,  72, -293,  58, -463, -223, -138, -13, -289, -85, -97,  104,  421, -417,  421, -467, -234,  170, -29, -176, -144, -250, -329, -258, -05,  306,  339,  296, -456, -397,  181, -260, -472,  388, -350, -83,  17,  12, -244,  228,  427,  159,  184, -299, -406,  105, -266, -139,  128, -443,  185,  484, -193,  356, -274,  303, -486, -83,  99, -442,  372, -220,  150,  400,  20,  301,  170, -463, -187,  426, -383,  93,  438, -346,  294, -468,  259, -120,  245, -113, -62, -70,  223,  245,  138,  449,  48, -495,  218, -01, -85,  91, -369, -434,  343, -497,  367,  13, -108,  32,  292,  10, -23,  230,  164, -229, -386,  275,  152,  360,  15, -410,  142, -262, -313,  133,  40,  236,  138, -242,  87, -447,  349,  219, -29, -455, -426,  190,  410, -33,  75,  202, -171, -448,  284, -155, -176, -249, -380, -172, -389,  487,  270, -395, -274,  457,  238, -382, -455,  228, -124,  485, -366,  78,  204,  105,  475,  278, -204,  385,  97,  371,  88,  426, -225,  224, -229,  99,  475,  244, -221, -62,  231, -99,  44, -191,  211, -218, -73,  256, -137, -344, -407, -03, -414,  297, -398, -439,  428,  250, -202,  377,  473, -262,  304, -251,  463, -73, -300,  438, -329,  332,  229, -245, -267, -227,  64,  444,  407, -156, -447, -230,  352, -354,  267, -210, -204, -278,  203,  76, -176, -499, -47,  150, -260,  109,  399, -297, -463, -49, -07,  60, -217,  74,  315,  369,  347,  232, -335,  255, -72, -282, -123,  132,  217, -03,  422, -135,  219,  125,  441, -105,  478,  246, -455, -282,  208, -204,  273, -403,  248,  119,  157, -117, -307,  325, -248, -459,  409, -82, -352,  189,  488,  25, -179, -443, -478, -257, -78, -407, -280,  215,  341, -302,  314,  386,  269,  22, -317,  42,  119, -217,  13,  128,  166,  207,  305, -229, -400,  214, -459,  100,  255, -471, -375, -424, -413,  00, -181,  361,  445,  391,  77,  286, -410, -109, -475,  359, -235,  60,  253, -264,  343, -233, -284,  361,  474, -478, -368, -74, -412, -327, -474,  344,  55,  03,  420,  494, -497,  92,  355, -199, -17,  284, -61,  425,  27, -36, -364, -356, -476,  390, -120,  367,  09,  97, -419,  335,  119, -287, -239, -441,  239,  139,  403,  146, -358,  324,  140, -02,  268,  347,  299,  103,  484,  90,  381,  363, -445, -483, -492, -421, -241, -112, -201, -380, -163, -120,  455, -192,  445,  68, -132, -464, -293,  123,  182,  202,  299,  174, -300,  67,  22, -149,  23,  358,  441, -96,  221, -152, -79,  229,  280, -467, -30, -421, -347, -341,  311, -39, -32, -392, -119, -312, -355,  441,  311,  327,  143,  111,  02, -305, -322, -124,  46,  201, -266,  339, -43, -193,  40, -269, -463, -180, -236,  359,  251,  269, -482,  62,  82, -14, -478,  464,  174, -333,  405, -14, -153,  400, -51,  349, -405,  127,  77,  493,  181, -337, -316, -362, -30,  224, -131,  07, -456,  485, -134,  295, -393, -115,  209,  189, -277,  232, -495, -250,  399, -238, -412, -254, -338,  37, -53, -243,  16, -124, -250, -303,  39, -65,  188, -490, -341, -91,  369,  56,  247,  88, -149,  354, -175, -439,  395,  48, -355, -247, -350, -456,  15, -262,  143,  178,  275, -58, -213, -208,  319,  38,  341, -142, -175,  381,  220,  336, -209,  90, -108, -462,  30, -404, -256,  355,  09, -09,  255,  154,  244,  406,  198, -240, -356,  193, -210, -228, -364,  77,  64, -193, -33,  257,  165,  292,  139,  238,  481,  430,  180, -127, -180, -290,  321,  416, -83, -170, -93, -328,  484, -348, -70, -465,  264,  427,  228, -94, -301, -284,  483, -385,  23, -49,  372, -311,  95,  363, -221,  76,  293,  459, -198, -35,  21, -25, -119,  438,  306,  289, -38,  290, -207,  393,  325, -91, -328,  406,  315,  223, -378,  298, -310,  146,  101, -438, -313,  49, -222, -34, -23, -429, -75,  279,  389,  446, -245,  122,  384, -87,  263,  198, -297, -444,  443, -119,  317, -385,  139,  132, -310,  261,  283, -120, -93,  236,  295,  94, -215, -427, -440,  263, -04,  337,  394, -115,  283,  01, -492, -481,  414,  271, -430, -30, -320, -487, -297,  497, -19,  342,  482,  171,  103, -383, -448, -137,  353,  347,  457, -09,  420, -130, -246, -84, -293,  00, -346, -157, -498,  14,  214,  416, -215,  284,  238,  317,  298,  441, -333, -221, -365,  01,  450,  239,  118, -498, -46,  323, -299, -89, -186, -379, -367,  420,  390,  193, -79, -456, -464, -77,  58, -398,  191, -305,  387,  282, -135, -463,  223,  32, -184, -289, -115,  118, -198, -497,  473,  256, -322, -326, -333, -07,  148,  153, -87,  38, -154, -314,  434,  234,  109,  344,  336,  153, -109,  223, -65,  256,  260,  10,  140, -72,  221, -475, -453, -477, -120, -128,  279,  59,  46, -201, -96,  46, -196,  317, -64,  150, -144,  222, -116, -183,  66, -280,  470, -190, -204,  257, -82, -92,  120, -89, -311, -159,  288, -264,  217, -331,  460,  348, -420,  358, -01, -16, -95,  303,  153,  341,  305, -491,  64, -311, -173, -18,  262,  149,  292, -90,  259,  63,  318, -121,  474, -141, -428,  262,  95, -359, -217,  407,  490, -137,  266,  341,  347, -329,  145,  01, -488,  302,  362,  428,  492,  41, -89, -394, -309,  55,  16,  450, -382,  186, -171, -408, -454,  253, -293,  493,  395, -10,  401, -263, -294, -481, -422, -447, -310, -425,  406,  54,  378, -379, -17,  370,  162, -254, -172,  353,  301, -304, -345,  420, -266,  336, -136,  132,  90,  423,  478, -15, -86, -269,  222,  120, -250, -348, -475, -60, -272, -216,  494, -394, -95,  329, -172, -433, -425, -492, -227, -271, -296,  280, -351,  290,  117,  365, -77,  59, -359, -99, -104,  55,  132, -30,  27, -266,  122,  404, -474,  350, -312, -128, -192,  445, -298,  488, -135,  129,  496,  138,  358, -300, -82, -141, -157, -113, -275,  266,  446,  218,  19, -158, -227,  03, -336, -348,  237,  287, -92,  263,  489,  449, -365,  150, -254,  189,  138,  111, -181,  135, -251, -323, -313, -480,  389,  30, -93, -34,  148,  206, -316, -333, -100,  309,  170,  65,  461,  259,  204,  221,  22,  193, -478, -490,  195, -231,  199, -166,  380, -130, -179, -18,  48,  08,  02, -63, -109, -239,  403, -461,  467, -413,  59,  220, -252, -271,  137,  61,  489, -159, -218,  363, -114, -195,  373, -418,  426,  425,  268,  306, -205, -411, -212, -305,  449, -358,  484, -160, -96, -261,  232,  223,  178, -209, -57,  426,  372, -420, -13,  361,  273,  270, -423, -340, -73,  450,  94, -147, -273, -138, -341,  23, -49,  300,  218, -100,  442, -445, -407, -154, -206,  325, -78,  473, -384,  365,  399,  488, -202, -113, -298, -429,  09, -221,  83,  436,  81, -323,  141, -339,  391, -348,  184, -158,  452,  254,  243, -253,  309, -312,  93, -44, -487, -133, -71, -19, -267, -172, -31,  383,  215, -477, -194, -276,  154, -258,  12,  88, -81, -347,  249, -189, -194,  285, -495,  110,  391, -400,  357, -447, -212,  303,  09, -199, -330,  438,  282,  255, -234,  104,  138, -166,  479, -203,  410,  134,  39,  275,  74, -190,  428, -177,  121,  86, -40,  479, -303, -149, -421, -94, -96, -132, -291,  413, -479, -120,  351, -344, -13, -30, -388, -374, -344, -409,  275, -82, -423, -186, -307, -497,  124, -378,  178,  98, -440, -362,  77,  109,  342, -492, -484, -254,  228, -275,  12,  250,  457,  215, -242, -55,  37, -130,  423,  193,  313,  198, -388, -257, -136,  157, -254,  488, -369,  425,  438, -308, -85,  367,  301, -243,  376, -331,  356,  104,  247, -132,  206, -444, -417,  464,  01,  473,  186,  276,  166,  352,  326, -370, -405, -310,  288, -159,  31,  419,  118, -31, -37, -466, -163,  117, -209,  65,  286, -353, -331,  33,  367, -272,  90, -197,  44, -57, -224,  83, -280, -206, -65, -102, -75,  30,  89,  65, -277, -380,  336,  342,  441, -200, -272,  130,  417,  19, -305, -445, -481,  217,  89,  386, -203,  31, -311,  341, -174,  317, -76,  398, -388, -289, -203,  389, -407,  386, -46, -183, -142, -210,  11,  151,  442,  239, -218, -289, -242, -23, -233,  129,  46, -292,  368,  343,  239, -443,  185, -435,  375, -39, -184, -161, -475,  113, -272, -382,  351, -466, -65, -291, -176,  446, -288,  119,  185, -06,  330, -204, -176, -403, -223,  370,  157, -355,  214, -104, -297,  251,  314, -70,  64, -370, -379,  89, -405, -151,  208,  446, -117, -357,  07, -441, -58,  219,  178, -21, -286,  361, -373,  38, -190, -95, -92,  468,  50, -26,  216, -395, -275,  382,  387,  290, -136, -492, -121, -41, -143, -413, -95, -408,  83,  412, -348, -123,  132, -318,  356,  346, -105,  484,  236,  206, -111, -04, -474,  439,  471, -406, -103, -304,  477, -216, -162, -159, -207, -430,  301,  150,  09, -294,  243, -408, -29, -253,  321, -397,  281, -470, -199, -323, -486, -111, -265,  255,  385, -239, -454,  356, -145, -57, -95,  184,  228, -405, -474, -127, -335, -321, -125,  175, -115, -30, -381,  356,  217,  441, -189, -01,  471,  112, -472, -163, -499, -237, -56, -261,  376,  342, -53,  83, -214,  352, -232, -134, -200, -206,  239, -35, -27, -34, -08, -290,  437,  112, -81,  154,  405, -418,  05, -272, -453,  33,  417, -100, -352, -139,  139, -476, -297, -413,  108,  341, -209,  376,  59,  91,  22, -202, -91, -153,  265,  401,  409, -446,  13, -172, -440,  270,  263,  66,  498,  310, -49,  415, -290,  100,  128,  350,  124,  332, -211,  84,  173,  80, -40, -267,  24, -166,  383,  433,  181, -500,  334,  443, -94, -152,  123, -33, -382, -114, -467, -31, -304,  336, -116, -93, -64, -487, -243, -87, -303,  46, -151, -278, -22,  310,  307, -498, -04, -457,  435,  30, -105,  270, -27,  302, -30, -404, -231,  440, -17, -198, -91,  179, -10, -354, -414, -221,  11,  195,  192,  208,  93, -107, -218, -428, -297, -410, -74, -448, -367, -138,  82,  28, -16, -445, -170,  454,  03,  99, -254,  486, -247, -492,  166, -404, -346, -396, -125,  165, -348, -81,  225,  245,  312, -493, -331, -132, -403,  96, -80,  82, -190, -498, -37,  294, -91,  293, -400,  412,  245,  198, -249, -150,  206, -231, -54,  360, -127,  321,  377,  377,  92,  102,  475, -95,  462, -356,  273, -89, -408, -307,  494,  254,  47, -43,  400, -192,  102, -500, -280,  199, -449, -29, -450,  257,  240,  348,  118, -34, -478,  347,  195,  114,  302,  170, -481,  264, -333, -356,  27, -241, -163,  21, -134, -264, -170, -234,  44, -215,  119, -383,  484,  170,  440, -114, -73,  181,  87, -103, -01,  109, -255, -306,  75, -101, -283,  447,  15, -116, -409, -458,  495,  281,  64, -139, -483, -254,  128,  62,  31, -253, -469,  368, -231,  471, -246,  196, -496,  341, -54,  03,  302, -457, -450, -122, -58,  119,  177,  457, -497,  268,  499,  498,  49,  415,  212,  419,  14,  192, -19, -455, -209,  364, -235,  60,  335,  20,  108,  340,  213, -446,  195,  368, -403, -403,  98,  39,  216, -225, -04,  219, -457,  348, -430,  445, -385, -366,  364,  129,  326,  197, -473, -31,  61, -208, -471, -104,  312,  137,  88,  378,  192, -216,  246, -359, -119,  196,  181, -50,  471,  29,  21, -134,  229,  91, -189,  345, -423, -325, -26,  403, -276,  01, -128,  285, -354,  253,  34, -190,  243, -378, -312,  287, -94, -214,  428, -360,  482,  461,  90, -195,  343, -389,  172,  72, -445, -165,  269, -16,  363, -256,  240, -413, -403, -388,  373, -257, -282,  259,  54,  461,  381, -406,  248,  140,  233, -472, -368, -433,  490, -426, -127,  333,  37, -103,  257,  92,  232,  27, -71,  95, -377, -331,  183,  72,  133,  408, -332,  351,  167, -426, -336,  400,  20,  412,  392, -247, -207, -476, -179, -217, -402, -454, -32,  488, -57,  77,  432, -325, -44, -139,  271,  79,  30,  306,  04, -336,  214,  172, -485,  233, -402, -320,  133,  118, -56,  26, -276,  237,  402,  397, -128, -147,  443, -308, -159, -114,  270, -227,  413, -274,  135,  184, -342, -335,  342,  162,  181,  408,  186,  197,  141, -364, -271,  127,  254, -475,  05, -170, -385, -93, -273, -13, -388, -330, -468, -47,  408,  302, -421,  322, -120, -434,  358,  38,  83, -447,  52, -235,  461,  90,  462,  103,  226,  43,  82,  333,  420, -413, -337, -465,  346,  243,  375,  459, -235,  407,  264, -326, -439, -305, -152, -59, -239,  58, -168,  345,  111, -264, -390,  73,  327, -76,  28,  405, -181, -390,  238, -261, -303, -246, -225, -105, -151,  02, -146,  114, -91, -29, -360,  322,  166, -12, -237,  428, -101,  447, -375, -490, -316, -265,  435, -137,  159, -37, -232,  478,  73, -141,  69, -378,  113,  344,  18,  462, -154, -276,  428, -393,  195, -431,  429,  214,  409,  45,  494, -192,  344, -381,  171, -120, -146,  106,  243, -135, -430, -488,  195,  143, -129, -236,  266, -164, -39,  136,  150, -341,  360,  78,  119,  56,  147,  400, -230,  57, -55, -236, -283,  142,  235,  388, -478, -411,  347,  266,  306,  417, -370,  353,  412,  01, -383, -470, -311,  430,  166,  339, -58,  27, -83, -439, -65, -435,  461, -443,  474,  259,  173, -309, -99, -92, -68, -77,  349, -221, -311,  155,  48, -181,  08, -40, -328,  477,  343, -139, -240,  09, -300,  202, -112,  118, -385, -325, -465, -424, -268, -491, -313,  405,  52,  88,  165, -164, -136,  14,  115,  405,  21, -337, -275, -119,  476,  249,  211,  319, -37,  471,  180,  163, -475, -79,  133, -360,  96, -480,  68, -319, -119,  256, -414, -214,  196, -396,  122, -440,  118,  90,  466, -08, -395,  43,  373, -419,  144,  84, -248, -393,  407, -215, -377,  432,  206, -392, -428,  154, -371,  493,  335,  10, -399, -226,  296,  297, -122,  271, -290, -152, -139, -324,  340, -34, -429,  214,  48,  215,  150, -348,  323,  58, -63, -202, -10, -357, -94,  415,  298,  35, -240,  485, -102, -139, -241,  46,  10,  137, -183,  220, -162,  178, -252, -322, -03, -181, -256, -455, -113,  395,  49,  62,  305,  487,  360, -205, -18,  118,  62, -220, -346,  322, -234,  404,  35,  377, -50, -454,  367,  268,  266, -295,  298, -133,  235, -205, -462,  480,  192, -75, -273, -258, -161, -468, -271,  51,  179,  211, -330,  94, -156,  176,  268,  462,  80, -196,  339, -470, -150, -442,  298, -32, -237,  449, -313,  499, -256, -274, -169,  437, -497,  58, -321, -157,  442,  260,  394,  473, -29, -84,  67, -333, -408, -164, -19,  172,  492,  173,  203, -158,  231,  353, -338, -153,  302, -150, -154, -453,  428, -471, -164,  431,  87,  15,  126,  381,  127,  21,  354, -50,  437,  274,  118, -118, -38, -401, -446, -46, -376, -391, -352,  356,  463, -190, -297, -383, -488,  401,  16,  440,  430,  352, -276,  369,  219,  350, -398, -154,  223, -192,  297, -487, -418,  267, -105,  44, -282, -51, -150, -157,  59, -02,  51,  374, -339, -394, -157, -327, -493, -288, -34, -211, -436,  190,  10, -364,  392,  112,  334,  116,  420,  131,  129, -497,  250, -476,  399,  469,  325, -250,  164,  236, -400, -285,  110, -239, -179, -194,  287,  180,  18,  105,  469,  434, -205, -21, -430, -313, -409, -243, -345, -137,  388,  284,  218,  491,  308,  118,  460,  134, -280,  124, -130,  172,  339, -167, -214,  12,  491, -427, -308,  09,  178,  13, -57, -175, -156,  366,  364,  287, -377, -480, -350, -137,  304,  369, -146,  465,  339,  166,  451, -89, -210,  173, -417, -19, -142, -131, -155, -151,  294,  389,  358, -28, -98,  154, -351,  246,  372, -134,  33, -153, -114,  184, -438,  42,  405, -83,  359,  244, -417,  310, -345,  226,  336,  90,  59, -306,  460,  405,  44,  254,  294,  254,  79,  49,  260,  228, -205,  132, -406, -319, -169,  332, -283, -106,  227, -378,  311,  86,  366, -254,  249, -127, -176,  85,  463, -264, -369, -225, -359,  175, -470, -213, -70,  461, -312,  42, -459, -16, -325, -12, -483,  06,  172, -266, -248, -101, -144, -85, -162, -278,  162, -413,  447, -162, -476,  410,  74, -345, -314, -433, -317,  68,  207,  465,  29,  395,  07,  422,  231, -466, -90,  248,  393, -417,  482, -355,  334, -162,  61, -328,  412,  75,  111,  359,  413,  487,  270,  340, -357, -192,  407,  178,  376,  466,  143,  257,  362,  02, -469,  93,  37, -58,  194, -70,  377,  176,  427,  211, -133, -12,  384, -221, -437,  347, -361, -171,  335, -239, -331, -170,  421, -72, -492,  297,  247, -497,  406,  109,  05,  437,  54, -458,  231,  100,  324,  108, -223,  252,  172,  144,  92,  408, -225,  156,  255, -86, -163,  442, -473,  358, -228,  448,  138, -220, -403, -115, -217, -145, -154,  289,  145, -247, -317, -124,  353, -492, -163, -18,  260, -139, -22, -148, -231,  254, -140, -124,  20, -451, -181,  400, -241,  91, -300,  398, -276, -202,  135,  359,  153, -166,  148,  150,  87, -316, -473,  292, -308,  216,  127, -196, -423, -43, -492,  198, -289,  221, -74, -416,  270,  245, -164, -118,  189,  36, -220,  413,  334, -233,  272,  340,  101,  273, -10,  40,  457,  369, -167,  01,  437, -188,  305, -486,  269, -335, -436, -167,  386, -09, -83, -491,  88, -395, -109, -223,  141,  171,  42, -24, -210,  167,  168,  392, -60,  10, -68,  249, -120, -383, -250, -183, -71, -445,  184, -301,  72, -400,  384, -41,  91, -199, -32, -320, -94,  359,  309, -101,  382, -148,  375, -328, -481,  395, -84, -41, -94,  349,  60, -362,  466,  310,  307,  248, -283, -09,  447,  289,  92,  331, -252,  35, -16, -432, -433, -258, -221,  377,  141,  13, -271,  369, -462,  100, -384, -46, -89,  22, -197,  471, -488,  122,  281,  320, -130,  498,  163,  169, -361,  107,  352,  240, -357,  188,  308, -290, -218, -412, -61,  423,  453,  168, -356,  491, -232, -239, -54, -469, -365, -399, -498, -352, -425,  283, -180,  297, -367,  483, -34,  125,  91,  170, -135, -414, -142, -327, -204,  140,  113, -412,  416,  419,  256, -88,  410, -123, -475,  208, -92, -339, -338,  263,  161, -263,  398,  481, -465, -116, -184,  353, -491,  407,  24, -126, -155, -266,  399,  494,  375,  365, -418, -357,  284,  338,  55,  194,  67,  433,  255, -172, -54,  417, -409, -393,  06,  489, -60,  41, -127, -392,  247,  234, -132,  123, -392,  213,  357, -140,  207, -416, -275,  289, -273, -491,  480, -365, -445,  399, -432, -338, -273,  366, -421,  170, -175,  86, -488, -383, -21,  237, -275,  78, -28,  93, -299,  432,  159, -441, -208, -134, -357,  17,  08,  223,  378, -12, -290, -214, -113,  130, -52,  467, -04,  380,  137,  321,  318,  149,  438,  149, -113,  15, -272,  359, -391, -71, -357,  268,  340, -64, -14, -164, -195,  494, -441, -316,  334,  121,  322,  74, -249,  122,  41,  247,  02, -322,  420, -180, -320, -290,  470,  419,  225,  50, -370,  334,  479, -227,  454, -328,  209,  293,  08, -485, -361,  419,  51,  474,  40,  225,  48,  291, -153, -59,  390,  350,  471, -338,  22, -349, -128,  344, -78, -403, -106,  52, -216,  226, -322,  90,  398,  387, -117,  258, -246,  375,  177, -343, -299,  69,  382,  249, -140,  82,  42,  102,  284,  13,  264, -194, -483, -12,  03, -61,  437,  397, -156, -279,  475,  22, -336, -275,  261,  399,  483, -132,  274, -488,  377,  475,  81, -388, -424, -207,  194,  118, -253, -22, -16, -137, -364,  01,  351,  491, -208,  289,  389,  488, -138, -284,  362,  26, -58,  124, -74,  277, -156,  52,  290, -279,  28,  223, -167,  104, -483, -121,  75,  116, -291, -441,  480,  198,  412, -317,  189, -296,  472,  78,  45,  187, -353, -93, -287,  89, -117,  491, -134,  227,  44,  08,  449, -76, -268,  134, -120,  101, -486,  455, -283,  75, -134,  49, -227, -222,  233,  463,  335, -443,  393, -120,  244, -460, -361,  458,  129,  23, -199, -152, -250,  345, -292,  51, -231, -60,  38,  150, -107,  52,  457,  463, -373, -176,  12,  253,  454,  97,  216, -359,  155,  109,  373, -101,  150, -487,  209,  131,  388, -489, -169, -362, -292,  40, -458, -22, -168,  80, -20,  226, -16,  289,  189,  463, -35,  53,  216, -80, -349, -68,  413, -342, -106,  287,  57, -456, -348,  119, -473, -460,  130, -141,  30,  338,  399,  72,  168, -269,  04,  00, -191,  488, -210, -150, -196,  255,  404, -480,  27, -93,  305,  293,  65, -301,  80, -26,  95, -416, -407,  122, -376, -425, -167,  154,  414, -268,  79,  434,  316, -417,  287, -375, -76, -71, -24,  228,  36, -120, -400, -84, -361, -243, -291, -444,  308, -359,  30,  255, -275,  124,  230,  201,  199, -437, -145,  465,  148, -214, -248, -36, -130, -461,  89, -354,  320, -435, -274, -144,  297, -174,  272, -212,  436,  481, -156,  244, -378,  375,  00, -153,  351,  82, -452,  402,  145,  256,  368, -207, -106, -28,  257, -384,  363,  199, -238,  183, -384, -12, -461,  414, -333,  312,  54, -397, -355,  399, -301, -232, -374, -449,  467,  477,  133, -132, -269, -221, -24, -401,  424,  370,  423, -466,  487,  286,  233,  101, -31,  349, -410,  361, -385,  109,  173,  170,  212, -330,  421, -237,  290, -453, -185,  258, -124,  448, -22,  107,  79, -194, -441,  356, -324,  482,  390,  15, -379,  123, -31,  90,  324,  411, -49, -208,  20, -24, -186,  84,  499, -265,  347,  289,  134,  14,  47, -490,  315, -123,  117, -106,  183, -472, -250, -288, -489, -08, -421, -368, -33,  48, -426,  144, -41,  378,  436, -169,  206, -250,  415,  205,  337,  263, -05, -29, -223, -106, -19, -56, -376, -50,  339,  307, -21, -59, -129,  342, -214, -49, -174,  253, -149, -100, -103,  311,  130, -167, -358, -163,  435, -90, -106,  272,  25, -259,  95, -346,  136, -72,  99,  260, -269, -62,  419,  210, -269, -209,  404,  17, -406, -270,  123, -55,  482, -480, -244,  465,  206,  251,  154,  493, -339, -452, -382, -462, -210,  213, -308, -222, -358,  291, -110, -127,  81, -191, -65,  313,  452,  191,  182, -454,  421, -195, -08, -245,  178, -400, -280,  236, -297,  374,  229,  216, -225,  347,  254,  417,  61,  447,  47, -445,  238,  437,  280, -180,  98,  67, -15,  51, -242,  19,  449,  31, -323,  293,  286,  355,  394, -141,  91, -51,  85,  172, -334, -288,  20, -228, -371, -67, -281,  176, -12, -190,  465, -232,  482,  64,  335, -33, -33, -55,  486, -84,  476, -337, -290,  262, -130, -44, -27,  461,  405, -441,  134, -77, -229,  06,  196,  253,  439, -233,  281, -73,  77,  247, -453,  59,  163, -266, -474, -370,  179, -135,  398,  155,  380, -392,  269, -249,  64, -257,  64,  322,  154,  50, -255, -223, -444, -207, -118,  495,  61, -336,  274, -362,  411,  321, -450,  426, -93, -72, -444, -414,  293,  454,  241,  174, -85,  363, -223, -169, -42,  341, -347, -388, -108,  251,  241, -52, -104, -376,  296,  457, -212,  70, -52,  51,  244, -02, -23, -349,  426,  385, -262, -428, -309, -169,  246,  106,  46, -477, -210, -496, -284, -57, -384,  108,  46, -290, -91,  443, -166, -295, -248,  122, -373,  200,  25,  371, -302, -146, -125, -23, -261,  465,  49,  282,  148,  147, -111, -305, -478,  179, -301, -262, -26,  168, -301, -127,  378,  108,  168, -288, -335,  420, -314, -208,  121, -437,  16, -329, -83,  391,  148, -492,  356, -303,  290,  04, -304,  31,  199, -282, -290, -249,  309, -463,  419, -492, -90, -351,  116, -422, -139,  281,  498,  399, -75,  471,  462,  441, -357, -121,  332, -357,  239, -460,  193,  29,  397,  389, -439,  448, -40,  123, -301, -231,  160, -30, -223, -78,  119, -255,  352, -168, -122, -297, -269, -345, -326, -307, -403,  169,  424, -219,  313,  163,  174,  06, -307,  71, -105,  106,  19, -293, -271, -429, -24, -258,  393, -395,  164,  13,  202,  17,  345, -68,  220, -71,  88, -254,  122, -463,  416,  399,  170,  229,  62, -156,  87, -393,  415,  482,  213,  287, -310, -205, -290, -482,  37, -397, -24,  53,  468, -322, -78, -334,  111, -06,  95,  51,  241, -283,  88,  157, -384, -242,  238, -469,  103, -175, -362,  370,  159, -296, -491, -299, -01, -281,  72, -112,  175, -452,  441,  143, -274,  216,  309, -311, -290, -96,  240,  451,  474,  180,  460, -58,  439, -450,  325,  394, -125,  464, -384, -113,  20, -374,  440, -129,  197,  12,  259,  224,  60, -448,  220,  287,  268,  381, -172,  479,  138, -431, -218,  112, -399, -257, -94, -460, -207, -268, -214, -479,  48, -97, -92, -432,  381,  200, -61,  430, -287,  50, -493,  273,  102,  227,  412,  223,  108,  93, -446, -254,  162, -164, -290,  263,  431,  469, -344, -275, -299,  294,  98,  249,  49, -142, -331, -70, -442,  460,  213, -229,  10,  220, -103, -36, -53,  161, -313, -93, -246,  93,  154, -232,  430, -284, -116,  361, -315,  40, -62, -114,  186, -112, -13, -264,  246, -492,  166, -343,  468,  231,  280, -22, -49,  29, -205, -250, -309,  334,  158,  297, -72, -188, -434, -142,  28, -50,  71, -434, -158, -138, -48, -472,  250, -208, -236,  349, -200, -217, -142,  121, -486, -362, -49,  318,  168,  246, -432, -289,  81,  226, -492, -491, -110, -426,  219, -229,  376,  142, -163, -282, -496, -359,  99, -393,  285,  363, -192, -62, -02,  166, -441,  13, -344,  10,  183,  324,  109,  251, -113, -310,  330, -104,  51,  72,  322, -230, -305,  199,  412,  32, -231, -231, -474,  368,  228,  311, -416, -464, -251,  82, -446,  160, -53, -290,  23, -370, -113, -368, -266,  274,  174, -84,  22, -275,  488, -155,  347, -316, -456, -389, -432,  165,  232, -406,  34, -40, -242,  118,  348,  359,  52, -246,  20, -500, -35, -457, -18, -296,  27, -432, -170, -299, -16,  353,  278, -27,  50,  125,  157,  446,  236,  225,  111, -31, -328, -355, -219, -70, -385, -18,  141,  168,  236,  13, -480, -299,  56,  02,  257, -65,  423, -412,  136, -93, -207,  266,  380,  343, -109,  389,  289, -20,  467,  252, -199, -09,  398,  82, -227, -487, -436,  414, -467, -347, -72, -447, -146, -164,  408, -36,  272,  331,  404,  260,  90, -303,  27, -29, -108, -230,  212,  33,  250,  179, -215, -97, -330,  35, -162,  295,  49,  254,  210,  434,  407, -362, -160, -238,  326, -252, -422,  98, -69,  482,  211, -479, -321,  90,  344,  423,  360,  57, -44,  463,  88, -407, -134, -389,  129,  204,  406,  30, -41,  468, -36, -134, -394,  304,  480,  433, -96, -442,  383, -313, -108,  446, -291,  71,  36, -95,  346, -103, -186, -198, -140, -245, -104,  226, -134, -475,  283,  124,  55, -258,  93, -129,  460, -449,  28, -207, -164,  432, -149, -280, -380,  244, -334,  181,  167, -445, -414,  366, -48,  253, -332, -336, -492,  416, -258, -126, -207, -475, -150, -300,  119,  443,  424,  80, -153, -48,  373,  183, -116,  76, -245,  356,  172, -78,  37,  192,  329,  476,  58, -219,  229, -422,  297,  237, -153, -461, -37,  140, -83, -335, -307, -464, -39, -383,  468,  308,  69, -307, -09, -195, -378,  247, -338, -354,  21,  199,  338, -150, -473,  248,  483, -392, -321,  280,  345,  26, -329,  160,  18,  88, -322, -437,  477,  139, -320,  445, -53, -399, -09,  438, -93,  113, -463,  69,  259,  410,  120,  450, -240, -500, -450,  95, -392, -271, -125, -194, -393,  399,  466,  478, -13, -04, -459, -36, -365,  74,  262,  82,  175, -247,  373, -66, -282, -238, -497, -171, -327,  476, -221, -67,  476, -170, -471, -416,  411,  256, -110, -481,  155,  209,  497, -05, -295, -110, -189,  193,  464, -75, -225,  492,  178,  00, -74, -252,  263,  282,  78,  436, -390, -291,  221, -414,  39,  250,  22,  303,  359, -235,  322,  366, -174, -329, -139,  383,  413, -475,  76,  378, -50, -296,  370, -19,  204,  148,  229,  319, -70,  159,  255,  40,  369, -23,  478, -92,  79,  353,  63, -62, -30,  237,  157,  296,  408, -482, -469, -326, -105,  460, -448,  346, -336, -226, -173, -280, -226, -92, -460, -443, -432,  295,  449,  437,  124,  428,  197, -296, -367, -239,  494,  103,  498,  151,  251, -241, -478, -366, -67, -83, -406,  337,  115, -242, -37,  442, -21,  237,  203,  19,  294,  271,  166,  244,  208, -209, -476,  257,  347,  09, -482,  341, -36, -131,  345,  67,  480, -281,  201,  265,  136,  296,  102, -248, -446, -83,  46,  385,  06, -251,  256, -199, -128,  275, -103, -420, -82,  273, -310, -235,  134, -292, -42, -402,  429,  155,  165,  409,  374, -134,  174,  363, -338,  128, -33,  69, -455, -487, -46,  52,  115,  63, -295,  487, -162,  454, -80,  256, -421,  110, -127,  213, -330,  331, -337, -48, -13, -320, -139,  213,  398, -112,  76, -87, -484, -457,  482, -86, -91,  288,  466, -476, -149,  23, -137, -459,  329, -365,  297,  408, -403, -330,  473,  120, -146, -12, -428, -307,  168,  285,  406,  66, -327, -17,  479, -310,  26, -187,  456,  435, -398, -226, -189,  305,  297, -473,  347,  478, -338,  496,  386,  112,  19, -289, -268,  373,  199,  156, -434, -133, -59, -176, -215,  115,  307, -235, -343,  186,  430, -387,  121, -468, -113, -215, -310,  36, -188, -111,  14,  326,  237,  252, -62, -244,  463, -478, -19, -486,  178,  399,  233, -380, -276, -482,  235, -469,  135, -256,  217,  66, -143,  191,  450, -404,  476, -08,  132,  140,  381, -02, -34,  119, -250, -243, -273,  65,  131,  209,  79, -190,  108,  164,  282,  332,  182,  369, -284,  170, -387,  433,  88,  322,  476,  390,  418,  452, -117,  402,  92,  116, -100, -89,  87, -498, -480,  315,  67,  151,  376, -02, -187,  336, -338, -405,  169, -304, -184, -263, -282, -71,  22,  306, -249, -01,  197,  21, -49, -68, -77, -104, -452,  323, -341,  136,  325, -321,  303,  244, -318, -469,  94, -04,  367, -392,  443,  388, -195, -240, -375,  375, -459,  148,  182, -207, -353,  231, -334,  450,  15,  90,  198,  63,  265, -291,  51,  91, -112,  206,  187,  423,  237,  134, -81,  105,  242, -138, -07, -101,  474,  471, -225, -484,  119,  457,  161, -382, -460,  327, -432,  55, -83, -381, -30, -317, -172, -126, -374, -431, -420, -335,  492, -330,  299, -89, -373,  42, -375,  472,  441, -48,  443, -284, -32,  62,  25, -371, -468,  417, -192, -399,  324,  226, -280, -205, -239,  400, -479,  239,  469, -47,  404,  461,  123,  204,  224, -398,  98,  350, -425,  39, -198, -482, -392, -378,  433,  485,  103,  465,  403,  411, -82,  227,  489,  490, -126, -250,  391, -105,  489, -288,  349, -254, -326,  324, -198,  398,  427,  400, -400, -498,  291, -98, -128, -249,  376,  157, -263, -21,  475, -360, -109,  245, -281, -120,  236,  446,  483,  479, -159,  472, -309,  42,  70, -135, -133,  372,  116, -206,  272,  216,  148,  416, -29, -128, -333, -153, -470, -96,  327, -143,  396, -282, -398, -32,  450,  338, -86,  433, -331,  255, -242, -139,  150,  328, -422, -483,  201,  194,  163,  325,  263,  163,  241, -266, -465,  409,  81, -83, -187,  260, -374,  62, -170, -271, -470, -219, -81, -56,  66,  89,  51,  324, -198, -299,  153,  232, -282,  206,  279, -267,  31,  42,  396, -227, -372, -216, -318,  209, -447,  347,  322, -320, -91,  04,  261,  291,  285, -320, -265,  204, -379,  287,  28,  275,  488,  33,  08,  59,  91, -213, -356, -377, -319, -107,  248, -191, -471, -218, -130, -418, -371, -308,  114,  391,  197, -125, -466,  334,  56, -230,  390, -471, -91,  271,  305,  249,  156, -187,  160, -252,  452,  305, -129, -15, -302, -29,  294, -273,  253,  16,  161, -266,  209, -224, -23,  258,  151,  12,  444,  59,  282, -313,  89,  43,  458,  246, -208,  114, -441,  453,  362, -137,  258,  85,  348, -192, -92,  494,  387, -339,  10,  48,  248,  71, -324, -275,  181, -320,  237,  478,  239,  371, -335,  180,  266, -377, -74, -441, -411,  337, -488, -196,  52, -378, -259,  252,  282,  150,  246,  169, -337, -243,  69,  411, -320,  246, -363,  362,  426, -274,  340, -483, -50, -143,  198, -284,  332, -24,  127,  421,  166,  139,  77,  70, -387,  319, -177, -253,  321, -431,  416,  484,  178, -14, -252,  359,  84,  237, -427,  10,  463,  413,  27,  265, -230,  77,  482, -398, -94,  109, -125, -428,  101,  453,  142, -434, -376, -183, -186, -203,  239,  82, -219, -83, -432,  381,  128,  152,  118, -447,  14,  82, -182, -458,  199,  440,  471, -467, -106, -123,  143,  270,  301,  96, -425,  296, -486,  51, -387, -172,  348,  352, -237, -19,  122, -169, -137,  102, -164,  481,  156, -298,  415,  474,  96,  115,  415,  68,  148, -191, -203,  143, -69, -401,  91,  06,  395,  106, -91, -140, -214, -243,  65,  49, -409, -313, -267, -46, -359,  421,  287,  297, -377,  203, -376,  220,  170, -461,  140,  170,  200,  437,  166, -16, -112, -243, -158,  135, -285,  252,  496,  354, -139,  61,  255, -48, -400, -160, -242, -259, -239, -454, -109,  237, -399,  15,  309, -377,  406, -51,  293,  458,  238,  311, -58, -21, -79,  285, -386,  136,  37, -38,  342,  398, -125,  98, -149, -25,  438,  461, -431,  52, -493, -40, -211, -40, -173, -50,  83,  85, -249,  229,  43,  489,  40,  486,  320,  461,  271,  435,  450, -192, -103, -356,  58, -375,  242, -239,  100, -467, -277, -479,  437,  82,  333,  78, -105,  12, -472,  478, -403, -221, -441,  141,  120,  452,  127, -59,  413,  250,  228, -285, -90, -23, -140,  468,  102, -46,  82,  55,  339,  305,  76,  276,  239,  262, -146, -366, -226, -118, -35, -128, -487,  24, -487,  486, -24,  492,  279,  242,  242,  07,  457, -348,  484,  169, -28,  87, -376, -446, -358,  463, -289, -430, -408,  451, -316, -54, -63, -41, -319,  402, -317,  46,  279,  48,  32, -245,  40, -189, -151,  134, -330,  159,  286, -345, -172, -242, -406,  304,  165,  88, -380,  376,  158, -288, -321, -305, -490,  117,  154,  43,  19,  337, -410, -202, -115,  474,  406, -223,  138, -245,  411,  308,  414, -451,  463,  95,  159, -91, -101, -176,  497,  371,  53, -492, -417,  232, -297, -406, -151,  357,  137, -279, -454, -421,  371,  283, -94,  277, -88, -456, -115,  175,  352,  151,  224, -332, -254,  235,  77,  498, -440,  427,  369,  465,  435, -195, -451, -362,  251, -101, -153,  240,  472,  245,  320, -305,  380, -274,  473, -208, -230,  210,  467, -26,  213, -457,  494,  460,  278,  72, -190, -310, -01,  31, -345,  286,  336, -295, -224,  87,  456,  123, -172, -220,  220,  00, -25,  100,  226,  300, -256, -152,  362,  63, -326,  76,  106, -331,  388,  236, -407, -302,  427,  92,  229, -66,  230,  418,  491, -494,  05, -201,  481, -315,  79,  201,  185, -93,  153,  263,  59,  397, -389, -78,  312,  138,  498, -82,  307,  386, -346,  400, -64, -67,  344,  17, -280,  74, -65, -289,  80, -207,  11,  61, -22, -58,  114, -336, -299, -233,  427,  261,  16, -109, -317, -172, -119,  33,  246, -312, -81, -248, -60,  355, -462, -216, -128, -242, -290, -340, -31, -358, -47, -168,  203,  431, -373,  169, -53, -172,  436,  227, -59, -48, -30,  476, -368,  351,  09,  378, -109, -220, -18, -317, -365,  20, -33,  360, -370, -471, -128,  452, -329,  325, -216, -274, -392,  263,  395,  56, -56, -317,  135,  385,  487, -395,  362, -381, -192,  223, -151,  199, -496, -317,  382, -09,  204,  201,  203, -314, -418, -425, -362,  105,  400,  275,  331, -491,  38, -422,  417,  482,  113,  52, -280,  100,  157, -66, -429, -183, -343, -80, -132, -339,  103, -250, -495,  159, -197,  208,  346,  237,  284,  484, -158,  184,  259, -327, -455,  150,  103,  462,  132,  68,  366, -296, -332,  375,  138, -261, -308, -352, -489,  60,  161,  114, -338,  166,  126,  317, -125, -28,  54,  11,  308,  396,  47,  420, -79,  93,  70, -124,  407,  54,  444,  274, -389, -388, -499,  249,  203, -306,  397, -434, -394,  59,  181,  121,  77, -193, -62,  452, -369,  493, -37, -209,  389, -489, -289,  163,  456, -367, -461, -285, -460,  484, -159, -349, -52, -157, -248,  04,  389, -350,  70,  495, -439,  103,  116,  138, -238, -93,  443, -107, -100, -94,  185,  141,  269, -252, -196, -423,  234,  196, -207,  274,  180,  134, -223, -20,  477,  29, -164, -282, -469,  407, -286, -408,  10, -318, -417,  273,  441, -474,  18, -159,  284,  55, -165,  406, -344,  491,  483,  390,  187, -224, -484,  219, -237, -207,  52, -260, -326,  388, -41, -294, -353, -475,  150,  158,  59,  233,  283,  01, -389, -199, -306,  396, -291,  381, -346, -135, -275, -363,  107, -236,  266,  123,  484, -471, -232,  388,  121, -58, -372, -420, -500, -224, -43,  151,  434, -131, -116, -431, -278,  348,  222,  268, -404,  431,  150, -250, -204,  375,  239,  403, -361,  05,  378, -25,  34, -354,  215, -344,  441,  344,  88,  441, -380, -102,  92, -94, -381, -171, -25, -159, -323, -303, -391,  125, -19, -389,  375, -371, -162,  114, -115, -22, -28, -237, -195, -142,  262, -127,  366,  203, -283,  307,  144, -163, -295,  89],
        [-500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -253, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -252, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -251, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -250, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -249, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -248, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -247, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -246, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -245, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -244, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -243, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -242, -241, -241, -241, -241, -241, -241, -241, -241, -241, -241, -241, -241, -241, -241, -241, -241, -241, -241, -241, -241, -241, -241, -241, -241, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -240, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -239, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -238, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -237, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -236, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -235, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -234, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -233, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -232, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -231, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -230, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -229, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -228, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -227, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -226, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -225, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -224, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -223, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -222, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -221, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -220, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -219, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -218, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -217, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -216, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -215, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -214, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -213, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -212, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -211, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -210, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -209, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -208, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -207, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -206, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -205, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -204, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -203, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -202, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -201, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -200, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -199, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -198, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -197, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -196, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -195, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -194, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -193, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -192, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -191, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -190, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -189, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -188, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -187, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -186, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -185, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -184, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -183, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -182, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -181, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -180, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -179, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -178, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -177, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -176, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -175, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -174, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -173, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -172, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -171, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -170, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -169, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -168, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -167, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -166, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -165, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -164, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -163, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -162, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -161, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -159, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -158, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -157, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -156, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -155, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -154, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -153, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -152, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -151, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -150, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -149, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -148, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -147, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -146, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -145, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -144, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -143, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -142, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -141, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -140, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -139, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -138, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -137, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -136, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -135, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -134, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -133, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -132, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -131, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -130, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -129, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -127, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -126, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -125, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -123, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -122, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -121, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -120, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -119, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -118, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -117, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -116, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -115, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -114, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -113, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -112, -111, -111, -111, -111, -111, -111, -111, -111, -111, -111, -111, -111, -111, -111, -111, -111, -111, -111, -111, -111, -111, -111, -111, -111, -111, -111, -111, -111, -111, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -110, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -109, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -108, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -107, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -106, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -105, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -104, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -103, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -102, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -101, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -98, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -97, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -96, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -95, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -94, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -93, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -92, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -89, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -88, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -87, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -85, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -84, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -83, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -82, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -81, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -80, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -79, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -78, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -77, -76, -76, -76, -76, -76, -76, -76, -76, -76, -76, -76, -76, -76, -76, -76, -76, -76, -76, -76, -76, -76, -76, -76, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -73, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -72, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -68, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -67, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -62, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -61, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -60, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -59, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -57, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -56, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -52, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -47, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -41, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -40, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -09, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -08, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -07, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -06, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -05, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -04, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -03, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -02, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01, -01,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  00,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  01,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  02,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  03,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  04,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  05,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  06,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  07,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  08,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  09,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  30,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  49,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  56,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  62,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  65,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  75,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  76,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  78,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  94,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  103,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,  107,  107,  107,  107,  107,  107,  107,  107,  107,  107,  107,  107,  107,  107,  107,  107,  107,  107,  107,  107,  107,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  108,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  109,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  110,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  111,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  112,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  113,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  115,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  116,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  119,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  120,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  122,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  123,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  126,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  128,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  136,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  137,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  139,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  141,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  142,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  145,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  146,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  155,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  156,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  159,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  160,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  161,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  163,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  165,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  167,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  169,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  170,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  172,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  173,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  175,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  178,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,  180,  180,  180,  180,  180,  180,  180,  180,  180,  180,  180,  180,  180,  180,  180,  180,  180,  180,  180,  180,  180,  180,  180,  180,  180,  180,  180,  180,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  186,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  187,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  189,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  190,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  191,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  192,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  193,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  194,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  195,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  196,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  198,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  201,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  202,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  203,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  205,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  207,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  208,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  209,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  210,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  215,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  216,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  217,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  220,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  223,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  225,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  226,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  227,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  228,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  232,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  233,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  235,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  239,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  240,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  241,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  242,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  243,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  244,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  246,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  247,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  249,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  252,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  260,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  261,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  262,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  264,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  265,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  266,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  267,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  268,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  269,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  270,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  271,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  272,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  273,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  276,  277,  277,  277,  277,  277,  277,  277,  277,  277,  277,  277,  277,  277,  277,  277,  277,  277,  277,  277,  277,  277,  277,  277,  277,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,  281,  281,  281,  281,  281,  281,  281,  281,  281,  281,  281,  281,  281,  281,  281,  281,  281,  281,  281,  281,  281,  281,  281,  281,  281,  281,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  284,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  289,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  290,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  293,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  294,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  296,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  297,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  298,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  299,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  300,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  301,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  302,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  304,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  305,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  306,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  307,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  310,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  313,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  314,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  315,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  316,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  317,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  318,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  319,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  339,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  343,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  355,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  356,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  357,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  360,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  361,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  362,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  363,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  365,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  366,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  367,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  371,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  372,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  373,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  374,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  376,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  378,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  379,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  380,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  381,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  382,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  383,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  384,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  385,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  386,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  387,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  388,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  390,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  391,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  394,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  395,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  397,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  398,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  399,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  407,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  408,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  409,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  410,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  411,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  412,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  413,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  414,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  415,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  416,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  417,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  418,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  419,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  420,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  421,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  423,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  424,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  425,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  427,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  428,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  429,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  430,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  431,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  433,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  434,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  435,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  436,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  438,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  439,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  440,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  442,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  443,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  446,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  447,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  449,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  450,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  451,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  452,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  453,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  454,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  455,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  456,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  457,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  459,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  460,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  461,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  462,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  463,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  464,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  465,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  466,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  467,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  468,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  469,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  470,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  472,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  473,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  474,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  475,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  477,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  478,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  479,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  480,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  481,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  482,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  491,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,  495,  495,  495,  495,  495,  495,  495,  495,  495,  495,  495,  495,  495,  495,  495,  495,  495,  495,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,  499,  499,  499,  499,  499,  499,  499,  499,  499,  499,  499,  499,  499,  499,  499,  499,  499,  499,  499,  499,  499,  499,  499,  499]);


//length == 32769
  check([-345,  150, -247, -146,  24, -107,  118,  54,  40,  489,  393,  105, -370, -329,  123, -446, -88, -404, -371,  366, -206, -66,  336, -493,  194, -309,  210, -367, -182,  257, -303,  326,  259,  303, -320, -216, -304, -349, -310, -411, -08, -417, -454,  474, -246,  169, -471, -481, -382, -342,  385,  264,  444, -427,  271,  138, -236,  334, -377,  434,  443, -179,  260,  203, -376, -207,  487,  172, -56, -323, -387, -212, -240, -341, -238,  366,  329, -209,  385, -201,  301, -378, -437, -402,  47, -313, -412,  311, -479, -288, -402, -184,  385, -290, -481, -139,  03, -494, -467, -201,  35, -01,  87, -353,  158, -298, -486,  339,  345, -249, -362,  499,  226,  54, -403, -227, -407, -315, -63, -386,  249,  35,  282,  486,  245,  302, -153,  101, -340,  233, -248,  196, -268, -308, -305,  390, -106,  61,  230,  91, -335, -280,  90,  391, -374, -461, -336, -281, -275,  101,  185, -174, -12, -32, -187,  86, -230,  160, -313, -70,  245,  291, -22,  477,  483, -474, -280,  229,  87, -198,  173,  252,  374, -237,  143, -499,  155, -340, -280,  380,  261,  406,  58, -250, -126,  371, -312,  496,  384,  227,  278,  481,  18,  109,  459,  354,  135,  31,  435, -278,  333,  108, -173,  207, -276, -178,  208,  379, -18, -219, -389, -256,  39,  169,  346, -235,  393, -114, -239, -371, -387, -109, -390,  131, -500, -79,  337,  487,  452, -375,  62,  285,  233,  389,  345, -191, -289,  405,  40,  194, -314, -497, -210, -423, -475, -12, -158,  418,  374,  455, -101, -161,  199,  09,  470,  199,  431, -340, -461, -265, -215,  101, -479, -130, -10,  366, -468, -447, -377,  72,  247, -190,  76, -111,  239,  101, -271, -418,  371, -397, -111, -230, -58, -412, -369,  265, -360, -86, -223, -321,  150,  414,  280,  171, -216,  122,  389, -184,  175, -136, -259,  275, -474,  317,  16,  266,  270,  246, -300,  493, -299,  89,  115,  496, -470,  246, -387,  22, -339, -110, -447, -337, -196,  333,  334,  440,  307, -425, -243,  334, -61,  350,  109, -34, -481, -374,  84,  289, -276,  284,  282, -75,  225, -103, -79,  255, -05,  386,  129, -492,  128,  182, -329,  432,  367, -143, -275,  174,  284,  334,  09, -276,  184, -30, -458,  203,  448,  126,  344, -328,  262,  126,  450, -13, -125,  223,  95, -278,  110, -276, -269, -262,  407, -98,  23,  274, -388, -400,  301,  396,  434,  162, -380,  118, -368,  14, -179, -67, -08, -335,  457, -246, -357,  407, -406,  370,  483,  189, -56,  93,  413,  175, -317, -328, -70, -442,  447,  42, -342, -400, -62, -408,  262,  411, -438,  394,  277, -117,  179, -230,  400,  137,  376, -105,  396, -178,  117,  379, -489, -438,  324, -223,  237, -492,  301,  19, -82,  248, -439,  77,  348,  352, -479,  462,  263, -416,  357,  392,  319,  388,  14, -428,  25, -109, -33, -78, -435, -415, -199, -71, -01, -374,  206, -264, -14,  07, -392,  404,  108,  21,  333,  308, -127,  355,  271, -12,  439,  480, -119, -390, -280,  395, -318,  246,  138, -498,  20, -444, -413, -327, -15,  86, -201,  43, -326, -363, -98,  134, -106, -490, -344, -273, -329,  381, -66, -206, -130,  225,  126, -397,  336,  346, -150, -482,  92,  489, -480, -36, -455, -41,  138,  30, -103, -211, -75,  424, -73,  327,  58, -327,  338, -434, -100, -139,  448,  335,  155,  170,  60,  133,  273,  248, -21, -377,  267, -76, -36, -361,  388,  361,  451,  378,  243,  200, -332, -332,  124,  447,  496,  35, -380, -314,  453,  372,  47,  401,  207,  54,  71,  120,  39,  196, -132, -482, -328, -13,  294,  136,  479,  183,  350,  430,  413,  93,  482, -419,  262,  107, -472,  258, -06,  00, -204, -53, -127, -305,  201, -68,  249,  124, -448,  140, -179,  273,  158, -07,  112, -47, -19,  91, -12, -169,  373, -99, -223,  356,  335, -461,  315, -285, -351, -191,  216,  297, -392, -59,  492,  309,  373, -407, -66, -222,  233, -393, -449,  243,  452,  163, -304,  285,  107, -464, -31,  332,  290,  246,  188,  477,  285,  355, -308, -214,  16,  408, -417,  125,  201, -425,  286,  75,  20, -280,  353, -247,  179, -244,  496,  131, -229,  45, -83,  378,  433,  386,  211,  223,  484,  251,  200,  269,  107, -255, -93, -377,  05,  342, -400, -293, -231,  387,  282,  289, -41,  487, -458, -09, -257, -462, -378,  14,  435,  391,  245,  369, -371, -44,  444, -387,  59,  497, -266,  18, -258,  493,  494,  247,  335, -406,  454, -396, -167, -412, -255, -355, -425, -213,  136, -182,  178,  258, -315,  465, -498,  430,  334, -369,  238,  279,  97, -203,  276,  331,  316, -482,  325,  310, -383, -488, -244, -76, -31,  90,  12,  214, -413,  88, -146,  223, -242, -468,  333, -57, -151,  335, -127, -316, -181, -37,  463, -232, -387, -409, -49, -219, -39,  128, -57,  78,  141,  199, -498, -390,  141,  15,  324,  228, -45,  30,  303,  213,  414,  137,  09, -236,  324, -266, -52, -357,  198,  263,  263,  311,  354, -285, -408,  167,  343,  35, -255, -16,  86,  100,  446,  80, -33, -377,  160, -226,  153, -36,  487,  68, -399,  348,  332,  425, -417,  132, -79, -367, -105, -316,  444,  101,  251, -112, -232,  95, -225,  365, -69, -287,  317, -122,  293, -216,  01, -46,  58,  06,  418,  398, -426, -129,  246, -242, -204, -319,  390, -431, -186, -215,  106,  110,  386, -143,  498,  06,  452,  125,  224,  236,  339,  41, -386,  484, -322,  467, -62, -412, -27,  208,  486,  400, -421, -415, -342,  228,  118, -451,  297,  433,  186, -97,  43,  425, -387,  394, -69, -83,  371,  07, -347, -438, -451,  119, -453,  79,  438,  337,  167,  264,  46, -494,  164,  477, -409, -326,  205, -439, -277,  355,  494, -238,  110,  390, -313,  223, -364,  470, -07, -493, -22,  146, -430,  379,  118, -31, -42,  56, -194, -375, -180, -296, -369, -164, -318,  74,  11, -261,  136, -414, -54,  482, -152, -443, -276,  35, -368, -140,  358,  125,  220, -164,  124, -358, -285, -258,  111, -475,  298,  417, -350, -29, -378,  134,  307,  156, -292, -182, -253, -304, -95,  194, -321, -395, -397, -97,  141, -265, -384, -01, -287,  336, -313, -311,  478, -98, -69,  441,  279,  81,  358,  429, -448, -168,  63, -288, -160,  272,  30,  88, -180, -213,  134, -01, -107,  237, -245, -114, -176, -129,  385,  389,  59, -428, -422,  389,  326,  09,  330,  105, -57, -460,  386, -05, -127, -50,  207, -435,  74,  90, -495,  394,  377,  139,  246,  122,  228, -499, -492, -447,  224,  393, -206, -217, -183, -127, -328, -05,  382, -498, -48,  177, -458,  191,  25,  267, -07, -268,  333, -81, -326,  338, -187, -96,  330, -89, -474,  58,  264, -465,  463, -12, -220, -242,  271,  450,  483, -205,  297, -283,  149, -250,  395,  192, -207, -80,  311,  286, -496,  496, -295, -321, -313,  370,  83, -483, -218,  461,  427, -454,  496, -257,  387,  129,  353, -490,  79,  336, -194, -124, -447,  455,  478,  448,  499, -229, -132, -337, -91, -127, -341,  114,  404, -154, -15,  339,  215, -381,  300,  495,  17, -351,  90, -96,  278, -57, -85,  209, -221, -427, -63,  184, -120, -84,  133, -120, -461, -147,  43, -51, -422, -446, -437, -166,  253,  400, -327, -32, -129, -174,  315,  389,  327, -95,  145,  457,  348, -88,  166, -21,  337, -397, -336, -282,  371, -351,  98,  411,  354, -07, -140, -215,  47,  275,  119, -200,  176,  293, -379, -453, -29, -212, -212, -202,  194, -214, -245,  394,  198, -227,  226,  36, -124, -258,  254,  100, -109,  204,  11,  97,  49,  371,  382, -52,  146,  02,  249,  174,  147, -278, -426, -30,  10, -138,  268,  56,  148, -125, -49,  199,  148, -323,  87, -124, -81,  193,  476, -338,  249, -13, -389, -202,  210,  494,  246,  209,  348,  347, -117,  347, -79, -43, -183, -216, -328, -63,  340, -328,  312,  143, -277, -40, -328,  310, -312,  91,  355, -335, -395,  104, -496,  69, -246,  215,  415, -499,  276,  263, -300, -341,  462,  122,  469, -221,  406, -359, -432, -402, -187,  380,  242,  37,  192,  414,  199,  380,  358,  55, -103, -185,  11, -98,  384,  266, -31,  299, -381, -255,  414,  171,  256, -272,  145,  225,  359,  403,  366,  427, -498,  32,  307, -404, -79, -01, -138, -380,  232, -280, -473, -371,  388,  391,  31,  272, -491, -148,  424, -20,  97, -310, -349, -146, -81, -351, -421, -222, -448, -202, -294, -94, -318, -487,  02,  103,  365,  365, -425,  97, -63, -45, -422, -175, -154,  462, -402, -145, -186, -126,  335, -236,  64, -162,  118, -165, -13, -451,  466,  392,  199, -328, -202,  381,  37,  301,  336,  254,  166,  412,  203, -397,  219,  282, -71, -435,  244,  379,  272, -442,  105,  459, -178,  21, -203, -208,  357, -363,  194,  323, -471,  245, -153, -173,  479, -264, -20,  315,  491, -354, -421,  194,  102,  298, -24, -117, -285, -280,  114,  487,  131,  71,  446, -195, -408,  96,  450, -199,  233,  144, -24, -386,  241,  323, -59,  220, -440,  422,  36, -97, -80,  467, -403, -126, -382,  426, -391, -167, -02, -425, -179, -371,  146, -233,  287,  239, -285,  237, -108,  448,  233,  369, -438, -26, -456,  356, -305, -396, -370, -417,  359,  402, -450,  457,  129, -332,  383,  238,  02, -119,  314, -325,  363,  312,  294, -498,  51, -490,  239, -204, -190,  324, -335,  225,  150, -291,  433,  345,  166, -437, -220,  25, -183, -169,  334,  446,  351, -431, -463,  205, -49, -297, -268,  166, -485, -473,  168,  419, -463,  259, -285,  199,  83,  232, -76, -267, -207, -143, -69,  459,  272,  211,  337, -410, -106, -477, -112,  98, -407, -75, -197,  44,  128,  36,  62,  496,  415, -270,  415, -196, -159, -18, -497,  424, -286, -72,  09,  07,  285,  440,  319,  410, -496, -492, -500,  250, -469, -112, -152, -376, -334, -496, -480,  294,  392,  82,  290,  307, -336, -443, -389,  05,  39, -34,  281, -395,  394, -209,  465, -468,  83,  284,  442,  439,  292, -206,  190, -325,  182, -462, -200, -300, -106,  172,  495, -214,  107, -363, -55,  271,  47,  408,  129, -62, -125, -90,  44,  121, -447,  09,  153,  137,  145,  447,  76,  289, -259,  118,  464, -224,  157,  116, -24, -449, -211,  323,  190, -252, -187, -365, -481,  360, -456, -500,  150, -81,  263, -306, -460,  316, -445, -454,  305,  200,  493,  234, -11,  87, -148, -46, -285, -491, -78, -457, -87, -437, -281, -397, -189,  32,  90,  183,  244,  134,  183, -106, -95, -54,  441, -54,  115,  496,  344, -80,  197, -311, -346,  38,  276,  07, -156, -157,  368,  267,  239,  133,  330,  458,  236, -06,  342, -173, -323,  86, -187, -288, -168,  219, -489, -227,  17,  126, -230, -139, -454, -181,  50,  53,  357,  179, -440, -298, -126, -220, -179, -387,  414,  03, -429, -498,  497,  413,  181, -326,  351,  495,  239, -316, -434,  250,  309,  83, -124, -69,  444,  274,  250,  346, -173,  460,  25,  239,  14,  400, -480,  335, -487, -214,  190, -63, -212,  188,  202,  470, -286,  406, -183, -195, -58, -117, -445, -249, -182, -69,  183, -238,  58,  285, -40,  385, -403,  486,  477,  111, -262,  497,  298,  103,  135, -11, -460,  423,  29, -405, -255, -405, -499,  62, -99,  295, -203, -44, -454,  115, -260, -419, -271,  298, -281,  190, -465, -184, -472, -488,  428, -234, -139, -422,  369,  496,  419, -238,  420, -52, -143,  17,  44,  210, -68, -203,  05,  229, -395,  403,  197, -155, -163, -222, -05,  56, -180,  31,  372, -152,  43, -348,  114,  405, -269,  336, -247, -350, -402, -327,  451, -45, -457,  347,  17, -25, -356, -126,  56, -251, -223,  105,  447,  114,  384, -58,  22, -296, -175, -105,  405,  369,  399,  19, -374, -370,  207,  231,  133,  305, -243,  84,  112, -200, -69, -371,  275,  427,  355, -169,  28, -367,  437, -25, -401, -327,  418,  474,  229, -257, -131,  134, -36,  120,  06,  442, -397, -287,  174,  236, -481,  431,  172,  483,  83, -45, -35, -142,  234, -180, -459, -238,  305, -170,  238,  405,  03, -492,  379,  85,  103,  100, -281, -80,  72,  225,  214,  175,  439, -112,  263, -190,  171, -65, -207, -246, -258,  258,  464,  476, -421, -142, -261,  384,  188, -171, -359,  44, -163, -128, -371, -208, -176,  200,  212,  397, -74,  279,  72,  217,  19, -164, -473, -309, -377,  172,  297, -134, -69, -386, -158,  362, -28,  433, -402, -340, -238, -260, -444,  451,  464,  37,  96, -211, -262,  160, -314,  164, -61, -390, -119,  459, -54,  260,  02,  422, -68,  151, -212, -285,  265,  482, -423, -263, -232, -324,  250,  382,  268, -342,  334,  232,  196,  282, -127,  434, -58,  59,  450,  382, -478,  183, -307,  320,  295,  195,  242, -273,  198, -118,  295, -36,  217,  372, -447,  485, -100, -345,  367,  20, -186, -447,  105, -138,  335,  478,  148, -222,  390,  450,  12,  412,  133,  205,  232, -72,  252, -25, -493, -50, -291, -346,  414,  426, -121, -180,  411,  279, -25, -369,  152, -359, -316, -243,  355, -480,  87,  03,  150, -23, -47, -338,  241, -62, -281, -26, -282,  471, -199,  78, -79,  10,  232,  188, -63, -389, -140,  200, -257, -313,  331,  395, -171, -132,  04, -316,  240, -57, -460,  242,  421, -07,  404,  162, -216, -25, -12,  02, -54,  289, -420, -281,  152,  313, -241, -59, -224,  119, -359,  19,  307, -175, -86, -12,  193, -230, -476,  285,  214, -436,  27,  487,  410,  283, -499, -306, -242, -10, -452, -444,  131, -19, -225, -217, -206,  35,  224,  70,  06, -282, -58,  165,  43, -292, -347,  88, -21,  30, -127,  45,  446,  400,  32,  356, -465,  385, -98, -207, -125,  303, -151, -141, -216,  124,  142,  430,  11,  219,  352, -130,  437, -206, -465,  332,  03,  41, -80, -166, -429, -355,  379, -483, -103,  263, -274, -68,  148,  480,  225, -124,  283, -74,  235, -81, -98,  229, -151,  414, -52, -298, -216,  237,  348,  171,  421, -149, -288,  193, -463, -217,  338, -232,  153,  87, -469, -269, -481, -468, -289, -404, -92, -153,  22, -357,  266,  425, -276, -32, -309, -475,  170,  327,  262,  370, -02, -464,  74, -437,  229,  111,  198,  420,  380, -149,  07, -237,  82,  27, -205, -354,  475,  203, -07,  350, -302,  111,  275, -77, -421, -182, -52, -399, -355,  62,  472,  495,  450,  46, -90,  180, -343, -391,  100, -111,  312, -393,  153,  247,  486,  448,  393, -186, -496,  238, -336, -298, -151, -209,  477, -71,  109,  277,  30, -394,  192,  02, -47,  142, -100,  364, -178,  410,  473, -226, -201,  285, -118, -196,  32,  220, -247,  277, -466,  109,  15, -302, -337, -283, -11, -359,  146, -50, -230,  28,  56,  462, -117, -490,  457,  283,  374, -221,  193, -301,  54, -155,  484, -212,  149,  369, -492, -246,  146, -457,  363,  14,  93, -473,  231, -417,  20,  229,  33,  290, -243, -58, -395,  492, -48, -438,  276,  178,  193,  321,  377,  99, -334, -287,  387,  316, -418,  396, -430, -419, -209, -214,  95,  384,  165,  178,  467, -315, -93,  353, -173, -484, -205,  284, -491, -401,  346,  285,  277,  392,  458,  154, -09, -23,  367, -121,  145, -198,  127, -433, -117,  418, -147, -170, -346, -482, -492, -26,  55, -85, -173,  383, -69,  474,  167, -60, -427,  366,  77,  350, -390,  388,  356,  101, -135, -425, -168, -490, -123,  459, -423,  260, -271,  283, -58,  236,  301, -50, -290, -143, -283,  389,  92, -499,  363,  111, -59,  436, -23, -129, -362,  439,  111, -154,  41,  476, -79, -275, -162, -349,  37, -85, -237,  266,  50,  206,  354, -148,  08, -436, -439,  226,  453,  153,  227,  316, -236,  20, -396, -406,  391,  94, -467,  02, -208,  426,  330, -434, -348, -332, -283,  189,  436, -20,  307, -14,  38,  162, -310, -453,  226, -249,  273, -468,  404,  00, -300, -331, -480,  157, -237, -236,  103,  148, -382,  396,  75, -199,  462,  227, -31,  31, -84,  257, -489,  75, -256,  50, -263, -66,  97, -184, -462,  222,  200,  442,  74,  400, -37,  446,  409,  226, -290,  13, -125,  181,  261, -198,  482,  223, -471,  303,  106,  297,  61,  117, -128, -343,  19,  462,  443, -32,  130,  481, -310, -170,  424,  264,  82,  239,  211,  344, -34, -227, -143, -307, -194, -382,  347, -212, -307,  376, -408,  299, -475,  153,  268,  249, -338,  140,  211, -395, -392,  193, -413,  151, -125, -137,  267, -190, -398,  330, -346,  420, -44,  11, -35,  262,  481, -188, -97,  26, -312, -05, -175,  65,  00, -55, -185,  162, -415, -122,  267,  46, -428, -294,  49, -53,  69, -184, -391,  172, -01, -237,  92,  455,  274, -442, -431, -393, -130, -28,  133,  411, -181, -190, -24, -329, -392,  291,  333, -307, -330,  453, -409,  94, -341,  140, -459,  229, -191, -349,  253, -340,  266, -155, -33,  393,  255,  36, -500, -374, -139,  486, -111,  180, -204,  365,  352, -96, -491, -463,  450,  31, -158, -107, -375,  02, -466,  18,  83,  195, -479,  188,  355,  288, -467, -178,  181, -359, -290,  181,  119,  71, -481, -492,  104, -184, -275,  308, -428, -266, -303, -126,  265,  40,  268,  390, -106, -346, -91, -171,  349, -70, -483, -444,  70, -98, -122, -249,  43,  440, -215, -338,  12, -196, -330, -32,  472, -104, -224, -455,  482, -27, -81,  248, -135,  39,  490,  259,  193,  251, -412,  42,  34, -395,  450, -396,  360, -172, -144, -97,  121,  141,  418, -367, -203, -60,  453, -230, -312, -271, -185, -329, -446, -414, -229, -80,  478, -239, -321,  171, -135,  120,  66,  399, -423,  16, -497,  437, -303, -141,  193,  318, -148,  111, -197,  150, -449, -244, -228, -260,  337,  439,  263,  391, -475, -466,  163, -497,  147, -305, -473, -136,  315,  93, -237,  392, -39, -233, -318,  158,  478,  375,  328,  183,  338, -369,  185, -259, -113,  457,  333, -276,  396,  96, -32, -227,  482, -369,  129,  482, -174,  156, -154, -07,  101,  110,  238, -438, -271,  420, -427,  59, -353,  401, -258, -163, -467,  427,  78,  272, -264, -88, -151, -368, -140,  317, -94, -157, -200, -113,  177,  479, -457, -477, -28,  496,  485,  62, -442, -286,  334, -369, -374, -167, -115, -132,  170, -82,  148, -251, -310,  384, -487,  39, -131,  225,  208, -373, -432, -491,  14, -403, -160,  409, -379, -336,  405, -394,  227, -185,  173,  413,  299, -349, -253, -316,  371,  417,  454,  19,  18, -04,  256,  31, -464, -23,  109, -404,  104,  177, -43, -30,  275,  297,  231, -252, -186,  136,  206, -459, -197,  231,  454, -398,  382,  53,  138,  254, -29,  92,  125,  489, -411, -119,  373, -23, -290, -18,  73,  314,  11, -117,  136,  138, -320, -133,  386, -06, -145,  445,  387,  159,  176, -306,  261,  411,  247,  252,  165, -282, -156,  142,  60,  285, -476,  285,  114,  86,  119, -312, -99, -370,  423, -111, -379, -397,  257, -141,  450, -388, -196,  337, -377, -167, -117, -263, -256, -369,  489, -239,  201,  185,  403,  113, -29, -221, -102, -415,  366, -483,  125,  119,  00,  48, -492,  121, -496, -383, -168,  454,  82,  137, -357,  205, -178,  379,  442,  66, -138,  431, -321, -437,  469, -418,  177, -60, -138, -73,  377,  80,  297,  355, -301,  149, -97,  59,  122,  259,  177,  454, -435, -241,  443,  61, -184, -235, -60, -241, -317,  302,  42, -138, -283,  11,  297, -254, -197,  11,  174,  33, -409,  323, -112,  142, -28, -357, -299, -406,  403, -270, -452, -180, -11,  492,  381,  306,  109, -179, -83,  293, -25,  459, -345,  193,  323,  452,  439, -22, -37,  465, -489,  406,  288, -101,  48,  112,  43,  250,  206,  298, -168, -393, -382,  322, -49, -148,  480, -440,  173,  249, -295,  01, -440,  213, -306,  383, -483, -15, -138,  333, -49,  225,  239,  91, -375, -212, -296, -480, -110,  410, -330,  222, -131,  140,  396,  320,  492, -272, -267, -482, -171, -62,  19, -110, -349, -435,  125,  21,  50, -161, -146, -499, -435, -407,  93,  42,  233,  297,  62, -25, -441, -416,  50,  281,  224,  298,  101,  217, -121, -314, -413,  208,  477,  106, -402, -372,  171, -424,  149,  73, -85, -145,  75,  332, -51,  20, -126,  34,  169, -212, -490,  228, -128,  412,  09, -403,  210, -37, -334, -411,  149, -247, -350,  126,  359,  100, -393,  382,  176, -392, -45, -56, -36, -118, -224, -235,  402, -497,  299,  423, -209, -339,  152,  164, -427,  13,  261,  284, -172,  427, -275,  478, -320, -125,  456, -109,  476, -85,  125, -496,  376, -68, -52, -160, -333, -423,  457, -79, -420,  256, -155, -129,  418, -151, -465,  491,  362, -352, -373, -309, -73,  205,  21,  459, -420,  329, -150, -92,  97, -173,  265, -27, -388, -287, -335, -221,  142, -378,  200,  222, -270, -103, -54, -352,  246,  333, -08,  109,  482,  471, -348, -91,  176, -475, -131,  257,  354, -429,  17, -49,  251, -218, -224,  363,  348, -59, -06, -10,  63,  46,  65,  294,  444, -489, -206,  190,  344, -362, -201,  326, -390,  303,  88,  286,  328, -191,  395, -465,  232, -87, -14, -17, -453,  263,  198, -253,  56, -308,  238, -28,  239,  155,  118,  183,  166,  412, -127,  362, -449, -475, -459,  13, -320,  129, -201, -491, -210, -305, -456, -478,  460,  382,  06, -141,  497, -296,  107,  54,  249,  197, -474, -12, -148,  144,  23, -130,  408, -252, -268, -189,  125,  125,  324,  306,  106, -376,  315,  396,  171, -289,  419,  483, -407,  277, -158, -57, -167, -199,  497, -418,  498, -125,  422,  202, -481, -55, -76, -221, -454, -491,  91,  171,  134,  267, -23, -259,  391,  144, -363,  414, -293, -92, -251,  153,  37,  444, -404,  371, -255, -407,  453,  96,  320,  376, -202,  339,  173, -425, -30,  219, -416, -439, -109,  218,  329, -280,  459, -428, -283, -51, -161, -76, -291,  88, -423,  247,  32, -327,  118, -370,  118,  423,  226, -62, -349, -124,  129,  325, -49, -400,  396,  35,  13,  139,  106,  194, -288,  417, -381, -71,  218,  310,  353,  428, -102,  431, -473, -217, -44,  497, -87, -425,  420, -09,  13, -428, -281, -05, -251,  171,  95, -03,  58, -40, -363,  16, -345, -151, -66, -226,  278,  04, -416,  483, -68,  334, -234,  311, -31,  223,  308, -266, -350,  229,  225,  163, -347,  445,  10,  254,  468, -395, -249,  378,  66,  240, -105, -427, -411, -319, -153, -281,  185,  283,  55, -30,  469,  321,  133, -61,  44, -58, -475,  194, -329,  251,  210,  176, -452, -280, -70, -132,  178, -467,  98,  96,  274, -155,  169, -285,  26, -132,  287,  64,  03, -158, -114, -28, -337, -481, -237, -440,  313, -211, -394,  484, -108, -332, -488,  292,  241,  294, -340,  271,  328,  258, -133,  102, -396, -112, -331,  482,  256,  456,  398, -241,  150, -216, -417, -334,  156,  199, -274, -31,  488,  184,  306,  232, -295, -330,  24,  446,  465,  184,  217,  293,  294, -64,  247,  398,  324,  416, -267,  80,  373, -369, -309,  23,  268,  126,  189,  276,  177, -233,  97, -483, -196, -97,  249,  09,  426, -227, -45,  391, -191,  24,  184, -396,  460,  283, -146, -364,  199,  87, -432,  424, -429,  111,  300,  339, -263,  341,  467,  415, -39,  64,  432,  265, -180, -466, -226, -254,  159, -419, -363,  469,  457, -327, -75, -231,  456, -369, -95,  155, -429, -27,  432, -358, -64,  232, -167, -475,  73, -200,  440, -466, -284, -275, -349,  36,  111,  277,  282, -230,  358, -229, -261, -333, -56, -484, -64,  252, -352, -307, -92,  71, -482,  192,  213, -46, -76, -102, -20, -151, -450,  272,  236, -234, -151,  387,  303, -188,  165,  85,  83,  375, -291, -326, -105,  153, -309, -317, -94,  191, -123, -334, -238,  247,  358, -173,  54,  134,  225, -466,  483,  275, -342, -429, -459,  360,  459, -304, -328,  476, -366,  255, -297, -157, -218,  98,  496, -27, -366,  254,  16,  11, -228,  278,  110, -370, -43, -336, -384, -318,  50, -400, -191, -439, -329,  202,  421, -18,  399, -407,  310, -467, -299, -486, -124, -17,  464,  224, -192, -50,  331, -324,  461, -397,  454,  424,  86,  263, -412,  202, -203,  491,  302,  106, -448, -174,  160, -175, -340,  59,  270,  471,  444,  471, -163,  172,  306,  153,  249, -386, -396,  80,  142, -83,  183,  96, -159, -231,  211,  282,  472, -492, -375, -374,  114, -323,  304,  127,  354,  465, -314,  124, -212, -17,  96,  125, -345,  254,  130,  404, -279,  234,  336,  363,  04,  20,  312, -303, -359,  23, -169, -387,  32, -44,  92, -02,  485, -104, -375,  339, -139,  164, -36,  149, -353, -88,  126,  154,  18, -243,  411,  239, -157,  247,  103, -301, -233, -85, -103, -91, -210, -420,  374,  322,  389, -34,  173,  374,  363, -350, -434,  76, -334,  382,  78,  165,  146, -296, -180, -336,  313,  83,  404,  09, -170,  359,  208,  450, -226, -43,  211,  64,  390,  437,  239,  279, -96,  264,  153,  119,  414, -429,  47, -419, -195, -375,  246,  451, -170, -82, -32, -05, -499, -128, -144,  184, -269, -83,  134,  357, -274, -155,  273, -384, -218,  364,  395, -462,  128,  401, -491,  395,  472,  57,  476, -222,  182, -426,  81, -136,  345, -451, -288,  346,  273,  68,  30, -144,  485,  16,  65, -288, -287, -161, -172,  348,  55,  76,  386, -316, -23, -252, -421,  301,  305, -93, -69, -13,  333, -487, -296,  178, -86, -84,  377, -312,  484,  259,  396, -178, -224, -38,  34, -11, -347, -286, -163,  208,  290,  76, -256,  119,  324,  175, -79,  481, -66,  352,  320, -232,  365, -476, -202,  132, -60, -325,  320,  277,  435, -432, -401,  63,  30,  485, -96,  183, -301,  242,  244, -158,  170,  488,  461,  346,  164,  234,  327, -402,  87,  147,  218,  304, -476, -483, -64, -36,  44,  108, -259,  331,  177, -160,  246,  59, -175, -349,  95,  377, -255, -161,  71, -233,  179,  384, -387,  195,  119, -208,  294,  58, -209,  364, -138, -185, -267, -349, -368, -370, -389, -127, -187, -360, -434, -440,  200,  243, -289, -205,  120,  308,  486,  43, -425,  165, -72, -312, -139, -453,  332,  07,  105, -377,  223, -181,  291,  457,  322,  423, -61,  434,  148,  252, -426,  214,  312, -374, -42, -125,  273, -70, -317,  259,  474, -242,  277, -98,  298, -10,  301,  482, -151,  258, -42, -76, -423, -251,  233,  400,  24, -328, -314, -328,  425, -240, -261, -411,  239,  197,  317,  12, -21, -500,  124,  305,  111,  253, -293,  261, -257, -140,  244,  444, -382, -298, -132,  48,  303, -46, -52, -173,  126,  486, -01,  403, -254,  238, -155,  485,  287, -338,  350,  119, -338, -26, -76, -375, -273,  484,  387,  322, -156,  131, -382,  315,  333,  338, -137,  488, -208, -337, -185, -229, -351, -334, -326,  247, -243,  19, -415, -104, -467,  435, -485,  48, -91, -60,  173,  488,  276,  60,  310, -28, -309, -220, -213, -124, -382, -498,  216, -89, -335, -469,  182,  166,  50, -292, -86,  307,  228,  351, -297, -387,  286, -281,  161,  47, -489, -165,  387,  287,  395, -451, -241, -61, -171,  399, -333, -53,  401,  384,  358, -81, -233,  392, -63,  317, -399, -297,  124, -319, -446,  328, -206, -308, -101,  456,  239, -90, -209,  478,  49,  38, -473, -340, -171, -144, -89, -03,  304,  165,  233, -486, -64, -500,  407,  373, -330, -492, -423,  294,  41, -369,  474,  335, -176,  225,  291, -85, -13, -66,  246, -112,  473,  273,  49, -198, -18, -188, -349, -214,  477, -264,  152, -87, -263,  411,  139,  259, -229,  216,  405,  312, -301, -268,  148,  375,  457, -61,  143, -55, -274, -111,  333, -301, -338,  234,  353,  144, -101, -143, -218, -124,  93, -213, -358, -318, -302,  281,  441, -30,  349,  347, -218, -452, -421,  430, -224, -112,  222,  419,  333,  448, -192, -481, -01,  322, -395,  204, -33,  04, -439, -399, -267, -493, -112,  227, -311,  87,  360, -17, -91, -439, -170,  191, -39,  261,  474,  237, -351, -452,  156, -165, -152,  464,  206, -301,  287, -337,  403,  106, -480, -183,  207,  105, -176, -52, -168,  365, -113,  44, -152,  296,  105, -470,  339, -434,  291,  313,  304, -207,  361,  312,  480, -291,  277, -462,  260,  416, -299,  164,  22, -279, -167,  81,  326,  157, -471,  10,  374, -84, -94, -277,  64, -489, -247, -96, -70, -103,  69,  86, -458,  283, -102, -478, -156,  27, -440, -395, -57,  113,  269, -183,  335, -398,  399, -487, -389,  428,  376,  485,  197, -218,  60,  113,  146,  314, -483, -424,  63,  439, -486,  105,  222,  264,  479, -434, -208, -461, -329, -413,  152, -208, -95,  339, -106, -196,  353,  357,  84,  229, -305,  133, -137,  255,  99, -491,  421,  116, -63, -16,  407, -49, -59,  129,  68, -80,  196,  360,  311, -281, -201,  316,  12,  204,  155, -242, -140,  360, -384, -203,  441,  163, -218, -195,  270,  381, -186,  192,  350,  252,  28,  257,  55, -178, -113, -377,  242, -65, -165,  406,  154,  487,  222, -334,  191, -123, -75, -96,  90,  393,  201,  31,  408, -165, -312,  178, -283,  03, -130, -433,  107, -249,  324,  14,  73,  63,  490,  167,  498, -175,  73, -495, -188, -205,  23, -144, -475, -200, -388,  115, -307,  313, -02, -47,  00,  187, -368,  217,  42,  354,  284, -351, -395,  461, -485, -470,  24, -495,  198,  375,  183, -229,  380,  495,  67, -97,  203,  444,  204,  315,  411, -251,  480, -91,  203, -19, -52,  335,  50,  490,  189, -165, -09, -353, -204,  07, -323, -328,  12,  375, -453, -305, -01, -221,  43, -434,  183,  98, -138,  239,  266, -227,  488,  246,  182,  191,  79, -17,  378, -370, -27,  420,  317,  465, -433, -35,  324,  96,  137, -164, -28, -463,  384,  471, -184,  279, -111,  499, -123, -397,  238, -357, -124, -421, -258, -90, -378, -327,  393, -147,  155, -133, -227, -28,  184,  192, -211,  360, -212, -221, -304, -388, -184, -68, -65,  132, -289, -324,  484,  441, -221, -426, -416,  155,  05,  178, -82,  128, -296, -189,  481,  359, -470,  106,  184, -434, -202,  473,  426,  438,  104, -25, -97,  420,  407,  338,  405, -29, -485,  389, -88, -206, -185,  348, -198,  321,  379,  220,  301, -417, -117,  282, -206, -86,  240,  478,  332, -110, -196,  259, -172,  408,  86,  231, -319, -07,  422, -414, -184,  437, -173, -420,  83,  494, -219, -263,  315, -340,  457,  116,  95,  193,  250, -259, -393,  342,  72, -209, -268,  376, -450,  61, -364,  136,  144,  169, -18,  66,  255, -350,  355, -66, -269,  291, -71,  364, -472,  96, -124, -162,  65, -177, -469,  167,  64, -10,  10, -364,  281,  242, -136, -316,  155,  01,  320, -200,  22,  154, -282,  130, -343, -74, -436, -112, -283,  345,  104, -255, -58,  480,  83, -141, -197,  114, -474,  367, -396,  36, -496, -262, -221,  220, -78,  434,  73, -258,  86, -404, -251, -343,  226, -94,  83, -358, -354,  300,  488,  250, -455,  282, -418,  481, -359, -115,  95, -333,  104, -448,  204,  460, -210, -165,  181,  212,  121, -246, -194, -292, -150,  407,  217, -72,  165, -200,  71,  311, -48,  59,  413, -03, -159,  495,  330,  334, -120,  278, -499, -163,  330, -443, -203, -28,  244,  478,  36, -134,  85, -306,  426,  435, -398,  143,  216,  267, -205, -213,  431,  247,  346,  344,  96,  39,  340, -73,  225,  72, -295,  226, -239, -113, -364,  59,  359,  380,  389,  247, -254, -26,  441,  24,  262, -457, -333, -22, -337,  314,  265, -406,  61,  463, -210, -342,  354, -18,  437,  79, -93, -358,  157,  168,  381, -355, -273, -408, -474, -31,  339,  124,  443,  280,  01,  205, -324, -480, -317, -161,  335, -200,  285, -104,  115, -425,  406, -31,  410,  343, -100, -183,  485, -442, -163, -282,  55,  65, -190,  433, -114, -351,  58, -171,  430, -89, -113, -42, -69,  70, -351, -234, -277,  434,  163,  338, -139,  69,  160, -229, -87, -440,  440,  250, -30, -222,  469, -474, -305,  131,  459,  81,  281,  369,  410, -437, -220, -203,  21,  212, -280,  170, -170,  295,  456,  493,  485, -183,  415,  145,  441, -172, -442, -267, -70,  28,  11,  251,  406, -442, -117, -282,  139, -336, -61,  402,  79, -428,  51, -48, -364, -377, -26, -34, -230, -70,  312, -244, -401,  227, -247, -108, -93, -189,  126,  337, -308, -11,  89, -402,  48, -176,  168,  39,  340, -392,  293, -81,  32, -155,  371,  168,  320, -155, -366, -409, -373,  446,  199, -274, -475,  452,  471, -68, -236,  97, -230,  308, -62, -289,  406,  486,  387,  427,  378,  227, -113,  171, -02,  419, -132,  221,  87,  41, -434, -427,  484,  45, -128,  183, -377, -103,  487, -406, -318,  103, -457,  304, -89, -18, -133,  170,  320, -246,  97,  198, -167, -164,  222,  331, -245, -410,  52, -306,  131,  470,  119,  115,  15, -157,  150,  490, -407,  138, -415, -225, -259, -20, -421, -495,  462,  298,  175, -365, -448, -228,  333, -115,  460,  407,  68, -285,  498, -380,  261,  481, -410, -120,  449,  457,  224,  99,  447, -331,  89, -116, -56, -317, -283,  375, -312,  31,  173,  363,  166, -423, -13,  352,  314, -53,  259, -118, -486, -391,  02,  275, -409,  444,  07, -460, -247,  83,  491,  52,  252,  81,  437, -304, -384, -346, -77, -196,  185, -52, -333,  204,  25, -494,  56,  191,  305,  167, -427,  319,  277,  427,  94,  368, -277, -399, -240, -24,  185, -249, -119, -63, -316,  170,  486, -200,  324,  261,  104,  361, -290, -377,  417, -413, -19,  325,  279, -214, -07, -296, -395, -230, -16, -449, -10,  207, -347,  250,  36, -310, -499,  417,  479,  38,  87, -183,  338,  263, -421,  295,  476,  141, -230, -254,  228,  252, -429,  359, -462,  64, -84, -04,  334,  400,  47, -176,  459, -448, -74,  347, -258, -72, -384,  74, -182, -445,  391, -344, -330,  470, -197, -353,  463,  74,  245, -456,  178,  316, -245, -432, -119,  171,  64,  67,  423, -388, -256,  383,  16,  170,  230,  259, -50, -301, -167,  268, -246,  76, -223, -75,  399,  80,  424,  362,  06,  169, -242, -316, -15,  14,  105, -282, -315, -331, -362, -391,  133, -118, -156, -350, -96, -74, -239,  355,  125,  446,  475,  380,  374, -248, -195,  273, -315, -271,  136, -457, -250, -254,  80, -413,  260, -315, -194,  446,  206,  296, -93,  192,  30,  251, -306,  434, -323, -45, -359,  303,  253, -383,  183,  127,  221, -160, -99, -242,  421, -111,  154, -329,  135, -266, -242, -104,  271,  416,  194,  329,  212, -399,  21, -258, -296,  215,  29,  233, -330,  170,  36, -225, -361,  71,  403, -287, -237,  156, -29, -316, -103, -23, -145, -116,  211,  114, -368,  334,  30, -322,  164, -257,  131, -315,  337,  335,  401, -134,  69, -77, -463, -43, -449,  28, -119, -194,  241,  144, -186, -287,  329,  211,  190, -316, -53,  254,  298,  80,  440,  181,  258,  104, -224, -110, -358, -387,  77, -105,  332, -354, -330, -279,  456, -279,  249, -163,  27, -09,  481,  341, -444,  310,  404, -402,  495, -148, -296, -355, -216, -355, -322, -458, -399, -46,  284, -257,  420, -138,  490, -396,  360, -339, -175,  316, -118, -74, -347, -238,  417, -365, -45, -175, -203, -140, -76,  144, -436,  480, -358,  200, -375, -180,  242,  79, -373,  379,  322, -101, -259, -335,  355, -47, -174, -320, -230, -440,  106, -77, -178,  376,  410, -370,  53,  60,  342, -171, -296,  406, -190, -154,  106, -65, -481,  200, -486, -02,  431, -311,  397, -328, -146,  252,  126, -468, -216, -252, -408, -258, -477,  267, -30, -214,  397, -476,  346,  239, -147, -450,  497,  163,  249,  455, -49, -380,  155,  317,  118,  87, -142,  367, -389, -436,  471, -411, -404, -245, -163,  41,  349, -139, -192, -180,  147, -295,  196, -07,  444, -99,  395,  441, -83,  496,  396, -280, -384,  403, -463,  234,  342,  248,  101,  454, -336,  72, -105, -239, -321,  233, -346, -119, -54, -38, -447, -55,  167,  249, -210,  111, -350, -315,  404,  67, -318, -348,  287,  150, -445, -323, -115, -250, -223, -162, -296, -59, -237,  451, -446,  294,  184, -292, -325, -18,  170, -272,  427,  189,  477, -283,  152, -20,  255,  56, -101, -211,  208, -313,  439, -384,  216, -176, -134,  493, -485,  422,  286, -222,  373, -307, -428,  410, -99, -252, -108, -76,  328, -180, -387, -342,  389,  266,  138,  144,  174, -463,  433,  235,  76,  373,  351,  144,  49,  69,  489,  64,  343,  276,  342, -432,  469, -233,  478,  222,  367,  223, -02,  195, -105,  112,  353, -216,  230,  343,  429, -96, -267, -286, -361, -339, -413, -158,  306,  489, -237,  295,  53, -42,  423,  248,  27, -256, -133,  357,  467, -266,  80,  317, -219,  475,  281, -13,  112,  11, -170,  41, -232,  415,  255,  259, -423, -305, -46,  383, -316,  217, -470, -411, -324,  454, -311, -445,  50,  56,  412,  369,  290, -07,  187, -428,  320, -32,  411, -68,  480, -259, -175,  100, -343, -67, -141, -266,  128,  313, -31, -336,  383, -01, -247, -89,  305, -57, -34, -144, -149,  230, -275, -358,  75, -236,  66, -104,  233, -23, -320, -435, -430,  06,  165,  79,  439, -476, -335,  419, -310,  134, -65, -427, -14,  188,  336,  143, -17, -198, -149,  335, -116,  77, -171,  460,  341, -253,  208,  426, -424,  388,  491, -354,  246,  156,  226, -463, -467, -257,  456,  75,  378,  243, -500,  216, -68,  336, -141, -233, -10,  211, -46,  374,  140,  283, -314,  333, -118,  394,  260, -42,  283,  251,  457,  29,  260, -465,  419, -355, -222,  375, -428,  08,  119, -428, -276, -97, -240,  436, -478,  250,  147, -23,  476,  139,  112, -337, -28, -153, -443,  84,  305, -308,  188,  262, -426, -52, -351,  493,  445, -72, -280, -483,  436, -309, -59,  13,  94,  201, -51,  469,  303, -52,  298,  279, -413, -90, -206,  411,  257,  204, -04,  415,  396, -316, -471,  470,  484, -321, -185, -219,  459,  36, -202,  395,  227, -409,  260,  174,  292, -291,  495,  95,  157,  293,  226,  244,  55, -479,  156,  165, -423,  04,  80,  473,  188,  461, -204, -476, -08,  111, -195, -49, -01,  455,  199,  79, -454, -41, -247, -310,  169, -252, -363, -174, -107,  363, -77,  448, -264, -69,  113, -187, -213,  45,  139,  475,  07, -213, -149,  499,  398,  156,  303,  250,  111,  02, -171, -491,  461,  434,  51,  482,  34,  188,  161,  427,  403, -64, -273, -08,  367,  341, -343,  06, -114,  296, -19, -255, -417, -316,  97, -166,  340, -100, -416,  303,  402,  265, -336, -285,  199,  215, -302,  85, -97, -289,  12, -194,  147,  239, -350,  366,  432, -192, -128,  171, -396, -295,  416,  40, -111,  365, -274,  81, -235,  162, -116, -333, -73,  48,  235, -22,  115, -215, -437, -482, -04,  427,  176, -05, -482, -321, -139, -197, -13, -415,  474,  443,  142, -258, -17, -469, -392, -439,  112, -127,  223, -152,  393,  02, -252,  480,  480,  363, -235, -105, -267, -387, -178, -239,  108,  193, -60, -179,  496,  427,  258, -178,  371, -100,  64,  206, -69, -476,  268, -105,  250,  343, -405,  143, -154, -157,  475, -174,  58, -260, -426,  291, -147, -104, -96, -187, -59,  345,  486, -63, -376,  244,  259, -153, -356,  176, -446,  427,  200, -326,  174, -50, -483,  269, -55, -137, -36,  272, -458, -478, -488, -384, -335,  217,  364,  69, -118, -194,  266, -132, -405,  391, -388, -293, -262,  108,  383,  144,  387,  435, -330,  61,  238, -312, -170,  35,  403,  294, -192,  445, -332,  172, -87, -167, -110, -222,  403,  272,  436,  169, -07, -117,  412,  457,  90,  03,  66,  325, -353, -47, -387, -182, -133,  351,  358,  197, -114, -387,  344, -454, -89, -488,  219,  324,  198, -39, -46,  101,  85, -110,  122, -422,  274,  387, -464,  216, -110,  454,  42,  389,  259, -493,  59, -374,  358, -83, -324,  96,  383, -480,  143, -206, -116,  214, -382, -418, -325,  425, -465,  260, -185, -490, -309, -59,  397, -273,  10,  139,  33, -96,  28, -208, -89, -412,  271, -231,  357,  447, -283,  240, -181, -288, -466,  203,  426,  05, -362, -399, -70, -327, -286, -403,  35, -95,  391, -68,  484, -99, -77,  17,  305,  452, -339, -284, -108,  432, -15, -251,  379, -446,  490,  50, -233, -124, -246, -307,  381,  244,  147,  163,  417,  361,  261, -47,  118,  152, -263,  102, -95,  161, -29, -290,  113,  132, -74, -495,  417, -237,  106, -352, -183,  96,  199,  84, -175, -195, -370,  58, -451,  277, -278, -182,  490, -165,  271,  108,  487, -139,  62, -108, -478, -115,  454,  487, -483, -120, -156, -214,  495,  450, -65, -188,  399, -14, -251, -276,  291, -121,  282, -308,  08, -144,  10,  350,  191,  134,  310, -470,  495, -128,  274, -483,  257,  228, -144, -374, -392,  200,  265, -45, -498, -300,  268,  401, -462, -131, -23, -319, -400,  112, -127,  108,  468, -265,  310,  160,  369,  120,  190,  364, -156, -35, -267, -47, -307,  441,  431,  154,  141,  196, -391,  496, -252, -271,  397, -214,  98, -125, -33,  198, -161, -308,  158, -193, -72,  320,  467, -203, -60,  158,  14,  284, -25,  247,  89, -480,  189,  21,  174,  182, -283, -364,  178, -34,  217,  428,  252,  168,  155,  72, -134,  494,  264, -123, -199, -308, -303, -231, -10,  490, -221, -496, -374, -394, -397,  216, -374, -356, -263, -347, -321, -46, -211,  357, -228, -494,  285, -475,  174,  292,  97, -107,  286,  213, -378, -412,  406,  171,  209,  248,  161, -160, -396, -360, -54,  59,  356,  72,  204, -55,  225,  383,  399, -134, -408, -328,  225, -270,  49,  251, -478, -02, -356,  309, -289,  118, -251, -383,  142, -190, -283, -197,  150, -179,  295, -52,  381,  151, -128,  437, -404, -402,  320, -152,  316, -236,  372,  41, -06, -79, -207,  17,  419,  289,  178, -18,  260, -221,  100, -98,  89, -331, -443, -261, -09,  353, -461,  224,  356, -89,  161,  453,  361,  333,  153,  178, -403,  25,  71,  92, -202, -284, -39,  69, -142, -09, -449, -382,  270, -497,  372, -141, -327,  429,  450, -484, -366, -159,  240,  491,  252, -99, -204,  114, -266, -199, -208, -169,  326, -285, -225, -24, -68, -412, -455,  290,  79, -52, -240,  201, -48, -368, -88,  477, -87,  214,  493,  48, -445,  233,  391,  308, -366, -313, -78,  220, -12, -434, -97,  166, -219,  179, -358,  213, -381,  39,  355, -449,  487, -385,  252,  291, -253, -335,  268,  161,  379,  261,  61,  435, -06, -48,  243,  480,  491,  17,  200,  331,  435, -44, -03, -284, -13,  491, -218,  106,  30, -11,  157,  369,  105, -90,  161, -296,  427, -71, -283,  306,  43,  278, -407, -111,  82, -312, -130,  73, -443, -78, -96,  492,  378, -247,  61, -135, -256,  343,  472, -374,  184,  481,  496, -211, -109, -491, -06,  170,  290, -437,  329, -167,  342,  422, -425, -76, -389, -55,  498, -332,  367,  254,  13,  246, -492, -426, -37, -248, -231, -65,  231,  453, -83, -421, -257, -340, -412, -411, -317, -270, -348, -488,  416, -154,  434,  491,  271, -103, -64, -379,  418,  155, -273, -69,  253, -265,  05, -283,  340, -374, -496,  423, -421,  273, -498,  174, -214, -58,  263, -31,  172, -232, -19,  440,  466, -85,  431, -411, -335,  219,  62, -417,  227,  290,  366, -20, -123,  223, -451, -283,  349, -446, -08,  428, -321, -06,  455, -35, -212, -430,  434,  461, -162, -85, -247,  157, -317,  37,  246, -152, -244, -191,  283, -165, -401,  149, -332, -24, -128, -283, -454,  73,  123,  38,  353,  303, -115,  308, -232,  173,  379, -297,  486,  69,  470, -260, -274,  05,  277,  473,  353, -115, -218,  488,  221,  233,  489, -259,  61, -139, -42,  107, -214, -418, -02, -360, -263, -265,  448,  05,  408, -321, -440, -253,  249, -117,  339, -173,  388,  116, -200, -406, -147,  434, -418, -74,  167, -428,  167, -271,  285, -22, -312, -428,  412, -462,  64, -351, -227,  12, -494,  34, -456, -81,  281,  293,  302,  120, -28, -458,  88,  273, -364, -207, -441,  71,  220, -421,  495,  239,  160, -368, -283, -300,  56, -371, -261, -380,  130,  364,  485,  137, -102, -471, -444,  31, -326, -290,  03,  146,  104, -57,  271, -407,  237, -317,  164,  309, -238, -489,  48, -226, -05, -382, -26, -448,  99,  213,  24, -270,  430,  361, -281, -172, -258,  127, -288,  268, -311,  215, -85,  293, -341,  38,  386, -252, -427,  402, -443, -165, -235,  457,  461,  261, -425, -64, -335,  175,  01,  189, -243, -69,  403, -24, -388, -355, -45, -176,  414,  144, -109,  181, -63,  50,  71, -176, -350,  145,  78, -293, -168,  344, -335, -206,  105,  92,  230,  270,  119, -269,  311,  376, -485,  214,  204, -373,  360, -341, -49,  274,  303,  342,  307,  93,  245, -122, -231,  395, -477,  347, -45, -144,  191,  120, -498, -204,  64,  232, -82, -316, -185, -270, -88, -170, -204, -383, -43, -344,  128, -240, -218,  284, -45, -411, -123,  52,  320,  146, -53,  343,  345, -246,  51,  37, -274,  53, -315,  291,  137,  456,  475,  453,  38, -113,  135,  334,  356, -55, -157, -15, -443,  477, -231,  12, -81,  498, -436, -261,  496,  364, -418,  341, -382,  486,  230, -155,  39,  416, -364, -323, -276, -37, -18,  262,  350, -31,  96, -441,  414, -209,  44,  472, -231, -335,  336,  188, -337,  401,  427,  11,  265, -139, -148, -265,  199, -65,  80, -261,  203, -432,  268,  427,  31,  102,  189,  234, -429,  137,  293,  486,  429,  189, -190,  50,  354, -354, -262, -131, -101,  17,  380, -336, -270,  84,  252,  430, -481,  184,  21,  222,  253, -211,  149,  136,  391,  190, -130, -186, -172,  15, -200,  109, -296,  462,  11, -442, -391, -399, -73,  08,  118,  159, -475, -300, -256, -371, -370,  115,  313,  151, -162,  66, -208, -161, -297,  35, -470,  425,  350,  210, -59, -350,  171,  145, -35, -318, -444,  74, -217, -17, -66, -247, -05,  311, -47, -409,  440,  84,  206,  254,  87, -104, -180,  380,  236,  375, -85, -382, -347, -235, -320,  94,  268, -297, -261, -267, -115,  147, -341, -480, -17,  93, -227,  478, -95, -422, -431, -155, -486, -373, -49,  102,  24,  272,  334,  112,  499,  101, -418, -348, -281, -238,  246,  487, -35, -162,  72, -298, -163,  231,  74,  320,  176,  347,  298, -67, -223, -281, -369, -208, -153,  82, -254, -277,  206, -68, -313,  206, -467, -231, -290, -248,  383, -191,  91,  200,  499,  15, -246, -164, -254,  328, -343, -225, -473,  455,  208, -196,  27,  339,  448, -274,  274, -306, -51, -20,  126,  488, -314, -488,  109, -103, -236, -08,  206, -292,  44, -443,  223,  298, -107, -178,  478,  50,  97, -495,  358,  157,  161, -115,  349,  110,  463,  123,  304,  264, -397,  283,  252, -210,  295, -139, -461, -89, -295, -403,  119, -399, -346,  195, -249,  47, -483, -271, -50,  114, -266, -192,  123,  395, -455, -28,  357, -492, -405, -486, -376, -301,  297,  376,  341,  444,  89, -268,  207,  294, -171,  179, -253,  335, -126, -02,  234, -109,  227, -316, -143, -187,  344, -168,  60, -259,  305, -82,  101,  400, -68,  225, -49, -271,  453, -208,  25,  42,  24, -268,  188, -295, -237,  435, -460,  137, -67, -373, -120,  12,  163, -411,  325,  08, -78, -114, -399,  79,  304, -445,  331, -264,  280, -217,  317, -414,  427,  194,  128, -48, -222, -183, -491,  42,  104, -98,  31, -110,  29,  412,  402, -308, -147,  228, -448, -373, -34,  06,  206, -230,  61,  38,  358, -159, -327, -473, -73, -400,  221, -92,  404,  499, -423, -234,  41,  181,  168, -427, -77,  49, -163, -174, -407, -458, -94, -354, -330,  372,  152, -272, -06, -287, -382,  204,  406, -209,  231,  186,  244, -48, -54,  148,  303,  23, -234, -155,  56,  434,  270,  480, -17, -41,  158,  77,  01, -436, -425, -477, -212, -421,  104,  282, -208,  222, -14,  50, -134,  69,  88, -38, -479, -466, -38, -324,  409,  229,  21, -34,  163,  143,  298, -01, -398, -44, -72,  456,  372,  03,  479, -340,  82,  83,  442, -274,  158,  280, -372, -124, -151,  217,  338,  222, -397, -200,  398, -487, -471,  272,  331, -455, -85,  129,  44,  370, -63, -176,  326, -191,  327,  305, -31,  261,  241,  263,  487, -101,  43, -33,  275,  392, -316,  465,  466, -212, -235,  364,  153,  147,  136, -16, -456, -448, -35,  440,  422,  402, -236,  248,  63, -409,  405, -116, -296,  498, -353, -309, -103, -458,  158,  24, -214, -305,  341, -248,  335, -393, -384, -12, -394,  253, -176, -350, -343,  289, -410, -69, -457, -146,  31,  458,  297, -64, -158, -499, -65, -11,  44, -316,  383,  54, -439, -331,  249,  402, -79,  436, -139,  389, -76,  319,  494,  248,  469, -349,  389, -89,  82,  432, -383, -35,  390, -234, -246,  84,  119, -459, -75, -337, -275, -192, -430,  138, -23, -329,  41, -250, -392, -246, -360,  384, -426, -366,  485, -105, -214,  374, -341, -280, -341, -224, -462, -99,  395, -208,  486,  14, -167, -89, -470,  58,  220, -400,  49,  49, -229, -58,  300,  231,  196,  440,  116, -378, -74,  453,  18, -436,  327,  177, -215, -162, -195,  175, -408, -300,  467, -422,  215, -200,  341,  245, -290,  413, -303,  259, -37, -32, -299,  115,  52, -250,  55,  20, -128,  481, -27, -258, -454,  152,  419,  183,  491, -275, -142, -417,  277,  177,  13, -08,  477, -146,  89, -313,  120,  286, -201, -417, -245,  352,  198, -341, -398,  105,  179,  327,  438, -348, -431, -164, -344,  489, -129, -01,  66, -419,  82, -157,  258, -53, -312,  235, -346,  277, -225,  274,  64,  74, -291, -329, -74,  407, -170,  29,  364, -139, -144,  302,  13,  277, -361, -479,  266,  362,  21,  184,  444, -45, -120,  202,  403,  68, -62, -91, -155, -435, -317, -239,  139, -108, -68, -83,  151, -386,  446,  15, -25,  154,  169, -160, -68, -340, -138,  50, -477, -265,  87,  467,  190,  467,  169,  445,  387, -41, -146,  84,  376,  37,  346,  15, -219,  130,  433, -216, -403, -269, -349,  424, -262,  321,  117, -478, -167,  479,  424, -144,  66,  11,  175, -244,  330,  197, -298,  217,  08,  56,  154, -115, -54,  00,  400, -421, -18, -315, -136,  431,  269,  367,  356, -493, -460, -27, -119, -126,  304, -195, -418, -130, -331,  258,  126,  499,  307, -320, -431, -185, -411,  223,  200,  387,  75,  453,  466, -91, -10,  182, -159, -241,  50, -303,  118,  90,  170,  499, -184,  326, -195, -101, -304, -26,  09, -326,  325, -184,  207,  394,  131,  296,  117,  184,  183,  44,  137, -499,  454, -21,  184, -205,  239, -266,  344, -143, -324,  14,  209, -07,  192, -486,  392,  388,  340,  253, -86,  165, -431, -379,  412,  200,  417,  381,  236,  452, -74, -127,  454, -120, -295,  490, -473,  444, -276,  371,  153,  252,  237, -138, -255, -71,  228, -11,  169,  420, -258, -417,  86, -189, -295, -02, -136, -26,  231, -400,  279, -343,  326, -415,  389, -117, -425,  416, -173, -201, -361, -168, -97, -272, -453,  149,  157,  275, -10,  178,  196, -415,  262,  134,  248, -181, -16, -36, -355, -285,  417,  424,  225,  243, -139,  114, -374, -64,  383,  305, -413, -126, -11, -09,  103,  36, -08,  112,  164,  482, -209,  212, -81, -447,  198, -332,  224, -318,  132,  369,  249,  49, -354, -26,  144,  07, -59, -378, -204, -176, -221, -117,  198,  269,  374, -199,  157,  218, -234, -179, -447,  57, -467, -28,  462, -417,  492,  186, -235,  125,  407, -133,  26, -95,  341,  23, -235, -218,  497,  61,  458, -223,  444, -491, -102, -329,  162, -445,  389,  428,  229, -206, -15, -386,  267, -53, -302,  259, -367,  315,  236, -107, -318,  115,  298, -476, -362, -437,  158, -13,  124,  469,  264,  421,  478,  14, -56,  140,  422,  185,  69,  151,  480, -446,  265, -401,  354, -185,  358, -161, -369,  447,  232,  165,  414,  31, -459, -448,  446,  200,  39,  423,  169,  156, -304,  499, -330,  140,  139, -408, -175, -292, -405,  157,  115, -287,  256, -31,  28,  467,  308, -489, -234,  41,  177, -320, -76,  218,  84, -130,  270, -25,  145,  291, -369,  341,  290,  154,  333, -70, -402,  11,  490,  46, -332,  105,  259, -223, -426,  139, -256, -265, -497,  10,  276, -468, -458,  52,  250,  126, -226,  373, -399,  420,  164,  85, -387,  307,  91,  447,  89, -459, -42,  79,  87,  478,  37,  198, -245,  463, -162,  351, -302,  193,  213, -174,  225,  255,  378, -25,  233, -347,  200,  335, -75, -135,  272,  38,  24, -137, -15, -387, -96, -205, -456, -156, -226,  81, -458,  381,  397,  232,  233, -405, -75,  298,  274, -350,  54,  152,  478, -213, -343,  178, -26,  82, -105, -254, -27,  419,  461, -190, -116,  218,  106, -71, -438, -268, -138, -44, -35, -241, -311,  50, -145,  114, -151, -19, -383, -245, -367, -405,  394,  143, -375, -131,  77,  21,  467, -450,  292, -219,  213, -323,  499,  171,  106, -87, -245,  468,  369,  220,  80, -442, -229, -213, -475,  472,  268, -358, -273, -247,  89, -379,  396, -434,  342,  326,  439,  310, -272,  232, -409,  441, -239, -58,  112, -281,  355,  367,  39,  224,  88, -381, -365, -289, -94,  12,  35,  26,  154,  262,  280,  95, -265, -472,  161, -422,  354,  101,  388, -417,  185, -169, -476,  446, -375,  489, -335,  480,  356, -444, -444,  296, -324,  43, -141,  434, -445,  394, -39,  209, -492,  93,  156, -256,  121, -182, -178, -24, -229,  62,  411,  456, -255, -213, -246, -130, -224,  271, -150, -15,  327,  258,  133, -145, -198,  493,  142, -143,  387, -397, -81,  396,  196, -73, -08,  169, -403,  314, -355, -132,  228, -92,  176,  473, -452,  430, -157,  176, -447, -455, -339,  381, -345,  295,  88, -43,  288, -270, -333, -473,  185,  438, -225,  233, -135,  267, -97,  315,  433,  400, -317,  161, -191, -288,  486, -143, -06,  181, -467,  48, -422,  47,  281, -266, -158, -131, -457, -18,  452,  62,  361,  137,  00, -11, -129, -282,  108,  274, -467,  42,  174,  68,  55, -165,  280,  42,  192, -225,  75, -422,  323,  154,  477,  104,  388,  171, -175,  431,  05, -223, -06, -134,  415, -154, -293, -214,  416,  316, -88, -199,  210, -414,  370,  117, -78, -498,  11, -34, -223, -413,  396, -48,  241,  373, -92,  129,  396,  234,  412, -99, -489,  258, -380, -222, -43, -173,  416, -127, -05, -172,  175, -295,  267,  397,  323,  41,  399, -166, -141, -323, -79,  108,  481,  14,  333, -110, -05,  230, -24, -92, -369,  339,  18,  103, -30,  475,  431, -114,  201,  278, -433,  228, -164, -314,  125, -341, -421,  24,  345, -62, -447,  119, -454, -465, -367, -268,  277,  129,  462,  105, -111, -55, -56,  407, -451,  414, -265, -168,  153,  436, -390,  220, -484, -54, -242,  141,  457, -163, -335, -345,  275,  71, -374, -326,  458, -241,  258,  235, -260,  220, -160,  481,  17, -364, -259,  66, -449,  328, -250,  204, -384,  213,  276, -368,  11, -466,  273, -31, -129, -210,  476, -02,  361, -398, -476, -329,  213,  282, -242, -194,  354,  450, -213, -128, -413,  380, -210, -10,  208,  393, -306,  324,  106, -178,  456, -383, -144, -419,  438, -421, -128, -234,  77,  85, -132,  454,  257, -418,  236, -133, -112,  91, -182, -473, -185, -95, -240,  105,  395,  468,  350, -59, -355, -44, -385, -47,  426, -29,  387, -284,  402, -241, -17, -21, -304,  351,  285, -195, -215,  22,  173, -475, -35,  491, -447,  280,  248,  165,  237,  495,  133,  88,  288, -370, -104,  403,  436, -178,  226,  323,  39,  128, -66, -478, -41,  130, -275, -255, -212,  11,  267,  461,  36,  84, -196,  441,  216, -96,  106,  305, -101,  92, -107,  39,  222, -358, -58, -490, -36, -332,  333, -145,  296, -233,  229,  107,  398,  455,  352,  38,  318,  471,  351, -146,  55, -345,  148,  123,  411, -246, -71,  162,  346,  322, -299,  421, -184,  143,  431, -367, -337, -383, -12, -189, -116,  70,  418, -218,  377,  271, -328,  195, -406, -477, -99, -498, -322, -451,  125, -59,  156, -446, -397,  02, -271, -196,  275,  45,  447, -441,  178, -38, -324, -333,  273,  60, -411,  192, -305,  466,  315, -133,  161,  409, -109, -86,  411,  421, -36,  37,  215, -380,  91,  318,  474,  320, -377, -398, -134, -78,  13, -104,  385,  189,  415,  158,  101, -496,  202, -352,  470,  17,  368,  483, -73,  111, -102,  190,  384,  362, -273,  99, -166, -329, -82, -192, -157,  393,  262, -439,  167, -225, -42,  404, -184, -127,  415,  418, -122,  117, -82,  200, -13,  138,  184, -234, -251, -66,  456, -14,  148,  36, -63,  482, -441, -293,  142, -98, -400, -95,  316, -380,  180, -226, -476,  497,  499,  439, -233, -123,  409, -463, -70, -104,  176, -34,  162, -223,  400,  470,  263,  48,  358,  53,  382,  417,  260,  24,  172,  361, -219, -12, -167, -186,  262, -143,  163, -387,  149,  430,  343,  58, -181, -227, -194,  495,  239, -180,  125,  491, -210,  240,  39,  01, -207,  273, -82, -446,  149, -58, -233,  431,  430,  100, -255, -456,  457,  408, -342,  106, -310, -499,  16,  09,  126,  322,  357, -135, -06, -18, -144,  285, -278, -253, -214,  368, -128, -444,  422, -479, -01, -311,  452,  281,  289,  49,  326, -402,  309, -164, -443, -149, -163,  425,  361,  463,  248, -430,  180,  94,  404, -112, -121, -374,  487, -483, -154, -141, -74, -232,  232, -223,  309,  185, -442,  450,  86, -264, -451,  248,  72, -42, -401, -239, -117, -188, -276, -17, -118, -244, -422, -214,  144,  309,  265,  483, -321, -389, -158,  457,  232, -425, -266,  41, -388, -208,  344, -450,  29, -255,  298, -47,  203,  398,  215, -62, -290, -209,  422,  445,  48, -148, -269,  44, -339, -152,  28, -160, -40, -278, -203,  44,  149,  383, -415,  261,  28,  429, -336, -443, -326,  462,  362, -271, -288,  77,  168,  275,  369,  90,  220, -83, -206, -197,  461, -45,  152,  341, -352, -36, -436,  297, -492,  213,  181, -55,  327, -291,  227, -157,  118, -247, -195,  332, -17,  370, -90, -349,  145, -221, -407,  217, -452, -113, -480, -139, -306,  172, -297, -158, -364,  119, -08, -04,  184,  25,  442,  363, -414,  169, -294, -444,  422,  12,  388,  257,  234, -202, -240, -121,  429, -147, -52,  477, -408, -32, -161,  139, -07,  394, -167,  481,  365,  325, -22,  49, -150,  272, -87,  288, -59,  119,  344,  215, -17,  233, -27, -283, -469,  233,  448,  461, -61,  248, -210,  383, -283,  481,  22, -438, -273,  356, -457, -408, -467,  373,  494,  236,  145, -93,  24, -62, -122, -131, -346, -286, -398,  127,  283, -15,  212, -416,  298, -349,  332, -59, -465, -99, -78,  409, -37,  150,  265,  359, -406, -349,  232, -412,  387, -122,  347, -89,  316, -274, -368, -178,  292,  86, -199,  75, -76, -486,  159, -278, -335,  344,  163,  52, -255, -62, -38,  209, -412,  79,  68, -318,  230,  152, -229,  469, -470, -382, -119, -301,  196,  365,  373, -12, -48, -325, -436,  376, -311, -425, -50,  206,  419, -386, -241,  17,  52, -427, -274,  492, -496, -354,  26,  235,  298,  297,  204, -319, -232, -63,  232, -184, -197,  105,  305, -393,  280, -279,  483,  469,  148, -67, -472,  420,  399,  139, -63,  303,  212, -485, -353,  216, -339,  174,  303, -189,  323,  360,  344, -57,  149,  76,  260, -196, -318,  417, -89, -186, -362,  246,  136, -362,  32,  164, -442, -69, -197, -05,  87, -133,  362,  234, -65, -477, -92,  91,  187,  84, -49,  31, -473, -400, -40,  287, -95,  494, -444, -332, -192, -306,  415, -204,  185, -53,  460,  243, -270,  115,  91,  317, -166, -47,  404,  270,  329,  164, -139,  16, -252, -336, -101,  128,  116,  359,  267, -127,  353,  324,  42,  14, -130, -43,  310, -445, -244, -377, -349, -14,  238,  242,  156, -75,  47,  412, -305, -124,  428,  408, -256,  29, -428,  144, -343,  188,  355,  424, -86,  209,  248,  456, -277, -29,  265, -467,  26, -479,  08,  177,  359, -253,  271,  367,  172, -181, -369, -281,  195, -440, -373, -208,  89,  51,  436,  246,  91,  291, -478, -495,  352, -377,  461, -73,  94, -422,  313, -28, -49, -179, -350, -189,  420, -227,  30,  444,  92,  162, -337,  140, -426,  142,  432,  163, -307, -280,  261, -363, -489, -365, -358, -284, -242, -44,  143,  352,  34, -44, -175,  486,  278,  327,  149, -450, -400,  31,  495, -455, -307, -342,  185,  119, -347,  469,  134,  198, -311, -105,  335,  52,  383,  478,  268, -359, -66,  264, -154, -180, -280, -477, -194, -150, -298, -193, -99, -198,  339, -104,  199, -116,  406, -116, -496, -441,  205,  138,  258,  394, -114,  445, -53, -231,  423,  67,  262,  209, -169, -392, -118,  404, -17, -460,  106,  185, -152, -493, -160, -313,  255, -461,  71, -486,  276,  427, -75, -19,  418,  35, -124, -196, -19, -325,  425,  256,  242,  187,  318, -426, -352, -300, -170,  131, -260,  436, -183,  440, -204,  157, -373, -97,  196, -449, -83, -28,  478, -305,  454,  396, -418,  182,  52,  63,  357, -23,  172,  99,  17,  342, -475,  165, -458, -145,  148,  134, -208,  465,  427,  440,  474, -446, -157, -477, -43, -387, -05,  288,  160,  301,  184,  242, -17,  89,  158,  192, -82, -170, -208,  435, -328,  169,  452,  66, -475,  101,  52,  169,  418, -21,  109,  393,  386, -196,  416, -157, -83,  263, -369, -423,  65, -332,  320, -100, -391, -22, -407,  27, -340,  237,  315,  184, -94,  267, -250,  283, -132, -346, -48, -213,  134, -87,  32,  372,  218, -52, -285, -13, -289,  199,  417, -372, -281, -411,  381, -172,  419,  474, -293, -69, -437, -478, -385, -31, -358,  217, -247,  10,  371, -443, -351,  357, -29, -467,  229,  41, -19,  445, -120, -455,  496,  149, -327,  67,  238, -94, -253, -491,  232, -46, -60,  295,  329,  55,  117,  471, -228,  370,  333, -356, -221,  483, -499, -398, -484,  231,  495,  350, -472, -124,  395, -124, -475, -80,  443, -384,  327, -310, -375,  59,  496,  66,  207,  325, -379, -176,  296,  246,  46,  130,  390,  325,  465, -257, -220, -167, -174, -225, -317, -146,  151, -70, -418, -471, -297, -475, -03, -470,  67,  122,  441,  64,  40, -500, -111, -486, -176,  38,  260,  370, -332, -498, -452, -367, -255, -172, -34,  72,  103, -498, -222,  107, -68, -139,  488,  135,  238, -15, -483, -194, -41,  459, -278, -148,  459,  111, -134,  136, -351, -374,  358,  169, -372,  406,  302, -127,  86,  121, -203, -310,  123,  76, -351, -93,  437, -363, -457,  175,  474, -440, -167,  285, -129,  55, -363,  183,  19,  03,  171, -480,  481,  29,  190, -391, -64,  344,  335, -478,  317, -16,  64, -60, -440, -435,  348, -151,  54, -257, -123,  28,  155,  210,  166, -473,  118,  303, -438, -363,  159,  233,  09,  140, -238,  51, -398, -450, -104, -211, -75, -287,  273, -159, -494, -314, -93, -294,  387,  461, -51, -236,  342, -396, -173,  08, -17, -203,  163,  397, -66,  174,  130, -205, -185, -255,  347,  269, -205,  95, -90, -428, -340, -317, -86, -334,  221,  321,  224,  109, -366,  25, -275, -172,  482,  52,  336, -35,  349,  352, -137,  135,  26, -155, -217, -307,  90, -370, -186, -262,  225,  224, -190,  385, -240, -424, -96,  481, -251, -372,  442, -116,  154, -332,  212,  136, -428,  401, -47, -226, -395, -332, -239,  131,  14,  44, -323, -44,  174, -09,  194,  251,  68, -143,  137,  328, -67, -459, -339, -465,  21, -396, -81, -325, -228, -17, -337,  196,  236,  117,  470,  341, -363, -268,  325, -497,  276, -498, -40,  303,  345,  06,  54, -87, -285,  43,  93, -499,  84,  255, -464, -42,  359, -45,  133, -17, -210, -351, -321, -473, -382,  02, -280, -245,  234, -455, -241,  362, -101, -429,  165, -255,  429,  72, -490, -355, -385,  104, -354, -448, -141, -318,  10, -282,  489, -05, -447, -221,  144,  84,  158,  262, -414,  379, -130, -328,  424,  481, -113, -176, -448, -96,  421, -167,  476,  431, -22, -408,  35,  124, -04,  394,  306, -494, -36, -353,  01,  369, -73, -354, -46, -63, -240,  392, -184,  482, -435,  93,  463, -48,  417, -133,  356,  338,  201,  333, -379,  31, -223,  157, -344,  273,  403, -186, -369,  220, -38,  132,  89, -259, -370, -105,  178,  243, -212, -153,  225, -147,  440, -459,  305,  357,  260, -487, -453,  313, -302,  20, -155, -25, -323,  353,  100, -67,  19,  231,  05,  481,  216, -406,  74, -302, -10,  105,  441, -370,  452, -481, -17,  392, -88,  140, -399,  24, -495, -352,  190, -296,  168, -113, -469, -302, -260,  132,  483,  259,  215, -12, -407,  283,  434, -481,  482,  276,  124, -225,  406,  76,  146,  241, -32, -90,  233,  69,  435,  239, -431,  477,  443, -410, -136,  474,  140,  104,  458,  123,  215, -474, -37, -340, -339,  249, -320, -05,  26,  304, -377,  284,  233,  269,  378, -299,  32,  111, -377,  319, -150, -308,  296,  145,  134, -340,  472, -226, -384,  430, -251, -317, -192, -436, -156,  322,  314,  376, -183,  192, -468, -60,  328,  265,  62,  206, -181, -406, -182, -58, -235, -480,  486, -439,  166,  473,  73,  138, -253,  189,  420,  349,  372,  81,  413,  68, -97, -421,  296,  220,  271,  329,  13,  452,  446, -73,  158, -235,  373, -172, -441, -362, -151, -102, -301, -133, -129,  272, -143,  470,  313,  129,  319, -463, -290, -415,  458,  113, -336,  254,  186, -212,  83,  51,  92,  30, -170, -250, -353, -297,  79,  59, -159, -220,  457,  392,  499,  180, -484, -144,  150, -319,  485,  322, -282,  48, -241, -324,  13,  275,  431, -301, -85,  366, -398, -493,  248, -68, -242,  396,  487, -311,  307, -172,  321,  264,  72,  320,  296,  440, -324,  298, -379,  13,  472,  192, -439, -269,  368,  75, -493, -349, -374, -78, -130,  81,  282, -382, -135, -460, -134, -147,  81, -327, -467, -98, -211,  106,  74, -415,  398, -398, -264, -128,  115, -292, -436, -471, -60, -216,  456,  299,  288, -66,  73, -342, -485, -145,  128, -119,  247,  495, -414,  180,  20, -381, -66, -338, -423, -492, -253,  476, -38, -17, -152, -70, -456,  264, -41, -16, -452,  267,  135,  336, -299, -292, -154,  69,  416,  475,  450,  163, -178, -464,  196, -306,  07, -370, -144,  85, -09,  104,  413,  453, -61, -239, -117,  335, -475,  342, -181, -75,  461, -194,  114, -337,  15,  460,  232,  283,  435, -466, -54,  109, -78, -06,  304,  429,  125, -340,  366, -384, -384,  279, -431,  408, -108, -47,  243,  269,  147, -85, -305,  461,  221,  309, -376,  88,  269, -292, -129, -443,  94, -330, -482, -484,  164, -326, -203,  141, -165, -336,  257,  303, -205, -321, -437,  188,  484,  307, -43,  483,  74, -496,  444, -205,  313, -432, -264,  435,  128,  459, -156, -278, -371, -138,  90, -354,  37, -260,  287, -276,  256,  397, -121, -449, -424, -57, -409, -88,  102,  49, -105, -324,  405,  192,  323,  219,  260, -441, -494,  241, -481,  202, -185,  00, -84,  406,  146, -195, -354,  286,  381,  402,  183, -239, -195, -389,  204, -103,  375, -194, -202, -230,  334, -297,  462,  157, -226, -425, -431,  132, -332, -60, -166, -17,  440,  251,  241,  439, -92,  387,  225, -210, -359,  260,  51,  299, -277,  107, -304, -402,  413, -06,  220, -401, -451, -465,  256, -176, -390, -323, -192,  130,  117,  143, -387,  410,  246,  355, -299, -346, -406,  426, -56,  88, -462,  495, -113, -239,  102,  83, -141,  367, -71, -69,  466,  330, -34, -425,  06,  428, -248,  315,  58, -278, -42,  172, -16,  56,  379,  185,  210,  473,  463, -345,  61, -499,  02, -200,  114, -43,  383, -175,  176,  164,  256,  143, -05, -277, -430, -147, -349,  174, -332,  210,  396,  478,  234, -120,  34,  113, -83, -255,  438, -120,  252,  352, -119,  106, -348, -153, -437, -112,  172, -408, -448,  281,  235,  399, -496, -343,  105,  07,  331,  273, -283, -420,  252, -197,  312, -214, -232, -270,  31, -293,  110,  135, -89, -156, -258,  63, -457,  157,  451,  216,  249, -144, -03,  336,  107,  353,  493, -288, -140, -323,  486,  430,  109, -410, -267, -79, -124,  354,  151, -240, -439,  114, -253, -28, -190, -11, -113, -147, -353,  191, -79, -252, -453,  418, -415, -494, -377, -70,  71, -16,  459,  409,  266,  68,  499,  499,  490,  227, -295,  493,  487, -234,  459,  87, -410, -231, -424,  330,  475,  75,  21, -104, -324,  420,  167, -239,  426,  290, -457, -03,  126, -497, -94, -108,  71,  257,  244,  61, -15,  449,  407,  324,  68,  366, -89, -490, -12, -12,  340, -37, -85, -139, -289,  91, -219, -270, -296,  60, -479, -252, -443,  499, -249,  316,  244, -326,  73,  340, -412, -442,  289,  495,  383,  209, -287,  146,  220, -447, -14,  412,  368,  402, -226, -420,  345,  407, -190, -450, -33,  183, -202,  377,  183,  401, -455,  279, -425,  118,  119, -337, -471,  260,  10, -236, -30,  224,  410,  42,  277, -103, -46,  146,  151, -420, -422, -04, -160, -112,  46, -341, -76, -304, -112, -41, -51, -67, -262,  377, -96,  357, -460,  285,  469,  403, -99, -61,  127, -189, -167,  256, -440, -360,  254, -437,  72, -316,  60, -236,  425, -42, -76, -151, -493, -336,  308, -44,  450, -102, -167, -146,  107,  226, -09,  76,  129,  392, -132,  108,  55,  201,  216,  116, -307,  323,  179,  266, -493,  91, -470,  432, -98,  306, -219, -91, -177, -59, -283, -227, -309,  403,  479,  298,  129, -30, -125,  110, -138,  243,  70,  417,  296,  138,  385,  490, -39,  65, -392, -31,  08, -10,  253,  410, -203, -113, -181,  472, -320,  389, -255, -128,  292, -276, -330,  273,  194,  45,  235, -92,  140, -195, -175, -63,  443, -289, -73,  257, -372,  35,  78,  136, -123, -169,  399,  174, -430,  70,  146, -249, -41, -257,  123,  103, -33,  293, -124,  13,  191, -389,  421, -169,  268, -253,  268, -436,  310,  47,  321, -210, -66,  251, -222,  312, -66, -323,  338,  05, -400,  337,  256,  59, -420,  231, -337,  400,  24,  391, -87, -285, -145,  187,  399, -377, -214, -481, -313, -404,  419, -140, -114, -147, -37, -484,  17,  398, -306,  208, -97, -206,  397,  11, -295, -171, -258,  220, -271, -382,  112,  495,  186,  467,  182,  85, -58,  468,  104,  130, -84,  375, -158, -346, -271,  306, -330, -402, -444,  216, -342, -41, -490, -445, -178,  68, -115,  416, -212,  466, -466, -248,  461,  220, -281,  495,  157, -486, -185,  114,  496, -417, -11, -162, -263, -430, -04,  260, -331,  52, -24,  179, -137,  339,  235, -463, -93, -380,  453, -453, -414, -160, -200, -100, -440,  371,  247, -430,  385, -437,  184,  381, -354, -327,  72,  236,  96, -432, -04,  265,  473, -176, -56, -164,  15,  31,  226, -226, -497,  179, -178, -58, -481,  122,  342, -68, -07,  89,  02,  231, -496,  38,  112, -349, -437, -316, -261,  159,  105,  235,  276,  78, -89,  73, -234,  427, -396,  492, -299, -392, -476,  375,  50, -457, -03,  244,  327, -157,  185,  181, -426,  190, -281, -462,  341, -217,  75, -420, -206,  32, -333, -429, -390,  430,  144,  228, -291,  248, -427,  263, -292, -403,  138,  258, -08, -364,  354, -180,  331,  40, -499, -243, -270,  73,  147, -77, -292, -278,  355,  02,  254, -126,  425, -284, -196,  69, -203,  366,  170, -130,  129,  378, -33, -233,  489, -189,  255,  343,  131,  86, -117,  485, -305,  465,  410,  343, -112, -382, -83, -257,  472, -328,  117,  398,  240, -226,  319, -463, -360, -11,  259,  269, -132, -274, -112,  209,  38, -356,  52,  21, -418, -212,  358, -222, -247,  268, -27,  494, -262,  390, -263,  63, -86, -293,  313, -345,  333,  132,  44,  473, -378, -196, -406,  342,  382, -18,  51,  272,  478, -45,  146, -439,  243,  04,  191, -151,  125, -336, -157, -285, -94,  432, -370,  321, -09,  443, -172, -176,  76,  372,  149, -450,  28,  243,  392,  263,  78,  295,  35,  56, -250,  33,  117, -154, -462,  160,  195, -485,  324, -110,  82, -269, -178,  213, -96,  314,  156,  232, -10,  84,  456, -360,  486,  337,  383,  378,  100,  313, -475, -365, -130, -224,  169, -161,  122, -441, -500,  169, -74, -324, -441, -492,  259,  233, -427, -337,  399, -418, -253, -110, -482, -296,  382, -495, -459,  265,  383,  493,  431, -239, -372, -199,  37, -351,  492,  11,  60, -156,  32, -162,  21,  443,  199,  132,  176,  272, -352,  428, -294, -105,  170, -275,  451,  52, -270, -156,  169, -35, -163,  100,  226,  318,  401,  115, -181,  394, -22, -268, -262, -490,  70, -389,  453, -231, -404,  482, -106, -256,  410,  100,  139,  80, -323,  443, -16, -93, -213, -347, -275,  477,  254,  451,  295, -493,  419, -386, -247, -103, -154, -08, -92, -231,  455,  213,  38, -449,  195, -216, -205,  457, -263, -213,  389, -86,  82, -127, -326, -279,  27, -101, -302,  133,  202,  493,  140,  121, -40,  394, -481, -342,  238, -73, -73,  193, -360, -182, -403, -312,  102,  244, -355,  339, -117, -113,  106,  465,  260,  280, -313,  139,  31, -115,  124, -267,  231, -235,  355, -309, -341,  374, -151, -251,  153,  277, -206,  293, -405, -109, -167, -451, -364,  331, -259,  371, -282,  347,  337, -170,  479, -476, -178,  362,  261,  446, -405, -08, -289,  450, -465,  222,  324,  237,  471, -23,  14,  118,  123,  461, -491,  456, -490, -03, -361,  103, -131, -143,  302,  58,  188, -367,  434, -138,  495,  195, -192, -409,  40,  372, -459,  75,  94, -282, -188,  418, -453, -322,  388, -478, -09,  397, -169,  354,  247, -30, -43, -32,  328, -240, -474,  368, -107,  460, -270, -111,  155,  390, -20,  47,  262,  373, -377,  209, -57,  287,  479, -09, -182,  367,  365,  309, -384, -304,  163,  363,  167, -379, -169,  347,  233, -143, -433, -374,  169,  149,  367, -175,  391,  199, -276,  154,  73, -153,  215, -484, -13,  194,  359, -343,  413, -423,  466, -471, -227,  130, -255, -208, -397,  428, -09,  336, -214,  410, -186, -193,  59, -318,  484, -49,  381, -291, -43,  306,  408, -328, -325, -105, -282, -114,  52, -369, -37,  371,  12,  237,  353,  257, -119,  456,  186, -275, -356, -176, -365,  310,  131, -453, -156,  116,  350,  78,  325, -193, -116,  233,  331,  411, -19, -99, -202, -115,  32,  261, -244, -456,  350, -391, -346,  84, -83, -308,  309,  413,  16,  444,  224, -01, -157, -432, -33, -307,  146,  144,  352, -117,  230, -465, -206, -289, -64,  92,  448,  468,  206, -295, -135,  408,  166,  371, -08, -64, -437, -199, -151,  431,  98, -75, -70,  441,  346, -250, -365,  344,  394, -161, -273,  124, -125,  374, -313,  311, -34, -364, -368,  24,  193,  349, -67, -141,  220,  425, -353,  283,  79, -03, -434, -323,  422, -04, -382,  268,  246,  105,  465,  493,  445, -308,  117,  172, -434, -343, -17,  385, -207,  467, -91, -162,  316,  342,  197,  36, -380, -303,  171,  199,  194,  237,  376,  468,  86, -154, -411,  184, -196, -446,  177,  101,  98,  147, -227,  165,  304, -392,  402, -51, -424, -189,  287,  392,  06,  336,  281,  478, -467,  304,  177, -421,  42,  405, -452, -372,  103, -11, -336,  407,  43,  342,  08, -07,  341, -367, -342,  497,  94, -440, -54,  170,  224,  85,  414,  82, -79, -453,  60,  307,  352, -263,  386,  246, -06, -214, -274, -403,  275, -110, -495,  170,  84,  365, -336, -75, -149,  174, -78,  445, -413, -280,  467,  311, -343, -267,  245,  431, -219, -195,  238, -15,  394,  476, -269, -112, -237, -43, -15, -110,  347,  342, -87, -68, -440,  429, -291, -89,  103,  484,  208, -458, -296,  175, -295, -138,  408,  450, -207,  41, -245, -117, -474, -351, -141, -243,  389,  474, -434, -125,  217,  414,  69, -18,  198,  481, -89,  407,  244, -134,  391, -48,  261, -52, -21,  466, -338,  240,  417,  307, -219,  24, -310,  160, -474,  401,  417,  415, -272,  484,  142, -203, -250, -288,  279,  448,  45,  42, -293, -210, -240, -401,  242, -479,  47,  74,  488, -439, -186, -243,  368,  447,  281, -90,  107,  307, -189,  377,  223,  391,  361, -135, -312, -37,  429, -181,  263,  327,  361,  470, -383, -378, -431, -289, -357,  468,  285, -17, -471, -49,  240, -251, -101,  22,  159, -494, -171,  471,  383, -96, -286, -404, -378, -97,  411, -97,  222,  174, -270,  436,  145, -153, -442, -434,  411,  53, -465, -452, -463, -84,  00,  277, -482,  399, -201,  177, -243,  481, -500, -359,  237, -285,  89,  359,  118,  01,  115,  192, -325,  345,  128,  320,  45,  186, -261,  308,  92,  126,  356,  129, -106, -144, -94, -88,  107, -442, -410,  365, -461, -410, -142,  276,  157, -201,  488, -225,  300,  455, -180, -172,  300,  448,  00,  197,  487,  239,  05,  79, -135,  214, -292,  260, -78,  466, -328, -470, -476,  114, -253, -85, -443,  457,  44,  214, -244,  384,  490, -91,  339, -190,  237,  491,  110, -263,  189,  97, -171,  46, -324,  194,  112,  236,  306, -465, -445, -169, -435, -421,  445,  164,  347, -498,  121, -109,  217, -271,  127, -441,  138, -34,  221, -125, -43, -169,  465, -02, -219,  146, -103,  309,  192, -491,  398, -01, -104,  453, -318,  313, -116, -373, -23, -269, -18, -50,  474,  51,  180,  101,  462, -182, -81,  183, -454, -271, -134, -137, -421,  499, -491, -24,  309,  201,  338,  207,  52, -266, -488,  234, -452, -104, -286,  377,  480,  196, -172, -194,  99, -492, -240,  61,  178,  179,  96,  224,  408,  462, -61,  488,  462, -52,  316, -377,  02, -494, -318, -446, -259, -306,  289,  141,  442, -497,  370,  422, -449, -302, -271,  150,  58, -11, -289, -263,  20, -341, -187,  281, -379,  253, -379, -65,  53,  437,  410, -445, -204, -408, -390,  37,  138, -249,  30,  81,  106, -100,  355,  157,  451, -64,  159,  09, -223, -278, -402,  298, -119,  264,  431,  354,  17, -448, -210, -78, -159, -300, -22,  137,  145,  440,  26, -217, -309, -92, -284,  297, -339, -428,  306, -388,  08, -35,  473,  286,  187, -428,  84, -80,  336,  15, -226,  205,  419,  64, -373, -240, -383,  457, -250, -386,  397,  276, -103, -412, -315,  114, -263, -154,  186, -457,  310,  46,  08,  283, -168,  47, -293, -232,  467, -457, -365, -258, -400, -446, -342, -272,  167,  127, -315,  417,  241, -65, -455, -09,  375,  82, -395, -387, -220, -357, -344, -410,  189, -483, -274, -126,  416, -67,  142, -264,  329,  278, -22,  429, -316,  488,  09,  351,  468, -453, -380,  209, -18, -334, -300, -143,  248,  157,  322, -471,  300, -169, -29,  342, -152,  197, -284,  116, -17,  358,  352, -188,  488,  182,  93, -327, -477, -397, -124,  491,  02, -03,  200, -164,  163, -247,  193,  263,  410,  368, -356, -437, -301,  468,  405,  47,  165, -27,  15,  00,  183, -132, -336,  172, -98,  258, -303, -75, -287,  73, -84,  215, -78, -31, -449, -415, -426, -404, -299,  484,  464, -155, -101, -337, -187,  156, -438, -169, -371,  430,  331, -335,  150,  496, -311, -448, -394, -114,  330, -181, -189,  98, -114,  234, -81,  289, -329, -07, -263, -128,  330, -298, -430, -271,  217, -117,  386, -368, -434, -133, -438,  398,  384,  212, -254, -427, -384,  204,  311,  446, -125, -25,  45,  261, -291, -184,  402,  232,  310, -361, -43,  140,  193,  27, -279, -89, -238, -393,  395, -171,  327, -191,  79,  211, -479,  325, -363, -11,  381,  448, -64, -244, -77, -167, -131,  484,  149, -229, -431,  311, -90,  26, -49, -396, -95,  173,  367,  167, -368,  262,  496, -189, -429,  75, -125, -56,  252,  12,  433,  133, -40,  221,  389, -264, -94, -242, -280, -92,  381,  141, -281, -208, -333, -477,  248,  72, -452,  467, -260, -320, -419,  88,  344,  04, -336, -281,  448,  416,  231, -267,  50,  43, -193,  291,  279, -435, -98, -148,  325, -217,  493, -455,  427,  13, -80,  175, -415, -32,  494,  177, -500, -425, -234,  344,  79,  282, -85,  379,  198, -354, -35,  100, -458,  272,  244, -327, -311, -354,  25, -485,  281,  371, -88,  209,  236, -316,  236,  321,  152,  231,  351, -496, -342, -31, -299,  238, -249,  116,  469, -199, -385, -66, -246, -343,  58,  498, -170,  248, -04, -292, -385,  129, -69,  379,  190, -333, -437,  279, -160, -433,  362,  43, -429, -480, -488, -228, -390,  115, -259, -420,  417, -144,  14,  23,  13, -75,  373, -305,  25, -131,  255,  140, -150, -314,  371, -459,  205,  434,  320, -102, -499,  182,  441, -76,  202,  454,  197, -335,  421,  438, -255,  338, -206, -389, -139, -341,  388, -266,  206, -87,  455, -38, -95,  158, -500, -224,  199,  206,  62,  371, -396,  63,  53, -103,  488,  107, -149, -463,  272,  125, -173, -131, -37,  473,  333, -323, -368,  221,  263, -310, -365, -429,  152,  392,  229,  153,  21,  280,  211, -417,  151, -333,  147,  56,  64,  487,  15, -232, -476,  140,  393, -149, -139,  208,  176, -306, -263,  308,  416, -147,  498, -97, -76, -497,  147,  05, -492, -332,  137, -429, -248,  140, -262, -249,  48, -346, -262, -437,  274,  114, -445, -481, -183, -83,  228,  493,  111, -183, -347,  379,  170,  03,  134, -406,  358, -218,  451,  366,  302,  88, -211, -446,  80,  379,  157, -372, -114, -253, -308, -340, -287,  99, -320,  30, -484, -240,  375,  480,  77, -120, -289, -252, -264, -302,  194, -406,  332,  146, -187,  134,  86,  102, -459, -333,  334,  198, -205, -280,  446,  339, -120,  11,  291,  412, -106, -341, -328, -231, -361, -398, -498,  203, -150, -262,  401, -456,  184,  233, -458, -151,  219,  481, -196,  260,  00, -362, -41,  295, -142,  257,  487, -410, -232,  278, -145,  162, -211,  27, -216, -71,  129,  138, -16, -169,  376,  237,  228,  412,  322, -378, -238,  41, -397,  66, -198,  103, -444, -387,  251, -86, -278, -410,  356,  342, -280, -289,  357,  09, -409, -07, -210, -428, -369,  274,  256, -141,  11, -16, -229, -167,  106,  385, -273, -438, -49,  29, -483,  359,  494, -380,  125, -284, -290, -18, -90, -70, -455, -233, -208, -364,  260,  82,  61,  391,  209, -183,  102,  72,  301,  374,  406,  259, -389, -15, -327,  415, -486, -309,  274, -140, -189, -100,  428,  374,  382, -162,  156, -221,  106,  448,  268,  218,  31, -171,  110, -260,  146,  64,  312,  299, -62, -430,  410,  402,  55, -416,  317,  421,  127,  91,  133, -210,  491,  61, -336, -275,  400,  321,  357,  06, -379,  125, -276,  152,  454, -314, -256,  100, -397, -91,  251,  393,  331,  161,  295,  239,  245,  112, -488, -128, -296,  146, -485,  47, -293, -321, -375, -393, -148,  482,  465, -26,  107,  42, -22,  413, -420, -425,  365, -317,  336,  116, -423,  167, -223,  372,  258, -477, -15,  271,  247, -459, -83,  262,  440,  476, -206, -83, -416,  146,  251, -451, -28,  210,  443,  451,  123, -476, -122, -12, -293, -286, -396, -216,  381, -118, -343,  492,  257,  494,  263,  356, -113,  32,  119, -173,  08, -235,  245,  444, -237, -04, -154,  236, -293, -211, -461, -318, -187, -83,  171,  21,  131, -373,  305,  364,  361, -186,  356,  470, -192,  471,  327, -453,  03,  298, -125, -136, -437, -28, -192, -174, -180,  154, -86,  379,  444, -47, -438,  109, -278, -415, -370, -295, -288, -212, -78, -74,  454,  130, -104,  115,  102, -277,  162, -43, -127, -463,  321, -64,  361, -18, -385, -318, -12,  29, -87,  284, -165, -25, -106,  57,  412,  376, -385, -23, -336,  37,  403, -29,  19,  151, -414, -379,  375,  248,  431, -252, -362, -396, -463,  499,  86, -348,  33, -425, -467,  447,  359, -132,  274,  105, -222,  187, -18,  245, -336,  498, -218, -81, -31, -347, -430,  407, -225, -203,  156, -294,  398, -354, -190,  435, -03, -251, -61, -117,  176, -28,  182,  35,  341, -44, -07, -29, -05,  475, -284,  159,  473,  350, -70,  295, -497,  01,  202,  130,  298,  210, -312,  196, -292,  351,  483,  206, -400, -78, -59,  276,  395, -377,  163, -412,  79, -344,  411, -425, -17, -373, -414,  309, -171,  17,  104,  184, -130,  158, -185,  20,  221,  355,  69,  429,  206,  52,  487, -342,  475, -72, -214, -278,  51,  450, -190, -369, -42, -279,  58,  442,  200,  496, -397, -119,  365,  207, -435, -265,  217,  232,  256, -62,  88,  177,  220, -206, -271,  207,  305,  56, -364, -409,  278,  187, -459, -60, -330,  352, -487, -420, -354,  213, -423, -251, -54,  442, -192,  12,  30, -475,  96,  138,  316, -316, -185,  36,  331,  396,  95,  136, -47,  231,  227, -269,  271, -379, -476, -207, -175, -463, -126, -29, -397,  303, -428,  49, -403, -120, -87,  127,  257, -490,  117,  73, -306,  432, -39, -123,  329, -443, -487,  134,  288, -407, -283,  411,  66, -259, -295,  391, -221,  431,  214, -118, -414,  286,  431, -317, -334,  197, -337,  423,  207, -368,  349,  401, -435, -190,  131, -254, -133,  144, -268,  08, -411, -51, -81,  155,  191,  476,  398,  470, -241,  112,  204,  197, -102,  487, -267,  64,  184,  248,  340, -109,  380,  189,  145,  445, -149, -224,  43,  219, -228,  275, -273,  214, -275,  498,  221, -232, -173,  120, -262,  438, -268, -206,  136,  483, -219,  369,  399,  466,  117,  239,  209, -03,  280,  206,  295, -368,  482,  190, -297,  107,  318,  282, -179, -105, -368, -458,  163, -41, -486, -247,  250, -253,  47, -114,  82,  328,  107, -19, -354,  76,  73, -292, -75, -147,  414,  72,  337, -251,  115, -460,  356, -67, -326,  29, -320, -193,  423,  343, -382,  438, -404,  368,  37,  143, -246, -381,  323, -287,  452, -178, -359,  25,  30,  67, -269, -56, -09, -432,  193, -394, -39,  401,  391,  135, -70, -429, -206, -146,  414, -87,  144, -490, -219, -319, -495,  388,  152, -319, -399,  104,  03, -257, -18, -115, -338,  213,  329,  153, -367,  375,  260,  94,  276,  151,  82,  59,  223,  376, -235,  489, -211,  409, -148,  423, -58, -143,  311, -54,  390, -236, -98,  245,  07,  384, -370, -479,  97, -188,  175, -417, -313,  287, -471, -185, -62,  463,  374,  13,  340, -361,  03, -19, -100,  355,  256,  342,  64,  67, -212,  307,  332,  191,  52,  191,  427,  183,  213,  377, -153,  240,  460,  34,  27,  489,  349, -183,  453, -424,  331, -355, -285,  186,  478,  116,  393, -413,  310,  309,  154, -49,  116,  338, -06, -331,  30, -79, -296,  95, -202,  51, -165,  110, -63, -286,  452,  138,  31, -243,  214,  214, -98, -218,  252,  232, -250,  145,  319, -440, -45,  326,  11, -77,  164, -495,  444,  46,  279,  00, -07, -71, -449,  328, -460,  340, -106,  492, -21,  426, -251,  45,  140, -497,  327, -107, -413, -423, -110, -241, -10, -303, -63, -147,  121, -47,  211,  417, -500, -10, -82,  345,  419,  321, -474, -189,  162, -80,  155, -07, -154,  404, -462, -161, -241, -282, -416,  199, -205, -26,  458, -363,  172, -105, -09,  145,  348, -298,  62, -300,  192, -168, -454,  463, -346, -76, -225, -332,  344,  430,  161, -309, -313, -449,  382,  298, -231,  466, -03,  65, -60,  307,  202, -36,  54,  45, -39,  255,  247, -124,  455, -61,  208, -147,  255,  362,  277, -470, -118,  474, -188, -457, -335,  351, -405, -453,  150, -136, -135, -353, -219,  305, -193, -164,  122,  361,  381, -417,  116,  129, -41,  424, -80,  20,  129, -325,  234,  259,  57, -383,  233,  370, -340, -250,  221,  107, -203,  223, -176, -486,  371,  105, -329,  30, -207,  293, -109,  27, -271, -492, -344, -460, -216,  428,  60,  413, -396,  147,  172, -487,  264, -95,  383, -224,  155,  457,  384, -196,  180, -292, -182,  403, -335, -10, -67,  311,  135, -323, -162,  364,  37,  346,  405,  321,  274,  317,  234, -270, -36,  259, -256, -272,  16, -21,  357, -328, -64,  241,  328, -31, -199, -01,  224,  318,  489,  10,  129,  476,  187, -181,  341, -276, -335, -402, -455,  440,  415, -369, -330,  232, -258,  266, -188,  259, -254, -331,  431, -466, -238, -389,  355,  415,  110,  80, -414,  451, -410, -433,  428, -371, -113, -379, -147,  52, -281,  250,  344, -14,  381, -133,  70, -376, -367,  383, -265, -121, -96, -334,  266,  167,  129,  121,  434, -260, -299, -480, -309,  143, -412, -29,  272, -25,  92, -375, -121, -337, -273, -276, -498, -391,  91,  72,  85,  224,  307,  320, -44, -288, -162, -278, -269,  467,  343, -335,  59, -103,  38,  251, -460,  126,  74,  313, -47, -333, -210,  332,  182,  18, -92,  184,  479,  499, -243,  416, -424, -84, -412,  32,  128,  278, -394, -289, -403,  449,  229,  157,  198, -233,  260,  239, -255,  186,  404,  198,  353,  46,  382,  36, -84,  143,  72,  247,  142, -319, -485, -430,  98, -45,  454,  78, -267, -440,  290,  183, -138,  19,  192, -440,  286,  304, -349, -117, -10, -93, -419,  196,  454, -185,  84,  222,  458, -344, -30,  453, -162, -15, -125, -212, -207, -170,  366,  378,  242, -492,  61, -44,  27, -247,  369,  165, -91, -128, -452,  400,  280, -19,  96, -414, -351,  32,  308, -41,  188,  130,  264, -122, -32, -360,  166,  261,  322,  385,  139,  416,  393, -299, -127,  273,  306,  94,  290, -284,  466, -309, -32,  246,  172, -84,  332, -327,  448,  493,  133,  488,  123,  249, -133, -409,  389, -115,  352, -437,  122,  344,  480,  16, -103,  205,  141,  55, -201, -69, -377, -235,  122,  91, -488,  147, -141, -304,  320, -193, -311,  305, -204,  313,  55, -485, -244,  296, -100, -39, -288, -477, -195, -308,  391, -446, -251,  32,  109,  48, -185,  233,  313, -210, -176, -323,  437,  184, -126, -391, -157,  415, -233,  139, -420, -326,  154, -163,  470, -93,  298,  34, -70, -45,  226, -179,  09,  475, -295, -382,  375,  372,  351,  189, -338,  28, -282, -49,  64,  92,  413,  407,  08, -320,  399,  88, -146,  405, -223,  176, -188, -73,  63, -406, -266, -211,  267,  243,  117,  472, -286, -08, -303, -83,  33, -141, -203,  252, -337,  361,  196, -424,  269,  56,  108, -480, -355, -186,  425,  274, -158, -262, -298,  405, -168, -64,  47, -400,  32,  16, -76,  246, -492,  121,  15,  394, -167,  313,  498,  348,  174,  194, -224,  295, -249,  384,  315,  248,  50, -407,  22, -256, -169, -424, -350, -485,  13, -451, -33, -103,  65, -256, -05,  425,  365, -490,  319,  50,  323, -331,  250,  350,  364, -474,  497, -385, -238, -335, -285,  312, -242, -411, -443,  441, -334,  59, -192, -469,  108, -372, -72,  25, -128,  423, -50,  89,  433,  122, -360, -391,  291,  390, -189, -493, -231,  160, -26,  31,  325,  189,  196, -65,  279, -395,  228,  445,  164, -111, -172,  124,  17,  256,  01,  389,  179,  451, -22,  464,  425,  470, -75,  217, -287,  236, -424, -18,  249,  51, -135,  74, -260, -439, -138, -129, -334, -58,  168, -318,  331,  496, -342, -152,  252,  159, -263,  283,  463, -432,  248,  388, -462, -327,  457,  103, -238, -466, -415, -489,  85, -49,  437, -323,  364,  151,  49, -117, -406,  69,  65,  425,  66, -424,  126, -182,  235, -285, -46,  198, -217, -298,  439,  174,  227,  396, -223,  489, -218,  215, -148, -281,  18, -210,  249, -118,  441,  150,  265, -465, -281,  183, -187,  285,  259, -209, -44,  346,  06,  410,  45, -358, -388,  336,  316, -309, -416, -55, -319,  219, -340,  33,  438, -470, -325,  187, -87, -383, -163,  30,  04,  409,  65, -331,  194, -176, -40, -350, -329,  467, -88, -432, -391,  376, -244, -223, -432, -160, -426,  101, -441, -265, -366, -150,  117,  162, -463, -470,  279,  227,  413,  135,  136, -22,  305,  182, -345, -235, -315,  178,  84,  97,  246, -455,  326, -498, -178,  394,  194, -103, -05,  254,  484,  481, -396,  101,  143, -07,  484,  274,  72, -251,  262,  60,  227,  67,  95, -266, -316,  280,  412,  269,  229,  158,  314,  55, -488, -11,  301, -441, -262,  148,  313,  74,  130, -231,  27,  125, -386,  11,  252, -461, -388,  14,  451, -308, -67,  46, -74,  117,  178, -161,  238, -92, -151,  405, -185,  214, -106, -31,  273,  484, -383,  438,  58, -401,  59, -415,  225, -475,  449,  329, -436, -439,  195, -132, -247, -372,  414, -468, -403,  445, -129, -312, -147, -428, -407, -480,  286,  339, -11,  411,  323,  459,  349,  233, -442,  260, -330, -365,  286, -381,  464, -298,  33, -489,  422, -362, -09,  337, -330,  89,  282,  393, -371, -13, -182,  74,  359, -44, -87,  201, -132,  88,  160,  69,  173,  218,  182,  343,  354, -32,  463, -330, -478,  348,  34,  445,  486, -475, -366,  09,  466, -232,  254, -405, -393, -428,  169, -182,  29, -66, -481, -251, -478,  179,  318,  195,  250,  00,  39,  456, -180,  354, -22,  195,  202, -488,  492, -460, -462, -374,  401, -496,  246,  156, -48,  353,  228, -379,  23,  109,  56,  43,  358,  430,  74,  177,  478,  176,  29,  369,  132,  350, -425, -37,  397,  277, -25,  389, -331,  365, -133, -429, -278, -387,  227,  174, -182,  307, -353,  341, -83, -445,  236, -225, -162, -189, -196, -184,  487, -314,  37,  472, -464,  112,  287, -215,  241, -238, -326,  410, -20,  41, -167, -446, -494, -88, -420, -176, -280, -273,  17,  489,  135, -246,  116,  473,  417,  421,  141,  404, -393, -322, -272, -05,  290, -485,  280,  31,  130, -194,  293, -38, -301, -373,  16, -295,  391,  96,  29, -389, -325, -454, -48, -338, -200, -431, -13, -283,  490, -372, -26, -51,  158, -446, -204,  300, -78, -72,  183, -96,  234, -23,  366,  433,  456,  234, -362,  347,  182, -481, -189,  357, -83,  263, -128, -430,  332,  359,  139, -326,  488, -35,  475,  498,  20, -229,  299, -206, -449,  334,  198, -363,  163,  416, -78,  471,  150,  412,  319, -168,  431, -18,  41, -151,  97,  413,  271, -70, -375, -90,  456, -35,  376, -216, -37,  248,  55,  114, -458,  459, -51, -408, -404, -36, -492,  19, -64, -490, -69,  107,  194,  215, -411,  87, -84,  186,  353, -313, -32,  478,  449,  277, -57,  325, -439, -242,  425,  468,  373, -181,  427,  174,  263, -476, -362,  271,  395,  426, -367,  178,  33, -321, -107,  474,  267,  309,  161,  472, -152, -19,  450, -202, -242,  245, -25,  171, -497, -99,  140, -272, -428,  67, -246,  336,  443,  245,  459, -310,  171, -55,  369, -295,  124,  114, -321,  243,  276, -308,  215, -376, -474, -483,  274, -216,  262, -250, -192, -382, -497,  448,  198, -73,  367,  453, -237, -337,  198, -277, -147,  221, -480,  74, -222,  144, -311, -42, -112, -183, -498, -45, -59, -472, -27,  68,  165,  87, -330,  473,  205,  25,  421,  256,  452, -360,  209, -284, -197,  259,  291,  157,  332,  311,  83, -389,  307, -376,  421, -305, -59,  423, -497,  383,  452, -24,  303,  469, -85,  473,  442, -379, -02, -285, -271, -50, -145,  438, -482, -489, -451, -339,  168,  381, -176,  103,  492, -368,  228,  413,  179, -331, -311,  182, -96, -07,  10, -293, -38,  426,  32,  256, -101, -118, -177,  128, -315,  178,  418, -297,  189,  467,  217,  209, -300, -107,  165,  45,  25, -107,  310,  57,  62, -149,  91, -181,  344, -398,  378,  158, -120, -89, -86,  279,  293,  237,  259,  478,  268,  177,  34,  309,  496, -249,  371,  48,  496,  36, -407,  22, -219, -244, -69, -305,  107, -478,  14, -48, -24, -107, -38,  356, -344,  377,  487,  449,  466,  246, -220, -414,  275,  314, -252,  271, -83, -381, -180, -87, -493,  265, -213,  140, -479,  218,  335,  129, -407,  202, -67,  421, -53,  395, -370,  103, -376, -383,  52, -409, -284,  332,  29,  491,  498,  277,  263,  267, -252, -65, -319,  107, -300,  320, -253, -278,  391, -65, -297,  484, -11,  136, -243,  436,  383, -113,  39, -492,  357, -57, -49, -427,  128, -168, -436,  126, -390, -321, -106,  210,  114,  427,  170, -333,  247, -231, -111,  138, -444,  444,  474,  45,  432, -268, -19,  315,  471, -480, -325,  328,  316,  478,  401, -56, -189, -182, -78,  273,  349, -332,  335,  316, -405,  05,  483, -305, -373,  224,  333, -317,  168, -340,  229,  452,  244, -290, -381,  215,  83, -205,  396, -101,  125, -351,  343,  436,  319,  117, -439,  169,  286,  397, -15, -267,  254,  320, -72,  381,  396,  114, -435,  64, -374, -354,  368,  370, -144,  487,  437,  439,  134,  333,  190, -240,  483,  385,  48,  302,  03,  110,  323, -211,  359, -192,  374,  465, -20, -197, -301, -124, -231,  116, -208, -105,  262, -340, -235, -30, -352, -298,  262, -366, -464, -48, -106, -129, -162,  443, -327, -307,  405,  497, -18, -384,  157,  208, -419, -10, -489,  132,  366, -220, -252,  11,  175, -490,  171, -208, -19, -329, -05, -257, -194,  383, -453, -448,  106, -115,  495,  279,  78, -248, -372, -88, -132, -362, -379,  302,  128, -16, -66,  346, -383,  183, -143, -356, -455, -119, -63,  378,  404, -216, -27,  62,  19,  21,  115, -375, -242,  110, -244, -311, -285, -115,  453,  83,  375, -74, -115,  03,  411,  320,  201, -120,  355, -89,  24,  400,  292, -187,  279,  196,  97,  104, -241, -32, -375, -274,  93,  236, -312,  350,  425, -97,  87,  378,  487,  314, -195, -128,  169,  68,  44, -130, -200, -101,  281,  324, -200,  425, -362, -69,  122, -413, -113, -267,  56,  13,  311,  01,  101,  499,  203,  26, -97,  142,  256, -110, -44, -87, -386, -375, -167,  159,  348,  133, -90,  129,  310, -438,  55, -200,  345,  29, -113, -267, -386, -205, -402,  425, -351,  199,  424,  352,  77, -173,  347, -167, -431, -197, -401,  36,  281, -68,  47,  129, -434,  457, -242,  376, -128, -335, -324, -283,  194,  415, -50, -340,  63,  400, -415,  212,  99, -138,  416, -324, -459,  263,  362, -389, -433,  461,  499,  348, -107,  46, -23,  311,  355, -413, -461, -273,  105,  67,  297, -201,  335, -253,  312, -102,  00,  397, -38, -401,  111, -122,  128,  153, -358, -10, -384,  61, -49, -385,  261, -304, -487,  90, -492,  368, -471, -101, -404,  134,  467,  393, -214,  302, -08, -402,  52,  492, -153, -486, -56,  459,  244, -428,  112,  386,  62,  228,  299, -135, -305,  60,  61, -292,  02,  421, -424,  32, -179,  24, -334,  140,  269, -48,  294,  114,  402, -154,  458, -250,  212, -98, -291, -44,  326,  321, -157,  240,  401, -06, -395, -52, -93, -481,  156,  409,  440, -416,  293,  113,  109, -188, -247,  230,  264, -453,  196,  167,  245,  155, -231, -43, -91, -22,  414,  88,  151,  109, -172,  404, -397,  286, -148,  362,  305, -492,  272,  245, -408,  417,  211, -447, -271,  464,  284, -154, -136, -20, -487, -391, -13, -218,  67, -251, -388, -19,  337,  263, -58, -335, -481,  45,  451, -129, -92,  256, -121,  32,  354,  323,  301,  65, -271, -469,  381, -135, -123, -255,  345,  242, -145,  185, -124, -226,  434,  340, -393,  271,  103,  49,  436,  122, -54, -260, -155, -294, -152, -424, -410, -298,  399,  392, -381, -372,  423, -499, -07,  152, -254,  191,  246,  453,  228, -26,  79,  162, -186,  186,  285, -231, -265,  221,  391,  182, -187,  88, -260,  162,  164, -169,  364,  63, -277, -164, -456, -02, -163,  389,  02,  435,  80, -252, -259, -192,  222,  320, -178, -112,  07, -393,  157, -406, -319,  400, -372, -06, -12, -131, -344, -348, -448, -127, -433, -225, -439, -389, -375, -102, -499,  127,  185,  433, -273,  426,  94, -199,  247, -232,  189,  106, -124, -154, -448,  409, -254,  33, -97, -414,  402,  412, -262,  454,  137, -195,  81,  198,  269, -442, -52, -378, -463, -367, -445, -236, -440, -499,  417, -341, -230,  458, -383,  146, -196, -331,  55,  402,  202, -190,  488,  456,  74,  78, -238, -289, -265, -305, -239, -496, -247,  209, -374, -210, -305, -318,  406,  107,  35,  323,  266,  305, -367, -265,  303, -63,  256,  210,  191,  311, -127, -469, -381,  447,  461, -118,  11, -303,  429,  272, -299, -317,  334, -172,  325, -471,  362, -416,  488,  249, -241, -394,  55, -107, -159,  210,  330, -403, -79,  374, -240,  294, -243, -120, -407, -281, -386,  104,  268, -457,  229,  469,  78,  63,  149, -96,  444,  363,  340, -216,  113, -401, -110,  20, -08,  231, -270,  175, -320,  151,  49, -59,  297, -342, -327,  391,  229, -213, -05, -03, -170, -276, -33, -239, -361, -32, -483, -65, -168,  357,  219,  445,  456, -391,  317, -51, -308, -453, -376,  225,  199, -475,  18,  348, -317,  191,  239,  413,  478,  87,  262,  160, -337, -271,  421, -197,  198,  438, -410, -118,  295, -338,  179, -396,  123, -04,  53, -332,  43, -471,  393,  94, -446, -89, -57,  89, -398,  34,  354, -68, -379,  117, -408, -215, -302, -134,  440, -252, -196, -118,  130, -48,  44,  161,  56,  20, -343, -39,  188, -447, -10,  81,  499,  396, -156, -58, -15, -54, -171,  192, -270, -50, -191, -178,  235,  359,  188, -473, -392, -155, -90,  238, -351,  454,  252,  205,  326,  409,  18,  14, -186, -140, -53, -186, -244,  291,  256, -407,  89, -415,  285,  319,  388, -54, -06,  475, -194,  34, -497,  266,  379, -87,  356, -472,  219,  108, -415,  46,  18,  455, -440, -316, -185,  360, -02,  71,  151,  107, -483,  93, -456, -346,  264,  432,  453, -242,  408,  111,  293, -237, -123, -476,  176, -267, -95, -105,  342,  342, -207,  212,  298,  206,  396, -387,  66, -105, -463,  69, -498, -94,  14, -102,  60, -221, -169,  365,  389,  91, -24,  182,  354,  353, -441,  382, -413,  316,  129, -219,  158,  423,  493, -44,  129,  389,  422,  47,  136, -189, -384,  490,  217,  131, -111,  129, -238, -428, -05, -349,  163,  471, -314,  369, -323, -255,  251,  116, -439, -120,  397, -429,  155, -258,  28, -216, -17,  302, -317, -28, -387, -200, -38, -318, -217,  351,  311,  397, -225,  158, -452,  438,  482, -266,  307, -341,  331,  410, -373, -256,  143, -476,  168, -202,  118,  48,  435, -399, -150, -382,  73,  315,  270, -112,  497, -95,  91, -340, -198,  367,  319, -149,  305,  301,  437,  465, -188, -379, -273, -61,  217,  370,  315, -115, -331, -67,  433, -396,  386, -217, -278,  312, -50, -155, -300, -53,  250,  291,  460, -447, -490, -369,  256, -332,  432,  193, -15,  96, -334,  212, -465,  384,  83, -298, -231, -396,  487,  55, -292,  373, -310,  282, -463,  141, -373, -263, -60,  378, -119, -100, -217,  243,  31, -461,  411,  315, -416, -104,  263, -249, -391, -350, -13, -456, -148, -392,  00, -161,  163,  208,  65,  354,  342,  102,  347, -178, -308, -213,  52,  425, -460,  335,  168,  423,  374,  80, -409,  458, -172,  354,  61,  289, -495, -100,  333,  209,  09, -167, -451,  24, -107,  466, -122,  88,  68,  77,  410,  260,  365, -38,  185, -243, -203, -146, -320,  23, -214, -229,  333,  114, -22,  247, -96,  335, -353,  89,  396,  156, -225, -203, -319, -480, -237,  411,  108,  332, -11,  370,  444,  206, -168,  130,  463,  481, -164, -357,  356,  474,  267, -458,  440,  97,  289, -156,  284,  436, -214,  180,  445,  61,  478, -22,  81, -259, -111, -310, -427, -270, -88, -482,  436,  245, -500,  399, -422,  188, -105, -213, -486,  14, -171,  454, -389, -382, -201, -253, -94,  437,  427, -149, -02,  405,  329, -421, -353,  71,  121,  72,  301, -466,  442,  238, -369, -206,  489,  61,  482,  236,  348, -152, -250, -323, -197,  213,  147,  454,  460, -446,  391,  388,  257, -111, -355,  87,  320, -208, -342,  294,  365,  459, -320,  307, -451,  163, -46, -461, -276, -64, -373, -75, -363, -122,  454, -60, -57,  102, -106,  256, -492, -215,  496,  265, -474, -359, -148,  346, -66,  362,  492,  151,  322,  24,  310, -277, -313, -236,  114, -88, -447,  242, -311, -310, -28, -357,  130,  415,  245, -124,  171, -395,  161, -481,  371, -461, -339, -277, -263,  95, -62, -270,  98, -240,  254, -92,  335, -206, -475, -50, -442, -422, -308, -253, -232,  164, -110, -250,  431, -12,  126,  455,  93,  139,  474, -36,  178, -365, -460, -233, -418, -22, -03,  180, -410,  104, -59,  425,  398, -34,  227,  456,  396, -229,  55,  16, -213,  445,  266, -281,  285,  244,  26,  231,  235,  352,  47,  265,  488,  87, -468, -78, -83,  30, -45,  359, -14,  396, -363,  236,  214,  364,  192,  110, -12, -253, -374,  275,  44, -256, -154,  182,  488,  372, -87, -425,  225,  460,  340, -435,  400,  372, -13,  169,  254, -206,  29, -260,  42,  166,  476, -244,  382, -480, -282, -130,  119,  196, -354,  16,  440, -08, -302, -220,  217,  463, -145,  294,  423, -305, -289, -325, -432, -450,  345,  322, -155, -126, -85,  387, -460,  243, -04, -226, -384,  214,  145,  235,  263,  291,  103,  203,  135,  301,  484,  204,  264,  191, -02, -460,  387, -439, -285, -193, -388, -440, -19, -43,  286, -252,  196, -322,  492, -308, -47, -392, -241, -402, -305, -478, -259, -349, -423,  376,  452, -87,  433, -431, -395,  283, -39, -156,  345,  176,  151,  457, -411, -368,  266,  375, -119, -38, -94,  225, -493,  359, -315,  118,  457,  232,  492, -302,  383, -431, -74, -312,  335, -141, -243,  440, -357, -430, -216,  488,  246,  435, -203, -313, -81, -437, -85, -348,  377,  321, -271,  384,  180, -86,  02,  489, -01,  346, -313, -118, -232,  465,  70, -397,  177, -321, -457,  320, -251,  179, -340, -152,  466,  309,  35, -115,  372,  450,  390,  249, -377, -381,  486,  303,  386,  340, -356, -115,  187,  183,  267,  455,  149,  190, -442, -174, -279, -47, -02, -29, -368, -490, -329, -402,  319, -442,  335, -457, -139, -423, -356, -16,  49, -370,  140, -65, -177,  284, -328, -138, -32, -209, -183, -383, -167,  227,  295,  55,  32, -207, -122, -484,  155,  49, -34,  326,  107,  153,  369,  468,  231, -135,  305, -220, -04, -55, -433, -329, -271,  91,  33,  197,  382, -298, -334, -284,  429, -187, -377,  313,  106,  01,  329,  113, -98,  147, -61, -139, -200, -192,  182, -469, -474, -13,  163,  22,  432, -418, -455,  13,  173,  78,  63,  408,  280, -419, -24, -439, -105,  99,  374, -147, -48, -445,  467,  354,  202, -94, -285, -498, -433,  397, -114, -407, -116, -99,  467,  168, -16, -488, -318,  09,  442, -403,  269,  222, -322, -255,  283,  73, -304, -491,  427,  148, -84,  394,  02, -382,  152, -430, -28, -429,  467, -290,  16,  204,  112,  335,  224, -52, -301, -242,  457, -359, -145, -421,  363,  34, -176,  498, -41,  21, -141, -114, -331,  275,  132, -476, -255,  137, -406, -430,  208, -87, -220,  77, -31,  392, -88,  46,  192,  112,  304, -498,  253, -340, -419,  469, -454, -95, -181,  05, -222,  179, -256,  300,  306, -272, -324, -448,  365,  122, -26,  426, -465,  254,  03,  357,  499, -233, -97,  191, -269,  59,  193,  485, -429,  274, -194, -383,  32,  125,  475, -338,  156,  71, -186, -37,  299, -10,  367,  165, -388, -159,  443,  00, -405, -54,  209, -54, -435, -388, -362, -203, -477,  331,  134, -405,  458,  440,  64,  342,  417,  391, -496,  74, -38, -181, -463,  114, -339,  404, -221, -226,  97, -278, -374,  192, -480,  335, -361, -415, -201,  129,  234, -178,  312, -132,  269, -378, -192, -166,  464, -274, -275, -179, -348, -460,  492, -311,  154, -347, -55, -215,  279, -458,  07,  405, -414,  379,  240,  77, -184, -109, -294, -449,  214, -129, -81, -17, -07, -420, -331, -42,  158, -105, -369,  310,  287, -377, -149, -59, -224,  296,  226, -444, -310,  85,  461, -224, -36, -446,  354, -368, -55, -88, -317,  11,  283,  455, -153,  129, -113,  16, -61, -103, -237,  70,  59, -450,  193,  410, -09,  469, -442, -283, -123, -252, -346, -161,  376,  118,  245, -418, -397, -310, -05,  138, -446,  130,  445, -99,  111, -168,  417, -450, -419, -319,  120,  140, -269, -187,  402,  223,  135,  460, -208, -488,  60, -53,  203,  289, -83, -52,  371,  20,  491,  218, -341, -455,  201, -396, -54, -188,  289, -137, -137,  370,  396, -165,  363, -372, -499,  265, -297,  136, -422,  347, -500,  490,  146, -444, -369, -436,  04, -145,  436,  347, -427, -53,  392, -374,  404,  190,  291,  193, -94, -346,  415, -198,  341, -370,  282,  342, -252,  485,  330, -174, -315, -317,  168,  331, -261, -348,  395, -405,  07, -316,  443,  80,  131, -313, -441,  35,  378,  350,  80, -216, -144, -04,  86, -303,  478,  221, -108, -274,  206, -278,  404,  391, -95,  425,  223,  144, -423,  470,  240,  84, -346,  183,  16,  286, -278,  75,  173, -400, -75, -246,  236,  281, -398, -177, -169, -420, -104,  223, -193, -398, -203, -289, -154,  203, -364, -79,  199,  65,  243, -61, -351, -250, -26,  166, -464,  197,  93, -439, -351, -481, -185,  386, -348, -83,  61,  335, -02,  457,  58,  305, -89,  356, -132, -391,  411,  357,  30,  110, -78,  126, -98,  424,  376, -272,  90, -236, -223, -317, -175, -73,  54,  141, -187, -441, -442, -274,  394,  408, -317,  305, -435,  446,  161, -66, -444,  424,  143,  86,  34, -83,  64, -212, -159, -60,  17, -217,  204,  294, -33, -470,  73, -127, -477, -262, -68, -67, -36, -173, -158,  499, -368, -93,  446, -355, -307, -498, -431, -312,  440,  455,  106,  05, -256,  447,  445, -387, -269, -498,  407, -450, -116, -19, -77, -93,  219, -292, -308,  36,  35,  34,  35, -481, -206, -19,  16, -13, -17,  437,  176,  276,  392, -218, -219, -12,  81,  78,  101, -336,  80,  361,  66,  464,  194, -158,  223, -87,  50,  416,  449, -63,  302,  337,  308, -404, -182, -176,  84, -346,  113,  112,  430,  05, -254,  63, -154, -321, -359, -201, -156,  222, -340, -238, -462,  354,  456, -386,  120,  06, -470,  421, -205,  332,  258, -397,  429, -71,  279,  365,  83, -108, -23,  365, -250, -425, -72,  96, -246,  69, -253,  450,  143,  260, -287,  182,  114, -331,  296,  86, -472, -322,  360, -177, -138,  118,  279,  143, -101,  58,  08,  482,  451, -163, -301,  53, -88,  127, -351,  167,  49,  248,  469, -308,  08, -318, -274, -25,  204, -126, -439,  232,  404, -227, -93, -233,  392, -314, -238, -209,  245,  271,  126, -452, -40, -323,  101, -275,  305, -398, -256,  206, -298, -287, -250,  211,  248, -23, -314, -48, -297,  99,  36, -392, -275,  443,  227, -383, -18,  489,  260,  79, -388,  238,  127,  73,  416,  80, -350, -427, -466,  246,  279, -264,  459, -119,  447,  207,  358, -15,  11, -86, -63, -101,  22, -486, -157, -251, -369, -323,  90, -257,  256,  203, -166,  235,  128, -250,  167, -370,  175,  201,  376,  306,  437,  335, -313, -263,  395, -454, -426,  258,  312,  363, -342, -166,  377,  353,  435, -140, -470,  377,  456, -362,  80, -210,  373,  60,  392,  40,  190,  67,  93,  66, -127,  30,  254,  412, -381,  149, -190,  46,  259, -378,  261,  417, -44,  491, -378,  243,  203,  04,  121,  159,  142,  53, -199,  15, -386, -307, -93,  304, -388, -500,  223, -15,  383, -23,  250, -146, -374, -440,  400, -263, -317, -486,  07,  491, -495,  129,  235,  208, -366,  208,  220, -372,  113, -479,  144,  227, -285, -97,  384,  179, -96,  107, -335,  139, -416, -233,  493,  62, -173,  394,  299,  10, -240,  158,  02, -235, -212,  89, -175,  274,  149, -455,  402, -238, -81,  398, -158,  486, -198,  78,  165, -442, -315, -318,  197,  121, -51,  190,  35,  277,  436,  186, -213, -304, -155, -359,  313,  485,  230, -361,  259,  231,  36, -487,  494,  455, -236,  188, -207,  418, -234,  459,  476,  303, -359, -475, -76,  91, -433,  459, -132, -144,  145, -493,  52,  490, -351,  218, -173, -269, -291, -414,  463,  245, -48,  457, -447,  216,  497, -154,  134, -237, -195,  462, -434,  299,  487,  342, -110, -94, -347, -390,  262,  298, -383,  167, -359,  118, -115, -32,  350,  94,  407,  313,  191, -141, -378,  244, -73, -381, -57, -439,  234, -400, -477,  300,  399, -138,  494,  141,  268, -353,  251,  383, -203, -279,  50,  290,  339,  435,  111,  189,  29,  18,  02,  72, -271,  476, -183,  156, -405, -388, -431,  329, -288, -56,  481, -36,  306,  475, -395,  426, -26, -291, -339,  272,  282,  211,  62,  121,  146, -327,  163,  27, -457,  17, -400, -228, -06,  269, -220,  89, -267, -151,  271, -55,  293, -396, -239,  451, -420,  219, -270,  406, -220, -109,  178, -438, -397, -259,  183, -399,  266,  198,  481,  310, -284, -67, -66,  210, -298,  215,  151,  287, -436,  274, -268, -290,  379,  346, -339, -189,  65,  243, -283,  345, -365, -252, -241,  90,  341, -206, -457,  107,  493, -476, -83, -291, -43,  352, -229, -489,  419,  422,  298,  483, -451, -117,  45,  428,  81, -441,  91, -02,  302, -340, -157, -211, -92,  454, -269, -251, -252, -225,  357, -259,  151,  126,  302, -39,  330, -427, -28,  249, -152,  123, -415, -103, -142,  130,  177,  439,  189,  120, -63, -08,  280, -368,  281, -311, -414, -487, -62,  186,  140,  147,  428, -209, -226,  230,  252, -44, -344,  77, -294,  04, -300, -209, -247,  410, -227, -218, -299,  463,  402,  138,  307,  182, -378,  440, -277,  60, -195,  162, -254,  445,  161, -326, -263,  435, -243, -159,  244,  265,  418,  450, -231, -30,  93,  374, -120,  366, -344,  81,  329, -442,  71,  488, -408, -455,  429, -184,  105, -266, -170,  352, -320,  491, -122,  269, -221,  487, -390, -477,  252, -119,  473, -479,  351,  418, -253,  84,  284, -97,  17,  466,  313, -59,  454,  406, -14,  383,  74, -408, -30,  404,  444,  150,  395,  174,  271,  26,  162, -267,  49, -86,  114,  374,  288,  318,  292, -465, -98,  429,  291, -229, -253,  104,  212,  53,  362,  51,  289, -64,  143, -241,  192,  439, -239,  88,  465, -468, -386,  127, -235, -484, -106,  380,  390, -318,  198, -465,  69, -48,  464, -140, -425,  63, -183, -360, -384, -321,  191,  405,  468,  186,  16,  160,  477,  277,  100,  442, -339,  215,  70, -73, -417,  464,  159,  473, -02,  209, -492, -433,  13, -176, -72,  88, -261,  245,  228, -144, -224,  271,  113, -256, -43, -18, -243, -66, -241,  357, -123, -79,  424, -201, -300, -493,  115,  359,  481, -387,  420, -159,  32, -67, -482, -188, -479, -243, -91, -398,  465,  186,  373,  431, -218,  183, -87,  39, -31, -476, -103, -302, -55, -179, -03,  145,  181, -36,  356, -486,  429,  276,  207, -38,  61,  225, -374,  435, -165,  36, -463,  152, -278, -238,  83,  356, -203,  496,  248,  267, -479, -355,  465,  318,  318,  315,  316,  351,  131, -476,  365,  61,  301,  73, -125,  214,  150,  01,  149,  485, -111, -462,  138,  463,  153,  73,  320,  450,  422,  68,  217, -205, -435, -465, -387, -265, -298, -219, -413,  333, -194,  452, -106, -41,  25, -379, -327, -324,  475, -325,  13, -136, -287,  03, -172,  366, -71,  00, -331, -149, -432, -262,  146, -367, -227, -389, -132, -25,  245,  307,  161, -97,  260, -445,  362,  137,  29, -113, -335,  04,  414,  179, -280, -372,  34,  48, -154,  463, -452,  15,  166, -32, -394,  164,  453,  231, -372,  174,  59,  373, -19, -280, -224, -259,  127, -10, -269, -344, -271, -104, -488, -356, -73, -267,  124,  462, -367,  470, -223,  34,  338,  444, -146, -204,  108, -192, -473,  236,  482,  86,  461,  315,  306,  89, -91, -66, -421,  140,  442,  161, -464,  455, -343, -36,  40,  281,  278,  173, -397, -445,  59, -207, -149,  414,  89,  460,  74,  117, -452,  408,  55, -138,  223,  214,  451, -368,  00, -117, -376, -58, -104, -339,  249,  53,  477, -211, -166,  255, -185, -63, -338,  374, -417,  14, -360,  172,  326,  214,  141, -274,  122,  49,  440, -154, -237,  392,  330,  263,  127,  455,  57, -477, -32, -193,  76,  297,  96, -238,  404,  411, -449, -434, -362, -366,  432, -222, -341, -390,  493,  300, -163,  467,  201, -223, -187,  464,  21, -04, -421,  00,  303,  137,  23,  123,  444, -49, -80,  40, -435, -176,  304, -383,  242,  442,  103,  175, -280,  262, -363,  65,  415,  326,  33,  116, -396, -302,  433,  477,  194, -488, -22,  349,  149, -147, -28,  93, -343,  392, -14, -278,  68, -210, -161, -189, -268, -205, -162,  304, -443, -25, -130, -176, -198,  403,  441,  258, -399, -274, -413,  296, -262,  65,  497, -260, -229, -30,  333, -72,  214,  171,  150, -217, -187, -158,  446,  45,  137, -216, -150, -454, -389,  220, -129,  265,  475,  164,  375, -424,  390,  463, -276, -372,  380, -278, -132,  03,  192,  54,  431,  258,  77,  434, -459,  391, -224, -161,  288, -235,  475, -362, -189, -61, -290,  182, -296, -315,  198, -420, -238,  88, -105,  338, -431,  127, -440,  289, -369, -396,  195, -438,  363, -227, -152, -244,  16,  124,  448, -196,  389,  423,  295, -299, -138, -495, -265,  419,  43, -214, -149, -343,  374,  246,  495, -205,  225, -92, -415,  356,  364, -368, -229,  227, -95,  119, -164, -227,  96, -216,  78, -15,  59, -127, -462,  422,  230,  126,  341,  125,  412, -308, -366, -362, -210, -18, -66, -485,  390,  371, -276,  254, -497, -05,  334,  261, -34,  22, -466, -438, -342,  464,  400,  217,  189,  438,  491, -80,  416, -316, -103,  328, -124,  32, -181, -482, -486,  253, -114,  404,  476,  110, -490,  479, -43, -304, -408, -225,  218, -21, -162,  376, -57,  90,  94, -367,  28,  85,  405,  297,  270, -198,  125, -02, -314,  444,  369, -300, -451, -245, -44, -475, -283,  319, -143, -474, -485,  301, -199,  234, -220,  491,  110, -424,  81,  56, -291, -38, -06, -34, -241,  116, -380, -264, -34, -193,  33, -165,  359,  82,  442, -184,  460,  11, -365, -183,  37, -350, -382, -309, -264,  251, -318, -301,  327, -384,  255, -112,  430, -251,  354, -311, -283, -174,  277,  184,  133, -190, -481, -07,  393, -186, -339, -295,  325,  148,  22,  215, -350,  492,  406, -113, -405, -412,  86,  422,  56, -159,  162, -14,  443,  16, -473, -340,  343,  305, -304,  328, -385,  68,  173, -140,  382,  334,  65, -441, -18, -61,  274,  133,  284,  180, -480,  379, -379,  458, -346,  177,  151,  316,  16,  94,  185,  43, -393,  380, -152, -197,  208,  316, -277, -118, -324, -395,  68, -406,  17, -449,  33, -209, -464,  169,  472, -92,  49, -55, -134,  203, -378, -483,  371,  490,  464,  56,  34, -77, -64, -266,  226, -03, -450, -198, -269,  79,  259,  299,  173, -224,  350,  58,  68,  386, -272,  40, -206, -371, -163, -488, -316, -41, -470, -445,  302,  494,  464, -164, -83,  252,  422, -05, -251, -175, -351, -20,  404,  409, -220,  429, -315, -18,  339,  253,  221, -433,  145, -133, -304,  482, -120,  232,  294,  262,  288,  96, -392,  252, -216,  377,  04, -294,  224, -394,  31,  374,  86,  287,  283, -282, -432,  468, -447,  408, -426, -374, -173,  219, -07,  376,  202, -275,  108,  348,  487, -104, -56, -405,  00, -420,  472, -495, -214, -451, -37, -330,  423, -451,  457,  206,  120, -474, -474, -475, -214, -400, -349,  113,  320,  144, -11,  374,  370, -402, -426, -291,  346,  18, -195, -153,  98,  129,  204, -264,  178, -333, -94,  453,  68,  216,  159,  40, -406, -462,  65, -120, -362, -432, -155, -190, -435,  335, -316,  435, -215, -242, -04, -369, -372, -347,  330, -422,  283,  34,  167,  313, -447, -75,  267,  122, -359,  278,  14, -265,  316, -420,  467,  455,  00, -187,  117,  65,  00,  302,  352,  285, -88, -151,  416,  393,  02, -401, -177,  137,  133,  490, -49,  187, -84,  70,  161,  409,  200, -325, -03,  17,  107, -36,  324, -392,  277, -59,  173, -223,  95,  26, -86, -140, -273,  183, -247,  229,  282,  428, -133, -85,  419, -330, -46,  187, -408, -33,  96,  292,  495, -407,  161,  102,  410,  337, -438, -461,  131, -412,  169, -274,  114, -417,  438,  341,  266, -309,  422,  400, -28,  141,  168, -109,  311, -378, -70,  403,  442, -122, -452,  437,  324,  209,  391,  234,  399,  454, -375,  30, -458, -354,  256, -492, -270, -453, -299, -152,  90, -377, -251, -438,  265, -231,  305,  428, -109, -265, -316,  185,  466, -268,  474,  290, -207,  366,  376, -308, -328, -147,  222,  66,  00,  331,  74, -418, -270, -373, -70,  320,  102, -469,  383,  219, -200,  188,  148, -456, -224, -316, -419, -258,  268, -444, -116, -439,  422,  112,  106, -406,  465,  180, -488,  317,  363,  86,  399, -407, -435,  182,  414,  167, -435, -351, -113, -134, -311, -113,  262,  317,  71,  343, -441,  191,  399,  295, -396, -327,  259,  210,  119,  225,  243,  131,  394,  458,  69,  294, -96,  134, -24,  170,  154,  41,  319, -107, -241, -492,  280, -127,  326,  203, -283, -263,  246, -32, -115,  350,  494, -356,  413,  113, -279, -492,  97, -384,  466, -334, -238, -130, -347,  238, -460,  307,  131, -289,  52,  391,  72,  184, -236, -102, -113,  333,  487, -15,  154,  224, -165,  148, -279, -252,  113,  294, -244, -290, -238,  75,  229,  24,  445,  382,  114, -162, -459, -254,  49,  93, -363, -379, -223,  253,  371, -484,  439, -289,  01,  93,  435, -312, -259,  08,  289, -294, -197, -455, -83,  65,  472, -02, -410, -230, -120,  204,  108,  273, -198, -343, -134,  291,  131,  495,  45,  02, -489, -16, -435,  364, -71, -499, -448,  170,  09,  341, -272, -336, -261,  145,  230, -289, -05, -328, -19,  375,  376, -59, -500,  31,  451, -134, -178,  82,  213,  367, -64,  224,  203,  02,  440, -368,  355, -155, -346,  216, -314, -117,  381,  277, -120,  111,  489,  376,  283,  322, -397, -489,  116, -396,  42,  67,  322,  365,  01,  36, -416,  437,  112, -360,  291,  405, -228,  498, -250,  279,  215, -64, -338,  448, -286,  394,  59,  55,  270,  194,  229, -274, -443, -155, -170,  452, -236,  04, -331,  265, -460,  105,  203, -495,  245,  346,  410, -130,  345, -340, -351,  60,  96, -189,  08, -338,  57, -81, -431, -172, -35, -349,  54,  374, -04, -264,  326,  261,  240,  495,  26, -367,  453,  81, -362,  198, -72, -452, -432, -227, -292, -283, -315, -344,  380, -455,  171, -62, -36, -408, -382, -219, -257, -476, -345,  240, -240, -166,  353, -148,  181,  231, -15,  134, -187,  123, -167, -407, -477,  253,  218,  83,  471,  403, -408, -297, -200,  263,  493, -384,  355, -389, -103, -49, -365,  404, -309,  247, -262, -104, -400,  420, -373,  437,  406,  292,  413, -261, -263,  436,  493,  455,  372, -184, -290,  464,  371,  362, -421,  365,  478, -214, -172,  227,  237,  316,  132, -220,  415, -278,  176, -133, -358, -344, -195, -451, -200, -282,  140,  390,  06,  485, -303, -122,  153, -92,  194,  377, -230,  273, -406,  101, -88, -78, -172, -351,  90, -188, -70,  06,  35, -42,  373,  177,  466, -322, -422,  119,  248, -429,  09,  107, -92,  206, -163, -438, -34, -468,  439, -411, -343, -467,  190,  69,  307, -130, -429, -102,  183,  353,  404, -282, -189, -371, -253,  130, -192,  178,  101, -92,  249, -390, -485, -343, -332, -147,  71,  135,  237,  362, -424,  394, -253, -382, -36, -445, -12,  387,  305,  23,  240, -439,  241, -97, -310, -159, -467, -02, -481,  134, -241, -380, -404, -226, -223, -235,  479, -299, -248,  216, -437,  180,  111, -189,  298, -73,  218,  138, -186,  23, -338, -446,  84, -245,  309,  274,  96,  343,  125,  115,  329, -264,  235, -222,  362, -135,  395,  342,  66, -01,  58,  481, -321,  21,  144, -171, -200, -138,  467,  466, -263, -371, -128, -327, -115, -318, -200,  481, -123,  425,  449, -294,  13,  184,  336, -125, -99,  231, -283, -181, -270, -372, -199,  261, -499,  445, -410, -198,  160, -442,  120, -251,  39,  493, -77, -224, -325,  223, -242,  52, -500,  59, -390,  13,  95,  447,  388,  497, -470, -42, -184, -239,  86,  469, -126,  439, -233, -35, -259,  427,  23,  362,  28, -86, -293,  451,  191, -118, -474, -199,  434, -474,  360, -104,  391, -45, -157,  280,  304, -126,  90, -379,  487, -324, -410, -139, -385,  209,  326,  209,  488,  201,  423,  17, -32, -370,  320, -341,  364,  347, -40,  298, -275,  172,  46, -383, -373,  390, -251,  432,  116,  339, -95,  103, -133,  347, -184,  334,  57, -357,  395,  45, -304, -330, -438,  164, -200,  383, -325,  16, -418,  487,  166, -193,  159, -287,  276, -361, -397, -123, -429,  219,  68,  328,  174, -213,  175,  490, -378,  84, -15, -131, -370, -466,  40,  44, -450, -308,  279, -274,  209, -287,  65, -125,  21, -275,  88,  149, -136, -457, -473,  287, -386,  447,  115, -360, -265,  142, -369,  209, -273,  468, -422,  209, -146,  470,  105, -95,  15, -115,  483, -276,  98,  48,  451, -29, -375,  392, -27, -11,  435,  352, -224, -98,  299, -257,  42, -466, -262, -475, -405,  317,  494, -326,  26,  200, -04, -369, -43, -489,  368, -60,  87,  319, -159,  39,  142, -34, -69, -385, -192,  218,  467,  84, -380, -381, -320, -485,  05, -82, -460,  101, -265, -114, -373, -387, -413,  123,  96,  44,  487, -35, -163,  74, -216, -470, -35, -222, -04, -252, -106,  304,  467,  213,  241, -61,  332,  421, -46, -162,  191,  347,  439, -222,  85, -434, -109,  172, -459,  487,  69, -472,  304, -242,  103, -60, -212, -432,  219,  284, -183, -387,  441,  136,  326,  182, -73, -489,  455, -266,  201,  498, -419,  492, -224,  166, -90,  167,  191, -49, -494,  112,  332,  311,  370, -65, -249, -342,  355,  470, -206,  24, -65, -265,  12,  114, -231,  440,  125,  76,  26,  178,  74,  459,  170, -298,  477, -420, -279,  168,  31, -272, -220,  215, -109,  02, -350,  142,  160, -142,  465, -193, -266,  252,  42,  247, -134, -336, -461, -157,  240,  417, -479,  167,  376,  191,  369,  353, -377, -57,  22, -493,  171, -346,  222, -86, -491, -275, -444,  169,  435, -127, -172, -331, -374,  371, -232, -08, -113,  159, -312, -21,  76,  61, -02, -48, -247,  220, -194,  228, -337, -320,  235, -314,  186,  310,  100,  195, -465, -492,  217,  470, -118, -455, -09,  08, -232, -388, -148, -493,  271,  392, -13,  200, -46,  485, -348, -441,  205,  310,  287, -280, -158,  375, -94, -119,  185, -494, -424, -428, -485, -355, -458,  249,  43,  385,  109,  311,  497, -187,  319,  269, -294,  158, -31,  160,  495,  473,  219, -447, -364,  358, -227,  330,  233, -468, -289,  270, -462,  140,  342, -95,  285,  384, -346,  180,  270,  263, -08, -381, -423,  163,  388,  135,  173,  209, -205,  168, -465, -134,  221, -329, -276, -153, -147, -190, -121,  65, -420,  269, -295,  423, -325, -158, -341,  181, -477, -219,  297,  367, -99, -274,  382,  141,  361,  55, -149, -344,  75,  238,  374,  149,  409, -402, -152, -238,  260,  227, -321,  341,  348,  236, -384, -477, -69, -225, -443,  306,  57,  354,  173, -190, -420,  407,  451,  441,  314,  154, -51,  241, -108, -177, -110,  153,  273,  238, -232,  34,  317, -53, -125,  166, -316, -09, -459,  467, -382, -402,  273, -473,  452,  298, -163, -116,  205, -211, -175,  371, -205,  274,  112,  188, -51, -497, -159, -277, -407,  109,  257,  411, -91, -16,  77,  445,  475,  470,  412, -55, -431,  185, -27, -127, -17,  310,  258,  40, -49, -417, -89,  247, -290, -477, -65,  159, -122, -372,  382, -28, -410,  491,  235, -01, -25,  164,  296,  302,  134,  208, -252, -445,  245,  221, -71,  80,  383, -313, -380, -165,  122,  383, -66,  332, -242, -279,  344,  137, -151, -422, -39,  291, -78,  48, -210,  397, -288, -414,  200, -302, -354, -200, -246,  391, -127,  183, -29, -244,  370,  443,  443,  344, -322,  229, -471, -63,  450,  373, -74,  152, -197,  387, -57,  225, -65, -414,  123,  499,  24,  175, -303,  171, -173,  303,  414,  200, -14,  238, -192,  208,  181,  104,  405,  360, -167,  434,  149, -216,  307, -425,  436, -38, -186,  231, -312, -399,  317, -337, -400, -158, -310,  149, -487,  17, -47, -221,  69, -209, -483,  377, -148,  199, -19, -243,  411,  315, -309,  412, -49, -150,  487,  239,  312, -199, -30, -148, -98, -212,  15,  354,  482,  205,  03,  495,  74, -192, -226, -357,  452,  144, -127, -196, -157, -294,  413,  106, -479, -44,  370,  324,  306,  357,  63,  470,  10, -466, -177, -236,  174, -310, -382,  156, -252,  473, -497,  322,  134,  129, -182,  86, -227,  191, -258,  468,  397, -345,  74, -229,  111, -56, -405,  269,  153, -489, -409, -337, -455, -86,  279,  219,  457,  397, -125, -295, -277, -122, -121,  357, -141,  197, -57,  133, -112,  185,  101,  138, -308,  28, -239,  303, -176,  208,  424,  478,  219, -485, -07,  264,  282, -227,  335,  239,  22,  62, -204,  245, -208,  175,  102,  152, -127, -103, -215, -387, -418, -262,  251, -226,  266, -488, -71, -409,  221, -147, -79,  292,  221,  414,  409,  03,  39,  244,  94, -86,  159,  390,  11,  451,  65, -386,  455, -210,  11,  92, -96,  446,  331, -345, -280,  97,  20, -498,  188,  93,  207, -39, -115, -72,  228, -206, -217,  119, -109, -271, -467, -450, -381,  45, -147, -463, -489, -191, -173,  22, -247,  231,  320, -416, -261, -107,  182,  259, -105,  222,  204, -46,  36, -59,  383, -236,  236,  18,  383, -21,  248,  417,  29, -281,  314,  382, -244,  325,  43,  84,  199,  297,  167,  20, -267,  406,  413, -233, -483,  160, -158,  221, -386,  378, -337,  497, -358, -249,  368, -475,  230,  116, -206,  111, -313, -392,  345, -56, -215, -111, -472,  485,  38,  195,  05, -377,  454,  270, -109,  471, -70,  233, -455,  44,  111,  60,  394, -395,  311,  262, -370,  393,  230,  277,  04,  417,  385, -151, -139, -329, -410,  241,  08,  480,  289, -135, -396, -405, -365, -05, -434,  65,  80, -37, -391, -309, -477, -497, -204,  334, -383,  278,  227,  347,  55,  83, -383,  293,  433,  330, -184, -477,  424,  324, -144, -435, -311, -40, -340, -176,  455,  78, -259,  387, -458,  202, -422, -435,  206,  226, -248, -325,  04,  479, -125, -88,  415, -08, -295,  348,  174,  373, -277,  98,  197,  79,  163, -262, -461, -325,  414, -154,  254,  07, -267,  296, -291,  163,  361,  415, -111, -387, -57, -254, -55,  318, -490, -140, -190,  67,  60,  484, -60,  283,  435, -11,  215,  98, -421, -394, -374,  493,  305,  380,  00, -462,  176,  209, -446,  389,  477,  295, -145, -80, -107, -348,  90, -97,  364, -248,  470,  276,  88, -90,  411,  23, -249,  126, -26, -170,  233,  100,  175,  38, -20, -325,  428,  08, -263, -166,  249,  66, -370, -44, -162,  23,  460,  428, -221, -324, -320, -251,  452, -380, -488,  364,  144, -237, -10, -30,  94,  75, -430,  121, -35,  402,  297,  246,  262, -114, -420,  363,  452, -290,  172,  142, -414,  132,  422, -135,  309, -398,  466, -387,  74,  478,  477, -282,  94,  320,  188, -312,  247, -390,  309, -287, -488,  458,  459, -374,  196, -109,  490, -500,  102, -486,  142, -460,  146,  64,  257,  307, -482,  223, -227,  93,  202, -250, -337, -204, -78, -296,  336, -330, -186,  497,  235,  179, -192, -454,  305, -496, -63, -353, -495, -109,  13,  499, -69, -340,  64, -312, -181,  434,  412,  92,  379,  466, -305, -457, -238,  469, -253, -50, -09,  413, -53, -274,  92, -393, -228,  250, -388, -438, -251, -31, -47,  263, -32,  385, -225, -116, -75,  446, -181,  189,  391, -302,  155, -414,  93, -231, -93,  340, -429,  399,  254,  371, -23,  198,  478, -398, -52, -410, -336,  198,  59,  117,  313, -120,  354, -412,  264,  132, -466, -65, -179,  425,  134, -171, -137,  79,  450,  271, -80, -478, -478,  26,  393, -01, -276,  371,  101, -475,  462,  265,  223,  373,  235,  36,  105,  89,  476, -130,  73, -490,  305,  395,  436,  291,  76,  151, -129,  26, -78, -357,  48, -56,  169, -59,  444, -255,  165,  397, -230,  479,  163, -155,  352,  250, -267, -42,  191, -291, -320, -235,  72, -163,  12,  08, -371, -412, -341,  352,  114,  434,  495,  15, -122, -484, -192,  174,  113,  473,  72,  384,  452,  87, -271, -343, -163,  315,  467, -472, -476, -353,  145,  96, -16, -343, -44,  465, -255,  468, -331, -288,  402,  16,  227,  132,  32, -465,  159, -354, -139,  83, -118, -187,  22,  463, -30,  359,  278, -63, -261, -345,  436, -263, -397,  273, -106,  412, -410,  492,  380, -240, -296, -366,  276, -217, -382,  161,  170,  277, -341, -469,  212,  41, -155, -266,  356, -333, -55,  135,  105, -463, -358,  393, -226, -255,  166,  168, -343,  257,  160, -111, -131, -284,  23, -355, -01,  142, -342, -330,  271, -183, -299, -16, -290,  398, -430, -433, -434,  16, -446, -477,  53, -304, -232,  327,  293,  435,  347, -197, -456,  360,  192, -87, -424,  68,  410,  428,  62, -79, -50, -167,  238, -497, -331,  449,  402, -260, -132,  468, -392, -78, -157,  161,  470,  111, -12,  263,  398, -165, -434, -206, -305, -389,  207,  124,  179,  470,  52, -259, -109, -498,  426, -19, -495, -404,  282, -241,  188, -350,  79,  296,  72,  422, -43,  42,  386, -203,  158,  284,  484,  224, -421,  32,  335, -362, -344,  366, -40, -440, -393, -297, -86, -466,  185, -81, -18, -33, -469, -330,  470,  110, -182,  42,  385, -373, -63,  271, -76, -405,  407,  260, -329, -162, -208, -141, -23,  300,  77, -211,  360,  185, -07, -226, -429, -322, -454,  53,  497, -423, -425,  467,  187,  245,  362,  424,  372,  151,  195,  148, -402,  103, -92, -231,  441,  201,  480,  270,  01,  58, -440,  214,  95,  405,  488,  166, -65, -114,  71, -68, -37,  498,  252,  03,  243,  114, -73,  115, -235, -25, -237, -137, -70, -477,  484,  223,  224, -183,  346,  78, -273, -242,  144,  322, -337,  132,  340,  98, -129,  263, -470,  334,  261, -366,  189,  04, -400, -31, -381, -135,  444,  234, -420,  226,  257, -83, -51,  334, -414,  147,  264, -187,  405, -92, -13, -432, -108,  179,  166,  263, -58, -451,  450, -297, -317,  139,  207, -216, -392, -322, -499, -96, -236, -66, -18, -479, -297, -216, -293,  141,  431,  471,  454,  337,  231,  293,  405, -376, -28,  424,  387, -234, -175,  337,  321,  360, -23,  28, -04,  437, -442, -02,  194,  174, -216, -324,  195,  339, -40, -245, -20, -108, -274,  286,  81,  458,  79,  338, -66, -97,  262, -179, -479, -61, -341,  342, -200,  488,  222,  296, -223,  280,  146,  471, -46,  430,  00,  01, -379,  460,  256,  101,  204, -165, -113,  137,  145, -182, -24, -421, -427,  90,  252, -406, -470, -237,  436, -170,  103,  158, -22,  381,  290, -375, -296,  96, -93, -444, -402,  29, -131, -294, -370, -427,  393,  370,  211,  390, -312,  39, -179, -238, -371, -426,  208,  11, -163,  145, -307,  441, -197,  172, -326, -54,  297,  230, -458,  56,  287, -08, -415, -344, -449,  68,  81,  444,  290,  144, -313, -170, -317,  08,  92,  165,  82,  153, -324, -228, -202, -130,  65,  453, -106,  239, -101, -309, -31, -58,  247,  108,  434, -315, -384, -163, -395,  198, -218,  395, -158,  321, -275,  378, -171, -330,  43, -236,  323, -429,  36, -379,  293, -399, -426, -313, -308,  326, -122, -487, -232, -22,  122,  54, -485,  238,  392, -380,  288,  26, -485, -369, -153, -260, -139, -472,  262, -244, -208,  85, -173, -320, -442, -379, -219, -15,  160, -27, -189, -461,  339,  79,  369, -39, -15, -264,  51,  229, -144, -160, -245,  223,  323,  454, -185, -316,  483, -422,  292, -225,  163, -29, -44, -426,  92, -411,  59,  105,  415,  370,  144,  254,  301,  365,  67,  138, -399, -382, -132,  309,  310,  123,  32,  133,  430, -301, -331,  413, -223,  461,  40, -207, -67, -152, -133, -123, -62,  426,  482,  205, -352,  478, -41,  449, -305, -122,  87,  148, -04, -193, -43,  159,  431, -159, -208,  361,  41, -38, -374, -330,  275,  166, -37,  60, -485, -318,  438,  305, -392, -228,  10,  108, -249, -179,  57, -54,  199, -03, -53,  47,  304, -244, -294, -413,  98,  351, -200, -09,  165,  278,  161,  292, -55, -23, -147,  312,  159, -209,  469, -380,  63,  331,  228, -334, -348,  138,  465, -297, -365, -88, -398, -209,  168,  161,  231,  118,  12, -117, -391,  29, -338, -377, -179,  107,  100,  174,  271, -241, -183, -408, -121,  381,  423, -392, -101, -425,  246, -136,  130, -267,  276, -416,  376,  297,  245,  107, -85,  109,  491,  25, -362, -347,  148,  312, -388,  100,  338, -265,  359, -344, -173,  91, -111, -250,  199,  288,  177,  297, -347,  159, -118, -219,  243, -242, -422, -11, -282, -06, -50, -291, -481,  89,  214, -481,  253, -322,  471,  91, -87,  330,  247, -408, -79, -364,  194, -28, -223, -129,  121, -70, -470, -497,  211, -375, -238,  290,  114, -20, -216, -435, -459,  155, -494, -393, -474, -389, -215,  497,  202, -450, -321,  302, -06,  453, -210, -312, -75,  67,  59, -101,  497,  441, -98, -439, -82, -484,  351, -467,  348, -13, -50,  389, -06,  308,  496,  20,  419,  133,  369,  121, -465, -452,  275,  29, -499, -434,  217,  279,  133,  128, -322,  131,  421,  80,  192, -160,  97,  395,  225,  297, -118, -325,  187,  376, -165, -465,  248, -246, -479,  117, -273, -444, -483, -497,  86, -481, -79,  155, -350, -446, -216, -172, -463,  57, -240,  229,  397, -291,  476,  122, -493,  210, -351,  194,  438,  336, -419,  186, -410, -46,  155,  170,  11,  173, -475, -51, -456, -54, -44, -306,  00, -408,  374,  38,  150, -366,  119,  399, -156,  96,  374,  203, -194, -477,  249, -255,  360,  330, -217, -198, -215, -209,  472, -352,  464,  497,  449, -140,  295, -95,  406, -204, -02, -368, -314,  00, -234,  305, -101,  462,  253, -227,  165, -88,  149, -86,  157,  361,  97, -208,  15, -266,  83, -12,  234,  399,  337,  183,  111,  485, -60,  17, -219, -210,  149,  319,  290, -232,  124,  42,  82,  230, -333,  100, -358,  316, -134, -349, -471, -185, -57,  45,  49, -121, -115, -217, -222,  74, -182,  390,  59,  259,  259, -308, -99,  261, -489, -308, -119,  488, -414,  463,  218, -247,  415,  360, -430, -218, -137, -49,  97, -342,  496, -01,  37, -119, -366, -332,  456, -47, -90,  367,  64, -331, -440,  465,  430, -429,  09, -189, -441,  95,  127, -371, -299,  42, -159,  123, -324,  204, -426, -374, -285, -429,  125,  252,  304,  259, -228, -388,  64,  182,  480, -372,  352, -460, -54, -366, -37, -193,  298,  375,  403,  277, -496, -44,  171, -154, -421,  348, -98, -347,  474,  117,  76,  99,  222, -119,  210,  494, -07, -225,  177,  325,  255,  381, -283, -299, -133,  181,  361, -335,  56, -384, -206,  412,  72,  466,  110,  151,  314, -487,  304, -360,  482,  233, -409,  204, -386,  301,  199,  459, -72,  228, -363, -316,  109, -146,  237,  476, -113,  98, -06, -205,  214, -360, -292,  138, -394,  318, -211, -228, -317, -54, -88, -334, -321,  355,  370,  145,  157,  421,  456, -63,  149, -407,  121, -242, -52,  211,  87,  335,  161, -67, -369,  228,  73,  191, -134, -468,  09,  156, -196, -455, -46, -431, -289,  133, -224, -67,  130,  433, -145,  86,  223, -496,  180,  196,  115, -20, -93,  54,  167, -431, -161,  298,  297, -236, -11,  15, -204, -149, -329,  453,  248,  477, -126,  459,  462,  150,  244,  92,  436, -49,  31,  159,  308,  63, -145, -77, -457, -385, -171,  210,  36, -480,  361,  185, -216, -150, -300,  81, -447,  224,  386,  301,  201, -240, -388,  164,  410, -291, -244, -302,  160, -361,  357, -32,  202,  65, -257,  245,  180,  424,  308, -284,  444,  169,  401, -271, -129, -47, -338,  277, -323, -452,  430,  379, -192, -457,  395,  70,  104,  03, -379, -236,  143, -170,  233, -155,  395, -172, -57,  427, -247, -249, -05, -303, -228,  248, -74,  143, -298,  88, -80, -121,  488, -149,  110,  148,  246,  05,  71,  202, -491,  192,  466,  152, -478, -449, -151, -230, -120,  292, -303,  485, -105, -455, -318,  167,  293,  461,  163,  495,  401, -417,  227,  390,  286,  189,  390,  384, -305, -39,  86,  56, -347,  405, -292, -324, -192,  57,  298,  188,  202,  495, -475, -403, -460, -292,  265, -314,  21,  280,  33, -78, -285,  112,  164, -498, -198,  55, -262, -03, -484, -323, -447,  22, -66,  113, -450,  242,  22,  348,  283, -276, -305,  308,  174, -264, -132,  291,  274,  389,  71, -193,  164,  286,  420,  180, -360, -278,  87, -121, -429,  456,  408, -24, -22, -158, -411,  28, -64,  111,  228, -281, -312,  423, -472,  362,  11,  248,  153, -215,  490, -276,  93, -494, -490,  365,  186, -349, -413,  126,  382,  10,  82, -358,  486, -88,  336, -73, -208, -228, -110, -480, -08,  78,  443,  372,  292,  307,  472, -55, -408,  462, -479, -463,  468, -116,  402, -493,  387, -159,  133, -379,  351,  67, -237, -311,  479, -401,  116,  123,  223, -493,  143,  67,  437,  438, -61,  230,  245,  264,  27,  338,  226,  49, -273, -453, -215, -370, -446, -328,  323, -461, -207,  175,  458,  56, -284,  437, -493,  333,  60,  230, -308,  55, -202, -19, -07, -411, -289,  91,  353,  239,  281,  432,  140, -492,  479,  425, -10, -115, -403, -186,  276,  242, -159,  234,  150,  57, -477,  157,  242,  83,  239, -214, -10, -111,  268, -165, -21,  479,  426,  184, -430,  207,  116, -438, -432,  447, -161,  58,  184, -64,  372, -40,  30, -287, -306, -320, -377, -283,  337,  365, -348,  429,  04,  142, -182, -228, -170,  297,  103, -244,  334, -474, -184, -50, -412, -116,  250, -72, -206, -66, -284, -333,  395,  247,  232, -59,  427,  355, -489, -383, -427,  15, -102,  77,  10,  216,  349,  340,  366,  304, -404,  200,  330,  264,  02,  419, -352,  104,  199, -57, -461,  415,  462, -214, -486,  194,  227, -206,  402, -410,  263,  475,  106, -339,  404, -384, -271,  253,  456, -405,  409, -96, -353,  240, -331, -498,  159, -183,  106,  210, -388,  145,  125, -74,  431,  492, -379, -489, -214, -125, -399, -99,  202, -441,  62,  106, -325,  291,  211, -17, -261,  120,  388, -114, -140, -443, -112, -129,  226, -153, -419, -309,  492, -441,  117, -224, -97,  238, -213,  189, -35,  240, -58, -333,  300, -496,  273, -173, -353, -16,  311,  238, -395,  199, -23,  317, -392,  365,  41,  334, -288,  122, -123,  57, -467,  495,  333, -64, -415, -28, -23,  51,  64,  419,  218,  216, -225, -08, -456,  275, -172, -293,  13,  285, -242,  490,  455, -134, -292, -04,  52,  272, -30,  430,  181,  04,  425,  366, -208, -138, -162, -378,  413, -245, -459,  132,  471,  169, -24, -133,  296, -344,  74, -191, -206,  332,  152, -251,  50, -288,  245, -45,  484, -285,  237,  166, -429, -486,  32, -136, -124, -277,  338, -210, -22,  379, -226,  301,  400, -398, -331,  196, -242, -405, -142,  52, -220, -490,  301,  330, -278,  398,  137,  58, -34, -126,  76,  37, -112, -39, -247,  265,  184, -409, -93,  14, -177,  181, -185,  75,  283,  336, -228, -459,  432,  130,  446, -288,  492, -401, -106,  66,  498, -468, -376, -36,  258,  201, -147, -353,  14,  107, -236, -302, -450,  171, -436, -127,  204,  231,  449, -13,  420,  73,  380,  352,  55,  326, -84,  399,  426,  310, -35,  424, -306,  89,  240, -195,  142, -407,  304, -344,  200, -432,  206, -397, -409, -378, -24,  295,  354,  277,  134,  274,  202,  14,  478, -243, -159,  246, -344,  119,  408,  121,  395, -397,  63,  135, -92,  57,  228,  64,  214,  281,  132,  272,  384, -425,  395,  212, -278, -399,  342,  356, -273,  44, -130, -295, -346, -437,  451, -190,  182,  359, -216,  77, -186, -301, -288, -426,  256, -207,  138,  322, -426,  122,  95, -190, -451, -10, -478, -229,  91,  364, -373,  318,  261,  350, -125,  415,  413,  178,  77,  96,  37,  361,  25, -296, -88, -410,  130, -331, -117, -231,  491,  309, -257,  86, -29, -207, -72,  345,  64, -481,  210, -456, -311,  323,  394,  64,  238,  307, -258, -185,  255, -368,  29, -219, -164,  441,  223,  466, -390, -394,  87, -46, -233, -317, -460,  238,  328,  321,  83, -108,  340,  145,  288, -470, -32,  182,  94,  58,  342, -311,  374,  97, -179, -97, -270, -491, -156,  453, -173,  307, -89,  415, -239, -470, -50,  153, -380, -222, -26,  204, -478,  167,  201,  311,  197,  22,  345,  143, -420,  187, -316, -194,  137,  05, -439, -281,  14, -94,  25,  342,  65, -212, -391,  326, -181,  59,  331, -61, -311, -194, -05, -289,  473,  49, -126, -478, -429, -280, -483,  03, -241, -298, -338, -252, -441, -277, -32,  74,  481,  493,  268,  46, -219,  377,  224,  452,  288,  56, -108,  477, -286,  387,  40,  39,  288,  415,  413, -289, -13,  430, -433,  246, -16, -271,  495,  44,  304,  315, -30,  286,  308, -262,  184, -59, -33, -91, -106, -245, -183, -362,  84,  31, -123, -24, -78, -334,  243, -165, -123, -270,  117, -56, -171, -398, -475,  176,  498,  330, -09, -32,  468,  151, -442,  152, -56,  25, -87,  338, -368,  230,  476, -432,  113,  206,  44, -465,  372, -212,  222,  101,  370, -160, -102, -301,  294, -77,  375, -356,  105, -134,  112,  425, -131,  170,  78,  314,  47, -157,  152,  179, -74,  481,  247, -461,  187,  143, -73,  411, -217,  01,  12, -346,  341,  410, -147,  487,  186, -271, -369, -209,  447, -405, -283, -183, -383, -353, -369,  164, -10, -365, -157,  416, -384, -58, -192, -345, -62, -413, -434,  221,  88,  431,  375,  282,  341, -271, -379,  27, -42, -247, -329,  257, -152, -112, -426, -34,  35,  57, -18, -123,  193, -322,  146, -339,  120, -194, -183, -90, -107,  235, -368, -167,  166, -493, -33,  360, -264,  89, -113, -454, -306,  58, -344,  394, -202, -270,  212, -315,  288, -305,  63,  333, -127,  61,  494, -155,  367,  163,  256,  112, -101,  388, -203, -83, -253,  265, -223,  336,  206, -483, -266,  400,  427, -110, -354, -274,  473,  359, -89,  261, -446, -174,  94,  279,  387,  440, -376,  254,  104, -268,  218, -497, -28, -484,  272,  220, -367, -450,  56,  339, -433, -358, -409, -154,  33, -263,  72,  06, -404,  484,  119,  02,  162,  65, -219,  50,  05,  258,  156, -391,  490, -125, -36,  315,  243, -263,  35, -272,  139, -57, -81, -442,  85,  10, -96, -30, -401,  477, -172,  48, -187, -201, -98,  475,  364,  184,  377,  222,  294,  34, -317, -364, -239, -500,  451, -144,  89,  338,  84, -272, -219, -497,  138, -281,  365, -458, -459,  464, -129, -130,  364, -464,  169, -233, -136,  386, -197, -259,  460, -403, -373, -357, -267,  240, -05,  37, -404, -416, -125,  180, -188, -491, -465,  450, -272,  400, -155,  121,  365,  216,  491,  229,  253, -487, -152, -383, -249,  151,  210, -289,  248, -310, -146, -166,  430,  350,  371, -473, -214,  98, -441,  99,  107, -405,  401, -313,  495, -254,  309, -288, -185, -348, -206, -80,  17,  142,  389,  268, -206,  99,  479, -458,  289,  186,  228,  220,  388,  99, -401, -326, -302, -342, -375, -343, -247, -121, -155,  101,  477,  06,  313, -208,  158, -393,  212, -324,  250,  453, -204, -456,  53, -224, -62,  194, -186, -333,  266, -298, -382,  365,  228,  168, -124,  354,  326,  481, -267,  23,  82, -290, -471, -104,  355, -461,  03,  419, -285,  105,  373,  12, -499,  278, -360, -60, -28, -46,  459,  91, -492, -423,  308,  236, -402, -316,  442,  424, -334,  27,  299,  248, -410,  328, -04,  445,  367, -500,  364, -65,  457, -411, -201,  459,  367,  291, -101, -160, -255, -142, -217,  105,  287, -409, -159,  385,  128,  136, -339,  294, -337,  460,  394, -247, -360, -109, -302, -140,  243, -85,  295,  200,  04, -54,  159, -128, -263, -90, -436,  334, -380,  199, -61,  408,  290, -368, -355,  270,  268,  159,  416,  432,  471,  311,  37, -36,  54,  236,  324, -203,  03,  471, -151, -141, -83, -491, -417, -494,  271, -01, -308,  392, -302,  483, -348, -159, -385,  149, -389, -264,  160, -472, -332,  132,  339,  205, -52,  245,  293, -228, -106,  148,  95,  243, -492, -136, -396, -409, -130,  376,  91,  62, -380, -359,  45, -228, -18, -488, -227,  94, -252,  434,  122,  268,  418,  313,  326, -134,  58,  471,  490,  452,  120,  85, -453,  480,  449,  04, -429,  171,  232, -486,  85,  352, -344, -18, -24,  138, -06,  249,  84, -405, -465, -294,  363,  453, -481, -459,  171,  429, -487,  161, -267,  133,  98, -219,  465,  47, -363, -464, -282,  369, -97, -345, -427,  411,  137,  49,  401, -368,  150, -14,  79,  186,  192, -58,  491, -436, -16,  163, -155,  349, -176,  79,  334,  423, -288,  299,  322, -151, -313, -107, -282,  90,  48,  143,  353, -314, -308,  255,  170, -306, -259, -251,  380, -215,  191,  372,  201,  27,  387, -453,  228, -289,  126,  62, -14, -310, -139, -191,  39,  49, -446, -391, -09,  102,  252, -155,  288, -204, -48, -42, -10,  193,  207,  223, -170,  251,  447, -468,  130,  334, -69, -141, -103, -91, -227,  384,  99,  135,  45, -362,  36,  99,  99, -121,  53, -149, -424, -158,  499,  28, -348, -11,  73, -288,  64,  404, -185,  11, -212,  445, -155, -429,  156,  243, -20,  430,  479, -421,  417,  24,  69,  305, -25, -332, -316, -472,  371, -239,  222,  370,  289, -273,  211, -137, -61, -224,  119,  254, -361, -241, -449, -15, -170,  208,  80,  310,  490,  59, -259,  407, -65,  310,  212,  410,  478, -252, -210,  349,  09, -135, -429,  151,  92,  282, -134, -117, -90, -163, -11,  50,  96,  40, -113, -222,  100,  467, -60,  90,  26,  181,  349, -187, -09,  413,  75,  321, -338,  365,  170, -477,  82, -407,  174, -326, -273, -108,  409,  138,  229, -102,  40, -175,  439,  427,  455,  391,  394, -105,  334,  272, -424,  183, -63,  67,  97, -488,  240, -389, -271,  262, -366,  312,  355, -339, -162, -417,  53, -252, -427, -217,  146,  113,  460,  437,  40,  416,  329,  286, -189,  163,  410,  240,  198, -153,  159,  147,  211, -100,  258,  440, -338, -255,  252, -482, -94, -409, -47,  459, -161,  26, -258, -163, -361,  55, -225, -469, -29, -44, -331, -366, -29, -69, -274, -331, -370,  386,  317,  341, -214,  427,  281, -52, -328,  386,  318,  78,  477, -229,  390,  168, -351, -368, -495,  140, -461,  132,  171,  362, -412, -308,  497,  59,  475,  75, -419, -395, -39,  398,  446, -401, -323, -420,  48, -150,  466,  218, -220, -205, -158, -330,  463, -09,  155, -180, -368, -454, -195, -345,  409, -107,  200, -242, -195,  175,  333, -114,  281, -205,  136, -421, -106, -335, -341, -206,  367, -375, -135,  00, -80,  207,  170,  235,  50,  177, -92, -466,  224,  213,  42,  485, -42, -258, -257, -385,  417, -424,  353, -450,  223,  341, -18, -30, -493,  141,  264,  374, -381, -19, -126,  391, -312, -103,  479, -409, -74, -113, -375,  02, -48,  167, -13,  410, -239,  230, -122,  31, -341, -269,  81, -266, -427, -85,  204, -68, -443, -31, -194,  28,  450, -467, -81, -09,  282, -102,  434, -292, -363, -441,  211,  89, -421,  50,  352, -160,  133, -270,  371,  292,  313,  305, -474,  386, -280, -417, -182,  129,  52,  477, -343,  354, -138,  429,  197, -356,  179,  131,  204,  317, -457,  267,  258, -26, -182,  462,  314,  451, -308, -462, -405, -142, -305, -27, -256,  267,  56,  415, -103, -40, -256,  406,  167,  106,  335,  216,  250,  367, -152, -46, -464,  243, -278,  294, -283,  392,  257, -117, -305, -199, -79, -210,  159,  468, -385, -244,  236, -476,  23, -15, -16,  267,  243,  03, -127,  431, -280, -25,  298,  68, -219,  334,  163,  03,  480,  380,  247,  237, -237,  442, -109, -463,  84, -98, -143,  200,  158, -407,  224, -319,  430,  60, -200,  174, -436,  173,  105, -216,  00,  255, -296,  282,  89,  367, -215,  69, -401, -115,  159, -138, -173, -450,  251,  412,  304, -391,  112, -37,  54,  188,  496, -15, -252,  149,  11, -188,  174, -32,  448, -325, -277, -348,  457, -336, -481,  94, -415, -382,  479,  244,  333, -193, -354,  436,  71,  451, -455, -317,  266,  100, -277, -386, -63, -29, -385, -200, -364,  290,  268, -416,  465, -157,  89,  422,  07,  108,  368,  444, -421,  348, -459, -236,  07, -313, -300, -422, -10,  98,  113,  108,  50,  336, -425,  487,  159, -310, -213, -353,  480, -93, -268, -203,  250,  321, -281,  109,  281, -60,  53, -288, -212,  446,  328, -353, -366, -471,  77,  476,  127, -310,  437, -323, -122, -488,  16, -111,  54, -345,  37,  35,  62, -379, -316,  164, -206, -96,  125, -73, -304,  30,  140, -16, -23, -32,  483,  463,  349,  60, -209, -24, -398, -272, -495,  332,  92,  373, -279, -353, -472, -390, -466,  442, -269, -282,  458,  25,  474,  435,  453, -330, -34,  445, -494, -205, -87, -159,  110, -237,  401,  401, -409, -145, -370, -51, -313, -426,  174, -91,  73, -445,  19,  459,  497, -397,  30, -192,  128,  04, -257,  433, -473, -439,  378, -115, -144,  144,  227,  466, -241,  480, -280,  202, -164,  202,  03,  375,  276, -322,  136, -150, -267,  08,  161,  82,  111, -309,  390,  91,  196, -14,  25, -425,  47,  255,  312, -244,  251,  39,  74, -490,  372, -354, -435,  60,  348,  68, -65,  125,  246, -428, -173,  479,  80,  488,  414,  43, -320,  304, -366, -272,  142, -489,  155, -310, -381, -33,  298,  370, -141,  224,  381,  83,  371,  446, -357,  219,  366,  430,  196,  113, -498, -125,  444,  434,  216,  358,  329, -252, -485,  464,  328,  157, -173, -17, -301, -54, -198, -151, -183, -487, -426,  50,  96, -203,  348,  239, -132,  214, -478, -435,  179, -124,  292,  476, -189,  08,  334, -08,  256, -299, -44,  84, -289, -364, -81, -90,  82,  222, -388, -249,  235,  38,  301,  184,  335,  149, -77, -297,  216, -55,  120, -105,  322, -87, -129, -15, -227,  58,  477, -118, -389,  286,  466, -178, -226,  238, -415,  356, -40, -303, -392,  47,  235, -239, -269,  70, -237, -493, -375,  479,  304, -402,  226,  478,  363, -50, -37, -364, -492,  293,  18, -29,  431,  337,  294, -295,  75,  379, -87, -113, -424,  373, -214,  311, -365,  18,  233, -102,  377, -290,  229,  181, -192,  307,  160,  23, -243, -25, -488,  117,  120,  382, -411,  403,  219, -265, -392,  146, -386,  22, -115, -310, -105,  172, -147,  382,  42, -62,  132,  271,  148,  213, -48, -191,  21, -36,  332, -370, -208,  344, -400, -236,  227,  41, -332,  298,  276, -224,  297,  390, -350, -318, -68,  398, -294, -363, -368, -400,  75,  265,  371,  75, -22,  176,  384,  499, -08, -431, -18,  284, -235,  82, -451,  492, -377, -283, -357,  399,  345,  440, -359, -152, -26,  73,  98,  181,  210,  230, -367,  137, -05, -495,  64,  474,  181, -51, -175,  25,  370,  307, -190, -365, -111,  211, -372,  364, -220, -229,  263, -375,  63,  404,  325, -463,  329, -77, -430,  391, -346, -296,  28, -499, -291, -407, -173, -258,  394,  153,  267,  264,  312, -71, -249,  54, -360, -121, -82, -80, -498, -318,  398,  417, -62,  223,  455, -232, -01, -475,  11, -495,  81, -108, -494,  290,  337, -166, -116,  231,  487,  04,  347, -349,  433, -402,  205, -74,  330, -376, -302, -316,  158, -404, -46, -404, -328, -91,  216,  171,  286, -272,  176, -132,  120, -466,  10, -43, -132, -253,  40,  207, -397,  239,  359, -464, -311,  64,  314, -129, -460, -487,  56,  198, -391, -138, -353,  133, -377,  363, -196,  409, -57, -168,  129, -85, -133, -08,  372, -413, -409,  264,  295, -306,  03, -494,  82, -455,  422, -103, -84,  463,  262, -176,  161, -277,  186,  308,  357,  309,  172,  13, -429, -33,  346, -448,  383,  65,  44, -393, -496,  487,  372,  299, -319,  227, -343, -384,  272, -420,  365,  41, -457,  127,  365,  204,  350,  52,  365,  207,  213,  389,  73,  284, -144, -81,  337, -261, -164,  233,  199, -160,  221,  71, -08, -246,  150,  149,  222,  275, -419,  87, -184, -376, -286, -319, -319, -83, -415, -454, -24,  299, -213, -451,  435,  143,  320,  272, -265,  08,  358,  434,  349,  79,  357,  193, -315,  359,  194,  408,  134,  276,  347,  450, -248, -86, -16, -67,  331,  421,  331, -193, -428, -382,  209, -492, -386,  29, -368,  201, -462,  490,  487, -261,  421,  344,  432, -41,  203,  478, -133,  190,  254,  66,  492, -141,  480,  328, -356,  311,  250,  476, -29, -326, -54, -320, -318,  412,  209, -185,  113, -401, -195,  452, -162,  79,  296,  122, -462,  352,  101,  257,  42,  207, -177,  34, -434, -196, -137,  63, -33, -35,  39,  438,  139, -163, -30, -326,  102, -320, -11,  67,  131, -354,  20, -178, -423, -184,  444, -385,  20,  397,  372, -438,  457, -304,  449, -125,  352,  164,  438, -181, -19,  329,  110, -380, -333, -420,  146, -379, -240, -365,  188, -256,  134, -292,  66,  211,  377,  10, -321, -103,  260, -449,  312,  217,  99, -387, -408, -49, -371, -117, -377,  110, -288,  233, -418,  231,  313,  229,  352, -74, -284,  41,  170,  350, -399, -264,  414,  478, -402, -407,  228,  358, -04,  40,  427, -404, -495, -128,  47, -366,  255,  170,  244,  467,  255,  326,  199,  69,  407,  51,  495, -376, -56,  165, -174,  46, -247, -260,  24, -149,  185,  104,  62, -318, -356, -11,  130,  01, -287,  29,  135,  468,  52,  231, -212, -193,  410,  487,  376,  317,  390,  371,  441,  187,  36,  120, -267,  289, -288, -391, -07,  398,  214, -445, -68, -290,  396, -438,  212, -38,  91, -153, -70, -357, -69, -430,  303, -159, -443,  179, -342, -200,  51, -48,  487, -61, -428, -280,  81,  136,  181, -74,  34, -105,  333, -182,  106,  229,  232,  170, -309,  176, -131,  474, -329,  300, -456,  474, -359, -46,  154,  152, -394,  57, -44, -407, -152,  380,  165, -219,  16,  198,  207, -97, -406,  40, -427, -448,  122,  306,  222, -335, -18, -57, -09,  153, -256,  36,  128,  237, -158,  134,  241, -52, -309, -303,  393,  39, -71,  410,  321,  446,  108,  380,  201, -446, -79,  274, -42, -105,  80,  32,  60, -438,  476, -448, -432, -280,  440,  196, -191, -218, -170, -449, -418,  373,  100, -173,  264, -470,  89,  437,  476,  49,  318, -471,  104,  91,  303, -86,  486, -116,  447,  46,  298,  423,  450,  366, -05,  390,  414,  304,  24, -256, -293,  458, -31,  308, -215, -266, -310, -274, -329,  18,  276,  489,  47,  232,  432, -150, -354,  418, -414, -55,  317,  385, -132,  267, -397, -285,  158, -482, -128, -318, -238,  79, -359,  232,  239,  278, -182,  429, -143, -11, -53, -367,  331, -154, -283,  263,  197,  215, -466, -365, -339,  351, -480,  381,  118, -24, -403,  128, -06, -31,  311, -392, -100, -196, -308, -360, -66,  10, -79,  291, -500,  369, -224, -317, -285,  345, -202, -236,  61, -168, -100, -426,  35,  272,  455, -346, -252, -448,  282,  242,  373,  445,  351, -226,  101, -105, -86, -464,  406,  335, -321, -242, -444, -44, -59,  124,  153,  239, -260, -286, -76,  492, -212,  459,  265,  96, -35, -135,  148, -252, -40,  22,  45,  163, -352, -353, -442,  62,  35,  464,  249,  214, -278, -342,  22, -485,  282, -324,  255, -126, -110,  31, -133, -469,  342, -16,  127, -192,  349,  127,  408, -191,  01, -47,  472,  149,  452, -117,  63, -13, -153, -187, -298,  422, -29,  224,  437,  105, -248, -456,  479,  143,  75,  198, -474, -82, -318, -495, -422, -468,  132,  486,  193, -366,  291, -482, -365,  244, -99,  199, -269, -400, -488,  285, -478,  335,  362,  460,  292, -386, -496,  271, -391,  432, -30, -365,  202, -496, -360,  280, -464, -375, -382, -418,  111,  409, -400,  246, -495,  01, -55,  89,  101,  309, -126,  124,  144,  88,  436, -64,  203,  440,  60,  312, -276, -118,  448,  426, -114, -60, -442,  275,  417, -324,  357,  28, -62,  457, -225,  295,  310, -428, -116,  263,  382, -389,  239,  378,  199,  175,  167, -98,  468, -273,  67, -308,  109,  367, -29, -153,  159,  29, -378,  77,  206,  479, -395, -04,  436,  232, -209, -402, -343, -472,  362, -461, -361,  101, -231, -310,  129,  436,  445,  97, -337,  12, -359, -376, -121,  112, -28, -110, -358,  94,  467, -300,  426, -75,  196,  362, -343,  487, -187,  166, -133, -325, -443,  06, -372, -173, -451,  257, -237,  494, -146,  279,  358,  348,  403, -263, -40,  227,  127,  454,  174,  447, -346,  100, -128, -298,  314,  381,  42, -373,  48,  409,  154,  105,  268,  283, -216,  317,  40,  48,  311, -253, -173,  169, -405,  82, -242,  407,  162, -263,  362, -164, -316, -132, -212,  408,  71, -398,  290, -387,  82,  190, -478, -264,  147,  290, -129,  432,  107,  412,  332,  270,  11,  11, -61,  106, -407, -451,  365, -393, -213,  227,  295,  323, -404, -417, -416,  167,  38,  374, -368, -28,  416,  06,  208,  63,  149, -68,  347,  108,  196,  179, -121, -293, -310, -330, -335,  136,  72, -470,  243, -289,  258,  39, -466, -294,  122, -382,  373,  12, -156, -143,  484, -240,  363, -455, -324,  12, -23, -477, -379, -327,  203,  352, -120,  393, -478,  397,  381,  446,  427,  125, -343, -463,  16, -308, -257, -10,  162, -32, -497, -141,  325,  487,  471, -459, -468, -353,  53,  361,  23, -474, -466,  78,  378,  266,  323, -247,  163,  205, -301,  443, -170, -143,  480, -302,  401,  76,  188,  415, -456,  191, -226, -278,  179, -254, -237, -437,  245, -332,  425, -232, -305, -189, -302, -75, -70, -478, -470, -407,  227, -270, -112, -91,  439, -131,  107, -308,  445, -205, -393, -159,  487,  234,  63, -482,  480,  326, -67, -423, -153,  210,  198,  42, -478,  396,  467, -48,  418,  498,  397,  497,  80, -214, -94,  371, -493, -135, -437, -196,  161,  22,  145, -500, -244,  61, -130,  88,  239,  303,  166, -414,  366,  216,  128, -260,  112,  448, -456,  383, -202,  441, -268, -270,  79,  139, -399,  86, -144,  16, -258, -131, -462,  388, -131,  147, -51, -409, -265, -312, -253, -247,  127, -387, -179, -245, -147, -214,  55, -103, -331, -295,  190,  253, -65,  122,  244,  36,  60, -399, -96,  303, -30,  295, -457, -308, -58, -08, -217, -471, -468,  30, -217,  159,  495,  104, -233, -152, -258, -326, -403,  263, -120, -360,  17,  315,  262, -239,  204, -178, -138, -392, -23,  333,  403,  20, -123,  197, -136,  160,  227, -103,  43, -490, -92,  38,  466, -473, -261,  61,  54, -164, -176,  434,  328,  341, -399,  90, -397,  305, -235, -35, -234, -406,  150,  21,  115, -473, -281,  479, -460, -202,  228,  83,  160, -11, -379,  478,  368,  212,  39, -78, -451,  364, -144, -271,  205, -42, -328,  308,  115,  289,  126, -267,  383,  128, -393, -02,  156, -174, -22, -452,  124,  58,  131,  136, -453, -396,  114,  416,  317, -346, -162, -282, -482, -453, -53,  223,  357,  119,  32, -28, -92,  10, -442,  144, -362, -335, -358, -354,  343,  472, -306,  319,  31, -323, -45,  78,  134, -431, -06, -49, -277, -315, -479, -259, -268, -32,  465, -411, -60,  349,  413, -300, -141,  471,  344,  349, -12, -161,  496, -169, -189,  42, -350,  342,  220,  105,  273, -146,  175,  119, -343,  398,  304, -322, -08, -112,  498,  309, -23,  290,  158,  243,  491, -131, -434, -313,  70,  55,  26,  66,  386, -310, -391, -463, -468, -319,  494,  305,  35, -479, -75,  192, -228,  81, -278,  264,  470, -280,  73,  299, -489,  83,  42, -146,  452,  109,  393,  22,  16,  272, -59, -98,  462,  402,  291,  494, -417, -362, -348,  470, -341,  429, -486, -69,  362, -264, -305,  332, -44, -380,  132,  319,  203,  26,  25, -493, -13, -81,  382, -497, -309, -177,  258, -347,  77,  401, -01,  160, -461, -497,  130,  51, -216,  496,  482, -353, -268,  30, -169, -460,  150, -185,  360, -146,  342,  237, -139,  181, -344, -257, -463, -153,  418, -353,  352, -05, -452,  204,  07, -60,  207, -11, -157, -156, -15, -175, -09,  217, -293, -326,  258,  358, -10,  470,  64,  184,  207, -223, -135, -284,  373,  254,  415,  291,  401, -380,  139, -198,  324, -354, -406,  383,  136, -63, -273, -27, -386, -430, -309, -178, -255, -199,  32,  235,  123, -404, -81,  182,  225, -364, -250,  98, -257, -334, -110, -356, -214, -119,  298, -38,  27,  392, -155,  15,  181,  73,  489, -352,  143,  32, -30,  388, -315, -146,  475, -340, -50,  246,  342, -325, -265, -55, -374, -22,  111,  16,  474, -251, -251, -375,  211,  276, -131, -92,  144, -449,  481,  485, -301,  477,  369, -479, -283, -446, -125,  45, -286, -323, -209, -92,  204,  26,  353,  330, -144,  316,  198,  183, -83,  447,  308, -372, -424, -323,  37, -428,  80,  370, -443, -369, -301,  426, -348, -83,  480,  379,  462,  46, -444,  105, -194, -387, -16,  12, -205,  340,  180,  494,  23, -402, -207,  183,  78, -131,  361, -385, -59, -59, -162,  350,  73,  37,  276, -423, -194, -392,  457, -232, -494, -135,  374, -187, -22, -142, -323,  274,  50,  357, -380, -74,  455, -87, -391,  34, -365,  470, -499,  428,  264, -161,  279,  189, -271,  55,  266,  35, -484, -425,  304, -478, -59, -470,  187, -229,  240, -284, -455, -210, -426,  17,  216, -119,  431,  326, -233, -434, -352, -231, -154, -236,  460, -375,  453, -311, -467, -428, -423, -451, -353, -267, -77,  440, -237, -37, -288, -145,  179,  109,  497, -395, -373, -434,  339, -90,  392, -394,  328, -108,  227, -326,  157,  188, -200,  462, -271,  185, -114, -194, -414,  34,  391,  09,  326, -346, -176, -462,  361, -144, -500,  359,  313, -21,  425,  152,  389, -331, -389, -431,  413,  338, -257,  422,  26,  395,  385, -392,  432, -229,  266, -482, -343,  158,  380,  484, -336, -296, -126, -474,  412,  226,  385,  226, -295, -338,  230, -54, -169,  341,  15, -256,  180, -389, -333,  58, -494, -96, -482,  439, -473,  285, -191, -315,  295, -311,  21,  459, -106, -253, -163,  158,  474,  74,  236, -321,  236, -33,  126, -433, -192, -07,  164, -160,  104, -317,  399,  463,  87, -231, -246,  114, -446,  63, -349,  349,  253,  172, -339, -01,  420, -02, -343,  394, -427, -254, -75,  309,  213, -97, -271, -127,  397, -255,  214,  01, -72,  465,  316, -485, -266, -430,  129,  141,  486,  281,  342,  239,  305, -497,  90, -423,  354, -401,  471,  427, -155,  249, -412, -442, -348,  169, -68, -99,  414, -02,  403, -158, -37,  219,  209, -451, -358, -161,  190, -372, -28,  33, -281,  129,  388,  309,  207,  242,  408, -470, -479,  106,  279, -38, -484, -216, -369,  300,  185, -102, -202,  440,  240, -387, -488,  302, -337, -346, -359,  353,  134,  465,  238,  353,  446,  127,  162,  153, -131,  422,  184,  243,  380,  315, -295,  397, -401, -164,  197, -363, -414,  496, -423, -321, -39, -411,  481,  124,  95, -26,  330, -271, -61,  420, -418, -115,  47, -404, -109, -231, -129, -425, -488, -249, -258, -283, -352,  194,  405, -302,  331, -156, -306, -240,  23, -493,  202,  04,  484,  149,  478,  314,  379,  269,  234, -187,  06,  134,  262,  397,  403, -367, -176, -233,  236,  419,  336,  385,  113, -407, -417,  296, -63,  129, -444,  460,  488, -390,  316,  472,  260,  294,  286,  491,  415,  373, -196, -78,  359, -82,  171, -386,  51, -152, -119,  140, -233,  69,  25, -268,  162,  460, -472, -48,  441, -64,  264,  429,  399,  81,  402,  159,  227, -460,  150,  143, -235, -194, -83, -376,  225, -60, -262,  128,  288,  471, -232, -93,  40, -355,  139,  55, -43, -481, -493,  250,  308,  271,  180,  207, -148,  434,  218, -68, -174, -132, -425,  444, -474, -08, -432, -397, -216,  159,  232, -427,  130, -148, -20,  23,  350, -28, -422, -193,  343, -63, -442,  151,  60, -410, -142,  413, -124, -424,  197,  202,  296,  272,  146, -325,  116, -433, -222,  400, -422, -138, -175,  208, -433,  306,  83,  417,  130, -487, -276, -27, -50,  134, -375, -489,  224,  335, -224, -400, -236,  473, -345, -88, -403, -347,  439,  213,  72, -282,  465,  150,  432, -209,  211,  499, -51, -206,  416, -421, -192, -07,  404, -390, -373, -119, -27, -296,  69, -399, -196,  333, -426,  311,  97,  23, -183,  37,  88,  389, -393,  54,  392, -109,  345,  103, -109,  146,  397,  159, -423,  57, -348,  481, -480,  132,  215, -07,  336, -216,  95, -08, -31, -479,  156, -434,  45,  473,  455, -367, -286, -86, -461, -394,  306, -264,  209, -303,  382,  459, -292,  459,  368,  213,  441,  388, -155,  156,  234,  33, -208,  181, -123,  261, -446, -467, -321,  451, -494, -13, -63, -279,  401, -24,  179,  207,  213, -111, -244,  95,  200, -35,  407,  68,  30,  348,  309, -273,  356,  395,  260,  00,  76, -363, -239,  482, -329,  292,  434,  29, -221,  223, -398, -319, -301,  282, -260, -236, -329, -03, -288, -277, -186, -381,  291,  344, -181,  452, -429,  27,  347, -317, -473,  275, -180,  140,  258,  343,  284, -456,  225, -436,  267,  327,  97, -182,  109, -311,  83, -368,  186, -353, -145, -500, -234, -01, -304,  85, -49, -233, -36,  151, -50, -09, -74, -377, -17,  36, -182, -233,  432, -457,  183, -449, -277, -220, -130, -316, -30, -195,  169,  08, -48, -476,  361, -430,  375, -443, -493,  179,  177, -29, -170, -21,  462, -392,  454, -55,  497, -227, -436, -219,  168,  248, -167,  391, -472, -445, -424,  350,  212,  245,  211,  16, -379,  72,  86, -151,  481,  93, -472,  158, -436,  210, -362, -122, -330, -56, -325,  19,  217, -261,  301, -114,  487, -14,  129, -132,  393,  205,  70,  105,  302, -219, -27, -224, -295, -89,  125, -313, -496, -495,  345, -80, -433, -165, -350, -263,  280, -175, -391,  349,  64, -238,  87,  404,  248, -283, -228,  493, -226, -306,  450, -71, -24, -77,  205,  181,  334,  182, -280, -310,  187, -82,  462,  254, -395, -388, -157,  385, -63, -48, -413, -147, -434, -474,  109, -334, -257,  381, -341,  370, -72, -391,  151,  404,  384, -144,  437,  218, -110,  10, -240, -423,  428, -278, -317, -467, -166,  26, -229, -377, -169, -142,  329, -103, -116, -62,  64,  480,  172, -425, -298, -400, -315,  353, -144, -431,  61,  145, -360,  451, -345,  252, -120, -417,  475,  63, -383,  161, -59, -112,  285, -376, -402,  114,  22,  334, -96, -62,  314, -424,  13, -132, -324, -450, -279,  32, -28, -366, -322,  112, -63,  185,  216,  317,  269,  191,  232, -262, -147,  26,  126, -10,  150, -424, -44,  24,  410,  360,  462, -423,  437,  328, -55, -35,  378, -481,  498,  202, -347,  28,  166,  443,  65, -117,  260, -166, -426,  345,  424,  279, -129,  50,  121, -479,  478, -423,  46,  389, -210,  360,  466,  79, -460,  263, -456,  419,  282, -106,  121, -212, -226, -212, -269,  340,  171, -157,  26, -403, -312, -49, -271,  59, -147,  350,  433, -168, -220,  331,  73,  422, -457,  391,  01, -416,  154,  45, -145,  289,  440,  476, -423,  66,  116, -192, -94,  139,  151, -215, -411, -308,  236, -182, -397, -411,  20, -464,  273,  300, -281, -154, -426, -237,  89,  75,  199, -256, -379, -446, -467, -87, -118, -38, -169, -149, -378,  238,  490, -375, -125, -69, -183, -389,  249, -79,  52,  122,  309, -174,  274, -119, -476,  349,  144,  114, -76,  195, -290,  397,  249,  95,  162, -369, -443,  494, -18, -321, -416,  325, -196, -41, -244,  474,  70, -142,  247, -26,  480,  56, -348, -394, -211,  29,  455, -215, -05,  232,  480,  205,  129,  229,  152, -208,  361,  209,  138,  195, -260,  222,  20,  396, -319,  277, -278, -397, -13,  469,  77,  319,  378, -418,  425, -333,  111, -267, -47, -394,  465, -67,  311,  94, -337,  315, -262, -124,  24,  376, -429, -384,  98,  444, -136, -369,  221,  87, -266,  60,  408, -336, -121,  286, -254,  156,  454, -291,  389,  259, -185,  354, -308, -22,  301,  207, -207, -109, -417, -331,  120,  07, -215,  70, -49, -499,  202,  24,  440, -212, -416,  349, -48,  315,  135, -450, -29,  441, -241,  213,  200,  426,  67,  393, -96,  220,  100,  197, -36, -464, -282, -416,  43,  03,  154,  494,  357,  208,  18,  297,  497,  454,  146,  301,  269,  134, -296,  92,  75, -37, -195,  128,  242, -275,  373, -354, -203,  325, -304,  261,  361, -86,  345,  256, -230,  352,  250, -373,  60,  120, -224,  409,  426, -225,  211,  195,  409, -233,  140,  336, -418,  445, -36,  324,  22,  189,  471,  320,  15,  19,  81, -124,  433,  279, -367, -297,  131, -265,  182,  43,  356,  459,  305, -366,  86,  368, -318, -05, -365,  322,  183, -283, -381,  00, -458,  142, -311, -135,  314,  204,  384,  247, -419, -331,  26,  66,  225,  09,  301,  259, -95, -491, -430, -290, -356,  156, -422, -174, -349, -287, -352, -313, -70,  119,  187,  324,  113,  376,  41, -73,  433,  277, -325, -486,  447,  201,  432, -476,  63,  233,  283,  468,  243,  354, -322, -261,  10, -244,  65, -486,  321, -435, -299,  103, -464, -260, -72,  150, -384, -179, -423, -99, -401,  104, -85, -102,  158, -153, -78, -279, -67,  57,  41,  28, -89,  219,  267,  422, -173,  184, -212, -352, -399, -11,  251, -363, -419,  31,  287,  49,  353, -283,  451, -196,  321,  218, -446, -21, -82, -24, -448,  351, -467,  93, -121,  297, -188, -02, -429,  491,  34, -141, -361,  135, -300, -257,  272, -219, -374,  412,  330, -169, -371,  281,  135,  450,  352,  189,  282, -230,  17,  334, -379,  403, -72,  352,  200, -408,  202,  271, -416, -264, -18,  75,  371,  182, -330,  143, -185, -203,  55, -03,  128, -464,  131,  116,  487, -17,  157, -379,  253,  27,  455,  374, -70,  235, -422, -18,  328,  280,  105, -236, -484, -413, -309,  387, -379, -138,  382, -64, -489,  290, -215,  491,  326,  416,  459, -335, -101,  117, -214, -348, -356,  94, -122,  426, -171, -44, -92,  09,  88, -487, -375,  104, -48, -183,  343,  425, -469, -422,  213, -106,  368,  498, -115,  194,  415, -155, -288, -186, -186,  350,  319,  310, -56,  49,  236, -374, -142, -04,  487,  446,  361, -387,  403, -187,  282, -402, -262, -335, -324,  451,  59, -456, -199,  444, -409, -284,  141,  155,  383,  455,  05, -446, -383,  450,  103,  353, -424,  461, -151, -85, -240,  62,  28, -337, -273, -190,  113, -35, -25,  290,  268, -114, -314, -430, -169, -223,  138, -176,  432,  373,  132, -62,  427,  249,  240,  383,  455, -332,  344, -196,  83, -44, -281, -36,  471, -54,  274,  85, -236,  102, -125, -116,  488,  61,  306,  171, -309, -55, -152, -25, -182,  480, -235,  98, -419, -495, -19, -464,  25,  177,  193, -391, -366,  412,  73, -43, -142,  199, -458,  122,  153,  269, -493,  494, -169,  313, -483,  374,  110, -135, -151, -219,  197,  115,  379,  279,  472,  212,  315, -02, -111,  08,  459,  375,  272,  32, -167, -369,  83, -125, -395, -263, -355, -36, -269,  328,  130, -252, -446, -260,  466, -97,  373,  163, -130,  252, -58,  195,  316,  110, -307, -294, -30, -348, -419, -257, -464, -86,  226,  119, -358, -317,  356,  139, -500, -61, -33,  130, -460,  373, -278, -142,  128, -404, -479,  499, -300,  316, -454, -483,  278, -261,  75, -252,  243,  156,  343,  279, -77,  421, -102,  65, -395,  107, -296, -395, -102, -477, -413,  290, -252, -191, -352,  376,  257, -330,  375, -190, -162,  421,  179, -384,  12, -246,  216, -245, -238,  60, -114, -463, -19, -363,  454,  86, -404, -342, -457,  346,  33, -370,  137,  281,  292,  285,  158,  401, -193,  385, -289,  145, -341, -258, -387, -477,  348,  330,  131, -37, -110, -483,  00,  371,  06, -45,  310,  102,  465, -295, -51,  351, -164, -62,  132, -20, -277,  142, -119,  31,  380,  445,  28, -109, -313,  142,  266, -464,  324, -103, -01, -286,  267, -149, -63, -227,  306,  99, -272,  272,  305, -471,  475, -07, -33,  459,  473,  190,  102,  206,  73,  334,  151, -46,  77, -309, -52, -157,  79, -228,  241, -70, -14,  360,  281, -225, -367,  88,  375,  213,  212, -468,  242, -461,  25,  61,  498,  350, -248,  452,  56, -323,  286,  60,  483,  215,  251, -69, -441, -170,  203, -348,  260,  41, -488,  41, -331, -03, -19, -456,  63,  45, -72, -195,  84,  453,  367,  83, -345, -29,  35,  211, -500,  174, -229,  484, -111, -126, -85,  300,  204, -29,  452,  316, -488, -184,  210,  33,  314,  43,  77, -123, -59, -143, -466, -123, -190, -247,  460, -35, -424,  348,  29, -71,  374, -348, -87,  115,  379, -320, -84,  435,  151, -132,  252, -484,  185,  314,  49,  351, -143, -21,  80,  298, -312,  114, -324, -01, -280, -12, -184,  148,  188, -303, -423,  62,  202, -10,  30,  81, -477,  446,  16, -474,  166,  120, -106, -149, -66,  444,  54, -356,  275, -366,  442, -185, -399, -30,  314, -179, -189, -17, -179, -149, -468, -101, -234,  234, -259,  296,  167, -236,  242, -316, -209, -92, -344,  185, -388,  91,  481,  166,  235, -392, -347, -471, -76, -246,  352,  90,  427,  15, -75, -252,  366, -42,  147, -368,  44,  389,  428,  64,  05,  170,  248,  296, -69, -244,  334,  43,  347,  315,  61,  434, -224,  214,  464,  200, -180, -332, -210, -253,  183, -432,  348,  49,  26,  347,  182, -78, -412,  462,  486,  94,  485, -414,  242, -84, -157,  76, -189,  42,  244,  372, -23, -480,  439,  293, -428, -241,  461, -138,  359,  144,  282, -441,  45, -192,  406, -273, -417, -153,  42, -79,  441,  379,  360, -465, -205,  55,  464,  458, -403,  208, -318,  74, -420, -379, -133, -348,  233,  180,  366,  92, -176,  149,  151,  370, -191,  409, -51, -108, -244, -157, -334,  49, -278, -474,  437,  17,  433,  401,  327, -470,  461, -490,  457, -459, -17,  176, -307, -284, -143, -89, -340,  181, -440, -337,  403, -130, -75,  205, -386,  181, -452, -220,  83, -229,  158,  20, -360,  91, -79,  468,  474,  234, -170,  431,  275, -335,  459, -180, -118, -184,  231,  394, -150, -356, -90,  105,  14,  335, -190,  480,  16, -141,  113, -49,  130,  123,  471,  270,  67,  244, -410,  41, -22,  272,  324,  105,  438,  283, -223,  172, -400, -139,  66,  302,  05,  476, -93, -129,  311,  218, -149,  180, -71,  464, -369, -441,  440, -45, -319,  07, -301,  124, -452, -470, -104,  372,  135, -166, -493,  413, -494, -393, -226,  425, -239, -369, -247,  169,  02, -83,  239, -295, -403, -332,  22,  80,  79, -38, -465,  260,  469,  87,  236, -483,  117, -367, -259,  104,  319, -252,  17, -322,  208, -357, -397,  469,  126,  208,  490, -372, -375, -419, -166, -278, -251,  356, -345,  328,  170, -310,  441,  139,  277,  177, -492, -106, -338, -251,  499, -166,  349,  368,  12,  57, -136,  467,  379,  490,  175, -279, -29, -347, -197, -343, -125,  52, -135,  382,  233, -465, -427, -474,  174, -298, -445,  182,  449, -282, -217, -200,  404, -368,  20,  268, -458,  384,  235, -227, -273,  262, -06, -450,  415,  297, -293,  143,  202,  72,  377,  287,  459,  450,  313,  485,  05,  368, -481, -46, -62, -198,  254,  194,  286, -226, -38, -320,  11,  49, -47,  238, -188,  448,  288,  79, -403, -153,  74, -349, -229, -48,  438,  82,  254, -397,  67, -241, -176,  86,  213,  262, -260,  319,  309, -474, -54, -229,  59,  457,  321, -488, -453, -15, -188, -313, -84, -90,  34, -157,  413, -343, -353, -296,  239,  401, -193, -194,  13,  131, -256,  78,  246, -16, -102,  55,  362, -304, -322, -79, -347,  499,  286, -300, -16, -402,  239, -247,  360,  125,  96,  274,  282,  243,  478,  21,  496,  137, -321,  09,  121,  275, -60, -133,  111, -310, -226,  325, -114, -48,  99,  39,  304, -115, -409,  140, -17,  330,  393,  196, -45,  341,  322,  89,  84,  300, -38,  433,  289,  493,  294, -90,  268, -266, -371, -121, -76,  255,  56, -338,  60, -345, -447, -136,  40, -356, -496, -124, -174, -250, -428, -367, -409,  394,  222, -472, -454, -316,  461,  335, -323, -393,  98, -203, -158, -421, -472, -382,  335,  85, -219, -105,  240,  186, -389, -219,  331, -385, -491,  09, -135, -419,  143,  309, -173,  217,  337, -127,  402, -350,  60, -69, -243,  10,  229,  451,  90,  257, -430,  277,  194,  203,  24, -65, -111,  135, -432,  72,  250, -423, -66, -32,  10, -423,  129,  337,  294, -34,  62, -452,  468, -378, -20, -275,  133,  61, -323,  75,  170,  99, -148, -135,  154,  376, -348, -105,  11, -280,  468,  113,  149, -98, -67,  11,  331, -438, -152,  477,  380,  410, -474,  348, -116,  358, -426, -131, -81,  103,  444, -411,  54,  148,  306, -292,  376,  458,  103, -113,  30,  423, -147,  31,  177,  286, -458,  08, -299,  242,  338, -419,  152,  364, -218, -111,  222, -144,  258, -07, -189, -445,  434,  365,  203,  241, -75,  80, -449, -472, -181,  82, -196, -476, -35,  481,  311,  08,  342, -136, -250,  180,  297, -245,  396, -421,  144,  118,  287,  254, -37, -402,  309, -103, -185,  365, -10,  240, -55,  42,  269, -384, -24, -427, -359,  441, -94, -196, -51, -252,  168, -448, -220, -35, -193, -324,  45,  451, -354, -168, -443,  109,  283,  367, -141, -402,  232,  349, -309,  29, -109, -188,  145,  367,  237, -362,  309, -357, -58,  110,  244, -38,  162, -476,  428,  469,  53,  325, -228,  199,  09, -170,  161,  144,  49, -480,  243,  133, -279, -214, -338,  113,  98, -341,  332, -165, -202,  493, -22,  240,  104,  74, -297,  118,  99, -17,  440,  04,  160, -288,  55, -331,  394, -284, -334,  295,  88, -239, -72,  310,  47,  90,  275, -355,  250,  107, -20, -452,  453, -190, -360,  57,  385, -157,  27,  336, -322, -33,  192,  338,  180, -253, -140,  426,  316,  378,  222, -96, -361,  02,  66,  186, -407, -159,  331, -305, -199,  163,  95, -246, -175,  235,  311,  62, -69, -162,  250,  109, -342, -58,  300, -310,  190,  12, -384,  06, -110, -310, -238,  29,  193,  329, -285, -362, -330, -102, -167, -29, -87,  428,  225,  238, -485,  388, -199, -54,  79, -449, -92,  237,  346,  60,  427,  36, -428, -105, -106,  314,  438,  156, -157,  483,  337,  410, -379, -492,  160,  306,  331, -427, -414,  409, -337, -399,  297, -36,  400,  228,  368, -192, -35,  214,  368,  244,  102, -208, -08,  496, -394, -70, -496,  301, -87,  342, -437,  386, -298,  223,  192, -467, -352, -370,  442, -189, -269, -408, -372, -369,  320,  496,  291,  138, -438, -489,  234,  164, -197, -274, -488,  261, -492, -484,  414,  273, -290,  477,  159, -88, -448,  203,  298, -300,  333, -408,  364, -83, -316, -156,  400, -143, -160,  192, -153,  254, -445, -419, -82,  211,  160,  282, -28,  168,  298, -113, -58, -139,  216, -47,  273,  269,  09,  423, -179, -158, -484,  37,  259,  52,  381,  160,  409,  73,  204, -244, -173,  259,  190, -403, -30, -150,  379, -205, -482, -470, -466,  312, -109,  250,  118,  16,  19, -373, -60, -307, -31,  308,  230,  81, -140,  112,  93,  122,  37,  149, -270,  365, -92,  420,  462, -269, -230, -306,  26,  141, -276,  60,  305,  115,  162, -77, -17,  34,  50,  423,  227, -128, -417,  309, -195, -56,  273,  398, -82, -189,  47,  148,  28, -193,  69, -10,  38, -309, -464, -84,  332, -240, -172,  490, -273,  491, -87,  211,  377, -184,  486,  104, -460, -430, -87, -155,  366,  39,  95, -216,  350, -358,  432, -122,  301,  353, -280,  192, -103, -243, -392,  81,  369,  289,  71, -403, -368, -163,  308, -491,  153,  294,  465,  193, -284,  230, -110, -418, -231,  485, -134, -29, -21,  151, -299, -220,  356,  274,  472, -247, -117, -67,  335, -248, -278,  258,  201,  206, -405,  09, -433,  248,  156, -468,  293,  372,  262, -317, -193, -116,  20,  173,  355,  499,  176, -91, -220,  385, -317, -248, -10,  66, -463, -175, -330,  111, -64,  372, -183,  31,  233, -116,  132, -111,  268, -75,  114,  383,  461,  421, -233, -19,  446, -26, -19,  475,  383,  261,  360, -434, -135, -150,  484, -97, -472, -345, -134, -36, -121,  184, -153, -388, -80,  479,  354, -311,  257, -32, -428,  218,  241,  191,  51, -461, -335, -468, -486, -99, -355, -274, -33,  363,  429,  304,  118, -191, -189,  484, -375,  190, -480, -28, -346, -59,  304, -492,  482,  61,  328, -94,  131,  421, -403, -318,  461,  114, -285, -173, -485,  212,  406,  335,  427, -313,  139,  45, -04, -198,  30,  121, -156,  402, -55, -02, -157, -251,  07,  177, -338,  187, -417,  293,  109,  32, -172,  422, -353,  43,  101,  14,  107,  07, -151,  35, -454, -160, -68,  42,  494, -186,  15, -162, -283, -187,  337,  412,  414,  196,  90, -423,  235, -475, -278,  196,  410,  50,  118, -91, -55,  72,  423, -447, -69,  125,  440, -22,  465, -128, -480, -188,  187,  388,  150,  404, -299, -13, -332, -385,  35,  258,  44, -229, -364,  267,  467, -454,  169,  438,  307, -385,  10,  230,  20,  441, -145,  312, -81,  173, -316,  292, -163, -277,  180,  487, -21, -267,  327,  148, -152, -138,  258, -255,  485, -254, -488, -195,  144, -467,  95, -49, -352, -395,  34, -480, -102, -259,  332, -330, -234, -131,  462,  103,  444,  494,  91,  276, -273, -82, -76,  75, -368,  34,  320, -30, -367, -316,  275,  277, -282, -130,  81,  218,  327, -385, -409,  77, -144, -225,  247,  123,  496,  209, -274,  441, -445,  317,  217, -218,  87, -07, -290, -428, -121, -118,  42,  12,  419,  169,  142, -11, -109, -277, -293, -282, -162,  150,  295,  194,  426,  395,  169,  422,  104,  396, -285, -488, -435, -216, -206, -495, -371,  04, -423,  361, -261,  471,  225, -342,  140, -133,  147, -117,  90, -294,  453, -220,  357,  248, -173,  283,  495,  496, -443,  452, -256,  125,  464,  162, -239, -242, -481, -109, -385, -52, -248, -146, -81,  477,  12, -89,  197, -341, -354,  139,  217, -401,  420,  74, -301,  99,  209, -305,  447, -381, -353,  44,  244, -389, -294, -143,  221,  77,  248,  336, -475, -148,  42,  296,  182, -446,  59, -121,  65,  205, -482, -217,  304, -210, -291, -497,  389,  419, -302, -311, -462, -155,  233, -366,  308, -209, -09,  30,  368,  92,  218,  393,  444, -239, -459,  126,  167,  100, -143, -267, -195, -124,  368, -391, -482, -423, -388,  408, -152,  163, -51, -114, -140, -318,  372, -331, -27,  216, -449,  193, -192,  269,  438, -248, -118,  479, -269, -450,  431,  88,  135, -264, -184,  03,  197, -165,  432, -339,  95, -219,  324, -456, -481,  37, -274, -256, -442, -449,  460, -391, -404, -232, -270, -466,  372,  113, -135, -397, -485, -204, -456,  150,  384, -140,  05,  81,  195, -63,  242, -210, -430,  419,  186, -58, -44, -236, -462,  14,  167,  498,  475,  263,  118,  57, -351,  342, -330,  366, -202, -315, -338, -158, -313, -102, -446,  192,  479,  250, -370,  222, -108,  52,  493, -421, -154, -51,  195, -116, -185, -137,  234, -210, -374, -148,  347, -224, -305, -130, -358, -07,  407,  157, -313, -405, -445, -259,  287, -113, -157, -231, -39, -412,  322, -46,  19,  20, -245, -286,  405,  70,  77,  139, -288,  204, -156, -441, -168,  391,  281,  326,  236,  189,  335,  423, -364, -257,  16,  423,  130,  360,  45, -409,  448,  219,  45,  319, -261,  300, -467, -04,  222,  111, -12,  434,  167,  332, -155, -149, -425, -373, -323,  311, -332, -487, -414, -196, -244,  102,  79, -262, -38, -24, -171,  262, -305, -274,  81, -65, -122,  467, -217, -400,  430,  271, -466,  97,  103, -121,  448,  178,  358, -23,  341, -122,  342,  427, -466, -50,  30,  114,  188, -156, -58, -131, -41,  138,  95, -108, -75, -175, -141,  208, -75, -211, -20,  311, -262, -65,  43, -314, -34, -99, -484, -193,  280,  358,  87,  314,  161, -383,  280, -151,  313, -277, -429, -228, -287,  166, -483,  138, -156, -124, -154,  269, -482, -322,  433, -244,  114, -24,  295, -420, -271, -337,  239, -491, -127, -174, -324, -466,  295, -192,  236,  109,  383,  307, -267, -404,  325, -250,  234, -331,  479, -67, -209,  497,  111, -276,  105,  77,  200,  252, -491,  429, -233, -399, -209,  141, -73,  319,  175, -277, -373,  263, -316, -489,  70, -83, -393,  248, -480, -306,  417,  499,  479,  60, -152,  442,  284, -195,  20,  336, -90,  381, -382,  177,  482, -91, -182, -90,  80, -154,  485,  207, -391,  21, -430,  180,  438, -322,  280, -190,  224, -451,  161,  203,  110, -491,  145,  246,  167,  17,  83, -423, -101, -447,  254, -119,  314, -75, -357, -106,  271, -20, -399,  380, -499, -328,  412, -208,  202, -456,  102,  278, -406, -236,  333,  204,  125, -22,  302, -208, -152,  237,  221,  247,  290,  328, -20,  104, -247,  476,  498, -476, -44, -48, -244,  310,  476,  21, -46, -470,  65, -444,  308,  159,  172,  141,  215,  150, -29,  18, -206, -329,  107, -484,  418, -102,  344,  251, -498, -403, -421, -147, -27,  387,  305, -419,  197, -367,  102, -349, -337,  20,  60, -177,  31,  84, -184,  99, -266,  287, -31,  29,  459, -424,  397, -271, -26,  241, -168,  329, -310, -89, -318,  163,  151, -161,  244, -152, -28,  199,  352,  487,  71,  264, -190, -398, -152,  126,  201,  435,  265, -330,  316, -424, -253,  213, -194, -427, -46,  490,  402,  144,  254, -64,  159, -95, -373, -97, -395,  99, -46,  457,  438, -123,  221, -252, -20, -78, -274,  33, -143,  492, -444, -327, -432,  155,  386,  226,  228, -160, -431,  483, -164,  323,  271,  495, -272,  399,  250, -167,  350,  57,  143,  289,  434, -136, -111,  266, -362,  116, -200, -05,  460, -144,  168, -120, -489,  406, -393, -409,  98, -324, -74,  434, -149, -302, -219,  431, -403, -468,  116, -201,  441, -241, -412,  375,  476, -22,  142, -386, -54,  442,  110, -94,  150,  130,  286, -487,  37, -255, -44, -365,  273,  383, -78, -376, -67,  203, -445,  30, -413,  172,  329, -472, -217, -230, -244, -241, -400,  398, -126,  46, -308, -164,  452, -306,  466, -410, -293,  355, -164, -485, -157, -391,  398, -383,  86, -169, -328,  493, -287, -240,  165, -105,  140,  449,  165, -252,  60, -383, -354, -214,  163,  190,  122,  467,  384,  441, -443, -57, -352,  245, -41, -09, -293,  209,  460,  293, -459, -367,  286,  106,  245,  304, -499,  237, -395, -482,  486,  165, -365, -16,  452, -350, -325,  426, -383, -89,  367,  27, -293, -484, -228,  166,  359,  331, -125,  320,  124,  268, -195, -89, -125, -450, -285,  228,  287, -180,  247,  273, -163, -266,  110,  141, -115,  285,  68,  354,  48,  287, -119,  255, -345, -494,  273, -133,  337, -351,  39, -38, -231,  344, -275,  144,  394,  292,  225, -467, -36, -28, -341,  301,  206,  269,  295, -57,  406, -137, -202,  306,  02,  179,  62,  158, -463, -165, -475,  375,  336,  416,  189, -394,  260, -234, -398, -494, -442,  327, -461,  374,  151, -302, -473, -142, -181,  322,  301,  77,  37, -401, -116, -460, -369,  446, -450, -332,  133, -73, -105, -30, -157, -64,  428, -397,  202, -470, -391, -388, -290,  00,  486,  361, -449, -486, -281, -130, -312, -127, -200,  226,  324,  184, -382, -193,  482, -332, -24,  115,  95, -277, -63, -210,  160, -135,  245, -138,  248,  354,  327,  458,  206,  313,  319,  257, -321, -109, -20, -132, -384,  280, -406,  440,  316, -288, -252,  298,  232, -424,  265,  179,  151, -297,  469, -189,  68,  214, -474,  168,  420,  353,  126,  126,  166,  298,  236, -302, -311,  68,  66, -195,  200, -488,  97,  16, -276, -303,  166, -192,  125, -69,  487, -223,  134,  456,  88,  55, -478,  114, -277, -206,  319, -298, -228,  338, -500, -492, -464, -311,  428,  102,  346,  128,  114,  295, -04, -310,  493, -338, -02,  118,  94, -15,  395, -272,  293,  336, -365, -333,  302, -141, -39,  122,  413, -415, -40,  413, -54, -04, -46, -126, -50,  152, -497, -84, -53, -01,  106, -60, -486, -44, -89,  108, -207, -194, -312, -62, -06, -176,  105, -203, -465, -82,  419,  448,  03, -121, -287,  449, -273,  167, -176, -471, -181,  179, -55, -382,  30, -97,  59,  44,  359,  470, -348, -348,  128, -159,  90, -377, -483,  47,  272, -448,  465,  191, -148, -32, -78,  65,  270, -499,  84, -406, -470, -245, -375,  327, -127,  155, -270, -216, -300, -59,  106,  204,  93,  87, -103,  35, -438, -86, -66,  334,  318, -101,  25,  22, -281, -201, -61,  489, -200, -125, -65,  182,  130,  60,  09, -144,  68,  239,  492, -380, -320,  99,  324, -375,  38,  74, -488,  100, -160, -54,  286,  11, -303,  163, -467,  268,  462, -27, -390, -238, -300,  45, -204,  331, -42,  305,  39, -122,  396,  383, -02, -72, -18,  174,  53, -128, -252,  417, -176,  441,  215, -390, -48,  412,  273, -15, -468,  235, -190, -358, -151,  11, -460,  145,  194, -02,  302,  85,  376,  198, -32,  226, -374, -197, -100, -469,  175, -499,  448, -148,  442,  163, -38, -106,  427,  88,  379,  460, -177,  42, -46, -475, -95, -06, -478, -49,  492,  325, -464, -280,  23,  356,  446, -498, -341, -153, -467, -313, -152,  482,  39, -210,  497, -147, -464, -223,  441, -233,  89,  117,  309, -457,  142,  66,  38, -484, -483,  382, -307, -95, -45,  217, -238, -99, -429,  273, -400, -396,  460,  300, -62,  351, -58, -64,  57, -22, -435, -02,  246,  154, -385,  407,  197, -391, -26,  87, -22,  343,  322,  171, -251, -223,  240,  363,  178,  311,  136, -369,  416,  449,  431, -146, -348, -126, -358,  209,  352, -293, -292,  450,  361,  175,  358,  411,  285,  184,  350,  115,  27,  172, -214,  276,  449, -473,  139,  480,  338, -224, -389,  254,  77, -458, -391,  229, -84,  103, -61,  121,  311,  147,  71, -476,  174,  281, -213, -41, -35, -362, -426,  493, -338,  213, -379, -388,  240,  261, -408,  78, -111,  55,  185,  466,  97,  294, -453, -134,  249, -14, -161,  60, -15, -238,  85, -340, -456,  372,  471,  09, -138, -102,  354,  25, -389,  476,  137, -297,  237, -419,  281, -22,  488, -34,  296,  85,  112,  343, -197, -138,  182,  142, -226, -333, -243,  359,  179, -199, -416,  151, -338, -54, -99, -483,  471,  364,  493,  460, -433, -418, -107,  348,  60, -119,  167,  208, -181,  131,  403,  122,  493,  85,  117, -232, -395,  374, -21,  284,  27,  63,  287,  189, -138, -312, -442,  185, -448, -449,  146, -29, -15, -461,  172, -103,  273, -161, -395, -408,  470, -491, -434, -184,  446,  183,  436, -449,  409, -85,  336,  288, -169,  123,  330, -455, -336,  388,  230,  68, -208, -124, -460, -371,  268,  212,  27,  41, -97,  484,  485, -127, -155, -449, -459, -208, -413,  477, -157, -152,  245,  31, -363, -72,  07, -181, -27,  171, -293, -297,  91,  351,  432,  483,  481, -448, -453,  360,  445, -50,  344,  430, -324,  42, -167, -283,  334, -80,  47,  29,  269,  144, -87, -242, -428,  420,  77,  397,  443, -364, -48,  34,  488,  236,  370, -179,  288,  417,  33, -415, -132, -123, -133,  44, -229,  201, -387, -43, -27, -488,  487, -258,  156, -100,  352, -420,  172,  281,  477,  115,  418,  282,  01, -242,  18, -129,  431,  159, -211, -36,  244, -491, -307, -36,  53, -35, -335, -482,  422,  138, -469, -239, -267, -461,  161, -63, -380, -167, -281, -51, -200, -363, -269,  302,  247,  250,  25,  178,  261,  314, -358,  357,  323, -165, -179,  228,  300, -14,  247, -425, -23, -370, -164, -438, -331,  498, -01,  141,  183,  218, -409, -164,  355,  174, -362,  102, -76,  163, -220,  37,  330,  274, -105, -495, -390,  216,  234, -238,  55,  333, -163, -468,  463,  174, -406, -16, -476,  445, -374, -441,  164,  69, -105,  371, -257,  385,  326, -480,  401, -394,  57,  231, -267, -196,  236, -157, -127,  322,  457,  428,  155, -205, -188,  470, -179,  258,  307, -155,  203, -215, -96, -133,  354, -348,  91, -51, -463, -83, -31, -210,  375, -121, -127, -392, -465, -38,  303, -92, -216,  261,  188, -208, -92, -500, -238,  229, -390, -79, -426, -334,  206,  330,  385,  60,  482, -24, -138, -128,  393, -317, -486,  269,  62, -112,  377,  98,  350,  181, -142, -14,  294, -453,  278, -298, -453, -107,  431,  10,  314, -143,  176,  21,  39,  61, -67,  374, -462,  295, -254,  431,  479,  112, -448,  393, -500,  430,  343,  350,  463, -298, -163,  257, -251, -33, -189,  148,  360,  94, -342,  175,  451, -314,  48, -10,  248,  481,  216, -362, -371, -186, -79, -40,  427, -26, -147,  427,  256,  49, -370,  219,  251,  319,  328, -500, -214, -09, -500, -01, -415,  11,  26, -112,  197, -426, -270,  297, -93,  447,  435,  388, -239,  209, -152, -312, -317, -446, -384,  439,  103, -254, -490, -146, -83, -310,  206,  203,  181, -442, -298, -382,  69,  228,  06, -233, -346,  236, -436,  62,  183, -148, -50,  445, -439, -349, -15,  96, -295,  101,  387, -340, -301, -251,  14,  116, -61,  72,  172, -28,  130, -274,  442,  52, -193, -52,  319, -39,  36, -265, -125, -280,  439, -322,  17, -148, -171, -498,  448,  34,  456,  335,  194,  07, -64,  60, -24,  375, -16, -352,  199, -34,  226,  141, -482, -467, -59,  337,  347,  478, -75, -278,  50, -136, -100, -433,  217,  229, -79, -483,  115, -123, -295,  161, -263,  141, -279,  213,  369, -443, -287,  420,  24,  439,  414,  42, -175, -145,  232, -328,  185, -343, -106, -265,  373, -353,  154,  442, -272, -424,  460,  344,  305,  17,  357, -458, -342, -421, -393, -473, -12, -180,  448, -488,  112,  362,  407,  437,  69,  139, -391, -245, -352,  355,  342, -479, -146, -03, -184,  83,  425,  128,  279,  230, -355,  136, -375, -197, -433, -268,  183,  56,  405,  483,  68,  17, -303,  327, -46, -382, -34,  415,  225,  114,  270,  68,  488, -375, -83, -196, -440, -158, -216,  339, -76, -71, -25,  401, -416,  43, -366,  267, -401, -461, -398, -481,  408, -201,  347, -138,  270, -187, -223, -05, -220, -101, -437,  120,  376, -20, -224,  436, -326,  60,  275,  99,  489, -249,  00, -75, -354,  486, -307, -255, -123,  147, -236, -215, -201, -37,  499, -431, -371,  128,  64, -91, -120,  128, -119, -244, -40,  157,  45,  487, -283, -180,  438,  58,  423, -62,  483, -431,  277,  28,  166,  06, -324, -217, -356, -25,  246, -357,  396,  375, -376, -40,  136,  04, -60, -483, -388, -247,  174,  157, -260, -257,  478, -322,  301, -247,  468, -363,  175,  245,  165,  193,  104,  341,  476,  248,  168, -425, -257,  64, -198, -133, -123,  439,  371,  317, -192,  484, -430, -165,  141, -190,  430,  471, -12, -416,  77, -43, -279,  104,  54,  386, -203, -342, -420, -226,  406, -400,  201,  02,  165, -497,  369, -458, -206, -407, -289,  455, -423, -218, -210, -430,  444,  72, -106,  285,  156, -177,  94,  377,  427, -352,  264, -276,  159, -304,  350,  417, -204,  51, -81, -187,  407, -211,  207, -299, -118,  419, -344,  311,  53,  298, -267, -03, -129,  479, -218, -121, -198,  376, -243, -271, -123, -127,  306, -464,  69,  156, -195,  365,  60,  225,  31, -33, -134, -262, -480, -400, -343,  29, -237,  210,  179,  348,  60, -98,  328,  342,  282, -370, -429, -461,  212, -52, -88,  370,  336, -167,  378, -359, -302, -62, -282,  229, -243,  436, -180,  130, -464, -23, -341,  151,  40, -310,  00, -48,  93, -172, -206,  227,  310,  217,  266,  374, -335,  30,  244, -147,  363,  123,  347, -87, -87, -435, -05,  171, -146,  315, -199,  242,  144,  312, -106,  36, -146, -254,  488,  447,  426,  135,  174,  236, -148,  292,  111,  370,  174,  207, -277,  389, -170, -78, -197,  244,  340, -350,  267, -306,  465, -80,  436,  461,  84,  182, -02,  438,  428, -14,  386,  354, -379,  412,  443, -26, -443,  406,  196,  231,  113,  419,  121, -204,  194, -224, -108,  34, -74, -341,  228, -109,  79, -484, -148, -337,  199, -298, -399,  479,  189, -161, -314,  310,  104, -371,  136,  161, -465, -168,  244, -500,  104,  217, -204, -202,  493,  188,  332, -81, -301,  412, -338, -370,  428,  367,  145,  479, -431, -401, -189,  258, -62, -03,  421, -106,  478,  409, -93, -135, -258, -348, -135, -302,  369, -486, -04,  363, -446,  180,  134, -246,  92, -351, -116,  372, -484, -470, -296, -63, -371,  367, -304,  419, -136, -31,  166,  194, -122, -427, -441,  472, -275,  276, -330, -53,  290, -482,  162,  345,  198, -204, -49,  142, -55, -313,  367,  313,  69, -77, -249, -450, -210,  299,  470, -494,  120,  488,  200,  498, -439, -389, -177, -213,  387, -07,  234, -470,  364,  248, -273,  62, -456,  178,  57,  342,  365,  276, -493,  287, -301, -242,  337,  341, -91, -341, -301, -471, -353, -249, -120, -291, -138,  203,  348,  101,  48,  434,  131, -88,  182,  358, -173,  226,  388,  384,  420, -394, -488,  428,  393, -289,  38,  230, -96,  448,  390,  103,  477, -111,  354, -143,  98,  68, -88, -54, -331,  461, -120,  301, -127, -438, -489,  200, -359,  400,  436, -87, -494,  448, -159, -249,  11,  380,  481,  415,  328, -277,  370, -343,  113, -424,  367, -289,  144, -221, -490,  314, -260,  242,  467,  114, -343, -170,  166, -202, -270,  103,  211,  88,  403, -95,  339, -85,  137, -327,  182,  317, -104,  405,  474, -139,  481,  341,  425,  126, -27,  435,  292,  213,  177, -389,  179, -314, -59,  198, -16, -476, -199,  48,  464,  56, -195, -344,  471,  442, -171, -494,  259, -423,  411, -415, -61, -256, -221, -136,  370,  252,  151, -486,  317,  180, -375, -03,  367,  419,  47,  203,  443, -300,  103,  407,  256,  408, -85, -420, -298,  244, -414, -187, -326, -151, -101,  465,  445,  178,  181, -332,  282, -168, -318,  99, -488,  160, -52, -269,  79,  495, -213,  22, -305,  390,  281,  452, -349, -303, -468, -147, -207, -30,  167,  319, -329, -82,  284, -384, -404, -35, -216,  378,  297,  319,  329, -338, -21, -222,  245, -442, -227, -468,  432,  321,  423, -435, -375, -74,  114, -343,  279, -240,  479,  298, -421],
        [-500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -500, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -499, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -498, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -497, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -496, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -495, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -494, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -493, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -492, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -491, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -490, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -489, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -488, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -487, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -486, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -485, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -484, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -483, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -482, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -481, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -480, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -479, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -478, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -477, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -476, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -475, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -474, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -473, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -472, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -471, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -470, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -469, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -468, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -467, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -466, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -465, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -464, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -463, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -462, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -461, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -460, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -459, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -458, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -457, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -456, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -455, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -454, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -453, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -452, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -451, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -450, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -449, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -448, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -447, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -446, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -445, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -444, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -443, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -442, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -441, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -440, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -439, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -438, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -437, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -436, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -435, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -434, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -433, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -432, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -431, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -430, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -429, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -428, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -427, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -426, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -425, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -424, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -423, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -422, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -421, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -420, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -419, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -418, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -417, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -416, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -415, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -414, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -413, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -412, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -411, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -410, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -409, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -408, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -407, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -406, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -405, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -404, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -403, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -402, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -401, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -400, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -399, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -398, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -397, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -396, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -395, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -394, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -393, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -392, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -391, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -390, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -389, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -388, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -387, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -386, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -385, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -384, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -383, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -382, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -381, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -380, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -379, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -378, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -377, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -376, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -375, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -374, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -373, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -372, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -371, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -370, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -369, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -368, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -367, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -366, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -365, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -364, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -363, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -362, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -361, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -360, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -359, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -358, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -357, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -356, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -355, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -354, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -353, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -352, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -351, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -350, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -349, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -348, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -347, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -346, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -345, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -344, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -343, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -342, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -341, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -340, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -339, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -338, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -337, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -336, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -335, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -334, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -333, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -332, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -331, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -330, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -329, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -328, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -327, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -326, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -325, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -324, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -323, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -322, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -321, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -320, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -319, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -318, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -317, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -316, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -315, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -314, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -313, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -312, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -311, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -310, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -309, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -308, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -307, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -306, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -305, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -304, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -303, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -302, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -301, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -300, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -299, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -298, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -297, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -296, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -295, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -294, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -293, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -292, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -291, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -290, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -289, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -288, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -287, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -286, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -285, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -284, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -283, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -282, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -281, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -280, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -279, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -278, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -277, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -276, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -275, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -274, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -273, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -272, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -271, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -270, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -269, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -268, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -267, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -266, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -265, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -264, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -263, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -262, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -261, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -260, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -259, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -258, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -257, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -254, -253, -253