// Copyright (c) 2014, the Dart project authors. All rights reserved.
// Autogenerated from the PCRE test suite Mon Feb  2 15:14:04 CET 2009

// Note that some regexps in the PCRE test suite use features not present
// in JavaScript.  These don't work in JS, but they fail to work in a
// predictable way, and the expected results reflect this.

// PCRE comes with the following license

// PCRE LICENCE
// ------------
//
// PCRE is a library of functions to support regular expressions whose syntax
// and semantics are as close as possible to those of the Perl 5 language.
//
// Release 7 of PCRE is distributed under the terms of the "BSD" licence, as
// specified below. The documentation for PCRE, supplied in the "doc"
// directory, is distributed under the same terms as the software itself.
//
// The basic library functions are written in C and are freestanding. Also
// included in the distribution is a set of C++ wrapper functions.
//
//
// THE BASIC LIBRARY FUNCTIONS
// ---------------------------
//
// Written by:       Philip Hazel
// Email local part: ph10
// Email domain:     cam.ac.uk
//
// University of Cambridge Computing Service,
// Cambridge, England.
//
// Copyright (c) 1997-2007 University of Cambridge
// All rights reserved.
//
//
// THE C++ WRAPPER FUNCTIONS
// -------------------------
//
// Contributed by:   Google Inc.
//
// Copyright (c) 2007, Google Inc.
// All rights reserved.
//
//
// THE "BSD" LICENCE
// -----------------
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice,
//       this list of conditions and the following disclaimer.
//
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//
//     * Neither the name of the University of Cambridge nor the name of Google
//       Inc. nor the names of their contributors may be used to endorse or
//       promote products derived from this software without specific prior
//       written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//
// End

import 'v8_regexp_utils.dart';
import 'package:expect/expect.dart';

void main() {
  var res = <RegExp>[];
  res.add(new RegExp(r"(a)b|", caseSensitive: false));
  res.add(new RegExp(r"abc", caseSensitive: false));
  res.add(new RegExp(r"^abc", caseSensitive: false));
  res.add(new RegExp(r"a+bc", caseSensitive: false));
  res.add(new RegExp(r"a*bc", caseSensitive: false));
  res.add(new RegExp(r"a{3}bc", caseSensitive: false));
  res.add(new RegExp(r"(abc|a+z)", caseSensitive: false));
  res.add(new RegExp(r"^abc$", caseSensitive: false));
  res.add(new RegExp(r"ab\idef"));
  res.add(new RegExp(r".*b", caseSensitive: false));
  res.add(new RegExp(r".*?b", caseSensitive: false));
  res.add(new RegExp(r"cat|dog|elephant", caseSensitive: false));
  res.add(new RegExp(r"cat|dog|elephant", caseSensitive: false));
  res.add(new RegExp(r"cat|dog|elephant", caseSensitive: false));
  res.add(new RegExp(r"a|[bcd]", caseSensitive: false));
  res.add(new RegExp(r"(a|[^\dZ])", caseSensitive: false));
  res.add(new RegExp(r"(a|b)*[\s]", caseSensitive: false));
  res.add(new RegExp(r"(ab\2)"));
  res.add(new RegExp(r"(a)(b)(c)\2", caseSensitive: false));
  res.add(new RegExp(r"(a)bc|(a)(b)\2", caseSensitive: false));
  res.add(new RegExp(r"abc$", caseSensitive: false));
  res.add(new RegExp(r"(a)(b)(c)(d)(e)\6"));
  res.add(new RegExp(r"the quick brown fox", caseSensitive: false));
  res.add(new RegExp(r"^abc|def", caseSensitive: false));
  res.add(new RegExp(r".*((abc)$|(def))", caseSensitive: false));
  res.add(new RegExp(r"abc", caseSensitive: false));
  res.add(new RegExp(r"^abc|def", caseSensitive: false));
  res.add(new RegExp(r".*((abc)$|(def))", caseSensitive: false));
  res.add(new RegExp(r"the quick brown fox", caseSensitive: false));
  res.add(new RegExp(r"the quick brown fox", caseSensitive: false));
  res.add(new RegExp(r"abc.def", caseSensitive: false));
  res.add(new RegExp(r"abc$", caseSensitive: false));
  res.add(new RegExp(r"(abc)\2", caseSensitive: false));
  res.add(new RegExp(r"(abc\1)", caseSensitive: false));
  res.add(new RegExp(r"a[]b"));
  res.add(new RegExp(r"[^aeiou ]{3,}", caseSensitive: false));
  res.add(new RegExp(r"<.*>", caseSensitive: false));
  res.add(new RegExp(r"<.*?>", caseSensitive: false));
  res.add(new RegExp(r"[abcd]", caseSensitive: false));
  res.add(new RegExp(r"(^a|^b)", multiLine: true, caseSensitive: false));
  res.add(new RegExp(r"a$", caseSensitive: false));
  res.add(new RegExp(r"a$", multiLine: true, caseSensitive: false));
  res.add(new RegExp(r"\Aabc", multiLine: true, caseSensitive: false));
  res.add(new RegExp(r"^abc", multiLine: true, caseSensitive: false));
  res.add(new RegExp(r"(?!alphabet)[ab]", caseSensitive: false));
  res.add(new RegExp(r"The next three are in testinput2 because they have variable length branches"));
  res.add(new RegExp(r"This one is here because Perl 5.005_02 doesn't fail it", caseSensitive: false));
  res.add(new RegExp(r"This one is here because I think Perl 5.005_02 gets the setting of $1 wrong", caseSensitive: false));
  res.add(new RegExp(r"^(a\1?){4}$", caseSensitive: false));
  res.add(new RegExp(r"These are syntax tests from Perl 5.005", caseSensitive: false));
  res.add(new RegExp(r"a[]b"));
  res.add(new RegExp(r"\1"));
  res.add(new RegExp(r"\2"));
  res.add(new RegExp(r"(a)|\2"));
  res.add(new RegExp(r"a[]b", caseSensitive: false));
  res.add(new RegExp(r"abc"));
  res.add(new RegExp(r"abc"));
  res.add(new RegExp(r"abc", caseSensitive: false));
  res.add(new RegExp(r"(a)bc(d)", caseSensitive: false));
  res.add(new RegExp(r"(.{20})", caseSensitive: false));
  res.add(new RegExp(r"(.{15})", caseSensitive: false));
  res.add(new RegExp(r"(.{16})", caseSensitive: false));
  res.add(new RegExp(r"^(a|(bc))de(f)", caseSensitive: false));
  res.add(new RegExp(r"^abc\00def", caseSensitive: false));
  res.add(new RegExp(r"word ((?:[a-zA-Z0-9]+ )((?:[a-zA-Z0-9]+ )((?:[a-zA-Z0-9]+ )((?:[a-zA-Z0-9]+\n)((?:[a-zA-Z0-9]+ )((?:[a-zA-Z0-9]+ )((?:[a-zA-Z0-9]+ )((?:[a-zA-Z0-9]+\n)?)?)?)?)?)?)?)?)?otherword", caseSensitive: false));
  res.add(new RegExp(r".*X", caseSensitive: false));
  res.add(new RegExp(r".*X", caseSensitive: false));
  res.add(new RegExp(r"(.*X|^B)", caseSensitive: false));
  res.add(new RegExp(r"(.*X|^B)", caseSensitive: false));
  res.add(new RegExp(r"\Biss\B", caseSensitive: false));
  res.add(new RegExp(r"\Biss\B", caseSensitive: false));
  res.add(new RegExp(r"iss", caseSensitive: false));
  res.add(new RegExp(r"\Biss\B", caseSensitive: false));
  res.add(new RegExp(r"\Biss\B", caseSensitive: false));
  res.add(new RegExp(r"^iss", caseSensitive: false));
  res.add(new RegExp(r".*iss", caseSensitive: false));
  res.add(new RegExp(r".i.", caseSensitive: false));
  res.add(new RegExp(r"^.is", caseSensitive: false));
  res.add(new RegExp(r"^ab\n", caseSensitive: false));
  res.add(new RegExp(r"^ab\n", multiLine: true, caseSensitive: false));
  res.add(new RegExp(r"abc", caseSensitive: false));
  res.add(new RegExp(r"abc|bac", caseSensitive: false));
  res.add(new RegExp(r"(abc|bac)", caseSensitive: false));
  res.add(new RegExp(r"(abc|(c|dc))", caseSensitive: false));
  res.add(new RegExp(r"(abc|(d|de)c)", caseSensitive: false));
  res.add(new RegExp(r"a*", caseSensitive: false));
  res.add(new RegExp(r"a+", caseSensitive: false));
  res.add(new RegExp(r"(baa|a+)", caseSensitive: false));
  res.add(new RegExp(r"a{0,3}", caseSensitive: false));
  res.add(new RegExp(r"baa{3,}", caseSensitive: false));
  res.add(new RegExp(r'"([^\\"]+|\.)*"', caseSensitive: false));
  res.add(new RegExp(r"(abc|ab[cd])", caseSensitive: false));
  res.add(new RegExp(r"(a|.)", caseSensitive: false));
  res.add(new RegExp(r"a|ba|\w", caseSensitive: false));
  res.add(new RegExp(r"abc(?=pqr)", caseSensitive: false));
  res.add(new RegExp(r"abc(?!pqr)", caseSensitive: false));
  res.add(new RegExp(r"ab.", caseSensitive: false));
  res.add(new RegExp(r"ab[xyz]", caseSensitive: false));
  res.add(new RegExp(r"abc*", caseSensitive: false));
  res.add(new RegExp(r"ab.c*", caseSensitive: false));
  res.add(new RegExp(r"a.c*", caseSensitive: false));
  res.add(new RegExp(r".c*", caseSensitive: false));
  res.add(new RegExp(r"ac*", caseSensitive: false));
  res.add(new RegExp(r"(a.c*|b.c*)", caseSensitive: false));
  res.add(new RegExp(r"a.c*|aba", caseSensitive: false));
  res.add(new RegExp(r".+a", caseSensitive: false));
  res.add(new RegExp(r"(?=abcda)a.*", caseSensitive: false));
  res.add(new RegExp(r"(?=a)a.*", caseSensitive: false));
  res.add(new RegExp(r"a(b)*", caseSensitive: false));
  res.add(new RegExp(r"a\d*", caseSensitive: false));
  res.add(new RegExp(r"ab\d*", caseSensitive: false));
  res.add(new RegExp(r"a(\d)*", caseSensitive: false));
  res.add(new RegExp(r"abcde{0,0}", caseSensitive: false));
  res.add(new RegExp(r"ab\d+", caseSensitive: false));
  res.add(new RegExp(r"ab\d{0}e", caseSensitive: false));
  res.add(new RegExp(r"a?b?", caseSensitive: false));
  res.add(new RegExp(r"|-", caseSensitive: false));
  res.add(new RegExp(r"a*(b+)(z)(z)", caseSensitive: false));
  res.add(new RegExp(r"^.?abcd", caseSensitive: false));
  res.add(new RegExp(r"^[[:alnum:]]"));
  res.add(new RegExp(r"^[[:^alnum:]]"));
  res.add(new RegExp(r"^[[:alpha:]]"));
  res.add(new RegExp(r"^[[:^alpha:]]"));
  res.add(new RegExp(r"[_[:alpha:]]", caseSensitive: false));
  res.add(new RegExp(r"^[[:ascii:]]"));
  res.add(new RegExp(r"^[[:^ascii:]]"));
  res.add(new RegExp(r"^[[:blank:]]"));
  res.add(new RegExp(r"^[[:^blank:]]"));
  res.add(new RegExp(r"[\n\x0b\x0c\x0d[:blank:]]", caseSensitive: false));
  res.add(new RegExp(r"^[[:cntrl:]]"));
  res.add(new RegExp(r"^[[:digit:]]"));
  res.add(new RegExp(r"^[[:graph:]]"));
  res.add(new RegExp(r"^[[:lower:]]"));
  res.add(new RegExp(r"^[[:print:]]"));
  res.add(new RegExp(r"^[[:punct:]]"));
  res.add(new RegExp(r"^[[:space:]]"));
  res.add(new RegExp(r"^[[:upper:]]"));
  res.add(new RegExp(r"^[[:xdigit:]]"));
  res.add(new RegExp(r"^[[:word:]]"));
  res.add(new RegExp(r"^[[:^cntrl:]]"));
  res.add(new RegExp(r"^[12[:^digit:]]"));
  res.add(new RegExp(r"^[[:^blank:]]"));
  res.add(new RegExp(r"[01[:alpha:]%]"));
  res.add(new RegExp(r"[[.ch.]]", caseSensitive: false));
  res.add(new RegExp(r"[[=ch=]]", caseSensitive: false));
  res.add(new RegExp(r"[[:rhubarb:]]", caseSensitive: false));
  res.add(new RegExp(r"[[:upper:]]", caseSensitive: false));
  res.add(new RegExp(r"[[:lower:]]", caseSensitive: false));
  res.add(new RegExp(r"This one's here because of the large output vector needed", caseSensitive: false));
  res.add(new RegExp(r"(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\d+(?:\s|$))(\w+)\s+(\270)", caseSensitive: false));
  res.add(new RegExp(r"This one's here because Perl does this differently and PCRE can't at present", caseSensitive: false));
  res.add(new RegExp(r"(main(O)?)+", caseSensitive: false));
  res.add(new RegExp(r"These are all cases where Perl does it differently (nested captures)", caseSensitive: false));
  res.add(new RegExp(r"^(a(b)?)+$", caseSensitive: false));
  res.add(new RegExp(r"^(aa(bb)?)+$", caseSensitive: false));
  res.add(new RegExp(r"^(aa|aa(bb))+$", caseSensitive: false));
  res.add(new RegExp(r"^(aa(bb)??)+$", caseSensitive: false));
  res.add(new RegExp(r"^(?:aa(bb)?)+$", caseSensitive: false));
  res.add(new RegExp(r"^(aa(b(b))?)+$", caseSensitive: false));
  res.add(new RegExp(r"^(?:aa(b(b))?)+$", caseSensitive: false));
  res.add(new RegExp(r"^(?:aa(b(?:b))?)+$", caseSensitive: false));
  res.add(new RegExp(r"^(?:aa(bb(?:b))?)+$", caseSensitive: false));
  res.add(new RegExp(r"^(?:aa(b(?:bb))?)+$", caseSensitive: false));
  res.add(new RegExp(r"^(?:aa(?:b(b))?)+$", caseSensitive: false));
  res.add(new RegExp(r"^(?:aa(?:b(bb))?)+$", caseSensitive: false));
  res.add(new RegExp(r"^(aa(b(bb))?)+$", caseSensitive: false));
  res.add(new RegExp(r"^(aa(bb(bb))?)+$", caseSensitive: false));
  res.add(new RegExp(r"a", caseSensitive: false));
  res.add(new RegExp(r"[\s]"));
  res.add(new RegExp(r"[\S]"));
  res.add(new RegExp(r"123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"));
  res.add(new RegExp(r"\Q123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"));
  res.add(new RegExp(r"\Q\E"));
  res.add(new RegExp(r"\Q\Ex"));
  res.add(new RegExp(r" \Q\E"));
  res.add(new RegExp(r"a\Q\E"));
  res.add(new RegExp(r"a\Q\Eb"));
  res.add(new RegExp(r"\Q\Eabc"));
  res.add(new RegExp(r"[.x.]", caseSensitive: false));
  res.add(new RegExp(r"[=x=]", caseSensitive: false));
  res.add(new RegExp(r"[:x:]", caseSensitive: false));
  res.add(new RegExp(r"\l", caseSensitive: false));
  res.add(new RegExp(r"\L", caseSensitive: false));
  res.add(new RegExp(r"\N{name}", caseSensitive: false));
  res.add(new RegExp(r"\u", caseSensitive: false));
  res.add(new RegExp(r"\U", caseSensitive: false));
  res.add(new RegExp(r"[[:space:]", caseSensitive: false));
  res.add(new RegExp(r"[\s]", caseSensitive: false));
  res.add(new RegExp(r"[[:space:]]", caseSensitive: false));
  res.add(new RegExp(r"[[:space:]abcde]", caseSensitive: false));
  res.add(new RegExp(r"(.*)\d+\1", caseSensitive: false));
  res.add(new RegExp(r"(.*)\d+", caseSensitive: false));
  res.add(new RegExp(r"(.*)\d+\1", caseSensitive: false));
  res.add(new RegExp(r"(.*)\d+", caseSensitive: false));
  res.add(new RegExp(r"(.*(xyz))\d+\2", caseSensitive: false));
  res.add(new RegExp(r"((.*))\d+\1", caseSensitive: false));
  res.add(new RegExp(r"a[b]", caseSensitive: false));
  res.add(new RegExp(r"(?=a).*", caseSensitive: false));
  res.add(new RegExp(r"(?=abc).xyz", caseSensitive: false));
  res.add(new RegExp(r"(?=a)(?=b)", caseSensitive: false));
  res.add(new RegExp(r"(?=.)a", caseSensitive: false));
  res.add(new RegExp(r"((?=abcda)a)", caseSensitive: false));
  res.add(new RegExp(r"((?=abcda)ab)", caseSensitive: false));
  res.add(new RegExp(r"()a", caseSensitive: false));
  res.add(new RegExp(r"(a)+", caseSensitive: false));
  res.add(new RegExp(r"(a){2,3}", caseSensitive: false));
  res.add(new RegExp(r"(a)*", caseSensitive: false));
  res.add(new RegExp(r"[a]", caseSensitive: false));
  res.add(new RegExp(r"[ab]", caseSensitive: false));
  res.add(new RegExp(r"[ab]", caseSensitive: false));
  res.add(new RegExp(r"[^a]", caseSensitive: false));
  res.add(new RegExp(r"\d456", caseSensitive: false));
  res.add(new RegExp(r"\d456", caseSensitive: false));
  res.add(new RegExp(r"a^b", caseSensitive: false));
  res.add(new RegExp(r"^a", multiLine: true, caseSensitive: false));
  res.add(new RegExp(r"c|abc", caseSensitive: false));
  res.add(new RegExp(r"(.*)a", caseSensitive: false));
  res.add(new RegExp(r"(.*)a\1", caseSensitive: false));
  res.add(new RegExp(r"(.*)a(b)\2", caseSensitive: false));
  res.add(new RegExp(r"((.*)a|(.*)b)z", caseSensitive: false));
  res.add(new RegExp(r"((.*)a|(.*)b)z\1", caseSensitive: false));
  res.add(new RegExp(r"((.*)a|(.*)b)z\2", caseSensitive: false));
  res.add(new RegExp(r"((.*)a|(.*)b)z\3", caseSensitive: false));
  res.add(new RegExp(r"((.*)a|^(.*)b)z\3", caseSensitive: false));
  res.add(new RegExp(r"(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)a", caseSensitive: false));
  res.add(new RegExp(r"(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)a\31", caseSensitive: false));
  res.add(new RegExp(r"(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)|(.*)a\32", caseSensitive: false));
  res.add(new RegExp(r"(a)(bc)", caseSensitive: false));
  res.add(new RegExp(r"(a+)*zz", caseSensitive: false));
  res.add(new RegExp(r"((w\/|-|with)*(free|immediate)*.*?shipping\s*[!.-]*)", caseSensitive: false));
  res.add(new RegExp(r"((w\/|-|with)*(free|immediate)*.*?shipping\s*[!.-]*)", caseSensitive: false));
  res.add(new RegExp(r"a*.*b", caseSensitive: false));
  res.add(new RegExp(r"(a|b)*.?c", caseSensitive: false));
  res.add(new RegExp(r"abcde", caseSensitive: false));
  res.add(new RegExp(r"a*b", caseSensitive: false));
  res.add(new RegExp(r"a+b", caseSensitive: false));
  res.add(new RegExp(r"(abc|def)x", caseSensitive: false));
  res.add(new RegExp(r"(ab|cd){3,4}", caseSensitive: false));
  res.add(new RegExp(r"([ab]{,4}c|xy)", caseSensitive: false));
  res.add(new RegExp(r"([ab]{1,4}c|xy){4,5}?123", caseSensitive: false));
  res.add(new RegExp(r"\b.*", caseSensitive: false));
  res.add(new RegExp(r"\b.*", caseSensitive: false));
  res.add(new RegExp(r"(?!.bcd).*", caseSensitive: false));
  res.add(new RegExp(r"abcde", caseSensitive: false));
  res.add(new RegExp(r"0{0,2}ABC", caseSensitive: false));
  res.add(new RegExp(r"\d{3,}ABC", caseSensitive: false));
  res.add(new RegExp(r"\d*ABC", caseSensitive: false));
  res.add(new RegExp(r"[abc]+DE", caseSensitive: false));
  res.add(new RegExp(r"[abc]?123", caseSensitive: false));
  res.add(new RegExp(r"^(?:\d){3,5}X", caseSensitive: false));
  res.add(new RegExp(r"^a", caseSensitive: false));
  res.add(new RegExp(r"line\nbreak", caseSensitive: false));
  res.add(new RegExp(r"line\nbreak", caseSensitive: false));
  res.add(new RegExp(r"line\nbreak", multiLine: true, caseSensitive: false));
  res.add(new RegExp(r"ab.cd", caseSensitive: false));
  res.add(new RegExp(r"ab.cd", caseSensitive: false));
  res.add(new RegExp(r"a(b)c", caseSensitive: false));
  res.add(new RegExp(r"Inthisnexttest,Jisnotsetattheouterlevel;consequentlyitisn'tsetinthepattern'soptions;consequentlypcre_get_named_substring()producesarandomvalue.", caseSensitive: false));
  res.add(new RegExp(r"\777", caseSensitive: false));
  res.add(new RegExp(r"\s*,\s*", caseSensitive: false));
  res.add(new RegExp(r"^abc", multiLine: true, caseSensitive: false));
  res.add(new RegExp(r"abc$", multiLine: true, caseSensitive: false));
  res.add(new RegExp(r"^abc", multiLine: true, caseSensitive: false));
  res.add(new RegExp(r"^abc", multiLine: true, caseSensitive: false));
  res.add(new RegExp(r"^abc", multiLine: true, caseSensitive: false));
  res.add(new RegExp(r"^abc", multiLine: true, caseSensitive: false));
  res.add(new RegExp(r"abc", caseSensitive: false));
  res.add(new RegExp(r".*", caseSensitive: false));
  res.add(new RegExp(r"\w+(.)(.)?def", caseSensitive: false));
  res.add(new RegExp(r"()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()(.(.))", caseSensitive: false));
  res.add(new RegExp(r"()[ab]xyz", caseSensitive: false));
  res.add(new RegExp(r"(|)[ab]xyz", caseSensitive: false));
  res.add(new RegExp(r"(|c)[ab]xyz", caseSensitive: false));
  res.add(new RegExp(r"(|c?)[ab]xyz", caseSensitive: false));
  res.add(new RegExp(r"(d?|c?)[ab]xyz", caseSensitive: false));
  res.add(new RegExp(r"(d?|c)[ab]xyz", caseSensitive: false));
  res.add(new RegExp(r"^a*b\d"));
  res.add(new RegExp(r"^a*?b\d"));
  res.add(new RegExp(r"^a+A\d"));
  res.add(new RegExp(r"^a*A\d", caseSensitive: false));
  res.add(new RegExp(r"(a*|b*)[cd]", caseSensitive: false));
  res.add(new RegExp(r"(a+|b*)[cd]", caseSensitive: false));
  res.add(new RegExp(r"(a*|b+)[cd]", caseSensitive: false));
  res.add(new RegExp(r"(a+|b+)[cd]", caseSensitive: false));
  res.add(new RegExp(r"(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((a)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))", caseSensitive: false));
  res.add(new RegExp(r"a*\d"));
  res.add(new RegExp(r"a*\D"));
  res.add(new RegExp(r"0*\d"));
  res.add(new RegExp(r"0*\D"));
  res.add(new RegExp(r"a*\s"));
  res.add(new RegExp(r"a*\S"));
  res.add(new RegExp(r" *\s"));
  res.add(new RegExp(r" *\S"));
  res.add(new RegExp(r"a*\w"));
  res.add(new RegExp(r"a*\W"));
  res.add(new RegExp(r"=*\w"));
  res.add(new RegExp(r"=*\W"));
  res.add(new RegExp(r"\d*a"));
  res.add(new RegExp(r"\d*2"));
  res.add(new RegExp(r"\d*\d"));
  res.add(new RegExp(r"\d*\D"));
  res.add(new RegExp(r"\d*\s"));
  res.add(new RegExp(r"\d*\S"));
  res.add(new RegExp(r"\d*\w"));
  res.add(new RegExp(r"\d*\W"));
  res.add(new RegExp(r"\D*a"));
  res.add(new RegExp(r"\D*2"));
  res.add(new RegExp(r"\D*\d"));
  res.add(new RegExp(r"\D*\D"));
  res.add(new RegExp(r"\D*\s"));
  res.add(new RegExp(r"\D*\S"));
  res.add(new RegExp(r"\D*\w"));
  res.add(new RegExp(r"\D*\W"));
  res.add(new RegExp(r"\s*a"));
  res.add(new RegExp(r"\s*2"));
  res.add(new RegExp(r"\s*\d"));
  res.add(new RegExp(r"\s*\D"));
  res.add(new RegExp(r"\s*\s"));
  res.add(new RegExp(r"\s*\S"));
  res.add(new RegExp(r"\s*\w"));
  res.add(new RegExp(r"\s*\W"));
  res.add(new RegExp(r"\S*a"));
  res.add(new RegExp(r"\S*2"));
  res.add(new RegExp(r"\S*\d"));
  res.add(new RegExp(r"\S*\D"));
  res.add(new RegExp(r"\S*\s"));
  res.add(new RegExp(r"\S*\S"));
  res.add(new RegExp(r"\S*\w"));
  res.add(new RegExp(r"\S*\W"));
  res.add(new RegExp(r"\w*a"));
  res.add(new RegExp(r"\w*2"));
  res.add(new RegExp(r"\w*\d"));
  res.add(new RegExp(r"\w*\D"));
  res.add(new RegExp(r"\w*\s"));
  res.add(new RegExp(r"\w*\S"));
  res.add(new RegExp(r"\w*\w"));
  res.add(new RegExp(r"\w*\W"));
  res.add(new RegExp(r"\W*a"));
  res.add(new RegExp(r"\W*2"));
  res.add(new RegExp(r"\W*\d"));
  res.add(new RegExp(r"\W*\D"));
  res.add(new RegExp(r"\W*\s"));
  res.add(new RegExp(r"\W*\S"));
  res.add(new RegExp(r"\W*\w"));
  res.add(new RegExp(r"\W*\W"));
  res.add(new RegExp(r"[^a]+a"));
  res.add(new RegExp(r"[^a]+a", caseSensitive: false));
  res.add(new RegExp(r"[^a]+A", caseSensitive: false));
  res.add(new RegExp(r"[^a]+b"));
  res.add(new RegExp(r"[^a]+\d"));
  res.add(new RegExp(r"a*[^a]"));
  res.add(new RegExp(r"^(?:(?:\1|X)(a|b))+"));
  res.add(new RegExp(r"^[\E\Qa\E-\Qz\E]+"));
  res.add(new RegExp(r"^[a\Q]bc\E]"));
  res.add(new RegExp(r"(?=(\w+))\1:", caseSensitive: false));
  res.add(new RegExp(r"(a|)*\d"));
  res.add(new RegExp(r"^a.b"));
  res.add(new RegExp(r"^abc.", multiLine: true));
  res.add(new RegExp(r"abc.$", multiLine: true));
  res.add(new RegExp(r"a"));
  res.add(new RegExp(r"a"));
  res.add(new RegExp(r"^a\Rb", caseSensitive: false));
  res.add(new RegExp(r"^a\R*b", caseSensitive: false));
  res.add(new RegExp(r"^a\R+b", caseSensitive: false));
  res.add(new RegExp(r"^a\R{1,3}b", caseSensitive: false));
  res.add(new RegExp(r"^a[\R]b", caseSensitive: false));
  res.add(new RegExp(r"^(a(b))\1\g1\g{1}\g-1\g{-1}\g{-02}Z"));
  res.add(new RegExp(r"^(a)\g-2"));
  res.add(new RegExp(r"^(a)\g"));
  res.add(new RegExp(r"^(a)\g{0}"));
  res.add(new RegExp(r"^(a)\g{3"));
  res.add(new RegExp(r"^(a)\g{4a}"));
  res.add(new RegExp(r"^a.b"));
  res.add(new RegExp(r".+foo"));
  res.add(new RegExp(r".+foo"));
  res.add(new RegExp(r".+foo"));
  res.add(new RegExp(r".+foo"));
  res.add(new RegExp(r"^$", multiLine: true));
  res.add(new RegExp(r"abc.$", multiLine: true));
  res.add(new RegExp(r"^X", multiLine: true));
  res.add(new RegExp(r"(foo)\Kbar"));
  res.add(new RegExp(r"(foo)(\Kbar|baz)"));
  res.add(new RegExp(r"(foo\Kbar)baz"));
  res.add(new RegExp(r"\g{A"));
  res.add(new RegExp(r"\H\h\V\v"));
  res.add(new RegExp(r"\H*\h+\V?\v{3,4}"));
  res.add(new RegExp(r"\H{3,4}"));
  res.add(new RegExp(r".\h{3,4}."));
  res.add(new RegExp(r"\h*X\h?\H+Y\H?Z"));
  res.add(new RegExp(r"\v*X\v?Y\v+Z\V*\x0a\V+\x0b\V{2,3}\x0c"));
  res.add(new RegExp(r"[\h]"));
  res.add(new RegExp(r"[\h]+"));
  res.add(new RegExp(r"[\v]"));
  res.add(new RegExp(r"[\H]"));
  res.add(new RegExp(r"[^\h]"));
  res.add(new RegExp(r"[\V]"));
  res.add(new RegExp(r"[\x0a\V]"));
  res.add(new RegExp(r"\H+\hY"));
  res.add(new RegExp(r"\H+ Y"));
  res.add(new RegExp(r"\h+A"));
  res.add(new RegExp(r"\v*B"));
  res.add(new RegExp(r"\V+\x0a"));
  res.add(new RegExp(r"A+\h"));
  res.add(new RegExp(r" *\H"));
  res.add(new RegExp(r"A*\v"));
  res.add(new RegExp(r"\x0b*\V"));
  res.add(new RegExp(r"\d+\h"));
  res.add(new RegExp(r"\d*\v"));
  res.add(new RegExp(r"S+\h\S+\v"));
  res.add(new RegExp(r"\w{3,}\h\w+\v"));
  res.add(new RegExp(r"\h+\d\h+\w\h+\S\h+\H"));
  res.add(new RegExp(r"\v+\d\v+\w\v+\S\v+\V"));
  res.add(new RegExp(r"\H+\h\H+\d"));
  res.add(new RegExp(r"\V+\v\V+\w"));
  res.add(new RegExp(r"[\E]AAA"));
  res.add(new RegExp(r"[\Q\E]AAA"));
  res.add(new RegExp(r"[^\E]AAA"));
  res.add(new RegExp(r"[^\Q\E]AAA"));
  res.add(new RegExp(r"[\E^]AAA"));
  res.add(new RegExp(r"[\Q\E^]AAA"));
  res.add(new RegExp(r"\g6666666666"));
  res.add(new RegExp(r"[\g6666666666]"));
  res.add(new RegExp(r".+A"));
  res.add(new RegExp(r"\nA"));
  res.add(new RegExp(r"[\r\n]A"));
  res.add(new RegExp(r"(\r|\n)A"));
  res.add(new RegExp(r"a\Rb", caseSensitive: false));
  res.add(new RegExp(r"a\Rb", caseSensitive: false));
  res.add(new RegExp(r"a\R?b", caseSensitive: false));
  res.add(new RegExp(r"a\R?b", caseSensitive: false));
  res.add(new RegExp(r"a\R{2,4}b", caseSensitive: false));
  res.add(new RegExp(r"a\R{2,4}b", caseSensitive: false));
  res.add(new RegExp(r"\k''"));
  res.add(new RegExp(r"\k<>"));
  res.add(new RegExp(r"\k{}"));
  res.add(new RegExp(r"[[:foo:]]"));
  res.add(new RegExp(r"[[:1234:]]"));
  res.add(new RegExp(r"[[:f\oo:]]"));
  res.add(new RegExp(r"[[: :]]"));
  res.add(new RegExp(r"[[:...:]]"));
  res.add(new RegExp(r"[[:l\ower:]]"));
  res.add(new RegExp(r"[[:abc\:]]"));
  res.add(new RegExp(r"[abc[:x\]pqr:]]"));
  res.add(new RegExp(r"[[:a\dz:]]"));
  res.add(new RegExp(r"^(a|b\g<1>c)"));
  res.add(new RegExp(r"^(a|b\g'1'c)"));
  res.add(new RegExp(r"^(a|b\g'-1'c)"));
  res.add(new RegExp(r"(^(a|b\g<-1>c))"));
  res.add(new RegExp(r"(^(a|b\g<-1'c))"));
  res.add(new RegExp(r"(^(a|b\g{-1}))"));
  res.add(new RegExp(r"(\3)(\1)(a)"));
  res.add(new RegExp(r"(\3)(\1)(a)"));
  res.add(new RegExp(r"TA]"));
  res.add(new RegExp(r"TA]"));
  res.add(new RegExp(r"a[]b"));
  res.add(new RegExp(r"a[^]b"));
  res.add(new RegExp(r"a[]b"));
  res.add(new RegExp(r"a[]+b"));
  res.add(new RegExp(r"a[^]b"));
  res.add(new RegExp(r"a[^]+b"));
  res.add(new RegExp(r"a(?!)+b"));
  res.add(new RegExp(r"(abc|pqr|123){0}[xyz]", caseSensitive: false));
  res.add(new RegExp(r" End of testinput2 "));
  res.add(new RegExp(r"a.b"));
  res.add(new RegExp(r"a(.{3})b"));
  res.add(new RegExp(r"a(.*?)(.)"));
  res.add(new RegExp(r"a(.*?)(.)"));
  res.add(new RegExp(r"a(.*)(.)"));
  res.add(new RegExp(r"a(.*)(.)"));
  res.add(new RegExp(r"a(.)(.)"));
  res.add(new RegExp(r"a(.)(.)"));
  res.add(new RegExp(r"a(.?)(.)"));
  res.add(new RegExp(r"a(.?)(.)"));
  res.add(new RegExp(r"a(.??)(.)"));
  res.add(new RegExp(r"a(.??)(.)"));
  res.add(new RegExp(r"a(.{3})b"));
  res.add(new RegExp(r"a(.{3,})b"));
  res.add(new RegExp(r"a(.{3,}?)b"));
  res.add(new RegExp(r"a(.{3,5})b"));
  res.add(new RegExp(r"a(.{3,5}?)b"));
  res.add(new RegExp(r"X(\C{3})"));
  res.add(new RegExp(r"X(\C{4})"));
  res.add(new RegExp(r"X\C*"));
  res.add(new RegExp(r"X\C*?"));
  res.add(new RegExp(r"X\C{3,5}"));
  res.add(new RegExp(r"X\C{3,5}?"));
  res.add(new RegExp(r"[^a]+"));
  res.add(new RegExp(r"^[^a]{2}"));
  res.add(new RegExp(r"^[^a]{2,}"));
  res.add(new RegExp(r"^[^a]{2,}?"));
  res.add(new RegExp(r"[^a]+", caseSensitive: false));
  res.add(new RegExp(r"^[^a]{2}", caseSensitive: false));
  res.add(new RegExp(r"^[^a]{2,}", caseSensitive: false));
  res.add(new RegExp(r"^[^a]{2,}?", caseSensitive: false));
  res.add(new RegExp(r"\D*"));
  res.add(new RegExp(r"\D*"));
  res.add(new RegExp(r"\D"));
  res.add(new RegExp(r">\S"));
  res.add(new RegExp(r"\d"));
  res.add(new RegExp(r"\s"));
  res.add(new RegExp(r"\D+"));
  res.add(new RegExp(r"\D{2,3}"));
  res.add(new RegExp(r"\D{2,3}?"));
  res.add(new RegExp(r"\d+"));
  res.add(new RegExp(r"\d{2,3}"));
  res.add(new RegExp(r"\d{2,3}?"));
  res.add(new RegExp(r"\S+"));
  res.add(new RegExp(r"\S{2,3}"));
  res.add(new RegExp(r"\S{2,3}?"));
  res.add(new RegExp(r">\s+<"));
  res.add(new RegExp(r">\s{2,3}<"));
  res.add(new RegExp(r">\s{2,3}?<"));
  res.add(new RegExp(r"\w+"));
  res.add(new RegExp(r"\w{2,3}"));
  res.add(new RegExp(r"\w{2,3}?"));
  res.add(new RegExp(r"\W+"));
  res.add(new RegExp(r"\W{2,3}"));
  res.add(new RegExp(r"\W{2,3}?"));
  res.add(new RegExp(r"a\Cb"));
  res.add(new RegExp(r"a\Cb"));
  res.add(new RegExp(r"[\xFF]"));
  res.add(new RegExp(r"[\xff]"));
  res.add(new RegExp(r"[^\xFF]"));
  res.add(new RegExp(r"[^\xff]"));
  res.add(new RegExp(r"^[ac]*b"));
  res.add(new RegExp(r"^[^x]*b", caseSensitive: false));
  res.add(new RegExp(r"^[^x]*b"));
  res.add(new RegExp(r"^\d*b"));
  res.add(new RegExp(r"(|a)"));
  res.add(new RegExp(r"\S\S"));
  res.add(new RegExp(r"\S{2}"));
  res.add(new RegExp(r"\W\W"));
  res.add(new RegExp(r"\W{2}"));
  res.add(new RegExp(r"\S"));
  res.add(new RegExp(r"[\S]"));
  res.add(new RegExp(r"\D"));
  res.add(new RegExp(r"[\D]"));
  res.add(new RegExp(r"\W"));
  res.add(new RegExp(r"[\W]"));
  res.add(new RegExp(r"[\S\s]*"));
  res.add(new RegExp(r".[^\S]."));
  res.add(new RegExp(r".[^\S\n]."));
  res.add(new RegExp(r"[[:^alnum:]]"));
  res.add(new RegExp(r"[[:^alpha:]]"));
  res.add(new RegExp(r"[[:^ascii:]]"));
  res.add(new RegExp(r"[[:^blank:]]"));
  res.add(new RegExp(r"[[:^cntrl:]]"));
  res.add(new RegExp(r"[[:^digit:]]"));
  res.add(new RegExp(r"[[:^graph:]]"));
  res.add(new RegExp(r"[[:^lower:]]"));
  res.add(new RegExp(r"[[:^print:]]"));
  res.add(new RegExp(r"[[:^punct:]]"));
  res.add(new RegExp(r"[[:^space:]]"));
  res.add(new RegExp(r"[[:^upper:]]"));
  res.add(new RegExp(r"[[:^word:]]"));
  res.add(new RegExp(r"[[:^xdigit:]]"));
  res.add(new RegExp(r"^[^d]*?$"));
  res.add(new RegExp(r"^[^d]*?$"));
  res.add(new RegExp(r"^[^d]*?$", caseSensitive: false));
  res.add(new RegExp(r"^[^d]*?$", caseSensitive: false));
  res.add(new RegExp(r" End of testinput4 "));
  res.add(new RegExp(r"\x80"));
  res.add(new RegExp(r"\xff"));
  res.add(new RegExp(r".{3,5}X"));
  res.add(new RegExp(r".{3,5}?"));
  res.add(new RegExp(r"X(\C)(.*)"));
  res.add(new RegExp(r"^[ab]"));
  res.add(new RegExp(r"^[^ab]"));
  res.add(new RegExp(r"[^ab\xC0-\xF0]"));
  res.add(new RegExp(r"[\xFF]"));
  res.add(new RegExp(r"[\xff]"));
  res.add(new RegExp(r"[^\xFF]"));
  res.add(new RegExp(r"[^\xff]"));
  res.add(new RegExp(r"anything"));
  res.add(new RegExp(r"\W"));
  res.add(new RegExp(r"\w"));
  res.add(new RegExp(r"\777", caseSensitive: false));
  res.add(new RegExp(r"\777", caseSensitive: false));
  res.add(new RegExp(r"^abc.", multiLine: true));
  res.add(new RegExp(r"abc.$", multiLine: true));
  res.add(new RegExp(r"^a\Rb", caseSensitive: false));
  res.add(new RegExp(r"^a\R*b", caseSensitive: false));
  res.add(new RegExp(r"^a\R+b", caseSensitive: false));
  res.add(new RegExp(r"^a\R{1,3}b", caseSensitive: false));
  res.add(new RegExp(r"\H\h\V\v"));
  res.add(new RegExp(r"\H*\h+\V?\v{3,4}"));
  res.add(new RegExp(r"\H\h\V\v"));
  res.add(new RegExp(r"\H*\h+\V?\v{3,4}"));
  res.add(new RegExp(r"[\h]"));
  res.add(new RegExp(r"[\h]{3,}"));
  res.add(new RegExp(r"[\v]"));
  res.add(new RegExp(r"[\H]"));
  res.add(new RegExp(r"[\V]"));
  res.add(new RegExp(r".*$"));
  res.add(new RegExp(r"X"));
  res.add(new RegExp(r"a\Rb", caseSensitive: false));
  res.add(new RegExp(r"a\Rb", caseSensitive: false));
  res.add(new RegExp(r"a\R?b", caseSensitive: false));
  res.add(new RegExp(r"a\R?b", caseSensitive: false));
  res.add(new RegExp(r".*a.*=.b.*"));
  res.add(new RegExp(r"a[^]b"));
  res.add(new RegExp(r"a[^]+b"));
  res.add(new RegExp(r"X"));
  res.add(new RegExp(r" End of testinput5 "));
  res.add(new RegExp(r"^\pC\pL\pM\pN\pP\pS\pZ<"));
  res.add(new RegExp(r"^\PC"));
  res.add(new RegExp(r"^\PL"));
  res.add(new RegExp(r"^\PM"));
  res.add(new RegExp(r"^\PN"));
  res.add(new RegExp(r"^\PP"));
  res.add(new RegExp(r"^\PS"));
  res.add(new RegExp(r"^\PZ"));
  res.add(new RegExp(r"^\p{Cc}"));
  res.add(new RegExp(r"^\p{Cf}"));
  res.add(new RegExp(r"^\p{Cn}"));
  res.add(new RegExp(r"^\p{Co}"));
  res.add(new RegExp(r"^\p{Cs}"));
  res.add(new RegExp(r"^\p{Ll}"));
  res.add(new RegExp(r"^\p{Lm}"));
  res.add(new RegExp(r"^\p{Lo}"));
  res.add(new RegExp(r"^\p{Lt}"));
  res.add(new RegExp(r"^\p{Lu}"));
  res.add(new RegExp(r"^\p{Mc}"));
  res.add(new RegExp(r"^\p{Me}"));
  res.add(new RegExp(r"^\p{Mn}"));
  res.add(new RegExp(r"^\p{Nl}"));
  res.add(new RegExp(r"^\p{No}"));
  res.add(new RegExp(r"^\p{Pc}"));
  res.add(new RegExp(r"^\p{Pd}"));
  res.add(new RegExp(r"^\p{Pe}"));
  res.add(new RegExp(r"^\p{Pf}"));
  res.add(new RegExp(r"^\p{Pi}"));
  res.add(new RegExp(r"^\p{Po}"));
  res.add(new RegExp(r"^\p{Ps}"));
  res.add(new RegExp(r"^\p{Sk}"));
  res.add(new RegExp(r"^\p{So}"));
  res.add(new RegExp(r"^\p{Zl}"));
  res.add(new RegExp(r"^\p{Zp}"));
  res.add(new RegExp(r"^\p{Zs}"));
  res.add(new RegExp(r"\p{Nd}{2,}(..)"));
  res.add(new RegExp(r"\p{Nd}{2,}?(..)"));
  res.add(new RegExp(r"\p{Nd}*(..)"));
  res.add(new RegExp(r"\p{Nd}*?(..)"));
  res.add(new RegExp(r"\p{Nd}{2}(..)"));
  res.add(new RegExp(r"\p{Nd}{2,3}(..)"));
  res.add(new RegExp(r"\p{Nd}{2,3}?(..)"));
  res.add(new RegExp(r"\p{Nd}?(..)"));
  res.add(new RegExp(r"\p{Nd}??(..)"));
  res.add(new RegExp(r"\p{Lu}", caseSensitive: false));
  res.add(new RegExp(r"\p{^Lu}", caseSensitive: false));
  res.add(new RegExp(r"\P{Lu}", caseSensitive: false));
  res.add(new RegExp(r"[\p{L}]"));
  res.add(new RegExp(r"[\p{^L}]"));
  res.add(new RegExp(r"[\P{L}]"));
  res.add(new RegExp(r"[\P{^L}]"));
  res.add(new RegExp(r"[\p{Nd}]"));
  res.add(new RegExp(r"[\P{Nd}]+"));
  res.add(new RegExp(r"\D+"));
  res.add(new RegExp(r"[\D]+"));
  res.add(new RegExp(r"[\P{Nd}]+"));
  res.add(new RegExp(r"[\D\P{Nd}]+"));
  res.add(new RegExp(r"\pL"));
  res.add(new RegExp(r"\pL", caseSensitive: false));
  res.add(new RegExp(r"\p{Lu}"));
  res.add(new RegExp(r"\p{Lu}", caseSensitive: false));
  res.add(new RegExp(r"\p{Ll}"));
  res.add(new RegExp(r"\p{Ll}", caseSensitive: false));
  res.add(new RegExp(r"^\X"));
  res.add(new RegExp(r"^[\X]"));
  res.add(new RegExp(r"^(\X*)C"));
  res.add(new RegExp(r"^(\X*?)C"));
  res.add(new RegExp(r"^(\X*)(.)"));
  res.add(new RegExp(r"^(\X*?)(.)"));
  res.add(new RegExp(r"^\X(.)"));
  res.add(new RegExp(r"^\X{2,3}(.)"));
  res.add(new RegExp(r"^\X{2,3}?(.)"));
  res.add(new RegExp(r"^[\p{Arabic}]"));
  res.add(new RegExp(r"^[\P{Yi}]"));
  res.add(new RegExp(r"^\p{Any}X"));
  res.add(new RegExp(r"^\P{Any}X"));
  res.add(new RegExp(r"^\p{Any}?X"));
  res.add(new RegExp(r"^\P{Any}?X"));
  res.add(new RegExp(r"^\p{Any}*X"));
  res.add(new RegExp(r"^\P{Any}*X"));
  res.add(new RegExp(r"^[\p{Any}]X"));
  res.add(new RegExp(r"^[\P{Any}]X"));
  res.add(new RegExp(r"^[\p{Any}]?X"));
  res.add(new RegExp(r"^[\P{Any}]?X"));
  res.add(new RegExp(r"^[\p{Any}]+X"));
  res.add(new RegExp(r"^[\P{Any}]+X"));
  res.add(new RegExp(r"^[\p{Any}]*X"));
  res.add(new RegExp(r"^[\P{Any}]*X"));
  res.add(new RegExp(r"^\p{Any}{3,5}?"));
  res.add(new RegExp(r"^\p{Any}{3,5}"));
  res.add(new RegExp(r"^\P{Any}{3,5}?"));
  res.add(new RegExp(r"^\p{L&}X"));
  res.add(new RegExp(r"^[\p{L&}]X"));
  res.add(new RegExp(r"^[\p{L&}]+X"));
  res.add(new RegExp(r"^[\p{L&}]+?X"));
  res.add(new RegExp(r"^\P{L&}X"));
  res.add(new RegExp(r"^[\P{L&}]X"));
  res.add(new RegExp(r"^(\p{Z}[^\p{C}\p{Z}]+)*$"));
  res.add(new RegExp(r"([\pL]=(abc))*X"));
  res.add(new RegExp(r"^\p{Balinese}\p{Cuneiform}\p{Nko}\p{Phags_Pa}\p{Phoenician}"));
  res.add(new RegExp(r"The next two are special cases where the lengths of the different cases of the \nsame character differ. The first went wrong with heap frame storage; the 2nd\nwas broken in all cases."));
  res.add(new RegExp(r"Check property support in non-UTF-8 mode"));
  res.add(new RegExp(r"\p{L}{4}"));
  res.add(new RegExp(r"\X{1,3}\d"));
  res.add(new RegExp(r"\X?\d"));
  res.add(new RegExp(r"\P{L}?\d"));
  res.add(new RegExp(r"[\PPP\x8a]{1,}\x80"));
  res.add(new RegExp(r"(?:[\PPa*]*){8,}"));
  res.add(new RegExp(r"[\P{Any}]"));
  res.add(new RegExp(r"[\P{Any}\E]"));
  res.add(new RegExp(r"(\P{Yi}{2}\277)?"));
  res.add(new RegExp(r"[\P{Yi}A]"));
  res.add(new RegExp(r"[\P{Yi}\P{Yi}\P{Yi}A]"));
  res.add(new RegExp(r"[^\P{Yi}A]"));
  res.add(new RegExp(r"[^\P{Yi}\P{Yi}\P{Yi}A]"));
  res.add(new RegExp(r"(\P{Yi}*\277)*"));
  res.add(new RegExp(r"(\P{Yi}*?\277)*"));
  res.add(new RegExp(r"(\P{Yi}?\277)*"));
  res.add(new RegExp(r"(\P{Yi}??\277)*"));
  res.add(new RegExp(r"(\P{Yi}{0,3}\277)*"));
  res.add(new RegExp(r"(\P{Yi}{0,3}?\277)*"));
  res.add(new RegExp(r"^[\p{Arabic}]"));
  res.add(new RegExp(r"^\p{Cyrillic}"));
  res.add(new RegExp(r"^\p{Common}"));
  res.add(new RegExp(r"^\p{Inherited}"));
  res.add(new RegExp(r"^\p{Shavian}"));
  res.add(new RegExp(r"^\p{Deseret}"));
  res.add(new RegExp(r"^\p{Osmanya}"));
  res.add(new RegExp(r"\p{Zl}"));
  res.add(new RegExp(r"\p{Carian}\p{Cham}\p{Kayah_Li}\p{Lepcha}\p{Lycian}\p{Lydian}\p{Ol_Chiki}\p{Rejang}\p{Saurashtra}\p{Sundanese}\p{Vai}"));
  res.add(new RegExp(r"(A)\1", caseSensitive: false));
  res.add(new RegExp(r" End of testinput6 "));
  res.add(new RegExp(r"abc"));
  res.add(new RegExp(r"ab*c"));
  res.add(new RegExp(r"ab+c"));
  res.add(new RegExp(r"a*"));
  res.add(new RegExp(r"(a|abcd|african)"));
  res.add(new RegExp(r"^abc"));
  res.add(new RegExp(r"^abc", multiLine: true));
  res.add(new RegExp(r"\Aabc"));
  res.add(new RegExp(r"\Aabc", multiLine: true));
  res.add(new RegExp(r"\Gabc"));
  res.add(new RegExp(r"x\dy\Dz"));
  res.add(new RegExp(r"x\sy\Sz"));
  res.add(new RegExp(r"x\wy\Wz"));
  res.add(new RegExp(r"x.y"));
  res.add(new RegExp(r"x.y"));
  res.add(new RegExp(r"a\d\z"));
  res.add(new RegExp(r"a\d\z", multiLine: true));
  res.add(new RegExp(r"a\d\Z"));
  res.add(new RegExp(r"a\d\Z", multiLine: true));
  res.add(new RegExp(r"a\d$"));
  res.add(new RegExp(r"a\d$", multiLine: true));
  res.add(new RegExp(r"abc", caseSensitive: false));
  res.add(new RegExp(r"[^a]"));
  res.add(new RegExp(r"ab?\w"));
  res.add(new RegExp(r"x{0,3}yz"));
  res.add(new RegExp(r"x{3}yz"));
  res.add(new RegExp(r"x{2,3}yz"));
  res.add(new RegExp(r"[^a]+"));
  res.add(new RegExp(r"[^a]*"));
  res.add(new RegExp(r"[^a]{3,5}"));
  res.add(new RegExp(r"\d*"));
  res.add(new RegExp(r"\D*"));
  res.add(new RegExp(r"\d+"));
  res.add(new RegExp(r"\D+"));
  res.add(new RegExp(r"\d?A"));
  res.add(new RegExp(r"\D?A"));
  res.add(new RegExp(r"a+"));
  res.add(new RegExp(r"^.*xyz"));
  res.add(new RegExp(r"^.+xyz"));
  res.add(new RegExp(r"^.?xyz"));
  res.add(new RegExp(r"^\d{2,3}X"));
  res.add(new RegExp(r"^[abcd]\d"));
  res.add(new RegExp(r"^[abcd]*\d"));
  res.add(new RegExp(r"^[abcd]+\d"));
  res.add(new RegExp(r"^a+X"));
  res.add(new RegExp(r"^[abcd]?\d"));
  res.add(new RegExp(r"^[abcd]{2,3}\d"));
  res.add(new RegExp(r"^(abc)*\d"));
  res.add(new RegExp(r"^(abc)+\d"));
  res.add(new RegExp(r"^(abc)?\d"));
  res.add(new RegExp(r"^(abc){2,3}\d"));
  res.add(new RegExp(r"^(a*\w|ab)=(a*\w|ab)"));
  res.add(new RegExp(r"^(?=abc)\w{5}:$"));
  res.add(new RegExp(r"^(?!abc)\d\d$"));
  res.add(new RegExp(r"(ab|cd){3,4}"));
  res.add(new RegExp(r"^abc"));
  res.add(new RegExp(r"^(a*|xyz)"));
  res.add(new RegExp(r"xyz$"));
  res.add(new RegExp(r"xyz$", multiLine: true));
  res.add(new RegExp(r"\Gabc"));
  res.add(new RegExp(r"^abcdef"));
  res.add(new RegExp(r"^a{2,4}\d+z"));
  res.add(new RegExp(r"^abcdef"));
  res.add(new RegExp(r"(ab*(cd|ef))+X"));
  res.add(new RegExp(r"the quick brown fox"));
  res.add(new RegExp(r"The quick brown fox", caseSensitive: false));
  res.add(new RegExp(r"abcd\t\n\r\f\a\e\071\x3b\$\\\?caxyz"));
  res.add(new RegExp(r"a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz"));
  res.add(new RegExp(r"^(abc){1,2}zz"));
  res.add(new RegExp(r"^(b+?|a){1,2}?c"));
  res.add(new RegExp(r"^(b+|a){1,2}c"));
  res.add(new RegExp(r"^(b*|ba){1,2}?bc"));
  res.add(new RegExp(r"^(ba|b*){1,2}?bc"));
  res.add(new RegExp(r"^[ab\]cde]"));
  res.add(new RegExp(r"^[]cde]"));
  res.add(new RegExp(r"^[^ab\]cde]"));
  res.add(new RegExp(r"^[^]cde]"));
  res.add(new RegExp(r"^[0-9]+$"));
  res.add(new RegExp(r"^.*nter"));
  res.add(new RegExp(r"^xxx[0-9]+$"));
  res.add(new RegExp(r"^.+[0-9][0-9][0-9]$"));
  res.add(new RegExp(r"^.+?[0-9][0-9][0-9]$"));
  res.add(new RegExp(r"^([^!]+)!(.+)=apquxz\.ixr\.zzz\.ac\.uk$"));
  res.add(new RegExp(r":"));
  res.add(new RegExp(r"([\da-f:]+)$", caseSensitive: false));
  res.add(new RegExp(r"^.*\.(\d{1,3})\.(\d{1,3})\.(\d{1,3})$"));
  res.add(new RegExp(r"^(\d+)\s+IN\s+SOA\s+(\S+)\s+(\S+)\s*\(\s*$"));
  res.add(new RegExp(r"^[a-zA-Z\d][a-zA-Z\d\-]*(\.[a-zA-Z\d][a-zA-z\d\-]*)*\.$"));
  res.add(new RegExp(r"^\*\.[a-z]([a-z\-\d]*[a-z\d]+)?(\.[a-z]([a-z\-\d]*[a-z\d]+)?)*$"));
  res.add(new RegExp(r"^(?=ab(de))(abd)(e)"));
  res.add(new RegExp(r"^(?!(ab)de|x)(abd)(f)"));
  res.add(new RegExp(r"^(?=(ab(cd)))(ab)"));
  res.add(new RegExp(r"^[\da-f](\.[\da-f])*$", caseSensitive: false));
  res.add(new RegExp(r'^\".*\"\s*(;.*)?$'));
  res.add(new RegExp(r"^$"));
  res.add(new RegExp(r"^ab\sc$"));
  res.add(new RegExp(r"^a\ b[c]d$"));
  res.add(new RegExp(r"^(a(b(c)))(d(e(f)))(h(i(j)))(k(l(m)))$"));
  res.add(new RegExp(r"^(?:a(b(c)))(?:d(e(f)))(?:h(i(j)))(?:k(l(m)))$"));
  res.add(new RegExp(r"^[\w][\W][\s][\S][\d][\D][\b][\n][\c]][\022]"));
  res.add(new RegExp(r"^a*\w"));
  res.add(new RegExp(r"^a*?\w"));
  res.add(new RegExp(r"^a+\w"));
  res.add(new RegExp(r"^a+?\w"));
  res.add(new RegExp(r"^\d{8}\w{2,}"));
  res.add(new RegExp(r"^[aeiou\d]{4,5}$"));
  res.add(new RegExp(r"^[aeiou\d]{4,5}?"));
  res.add(new RegExp(r"^From +([^ ]+) +[a-zA-Z][a-zA-Z][a-zA-Z] +[a-zA-Z][a-zA-Z][a-zA-Z] +[0-9]?[0-9] +[0-9][0-9]:[0-9][0-9]"));
  res.add(new RegExp(r"^From\s+\S+\s+([a-zA-Z]{3}\s+){2}\d{1,2}\s+\d\d:\d\d"));
  res.add(new RegExp(r"^12.34"));
  res.add(new RegExp(r"\w+(?=\t)"));
  res.add(new RegExp(r"foo(?!bar)(.*)"));
  res.add(new RegExp(r"(?:(?!foo)...|^.{0,2})bar(.*)"));
  res.add(new RegExp(r"^(\D*)(?=\d)(?!123)"));
  res.add(new RegExp(r"^1234"));
  res.add(new RegExp(r"^1234"));
  res.add(new RegExp(r"abcd"));
  res.add(new RegExp(r"^abcd"));
  res.add(new RegExp(r"(?!^)abc"));
  res.add(new RegExp(r"(?=^)abc"));
  res.add(new RegExp(r"^[ab]{1,3}(ab*|b)"));
  res.add(new RegExp(r"^[ab]{1,3}?(ab*|b)"));
  res.add(new RegExp(r"^[ab]{1,3}?(ab*?|b)"));
  res.add(new RegExp(r"^[ab]{1,3}(ab*?|b)"));
  res.add(new RegExp(r'(?:[\040\t]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff])*\))*\))*(?:(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|"(?:[^\\\x80-\xff\n\015"]|\\[^\x80-\xff])*")(?:(?:[\040\t]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff])*\))*\))*\.(?:[\040\t]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff])*\))*\))*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|"(?:[^\\\x80-\xff\n\015"]|\\[^\x80-\xff])*"))*(?:[\040\t]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff])*\))*\))*@(?:[\040\t]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff])*\))*\))*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|\[(?:[^\\\x80-\xff\n\015\[\]]|\\[^\x80-\xff])*\])(?:(?:[\040\t]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff])*\))*\))*\.(?:[\040\t]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff])*\))*\))*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|\[(?:[^\\\x80-\xff\n\015\[\]]|\\[^\x80-\xff])*\]))*|(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|"(?:[^\\\x80-\xff\n\015"]|\\[^\x80-\xff])*")(?:[^()<>@,;:".\\\[\]\x80-\xff\000-\010\012-\037]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff])*\))*\)|"(?:[^\\\x80-\xff\n\015"]|\\[^\x80-\xff])*")*<(?:[\040\t]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff])*\))*\))*(?:@(?:[\040\t]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff])*\))*\))*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|\[(?:[^\\\x80-\xff\n\015\[\]]|\\[^\x80-\xff])*\])(?:(?:[\040\t]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff])*\))*\))*\.(?:[\040\t]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff])*\))*\))*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|\[(?:[^\\\x80-\xff\n\015\[\]]|\\[^\x80-\xff])*\]))*(?:(?:[\040\t]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff])*\))*\))*,(?:[\040\t]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff])*\))*\))*@(?:[\040\t]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff])*\))*\))*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|\[(?:[^\\\x80-\xff\n\015\[\]]|\\[^\x80-\xff])*\])(?:(?:[\040\t]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff])*\))*\))*\.(?:[\040\t]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff])*\))*\))*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|\[(?:[^\\\x80-\xff\n\015\[\]]|\\[^\x80-\xff])*\]))*)*:(?:[\040\t]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff])*\))*\))*)?(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|"(?:[^\\\x80-\xff\n\015"]|\\[^\x80-\xff])*")(?:(?:[\040\t]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff])*\))*\))*\.(?:[\040\t]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff])*\))*\))*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|"(?:[^\\\x80-\xff\n\015"]|\\[^\x80-\xff])*"))*(?:[\040\t]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff])*\))*\))*@(?:[\040\t]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff])*\))*\))*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|\[(?:[^\\\x80-\xff\n\015\[\]]|\\[^\x80-\xff])*\])(?:(?:[\040\t]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff])*\))*\))*\.(?:[\040\t]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff])*\))*\))*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|\[(?:[^\\\x80-\xff\n\015\[\]]|\\[^\x80-\xff])*\]))*(?:[\040\t]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff])*\))*\))*>)(?:[\040\t]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff]|\((?:[^\\\x80-\xff\n\015()]|\\[^\x80-\xff])*\))*\))*'));
  res.add(new RegExp(r'[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*(?:(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|"[^\\\x80-\xff\n\015"]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015"]*)*")[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*(?:\.[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|"[^\\\x80-\xff\n\015"]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015"]*)*")[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*)*@[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|\[(?:[^\\\x80-\xff\n\015\[\]]|\\[^\x80-\xff])*\])[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*(?:\.[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|\[(?:[^\\\x80-\xff\n\015\[\]]|\\[^\x80-\xff])*\])[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*)*|(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|"[^\\\x80-\xff\n\015"]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015"]*)*")[^()<>@,;:".\\\[\]\x80-\xff\000-\010\012-\037]*(?:(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)|"[^\\\x80-\xff\n\015"]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015"]*)*")[^()<>@,;:".\\\[\]\x80-\xff\000-\010\012-\037]*)*<[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*(?:@[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|\[(?:[^\\\x80-\xff\n\015\[\]]|\\[^\x80-\xff])*\])[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*(?:\.[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|\[(?:[^\\\x80-\xff\n\015\[\]]|\\[^\x80-\xff])*\])[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*)*(?:,[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*@[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|\[(?:[^\\\x80-\xff\n\015\[\]]|\\[^\x80-\xff])*\])[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*(?:\.[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|\[(?:[^\\\x80-\xff\n\015\[\]]|\\[^\x80-\xff])*\])[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*)*)*:[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*)?(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|"[^\\\x80-\xff\n\015"]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015"]*)*")[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*(?:\.[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|"[^\\\x80-\xff\n\015"]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015"]*)*")[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*)*@[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|\[(?:[^\\\x80-\xff\n\015\[\]]|\\[^\x80-\xff])*\])[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*(?:\.[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|\[(?:[^\\\x80-\xff\n\015\[\]]|\\[^\x80-\xff])*\])[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*)*>)'));
  res.add(new RegExp(r"abc\x0def\x00pqr\x000xyz\x0000AB"));
  res.add(new RegExp(r"^[\000-\037]"));
  res.add(new RegExp(r"\0*"));
  res.add(new RegExp(r"A\x0{2,3}Z"));
  res.add(new RegExp(r"^\s"));
  res.add(new RegExp(r"^abc"));
  res.add(new RegExp(r"ab{1,3}bc"));
  res.add(new RegExp(r"([^.]*)\.([^:]*):[T ]+(.*)"));
  res.add(new RegExp(r"([^.]*)\.([^:]*):[T ]+(.*)", caseSensitive: false));
  res.add(new RegExp(r"([^.]*)\.([^:]*):[t ]+(.*)", caseSensitive: false));
  res.add(new RegExp(r"^[W-c]+$"));
  res.add(new RegExp(r"^[W-c]+$", caseSensitive: false));
  res.add(new RegExp(r"^[\x3f-\x5F]+$", caseSensitive: false));
  res.add(new RegExp(r"^abc$", multiLine: true));
  res.add(new RegExp(r"^abc$"));
  res.add(new RegExp(r"\Aabc\Z", multiLine: true));
  res.add(new RegExp(r"\A(.)*\Z"));
  res.add(new RegExp(r"\A(.)*\Z", multiLine: true));
  res.add(new RegExp(r"(?:b)|(?::+)"));
  res.add(new RegExp(r"[-az]+"));
  res.add(new RegExp(r"[az-]+"));
  res.add(new RegExp(r"[a\-z]+"));
  res.add(new RegExp(r"[a-z]+"));
  res.add(new RegExp(r"[\d-]+"));
  res.add(new RegExp(r"[\d-z]+"));
  res.add(new RegExp(r"\x5c"));
  res.add(new RegExp(r"\x20Z"));
  res.add(new RegExp(r"ab{3cd"));
  res.add(new RegExp(r"ab{3,cd"));
  res.add(new RegExp(r"ab{3,4a}cd"));
  res.add(new RegExp(r"{4,5a}bc"));
  res.add(new RegExp(r"^a.b"));
  res.add(new RegExp(r"abc$"));
  res.add(new RegExp(r"(abc)\123"));
  res.add(new RegExp(r"(abc)\223"));
  res.add(new RegExp(r"(abc)\323"));
  res.add(new RegExp(r"(abc)\100"));
  res.add(new RegExp(r"abc\81"));
  res.add(new RegExp(r"abc\91"));
  res.add(new RegExp(r"(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)\12\123"));
  res.add(new RegExp(r"ab\idef"));
  res.add(new RegExp(r"a{0}bc"));
  res.add(new RegExp(r"(a|(bc)){0,0}?xyz"));
  res.add(new RegExp(r"abc[\10]de"));
  res.add(new RegExp(r"abc[\1]de"));
  res.add(new RegExp(r"(abc)[\1]de"));
  res.add(new RegExp(r"^([^a])([^\b])([^c]*)([^d]{3,4})"));
  res.add(new RegExp(r"[^a]"));
  res.add(new RegExp(r"[^a]", caseSensitive: false));
  res.add(new RegExp(r"[^a]+"));
  res.add(new RegExp(r"[^a]+", caseSensitive: false));
  res.add(new RegExp(r"[^a]+"));
  res.add(new RegExp(r"[^k]$"));
  res.add(new RegExp(r"[^k]{2,3}$"));
  res.add(new RegExp(r"^\d{8,}\@.+[^k]$"));
  res.add(new RegExp(r"[^a]"));
  res.add(new RegExp(r"[^a]", caseSensitive: false));
  res.add(new RegExp(r"[^az]"));
  res.add(new RegExp(r"[^az]", caseSensitive: false));
  res.add(new RegExp(r"\000\001\002\003\004\005\006\007\010\011\012\013\014\015\016\017\020\021\022\023\024\025\026\027\030\031\032\033\034\035\036\037\040\041\042\043\044\045\046\047\050\051\052\053\054\055\056\057\060\061\062\063\064\065\066\067\070\071\072\073\074\075\076\077\100\101\102\103\104\105\106\107\110\111\112\113\114\115\116\117\120\121\122\123\124\125\126\127\130\131\132\133\134\135\136\137\140\141\142\143\144\145\146\147\150\151\152\153\154\155\156\157\160\161\162\163\164\165\166\167\170\171\172\173\174\175\176\177\200\201\202\203\204\205\206\207\210\211\212\213\214\215\216\217\220\221\222\223\224\225\226\227\230\231\232\233\234\235\236\237\240\241\242\243\244\245\246\247\250\251\252\253\254\255\256\257\260\261\262\263\264\265\266\267\270\271\272\273\274\275\276\277\300\301\302\303\304\305\306\307\310\311\312\313\314\315\316\317\320\321\322\323\324\325\326\327\330\331\332\333\334\335\336\337\340\341\342\343\344\345\346\347\350\351\352\353\354\355\356\357\360\361\362\363\364\365\366\367\370\371\372\373\374\375\376\377"));
  res.add(new RegExp(r"P[^*]TAIRE[^*]{1,6}?LL"));
  res.add(new RegExp(r"P[^*]TAIRE[^*]{1,}?LL"));
  res.add(new RegExp(r"(\.\d\d[1-9]?)\d+"));
  res.add(new RegExp(r"(\.\d\d((?=0)|\d(?=\d)))"));
  res.add(new RegExp(r"\b(foo)\s+(\w+)", caseSensitive: false));
  res.add(new RegExp(r"foo(.*)bar"));
  res.add(new RegExp(r"foo(.*?)bar"));
  res.add(new RegExp(r"(.*)(\d*)"));
  res.add(new RegExp(r"(.*)(\d+)"));
  res.add(new RegExp(r"(.*?)(\d*)"));
  res.add(new RegExp(r"(.*?)(\d+)"));
  res.add(new RegExp(r"(.*)(\d+)$"));
  res.add(new RegExp(r"(.*?)(\d+)$"));
  res.add(new RegExp(r"(.*)\b(\d+)$"));
  res.add(new RegExp(r"(.*\D)(\d+)$"));
  res.add(new RegExp(r"^\D*(?!123)"));
  res.add(new RegExp(r"^(\D*)(?=\d)(?!123)"));
  res.add(new RegExp(r"^[W-]46]"));
  res.add(new RegExp(r"^[W-\]46]"));
  res.add(new RegExp(r"\d\d\/\d\d\/\d\d\d\d"));
  res.add(new RegExp(r"word (?:[a-zA-Z0-9]+ ){0,10}otherword"));
  res.add(new RegExp(r"word (?:[a-zA-Z0-9]+ ){0,300}otherword"));
  res.add(new RegExp(r"^(a){0,0}"));
  res.add(new RegExp(r"^(a){0,1}"));
  res.add(new RegExp(r"^(a){0,2}"));
  res.add(new RegExp(r"^(a){0,3}"));
  res.add(new RegExp(r"^(a){0,}"));
  res.add(new RegExp(r"^(a){1,1}"));
  res.add(new RegExp(r"^(a){1,2}"));
  res.add(new RegExp(r"^(a){1,3}"));
  res.add(new RegExp(r"^(a){1,}"));
  res.add(new RegExp(r".*\.gif"));
  res.add(new RegExp(r".{0,}\.gif"));
  res.add(new RegExp(r".*\.gif", multiLine: true));
  res.add(new RegExp(r".*\.gif"));
  res.add(new RegExp(r".*\.gif", multiLine: true));
  res.add(new RegExp(r".*$"));
  res.add(new RegExp(r".*$", multiLine: true));
  res.add(new RegExp(r".*$"));
  res.add(new RegExp(r".*$", multiLine: true));
  res.add(new RegExp(r".*$"));
  res.add(new RegExp(r".*$", multiLine: true));
  res.add(new RegExp(r".*$"));
  res.add(new RegExp(r".*$", multiLine: true));
  res.add(new RegExp(r"(.*X|^B)"));
  res.add(new RegExp(r"(.*X|^B)", multiLine: true));
  res.add(new RegExp(r"(.*X|^B)"));
  res.add(new RegExp(r"(.*X|^B)", multiLine: true));
  res.add(new RegExp(r"^.*B"));
  res.add(new RegExp(r"^[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]"));
  res.add(new RegExp(r"^\d\d\d\d\d\d\d\d\d\d\d\d"));
  res.add(new RegExp(r"^[\d][\d][\d][\d][\d][\d][\d][\d][\d][\d][\d][\d]"));
  res.add(new RegExp(r"^[abc]{12}"));
  res.add(new RegExp(r"^[a-c]{12}"));
  res.add(new RegExp(r"^(a|b|c){12}"));
  res.add(new RegExp(r"^[abcdefghijklmnopqrstuvwxy0123456789]"));
  res.add(new RegExp(r"abcde{0,0}"));
  res.add(new RegExp(r"ab[cd]{0,0}e"));
  res.add(new RegExp(r"ab(c){0,0}d"));
  res.add(new RegExp(r"a(b*)"));
  res.add(new RegExp(r"ab\d{0}e"));
  res.add(new RegExp(r'"([^\\"]+|\\.)*"'));
  res.add(new RegExp(r".*?"));
  res.add(new RegExp(r"\b"));
  res.add(new RegExp(r"\b"));
  res.add(new RegExp(r"<tr([\w\W\s\d][^<>]{0,})><TD([\w\W\s\d][^<>]{0,})>([\d]{0,}\.)(.*)((<BR>([\w\W\s\d][^<>]{0,})|[\s]{0,}))<\/a><\/TD><TD([\w\W\s\d][^<>]{0,})>([\w\W\s\d][^<>]{0,})<\/TD><TD([\w\W\s\d][^<>]{0,})>([\w\W\s\d][^<>]{0,})<\/TD><\/TR>", caseSensitive: false));
  res.add(new RegExp(r"a[^a]b"));
  res.add(new RegExp(r"a.b"));
  res.add(new RegExp(r"a[^a]b"));
  res.add(new RegExp(r"a.b"));
  res.add(new RegExp(r"^(b+?|a){1,2}?c"));
  res.add(new RegExp(r"^(b+|a){1,2}?c"));
  res.add(new RegExp(r"(?!\A)x", multiLine: true));
  res.add(new RegExp(r"\x0{ab}"));
  res.add(new RegExp(r"(A|B)*?CD"));
  res.add(new RegExp(r"(A|B)*CD"));
  res.add(new RegExp(r"\Aabc\z", multiLine: true));
  res.add(new RegExp(r"(\d+)(\w)"));
  res.add(new RegExp(r"(a+|b+|c+)*c"));
  res.add(new RegExp(r"(abc|)+"));
  res.add(new RegExp(r"([a]*)*"));
  res.add(new RegExp(r"([ab]*)*"));
  res.add(new RegExp(r"([^a]*)*"));
  res.add(new RegExp(r"([^ab]*)*"));
  res.add(new RegExp(r"([a]*?)*"));
  res.add(new RegExp(r"([ab]*?)*"));
  res.add(new RegExp(r"([^a]*?)*"));
  res.add(new RegExp(r"([^ab]*?)*"));
  res.add(new RegExp(r"The following tests are taken from the Perl 5.005 test suite; some of them"));
  res.add(new RegExp(r"are compatible with 5.004, but I'd rather not have to sort them out."));
  res.add(new RegExp(r"abc"));
  res.add(new RegExp(r"ab*c"));
  res.add(new RegExp(r"ab*bc"));
  res.add(new RegExp(r".{1}"));
  res.add(new RegExp(r".{3,4}"));
  res.add(new RegExp(r"ab{0,}bc"));
  res.add(new RegExp(r"ab+bc"));
  res.add(new RegExp(r"ab{1,}bc"));
  res.add(new RegExp(r"ab+bc"));
  res.add(new RegExp(r"ab{1,}bc"));
  res.add(new RegExp(r"ab{1,3}bc"));
  res.add(new RegExp(r"ab{3,4}bc"));
  res.add(new RegExp(r"ab{4,5}bc"));
  res.add(new RegExp(r"ab?bc"));
  res.add(new RegExp(r"ab{0,1}bc"));
  res.add(new RegExp(r"ab?bc"));
  res.add(new RegExp(r"ab?c"));
  res.add(new RegExp(r"ab{0,1}c"));
  res.add(new RegExp(r"^abc$"));
  res.add(new RegExp(r"^abc"));
  res.add(new RegExp(r"^abc$"));
  res.add(new RegExp(r"abc$"));
  res.add(new RegExp(r"^"));
  res.add(new RegExp(r"$"));
  res.add(new RegExp(r"a.c"));
  res.add(new RegExp(r"a.*c"));
  res.add(new RegExp(r"a[bc]d"));
  res.add(new RegExp(r"a[b-d]e"));
  res.add(new RegExp(r"a[b-d]"));
  res.add(new RegExp(r"a[-b]"));
  res.add(new RegExp(r"a[b-]"));
  res.add(new RegExp(r"a]"));
  res.add(new RegExp(r"a[]]b"));
  res.add(new RegExp(r"a[^bc]d"));
  res.add(new RegExp(r"a[^-b]c"));
  res.add(new RegExp(r"a[^]b]c"));
  res.add(new RegExp(r"\ba\b"));
  res.add(new RegExp(r"\by\b"));
  res.add(new RegExp(r"\Ba\B"));
  res.add(new RegExp(r"\By\b"));
  res.add(new RegExp(r"\by\B"));
  res.add(new RegExp(r"\By\B"));
  res.add(new RegExp(r"\w"));
  res.add(new RegExp(r"\W"));
  res.add(new RegExp(r"a\sb"));
  res.add(new RegExp(r"a\Sb"));
  res.add(new RegExp(r"\d"));
  res.add(new RegExp(r"\D"));
  res.add(new RegExp(r"[\w]"));
  res.add(new RegExp(r"[\W]"));
  res.add(new RegExp(r"a[\s]b"));
  res.add(new RegExp(r"a[\S]b"));
  res.add(new RegExp(r"[\d]"));
  res.add(new RegExp(r"[\D]"));
  res.add(new RegExp(r"ab|cd"));
  res.add(new RegExp(r"()ef"));
  res.add(new RegExp(r"$b"));
  res.add(new RegExp(r"a\(b"));
  res.add(new RegExp(r"a\\b"));
  res.add(new RegExp(r"((a))"));
  res.add(new RegExp(r"(a)b(c)"));
  res.add(new RegExp(r"a+b+c"));
  res.add(new RegExp(r"a{1,}b{1,}c"));
  res.add(new RegExp(r"a.+?c"));
  res.add(new RegExp(r"(a+|b)*"));
  res.add(new RegExp(r"(a+|b){0,}"));
  res.add(new RegExp(r"(a+|b)+"));
  res.add(new RegExp(r"(a+|b){1,}"));
  res.add(new RegExp(r"(a+|b)?"));
  res.add(new RegExp(r"(a+|b){0,1}"));
  res.add(new RegExp(r"[^ab]*"));
  res.add(new RegExp(r"abc"));
  res.add(new RegExp(r"a*"));
  res.add(new RegExp(r"([abc])*d"));
  res.add(new RegExp(r"([abc])*bcd"));
  res.add(new RegExp(r"a|b|c|d|e"));
  res.add(new RegExp(r"(a|b|c|d|e)f"));
  res.add(new RegExp(r"abcd*efg"));
  res.add(new RegExp(r"ab*"));
  res.add(new RegExp(r"(ab|cd)e"));
  res.add(new RegExp(r"[abhgefdc]ij"));
  res.add(new RegExp(r"^(ab|cd)e"));
  res.add(new RegExp(r"(abc|)ef"));
  res.add(new RegExp(r"(a|b)c*d"));
  res.add(new RegExp(r"(ab|ab*)bc"));
  res.add(new RegExp(r"a([bc]*)c*"));
  res.add(new RegExp(r"a([bc]*)(c*d)"));
  res.add(new RegExp(r"a([bc]+)(c*d)"));
  res.add(new RegExp(r"a([bc]*)(c+d)"));
  res.add(new RegExp(r"a[bcd]*dcdcde"));
  res.add(new RegExp(r"a[bcd]+dcdcde"));
  res.add(new RegExp(r"(ab|a)b*c"));
  res.add(new RegExp(r"((a)(b)c)(d)"));
  res.add(new RegExp(r"[a-zA-Z_][a-zA-Z0-9_]*"));
  res.add(new RegExp(r"^a(bc+|b[eh])g|.h$"));
  res.add(new RegExp(r"(bc+d$|ef*g.|h?i(j|k))"));
  res.add(new RegExp(r"((((((((((a))))))))))"));
  res.add(new RegExp(r"(((((((((a)))))))))"));
  res.add(new RegExp(r"multiple words of text"));
  res.add(new RegExp(r"multiple words"));
  res.add(new RegExp(r"(.*)c(.*)"));
  res.add(new RegExp(r"\((.*), (.*)\)"));
  res.add(new RegExp(r"[k]"));
  res.add(new RegExp(r"abcd"));
  res.add(new RegExp(r"a(bc)d"));
  res.add(new RegExp(r"a[-]?c"));
  res.add(new RegExp(r"abc", caseSensitive: false));
  res.add(new RegExp(r"ab*c", caseSensitive: false));
  res.add(new RegExp(r"ab*bc", caseSensitive: false));
  res.add(new RegExp(r"ab*?bc", caseSensitive: false));
  res.add(new RegExp(r"ab{0,}?bc", caseSensitive: false));
  res.add(new RegExp(r"ab+?bc", caseSensitive: false));
  res.add(new RegExp(r"ab+bc", caseSensitive: false));
  res.add(new RegExp(r"ab{1,}bc", caseSensitive: false));
  res.add(new RegExp(r"ab+bc", caseSensitive: false));
  res.add(new RegExp(r"ab{1,}?bc", caseSensitive: false));
  res.add(new RegExp(r"ab{1,3}?bc", caseSensitive: false));
  res.add(new RegExp(r"ab{3,4}?bc", caseSensitive: false));
  res.add(new RegExp(r"ab{4,5}?bc", caseSensitive: false));
  res.add(new RegExp(r"ab??bc", caseSensitive: false));
  res.add(new RegExp(r"ab{0,1}?bc", caseSensitive: false));
  res.add(new RegExp(r"ab??bc", caseSensitive: false));
  res.add(new RegExp(r"ab??c", caseSensitive: false));
  res.add(new RegExp(r"ab{0,1}?c", caseSensitive: false));
  res.add(new RegExp(r"^abc$", caseSensitive: false));
  res.add(new RegExp(r"^abc", caseSensitive: false));
  res.add(new RegExp(r"^abc$", caseSensitive: false));
  res.add(new RegExp(r"abc$", caseSensitive: false));
  res.add(new RegExp(r"^", caseSensitive: false));
  res.add(new RegExp(r"$", caseSensitive: false));
  res.add(new RegExp(r"a.c", caseSensitive: false));
  res.add(new RegExp(r"a.*?c", caseSensitive: false));
  res.add(new RegExp(r"a.*c", caseSensitive: false));
  res.add(new RegExp(r"a[bc]d", caseSensitive: false));
  res.add(new RegExp(r"a[b-d]e", caseSensitive: false));
  res.add(new RegExp(r"a[b-d]", caseSensitive: false));
  res.add(new RegExp(r"a[-b]", caseSensitive: false));
  res.add(new RegExp(r"a[b-]", caseSensitive: false));
  res.add(new RegExp(r"a]", caseSensitive: false));
  res.add(new RegExp(r"a[]]b", caseSensitive: false));
  res.add(new RegExp(r"a[^bc]d", caseSensitive: false));
  res.add(new RegExp(r"a[^-b]c", caseSensitive: false));
  res.add(new RegExp(r"a[^]b]c", caseSensitive: false));
  res.add(new RegExp(r"ab|cd", caseSensitive: false));
  res.add(new RegExp(r"()ef", caseSensitive: false));
  res.add(new RegExp(r"$b", caseSensitive: false));
  res.add(new RegExp(r"a\(b", caseSensitive: false));
  res.add(new RegExp(r"a\\b", caseSensitive: false));
  res.add(new RegExp(r"((a))", caseSensitive: false));
  res.add(new RegExp(r"(a)b(c)", caseSensitive: false));
  res.add(new RegExp(r"a+b+c", caseSensitive: false));
  res.add(new RegExp(r"a{1,}b{1,}c", caseSensitive: false));
  res.add(new RegExp(r"a.+?c", caseSensitive: false));
  res.add(new RegExp(r"a.*?c", caseSensitive: false));
  res.add(new RegExp(r"a.{0,5}?c", caseSensitive: false));
  res.add(new RegExp(r"(a+|b)*", caseSensitive: false));
  res.add(new RegExp(r"(a+|b){0,}", caseSensitive: false));
  res.add(new RegExp(r"(a+|b)+", caseSensitive: false));
  res.add(new RegExp(r"(a+|b){1,}", caseSensitive: false));
  res.add(new RegExp(r"(a+|b)?", caseSensitive: false));
  res.add(new RegExp(r"(a+|b){0,1}", caseSensitive: false));
  res.add(new RegExp(r"(a+|b){0,1}?", caseSensitive: false));
  res.add(new RegExp(r"[^ab]*", caseSensitive: false));
  res.add(new RegExp(r"abc", caseSensitive: false));
  res.add(new RegExp(r"a*", caseSensitive: false));
  res.add(new RegExp(r"([abc])*d", caseSensitive: false));
  res.add(new RegExp(r"([abc])*bcd", caseSensitive: false));
  res.add(new RegExp(r"a|b|c|d|e", caseSensitive: false));
  res.add(new RegExp(r"(a|b|c|d|e)f", caseSensitive: false));
  res.add(new RegExp(r"abcd*efg", caseSensitive: false));
  res.add(new RegExp(r"ab*", caseSensitive: false));
  res.add(new RegExp(r"(ab|cd)e", caseSensitive: false));
  res.add(new RegExp(r"[abhgefdc]ij", caseSensitive: false));
  res.add(new RegExp(r"^(ab|cd)e", caseSensitive: false));
  res.add(new RegExp(r"(abc|)ef", caseSensitive: false));
  res.add(new RegExp(r"(a|b)c*d", caseSensitive: false));
  res.add(new RegExp(r"(ab|ab*)bc", caseSensitive: false));
  res.add(new RegExp(r"a([bc]*)c*", caseSensitive: false));
  res.add(new RegExp(r"a([bc]*)(c*d)", caseSensitive: false));
  res.add(new RegExp(r"a([bc]+)(c*d)", caseSensitive: false));
  res.add(new RegExp(r"a([bc]*)(c+d)", caseSensitive: false));
  res.add(new RegExp(r"a[bcd]*dcdcde", caseSensitive: false));
  res.add(new RegExp(r"a[bcd]+dcdcde", caseSensitive: false));
  res.add(new RegExp(r"(ab|a)b*c", caseSensitive: false));
  res.add(new RegExp(r"((a)(b)c)(d)", caseSensitive: false));
  res.add(new RegExp(r"[a-zA-Z_][a-zA-Z0-9_]*", caseSensitive: false));
  res.add(new RegExp(r"^a(bc+|b[eh])g|.h$", caseSensitive: false));
  res.add(new RegExp(r"(bc+d$|ef*g.|h?i(j|k))", caseSensitive: false));
  res.add(new RegExp(r"((((((((((a))))))))))", caseSensitive: false));
  res.add(new RegExp(r"(((((((((a)))))))))", caseSensitive: false));
  res.add(new RegExp(r"(?:(?:(?:(?:(?:(?:(?:(?:(?:(a))))))))))", caseSensitive: false));
  res.add(new RegExp(r"(?:(?:(?:(?:(?:(?:(?:(?:(?:(a|b|c))))))))))", caseSensitive: false));
  res.add(new RegExp(r"multiple words of text", caseSensitive: false));
  res.add(new RegExp(r"multiple words", caseSensitive: false));
  res.add(new RegExp(r"(.*)c(.*)", caseSensitive: false));
  res.add(new RegExp(r"\((.*), (.*)\)", caseSensitive: false));
  res.add(new RegExp(r"[k]", caseSensitive: false));
  res.add(new RegExp(r"abcd", caseSensitive: false));
  res.add(new RegExp(r"a(bc)d", caseSensitive: false));
  res.add(new RegExp(r"a[-]?c", caseSensitive: false));
  res.add(new RegExp(r"a(?!b)."));
  res.add(new RegExp(r"a(?=d)."));
  res.add(new RegExp(r"a(?=c|d)."));
  res.add(new RegExp(r"a(?:b|c|d)(.)"));
  res.add(new RegExp(r"a(?:b|c|d)*(.)"));
  res.add(new RegExp(r"a(?:b|c|d)+?(.)"));
  res.add(new RegExp(r"a(?:b|c|d)+(.)"));
  res.add(new RegExp(r"a(?:b|c|d){2}(.)"));
  res.add(new RegExp(r"a(?:b|c|d){4,5}(.)"));
  res.add(new RegExp(r"a(?:b|c|d){4,5}?(.)"));
  res.add(new RegExp(r"((foo)|(bar))*"));
  res.add(new RegExp(r"a(?:b|c|d){6,7}(.)"));
  res.add(new RegExp(r"a(?:b|c|d){6,7}?(.)"));
  res.add(new RegExp(r"a(?:b|c|d){5,6}(.)"));
  res.add(new RegExp(r"a(?:b|c|d){5,6}?(.)"));
  res.add(new RegExp(r"a(?:b|c|d){5,7}(.)"));
  res.add(new RegExp(r"a(?:b|c|d){5,7}?(.)"));
  res.add(new RegExp(r"a(?:b|(c|e){1,2}?|d)+?(.)"));
  res.add(new RegExp(r"^(.+)?B"));
  res.add(new RegExp(r"^([^a-z])|(\^)$"));
  res.add(new RegExp(r"^[<>]&"));
  res.add(new RegExp(r"(?:(f)(o)(o)|(b)(a)(r))*"));
  res.add(new RegExp(r"(?:..)*a"));
  res.add(new RegExp(r"(?:..)*?a"));
  res.add(new RegExp(r"^(){3,5}"));
  res.add(new RegExp(r"^(a+)*ax"));
  res.add(new RegExp(r"^((a|b)+)*ax"));
  res.add(new RegExp(r"^((a|bc)+)*ax"));
  res.add(new RegExp(r"(a|x)*ab"));
  res.add(new RegExp(r"(a)*ab"));
  res.add(new RegExp(r"(?:c|d)(?:)(?:a(?:)(?:b)(?:b(?:))(?:b(?:)(?:b)))"));
  res.add(new RegExp(r"(?:c|d)(?:)(?:aaaaaaaa(?:)(?:bbbbbbbb)(?:bbbbbbbb(?:))(?:bbbbbbbb(?:)(?:bbbbbbbb)))"));
  res.add(new RegExp(r"foo\w*\d{4}baz"));
  res.add(new RegExp(r"x(~~)*(?:(?:F)?)?"));
  res.add(new RegExp(r"^a{3}c"));
  res.add(new RegExp(r"^a{3}c"));
  res.add(new RegExp(r"^(?:a?b?)*$"));
  res.add(new RegExp(r"^b"));
  res.add(new RegExp(r"()^b"));
  res.add(new RegExp(r"(\w+:)+"));
  res.add(new RegExp(r"([\w:]+::)?(\w+)$"));
  res.add(new RegExp(r"^[^bcd]*(c+)"));
  res.add(new RegExp(r"(a*)b+"));
  res.add(new RegExp(r"([\w:]+::)?(\w+)$"));
  res.add(new RegExp(r"^[^bcd]*(c+)"));
  res.add(new RegExp(r"(>a+)ab"));
  res.add(new RegExp(r"([[:]+)"));
  res.add(new RegExp(r"([[=]+)"));
  res.add(new RegExp(r"([[.]+)"));
  res.add(new RegExp(r"a\Z"));
  res.add(new RegExp(r"b\Z"));
  res.add(new RegExp(r"b\z"));
  res.add(new RegExp(r"b\Z"));
  res.add(new RegExp(r"b\z"));
  res.add(new RegExp(r"((Z)+|A)*"));
  res.add(new RegExp(r"(Z()|A)*"));
  res.add(new RegExp(r"(Z(())|A)*"));
  res.add(new RegExp(r"a*"));
  res.add(new RegExp(r"^[\d-a]"));
  res.add(new RegExp(r"[[:space:]]+"));
  res.add(new RegExp(r"[[:blank:]]+"));
  res.add(new RegExp(r"[\s]+"));
  res.add(new RegExp(r"\s+"));
  res.add(new RegExp(r"ab"));
  res.add(new RegExp(r"(?!\A)x", multiLine: true));
  res.add(new RegExp(r"(?!^)x", multiLine: true));
  res.add(new RegExp(r"abc\Qabc\Eabc"));
  res.add(new RegExp(r"abc\Qabc\Eabc"));
  res.add(new RegExp(r"abc\Qliteral\E"));
  res.add(new RegExp(r"abc\Qliteral"));
  res.add(new RegExp(r"abc\Qliteral\E"));
  res.add(new RegExp(r"abc\Qliteral\E"));
  res.add(new RegExp(r"\Qabc\$xyz\E"));
  res.add(new RegExp(r"\Qabc\E\$\Qxyz\E"));
  res.add(new RegExp(r"\Gabc"));
  res.add(new RegExp(r"\Gabc."));
  res.add(new RegExp(r"abc."));
  res.add(new RegExp(r"[z\Qa-d]\E]"));
  res.add(new RegExp(r"[\z\C]"));
  res.add(new RegExp(r"\M"));
  res.add(new RegExp(r"(a+)*b"));
  res.add(new RegExp(r"line\nbreak"));
  res.add(new RegExp(r"line\nbreak"));
  res.add(new RegExp(r"line\nbreak", multiLine: true));
  res.add(new RegExp(r"1234"));
  res.add(new RegExp(r"1234"));
  res.add(new RegExp(r"^", multiLine: true));
  res.add(new RegExp(r"Content-Type\x3A[^\r\n]{6,}"));
  res.add(new RegExp(r"Content-Type\x3A[^\r\n]{6,}z"));
  res.add(new RegExp(r"Content-Type\x3A[^a]{6,}"));
  res.add(new RegExp(r"Content-Type\x3A[^a]{6,}z"));
  res.add(new RegExp(r"^abc", multiLine: true));
  res.add(new RegExp(r"abc$", multiLine: true));
  res.add(new RegExp(r"^abc", multiLine: true));
  res.add(new RegExp(r"^abc", multiLine: true));
  res.add(new RegExp(r"^abc", multiLine: true));
  res.add(new RegExp(r".*"));
  res.add(new RegExp(r"\w+(.)(.)?def"));
  res.add(new RegExp(r"^\w+=.*(\\\n.*)*"));
  res.add(new RegExp(r"^(a()*)*"));
  res.add(new RegExp(r"^(?:a(?:(?:))*)*"));
  res.add(new RegExp(r"^(a()+)+"));
  res.add(new RegExp(r"^(?:a(?:(?:))+)+"));
  res.add(new RegExp(r"(a|)*\d"));
  res.add(new RegExp(r"(?:a|)*\d"));
  res.add(new RegExp(r"^a.b"));
  res.add(new RegExp(r"^abc.", multiLine: true));
  res.add(new RegExp(r"abc.$", multiLine: true));
  res.add(new RegExp(r"^a\Rb", caseSensitive: false));
  res.add(new RegExp(r"^a\R*b", caseSensitive: false));
  res.add(new RegExp(r"^a\R+b", caseSensitive: false));
  res.add(new RegExp(r"^a\R{1,3}b", caseSensitive: false));
  res.add(new RegExp(r"^a[\R]b", caseSensitive: false));
  res.add(new RegExp(r".+foo"));
  res.add(new RegExp(r".+foo"));
  res.add(new RegExp(r".+foo"));
  res.add(new RegExp(r".+foo"));
  res.add(new RegExp(r"^$", multiLine: true));
  res.add(new RegExp(r"^X", multiLine: true));
  res.add(new RegExp(r"\H\h\V\v"));
  res.add(new RegExp(r"\H*\h+\V?\v{3,4}"));
  res.add(new RegExp(r"\H{3,4}"));
  res.add(new RegExp(r".\h{3,4}."));
  res.add(new RegExp(r"\h*X\h?\H+Y\H?Z"));
  res.add(new RegExp(r"\v*X\v?Y\v+Z\V*\x0a\V+\x0b\V{2,3}\x0c"));
  res.add(new RegExp(r".+A"));
  res.add(new RegExp(r"\nA"));
  res.add(new RegExp(r"[\r\n]A"));
  res.add(new RegExp(r"(\r|\n)A"));
  res.add(new RegExp(r"a\Rb", caseSensitive: false));
  res.add(new RegExp(r"a\Rb", caseSensitive: false));
  res.add(new RegExp(r"a\R?b", caseSensitive: false));
  res.add(new RegExp(r"a\R?b", caseSensitive: false));
  res.add(new RegExp(r"a\R{2,4}b", caseSensitive: false));
  res.add(new RegExp(r"a\R{2,4}b", caseSensitive: false));
  res.add(new RegExp(r"a(?!)|\wbc"));
  res.add(new RegExp(r"a[]b"));
  res.add(new RegExp(r"a[]+b"));
  res.add(new RegExp(r"a[^]b"));
  res.add(new RegExp(r"a[^]+b"));
  res.add(new RegExp(r" End of testinput7 "));
  res.add(new RegExp(r"\bX"));
  res.add(new RegExp(r"\BX"));
  res.add(new RegExp(r"X\b"));
  res.add(new RegExp(r"X\B"));
  res.add(new RegExp(r"[^a]"));
  res.add(new RegExp(r"abc"));
  res.add(new RegExp(r"a.b"));
  res.add(new RegExp(r"a(.{3})b"));
  res.add(new RegExp(r"a(.*?)(.)"));
  res.add(new RegExp(r"a(.*?)(.)"));
  res.add(new RegExp(r"a(.*)(.)"));
  res.add(new RegExp(r"a(.*)(.)"));
  res.add(new RegExp(r"a(.)(.)"));
  res.add(new RegExp(r"a(.)(.)"));
  res.add(new RegExp(r"a(.?)(.)"));
  res.add(new RegExp(r"a(.?)(.)"));
  res.add(new RegExp(r"a(.??)(.)"));
  res.add(new RegExp(r"a(.??)(.)"));
  res.add(new RegExp(r"a(.{3})b"));
  res.add(new RegExp(r"a(.{3,})b"));
  res.add(new RegExp(r"a(.{3,}?)b"));
  res.add(new RegExp(r"a(.{3,5})b"));
  res.add(new RegExp(r"a(.{3,5}?)b"));
  res.add(new RegExp(r"[^a]+"));
  res.add(new RegExp(r"^[^a]{2}"));
  res.add(new RegExp(r"^[^a]{2,}"));
  res.add(new RegExp(r"^[^a]{2,}?"));
  res.add(new RegExp(r"[^a]+", caseSensitive: false));
  res.add(new RegExp(r"^[^a]{2}", caseSensitive: false));
  res.add(new RegExp(r"^[^a]{2,}", caseSensitive: false));
  res.add(new RegExp(r"^[^a]{2,}?", caseSensitive: false));
  res.add(new RegExp(r"\D*"));
  res.add(new RegExp(r"\D*"));
  res.add(new RegExp(r"\D"));
  res.add(new RegExp(r">\S"));
  res.add(new RegExp(r"\d"));
  res.add(new RegExp(r"\s"));
  res.add(new RegExp(r"\D+"));
  res.add(new RegExp(r"\D{2,3}"));
  res.add(new RegExp(r"\D{2,3}?"));
  res.add(new RegExp(r"\d+"));
  res.add(new RegExp(r"\d{2,3}"));
  res.add(new RegExp(r"\d{2,3}?"));
  res.add(new RegExp(r"\S+"));
  res.add(new RegExp(r"\S{2,3}"));
  res.add(new RegExp(r"\S{2,3}?"));
  res.add(new RegExp(r">\s+<"));
  res.add(new RegExp(r">\s{2,3}<"));
  res.add(new RegExp(r">\s{2,3}?<"));
  res.add(new RegExp(r"\w+"));
  res.add(new RegExp(r"\w{2,3}"));
  res.add(new RegExp(r"\w{2,3}?"));
  res.add(new RegExp(r"\W+"));
  res.add(new RegExp(r"\W{2,3}"));
  res.add(new RegExp(r"\W{2,3}?"));
  res.add(new RegExp(r"[\xFF]"));
  res.add(new RegExp(r"[\xff]"));
  res.add(new RegExp(r"[^\xFF]"));
  res.add(new RegExp(r"[^\xff]"));
  res.add(new RegExp(r"^[ac]*b"));
  res.add(new RegExp(r"^[^x]*b", caseSensitive: false));
  res.add(new RegExp(r"^[^x]*b"));
  res.add(new RegExp(r"^\d*b"));
  res.add(new RegExp(r"(|a)"));
  res.add(new RegExp(r"^abc.", multiLine: true));
  res.add(new RegExp(r"abc.$", multiLine: true));
  res.add(new RegExp(r"^a\Rb", caseSensitive: false));
  res.add(new RegExp(r"^a\R*b", caseSensitive: false));
  res.add(new RegExp(r"^a\R+b", caseSensitive: false));
  res.add(new RegExp(r"^a\R{1,3}b", caseSensitive: false));
  res.add(new RegExp(r"\h+\V?\v{3,4}"));
  res.add(new RegExp(r"\V?\v{3,4}"));
  res.add(new RegExp(r"\h+\V?\v{3,4}"));
  res.add(new RegExp(r"\V?\v{3,4}"));
  res.add(new RegExp(r"\H\h\V\v"));
  res.add(new RegExp(r"\H*\h+\V?\v{3,4}"));
  res.add(new RegExp(r"\H\h\V\v"));
  res.add(new RegExp(r"\H*\h+\V?\v{3,4}"));
  res.add(new RegExp(r"a\Rb", caseSensitive: false));
  res.add(new RegExp(r"a\Rb", caseSensitive: false));
  res.add(new RegExp(r"a\R?b", caseSensitive: false));
  res.add(new RegExp(r"a\R?b", caseSensitive: false));
  res.add(new RegExp(r"X"));
  res.add(new RegExp(r" End of testinput 8 "));
  res.add(new RegExp(r"\pL\P{Nd}"));
  res.add(new RegExp(r"\X."));
  res.add(new RegExp(r"\X\X"));
  res.add(new RegExp(r"^\pL+"));
  res.add(new RegExp(r"^\PL+"));
  res.add(new RegExp(r"^\X+"));
  res.add(new RegExp(r"\X?abc"));
  res.add(new RegExp(r"^\X?abc"));
  res.add(new RegExp(r"\X*abc"));
  res.add(new RegExp(r"^\X*abc"));
  res.add(new RegExp(r"^\pL?=."));
  res.add(new RegExp(r"^\pL*=."));
  res.add(new RegExp(r"^\X{2,3}X"));
  res.add(new RegExp(r"^\pC\pL\pM\pN\pP\pS\pZ<"));
  res.add(new RegExp(r"^\PC"));
  res.add(new RegExp(r"^\PL"));
  res.add(new RegExp(r"^\PM"));
  res.add(new RegExp(r"^\PN"));
  res.add(new RegExp(r"^\PP"));
  res.add(new RegExp(r"^\PS"));
  res.add(new RegExp(r"^\PZ"));
  res.add(new RegExp(r"^\p{Cc}"));
  res.add(new RegExp(r"^\p{Cf}"));
  res.add(new RegExp(r"^\p{Cn}"));
  res.add(new RegExp(r"^\p{Co}"));
  res.add(new RegExp(r"^\p{Cs}"));
  res.add(new RegExp(r"^\p{Ll}"));
  res.add(new RegExp(r"^\p{Lm}"));
  res.add(new RegExp(r"^\p{Lo}"));
  res.add(new RegExp(r"^\p{Lt}"));
  res.add(new RegExp(r"^\p{Lu}"));
  res.add(new RegExp(r"^\p{Mc}"));
  res.add(new RegExp(r"^\p{Me}"));
  res.add(new RegExp(r"^\p{Mn}"));
  res.add(new RegExp(r"^\p{Nl}"));
  res.add(new RegExp(r"^\p{No}"));
  res.add(new RegExp(r"^\p{Pc}"));
  res.add(new RegExp(r"^\p{Pd}"));
  res.add(new RegExp(r"^\p{Pe}"));
  res.add(new RegExp(r"^\p{Pf}"));
  res.add(new RegExp(r"^\p{Pi}"));
  res.add(new RegExp(r"^\p{Po}"));
  res.add(new RegExp(r"^\p{Ps}"));
  res.add(new RegExp(r"^\p{Sk}"));
  res.add(new RegExp(r"^\p{So}"));
  res.add(new RegExp(r"^\p{Zl}"));
  res.add(new RegExp(r"^\p{Zp}"));
  res.add(new RegExp(r"^\p{Zs}"));
  res.add(new RegExp(r"\p{Nd}{2,}(..)"));
  res.add(new RegExp(r"\p{Nd}{2,}?(..)"));
  res.add(new RegExp(r"\p{Nd}*(..)"));
  res.add(new RegExp(r"\p{Nd}*?(..)"));
  res.add(new RegExp(r"\p{Nd}{2}(..)"));
  res.add(new RegExp(r"\p{Nd}{2,3}(..)"));
  res.add(new RegExp(r"\p{Nd}{2,3}?(..)"));
  res.add(new RegExp(r"\p{Nd}?(..)"));
  res.add(new RegExp(r"\p{Nd}??(..)"));
  res.add(new RegExp(r"\p{Lu}", caseSensitive: false));
  res.add(new RegExp(r"\p{^Lu}", caseSensitive: false));
  res.add(new RegExp(r"\P{Lu}", caseSensitive: false));
  res.add(new RegExp(r"[\p{Nd}]"));
  res.add(new RegExp(r"[\P{Nd}]+"));
  res.add(new RegExp(r"\D+"));
  res.add(new RegExp(r"[\D]+"));
  res.add(new RegExp(r"[\P{Nd}]+"));
  res.add(new RegExp(r"[\D\P{Nd}]+"));
  res.add(new RegExp(r"\pL"));
  res.add(new RegExp(r"\pL", caseSensitive: false));
  res.add(new RegExp(r"\p{Lu}"));
  res.add(new RegExp(r"\p{Lu}", caseSensitive: false));
  res.add(new RegExp(r"\p{Ll}"));
  res.add(new RegExp(r"\p{Ll}", caseSensitive: false));
  res.add(new RegExp(r"^\X"));
  res.add(new RegExp(r"^[\X]"));
  res.add(new RegExp(r"^(\X*)C"));
  res.add(new RegExp(r"^(\X*?)C"));
  res.add(new RegExp(r"^(\X*)(.)"));
  res.add(new RegExp(r"^(\X*?)(.)"));
  res.add(new RegExp(r"^\X(.)"));
  res.add(new RegExp(r"^\X{2,3}(.)"));
  res.add(new RegExp(r"^\X{2,3}?(.)"));
  res.add(new RegExp(r"^\pN{2,3}X"));
  res.add(new RegExp(r"^[\p{Arabic}]"));
  res.add(new RegExp(r"^[\P{Yi}]"));
  res.add(new RegExp(r"^\p{Any}X"));
  res.add(new RegExp(r"^\P{Any}X"));
  res.add(new RegExp(r"^\p{Any}?X"));
  res.add(new RegExp(r"^\P{Any}?X"));
  res.add(new RegExp(r"^\p{Any}*X"));
  res.add(new RegExp(r"^\P{Any}*X"));
  res.add(new RegExp(r"^[\p{Any}]X"));
  res.add(new RegExp(r"^[\P{Any}]X"));
  res.add(new RegExp(r"^[\p{Any}]?X"));
  res.add(new RegExp(r"^[\P{Any}]?X"));
  res.add(new RegExp(r"^[\p{Any}]+X"));
  res.add(new RegExp(r"^[\P{Any}]+X"));
  res.add(new RegExp(r"^[\p{Any}]*X"));
  res.add(new RegExp(r"^[\P{Any}]*X"));
  res.add(new RegExp(r"^\p{Any}{3,5}?"));
  res.add(new RegExp(r"^\p{Any}{3,5}"));
  res.add(new RegExp(r"^\P{Any}{3,5}?"));
  res.add(new RegExp(r"^\p{L&}X"));
  res.add(new RegExp(r"^[\p{L&}]X"));
  res.add(new RegExp(r"^[\p{L&}]+X"));
  res.add(new RegExp(r"^[\p{L&}]+?X"));
  res.add(new RegExp(r"^\P{L&}X"));
  res.add(new RegExp(r"^[\P{L&}]X"));
  res.add(new RegExp(r"Check property support in non-UTF-8 mode"));
  res.add(new RegExp(r"\p{L}{4}"));
  res.add(new RegExp(r"\p{Carian}\p{Cham}\p{Kayah_Li}\p{Lepcha}\p{Lycian}\p{Lydian}\p{Ol_Chiki}\p{Rejang}\p{Saurashtra}\p{Sundanese}\p{Vai}"));
  res.add(new RegExp(r" End "));
  res.add(new RegExp(r"^[[:alnum:]]", multiLine: true));
  res.add(new RegExp(r"a", multiLine: true, caseSensitive: false));
  res.add(new RegExp(r"abcde", multiLine: true));
  res.add(new RegExp(r"\x80", multiLine: true));
  res.add(new RegExp(r"\xff", multiLine: true));
  res.add(new RegExp(r"[\p{L}]", multiLine: true));
  res.add(new RegExp(r"[\p{^L}]", multiLine: true));
  res.add(new RegExp(r"[\P{L}]", multiLine: true));
  res.add(new RegExp(r"[\P{^L}]", multiLine: true));
  res.add(new RegExp(r"[\p{Nd}]", multiLine: true));
  res.add(new RegExp(r"[a]", multiLine: true));
  res.add(new RegExp(r"[a]", multiLine: true));
  res.add(new RegExp(r"[\xaa]", multiLine: true));
  res.add(new RegExp(r"[\xaa]", multiLine: true));
  res.add(new RegExp(r"[^a]", multiLine: true));
  res.add(new RegExp(r"[^a]", multiLine: true));
  res.add(new RegExp(r"[^\xaa]", multiLine: true));
  res.add(new RegExp(r"[^\xaa]", multiLine: true));
  res.add(new RegExp(r" End of testinput10 "));
  assertToStringEquals("abc", res[1].firstMatch("abc"), 0);
  assertToStringEquals("abc", res[1].firstMatch("defabc"), 1);
  assertToStringEquals("abc", res[1].firstMatch("Aabc"), 2);
  assertNull(res[1].firstMatch("*** Failers"), 3);
  assertToStringEquals("abc", res[1].firstMatch("Adefabc"), 4);
  assertToStringEquals("ABC", res[1].firstMatch("ABC"), 5);
  assertToStringEquals("abc", res[2].firstMatch("abc"), 6);
  assertNull(res[2].firstMatch("Aabc"), 7);
  assertNull(res[2].firstMatch("*** Failers"), 8);
  assertNull(res[2].firstMatch("defabc"), 9);
  assertNull(res[2].firstMatch("Adefabc"), 10);
  assertToStringEquals("abc", res[7].firstMatch("abc"), 11);
  assertNull(res[7].firstMatch("*** Failers"), 12);
  assertNull(res[7].firstMatch("def\nabc"), 13);
  assertThrows(() => new RegExp(r"x{5,4}"));
  assertThrows(() => new RegExp(r"[abcd"));
  assertThrows(() => new RegExp(r"[z-a]"));
  assertThrows(() => new RegExp(r"^*"));
  assertThrows(() => new RegExp(r"(abc"));
  assertThrows(() => new RegExp(r"(?# abc"));
  assertToStringEquals("cat", res[11].firstMatch("this sentence eventually mentions a cat"), 20);
  assertToStringEquals("elephant", res[11].firstMatch("this sentences rambles on and on for a while and then reaches elephant"), 21);
  assertToStringEquals("cat", res[12].firstMatch("this sentence eventually mentions a cat"), 22);
  assertToStringEquals("elephant", res[12].firstMatch("this sentences rambles on and on for a while and then reaches elephant"), 23);
  assertToStringEquals("CAT", res[13].firstMatch("this sentence eventually mentions a CAT cat"), 24);
  assertToStringEquals("elephant", res[13].firstMatch("this sentences rambles on and on for a while to elephant ElePhant"), 25);
  assertThrows(() => new RegExp(r"{4,5}abc"));
  assertToStringEquals("abcb,a,b,c", res[18].firstMatch("abcb"), 27);
  assertToStringEquals("abcb,a,b,c", res[18].firstMatch("O0abcb"), 28);
  assertToStringEquals("abcb,a,b,c", res[18].firstMatch("O3abcb"), 29);
  assertToStringEquals("abcb,a,b,c", res[18].firstMatch("O6abcb"), 30);
  assertToStringEquals("abcb,a,b,c", res[18].firstMatch("O9abcb"), 31);
  assertToStringEquals("abcb,a,b,c", res[18].firstMatch("O12abcb"), 32);
  assertToStringEquals("abc,a,,", res[19].firstMatch("abc"), 33);
  assertToStringEquals("abc,a,,", res[19].firstMatch("O0abc"), 34);
  assertToStringEquals("abc,a,,", res[19].firstMatch("O3abc"), 35);
  assertToStringEquals("abc,a,,", res[19].firstMatch("O6abc"), 36);
  assertToStringEquals("aba,,a,b", res[19].firstMatch("aba"), 37);
  assertToStringEquals("aba,,a,b", res[19].firstMatch("O0aba"), 38);
  assertToStringEquals("aba,,a,b", res[19].firstMatch("O3aba"), 39);
  assertToStringEquals("aba,,a,b", res[19].firstMatch("O6aba"), 40);
  assertToStringEquals("aba,,a,b", res[19].firstMatch("O9aba"), 41);
  assertToStringEquals("aba,,a,b", res[19].firstMatch("O12aba"), 42);
  assertToStringEquals("abc", res[20].firstMatch("abc"), 43);
  assertNull(res[20].firstMatch("*** Failers"), 44);
  assertNull(res[20].firstMatch("abc\n"), 45);
  assertNull(res[20].firstMatch("abc\ndef"), 46);
  assertToStringEquals("the quick brown fox", res[22].firstMatch("the quick brown fox"), 47);
  assertToStringEquals("the quick brown fox", res[22].firstMatch("this is a line with the quick brown fox"), 48);
  assertToStringEquals("abc", res[23].firstMatch("abcdef"), 49);
  assertToStringEquals("abc", res[23].firstMatch("abcdefB"), 50);
  assertToStringEquals("defabc,abc,abc,", res[24].firstMatch("defabc"), 51);
  assertToStringEquals("Zdefabc,abc,abc,", res[24].firstMatch("Zdefabc"), 52);
  assertToStringEquals("abc", res[25].firstMatch("abc"), 53);
  assertNull(res[25].firstMatch("*** Failers"), 54);
  assertToStringEquals("abc", res[26].firstMatch("abcdef"), 55);
  assertToStringEquals("abc", res[26].firstMatch("abcdefB"), 56);
  assertToStringEquals("defabc,abc,abc,", res[27].firstMatch("defabc"), 57);
  assertToStringEquals("Zdefabc,abc,abc,", res[27].firstMatch("Zdefabc"), 58);
  assertToStringEquals("the quick brown fox", res[28].firstMatch("the quick brown fox"), 59);
  assertNull(res[28].firstMatch("*** Failers"), 60);
  assertToStringEquals("The Quick Brown Fox", res[28].firstMatch("The Quick Brown Fox"), 61);
  assertToStringEquals("the quick brown fox", res[29].firstMatch("the quick brown fox"), 62);
  assertToStringEquals("The Quick Brown Fox", res[29].firstMatch("The Quick Brown Fox"), 63);
  assertNull(res[30].firstMatch("*** Failers"), 64);
  assertNull(res[30].firstMatch("abc\ndef"), 65);
  assertToStringEquals("abc", res[31].firstMatch("abc"), 66);
  assertNull(res[31].firstMatch("abc\n"), 67);
  assertToStringEquals("abc,abc", res[33].firstMatch("abc"), 68);
  assertThrows(() => new RegExp(r")"));
  assertToStringEquals("-pr", res[35].firstMatch("co-processors, and for"), 70);
  assertToStringEquals("<def>ghi<klm>", res[36].firstMatch("abc<def>ghi<klm>nop"), 71);
  assertToStringEquals("<def>", res[37].firstMatch("abc<def>ghi<klm>nop"), 72);
  assertToStringEquals("<def>", res[37].firstMatch("abc<def>ghi<klm>nop"), 73);
  assertNull(res[37].firstMatch("abc========def"), 74);
  assertNull(res[37].firstMatch("foo"), 75);
  assertNull(res[37].firstMatch("catfoo"), 76);
  assertNull(res[37].firstMatch("*** Failers"), 77);
  assertNull(res[37].firstMatch("the barfoo"), 78);
  assertNull(res[37].firstMatch("and cattlefoo"), 79);
  assertToStringEquals("a", res[40].firstMatch("a"), 80);
  assertNull(res[40].firstMatch("a\n"), 81);
  assertNull(res[40].firstMatch("*** Failers"), 82);
  assertToStringEquals("a", res[40].firstMatch("Za"), 83);
  assertNull(res[40].firstMatch("Za\n"), 84);
  assertToStringEquals("a", res[41].firstMatch("a"), 85);
  assertToStringEquals("a", res[41].firstMatch("a\n"), 86);
  assertToStringEquals("a", res[41].firstMatch("Za\n"), 87);
  assertNull(res[41].firstMatch("*** Failers"), 88);
  assertToStringEquals("a", res[41].firstMatch("Za"), 89);
  assertToStringEquals("b", res[44].firstMatch("foo\nbarbar"), 90);
  assertToStringEquals("a", res[44].firstMatch("***Failers"), 91);
  assertToStringEquals("b", res[44].firstMatch("rhubarb"), 92);
  assertToStringEquals("b", res[44].firstMatch("barbell"), 93);
  assertToStringEquals("a", res[44].firstMatch("abc\nbarton"), 94);
  assertToStringEquals("b", res[44].firstMatch("foo\nbarbar"), 95);
  assertToStringEquals("a", res[44].firstMatch("***Failers"), 96);
  assertToStringEquals("b", res[44].firstMatch("rhubarb"), 97);
  assertToStringEquals("b", res[44].firstMatch("barbell"), 98);
  assertToStringEquals("a", res[44].firstMatch("abc\nbarton"), 99);
  assertToStringEquals("a", res[44].firstMatch("abc"), 100);
  assertToStringEquals("a", res[44].firstMatch("def\nabc"), 101);
  assertToStringEquals("a", res[44].firstMatch("*** Failers"), 102);
  assertToStringEquals("a", res[44].firstMatch("defabc"), 103);
  assertNull(res[45].firstMatch("the bullock-cart"), 104);
  assertNull(res[45].firstMatch("a donkey-cart race"), 105);
  assertNull(res[45].firstMatch("*** Failers"), 106);
  assertNull(res[45].firstMatch("cart"), 107);
  assertNull(res[45].firstMatch("horse-and-cart"), 108);
  assertNull(res[45].firstMatch("alphabetabcd"), 109);
  assertNull(res[45].firstMatch("endingxyz"), 110);
  assertNull(res[45].firstMatch("abxyZZ"), 111);
  assertNull(res[45].firstMatch("abXyZZ"), 112);
  assertNull(res[45].firstMatch("ZZZ"), 113);
  assertNull(res[45].firstMatch("zZZ"), 114);
  assertNull(res[45].firstMatch("bZZ"), 115);
  assertNull(res[45].firstMatch("BZZ"), 116);
  assertNull(res[45].firstMatch("*** Failers"), 117);
  assertNull(res[45].firstMatch("ZZ"), 118);
  assertNull(res[45].firstMatch("abXYZZ"), 119);
  assertNull(res[45].firstMatch("zzz"), 120);
  assertNull(res[45].firstMatch("bzz"), 121);
  assertNull(res[45].firstMatch("bar"), 122);
  assertNull(res[45].firstMatch("foobbar"), 123);
  assertNull(res[45].firstMatch("*** Failers"), 124);
  assertNull(res[45].firstMatch("fooabar"), 125);
  assertNull(res[46].firstMatch("*** Failers"), 126);
  assertNull(res[46].firstMatch("a"), 127);
  assertNull(res[48].firstMatch("aaaaaa"), 128);
  assertThrows(() => new RegExp(r"a[b-a]"), 129);
  assertThrows(() => new RegExp(r"a["), 130);
  assertThrows(() => new RegExp(r"*a"), 131);
  assertThrows(() => new RegExp(r"abc)"), 132);
  assertThrows(() => new RegExp(r"(abc"), 133);
  assertThrows(() => new RegExp(r"a**"), 134);
  assertThrows(() => new RegExp(r")("), 135);
  assertThrows(() => new RegExp(r"a[b-a]"), 136);
  assertThrows(() => new RegExp(r"a["), 137);
  assertThrows(() => new RegExp(r"*a"), 138);
  assertThrows(() => new RegExp(r"abc)"), 139);
  assertThrows(() => new RegExp(r"(abc"), 140);
  assertThrows(() => new RegExp(r"a**"), 141);
  assertThrows(() => new RegExp(r")("), 142);
  assertThrows(() => new RegExp(r":(?:"), 143);
  assertThrows(() => new RegExp(r"a(?{)b"), 144);
  assertThrows(() => new RegExp(r"a(?{{})b"), 145);
  assertThrows(() => new RegExp(r"a(?{}})b"), 146);
  assertThrows(() => new RegExp(r'a(?{\"{\"})b'), 147);
  assertThrows(() => new RegExp(r'a(?{\"{\"}})b'), 148);
  assertThrows(() => new RegExp(r"[a[:xyz:"), 149);
  assertThrows(() => new RegExp(r"a{37,17}"), 150);
  assertToStringEquals("abcd,a,d", res[58].firstMatch("abcd"), 151);
  assertToStringEquals("abcd,a,d", res[58].firstMatch("abcdC2"), 152);
  assertToStringEquals("abcd,a,d", res[58].firstMatch("abcdC5"), 153);
  assertToStringEquals("abcdefghijklmnopqrst,abcdefghijklmnopqrst", res[59].firstMatch("abcdefghijklmnopqrstuvwxyz"), 154);
  assertToStringEquals("abcdefghijklmnopqrst,abcdefghijklmnopqrst", res[59].firstMatch("abcdefghijklmnopqrstuvwxyzC1"), 155);
  assertToStringEquals("abcdefghijklmnopqrst,abcdefghijklmnopqrst", res[59].firstMatch("abcdefghijklmnopqrstuvwxyzG1"), 156);
  assertToStringEquals("abcdefghijklmno,abcdefghijklmno", res[60].firstMatch("abcdefghijklmnopqrstuvwxyz"), 157);
  assertToStringEquals("abcdefghijklmno,abcdefghijklmno", res[60].firstMatch("abcdefghijklmnopqrstuvwxyzC1G1"), 158);
  assertToStringEquals("abcdefghijklmnop,abcdefghijklmnop", res[61].firstMatch("abcdefghijklmnopqrstuvwxyz"), 159);
  assertToStringEquals("abcdefghijklmnop,abcdefghijklmnop", res[61].firstMatch("abcdefghijklmnopqrstuvwxyzC1G1L"), 160);
  assertToStringEquals("adef,a,,f", res[62].firstMatch("adefG1G2G3G4L"), 161);
  assertToStringEquals("bcdef,bc,bc,f", res[62].firstMatch("bcdefG1G2G3G4L"), 162);
  assertToStringEquals("adef,a,,f", res[62].firstMatch("adefghijkC0"), 163);
  assertToStringEquals("abc\x00def", res[63].firstMatch("abc\x00defLC0"), 164);
  assertToStringEquals("iss", res[69].firstMatch("Mississippi"), 165);
  assertToStringEquals("iss", res[70].firstMatch("Mississippi"), 166);
  assertToStringEquals("iss", res[71].firstMatch("Mississippi"), 167);
  assertToStringEquals("iss", res[72].firstMatch("Mississippi"), 168);
  assertToStringEquals("iss", res[73].firstMatch("Mississippi"), 169);
  assertNull(res[73].firstMatch("*** Failers"), 170);
  assertToStringEquals("iss", res[73].firstMatch("MississippiA"), 171);
  assertToStringEquals("iss", res[73].firstMatch("Mississippi"), 172);
  assertToStringEquals("iss", res[74].firstMatch("ississippi"), 174);
  assertToStringEquals("abciss", res[75].firstMatch("abciss\nxyzisspqr"), 175);
  assertToStringEquals("Mis", res[76].firstMatch("Mississippi"), 176);
  assertToStringEquals("Mis", res[77].firstMatch("Mississippi"), 180);
  assertToStringEquals("ab\n", res[78].firstMatch("ab\nab\ncd"), 181);
  assertToStringEquals("ab\n", res[79].firstMatch("ab\nab\ncd"), 182);
  assertToStringEquals("a", res[115].firstMatch("a"), 183);
  assertToStringEquals("b", res[115].firstMatch("b"), 184);
  assertToStringEquals("ab", res[115].firstMatch("ab"), 185);
  assertToStringEquals("", res[115].firstMatch("\\"), 186);
  assertToStringEquals("", res[115].firstMatch("*** Failers"), 187);
  assertToStringEquals("", res[115].firstMatch("N"), 188);
  assertToStringEquals("", res[116].firstMatch("abcd"), 189);
  assertToStringEquals("", res[116].firstMatch("-abc"), 190);
  assertToStringEquals("", res[116].firstMatch("Nab-c"), 191);
  assertToStringEquals("", res[116].firstMatch("*** Failers"), 192);
  assertToStringEquals("", res[116].firstMatch("Nabc"), 193);
  assertToStringEquals("aaaabbbbzz,bbbb,z,z", res[117].firstMatch("aaaabbbbzzzz"), 194);
  assertToStringEquals("aaaabbbbzz,bbbb,z,z", res[117].firstMatch("aaaabbbbzzzzO0"), 195);
  assertToStringEquals("aaaabbbbzz,bbbb,z,z", res[117].firstMatch("aaaabbbbzzzzO1"), 196);
  assertToStringEquals("aaaabbbbzz,bbbb,z,z", res[117].firstMatch("aaaabbbbzzzzO2"), 197);
  assertToStringEquals("aaaabbbbzz,bbbb,z,z", res[117].firstMatch("aaaabbbbzzzzO3"), 198);
  assertToStringEquals("aaaabbbbzz,bbbb,z,z", res[117].firstMatch("aaaabbbbzzzzO4"), 199);
  assertToStringEquals("aaaabbbbzz,bbbb,z,z", res[117].firstMatch("aaaabbbbzzzzO5"), 200);
  assertToStringEquals("(abcd", res[118].firstMatch("(abcd)"), 201);
  assertToStringEquals("(abcd", res[118].firstMatch("(abcd)xyz"), 202);
  assertNull(res[118].firstMatch("xyz(abcd)"), 203);
  assertNull(res[118].firstMatch("(ab(xy)cd)pqr"), 204);
  assertNull(res[118].firstMatch("(ab(xycd)pqr"), 205);
  assertNull(res[118].firstMatch("() abc ()"), 206);
  assertNull(res[118].firstMatch("12(abcde(fsh)xyz(foo(bar))lmno)89"), 207);
  assertNull(res[118].firstMatch("*** Failers"), 208);
  assertToStringEquals("abcd", res[118].firstMatch("abcd"), 209);
  assertToStringEquals("abcd", res[118].firstMatch("abcd)"), 210);
  assertToStringEquals("(abcd", res[118].firstMatch("(abcd"), 211);
  assertNull(res[118].firstMatch("(ab(xy)cd)pqr"), 212);
  assertNull(res[118].firstMatch("1(abcd)(x(y)z)pqr"), 213);
  assertToStringEquals("(abcd", res[118].firstMatch("(abcd)"), 214);
  assertNull(res[118].firstMatch("(ab(xy)cd)"), 215);
  assertNull(res[118].firstMatch("(a(b(c)d)e)"), 216);
  assertNull(res[118].firstMatch("((ab))"), 217);
  assertNull(res[118].firstMatch("*** Failers"), 218);
  assertNull(res[118].firstMatch("()"), 219);
  assertNull(res[118].firstMatch("()"), 220);
  assertNull(res[118].firstMatch("12(abcde(fsh)xyz(foo(bar))lmno)89"), 221);
  assertNull(res[118].firstMatch("(ab(xy)cd)"), 222);
  assertNull(res[118].firstMatch("(ab(xy)cd)"), 223);
  assertNull(res[118].firstMatch("(ab(xy)cd)"), 224);
  assertNull(res[118].firstMatch("(123ab(xy)cd)"), 225);
  assertNull(res[118].firstMatch("(ab(xy)cd)"), 226);
  assertNull(res[118].firstMatch("(123ab(xy)cd)"), 227);
  assertNull(res[118].firstMatch("(ab(xy)cd)"), 228);
  assertToStringEquals("(abcd", res[118].firstMatch("(abcd(xyz<p>qrs)123)"), 229);
  assertNull(res[118].firstMatch("(ab(cd)ef)"), 230);
  assertNull(res[118].firstMatch("(ab(cd(ef)gh)ij)"), 231);
  assertNull(res[146].firstMatch("A"), 232);
  assertNull(res[146].firstMatch("a"), 233);
  assertNull(res[147].firstMatch("A"), 234);
  assertNull(res[147].firstMatch("a"), 235);
  assertNull(res[147].firstMatch("ab"), 236);
  assertNull(res[147].firstMatch("aB"), 237);
  assertNull(res[147].firstMatch("*** Failers"), 238);
  assertNull(res[147].firstMatch("Ab"), 239);
  assertNull(res[147].firstMatch("AB"), 240);
  assertThrows(() => new RegExp(r"[\200-\110]"), 241);
  // TODO(jgruber): Reintegrate stack-overflow2_test.dart once it passes.
  assertToStringEquals("mainmain,main,", res[151].firstMatch("mainmain"), 243);
  assertToStringEquals("mainOmain,main,", res[151].firstMatch("mainOmain"), 244);
  assertToStringEquals("aba,a,", res[153].firstMatch("aba"), 245);
  assertToStringEquals("aabbaa,aa,", res[154].firstMatch("aabbaa"), 246);
  assertToStringEquals("aabbaa,aa,", res[155].firstMatch("aabbaa"), 247);
  assertToStringEquals("aabbaa,aa,", res[156].firstMatch("aabbaa"), 248);
  assertToStringEquals("aabbaa,", res[157].firstMatch("aabbaa"), 249);
  assertToStringEquals("aabbaa,aa,,", res[158].firstMatch("aabbaa"), 250);
  assertToStringEquals("aabbaa,,", res[159].firstMatch("aabbaa"), 251);
  assertToStringEquals("aabbaa,", res[160].firstMatch("aabbaa"), 252);
  assertToStringEquals("aabbbaa,", res[161].firstMatch("aabbbaa"), 253);
  assertToStringEquals("aabbbaa,", res[162].firstMatch("aabbbaa"), 254);
  assertToStringEquals("aabbaa,", res[163].firstMatch("aabbaa"), 255);
  assertToStringEquals("aabbbaa,", res[164].firstMatch("aabbbaa"), 256);
  assertToStringEquals("aabbbaa,aa,,", res[165].firstMatch("aabbbaa"), 257);
  assertToStringEquals("aabbbbaa,aa,,", res[166].firstMatch("aabbbbaa"), 258);
  // Dart does not have RegExp literals and thus no translatation of the below.
  // assertThrows("var re = //;", 259);
  assertToStringEquals("a", res[169].firstMatch("ab"), 260);
  assertToStringEquals("a", res[169].firstMatch("aB"), 261);
  assertToStringEquals("*", res[169].firstMatch("*** Failers"), 262);
  assertToStringEquals("A", res[169].firstMatch("AB"), 263);
  assertToStringEquals("a", res[169].firstMatch("ab"), 264);
  assertToStringEquals("a", res[169].firstMatch("aB"), 265);
  assertToStringEquals("*", res[169].firstMatch("*** Failers"), 266);
  assertToStringEquals("A", res[169].firstMatch("AB"), 267);
  assertNull(res[172].firstMatch("\\"), 268);
  assertNull(res[177].firstMatch("*** Failers"), 269);
  assertNull(res[177].firstMatch("xxxxx"), 270);
  assertNull(res[177].firstMatch("now is the time for all good men to come to the aid of the party"), 271);
  assertNull(res[177].firstMatch("*** Failers"), 272);
  assertNull(res[177].firstMatch("this is not a line with only words and spaces!"), 273);
  assertNull(res[177].firstMatch("12345a"), 274);
  assertNull(res[177].firstMatch("*** Failers"), 275);
  assertNull(res[177].firstMatch("12345+"), 276);
  assertNull(res[177].firstMatch("aaab"), 277);
  assertNull(res[177].firstMatch("aaab"), 278);
  assertNull(res[177].firstMatch("aaab"), 279);
  assertNull(res[177].firstMatch("((abc(ade)ufh()()x"), 280);
  assertNull(res[177].firstMatch("(abc)"), 281);
  assertNull(res[177].firstMatch("(abc(def)xyz)"), 282);
  assertNull(res[177].firstMatch("*** Failers"), 283);
  assertNull(res[177].firstMatch("((()aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"), 284);
  assertNull(res[177].firstMatch("xaaaab"), 285);
  assertNull(res[177].firstMatch("xaaaab"), 286);
  assertThrows(() => new RegExp(r"["), 287);
  assertThrows(() => new RegExp(r"[a-"), 288);
  assertNull(res[189].firstMatch("<>"), 289);
  assertNull(res[189].firstMatch("<abcd>"), 290);
  assertNull(res[189].firstMatch("<abc <123> hij>"), 291);
  assertNull(res[189].firstMatch("<abc <def> hij>"), 292);
  assertNull(res[189].firstMatch("<abc<>def>"), 293);
  assertNull(res[189].firstMatch("<abc<>"), 294);
  assertNull(res[189].firstMatch("*** Failers"), 295);
  assertNull(res[189].firstMatch("<abc"), 296);
  assertToStringEquals("bc123bc,bc,bc", res[195].firstMatch("abc123bc"), 297);
  assertToStringEquals("abc", res[215].firstMatch("abcdef"), 298);
  assertToStringEquals("abc", res[215].firstMatch("1234abcdef"), 299);
  assertNull(res[215].firstMatch("*** Failers"), 300);
  assertToStringEquals("abc", res[215].firstMatch("abcxyz"), 301);
  assertToStringEquals("abc", res[215].firstMatch("abcxyzf"), 302);
  assertToStringEquals("abc", res[215].firstMatch("123abcdef"), 303);
  assertToStringEquals("abc", res[215].firstMatch("1234abcdef"), 304);
  assertNull(res[215].firstMatch("*** Failers"), 305);
  assertToStringEquals("abc", res[215].firstMatch("abcdef"), 306);
  assertNull(res[215].firstMatch("*** Failers"), 307);
  assertToStringEquals("abc", res[215].firstMatch("\x83x0abcdef"), 308);
  assertToStringEquals("abc", res[215].firstMatch("123abcdef"), 309);
  assertToStringEquals("abc", res[215].firstMatch("123abcdefC+"), 310);
  assertToStringEquals("abc", res[215].firstMatch("123abcdefC-"), 311);
  assertNull(res[215].firstMatch("*** Failers"), 312);
  assertToStringEquals("abc", res[215].firstMatch("123abcdefC!1"), 313);
  assertToStringEquals("abc", res[215].firstMatch("abcabcabc"), 314);
  assertToStringEquals("abc", res[215].firstMatch("abcabcC!1!3"), 315);
  assertNull(res[215].firstMatch("*** Failers"), 316);
  assertToStringEquals("abc", res[215].firstMatch("abcabcabcC!1!3"), 317);
  assertToStringEquals("C", res[215].firstMatch("123C+"), 318);
  assertToStringEquals("C", res[215].firstMatch("123456C+"), 319);
  assertToStringEquals("C", res[215].firstMatch("123456789C+"), 320);
  assertToStringEquals("abc", res[215].firstMatch("xyzabcC+"), 321);
  assertToStringEquals("abc", res[215].firstMatch("XxyzabcC+"), 322);
  assertToStringEquals("abc", res[215].firstMatch("abcdefC+"), 323);
  assertToStringEquals("abc", res[215].firstMatch("abcxyzC+"), 324);
  assertToStringEquals("c", res[215].firstMatch("abbbbbcccC*1"), 325);
  assertToStringEquals("c", res[215].firstMatch("abbbbbcccC*1"), 326);
  assertNull(res[215].firstMatch("xab"), 327);
  assertToStringEquals("c", res[215].firstMatch("xbc"), 328);
  assertNull(res[215].firstMatch("xde"), 329);
  assertNull(res[215].firstMatch("xxab"), 330);
  assertNull(res[215].firstMatch("xxxab"), 331);
  assertNull(res[215].firstMatch("*** Failers"), 332);
  assertNull(res[215].firstMatch("xyab"), 333);
  assertToStringEquals("abc", res[215].firstMatch("abc"), 334);
  assertToStringEquals("c", res[215].firstMatch("a(b)c"), 335);
  assertToStringEquals("c", res[215].firstMatch("a(b(c))d"), 336);
  assertNull(res[215].firstMatch("*** Failers)"), 337);
  assertToStringEquals("c", res[215].firstMatch("a(b(c)d"), 338);
  assertNull(res[215].firstMatch("1221"), 339);
  assertToStringEquals("c", res[215].firstMatch("Satan, oscillate my metallic sonatas!"), 340);
  assertToStringEquals("c", res[215].firstMatch("A man, a plan, a canal: Panama!"), 341);
  assertNull(res[215].firstMatch("Able was I ere I saw Elba."), 342);
  assertNull(res[215].firstMatch("*** Failers"), 343);
  assertToStringEquals("c", res[215].firstMatch("The quick brown fox"), 344);
  assertNull(res[215].firstMatch("12"), 345);
  assertNull(res[215].firstMatch("(((2+2)*-3)-7)"), 346);
  assertNull(res[215].firstMatch("-12"), 347);
  assertNull(res[215].firstMatch("*** Failers"), 348);
  assertNull(res[215].firstMatch("((2+2)*-3)-7)"), 349);
  assertNull(res[215].firstMatch("xyz"), 350);
  assertNull(res[215].firstMatch("xxyzxyzz"), 351);
  assertNull(res[215].firstMatch("*** Failers"), 352);
  assertNull(res[215].firstMatch("xxyzz"), 353);
  assertNull(res[215].firstMatch("xxyzxyzxyzz"), 354);
  assertNull(res[215].firstMatch("<>"), 355);
  assertToStringEquals("abc", res[215].firstMatch("<abcd>"), 356);
  assertToStringEquals("abc", res[215].firstMatch("<abc <123> hij>"), 357);
  assertToStringEquals("abc", res[215].firstMatch("<abc <def> hij>"), 358);
  assertToStringEquals("abc", res[215].firstMatch("<abc<>def>"), 359);
  assertToStringEquals("abc", res[215].firstMatch("<abc<>"), 360);
  assertNull(res[215].firstMatch("*** Failers"), 361);
  assertToStringEquals("abc", res[215].firstMatch("<abc"), 362);
  assertToStringEquals("abc", res[215].firstMatch("abcdefabc"), 363);
  assertNull(res[215].firstMatch("a=a"), 364);
  assertNull(res[215].firstMatch("a=b"), 365);
  assertToStringEquals("c", res[215].firstMatch("a=bc"), 366);
  assertNull(res[215].firstMatch("a=a"), 367);
  assertNull(res[215].firstMatch("a=b"), 368);
  assertToStringEquals("c", res[215].firstMatch("a=bc"), 369);
  assertNull(res[215].firstMatch("abde"), 370);
  assertToStringEquals("c", res[215].firstMatch("acde"), 371);
  assertNull(res[215].firstMatch("1221"), 372);
  assertToStringEquals("c", res[215].firstMatch("Satan, oscillate my metallic sonatas!"), 373);
  assertToStringEquals("c", res[215].firstMatch("A man, a plan, a canal: Panama!"), 374);
  assertNull(res[215].firstMatch("Able was I ere I saw Elba."), 375);
  assertNull(res[215].firstMatch("*** Failers"), 376);
  assertToStringEquals("c", res[215].firstMatch("The quick brown fox"), 377);
  assertNull(res[228].firstMatch("abcdefgh"), 378);
  assertNull(res[228].firstMatch("abcdefghC1Gtwo"), 379);
  assertNull(res[228].firstMatch("abcdefghConeCtwo"), 380);
  assertNull(res[228].firstMatch("abcdefghCthree"), 381);
  assertToStringEquals("zz,", res[228].firstMatch("zzaaCZ"), 382);
  assertToStringEquals("zz,", res[228].firstMatch("zzaaCA"), 383);
  assertNull(res[228].firstMatch("[10,20,30,5,5,4,4,2,43,23,4234]"), 384);
  assertNull(res[228].firstMatch("*** Failers"), 385);
  assertNull(res[228].firstMatch("[]"), 386);
  assertNull(res[228].firstMatch("[10,20,30,5,5,4,4,2,43,23,4234]"), 387);
  assertNull(res[228].firstMatch("[]"), 388);
  assertToStringEquals(" Baby Bjorn Active Carrier - With free SHIPPING!!, Baby Bjorn Active Carrier - With free SHIPPING!!,,", res[229].firstMatch(" Baby Bjorn Active Carrier - With free SHIPPING!!"), 389);
  assertToStringEquals(" Baby Bjorn Active Carrier - With free SHIPPING!!, Baby Bjorn Active Carrier - With free SHIPPING!!,,", res[230].firstMatch(" Baby Bjorn Active Carrier - With free SHIPPING!!"), 390);
  assertNull(res[238].firstMatch("Note: that { does NOT introduce a quantifier"), 391);
  assertToStringEquals("aacaacaacaacaac123,aac", res[239].firstMatch("aacaacaacaacaac123"), 392);
  assertNull(res[243].firstMatch("abP"), 393);
  assertNull(res[243].firstMatch("abcP"), 394);
  assertNull(res[243].firstMatch("abcdP"), 395);
  assertToStringEquals("abcde", res[243].firstMatch("abcdeP"), 396);
  assertNull(res[243].firstMatch("the quick brown abcP"), 397);
  assertNull(res[243].firstMatch("** FailersP"), 398);
  assertNull(res[243].firstMatch("the quick brown abxyz foxP"), 399);
  assertNull(res[243].firstMatch("13/05/04P"), 400);
  assertNull(res[243].firstMatch("13/5/2004P"), 401);
  assertNull(res[243].firstMatch("02/05/09P"), 402);
  assertNull(res[243].firstMatch("1P"), 403);
  assertNull(res[243].firstMatch("1/2P"), 404);
  assertNull(res[243].firstMatch("1/2/0P"), 405);
  assertNull(res[243].firstMatch("1/2/04P"), 406);
  assertNull(res[243].firstMatch("0P"), 407);
  assertNull(res[243].firstMatch("02/P"), 408);
  assertNull(res[243].firstMatch("02/0P"), 409);
  assertNull(res[243].firstMatch("02/1P"), 410);
  assertNull(res[243].firstMatch("** FailersP"), 411);
  assertNull(res[243].firstMatch("P"), 412);
  assertNull(res[243].firstMatch("123P"), 413);
  assertNull(res[243].firstMatch("33/4/04P"), 414);
  assertNull(res[243].firstMatch("3/13/04P"), 415);
  assertNull(res[243].firstMatch("0/1/2003P"), 416);
  assertNull(res[243].firstMatch("0/P"), 417);
  assertNull(res[243].firstMatch("02/0/P"), 418);
  assertNull(res[243].firstMatch("02/13P"), 419);
  assertToStringEquals("123", res[248].firstMatch("123P"), 420);
  assertNull(res[248].firstMatch("aP"), 421);
  assertNull(res[248].firstMatch("bP"), 422);
  assertNull(res[248].firstMatch("cP"), 423);
  assertNull(res[248].firstMatch("c12P"), 424);
  assertToStringEquals("c123", res[248].firstMatch("c123P"), 425);
  assertNull(res[249].firstMatch("1P"), 426);
  assertNull(res[249].firstMatch("123P"), 427);
  assertToStringEquals("123X", res[249].firstMatch("123X"), 428);
  assertNull(res[249].firstMatch("1234P"), 429);
  assertToStringEquals("1234X", res[249].firstMatch("1234X"), 430);
  assertNull(res[249].firstMatch("12345P"), 431);
  assertToStringEquals("12345X", res[249].firstMatch("12345X"), 432);
  assertNull(res[249].firstMatch("*** Failers"), 433);
  assertNull(res[249].firstMatch("1X"), 434);
  assertNull(res[249].firstMatch("123456P"), 435);
  assertNull(res[249].firstMatch("abc"), 436);
  assertNull(res[249].firstMatch("** Failers"), 437);
  assertNull(res[249].firstMatch("bca"), 438);
  assertNull(res[249].firstMatch("abc"), 439);
  assertNull(res[249].firstMatch("** Failers"), 440);
  assertNull(res[249].firstMatch("bca"), 441);
  assertNull(res[249].firstMatch("abc"), 442);
  assertNull(res[249].firstMatch("** Failers"), 443);
  assertNull(res[249].firstMatch("def"), 444);
  assertNull(res[249].firstMatch("abc"), 445);
  assertNull(res[249].firstMatch("** Failers"), 446);
  assertNull(res[249].firstMatch("def"), 447);
  assertNull(res[249].firstMatch("<!DOCTYPE seite SYSTEM \"http://www.lco.lineas.de/xmlCms.dtd\">\n<seite>\n<dokumenteninformation>\n<seitentitel>Partner der LCO</seitentitel>\n<sprache>de</sprache>\n<seitenbeschreibung>Partner der LINEAS Consulting\nGmbH</seitenbeschreibung>\n<schluesselworte>LINEAS Consulting GmbH Hamburg\nPartnerfirmen</schluesselworte>\n<revisit>30 days</revisit>\n<robots>index,follow</robots>\n<menueinformation>\n<aktiv>ja</aktiv>\n<menueposition>3</menueposition>\n<menuetext>Partner</menuetext>\n</menueinformation>\n<lastedited>\n<autor>LCO</autor>\n<firma>LINEAS Consulting</firma>\n<datum>15.10.2003</datum>\n</lastedited>\n</dokumenteninformation>\n<inhalt>\n\n<absatzueberschrift>Die Partnerfirmen der LINEAS Consulting\nGmbH</absatzueberschrift>\n\n<absatz><link ziel=\"http://www.ca.com/\" zielfenster=\"_blank\">\n<bild name=\"logo_ca.gif\" rahmen=\"no\"/></link> <link\nziel=\"http://www.ey.com/\" zielfenster=\"_blank\"><bild\nname=\"logo_euy.gif\" rahmen=\"no\"/></link>\n</absatz>\n\n<absatz><link ziel=\"http://www.cisco.de/\" zielfenster=\"_blank\">\n<bild name=\"logo_cisco.gif\" rahmen=\"ja\"/></link></absatz>\n\n<absatz><link ziel=\"http://www.atelion.de/\"\nzielfenster=\"_blank\"><bild\nname=\"logo_atelion.gif\" rahmen=\"no\"/></link>\n</absatz>\n\n<absatz><link ziel=\"http://www.line-information.de/\"\nzielfenster=\"_blank\">\n<bild name=\"logo_line_information.gif\" rahmen=\"no\"/></link>\n</absatz>\n\n<absatz><bild name=\"logo_aw.gif\" rahmen=\"no\"/></absatz>\n\n<absatz><link ziel=\"http://www.incognis.de/\"\nzielfenster=\"_blank\"><bild\nname=\"logo_incognis.gif\" rahmen=\"no\"/></link></absatz>\n\n<absatz><link ziel=\"http://www.addcraft.com/\"\nzielfenster=\"_blank\"><bild\nname=\"logo_addcraft.gif\" rahmen=\"no\"/></link></absatz>\n\n<absatz><link ziel=\"http://www.comendo.com/\"\nzielfenster=\"_blank\"><bild\nname=\"logo_comendo.gif\" rahmen=\"no\"/></link></absatz>\n\n</inhalt>\n</seite>"), 448);
  assertToStringEquals("line\nbreak", res[251].firstMatch("this is a line\nbreak"), 449);
  assertToStringEquals("line\nbreak", res[251].firstMatch("line one\nthis is a line\nbreak in the second line"), 450);
  assertToStringEquals("line\nbreak", res[252].firstMatch("this is a line\nbreak"), 451);
  assertNull(res[252].firstMatch("** Failers"), 452);
  assertToStringEquals("line\nbreak", res[252].firstMatch("line one\nthis is a line\nbreak in the second line"), 453);
  assertToStringEquals("line\nbreak", res[253].firstMatch("this is a line\nbreak"), 454);
  assertNull(res[253].firstMatch("** Failers"), 455);
  assertToStringEquals("line\nbreak", res[253].firstMatch("line one\nthis is a line\nbreak in the second line"), 456);
  assertToStringEquals("ab-cd", res[254].firstMatch("ab-cd"), 457);
  assertToStringEquals("ab=cd", res[254].firstMatch("ab=cd"), 458);
  assertNull(res[254].firstMatch("** Failers"), 459);
  assertNull(res[254].firstMatch("ab\ncd"), 460);
  assertToStringEquals("ab-cd", res[255].firstMatch("ab-cd"), 461);
  assertToStringEquals("ab=cd", res[255].firstMatch("ab=cd"), 462);
  assertNull(res[255].firstMatch("ab\ncd"), 463);
  assertNull(res[255].firstMatch("AbCd"), 464);
  assertNull(res[255].firstMatch("** Failers"), 465);
  assertNull(res[255].firstMatch("abcd"), 466);
  // We are compatible with JSC, and don't throw an exception in this case.
  // assertThrows("var re = /(){2,4294967295}/;", 467);
  assertNull(res[255].firstMatch("abcdefghijklAkB"), 468);
  assertNull(res[255].firstMatch("abcdefghijklAkB"), 469);
  assertNull(res[255].firstMatch("abcdefghijklAkB"), 470);
  assertNull(res[255].firstMatch("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"), 471);
  assertNull(res[255].firstMatch("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"), 472);
  assertNull(res[255].firstMatch("(this(and)that"), 473);
  assertNull(res[255].firstMatch("(this(and)that)"), 474);
  assertNull(res[255].firstMatch("(this(and)that)stuff"), 475);
  assertNull(res[255].firstMatch("(this(and)that"), 476);
  assertNull(res[255].firstMatch("(this(and)that)"), 477);
  assertNull(res[255].firstMatch("(this(and)that"), 478);
  assertNull(res[255].firstMatch("(this(and)that)"), 479);
  assertNull(res[255].firstMatch("(this(and)that"), 480);
  assertNull(res[255].firstMatch("(this(and)that)"), 481);
  assertNull(res[255].firstMatch("((this))"), 482);
  assertNull(res[255].firstMatch("(this(and)that"), 483);
  assertNull(res[255].firstMatch("(this(and)that)"), 484);
  assertNull(res[255].firstMatch("(this)"), 485);
  assertNull(res[255].firstMatch("((this))"), 486);
  assertToStringEquals("abc,b", res[256].firstMatch("abc"), 487);
  assertToStringEquals("abc,b", res[256].firstMatch("abc"), 488);
  assertNull(res[256].firstMatch("a1bCA"), 489);
  assertNull(res[256].firstMatch("a2bCA"), 490);
  assertNull(res[257].firstMatch("a bc dCACBCC"), 491);
  assertNull(res[257].firstMatch("aabc"), 492);
  assertNull(res[257].firstMatch("bc"), 493);
  assertNull(res[257].firstMatch("** Failers"), 494);
  assertNull(res[257].firstMatch("abc"), 495);
  assertNull(res[257].firstMatch("bXaX"), 496);
  assertNull(res[257].firstMatch("bbXaaX"), 497);
  assertNull(res[257].firstMatch("(b)\\Xa\\X"), 498);
  assertNull(res[257].firstMatch("bXXaYYaY"), 499);
  assertNull(res[257].firstMatch("bXYaXXaX"), 500);
  assertNull(res[257].firstMatch("bXXaYYaY"), 501);
  assertToStringEquals("\x0b,\x0b", res[259].firstMatch("\x0b,\x0b"), 502);
  assertToStringEquals("\x0c,\x0d", res[259].firstMatch("\x0c,\x0d"), 503);
  assertToStringEquals("abc", res[260].firstMatch("xyz\nabc"), 504);
  assertToStringEquals("abc", res[260].firstMatch("xyz\nabc<lf>"), 505);
  assertToStringEquals("abc", res[260].firstMatch("xyz\x0d\nabc<lf>"), 506);
  assertToStringEquals("abc", res[260].firstMatch("xyz\x0dabc<cr>"), 507);
  assertToStringEquals("abc", res[260].firstMatch("xyz\x0d\nabc<crlf>"), 508);
  assertNull(res[260].firstMatch("** Failers"), 509);
  assertToStringEquals("abc", res[260].firstMatch("xyz\nabc<cr>"), 510);
  assertToStringEquals("abc", res[260].firstMatch("xyz\x0d\nabc<cr>"), 511);
  assertToStringEquals("abc", res[260].firstMatch("xyz\nabc<crlf>"), 512);
  assertToStringEquals("abc", res[260].firstMatch("xyz\x0dabc<crlf>"), 513);
  assertToStringEquals("abc", res[260].firstMatch("xyz\x0dabc<lf>"), 514);
  assertToStringEquals("abc", res[261].firstMatch("xyzabc"), 515);
  assertToStringEquals("abc", res[261].firstMatch("xyzabc\n"), 516);
  assertToStringEquals("abc", res[261].firstMatch("xyzabc\npqr"), 517);
  assertToStringEquals("abc", res[261].firstMatch("xyzabc\x0d<cr>"), 518);
  assertToStringEquals("abc", res[261].firstMatch("xyzabc\x0dpqr<cr>"), 519);
  assertToStringEquals("abc", res[261].firstMatch("xyzabc\x0d\n<crlf>"), 520);
  assertToStringEquals("abc", res[261].firstMatch("xyzabc\x0d\npqr<crlf>"), 521);
  assertNull(res[261].firstMatch("** Failers"), 522);
  assertToStringEquals("abc", res[261].firstMatch("xyzabc\x0d"), 523);
  assertToStringEquals("abc", res[261].firstMatch("xyzabc\x0dpqr"), 524);
  assertToStringEquals("abc", res[261].firstMatch("xyzabc\x0d\n"), 525);
  assertToStringEquals("abc", res[261].firstMatch("xyzabc\x0d\npqr"), 526);
  assertToStringEquals("abc", res[262].firstMatch("xyz\x0dabcdef"), 527);
  assertToStringEquals("abc", res[262].firstMatch("xyz\nabcdef<lf>"), 528);
  assertNull(res[262].firstMatch("** Failers"), 529);
  assertToStringEquals("abc", res[262].firstMatch("xyz\nabcdef"), 530);
  assertToStringEquals("abc", res[263].firstMatch("xyz\nabcdef"), 531);
  assertToStringEquals("abc", res[263].firstMatch("xyz\x0dabcdef<cr>"), 532);
  assertNull(res[263].firstMatch("** Failers"), 533);
  assertToStringEquals("abc", res[263].firstMatch("xyz\x0dabcdef"), 534);
  assertToStringEquals("abc", res[264].firstMatch("xyz\x0d\nabcdef"), 535);
  assertToStringEquals("abc", res[264].firstMatch("xyz\x0dabcdef<cr>"), 536);
  assertNull(res[264].firstMatch("** Failers"), 537);
  assertToStringEquals("abc", res[264].firstMatch("xyz\x0dabcdef"), 538);
  assertToStringEquals("abc", res[266].firstMatch("xyz\x0dabc<bad>"), 539);
  assertToStringEquals("abc", res[266].firstMatch("abc"), 540);
  assertToStringEquals("abc", res[267].firstMatch("abc\ndef"), 541);
  assertToStringEquals("abc", res[267].firstMatch("abc\x0ddef"), 542);
  assertToStringEquals("abc", res[267].firstMatch("abc\x0d\ndef"), 543);
  assertToStringEquals("<cr>abc", res[267].firstMatch("<cr>abc\ndef"), 544);
  assertToStringEquals("<cr>abc", res[267].firstMatch("<cr>abc\x0ddef"), 545);
  assertToStringEquals("<cr>abc", res[267].firstMatch("<cr>abc\x0d\ndef"), 546);
  assertToStringEquals("<crlf>abc", res[267].firstMatch("<crlf>abc\ndef"), 547);
  assertToStringEquals("<crlf>abc", res[267].firstMatch("<crlf>abc\x0ddef"), 548);
  assertToStringEquals("<crlf>abc", res[267].firstMatch("<crlf>abc\x0d\ndef"), 549);
  assertNull(res[268].firstMatch("abc\ndef"), 550);
  assertNull(res[268].firstMatch("abc\x0ddef"), 551);
  assertNull(res[268].firstMatch("abc\x0d\ndef"), 552);
  assertToStringEquals("XY,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,XY,Y", res[269].firstMatch("XYO400"), 553);
  assertToStringEquals("aaaA5", res[278].firstMatch("aaaA5"), 554);
  assertNull(res[278].firstMatch("** Failers"), 555);
  assertNull(res[278].firstMatch("aaaa5"), 556);
  assertToStringEquals("aaaA5", res[279].firstMatch("aaaA5"), 557);
  assertToStringEquals("aaaa5", res[279].firstMatch("aaaa5"), 558);
  assertToStringEquals("x", res[350].firstMatch("xyCabcCxyz"), 559);
  assertToStringEquals("x", res[350].firstMatch("xyCabcCxyz"), 560);
  assertToStringEquals("b", res[350].firstMatch("bXaX"), 561);
  assertToStringEquals("b", res[350].firstMatch("bXbX"), 562);
  assertToStringEquals("*", res[350].firstMatch("** Failers"), 563);
  assertToStringEquals("aX", res[350].firstMatch("aXaX"), 564);
  assertToStringEquals("aX", res[350].firstMatch("aXbX"), 565);
  assertToStringEquals("x", res[350].firstMatch("xx"), 566);
  assertToStringEquals("x", res[350].firstMatch("xy"), 567);
  assertToStringEquals("y", res[350].firstMatch("yy"), 568);
  assertToStringEquals("y", res[350].firstMatch("yx"), 569);
  assertToStringEquals("x", res[350].firstMatch("xx"), 570);
  assertToStringEquals("x", res[350].firstMatch("xy"), 571);
  assertToStringEquals("y", res[350].firstMatch("yy"), 572);
  assertToStringEquals("y", res[350].firstMatch("yx"), 573);
  assertToStringEquals("b", res[350].firstMatch("bxay"), 574);
  assertToStringEquals("b", res[350].firstMatch("bxby"), 575);
  assertToStringEquals("*", res[350].firstMatch("** Failers"), 576);
  assertToStringEquals("ax", res[350].firstMatch("axby"), 577);
  assertToStringEquals("X", res[350].firstMatch("XxXxxx"), 578);
  assertToStringEquals("X", res[350].firstMatch("XxXyyx"), 579);
  assertToStringEquals("X", res[350].firstMatch("XxXyxx"), 580);
  assertToStringEquals("*", res[350].firstMatch("** Failers"), 581);
  assertToStringEquals("x", res[350].firstMatch("x"), 582);
  assertToStringEquals("ab", res[350].firstMatch("abcabc"), 583);
  assertToStringEquals("Xaaa,a", res[351].firstMatch("Xaaa"), 584);
  assertToStringEquals("Xaba,a", res[351].firstMatch("Xaba"), 585);
  assertThrows(() => new RegExp(r"^[a-\\Q\\E]"), 586);
  assertNull(res[353].firstMatch("(xy)x"), 587);
  assertNull(res[353].firstMatch("1221"), 588);
  assertNull(res[353].firstMatch("Satan, oscillate my metallic sonatas!"), 589);
  assertNull(res[353].firstMatch("A man, a plan, a canal: Panama!"), 590);
  assertNull(res[353].firstMatch("Able was I ere I saw Elba."), 591);
  assertNull(res[353].firstMatch("*** Failers"), 592);
  assertNull(res[353].firstMatch("The quick brown fox"), 593);
  assertToStringEquals("abcd:,abcd", res[354].firstMatch("abcd:"), 594);
  assertToStringEquals("abcd:,abcd", res[354].firstMatch("abcd:"), 595);
  assertToStringEquals("a:,a", res[354].firstMatch("a:aaxyz"), 596);
  assertToStringEquals("ab:,ab", res[354].firstMatch("ab:ababxyz"), 597);
  assertNull(res[354].firstMatch("** Failers"), 598);
  assertToStringEquals("a:,a", res[354].firstMatch("a:axyz"), 599);
  assertToStringEquals("ab:,ab", res[354].firstMatch("ab:abxyz"), 600);
  assertNull(res[354].firstMatch("abd"), 601);
  assertNull(res[354].firstMatch("ce"), 602);
  assertNull(res[354].firstMatch("abcabc1Xabc2XabcXabcabc"), 603);
  assertNull(res[354].firstMatch("abcabc1Xabc2XabcXabcabc"), 604);
  assertNull(res[354].firstMatch("abcabc1Xabc2XabcXabcabc"), 605);
  assertNull(res[354].firstMatch("abcd"), 606);
  assertNull(res[354].firstMatch("metcalfe 33"), 607);
  assertNull(res[356].firstMatch("a\x0db"), 608);
  assertNull(res[356].firstMatch("a\nb<cr>"), 609);
  assertToStringEquals("a\x85b", res[356].firstMatch("a\x85b<anycrlf> "), 610);
  assertNull(res[356].firstMatch("** Failers"), 611);
  assertNull(res[356].firstMatch("a\nb"), 612);
  assertNull(res[356].firstMatch("a\nb<any>"), 613);
  assertNull(res[356].firstMatch("a\x0db<cr>"), 614);
  assertNull(res[356].firstMatch("a\x0db<any>"), 615);
  assertToStringEquals("a\x85b", res[356].firstMatch("a\x85b<any> "), 616);
  assertNull(res[356].firstMatch("a\x0db<anycrlf>"), 617);
  assertToStringEquals("abc1", res[357].firstMatch("abc1 \nabc2 \x0babc3xx \x0cabc4 \x0dabc5xx \x0d\nabc6 \x85abc7 JUNK"), 618);
  assertToStringEquals("abc1", res[358].firstMatch("abc1\n abc2\x0b abc3\x0c abc4\x0d abc5\x0d\n abc6\x85 abc7 abc9"), 619);
  assertNull(res[361].firstMatch("a\nb"), 620);
  assertNull(res[361].firstMatch("a\x0db"), 621);
  assertNull(res[361].firstMatch("a\x0d\nb"), 622);
  assertNull(res[361].firstMatch("a\x0bb"), 623);
  assertNull(res[361].firstMatch("a\x0cb"), 624);
  assertNull(res[361].firstMatch("a\x85b"), 625);
  assertNull(res[361].firstMatch("** Failers"), 626);
  assertNull(res[361].firstMatch("a\n\x0db"), 627);
  assertToStringEquals("ab", res[362].firstMatch("ab"), 628);
  assertNull(res[362].firstMatch("a\nb"), 629);
  assertNull(res[362].firstMatch("a\x0db"), 630);
  assertNull(res[362].firstMatch("a\x0d\nb"), 631);
  assertNull(res[362].firstMatch("a\x0bb"), 632);
  assertNull(res[362].firstMatch("a\x0cb"), 633);
  assertNull(res[362].firstMatch("a\x85b"), 634);
  assertNull(res[362].firstMatch("a\n\x0db"), 635);
  assertNull(res[362].firstMatch("a\n\x0d\x85\x0cb"), 636);
  assertNull(res[363].firstMatch("a\nb"), 637);
  assertNull(res[363].firstMatch("a\x0db"), 638);
  assertNull(res[363].firstMatch("a\x0d\nb"), 639);
  assertNull(res[363].firstMatch("a\x0bb"), 640);
  assertNull(res[363].firstMatch("a\x0cb"), 641);
  assertNull(res[363].firstMatch("a\x85b"), 642);
  assertNull(res[363].firstMatch("a\n\x0db"), 643);
  assertNull(res[363].firstMatch("a\n\x0d\x85\x0cb"), 644);
  assertNull(res[363].firstMatch("** Failers"), 645);
  assertNull(res[363].firstMatch("ab"), 646);
  assertNull(res[364].firstMatch("a\nb"), 647);
  assertNull(res[364].firstMatch("a\n\x0db"), 648);
  assertNull(res[364].firstMatch("a\n\x0d\x85b"), 649);
  assertNull(res[364].firstMatch("a\x0d\n\x0d\nb"), 650);
  assertNull(res[364].firstMatch("a\x0d\n\x0d\n\x0d\nb"), 651);
  assertNull(res[364].firstMatch("a\n\x0d\n\x0db"), 652);
  assertNull(res[364].firstMatch("a\n\n\x0d\nb"), 653);
  assertNull(res[364].firstMatch("** Failers"), 654);
  assertNull(res[364].firstMatch("a\n\n\n\x0db"), 655);
  assertNull(res[364].firstMatch("a\x0d"), 656);
  assertToStringEquals("aRb", res[365].firstMatch("aRb"), 657);
  assertNull(res[365].firstMatch("** Failers"), 658);
  assertNull(res[365].firstMatch("a\nb"), 659);
  assertNull(res[365].firstMatch("abcPXP123"), 660);
  assertNull(res[365].firstMatch("abcPXP123"), 661);
  assertNull(res[365].firstMatch("1.2.3.4"), 662);
  assertNull(res[365].firstMatch("131.111.10.206"), 663);
  assertNull(res[365].firstMatch("10.0.0.0"), 664);
  assertNull(res[365].firstMatch("** Failers"), 665);
  assertNull(res[365].firstMatch("10.6"), 666);
  assertNull(res[365].firstMatch("455.3.4.5"), 667);
  assertNull(res[365].firstMatch("1.2.3.4"), 668);
  assertNull(res[365].firstMatch("131.111.10.206"), 669);
  assertNull(res[365].firstMatch("10.0.0.0"), 670);
  assertNull(res[365].firstMatch("** Failers"), 671);
  assertNull(res[365].firstMatch("10.6"), 672);
  assertNull(res[365].firstMatch("455.3.4.5"), 673);
  assertNull(res[365].firstMatch("123axbaxbaxbx456"), 674);
  assertNull(res[365].firstMatch("123axbaxbaxb456"), 675);
  assertNull(res[365].firstMatch("123axbaxbaxbx456"), 676);
  assertNull(res[365].firstMatch("123axbaxbaxbx456"), 677);
  assertNull(res[365].firstMatch("123axbaxbaxbx456"), 678);
  assertNull(res[366].firstMatch("ababababbbabZXXXX"), 679);
  assertNull(res[372].firstMatch("a\x0db"), 680);
  assertNull(res[372].firstMatch("*** Failers"), 681);
  assertNull(res[372].firstMatch("a\nb"), 682);
  assertToStringEquals("afoo", res[373].firstMatch("afoo"), 683);
  assertNull(res[373].firstMatch("** Failers"), 684);
  assertNull(res[373].firstMatch("\x0d\nfoo"), 685);
  assertNull(res[373].firstMatch("\nfoo"), 686);
  assertToStringEquals("afoo", res[374].firstMatch("afoo"), 687);
  assertNull(res[374].firstMatch("\nfoo"), 688);
  assertNull(res[374].firstMatch("** Failers"), 689);
  assertNull(res[374].firstMatch("\x0d\nfoo"), 690);
  assertToStringEquals("afoo", res[375].firstMatch("afoo"), 691);
  assertNull(res[375].firstMatch("** Failers"), 692);
  assertNull(res[375].firstMatch("\nfoo"), 693);
  assertNull(res[375].firstMatch("\x0d\nfoo"), 694);
  assertToStringEquals("afoo", res[376].firstMatch("afoo"), 695);
  assertNull(res[376].firstMatch("\x0d\nfoo"), 696);
  assertNull(res[376].firstMatch("\nfoo"), 697);
  assertToStringEquals("", res[377].firstMatch("abc\x0d\x0dxyz"), 698);
  assertToStringEquals("", res[377].firstMatch("abc\n\x0dxyz  "), 699);
  assertNull(res[377].firstMatch("** Failers "), 700);
  assertToStringEquals("", res[377].firstMatch("abc\x0d\nxyz"), 701);
  assertToStringEquals("", res[377].firstMatch("abc\x0d\n\x0d\n"), 702);
  assertToStringEquals("", res[377].firstMatch("abc\x0d\n\x0d\n"), 703);
  assertToStringEquals("", res[377].firstMatch("abc\x0d\n\x0d\n"), 704);
  assertToStringEquals("abc1", res[378].firstMatch("abc1\n abc2\x0b abc3\x0c abc4\x0d abc5\x0d\n abc6\x85 abc9"), 705);
  assertToStringEquals("X", res[379].firstMatch("XABC"), 706);
  assertNull(res[379].firstMatch("** Failers "), 707);
  assertToStringEquals("X", res[379].firstMatch("XABCB"), 708);
  assertThrows(() => new RegExp(r"(ab|c)(?-1)"), 709);
  assertNull(res[379].firstMatch("abc"), 710);
  assertNull(res[379].firstMatch("xyabcabc"), 711);
  assertNull(res[379].firstMatch("** Failers"), 712);
  assertNull(res[379].firstMatch("xyabc  "), 713);
  assertThrows(() => new RegExp(r"x(?-0)y"), 714);
  assertThrows(() => new RegExp(r"x(?-1)y"), 715);
  assertNull(res[379].firstMatch("abcX"), 716);
  assertNull(res[379].firstMatch("Y"), 717);
  assertNull(res[379].firstMatch("** Failers"), 718);
  assertNull(res[379].firstMatch("abcY   "), 719);
  assertNull(res[379].firstMatch("YabcXabc"), 720);
  assertNull(res[379].firstMatch("YabcXabcXabc"), 721);
  assertNull(res[379].firstMatch("** Failers"), 722);
  assertToStringEquals("X", res[379].firstMatch("XabcXabc  "), 723);
  assertNull(res[379].firstMatch("Y!"), 724);
  assertNull(res[380].firstMatch("foobar"), 725);
  assertNull(res[381].firstMatch("foobar"), 726);
  assertToStringEquals("foobaz,foo,baz", res[381].firstMatch("foobaz "), 727);
  assertNull(res[382].firstMatch("foobarbaz"), 728);
  assertNull(res[382].firstMatch("tom-tom"), 729);
  assertNull(res[382].firstMatch("bon-bon "), 730);
  assertNull(res[382].firstMatch("** Failers"), 731);
  assertNull(res[382].firstMatch("tom-bon  "), 732);
  assertNull(res[382].firstMatch("tom-tom"), 733);
  assertNull(res[382].firstMatch("bon-bon "), 734);
  assertThrows(() => new RegExp(r"(?|(abc)|(xyz))"), 735);
  assertThrows(() => new RegExp(r"(x)(?|(abc)|(xyz))(x)"), 736);
  assertNull(res[383].firstMatch("xabcx"), 737);
  assertNull(res[383].firstMatch("xxyzx "), 738);
  assertThrows(() => new RegExp(r"(x)(?|(abc)(pqr)|(xyz))(x)"), 739);
  assertNull(res[383].firstMatch("xabcpqrx"), 740);
  assertNull(res[383].firstMatch("xxyzx "), 741);
  assertThrows(() => new RegExp(r"(?|(abc)|(xyz))\1"), 742);
  assertNull(res[383].firstMatch("abcabc"), 743);
  assertNull(res[383].firstMatch("xyzxyz "), 744);
  assertNull(res[383].firstMatch("** Failers"), 745);
  assertNull(res[383].firstMatch("abcxyz"), 746);
  assertNull(res[383].firstMatch("xyzabc   "), 747);
  assertNull(res[383].firstMatch("abcabc"), 748);
  assertNull(res[383].firstMatch("xyzabc "), 749);
  assertNull(res[383].firstMatch("** Failers "), 750);
  assertNull(res[383].firstMatch("xyzxyz "), 751);
  assertNull(res[384].firstMatch("X X\n"), 752);
  assertNull(res[384].firstMatch("X\x09X\x0b"), 753);
  assertNull(res[384].firstMatch("** Failers"), 754);
  assertNull(res[384].firstMatch("\xa0 X\n   "), 755);
  assertNull(res[385].firstMatch("\x09 \xa0X\n\x0b\x0c\x0d\n"), 756);
  assertNull(res[385].firstMatch("\x09 \xa0\n\x0b\x0c\x0d\n"), 757);
  assertNull(res[385].firstMatch("\x09 \xa0\n\x0b\x0c"), 758);
  assertNull(res[385].firstMatch("** Failers "), 759);
  assertNull(res[385].firstMatch("\x09 \xa0\n\x0b"), 760);
  assertNull(res[385].firstMatch(" "), 761);
  assertNull(res[386].firstMatch("XY  ABCDE"), 762);
  assertNull(res[386].firstMatch("XY  PQR ST "), 763);
  assertNull(res[387].firstMatch("XY  AB    PQRS"), 764);
  assertNull(res[388].firstMatch(">XNNNYZ"), 765);
  assertNull(res[388].firstMatch(">  X NYQZ"), 766);
  assertNull(res[388].firstMatch("** Failers"), 767);
  assertNull(res[388].firstMatch(">XYZ   "), 768);
  assertNull(res[388].firstMatch(">  X NY Z"), 769);
  assertNull(res[389].firstMatch(">XY\nZ\nA\x0bNN\x0c"), 770);
  assertNull(res[389].firstMatch(">\n\x0dX\nY\n\x0bZZZ\nAAA\x0bNNN\x0c"), 771);
  assertNull(res[390].firstMatch(">\x09<"), 772);
  assertNull(res[391].firstMatch(">\x09 \xa0<"), 773);
  assertNull(res[396].firstMatch("** Failers"), 774);
  assertNull(res[396].firstMatch("XXXX"), 775);
  assertNull(res[397].firstMatch("XXXX Y "), 776);
  assertNull(res[419].firstMatch("aaaaaa"), 777);
  assertNull(res[419].firstMatch("aaabccc"), 778);
  assertNull(res[419].firstMatch("aaabccc"), 779);
  assertNull(res[419].firstMatch("aaabccc"), 780);
  assertNull(res[419].firstMatch("aaabcccaaabccc"), 781);
  assertNull(res[419].firstMatch("aaaxxxxxx"), 782);
  assertNull(res[419].firstMatch("aaa++++++ "), 783);
  assertNull(res[419].firstMatch("bbbxxxxx"), 784);
  assertNull(res[419].firstMatch("bbb+++++ "), 785);
  assertNull(res[419].firstMatch("cccxxxx"), 786);
  assertNull(res[419].firstMatch("ccc++++ "), 787);
  assertNull(res[419].firstMatch("dddddddd   "), 788);
  assertNull(res[419].firstMatch("aaaxxxxxx"), 789);
  assertNull(res[419].firstMatch("aaa++++++ "), 790);
  assertNull(res[419].firstMatch("bbbxxxxx"), 791);
  assertNull(res[419].firstMatch("bbb+++++ "), 792);
  assertNull(res[419].firstMatch("cccxxxx"), 793);
  assertNull(res[419].firstMatch("ccc++++ "), 794);
  assertNull(res[419].firstMatch("dddddddd   "), 795);
  assertNull(res[419].firstMatch("aaabccc"), 796);
  assertNull(res[419].firstMatch("ABX"), 797);
  assertNull(res[419].firstMatch("AADE"), 798);
  assertNull(res[419].firstMatch("ACDE"), 799);
  assertNull(res[419].firstMatch("** Failers"), 800);
  assertNull(res[419].firstMatch("AD "), 801);
  assertNull(res[419].firstMatch("    "), 802);
  assertNull(res[419].firstMatch("aaaaaa"), 803);
  assertNull(res[419].firstMatch("aaabccc"), 804);
  assertNull(res[419].firstMatch("aaabccc"), 805);
  assertNull(res[419].firstMatch("aaabccc"), 806);
  assertNull(res[419].firstMatch("aaabcccaaabccc"), 807);
  assertNull(res[419].firstMatch("aaabccc"), 808);
  assertNull(res[422].firstMatch("\x0d\nA"), 809);
  assertToStringEquals("\nA", res[423].firstMatch("\x0d\nA "), 810);
  assertToStringEquals("\nA", res[424].firstMatch("\x0d\nA "), 811);
  assertToStringEquals("\nA,\n", res[425].firstMatch("\x0d\nA "), 812);
  assertNull(res[425].firstMatch("a\nb"), 813);
  assertNull(res[425].firstMatch("** Failers"), 814);
  assertNull(res[425].firstMatch("a\x0db  "), 815);
  assertNull(res[425].firstMatch("a\nb"), 816);
  assertNull(res[425].firstMatch("** Failers"), 817);
  assertNull(res[425].firstMatch("a\x0db  "), 818);
  assertNull(res[425].firstMatch("a\x0db"), 819);
  assertNull(res[425].firstMatch("** Failers"), 820);
  assertNull(res[425].firstMatch("a\nb  "), 821);
  assertNull(res[425].firstMatch("a\x0db"), 822);
  assertNull(res[425].firstMatch("a\nb  "), 823);
  assertNull(res[425].firstMatch("** Failers"), 824);
  assertNull(res[425].firstMatch("a\x0d\nb  "), 825);
  assertNull(res[425].firstMatch("** Failers"), 826);
  assertNull(res[425].firstMatch("a\x0db"), 827);
  assertNull(res[425].firstMatch("a\nb  "), 828);
  assertNull(res[425].firstMatch("a\x0d\nb  "), 829);
  assertNull(res[425].firstMatch("** Failers"), 830);
  assertNull(res[425].firstMatch("a\x0db"), 831);
  assertNull(res[425].firstMatch("a\nb  "), 832);
  assertNull(res[425].firstMatch("a\x0d\nb  "), 833);
  assertNull(res[425].firstMatch("a\x85b "), 834);
  assertNull(res[426].firstMatch("a\x0db"), 835);
  assertNull(res[426].firstMatch("a\nb"), 836);
  assertNull(res[426].firstMatch("a\x0d\nb"), 837);
  assertNull(res[426].firstMatch("** Failers"), 838);
  assertNull(res[426].firstMatch("a\x85b"), 839);
  assertNull(res[426].firstMatch("a\x0bb     "), 840);
  assertNull(res[427].firstMatch("a\x0db"), 841);
  assertNull(res[427].firstMatch("a\nb"), 842);
  assertNull(res[427].firstMatch("a\x0d\nb"), 843);
  assertNull(res[427].firstMatch("a\x85b"), 844);
  assertNull(res[427].firstMatch("a\x0bb     "), 845);
  assertNull(res[427].firstMatch("** Failers "), 846);
  assertNull(res[427].firstMatch("a\x85b<bsr_anycrlf>"), 847);
  assertNull(res[427].firstMatch("a\x0bb<bsr_anycrlf>"), 848);
  assertNull(res[428].firstMatch("a\x0db"), 849);
  assertNull(res[428].firstMatch("a\nb"), 850);
  assertNull(res[428].firstMatch("a\x0d\nb"), 851);
  assertNull(res[428].firstMatch("** Failers"), 852);
  assertNull(res[428].firstMatch("a\x85b"), 853);
  assertNull(res[428].firstMatch("a\x0bb     "), 854);
  assertNull(res[429].firstMatch("a\x0db"), 855);
  assertNull(res[429].firstMatch("a\nb"), 856);
  assertNull(res[429].firstMatch("a\x0d\nb"), 857);
  assertNull(res[429].firstMatch("a\x85b"), 858);
  assertNull(res[429].firstMatch("a\x0bb     "), 859);
  assertNull(res[429].firstMatch("** Failers "), 860);
  assertNull(res[429].firstMatch("a\x85b<bsr_anycrlf>"), 861);
  assertNull(res[429].firstMatch("a\x0bb<bsr_anycrlf>"), 862);
  assertNull(res[430].firstMatch("a\x0d\n\nb"), 863);
  assertNull(res[430].firstMatch("a\n\x0d\x0db"), 864);
  assertNull(res[430].firstMatch("a\x0d\n\x0d\n\x0d\n\x0d\nb"), 865);
  assertNull(res[430].firstMatch("** Failers"), 866);
  assertNull(res[430].firstMatch("a\x8585b"), 867);
  assertNull(res[430].firstMatch("a\x0b\x00bb     "), 868);
  assertNull(res[431].firstMatch("a\x0d\x0db"), 869);
  assertNull(res[431].firstMatch("a\n\n\nb"), 870);
  assertNull(res[431].firstMatch("a\x0d\n\n\x0d\x0db"), 871);
  assertNull(res[431].firstMatch("a\x8585b"), 872);
  assertNull(res[431].firstMatch("a\x0b\x00bb     "), 873);
  assertNull(res[431].firstMatch("** Failers "), 874);
  assertNull(res[431].firstMatch("a\x0d\x0d\x0d\x0d\x0db "), 875);
  assertNull(res[431].firstMatch("a\x8585b<bsr_anycrlf>"), 876);
  assertNull(res[431].firstMatch("a\x0b\x00bb<bsr_anycrlf>"), 877);
  assertNull(res[431].firstMatch("a\nb"), 878);
  assertNull(res[431].firstMatch("a\x0db "), 879);
  assertNull(res[431].firstMatch("a\x85b"), 880);
  assertNull(res[431].firstMatch("a\nb"), 881);
  assertNull(res[431].firstMatch("a\x0db "), 882);
  assertNull(res[431].firstMatch("a\x85b"), 883);
  assertThrows(() => new RegExp(r"(?-+a)"), 884);
  assertNull(res[443].firstMatch("aaaa"), 885);
  assertNull(res[443].firstMatch("bacxxx"), 886);
  assertNull(res[443].firstMatch("bbaccxxx "), 887);
  assertNull(res[443].firstMatch("bbbacccxx"), 888);
  assertNull(res[443].firstMatch("aaaa"), 889);
  assertNull(res[443].firstMatch("bacxxx"), 890);
  assertNull(res[443].firstMatch("bbaccxxx "), 891);
  assertNull(res[443].firstMatch("bbbacccxx"), 892);
  assertToStringEquals("a,a", res[444].firstMatch("aaaa"), 893);
  assertNull(res[444].firstMatch("bacxxx"), 894);
  assertNull(res[444].firstMatch("bbaccxxx "), 895);
  assertNull(res[444].firstMatch("bbbacccxx"), 896);
  assertToStringEquals("a,a", res[445].firstMatch("aaaa"), 897);
  assertNull(res[445].firstMatch("bacxxx"), 898);
  assertNull(res[445].firstMatch("bbaccxxx "), 899);
  assertNull(res[445].firstMatch("bbbacccxx"), 900);
  assertToStringEquals("a,a", res[446].firstMatch("aaaa"), 901);
  assertNull(res[446].firstMatch("bacxxx"), 902);
  assertNull(res[446].firstMatch("bbaccxxx "), 903);
  assertNull(res[446].firstMatch("bbbacccxx"), 904);
  assertToStringEquals("a,a,a", res[447].firstMatch("aaaa"), 905);
  assertNull(res[447].firstMatch("bacxxx"), 906);
  assertNull(res[447].firstMatch("bbaccxxx "), 907);
  assertNull(res[447].firstMatch("bbbacccxx"), 908);
  assertNull(res[449].firstMatch("bacxxx"), 909);
  assertNull(res[449].firstMatch("XaaX"), 910);
  assertNull(res[449].firstMatch("XAAX "), 911);
  assertNull(res[449].firstMatch("XaaX"), 912);
  assertNull(res[449].firstMatch("** Failers "), 913);
  assertNull(res[449].firstMatch("XAAX "), 914);
  assertNull(res[449].firstMatch("XaaX"), 915);
  assertNull(res[449].firstMatch("XAAX "), 916);
  assertNull(res[449].firstMatch("xzxx"), 917);
  assertNull(res[449].firstMatch("yzyy "), 918);
  assertNull(res[449].firstMatch("** Failers"), 919);
  assertNull(res[449].firstMatch("xxz  "), 920);
  assertToStringEquals("a,,,a", res[450].firstMatch("cat"), 921);
  assertToStringEquals("a,,,a", res[451].firstMatch("cat"), 922);
  assertToStringEquals("TA]", res[452].firstMatch("The ACTA] comes "), 923);
  assertToStringEquals("TA]", res[453].firstMatch("The ACTA] comes "), 924);
  assertNull(res[453].firstMatch("abcbabc"), 925);
  assertNull(res[453].firstMatch("abcbabc"), 926);
  assertNull(res[453].firstMatch("abcbabc"), 927);
  assertNull(res[453].firstMatch("** Failers "), 928);
  assertNull(res[453].firstMatch("abcXabc"), 929);
  assertNull(res[453].firstMatch("abcXabc"), 930);
  assertNull(res[453].firstMatch("** Failers "), 931);
  assertNull(res[453].firstMatch("abcbabc"), 932);
  assertNull(res[453].firstMatch("xyzbabcxyz"), 933);
  assertNull(res[456].firstMatch("** Failers"), 934);
  assertNull(res[456].firstMatch("ab"), 935);
  assertNull(res[457].firstMatch("** Failers"), 936);
  assertNull(res[457].firstMatch("ab "), 937);
  assertNull(res[457].firstMatch("** Failers"), 938);
  assertNull(res[457].firstMatch("ab "), 939);
  assertToStringEquals("aXb", res[458].firstMatch("aXb"), 940);
  assertToStringEquals("a\nb", res[458].firstMatch("a\nb "), 941);
  assertNull(res[458].firstMatch("** Failers"), 942);
  assertNull(res[458].firstMatch("ab  "), 943);
  assertToStringEquals("aXb", res[459].firstMatch("aXb"), 944);
  assertToStringEquals("a\nX\nXb", res[459].firstMatch("a\nX\nXb "), 945);
  assertNull(res[459].firstMatch("** Failers"), 946);
  assertNull(res[459].firstMatch("ab  "), 947);
  assertToStringEquals("acb", res[463].firstMatch("acb"), 948);
  assertToStringEquals("ab", res[463].firstMatch("ab"), 949);
  assertNull(res[463].firstMatch("ax{100}b "), 950);
  assertNull(res[463].firstMatch("*** Failers"), 951);
  assertNull(res[463].firstMatch("a\nb  "), 952);
  assertNull(res[464].firstMatch("ax{4000}xyb "), 953);
  assertNull(res[464].firstMatch("ax{4000}yb "), 954);
  assertNull(res[464].firstMatch("ax{4000}x{100}yb "), 955);
  assertNull(res[464].firstMatch("*** Failers"), 956);
  assertNull(res[464].firstMatch("ax{4000}b "), 957);
  assertNull(res[464].firstMatch("ac\ncb "), 958);
  assertToStringEquals("a\xc0,,\xc0", res[465].firstMatch("a\xc0\x88b"), 959);
  assertToStringEquals("ax,,x", res[466].firstMatch("ax{100}b"), 960);
  assertToStringEquals("a\xc0\x88b,\xc0\x88,b", res[467].firstMatch("a\xc0\x88b"), 961);
  assertToStringEquals("ax{100}b,x{100},b", res[468].firstMatch("ax{100}b"), 962);
  assertToStringEquals("a\xc0\x92,\xc0,\x92", res[469].firstMatch("a\xc0\x92bcd"), 963);
  assertToStringEquals("ax{,x,{", res[470].firstMatch("ax{240}bcd"), 964);
  assertToStringEquals("a\xc0\x92,\xc0,\x92", res[471].firstMatch("a\xc0\x92bcd"), 965);
  assertToStringEquals("ax{,x,{", res[472].firstMatch("ax{240}bcd"), 966);
  assertToStringEquals("a\xc0,,\xc0", res[473].firstMatch("a\xc0\x92bcd"), 967);
  assertToStringEquals("ax,,x", res[474].firstMatch("ax{240}bcd"), 968);
  assertNull(res[475].firstMatch("ax{1234}xyb "), 969);
  assertNull(res[475].firstMatch("ax{1234}x{4321}yb "), 970);
  assertNull(res[475].firstMatch("ax{1234}x{4321}x{3412}b "), 971);
  assertNull(res[475].firstMatch("*** Failers"), 972);
  assertNull(res[475].firstMatch("ax{1234}b "), 973);
  assertNull(res[475].firstMatch("ac\ncb "), 974);
  assertToStringEquals("ax{1234}xyb,x{1234}xy", res[476].firstMatch("ax{1234}xyb "), 975);
  assertToStringEquals("ax{1234}x{4321}yb,x{1234}x{4321}y", res[476].firstMatch("ax{1234}x{4321}yb "), 976);
  assertToStringEquals("ax{1234}x{4321}x{3412}b,x{1234}x{4321}x{3412}", res[476].firstMatch("ax{1234}x{4321}x{3412}b "), 977);
  assertToStringEquals("axxxxbcdefghijb,xxxxbcdefghij", res[476].firstMatch("axxxxbcdefghijb "), 978);
  assertToStringEquals("ax{1234}x{4321}x{3412}x{3421}b,x{1234}x{4321}x{3412}x{3421}", res[476].firstMatch("ax{1234}x{4321}x{3412}x{3421}b "), 979);
  assertNull(res[476].firstMatch("*** Failers"), 980);
  assertToStringEquals("ax{1234}b,x{1234}", res[476].firstMatch("ax{1234}b "), 981);
  assertToStringEquals("ax{1234}xyb,x{1234}xy", res[477].firstMatch("ax{1234}xyb "), 982);
  assertToStringEquals("ax{1234}x{4321}yb,x{1234}x{4321}y", res[477].firstMatch("ax{1234}x{4321}yb "), 983);
  assertToStringEquals("ax{1234}x{4321}x{3412}b,x{1234}x{4321}x{3412}", res[477].firstMatch("ax{1234}x{4321}x{3412}b "), 984);
  assertToStringEquals("axxxxb,xxxx", res[477].firstMatch("axxxxbcdefghijb "), 985);
  assertToStringEquals("ax{1234}x{4321}x{3412}x{3421}b,x{1234}x{4321}x{3412}x{3421}", res[477].firstMatch("ax{1234}x{4321}x{3412}x{3421}b "), 986);
  assertNull(res[477].firstMatch("*** Failers"), 987);
  assertToStringEquals("ax{1234}b,x{1234}", res[477].firstMatch("ax{1234}b "), 988);
  assertNull(res[478].firstMatch("ax{1234}xyb "), 989);
  assertNull(res[478].firstMatch("ax{1234}x{4321}yb "), 990);
  assertNull(res[478].firstMatch("ax{1234}x{4321}x{3412}b "), 991);
  assertToStringEquals("axxxxb,xxxx", res[478].firstMatch("axxxxbcdefghijb "), 992);
  assertNull(res[478].firstMatch("ax{1234}x{4321}x{3412}x{3421}b "), 993);
  assertToStringEquals("axbxxb,xbxx", res[478].firstMatch("axbxxbcdefghijb "), 994);
  assertToStringEquals("axxxxxb,xxxxx", res[478].firstMatch("axxxxxbcdefghijb "), 995);
  assertNull(res[478].firstMatch("*** Failers"), 996);
  assertNull(res[478].firstMatch("ax{1234}b "), 997);
  assertNull(res[478].firstMatch("axxxxxxbcdefghijb "), 998);
  assertNull(res[479].firstMatch("ax{1234}xyb "), 999);
  assertNull(res[479].firstMatch("ax{1234}x{4321}yb "), 1000);
  assertNull(res[479].firstMatch("ax{1234}x{4321}x{3412}b "), 1001);
  assertToStringEquals("axxxxb,xxxx", res[479].firstMatch("axxxxbcdefghijb "), 1002);
  assertNull(res[479].firstMatch("ax{1234}x{4321}x{3412}x{3421}b "), 1003);
  assertToStringEquals("axbxxb,xbxx", res[479].firstMatch("axbxxbcdefghijb "), 1004);
  assertToStringEquals("axxxxxb,xxxxx", res[479].firstMatch("axxxxxbcdefghijb "), 1005);
  assertNull(res[479].firstMatch("*** Failers"), 1006);
  assertNull(res[479].firstMatch("ax{1234}b "), 1007);
  assertNull(res[479].firstMatch("axxxxxxbcdefghijb "), 1008);
  assertNull(res[479].firstMatch("*** Failers"), 1009);
  assertNull(res[479].firstMatch("x{100}"), 1010);
  assertNull(res[479].firstMatch("aXbcd"), 1011);
  assertNull(res[479].firstMatch("ax{100}bcd"), 1012);
  assertNull(res[479].firstMatch("ax{100000}bcd"), 1013);
  assertNull(res[479].firstMatch("x{100}x{100}x{100}b"), 1014);
  assertNull(res[479].firstMatch("*** Failers "), 1015);
  assertNull(res[479].firstMatch("x{100}x{100}b"), 1016);
  assertNull(res[479].firstMatch("x{ab} "), 1017);
  assertNull(res[479].firstMatch("\xc2\xab"), 1018);
  assertNull(res[479].firstMatch("*** Failers "), 1019);
  assertNull(res[479].firstMatch("\x00{ab}"), 1020);
  assertNull(res[479].firstMatch("WXYZ"), 1021);
  assertNull(res[479].firstMatch("x{256}XYZ "), 1022);
  assertNull(res[479].firstMatch("*** Failers"), 1023);
  assertNull(res[479].firstMatch("XYZ "), 1024);
  assertNull(res[480].firstMatch("Xx{1234}"), 1025);
  assertNull(res[481].firstMatch("Xx{1234}YZ"), 1026);
  assertToStringEquals("X", res[482].firstMatch("XYZabcdce"), 1027);
  assertToStringEquals("X", res[483].firstMatch("XYZabcde"), 1028);
  assertNull(res[484].firstMatch("Xabcdefg   "), 1029);
  assertNull(res[484].firstMatch("Xx{1234} "), 1030);
  assertNull(res[484].firstMatch("Xx{1234}YZ"), 1031);
  assertNull(res[484].firstMatch("Xx{1234}x{512}  "), 1032);
  assertNull(res[484].firstMatch("Xx{1234}x{512}YZ"), 1033);
  assertNull(res[485].firstMatch("Xabcdefg   "), 1034);
  assertNull(res[485].firstMatch("Xx{1234} "), 1035);
  assertNull(res[485].firstMatch("Xx{1234}YZ"), 1036);
  assertNull(res[485].firstMatch("Xx{1234}x{512}  "), 1037);
  assertToStringEquals("bcd", res[486].firstMatch("bcd"), 1038);
  assertToStringEquals("x{", res[487].firstMatch("x{100}bc"), 1040);
  assertToStringEquals("x{100}bcA", res[488].firstMatch("x{100}bcAa"), 1041);
  assertToStringEquals("x{", res[489].firstMatch("x{100}bca"), 1042);
  assertToStringEquals("bcd", res[490].firstMatch("bcd"), 1043);
  assertToStringEquals("x{", res[491].firstMatch("x{100}bc"), 1045);
  assertToStringEquals("x{100}bc", res[492].firstMatch("x{100}bcAa"), 1046);
  assertToStringEquals("x{", res[493].firstMatch("x{100}bca"), 1047);
  assertNull(res[493].firstMatch("abcd"), 1048);
  assertNull(res[493].firstMatch("abcd"), 1049);
  assertToStringEquals("x{", res[493].firstMatch("x{100}x{100} "), 1050);
  assertToStringEquals("x{", res[493].firstMatch("x{100}x{100} "), 1051);
  assertToStringEquals("x{", res[493].firstMatch("x{100}x{100}x{100}x{100} "), 1052);
  assertNull(res[493].firstMatch("abce"), 1053);
  assertToStringEquals("x{", res[493].firstMatch("x{100}x{100}x{100}x{100} "), 1054);
  assertNull(res[493].firstMatch("abcdx{100}x{100}x{100}x{100} "), 1055);
  assertNull(res[493].firstMatch("abcdx{100}x{100}x{100}x{100} "), 1056);
  assertNull(res[493].firstMatch("abcdx{100}x{100}x{100}x{100} "), 1057);
  assertNull(res[493].firstMatch("abcdx{100}x{100}x{100}XX"), 1058);
  assertNull(res[493].firstMatch("abcdx{100}x{100}x{100}x{100}x{100}x{100}x{100}XX"), 1059);
  assertNull(res[493].firstMatch("abcdx{100}x{100}x{100}x{100}x{100}x{100}x{100}XX"), 1060);
  assertToStringEquals("Xy", res[493].firstMatch("Xyyyax{100}x{100}bXzzz"), 1061);
  assertToStringEquals("X", res[496].firstMatch("1X2"), 1062);
  assertToStringEquals("x", res[496].firstMatch("1x{100}2 "), 1063);
  assertToStringEquals(">X", res[497].firstMatch("> >X Y"), 1064);
  assertToStringEquals(">x", res[497].firstMatch("> >x{100} Y"), 1065);
  assertToStringEquals("1", res[498].firstMatch("x{100}3"), 1066);
  assertToStringEquals(" ", res[499].firstMatch("x{100} X"), 1067);
  assertToStringEquals("abcd", res[500].firstMatch("12abcd34"), 1068);
  assertToStringEquals("*** Failers", res[500].firstMatch("*** Failers"), 1069);
  assertToStringEquals("  ", res[500].firstMatch("1234  "), 1070);
  assertToStringEquals("abc", res[501].firstMatch("12abcd34"), 1071);
  assertToStringEquals("ab", res[501].firstMatch("12ab34"), 1072);
  assertToStringEquals("***", res[501].firstMatch("*** Failers  "), 1073);
  assertNull(res[501].firstMatch("1234"), 1074);
  assertToStringEquals("  ", res[501].firstMatch("12a34  "), 1075);
  assertToStringEquals("ab", res[502].firstMatch("12abcd34"), 1076);
  assertToStringEquals("ab", res[502].firstMatch("12ab34"), 1077);
  assertToStringEquals("**", res[502].firstMatch("*** Failers  "), 1078);
  assertNull(res[502].firstMatch("1234"), 1079);
  assertToStringEquals("  ", res[502].firstMatch("12a34  "), 1080);
  assertToStringEquals("12", res[503].firstMatch("12abcd34"), 1081);
  assertNull(res[503].firstMatch("*** Failers"), 1082);
  assertToStringEquals("12", res[504].firstMatch("12abcd34"), 1083);
  assertToStringEquals("123", res[504].firstMatch("1234abcd"), 1084);
  assertNull(res[504].firstMatch("*** Failers  "), 1085);
  assertNull(res[504].firstMatch("1.4 "), 1086);
  assertToStringEquals("12", res[505].firstMatch("12abcd34"), 1087);
  assertToStringEquals("12", res[505].firstMatch("1234abcd"), 1088);
  assertNull(res[505].firstMatch("*** Failers  "), 1089);
  assertNull(res[505].firstMatch("1.4 "), 1090);
  assertToStringEquals("12abcd34", res[506].firstMatch("12abcd34"), 1091);
  assertToStringEquals("***", res[506].firstMatch("*** Failers"), 1092);
  assertNull(res[506].firstMatch("     "), 1093);
  assertToStringEquals("12a", res[507].firstMatch("12abcd34"), 1094);
  assertToStringEquals("123", res[507].firstMatch("1234abcd"), 1095);
  assertToStringEquals("***", res[507].firstMatch("*** Failers"), 1096);
  assertNull(res[507].firstMatch("       "), 1097);
  assertToStringEquals("12", res[508].firstMatch("12abcd34"), 1098);
  assertToStringEquals("12", res[508].firstMatch("1234abcd"), 1099);
  assertToStringEquals("**", res[508].firstMatch("*** Failers"), 1100);
  assertNull(res[508].firstMatch("       "), 1101);
  assertToStringEquals(">      <", res[509].firstMatch("12>      <34"), 1102);
  assertNull(res[509].firstMatch("*** Failers"), 1103);
  assertToStringEquals(">  <", res[510].firstMatch("ab>  <cd"), 1104);
  assertToStringEquals(">   <", res[510].firstMatch("ab>   <ce"), 1105);
  assertNull(res[510].firstMatch("*** Failers"), 1106);
  assertNull(res[510].firstMatch("ab>    <cd "), 1107);
  assertToStringEquals(">  <", res[511].firstMatch("ab>  <cd"), 1108);
  assertToStringEquals(">   <", res[511].firstMatch("ab>   <ce"), 1109);
  assertNull(res[511].firstMatch("*** Failers"), 1110);
  assertNull(res[511].firstMatch("ab>    <cd "), 1111);
  assertToStringEquals("12", res[512].firstMatch("12      34"), 1112);
  assertToStringEquals("Failers", res[512].firstMatch("*** Failers"), 1113);
  assertNull(res[512].firstMatch("+++=*! "), 1114);
  assertToStringEquals("ab", res[513].firstMatch("ab  cd"), 1115);
  assertToStringEquals("abc", res[513].firstMatch("abcd ce"), 1116);
  assertToStringEquals("Fai", res[513].firstMatch("*** Failers"), 1117);
  assertNull(res[513].firstMatch("a.b.c"), 1118);
  assertToStringEquals("ab", res[514].firstMatch("ab  cd"), 1119);
  assertToStringEquals("ab", res[514].firstMatch("abcd ce"), 1120);
  assertToStringEquals("Fa", res[514].firstMatch("*** Failers"), 1121);
  assertNull(res[514].firstMatch("a.b.c"), 1122);
  assertToStringEquals("====", res[515].firstMatch("12====34"), 1123);
  assertToStringEquals("*** ", res[515].firstMatch("*** Failers"), 1124);
  assertToStringEquals(" ", res[515].firstMatch("abcd "), 1125);
  assertToStringEquals("===", res[516].firstMatch("ab====cd"), 1126);
  assertToStringEquals("==", res[516].firstMatch("ab==cd"), 1127);
  assertToStringEquals("***", res[516].firstMatch("*** Failers"), 1128);
  assertNull(res[516].firstMatch("a.b.c"), 1129);
  assertToStringEquals("==", res[517].firstMatch("ab====cd"), 1130);
  assertToStringEquals("==", res[517].firstMatch("ab==cd"), 1131);
  assertToStringEquals("**", res[517].firstMatch("*** Failers"), 1132);
  assertNull(res[517].firstMatch("a.b.c"), 1133);
  assertNull(res[517].firstMatch("x{100}"), 1134);
  assertNull(res[517].firstMatch("Zx{100}"), 1135);
  assertNull(res[517].firstMatch("x{100}Z"), 1136);
  assertToStringEquals("**", res[517].firstMatch("*** Failers "), 1137);
  assertNull(res[517].firstMatch("Zx{100}"), 1138);
  assertNull(res[517].firstMatch("x{100}"), 1139);
  assertNull(res[517].firstMatch("x{100}Z"), 1140);
  assertToStringEquals("**", res[517].firstMatch("*** Failers "), 1141);
  assertNull(res[517].firstMatch("abcx{200}X"), 1142);
  assertNull(res[517].firstMatch("abcx{100}X "), 1143);
  assertToStringEquals("**", res[517].firstMatch("*** Failers"), 1144);
  assertToStringEquals("  ", res[517].firstMatch("X  "), 1145);
  assertNull(res[517].firstMatch("abcx{200}X"), 1146);
  assertNull(res[517].firstMatch("abcx{100}X "), 1147);
  assertNull(res[517].firstMatch("abQX "), 1148);
  assertToStringEquals("**", res[517].firstMatch("*** Failers"), 1149);
  assertToStringEquals("  ", res[517].firstMatch("X  "), 1150);
  assertNull(res[517].firstMatch("abcx{100}x{200}x{100}X"), 1151);
  assertToStringEquals("**", res[517].firstMatch("*** Failers"), 1152);
  assertNull(res[517].firstMatch("abcx{200}X"), 1153);
  assertToStringEquals("  ", res[517].firstMatch("X  "), 1154);
  assertNull(res[517].firstMatch("AX"), 1155);
  assertNull(res[517].firstMatch("x{150}X"), 1156);
  assertNull(res[517].firstMatch("x{500}X "), 1157);
  assertToStringEquals("**", res[517].firstMatch("*** Failers"), 1158);
  assertNull(res[517].firstMatch("x{100}X"), 1159);
  assertToStringEquals("  ", res[517].firstMatch("x{200}X   "), 1160);
  assertNull(res[517].firstMatch("AX"), 1161);
  assertNull(res[517].firstMatch("x{150}X"), 1162);
  assertNull(res[517].firstMatch("x{500}X "), 1163);
  assertToStringEquals("**", res[517].firstMatch("*** Failers"), 1164);
  assertNull(res[517].firstMatch("x{100}X"), 1165);
  assertToStringEquals("  ", res[517].firstMatch("x{200}X   "), 1166);
  assertNull(res[517].firstMatch("QX "), 1167);
  assertNull(res[517].firstMatch("AX"), 1168);
  assertNull(res[517].firstMatch("x{500}X "), 1169);
  assertToStringEquals("**", res[517].firstMatch("*** Failers"), 1170);
  assertNull(res[517].firstMatch("x{100}X"), 1171);
  assertNull(res[517].firstMatch("x{150}X"), 1172);
  assertToStringEquals("  ", res[517].firstMatch("x{200}X   "), 1173);
  assertNull(res[518].firstMatch("aXb"), 1174);
  assertNull(res[518].firstMatch("a\nb"), 1175);
  assertNull(res[519].firstMatch("aXb"), 1176);
  assertNull(res[519].firstMatch("a\nb"), 1177);
  assertNull(res[519].firstMatch("*** Failers "), 1178);
  assertNull(res[519].firstMatch("ax{100}b "), 1179);
  assertNull(res[519].firstMatch("z"), 1180);
  assertNull(res[519].firstMatch("Z "), 1181);
  assertNull(res[519].firstMatch("x{100}"), 1182);
  assertNull(res[519].firstMatch("*** Failers"), 1183);
  assertNull(res[519].firstMatch("x{102}"), 1184);
  assertNull(res[519].firstMatch("y    "), 1185);
  assertToStringEquals("\xff", res[520].firstMatch(">\xff<"), 1186);
  assertNull(res[521].firstMatch(">x{ff}<"), 1187);
  assertToStringEquals("X", res[522].firstMatch("XYZ"), 1188);
  assertToStringEquals("X", res[523].firstMatch("XYZ"), 1189);
  assertToStringEquals("x", res[523].firstMatch("x{123} "), 1190);
  assertToStringEquals(",", res[528].firstMatch("catac"), 1191);
  assertToStringEquals(",", res[528].firstMatch("ax{256}a "), 1192);
  assertToStringEquals(",", res[528].firstMatch("x{85}"), 1193);
  assertToStringEquals(",", res[528].firstMatch("\u1234 "), 1194);
  assertToStringEquals(",", res[528].firstMatch("\u1234 "), 1195);
  assertToStringEquals(",", res[528].firstMatch("abcdefg"), 1196);
  assertToStringEquals(",", res[528].firstMatch("ab"), 1197);
  assertToStringEquals(",", res[528].firstMatch("a "), 1198);
  assertToStringEquals("Ax", res[529].firstMatch("Ax{a3}BC"), 1199);
  assertToStringEquals("Ax", res[530].firstMatch("Ax{a3}BC"), 1200);
  assertToStringEquals("}=", res[531].firstMatch("+x{a3}== "), 1201);
  assertToStringEquals("}=", res[532].firstMatch("+x{a3}== "), 1202);
  assertToStringEquals("x", res[533].firstMatch("x{442}x{435}x{441}x{442}"), 1203);
  assertToStringEquals("x", res[534].firstMatch("x{442}x{435}x{441}x{442}"), 1204);
  assertToStringEquals("x", res[535].firstMatch("x{442}x{435}x{441}x{442}"), 1205);
  assertToStringEquals("x", res[536].firstMatch("x{442}x{435}x{441}x{442}"), 1206);
  assertToStringEquals("{", res[537].firstMatch("x{2442}x{2435}x{2441}x{2442}"), 1207);
  assertToStringEquals("{", res[538].firstMatch("x{2442}x{2435}x{2441}x{2442}"), 1208);
  assertToStringEquals("abc\n\x0dx{442}x{435}x{441}x{442}xyz ", res[539].firstMatch("abc\n\x0dx{442}x{435}x{441}x{442}xyz "), 1209);
  assertToStringEquals("x{442}x{435}x{441}x{442}", res[539].firstMatch("x{442}x{435}x{441}x{442}"), 1210);
  assertToStringEquals("c d", res[540].firstMatch("abc defx{442}x{443}xyz\npqr"), 1211);
  assertToStringEquals("c d", res[541].firstMatch("abc defx{442}x{443}xyz\npqr"), 1212);
  assertNull(res[542].firstMatch("+x{2442}"), 1213);
  assertNull(res[543].firstMatch("+x{2442}"), 1214);
  assertNull(res[544].firstMatch("Ax{442}"), 1215);
  assertNull(res[545].firstMatch("Ax{442}"), 1216);
  assertNull(res[546].firstMatch("Ax{442}"), 1217);
  assertNull(res[547].firstMatch("Ax{442}"), 1218);
  assertNull(res[548].firstMatch("\x19x{e01ff}"), 1219);
  assertNull(res[549].firstMatch("Ax{422}"), 1220);
  assertNull(res[550].firstMatch("x{19}x{e01ff}"), 1221);
  assertNull(res[551].firstMatch("Ax{442}"), 1222);
  assertNull(res[552].firstMatch("Ax{442}"), 1223);
  assertNull(res[553].firstMatch("ax{442}"), 1224);
  assertNull(res[554].firstMatch("+x{2442}"), 1225);
  assertNull(res[555].firstMatch("Mx{442}"), 1226);
  assertToStringEquals("abc", res[556].firstMatch("abc"), 1227);
  assertToStringEquals("abc", res[557].firstMatch("abc"), 1228);
  assertToStringEquals("abc", res[558].firstMatch("abc"), 1229);
  assertToStringEquals("abc", res[559].firstMatch("abc"), 1230);
  assertNull(res[560].firstMatch("x{100}ax{1234}bcd"), 1231);
  assertNull(res[562].firstMatch("x{0041}x{2262}x{0391}x{002e}"), 1232);
  assertNull(res[562].firstMatch("x{D55c}x{ad6d}x{C5B4} "), 1233);
  assertNull(res[562].firstMatch("x{65e5}x{672c}x{8a9e}"), 1234);
  assertToStringEquals("{861}X", res[563].firstMatch("x{212ab}x{212ab}x{212ab}x{861}X"), 1235);
  assertToStringEquals("x{2", res[564].firstMatch("x{212ab}x{212ab}x{212ab}x{861}"), 1236);
  assertToStringEquals("x{c", res[564].firstMatch("x{c0}b"), 1237);
  assertToStringEquals("ax{", res[564].firstMatch("ax{c0}aaaa/ "), 1238);
  assertToStringEquals("ax{", res[564].firstMatch("ax{c0}aaaa/ "), 1239);
  assertToStringEquals("ax{", res[564].firstMatch("ax{c0}ax{c0}aaa/ "), 1240);
  assertToStringEquals("ax{", res[564].firstMatch("ax{c0}aaaa/ "), 1241);
  assertToStringEquals("ax{", res[564].firstMatch("ax{c0}ax{c0}aaa/ "), 1242);
  assertToStringEquals("ax{", res[564].firstMatch("ax{c0}aaaa/ "), 1243);
  assertToStringEquals("ax{", res[564].firstMatch("ax{c0}ax{c0}aaa/ "), 1244);
  assertToStringEquals("Sho", res[564].firstMatch("Should produce an error diagnostic"), 1245);
  assertNull(res[565].firstMatch("Xx{1234}"), 1246);
  assertNull(res[565].firstMatch("X\nabc "), 1247);
  assertToStringEquals("b", res[566].firstMatch("bar"), 1248);
  assertNull(res[566].firstMatch("*** Failers"), 1249);
  assertNull(res[566].firstMatch("c"), 1250);
  assertNull(res[566].firstMatch("x{ff}"), 1251);
  assertNull(res[566].firstMatch("x{100}  "), 1252);
  assertToStringEquals("c", res[567].firstMatch("c"), 1253);
  assertToStringEquals("x", res[567].firstMatch("x{ff}"), 1254);
  assertToStringEquals("x", res[567].firstMatch("x{100}  "), 1255);
  assertToStringEquals("*", res[567].firstMatch("*** Failers "), 1256);
  assertNull(res[567].firstMatch("aaa"), 1257);
  assertToStringEquals("x", res[568].firstMatch("x{f1}"), 1258);
  assertToStringEquals("x", res[568].firstMatch("x{bf}"), 1259);
  assertToStringEquals("x", res[568].firstMatch("x{100}"), 1260);
  assertToStringEquals("x", res[568].firstMatch("x{1000}   "), 1261);
  assertToStringEquals("*", res[568].firstMatch("*** Failers"), 1262);
  assertToStringEquals("x", res[568].firstMatch("x{c0} "), 1263);
  assertToStringEquals("x", res[568].firstMatch("x{f0} "), 1264);
  assertToStringEquals("1", res[568].firstMatch("1234"), 1265);
  assertToStringEquals("\"", res[568].firstMatch("\"1234\" "), 1266);
  assertToStringEquals("x", res[568].firstMatch("x{100}1234"), 1267);
  assertToStringEquals("\"", res[568].firstMatch("\"x{100}1234\"  "), 1268);
  assertToStringEquals("x", res[568].firstMatch("x{100}x{100}12ab "), 1269);
  assertToStringEquals("x", res[568].firstMatch("x{100}x{100}\"12\" "), 1270);
  assertToStringEquals("*", res[568].firstMatch("*** Failers "), 1271);
  assertToStringEquals("x", res[568].firstMatch("x{100}x{100}abcd"), 1272);
  assertToStringEquals("A", res[568].firstMatch("A"), 1273);
  assertToStringEquals("x", res[568].firstMatch("x{100}"), 1274);
  assertToStringEquals("Z", res[568].firstMatch("Zx{100}"), 1275);
  assertToStringEquals("x", res[568].firstMatch("x{100}Z"), 1276);
  assertToStringEquals("*", res[568].firstMatch("*** Failers "), 1277);
  assertToStringEquals("Z", res[568].firstMatch("Zx{100}"), 1278);
  assertToStringEquals("x", res[568].firstMatch("x{100}"), 1279);
  assertToStringEquals("x", res[568].firstMatch("x{100}Z"), 1280);
  assertToStringEquals("*", res[568].firstMatch("*** Failers "), 1281);
  assertToStringEquals("x", res[568].firstMatch("x{100}"), 1282);
  assertToStringEquals("x", res[568].firstMatch("x{104}"), 1283);
  assertToStringEquals("*", res[568].firstMatch("*** Failers"), 1284);
  assertToStringEquals("x", res[568].firstMatch("x{105}"), 1285);
  assertToStringEquals("x", res[568].firstMatch("x{ff}    "), 1286);
  assertToStringEquals("x", res[568].firstMatch("x{100}"), 1287);
  assertToStringEquals("\u0100", res[568].firstMatch("\u0100 "), 1288);
  assertToStringEquals("\xff", res[569].firstMatch(">\xff<"), 1289);
  assertNull(res[570].firstMatch(">x{ff}<"), 1290);
  assertToStringEquals("\xd6", res[572].firstMatch("\xd6 # Matches without Study"), 1291);
  assertToStringEquals("x", res[572].firstMatch("x{d6}"), 1292);
  assertToStringEquals("\xd6", res[572].firstMatch("\xd6 <-- Same with Study"), 1293);
  assertToStringEquals("x", res[572].firstMatch("x{d6}"), 1294);
  assertToStringEquals("\xd6", res[572].firstMatch("\xd6 # Matches without Study"), 1295);
  assertToStringEquals("x", res[572].firstMatch("x{d6} "), 1296);
  assertToStringEquals("\xd6", res[572].firstMatch("\xd6 <-- Same with Study"), 1297);
  assertToStringEquals("x", res[572].firstMatch("x{d6} "), 1298);
  assertToStringEquals("\ufffd", res[572].firstMatch("\ufffd]"), 1299);
  assertToStringEquals("\ufffd", res[572].firstMatch("\ufffd"), 1300);
  assertToStringEquals("\ufffd", res[572].firstMatch("\ufffd\ufffd\ufffd"), 1301);
  assertToStringEquals("\ufffd", res[572].firstMatch("\ufffd\ufffd\ufffd?"), 1302);
  assertNull(res[573].firstMatch("\xc0\x80"), 1303);
  assertNull(res[573].firstMatch("\xc1\x8f "), 1304);
  assertNull(res[573].firstMatch("\xe0\x9f\x80"), 1305);
  assertNull(res[573].firstMatch("\xf0\x8f\x80\x80 "), 1306);
  assertNull(res[573].firstMatch("\xf8\x87\x80\x80\x80  "), 1307);
  assertNull(res[573].firstMatch("\xfc\x83\x80\x80\x80\x80"), 1308);
  assertNull(res[573].firstMatch("\xfe\x80\x80\x80\x80\x80  "), 1309);
  assertNull(res[573].firstMatch("\xff\x80\x80\x80\x80\x80  "), 1310);
  assertNull(res[573].firstMatch("\xc3\x8f"), 1311);
  assertNull(res[573].firstMatch("\xe0\xaf\x80"), 1312);
  assertNull(res[573].firstMatch("\xe1\x80\x80"), 1313);
  assertNull(res[573].firstMatch("\xf0\x9f\x80\x80 "), 1314);
  assertNull(res[573].firstMatch("\xf1\x8f\x80\x80 "), 1315);
  assertNull(res[573].firstMatch("\xf8\x88\x80\x80\x80  "), 1316);
  assertNull(res[573].firstMatch("\xf9\x87\x80\x80\x80  "), 1317);
  assertNull(res[573].firstMatch("\xfc\x84\x80\x80\x80\x80"), 1318);
  assertNull(res[573].firstMatch("\xfd\x83\x80\x80\x80\x80"), 1319);
  assertNull(res[573].firstMatch("?\xf8\x88\x80\x80\x80  "), 1320);
  assertNull(res[573].firstMatch("?\xf9\x87\x80\x80\x80  "), 1321);
  assertNull(res[573].firstMatch("?\xfc\x84\x80\x80\x80\x80"), 1322);
  assertNull(res[573].firstMatch("?\xfd\x83\x80\x80\x80\x80"), 1323);
  assertToStringEquals(".", res[574].firstMatch("A.B"), 1324);
  assertToStringEquals("{", res[574].firstMatch("Ax{100}B "), 1325);
  assertToStringEquals("x", res[575].firstMatch("x{100}X   "), 1326);
  assertToStringEquals("a", res[575].firstMatch("ax{1234}b"), 1327);
  assertNull(res[577].firstMatch("AxxB     "), 1328);
  assertToStringEquals("abc1", res[578].firstMatch("abc1 \nabc2 \x0babc3xx \x0cabc4 \x0dabc5xx \x0d\nabc6 x{0085}abc7 x{2028}abc8 x{2029}abc9 JUNK"), 1329);
  assertToStringEquals("abc1", res[579].firstMatch("abc1\n abc2\x0b abc3\x0c abc4\x0d abc5\x0d\n abc6x{0085} abc7x{2028} abc8x{2029} abc9"), 1330);
  assertNull(res[580].firstMatch("a\nb"), 1331);
  assertNull(res[580].firstMatch("a\x0db"), 1332);
  assertNull(res[580].firstMatch("a\x0d\nb"), 1333);
  assertNull(res[580].firstMatch("a\x0bb"), 1334);
  assertNull(res[580].firstMatch("a\x0cb"), 1335);
  assertNull(res[580].firstMatch("ax{85}b   "), 1336);
  assertNull(res[580].firstMatch("ax{2028}b "), 1337);
  assertNull(res[580].firstMatch("ax{2029}b "), 1338);
  assertNull(res[580].firstMatch("** Failers"), 1339);
  assertNull(res[580].firstMatch("a\n\x0db    "), 1340);
  assertToStringEquals("ab", res[581].firstMatch("ab"), 1341);
  assertNull(res[581].firstMatch("a\nb"), 1342);
  assertNull(res[581].firstMatch("a\x0db"), 1343);
  assertNull(res[581].firstMatch("a\x0d\nb"), 1344);
  assertNull(res[581].firstMatch("a\x0bb"), 1345);
  assertNull(res[581].firstMatch("a\x0cx{2028}x{2029}b"), 1346);
  assertNull(res[581].firstMatch("ax{85}b   "), 1347);
  assertNull(res[581].firstMatch("a\n\x0db    "), 1348);
  assertNull(res[581].firstMatch("a\n\x0dx{85}\x0cb "), 1349);
  assertNull(res[582].firstMatch("a\nb"), 1350);
  assertNull(res[582].firstMatch("a\x0db"), 1351);
  assertNull(res[582].firstMatch("a\x0d\nb"), 1352);
  assertNull(res[582].firstMatch("a\x0bb"), 1353);
  assertNull(res[582].firstMatch("a\x0cx{2028}x{2029}b"), 1354);
  assertNull(res[582].firstMatch("ax{85}b   "), 1355);
  assertNull(res[582].firstMatch("a\n\x0db    "), 1356);
  assertNull(res[582].firstMatch("a\n\x0dx{85}\x0cb "), 1357);
  assertNull(res[582].firstMatch("** Failers"), 1358);
  assertNull(res[582].firstMatch("ab  "), 1359);
  assertNull(res[583].firstMatch("a\nb"), 1360);
  assertNull(res[583].firstMatch("a\n\x0db"), 1361);
  assertNull(res[583].firstMatch("a\n\x0dx{85}b"), 1362);
  assertNull(res[583].firstMatch("a\x0d\n\x0d\nb "), 1363);
  assertNull(res[583].firstMatch("a\x0d\n\x0d\n\x0d\nb "), 1364);
  assertNull(res[583].firstMatch("a\n\x0d\n\x0db"), 1365);
  assertNull(res[583].firstMatch("a\n\n\x0d\nb "), 1366);
  assertNull(res[583].firstMatch("** Failers"), 1367);
  assertNull(res[583].firstMatch("a\n\n\n\x0db"), 1368);
  assertNull(res[583].firstMatch("a\x0d"), 1369);
  assertNull(res[584].firstMatch("X X\n"), 1370);
  assertNull(res[584].firstMatch("X\x09X\x0b"), 1371);
  assertNull(res[584].firstMatch("** Failers"), 1372);
  assertNull(res[584].firstMatch("x{a0} X\n   "), 1373);
  assertNull(res[585].firstMatch("\x09 x{a0}X\n\x0b\x0c\x0d\n"), 1374);
  assertNull(res[585].firstMatch("\x09 x{a0}\n\x0b\x0c\x0d\n"), 1375);
  assertNull(res[585].firstMatch("\x09 x{a0}\n\x0b\x0c"), 1376);
  assertNull(res[585].firstMatch("** Failers "), 1377);
  assertNull(res[585].firstMatch("\x09 x{a0}\n\x0b"), 1378);
  assertNull(res[585].firstMatch(" "), 1379);
  assertNull(res[586].firstMatch("x{3001}x{3000}x{2030}x{2028}"), 1380);
  assertNull(res[586].firstMatch("Xx{180e}Xx{85}"), 1381);
  assertNull(res[586].firstMatch("** Failers"), 1382);
  assertNull(res[586].firstMatch("x{2009} X\n   "), 1383);
  assertNull(res[587].firstMatch("x{1680}x{180e}x{2007}Xx{2028}x{2029}\x0c\x0d\n"), 1384);
  assertNull(res[587].firstMatch("\x09x{205f}x{a0}\nx{2029}\x0cx{2028}\n"), 1385);
  assertNull(res[587].firstMatch("\x09 x{202f}\n\x0b\x0c"), 1386);
  assertNull(res[587].firstMatch("** Failers "), 1387);
  assertNull(res[587].firstMatch("\x09x{200a}x{a0}x{2028}\x0b"), 1388);
  assertNull(res[587].firstMatch(" "), 1389);
  assertNull(res[588].firstMatch(">x{1680}"), 1390);
  assertNull(res[589].firstMatch(">x{1680}x{180e}x{2000}x{2003}x{200a}x{202f}x{205f}x{3000}<"), 1391);
  assertToStringEquals("x{1ec5} ", res[593].firstMatch("x{1ec5} "), 1392);
  assertNull(res[594].firstMatch("x{0}x{d7ff}x{e000}x{10ffff}"), 1393);
  assertNull(res[594].firstMatch("x{d800}"), 1394);
  assertNull(res[594].firstMatch("x{d800}?"), 1395);
  assertNull(res[594].firstMatch("x{da00}"), 1396);
  assertNull(res[594].firstMatch("x{da00}?"), 1397);
  assertNull(res[594].firstMatch("x{dfff}"), 1398);
  assertNull(res[594].firstMatch("x{dfff}?"), 1399);
  assertNull(res[594].firstMatch("x{110000}    "), 1400);
  assertNull(res[594].firstMatch("x{110000}?    "), 1401);
  assertNull(res[594].firstMatch("x{2000000} "), 1402);
  assertNull(res[594].firstMatch("x{2000000}? "), 1403);
  assertNull(res[594].firstMatch("x{7fffffff} "), 1404);
  assertNull(res[594].firstMatch("x{7fffffff}? "), 1405);
  assertNull(res[595].firstMatch("a\x0db"), 1406);
  assertNull(res[595].firstMatch("a\nb"), 1407);
  assertNull(res[595].firstMatch("a\x0d\nb"), 1408);
  assertNull(res[595].firstMatch("** Failers"), 1409);
  assertNull(res[595].firstMatch("ax{85}b"), 1410);
  assertNull(res[595].firstMatch("a\x0bb     "), 1411);
  assertNull(res[596].firstMatch("a\x0db"), 1412);
  assertNull(res[596].firstMatch("a\nb"), 1413);
  assertNull(res[596].firstMatch("a\x0d\nb"), 1414);
  assertNull(res[596].firstMatch("ax{85}b"), 1415);
  assertNull(res[596].firstMatch("a\x0bb     "), 1416);
  assertNull(res[596].firstMatch("** Failers "), 1417);
  assertNull(res[596].firstMatch("ax{85}b<bsr_anycrlf>"), 1418);
  assertNull(res[596].firstMatch("a\x0bb<bsr_anycrlf>"), 1419);
  assertNull(res[597].firstMatch("a\x0db"), 1420);
  assertNull(res[597].firstMatch("a\nb"), 1421);
  assertNull(res[597].firstMatch("a\x0d\nb"), 1422);
  assertNull(res[597].firstMatch("** Failers"), 1423);
  assertNull(res[597].firstMatch("ax{85}b"), 1424);
  assertNull(res[597].firstMatch("a\x0bb     "), 1425);
  assertNull(res[598].firstMatch("a\x0db"), 1426);
  assertNull(res[598].firstMatch("a\nb"), 1427);
  assertNull(res[598].firstMatch("a\x0d\nb"), 1428);
  assertNull(res[598].firstMatch("ax{85}b"), 1429);
  assertNull(res[598].firstMatch("a\x0bb     "), 1430);
  assertNull(res[598].firstMatch("** Failers "), 1431);
  assertNull(res[598].firstMatch("ax{85}b<bsr_anycrlf>"), 1432);
  assertNull(res[598].firstMatch("a\x0bb<bsr_anycrlf>"), 1433);
  assertToStringEquals("QQQx{2029}ABCaXYZ=!bPQR", res[599].firstMatch("QQQx{2029}ABCaXYZ=!bPQR"), 1434);
  assertNull(res[599].firstMatch("** Failers"), 1435);
  assertNull(res[599].firstMatch("ax{2029}b"), 1436);
  assertNull(res[599].firstMatch("a\xe2\x80\xa9b "), 1437);
  assertNull(res[600].firstMatch("ax{1234}b"), 1438);
  assertToStringEquals("a\nb", res[600].firstMatch("a\nb "), 1439);
  assertNull(res[600].firstMatch("** Failers"), 1440);
  assertNull(res[600].firstMatch("ab  "), 1441);
  assertToStringEquals("aXb", res[601].firstMatch("aXb"), 1442);
  assertToStringEquals("a\nX\nXx{1234}b", res[601].firstMatch("a\nX\nXx{1234}b "), 1443);
  assertNull(res[601].firstMatch("** Failers"), 1444);
  assertNull(res[601].firstMatch("ab  "), 1445);
  assertNull(res[601].firstMatch("x{de}x{de}"), 1446);
  assertNull(res[601].firstMatch("x{123} "), 1447);
  assertToStringEquals("X", res[602].firstMatch("Ax{1ec5}ABCXYZ"), 1448);
  assertNull(res[604].firstMatch("x{c0}x{30f}x{660}x{66c}x{f01}x{1680}<"), 1449);
  assertNull(res[604].firstMatch("\npx{300}9!\$ < "), 1450);
  assertNull(res[604].firstMatch("** Failers "), 1451);
  assertNull(res[604].firstMatch("apx{300}9!\$ < "), 1452);
  assertNull(res[605].firstMatch("X"), 1453);
  assertNull(res[605].firstMatch("** Failers "), 1454);
  assertNull(res[605].firstMatch(""), 1455);
  assertNull(res[606].firstMatch("9"), 1456);
  assertNull(res[606].firstMatch("** Failers "), 1457);
  assertNull(res[606].firstMatch("x{c0}"), 1458);
  assertNull(res[607].firstMatch("X"), 1459);
  assertNull(res[607].firstMatch("** Failers "), 1460);
  assertNull(res[607].firstMatch("x{30f}"), 1461);
  assertNull(res[608].firstMatch("X"), 1462);
  assertNull(res[608].firstMatch("** Failers "), 1463);
  assertNull(res[608].firstMatch("x{660}"), 1464);
  assertNull(res[609].firstMatch("X"), 1465);
  assertNull(res[609].firstMatch("** Failers "), 1466);
  assertNull(res[609].firstMatch("x{66c}"), 1467);
  assertNull(res[610].firstMatch("X"), 1468);
  assertNull(res[610].firstMatch("** Failers "), 1469);
  assertNull(res[610].firstMatch("x{f01}"), 1470);
  assertNull(res[611].firstMatch("X"), 1471);
  assertNull(res[611].firstMatch("** Failers "), 1472);
  assertNull(res[611].firstMatch("x{1680}"), 1473);
  assertNull(res[612].firstMatch("x{017}"), 1474);
  assertNull(res[612].firstMatch("x{09f} "), 1475);
  assertNull(res[612].firstMatch("** Failers"), 1476);
  assertNull(res[612].firstMatch("x{0600} "), 1477);
  assertNull(res[613].firstMatch("x{601}"), 1478);
  assertNull(res[613].firstMatch("** Failers"), 1479);
  assertNull(res[613].firstMatch("x{09f} "), 1480);
  assertNull(res[614].firstMatch("x{e0000}"), 1481);
  assertNull(res[614].firstMatch("** Failers"), 1482);
  assertNull(res[614].firstMatch("x{09f} "), 1483);
  assertNull(res[615].firstMatch("x{f8ff}"), 1484);
  assertNull(res[615].firstMatch("** Failers"), 1485);
  assertNull(res[615].firstMatch("x{09f} "), 1486);
  assertNull(res[616].firstMatch("?x{dfff}"), 1487);
  assertNull(res[616].firstMatch("** Failers"), 1488);
  assertNull(res[616].firstMatch("x{09f} "), 1489);
  assertNull(res[617].firstMatch("a"), 1490);
  assertNull(res[617].firstMatch("** Failers "), 1491);
  assertNull(res[617].firstMatch("Z"), 1492);
  assertNull(res[617].firstMatch("x{e000}  "), 1493);
  assertNull(res[618].firstMatch("x{2b0}"), 1494);
  assertNull(res[618].firstMatch("** Failers"), 1495);
  assertNull(res[618].firstMatch("a "), 1496);
  assertNull(res[619].firstMatch("x{1bb}"), 1497);
  assertNull(res[619].firstMatch("x{3400}"), 1498);
  assertNull(res[619].firstMatch("x{3401}"), 1499);
  assertNull(res[619].firstMatch("x{4d00}"), 1500);
  assertNull(res[619].firstMatch("x{4db4}"), 1501);
  assertNull(res[619].firstMatch("x{4db5}     "), 1502);
  assertNull(res[619].firstMatch("** Failers"), 1503);
  assertNull(res[619].firstMatch("a "), 1504);
  assertNull(res[619].firstMatch("x{2b0}"), 1505);
  assertNull(res[619].firstMatch("x{4db6} "), 1506);
  assertNull(res[620].firstMatch("x{1c5}"), 1507);
  assertNull(res[620].firstMatch("** Failers"), 1508);
  assertNull(res[620].firstMatch("a "), 1509);
  assertNull(res[620].firstMatch("x{2b0}"), 1510);
  assertNull(res[621].firstMatch("A"), 1511);
  assertNull(res[621].firstMatch("** Failers"), 1512);
  assertNull(res[621].firstMatch("x{2b0}"), 1513);
  assertNull(res[622].firstMatch("x{903}"), 1514);
  assertNull(res[622].firstMatch("** Failers"), 1515);
  assertNull(res[622].firstMatch("X"), 1516);
  assertNull(res[622].firstMatch("x{300}"), 1517);
  assertNull(res[622].firstMatch("   "), 1518);
  assertNull(res[623].firstMatch("x{488}"), 1519);
  assertNull(res[623].firstMatch("** Failers"), 1520);
  assertNull(res[623].firstMatch("X"), 1521);
  assertNull(res[623].firstMatch("x{903}"), 1522);
  assertNull(res[623].firstMatch("x{300}"), 1523);
  assertNull(res[624].firstMatch("x{300}"), 1524);
  assertNull(res[624].firstMatch("** Failers"), 1525);
  assertNull(res[624].firstMatch("X"), 1526);
  assertNull(res[624].firstMatch("x{903}"), 1527);
  assertNull(res[624].firstMatch("0123456789x{660}x{661}x{662}x{663}x{664}x{665}x{666}x{667}x{668}x{669}x{66a}"), 1528);
  assertNull(res[624].firstMatch("x{6f0}x{6f1}x{6f2}x{6f3}x{6f4}x{6f5}x{6f6}x{6f7}x{6f8}x{6f9}x{6fa}"), 1529);
  assertNull(res[624].firstMatch("x{966}x{967}x{968}x{969}x{96a}x{96b}x{96c}x{96d}x{96e}x{96f}x{970}"), 1530);
  assertNull(res[624].firstMatch("** Failers"), 1531);
  assertNull(res[624].firstMatch("X"), 1532);
  assertNull(res[625].firstMatch("x{16ee}"), 1533);
  assertNull(res[625].firstMatch("** Failers"), 1534);
  assertNull(res[625].firstMatch("X"), 1535);
  assertNull(res[625].firstMatch("x{966}"), 1536);
  assertNull(res[626].firstMatch("x{b2}"), 1537);
  assertNull(res[626].firstMatch("x{b3}"), 1538);
  assertNull(res[626].firstMatch("** Failers"), 1539);
  assertNull(res[626].firstMatch("X"), 1540);
  assertNull(res[626].firstMatch("x{16ee}"), 1541);
  assertNull(res[627].firstMatch("_"), 1542);
  assertNull(res[627].firstMatch("x{203f}"), 1543);
  assertNull(res[627].firstMatch("** Failers"), 1544);
  assertNull(res[627].firstMatch("X"), 1545);
  assertNull(res[627].firstMatch("-"), 1546);
  assertNull(res[627].firstMatch("x{58a}"), 1547);
  assertNull(res[628].firstMatch("-"), 1548);
  assertNull(res[628].firstMatch("x{58a}"), 1549);
  assertNull(res[628].firstMatch("** Failers"), 1550);
  assertNull(res[628].firstMatch("X"), 1551);
  assertNull(res[628].firstMatch("x{203f}"), 1552);
  assertNull(res[629].firstMatch(")"), 1553);
  assertNull(res[629].firstMatch("]"), 1554);
  assertNull(res[629].firstMatch("}"), 1555);
  assertNull(res[629].firstMatch("x{f3b}"), 1556);
  assertNull(res[629].firstMatch("** Failers"), 1557);
  assertNull(res[629].firstMatch("X"), 1558);
  assertNull(res[629].firstMatch("x{203f}"), 1559);
  assertNull(res[629].firstMatch("("), 1560);
  assertNull(res[629].firstMatch("["), 1561);
  assertNull(res[629].firstMatch("{"), 1562);
  assertNull(res[629].firstMatch("x{f3c}"), 1563);
  assertNull(res[630].firstMatch("x{bb}"), 1564);
  assertNull(res[630].firstMatch("x{2019}"), 1565);
  assertNull(res[630].firstMatch("** Failers"), 1566);
  assertNull(res[630].firstMatch("X"), 1567);
  assertNull(res[630].firstMatch("x{203f}"), 1568);
  assertNull(res[631].firstMatch("x{ab}"), 1569);
  assertNull(res[631].firstMatch("x{2018}"), 1570);
  assertNull(res[631].firstMatch("** Failers"), 1571);
  assertNull(res[631].firstMatch("X"), 1572);
  assertNull(res[631].firstMatch("x{203f}"), 1573);
  assertNull(res[632].firstMatch("!"), 1574);
  assertNull(res[632].firstMatch("x{37e}"), 1575);
  assertNull(res[632].firstMatch("** Failers"), 1576);
  assertNull(res[632].firstMatch("X"), 1577);
  assertNull(res[632].firstMatch("x{203f}"), 1578);
  assertNull(res[633].firstMatch("("), 1579);
  assertNull(res[633].firstMatch("["), 1580);
  assertNull(res[633].firstMatch("{"), 1581);
  assertNull(res[633].firstMatch("x{f3c}"), 1582);
  assertNull(res[633].firstMatch("** Failers"), 1583);
  assertNull(res[633].firstMatch("X"), 1584);
  assertNull(res[633].firstMatch(")"), 1585);
  assertNull(res[633].firstMatch("]"), 1586);
  assertNull(res[633].firstMatch("}"), 1587);
  assertNull(res[633].firstMatch("x{f3b}"), 1588);
  assertNull(res[633].firstMatch("\$x{a2}x{a3}x{a4}x{a5}x{a6}"), 1589);
  assertNull(res[633].firstMatch("x{9f2}"), 1590);
  assertNull(res[633].firstMatch("** Failers"), 1591);
  assertNull(res[633].firstMatch("X"), 1592);
  assertNull(res[633].firstMatch("x{2c2}"), 1593);
  assertNull(res[634].firstMatch("x{2c2}"), 1594);
  assertNull(res[634].firstMatch("** Failers"), 1595);
  assertNull(res[634].firstMatch("X"), 1596);
  assertNull(res[634].firstMatch("x{9f2}"), 1597);
  assertNull(res[634].firstMatch("+<|~x{ac}x{2044}"), 1598);
  assertNull(res[634].firstMatch("** Failers"), 1599);
  assertNull(res[634].firstMatch("X"), 1600);
  assertNull(res[634].firstMatch("x{9f2}"), 1601);
  assertNull(res[635].firstMatch("x{a6}"), 1602);
  assertNull(res[635].firstMatch("x{482} "), 1603);
  assertNull(res[635].firstMatch("** Failers"), 1604);
  assertNull(res[635].firstMatch("X"), 1605);
  assertNull(res[635].firstMatch("x{9f2}"), 1606);
  assertNull(res[636].firstMatch("x{2028}"), 1607);
  assertNull(res[636].firstMatch("** Failers"), 1608);
  assertNull(res[636].firstMatch("X"), 1609);
  assertNull(res[636].firstMatch("x{2029}"), 1610);
  assertNull(res[637].firstMatch("x{2029}"), 1611);
  assertNull(res[637].firstMatch("** Failers"), 1612);
  assertNull(res[637].firstMatch("X"), 1613);
  assertNull(res[637].firstMatch("x{2028}"), 1614);
  assertNull(res[638].firstMatch("\\ \\"), 1615);
  assertNull(res[638].firstMatch("x{a0}"), 1616);
  assertNull(res[638].firstMatch("x{1680}"), 1617);
  assertNull(res[638].firstMatch("x{180e}"), 1618);
  assertNull(res[638].firstMatch("x{2000}"), 1619);
  assertNull(res[638].firstMatch("x{2001}     "), 1620);
  assertNull(res[638].firstMatch("** Failers"), 1621);
  assertNull(res[638].firstMatch("x{2028}"), 1622);
  assertNull(res[638].firstMatch("x{200d} "), 1623);
  assertNull(res[638].firstMatch("  x{660}x{661}x{662}ABC"), 1624);
  assertNull(res[638].firstMatch("  x{660}x{661}x{662}ABC"), 1625);
  assertNull(res[639].firstMatch("  x{660}x{661}x{662}ABC"), 1626);
  assertNull(res[640].firstMatch("  x{660}x{661}x{662}ABC"), 1627);
  assertNull(res[641].firstMatch("  x{660}x{661}x{662}ABC"), 1628);
  assertNull(res[642].firstMatch("  x{660}x{661}x{662}ABC"), 1629);
  assertNull(res[643].firstMatch("  x{660}x{661}x{662}ABC"), 1630);
  assertNull(res[644].firstMatch("  x{660}x{661}x{662}ABC"), 1631);
  assertNull(res[645].firstMatch("  x{660}x{661}x{662}ABC"), 1632);
  assertNull(res[646].firstMatch("  x{660}x{661}x{662}ABC"), 1633);
  assertNull(res[647].firstMatch("  x{660}x{661}x{662}ABC"), 1634);
  assertNull(res[647].firstMatch("  x{660}x{661}x{662}ABC"), 1635);
  assertNull(res[647].firstMatch("  x{660}x{661}x{662}ABC"), 1636);
  assertNull(res[647].firstMatch("  ** Failers"), 1637);
  assertNull(res[647].firstMatch("  x{660}x{661}x{662}ABC"), 1638);
  assertNull(res[648].firstMatch("A"), 1639);
  assertNull(res[648].firstMatch("ax{10a0}B "), 1640);
  assertNull(res[648].firstMatch("** Failers "), 1641);
  assertNull(res[648].firstMatch("a"), 1642);
  assertNull(res[648].firstMatch("x{1d00}  "), 1643);
  assertNull(res[649].firstMatch("1234"), 1644);
  assertNull(res[649].firstMatch("** Failers"), 1645);
  assertNull(res[649].firstMatch("ABC "), 1646);
  assertNull(res[650].firstMatch("1234"), 1647);
  assertNull(res[650].firstMatch("** Failers"), 1648);
  assertNull(res[650].firstMatch("ABC "), 1649);
  assertNull(res[650].firstMatch("A2XYZ"), 1650);
  assertNull(res[650].firstMatch("123A5XYZPQR"), 1651);
  assertNull(res[650].firstMatch("ABAx{660}XYZpqr"), 1652);
  assertNull(res[650].firstMatch("** Failers"), 1653);
  assertNull(res[650].firstMatch("AXYZ"), 1654);
  assertNull(res[650].firstMatch("XYZ     "), 1655);
  assertNull(res[650].firstMatch("1XYZ"), 1656);
  assertNull(res[650].firstMatch("AB=XYZ.. "), 1657);
  assertNull(res[650].firstMatch("XYZ "), 1658);
  assertNull(res[650].firstMatch("** Failers"), 1659);
  assertNull(res[650].firstMatch("WXYZ "), 1660);
  assertNull(res[655].firstMatch("1234"), 1661);
  assertNull(res[655].firstMatch("1234"), 1662);
  assertNull(res[655].firstMatch("12-34"), 1663);
  assertToStringEquals("{", res[655].firstMatch("12+x{661}-34  "), 1664);
  assertNull(res[655].firstMatch("** Failers"), 1665);
  assertToStringEquals("d", res[655].firstMatch("abcd  "), 1666);
  assertToStringEquals("d", res[656].firstMatch("abcd"), 1667);
  assertNull(res[656].firstMatch("** Failers"), 1668);
  assertNull(res[656].firstMatch("1234"), 1669);
  assertNull(res[657].firstMatch("11111111111111111111111111111111111111111111111111111111111111111111111"), 1670);
  assertToStringEquals("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", res[657].firstMatch("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"), 1671);
  assertToStringEquals(" ", res[657].firstMatch(" "), 1672);
  assertNull(res[657].firstMatch("11111111111111111111111111111111111111111111111111111111111111111111111"), 1673);
  assertToStringEquals("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", res[657].firstMatch("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"), 1674);
  assertNull(res[658].firstMatch("11111111111111111111111111111111111111111111111111111111111111111111111"), 1675);
  assertToStringEquals("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", res[658].firstMatch("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"), 1676);
  assertNull(res[659].firstMatch("11111111111111111111111111111111111111111111111111111111111111111111111"), 1677);
  assertNull(res[659].firstMatch("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"), 1678);
  assertNull(res[660].firstMatch("11111111111111111111111111111111111111111111111111111111111111111111111"), 1679);
  assertToStringEquals("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", res[660].firstMatch("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"), 1680);
  assertNull(res[661].firstMatch("a"), 1681);
  assertNull(res[661].firstMatch("A "), 1682);
  assertNull(res[662].firstMatch("a"), 1683);
  assertNull(res[662].firstMatch("A "), 1684);
  assertNull(res[663].firstMatch("A"), 1685);
  assertNull(res[663].firstMatch("aZ"), 1686);
  assertNull(res[663].firstMatch("** Failers"), 1687);
  assertNull(res[663].firstMatch("abc   "), 1688);
  assertNull(res[664].firstMatch("A"), 1689);
  assertNull(res[664].firstMatch("aZ"), 1690);
  assertNull(res[664].firstMatch("** Failers"), 1691);
  assertNull(res[664].firstMatch("abc   "), 1692);
  assertNull(res[665].firstMatch("a"), 1693);
  assertNull(res[665].firstMatch("Az"), 1694);
  assertNull(res[665].firstMatch("** Failers"), 1695);
  assertNull(res[665].firstMatch("ABC   "), 1696);
  assertNull(res[666].firstMatch("a"), 1697);
  assertNull(res[666].firstMatch("Az"), 1698);
  assertNull(res[666].firstMatch("** Failers"), 1699);
  assertNull(res[666].firstMatch("ABC   "), 1700);
  assertNull(res[666].firstMatch("x{c0}"), 1701);
  assertNull(res[666].firstMatch("x{e0} "), 1702);
  assertNull(res[666].firstMatch("x{c0}"), 1703);
  assertNull(res[666].firstMatch("x{e0} "), 1704);
  assertNull(res[666].firstMatch("Ax{391}x{10427}x{ff3a}x{1fb0}"), 1705);
  assertNull(res[666].firstMatch("** Failers"), 1706);
  assertNull(res[666].firstMatch("ax{391}x{10427}x{ff3a}x{1fb0}   "), 1707);
  assertNull(res[666].firstMatch("Ax{3b1}x{10427}x{ff3a}x{1fb0}"), 1708);
  assertNull(res[666].firstMatch("Ax{391}x{1044F}x{ff3a}x{1fb0}"), 1709);
  assertNull(res[666].firstMatch("Ax{391}x{10427}x{ff5a}x{1fb0}"), 1710);
  assertNull(res[666].firstMatch("Ax{391}x{10427}x{ff3a}x{1fb8}"), 1711);
  assertNull(res[666].firstMatch("Ax{391}x{10427}x{ff3a}x{1fb0}"), 1712);
  assertNull(res[666].firstMatch("ax{391}x{10427}x{ff3a}x{1fb0}   "), 1713);
  assertNull(res[666].firstMatch("Ax{3b1}x{10427}x{ff3a}x{1fb0}"), 1714);
  assertNull(res[666].firstMatch("Ax{391}x{1044F}x{ff3a}x{1fb0}"), 1715);
  assertNull(res[666].firstMatch("Ax{391}x{10427}x{ff5a}x{1fb0}"), 1716);
  assertNull(res[666].firstMatch("Ax{391}x{10427}x{ff3a}x{1fb8}"), 1717);
  assertNull(res[666].firstMatch("x{391}x{3b1}x{3b1}x{3b1}x{391}"), 1718);
  assertNull(res[666].firstMatch("x{391}x{3b1}x{3b1}x{3b1}x{391}X"), 1719);
  assertNull(res[666].firstMatch("x{391}x{3b1}x{3b1}x{3b1}x{391}X"), 1720);
  assertNull(res[666].firstMatch("x{391}"), 1721);
  assertNull(res[666].firstMatch("x{ff3a}"), 1722);
  assertNull(res[666].firstMatch("x{3b1}"), 1723);
  assertNull(res[666].firstMatch("x{ff5a}   "), 1724);
  assertNull(res[666].firstMatch("x{c0}"), 1725);
  assertNull(res[666].firstMatch("x{e0} "), 1726);
  assertNull(res[666].firstMatch("x{104}"), 1727);
  assertNull(res[666].firstMatch("x{105}"), 1728);
  assertNull(res[666].firstMatch("x{109}  "), 1729);
  assertNull(res[666].firstMatch("** Failers"), 1730);
  assertNull(res[666].firstMatch("x{100}"), 1731);
  assertNull(res[666].firstMatch("x{10a} "), 1732);
  assertNull(res[666].firstMatch("Z"), 1733);
  assertNull(res[666].firstMatch("z"), 1734);
  assertNull(res[666].firstMatch("x{39c}"), 1735);
  assertNull(res[666].firstMatch("x{178}"), 1736);
  assertNull(res[666].firstMatch("|"), 1737);
  assertNull(res[666].firstMatch("x{80}"), 1738);
  assertNull(res[666].firstMatch("x{ff}"), 1739);
  assertNull(res[666].firstMatch("x{100}"), 1740);
  assertNull(res[666].firstMatch("x{101} "), 1741);
  assertNull(res[666].firstMatch("** Failers"), 1742);
  assertNull(res[666].firstMatch("x{102}"), 1743);
  assertNull(res[666].firstMatch("Y"), 1744);
  assertNull(res[666].firstMatch("y           "), 1745);
  assertNull(res[667].firstMatch("A"), 1746);
  assertNull(res[667].firstMatch("Ax{300}BC "), 1747);
  assertNull(res[667].firstMatch("Ax{300}x{301}x{302}BC "), 1748);
  assertNull(res[667].firstMatch("*** Failers"), 1749);
  assertNull(res[667].firstMatch("x{300}  "), 1750);
  assertToStringEquals("X", res[668].firstMatch("X123"), 1751);
  assertNull(res[668].firstMatch("*** Failers"), 1752);
  assertNull(res[668].firstMatch("AXYZ"), 1753);
  assertNull(res[669].firstMatch("Ax{300}x{301}x{302}BCAx{300}x{301} "), 1754);
  assertNull(res[669].firstMatch("Ax{300}x{301}x{302}BCAx{300}x{301}C "), 1755);
  assertNull(res[670].firstMatch("Ax{300}x{301}x{302}BCAx{300}x{301} "), 1756);
  assertNull(res[670].firstMatch("Ax{300}x{301}x{302}BCAx{300}x{301}C "), 1757);
  assertToStringEquals("A,,A", res[671].firstMatch("Ax{300}x{301}x{302}BCAx{300}x{301} "), 1758);
  assertToStringEquals("A,,A", res[671].firstMatch("Ax{300}x{301}x{302}BCAx{300}x{301}C "), 1759);
  assertToStringEquals("A,,A", res[672].firstMatch("Ax{300}x{301}x{302}BCAx{300}x{301} "), 1760);
  assertToStringEquals("A,,A", res[672].firstMatch("Ax{300}x{301}x{302}BCAx{300}x{301}C "), 1761);
  assertNull(res[673].firstMatch("*** Failers"), 1762);
  assertNull(res[673].firstMatch("Ax{300}x{301}x{302}"), 1763);
  assertNull(res[674].firstMatch("Ax{300}x{301}Bx{300}X"), 1764);
  assertNull(res[674].firstMatch("Ax{300}x{301}Bx{300}Cx{300}x{301}"), 1765);
  assertNull(res[674].firstMatch("Ax{300}x{301}Bx{300}Cx{300}x{301}X"), 1766);
  assertNull(res[674].firstMatch("Ax{300}x{301}Bx{300}Cx{300}x{301}DAx{300}X"), 1767);
  assertNull(res[675].firstMatch("Ax{300}x{301}Bx{300}X"), 1768);
  assertNull(res[675].firstMatch("Ax{300}x{301}Bx{300}Cx{300}x{301}"), 1769);
  assertNull(res[675].firstMatch("Ax{300}x{301}Bx{300}Cx{300}x{301}X"), 1770);
  assertNull(res[675].firstMatch("Ax{300}x{301}Bx{300}Cx{300}x{301}DAx{300}X"), 1771);
  assertNull(res[675].firstMatch("x{2e81}x{3007}x{2f804}x{31a0}"), 1772);
  assertNull(res[675].firstMatch("** Failers"), 1773);
  assertNull(res[675].firstMatch("x{2e7f}  "), 1774);
  assertNull(res[675].firstMatch("x{3105}"), 1775);
  assertNull(res[675].firstMatch("** Failers"), 1776);
  assertNull(res[675].firstMatch("x{30ff}  "), 1777);
  assertNull(res[676].firstMatch("x{06e9}"), 1778);
  assertNull(res[676].firstMatch("x{060b}"), 1779);
  assertNull(res[676].firstMatch("** Failers"), 1780);
  assertNull(res[676].firstMatch("Xx{06e9}   "), 1781);
  assertNull(res[677].firstMatch("x{2f800}"), 1782);
  assertNull(res[677].firstMatch("** Failers"), 1783);
  assertNull(res[677].firstMatch("x{a014}"), 1784);
  assertNull(res[677].firstMatch("x{a4c6}   "), 1785);
  assertNull(res[678].firstMatch("AXYZ"), 1786);
  assertNull(res[678].firstMatch("x{1234}XYZ "), 1787);
  assertNull(res[678].firstMatch("** Failers"), 1788);
  assertNull(res[678].firstMatch("X  "), 1789);
  assertNull(res[679].firstMatch("** Failers"), 1790);
  assertNull(res[679].firstMatch("AX"), 1791);
  assertNull(res[680].firstMatch("XYZ"), 1792);
  assertNull(res[680].firstMatch("AXYZ"), 1793);
  assertNull(res[680].firstMatch("x{1234}XYZ "), 1794);
  assertNull(res[680].firstMatch("** Failers"), 1795);
  assertNull(res[680].firstMatch("ABXYZ   "), 1796);
  assertNull(res[681].firstMatch("XYZ"), 1797);
  assertNull(res[681].firstMatch("** Failers"), 1798);
  assertNull(res[681].firstMatch("AXYZ"), 1799);
  assertNull(res[681].firstMatch("x{1234}XYZ "), 1800);
  assertNull(res[681].firstMatch("ABXYZ   "), 1801);
  assertNull(res[681].firstMatch("AXYZ"), 1802);
  assertNull(res[681].firstMatch("x{1234}XYZ"), 1803);
  assertNull(res[681].firstMatch("Ax{1234}XYZ"), 1804);
  assertNull(res[681].firstMatch("** Failers"), 1805);
  assertNull(res[681].firstMatch("XYZ"), 1806);
  assertNull(res[681].firstMatch("** Failers"), 1807);
  assertNull(res[681].firstMatch("AXYZ"), 1808);
  assertNull(res[681].firstMatch("x{1234}XYZ"), 1809);
  assertNull(res[681].firstMatch("Ax{1234}XYZ"), 1810);
  assertNull(res[681].firstMatch("XYZ"), 1811);
  assertNull(res[682].firstMatch("XYZ"), 1812);
  assertNull(res[682].firstMatch("AXYZ"), 1813);
  assertNull(res[682].firstMatch("x{1234}XYZ"), 1814);
  assertNull(res[682].firstMatch("Ax{1234}XYZ"), 1815);
  assertNull(res[682].firstMatch("** Failers"), 1816);
  assertNull(res[683].firstMatch("XYZ"), 1817);
  assertNull(res[683].firstMatch("** Failers"), 1818);
  assertNull(res[683].firstMatch("AXYZ"), 1819);
  assertNull(res[683].firstMatch("x{1234}XYZ"), 1820);
  assertNull(res[683].firstMatch("Ax{1234}XYZ"), 1821);
  assertToStringEquals("AX", res[684].firstMatch("AXYZ"), 1822);
  assertNull(res[684].firstMatch("x{1234}XYZ "), 1823);
  assertNull(res[684].firstMatch("** Failers"), 1824);
  assertNull(res[684].firstMatch("X  "), 1825);
  assertNull(res[685].firstMatch("** Failers"), 1826);
  assertToStringEquals("AX", res[685].firstMatch("AX"), 1827);
  assertToStringEquals("X", res[686].firstMatch("XYZ"), 1828);
  assertToStringEquals("AX", res[686].firstMatch("AXYZ"), 1829);
  assertNull(res[686].firstMatch("x{1234}XYZ "), 1830);
  assertNull(res[686].firstMatch("** Failers"), 1831);
  assertNull(res[686].firstMatch("ABXYZ   "), 1832);
  assertToStringEquals("X", res[687].firstMatch("XYZ"), 1833);
  assertNull(res[687].firstMatch("** Failers"), 1834);
  assertToStringEquals("AX", res[687].firstMatch("AXYZ"), 1835);
  assertNull(res[687].firstMatch("x{1234}XYZ "), 1836);
  assertNull(res[687].firstMatch("ABXYZ   "), 1837);
  assertToStringEquals("AX", res[688].firstMatch("AXYZ"), 1838);
  assertNull(res[688].firstMatch("x{1234}XYZ"), 1839);
  assertNull(res[688].firstMatch("Ax{1234}XYZ"), 1840);
  assertNull(res[688].firstMatch("** Failers"), 1841);
  assertNull(res[688].firstMatch("XYZ"), 1842);
  assertNull(res[689].firstMatch("** Failers"), 1843);
  assertToStringEquals("AX", res[689].firstMatch("AXYZ"), 1844);
  assertNull(res[689].firstMatch("x{1234}XYZ"), 1845);
  assertNull(res[689].firstMatch("Ax{1234}XYZ"), 1846);
  assertNull(res[689].firstMatch("XYZ"), 1847);
  assertToStringEquals("X", res[690].firstMatch("XYZ"), 1848);
  assertToStringEquals("AX", res[690].firstMatch("AXYZ"), 1849);
  assertNull(res[690].firstMatch("x{1234}XYZ"), 1850);
  assertNull(res[690].firstMatch("Ax{1234}XYZ"), 1851);
  assertNull(res[690].firstMatch("** Failers"), 1852);
  assertToStringEquals("X", res[691].firstMatch("XYZ"), 1853);
  assertNull(res[691].firstMatch("** Failers"), 1854);
  assertToStringEquals("AX", res[691].firstMatch("AXYZ"), 1855);
  assertNull(res[691].firstMatch("x{1234}XYZ"), 1856);
  assertNull(res[691].firstMatch("Ax{1234}XYZ"), 1857);
  assertNull(res[692].firstMatch("abcdefgh"), 1858);
  assertNull(res[692].firstMatch("x{1234}\n\x0dx{3456}xyz "), 1859);
  assertNull(res[693].firstMatch("abcdefgh"), 1860);
  assertNull(res[693].firstMatch("x{1234}\n\x0dx{3456}xyz "), 1861);
  assertNull(res[694].firstMatch("** Failers"), 1862);
  assertNull(res[694].firstMatch("abcdefgh"), 1863);
  assertNull(res[694].firstMatch("x{1234}\n\x0dx{3456}xyz "), 1864);
  assertNull(res[695].firstMatch(" AXY"), 1865);
  assertNull(res[695].firstMatch(" aXY"), 1866);
  assertNull(res[695].firstMatch(" x{1c5}XY"), 1867);
  assertNull(res[695].firstMatch(" ** Failers"), 1868);
  assertNull(res[695].firstMatch(" x{1bb}XY"), 1869);
  assertNull(res[695].firstMatch(" x{2b0}XY"), 1870);
  assertNull(res[695].firstMatch(" !XY      "), 1871);
  assertNull(res[696].firstMatch(" AXY"), 1872);
  assertNull(res[696].firstMatch(" aXY"), 1873);
  assertNull(res[696].firstMatch(" x{1c5}XY"), 1874);
  assertNull(res[696].firstMatch(" ** Failers"), 1875);
  assertNull(res[696].firstMatch(" x{1bb}XY"), 1876);
  assertNull(res[696].firstMatch(" x{2b0}XY"), 1877);
  assertNull(res[696].firstMatch(" !XY      "), 1878);
  assertNull(res[696].firstMatch(" AXY"), 1879);
  assertNull(res[696].firstMatch(" aXY"), 1880);
  assertNull(res[696].firstMatch(" AbcdeXyz "), 1881);
  assertNull(res[696].firstMatch(" x{1c5}AbXY"), 1882);
  assertNull(res[696].firstMatch(" abcDEXypqreXlmn "), 1883);
  assertNull(res[696].firstMatch(" ** Failers"), 1884);
  assertNull(res[696].firstMatch(" x{1bb}XY"), 1885);
  assertNull(res[696].firstMatch(" x{2b0}XY"), 1886);
  assertNull(res[696].firstMatch(" !XY      "), 1887);
  assertNull(res[697].firstMatch(" AXY"), 1888);
  assertNull(res[697].firstMatch(" aXY"), 1889);
  assertNull(res[697].firstMatch(" AbcdeXyz "), 1890);
  assertNull(res[697].firstMatch(" x{1c5}AbXY"), 1891);
  assertNull(res[697].firstMatch(" abcDEXypqreXlmn "), 1892);
  assertNull(res[697].firstMatch(" ** Failers"), 1893);
  assertNull(res[697].firstMatch(" x{1bb}XY"), 1894);
  assertNull(res[697].firstMatch(" x{2b0}XY"), 1895);
  assertNull(res[697].firstMatch(" !XY      "), 1896);
  assertNull(res[697].firstMatch(" AXY"), 1897);
  assertNull(res[697].firstMatch(" aXY"), 1898);
  assertNull(res[697].firstMatch(" AbcdeXyz "), 1899);
  assertNull(res[697].firstMatch(" x{1c5}AbXY"), 1900);
  assertNull(res[697].firstMatch(" abcDEXypqreXlmn "), 1901);
  assertNull(res[697].firstMatch(" ** Failers"), 1902);
  assertNull(res[697].firstMatch(" x{1bb}XY"), 1903);
  assertNull(res[697].firstMatch(" x{2b0}XY"), 1904);
  assertNull(res[697].firstMatch(" !XY      "), 1905);
  assertNull(res[698].firstMatch(" AXY"), 1906);
  assertNull(res[698].firstMatch(" aXY"), 1907);
  assertNull(res[698].firstMatch(" AbcdeXyz "), 1908);
  assertNull(res[698].firstMatch(" x{1c5}AbXY"), 1909);
  assertNull(res[698].firstMatch(" abcDEXypqreXlmn "), 1910);
  assertNull(res[698].firstMatch(" ** Failers"), 1911);
  assertNull(res[698].firstMatch(" x{1bb}XY"), 1912);
  assertNull(res[698].firstMatch(" x{2b0}XY"), 1913);
  assertNull(res[698].firstMatch(" !XY      "), 1914);
  assertNull(res[699].firstMatch(" !XY"), 1915);
  assertNull(res[699].firstMatch(" x{1bb}XY"), 1916);
  assertNull(res[699].firstMatch(" x{2b0}XY"), 1917);
  assertNull(res[699].firstMatch(" ** Failers"), 1918);
  assertNull(res[699].firstMatch(" x{1c5}XY"), 1919);
  assertNull(res[699].firstMatch(" AXY      "), 1920);
  assertNull(res[700].firstMatch(" !XY"), 1921);
  assertNull(res[700].firstMatch(" x{1bb}XY"), 1922);
  assertNull(res[700].firstMatch(" x{2b0}XY"), 1923);
  assertNull(res[700].firstMatch(" ** Failers"), 1924);
  assertNull(res[700].firstMatch(" x{1c5}XY"), 1925);
  assertNull(res[700].firstMatch(" AXY      "), 1926);
  assertNull(res[701].firstMatch("\xa0!"), 1927);
  assertNull(res[701].firstMatch("AabcabcYZ    "), 1928);
  assertToStringEquals("L=abcX,L=abc,abc", res[702].firstMatch("L=abcX"), 1929);
  assertNull(res[702].firstMatch("x{c0}"), 1930);
  assertNull(res[702].firstMatch("x{e0} "), 1931);
  assertNull(res[702].firstMatch("x{c0}"), 1932);
  assertNull(res[702].firstMatch("x{e0} "), 1933);
  assertNull(res[703].firstMatch("x{1b00}x{12000}x{7c0}x{a840}x{10900}"), 1934);
  assertNull(res[706].firstMatch("123abcdefg"), 1935);
  assertNull(res[706].firstMatch("123abc\xc4\xc5zz"), 1936);
  assertNull(res[710].firstMatch("A\x80"), 1937);
  assertNull(res[725].firstMatch("x{60e} "), 1938);
  assertNull(res[725].firstMatch("x{656} "), 1939);
  assertNull(res[725].firstMatch("x{657} "), 1940);
  assertNull(res[725].firstMatch("x{658} "), 1941);
  assertNull(res[725].firstMatch("x{659} "), 1942);
  assertNull(res[725].firstMatch("x{65a} "), 1943);
  assertNull(res[725].firstMatch("x{65b} "), 1944);
  assertNull(res[725].firstMatch("x{65c} "), 1945);
  assertNull(res[725].firstMatch("x{65d} "), 1946);
  assertNull(res[725].firstMatch("x{65e} "), 1947);
  assertNull(res[725].firstMatch("x{66a} "), 1948);
  assertNull(res[725].firstMatch("x{6e9} "), 1949);
  assertNull(res[725].firstMatch("x{6ef}"), 1950);
  assertNull(res[725].firstMatch("x{6fa}  "), 1951);
  assertNull(res[725].firstMatch("** Failers"), 1952);
  assertNull(res[725].firstMatch("x{600}"), 1953);
  assertNull(res[725].firstMatch("x{650}"), 1954);
  assertNull(res[725].firstMatch("x{651}  "), 1955);
  assertNull(res[725].firstMatch("x{652}  "), 1956);
  assertNull(res[725].firstMatch("x{653}  "), 1957);
  assertNull(res[725].firstMatch("x{654} "), 1958);
  assertNull(res[725].firstMatch("x{655} "), 1959);
  assertNull(res[725].firstMatch("x{65f}  "), 1960);
  assertNull(res[726].firstMatch("x{1d2b} "), 1961);
  assertNull(res[727].firstMatch("x{589}"), 1962);
  assertNull(res[727].firstMatch("x{60c}"), 1963);
  assertNull(res[727].firstMatch("x{61f}  "), 1964);
  assertNull(res[727].firstMatch("x{964}"), 1965);
  assertNull(res[727].firstMatch("x{965}  "), 1966);
  assertNull(res[727].firstMatch("x{970}  "), 1967);
  assertNull(res[728].firstMatch("x{64b}"), 1968);
  assertNull(res[728].firstMatch("x{654}"), 1969);
  assertNull(res[728].firstMatch("x{655}"), 1970);
  assertNull(res[728].firstMatch("x{200c} "), 1971);
  assertNull(res[728].firstMatch("** Failers"), 1972);
  assertNull(res[728].firstMatch("x{64a}"), 1973);
  assertNull(res[728].firstMatch("x{656}     "), 1974);
  assertNull(res[729].firstMatch("x{10450}"), 1975);
  assertNull(res[729].firstMatch("x{1047f}"), 1976);
  assertNull(res[730].firstMatch("x{10400}"), 1977);
  assertNull(res[730].firstMatch("x{1044f}"), 1978);
  assertNull(res[731].firstMatch("x{10480}"), 1979);
  assertNull(res[731].firstMatch("x{1049d}"), 1980);
  assertNull(res[731].firstMatch("x{104a0}"), 1981);
  assertNull(res[731].firstMatch("x{104a9}"), 1982);
  assertNull(res[731].firstMatch("** Failers"), 1983);
  assertNull(res[731].firstMatch("x{1049e}"), 1984);
  assertNull(res[731].firstMatch("x{1049f}"), 1985);
  assertNull(res[731].firstMatch("x{104aa}           "), 1986);
  assertNull(res[731].firstMatch("\xe2\x80\xa8\xe2\x80\xa8"), 1987);
  assertNull(res[731].firstMatch("x{2028}x{2028}x{2028}"), 1988);
  assertNull(res[732].firstMatch("x{c0}x{e0}x{116}x{117}"), 1989);
  assertNull(res[732].firstMatch("x{c0}x{e0}x{116}x{117}"), 1990);
  assertNull(res[733].firstMatch("x{102A4}x{AA52}x{A91D}x{1C46}x{10283}x{1092E}x{1C6B}x{A93B}x{A8BF}x{1BA0}x{A50A}===="), 1991);
  assertNull(res[733].firstMatch("x{a77d}x{1d79}"), 1992);
  assertNull(res[733].firstMatch("x{1d79}x{a77d} "), 1993);
  assertNull(res[733].firstMatch("x{a77d}x{1d79}"), 1994);
  assertNull(res[733].firstMatch("** Failers "), 1995);
  assertNull(res[733].firstMatch("x{1d79}x{a77d} "), 1996);
  assertToStringEquals("AA,A", res[734].firstMatch("AA"), 1997);
  assertToStringEquals("Aa,A", res[734].firstMatch("Aa"), 1998);
  assertToStringEquals("aa,a", res[734].firstMatch("aa"), 1999);
  assertToStringEquals("aA,a", res[734].firstMatch("aA"), 2000);
  assertNull(res[734].firstMatch("x{de}x{de}"), 2001);
  assertNull(res[734].firstMatch("x{de}x{fe}"), 2002);
  assertNull(res[734].firstMatch("x{fe}x{fe}"), 2003);
  assertNull(res[734].firstMatch("x{fe}x{de}"), 2004);
  assertNull(res[734].firstMatch("x{10a}x{10a}"), 2005);
  assertNull(res[734].firstMatch("x{10a}x{10b}"), 2006);
  assertNull(res[734].firstMatch("x{10b}x{10b}"), 2007);
  assertNull(res[734].firstMatch("x{10b}x{10a}"), 2008);
  assertToStringEquals("abc", res[736].firstMatch("abc"), 2009);
  assertToStringEquals("abc", res[737].firstMatch("abc"), 2010);
  assertToStringEquals("abbbbc", res[737].firstMatch("abbbbc"), 2011);
  assertToStringEquals("ac", res[737].firstMatch("ac"), 2012);
  assertToStringEquals("abc", res[738].firstMatch("abc"), 2013);
  assertToStringEquals("abbbbbbc", res[738].firstMatch("abbbbbbc"), 2014);
  assertNull(res[738].firstMatch("*** Failers "), 2015);
  assertNull(res[738].firstMatch("ac"), 2016);
  assertNull(res[738].firstMatch("ab"), 2017);
  assertToStringEquals("a", res[739].firstMatch("a"), 2018);
  assertToStringEquals("aaaaaaaaaaaaaaaaa", res[739].firstMatch("aaaaaaaaaaaaaaaaa"), 2019);
  assertToStringEquals("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", res[739].firstMatch("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaa "), 2020);
  assertToStringEquals("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", res[739].firstMatch("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaF "), 2021);
  assertToStringEquals("a,a", res[740].firstMatch("a"), 2022);
  assertToStringEquals("a,a", res[740].firstMatch("abcd"), 2023);
  assertToStringEquals("a,a", res[740].firstMatch("african"), 2024);
  assertToStringEquals("abc", res[741].firstMatch("abcdef"), 2025);
  assertNull(res[741].firstMatch("*** Failers"), 2026);
  assertNull(res[741].firstMatch("xyzabc"), 2027);
  assertNull(res[741].firstMatch("xyz\nabc    "), 2028);
  assertToStringEquals("abc", res[742].firstMatch("abcdef"), 2029);
  assertToStringEquals("abc", res[742].firstMatch("xyz\nabc    "), 2030);
  assertNull(res[742].firstMatch("*** Failers"), 2031);
  assertNull(res[742].firstMatch("xyzabc"), 2032);
  assertNull(res[743].firstMatch("abcdef"), 2033);
  assertNull(res[743].firstMatch("*** Failers"), 2034);
  assertNull(res[743].firstMatch("xyzabc"), 2035);
  assertNull(res[743].firstMatch("xyz\nabc    "), 2036);
  assertNull(res[744].firstMatch("abcdef"), 2037);
  assertNull(res[744].firstMatch("*** Failers"), 2038);
  assertNull(res[744].firstMatch("xyzabc"), 2039);
  assertNull(res[744].firstMatch("xyz\nabc    "), 2040);
  assertNull(res[745].firstMatch("abcdef"), 2041);
  assertNull(res[745].firstMatch("xyzabc>3"), 2042);
  assertNull(res[745].firstMatch("*** Failers"), 2043);
  assertNull(res[745].firstMatch("xyzabc    "), 2044);
  assertNull(res[745].firstMatch("xyzabc>2 "), 2045);
  assertToStringEquals("x9yzz", res[746].firstMatch("x9yzz"), 2046);
  assertToStringEquals("x0y+z", res[746].firstMatch("x0y+z"), 2047);
  assertNull(res[746].firstMatch("*** Failers"), 2048);
  assertNull(res[746].firstMatch("xyz"), 2049);
  assertNull(res[746].firstMatch("xxy0z     "), 2050);
  assertToStringEquals("x yzz", res[747].firstMatch("x yzz"), 2051);
  assertToStringEquals("x y+z", res[747].firstMatch("x y+z"), 2052);
  assertNull(res[747].firstMatch("*** Failers"), 2053);
  assertNull(res[747].firstMatch("xyz"), 2054);
  assertNull(res[747].firstMatch("xxyyz"), 2055);
  assertToStringEquals("xxy+z", res[748].firstMatch("xxy+z"), 2056);
  assertNull(res[748].firstMatch("*** Failers"), 2057);
  assertNull(res[748].firstMatch("xxy0z"), 2058);
  assertNull(res[748].firstMatch("x+y+z         "), 2059);
  assertToStringEquals("x+y", res[749].firstMatch("x+y"), 2060);
  assertToStringEquals("x-y", res[749].firstMatch("x-y"), 2061);
  assertNull(res[749].firstMatch("*** Failers"), 2062);
  assertNull(res[749].firstMatch("x\ny"), 2063);
  assertToStringEquals("x+y", res[750].firstMatch("x+y"), 2064);
  assertToStringEquals("x-y", res[750].firstMatch("x-y"), 2065);
  assertNull(res[750].firstMatch("x\ny"), 2066);
  assertNull(res[750].firstMatch("a+bc+dp+q"), 2067);
  assertNull(res[750].firstMatch("a+bc\ndp+q"), 2068);
  assertNull(res[750].firstMatch("x\nyp+q "), 2069);
  assertNull(res[750].firstMatch("*** Failers "), 2070);
  assertNull(res[750].firstMatch("a\nbc\ndp+q"), 2071);
  assertNull(res[750].firstMatch("a+bc\ndp\nq"), 2072);
  assertNull(res[750].firstMatch("x\nyp\nq "), 2073);
  assertNull(res[751].firstMatch("ba0"), 2074);
  assertNull(res[751].firstMatch("*** Failers"), 2075);
  assertNull(res[751].firstMatch("ba0\n"), 2076);
  assertNull(res[751].firstMatch("ba0\ncd   "), 2077);
  assertNull(res[752].firstMatch("ba0"), 2078);
  assertNull(res[752].firstMatch("*** Failers"), 2079);
  assertNull(res[752].firstMatch("ba0\n"), 2080);
  assertNull(res[752].firstMatch("ba0\ncd   "), 2081);
  assertNull(res[753].firstMatch("ba0"), 2082);
  assertNull(res[753].firstMatch("ba0\n"), 2083);
  assertNull(res[753].firstMatch("*** Failers"), 2084);
  assertNull(res[753].firstMatch("ba0\ncd   "), 2085);
  assertNull(res[754].firstMatch("ba0"), 2086);
  assertNull(res[754].firstMatch("ba0\n"), 2087);
  assertNull(res[754].firstMatch("*** Failers"), 2088);
  assertNull(res[754].firstMatch("ba0\ncd   "), 2089);
  assertToStringEquals("a0", res[755].firstMatch("ba0"), 2090);
  assertNull(res[755].firstMatch("ba0\n"), 2091);
  assertNull(res[755].firstMatch("*** Failers"), 2092);
  assertNull(res[755].firstMatch("ba0\ncd   "), 2093);
  assertToStringEquals("a0", res[756].firstMatch("ba0"), 2094);
  assertToStringEquals("a0", res[756].firstMatch("ba0\n"), 2095);
  assertToStringEquals("a0", res[756].firstMatch("ba0\ncd   "), 2096);
  assertNull(res[756].firstMatch("*** Failers"), 2097);
  assertToStringEquals("abc", res[757].firstMatch("abc"), 2098);
  assertToStringEquals("aBc", res[757].firstMatch("aBc"), 2099);
  assertToStringEquals("ABC", res[757].firstMatch("ABC"), 2100);
  assertToStringEquals("b", res[758].firstMatch("abcd"), 2101);
  assertToStringEquals("abz", res[759].firstMatch("abz"), 2102);
  assertToStringEquals("abb", res[759].firstMatch("abbz"), 2103);
  assertToStringEquals("az", res[759].firstMatch("azz  "), 2104);
  assertToStringEquals("yz", res[760].firstMatch("ayzq"), 2105);
  assertToStringEquals("xyz", res[760].firstMatch("axyzq"), 2106);
  assertToStringEquals("xxyz", res[760].firstMatch("axxyz"), 2107);
  assertToStringEquals("xxxyz", res[760].firstMatch("axxxyzq"), 2108);
  assertToStringEquals("xxxyz", res[760].firstMatch("axxxxyzq"), 2109);
  assertNull(res[760].firstMatch("*** Failers"), 2110);
  assertNull(res[760].firstMatch("ax"), 2111);
  assertNull(res[760].firstMatch("axx     "), 2112);
  assertNull(res[760].firstMatch("  "), 2113);
  assertToStringEquals("xxxyz", res[761].firstMatch("axxxyzq"), 2114);
  assertToStringEquals("xxxyz", res[761].firstMatch("axxxxyzq"), 2115);
  assertNull(res[761].firstMatch("*** Failers"), 2116);
  assertNull(res[761].firstMatch("ax"), 2117);
  assertNull(res[761].firstMatch("axx     "), 2118);
  assertNull(res[761].firstMatch("ayzq"), 2119);
  assertNull(res[761].firstMatch("axyzq"), 2120);
  assertNull(res[761].firstMatch("axxyz"), 2121);
  assertNull(res[761].firstMatch("  "), 2122);
  assertToStringEquals("xxyz", res[762].firstMatch("axxyz"), 2123);
  assertToStringEquals("xxxyz", res[762].firstMatch("axxxyzq"), 2124);
  assertToStringEquals("xxxyz", res[762].firstMatch("axxxxyzq"), 2125);
  assertNull(res[762].firstMatch("*** Failers"), 2126);
  assertNull(res[762].firstMatch("ax"), 2127);
  assertNull(res[762].firstMatch("axx     "), 2128);
  assertNull(res[762].firstMatch("ayzq"), 2129);
  assertNull(res[762].firstMatch("axyzq"), 2130);
  assertNull(res[762].firstMatch("  "), 2131);
  assertToStringEquals("b", res[763].firstMatch("bac"), 2132);
  assertToStringEquals("bcdef", res[763].firstMatch("bcdefax"), 2133);
  assertToStringEquals("*** F", res[763].firstMatch("*** Failers"), 2134);
  assertToStringEquals("   ", res[763].firstMatch("aaaaa   "), 2135);
  assertToStringEquals("b", res[764].firstMatch("bac"), 2136);
  assertToStringEquals("bcdef", res[764].firstMatch("bcdefax"), 2137);
  assertToStringEquals("*** F", res[764].firstMatch("*** Failers"), 2138);
  assertToStringEquals("", res[764].firstMatch("aaaaa   "), 2139);
  assertToStringEquals("xyz", res[765].firstMatch("xyz"), 2140);
  assertToStringEquals("wxyz", res[765].firstMatch("awxyza"), 2141);
  assertToStringEquals("bcdef", res[765].firstMatch("abcdefa"), 2142);
  assertToStringEquals("bcdef", res[765].firstMatch("abcdefghijk"), 2143);
  assertToStringEquals("*** F", res[765].firstMatch("*** Failers"), 2144);
  assertNull(res[765].firstMatch("axya"), 2145);
  assertNull(res[765].firstMatch("axa"), 2146);
  assertToStringEquals("     ", res[765].firstMatch("aaaaa         "), 2147);
  assertToStringEquals("1234", res[766].firstMatch("1234b567"), 2148);
  assertToStringEquals("", res[766].firstMatch("xyz"), 2149);
  assertToStringEquals("a", res[767].firstMatch("a1234b567"), 2150);
  assertToStringEquals("xyz", res[767].firstMatch("xyz"), 2151);
  assertToStringEquals(" ", res[767].firstMatch(" "), 2152);
  assertToStringEquals("1234", res[768].firstMatch("ab1234c56"), 2153);
  assertNull(res[768].firstMatch("*** Failers"), 2154);
  assertNull(res[768].firstMatch("xyz"), 2155);
  assertToStringEquals("ab", res[769].firstMatch("ab123c56"), 2156);
  assertToStringEquals("*** Failers", res[769].firstMatch("*** Failers"), 2157);
  assertNull(res[769].firstMatch("789"), 2158);
  assertToStringEquals("5A", res[770].firstMatch("045ABC"), 2159);
  assertToStringEquals("A", res[770].firstMatch("ABC"), 2160);
  assertNull(res[770].firstMatch("*** Failers"), 2161);
  assertNull(res[770].firstMatch("XYZ"), 2162);
  assertToStringEquals("A", res[771].firstMatch("ABC"), 2163);
  assertToStringEquals("BA", res[771].firstMatch("BAC"), 2164);
  assertToStringEquals("A", res[771].firstMatch("9ABC             "), 2165);
  assertNull(res[771].firstMatch("*** Failers"), 2166);
  assertToStringEquals("aaaa", res[772].firstMatch("aaaa"), 2167);
  assertToStringEquals("xyz", res[773].firstMatch("xyz"), 2168);
  assertToStringEquals("ggggggggxyz", res[773].firstMatch("ggggggggxyz"), 2169);
  assertToStringEquals("abcdxyz", res[774].firstMatch("abcdxyz"), 2170);
  assertToStringEquals("axyz", res[774].firstMatch("axyz"), 2171);
  assertNull(res[774].firstMatch("*** Failers"), 2172);
  assertNull(res[774].firstMatch("xyz"), 2173);
  assertToStringEquals("xyz", res[775].firstMatch("xyz"), 2174);
  assertToStringEquals("cxyz", res[775].firstMatch("cxyz       "), 2175);
  assertToStringEquals("12X", res[776].firstMatch("12X"), 2176);
  assertToStringEquals("123X", res[776].firstMatch("123X"), 2177);
  assertNull(res[776].firstMatch("*** Failers"), 2178);
  assertNull(res[776].firstMatch("X"), 2179);
  assertNull(res[776].firstMatch("1X"), 2180);
  assertNull(res[776].firstMatch("1234X     "), 2181);
  assertToStringEquals("a4", res[777].firstMatch("a45"), 2182);
  assertToStringEquals("b9", res[777].firstMatch("b93"), 2183);
  assertToStringEquals("c9", res[777].firstMatch("c99z"), 2184);
  assertToStringEquals("d0", res[777].firstMatch("d04"), 2185);
  assertNull(res[777].firstMatch("*** Failers"), 2186);
  assertNull(res[777].firstMatch("e45"), 2187);
  assertNull(res[777].firstMatch("abcd      "), 2188);
  assertNull(res[777].firstMatch("abcd1234"), 2189);
  assertNull(res[777].firstMatch("1234  "), 2190);
  assertToStringEquals("a4", res[778].firstMatch("a45"), 2191);
  assertToStringEquals("b9", res[778].firstMatch("b93"), 2192);
  assertToStringEquals("c9", res[778].firstMatch("c99z"), 2193);
  assertToStringEquals("d0", res[778].firstMatch("d04"), 2194);
  assertToStringEquals("abcd1", res[778].firstMatch("abcd1234"), 2195);
  assertToStringEquals("1", res[778].firstMatch("1234  "), 2196);
  assertNull(res[778].firstMatch("*** Failers"), 2197);
  assertNull(res[778].firstMatch("e45"), 2198);
  assertNull(res[778].firstMatch("abcd      "), 2199);
  assertToStringEquals("a4", res[779].firstMatch("a45"), 2200);
  assertToStringEquals("b9", res[779].firstMatch("b93"), 2201);
  assertToStringEquals("c9", res[779].firstMatch("c99z"), 2202);
  assertToStringEquals("d0", res[779].firstMatch("d04"), 2203);
  assertToStringEquals("abcd1", res[779].firstMatch("abcd1234"), 2204);
  assertNull(res[779].firstMatch("*** Failers"), 2205);
  assertNull(res[779].firstMatch("1234  "), 2206);
  assertNull(res[779].firstMatch("e45"), 2207);
  assertNull(res[779].firstMatch("abcd      "), 2208);
  assertToStringEquals("aX", res[780].firstMatch("aX"), 2209);
  assertToStringEquals("aaX", res[780].firstMatch("aaX "), 2210);
  assertToStringEquals("a4", res[781].firstMatch("a45"), 2211);
  assertToStringEquals("b9", res[781].firstMatch("b93"), 2212);
  assertToStringEquals("c9", res[781].firstMatch("c99z"), 2213);
  assertToStringEquals("d0", res[781].firstMatch("d04"), 2214);
  assertToStringEquals("1", res[781].firstMatch("1234  "), 2215);
  assertNull(res[781].firstMatch("*** Failers"), 2216);
  assertNull(res[781].firstMatch("abcd1234"), 2217);
  assertNull(res[781].firstMatch("e45"), 2218);
  assertToStringEquals("ab4", res[782].firstMatch("ab45"), 2219);
  assertToStringEquals("bcd9", res[782].firstMatch("bcd93"), 2220);
  assertNull(res[782].firstMatch("*** Failers"), 2221);
  assertNull(res[782].firstMatch("1234 "), 2222);
  assertNull(res[782].firstMatch("a36 "), 2223);
  assertNull(res[782].firstMatch("abcd1234"), 2224);
  assertNull(res[782].firstMatch("ee45"), 2225);
  assertToStringEquals("abc4,abc", res[783].firstMatch("abc45"), 2226);
  assertToStringEquals("abcabcabc4,abc", res[783].firstMatch("abcabcabc45"), 2227);
  assertToStringEquals("4,", res[783].firstMatch("42xyz "), 2228);
  assertNull(res[783].firstMatch("*** Failers"), 2229);
  assertToStringEquals("abc4,abc", res[784].firstMatch("abc45"), 2230);
  assertToStringEquals("abcabcabc4,abc", res[784].firstMatch("abcabcabc45"), 2231);
  assertNull(res[784].firstMatch("*** Failers"), 2232);
  assertNull(res[784].firstMatch("42xyz "), 2233);
  assertToStringEquals("abc4,abc", res[785].firstMatch("abc45"), 2234);
  assertToStringEquals("4,", res[785].firstMatch("42xyz "), 2235);
  assertNull(res[785].firstMatch("*** Failers"), 2236);
  assertNull(res[785].firstMatch("abcabcabc45"), 2237);
  assertToStringEquals("abcabc4,abc", res[786].firstMatch("abcabc45"), 2238);
  assertToStringEquals("abcabcabc4,abc", res[786].firstMatch("abcabcabc45"), 2239);
  assertNull(res[786].firstMatch("*** Failers"), 2240);
  assertNull(res[786].firstMatch("abcabcabcabc45"), 2241);
  assertNull(res[786].firstMatch("abc45"), 2242);
  assertNull(res[786].firstMatch("42xyz "), 2243);
  assertNull(res[786].firstMatch("1abc2abc3456"), 2244);
  assertNull(res[786].firstMatch("1abc2xyz3456 "), 2245);
  assertToStringEquals("ab=ab,ab,ab", res[787].firstMatch("ab=ab"), 2246);
  assertToStringEquals("ab=ab,ab,ab", res[787].firstMatch("ab=ab"), 2247);
  assertNull(res[787].firstMatch("abc"), 2248);
  assertNull(res[787].firstMatch("a(b)c"), 2249);
  assertNull(res[787].firstMatch("a(b(c))d  "), 2250);
  assertNull(res[787].firstMatch("*** Failers)"), 2251);
  assertNull(res[787].firstMatch("a(b(c)d  "), 2252);
  assertNull(res[787].firstMatch(">abc>123<xyz<"), 2253);
  assertNull(res[787].firstMatch(">abc>1(2)3<xyz<"), 2254);
  assertNull(res[787].firstMatch(">abc>(1(2)3)<xyz<"), 2255);
  assertNull(res[787].firstMatch("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa9876"), 2256);
  assertNull(res[787].firstMatch("*** Failers "), 2257);
  assertNull(res[787].firstMatch("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"), 2258);
  assertNull(res[787].firstMatch("<>"), 2259);
  assertNull(res[787].firstMatch("<abcd>"), 2260);
  assertNull(res[787].firstMatch("<abc <123> hij>"), 2261);
  assertNull(res[787].firstMatch("<abc <def> hij>"), 2262);
  assertNull(res[787].firstMatch("<abc<>def> "), 2263);
  assertNull(res[787].firstMatch("<abc<>      "), 2264);
  assertNull(res[787].firstMatch("*** Failers"), 2265);
  assertNull(res[787].firstMatch("<abc"), 2266);
  assertNull(res[787].firstMatch("abc:                          "), 2267);
  assertNull(res[787].firstMatch("12                             "), 2268);
  assertNull(res[787].firstMatch("*** Failers                     "), 2269);
  assertNull(res[787].firstMatch("123                       "), 2270);
  assertNull(res[787].firstMatch("xyz                        "), 2271);
  assertNull(res[787].firstMatch("                            "), 2272);
  assertNull(res[787].firstMatch("abc:                        "), 2273);
  assertNull(res[787].firstMatch("12         "), 2274);
  assertNull(res[787].firstMatch("*** Failers"), 2275);
  assertNull(res[787].firstMatch("123"), 2276);
  assertNull(res[787].firstMatch("xyz    "), 2277);
  assertNull(res[788].firstMatch("abcde:                          "), 2278);
  assertNull(res[788].firstMatch("*** Failers                     "), 2279);
  assertNull(res[788].firstMatch("abc.. "), 2280);
  assertNull(res[788].firstMatch("123                       "), 2281);
  assertNull(res[788].firstMatch("vwxyz                        "), 2282);
  assertNull(res[788].firstMatch("                            "), 2283);
  assertNull(res[789].firstMatch("12         "), 2284);
  assertNull(res[789].firstMatch("*** Failers"), 2285);
  assertNull(res[789].firstMatch("abcde:"), 2286);
  assertNull(res[789].firstMatch("abc..  "), 2287);
  assertNull(res[789].firstMatch("123"), 2288);
  assertNull(res[789].firstMatch("vwxyz    "), 2289);
  assertNull(res[789].firstMatch("abc12345"), 2290);
  assertNull(res[789].firstMatch("wxy123z"), 2291);
  assertNull(res[789].firstMatch("*** Failers"), 2292);
  assertNull(res[789].firstMatch("123abc"), 2293);
  assertNull(res[789].firstMatch("123abc"), 2294);
  assertNull(res[789].firstMatch("mno123456 "), 2295);
  assertNull(res[789].firstMatch("*** Failers"), 2296);
  assertNull(res[789].firstMatch("abc12345"), 2297);
  assertNull(res[789].firstMatch("wxy123z"), 2298);
  assertNull(res[789].firstMatch("abcxyz"), 2299);
  assertNull(res[789].firstMatch("123abcxyz999 "), 2300);
  assertToStringEquals("abc", res[791].firstMatch("abcdef"), 2301);
  assertNull(res[791].firstMatch("*** Failers"), 2302);
  assertToStringEquals("abc", res[791].firstMatch("abcdefB  "), 2303);
  assertToStringEquals(",", res[792].firstMatch("bcd"), 2304);
  assertToStringEquals("aaa,aaa", res[792].firstMatch("aaabcd"), 2305);
  assertToStringEquals(",", res[792].firstMatch("xyz"), 2306);
  assertToStringEquals(",", res[792].firstMatch("xyzN  "), 2307);
  assertToStringEquals(",", res[792].firstMatch("*** Failers"), 2308);
  assertToStringEquals(",", res[792].firstMatch("bcdN   "), 2309);
  assertToStringEquals("xyz", res[793].firstMatch("xyz"), 2310);
  assertNull(res[793].firstMatch("xyz\n"), 2311);
  assertNull(res[793].firstMatch("*** Failers"), 2312);
  assertNull(res[793].firstMatch("xyzZ"), 2313);
  assertNull(res[793].firstMatch("xyz\nZ    "), 2314);
  assertToStringEquals("xyz", res[794].firstMatch("xyz"), 2315);
  assertToStringEquals("xyz", res[794].firstMatch("xyz\n "), 2316);
  assertToStringEquals("xyz", res[794].firstMatch("abcxyz\npqr "), 2317);
  assertToStringEquals("xyz", res[794].firstMatch("abcxyz\npqrZ "), 2318);
  assertToStringEquals("xyz", res[794].firstMatch("xyz\nZ    "), 2319);
  assertNull(res[794].firstMatch("*** Failers"), 2320);
  assertNull(res[794].firstMatch("xyzZ"), 2321);
  assertNull(res[795].firstMatch("abcdef"), 2322);
  assertNull(res[795].firstMatch("defabcxyz>3 "), 2323);
  assertNull(res[795].firstMatch("*** Failers "), 2324);
  assertNull(res[795].firstMatch("defabcxyz"), 2325);
  assertNull(res[796].firstMatch("abP"), 2326);
  assertNull(res[796].firstMatch("abcdeP"), 2327);
  assertToStringEquals("abcdef", res[796].firstMatch("abcdefP"), 2328);
  assertNull(res[796].firstMatch("*** Failers"), 2329);
  assertNull(res[796].firstMatch("abxP    "), 2330);
  assertNull(res[797].firstMatch("aP"), 2331);
  assertNull(res[797].firstMatch("aaP"), 2332);
  assertNull(res[797].firstMatch("aa2P "), 2333);
  assertNull(res[797].firstMatch("aaaP"), 2334);
  assertNull(res[797].firstMatch("aaa23P "), 2335);
  assertNull(res[797].firstMatch("aaaa12345P"), 2336);
  assertToStringEquals("aa0z", res[797].firstMatch("aa0zP"), 2337);
  assertToStringEquals("aaaa4444444444444z", res[797].firstMatch("aaaa4444444444444zP "), 2338);
  assertNull(res[797].firstMatch("*** Failers"), 2339);
  assertNull(res[797].firstMatch("azP "), 2340);
  assertNull(res[797].firstMatch("aaaaaP "), 2341);
  assertNull(res[797].firstMatch("a56P "), 2342);
  assertNull(res[799].firstMatch("adfadadaklhlkalkajhlkjahdfasdfasdfladsfjkjPZ"), 2343);
  assertNull(res[799].firstMatch("lkjhlkjhlkjhlkjhabbbbbbcdaefabbbbbbbefaPBZ"), 2344);
  assertNull(res[799].firstMatch("cdabbbbbbbbPRBZ"), 2345);
  assertNull(res[799].firstMatch("efabbbbbbbbbbbbbbbbPRBZ"), 2346);
  assertNull(res[799].firstMatch("bbbbbbbbbbbbcdXyasdfadfPRBZ    "), 2347);
  assertNull(res[799].firstMatch("abc"), 2348);
  assertNull(res[799].firstMatch("** Failers"), 2349);
  assertNull(res[799].firstMatch("def  "), 2350);
  assertToStringEquals("the quick brown fox", res[800].firstMatch("the quick brown fox"), 2351);
  assertNull(res[800].firstMatch("The quick brown FOX"), 2352);
  assertToStringEquals("the quick brown fox", res[800].firstMatch("What do you know about the quick brown fox?"), 2353);
  assertNull(res[800].firstMatch("What do you know about THE QUICK BROWN FOX?"), 2354);
  assertToStringEquals("the quick brown fox", res[801].firstMatch("the quick brown fox"), 2355);
  assertToStringEquals("The quick brown FOX", res[801].firstMatch("The quick brown FOX"), 2356);
  assertToStringEquals("the quick brown fox", res[801].firstMatch("What do you know about the quick brown fox?"), 2357);
  assertToStringEquals("THE QUICK BROWN FOX", res[801].firstMatch("What do you know about THE QUICK BROWN FOX?"), 2358);
  assertToStringEquals("abcd\x09\n\x0d\x0cae9;\$\\?caxyz", res[802].firstMatch("abcd\x09\n\x0d\x0cae9;\$\\?caxyz"), 2359);
  assertToStringEquals("abxyzpqrrrabbxyyyypqAzz", res[803].firstMatch("abxyzpqrrrabbxyyyypqAzz"), 2360);
  assertToStringEquals("abxyzpqrrrabbxyyyypqAzz", res[803].firstMatch("abxyzpqrrrabbxyyyypqAzz"), 2361);
  assertToStringEquals("aabxyzpqrrrabbxyyyypqAzz", res[803].firstMatch("aabxyzpqrrrabbxyyyypqAzz"), 2362);
  assertToStringEquals("aaabxyzpqrrrabbxyyyypqAzz", res[803].firstMatch("aaabxyzpqrrrabbxyyyypqAzz"), 2363);
  assertToStringEquals("aaaabxyzpqrrrabbxyyyypqAzz", res[803].firstMatch("aaaabxyzpqrrrabbxyyyypqAzz"), 2364);
  assertToStringEquals("abcxyzpqrrrabbxyyyypqAzz", res[803].firstMatch("abcxyzpqrrrabbxyyyypqAzz"), 2365);
  assertToStringEquals("aabcxyzpqrrrabbxyyyypqAzz", res[803].firstMatch("aabcxyzpqrrrabbxyyyypqAzz"), 2366);
  assertToStringEquals("aaabcxyzpqrrrabbxyyyypAzz", res[803].firstMatch("aaabcxyzpqrrrabbxyyyypAzz"), 2367);
  assertToStringEquals("aaabcxyzpqrrrabbxyyyypqAzz", res[803].firstMatch("aaabcxyzpqrrrabbxyyyypqAzz"), 2368);
  assertToStringEquals("aaabcxyzpqrrrabbxyyyypqqAzz", res[803].firstMatch("aaabcxyzpqrrrabbxyyyypqqAzz"), 2369);
  assertToStringEquals("aaabcxyzpqrrrabbxyyyypqqqAzz", res[803].firstMatch("aaabcxyzpqrrrabbxyyyypqqqAzz"), 2370);
  assertToStringEquals("aaabcxyzpqrrrabbxyyyypqqqqAzz", res[803].firstMatch("aaabcxyzpqrrrabbxyyyypqqqqAzz"), 2371);
  assertToStringEquals("aaabcxyzpqrrrabbxyyyypqqqqqAzz", res[803].firstMatch("aaabcxyzpqrrrabbxyyyypqqqqqAzz"), 2372);
  assertToStringEquals("aaabcxyzpqrrrabbxyyyypqqqqqqAzz", res[803].firstMatch("aaabcxyzpqrrrabbxyyyypqqqqqqAzz"), 2373);
  assertToStringEquals("aaaabcxyzpqrrrabbxyyyypqAzz", res[803].firstMatch("aaaabcxyzpqrrrabbxyyyypqAzz"), 2374);
  assertToStringEquals("abxyzzpqrrrabbxyyyypqAzz", res[803].firstMatch("abxyzzpqrrrabbxyyyypqAzz"), 2375);
  assertToStringEquals("aabxyzzzpqrrrabbxyyyypqAzz", res[803].firstMatch("aabxyzzzpqrrrabbxyyyypqAzz"), 2376);
  assertToStringEquals("aaabxyzzzzpqrrrabbxyyyypqAzz", res[803].firstMatch("aaabxyzzzzpqrrrabbxyyyypqAzz"), 2377);
  assertToStringEquals("aaaabxyzzzzpqrrrabbxyyyypqAzz", res[803].firstMatch("aaaabxyzzzzpqrrrabbxyyyypqAzz"), 2378);
  assertToStringEquals("abcxyzzpqrrrabbxyyyypqAzz", res[803].firstMatch("abcxyzzpqrrrabbxyyyypqAzz"), 2379);
  assertToStringEquals("aabcxyzzzpqrrrabbxyyyypqAzz", res[803].firstMatch("aabcxyzzzpqrrrabbxyyyypqAzz"), 2380);
  assertToStringEquals("aaabcxyzzzzpqrrrabbxyyyypqAzz", res[803].firstMatch("aaabcxyzzzzpqrrrabbxyyyypqAzz"), 2381);
  assertToStringEquals("aaaabcxyzzzzpqrrrabbxyyyypqAzz", res[803].firstMatch("aaaabcxyzzzzpqrrrabbxyyyypqAzz"), 2382);
  assertToStringEquals("aaaabcxyzzzzpqrrrabbbxyyyypqAzz", res[803].firstMatch("aaaabcxyzzzzpqrrrabbbxyyyypqAzz"), 2383);
  assertToStringEquals("aaaabcxyzzzzpqrrrabbbxyyyyypqAzz", res[803].firstMatch("aaaabcxyzzzzpqrrrabbbxyyyyypqAzz"), 2384);
  assertToStringEquals("aaabcxyzpqrrrabbxyyyypABzz", res[803].firstMatch("aaabcxyzpqrrrabbxyyyypABzz"), 2385);
  assertToStringEquals("aaabcxyzpqrrrabbxyyyypABBzz", res[803].firstMatch("aaabcxyzpqrrrabbxyyyypABBzz"), 2386);
  assertToStringEquals("aaabxyzpqrrrabbxyyyypqAzz", res[803].firstMatch(">>>aaabxyzpqrrrabbxyyyypqAzz"), 2387);
  assertToStringEquals("aaaabxyzpqrrrabbxyyyypqAzz", res[803].firstMatch(">aaaabxyzpqrrrabbxyyyypqAzz"), 2388);
  assertToStringEquals("abcxyzpqrrrabbxyyyypqAzz", res[803].firstMatch(">>>>abcxyzpqrrrabbxyyyypqAzz"), 2389);
  assertNull(res[803].firstMatch("*** Failers"), 2390);
  assertNull(res[803].firstMatch("abxyzpqrrabbxyyyypqAzz"), 2391);
  assertNull(res[803].firstMatch("abxyzpqrrrrabbxyyyypqAzz"), 2392);
  assertNull(res[803].firstMatch("abxyzpqrrrabxyyyypqAzz"), 2393);
  assertNull(res[803].firstMatch("aaaabcxyzzzzpqrrrabbbxyyyyyypqAzz"), 2394);
  assertNull(res[803].firstMatch("aaaabcxyzzzzpqrrrabbbxyyypqAzz"), 2395);
  assertNull(res[803].firstMatch("aaabcxyzpqrrrabbxyyyypqqqqqqqAzz"), 2396);
  assertToStringEquals("abczz,abc", res[804].firstMatch("abczz"), 2397);
  assertToStringEquals("abcabczz,abc", res[804].firstMatch("abcabczz"), 2398);
  assertNull(res[804].firstMatch("*** Failers"), 2399);
  assertNull(res[804].firstMatch("zz"), 2400);
  assertNull(res[804].firstMatch("abcabcabczz"), 2401);
  assertNull(res[804].firstMatch(">>abczz"), 2402);
  assertToStringEquals("bc,b", res[805].firstMatch("bc"), 2403);
  assertToStringEquals("bbc,b", res[805].firstMatch("bbc"), 2404);
  assertToStringEquals("bbbc,bb", res[805].firstMatch("bbbc"), 2405);
  assertToStringEquals("bac,a", res[805].firstMatch("bac"), 2406);
  assertToStringEquals("bbac,a", res[805].firstMatch("bbac"), 2407);
  assertToStringEquals("aac,a", res[805].firstMatch("aac"), 2408);
  assertToStringEquals("abbbbbbbbbbbc,bbbbbbbbbbb", res[805].firstMatch("abbbbbbbbbbbc"), 2409);
  assertToStringEquals("bbbbbbbbbbbac,a", res[805].firstMatch("bbbbbbbbbbbac"), 2410);
  assertNull(res[805].firstMatch("*** Failers"), 2411);
  assertNull(res[805].firstMatch("aaac"), 2412);
  assertNull(res[805].firstMatch("abbbbbbbbbbbac"), 2413);
  assertToStringEquals("bc,b", res[806].firstMatch("bc"), 2414);
  assertToStringEquals("bbc,bb", res[806].firstMatch("bbc"), 2415);
  assertToStringEquals("bbbc,bbb", res[806].firstMatch("bbbc"), 2416);
  assertToStringEquals("bac,a", res[806].firstMatch("bac"), 2417);
  assertToStringEquals("bbac,a", res[806].firstMatch("bbac"), 2418);
  assertToStringEquals("aac,a", res[806].firstMatch("aac"), 2419);
  assertToStringEquals("abbbbbbbbbbbc,bbbbbbbbbbb", res[806].firstMatch("abbbbbbbbbbbc"), 2420);
  assertToStringEquals("bbbbbbbbbbbac,a", res[806].firstMatch("bbbbbbbbbbbac"), 2421);
  assertNull(res[806].firstMatch("*** Failers"), 2422);
  assertNull(res[806].firstMatch("aaac"), 2423);
  assertNull(res[806].firstMatch("abbbbbbbbbbbac"), 2424);
  assertToStringEquals("bbc,bb", res[806].firstMatch("bbc"), 2425);
  assertToStringEquals("babc,ba", res[807].firstMatch("babc"), 2426);
  assertToStringEquals("bbabc,ba", res[807].firstMatch("bbabc"), 2427);
  assertToStringEquals("bababc,ba", res[807].firstMatch("bababc"), 2428);
  assertNull(res[807].firstMatch("*** Failers"), 2429);
  assertNull(res[807].firstMatch("bababbc"), 2430);
  assertNull(res[807].firstMatch("babababc"), 2431);
  assertToStringEquals("babc,ba", res[808].firstMatch("babc"), 2432);
  assertToStringEquals("bbabc,ba", res[808].firstMatch("bbabc"), 2433);
  assertToStringEquals("bababc,ba", res[808].firstMatch("bababc"), 2434);
  assertNull(res[808].firstMatch("*** Failers"), 2435);
  assertNull(res[808].firstMatch("bababbc"), 2436);
  assertNull(res[808].firstMatch("babababc"), 2437);
  assertThrows(() => new RegExp(r"^\\ca\\cA\\c[\\c{\\c:"), 2438);
  assertNull(res[808].firstMatch("\x01\x01e;z"), 2439);
  assertToStringEquals("a", res[809].firstMatch("athing"), 2440);
  assertToStringEquals("b", res[809].firstMatch("bthing"), 2441);
  assertToStringEquals("]", res[809].firstMatch("]thing"), 2442);
  assertToStringEquals("c", res[809].firstMatch("cthing"), 2443);
  assertToStringEquals("d", res[809].firstMatch("dthing"), 2444);
  assertToStringEquals("e", res[809].firstMatch("ething"), 2445);
  assertNull(res[809].firstMatch("*** Failers"), 2446);
  assertNull(res[809].firstMatch("fthing"), 2447);
  assertNull(res[809].firstMatch("[thing"), 2448);
  assertNull(res[809].firstMatch("\\thing"), 2449);
  assertNull(res[810].firstMatch("]thing"), 2450);
  assertNull(res[810].firstMatch("cthing"), 2451);
  assertNull(res[810].firstMatch("dthing"), 2452);
  assertNull(res[810].firstMatch("ething"), 2453);
  assertNull(res[810].firstMatch("*** Failers"), 2454);
  assertNull(res[810].firstMatch("athing"), 2455);
  assertNull(res[810].firstMatch("fthing"), 2456);
  assertToStringEquals("f", res[811].firstMatch("fthing"), 2457);
  assertToStringEquals("[", res[811].firstMatch("[thing"), 2458);
  assertToStringEquals("\\", res[811].firstMatch("\\thing"), 2459);
  assertToStringEquals("*", res[811].firstMatch("*** Failers"), 2460);
  assertNull(res[811].firstMatch("athing"), 2461);
  assertNull(res[811].firstMatch("bthing"), 2462);
  assertNull(res[811].firstMatch("]thing"), 2463);
  assertNull(res[811].firstMatch("cthing"), 2464);
  assertNull(res[811].firstMatch("dthing"), 2465);
  assertNull(res[811].firstMatch("ething"), 2466);
  assertNull(res[812].firstMatch("athing"), 2467);
  assertNull(res[812].firstMatch("fthing"), 2468);
  assertNull(res[812].firstMatch("*** Failers"), 2469);
  assertNull(res[812].firstMatch("]thing"), 2470);
  assertNull(res[812].firstMatch("cthing"), 2471);
  assertNull(res[812].firstMatch("dthing"), 2472);
  assertNull(res[812].firstMatch("ething"), 2473);
  assertNull(res[812].firstMatch("\ufffd"), 2474);
  assertNull(res[812].firstMatch("\ufffd"), 2475);
  assertToStringEquals("0", res[813].firstMatch("0"), 2476);
  assertToStringEquals("1", res[813].firstMatch("1"), 2477);
  assertToStringEquals("2", res[813].firstMatch("2"), 2478);
  assertToStringEquals("3", res[813].firstMatch("3"), 2479);
  assertToStringEquals("4", res[813].firstMatch("4"), 2480);
  assertToStringEquals("5", res[813].firstMatch("5"), 2481);
  assertToStringEquals("6", res[813].firstMatch("6"), 2482);
  assertToStringEquals("7", res[813].firstMatch("7"), 2483);
  assertToStringEquals("8", res[813].firstMatch("8"), 2484);
  assertToStringEquals("9", res[813].firstMatch("9"), 2485);
  assertToStringEquals("10", res[813].firstMatch("10"), 2486);
  assertToStringEquals("100", res[813].firstMatch("100"), 2487);
  assertNull(res[813].firstMatch("*** Failers"), 2488);
  assertNull(res[813].firstMatch("abc"), 2489);
  assertToStringEquals("enter", res[814].firstMatch("enter"), 2490);
  assertToStringEquals("inter", res[814].firstMatch("inter"), 2491);
  assertToStringEquals("uponter", res[814].firstMatch("uponter"), 2492);
  assertToStringEquals("xxx0", res[815].firstMatch("xxx0"), 2493);
  assertToStringEquals("xxx1234", res[815].firstMatch("xxx1234"), 2494);
  assertNull(res[815].firstMatch("*** Failers"), 2495);
  assertNull(res[815].firstMatch("xxx"), 2496);
  assertToStringEquals("x123", res[816].firstMatch("x123"), 2497);
  assertToStringEquals("xx123", res[816].firstMatch("xx123"), 2498);
  assertToStringEquals("123456", res[816].firstMatch("123456"), 2499);
  assertNull(res[816].firstMatch("*** Failers"), 2500);
  assertNull(res[816].firstMatch("123"), 2501);
  assertToStringEquals("x1234", res[816].firstMatch("x1234"), 2502);
  assertToStringEquals("x123", res[817].firstMatch("x123"), 2503);
  assertToStringEquals("xx123", res[817].firstMatch("xx123"), 2504);
  assertToStringEquals("123456", res[817].firstMatch("123456"), 2505);
  assertNull(res[817].firstMatch("*** Failers"), 2506);
  assertNull(res[817].firstMatch("123"), 2507);
  assertToStringEquals("x1234", res[817].firstMatch("x1234"), 2508);
  assertToStringEquals("abc!pqr=apquxz.ixr.zzz.ac.uk,abc,pqr", res[818].firstMatch("abc!pqr=apquxz.ixr.zzz.ac.uk"), 2509);
  assertNull(res[818].firstMatch("*** Failers"), 2510);
  assertNull(res[818].firstMatch("!pqr=apquxz.ixr.zzz.ac.uk"), 2511);
  assertNull(res[818].firstMatch("abc!=apquxz.ixr.zzz.ac.uk"), 2512);
  assertNull(res[818].firstMatch("abc!pqr=apquxz:ixr.zzz.ac.uk"), 2513);
  assertNull(res[818].firstMatch("abc!pqr=apquxz.ixr.zzz.ac.ukk"), 2514);
  assertToStringEquals(":", res[819].firstMatch("Well, we need a colon: somewhere"), 2515);
  assertNull(res[819].firstMatch("*** Fail if we don't"), 2516);
  assertToStringEquals("0abc,0abc", res[820].firstMatch("0abc"), 2517);
  assertToStringEquals("abc,abc", res[820].firstMatch("abc"), 2518);
  assertToStringEquals("fed,fed", res[820].firstMatch("fed"), 2519);
  assertToStringEquals("E,E", res[820].firstMatch("E"), 2520);
  assertToStringEquals("::,::", res[820].firstMatch("::"), 2521);
  assertToStringEquals("5f03:12C0::932e,5f03:12C0::932e", res[820].firstMatch("5f03:12C0::932e"), 2522);
  assertToStringEquals("def,def", res[820].firstMatch("fed def"), 2523);
  assertToStringEquals("ff,ff", res[820].firstMatch("Any old stuff"), 2524);
  assertNull(res[820].firstMatch("*** Failers"), 2525);
  assertNull(res[820].firstMatch("0zzz"), 2526);
  assertNull(res[820].firstMatch("gzzz"), 2527);
  assertNull(res[820].firstMatch("fed "), 2528);
  assertNull(res[820].firstMatch("Any old rubbish"), 2529);
  assertToStringEquals(".1.2.3,1,2,3", res[821].firstMatch(".1.2.3"), 2530);
  assertToStringEquals("A.12.123.0,12,123,0", res[821].firstMatch("A.12.123.0"), 2531);
  assertNull(res[821].firstMatch("*** Failers"), 2532);
  assertNull(res[821].firstMatch(".1.2.3333"), 2533);
  assertNull(res[821].firstMatch("1.2.3"), 2534);
  assertNull(res[821].firstMatch("1234.2.3"), 2535);
  assertToStringEquals("1 IN SOA non-sp1 non-sp2(,1,non-sp1,non-sp2", res[822].firstMatch("1 IN SOA non-sp1 non-sp2("), 2536);
  assertToStringEquals("1    IN    SOA    non-sp1    non-sp2   (,1,non-sp1,non-sp2", res[822].firstMatch("1    IN    SOA    non-sp1    non-sp2   ("), 2537);
  assertNull(res[822].firstMatch("*** Failers"), 2538);
  assertNull(res[822].firstMatch("1IN SOA non-sp1 non-sp2("), 2539);
  assertToStringEquals("a.,", res[823].firstMatch("a."), 2540);
  assertToStringEquals("Z.,", res[823].firstMatch("Z."), 2541);
  assertToStringEquals("2.,", res[823].firstMatch("2."), 2542);
  assertToStringEquals("ab-c.pq-r.,.pq-r", res[823].firstMatch("ab-c.pq-r."), 2543);
  assertToStringEquals("sxk.zzz.ac.uk.,.uk", res[823].firstMatch("sxk.zzz.ac.uk."), 2544);
  assertToStringEquals("x-.y-.,.y-", res[823].firstMatch("x-.y-."), 2545);
  assertNull(res[823].firstMatch("*** Failers"), 2546);
  assertNull(res[823].firstMatch("-abc.peq."), 2547);
  assertToStringEquals("*.a,,,", res[824].firstMatch("*.a"), 2548);
  assertToStringEquals("*.b0-a,0-a,,", res[824].firstMatch("*.b0-a"), 2549);
  assertToStringEquals("*.c3-b.c,3-b,.c,", res[824].firstMatch("*.c3-b.c"), 2550);
  assertToStringEquals("*.c-a.b-c,-a,.b-c,-c", res[824].firstMatch("*.c-a.b-c"), 2551);
  assertNull(res[824].firstMatch("*** Failers"), 2552);
  assertNull(res[824].firstMatch("*.0"), 2553);
  assertNull(res[824].firstMatch("*.a-"), 2554);
  assertNull(res[824].firstMatch("*.a-b.c-"), 2555);
  assertNull(res[824].firstMatch("*.c-a.0-c"), 2556);
  assertToStringEquals("abde,de,abd,e", res[825].firstMatch("abde"), 2557);
  assertToStringEquals("abdf,,abd,f", res[826].firstMatch("abdf"), 2558);
  assertToStringEquals("ab,abcd,cd,ab", res[827].firstMatch("abcd"), 2559);
  assertToStringEquals("a.b.c.d,.d", res[828].firstMatch("a.b.c.d"), 2560);
  assertToStringEquals("A.B.C.D,.D", res[828].firstMatch("A.B.C.D"), 2561);
  assertToStringEquals("a.b.c.1.2.3.C,.C", res[828].firstMatch("a.b.c.1.2.3.C"), 2562);
  assertToStringEquals("\"1234\",", res[829].firstMatch("\"1234\""), 2563);
  assertToStringEquals("\"abcd\" ;,;", res[829].firstMatch("\"abcd\" ;"), 2564);
  assertToStringEquals("\"\" ; rhubarb,; rhubarb", res[829].firstMatch("\"\" ; rhubarb"), 2565);
  assertNull(res[829].firstMatch("*** Failers"), 2566);
  assertNull(res[829].firstMatch("\"1234\" : things"), 2567);
  assertNull(res[830].firstMatch("\\"), 2568);
  assertNull(res[830].firstMatch("*** Failers"), 2569);
  assertToStringEquals("ab c", res[831].firstMatch("ab c"), 2570);
  assertNull(res[831].firstMatch("*** Failers"), 2571);
  assertNull(res[831].firstMatch("abc"), 2572);
  assertNull(res[831].firstMatch("ab cde"), 2573);
  assertToStringEquals("ab c", res[831].firstMatch("ab c"), 2574);
  assertNull(res[831].firstMatch("*** Failers"), 2575);
  assertNull(res[831].firstMatch("abc"), 2576);
  assertNull(res[831].firstMatch("ab cde"), 2577);
  assertToStringEquals("a bcd", res[832].firstMatch("a bcd"), 2578);
  assertNull(res[832].firstMatch("a b d"), 2579);
  assertNull(res[832].firstMatch("*** Failers"), 2580);
  assertNull(res[832].firstMatch("abcd"), 2581);
  assertNull(res[832].firstMatch("ab d"), 2582);
  assertToStringEquals("abcdefhijklm,abc,bc,c,def,ef,f,hij,ij,j,klm,lm,m", res[833].firstMatch("abcdefhijklm"), 2583);
  assertToStringEquals("abcdefhijklm,bc,c,ef,f,ij,j,lm,m", res[834].firstMatch("abcdefhijklm"), 2584);
  assertNull(res[835].firstMatch("a+ Z0+\x08\n\x1d\x12"), 2585);
  assertNull(res[835].firstMatch(".^\$(*+)|{?,?}"), 2586);
  assertToStringEquals("z", res[836].firstMatch("z"), 2587);
  assertToStringEquals("az", res[836].firstMatch("az"), 2588);
  assertToStringEquals("aaaz", res[836].firstMatch("aaaz"), 2589);
  assertToStringEquals("a", res[836].firstMatch("a"), 2590);
  assertToStringEquals("aa", res[836].firstMatch("aa"), 2591);
  assertToStringEquals("aaaa", res[836].firstMatch("aaaa"), 2592);
  assertToStringEquals("a", res[836].firstMatch("a+"), 2593);
  assertToStringEquals("aa", res[836].firstMatch("aa+"), 2594);
  assertToStringEquals("z", res[837].firstMatch("z"), 2595);
  assertToStringEquals("a", res[837].firstMatch("az"), 2596);
  assertToStringEquals("a", res[837].firstMatch("aaaz"), 2597);
  assertToStringEquals("a", res[837].firstMatch("a"), 2598);
  assertToStringEquals("a", res[837].firstMatch("aa"), 2599);
  assertToStringEquals("a", res[837].firstMatch("aaaa"), 2600);
  assertToStringEquals("a", res[837].firstMatch("a+"), 2601);
  assertToStringEquals("a", res[837].firstMatch("aa+"), 2602);
  assertToStringEquals("az", res[838].firstMatch("az"), 2603);
  assertToStringEquals("aaaz", res[838].firstMatch("aaaz"), 2604);
  assertToStringEquals("aa", res[838].firstMatch("aa"), 2605);
  assertToStringEquals("aaaa", res[838].firstMatch("aaaa"), 2606);
  assertToStringEquals("aa", res[838].firstMatch("aa+"), 2607);
  assertToStringEquals("az", res[839].firstMatch("az"), 2608);
  assertToStringEquals("aa", res[839].firstMatch("aaaz"), 2609);
  assertToStringEquals("aa", res[839].firstMatch("aa"), 2610);
  assertToStringEquals("aa", res[839].firstMatch("aaaa"), 2611);
  assertToStringEquals("aa", res[839].firstMatch("aa+"), 2612);
  assertToStringEquals("1234567890", res[840].firstMatch("1234567890"), 2613);
  assertToStringEquals("12345678ab", res[840].firstMatch("12345678ab"), 2614);
  assertToStringEquals("12345678__", res[840].firstMatch("12345678__"), 2615);
  assertNull(res[840].firstMatch("*** Failers"), 2616);
  assertNull(res[840].firstMatch("1234567"), 2617);
  assertToStringEquals("uoie", res[841].firstMatch("uoie"), 2618);
  assertToStringEquals("1234", res[841].firstMatch("1234"), 2619);
  assertToStringEquals("12345", res[841].firstMatch("12345"), 2620);
  assertToStringEquals("aaaaa", res[841].firstMatch("aaaaa"), 2621);
  assertNull(res[841].firstMatch("*** Failers"), 2622);
  assertNull(res[841].firstMatch("123456"), 2623);
  assertToStringEquals("uoie", res[842].firstMatch("uoie"), 2624);
  assertToStringEquals("1234", res[842].firstMatch("1234"), 2625);
  assertToStringEquals("1234", res[842].firstMatch("12345"), 2626);
  assertToStringEquals("aaaa", res[842].firstMatch("aaaaa"), 2627);
  assertToStringEquals("1234", res[842].firstMatch("123456"), 2628);
  assertToStringEquals("From abcd  Mon Sep 01 12:33,abcd", res[843].firstMatch("From abcd  Mon Sep 01 12:33:02 1997"), 2629);
  assertToStringEquals("From abcd  Mon Sep 01 12:33,Sep ", res[844].firstMatch("From abcd  Mon Sep 01 12:33:02 1997"), 2630);
  assertToStringEquals("From abcd  Mon Sep  1 12:33,Sep  ", res[844].firstMatch("From abcd  Mon Sep  1 12:33:02 1997"), 2631);
  assertNull(res[844].firstMatch("*** Failers"), 2632);
  assertNull(res[844].firstMatch("From abcd  Sep 01 12:33:02 1997"), 2633);
  assertNull(res[845].firstMatch("12\n34"), 2634);
  assertNull(res[845].firstMatch("12\x0d34"), 2635);
  assertToStringEquals("brown", res[846].firstMatch("the quick brown\x09 fox"), 2636);
  assertToStringEquals("foolish see?,lish see?", res[847].firstMatch("foobar is foolish see?"), 2637);
  assertToStringEquals("rowbar etc, etc", res[848].firstMatch("foobar crowbar etc"), 2638);
  assertToStringEquals("barrel,rel", res[848].firstMatch("barrel"), 2639);
  assertToStringEquals("2barrel,rel", res[848].firstMatch("2barrel"), 2640);
  assertToStringEquals("A barrel,rel", res[848].firstMatch("A barrel"), 2641);
  assertToStringEquals("abc,abc", res[849].firstMatch("abc456"), 2642);
  assertNull(res[849].firstMatch("*** Failers"), 2643);
  assertNull(res[849].firstMatch("abc123"), 2644);
  assertToStringEquals("1234", res[850].firstMatch("1234"), 2645);
  assertToStringEquals("1234", res[851].firstMatch("1234"), 2646);
  assertToStringEquals("abcd", res[852].firstMatch("abcd"), 2647);
  assertToStringEquals("abcd", res[853].firstMatch("abcd"), 2648);
  assertToStringEquals("abc", res[854].firstMatch("the abc"), 2649);
  assertNull(res[854].firstMatch("*** Failers"), 2650);
  assertNull(res[854].firstMatch("abc"), 2651);
  assertToStringEquals("abc", res[855].firstMatch("abc"), 2652);
  assertNull(res[855].firstMatch("*** Failers"), 2653);
  assertNull(res[855].firstMatch("the abc"), 2654);
  assertToStringEquals("aabb,b", res[856].firstMatch("aabbbbb"), 2655);
  assertToStringEquals("aabbbbb,abbbbb", res[857].firstMatch("aabbbbb"), 2656);
  assertToStringEquals("aa,a", res[858].firstMatch("aabbbbb"), 2657);
  assertToStringEquals("aabb,b", res[859].firstMatch("aabbbbb"), 2658);
  assertToStringEquals("Alan Other <user@dom.ain>", res[860].firstMatch("Alan Other <user@dom.ain>"), 2659);
  assertToStringEquals("user@dom.ain", res[860].firstMatch("<user@dom.ain>"), 2660);
  assertToStringEquals("user@dom.ain", res[860].firstMatch("user@dom.ain"), 2661);
  assertToStringEquals("\"A. Other\" <user.1234@dom.ain> (a comment)", res[860].firstMatch("\"A. Other\" <user.1234@dom.ain> (a comment)"), 2662);
  assertToStringEquals(" Other <user.1234@dom.ain> (a comment)", res[860].firstMatch("A. Other <user.1234@dom.ain> (a comment)"), 2663);
  assertToStringEquals("\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"@x400-re.lay", res[860].firstMatch("\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"@x400-re.lay"), 2664);
  assertToStringEquals("user@some.where", res[860].firstMatch("A missing angle <user@some.where"), 2665);
  assertNull(res[860].firstMatch("*** Failers"), 2666);
  assertNull(res[860].firstMatch("The quick brown fox"), 2667);
  assertToStringEquals("Alan Other <user@dom.ain>", res[861].firstMatch("Alan Other <user@dom.ain>"), 2668);
  assertToStringEquals("user@dom.ain", res[861].firstMatch("<user@dom.ain>"), 2669);
  assertToStringEquals("user@dom.ain", res[861].firstMatch("user@dom.ain"), 2670);
  assertToStringEquals("\"A. Other\" <user.1234@dom.ain>", res[861].firstMatch("\"A. Other\" <user.1234@dom.ain> (a comment)"), 2671);
  assertToStringEquals(" Other <user.1234@dom.ain>", res[861].firstMatch("A. Other <user.1234@dom.ain> (a comment)"), 2672);
  assertToStringEquals("\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"@x400-re.lay", res[861].firstMatch("\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"@x400-re.lay"), 2673);
  assertToStringEquals("user@some.where", res[861].firstMatch("A missing angle <user@some.where"), 2674);
  assertNull(res[861].firstMatch("*** Failers"), 2675);
  assertNull(res[861].firstMatch("The quick brown fox"), 2676);
  assertNull(res[861].firstMatch("abc\x00def\x00pqr\x00xyz\x000AB"), 2677);
  assertNull(res[861].firstMatch("abc456 abc\x00def\x00pqr\x00xyz\x000ABCDE"), 2678);
  assertToStringEquals("abc\x0def\x00pqr\x000xyz\x0000AB", res[862].firstMatch("abc\x0def\x00pqr\x000xyz\x0000AB"), 2679);
  assertToStringEquals("abc\x0def\x00pqr\x000xyz\x0000AB", res[862].firstMatch("abc456 abc\x0def\x00pqr\x000xyz\x0000ABCDE"), 2680);
  assertToStringEquals("\x00", res[863].firstMatch("\x00A"), 2681);
  assertToStringEquals("\x01", res[863].firstMatch("\x01B"), 2682);
  assertToStringEquals("\x1f", res[863].firstMatch("\x1fC"), 2683);
  assertToStringEquals("\x00\x00\x00\x00", res[864].firstMatch("\x00\x00\x00\x00"), 2684);
  assertNull(res[865].firstMatch("The Ax0x0Z"), 2685);
  assertNull(res[865].firstMatch("An A\x00x0\x00Z"), 2686);
  assertNull(res[865].firstMatch("*** Failers"), 2687);
  assertNull(res[865].firstMatch("A\x00Z"), 2688);
  assertNull(res[865].firstMatch("A\x00x0\x00x0Z"), 2689);
  assertToStringEquals(" ", res[866].firstMatch(" abc"), 2690);
  assertToStringEquals("\x0c", res[866].firstMatch("\x0cabc"), 2691);
  assertToStringEquals("\n", res[866].firstMatch("\nabc"), 2692);
  assertToStringEquals("\x0d", res[866].firstMatch("\x0dabc"), 2693);
  assertToStringEquals("\x09", res[866].firstMatch("\x09abc"), 2694);
  assertNull(res[866].firstMatch("*** Failers"), 2695);
  assertNull(res[866].firstMatch("abc"), 2696);
  assertToStringEquals("abc", res[867].firstMatch("abc"), 2697);
  assertToStringEquals("abbbbc", res[868].firstMatch("abbbbc"), 2698);
  assertToStringEquals("abbbc", res[868].firstMatch("abbbc"), 2699);
  assertToStringEquals("abbc", res[868].firstMatch("abbc"), 2700);
  assertNull(res[868].firstMatch("*** Failers"), 2701);
  assertNull(res[868].firstMatch("abc"), 2702);
  assertNull(res[868].firstMatch("abbbbbc"), 2703);
  assertToStringEquals("track1.title:TBlah blah blah,track1,title,Blah blah blah", res[869].firstMatch("track1.title:TBlah blah blah"), 2704);
  assertToStringEquals("track1.title:TBlah blah blah,track1,title,Blah blah blah", res[870].firstMatch("track1.title:TBlah blah blah"), 2705);
  assertToStringEquals("track1.title:TBlah blah blah,track1,title,Blah blah blah", res[871].firstMatch("track1.title:TBlah blah blah"), 2706);
  assertToStringEquals("WXY_^abc", res[872].firstMatch("WXY_^abc"), 2707);
  assertNull(res[872].firstMatch("*** Failers"), 2708);
  assertNull(res[872].firstMatch("wxy"), 2709);
  assertToStringEquals("WXY_^abc", res[873].firstMatch("WXY_^abc"), 2710);
  assertToStringEquals("wxy_^ABC", res[873].firstMatch("wxy_^ABC"), 2711);
  assertToStringEquals("WXY_^abc", res[874].firstMatch("WXY_^abc"), 2712);
  assertToStringEquals("wxy_^ABC", res[874].firstMatch("wxy_^ABC"), 2713);
  assertToStringEquals("abc", res[875].firstMatch("abc"), 2714);
  assertToStringEquals("abc", res[875].firstMatch("qqq\nabc"), 2715);
  assertToStringEquals("abc", res[875].firstMatch("abc\nzzz"), 2716);
  assertToStringEquals("abc", res[875].firstMatch("qqq\nabc\nzzz"), 2717);
  assertToStringEquals("abc", res[876].firstMatch("abc"), 2718);
  assertNull(res[876].firstMatch("*** Failers"), 2719);
  assertNull(res[876].firstMatch("qqq\nabc"), 2720);
  assertNull(res[876].firstMatch("abc\nzzz"), 2721);
  assertNull(res[876].firstMatch("qqq\nabc\nzzz"), 2722);
  assertNull(res[877].firstMatch("abc"), 2723);
  assertNull(res[877].firstMatch("abc\n "), 2724);
  assertNull(res[877].firstMatch("*** Failers"), 2725);
  assertNull(res[877].firstMatch("qqq\nabc"), 2726);
  assertNull(res[877].firstMatch("abc\nzzz"), 2727);
  assertNull(res[877].firstMatch("qqq\nabc\nzzz"), 2728);
  assertNull(res[878].firstMatch("abc\ndef"), 2729);
  assertNull(res[879].firstMatch("*** Failers"), 2730);
  assertNull(res[879].firstMatch("abc\ndef"), 2731);
  assertToStringEquals("b", res[880].firstMatch("b::c"), 2732);
  assertToStringEquals("::", res[880].firstMatch("c::b"), 2733);
  assertToStringEquals("az-", res[881].firstMatch("az-"), 2734);
  assertToStringEquals("a", res[881].firstMatch("*** Failers"), 2735);
  assertNull(res[881].firstMatch("b"), 2736);
  assertToStringEquals("za-", res[882].firstMatch("za-"), 2737);
  assertToStringEquals("a", res[882].firstMatch("*** Failers"), 2738);
  assertNull(res[882].firstMatch("b"), 2739);
  assertToStringEquals("a-z", res[883].firstMatch("a-z"), 2740);
  assertToStringEquals("a", res[883].firstMatch("*** Failers"), 2741);
  assertNull(res[883].firstMatch("b"), 2742);
  assertToStringEquals("abcdxyz", res[884].firstMatch("abcdxyz"), 2743);
  assertToStringEquals("12-34", res[885].firstMatch("12-34"), 2744);
  assertNull(res[885].firstMatch("*** Failers"), 2745);
  assertNull(res[885].firstMatch("aaa"), 2746);
  assertToStringEquals("12-34z", res[886].firstMatch("12-34z"), 2747);
  assertNull(res[886].firstMatch("*** Failers"), 2748);
  assertNull(res[886].firstMatch("aaa"), 2749);
  assertToStringEquals("\\", res[887].firstMatch("\\\\"), 2750);
  assertToStringEquals(" Z", res[888].firstMatch("the Zoo"), 2751);
  assertNull(res[888].firstMatch("*** Failers"), 2752);
  assertNull(res[888].firstMatch("Zulu"), 2753);
  assertToStringEquals("ab{3cd", res[889].firstMatch("ab{3cd"), 2754);
  assertToStringEquals("ab{3,cd", res[890].firstMatch("ab{3,cd"), 2755);
  assertToStringEquals("ab{3,4a}cd", res[891].firstMatch("ab{3,4a}cd"), 2756);
  assertToStringEquals("{4,5a}bc", res[892].firstMatch("{4,5a}bc"), 2757);
  assertNull(res[893].firstMatch("a\x0db"), 2758);
  assertNull(res[893].firstMatch("*** Failers"), 2759);
  assertNull(res[893].firstMatch("a\nb"), 2760);
  assertToStringEquals("abc", res[894].firstMatch("abc"), 2761);
  assertNull(res[894].firstMatch("abc\n"), 2762);
  assertNull(res[894].firstMatch("*** Failers"), 2763);
  assertNull(res[894].firstMatch("abc\ndef"), 2764);
  assertToStringEquals("abcS,abc", res[895].firstMatch("abcS"), 2765);
  assertToStringEquals("abc\x93,abc", res[896].firstMatch("abc\x93"), 2766);
  assertToStringEquals("abc\xd3,abc", res[897].firstMatch("abc\xd3"), 2767);
  assertToStringEquals("abc@,abc", res[898].firstMatch("abc@"), 2768);
  assertToStringEquals("abc@,abc", res[898].firstMatch("abc@"), 2769);
  assertToStringEquals("abc@,abc", res[898].firstMatch("abc@0"), 2770);
  assertToStringEquals("abc@,abc", res[898].firstMatch("abc@0"), 2771);
  assertToStringEquals("abc@,abc", res[898].firstMatch("abc@0"), 2772);
  assertToStringEquals("abc@,abc", res[898].firstMatch("abc@0"), 2773);
  assertToStringEquals("abc@,abc", res[898].firstMatch("abc@0"), 2774);
  assertToStringEquals("abc@,abc", res[898].firstMatch("abc@0"), 2775);
  assertNull(res[899].firstMatch("abc\x0081"), 2776);
  assertNull(res[899].firstMatch("abc\x0081"), 2777);
  assertNull(res[900].firstMatch("abc\x0091"), 2778);
  assertNull(res[900].firstMatch("abc\x0091"), 2779);
  assertToStringEquals("abcdefghijk\nS,a,b,c,d,e,f,g,h,i,j,k", res[901].firstMatch("abcdefghijk\nS"), 2780);
  assertToStringEquals("abidef", res[902].firstMatch("abidef"), 2781);
  assertToStringEquals("bc", res[903].firstMatch("bc"), 2782);
  assertToStringEquals("xyz,,", res[904].firstMatch("xyz"), 2783);
  assertToStringEquals("abc\x08de", res[905].firstMatch("abc\x08de"), 2784);
  assertToStringEquals("abc\x01de", res[906].firstMatch("abc\x01de"), 2785);
  assertToStringEquals("abc\x01de,abc", res[907].firstMatch("abc\x01de"), 2786);
  assertNull(res[907].firstMatch("a\nb"), 2787);
  assertToStringEquals("baNOTcccc,b,a,NOT,cccc", res[908].firstMatch("baNOTccccd"), 2788);
  assertToStringEquals("baNOTccc,b,a,NOT,ccc", res[908].firstMatch("baNOTcccd"), 2789);
  assertToStringEquals("baNOTcc,b,a,NO,Tcc", res[908].firstMatch("baNOTccd"), 2790);
  assertToStringEquals("baccc,b,a,,ccc", res[908].firstMatch("bacccd"), 2791);
  assertToStringEquals("*** Failers,*,*,* Fail,ers", res[908].firstMatch("*** Failers"), 2792);
  assertNull(res[908].firstMatch("anything"), 2793);
  assertNull(res[908].firstMatch("b\x08c   "), 2794);
  assertNull(res[908].firstMatch("baccd"), 2795);
  assertToStringEquals("A", res[909].firstMatch("Abc"), 2796);
  assertToStringEquals("b", res[910].firstMatch("Abc "), 2797);
  assertToStringEquals("AAA", res[911].firstMatch("AAAaAbc"), 2798);
  assertToStringEquals("bc ", res[912].firstMatch("AAAaAbc "), 2799);
  assertToStringEquals("bbb\nccc", res[913].firstMatch("bbb\nccc"), 2800);
  assertToStringEquals("c", res[914].firstMatch("abc"), 2801);
  assertToStringEquals("s", res[914].firstMatch("*** Failers"), 2802);
  assertToStringEquals(" ", res[914].firstMatch("abk   "), 2803);
  assertToStringEquals("abc", res[915].firstMatch("abc"), 2804);
  assertToStringEquals("bc", res[915].firstMatch("kbc"), 2805);
  assertToStringEquals("bc ", res[915].firstMatch("kabc "), 2806);
  assertToStringEquals("ers", res[915].firstMatch("*** Failers"), 2807);
  assertNull(res[915].firstMatch("abk"), 2808);
  assertNull(res[915].firstMatch("akb"), 2809);
  assertNull(res[915].firstMatch("akk "), 2810);
  assertToStringEquals("12345678@a.b.c.d", res[916].firstMatch("12345678@a.b.c.d"), 2811);
  assertToStringEquals("123456789@x.y.z", res[916].firstMatch("123456789@x.y.z"), 2812);
  assertNull(res[916].firstMatch("*** Failers"), 2813);
  assertNull(res[916].firstMatch("12345678@x.y.uk"), 2814);
  assertNull(res[916].firstMatch("1234567@a.b.c.d       "), 2815);
  assertToStringEquals("b", res[917].firstMatch("aaaabcd"), 2816);
  assertToStringEquals("A", res[917].firstMatch("aaAabcd "), 2817);
  assertToStringEquals("b", res[918].firstMatch("aaaabcd"), 2818);
  assertToStringEquals("b", res[918].firstMatch("aaAabcd "), 2819);
  assertToStringEquals("b", res[919].firstMatch("aaaabcd"), 2820);
  assertToStringEquals("A", res[919].firstMatch("aaAabcd "), 2821);
  assertToStringEquals("b", res[920].firstMatch("aaaabcd"), 2822);
  assertToStringEquals("b", res[920].firstMatch("aaAabcd "), 2823);
  assertToStringEquals("PSTAIREISLL", res[922].firstMatch("xxxxxxxxxxxPSTAIREISLLxxxxxxxxx"), 2824);
  assertToStringEquals("PSTAIREISLL", res[923].firstMatch("xxxxxxxxxxxPSTAIREISLLxxxxxxxxx"), 2825);
  assertToStringEquals(".230003938,.23", res[924].firstMatch("1.230003938"), 2826);
  assertToStringEquals(".875000282,.875", res[924].firstMatch("1.875000282   "), 2827);
  assertToStringEquals(".235,.23", res[924].firstMatch("1.235  "), 2828);
  assertNull(res[924].firstMatch("              "), 2829);
  assertToStringEquals(".23,.23,", res[925].firstMatch("1.230003938      "), 2830);
  assertToStringEquals(".875,.875,5", res[925].firstMatch("1.875000282"), 2831);
  assertNull(res[925].firstMatch("*** Failers "), 2832);
  assertNull(res[925].firstMatch("1.235 "), 2833);
  assertThrows(() => new RegExp(r"a(?)b"), 2834);
  assertNull(res[925].firstMatch("ab "), 2835);
  assertToStringEquals("foo table,foo,table", res[926].firstMatch("Food is on the foo table"), 2836);
  assertToStringEquals("food is under the bar in the bar,d is under the bar in the ", res[927].firstMatch("The food is under the bar in the barn."), 2837);
  assertToStringEquals("food is under the bar,d is under the ", res[928].firstMatch("The food is under the bar in the barn."), 2838);
  assertToStringEquals("I have 2 numbers: 53147,I have 2 numbers: 53147,", res[929].firstMatch("I have 2 numbers: 53147"), 2839);
  assertToStringEquals("I have 2 numbers: 53147,I have 2 numbers: 5314,7", res[930].firstMatch("I have 2 numbers: 53147"), 2840);
  assertToStringEquals(",,", res[931].firstMatch("I have 2 numbers: 53147"), 2841);
  assertToStringEquals("I have 2,I have ,2", res[932].firstMatch("I have 2 numbers: 53147"), 2842);
  assertToStringEquals("I have 2 numbers: 53147,I have 2 numbers: 5314,7", res[933].firstMatch("I have 2 numbers: 53147"), 2843);
  assertToStringEquals("I have 2 numbers: 53147,I have 2 numbers: ,53147", res[934].firstMatch("I have 2 numbers: 53147"), 2844);
  assertToStringEquals("I have 2 numbers: 53147,I have 2 numbers: ,53147", res[935].firstMatch("I have 2 numbers: 53147"), 2845);
  assertToStringEquals("I have 2 numbers: 53147,I have 2 numbers: ,53147", res[936].firstMatch("I have 2 numbers: 53147"), 2846);
  assertToStringEquals("AB", res[937].firstMatch("ABC123"), 2847);
  assertToStringEquals(" ", res[937].firstMatch(" "), 2848);
  assertToStringEquals("ABC,ABC", res[938].firstMatch("ABC445"), 2849);
  assertNull(res[938].firstMatch("*** Failers"), 2850);
  assertNull(res[938].firstMatch("ABC123"), 2851);
  assertToStringEquals("W46]", res[939].firstMatch("W46]789 "), 2852);
  assertToStringEquals("-46]", res[939].firstMatch("-46]789"), 2853);
  assertNull(res[939].firstMatch("*** Failers"), 2854);
  assertNull(res[939].firstMatch("Wall"), 2855);
  assertNull(res[939].firstMatch("Zebra"), 2856);
  assertNull(res[939].firstMatch("42"), 2857);
  assertNull(res[939].firstMatch("[abcd] "), 2858);
  assertNull(res[939].firstMatch("]abcd["), 2859);
  assertNull(res[939].firstMatch("   "), 2860);
  assertToStringEquals("W", res[940].firstMatch("W46]789 "), 2861);
  assertToStringEquals("W", res[940].firstMatch("Wall"), 2862);
  assertToStringEquals("Z", res[940].firstMatch("Zebra"), 2863);
  assertToStringEquals("X", res[940].firstMatch("Xylophone  "), 2864);
  assertToStringEquals("4", res[940].firstMatch("42"), 2865);
  assertToStringEquals("[", res[940].firstMatch("[abcd] "), 2866);
  assertToStringEquals("]", res[940].firstMatch("]abcd["), 2867);
  assertToStringEquals("\\", res[940].firstMatch("\\backslash "), 2868);
  assertNull(res[940].firstMatch("*** Failers"), 2869);
  assertNull(res[940].firstMatch("-46]789"), 2870);
  assertNull(res[940].firstMatch("well"), 2871);
  assertToStringEquals("01/01/2000", res[941].firstMatch("01/01/2000"), 2872);
  assertToStringEquals("01/01/2000", res[941].firstMatch("01/01/2000"), 2872);
  assertToStringEquals(",", res[944].firstMatch("bcd"), 2873);
  assertToStringEquals(",", res[944].firstMatch("abc"), 2874);
  assertToStringEquals(",", res[944].firstMatch("aab     "), 2875);
  assertToStringEquals(",", res[945].firstMatch("bcd"), 2876);
  assertToStringEquals("a,a", res[945].firstMatch("abc"), 2877);
  assertToStringEquals("a,a", res[945].firstMatch("aab  "), 2878);
  assertToStringEquals(",", res[946].firstMatch("bcd"), 2879);
  assertToStringEquals("a,a", res[946].firstMatch("abc"), 2880);
  assertToStringEquals("aa,a", res[946].firstMatch("aab  "), 2881);
  assertToStringEquals(",", res[947].firstMatch("bcd"), 2882);
  assertToStringEquals("a,a", res[947].firstMatch("abc"), 2883);
  assertToStringEquals("aa,a", res[947].firstMatch("aab"), 2884);
  assertToStringEquals("aaa,a", res[947].firstMatch("aaa   "), 2885);
  assertToStringEquals(",", res[948].firstMatch("bcd"), 2886);
  assertToStringEquals("a,a", res[948].firstMatch("abc"), 2887);
  assertToStringEquals("aa,a", res[948].firstMatch("aab"), 2888);
  assertToStringEquals("aaa,a", res[948].firstMatch("aaa"), 2889);
  assertToStringEquals("aaaaaaaa,a", res[948].firstMatch("aaaaaaaa    "), 2890);
  assertNull(res[949].firstMatch("bcd"), 2891);
  assertToStringEquals("a,a", res[949].firstMatch("abc"), 2892);
  assertToStringEquals("a,a", res[949].firstMatch("aab  "), 2893);
  assertNull(res[950].firstMatch("bcd"), 2894);
  assertToStringEquals("a,a", res[950].firstMatch("abc"), 2895);
  assertToStringEquals("aa,a", res[950].firstMatch("aab  "), 2896);
  assertNull(res[951].firstMatch("bcd"), 2897);
  assertToStringEquals("a,a", res[951].firstMatch("abc"), 2898);
  assertToStringEquals("aa,a", res[951].firstMatch("aab"), 2899);
  assertToStringEquals("aaa,a", res[951].firstMatch("aaa   "), 2900);
  assertNull(res[952].firstMatch("bcd"), 2901);
  assertToStringEquals("a,a", res[952].firstMatch("abc"), 2902);
  assertToStringEquals("aa,a", res[952].firstMatch("aab"), 2903);
  assertToStringEquals("aaa,a", res[952].firstMatch("aaa"), 2904);
  assertToStringEquals("aaaaaaaa,a", res[952].firstMatch("aaaaaaaa    "), 2905);
  assertToStringEquals("bib.gif", res[953].firstMatch("borfle\nbib.gif\nno"), 2906);
  assertToStringEquals("bib.gif", res[954].firstMatch("borfle\nbib.gif\nno"), 2907);
  assertToStringEquals("bib.gif", res[955].firstMatch("borfle\nbib.gif\nno"), 2908);
  assertToStringEquals("bib.gif", res[956].firstMatch("borfle\nbib.gif\nno"), 2909);
  assertToStringEquals("bib.gif", res[957].firstMatch("borfle\nbib.gif\nno"), 2910);
  assertToStringEquals("no", res[958].firstMatch("borfle\nbib.gif\nno"), 2911);
  assertToStringEquals("borfle", res[959].firstMatch("borfle\nbib.gif\nno"), 2912);
  assertToStringEquals("no", res[960].firstMatch("borfle\nbib.gif\nno"), 2913);
  assertToStringEquals("borfle", res[961].firstMatch("borfle\nbib.gif\nno"), 2914);
  assertToStringEquals("", res[962].firstMatch("borfle\nbib.gif\nno\n"), 2915);
  assertToStringEquals("borfle", res[963].firstMatch("borfle\nbib.gif\nno\n"), 2916);
  assertToStringEquals("", res[964].firstMatch("borfle\nbib.gif\nno\n"), 2917);
  assertToStringEquals("borfle", res[965].firstMatch("borfle\nbib.gif\nno\n"), 2918);
  assertToStringEquals("1234X,1234X", res[966].firstMatch("abcde\n1234Xyz"), 2919);
  assertToStringEquals("B,B", res[966].firstMatch("BarFoo "), 2920);
  assertNull(res[966].firstMatch("*** Failers"), 2921);
  assertNull(res[966].firstMatch("abcde\nBar  "), 2922);
  assertToStringEquals("1234X,1234X", res[967].firstMatch("abcde\n1234Xyz"), 2923);
  assertToStringEquals("B,B", res[967].firstMatch("BarFoo "), 2924);
  assertToStringEquals("B,B", res[967].firstMatch("abcde\nBar  "), 2925);
  assertToStringEquals("1234X,1234X", res[968].firstMatch("abcde\n1234Xyz"), 2926);
  assertToStringEquals("B,B", res[968].firstMatch("BarFoo "), 2927);
  assertNull(res[968].firstMatch("*** Failers"), 2928);
  assertNull(res[968].firstMatch("abcde\nBar  "), 2929);
  assertToStringEquals("1234X,1234X", res[969].firstMatch("abcde\n1234Xyz"), 2930);
  assertToStringEquals("B,B", res[969].firstMatch("BarFoo "), 2931);
  assertToStringEquals("B,B", res[969].firstMatch("abcde\nBar  "), 2932);
  assertToStringEquals("1234X,1234X", res[969].firstMatch("abcde\n1234Xyz"), 2933);
  assertToStringEquals("B,B", res[969].firstMatch("BarFoo "), 2934);
  assertNull(res[969].firstMatch("*** Failers "), 2935);
  assertToStringEquals("B,B", res[969].firstMatch("abcde\nBar  "), 2936);
  assertToStringEquals("1234X,1234X", res[969].firstMatch("abcde\n1234Xyz"), 2937);
  assertToStringEquals("B,B", res[969].firstMatch("BarFoo "), 2938);
  assertNull(res[969].firstMatch("*** Failers "), 2939);
  assertToStringEquals("B,B", res[969].firstMatch("abcde\nBar  "), 2940);
  assertNull(res[970].firstMatch("**** Failers"), 2941);
  assertNull(res[970].firstMatch("abc\nB"), 2942);
  assertNull(res[970].firstMatch(" "), 2943);
  assertNull(res[970].firstMatch("abc\nB"), 2944);
  assertNull(res[970].firstMatch("abc\nB"), 2945);
  assertNull(res[970].firstMatch(" "), 2946);
  assertNull(res[970].firstMatch("abc\nB"), 2947);
  assertNull(res[970].firstMatch("abc\nB"), 2948);
  assertToStringEquals("B", res[970].firstMatch("B\n"), 2949);
  assertToStringEquals("123456654321", res[971].firstMatch("123456654321"), 2950);
  assertToStringEquals("123456654321", res[972].firstMatch("123456654321 "), 2951);
  assertToStringEquals("123456654321", res[973].firstMatch("123456654321"), 2952);
  assertToStringEquals("abcabcabcabc", res[974].firstMatch("abcabcabcabc"), 2953);
  assertToStringEquals("abcabcabcabc", res[975].firstMatch("abcabcabcabc"), 2954);
  assertToStringEquals("abcabcabcabc,c", res[976].firstMatch("abcabcabcabc "), 2955);
  assertToStringEquals("n", res[977].firstMatch("n"), 2956);
  assertNull(res[977].firstMatch("*** Failers "), 2957);
  assertNull(res[977].firstMatch("z "), 2958);
  assertToStringEquals("abcd", res[978].firstMatch("abcd"), 2959);
  assertNull(res[978].firstMatch("*** Failers"), 2960);
  assertNull(res[978].firstMatch("abce  "), 2961);
  assertToStringEquals("abe", res[979].firstMatch("abe"), 2962);
  assertNull(res[979].firstMatch("*** Failers"), 2963);
  assertNull(res[979].firstMatch("abcde "), 2964);
  assertToStringEquals("abd,", res[980].firstMatch("abd"), 2965);
  assertNull(res[980].firstMatch("*** Failers"), 2966);
  assertNull(res[980].firstMatch("abcd   "), 2967);
  assertToStringEquals("a,", res[981].firstMatch("a"), 2968);
  assertToStringEquals("ab,b", res[981].firstMatch("ab"), 2969);
  assertToStringEquals("abbbb,bbbb", res[981].firstMatch("abbbb"), 2970);
  assertToStringEquals("a,", res[981].firstMatch("*** Failers"), 2971);
  assertNull(res[981].firstMatch("bbbbb    "), 2972);
  assertToStringEquals("abe", res[982].firstMatch("abe"), 2973);
  assertNull(res[982].firstMatch("*** Failers"), 2974);
  assertNull(res[982].firstMatch("ab1e   "), 2975);
  assertToStringEquals("\"quick\",quick", res[983].firstMatch("the \"quick\" brown fox"), 2976);
  assertToStringEquals("\"the \\\"quick\\\" brown fox\", brown fox", res[983].firstMatch("\"the \\\"quick\\\" brown fox\" "), 2977);
  assertToStringEquals("", res[984].firstMatch("abc"), 2978);
  assertToStringEquals("", res[985].firstMatch("abc "), 2979);
  assertToStringEquals("", res[986].firstMatch("abc "), 2980);
  // Dart does not have RegExp literals and thus no translatation of the below.
  // assertThrows("var re = //;", 2981);
  assertToStringEquals("", res[986].firstMatch("abc"), 2982);
  assertToStringEquals("acb", res[988].firstMatch("acb"), 2983);
  assertToStringEquals("a\nb", res[988].firstMatch("a\nb"), 2984);
  assertToStringEquals("acb", res[989].firstMatch("acb"), 2985);
  assertNull(res[989].firstMatch("*** Failers "), 2986);
  assertNull(res[989].firstMatch("a\nb   "), 2987);
  assertToStringEquals("acb", res[990].firstMatch("acb"), 2988);
  assertToStringEquals("a\nb", res[990].firstMatch("a\nb  "), 2989);
  assertToStringEquals("acb", res[991].firstMatch("acb"), 2990);
  assertNull(res[991].firstMatch("a\nb  "), 2991);
  assertToStringEquals("bac,a", res[992].firstMatch("bac"), 2992);
  assertToStringEquals("bbac,a", res[992].firstMatch("bbac"), 2993);
  assertToStringEquals("bbbac,a", res[992].firstMatch("bbbac"), 2994);
  assertToStringEquals("bbbbac,a", res[992].firstMatch("bbbbac"), 2995);
  assertToStringEquals("bbbbbac,a", res[992].firstMatch("bbbbbac "), 2996);
  assertToStringEquals("bac,a", res[993].firstMatch("bac"), 2997);
  assertToStringEquals("bbac,a", res[993].firstMatch("bbac"), 2998);
  assertToStringEquals("bbbac,a", res[993].firstMatch("bbbac"), 2999);
  assertToStringEquals("bbbbac,a", res[993].firstMatch("bbbbac"), 3000);
  assertToStringEquals("bbbbbac,a", res[993].firstMatch("bbbbbac "), 3001);
  assertToStringEquals("x", res[994].firstMatch("x\nb\n"), 3002);
  assertToStringEquals("x", res[994].firstMatch("a\x08x\n  "), 3003);
  assertNull(res[995].firstMatch("\x00{ab} "), 3004);
  assertToStringEquals("CD,", res[996].firstMatch("CD "), 3005);
  assertToStringEquals("CD,", res[997].firstMatch("CD "), 3006);
  assertNull(res[997].firstMatch("foo"), 3007);
  assertNull(res[997].firstMatch("catfood"), 3008);
  assertNull(res[997].firstMatch("arfootle"), 3009);
  assertNull(res[997].firstMatch("rfoosh"), 3010);
  assertNull(res[997].firstMatch("*** Failers"), 3011);
  assertNull(res[997].firstMatch("barfoo"), 3012);
  assertNull(res[997].firstMatch("towbarfoo"), 3013);
  assertNull(res[997].firstMatch("catfood"), 3014);
  assertNull(res[997].firstMatch("*** Failers"), 3015);
  assertNull(res[997].firstMatch("foo"), 3016);
  assertNull(res[997].firstMatch("barfoo"), 3017);
  assertNull(res[997].firstMatch("towbarfoo"), 3018);
  assertNull(res[997].firstMatch("fooabar"), 3019);
  assertNull(res[997].firstMatch("*** Failers"), 3020);
  assertNull(res[997].firstMatch("bar"), 3021);
  assertNull(res[997].firstMatch("foobbar"), 3022);
  assertNull(res[997].firstMatch("  "), 3023);
  assertNull(res[998].firstMatch("abc"), 3024);
  assertNull(res[998].firstMatch("*** Failers"), 3025);
  assertNull(res[998].firstMatch("abc\n   "), 3026);
  assertNull(res[998].firstMatch("qqq\nabc"), 3027);
  assertNull(res[998].firstMatch("abc\nzzz"), 3028);
  assertNull(res[998].firstMatch("qqq\nabc\nzzz"), 3029);
  assertNull(res[998].firstMatch("/this/is/a/very/long/line/in/deed/with/very/many/slashes/in/it/you/see/"), 3030);
  assertNull(res[998].firstMatch("/this/is/a/very/long/line/in/deed/with/very/many/slashes/in/and/foo"), 3031);
  assertNull(res[998].firstMatch("1.230003938"), 3032);
  assertNull(res[998].firstMatch("1.875000282"), 3033);
  assertNull(res[998].firstMatch("*** Failers "), 3034);
  assertNull(res[998].firstMatch("1.235 "), 3035);
  assertNull(res[998].firstMatch("now is the time for all good men to come to the aid of the party"), 3036);
  assertNull(res[998].firstMatch("*** Failers"), 3037);
  assertNull(res[998].firstMatch("this is not a line with only words and spaces!"), 3038);
  assertToStringEquals("12345a,12345,a", res[999].firstMatch("12345a"), 3039);
  assertToStringEquals("12345,1234,5", res[999].firstMatch("12345+ "), 3040);
  assertToStringEquals("12345a,12345,a", res[999].firstMatch("12345a"), 3041);
  assertNull(res[999].firstMatch("*** Failers"), 3042);
  assertToStringEquals("12345,1234,5", res[999].firstMatch("12345+ "), 3043);
  assertNull(res[999].firstMatch("aaab"), 3044);
  assertNull(res[999].firstMatch("aaab"), 3045);
  assertNull(res[999].firstMatch("aaab"), 3046);
  assertNull(res[999].firstMatch("aaabbbccc"), 3047);
  assertNull(res[999].firstMatch("aaabbbbccccd"), 3048);
  assertToStringEquals("aaabbbbcccc,ccc", res[1000].firstMatch("aaabbbbccccd"), 3049);
  assertToStringEquals("abc,b", res[1000].firstMatch("((abc(ade)ufh()()x"), 3050);
  assertNull(res[1000].firstMatch(""), 3051);
  assertToStringEquals("abc,b", res[1000].firstMatch("(abc)"), 3052);
  assertToStringEquals("abc,b", res[1000].firstMatch("(abc(def)xyz)"), 3053);
  assertNull(res[1000].firstMatch("*** Failers"), 3054);
  assertNull(res[1000].firstMatch("ab"), 3055);
  assertNull(res[1000].firstMatch("Ab"), 3056);
  assertNull(res[1000].firstMatch("*** Failers "), 3057);
  assertNull(res[1000].firstMatch("aB"), 3058);
  assertNull(res[1000].firstMatch("AB"), 3059);
  assertNull(res[1000].firstMatch("    "), 3060);
  assertToStringEquals("bc,b", res[1000].firstMatch("a bcd e"), 3061);
  assertNull(res[1000].firstMatch("*** Failers"), 3062);
  assertToStringEquals("c,", res[1000].firstMatch("a b cd e"), 3063);
  assertToStringEquals("abc,b", res[1000].firstMatch("abcd e   "), 3064);
  assertToStringEquals("bc,b", res[1000].firstMatch("a bcde "), 3065);
  assertToStringEquals("bc,b", res[1000].firstMatch("a bcde f"), 3066);
  assertNull(res[1000].firstMatch("*** Failers"), 3067);
  assertToStringEquals("abc,b", res[1000].firstMatch("abcdef  "), 3068);
  assertToStringEquals("abc,b", res[1000].firstMatch("abc"), 3069);
  assertToStringEquals("c,", res[1000].firstMatch("aBc"), 3070);
  assertNull(res[1000].firstMatch("*** Failers"), 3071);
  assertNull(res[1000].firstMatch("abC"), 3072);
  assertNull(res[1000].firstMatch("aBC  "), 3073);
  assertToStringEquals("bc,b", res[1000].firstMatch("Abc"), 3074);
  assertToStringEquals("c,", res[1000].firstMatch("ABc"), 3075);
  assertNull(res[1000].firstMatch("ABC"), 3076);
  assertNull(res[1000].firstMatch("AbC"), 3077);
  assertNull(res[1000].firstMatch(""), 3078);
  assertToStringEquals("abc,b", res[1000].firstMatch("abc"), 3079);
  assertToStringEquals("c,", res[1000].firstMatch("aBc"), 3080);
  assertNull(res[1000].firstMatch("*** Failers "), 3081);
  assertNull(res[1000].firstMatch("ABC"), 3082);
  assertNull(res[1000].firstMatch("abC"), 3083);
  assertNull(res[1000].firstMatch("aBC"), 3084);
  assertNull(res[1000].firstMatch(""), 3085);
  assertToStringEquals("c,", res[1000].firstMatch("aBc"), 3086);
  assertToStringEquals("c,", res[1000].firstMatch("aBBc"), 3087);
  assertNull(res[1000].firstMatch("*** Failers "), 3088);
  assertNull(res[1000].firstMatch("aBC"), 3089);
  assertNull(res[1000].firstMatch("aBBC"), 3090);
  assertNull(res[1000].firstMatch(""), 3091);
  assertToStringEquals("abc,b", res[1000].firstMatch("abcd"), 3092);
  assertNull(res[1000].firstMatch("abCd"), 3093);
  assertNull(res[1000].firstMatch("*** Failers"), 3094);
  assertNull(res[1000].firstMatch("aBCd"), 3095);
  assertToStringEquals("abc,b", res[1000].firstMatch("abcD     "), 3096);
  assertNull(res[1000].firstMatch(""), 3097);
  assertNull(res[1000].firstMatch("more than million"), 3098);
  assertNull(res[1000].firstMatch("more than MILLION"), 3099);
  assertNull(res[1000].firstMatch("more \n than Million "), 3100);
  assertNull(res[1000].firstMatch("*** Failers"), 3101);
  assertNull(res[1000].firstMatch("MORE THAN MILLION    "), 3102);
  assertNull(res[1000].firstMatch("more \n than \n million "), 3103);
  assertNull(res[1000].firstMatch("more than million"), 3104);
  assertNull(res[1000].firstMatch("more than MILLION"), 3105);
  assertNull(res[1000].firstMatch("more \n than Million "), 3106);
  assertNull(res[1000].firstMatch("*** Failers"), 3107);
  assertNull(res[1000].firstMatch("MORE THAN MILLION    "), 3108);
  assertNull(res[1000].firstMatch("more \n than \n million "), 3109);
  assertNull(res[1000].firstMatch(""), 3110);
  assertToStringEquals("abc,b", res[1000].firstMatch("abc"), 3111);
  assertToStringEquals("bc,b", res[1000].firstMatch("aBbc"), 3112);
  assertToStringEquals("c,", res[1000].firstMatch("aBBc "), 3113);
  assertNull(res[1000].firstMatch("*** Failers"), 3114);
  assertToStringEquals("bc,b", res[1000].firstMatch("Abc"), 3115);
  assertNull(res[1000].firstMatch("abAb    "), 3116);
  assertNull(res[1000].firstMatch("abbC "), 3117);
  assertNull(res[1000].firstMatch(""), 3118);
  assertToStringEquals("abc,b", res[1000].firstMatch("abc"), 3119);
  assertToStringEquals("c,", res[1000].firstMatch("aBc"), 3120);
  assertNull(res[1000].firstMatch("*** Failers"), 3121);
  assertNull(res[1000].firstMatch("Ab "), 3122);
  assertNull(res[1000].firstMatch("abC"), 3123);
  assertNull(res[1000].firstMatch("aBC     "), 3124);
  assertNull(res[1000].firstMatch(""), 3125);
  assertToStringEquals("c,", res[1000].firstMatch("abxxc"), 3126);
  assertToStringEquals("c,", res[1000].firstMatch("aBxxc"), 3127);
  assertNull(res[1000].firstMatch("*** Failers"), 3128);
  assertToStringEquals("c,", res[1000].firstMatch("Abxxc"), 3129);
  assertToStringEquals("c,", res[1000].firstMatch("ABxxc"), 3130);
  assertNull(res[1000].firstMatch("abxxC      "), 3131);
  assertToStringEquals("abc,b", res[1000].firstMatch("abc:"), 3132);
  assertNull(res[1000].firstMatch("12"), 3133);
  assertNull(res[1000].firstMatch("*** Failers"), 3134);
  assertNull(res[1000].firstMatch("123"), 3135);
  assertNull(res[1000].firstMatch("xyz    "), 3136);
  assertToStringEquals("abc,b", res[1000].firstMatch("abc:"), 3137);
  assertNull(res[1000].firstMatch("12"), 3138);
  assertNull(res[1000].firstMatch("*** Failers"), 3139);
  assertNull(res[1000].firstMatch("123"), 3140);
  assertNull(res[1000].firstMatch("xyz    "), 3141);
  assertNull(res[1000].firstMatch(""), 3142);
  assertNull(res[1000].firstMatch("foobar"), 3143);
  assertToStringEquals("c,", res[1000].firstMatch("cat"), 3144);
  assertToStringEquals("c,", res[1000].firstMatch("fcat"), 3145);
  assertToStringEquals("c,", res[1000].firstMatch("focat   "), 3146);
  assertNull(res[1000].firstMatch("*** Failers"), 3147);
  assertToStringEquals("c,", res[1000].firstMatch("foocat  "), 3148);
  assertNull(res[1000].firstMatch("foobar"), 3149);
  assertToStringEquals("c,", res[1000].firstMatch("cat"), 3150);
  assertToStringEquals("c,", res[1000].firstMatch("fcat"), 3151);
  assertToStringEquals("c,", res[1000].firstMatch("focat   "), 3152);
  assertNull(res[1000].firstMatch("*** Failers"), 3153);
  assertToStringEquals("c,", res[1000].firstMatch("foocat  "), 3154);
  assertNull(res[1000].firstMatch("a"), 3155);
  assertNull(res[1000].firstMatch("aa"), 3156);
  assertNull(res[1000].firstMatch("aaaa"), 3157);
  assertNull(res[1000].firstMatch(""), 3158);
  assertToStringEquals("abc,abc", res[1001].firstMatch("abc"), 3159);
  assertToStringEquals("abcabc,abc", res[1001].firstMatch("abcabc"), 3160);
  assertToStringEquals("abcabcabc,abc", res[1001].firstMatch("abcabcabc"), 3161);
  assertToStringEquals(",", res[1001].firstMatch("xyz      "), 3162);
  assertToStringEquals("a,a", res[1002].firstMatch("a"), 3163);
  assertToStringEquals("aaaaa,aaaaa", res[1002].firstMatch("aaaaa "), 3164);
  assertToStringEquals("a,a", res[1003].firstMatch("a"), 3165);
  assertToStringEquals("b,b", res[1003].firstMatch("b"), 3166);
  assertToStringEquals("ababab,ababab", res[1003].firstMatch("ababab"), 3167);
  assertToStringEquals("aaaab,aaaab", res[1003].firstMatch("aaaabcde"), 3168);
  assertToStringEquals("bbbb,bbbb", res[1003].firstMatch("bbbb    "), 3169);
  assertToStringEquals("b,b", res[1004].firstMatch("b"), 3170);
  assertToStringEquals("bbbb,bbbb", res[1004].firstMatch("bbbb"), 3171);
  assertToStringEquals(",", res[1004].firstMatch("aaa   "), 3172);
  assertToStringEquals("cccc,cccc", res[1005].firstMatch("cccc"), 3173);
  assertToStringEquals(",", res[1005].firstMatch("abab  "), 3174);
  assertToStringEquals("a,a", res[1006].firstMatch("a"), 3175);
  assertToStringEquals("aaaa,a", res[1006].firstMatch("aaaa "), 3176);
  assertToStringEquals("a,a", res[1007].firstMatch("a"), 3177);
  assertToStringEquals("b,b", res[1007].firstMatch("b"), 3178);
  assertToStringEquals("abab,b", res[1007].firstMatch("abab"), 3179);
  assertToStringEquals("baba,a", res[1007].firstMatch("baba   "), 3180);
  assertToStringEquals("b,b", res[1008].firstMatch("b"), 3181);
  assertToStringEquals("bbbb,b", res[1008].firstMatch("bbbb"), 3182);
  assertToStringEquals(",", res[1008].firstMatch("aaa   "), 3183);
  assertToStringEquals("c,c", res[1009].firstMatch("c"), 3184);
  assertToStringEquals("cccc,c", res[1009].firstMatch("cccc"), 3185);
  assertToStringEquals(",", res[1009].firstMatch("baba   "), 3186);
  assertToStringEquals(",", res[1009].firstMatch("a"), 3187);
  assertToStringEquals(",", res[1009].firstMatch("aaabcde "), 3188);
  assertToStringEquals(",", res[1009].firstMatch("aaaaa"), 3189);
  assertToStringEquals(",", res[1009].firstMatch("aabbaa "), 3190);
  assertToStringEquals(",", res[1009].firstMatch("aaaaa"), 3191);
  assertToStringEquals(",", res[1009].firstMatch("aabbaa "), 3192);
  assertToStringEquals("12-sep-98,8", res[1009].firstMatch("12-sep-98"), 3193);
  assertToStringEquals("12-09-98,8", res[1009].firstMatch("12-09-98"), 3194);
  assertToStringEquals("*** F,F", res[1009].firstMatch("*** Failers"), 3195);
  assertToStringEquals("sep-12-98,8", res[1009].firstMatch("sep-12-98"), 3196);
  assertToStringEquals("    , ", res[1009].firstMatch("    "), 3197);
  assertToStringEquals("s,s", res[1009].firstMatch("saturday"), 3198);
  assertToStringEquals("sund,d", res[1009].firstMatch("sunday"), 3199);
  assertToStringEquals("S,S", res[1009].firstMatch("Saturday"), 3200);
  assertToStringEquals("Sund,d", res[1009].firstMatch("Sunday"), 3201);
  assertToStringEquals("SATURDAY,Y", res[1009].firstMatch("SATURDAY"), 3202);
  assertToStringEquals("SUNDAY,Y", res[1009].firstMatch("SUNDAY"), 3203);
  assertToStringEquals("SunD,D", res[1009].firstMatch("SunDay"), 3204);
  assertToStringEquals(",", res[1009].firstMatch("abcx"), 3205);
  assertToStringEquals(",", res[1009].firstMatch("aBCx"), 3206);
  assertToStringEquals(",", res[1009].firstMatch("bbx"), 3207);
  assertToStringEquals("BBx,x", res[1009].firstMatch("BBx"), 3208);
  assertToStringEquals("*** F,F", res[1009].firstMatch("*** Failers"), 3209);
  assertToStringEquals(",", res[1009].firstMatch("abcX"), 3210);
  assertToStringEquals(",", res[1009].firstMatch("aBCX"), 3211);
  assertToStringEquals(",", res[1009].firstMatch("bbX"), 3212);
  assertToStringEquals("BBX               , ", res[1009].firstMatch("BBX               "), 3213);
  assertToStringEquals(",", res[1009].firstMatch("ac"), 3214);
  assertToStringEquals(",", res[1009].firstMatch("aC"), 3215);
  assertToStringEquals(",", res[1009].firstMatch("bD"), 3216);
  assertToStringEquals("eleph,h", res[1009].firstMatch("elephant"), 3217);
  assertToStringEquals("Europe , ", res[1009].firstMatch("Europe "), 3218);
  assertToStringEquals("frog,g", res[1009].firstMatch("frog"), 3219);
  assertToStringEquals("Fr,r", res[1009].firstMatch("France"), 3220);
  assertToStringEquals("*** F,F", res[1009].firstMatch("*** Failers"), 3221);
  assertToStringEquals("Afric,c", res[1009].firstMatch("Africa     "), 3222);
  assertToStringEquals(",", res[1009].firstMatch("ab"), 3223);
  assertToStringEquals(",", res[1009].firstMatch("aBd"), 3224);
  assertToStringEquals("xy,y", res[1009].firstMatch("xy"), 3225);
  assertToStringEquals("xY,Y", res[1009].firstMatch("xY"), 3226);
  assertToStringEquals("ze,e", res[1009].firstMatch("zebra"), 3227);
  assertToStringEquals("Z,Z", res[1009].firstMatch("Zambesi"), 3228);
  assertToStringEquals("*** F,F", res[1009].firstMatch("*** Failers"), 3229);
  assertToStringEquals(",", res[1009].firstMatch("aCD  "), 3230);
  assertToStringEquals("XY  , ", res[1009].firstMatch("XY  "), 3231);
  assertToStringEquals("foo\n,\n", res[1009].firstMatch("foo\nbar"), 3232);
  assertToStringEquals("*** F,F", res[1009].firstMatch("*** Failers"), 3233);
  assertToStringEquals(",", res[1009].firstMatch("bar"), 3234);
  assertToStringEquals(",", res[1009].firstMatch("baz\nbar   "), 3235);
  assertToStringEquals(",", res[1009].firstMatch("barbaz"), 3236);
  assertToStringEquals(",", res[1009].firstMatch("barbarbaz "), 3237);
  assertToStringEquals("koo,o", res[1009].firstMatch("koobarbaz "), 3238);
  assertToStringEquals("*** F,F", res[1009].firstMatch("*** Failers"), 3239);
  assertToStringEquals(",", res[1009].firstMatch("baz"), 3240);
  assertToStringEquals("foo,o", res[1009].firstMatch("foobarbaz "), 3241);
  assertToStringEquals("abc", res[1012].firstMatch("abc"), 3242);
  assertToStringEquals("abc", res[1012].firstMatch("xabcy"), 3243);
  assertToStringEquals("abc", res[1012].firstMatch("ababc"), 3244);
  assertNull(res[1012].firstMatch("*** Failers"), 3245);
  assertNull(res[1012].firstMatch("xbc"), 3246);
  assertNull(res[1012].firstMatch("axc"), 3247);
  assertNull(res[1012].firstMatch("abx"), 3248);
  assertToStringEquals("abc", res[1013].firstMatch("abc"), 3249);
  assertToStringEquals("abc", res[1014].firstMatch("abc"), 3250);
  assertToStringEquals("abbc", res[1014].firstMatch("abbc"), 3251);
  assertToStringEquals("abbbbc", res[1014].firstMatch("abbbbc"), 3252);
  assertToStringEquals("a", res[1015].firstMatch("abbbbc"), 3253);
  assertToStringEquals("abbb", res[1016].firstMatch("abbbbc"), 3254);
  assertToStringEquals("abbbbc", res[1017].firstMatch("abbbbc"), 3255);
  assertToStringEquals("abbc", res[1018].firstMatch("abbc"), 3256);
  assertNull(res[1018].firstMatch("*** Failers"), 3257);
  assertNull(res[1018].firstMatch("abc"), 3258);
  assertNull(res[1018].firstMatch("abq"), 3259);
  assertToStringEquals("abbbbc", res[1020].firstMatch("abbbbc"), 3260);
  assertToStringEquals("abbbbc", res[1021].firstMatch("abbbbc"), 3261);
  assertToStringEquals("abbbbc", res[1022].firstMatch("abbbbc"), 3262);
  assertToStringEquals("abbbbc", res[1023].firstMatch("abbbbc"), 3263);
  assertNull(res[1024].firstMatch("*** Failers"), 3264);
  assertNull(res[1024].firstMatch("abq"), 3265);
  assertNull(res[1024].firstMatch("abbbbc"), 3266);
  assertToStringEquals("abbc", res[1025].firstMatch("abbc"), 3267);
  assertToStringEquals("abc", res[1025].firstMatch("abc"), 3268);
  assertToStringEquals("abc", res[1026].firstMatch("abc"), 3269);
  assertToStringEquals("abc", res[1028].firstMatch("abc"), 3270);
  assertToStringEquals("abc", res[1029].firstMatch("abc"), 3271);
  assertToStringEquals("abc", res[1030].firstMatch("abc"), 3272);
  assertNull(res[1030].firstMatch("*** Failers"), 3273);
  assertNull(res[1030].firstMatch("abbbbc"), 3274);
  assertNull(res[1030].firstMatch("abcc"), 3275);
  assertToStringEquals("abc", res[1031].firstMatch("abcc"), 3276);
  assertToStringEquals("abc", res[1033].firstMatch("aabc"), 3277);
  assertNull(res[1033].firstMatch("*** Failers"), 3278);
  assertToStringEquals("abc", res[1033].firstMatch("aabc"), 3279);
  assertNull(res[1033].firstMatch("aabcd"), 3280);
  assertToStringEquals("", res[1034].firstMatch("abc"), 3281);
  assertToStringEquals("", res[1035].firstMatch("abc"), 3282);
  assertToStringEquals("abc", res[1036].firstMatch("abc"), 3283);
  assertToStringEquals("axc", res[1036].firstMatch("axc"), 3284);
  assertToStringEquals("axyzc", res[1037].firstMatch("axyzc"), 3285);
  assertToStringEquals("abd", res[1038].firstMatch("abd"), 3286);
  assertNull(res[1038].firstMatch("*** Failers"), 3287);
  assertNull(res[1038].firstMatch("axyzd"), 3288);
  assertNull(res[1038].firstMatch("abc"), 3289);
  assertToStringEquals("ace", res[1039].firstMatch("ace"), 3290);
  assertToStringEquals("ac", res[1040].firstMatch("aac"), 3291);
  assertToStringEquals("a-", res[1041].firstMatch("a-"), 3292);
  assertToStringEquals("a-", res[1042].firstMatch("a-"), 3293);
  assertToStringEquals("a]", res[1043].firstMatch("a]"), 3294);
  assertNull(res[1044].firstMatch("a]b"), 3295);
  assertToStringEquals("aed", res[1045].firstMatch("aed"), 3296);
  assertNull(res[1045].firstMatch("*** Failers"), 3297);
  assertNull(res[1045].firstMatch("abd"), 3298);
  assertNull(res[1045].firstMatch("abd"), 3299);
  assertToStringEquals("adc", res[1046].firstMatch("adc"), 3300);
  assertNull(res[1047].firstMatch("adc"), 3301);
  assertNull(res[1047].firstMatch("*** Failers"), 3302);
  assertNull(res[1047].firstMatch("a-c"), 3303);
  assertNull(res[1047].firstMatch("a]c"), 3304);
  assertToStringEquals("a", res[1048].firstMatch("a-"), 3305);
  assertToStringEquals("a", res[1048].firstMatch("-a"), 3306);
  assertToStringEquals("a", res[1048].firstMatch("-a-"), 3307);
  assertNull(res[1049].firstMatch("*** Failers"), 3308);
  assertNull(res[1049].firstMatch("xy"), 3309);
  assertNull(res[1049].firstMatch("yz"), 3310);
  assertNull(res[1049].firstMatch("xyz"), 3311);
  assertToStringEquals("a", res[1050].firstMatch("*** Failers"), 3312);
  assertNull(res[1050].firstMatch("a-"), 3313);
  assertNull(res[1050].firstMatch("-a"), 3314);
  assertNull(res[1050].firstMatch("-a-"), 3315);
  assertToStringEquals("y", res[1051].firstMatch("xy"), 3316);
  assertToStringEquals("y", res[1052].firstMatch("yz"), 3317);
  assertToStringEquals("y", res[1053].firstMatch("xyz"), 3318);
  assertToStringEquals("a", res[1054].firstMatch("a"), 3319);
  assertToStringEquals("-", res[1055].firstMatch("-"), 3320);
  assertToStringEquals("*", res[1055].firstMatch("*** Failers"), 3321);
  assertToStringEquals("-", res[1055].firstMatch("-"), 3322);
  assertNull(res[1055].firstMatch("a"), 3323);
  assertToStringEquals("a b", res[1056].firstMatch("a b"), 3324);
  assertToStringEquals("a-b", res[1057].firstMatch("a-b"), 3325);
  assertNull(res[1057].firstMatch("*** Failers"), 3326);
  assertToStringEquals("a-b", res[1057].firstMatch("a-b"), 3327);
  assertNull(res[1057].firstMatch("a b"), 3328);
  assertToStringEquals("1", res[1058].firstMatch("1"), 3329);
  assertToStringEquals("-", res[1059].firstMatch("-"), 3330);
  assertToStringEquals("*", res[1059].firstMatch("*** Failers"), 3331);
  assertToStringEquals("-", res[1059].firstMatch("-"), 3332);
  assertNull(res[1059].firstMatch("1"), 3333);
  assertToStringEquals("a", res[1060].firstMatch("a"), 3334);
  assertToStringEquals("-", res[1061].firstMatch("-"), 3335);
  assertToStringEquals("*", res[1061].firstMatch("*** Failers"), 3336);
  assertToStringEquals("-", res[1061].firstMatch("-"), 3337);
  assertNull(res[1061].firstMatch("a"), 3338);
  assertToStringEquals("a b", res[1062].firstMatch("a b"), 3339);
  assertToStringEquals("a-b", res[1063].firstMatch("a-b"), 3340);
  assertNull(res[1063].firstMatch("*** Failers"), 3341);
  assertToStringEquals("a-b", res[1063].firstMatch("a-b"), 3342);
  assertNull(res[1063].firstMatch("a b"), 3343);
  assertToStringEquals("1", res[1064].firstMatch("1"), 3344);
  assertToStringEquals("-", res[1065].firstMatch("-"), 3345);
  assertToStringEquals("*", res[1065].firstMatch("*** Failers"), 3346);
  assertToStringEquals("-", res[1065].firstMatch("-"), 3347);
  assertNull(res[1065].firstMatch("1"), 3348);
  assertToStringEquals("ab", res[1066].firstMatch("abc"), 3349);
  assertToStringEquals("ab", res[1066].firstMatch("abcd"), 3350);
  assertToStringEquals("ef,", res[1067].firstMatch("def"), 3351);
  assertToStringEquals("a(b", res[1069].firstMatch("a(b"), 3352);
  assertNull(res[1069].firstMatch("ab"), 3353);
  assertNull(res[1069].firstMatch("a((b"), 3354);
  assertNull(res[1070].firstMatch("a\x08"), 3355);
  assertToStringEquals("a,a,a", res[1071].firstMatch("abc"), 3356);
  assertToStringEquals("abc,a,c", res[1072].firstMatch("abc"), 3357);
  assertToStringEquals("abc", res[1073].firstMatch("aabbabc"), 3358);
  assertToStringEquals("abc", res[1074].firstMatch("aabbabc"), 3359);
  assertToStringEquals("abc", res[1075].firstMatch("abcabc"), 3360);
  assertToStringEquals("ab,b", res[1076].firstMatch("ab"), 3361);
  assertToStringEquals("ab,b", res[1077].firstMatch("ab"), 3362);
  assertToStringEquals("ab,b", res[1078].firstMatch("ab"), 3363);
  assertToStringEquals("ab,b", res[1079].firstMatch("ab"), 3364);
  assertToStringEquals("a,a", res[1080].firstMatch("ab"), 3365);
  assertToStringEquals("a,a", res[1081].firstMatch("ab"), 3366);
  assertToStringEquals("cde", res[1082].firstMatch("cde"), 3367);
  assertNull(res[1083].firstMatch("*** Failers"), 3368);
  assertNull(res[1083].firstMatch("b"), 3369);
  assertToStringEquals("abbbcd,c", res[1085].firstMatch("abbbcd"), 3370);
  assertToStringEquals("abcd,a", res[1086].firstMatch("abcd"), 3371);
  assertToStringEquals("e", res[1087].firstMatch("e"), 3372);
  assertToStringEquals("ef,e", res[1088].firstMatch("ef"), 3373);
  assertToStringEquals("abcdefg", res[1089].firstMatch("abcdefg"), 3374);
  assertToStringEquals("ab", res[1090].firstMatch("xabyabbbz"), 3375);
  assertToStringEquals("a", res[1090].firstMatch("xayabbbz"), 3376);
  assertToStringEquals("cde,cd", res[1091].firstMatch("abcde"), 3377);
  assertToStringEquals("hij", res[1092].firstMatch("hij"), 3378);
  assertToStringEquals("ef,", res[1094].firstMatch("abcdef"), 3379);
  assertToStringEquals("bcd,b", res[1095].firstMatch("abcd"), 3380);
  assertToStringEquals("abc,a", res[1096].firstMatch("abc"), 3381);
  assertToStringEquals("abc,bc", res[1097].firstMatch("abc"), 3382);
  assertToStringEquals("abcd,bc,d", res[1098].firstMatch("abcd"), 3383);
  assertToStringEquals("abcd,bc,d", res[1099].firstMatch("abcd"), 3384);
  assertToStringEquals("abcd,b,cd", res[1100].firstMatch("abcd"), 3385);
  assertToStringEquals("adcdcde", res[1101].firstMatch("adcdcde"), 3386);
  assertNull(res[1102].firstMatch("*** Failers"), 3387);
  assertNull(res[1102].firstMatch("abcde"), 3388);
  assertNull(res[1102].firstMatch("adcdcde"), 3389);
  assertToStringEquals("abc,ab", res[1103].firstMatch("abc"), 3390);
  assertToStringEquals("abcd,abc,a,b,d", res[1104].firstMatch("abcd"), 3391);
  assertToStringEquals("alpha", res[1105].firstMatch("alpha"), 3392);
  assertToStringEquals("bh,", res[1106].firstMatch("abh"), 3393);
  assertToStringEquals("effgz,effgz,", res[1107].firstMatch("effgz"), 3394);
  assertToStringEquals("ij,ij,j", res[1107].firstMatch("ij"), 3395);
  assertToStringEquals("effgz,effgz,", res[1107].firstMatch("reffgz"), 3396);
  assertNull(res[1107].firstMatch("*** Failers"), 3397);
  assertNull(res[1107].firstMatch("effg"), 3398);
  assertNull(res[1107].firstMatch("bcdd"), 3399);
  assertToStringEquals("a,a,a,a,a,a,a,a,a,a,a", res[1108].firstMatch("a"), 3400);
  assertToStringEquals("a,a,a,a,a,a,a,a,a,a", res[1109].firstMatch("a"), 3401);
  assertNull(res[1110].firstMatch("*** Failers"), 3402);
  assertNull(res[1110].firstMatch("aa"), 3403);
  assertNull(res[1110].firstMatch("uh-uh"), 3404);
  assertToStringEquals("multiple words", res[1111].firstMatch("multiple words, yeah"), 3405);
  assertToStringEquals("abcde,ab,de", res[1112].firstMatch("abcde"), 3406);
  assertToStringEquals("(a, b),a,b", res[1113].firstMatch("(a, b)"), 3407);
  assertToStringEquals("abcd", res[1115].firstMatch("abcd"), 3408);
  assertToStringEquals("abcd,bc", res[1116].firstMatch("abcd"), 3409);
  assertToStringEquals("ac", res[1117].firstMatch("ac"), 3410);
  assertToStringEquals("ABC", res[1118].firstMatch("ABC"), 3411);
  assertToStringEquals("ABC", res[1118].firstMatch("XABCY"), 3412);
  assertToStringEquals("ABC", res[1118].firstMatch("ABABC"), 3413);
  assertNull(res[1118].firstMatch("*** Failers"), 3414);
  assertNull(res[1118].firstMatch("aaxabxbaxbbx"), 3415);
  assertNull(res[1118].firstMatch("XBC"), 3416);
  assertNull(res[1118].firstMatch("AXC"), 3417);
  assertNull(res[1118].firstMatch("ABX"), 3418);
  assertToStringEquals("ABC", res[1119].firstMatch("ABC"), 3419);
  assertToStringEquals("ABC", res[1120].firstMatch("ABC"), 3420);
  assertToStringEquals("ABBC", res[1120].firstMatch("ABBC"), 3421);
  assertToStringEquals("ABBBBC", res[1121].firstMatch("ABBBBC"), 3422);
  assertToStringEquals("ABBBBC", res[1122].firstMatch("ABBBBC"), 3423);
  assertToStringEquals("ABBC", res[1123].firstMatch("ABBC"), 3424);
  assertNull(res[1124].firstMatch("*** Failers"), 3425);
  assertNull(res[1124].firstMatch("ABC"), 3426);
  assertNull(res[1124].firstMatch("ABQ"), 3427);
  assertToStringEquals("ABBBBC", res[1126].firstMatch("ABBBBC"), 3428);
  assertToStringEquals("ABBBBC", res[1127].firstMatch("ABBBBC"), 3429);
  assertToStringEquals("ABBBBC", res[1128].firstMatch("ABBBBC"), 3430);
  assertToStringEquals("ABBBBC", res[1129].firstMatch("ABBBBC"), 3431);
  assertNull(res[1130].firstMatch("*** Failers"), 3432);
  assertNull(res[1130].firstMatch("ABQ"), 3433);
  assertNull(res[1130].firstMatch("ABBBBC"), 3434);
  assertToStringEquals("ABBC", res[1131].firstMatch("ABBC"), 3435);
  assertToStringEquals("ABC", res[1131].firstMatch("ABC"), 3436);
  assertToStringEquals("ABC", res[1132].firstMatch("ABC"), 3437);
  assertToStringEquals("ABC", res[1134].firstMatch("ABC"), 3438);
  assertToStringEquals("ABC", res[1135].firstMatch("ABC"), 3439);
  assertToStringEquals("ABC", res[1136].firstMatch("ABC"), 3440);
  assertNull(res[1136].firstMatch("*** Failers"), 3441);
  assertNull(res[1136].firstMatch("ABBBBC"), 3442);
  assertNull(res[1136].firstMatch("ABCC"), 3443);
  assertToStringEquals("ABC", res[1137].firstMatch("ABCC"), 3444);
  assertToStringEquals("ABC", res[1139].firstMatch("AABC"), 3445);
  assertToStringEquals("", res[1140].firstMatch("ABC"), 3446);
  assertToStringEquals("", res[1141].firstMatch("ABC"), 3447);
  assertToStringEquals("ABC", res[1142].firstMatch("ABC"), 3448);
  assertToStringEquals("AXC", res[1142].firstMatch("AXC"), 3449);
  assertToStringEquals("AXYZC", res[1143].firstMatch("AXYZC"), 3450);
  assertNull(res[1144].firstMatch("*** Failers"), 3451);
  assertToStringEquals("AABC", res[1144].firstMatch("AABC"), 3452);
  assertNull(res[1144].firstMatch("AXYZD"), 3453);
  assertToStringEquals("ABD", res[1145].firstMatch("ABD"), 3454);
  assertToStringEquals("ACE", res[1146].firstMatch("ACE"), 3455);
  assertNull(res[1146].firstMatch("*** Failers"), 3456);
  assertNull(res[1146].firstMatch("ABC"), 3457);
  assertNull(res[1146].firstMatch("ABD"), 3458);
  assertToStringEquals("AC", res[1147].firstMatch("AAC"), 3459);
  assertToStringEquals("A-", res[1148].firstMatch("A-"), 3460);
  assertToStringEquals("A-", res[1149].firstMatch("A-"), 3461);
  assertToStringEquals("A]", res[1150].firstMatch("A]"), 3462);
  assertNull(res[1151].firstMatch("A]B"), 3463);
  assertToStringEquals("AED", res[1152].firstMatch("AED"), 3464);
  assertToStringEquals("ADC", res[1153].firstMatch("ADC"), 3465);
  assertNull(res[1153].firstMatch("*** Failers"), 3466);
  assertNull(res[1153].firstMatch("ABD"), 3467);
  assertNull(res[1153].firstMatch("A-C"), 3468);
  assertNull(res[1154].firstMatch("ADC"), 3469);
  assertToStringEquals("AB", res[1155].firstMatch("ABC"), 3470);
  assertToStringEquals("AB", res[1155].firstMatch("ABCD"), 3471);
  assertToStringEquals("EF,", res[1156].firstMatch("DEF"), 3472);
  assertNull(res[1157].firstMatch("*** Failers"), 3473);
  assertNull(res[1157].firstMatch("A]C"), 3474);
  assertNull(res[1157].firstMatch("B"), 3475);
  assertToStringEquals("A(B", res[1158].firstMatch("A(B"), 3476);
  assertNull(res[1158].firstMatch("AB"), 3477);
  assertNull(res[1158].firstMatch("A((B"), 3478);
  assertNull(res[1159].firstMatch("AB"), 3479);
  assertToStringEquals("A,A,A", res[1160].firstMatch("ABC"), 3480);
  assertToStringEquals("ABC,A,C", res[1161].firstMatch("ABC"), 3481);
  assertToStringEquals("ABC", res[1162].firstMatch("AABBABC"), 3482);
  assertToStringEquals("ABC", res[1163].firstMatch("AABBABC"), 3483);
  assertToStringEquals("ABC", res[1164].firstMatch("ABCABC"), 3484);
  assertToStringEquals("ABC", res[1165].firstMatch("ABCABC"), 3485);
  assertToStringEquals("ABC", res[1166].firstMatch("ABCABC"), 3486);
  assertToStringEquals("AB,B", res[1167].firstMatch("AB"), 3487);
  assertToStringEquals("AB,B", res[1168].firstMatch("AB"), 3488);
  assertToStringEquals("AB,B", res[1169].firstMatch("AB"), 3489);
  assertToStringEquals("AB,B", res[1170].firstMatch("AB"), 3490);
  assertToStringEquals("A,A", res[1171].firstMatch("AB"), 3491);
  assertToStringEquals("A,A", res[1172].firstMatch("AB"), 3492);
  assertToStringEquals(",", res[1173].firstMatch("AB"), 3493);
  assertToStringEquals("CDE", res[1174].firstMatch("CDE"), 3494);
  assertToStringEquals("ABBBCD,C", res[1177].firstMatch("ABBBCD"), 3495);
  assertToStringEquals("ABCD,A", res[1178].firstMatch("ABCD"), 3496);
  assertToStringEquals("E", res[1179].firstMatch("E"), 3497);
  assertToStringEquals("EF,E", res[1180].firstMatch("EF"), 3498);
  assertToStringEquals("ABCDEFG", res[1181].firstMatch("ABCDEFG"), 3499);
  assertToStringEquals("AB", res[1182].firstMatch("XABYABBBZ"), 3500);
  assertToStringEquals("A", res[1182].firstMatch("XAYABBBZ"), 3501);
  assertToStringEquals("CDE,CD", res[1183].firstMatch("ABCDE"), 3502);
  assertToStringEquals("HIJ", res[1184].firstMatch("HIJ"), 3503);
  assertNull(res[1185].firstMatch("ABCDE"), 3504);
  assertToStringEquals("EF,", res[1186].firstMatch("ABCDEF"), 3505);
  assertToStringEquals("BCD,B", res[1187].firstMatch("ABCD"), 3506);
  assertToStringEquals("ABC,A", res[1188].firstMatch("ABC"), 3507);
  assertToStringEquals("ABC,BC", res[1189].firstMatch("ABC"), 3508);
  assertToStringEquals("ABCD,BC,D", res[1190].firstMatch("ABCD"), 3509);
  assertToStringEquals("ABCD,BC,D", res[1191].firstMatch("ABCD"), 3510);
  assertToStringEquals("ABCD,B,CD", res[1192].firstMatch("ABCD"), 3511);
  assertToStringEquals("ADCDCDE", res[1193].firstMatch("ADCDCDE"), 3512);
  assertToStringEquals("ABC,AB", res[1195].firstMatch("ABC"), 3513);
  assertToStringEquals("ABCD,ABC,A,B,D", res[1196].firstMatch("ABCD"), 3514);
  assertToStringEquals("ALPHA", res[1197].firstMatch("ALPHA"), 3515);
  assertToStringEquals("BH,", res[1198].firstMatch("ABH"), 3516);
  assertToStringEquals("EFFGZ,EFFGZ,", res[1199].firstMatch("EFFGZ"), 3517);
  assertToStringEquals("IJ,IJ,J", res[1199].firstMatch("IJ"), 3518);
  assertToStringEquals("EFFGZ,EFFGZ,", res[1199].firstMatch("REFFGZ"), 3519);
  assertNull(res[1199].firstMatch("*** Failers"), 3520);
  assertNull(res[1199].firstMatch("ADCDCDE"), 3521);
  assertNull(res[1199].firstMatch("EFFG"), 3522);
  assertNull(res[1199].firstMatch("BCDD"), 3523);
  assertToStringEquals("A,A,A,A,A,A,A,A,A,A,A", res[1200].firstMatch("A"), 3524);
  assertToStringEquals("A,A,A,A,A,A,A,A,A,A", res[1201].firstMatch("A"), 3525);
  assertToStringEquals("A,A", res[1202].firstMatch("A"), 3526);
  assertToStringEquals("C,C", res[1203].firstMatch("C"), 3527);
  assertNull(res[1204].firstMatch("*** Failers"), 3528);
  assertNull(res[1204].firstMatch("AA"), 3529);
  assertNull(res[1204].firstMatch("UH-UH"), 3530);
  assertToStringEquals("MULTIPLE WORDS", res[1205].firstMatch("MULTIPLE WORDS, YEAH"), 3531);
  assertToStringEquals("ABCDE,AB,DE", res[1206].firstMatch("ABCDE"), 3532);
  assertToStringEquals("(A, B),A,B", res[1207].firstMatch("(A, B)"), 3533);
  assertToStringEquals("ABCD", res[1209].firstMatch("ABCD"), 3534);
  assertToStringEquals("ABCD,BC", res[1210].firstMatch("ABCD"), 3535);
  assertToStringEquals("AC", res[1211].firstMatch("AC"), 3536);
  assertToStringEquals("ad", res[1212].firstMatch("abad"), 3537);
  assertToStringEquals("ad", res[1213].firstMatch("abad"), 3538);
  assertToStringEquals("ad", res[1214].firstMatch("abad"), 3539);
  assertToStringEquals("ace,e", res[1215].firstMatch("ace"), 3540);
  assertToStringEquals("ace,e", res[1216].firstMatch("ace"), 3541);
  assertToStringEquals("ace,e", res[1217].firstMatch("ace"), 3542);
  assertToStringEquals("acd,d", res[1217].firstMatch("acdbcdbe"), 3543);
  assertToStringEquals("acdbcdbe,e", res[1218].firstMatch("acdbcdbe"), 3544);
  assertToStringEquals("acdb,b", res[1219].firstMatch("acdbcdbe"), 3545);
  assertToStringEquals("acdbcdb,b", res[1220].firstMatch("acdbcdbe"), 3546);
  assertToStringEquals("acdbcd,d", res[1221].firstMatch("acdbcdbe"), 3547);
  assertToStringEquals("foobar,bar,,bar", res[1222].firstMatch("foobar"), 3548);
  assertToStringEquals("acdbcdbe,e", res[1223].firstMatch("acdbcdbe"), 3549);
  assertToStringEquals("acdbcdbe,e", res[1224].firstMatch("acdbcdbe"), 3550);
  assertToStringEquals("acdbcdbe,e", res[1225].firstMatch("acdbcdbe"), 3551);
  assertToStringEquals("acdbcdb,b", res[1226].firstMatch("acdbcdbe"), 3552);
  assertToStringEquals("acdbcdbe,e", res[1227].firstMatch("acdbcdbe"), 3553);
  assertToStringEquals("acdbcdb,b", res[1228].firstMatch("acdbcdbe"), 3554);
  assertToStringEquals("ace,c,e", res[1229].firstMatch("ace"), 3555);
  assertToStringEquals("AB,A", res[1230].firstMatch("AB"), 3556);
  assertToStringEquals(".,.,", res[1231].firstMatch("."), 3557);
  assertToStringEquals("<&", res[1232].firstMatch("<&OUT"), 3558);
  assertToStringEquals("foobar,,,,b,a,r", res[1233].firstMatch("foobar"), 3559);
  assertToStringEquals(",,,,,,", res[1233].firstMatch("ab"), 3560);
  assertToStringEquals(",,,,,,", res[1233].firstMatch("*** Failers"), 3561);
  assertToStringEquals(",,,,,,", res[1233].firstMatch("cb"), 3562);
  assertToStringEquals(",,,,,,", res[1233].firstMatch("b"), 3563);
  assertToStringEquals(",,,,,,", res[1233].firstMatch("ab"), 3564);
  assertToStringEquals(",,,,,,", res[1233].firstMatch("b"), 3565);
  assertToStringEquals(",,,,,,", res[1233].firstMatch("b"), 3566);
  assertToStringEquals("aba", res[1234].firstMatch("aba"), 3567);
  assertToStringEquals("a", res[1235].firstMatch("aba"), 3568);
  assertToStringEquals(",", res[1236].firstMatch("abc"), 3569);
  assertToStringEquals("aax,a", res[1237].firstMatch("aax"), 3570);
  assertToStringEquals("aax,a,a", res[1238].firstMatch("aax"), 3571);
  assertToStringEquals("aax,a,a", res[1239].firstMatch("aax"), 3572);
  assertToStringEquals("ab,", res[1240].firstMatch("cab"), 3573);
  assertToStringEquals("ab,", res[1241].firstMatch("cab"), 3574);
  assertToStringEquals("ab,", res[1241].firstMatch("ab"), 3575);
  assertToStringEquals("ab,", res[1241].firstMatch("ab"), 3576);
  assertNull(res[1241].firstMatch("Ab"), 3577);
  assertNull(res[1241].firstMatch("Ab"), 3578);
  assertNull(res[1241].firstMatch("*** Failers"), 3579);
  assertNull(res[1241].firstMatch("cb"), 3580);
  assertNull(res[1241].firstMatch("aB"), 3581);
  assertToStringEquals("ab,", res[1241].firstMatch("ab"), 3582);
  assertToStringEquals("ab,", res[1241].firstMatch("ab"), 3583);
  assertNull(res[1241].firstMatch("Ab"), 3584);
  assertNull(res[1241].firstMatch("Ab"), 3585);
  assertNull(res[1241].firstMatch("*** Failers"), 3586);
  assertNull(res[1241].firstMatch("aB"), 3587);
  assertNull(res[1241].firstMatch("aB"), 3588);
  assertToStringEquals("ab,", res[1241].firstMatch("ab"), 3589);
  assertToStringEquals("ab,", res[1241].firstMatch("ab"), 3590);
  assertNull(res[1241].firstMatch("aB"), 3591);
  assertNull(res[1241].firstMatch("aB"), 3592);
  assertNull(res[1241].firstMatch("*** Failers"), 3593);
  assertNull(res[1241].firstMatch("aB"), 3594);
  assertNull(res[1241].firstMatch("Ab"), 3595);
  assertNull(res[1241].firstMatch("aB"), 3596);
  assertNull(res[1241].firstMatch("aB"), 3597);
  assertNull(res[1241].firstMatch("*** Failers"), 3598);
  assertNull(res[1241].firstMatch("Ab"), 3599);
  assertNull(res[1241].firstMatch("AB"), 3600);
  assertToStringEquals("ab,", res[1241].firstMatch("ab"), 3601);
  assertToStringEquals("ab,", res[1241].firstMatch("ab"), 3602);
  assertNull(res[1241].firstMatch("aB"), 3603);
  assertNull(res[1241].firstMatch("aB"), 3604);
  assertNull(res[1241].firstMatch("*** Failers"), 3605);
  assertNull(res[1241].firstMatch("AB"), 3606);
  assertNull(res[1241].firstMatch("Ab"), 3607);
  assertNull(res[1241].firstMatch("aB"), 3608);
  assertNull(res[1241].firstMatch("aB"), 3609);
  assertNull(res[1241].firstMatch("*** Failers"), 3610);
  assertNull(res[1241].firstMatch("Ab"), 3611);
  assertNull(res[1241].firstMatch("AB"), 3612);
  assertNull(res[1241].firstMatch("*** Failers"), 3613);
  assertNull(res[1241].firstMatch("AB"), 3614);
  assertNull(res[1241].firstMatch("a\nB"), 3615);
  assertNull(res[1241].firstMatch("a\nB"), 3616);
  assertToStringEquals("cabbbb", res[1242].firstMatch("cabbbb"), 3617);
  assertToStringEquals("caaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb", res[1243].firstMatch("caaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb"), 3618);
  assertToStringEquals("foobar1234baz", res[1244].firstMatch("foobar1234baz"), 3619);
  assertToStringEquals("x~~,~~", res[1245].firstMatch("x~~"), 3620);
  assertToStringEquals("aaac", res[1246].firstMatch("aaac"), 3621);
  assertToStringEquals("aaac", res[1247].firstMatch("aaac"), 3622);
  assertNull(res[1247].firstMatch("*** Failers"), 3623);
  assertNull(res[1247].firstMatch("B\nB"), 3624);
  assertNull(res[1247].firstMatch("dbcb"), 3625);
  assertNull(res[1247].firstMatch("dbaacb"), 3626);
  assertNull(res[1247].firstMatch("dbaacb"), 3627);
  assertNull(res[1247].firstMatch("cdaccb"), 3628);
  assertNull(res[1248].firstMatch("*** Failers"), 3629);
  assertNull(res[1248].firstMatch("dbcb"), 3630);
  assertNull(res[1248].firstMatch("a--"), 3631);
  assertNull(res[1248].firstMatch("a\nb\nc\n"), 3632);
  assertNull(res[1248].firstMatch("a\nb\nc\n"), 3633);
  assertNull(res[1248].firstMatch("a\nb\n"), 3634);
  assertNull(res[1248].firstMatch("a\nb\n"), 3635);
  assertNull(res[1248].firstMatch("a\nb\n"), 3636);
  assertNull(res[1248].firstMatch("a\nb\n"), 3637);
  assertNull(res[1248].firstMatch("a\nb\nc\n"), 3638);
  assertNull(res[1248].firstMatch("a\nb\nc\n"), 3639);
  assertNull(res[1248].firstMatch("a\nb\nc\n"), 3640);
  assertNull(res[1248].firstMatch("a\nb\nc\n"), 3641);
  assertNull(res[1250].firstMatch("*** Failers"), 3642);
  assertNull(res[1250].firstMatch("a\nb\nc\n"), 3643);
  assertNull(res[1250].firstMatch("a\nb\nc\n"), 3644);
  assertNull(res[1250].firstMatch("a\nb\nc\n"), 3645);
  assertNull(res[1250].firstMatch("a"), 3646);
  assertNull(res[1250].firstMatch("*** Failers"), 3647);
  assertNull(res[1250].firstMatch("a"), 3648);
  assertNull(res[1250].firstMatch("a"), 3649);
  assertNull(res[1250].firstMatch("a"), 3650);
  assertToStringEquals("one:,one:", res[1251].firstMatch("one:"), 3651);
  assertNull(res[1251].firstMatch("a"), 3652);
  assertToStringEquals("abcd,,abcd", res[1252].firstMatch("abcd"), 3653);
  assertToStringEquals("xy:z:::abcd,xy:z:::,abcd", res[1252].firstMatch("xy:z:::abcd"), 3654);
  assertToStringEquals("aexyc,c", res[1253].firstMatch("aexycd"), 3655);
  assertToStringEquals("aab,aa", res[1254].firstMatch("caab"), 3656);
  assertToStringEquals("abcd,,abcd", res[1255].firstMatch("abcd"), 3657);
  assertToStringEquals("xy:z:::abcd,xy:z:::,abcd", res[1255].firstMatch("xy:z:::abcd"), 3658);
  assertToStringEquals("Failers,,Failers", res[1255].firstMatch("*** Failers"), 3659);
  assertNull(res[1255].firstMatch("abcd:"), 3660);
  assertNull(res[1255].firstMatch("abcd:"), 3661);
  assertToStringEquals("aexyc,c", res[1256].firstMatch("aexycd"), 3662);
  assertNull(res[1257].firstMatch("aaab"), 3663);
  assertToStringEquals(":[,:[", res[1258].firstMatch("a:[b]:"), 3664);
  assertToStringEquals("=[,=[", res[1259].firstMatch("a=[b]="), 3665);
  assertToStringEquals(".[,.[", res[1260].firstMatch("a.[b]."), 3666);
  assertNull(res[1260].firstMatch("aaab"), 3667);
  assertNull(res[1260].firstMatch("aaab"), 3668);
  assertNull(res[1260].firstMatch("((abc(ade)ufh()()x"), 3669);
  assertNull(res[1261].firstMatch("*** Failers"), 3670);
  assertNull(res[1261].firstMatch("aaab"), 3671);
  assertNull(res[1261].firstMatch("a\nb\n"), 3672);
  assertNull(res[1262].firstMatch("a\nb\n"), 3673);
  assertNull(res[1264].firstMatch("a\nb"), 3674);
  assertNull(res[1265].firstMatch("a\nb"), 3675);
  assertNull(res[1265].firstMatch("*** Failers"), 3676);
  assertNull(res[1265].firstMatch("alphabetabcd"), 3677);
  assertNull(res[1265].firstMatch("endingwxyz"), 3678);
  assertNull(res[1265].firstMatch("*** Failers"), 3679);
  assertNull(res[1265].firstMatch("a rather long string that doesn't end with one of them"), 3680);
  assertNull(res[1265].firstMatch("word cat dog elephant mussel cow horse canary baboon snake shark otherword"), 3681);
  assertNull(res[1265].firstMatch("word cat dog elephant mussel cow horse canary baboon snake shark"), 3682);
  assertNull(res[1265].firstMatch("word cat dog elephant mussel cow horse canary baboon snake shark the quick brown fox and the lazy dog and several other words getting close to thirty by now I hope"), 3683);
  assertNull(res[1265].firstMatch("999foo"), 3684);
  assertNull(res[1265].firstMatch("123999foo "), 3685);
  assertNull(res[1265].firstMatch("*** Failers"), 3686);
  assertNull(res[1265].firstMatch("123abcfoo"), 3687);
  assertNull(res[1265].firstMatch("999foo"), 3688);
  assertNull(res[1265].firstMatch("123999foo "), 3689);
  assertNull(res[1265].firstMatch("*** Failers"), 3690);
  assertNull(res[1265].firstMatch("123abcfoo"), 3691);
  assertNull(res[1265].firstMatch("123abcfoo"), 3692);
  assertNull(res[1265].firstMatch("123456foo "), 3693);
  assertNull(res[1265].firstMatch("*** Failers"), 3694);
  assertNull(res[1265].firstMatch("123999foo  "), 3695);
  assertNull(res[1265].firstMatch("123abcfoo   "), 3696);
  assertNull(res[1265].firstMatch("123456foo "), 3697);
  assertNull(res[1265].firstMatch("*** Failers"), 3698);
  assertNull(res[1265].firstMatch("123999foo  "), 3699);
  assertToStringEquals("ZA,A,", res[1266].firstMatch("ZABCDEFG"), 3700);
  assertToStringEquals("ZA,A,", res[1267].firstMatch("ZABCDEFG"), 3701);
  assertToStringEquals("ZA,A,,", res[1268].firstMatch("ZABCDEFG"), 3702);
  assertToStringEquals("ZA,A,,", res[1268].firstMatch("ZABCDEFG"), 3703);
  assertToStringEquals("ZA,A,,", res[1268].firstMatch("ZABCDEFG"), 3704);
  assertToStringEquals("a", res[1269].firstMatch("abbab"), 3705);
  assertToStringEquals("a", res[1270].firstMatch("abcde"), 3711);
  assertToStringEquals("-", res[1270].firstMatch("-things"), 3712);
  assertToStringEquals("0", res[1270].firstMatch("0digit"), 3713);
  assertNull(res[1270].firstMatch("*** Failers"), 3714);
  assertNull(res[1270].firstMatch("bcdef    "), 3715);
  assertNull(res[1271].firstMatch("> \x09\n\x0c\x0d\x0b<"), 3716);
  assertNull(res[1271].firstMatch(" "), 3717);
  assertNull(res[1272].firstMatch("> \x09\n\x0c\x0d\x0b<"), 3718);
  assertNull(res[1272].firstMatch(" "), 3719);
  assertToStringEquals(" \x09\n\x0c\x0d\x0b", res[1273].firstMatch("> \x09\n\x0c\x0d\x0b<"), 3720);
  assertToStringEquals(" ", res[1273].firstMatch(" "), 3721);
  assertToStringEquals(" \x09\n\x0c\x0d\x0b", res[1274].firstMatch("> \x09\n\x0c\x0d\x0b<"), 3722);
  assertToStringEquals(" ", res[1274].firstMatch(" "), 3723);
  assertNull(res[1275].firstMatch("ab"), 3724);
  assertNull(res[1278].firstMatch("abcabcabc"), 3725);
  assertNull(res[1278].firstMatch("abc(*+|abc "), 3726);
  assertNull(res[1279].firstMatch("abc abcabc"), 3727);
  assertNull(res[1279].firstMatch("*** Failers"), 3728);
  assertNull(res[1279].firstMatch("abcabcabc  "), 3729);
  assertNull(res[1280].firstMatch("abc#not comment\n    literal     "), 3730);
  assertNull(res[1281].firstMatch("abc#not comment\n    literal     "), 3731);
  assertNull(res[1282].firstMatch("abc#not comment\n    literal     "), 3732);
  assertNull(res[1283].firstMatch("abc#not comment\n    literal     "), 3733);
  assertNull(res[1284].firstMatch("abc\\\$xyz"), 3734);
  assertNull(res[1285].firstMatch("abc\\\$xyz"), 3735);
  assertNull(res[1286].firstMatch("abc"), 3736);
  assertNull(res[1286].firstMatch("*** Failers"), 3737);
  assertNull(res[1286].firstMatch("xyzabc  "), 3738);
  assertNull(res[1287].firstMatch("abc1abc2xyzabc3"), 3739);
  assertToStringEquals("abc1", res[1288].firstMatch("abc1abc2xyzabc3 "), 3740);
  assertNull(res[1288].firstMatch("*** Failers "), 3742);
  assertNull(res[1288].firstMatch("Xa b c d Y "), 3743);
  assertToStringEquals("abcY", res[1288].firstMatch("XabcY"), 3744);
  assertNull(res[1288].firstMatch("AxyzB "), 3745);
  assertNull(res[1288].firstMatch("XabCY"), 3746);
  assertNull(res[1288].firstMatch("*** Failers"), 3747);
  assertToStringEquals("abcY", res[1288].firstMatch("XabcY  "), 3748);
  assertNull(res[1288].firstMatch("abCE"), 3749);
  assertNull(res[1288].firstMatch("DE"), 3750);
  assertNull(res[1288].firstMatch("*** Failers"), 3751);
  assertToStringEquals("abcE", res[1288].firstMatch("abcE"), 3752);
  assertNull(res[1288].firstMatch("abCe  "), 3753);
  assertNull(res[1288].firstMatch("dE"), 3754);
  assertNull(res[1288].firstMatch("De    "), 3755);
  assertNull(res[1289].firstMatch("z"), 3756);
  assertNull(res[1289].firstMatch("a"), 3757);
  assertNull(res[1289].firstMatch("-"), 3758);
  assertNull(res[1289].firstMatch("d"), 3759);
  assertNull(res[1289].firstMatch("] "), 3760);
  assertNull(res[1289].firstMatch("*** Failers"), 3761);
  assertNull(res[1289].firstMatch("b     "), 3762);
  assertToStringEquals("z", res[1290].firstMatch("z"), 3763);
  assertToStringEquals("C", res[1290].firstMatch("C "), 3764);
  assertToStringEquals("M", res[1291].firstMatch("M "), 3765);
  assertNull(res[1292].firstMatch(""), 3766);
  assertNull(res[1292].firstMatch("REGular"), 3767);
  assertNull(res[1292].firstMatch("regulaer"), 3768);
  assertNull(res[1292].firstMatch("Regex  "), 3769);
  assertNull(res[1292].firstMatch("regul\ufffdr "), 3770);
  assertNull(res[1292].firstMatch("\ufffd\ufffd\ufffd\ufffd\ufffd"), 3771);
  assertNull(res[1292].firstMatch("\ufffd\ufffd\ufffd\ufffd\ufffd"), 3772);
  assertNull(res[1292].firstMatch("\ufffd\ufffd\ufffd\ufffd\ufffd"), 3773);
  assertNull(res[1292].firstMatch("\ufffd\ufffd\ufffd\ufffd\ufffd"), 3774);
  assertNull(res[1292].firstMatch("\x84XAZXB"), 3775);
  assertNull(res[1292].firstMatch("123a"), 3776);
  assertNull(res[1292].firstMatch("ac"), 3777);
  assertToStringEquals("b,", res[1292].firstMatch("bbbbc"), 3778);
  assertToStringEquals("ab,a", res[1292].firstMatch("abc"), 3779);
  assertNull(res[1292].firstMatch("*** Failers"), 3780);
  assertToStringEquals("b,", res[1292].firstMatch("bca"), 3781);
  assertNull(res[1292].firstMatch(""), 3782);
  assertToStringEquals("ab,a", res[1292].firstMatch("abc"), 3783);
  assertNull(res[1292].firstMatch("*** Failers"), 3784);
  assertToStringEquals("b,", res[1292].firstMatch("bca"), 3785);
  assertToStringEquals("ab,a", res[1292].firstMatch("abc"), 3786);
  assertNull(res[1292].firstMatch("*** Failers"), 3787);
  assertNull(res[1292].firstMatch("def  "), 3788);
  assertNull(res[1292].firstMatch(""), 3789);
  assertToStringEquals("ab,a", res[1292].firstMatch("abc"), 3790);
  assertNull(res[1292].firstMatch("*** Failers"), 3791);
  assertNull(res[1292].firstMatch("def  "), 3792);
  assertNull(res[1292].firstMatch(""), 3793);
  assertToStringEquals("line\nbreak", res[1293].firstMatch("this is a line\nbreak"), 3794);
  assertToStringEquals("line\nbreak", res[1293].firstMatch("line one\nthis is a line\nbreak in the second line "), 3795);
  assertToStringEquals("line\nbreak", res[1294].firstMatch("this is a line\nbreak"), 3796);
  assertNull(res[1294].firstMatch("** Failers "), 3797);
  assertToStringEquals("line\nbreak", res[1294].firstMatch("line one\nthis is a line\nbreak in the second line "), 3798);
  assertToStringEquals("line\nbreak", res[1295].firstMatch("this is a line\nbreak"), 3799);
  assertNull(res[1295].firstMatch("** Failers "), 3800);
  assertToStringEquals("line\nbreak", res[1295].firstMatch("line one\nthis is a line\nbreak in the second line "), 3801);
  assertNull(res[1296].firstMatch("123P"), 3802);
  assertNull(res[1296].firstMatch("a4PR"), 3803);
  assertNull(res[1297].firstMatch("123P"), 3804);
  assertNull(res[1297].firstMatch("4PR"), 3805);
  assertToStringEquals("", res[1298].firstMatch("a\nb\nc\n"), 3806);
  assertToStringEquals("", res[1298].firstMatch(" "), 3807);
  assertToStringEquals("", res[1298].firstMatch("A\nC\nC\n "), 3808);
  assertToStringEquals("", res[1298].firstMatch("AB"), 3809);
  assertToStringEquals("", res[1298].firstMatch("aB  "), 3810);
  assertToStringEquals("", res[1298].firstMatch("AB"), 3811);
  assertToStringEquals("", res[1298].firstMatch("aB  "), 3812);
  assertToStringEquals("", res[1298].firstMatch("AB"), 3813);
  assertToStringEquals("", res[1298].firstMatch("aB  "), 3814);
  assertToStringEquals("", res[1298].firstMatch("AB"), 3815);
  assertToStringEquals("", res[1298].firstMatch("aB  "), 3816);
  assertToStringEquals("Content-Type:xxxxxyyy ", res[1299].firstMatch("Content-Type:xxxxxyyy "), 3817);
  assertToStringEquals("Content-Type:xxxxxyyyz", res[1300].firstMatch("Content-Type:xxxxxyyyz"), 3818);
  assertToStringEquals("Content-Type:xxxyyy ", res[1301].firstMatch("Content-Type:xxxyyy "), 3819);
  assertToStringEquals("Content-Type:xxxyyyz", res[1302].firstMatch("Content-Type:xxxyyyz"), 3820);
  assertToStringEquals("abc", res[1303].firstMatch("xyz\nabc"), 3821);
  assertToStringEquals("abc", res[1303].firstMatch("xyz\nabc<lf>"), 3822);
  assertToStringEquals("abc", res[1303].firstMatch("xyz\x0d\nabc<lf>"), 3823);
  assertToStringEquals("abc", res[1303].firstMatch("xyz\x0dabc<cr>"), 3824);
  assertToStringEquals("abc", res[1303].firstMatch("xyz\x0d\nabc<crlf>"), 3825);
  assertNull(res[1303].firstMatch("** Failers "), 3826);
  assertToStringEquals("abc", res[1303].firstMatch("xyz\nabc<cr>"), 3827);
  assertToStringEquals("abc", res[1303].firstMatch("xyz\x0d\nabc<cr>"), 3828);
  assertToStringEquals("abc", res[1303].firstMatch("xyz\nabc<crlf>"), 3829);
  assertToStringEquals("abc", res[1303].firstMatch("xyz\x0dabc<crlf>"), 3830);
  assertToStringEquals("abc", res[1303].firstMatch("xyz\x0dabc<lf>"), 3831);
  assertToStringEquals("abc", res[1304].firstMatch("xyzabc"), 3832);
  assertToStringEquals("abc", res[1304].firstMatch("xyzabc\n "), 3833);
  assertToStringEquals("abc", res[1304].firstMatch("xyzabc\npqr "), 3834);
  assertToStringEquals("abc", res[1304].firstMatch("xyzabc\x0d<cr> "), 3835);
  assertToStringEquals("abc", res[1304].firstMatch("xyzabc\x0dpqr<cr> "), 3836);
  assertToStringEquals("abc", res[1304].firstMatch("xyzabc\x0d\n<crlf> "), 3837);
  assertToStringEquals("abc", res[1304].firstMatch("xyzabc\x0d\npqr<crlf> "), 3838);
  assertNull(res[1304].firstMatch("** Failers"), 3839);
  assertToStringEquals("abc", res[1304].firstMatch("xyzabc\x0d "), 3840);
  assertToStringEquals("abc", res[1304].firstMatch("xyzabc\x0dpqr "), 3841);
  assertToStringEquals("abc", res[1304].firstMatch("xyzabc\x0d\n "), 3842);
  assertToStringEquals("abc", res[1304].firstMatch("xyzabc\x0d\npqr "), 3843);
  assertToStringEquals("abc", res[1305].firstMatch("xyz\x0dabcdef"), 3844);
  assertToStringEquals("abc", res[1305].firstMatch("xyz\nabcdef<lf>"), 3845);
  assertNull(res[1305].firstMatch("** Failers  "), 3846);
  assertToStringEquals("abc", res[1305].firstMatch("xyz\nabcdef"), 3847);
  assertNull(res[1305].firstMatch("   "), 3848);
  assertToStringEquals("abc", res[1306].firstMatch("xyz\nabcdef"), 3849);
  assertToStringEquals("abc", res[1306].firstMatch("xyz\x0dabcdef<cr>"), 3850);
  assertNull(res[1306].firstMatch("** Failers  "), 3851);
  assertToStringEquals("abc", res[1306].firstMatch("xyz\x0dabcdef"), 3852);
  assertNull(res[1306].firstMatch("   "), 3853);
  assertToStringEquals("abc", res[1307].firstMatch("xyz\x0d\nabcdef"), 3854);
  assertToStringEquals("abc", res[1307].firstMatch("xyz\x0dabcdef<cr>"), 3855);
  assertNull(res[1307].firstMatch("** Failers  "), 3856);
  assertToStringEquals("abc", res[1307].firstMatch("xyz\x0dabcdef"), 3857);
  assertToStringEquals("abc", res[1308].firstMatch("abc\ndef"), 3858);
  assertToStringEquals("abc", res[1308].firstMatch("abc\x0ddef"), 3859);
  assertToStringEquals("abc", res[1308].firstMatch("abc\x0d\ndef"), 3860);
  assertToStringEquals("<cr>abc", res[1308].firstMatch("<cr>abc\ndef"), 3861);
  assertToStringEquals("<cr>abc", res[1308].firstMatch("<cr>abc\x0ddef"), 3862);
  assertToStringEquals("<cr>abc", res[1308].firstMatch("<cr>abc\x0d\ndef"), 3863);
  assertToStringEquals("<crlf>abc", res[1308].firstMatch("<crlf>abc\ndef"), 3864);
  assertToStringEquals("<crlf>abc", res[1308].firstMatch("<crlf>abc\x0ddef"), 3865);
  assertToStringEquals("<crlf>abc", res[1308].firstMatch("<crlf>abc\x0d\ndef"), 3866);
  assertNull(res[1309].firstMatch("abc\ndef"), 3867);
  assertNull(res[1309].firstMatch("abc\x0ddef"), 3868);
  assertNull(res[1309].firstMatch("abc\x0d\ndef"), 3869);
  assertToStringEquals("abc=xyz\\,", res[1310].firstMatch("abc=xyz\\\npqr"), 3870);
  assertToStringEquals("aaaa,a,", res[1311].firstMatch("aaaa"), 3871);
  assertToStringEquals("aaaa", res[1312].firstMatch("aaaa"), 3872);
  assertToStringEquals("aaaa,a,", res[1313].firstMatch("aaaa"), 3873);
  assertToStringEquals("aaaa", res[1314].firstMatch("aaaa"), 3874);
  assertNull(res[1317].firstMatch("a\x0db"), 3875);
  assertNull(res[1317].firstMatch("a\nb<cr> "), 3876);
  assertNull(res[1317].firstMatch("** Failers"), 3877);
  assertNull(res[1317].firstMatch("a\nb"), 3878);
  assertNull(res[1317].firstMatch("a\nb<any>"), 3879);
  assertNull(res[1317].firstMatch("a\x0db<cr>   "), 3880);
  assertNull(res[1317].firstMatch("a\x0db<any>   "), 3881);
  assertToStringEquals("abc1", res[1318].firstMatch("abc1 \nabc2 \x0babc3xx \x0cabc4 \x0dabc5xx \x0d\nabc6 \x85abc7 JUNK"), 3882);
  assertToStringEquals("abc1", res[1319].firstMatch("abc1\n abc2\x0b abc3\x0c abc4\x0d abc5\x0d\n abc6\x85 abc9"), 3883);
  assertNull(res[1320].firstMatch("a\nb"), 3884);
  assertNull(res[1320].firstMatch("a\x0db"), 3885);
  assertNull(res[1320].firstMatch("a\x0d\nb"), 3886);
  assertNull(res[1320].firstMatch("a\x0bb"), 3887);
  assertNull(res[1320].firstMatch("a\x0cb"), 3888);
  assertNull(res[1320].firstMatch("a\x85b   "), 3889);
  assertNull(res[1320].firstMatch("** Failers"), 3890);
  assertNull(res[1320].firstMatch("a\n\x0db    "), 3891);
  assertToStringEquals("ab", res[1321].firstMatch("ab"), 3892);
  assertNull(res[1321].firstMatch("a\nb"), 3893);
  assertNull(res[1321].firstMatch("a\x0db"), 3894);
  assertNull(res[1321].firstMatch("a\x0d\nb"), 3895);
  assertNull(res[1321].firstMatch("a\x0bb"), 3896);
  assertNull(res[1321].firstMatch("a\x0cb"), 3897);
  assertNull(res[1321].firstMatch("a\x85b   "), 3898);
  assertNull(res[1321].firstMatch("a\n\x0db    "), 3899);
  assertNull(res[1321].firstMatch("a\n\x0d\x85\x0cb "), 3900);
  assertNull(res[1322].firstMatch("a\nb"), 3901);
  assertNull(res[1322].firstMatch("a\x0db"), 3902);
  assertNull(res[1322].firstMatch("a\x0d\nb"), 3903);
  assertNull(res[1322].firstMatch("a\x0bb"), 3904);
  assertNull(res[1322].firstMatch("a\x0cb"), 3905);
  assertNull(res[1322].firstMatch("a\x85b   "), 3906);
  assertNull(res[1322].firstMatch("a\n\x0db    "), 3907);
  assertNull(res[1322].firstMatch("a\n\x0d\x85\x0cb "), 3908);
  assertNull(res[1322].firstMatch("** Failers"), 3909);
  assertNull(res[1322].firstMatch("ab  "), 3910);
  assertNull(res[1323].firstMatch("a\nb"), 3911);
  assertNull(res[1323].firstMatch("a\n\x0db"), 3912);
  assertNull(res[1323].firstMatch("a\n\x0d\x85b"), 3913);
  assertNull(res[1323].firstMatch("a\x0d\n\x0d\nb "), 3914);
  assertNull(res[1323].firstMatch("a\x0d\n\x0d\n\x0d\nb "), 3915);
  assertNull(res[1323].firstMatch("a\n\x0d\n\x0db"), 3916);
  assertNull(res[1323].firstMatch("a\n\n\x0d\nb "), 3917);
  assertNull(res[1323].firstMatch("** Failers"), 3918);
  assertNull(res[1323].firstMatch("a\n\n\n\x0db"), 3919);
  assertNull(res[1323].firstMatch("a\x0d"), 3920);
  assertToStringEquals("aRb", res[1324].firstMatch("aRb"), 3921);
  assertNull(res[1324].firstMatch("** Failers"), 3922);
  assertNull(res[1324].firstMatch("a\nb  "), 3923);
  assertToStringEquals("afoo", res[1325].firstMatch("afoo"), 3924);
  assertNull(res[1325].firstMatch("** Failers "), 3925);
  assertNull(res[1325].firstMatch("\x0d\nfoo "), 3926);
  assertNull(res[1325].firstMatch("\nfoo "), 3927);
  assertToStringEquals("afoo", res[1326].firstMatch("afoo"), 3928);
  assertNull(res[1326].firstMatch("\nfoo "), 3929);
  assertNull(res[1326].firstMatch("** Failers "), 3930);
  assertNull(res[1326].firstMatch("\x0d\nfoo "), 3931);
  assertToStringEquals("afoo", res[1327].firstMatch("afoo"), 3932);
  assertNull(res[1327].firstMatch("** Failers "), 3933);
  assertNull(res[1327].firstMatch("\nfoo "), 3934);
  assertNull(res[1327].firstMatch("\x0d\nfoo "), 3935);
  assertToStringEquals("afoo", res[1328].firstMatch("afoo"), 3936);
  assertNull(res[1328].firstMatch("\x0d\nfoo "), 3937);
  assertNull(res[1328].firstMatch("\nfoo "), 3938);
  assertToStringEquals("", res[1329].firstMatch("abc\x0d\x0dxyz"), 3939);
  assertToStringEquals("", res[1329].firstMatch("abc\n\x0dxyz  "), 3940);
  assertNull(res[1329].firstMatch("** Failers "), 3941);
  assertToStringEquals("", res[1329].firstMatch("abc\x0d\nxyz"), 3942);
  assertToStringEquals("X", res[1330].firstMatch("XABC"), 3943);
  assertNull(res[1330].firstMatch("** Failers "), 3944);
  assertToStringEquals("X", res[1330].firstMatch("XABCB"), 3945);
  assertNull(res[1330].firstMatch("abc\x0d\n\x0d\n"), 3946);
  assertNull(res[1330].firstMatch("abc\x0d\n\x0d\n"), 3947);
  assertNull(res[1330].firstMatch("abc\x0d\n\x0d\n"), 3948);
  assertThrows(() => new RegExp(r"(?|(abc)|(xyz))"), 3949);
  assertThrows(() => new RegExp(r"(x)(?|(abc)|(xyz))(x)"), 3950);
  assertNull(res[1330].firstMatch("xabcx"), 3951);
  assertNull(res[1330].firstMatch("xxyzx "), 3952);
  assertThrows(() => new RegExp(r"(x)(?|(abc)(pqr)|(xyz))(x)"), 3953);
  assertNull(res[1330].firstMatch("xabcpqrx"), 3954);
  assertNull(res[1330].firstMatch("xxyzx "), 3955);
  assertNull(res[1330].firstMatch("abcabc"), 3956);
  assertNull(res[1330].firstMatch("xyzabc "), 3957);
  assertNull(res[1330].firstMatch("** Failers "), 3958);
  assertNull(res[1330].firstMatch("xyzxyz "), 3959);
  assertNull(res[1331].firstMatch("X X\n"), 3960);
  assertNull(res[1331].firstMatch("X\x09X\x0b"), 3961);
  assertNull(res[1331].firstMatch("** Failers"), 3962);
  assertNull(res[1331].firstMatch("\xa0 X\n   "), 3963);
  assertNull(res[1332].firstMatch("\x09 \xa0X\n\x0b\x0c\x0d\n"), 3964);
  assertNull(res[1332].firstMatch("\x09 \xa0\n\x0b\x0c\x0d\n"), 3965);
  assertNull(res[1332].firstMatch("\x09 \xa0\n\x0b\x0c"), 3966);
  assertNull(res[1332].firstMatch("** Failers "), 3967);
  assertNull(res[1332].firstMatch("\x09 \xa0\n\x0b"), 3968);
  assertNull(res[1332].firstMatch(" "), 3969);
  assertNull(res[1333].firstMatch("XY  ABCDE"), 3970);
  assertNull(res[1333].firstMatch("XY  PQR ST "), 3971);
  assertNull(res[1334].firstMatch("XY  AB    PQRS"), 3972);
  assertNull(res[1335].firstMatch(">XNNNYZ"), 3973);
  assertNull(res[1335].firstMatch(">  X NYQZ"), 3974);
  assertNull(res[1335].firstMatch("** Failers"), 3975);
  assertNull(res[1335].firstMatch(">XYZ   "), 3976);
  assertNull(res[1335].firstMatch(">  X NY Z"), 3977);
  assertNull(res[1336].firstMatch(">XY\nZ\nA\x0bNN\x0c"), 3978);
  assertNull(res[1336].firstMatch(">\n\x0dX\nY\n\x0bZZZ\nAAA\x0bNNN\x0c"), 3979);
  assertNull(res[1337].firstMatch("\x0d\nA"), 3980);
  assertToStringEquals("\nA", res[1338].firstMatch("\x0d\nA "), 3981);
  assertToStringEquals("\nA", res[1339].firstMatch("\x0d\nA "), 3982);
  assertToStringEquals("\nA,\n", res[1340].firstMatch("\x0d\nA "), 3983);
  assertNull(res[1341].firstMatch("a\x0db"), 3984);
  assertNull(res[1341].firstMatch("a\nb"), 3985);
  assertNull(res[1341].firstMatch("a\x0d\nb"), 3986);
  assertNull(res[1341].firstMatch("** Failers"), 3987);
  assertNull(res[1341].firstMatch("a\x85b"), 3988);
  assertNull(res[1341].firstMatch("a\x0bb     "), 3989);
  assertNull(res[1342].firstMatch("a\x0db"), 3990);
  assertNull(res[1342].firstMatch("a\nb"), 3991);
  assertNull(res[1342].firstMatch("a\x0d\nb"), 3992);
  assertNull(res[1342].firstMatch("a\x85b"), 3993);
  assertNull(res[1342].firstMatch("a\x0bb     "), 3994);
  assertNull(res[1342].firstMatch("** Failers "), 3995);
  assertNull(res[1342].firstMatch("a\x85b<bsr_anycrlf>"), 3996);
  assertNull(res[1342].firstMatch("a\x0bb<bsr_anycrlf>"), 3997);
  assertNull(res[1343].firstMatch("a\x0db"), 3998);
  assertNull(res[1343].firstMatch("a\nb"), 3999);
  assertNull(res[1343].firstMatch("a\x0d\nb"), 4000);
  assertNull(res[1343].firstMatch("** Failers"), 4001);
  assertNull(res[1343].firstMatch("a\x85b"), 4002);
  assertNull(res[1343].firstMatch("a\x0bb     "), 4003);
  assertNull(res[1344].firstMatch("a\x0db"), 4004);
  assertNull(res[1344].firstMatch("a\nb"), 4005);
  assertNull(res[1344].firstMatch("a\x0d\nb"), 4006);
  assertNull(res[1344].firstMatch("a\x85b"), 4007);
  assertNull(res[1344].firstMatch("a\x0bb     "), 4008);
  assertNull(res[1344].firstMatch("** Failers "), 4009);
  assertNull(res[1344].firstMatch("a\x85b<bsr_anycrlf>"), 4010);
  assertNull(res[1344].firstMatch("a\x0bb<bsr_anycrlf>"), 4011);
  assertNull(res[1345].firstMatch("a\x0d\n\nb"), 4012);
  assertNull(res[1345].firstMatch("a\n\x0d\x0db"), 4013);
  assertNull(res[1345].firstMatch("a\x0d\n\x0d\n\x0d\n\x0d\nb"), 4014);
  assertNull(res[1345].firstMatch("** Failers"), 4015);
  assertNull(res[1345].firstMatch("a\x8585b"), 4016);
  assertNull(res[1345].firstMatch("a\x0b\x00bb     "), 4017);
  assertNull(res[1346].firstMatch("a\x0d\x0db"), 4018);
  assertNull(res[1346].firstMatch("a\n\n\nb"), 4019);
  assertNull(res[1346].firstMatch("a\x0d\n\n\x0d\x0db"), 4020);
  assertNull(res[1346].firstMatch("a\x8585b"), 4021);
  assertNull(res[1346].firstMatch("a\x0b\x00bb     "), 4022);
  assertNull(res[1346].firstMatch("** Failers "), 4023);
  assertNull(res[1346].firstMatch("a\x0d\x0d\x0d\x0d\x0db "), 4024);
  assertNull(res[1346].firstMatch("a\x8585b<bsr_anycrlf>"), 4025);
  assertNull(res[1346].firstMatch("a\x0b\x00bb<bsr_anycrlf>"), 4026);
  assertToStringEquals("abc", res[1347].firstMatch("abc "), 4027);
  assertNull(res[1348].firstMatch("** Failers"), 4028);
  assertNull(res[1348].firstMatch("ab"), 4029);
  assertNull(res[1349].firstMatch("** Failers"), 4030);
  assertNull(res[1349].firstMatch("ab "), 4031);
  assertNull(res[1349].firstMatch("** Failers"), 4032);
  assertNull(res[1349].firstMatch("ab "), 4033);
  assertToStringEquals("aXb", res[1350].firstMatch("aXb"), 4034);
  assertToStringEquals("a\nb", res[1350].firstMatch("a\nb "), 4035);
  assertNull(res[1350].firstMatch("** Failers"), 4036);
  assertNull(res[1350].firstMatch("ab  "), 4037);
  assertToStringEquals("aXb", res[1351].firstMatch("aXb"), 4038);
  assertToStringEquals("a\nX\nXb", res[1351].firstMatch("a\nX\nXb "), 4039);
  assertNull(res[1351].firstMatch("** Failers"), 4040);
  assertNull(res[1351].firstMatch("ab  "), 4041);
  assertNull(res[1352].firstMatch("ab"), 4042);
  assertNull(res[1352].firstMatch("ax{100}b  "), 4043);
  assertNull(res[1352].firstMatch("ax{100}x{100}b  "), 4044);
  assertNull(res[1352].firstMatch("ax{100}b  "), 4045);
  assertNull(res[1352].firstMatch("ax{100}x{100}b  "), 4046);
  assertNull(res[1352].firstMatch("*** Failers "), 4047);
  assertNull(res[1352].firstMatch("ab"), 4048);
  assertNull(res[1352].firstMatch(" "), 4049);
  assertToStringEquals("X", res[1353].firstMatch("Xoanon"), 4050);
  assertToStringEquals("X", res[1353].firstMatch("+Xoanon"), 4051);
  assertToStringEquals("X", res[1353].firstMatch("x{300}Xoanon "), 4052);
  assertNull(res[1353].firstMatch("*** Failers "), 4053);
  assertNull(res[1353].firstMatch("YXoanon  "), 4054);
  assertToStringEquals("X", res[1354].firstMatch("YXoanon"), 4055);
  assertNull(res[1354].firstMatch("*** Failers"), 4056);
  assertNull(res[1354].firstMatch("Xoanon"), 4057);
  assertNull(res[1354].firstMatch("+Xoanon    "), 4058);
  assertNull(res[1354].firstMatch("x{300}Xoanon "), 4059);
  assertToStringEquals("X", res[1355].firstMatch("X+oanon"), 4060);
  assertNull(res[1355].firstMatch("ZXx{300}oanon "), 4061);
  assertToStringEquals("X", res[1355].firstMatch("FAX "), 4062);
  assertNull(res[1355].firstMatch("*** Failers "), 4063);
  assertNull(res[1355].firstMatch("Xoanon  "), 4064);
  assertToStringEquals("X", res[1356].firstMatch("Xoanon  "), 4065);
  assertNull(res[1356].firstMatch("*** Failers"), 4066);
  assertNull(res[1356].firstMatch("X+oanon"), 4067);
  assertToStringEquals("X", res[1356].firstMatch("ZXx{300}oanon "), 4068);
  assertNull(res[1356].firstMatch("FAX "), 4069);
  assertToStringEquals("b", res[1357].firstMatch("abcd"), 4070);
  assertToStringEquals("x", res[1357].firstMatch("ax{100}   "), 4071);
  assertToStringEquals("b", res[1357].firstMatch("ab99"), 4072);
  assertToStringEquals("x", res[1357].firstMatch("x{123}x{123}45"), 4073);
  assertToStringEquals("x", res[1357].firstMatch("x{400}x{401}x{402}6  "), 4074);
  assertToStringEquals("*", res[1357].firstMatch("*** Failers"), 4075);
  assertToStringEquals("d", res[1357].firstMatch("d99"), 4076);
  assertToStringEquals("x", res[1357].firstMatch("x{123}x{122}4   "), 4077);
  assertToStringEquals("x", res[1357].firstMatch("x{400}x{403}6  "), 4078);
  assertToStringEquals("x", res[1357].firstMatch("x{400}x{401}x{402}x{402}6  "), 4079);
  assertNull(res[1358].firstMatch("\ufffd]"), 4080);
  assertNull(res[1358].firstMatch("\ufffd"), 4081);
  assertNull(res[1358].firstMatch("\ufffd\ufffd\ufffd"), 4082);
  assertNull(res[1358].firstMatch("\ufffd\ufffd\ufffd?"), 4083);
  assertToStringEquals("acb", res[1359].firstMatch("acb"), 4084);
  assertToStringEquals("ab", res[1359].firstMatch("ab"), 4085);
  assertNull(res[1359].firstMatch("ax{100}b "), 4086);
  assertNull(res[1359].firstMatch("*** Failers"), 4087);
  assertNull(res[1359].firstMatch("a\nb  "), 4088);
  assertNull(res[1360].firstMatch("ax{4000}xyb "), 4089);
  assertNull(res[1360].firstMatch("ax{4000}yb "), 4090);
  assertNull(res[1360].firstMatch("ax{4000}x{100}yb "), 4091);
  assertNull(res[1360].firstMatch("*** Failers"), 4092);
  assertNull(res[1360].firstMatch("ax{4000}b "), 4093);
  assertNull(res[1360].firstMatch("ac\ncb "), 4094);
  assertToStringEquals("a\xc0,,\xc0", res[1361].firstMatch("a\xc0\x88b"), 4095);
  assertToStringEquals("ax,,x", res[1362].firstMatch("ax{100}b"), 4096);
  assertToStringEquals("a\xc0\x88b,\xc0\x88,b", res[1363].firstMatch("a\xc0\x88b"), 4097);
  assertToStringEquals("ax{100}b,x{100},b", res[1364].firstMatch("ax{100}b"), 4098);
  assertToStringEquals("a\xc0\x92,\xc0,\x92", res[1365].firstMatch("a\xc0\x92bcd"), 4099);
  assertToStringEquals("ax{,x,{", res[1366].firstMatch("ax{240}bcd"), 4100);
  assertToStringEquals("a\xc0\x92,\xc0,\x92", res[1367].firstMatch("a\xc0\x92bcd"), 4101);
  assertToStringEquals("ax{,x,{", res[1368].firstMatch("ax{240}bcd"), 4102);
  assertToStringEquals("a\xc0,,\xc0", res[1369].firstMatch("a\xc0\x92bcd"), 4103);
  assertToStringEquals("ax,,x", res[1370].firstMatch("ax{240}bcd"), 4104);
  assertNull(res[1371].firstMatch("ax{1234}xyb "), 4105);
  assertNull(res[1371].firstMatch("ax{1234}x{4321}yb "), 4106);
  assertNull(res[1371].firstMatch("ax{1234}x{4321}x{3412}b "), 4107);
  assertNull(res[1371].firstMatch("*** Failers"), 4108);
  assertNull(res[1371].firstMatch("ax{1234}b "), 4109);
  assertNull(res[1371].firstMatch("ac\ncb "), 4110);
  assertToStringEquals("ax{1234}xyb,x{1234}xy", res[1372].firstMatch("ax{1234}xyb "), 4111);
  assertToStringEquals("ax{1234}x{4321}yb,x{1234}x{4321}y", res[1372].firstMatch("ax{1234}x{4321}yb "), 4112);
  assertToStringEquals("ax{1234}x{4321}x{3412}b,x{1234}x{4321}x{3412}", res[1372].firstMatch("ax{1234}x{4321}x{3412}b "), 4113);
  assertToStringEquals("axxxxbcdefghijb,xxxxbcdefghij", res[1372].firstMatch("axxxxbcdefghijb "), 4114);
  assertToStringEquals("ax{1234}x{4321}x{3412}x{3421}b,x{1234}x{4321}x{3412}x{3421}", res[1372].firstMatch("ax{1234}x{4321}x{3412}x{3421}b "), 4115);
  assertNull(res[1372].firstMatch("*** Failers"), 4116);
  assertToStringEquals("ax{1234}b,x{1234}", res[1372].firstMatch("ax{1234}b "), 4117);
  assertToStringEquals("ax{1234}xyb,x{1234}xy", res[1373].firstMatch("ax{1234}xyb "), 4118);
  assertToStringEquals("ax{1234}x{4321}yb,x{1234}x{4321}y", res[1373].firstMatch("ax{1234}x{4321}yb "), 4119);
  assertToStringEquals("ax{1234}x{4321}x{3412}b,x{1234}x{4321}x{3412}", res[1373].firstMatch("ax{1234}x{4321}x{3412}b "), 4120);
  assertToStringEquals("axxxxb,xxxx", res[1373].firstMatch("axxxxbcdefghijb "), 4121);
  assertToStringEquals("ax{1234}x{4321}x{3412}x{3421}b,x{1234}x{4321}x{3412}x{3421}", res[1373].firstMatch("ax{1234}x{4321}x{3412}x{3421}b "), 4122);
  assertNull(res[1373].firstMatch("*** Failers"), 4123);
  assertToStringEquals("ax{1234}b,x{1234}", res[1373].firstMatch("ax{1234}b "), 4124);
  assertNull(res[1374].firstMatch("ax{1234}xyb "), 4125);
  assertNull(res[1374].firstMatch("ax{1234}x{4321}yb "), 4126);
  assertNull(res[1374].firstMatch("ax{1234}x{4321}x{3412}b "), 4127);
  assertToStringEquals("axxxxb,xxxx", res[1374].firstMatch("axxxxbcdefghijb "), 4128);
  assertNull(res[1374].firstMatch("ax{1234}x{4321}x{3412}x{3421}b "), 4129);
  assertToStringEquals("axbxxb,xbxx", res[1374].firstMatch("axbxxbcdefghijb "), 4130);
  assertToStringEquals("axxxxxb,xxxxx", res[1374].firstMatch("axxxxxbcdefghijb "), 4131);
  assertNull(res[1374].firstMatch("*** Failers"), 4132);
  assertNull(res[1374].firstMatch("ax{1234}b "), 4133);
  assertNull(res[1374].firstMatch("axxxxxxbcdefghijb "), 4134);
  assertNull(res[1375].firstMatch("ax{1234}xyb "), 4135);
  assertNull(res[1375].firstMatch("ax{1234}x{4321}yb "), 4136);
  assertNull(res[1375].firstMatch("ax{1234}x{4321}x{3412}b "), 4137);
  assertToStringEquals("axxxxb,xxxx", res[1375].firstMatch("axxxxbcdefghijb "), 4138);
  assertNull(res[1375].firstMatch("ax{1234}x{4321}x{3412}x{3421}b "), 4139);
  assertToStringEquals("axbxxb,xbxx", res[1375].firstMatch("axbxxbcdefghijb "), 4140);
  assertToStringEquals("axxxxxb,xxxxx", res[1375].firstMatch("axxxxxbcdefghijb "), 4141);
  assertNull(res[1375].firstMatch("*** Failers"), 4142);
  assertNull(res[1375].firstMatch("ax{1234}b "), 4143);
  assertNull(res[1375].firstMatch("axxxxxxbcdefghijb "), 4144);
  assertNull(res[1375].firstMatch("*** Failers"), 4145);
  assertNull(res[1375].firstMatch("x{100}"), 4146);
  assertNull(res[1375].firstMatch("aXbcd"), 4147);
  assertNull(res[1375].firstMatch("ax{100}bcd"), 4148);
  assertNull(res[1375].firstMatch("ax{100000}bcd"), 4149);
  assertNull(res[1375].firstMatch("x{100}x{100}x{100}b"), 4150);
  assertNull(res[1375].firstMatch("*** Failers "), 4151);
  assertNull(res[1375].firstMatch("x{100}x{100}b"), 4152);
  assertNull(res[1375].firstMatch("x{ab} "), 4153);
  assertNull(res[1375].firstMatch("\xc2\xab"), 4154);
  assertNull(res[1375].firstMatch("*** Failers "), 4155);
  assertNull(res[1375].firstMatch("\x00{ab}"), 4156);
  assertNull(res[1375].firstMatch("WXYZ"), 4157);
  assertNull(res[1375].firstMatch("x{256}XYZ "), 4158);
  assertNull(res[1375].firstMatch("*** Failers"), 4159);
  assertNull(res[1375].firstMatch("XYZ "), 4160);
  assertToStringEquals("bcd", res[1376].firstMatch("bcd"), 4161);
  assertToStringEquals("x{", res[1377].firstMatch("x{100}bc"), 4163);
  assertToStringEquals("x{100}bcA", res[1378].firstMatch("x{100}bcAa"), 4164);
  assertToStringEquals("x{", res[1379].firstMatch("x{100}bca"), 4165);
  assertToStringEquals("bcd", res[1380].firstMatch("bcd"), 4166);
  assertToStringEquals("x{", res[1381].firstMatch("x{100}bc"), 4168);
  assertToStringEquals("x{100}bc", res[1382].firstMatch("x{100}bcAa"), 4169);
  assertToStringEquals("x{", res[1383].firstMatch("x{100}bca"), 4170);
  assertNull(res[1383].firstMatch("abcd"), 4171);
  assertNull(res[1383].firstMatch("abcd"), 4172);
  assertToStringEquals("x{", res[1383].firstMatch("x{100}x{100} "), 4173);
  assertToStringEquals("x{", res[1383].firstMatch("x{100}x{100} "), 4174);
  assertToStringEquals("x{", res[1383].firstMatch("x{100}x{100}x{100}x{100} "), 4175);
  assertNull(res[1383].firstMatch("abce"), 4176);
  assertToStringEquals("x{", res[1383].firstMatch("x{100}x{100}x{100}x{100} "), 4177);
  assertNull(res[1383].firstMatch("abcdx{100}x{100}x{100}x{100} "), 4178);
  assertNull(res[1383].firstMatch("abcdx{100}x{100}x{100}x{100} "), 4179);
  assertNull(res[1383].firstMatch("abcdx{100}x{100}x{100}x{100} "), 4180);
  assertNull(res[1383].firstMatch("abcdx{100}x{100}x{100}XX"), 4181);
  assertNull(res[1383].firstMatch("abcdx{100}x{100}x{100}x{100}x{100}x{100}x{100}XX"), 4182);
  assertNull(res[1383].firstMatch("abcdx{100}x{100}x{100}x{100}x{100}x{100}x{100}XX"), 4183);
  assertToStringEquals("Xy", res[1383].firstMatch("Xyyyax{100}x{100}bXzzz"), 4184);
  assertToStringEquals("X", res[1386].firstMatch("1X2"), 4185);
  assertToStringEquals("x", res[1386].firstMatch("1x{100}2 "), 4186);
  assertToStringEquals(">X", res[1387].firstMatch("> >X Y"), 4187);
  assertToStringEquals(">x", res[1387].firstMatch("> >x{100} Y"), 4188);
  assertToStringEquals("1", res[1388].firstMatch("x{100}3"), 4189);
  assertToStringEquals(" ", res[1389].firstMatch("x{100} X"), 4190);
  assertToStringEquals("abcd", res[1390].firstMatch("12abcd34"), 4191);
  assertToStringEquals("*** Failers", res[1390].firstMatch("*** Failers"), 4192);
  assertToStringEquals("  ", res[1390].firstMatch("1234  "), 4193);
  assertToStringEquals("abc", res[1391].firstMatch("12abcd34"), 4194);
  assertToStringEquals("ab", res[1391].firstMatch("12ab34"), 4195);
  assertToStringEquals("***", res[1391].firstMatch("*** Failers  "), 4196);
  assertNull(res[1391].firstMatch("1234"), 4197);
  assertToStringEquals("  ", res[1391].firstMatch("12a34  "), 4198);
  assertToStringEquals("ab", res[1392].firstMatch("12abcd34"), 4199);
  assertToStringEquals("ab", res[1392].firstMatch("12ab34"), 4200);
  assertToStringEquals("**", res[1392].firstMatch("*** Failers  "), 4201);
  assertNull(res[1392].firstMatch("1234"), 4202);
  assertToStringEquals("  ", res[1392].firstMatch("12a34  "), 4203);
  assertToStringEquals("12", res[1393].firstMatch("12abcd34"), 4204);
  assertNull(res[1393].firstMatch("*** Failers"), 4205);
  assertToStringEquals("12", res[1394].firstMatch("12abcd34"), 4206);
  assertToStringEquals("123", res[1394].firstMatch("1234abcd"), 4207);
  assertNull(res[1394].firstMatch("*** Failers  "), 4208);
  assertNull(res[1394].firstMatch("1.4 "), 4209);
  assertToStringEquals("12", res[1395].firstMatch("12abcd34"), 4210);
  assertToStringEquals("12", res[1395].firstMatch("1234abcd"), 4211);
  assertNull(res[1395].firstMatch("*** Failers  "), 4212);
  assertNull(res[1395].firstMatch("1.4 "), 4213);
  assertToStringEquals("12abcd34", res[1396].firstMatch("12abcd34"), 4214);
  assertToStringEquals("***", res[1396].firstMatch("*** Failers"), 4215);
  assertNull(res[1396].firstMatch("     "), 4216);
  assertToStringEquals("12a", res[1397].firstMatch("12abcd34"), 4217);
  assertToStringEquals("123", res[1397].firstMatch("1234abcd"), 4218);
  assertToStringEquals("***", res[1397].firstMatch("*** Failers"), 4219);
  assertNull(res[1397].firstMatch("       "), 4220);
  assertToStringEquals("12", res[1398].firstMatch("12abcd34"), 4221);
  assertToStringEquals("12", res[1398].firstMatch("1234abcd"), 4222);
  assertToStringEquals("**", res[1398].firstMatch("*** Failers"), 4223);
  assertNull(res[1398].firstMatch("       "), 4224);
  assertToStringEquals(">      <", res[1399].firstMatch("12>      <34"), 4225);
  assertNull(res[1399].firstMatch("*** Failers"), 4226);
  assertToStringEquals(">  <", res[1400].firstMatch("ab>  <cd"), 4227);
  assertToStringEquals(">   <", res[1400].firstMatch("ab>   <ce"), 4228);
  assertNull(res[1400].firstMatch("*** Failers"), 4229);
  assertNull(res[1400].firstMatch("ab>    <cd "), 4230);
  assertToStringEquals(">  <", res[1401].firstMatch("ab>  <cd"), 4231);
  assertToStringEquals(">   <", res[1401].firstMatch("ab>   <ce"), 4232);
  assertNull(res[1401].firstMatch("*** Failers"), 4233);
  assertNull(res[1401].firstMatch("ab>    <cd "), 4234);
  assertToStringEquals("12", res[1402].firstMatch("12      34"), 4235);
  assertToStringEquals("Failers", res[1402].firstMatch("*** Failers"), 4236);
  assertNull(res[1402].firstMatch("+++=*! "), 4237);
  assertToStringEquals("ab", res[1403].firstMatch("ab  cd"), 4238);
  assertToStringEquals("abc", res[1403].firstMatch("abcd ce"), 4239);
  assertToStringEquals("Fai", res[1403].firstMatch("*** Failers"), 4240);
  assertNull(res[1403].firstMatch("a.b.c"), 4241);
  assertToStringEquals("ab", res[1404].firstMatch("ab  cd"), 4242);
  assertToStringEquals("ab", res[1404].firstMatch("abcd ce"), 4243);
  assertToStringEquals("Fa", res[1404].firstMatch("*** Failers"), 4244);
  assertNull(res[1404].firstMatch("a.b.c"), 4245);
  assertToStringEquals("====", res[1405].firstMatch("12====34"), 4246);
  assertToStringEquals("*** ", res[1405].firstMatch("*** Failers"), 4247);
  assertToStringEquals(" ", res[1405].firstMatch("abcd "), 4248);
  assertToStringEquals("===", res[1406].firstMatch("ab====cd"), 4249);
  assertToStringEquals("==", res[1406].firstMatch("ab==cd"), 4250);
  assertToStringEquals("***", res[1406].firstMatch("*** Failers"), 4251);
  assertNull(res[1406].firstMatch("a.b.c"), 4252);
  assertToStringEquals("==", res[1407].firstMatch("ab====cd"), 4253);
  assertToStringEquals("==", res[1407].firstMatch("ab==cd"), 4254);
  assertToStringEquals("**", res[1407].firstMatch("*** Failers"), 4255);
  assertNull(res[1407].firstMatch("a.b.c"), 4256);
  assertNull(res[1407].firstMatch("x{100}"), 4257);
  assertNull(res[1407].firstMatch("Zx{100}"), 4258);
  assertNull(res[1407].firstMatch("x{100}Z"), 4259);
  assertToStringEquals("**", res[1407].firstMatch("*** Failers "), 4260);
  assertNull(res[1407].firstMatch("Zx{100}"), 4261);
  assertNull(res[1407].firstMatch("x{100}"), 4262);
  assertNull(res[1407].firstMatch("x{100}Z"), 4263);
  assertToStringEquals("**", res[1407].firstMatch("*** Failers "), 4264);
  assertNull(res[1407].firstMatch("abcx{200}X"), 4265);
  assertNull(res[1407].firstMatch("abcx{100}X "), 4266);
  assertToStringEquals("**", res[1407].firstMatch("*** Failers"), 4267);
  assertToStringEquals("  ", res[1407].firstMatch("X  "), 4268);
  assertNull(res[1407].firstMatch("abcx{200}X"), 4269);
  assertNull(res[1407].firstMatch("abcx{100}X "), 4270);
  assertNull(res[1407].firstMatch("abQX "), 4271);
  assertToStringEquals("**", res[1407].firstMatch("*** Failers"), 4272);
  assertToStringEquals("  ", res[1407].firstMatch("X  "), 4273);
  assertNull(res[1407].firstMatch("abcx{100}x{200}x{100}X"), 4274);
  assertToStringEquals("**", res[1407].firstMatch("*** Failers"), 4275);
  assertNull(res[1407].firstMatch("abcx{200}X"), 4276);
  assertToStringEquals("  ", res[1407].firstMatch("X  "), 4277);
  assertNull(res[1407].firstMatch("AX"), 4278);
  assertNull(res[1407].firstMatch("x{150}X"), 4279);
  assertNull(res[1407].firstMatch("x{500}X "), 4280);
  assertToStringEquals("**", res[1407].firstMatch("*** Failers"), 4281);
  assertNull(res[1407].firstMatch("x{100}X"), 4282);
  assertToStringEquals("  ", res[1407].firstMatch("x{200}X   "), 4283);
  assertNull(res[1407].firstMatch("AX"), 4284);
  assertNull(res[1407].firstMatch("x{150}X"), 4285);
  assertNull(res[1407].firstMatch("x{500}X "), 4286);
  assertToStringEquals("**", res[1407].firstMatch("*** Failers"), 4287);
  assertNull(res[1407].firstMatch("x{100}X"), 4288);
  assertToStringEquals("  ", res[1407].firstMatch("x{200}X   "), 4289);
  assertNull(res[1407].firstMatch("QX "), 4290);
  assertNull(res[1407].firstMatch("AX"), 4291);
  assertNull(res[1407].firstMatch("x{500}X "), 4292);
  assertToStringEquals("**", res[1407].firstMatch("*** Failers"), 4293);
  assertNull(res[1407].firstMatch("x{100}X"), 4294);
  assertNull(res[1407].firstMatch("x{150}X"), 4295);
  assertToStringEquals("  ", res[1407].firstMatch("x{200}X   "), 4296);
  assertNull(res[1407].firstMatch("z"), 4297);
  assertNull(res[1407].firstMatch("Z "), 4298);
  assertNull(res[1407].firstMatch("x{100}"), 4299);
  assertToStringEquals("**", res[1407].firstMatch("*** Failers"), 4300);
  assertNull(res[1407].firstMatch("x{102}"), 4301);
  assertToStringEquals("  ", res[1407].firstMatch("y    "), 4302);
  assertToStringEquals("\xff", res[1408].firstMatch(">\xff<"), 4303);
  assertNull(res[1409].firstMatch(">x{ff}<"), 4304);
  assertToStringEquals("X", res[1410].firstMatch("XYZ"), 4305);
  assertToStringEquals("X", res[1411].firstMatch("XYZ"), 4306);
  assertToStringEquals("x", res[1411].firstMatch("x{123} "), 4307);
  assertToStringEquals(",", res[1416].firstMatch("catac"), 4308);
  assertToStringEquals(",", res[1416].firstMatch("ax{256}a "), 4309);
  assertToStringEquals(",", res[1416].firstMatch("x{85}"), 4310);
  assertToStringEquals("abc1", res[1417].firstMatch("abc1 \nabc2 \x0babc3xx \x0cabc4 \x0dabc5xx \x0d\nabc6 x{0085}abc7 x{2028}abc8 x{2029}abc9 JUNK"), 4311);
  assertToStringEquals("abc1", res[1418].firstMatch("abc1\n abc2\x0b abc3\x0c abc4\x0d abc5\x0d\n abc6x{0085} abc7x{2028} abc8x{2029} abc9"), 4312);
  assertNull(res[1419].firstMatch("a\nb"), 4313);
  assertNull(res[1419].firstMatch("a\x0db"), 4314);
  assertNull(res[1419].firstMatch("a\x0d\nb"), 4315);
  assertNull(res[1419].firstMatch("a\x0bb"), 4316);
  assertNull(res[1419].firstMatch("a\x0cb"), 4317);
  assertNull(res[1419].firstMatch("ax{85}b   "), 4318);
  assertNull(res[1419].firstMatch("ax{2028}b "), 4319);
  assertNull(res[1419].firstMatch("ax{2029}b "), 4320);
  assertNull(res[1419].firstMatch("** Failers"), 4321);
  assertNull(res[1419].firstMatch("a\n\x0db    "), 4322);
  assertToStringEquals("ab", res[1420].firstMatch("ab"), 4323);
  assertNull(res[1420].firstMatch("a\nb"), 4324);
  assertNull(res[1420].firstMatch("a\x0db"), 4325);
  assertNull(res[1420].firstMatch("a\x0d\nb"), 4326);
  assertNull(res[1420].firstMatch("a\x0bb"), 4327);
  assertNull(res[1420].firstMatch("a\x0cx{2028}x{2029}b"), 4328);
  assertNull(res[1420].firstMatch("ax{85}b   "), 4329);
  assertNull(res[1420].firstMatch("a\n\x0db    "), 4330);
  assertNull(res[1420].firstMatch("a\n\x0dx{85}\x0cb "), 4331);
  assertNull(res[1421].firstMatch("a\nb"), 4332);
  assertNull(res[1421].firstMatch("a\x0db"), 4333);
  assertNull(res[1421].firstMatch("a\x0d\nb"), 4334);
  assertNull(res[1421].firstMatch("a\x0bb"), 4335);
  assertNull(res[1421].firstMatch("a\x0cx{2028}x{2029}b"), 4336);
  assertNull(res[1421].firstMatch("ax{85}b   "), 4337);
  assertNull(res[1421].firstMatch("a\n\x0db    "), 4338);
  assertNull(res[1421].firstMatch("a\n\x0dx{85}\x0cb "), 4339);
  assertNull(res[1421].firstMatch("** Failers"), 4340);
  assertNull(res[1421].firstMatch("ab  "), 4341);
  assertNull(res[1422].firstMatch("a\nb"), 4342);
  assertNull(res[1422].firstMatch("a\n\x0db"), 4343);
  assertNull(res[1422].firstMatch("a\n\x0dx{85}b"), 4344);
  assertNull(res[1422].firstMatch("a\x0d\n\x0d\nb "), 4345);
  assertNull(res[1422].firstMatch("a\x0d\n\x0d\n\x0d\nb "), 4346);
  assertNull(res[1422].firstMatch("a\n\x0d\n\x0db"), 4347);
  assertNull(res[1422].firstMatch("a\n\n\x0d\nb "), 4348);
  assertNull(res[1422].firstMatch("** Failers"), 4349);
  assertNull(res[1422].firstMatch("a\n\n\n\x0db"), 4350);
  assertNull(res[1422].firstMatch("a\x0d"), 4351);
  assertNull(res[1423].firstMatch("\x09 x{a0}X\n\x0b\x0c\x0d\n"), 4352);
  assertNull(res[1424].firstMatch(" x{a0}X\n\x0b\x0c\x0d\n"), 4353);
  assertNull(res[1425].firstMatch(">\x09 x{a0}X\n\n\n<"), 4354);
  assertNull(res[1426].firstMatch(">\x09 x{a0}X\n\n\n<"), 4355);
  assertNull(res[1427].firstMatch("X X\n"), 4356);
  assertNull(res[1427].firstMatch("X\x09X\x0b"), 4357);
  assertNull(res[1427].firstMatch("** Failers"), 4358);
  assertNull(res[1427].firstMatch("x{a0} X\n   "), 4359);
  assertNull(res[1428].firstMatch("\x09 x{a0}X\n\x0b\x0c\x0d\n"), 4360);
  assertNull(res[1428].firstMatch("\x09 x{a0}\n\x0b\x0c\x0d\n"), 4361);
  assertNull(res[1428].firstMatch("\x09 x{a0}\n\x0b\x0c"), 4362);
  assertNull(res[1428].firstMatch("** Failers "), 4363);
  assertNull(res[1428].firstMatch("\x09 x{a0}\n\x0b"), 4364);
  assertNull(res[1428].firstMatch(" "), 4365);
  assertNull(res[1429].firstMatch("x{3001}x{3000}x{2030}x{2028}"), 4366);
  assertNull(res[1429].firstMatch("Xx{180e}Xx{85}"), 4367);
  assertNull(res[1429].firstMatch("** Failers"), 4368);
  assertNull(res[1429].firstMatch("x{2009} X\n   "), 4369);
  assertNull(res[1430].firstMatch("x{1680}x{180e}x{2007}Xx{2028}x{2029}\x0c\x0d\n"), 4370);
  assertNull(res[1430].firstMatch("\x09x{205f}x{a0}\nx{2029}\x0cx{2028}\n"), 4371);
  assertNull(res[1430].firstMatch("\x09 x{202f}\n\x0b\x0c"), 4372);
  assertNull(res[1430].firstMatch("** Failers "), 4373);
  assertNull(res[1430].firstMatch("\x09x{200a}x{a0}x{2028}\x0b"), 4374);
  assertNull(res[1430].firstMatch(" "), 4375);
  assertNull(res[1431].firstMatch("a\x0db"), 4376);
  assertNull(res[1431].firstMatch("a\nb"), 4377);
  assertNull(res[1431].firstMatch("a\x0d\nb"), 4378);
  assertNull(res[1431].firstMatch("** Failers"), 4379);
  assertNull(res[1431].firstMatch("ax{85}b"), 4380);
  assertNull(res[1431].firstMatch("a\x0bb     "), 4381);
  assertNull(res[1432].firstMatch("a\x0db"), 4382);
  assertNull(res[1432].firstMatch("a\nb"), 4383);
  assertNull(res[1432].firstMatch("a\x0d\nb"), 4384);
  assertNull(res[1432].firstMatch("ax{85}b"), 4385);
  assertNull(res[1432].firstMatch("a\x0bb     "), 4386);
  assertNull(res[1432].firstMatch("** Failers "), 4387);
  assertNull(res[1432].firstMatch("ax{85}b<bsr_anycrlf>"), 4388);
  assertNull(res[1432].firstMatch("a\x0bb<bsr_anycrlf>"), 4389);
  assertNull(res[1433].firstMatch("a\x0db"), 4390);
  assertNull(res[1433].firstMatch("a\nb"), 4391);
  assertNull(res[1433].firstMatch("a\x0d\nb"), 4392);
  assertNull(res[1433].firstMatch("** Failers"), 4393);
  assertNull(res[1433].firstMatch("ax{85}b"), 4394);
  assertNull(res[1433].firstMatch("a\x0bb     "), 4395);
  assertNull(res[1434].firstMatch("a\x0db"), 4396);
  assertNull(res[1434].firstMatch("a\nb"), 4397);
  assertNull(res[1434].firstMatch("a\x0d\nb"), 4398);
  assertNull(res[1434].firstMatch("ax{85}b"), 4399);
  assertNull(res[1434].firstMatch("a\x0bb     "), 4400);
  assertNull(res[1434].firstMatch("** Failers "), 4401);
  assertNull(res[1434].firstMatch("ax{85}b<bsr_anycrlf>"), 4402);
  assertNull(res[1434].firstMatch("a\x0bb<bsr_anycrlf>"), 4403);
  assertToStringEquals("X", res[1435].firstMatch("Ax{1ec5}ABCXYZ"), 4404);
  assertNull(res[1437].firstMatch("AB"), 4405);
  assertNull(res[1437].firstMatch("*** Failers"), 4406);
  assertNull(res[1437].firstMatch("A0"), 4407);
  assertNull(res[1437].firstMatch("00   "), 4408);
  assertNull(res[1438].firstMatch("AB"), 4409);
  assertNull(res[1438].firstMatch("Ax{300}BC "), 4410);
  assertNull(res[1438].firstMatch("Ax{300}x{301}x{302}BC "), 4411);
  assertNull(res[1438].firstMatch("*** Failers"), 4412);
  assertNull(res[1438].firstMatch("x{300}  "), 4413);
  assertNull(res[1439].firstMatch("ABC"), 4414);
  assertNull(res[1439].firstMatch("Ax{300}Bx{300}x{301}C "), 4415);
  assertNull(res[1439].firstMatch("Ax{300}x{301}x{302}BC "), 4416);
  assertNull(res[1439].firstMatch("*** Failers"), 4417);
  assertNull(res[1439].firstMatch("x{300}  "), 4418);
  assertNull(res[1440].firstMatch("abcd"), 4419);
  assertNull(res[1440].firstMatch("a "), 4420);
  assertNull(res[1440].firstMatch("*** Failers "), 4421);
  assertNull(res[1441].firstMatch("1234"), 4422);
  assertNull(res[1441].firstMatch("= "), 4423);
  assertNull(res[1441].firstMatch("*** Failers "), 4424);
  assertNull(res[1441].firstMatch("abcd "), 4425);
  assertNull(res[1442].firstMatch("abcdAx{300}x{301}x{302}"), 4426);
  assertNull(res[1442].firstMatch("Ax{300}x{301}x{302}"), 4427);
  assertNull(res[1442].firstMatch("Ax{300}x{301}x{302}Ax{300}x{301}x{302}"), 4428);
  assertNull(res[1442].firstMatch("a "), 4429);
  assertNull(res[1442].firstMatch("*** Failers "), 4430);
  assertNull(res[1442].firstMatch("x{300}x{301}x{302}"), 4431);
  assertToStringEquals("abc", res[1443].firstMatch("abc"), 4432);
  assertToStringEquals("abc", res[1443].firstMatch("Ax{300}abc"), 4433);
  assertToStringEquals("abc", res[1443].firstMatch("Ax{300}x{301}x{302}Ax{300}Ax{300}Ax{300}abcxyz"), 4434);
  assertToStringEquals("abc", res[1443].firstMatch("x{300}abc  "), 4435);
  assertNull(res[1443].firstMatch("*** Failers"), 4436);
  assertToStringEquals("abc", res[1444].firstMatch("abc"), 4437);
  assertNull(res[1444].firstMatch("Ax{300}abc"), 4438);
  assertNull(res[1444].firstMatch("*** Failers"), 4439);
  assertNull(res[1444].firstMatch("Ax{300}x{301}x{302}Ax{300}Ax{300}Ax{300}abcxyz"), 4440);
  assertNull(res[1444].firstMatch("x{300}abc  "), 4441);
  assertToStringEquals("abc", res[1445].firstMatch("abc"), 4442);
  assertToStringEquals("abc", res[1445].firstMatch("Ax{300}abc"), 4443);
  assertToStringEquals("abc", res[1445].firstMatch("Ax{300}x{301}x{302}Ax{300}Ax{300}Ax{300}abcxyz"), 4444);
  assertToStringEquals("abc", res[1445].firstMatch("x{300}abc  "), 4445);
  assertNull(res[1445].firstMatch("*** Failers"), 4446);
  assertToStringEquals("abc", res[1446].firstMatch("abc"), 4447);
  assertNull(res[1446].firstMatch("Ax{300}abc"), 4448);
  assertNull(res[1446].firstMatch("Ax{300}x{301}x{302}Ax{300}Ax{300}Ax{300}abcxyz"), 4449);
  assertNull(res[1446].firstMatch("*** Failers"), 4450);
  assertNull(res[1446].firstMatch("x{300}abc  "), 4451);
  assertNull(res[1447].firstMatch("A=b"), 4452);
  assertNull(res[1447].firstMatch("=c "), 4453);
  assertNull(res[1447].firstMatch("*** Failers"), 4454);
  assertNull(res[1447].firstMatch("1=2 "), 4455);
  assertNull(res[1447].firstMatch("AAAA=b  "), 4456);
  assertNull(res[1448].firstMatch("AAAA=b"), 4457);
  assertNull(res[1448].firstMatch("=c "), 4458);
  assertNull(res[1448].firstMatch("*** Failers"), 4459);
  assertNull(res[1448].firstMatch("1=2  "), 4460);
  assertNull(res[1449].firstMatch("Ax{300}x{301}x{302}Ax{300}x{301}x{302}X"), 4461);
  assertNull(res[1449].firstMatch("Ax{300}x{301}x{302}Ax{300}x{301}x{302}Ax{300}x{301}x{302}X "), 4462);
  assertNull(res[1449].firstMatch("*** Failers"), 4463);
  assertNull(res[1449].firstMatch("X"), 4464);
  assertNull(res[1449].firstMatch("Ax{300}x{301}x{302}X"), 4465);
  assertNull(res[1449].firstMatch("Ax{300}x{301}x{302}Ax{300}x{301}x{302}Ax{300}x{301}x{302}Ax{300}x{301}x{302}X"), 4466);
  assertNull(res[1450].firstMatch("x{c0}x{30f}x{660}x{66c}x{f01}x{1680}<"), 4467);
  assertNull(res[1450].firstMatch("\npx{300}9!\$ < "), 4468);
  assertNull(res[1450].firstMatch("** Failers "), 4469);
  assertNull(res[1450].firstMatch("apx{300}9!\$ < "), 4470);
  assertNull(res[1451].firstMatch("X"), 4471);
  assertNull(res[1451].firstMatch("** Failers "), 4472);
  assertNull(res[1451].firstMatch(""), 4473);
  assertNull(res[1452].firstMatch("9"), 4474);
  assertNull(res[1452].firstMatch("** Failers "), 4475);
  assertNull(res[1452].firstMatch("x{c0}"), 4476);
  assertNull(res[1453].firstMatch("X"), 4477);
  assertNull(res[1453].firstMatch("** Failers "), 4478);
  assertNull(res[1453].firstMatch("x{30f}"), 4479);
  assertNull(res[1454].firstMatch("X"), 4480);
  assertNull(res[1454].firstMatch("** Failers "), 4481);
  assertNull(res[1454].firstMatch("x{660}"), 4482);
  assertNull(res[1455].firstMatch("X"), 4483);
  assertNull(res[1455].firstMatch("** Failers "), 4484);
  assertNull(res[1455].firstMatch("x{66c}"), 4485);
  assertNull(res[1456].firstMatch("X"), 4486);
  assertNull(res[1456].firstMatch("** Failers "), 4487);
  assertNull(res[1456].firstMatch("x{f01}"), 4488);
  assertNull(res[1457].firstMatch("X"), 4489);
  assertNull(res[1457].firstMatch("** Failers "), 4490);
  assertNull(res[1457].firstMatch("x{1680}"), 4491);
  assertNull(res[1458].firstMatch("x{017}"), 4492);
  assertNull(res[1458].firstMatch("x{09f} "), 4493);
  assertNull(res[1458].firstMatch("** Failers"), 4494);
  assertNull(res[1458].firstMatch("x{0600} "), 4495);
  assertNull(res[1459].firstMatch("x{601}"), 4496);
  assertNull(res[1459].firstMatch("** Failers"), 4497);
  assertNull(res[1459].firstMatch("x{09f} "), 4498);
  assertNull(res[1460].firstMatch("** Failers"), 4499);
  assertNull(res[1460].firstMatch("x{09f} "), 4500);
  assertNull(res[1461].firstMatch("x{f8ff}"), 4501);
  assertNull(res[1461].firstMatch("** Failers"), 4502);
  assertNull(res[1461].firstMatch("x{09f} "), 4503);
  assertNull(res[1462].firstMatch("?x{dfff}"), 4504);
  assertNull(res[1462].firstMatch("** Failers"), 4505);
  assertNull(res[1462].firstMatch("x{09f} "), 4506);
  assertNull(res[1463].firstMatch("a"), 4507);
  assertNull(res[1463].firstMatch("** Failers "), 4508);
  assertNull(res[1463].firstMatch("Z"), 4509);
  assertNull(res[1463].firstMatch("x{e000}  "), 4510);
  assertNull(res[1464].firstMatch("x{2b0}"), 4511);
  assertNull(res[1464].firstMatch("** Failers"), 4512);
  assertNull(res[1464].firstMatch("a "), 4513);
  assertNull(res[1465].firstMatch("x{1bb}"), 4514);
  assertNull(res[1465].firstMatch("** Failers"), 4515);
  assertNull(res[1465].firstMatch("a "), 4516);
  assertNull(res[1465].firstMatch("x{2b0}"), 4517);
  assertNull(res[1466].firstMatch("x{1c5}"), 4518);
  assertNull(res[1466].firstMatch("** Failers"), 4519);
  assertNull(res[1466].firstMatch("a "), 4520);
  assertNull(res[1466].firstMatch("x{2b0}"), 4521);
  assertNull(res[1467].firstMatch("A"), 4522);
  assertNull(res[1467].firstMatch("** Failers"), 4523);
  assertNull(res[1467].firstMatch("x{2b0}"), 4524);
  assertNull(res[1468].firstMatch("x{903}"), 4525);
  assertNull(res[1468].firstMatch("** Failers"), 4526);
  assertNull(res[1468].firstMatch("X"), 4527);
  assertNull(res[1468].firstMatch("x{300}"), 4528);
  assertNull(res[1468].firstMatch("   "), 4529);
  assertNull(res[1469].firstMatch("x{488}"), 4530);
  assertNull(res[1469].firstMatch("** Failers"), 4531);
  assertNull(res[1469].firstMatch("X"), 4532);
  assertNull(res[1469].firstMatch("x{903}"), 4533);
  assertNull(res[1469].firstMatch("x{300}"), 4534);
  assertNull(res[1470].firstMatch("x{300}"), 4535);
  assertNull(res[1470].firstMatch("** Failers"), 4536);
  assertNull(res[1470].firstMatch("X"), 4537);
  assertNull(res[1470].firstMatch("x{903}"), 4538);
  assertNull(res[1470].firstMatch("0123456789x{660}x{661}x{662}x{663}x{664}x{665}x{666}x{667}x{668}x{669}x{66a}"), 4539);
  assertNull(res[1470].firstMatch("x{6f0}x{6f1}x{6f2}x{6f3}x{6f4}x{6f5}x{6f6}x{6f7}x{6f8}x{6f9}x{6fa}"), 4540);
  assertNull(res[1470].firstMatch("x{966}x{967}x{968}x{969}x{96a}x{96b}x{96c}x{96d}x{96e}x{96f}x{970}"), 4541);
  assertNull(res[1470].firstMatch("** Failers"), 4542);
  assertNull(res[1470].firstMatch("X"), 4543);
  assertNull(res[1471].firstMatch("x{16ee}"), 4544);
  assertNull(res[1471].firstMatch("** Failers"), 4545);
  assertNull(res[1471].firstMatch("X"), 4546);
  assertNull(res[1471].firstMatch("x{966}"), 4547);
  assertNull(res[1472].firstMatch("x{b2}"), 4548);
  assertNull(res[1472].firstMatch("x{b3}"), 4549);
  assertNull(res[1472].firstMatch("** Failers"), 4550);
  assertNull(res[1472].firstMatch("X"), 4551);
  assertNull(res[1472].firstMatch("x{16ee}"), 4552);
  assertNull(res[1473].firstMatch("_"), 4553);
  assertNull(res[1473].firstMatch("x{203f}"), 4554);
  assertNull(res[1473].firstMatch("** Failers"), 4555);
  assertNull(res[1473].firstMatch("X"), 4556);
  assertNull(res[1473].firstMatch("-"), 4557);
  assertNull(res[1473].firstMatch("x{58a}"), 4558);
  assertNull(res[1474].firstMatch("-"), 4559);
  assertNull(res[1474].firstMatch("x{58a}"), 4560);
  assertNull(res[1474].firstMatch("** Failers"), 4561);
  assertNull(res[1474].firstMatch("X"), 4562);
  assertNull(res[1474].firstMatch("x{203f}"), 4563);
  assertNull(res[1475].firstMatch(")"), 4564);
  assertNull(res[1475].firstMatch("]"), 4565);
  assertNull(res[1475].firstMatch("}"), 4566);
  assertNull(res[1475].firstMatch("x{f3b}"), 4567);
  assertNull(res[1475].firstMatch("** Failers"), 4568);
  assertNull(res[1475].firstMatch("X"), 4569);
  assertNull(res[1475].firstMatch("x{203f}"), 4570);
  assertNull(res[1475].firstMatch("("), 4571);
  assertNull(res[1475].firstMatch("["), 4572);
  assertNull(res[1475].firstMatch("{"), 4573);
  assertNull(res[1475].firstMatch("x{f3c}"), 4574);
  assertNull(res[1476].firstMatch("x{bb}"), 4575);
  assertNull(res[1476].firstMatch("x{2019}"), 4576);
  assertNull(res[1476].firstMatch("** Failers"), 4577);
  assertNull(res[1476].firstMatch("X"), 4578);
  assertNull(res[1476].firstMatch("x{203f}"), 4579);
  assertNull(res[1477].firstMatch("x{ab}"), 4580);
  assertNull(res[1477].firstMatch("x{2018}"), 4581);
  assertNull(res[1477].firstMatch("** Failers"), 4582);
  assertNull(res[1477].firstMatch("X"), 4583);
  assertNull(res[1477].firstMatch("x{203f}"), 4584);
  assertNull(res[1478].firstMatch("!"), 4585);
  assertNull(res[1478].firstMatch("x{37e}"), 4586);
  assertNull(res[1478].firstMatch("** Failers"), 4587);
  assertNull(res[1478].firstMatch("X"), 4588);
  assertNull(res[1478].firstMatch("x{203f}"), 4589);
  assertNull(res[1479].firstMatch("("), 4590);
  assertNull(res[1479].firstMatch("["), 4591);
  assertNull(res[1479].firstMatch("{"), 4592);
  assertNull(res[1479].firstMatch("x{f3c}"), 4593);
  assertNull(res[1479].firstMatch("** Failers"), 4594);
  assertNull(res[1479].firstMatch("X"), 4595);
  assertNull(res[1479].firstMatch(")"), 4596);
  assertNull(res[1479].firstMatch("]"), 4597);
  assertNull(res[1479].firstMatch("}"), 4598);
  assertNull(res[1479].firstMatch("x{f3b}"), 4599);
  assertNull(res[1479].firstMatch("\$x{a2}x{a3}x{a4}x{a5}x{a6}"), 4600);
  assertNull(res[1479].firstMatch("x{9f2}"), 4601);
  assertNull(res[1479].firstMatch("** Failers"), 4602);
  assertNull(res[1479].firstMatch("X"), 4603);
  assertNull(res[1479].firstMatch("x{2c2}"), 4604);
  assertNull(res[1480].firstMatch("x{2c2}"), 4605);
  assertNull(res[1480].firstMatch("** Failers"), 4606);
  assertNull(res[1480].firstMatch("X"), 4607);
  assertNull(res[1480].firstMatch("x{9f2}"), 4608);
  assertNull(res[1480].firstMatch("+<|~x{ac}x{2044}"), 4609);
  assertNull(res[1480].firstMatch("** Failers"), 4610);
  assertNull(res[1480].firstMatch("X"), 4611);
  assertNull(res[1480].firstMatch("x{9f2}"), 4612);
  assertNull(res[1481].firstMatch("x{a6}"), 4613);
  assertNull(res[1481].firstMatch("x{482} "), 4614);
  assertNull(res[1481].firstMatch("** Failers"), 4615);
  assertNull(res[1481].firstMatch("X"), 4616);
  assertNull(res[1481].firstMatch("x{9f2}"), 4617);
  assertNull(res[1482].firstMatch("x{2028}"), 4618);
  assertNull(res[1482].firstMatch("** Failers"), 4619);
  assertNull(res[1482].firstMatch("X"), 4620);
  assertNull(res[1482].firstMatch("x{2029}"), 4621);
  assertNull(res[1483].firstMatch("x{2029}"), 4622);
  assertNull(res[1483].firstMatch("** Failers"), 4623);
  assertNull(res[1483].firstMatch("X"), 4624);
  assertNull(res[1483].firstMatch("x{2028}"), 4625);
  assertNull(res[1484].firstMatch("\\ \\"), 4626);
  assertNull(res[1484].firstMatch("x{a0}"), 4627);
  assertNull(res[1484].firstMatch("x{1680}"), 4628);
  assertNull(res[1484].firstMatch("x{180e}"), 4629);
  assertNull(res[1484].firstMatch("x{2000}"), 4630);
  assertNull(res[1484].firstMatch("x{2001}     "), 4631);
  assertNull(res[1484].firstMatch("** Failers"), 4632);
  assertNull(res[1484].firstMatch("x{2028}"), 4633);
  assertNull(res[1484].firstMatch("x{200d} "), 4634);
  assertNull(res[1484].firstMatch("  x{660}x{661}x{662}ABC"), 4635);
  assertNull(res[1484].firstMatch("  x{660}x{661}x{662}ABC"), 4636);
  assertNull(res[1485].firstMatch("  x{660}x{661}x{662}ABC"), 4637);
  assertNull(res[1486].firstMatch("  x{660}x{661}x{662}ABC"), 4638);
  assertNull(res[1487].firstMatch("  x{660}x{661}x{662}ABC"), 4639);
  assertNull(res[1488].firstMatch("  x{660}x{661}x{662}ABC"), 4640);
  assertNull(res[1489].firstMatch("  x{660}x{661}x{662}ABC"), 4641);
  assertNull(res[1490].firstMatch("  x{660}x{661}x{662}ABC"), 4642);
  assertNull(res[1491].firstMatch("  x{660}x{661}x{662}ABC"), 4643);
  assertNull(res[1492].firstMatch("  x{660}x{661}x{662}ABC"), 4644);
  assertNull(res[1493].firstMatch("  x{660}x{661}x{662}ABC"), 4645);
  assertNull(res[1493].firstMatch("  x{660}x{661}x{662}ABC"), 4646);
  assertNull(res[1493].firstMatch("  x{660}x{661}x{662}ABC"), 4647);
  assertNull(res[1493].firstMatch("  ** Failers"), 4648);
  assertNull(res[1493].firstMatch("  x{660}x{661}x{662}ABC"), 4649);
  assertNull(res[1494].firstMatch("A"), 4650);
  assertNull(res[1494].firstMatch("ax{10a0}B "), 4651);
  assertNull(res[1494].firstMatch("** Failers "), 4652);
  assertNull(res[1494].firstMatch("a"), 4653);
  assertNull(res[1494].firstMatch("x{1d00}  "), 4654);
  assertNull(res[1495].firstMatch("1234"), 4655);
  assertNull(res[1495].firstMatch("** Failers"), 4656);
  assertNull(res[1495].firstMatch("ABC "), 4657);
  assertNull(res[1496].firstMatch("1234"), 4658);
  assertNull(res[1496].firstMatch("** Failers"), 4659);
  assertNull(res[1496].firstMatch("ABC "), 4660);
  assertNull(res[1496].firstMatch("A2XYZ"), 4661);
  assertNull(res[1496].firstMatch("123A5XYZPQR"), 4662);
  assertNull(res[1496].firstMatch("ABAx{660}XYZpqr"), 4663);
  assertNull(res[1496].firstMatch("** Failers"), 4664);
  assertNull(res[1496].firstMatch("AXYZ"), 4665);
  assertNull(res[1496].firstMatch("XYZ     "), 4666);
  assertNull(res[1496].firstMatch("1XYZ"), 4667);
  assertNull(res[1496].firstMatch("AB=XYZ.. "), 4668);
  assertNull(res[1496].firstMatch("XYZ "), 4669);
  assertNull(res[1496].firstMatch("** Failers"), 4670);
  assertNull(res[1496].firstMatch("WXYZ "), 4671);
  assertNull(res[1497].firstMatch("1234"), 4672);
  assertNull(res[1497].firstMatch("1234"), 4673);
  assertNull(res[1497].firstMatch("12-34"), 4674);
  assertToStringEquals("{", res[1497].firstMatch("12+x{661}-34  "), 4675);
  assertNull(res[1497].firstMatch("** Failers"), 4676);
  assertToStringEquals("d", res[1497].firstMatch("abcd  "), 4677);
  assertToStringEquals("d", res[1498].firstMatch("abcd"), 4678);
  assertNull(res[1498].firstMatch("** Failers"), 4679);
  assertNull(res[1498].firstMatch("1234"), 4680);
  assertNull(res[1499].firstMatch("11111111111111111111111111111111111111111111111111111111111111111111111"), 4681);
  assertToStringEquals("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", res[1499].firstMatch("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"), 4682);
  assertToStringEquals(" ", res[1499].firstMatch(" "), 4683);
  assertNull(res[1499].firstMatch("11111111111111111111111111111111111111111111111111111111111111111111111"), 4684);
  assertToStringEquals("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", res[1499].firstMatch("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"), 4685);
  assertNull(res[1500].firstMatch("11111111111111111111111111111111111111111111111111111111111111111111111"), 4686);
  assertToStringEquals("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", res[1500].firstMatch("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"), 4687);
  assertNull(res[1501].firstMatch("11111111111111111111111111111111111111111111111111111111111111111111111"), 4688);
  assertNull(res[1501].firstMatch("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"), 4689);
  assertNull(res[1502].firstMatch("11111111111111111111111111111111111111111111111111111111111111111111111"), 4690);
  assertToStringEquals("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", res[1502].firstMatch("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"), 4691);
  assertNull(res[1503].firstMatch("a"), 4692);
  assertNull(res[1503].firstMatch("A "), 4693);
  assertNull(res[1504].firstMatch("a"), 4694);
  assertNull(res[1504].firstMatch("A "), 4695);
  assertNull(res[1505].firstMatch("A"), 4696);
  assertNull(res[1505].firstMatch("aZ"), 4697);
  assertNull(res[1505].firstMatch("** Failers"), 4698);
  assertNull(res[1505].firstMatch("abc   "), 4699);
  assertNull(res[1506].firstMatch("A"), 4700);
  assertNull(res[1506].firstMatch("aZ"), 4701);
  assertNull(res[1506].firstMatch("** Failers"), 4702);
  assertNull(res[1506].firstMatch("abc   "), 4703);
  assertNull(res[1507].firstMatch("a"), 4704);
  assertNull(res[1507].firstMatch("Az"), 4705);
  assertNull(res[1507].firstMatch("** Failers"), 4706);
  assertNull(res[1507].firstMatch("ABC   "), 4707);
  assertNull(res[1508].firstMatch("a"), 4708);
  assertNull(res[1508].firstMatch("Az"), 4709);
  assertNull(res[1508].firstMatch("** Failers"), 4710);
  assertNull(res[1508].firstMatch("ABC   "), 4711);
  assertNull(res[1508].firstMatch("x{c0}"), 4712);
  assertNull(res[1508].firstMatch("x{e0} "), 4713);
  assertNull(res[1508].firstMatch("x{c0}"), 4714);
  assertNull(res[1508].firstMatch("x{e0} "), 4715);
  assertNull(res[1508].firstMatch("Ax{391}x{10427}x{ff3a}x{1fb0}"), 4716);
  assertNull(res[1508].firstMatch("** Failers"), 4717);
  assertNull(res[1508].firstMatch("ax{391}x{10427}x{ff3a}x{1fb0}   "), 4718);
  assertNull(res[1508].firstMatch("Ax{3b1}x{10427}x{ff3a}x{1fb0}"), 4719);
  assertNull(res[1508].firstMatch("Ax{391}x{1044F}x{ff3a}x{1fb0}"), 4720);
  assertNull(res[1508].firstMatch("Ax{391}x{10427}x{ff5a}x{1fb0}"), 4721);
  assertNull(res[1508].firstMatch("Ax{391}x{10427}x{ff3a}x{1fb8}"), 4722);
  assertNull(res[1508].firstMatch("Ax{391}x{10427}x{ff3a}x{1fb0}"), 4723);
  assertNull(res[1508].firstMatch("ax{391}x{10427}x{ff3a}x{1fb0}   "), 4724);
  assertNull(res[1508].firstMatch("Ax{3b1}x{10427}x{ff3a}x{1fb0}"), 4725);
  assertNull(res[1508].firstMatch("Ax{391}x{1044F}x{ff3a}x{1fb0}"), 4726);
  assertNull(res[1508].firstMatch("Ax{391}x{10427}x{ff5a}x{1fb0}"), 4727);
  assertNull(res[1508].firstMatch("Ax{391}x{10427}x{ff3a}x{1fb8}"), 4728);
  assertNull(res[1508].firstMatch("x{391}x{3b1}x{3b1}x{3b1}x{391}"), 4729);
  assertNull(res[1508].firstMatch("x{391}x{3b1}x{3b1}x{3b1}x{391}X"), 4730);
  assertNull(res[1508].firstMatch("x{391}x{3b1}x{3b1}x{3b1}x{391}X"), 4731);
  assertNull(res[1508].firstMatch("x{391}"), 4732);
  assertNull(res[1508].firstMatch("x{ff3a}"), 4733);
  assertNull(res[1508].firstMatch("x{3b1}"), 4734);
  assertNull(res[1508].firstMatch("x{ff5a}   "), 4735);
  assertNull(res[1508].firstMatch("x{c0}"), 4736);
  assertNull(res[1508].firstMatch("x{e0} "), 4737);
  assertNull(res[1508].firstMatch("x{104}"), 4738);
  assertNull(res[1508].firstMatch("x{105}"), 4739);
  assertNull(res[1508].firstMatch("x{109}  "), 4740);
  assertNull(res[1508].firstMatch("** Failers"), 4741);
  assertNull(res[1508].firstMatch("x{100}"), 4742);
  assertNull(res[1508].firstMatch("x{10a} "), 4743);
  assertNull(res[1508].firstMatch("Z"), 4744);
  assertNull(res[1508].firstMatch("z"), 4745);
  assertNull(res[1508].firstMatch("x{39c}"), 4746);
  assertNull(res[1508].firstMatch("x{178}"), 4747);
  assertNull(res[1508].firstMatch("|"), 4748);
  assertNull(res[1508].firstMatch("x{80}"), 4749);
  assertNull(res[1508].firstMatch("x{ff}"), 4750);
  assertNull(res[1508].firstMatch("x{100}"), 4751);
  assertNull(res[1508].firstMatch("x{101} "), 4752);
  assertNull(res[1508].firstMatch("** Failers"), 4753);
  assertNull(res[1508].firstMatch("x{102}"), 4754);
  assertNull(res[1508].firstMatch("Y"), 4755);
  assertNull(res[1508].firstMatch("y           "), 4756);
  assertNull(res[1509].firstMatch("A"), 4757);
  assertNull(res[1509].firstMatch("Ax{300}BC "), 4758);
  assertNull(res[1509].firstMatch("Ax{300}x{301}x{302}BC "), 4759);
  assertNull(res[1509].firstMatch("*** Failers"), 4760);
  assertNull(res[1509].firstMatch("x{300}  "), 4761);
  assertToStringEquals("X", res[1510].firstMatch("X123"), 4762);
  assertNull(res[1510].firstMatch("*** Failers"), 4763);
  assertNull(res[1510].firstMatch("AXYZ"), 4764);
  assertNull(res[1511].firstMatch("Ax{300}x{301}x{302}BCAx{300}x{301} "), 4765);
  assertNull(res[1511].firstMatch("Ax{300}x{301}x{302}BCAx{300}x{301}C "), 4766);
  assertNull(res[1512].firstMatch("Ax{300}x{301}x{302}BCAx{300}x{301} "), 4767);
  assertNull(res[1512].firstMatch("Ax{300}x{301}x{302}BCAx{300}x{301}C "), 4768);
  assertToStringEquals("A,,A", res[1513].firstMatch("Ax{300}x{301}x{302}BCAx{300}x{301} "), 4769);
  assertToStringEquals("A,,A", res[1513].firstMatch("Ax{300}x{301}x{302}BCAx{300}x{301}C "), 4770);
  assertToStringEquals("A,,A", res[1514].firstMatch("Ax{300}x{301}x{302}BCAx{300}x{301} "), 4771);
  assertToStringEquals("A,,A", res[1514].firstMatch("Ax{300}x{301}x{302}BCAx{300}x{301}C "), 4772);
  assertNull(res[1515].firstMatch("*** Failers"), 4773);
  assertNull(res[1515].firstMatch("Ax{300}x{301}x{302}"), 4774);
  assertNull(res[1516].firstMatch("Ax{300}x{301}Bx{300}X"), 4775);
  assertNull(res[1516].firstMatch("Ax{300}x{301}Bx{300}Cx{300}x{301}"), 4776);
  assertNull(res[1516].firstMatch("Ax{300}x{301}Bx{300}Cx{300}x{301}X"), 4777);
  assertNull(res[1516].firstMatch("Ax{300}x{301}Bx{300}Cx{300}x{301}DAx{300}X"), 4778);
  assertNull(res[1517].firstMatch("Ax{300}x{301}Bx{300}X"), 4779);
  assertNull(res[1517].firstMatch("Ax{300}x{301}Bx{300}Cx{300}x{301}"), 4780);
  assertNull(res[1517].firstMatch("Ax{300}x{301}Bx{300}Cx{300}x{301}X"), 4781);
  assertNull(res[1517].firstMatch("Ax{300}x{301}Bx{300}Cx{300}x{301}DAx{300}X"), 4782);
  assertNull(res[1518].firstMatch("12X"), 4783);
  assertNull(res[1518].firstMatch("123X"), 4784);
  assertNull(res[1518].firstMatch("*** Failers"), 4785);
  assertNull(res[1518].firstMatch("X"), 4786);
  assertNull(res[1518].firstMatch("1X"), 4787);
  assertNull(res[1518].firstMatch("1234X     "), 4788);
  assertNull(res[1518].firstMatch("x{100}   "), 4789);
  assertNull(res[1518].firstMatch("x{101} "), 4790);
  assertNull(res[1518].firstMatch("x{2e81}x{3007}x{2f804}x{31a0}"), 4791);
  assertNull(res[1518].firstMatch("** Failers"), 4792);
  assertNull(res[1518].firstMatch("x{2e7f}  "), 4793);
  assertNull(res[1518].firstMatch("x{3105}"), 4794);
  assertNull(res[1518].firstMatch("** Failers"), 4795);
  assertNull(res[1518].firstMatch("x{30ff}  "), 4796);
  assertNull(res[1519].firstMatch("x{06e9}"), 4797);
  assertNull(res[1519].firstMatch("x{060b}"), 4798);
  assertNull(res[1519].firstMatch("** Failers"), 4799);
  assertNull(res[1519].firstMatch("Xx{06e9}   "), 4800);
  assertNull(res[1520].firstMatch("x{2f800}"), 4801);
  assertNull(res[1520].firstMatch("** Failers"), 4802);
  assertNull(res[1520].firstMatch("x{a014}"), 4803);
  assertNull(res[1520].firstMatch("x{a4c6}   "), 4804);
  assertNull(res[1521].firstMatch("AXYZ"), 4805);
  assertNull(res[1521].firstMatch("x{1234}XYZ "), 4806);
  assertNull(res[1521].firstMatch("** Failers"), 4807);
  assertNull(res[1521].firstMatch("X  "), 4808);
  assertNull(res[1522].firstMatch("** Failers"), 4809);
  assertNull(res[1522].firstMatch("AX"), 4810);
  assertNull(res[1523].firstMatch("XYZ"), 4811);
  assertNull(res[1523].firstMatch("AXYZ"), 4812);
  assertNull(res[1523].firstMatch("x{1234}XYZ "), 4813);
  assertNull(res[1523].firstMatch("** Failers"), 4814);
  assertNull(res[1523].firstMatch("ABXYZ   "), 4815);
  assertNull(res[1524].firstMatch("XYZ"), 4816);
  assertNull(res[1524].firstMatch("** Failers"), 4817);
  assertNull(res[1524].firstMatch("AXYZ"), 4818);
  assertNull(res[1524].firstMatch("x{1234}XYZ "), 4819);
  assertNull(res[1524].firstMatch("ABXYZ   "), 4820);
  assertNull(res[1524].firstMatch("AXYZ"), 4821);
  assertNull(res[1524].firstMatch("x{1234}XYZ"), 4822);
  assertNull(res[1524].firstMatch("Ax{1234}XYZ"), 4823);
  assertNull(res[1524].firstMatch("** Failers"), 4824);
  assertNull(res[1524].firstMatch("XYZ"), 4825);
  assertNull(res[1524].firstMatch("** Failers"), 4826);
  assertNull(res[1524].firstMatch("AXYZ"), 4827);
  assertNull(res[1524].firstMatch("x{1234}XYZ"), 4828);
  assertNull(res[1524].firstMatch("Ax{1234}XYZ"), 4829);
  assertNull(res[1524].firstMatch("XYZ"), 4830);
  assertNull(res[1525].firstMatch("XYZ"), 4831);
  assertNull(res[1525].firstMatch("AXYZ"), 4832);
  assertNull(res[1525].firstMatch("x{1234}XYZ"), 4833);
  assertNull(res[1525].firstMatch("Ax{1234}XYZ"), 4834);
  assertNull(res[1525].firstMatch("** Failers"), 4835);
  assertNull(res[1526].firstMatch("XYZ"), 4836);
  assertNull(res[1526].firstMatch("** Failers"), 4837);
  assertNull(res[1526].firstMatch("AXYZ"), 4838);
  assertNull(res[1526].firstMatch("x{1234}XYZ"), 4839);
  assertNull(res[1526].firstMatch("Ax{1234}XYZ"), 4840);
  assertToStringEquals("AX", res[1527].firstMatch("AXYZ"), 4841);
  assertNull(res[1527].firstMatch("x{1234}XYZ "), 4842);
  assertNull(res[1527].firstMatch("** Failers"), 4843);
  assertNull(res[1527].firstMatch("X  "), 4844);
  assertNull(res[1528].firstMatch("** Failers"), 4845);
  assertToStringEquals("AX", res[1528].firstMatch("AX"), 4846);
  assertToStringEquals("X", res[1529].firstMatch("XYZ"), 4847);
  assertToStringEquals("AX", res[1529].firstMatch("AXYZ"), 4848);
  assertNull(res[1529].firstMatch("x{1234}XYZ "), 4849);
  assertNull(res[1529].firstMatch("** Failers"), 4850);
  assertNull(res[1529].firstMatch("ABXYZ   "), 4851);
  assertToStringEquals("X", res[1530].firstMatch("XYZ"), 4852);
  assertNull(res[1530].firstMatch("** Failers"), 4853);
  assertToStringEquals("AX", res[1530].firstMatch("AXYZ"), 4854);
  assertNull(res[1530].firstMatch("x{1234}XYZ "), 4855);
  assertNull(res[1530].firstMatch("ABXYZ   "), 4856);
  assertToStringEquals("AX", res[1531].firstMatch("AXYZ"), 4857);
  assertNull(res[1531].firstMatch("x{1234}XYZ"), 4858);
  assertNull(res[1531].firstMatch("Ax{1234}XYZ"), 4859);
  assertNull(res[1531].firstMatch("** Failers"), 4860);
  assertNull(res[1531].firstMatch("XYZ"), 4861);
  assertNull(res[1532].firstMatch("** Failers"), 4862);
  assertToStringEquals("AX", res[1532].firstMatch("AXYZ"), 4863);
  assertNull(res[1532].firstMatch("x{1234}XYZ"), 4864);
  assertNull(res[1532].firstMatch("Ax{1234}XYZ"), 4865);
  assertNull(res[1532].firstMatch("XYZ"), 4866);
  assertToStringEquals("X", res[1533].firstMatch("XYZ"), 4867);
  assertToStringEquals("AX", res[1533].firstMatch("AXYZ"), 4868);
  assertNull(res[1533].firstMatch("x{1234}XYZ"), 4869);
  assertNull(res[1533].firstMatch("Ax{1234}XYZ"), 4870);
  assertNull(res[1533].firstMatch("** Failers"), 4871);
  assertToStringEquals("X", res[1534].firstMatch("XYZ"), 4872);
  assertNull(res[1534].firstMatch("** Failers"), 4873);
  assertToStringEquals("AX", res[1534].firstMatch("AXYZ"), 4874);
  assertNull(res[1534].firstMatch("x{1234}XYZ"), 4875);
  assertNull(res[1534].firstMatch("Ax{1234}XYZ"), 4876);
  assertNull(res[1535].firstMatch("abcdefgh"), 4877);
  assertNull(res[1535].firstMatch("x{1234}\n\x0dx{3456}xyz "), 4878);
  assertNull(res[1536].firstMatch("abcdefgh"), 4879);
  assertNull(res[1536].firstMatch("x{1234}\n\x0dx{3456}xyz "), 4880);
  assertNull(res[1537].firstMatch("** Failers"), 4881);
  assertNull(res[1537].firstMatch("abcdefgh"), 4882);
  assertNull(res[1537].firstMatch("x{1234}\n\x0dx{3456}xyz "), 4883);
  assertNull(res[1538].firstMatch(" AXY"), 4884);
  assertNull(res[1538].firstMatch(" aXY"), 4885);
  assertNull(res[1538].firstMatch(" x{1c5}XY"), 4886);
  assertNull(res[1538].firstMatch(" ** Failers"), 4887);
  assertNull(res[1538].firstMatch(" x{1bb}XY"), 4888);
  assertNull(res[1538].firstMatch(" x{2b0}XY"), 4889);
  assertNull(res[1538].firstMatch(" !XY      "), 4890);
  assertNull(res[1539].firstMatch(" AXY"), 4891);
  assertNull(res[1539].firstMatch(" aXY"), 4892);
  assertNull(res[1539].firstMatch(" x{1c5}XY"), 4893);
  assertNull(res[1539].firstMatch(" ** Failers"), 4894);
  assertNull(res[1539].firstMatch(" x{1bb}XY"), 4895);
  assertNull(res[1539].firstMatch(" x{2b0}XY"), 4896);
  assertNull(res[1539].firstMatch(" !XY      "), 4897);
  assertNull(res[1539].firstMatch(" AXY"), 4898);
  assertNull(res[1539].firstMatch(" aXY"), 4899);
  assertNull(res[1539].firstMatch(" AbcdeXyz "), 4900);
  assertNull(res[1539].firstMatch(" x{1c5}AbXY"), 4901);
  assertNull(res[1539].firstMatch(" abcDEXypqreXlmn "), 4902);
  assertNull(res[1539].firstMatch(" ** Failers"), 4903);
  assertNull(res[1539].firstMatch(" x{1bb}XY"), 4904);
  assertNull(res[1539].firstMatch(" x{2b0}XY"), 4905);
  assertNull(res[1539].firstMatch(" !XY      "), 4906);
  assertNull(res[1540].firstMatch(" AXY"), 4907);
  assertNull(res[1540].firstMatch(" aXY"), 4908);
  assertNull(res[1540].firstMatch(" AbcdeXyz "), 4909);
  assertNull(res[1540].firstMatch(" x{1c5}AbXY"), 4910);
  assertNull(res[1540].firstMatch(" abcDEXypqreXlmn "), 4911);
  assertNull(res[1540].firstMatch(" ** Failers"), 4912);
  assertNull(res[1540].firstMatch(" x{1bb}XY"), 4913);
  assertNull(res[1540].firstMatch(" x{2b0}XY"), 4914);
  assertNull(res[1540].firstMatch(" !XY      "), 4915);
  assertNull(res[1540].firstMatch(" AXY"), 4916);
  assertNull(res[1540].firstMatch(" aXY"), 4917);
  assertNull(res[1540].firstMatch(" AbcdeXyz "), 4918);
  assertNull(res[1540].firstMatch(" x{1c5}AbXY"), 4919);
  assertNull(res[1540].firstMatch(" abcDEXypqreXlmn "), 4920);
  assertNull(res[1540].firstMatch(" ** Failers"), 4921);
  assertNull(res[1540].firstMatch(" x{1bb}XY"), 4922);
  assertNull(res[1540].firstMatch(" x{2b0}XY"), 4923);
  assertNull(res[1540].firstMatch(" !XY      "), 4924);
  assertNull(res[1541].firstMatch(" AXY"), 4925);
  assertNull(res[1541].firstMatch(" aXY"), 4926);
  assertNull(res[1541].firstMatch(" AbcdeXyz "), 4927);
  assertNull(res[1541].firstMatch(" x{1c5}AbXY"), 4928);
  assertNull(res[1541].firstMatch(" abcDEXypqreXlmn "), 4929);
  assertNull(res[1541].firstMatch(" ** Failers"), 4930);
  assertNull(res[1541].firstMatch(" x{1bb}XY"), 4931);
  assertNull(res[1541].firstMatch(" x{2b0}XY"), 4932);
  assertNull(res[1541].firstMatch(" !XY      "), 4933);
  assertNull(res[1542].firstMatch(" !XY"), 4934);
  assertNull(res[1542].firstMatch(" x{1bb}XY"), 4935);
  assertNull(res[1542].firstMatch(" x{2b0}XY"), 4936);
  assertNull(res[1542].firstMatch(" ** Failers"), 4937);
  assertNull(res[1542].firstMatch(" x{1c5}XY"), 4938);
  assertNull(res[1542].firstMatch(" AXY      "), 4939);
  assertNull(res[1543].firstMatch(" !XY"), 4940);
  assertNull(res[1543].firstMatch(" x{1bb}XY"), 4941);
  assertNull(res[1543].firstMatch(" x{2b0}XY"), 4942);
  assertNull(res[1543].firstMatch(" ** Failers"), 4943);
  assertNull(res[1543].firstMatch(" x{1c5}XY"), 4944);
  assertNull(res[1543].firstMatch(" AXY      "), 4945);
  assertNull(res[1543].firstMatch("x{c0}x{e0}x{116}x{117}"), 4946);
  assertNull(res[1543].firstMatch("x{c0}x{e0}x{116}x{117}"), 4947);
  assertNull(res[1545].firstMatch("123abcdefg"), 4948);
  assertNull(res[1545].firstMatch("123abc\xc4\xc5zz"), 4949);
  assertNull(res[1546].firstMatch("x{102A4}x{AA52}x{A91D}x{1C46}x{10283}x{1092E}x{1C6B}x{A93B}x{A8BF}x{1BA0}x{A50A}===="), 4950);
  assertNull(res[1546].firstMatch("x{a77d}x{1d79}"), 4951);
  assertNull(res[1546].firstMatch("x{1d79}x{a77d} "), 4952);
  assertNull(res[1546].firstMatch("x{a77d}x{1d79}"), 4953);
  assertNull(res[1546].firstMatch("** Failers "), 4954);
  assertNull(res[1546].firstMatch("x{1d79}x{a77d} "), 4955);
  // Dart does not have RegExp literals and thus no translatation of the below.
  // assertThrows("var re = //;", 4956);
}
