// Copyright (c) 2014, the Dart project authors. All rights reserved.
// Copyright 2013 the V8 project authors. All rights reserved.
// Copyright (C) 2005, 2006, 2007, 2008, 2009 Apple Inc. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1.  Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
// 2.  Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
// ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import 'v8_regexp_utils.dart';
import 'package:expect/expect.dart';

void main() {
  description(
  'Test for <a href="https://bugs.webkit.org/show_bug.cgi?id=8870">bug 8870</a>: Crash typing in Yahoo auto-complete widget.'
  );

  var re = new RegExp(r'^(\s+|[,:{}\[\]]|"(\\["\\\/bfnrtu]|[^\u0000-\u001f"\\]+)*"|-?\d+(\.\d*)?([eE][+-]?\d+)?|true|false|null)+$');

  var result= re.firstMatch('{"ResultSet":{"totalResultsAvailable":"101000000","totalResultsReturned":100,"firstResultPosition":1,"Result":[{"Title":"Solar Eclipses of Saros 132","Summary":"Solar Eclipses of Saros 132 Solar Eclipses of Saros 132 The periodicity and recurrence of solar (and lunar) eclipses is governed by the Saros cycle, a period of approximately 6,585. 3 days (18 years 11 days 8 hours). When two eclipses are ...","Url":"http:\\/\\/sunearth.gsfc.nasa.gov\\/eclipse\\/SEsaros\\/SEsaros132.html","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBUBzdmMwF;_ylu=X3oDMTB2cXVjNTM5BGNvbG8DdwRsA1dTMQRwb3MDMQRzZWMDc3IEdnRpZAM-\\/SIG=19ip3vo9u\\/EXP=1147592336\\/**http%3a\\/\\/rdrw1.yahoo.com\\/click%3fu=http%3a\\/\\/sunearth.gsfc.nasa.gov\\/eclipse\\/SEsaros\\/SEsaros132.html%26y=0405DC60F30D6DD673%26i=482%26c=15685%26q=02%255ESSHPM%255BL7.,-6%26e=utf-8%26r=0%26d=wow%7eWBSV-en-us%26n=3O6KG7JU5PIK8T7I%26s=6%26t=%26m=44658D10%26x=05A6B5FDC2F29725CD6EE467684E0FE76D","ModificationDate":1146207600,"MimeType":"text\\/html"},{"Title":"Psalms 132 -Matthew Henry\'s Commentary - Bible Software by johnhurt.com","Summary":"Psalms 132 - Matthew Henry Commentary - Bible Software by johnhurt.com ... Henry\'s Psalms 131. Psalms 132. Outline of Psalms 132. David\'s care for the ark ...","Url":"http:\\/\\/www.htmlbible.com\\/kjv30\\/henry\\/H19C132.htm","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBVhzdmMwF;_ylu=X3oDMTB2ZjQ4dDExBGNvbG8DdwRsA1dTMQRwb3MDMgRzZWMDc3IEdnRpZAM-\\/SIG=1246fjpfq\\/EXP=1147592336\\/**http%3a\\/\\/www.htmlbible.com\\/kjv30\\/henry\\/H19C132.htm","ModificationDate":1015660800,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBWxzdmMwF;_ylu=X3oDMTBwZG5hOWwzBGNvbG8DdwRwb3MDMgRzZWMDc3IEdnRpZAM-\\/SIG=16llm3b1a\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.htmlbible.com\\/kjv30\\/henry\\/H19C132.htm%26w=132%26d=XlIIG0aqMlsm%26icp=1%26.intl=us","Size":"4160"}},{"Title":"General requirements. - 1910.132","Summary":"General%20requirements.%20-%201910.132 ... Regulations (Standards - 29 CFR) General requirements. - 1910.132 ... of any part of the body through absorption, inhalation or physical contact. 1910.132(b) Employee-owned equipment ...","Url":"http:\\/\\/www.osha.gov\\/pls\\/oshaweb\\/owadisp.show_document?p_table=STANDARDS&p_id=9777","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBXRzdmMwF;_ylu=X3oDMTB2M3MzdmZoBGNvbG8DdwRsA1dTMQRwb3MDMwRzZWMDc3IEdnRpZAM-\\/SIG=13916ebti\\/EXP=1147592336\\/**http%3a\\/\\/www.osha.gov\\/pls\\/oshaweb\\/owadisp.show_document%3fp_table=STANDARDS%26p_id=9777","ModificationDate":1147330800,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBYhzdmMwF;_ylu=X3oDMTBwZ2dpZ2ZkBGNvbG8DdwRwb3MDMwRzZWMDc3IEdnRpZAM-\\/SIG=186osem1n\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.osha.gov\\/pls\\/oshaweb\\/owadisp.show_document%253Fp_table%253DSTANDARDS%2526p_id%253D9777%26w=132%26d=Ujn5sEaqMw88%26icp=1%26.intl=us","Size":"29922"}},{"Title":"USCCB - NAB - Psalm 132","Summary":"Chapter 132. 1. 1 A song of ascents. 2 LORD, remember David and all his anxious care; 2. 3 How he swore an oath to the LORD, vowed to the Mighty One of Jacob: 3. \\"I will not enter the house where I live, nor lie on the couch where I sleep; ... 1 [Psalm 132] A song for a liturgical ceremony in which the ark, the throne of Israel\'s God, was carried in ...","Url":"http:\\/\\/www.usccb.org\\/nab\\/bible\\/psalms\\/psalm132.htm","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBZBzdmMwF;_ylu=X3oDMTB2OWM1MXQ5BGNvbG8DdwRsA1dTMQRwb3MDNARzZWMDc3IEdnRpZAM-\\/SIG=126n03p75\\/EXP=1147592336\\/**http%3a\\/\\/www.usccb.org\\/nab\\/bible\\/psalms\\/psalm132.htm","ModificationDate":1054623600,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBaRzdmMwF;_ylu=X3oDMTBwYzFnNmkxBGNvbG8DdwRwb3MDNARzZWMDc3IEdnRpZAM-\\/SIG=16nvcm74b\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.usccb.org\\/nab\\/bible\\/psalms\\/psalm132.htm%26w=132%26d=FMBGyUaqMh-a%26icp=1%26.intl=us","Size":"8840"}},{"Title":"* City of Lost Dreams Mod *","Summary":"Mafia game modification","Url":"http:\\/\\/www.citizen-132.com\\/","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBaxzdmMwF;_ylu=X3oDMTB2NW50aG1hBGNvbG8DdwRsA1dTMQRwb3MDNQRzZWMDc3IEdnRpZAM-\\/SIG=11fnqlf31\\/EXP=1147592336\\/**http%3a\\/\\/www.citizen-132.com\\/","ModificationDate":1107676800,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBcBzdmMwF;_ylu=X3oDMTBwdDJ0dDBoBGNvbG8DdwRwb3MDNQRzZWMDc3IEdnRpZAM-\\/SIG=160jdk4g3\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.citizen-132.com\\/%26w=132%26d=ZiSHAkaqMuny%26icp=1%26.intl=us","Size":"6861"}},{"Title":"BibleGateway.com: Search for a Bible passage in over 35 languages and 50 versions.","Summary":"English (EN) Espa\\u00f1ol (ES) Passage results ... Footnotes: Psalm 132:6 That is, Kiriath Jearim. Psalm 132:6 Or heard of it in ...","Url":"http:\\/\\/www.biblegateway.com\\/passage\\/?book_id=23&chapter=132&version=31","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBchzdmMwF;_ylu=X3oDMTB2azJrdmpwBGNvbG8DdwRsA1dTMQRwb3MDNgRzZWMDc3IEdnRpZAM-\\/SIG=1300p6cfh\\/EXP=1147592336\\/**http%3a\\/\\/www.biblegateway.com\\/passage\\/%3fbook_id=23%26chapter=132%26version=31","ModificationDate":1147158000,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBdxzdmMwF;_ylu=X3oDMTBwYmwxdWo4BGNvbG8DdwRwb3MDNgRzZWMDc3IEdnRpZAM-\\/SIG=183q9adk2\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.biblegateway.com\\/passage\\/%253Fbook_id%253D23%2526chapter%253D132%2526version%253D31%26w=132%26d=XUM-1kaqMwKY%26icp=1%26.intl=us","Size":"27373"}},{"Title":"132 - Wikipedia, the free encyclopedia","Summary":"From Wikipedia, the free encyclopedia. This article is about the year. For other uses, see 132 (number). Events. Roman Empire. The Olympeion in Athens is completed ... Your continued donations keep Wikipedia running! 132. From Wikipedia, the free encyclopedia ... For other uses, see 132 (number). Years: 128 129 130 131 - 132 - 133 134 135 136 ...","Url":"http:\\/\\/en.wikipedia.org\\/wiki\\/132","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBeRzdmMwF;_ylu=X3oDMTB2bDEyNXM5BGNvbG8DdwRsA1dTMQRwb3MDNwRzZWMDc3IEdnRpZAM-\\/SIG=11k81281i\\/EXP=1147592336\\/**http%3a\\/\\/en.wikipedia.org\\/wiki\\/132","ModificationDate":1145862000,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBfhzdmMwF;_ylu=X3oDMTBwMTB0ZWFoBGNvbG8DdwRwb3MDNwRzZWMDc3IEdnRpZAM-\\/SIG=165kmnv8l\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=en.wikipedia.org\\/wiki\\/132%26w=132%26d=OcxF4UaqMuf2%26icp=1%26.intl=us","Size":"15956"}},{"Title":"BBC SPORT | Football | Internationals","Summary":"Visit BBC Sport for all the action as it happens - up-to-the-minute news, results, breaking news, video, audio and feature stories. BBC Sport covers the major events and all the professional football clubs in the UK, plus cricket, rugby, golf, ...","Url":"http:\\/\\/news.bbc.co.uk\\/sport1\\/hi\\/football\\/internationals\\/default.stm","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBgBzdmMwF;_ylu=X3oDMTB2bTU4Zm85BGNvbG8DdwRsA1dTMQRwb3MDOARzZWMDc3IEdnRpZAM-\\/SIG=12n3aafin\\/EXP=1147592336\\/**http%3a\\/\\/news.bbc.co.uk\\/sport1\\/hi\\/football\\/internationals\\/default.stm","ModificationDate":1147417200,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBhRzdmMwF;_ylu=X3oDMTBwYTZ1aGtmBGNvbG8DdwRwb3MDOARzZWMDc3IEdnRpZAM-\\/SIG=178rplb9d\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=news.bbc.co.uk\\/sport1\\/hi\\/football\\/internationals\\/default.stm%26w=132%26d=PmSx-kaqMw8o%26icp=1%26.intl=us","Size":"52634"}},{"Title":"Metro Route 132 Timetable, Weekday","Summary":"... Custom Print Help. 132. Weekday: Feb. 11 thru June 2, 2006 ...","Url":"http:\\/\\/transit.metrokc.gov\\/tops\\/bus\\/schedules\\/s132_0_.html","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBhxzdmMwF;_ylu=X3oDMTB2dW8yNmN0BGNvbG8DdwRsA1dTMQRwb3MDOQRzZWMDc3IEdnRpZAM-\\/SIG=12eusl28m\\/EXP=1147592336\\/**http%3a\\/\\/transit.metrokc.gov\\/tops\\/bus\\/schedules\\/s132_0_.html","ModificationDate":1146553200,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBjBzdmMwF;_ylu=X3oDMTBwOTRzYmZlBGNvbG8DdwRwb3MDOQRzZWMDc3IEdnRpZAM-\\/SIG=16vd4gkvv\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=transit.metrokc.gov\\/tops\\/bus\\/schedules\\/s132_0_.html%26w=132%26d=Nvq_ekaqMulb%26icp=1%26.intl=us","Size":"27482"}},{"Title":"BBC NEWS | Politics | Bush arrives for state visit","Summary":"George Bush arrives in the UK for the first state visit by a US president amid some of the tightest security London has seen.","Url":"http:\\/\\/news.bbc.co.uk\\/1\\/hi\\/uk_politics\\/3279179.stm","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBjhzdmMwF;_ylu=X3oDMTEwc3RuNTk4BGNvbG8DdwRsA1dTMQRwb3MDMTAEc2VjA3NyBHZ0aWQD\\/SIG=126am8694\\/EXP=1147592336\\/**http%3a\\/\\/news.bbc.co.uk\\/1\\/hi\\/uk_politics\\/3279179.stm","ModificationDate":1147417200,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBkxzdmMwF;_ylu=X3oDMTBxNTUzbTg4BGNvbG8DdwRwb3MDMTAEc2VjA3NyBHZ0aWQD\\/SIG=16nt5u57o\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=news.bbc.co.uk\\/1\\/hi\\/uk_politics\\/3279179.stm%26w=132%26d=CxDE2UaqMw8U%26icp=1%26.intl=us","Size":"43537"}},{"Title":"132 (number) - Wikipedia, the free encyclopedia","Summary":"... you can make from 132, you get 132: 12 + 13 + 21 + 23 + 31 + 32 = 132. 132 is the smallest number ...","Url":"http:\\/\\/en.wikipedia.org\\/wiki\\/132_(number)","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBlRzdmMwF;_ylu=X3oDMTEwNXN0b3YwBGNvbG8DdwRsA1dTMQRwb3MDMTEEc2VjA3NyBHZ0aWQD\\/SIG=11thbnu67\\/EXP=1147592336\\/**http%3a\\/\\/en.wikipedia.org\\/wiki\\/132_(number)","ModificationDate":1145430000,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBmhzdmMwF;_ylu=X3oDMTBxYnA3amlzBGNvbG8DdwRwb3MDMTEEc2VjA3NyBHZ0aWQD\\/SIG=16m4qjjlq\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=en.wikipedia.org\\/wiki\\/132_%2528number%2529%26w=132%26d=Ygdh6EaqMsBb%26icp=1%26.intl=us","Size":"13154"}},{"Title":"Psalms, Chapter 132","Summary":"King James Reference Suite - Bible Software by johnhurt.com ... Chapter 132. 1. Lord, remember David, and all his afflictions ... Notes on Chapter 132. 1. 2. 3 ...","Url":"http:\\/\\/www.htmlbible.com\\/kjv30\\/B19C132.htm","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBnBzdmMwF;_ylu=X3oDMTEwNmgxNTZoBGNvbG8DdwRsA1dTMQRwb3MDMTIEc2VjA3NyBHZ0aWQD\\/SIG=11uujk8hq\\/EXP=1147592336\\/**http%3a\\/\\/www.htmlbible.com\\/kjv30\\/B19C132.htm","ModificationDate":1079942400,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBoRzdmMwF;_ylu=X3oDMTBxN2cybDkwBGNvbG8DdwRwb3MDMTIEc2VjA3NyBHZ0aWQD\\/SIG=16fpgk3vj\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.htmlbible.com\\/kjv30\\/B19C132.htm%26w=132%26d=TaFtBUaqMwcr%26icp=1%26.intl=us","Size":"8721"}},{"Title":"SPACE.com -- Privately Funded SpaceShipOne Breaks Sound Barrier","Summary":"A privately financed passenger-carrying sub-orbital rocket plane screamed its way through the sound barrier today, the 100th anniversary of the Wright Brothers historic 12-second flight over Kitty Hawk, North Carolina.","Url":"http:\\/\\/www.space.com\\/businesstechnology\\/technology\\/rutan_update_031217.html","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBoxzdmMwF;_ylu=X3oDMTEwNHRmcnV0BGNvbG8DdwRsA1dTMQRwb3MDMTMEc2VjA3NyBHZ0aWQD\\/SIG=12vltjpcd\\/EXP=1147592336\\/**http%3a\\/\\/www.space.com\\/businesstechnology\\/technology\\/rutan_update_031217.html","ModificationDate":1147330800,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBqBzdmMwF;_ylu=X3oDMTBxajcxM3AwBGNvbG8DdwRwb3MDMTMEc2VjA3NyBHZ0aWQD\\/SIG=17g6i6br5\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.space.com\\/businesstechnology\\/technology\\/rutan_update_031217.html%26w=132%26d=CklT2kaqMwqb%26icp=1%26.intl=us","Size":"39319"}},{"Title":"D&C 132","Summary":"THE DOCTRINE AND COVENANTS. SECTION 132 ... LDS HomeScriptures Doctrine and Covenants Sections Section 132. Prev | Next ... SECTION 132. Revelation given through Joseph Smith the Prophet, at Nauvoo, Illinois, recorded July 12, 1843 ...","Url":"http:\\/\\/scriptures.lds.org\\/dc\\/132","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBqhzdmMwF;_ylu=X3oDMTEwamo4ZjVjBGNvbG8DdwRsA1dTMQRwb3MDMTQEc2VjA3NyBHZ0aWQD\\/SIG=11k67f7oi\\/EXP=1147592336\\/**http%3a\\/\\/scriptures.lds.org\\/dc\\/132","ModificationDate":1146985200,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBrxzdmMwF;_ylu=X3oDMTBxcDhuOXFrBGNvbG8DdwRwb3MDMTQEc2VjA3NyBHZ0aWQD\\/SIG=165qbp40u\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=scriptures.lds.org\\/dc\\/132%26w=132%26d=KIW1S0aqMwF3%26icp=1%26.intl=us","Size":"51549"}},{"Title":"State Representative District 132","Summary":"State Representative District 132. State Representative District 132 is shaded area. SACO. BIDDEFORD. 127. 132. 133. 136. OLD ORCHARD BEACH. SACO","Url":"http:\\/\\/mainegov-images.informe.org\\/sos\\/cec\\/elec\\/apport\\/House\\/h132.pdf","ClickUrl":"http:\\/\\/mainegov-images.informe.org\\/sos\\/cec\\/elec\\/apport\\/House\\/h132.pdf#search=\'\'","ModificationDate":1075968000,"MimeType":"application\\/pdf","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBtBzdmMwF;_ylu=X3oDMTBxbnZxbGc1BGNvbG8DdwRwb3MDMTUEc2VjA3NyBHZ0aWQD\\/SIG=17at7erej\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=mainegov-images.informe.org\\/sos\\/cec\\/elec\\/apport\\/House\\/h132.pdf%26w=132%26d=DsRim0aqMiIQ%26icp=1%26.intl=us","Size":"129767"}},{"Title":"BLB Psa 132","Summary":"We apologize, but the page layout is not visible because you are using an older browser. We recommend upgrading to a standards-compliant browser. Without such, this page will remain viewable, though unformatted.","Url":"http:\\/\\/www.blueletterbible.org\\/kjv\\/Psa\\/Psa132.html","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBthzdmMwF;_ylu=X3oDMTEwdXRzN2p1BGNvbG8DdwRsA1dTMQRwb3MDMTYEc2VjA3NyBHZ0aWQD\\/SIG=126nkscdr\\/EXP=1147592336\\/**http%3a\\/\\/www.blueletterbible.org\\/kjv\\/Psa\\/Psa132.html","ModificationDate":1146985200,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBuxzdmMwF;_ylu=X3oDMTBxdWpsMnAxBGNvbG8DdwRwb3MDMTYEc2VjA3NyBHZ0aWQD\\/SIG=16nmo95in\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.blueletterbible.org\\/kjv\\/Psa\\/Psa132.html%26w=132%26d=RzXlkkaqMwDE%26icp=1%26.intl=us","Size":"40835"}},{"Title":"ADL Found Guilty Of Spying By California Court","Summary":"ADL Found Guilty Of Spying. By California Court. By Barbara Ferguson. Arab News Correspondent. 4-27-2","Url":"http:\\/\\/www.rense.com\\/general24\\/adl.htm","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBvRzdmMwF;_ylu=X3oDMTEwcm5pb3BuBGNvbG8DdwRsA1dTMQRwb3MDMTcEc2VjA3NyBHZ0aWQD\\/SIG=11qjguns4\\/EXP=1147592336\\/**http%3a\\/\\/www.rense.com\\/general24\\/adl.htm","ModificationDate":1019890800,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBwhzdmMwF;_ylu=X3oDMTBxN2RrOGV1BGNvbG8DdwRwb3MDMTcEc2VjA3NyBHZ0aWQD\\/SIG=16bnmcrht\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.rense.com\\/general24\\/adl.htm%26w=132%26d=Xkre4EaqMuwO%26icp=1%26.intl=us","Size":"5916"}},{"Title":"FindLaw for Legal Professionals - Case Law, Federal and State Resources, Forms, and Code","Summary":"FindLaw for Legal Professionals is a free resource for attorneys that includes online case law, free state codes, free federal codes, free legal forms, and a directory of products and services for lawyers. This online legal Web site also includes...","Url":"http:\\/\\/caselaw.lp.findlaw.com\\/cgi-bin\\/getcase.pl?court=US&vol=391&invol=936","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBxBzdmMwF;_ylu=X3oDMTEwa2drb20xBGNvbG8DdwRsA1dTMQRwb3MDMTgEc2VjA3NyBHZ0aWQD\\/SIG=135rsl3q8\\/EXP=1147592336\\/**http%3a\\/\\/caselaw.lp.findlaw.com\\/cgi-bin\\/getcase.pl%3fcourt=US%26vol=391%26invol=936","ModificationDate":1147330800,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcByRzdmMwF;_ylu=X3oDMTBxZGJndmNzBGNvbG8DdwRwb3MDMTgEc2VjA3NyBHZ0aWQD\\/SIG=188s7bq1v\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=caselaw.lp.findlaw.com\\/cgi-bin\\/getcase.pl%253Fcourt%253DUS%2526vol%253D391%2526invol%253D936%26w=132%26d=GCWYIUaqMwZK%26icp=1%26.intl=us","Size":"57332"}},{"Title":"Chapter 132","Summary":"... Public Records. \\u00a7 132\\u20101. \\" Public records\\" defined ... Public records, as defined in G.S. 132\\u20101, shall not include written communications (and copies thereof) to any public ...","Url":"http:\\/\\/www.ncleg.net\\/EnactedLegislation\\/Statutes\\/HTML\\/ByChapter\\/Chapter_132.html","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcByxzdmMwF;_ylu=X3oDMTEwdjV0NWw0BGNvbG8DdwRsA1dTMQRwb3MDMTkEc2VjA3NyBHZ0aWQD\\/SIG=1349nldcc\\/EXP=1147592336\\/**http%3a\\/\\/www.ncleg.net\\/EnactedLegislation\\/Statutes\\/HTML\\/ByChapter\\/Chapter_132.html","ModificationDate":1141027200,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcB0BzdmMwF;_ylu=X3oDMTBxdDJjbXM4BGNvbG8DdwRwb3MDMTkEc2VjA3NyBHZ0aWQD\\/SIG=17lgm2hmb\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.ncleg.net\\/EnactedLegislation\\/Statutes\\/HTML\\/ByChapter\\/Chapter_132.html%26w=132%26d=akl3I0aqMt5y%26icp=1%26.intl=us","Size":"76411"}},{"Title":"oremus Bible Browser : Psalm 132","Summary":"Psalm 132. A Song of Ascents. 1O Lord, remember in David\'s favour. all the hardships he endured; 2how he swore to the Lord. and vowed to the Mighty One of Jacob, 3 I will not enter my house. or get into my bed;","Url":"http:\\/\\/bible.oremus.org\\/?passage=Psalm+132","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcB0hzdmMwF;_ylu=X3oDMTEwcDU0bmdlBGNvbG8DdwRsA1dTMQRwb3MDMjAEc2VjA3NyBHZ0aWQD\\/SIG=122hghelb\\/EXP=1147592336\\/**http%3a\\/\\/bible.oremus.org\\/%3fpassage=Psalm%2b132","ModificationDate":1138003200,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcB1xzdmMwF;_ylu=X3oDMTBxbjVuNnZxBGNvbG8DdwRwb3MDMjAEc2VjA3NyBHZ0aWQD\\/SIG=16ppk73gi\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=bible.oremus.org\\/%253Fpassage%253DPsalm%2b132%26w=132%26d=MBPBT0aqMkLR%26icp=1%26.intl=us","Size":"6083"}},{"Title":"Electronic Code of Federal Regulations:","Summary":"... Application of part 132 requirements in Great Lakes States and Tribes ... Appendix A to Part 132 --Great Lakes Water Quality Initiative Methodologies for Development of Aquatic Life ...","Url":"http:\\/\\/ecfr.gpoaccess.gov\\/cgi\\/t\\/text\\/text-idx?c=ecfr&tpl=\\/ecfrbrowse\\/Title40\\/40cfr132_main_02.tpl","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcB2RzdmMwF;_ylu=X3oDMTEwMGRnbnZ2BGNvbG8DdwRsA1dTMQRwb3MDMjEEc2VjA3NyBHZ0aWQD\\/SIG=13p811gl2\\/EXP=1147592336\\/**http%3a\\/\\/ecfr.gpoaccess.gov\\/cgi\\/t\\/text\\/text-idx%3fc=ecfr%26tpl=\\/ecfrbrowse\\/Title40\\/40cfr132_main_02.tpl","ModificationDate":1147244400,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcB3hzdmMwF;_ylu=X3oDMTBxb2QzaXJsBGNvbG8DdwRwb3MDMjEEc2VjA3NyBHZ0aWQD\\/SIG=18m524f9v\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=ecfr.gpoaccess.gov\\/cgi\\/t\\/text\\/text-idx%253Fc%253Decfr%2526tpl%253D\\/ecfrbrowse\\/Title40\\/40cfr132_main_02.tpl%26w=132%26d=OC6Oa0aqMwQa%26icp=1%26.intl=us","Size":"24321"}},{"Title":"BibleGateway.com - Passage Lookup: Psalms 132;","Summary":"English (EN) Espa\\u00f1ol (ES) Passage results ... View commentary related to this passage : Psalm 132. Psalm 132 (Amplified Bible ...","Url":"http:\\/\\/www.biblegateway.com\\/passage?search=Psalms+132;&version=45;","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcB4BzdmMwF;_ylu=X3oDMTEwMmJvNjYwBGNvbG8DdwRsA1dTMQRwb3MDMjIEc2VjA3NyBHZ0aWQD\\/SIG=12s5v8a5i\\/EXP=1147592336\\/**http%3a\\/\\/www.biblegateway.com\\/passage%3fsearch=Psalms%2b132;%26version=45;","ModificationDate":1139990400,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcB5RzdmMwF;_ylu=X3oDMTBxOTdwc3RpBGNvbG8DdwRwb3MDMjIEc2VjA3NyBHZ0aWQD\\/SIG=1810cufkn\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.biblegateway.com\\/passage%253Fsearch%253DPsalms%2b132%253B%2526version%253D45%253B%26w=132%26d=KJ4R3EaqMjLm%26icp=1%26.intl=us","Size":"27611"}},{"Title":"N-132: Wu-ftpd Buffer Overflow Vulnerability","Summary":"INFORMATION BULLETIN. N-132: Wu-ftpd Buffer Overflow Vulnerability. [Red Hat Security Advisory RHSA-2003:245-15] July 31, 2003 18:00 GMT. [Revised 13 Aug 2003] [Revised 14 Aug 2003] [Revised 5 Sept 2003] [Revised 8 Oct 2003]","Url":"http:\\/\\/www.ciac.org\\/ciac\\/bulletins\\/n-132.shtml","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcB5xzdmMwF;_ylu=X3oDMTEwZXVqN2J0BGNvbG8DdwRsA1dTMQRwb3MDMjMEc2VjA3NyBHZ0aWQD\\/SIG=122msf6uh\\/EXP=1147592336\\/**http%3a\\/\\/www.ciac.org\\/ciac\\/bulletins\\/n-132.shtml","ModificationDate":1146812400,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcB7BzdmMwF;_ylu=X3oDMTBxbm8wZ2ZmBGNvbG8DdwRwb3MDMjMEc2VjA3NyBHZ0aWQD\\/SIG=16jq98ra6\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.ciac.org\\/ciac\\/bulletins\\/n-132.shtml%26w=132%26d=cBzeO0aqMu2t%26icp=1%26.intl=us","Size":"12337"}},{"Title":"Bumpy Objects","Summary":"Bumpy Objects","Url":"http:\\/\\/acm.uva.es\\/p\\/v1\\/132.html","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcB7hzdmMwF;_ylu=X3oDMTEwZmNyM2VjBGNvbG8DdwRsA1dTMQRwb3MDMjQEc2VjA3NyBHZ0aWQD\\/SIG=11j1o5t64\\/EXP=1147592336\\/**http%3a\\/\\/acm.uva.es\\/p\\/v1\\/132.html","ModificationDate":1057820400,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcB8xzdmMwF;_ylu=X3oDMTBxNWw4M3FvBGNvbG8DdwRwb3MDMjQEc2VjA3NyBHZ0aWQD\\/SIG=164vlv52k\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=acm.uva.es\\/p\\/v1\\/132.html%26w=132%26d=ZSctVkaqMvQs%26icp=1%26.intl=us","Size":"2803"}},{"Title":"The Hayes memo is important\\u2014but bogus. By Daniel Benjamin","Summary":"When they published their \\" Case Closed\\" cover story three weeks ago on the relationship between Saddam Hussein\'s Iraq and al-Qaida, the editors of the Weekly Standard aimed to set off a bomb. The article was centered on a sizable leak\\u2014a gusher...","Url":"http:\\/\\/www.slate.com\\/id\\/2092180\\/","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcB9RzdmMwF;_ylu=X3oDMTEwamxzbHY1BGNvbG8DdwRsA1dTMQRwb3MDMjUEc2VjA3NyBHZ0aWQD\\/SIG=11kj0d4q1\\/EXP=1147592336\\/**http%3a\\/\\/www.slate.com\\/id\\/2092180\\/","ModificationDate":1147071600,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcB.hzdmMwF;_ylu=X3oDMTBxdGc1MmltBGNvbG8DdwRwb3MDMjUEc2VjA3NyBHZ0aWQD\\/SIG=16507c1iu\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=slate.msn.com\\/id\\/2092180\\/%26w=132%26d=bWigBUaqMvyd%26icp=1%26.intl=us","Size":"40222"}},{"Title":"FNMOC WXMAP: North America","Summary":"UNCLASSIFIED. FNMOC WXMAP. Model: NOGAPS. Area: North America. DTG: 2006050500. UNCLASSIFIED","Url":"https:\\/\\/www.fnmoc.navy.mil\\/CGI\\/PUBLIC\\/wxmap_single.cgi?area=ngp_namer&prod=850&tau=132","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcB_BzdmMwF;_ylu=X3oDMTEwNDNwbjA5BGNvbG8DdwRsA1dTMQRwb3MDMjYEc2VjA3NyBHZ0aWQD\\/SIG=13g43sejj\\/EXP=1147592336\\/**https%3a\\/\\/www.fnmoc.navy.mil\\/CGI\\/PUBLIC\\/wxmap_single.cgi%3farea=ngp_namer%26prod=850%26tau=132","ModificationDate":1146812400,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBAR3dmMwF;_ylu=X3oDMTBxN2ZrcnVrBGNvbG8DdwRwb3MDMjYEc2VjA3NyBHZ0aWQD\\/SIG=18s7gc72v\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=https%3a\\/\\/www.fnmoc.navy.mil\\/CGI\\/PUBLIC\\/wxmap_single.cgi%253Farea%253Dngp_namer%2526prod%253D850%2526tau%253D132%26w=132%26d=KiW5fUaqMvIm%26icp=1%26.intl=us","Size":"9048"}},{"Title":"O-132: BEA WebLogic Server and Express Certificate Spoofing Vulnerability","Summary":"INFORMATION BULLETIN. O-132: BEA WebLogic Server and Express Certificate Spoofing Vulnerability. [BEA Security Advisory: BEA04-54.00] April 30, 2004 20:00 GMT. PROBLEM:","Url":"http:\\/\\/ciac.llnl.gov\\/ciac\\/bulletins\\/o-132.shtml","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBAx3dmMwF;_ylu=X3oDMTEwb2lhN21nBGNvbG8DdwRsA1dTMQRwb3MDMjcEc2VjA3NyBHZ0aWQD\\/SIG=1231gt787\\/EXP=1147592336\\/**http%3a\\/\\/ciac.llnl.gov\\/ciac\\/bulletins\\/o-132.shtml","ModificationDate":1142064000,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBCB3dmMwF;_ylu=X3oDMTBxaGVsMDBlBGNvbG8DdwRwb3MDMjcEc2VjA3NyBHZ0aWQD\\/SIG=16k4puak0\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=ciac.llnl.gov\\/ciac\\/bulletins\\/o-132.shtml%26w=132%26d=ZZgzx0aqMjzn%26icp=1%26.intl=us","Size":"10701"}},{"Title":"NET Bible\\u00ae - Psalms 132","Summary":"... Psalms 132. Psalm 1321. A song of ascents.2. 132:1 O Lord, for David\'s sake remember ...","Url":"http:\\/\\/www.bible.org\\/netbible\\/psa132.htm","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBCh3dmMwF;_ylu=X3oDMTEwYjBiNjdsBGNvbG8DdwRsA1dTMQRwb3MDMjgEc2VjA3NyBHZ0aWQD\\/SIG=11sp4034c\\/EXP=1147592336\\/**http%3a\\/\\/www.bible.org\\/netbible\\/psa132.htm","ModificationDate":1133769600,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBDx3dmMwF;_ylu=X3oDMTBxOWNtc2JjBGNvbG8DdwRwb3MDMjgEc2VjA3NyBHZ0aWQD\\/SIG=16duuokm4\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.bible.org\\/netbible\\/psa132.htm%26w=132%26d=aVzzT0aqMwNl%26icp=1%26.intl=us","Size":"6048"}},{"Title":"HoustonChronicle.com - Sports: Fran Blinebury","Summary":"06, 2006. Column archive 2002. [an error occurred while processing this directive]","Url":"http:\\/\\/www.chron.com\\/content\\/chronicle\\/sports\\/blinebury\\/home","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBER3dmMwF;_ylu=X3oDMTEwcmlvNjMyBGNvbG8DdwRsA1dTMQRwb3MDMjkEc2VjA3NyBHZ0aWQD\\/SIG=12gac009r\\/EXP=1147592336\\/**http%3a\\/\\/www.chron.com\\/content\\/chronicle\\/sports\\/blinebury\\/home","ModificationDate":1146898800,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBFh3dmMwF;_ylu=X3oDMTBxNTVsY25mBGNvbG8DdwRwb3MDMjkEc2VjA3NyBHZ0aWQD\\/SIG=171sgehbh\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.chron.com\\/content\\/chronicle\\/sports\\/blinebury\\/home%26w=132%26d=I3QMYEaqMuxa%26icp=1%26.intl=us","Size":"27335"}},{"Title":"FNMOC WXMAP: North America","Summary":"UNCLASSIFIED. FNMOC WXMAP. Model: NOGAPS. Area: North America. DTG: 2006050512. UNCLASSIFIED","Url":"https:\\/\\/www.fnmoc.navy.mil\\/CGI\\/PUBLIC\\/wxmap_single.cgi?area=ngp_namer&prod=prp&tau=132","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBGB3dmMwF;_ylu=X3oDMTEwN2g4ZWdqBGNvbG8DdwRsA1dTMQRwb3MDMzAEc2VjA3NyBHZ0aWQD\\/SIG=13g08kode\\/EXP=1147592336\\/**https%3a\\/\\/www.fnmoc.navy.mil\\/CGI\\/PUBLIC\\/wxmap_single.cgi%3farea=ngp_namer%26prod=prp%26tau=132","ModificationDate":1146812400,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBHR3dmMwF;_ylu=X3oDMTBxaGdhODhjBGNvbG8DdwRwb3MDMzAEc2VjA3NyBHZ0aWQD\\/SIG=18solhmco\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=https%3a\\/\\/www.fnmoc.navy.mil\\/CGI\\/PUBLIC\\/wxmap_single.cgi%253Farea%253Dngp_namer%2526prod%253Dprp%2526tau%253D132%26w=132%26d=MKdCgkaqMuri%26icp=1%26.intl=us","Size":"9048"}},{"Title":"US CODE: Title 36,132. National School Lunch Week","Summary":"National School Lunch Week. Release date: 2005-10-11. (a) Designation.\\u2014. The week beginning on the second Sunday in October is National School Lunch Week. (b) Proclamation.\\u2014 ... TITLE 36 &gt; Subtitle I &gt; Part A &gt; CHAPTER 1 &gt; \\u00a7 132. Prev | Next. \\u00a7 132. National School Lunch Week ...","Url":"http:\\/\\/www4.law.cornell.edu\\/uscode\\/html\\/uscode36\\/usc_sec_36_00000132----000-.html","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBHx3dmMwF;_ylu=X3oDMTEwN3BsMm9vBGNvbG8DdwRsA1dTMQRwb3MDMzEEc2VjA3NyBHZ0aWQD\\/SIG=1359dp76s\\/EXP=1147592336\\/**http%3a\\/\\/www4.law.cornell.edu\\/uscode\\/html\\/uscode36\\/usc_sec_36_00000132----000-.html","ModificationDate":1145343600,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBJB3dmMwF;_ylu=X3oDMTBxNG81cnMxBGNvbG8DdwRwb3MDMzEEc2VjA3NyBHZ0aWQD\\/SIG=17m1he9ur\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www4.law.cornell.edu\\/uscode\\/html\\/uscode36\\/usc_sec_36_00000132----000-.html%26w=132%26d=NTi8bUaqMpvs%26icp=1%26.intl=us","Size":"8976"}},{"Title":"ATel #132: IGR J17464-3213","Summary":"Outside. Other. Present Time: 7 May 2006; 4:08 UT. RSS. XML Gamma Ray Bursts. IGR J17464-3213 ... IGR J17464-3213. ATel #132; M. Revnivtsev (IKI, Moscow; MPA, Garching), M ... XTE J1746-322 = IGR J17464-3213 = H1743-322. 132. IGR J17464-3213 ...","Url":"http:\\/\\/www.astronomerstelegram.org\\/?read=132","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBJh3dmMwF;_ylu=X3oDMTEwYWI0N2o2BGNvbG8DdwRsA1dTMQRwb3MDMzIEc2VjA3NyBHZ0aWQD\\/SIG=122qvcsd1\\/EXP=1147592336\\/**http%3a\\/\\/www.astronomerstelegram.org\\/%3fread=132","ModificationDate":1146985200,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBKx3dmMwF;_ylu=X3oDMTBxYmt2ZDZzBGNvbG8DdwRwb3MDMzIEc2VjA3NyBHZ0aWQD\\/SIG=16pipao89\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.astronomerstelegram.org\\/%253Fread%253D132%26w=132%26d=Pb4lcUaqMvBj%26icp=1%26.intl=us","Size":"9056"}},{"Title":"Vashegyite Mineral Data","Summary":"Vashegyite Mineral Data + General Vashegyite Information. Chemical Formula: Al11(PO4)9(OH)6\\u00b738(H2O) or Al6(PO4)5(OH)3\\u00b723(H2O) Composition: Molecular Weight = 1,938.16 gm. Aluminum 15.31 % Al 28.93 % Al2O3","Url":"http:\\/\\/www.webmineral.com\\/data\\/Vashegyite.shtml","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBLR3dmMwF;_ylu=X3oDMTEwNHFvMGppBGNvbG8DdwRsA1dTMQRwb3MDMzMEc2VjA3NyBHZ0aWQD\\/SIG=123ajp144\\/EXP=1147592336\\/**http%3a\\/\\/www.webmineral.com\\/data\\/Vashegyite.shtml","ModificationDate":1146898800,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBMh3dmMwF;_ylu=X3oDMTBxNzAwNWY0BGNvbG8DdwRwb3MDMzMEc2VjA3NyBHZ0aWQD\\/SIG=16ktl9ibf\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.webmineral.com\\/data\\/Vashegyite.shtml%26w=132%26d=W38GQkaqMvCt%26icp=1%26.intl=us","Size":"29234"}},{"Title":"2003 CFR Title 40, Volume 19","Summary":"... CHAPTER I--ENVIRONMENTAL PROTECTION AGENCY. PART 132--WATER QUALITY GUIDANCE FOR THE GREAT LAKES SYSTEM. 132.1. Scope, purpose, and availability of documents ...","Url":"http:\\/\\/www.access.gpo.gov\\/nara\\/cfr\\/waisidx_03\\/40cfr132_03.html","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBNB3dmMwF;_ylu=X3oDMTEwdHZ0ZXZxBGNvbG8DdwRsA1dTMQRwb3MDMzQEc2VjA3NyBHZ0aWQD\\/SIG=12imj9jh5\\/EXP=1147592336\\/**http%3a\\/\\/www.access.gpo.gov\\/nara\\/cfr\\/waisidx_03\\/40cfr132_03.html","ModificationDate":1123916400,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBOR3dmMwF;_ylu=X3oDMTBxcml1MjI5BGNvbG8DdwRwb3MDMzQEc2VjA3NyBHZ0aWQD\\/SIG=173ahs683\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.access.gpo.gov\\/nara\\/cfr\\/waisidx_03\\/40cfr132_03.html%26w=132%26d=c8h16UaqMjB2%26icp=1%26.intl=us","Size":"4704"}},{"Title":"Chapter HFS 132","Summary":"... 145. HFS 132.13. DEPARTMENT OF HEALTH AND FAMILY SERVICES ... Subchapter I \\u2014 General. HFS 132.11. Statutory authority. HFS 132.12 ...","Url":"http:\\/\\/www.legis.state.wi.us\\/rsb\\/code\\/hfs\\/hfs132.pdf","ClickUrl":"http:\\/\\/www.legis.state.wi.us\\/rsb\\/code\\/hfs\\/hfs132.pdf#search=\'\'","ModificationDate":1099033200,"MimeType":"application\\/pdf","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBPh3dmMwF;_ylu=X3oDMTBxaXI5cmVpBGNvbG8DdwRwb3MDMzUEc2VjA3NyBHZ0aWQD\\/SIG=16p8cmh99\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.legis.state.wi.us\\/rsb\\/code\\/hfs\\/hfs132.pdf%26w=132%26d=CN-yI0aqMkhi%26icp=1%26.intl=us","Size":"283151"}},{"Title":"U.S. Senate: Legislation & Records Home &gt; Votes &gt; Roll Call Vote","Summary":"... Vote Number: 132. Vote Date: June 8, 2005, 05:30 PM ...","Url":"http:\\/\\/www.senate.gov\\/legislative\\/LIS\\/roll_call_lists\\/roll_call_vote_cfm.cfm?congress=109&session=1&vote=00132","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBQB3dmMwF;_ylu=X3oDMTEwdTlzNmU2BGNvbG8DdwRsA1dTMQRwb3MDMzYEc2VjA3NyBHZ0aWQD\\/SIG=148g3pmm4\\/EXP=1147592336\\/**http%3a\\/\\/www.senate.gov\\/legislative\\/LIS\\/roll_call_lists\\/roll_call_vote_cfm.cfm%3fcongress=109%26session=1%26vote=00132","ModificationDate":1143360000,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBRR3dmMwF;_ylu=X3oDMTBxOTlsaWYxBGNvbG8DdwRwb3MDMzYEc2VjA3NyBHZ0aWQD\\/SIG=19b3rasjc\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.senate.gov\\/legislative\\/LIS\\/roll_call_lists\\/roll_call_vote_cfm.cfm%253Fcongress%253D109%2526session%253D1%2526vote%253D00132%26w=132%26d=dtev60aqMh1g%26icp=1%26.intl=us","Size":"51433"}},{"Title":"Storm Prediction Center Tornado Watch 132","Summary":"Severe weather, tornado, thunderstorm, fire weather, storm report, tornado watch, severe thunderstorm watch, mesoscale discussion, convective outlook products from the Storm Prediction Center. ... SEL2 URGENT - IMMEDIATE BROADCAST REQUESTED TORNADO WATCH NUMBER 132 NWS STORM PREDICTION CENTER NORMAN OK 325 PM CDT ...","Url":"http:\\/\\/www.spc.noaa.gov\\/products\\/watch\\/ww0132.html","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBRx3dmMwF;_ylu=X3oDMTEwanQ3MzU2BGNvbG8DdwRsA1dTMQRwb3MDMzcEc2VjA3NyBHZ0aWQD\\/SIG=126urlun7\\/EXP=1147592336\\/**http%3a\\/\\/www.spc.noaa.gov\\/products\\/watch\\/ww0132.html","ModificationDate":1146812400,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBTB3dmMwF;_ylu=X3oDMTBxNDRkc3R1BGNvbG8DdwRwb3MDMzcEc2VjA3NyBHZ0aWQD\\/SIG=16n3e4s74\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.spc.noaa.gov\\/products\\/watch\\/ww0132.html%26w=132%26d=N4g-pUaqMusz%26icp=1%26.intl=us","Size":"19990"}},{"Title":"PLANT PHYSIOLOGY ONLINE -- Table of Contents (132 [2])","Summary":"To see an article, click its [Full Text] link. To review many abstracts, check the boxes to the left of the titles you want, and click the \'Get All Checked Abstract(s)\' button. To see one abstract at a time, click its [Abstract] link.","Url":"http:\\/\\/www.plantphysiol.org\\/content\\/vol132\\/issue2\\/index.shtml","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBTh3dmMwF;_ylu=X3oDMTEwa2NtaWpsBGNvbG8DdwRsA1dTMQRwb3MDMzgEc2VjA3NyBHZ0aWQD\\/SIG=12hg0jpkp\\/EXP=1147592336\\/**http%3a\\/\\/www.plantphysiol.org\\/content\\/vol132\\/issue2\\/index.shtml","ModificationDate":1141804800,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBUx3dmMwF;_ylu=X3oDMTBxYnZvM21yBGNvbG8DdwRwb3MDMzgEc2VjA3NyBHZ0aWQD\\/SIG=172cps28k\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.plantphysiol.org\\/content\\/vol132\\/issue2\\/index.shtml%26w=132%26d=Yvs4KUaqMjZc%26icp=1%26.intl=us","Size":"79038"}},{"Title":"AgGPS 132","Summary":"... The AgGPS 132 outputs sub- meter accuracy DGPS positions ... lightbar is connected to the. AgGPS 132. The AgGPS 132. can output positions up to 10 ...","Url":"http:\\/\\/www.farmgis.com\\/products\\/hardware\\/gps\\/aggps132.pdf","ClickUrl":"http:\\/\\/www.farmgis.com\\/products\\/hardware\\/gps\\/aggps132.pdf#search=\'\'","ModificationDate":1098169200,"MimeType":"application\\/pdf","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBWB3dmMwF;_ylu=X3oDMTBxcXNibWtvBGNvbG8DdwRwb3MDMzkEc2VjA3NyBHZ0aWQD\\/SIG=16us46bp9\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.farmgis.com\\/products\\/hardware\\/gps\\/aggps132.pdf%26w=132%26d=EvLM70aqMkiV%26icp=1%26.intl=us","Size":"162160"}},{"Title":"Chapter 132 \\u2014 Grand Jury, Indictments and Other Accusatory Instruments","Summary":"The text appearing in this database was produced from material provided by the Legislative Counsel Committee of the Oregon Legislative Assembly. The official record copy is the printed published copy of the Oregon Revised Statutes. ... 132.010 Composition. A grand jury is a body of seven persons drawn from the jurors in attendance ... 132.030 Challenge of juror prohibited; when juror may be excused. Neither ...","Url":"http:\\/\\/www.leg.state.or.us\\/ors\\/132.html","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBWh3dmMwF;_ylu=X3oDMTEwYTAzbTUxBGNvbG8DdwRsA1dTMQRwb3MDNDAEc2VjA3NyBHZ0aWQD\\/SIG=11r91jes0\\/EXP=1147592336\\/**http%3a\\/\\/www.leg.state.or.us\\/ors\\/132.html","ModificationDate":1144220400,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBXx3dmMwF;_ylu=X3oDMTBxdGU5a2FhBGNvbG8DdwRwb3MDNDAEc2VjA3NyBHZ0aWQD\\/SIG=16cbqvrlb\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.leg.state.or.us\\/ors\\/132.html%26w=132%26d=MFh3EUaqMk41%26icp=1%26.intl=us","Size":"73717"}},{"Title":"Downloaded 19 Aug 2002 to 132.163.136.56. Redistribution subject to AIP license or copyright, see http:\\/\\/ojps.aip... ","Summary":"Downloaded 19 Aug 2002 to 132.163.136.56. Redistribution subject to AIP license or copyright, see http:\\/\\/ojps.aip.org\\/japo\\/japcr.jsp. Downloaded 19 Aug 2002 to 132.163.136.56.","Url":"http:\\/\\/tf.nist.gov\\/general\\/pdf\\/550.pdf","ClickUrl":"http:\\/\\/tf.nist.gov\\/general\\/pdf\\/550.pdf#search=\'\'","ModificationDate":1029740400,"MimeType":"application\\/pdf","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBZB3dmMwF;_ylu=X3oDMTBxcDdtZjJoBGNvbG8DdwRwb3MDNDEEc2VjA3NyBHZ0aWQD\\/SIG=16bgqks5e\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=tf.nist.gov\\/general\\/pdf\\/550.pdf%26w=132%26d=PNXPXkaqMkLS%26icp=1%26.intl=us","Size":"2485625"}},{"Title":"Father Tom Inspired Pflugerville #132 To Evolve Into A Strong Fraternal Society","Summary":"... Monsignor Tom Frank is presented with the 2002 Society #132. Service Award by President Ray Pokorney ... ach year Society #132. of Pflugerville honors ...","Url":"http:\\/\\/www.kjtnet.org\\/web\\/benefits\\/newsletter\\/march03.pdf","ClickUrl":"http:\\/\\/www.kjtnet.org\\/web\\/benefits\\/newsletter\\/march03.pdf#search=\'\'","ModificationDate":1105603200,"MimeType":"application\\/pdf","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBaR3dmMwF;_ylu=X3oDMTBxMWU2b2h1BGNvbG8DdwRwb3MDNDIEc2VjA3NyBHZ0aWQD\\/SIG=16u12rqgg\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.kjtnet.org\\/web\\/benefits\\/newsletter\\/march03.pdf%26w=132%26d=fjH4hEaqMwZd%26icp=1%26.intl=us","Size":"2791412"}},{"Title":"Alsakharovite-Zn Mineral Data","Summary":"Alsakharovite-Zn Mineral Data. [Log In] [Current Auction] [Register to Bid] [FAQ] [About Us] Tired of Ebay rip-offs, scams, and dishonest people?","Url":"http:\\/\\/www.webmineral.com\\/data\\/Alsakharovite-Zn.shtml","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBax3dmMwF;_ylu=X3oDMTEwN2JwMzlhBGNvbG8DdwRsA1dTMQRwb3MDNDMEc2VjA3NyBHZ0aWQD\\/SIG=129j54b3c\\/EXP=1147592336\\/**http%3a\\/\\/www.webmineral.com\\/data\\/Alsakharovite-Zn.shtml","ModificationDate":1147158000,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBcB3dmMwF;_ylu=X3oDMTBxamhmc2lnBGNvbG8DdwRwb3MDNDMEc2VjA3NyBHZ0aWQD\\/SIG=16q6pnttb\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.webmineral.com\\/data\\/Alsakharovite-Zn.shtml%26w=132%26d=B_smj0aqMwJU%26icp=1%26.intl=us","Size":"38594"}},{"Title":"Psalm 132","Summary":"... Psalm 132. The Eternal Dwelling of God in Zion ...","Url":"http:\\/\\/www.hope.edu\\/academic\\/religion\\/bandstra\\/BIBLE\\/PSA\\/PSA132.HTM","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBch3dmMwF;_ylu=X3oDMTEwdXE2dm1tBGNvbG8DdwRsA1dTMQRwb3MDNDQEc2VjA3NyBHZ0aWQD\\/SIG=12n448u4t\\/EXP=1147592336\\/**http%3a\\/\\/www.hope.edu\\/academic\\/religion\\/bandstra\\/BIBLE\\/PSA\\/PSA132.HTM","ModificationDate":1114758000,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBdx3dmMwF;_ylu=X3oDMTBxMjBjZXRuBGNvbG8DdwRwb3MDNDQEc2VjA3NyBHZ0aWQD\\/SIG=17829d5da\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.hope.edu\\/academic\\/religion\\/bandstra\\/BIBLE\\/PSA\\/PSA132.HTM%26w=132%26d=Gs9Yt0aqMhg_%26icp=1%26.intl=us","Size":"5137"}},{"Title":"Bug 132 - Heartbeat requires all nodes to be pre-configured in ha.cf","Summary":"... Bugzilla Bug 132. Heartbeat requires all nodes to be pre-configured in ha.cf ... Bug#: 132. Platform: All DEC HP Macintosh PC SGI Sun Other ...","Url":"http:\\/\\/www.osdl.org\\/developer_bugzilla\\/show_bug.cgi?id=132","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBeR3dmMwF;_ylu=X3oDMTEwa3QxajIyBGNvbG8DdwRsA1dTMQRwb3MDNDUEc2VjA3NyBHZ0aWQD\\/SIG=12g1vvd06\\/EXP=1147592336\\/**http%3a\\/\\/www.osdl.org\\/developer_bugzilla\\/show_bug.cgi%3fid=132","ModificationDate":1146553200,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBfh3dmMwF;_ylu=X3oDMTBxbHY2NGw5BGNvbG8DdwRwb3MDNDUEc2VjA3NyBHZ0aWQD\\/SIG=177hj2go7\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.osdl.org\\/developer_bugzilla\\/show_bug.cgi%253Fid%253D132%26w=132%26d=Uzd0n0aqMtwg%26icp=1%26.intl=us","Size":"40101"}},{"Title":"Bug 132 - ChargeDispositionPlea and ChargeDispositionVerdict","Summary":"... Bugzilla Bug 132. ChargeDispositionPlea and ChargeDispositionVerdict ... Bug#: 132. Domain: AAMVA Corrections Courts Juvenile Law Enforcement Parole Probation Prosecution Other ...","Url":"http:\\/\\/justicexml.gtri.gatech.edu\\/feedback\\/show_bug.cgi?id=132","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBgB3dmMwF;_ylu=X3oDMTEwdmhtYjA4BGNvbG8DdwRsA1dTMQRwb3MDNDYEc2VjA3NyBHZ0aWQD\\/SIG=12klknku3\\/EXP=1147592336\\/**http%3a\\/\\/justicexml.gtri.gatech.edu\\/feedback\\/show_bug.cgi%3fid=132","ModificationDate":1143360000,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBhR3dmMwF;_ylu=X3oDMTBxa2g2bWNnBGNvbG8DdwRwb3MDNDYEc2VjA3NyBHZ0aWQD\\/SIG=17bcs6mrt\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=justicexml.gtri.gatech.edu\\/feedback\\/show_bug.cgi%253Fid%253D132%26w=132%26d=e0Zoy0aqMjBn%26icp=1%26.intl=us","Size":"16410"}},{"Title":"Publications","Summary":"... Bulletin 132, Management of the California State Water Project, is a series of annual reports that describe the ... annual Appendix E to Bulletin 132 and the final edition of the ...","Url":"http:\\/\\/www.swpao.water.ca.gov\\/publications","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBhx3dmMwF;_ylu=X3oDMTEwZjVhYXMzBGNvbG8DdwRsA1dTMQRwb3MDNDcEc2VjA3NyBHZ0aWQD\\/SIG=11ud1cv0a\\/EXP=1147592336\\/**http%3a\\/\\/www.swpao.water.ca.gov\\/publications","ModificationDate":1143187200,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBjB3dmMwF;_ylu=X3oDMTBxcjNocmY0BGNvbG8DdwRwb3MDNDcEc2VjA3NyBHZ0aWQD\\/SIG=16fvue890\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.swpao.water.ca.gov\\/publications%26w=132%26d=CDqKvkaqMhfi%26icp=1%26.intl=us","Size":"27835"}},{"Title":"Sampling at Head Crater and Bench Crater","Summary":"... 132:10:41 Bean: Boy, this Hand Tool Carrier is light and nice compared to carrying it around ... 132:11:20 Bean: I can see everything from fine-grain basalt ...","Url":"http:\\/\\/www.hq.nasa.gov\\/alsj\\/a12\\/a12.head_bench.html","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBjh3dmMwF;_ylu=X3oDMTEwYjFmcHI4BGNvbG8DdwRsA1dTMQRwb3MDNDgEc2VjA3NyBHZ0aWQD\\/SIG=127h6jrgp\\/EXP=1147592336\\/**http%3a\\/\\/www.hq.nasa.gov\\/alsj\\/a12\\/a12.head_bench.html","ModificationDate":1139731200,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBkx3dmMwF;_ylu=X3oDMTBxazBuMTN2BGNvbG8DdwRwb3MDNDgEc2VjA3NyBHZ0aWQD\\/SIG=16of05gsq\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.hq.nasa.gov\\/alsj\\/a12\\/a12.head_bench.html%26w=132%26d=O2JTbEaqMul1%26icp=1%26.intl=us","Size":"91895"}},{"Title":"Psalms 132","Summary":"Psalms 132. 132:1 A Song of degrees.","Url":"http:\\/\\/www.masterstech-home.com\\/The_Library\\/The_Bible\\/Bible_Chapters\\/Psalms\\/132.html","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBlR3dmMwF;_ylu=X3oDMTEwOG85MWM5BGNvbG8DdwRsA1dTMQRwb3MDNDkEc2VjA3NyBHZ0aWQD\\/SIG=1381oeor0\\/EXP=1147592336\\/**http%3a\\/\\/www.masterstech-home.com\\/The_Library\\/The_Bible\\/Bible_Chapters\\/Psalms\\/132.html","ModificationDate":1135152000,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBmh3dmMwF;_ylu=X3oDMTBxNWpuM3FoBGNvbG8DdwRwb3MDNDkEc2VjA3NyBHZ0aWQD\\/SIG=17p7bjs0u\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.masterstech-home.com\\/The_Library\\/The_Bible\\/Bible_Chapters\\/Psalms\\/132.html%26w=132%26d=TUYYg0aqMhg4%26icp=1%26.intl=us","Size":"11669"}},{"Title":"California Highways (www.cahighways.org): Routes 129 through 136","Summary":"... The 2005 Transportation Bill included \$14.4 million to widen Route 132 from Route 99 west to Dakota Avenue ... between Coulterville and Mariposa was cosigned as Route 49 and Route 132 ...","Url":"http:\\/\\/www.cahighways.org\\/129-136.html","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBnB3dmMwF;_ylu=X3oDMTEwaXBqZ2lxBGNvbG8DdwRsA1dTMQRwb3MDNTAEc2VjA3NyBHZ0aWQD\\/SIG=11q1ne7f6\\/EXP=1147592336\\/**http%3a\\/\\/www.cahighways.org\\/129-136.html","ModificationDate":1145689200,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBoR3dmMwF;_ylu=X3oDMTBxbmZjMXVuBGNvbG8DdwRwb3MDNTAEc2VjA3NyBHZ0aWQD\\/SIG=16bhah065\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.cahighways.org\\/129-136.html%26w=132%26d=fRBtE0aqMqve%26icp=1%26.intl=us","Size":"49110"}},{"Title":"Downloaded 11 Nov 2002 to 132.64.1.37. Redistribution subject to AIP license or copyright, see http:\\/\\/ojps.aip.org\\/... ","Summary":"Downloaded 11 Nov 2002 to 132.64.1.37. Redistribution subject to AIP license or copyright, see http:\\/\\/ojps.aip.org\\/rsio\\/rsicr.jsp. Downloaded 11 Nov 2002 to 132.64.1.37.","Url":"http:\\/\\/chem.ch.huji.ac.il\\/~porath\\/NST2\\/Lecture%205\\/Kuk%20and%20Silverman%20Rev_Sci_Inst_60_165_1989.pdf","ClickUrl":"http:\\/\\/chem.ch.huji.ac.il\\/~porath\\/NST2\\/Lecture%205\\/Kuk%20and%20Silverman%20Rev_Sci_Inst_60_165_1989.pdf#search=\'\'","ModificationDate":1069660800,"MimeType":"application\\/pdf","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBph3dmMwF;_ylu=X3oDMTBxZHJldXUyBGNvbG8DdwRwb3MDNTEEc2VjA3NyBHZ0aWQD\\/SIG=190pnnu1n\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=chem.ch.huji.ac.il\\/%257Eporath\\/NST2\\/Lecture%2525205\\/Kuk%252520and%252520Silverman%252520Rev_Sci_Inst_60_165_1989.pdf%26w=132%26d=F4c-T0aqMhfn%26icp=1%26.intl=us","Size":"3386219"}},{"Title":"Phelps Personnel Associates","Summary":"Welcome to Phelps Personnel Associates. Recruiting and Placing Engineers and Management Professionals since 1976. Concentration in the Carolinas and Southeastern job market. Permanent, Company fee-paid positions only. Confidential, courteous service","Url":"http:\\/\\/www.phelpspersonnel.com\\/","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBqB3dmMwF;_ylu=X3oDMTEwazlldjdwBGNvbG8DdwRsA1dTMQRwb3MDNTIEc2VjA3NyBHZ0aWQD\\/SIG=11j85rkug\\/EXP=1147592336\\/**http%3a\\/\\/www.phelpspersonnel.com\\/","ModificationDate":1060239600,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBrR3dmMwF;_ylu=X3oDMTBxZWJqMW1lBGNvbG8DdwRwb3MDNTIEc2VjA3NyBHZ0aWQD\\/SIG=164jn86me\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.phelpspersonnel.com\\/%26w=132%26d=KRPdjUaqMwQa%26icp=1%26.intl=us","Size":"6288"}},{"Title":"132 - Loss and resumption of Australian citizenship - Declaration of desre to resume Australian citizenship under ... ","Summary":"... retain another citizenship \\u0096 be under the age of 25 years. 132 (Design date 0705) - Page 1 ... 23A, 23AA, 23AB or 23B. 132 (Design date 0705) - Page 2 ...","Url":"http:\\/\\/www.immi.gov.au\\/allforms\\/pdf\\/132.pdf","ClickUrl":"http:\\/\\/www.immi.gov.au\\/allforms\\/pdf\\/132.pdf#search=\'\'","ModificationDate":1141113600,"MimeType":"application\\/pdf","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBsh3dmMwF;_ylu=X3oDMTBxYzdmNTNvBGNvbG8DdwRwb3MDNTMEc2VjA3NyBHZ0aWQD\\/SIG=16gtd8vkd\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.immi.gov.au\\/allforms\\/pdf\\/132.pdf%26w=132%26d=XLvxbUaqMvqk%26icp=1%26.intl=us","Size":"118238"}},{"Title":"Communication Workersof America Local 3808","Summary":"News Highlights and Headlines. Nominations for one (1) 402 Franklin Road Area Representative will be taken at the June 6, 2006 Membership Meeting. BellSouth CONTRACT INFO. Frequently asked Q&A","Url":"http:\\/\\/cwa3808.org\\/","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBtB3dmMwF;_ylu=X3oDMTEwMGJ0MmQ1BGNvbG8DdwRsA1dTMQRwb3MDNTQEc2VjA3NyBHZ0aWQD\\/SIG=117pqud0l\\/EXP=1147592336\\/**http%3a\\/\\/cwa3808.org\\/","ModificationDate":1147071600,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBuR3dmMwF;_ylu=X3oDMTBxY3NiaDkyBGNvbG8DdwRwb3MDNTQEc2VjA3NyBHZ0aWQD\\/SIG=15od3j3p8\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=cwa3808.org\\/%26w=132%26d=ahqtKEaqMwC6%26icp=1%26.intl=us","Size":"53103"}},{"Title":"Mirabilis ICQ 98a Vulnerability","Summary":"... Bugtraq ID: 132. Class: Failure to Handle Exceptional Conditions ...","Url":"http:\\/\\/www.securityfocus.com\\/bid\\/132","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBux3dmMwF;_ylu=X3oDMTEwNXIwZzI2BGNvbG8DdwRsA1dTMQRwb3MDNTUEc2VjA3NyBHZ0aWQD\\/SIG=11ocj9p23\\/EXP=1147592336\\/**http%3a\\/\\/www.securityfocus.com\\/bid\\/132","ModificationDate":1146034800,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBwB3dmMwF;_ylu=X3oDMTBxbnNnYWFhBGNvbG8DdwRwb3MDNTUEc2VjA3NyBHZ0aWQD\\/SIG=169dn3s31\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.securityfocus.com\\/bid\\/132%26w=132%26d=bbuQiUaqMsU1%26icp=1%26.intl=us","Size":"11819"}},{"Title":"Downloaded 23 Dec 2001 to 132.76.33.15. Redistribution subject to AIP license or copyright, see http:\\/\\/ojps.aip.org\\/... ","Summary":"Downloaded 23 Dec 2001 to 132.76.33.15. Redistribution subject to AIP license or copyright, see http:\\/\\/ojps.aip.org\\/jcpo\\/jcpcr.jsp. Downloaded 23 Dec 2001 to 132.76.33.15.","Url":"http:\\/\\/theochem.weizmann.ac.il\\/AIPreprints\\/8.pdf","ClickUrl":"http:\\/\\/theochem.weizmann.ac.il\\/AIPreprints\\/8.pdf#search=\'\'","ModificationDate":1092294000,"MimeType":"application\\/pdf","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBxR3dmMwF;_ylu=X3oDMTBxcjhpcTNrBGNvbG8DdwRwb3MDNTYEc2VjA3NyBHZ0aWQD\\/SIG=16l1r1fiu\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=theochem.weizmann.ac.il\\/AIPreprints\\/8.pdf%26w=132%26d=VrF160aqMjIt%26icp=1%26.intl=us","Size":"1754089"}},{"Title":"Chapter RL 132","Summary":"DEPARTMENT OF REGULATION AND LICENSING. Unofficial Text (See Printed Volume). Current through date and Register shown on Title Page. Register, July, 1999, No. 523. Chapter RL 132. APPLICATIONS. RL 132.01. Authority. RL 132.02 ... Note: Chapter RL 132 was created as an emergency rule effective 11\\u20131\\u201398 ...","Url":"http:\\/\\/www.legis.state.wi.us\\/rsb\\/code\\/rl\\/rl132.pdf","ClickUrl":"http:\\/\\/www.legis.state.wi.us\\/rsb\\/code\\/rl\\/rl132.pdf#search=\'\'","ModificationDate":1011859200,"MimeType":"application\\/pdf","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcByh3dmMwF;_ylu=X3oDMTBxZjI4aHZhBGNvbG8DdwRwb3MDNTcEc2VjA3NyBHZ0aWQD\\/SIG=16nps3tc2\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.legis.state.wi.us\\/rsb\\/code\\/rl\\/rl132.pdf%26w=132%26d=VTECeUaqMi-4%26icp=1%26.intl=us","Size":"8138"}},{"Title":"Rebuffing Bush, 132 Mayors Embrace Kyoto Rules - New York Times","Summary":"Greg Nickels of Seattle and 131 other like-minded mayors have joined a bipartisan coalition to fight global warming on the local level.","Url":"http:\\/\\/www.nytimes.com\\/2005\\/05\\/14\\/national\\/14kyoto.html?ex=1273723200&en=c02e1cce1ca43706&ei=5088","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBzB3dmMwF;_ylu=X3oDMTEwbm43bzM3BGNvbG8DdwRsA1dTMQRwb3MDNTgEc2VjA3NyBHZ0aWQD\\/SIG=13repbe72\\/EXP=1147592336\\/**http%3a\\/\\/www.nytimes.com\\/2005\\/05\\/14\\/national\\/14kyoto.html%3fex=1273723200%26en=c02e1cce1ca43706%26ei=5088","ModificationDate":1147330800,"MimeType":"text\\/html"},{"Title":"DHS-Revised Rule 132","Summary":"Easy access to Illinois services and information ... an e-mail address to pose questions regarding Rule 132. Please review the Rule 132 Q&A document posted on ...","Url":"http:\\/\\/www.dhs.state.il.us\\/revisedRule132","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcB0h3dmMwF;_ylu=X3oDMTEwMjl1dW84BGNvbG8DdwRsA1dTMQRwb3MDNTkEc2VjA3NyBHZ0aWQD\\/SIG=11tb4gcma\\/EXP=1147592336\\/**http%3a\\/\\/www.dhs.state.il.us\\/revisedRule132","ModificationDate":1147244400,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcB1x3dmMwF;_ylu=X3oDMTBxOWMyazRxBGNvbG8DdwRwb3MDNTkEc2VjA3NyBHZ0aWQD\\/SIG=16e8khp3d\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.dhs.state.il.us\\/revisedRule132%26w=132%26d=Oc4YikaqMwgM%26icp=1%26.intl=us","Size":"22903"}},{"Title":"211 CMR: DIVISION OF INSURANCE 6\\/27\\/97 211 CMR - 837 211 CMR 132.00: ACTUARIAL OPINION AND MEMORANDUM REGULATION ... ","Summary":"... 132.01: Purpose. 132.02: Authority. 132.03: Scope. 132.04: Definitions. 132.05: General Requirements. 132.06: Required Opinions. 132 ... Adequacy Analysis. 132.08: Statement of Actuarial ...","Url":"http:\\/\\/www.mass.gov\\/doi\\/Legal_Hearings\\/211_132.PDF","ClickUrl":"http:\\/\\/www.mass.gov\\/doi\\/Legal_Hearings\\/211_132.PDF#search=\'\'","ModificationDate":1003906800,"MimeType":"application\\/pdf","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcB3B3dmMwF;_ylu=X3oDMTBxdG9ldThsBGNvbG8DdwRwb3MDNjAEc2VjA3NyBHZ0aWQD\\/SIG=16no3ibvg\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.mass.gov\\/doi\\/Legal_Hearings\\/211_132.PDF%26w=132%26d=C4QXPkaqMjRM%26icp=1%26.intl=us","Size":"45945"}},{"Title":"Downloaded 22 Jul 2003 to 132.66.16.23. Redistribution subject to AIP license or copyright, see http:\\/\\/ojps.aip.org\\/... ","Summary":"Downloaded 22 Jul 2003 to 132.66.16.23. Redistribution subject to AIP license or copyright, see http:\\/\\/ojps.aip.org\\/jcpo\\/jcpcr.jsp. Downloaded 22 Jul 2003 to 132.66.16.23.","Url":"http:\\/\\/star.tau.ac.il\\/~andelman\\/reprints\\/021_JCP_1987_87_7229.pdf","ClickUrl":"http:\\/\\/star.tau.ac.il\\/~andelman\\/reprints\\/021_JCP_1987_87_7229.pdf#search=\'\'","ModificationDate":1058857200,"MimeType":"application\\/pdf","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcB4R3dmMwF;_ylu=X3oDMTBxZzZxbDZiBGNvbG8DdwRwb3MDNjEEc2VjA3NyBHZ0aWQD\\/SIG=17adesqgt\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=star.tau.ac.il\\/%257Eandelman\\/reprints\\/021_JCP_1987_87_7229.pdf%26w=132%26d=Lvkyh0aqMh8L%26icp=1%26.intl=us","Size":"1798906"}},{"Title":"Special Troops Battalion, 4th Brigade, 10th Mountain Division Insignia","Summary":"The Institute of Heraldry\'s Special Troops Battalion Section, Special Troops Battalion, 4th Brigade, 10th Mountain Division Insignia Page","Url":"http:\\/\\/www.tioh.hqda.pentagon.mil\\/STB\\/STB4Brigade10MountainDivision.htm","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcB4x3dmMwF;_ylu=X3oDMTEwZjFqOHFiBGNvbG8DdwRsA1dTMQRwb3MDNjIEc2VjA3NyBHZ0aWQD\\/SIG=12rjb6bu4\\/EXP=1147592336\\/**http%3a\\/\\/www.tioh.hqda.pentagon.mil\\/STB\\/STB4Brigade10MountainDivision.htm","ModificationDate":1109923200,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcB6B3dmMwF;_ylu=X3oDMTBxZzN1cnRoBGNvbG8DdwRwb3MDNjIEc2VjA3NyBHZ0aWQD\\/SIG=17c61sq2b\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.tioh.hqda.pentagon.mil\\/STB\\/STB4Brigade10MountainDivision.htm%26w=132%26d=CjDx1kaqMwEn%26icp=1%26.intl=us","Size":"8896"}},{"Title":"NNSA\'s Brooks lauds partnership in nonproliferation","Summary":"... ite Way. U133. 132. A-4. 135. 134. 132. Fun With Science ...","Url":"http:\\/\\/www.llnl.gov\\/llnl\\/06news\\/employee\\/articles\\/2001\\/12.21.01newsline.pdf","ClickUrl":"http:\\/\\/www.llnl.gov\\/llnl\\/06news\\/employee\\/articles\\/2001\\/12.21.01newsline.pdf#search=\'\'","ModificationDate":1099555200,"MimeType":"application\\/pdf","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcB7R3dmMwF;_ylu=X3oDMTBxZ25nbWN0BGNvbG8DdwRwb3MDNjMEc2VjA3NyBHZ0aWQD\\/SIG=17go91rgp\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.llnl.gov\\/llnl\\/06news\\/employee\\/articles\\/2001\\/12.21.01newsline.pdf%26w=132%26d=aLdSWEaqMjYB%26icp=1%26.intl=us","Size":"472758"}},{"Title":"Psalms 132. The Holy Bible: King James Version.","Summary":"... Reference &gt; The Bible &gt; The King James Version &gt; Psalms &gt; 132 ... The Psalms. 132. A Prayer for Blessing on the Sanctuary ...","Url":"http:\\/\\/www.bartleby.com\\/108\\/19\\/132.html","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcB7x3dmMwF;_ylu=X3oDMTEwdm1iOTMzBGNvbG8DdwRsA1dTMQRwb3MDNjQEc2VjA3NyBHZ0aWQD\\/SIG=11rfct28r\\/EXP=1147592336\\/**http%3a\\/\\/www.bartleby.com\\/108\\/19\\/132.html","ModificationDate":1134460800,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcB9B3dmMwF;_ylu=X3oDMTBxa3RqY29tBGNvbG8DdwRwb3MDNjQEc2VjA3NyBHZ0aWQD\\/SIG=16ckhlf21\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.bartleby.com\\/108\\/19\\/132.html%26w=132%26d=Om0HPEaqMjyM%26icp=1%26.intl=us","Size":"26896"}},{"Title":"The Criterion Collection: Ruling Class, The","Summary":"Title Person. Film Info. 1972. 154 minutes. Color. 1.77:1. Dolby Digital Mono 1.0. Anamorphic. English. Release Info. Catalog Number: CC1575D. ISBN: 1-55940-922-3. UPC: 7-15515-0124-2-3. SRP: \$39.95. Synopsis","Url":"http:\\/\\/www.criterionco.com\\/asp\\/release.asp?id=132","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcB9h3dmMwF;_ylu=X3oDMTEwcTRya2ltBGNvbG8DdwRsA1dTMQRwb3MDNjUEc2VjA3NyBHZ0aWQD\\/SIG=1272o9dh7\\/EXP=1147592336\\/**http%3a\\/\\/www.criterionco.com\\/asp\\/release.asp%3fid=132","ModificationDate":1147244400,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcB.x3dmMwF;_ylu=X3oDMTBxdDMwMGJvBGNvbG8DdwRwb3MDNjUEc2VjA3NyBHZ0aWQD\\/SIG=16u4fa0dg\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.criterionco.com\\/asp\\/release.asp%253Fid%253D132%26w=132%26d=L2PGVEaqMwN7%26icp=1%26.intl=us","Size":"16920"}},{"Title":"AJP Legacy -- Table of Contents (February 28 1941, 132 [2])","Summary":"Contents: February 28 1941, Volume 132, Issue 2 [Index by Author] Other Issues: To see an article, click its [Full Text] link.","Url":"http:\\/\\/ajplegacy.physiology.org\\/content\\/vol132\\/issue2\\/index.shtml","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcB_R3dmMwF;_ylu=X3oDMTEwZWhkczJpBGNvbG8DdwRsA1dTMQRwb3MDNjYEc2VjA3NyBHZ0aWQD\\/SIG=12lf1ce7j\\/EXP=1147592336\\/**http%3a\\/\\/ajplegacy.physiology.org\\/content\\/vol132\\/issue2\\/index.shtml","ModificationDate":1141459200,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBAh7dmMwF;_ylu=X3oDMTBxNzI0azAwBGNvbG8DdwRwb3MDNjYEc2VjA3NyBHZ0aWQD\\/SIG=176uub081\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=ajplegacy.physiology.org\\/content\\/vol132\\/issue2\\/index.shtml%26w=132%26d=Ms_vOEaqMj-H%26icp=1%26.intl=us","Size":"24095"}},{"Title":"released a letter (PDF)","Summary":"","Url":"http:\\/\\/www.house.gov\\/judiciary_democrats\\/letters\\/rovehrgrequestltr71405.pdf","ClickUrl":"http:\\/\\/www.house.gov\\/judiciary_democrats\\/letters\\/rovehrgrequestltr71405.pdf#search=\'\'","ModificationDate":1121410800,"MimeType":"application\\/pdf","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBBx7dmMwF;_ylu=X3oDMTBxOXQ3MWF0BGNvbG8DdwRwb3MDNjcEc2VjA3NyBHZ0aWQD\\/SIG=17g69a880\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.house.gov\\/judiciary_democrats\\/letters\\/rovehrgrequestltr71405.pdf%26w=132%26d=LPrB50aqMqRY%26icp=1%26.intl=us","Size":"381000"}},{"Title":"NC General Statutes Chapter 132","Summary":"North Carolina. State Public Records Law. North Carolina General Statutes. Chapter 132. Public Records. Last updated December 10th, 1999. Contents. Section Title. 132-1. \\"Public records\\" defined. 132-1.1. ... Section Title. 132-1. \\"Public records\\" defined. 132-1.1. Confidential communications by legal counsel to public board or agency; State tax ...","Url":"http:\\/\\/www.ah.dcr.state.nc.us\\/e-records\\/ncgs\\/ncgs132.htm","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBCR7dmMwF;_ylu=X3oDMTEwMjJmbW84BGNvbG8DdwRsA1dTMQRwb3MDNjgEc2VjA3NyBHZ0aWQD\\/SIG=12ctoo16c\\/EXP=1147592336\\/**http%3a\\/\\/www.ah.dcr.state.nc.us\\/e-records\\/ncgs\\/ncgs132.htm","ModificationDate":953625600,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBDh7dmMwF;_ylu=X3oDMTBxYjJtcGphBGNvbG8DdwRwb3MDNjgEc2VjA3NyBHZ0aWQD\\/SIG=16t5vbni8\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.ah.dcr.state.nc.us\\/e-records\\/ncgs\\/ncgs132.htm%26w=132%26d=MyfGH0aqMwR0%26icp=1%26.intl=us","Size":"43695"}},{"Title":"Technical Introduction to CDMA","Summary":"Course 132. Technical. Introduction to CDMA. Technical. Introduction to CDMA. IS-95, CDMA2000 and a glimpse of 1xEV. February, 2005. 132 - 1. Technical Introduction to CDMA v4.0 (c) 2005 Scott Baxter. Course Outline. Basic CDMA Principles. Coding","Url":"http:\\/\\/www.howcdmaworks.com\\/intro\\/132v3.pdf","ClickUrl":"http:\\/\\/www.howcdmaworks.com\\/intro\\/132v3.pdf#search=\'\'","ModificationDate":1107590400,"MimeType":"application\\/pdf","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBEx7dmMwF;_ylu=X3oDMTBxbTJnbmxhBGNvbG8DdwRwb3MDNjkEc2VjA3NyBHZ0aWQD\\/SIG=16ghr9cvr\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.howcdmaworks.com\\/intro\\/132v3.pdf%26w=132%26d=B6dAbEaqMu7t%26icp=1%26.intl=us","Size":"4342039"}},{"Title":"Thread Images Digitizing","Summary":"Free embroidery design. Specializes in providing custom quality embroidery designs to the professional embroiderer.","Url":"http:\\/\\/www.threadimages.com\\/","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBFR7dmMwF;_ylu=X3oDMTEwMmI2cWQzBGNvbG8DdwRsA1dTMQRwb3MDNzAEc2VjA3NyBHZ0aWQD\\/SIG=11gsp7523\\/EXP=1147592336\\/**http%3a\\/\\/www.threadimages.com\\/","ModificationDate":1147158000,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBGx7dmMwF;_ylu=X3oDMTBxaml0dDF0BGNvbG8DdwRwb3MDNzAEc2VjA3NyBHZ0aWQD\\/SIG=161ukrsfh\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.threadimages.com\\/%26w=132%26d=BmPG10aqMwgW%26icp=1%26.intl=us","Size":"55861"}},{"Title":"Psalms Chapter 132:1-18.","Summary":"Read the Hebrew Transliteration Psalms 132:1-18 Online.","Url":"http:\\/\\/bibledbdata.org\\/onlinebibles\\/hebrew_translit\\/19_132.htm","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBHR7dmMwF;_ylu=X3oDMTEwdXJnMnJuBGNvbG8DdwRsA1dTMQRwb3MDNzEEc2VjA3NyBHZ0aWQD\\/SIG=12i1mped7\\/EXP=1147592336\\/**http%3a\\/\\/bibledbdata.org\\/onlinebibles\\/hebrew_translit\\/19_132.htm","ModificationDate":1044172800,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBIh7dmMwF;_ylu=X3oDMTBxNmJocG1iBGNvbG8DdwRwb3MDNzEEc2VjA3NyBHZ0aWQD\\/SIG=173o8ajtj\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=bibledbdata.org\\/onlinebibles\\/hebrew_translit\\/19_132.htm%26w=132%26d=dfiAJkaqMi1u%26icp=1%26.intl=us","Size":"9706"}},{"Title":"PRC-132","Summary":"K6ERO Portable and pedestrian mobile amateur radio. PRC-132 &amp; M50B. To the left is a Loral Terracom M50B. made in 1988 Serial#19 . Its 10 inches tall. with out battery box or external power. box , 3.5 inches wide and 5.25 inches. deep, weight 6.9 lbs . ... The M50B is the early issue version of the. PRC-132 special operations HF Radio ...","Url":"http:\\/\\/www.muttmotorpool.com\\/PRC-132","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBJB7dmMwF;_ylu=X3oDMTEwYm80YTY1BGNvbG8DdwRsA1dTMQRwb3MDNzIEc2VjA3NyBHZ0aWQD\\/SIG=11ou3h7bi\\/EXP=1147592336\\/**http%3a\\/\\/www.muttmotorpool.com\\/PRC-132","ModificationDate":1146294000,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBKR7dmMwF;_ylu=X3oDMTBxaDgzYWcxBGNvbG8DdwRwb3MDNzIEc2VjA3NyBHZ0aWQD\\/SIG=169r7ofhd\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.muttmotorpool.com\\/PRC-132%26w=132%26d=Utj0H0aqMs48%26icp=1%26.intl=us","Size":"19723"}},{"Title":"Firenze 132 \\/ 170","Summary":"Firenze 132 \\/ 170. Matte Presentation Paper. 132 gram 2-side coated. 170 gram single side coated. Magicl\\u00e9e\\u00ae Firenze 132 and Firenze 170 matte. papers are designed for poster applications and. have an impressive price performance ratio. The ... If using the 132 gram. paper for 2-sided imaging ink limit on ...","Url":"http:\\/\\/www.magicinkjet.com\\/client_data_pdf\\/guides\\/Firenze.pdf","ClickUrl":"http:\\/\\/www.magicinkjet.com\\/client_data_pdf\\/guides\\/Firenze.pdf#search=\'\'","ModificationDate":1081839600,"MimeType":"application\\/pdf","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBLh7dmMwF;_ylu=X3oDMTBxbXY4b2luBGNvbG8DdwRwb3MDNzMEc2VjA3NyBHZ0aWQD\\/SIG=172sdum75\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.magicinkjet.com\\/client_data_pdf\\/guides\\/Firenze.pdf%26w=132%26d=Q4ILzEaqMh1n%26icp=1%26.intl=us","Size":"2152647"}},{"Title":"Museletter # 132 \\/ February 2003: The US and Eurasia: End Game for the Industrial Era?","Summary":"Defining democracy in the wake of the 2002 elections in the U.S.A..","Url":"http:\\/\\/www.museletter.com\\/archive\\/132.html","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBMB7dmMwF;_ylu=X3oDMTEwNGRiZ3FjBGNvbG8DdwRsA1dTMQRwb3MDNzQEc2VjA3NyBHZ0aWQD\\/SIG=11upr7v32\\/EXP=1147592336\\/**http%3a\\/\\/www.museletter.com\\/archive\\/132.html","ModificationDate":1108540800,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBNR7dmMwF;_ylu=X3oDMTBxZTNpbG1nBGNvbG8DdwRwb3MDNzQEc2VjA3NyBHZ0aWQD\\/SIG=16fg9g4no\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.museletter.com\\/archive\\/132.html%26w=132%26d=SS0AQEaqMvuR%26icp=1%26.intl=us","Size":"47428"}},{"Title":"Downloaded 25 Oct 2002 to 132.66.16.12. Redistribution subject to AIP license or copyright, see http:\\/\\/ojps.aip.org\\/... ","Summary":"Downloaded 25 Oct 2002 to 132.66.16.12. Redistribution subject to AIP license or copyright, see http:\\/\\/ojps.aip.org\\/jcpo\\/jcpcr.jsp. Downloaded 25 Oct 2002 to 132.66.16.12.","Url":"http:\\/\\/star.tau.ac.il\\/~andelman\\/reprints\\/018_JCP_1987_86_3673.pdf","ClickUrl":"http:\\/\\/star.tau.ac.il\\/~andelman\\/reprints\\/018_JCP_1987_86_3673.pdf#search=\'\'","ModificationDate":1035529200,"MimeType":"application\\/pdf","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBOh7dmMwF;_ylu=X3oDMTBxbGZmanU1BGNvbG8DdwRwb3MDNzUEc2VjA3NyBHZ0aWQD\\/SIG=17a4s312u\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=star.tau.ac.il\\/%257Eandelman\\/reprints\\/018_JCP_1987_86_3673.pdf%26w=132%26d=YANT3kaqMhfd%26icp=1%26.intl=us","Size":"1204421"}},{"Title":"Hepatitis B Virus: A Comprehensive Strategy for Eliminating Transmission in the United States Through Universal ... ","Summary":"Hepatitis B Virus: A Comprehensive Strategy for Eliminating Transmission in the United States Through Universal Childhood Vaccination: Recommendations of the Immunization Practices Advisory Committee (ACIP)","Url":"http:\\/\\/www.cdc.gov\\/mmwr\\/preview\\/mmwrhtml\\/00033405.htm","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBPB7dmMwF;_ylu=X3oDMTEwb2NlbHRuBGNvbG8DdwRsA1dTMQRwb3MDNzYEc2VjA3NyBHZ0aWQD\\/SIG=129kdm2n4\\/EXP=1147592336\\/**http%3a\\/\\/www.cdc.gov\\/mmwr\\/preview\\/mmwrhtml\\/00033405.htm","ModificationDate":1139990400,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBQR7dmMwF;_ylu=X3oDMTBxZm44bG9sBGNvbG8DdwRwb3MDNzYEc2VjA3NyBHZ0aWQD\\/SIG=16qv48dkp\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.cdc.gov\\/mmwr\\/preview\\/mmwrhtml\\/00033405.htm%26w=132%26d=b-Kz6UaqMwIM%26icp=1%26.intl=us","Size":"87232"}},{"Title":"Tour de France 2005","Summary":"... QUICK STEP - INNERGETIC. 132 - CRETSKENS Wilfried (BEL) Born in 10\\/07\\/1976 \\u00e0 Herk-de-Stad (BEL ...","Url":"http:\\/\\/www.letour.fr\\/2005\\/TDF\\/RIDERS\\/us\\/coureurs\\/132.html","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBQx7dmMwF;_ylu=X3oDMTEwYjdwazg2BGNvbG8DdwRsA1dTMQRwb3MDNzcEc2VjA3NyBHZ0aWQD\\/SIG=12dpjmcf6\\/EXP=1147592336\\/**http%3a\\/\\/www.letour.fr\\/2005\\/TDF\\/RIDERS\\/us\\/coureurs\\/132.html","ModificationDate":1121583600,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBSB7dmMwF;_ylu=X3oDMTBxa21laGFvBGNvbG8DdwRwb3MDNzcEc2VjA3NyBHZ0aWQD\\/SIG=16u0nn96f\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.letour.fr\\/2005\\/TDF\\/RIDERS\\/us\\/coureurs\\/132.html%26w=132%26d=BTTUC0aqMv4Z%26icp=1%26.intl=us","Size":"12171"}},{"Title":"This American Life | Father\'s Day \'99","Summary":"... 6\\/18\\/99. Episode 132. For Father\'s Day, stories about fathers going out of their way to protect their kids, and kids going ...","Url":"http:\\/\\/www.thisamericanlife.org\\/pages\\/descriptions\\/99\\/132.html","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBSh7dmMwF;_ylu=X3oDMTEwNDFvam42BGNvbG8DdwRsA1dTMQRwb3MDNzgEc2VjA3NyBHZ0aWQD\\/SIG=12iobnkgv\\/EXP=1147592336\\/**http%3a\\/\\/www.thisamericanlife.org\\/pages\\/descriptions\\/99\\/132.html","ModificationDate":1146466800,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBTx7dmMwF;_ylu=X3oDMTBxZzFuNDV2BGNvbG8DdwRwb3MDNzgEc2VjA3NyBHZ0aWQD\\/SIG=1738d5fam\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.thisamericanlife.org\\/pages\\/descriptions\\/99\\/132.html%26w=132%26d=Ss_yvkaqMvWK%26icp=1%26.intl=us","Size":"8411"}},{"Title":"Downloaded 21 Jan 2004 to 132.66.16.34. Redistribution subject to AIP license or copyright, see http:\\/\\/ojps.aip.org\\/... ","Summary":"Downloaded 21 Jan 2004 to 132.66.16.34. Redistribution subject to AIP license or copyright, see http:\\/\\/ojps.aip.org\\/jcpo\\/jcpcr.jsp. Downloaded 21 Jan 2004 to 132.66.16.34.","Url":"http:\\/\\/femto.tau.ac.il\\/~nitzan\\/3.pdf","ClickUrl":"http:\\/\\/femto.tau.ac.il\\/~nitzan\\/3.pdf#search=\'\'","ModificationDate":1088665200,"MimeType":"application\\/pdf","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBVB7dmMwF;_ylu=X3oDMTBxdXJmcnJsBGNvbG8DdwRwb3MDNzkEc2VjA3NyBHZ0aWQD\\/SIG=16da99c2u\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=femto.tau.ac.il\\/%257Enitzan\\/3.pdf%26w=132%26d=b5Br7UaqMjB1%26icp=1%26.intl=us","Size":"1071954"}},{"Title":"CHAPTER 12 ENVIRONMENTAL REVIEW \\u2013 EAST 132","Summary":"Solid Waste Management Plan. 12-1. October2004. DEIS. CHAPTER 12. ENVIRONMENTAL REVIEW \\u2013 EAST 132. ND. STREET SITE. 12.1 Introduction. The East 132. nd. Street Site is currently permitted to handle 2,999 tpd of putrescible waste, with a","Url":"http:\\/\\/www.nyc.gov\\/html\\/dsny\\/downloads\\/pdf\\/pubnrpts\\/swmp-4oct\\/deis\\/chapter12.pdf","ClickUrl":"http:\\/\\/www.nyc.gov\\/html\\/dsny\\/downloads\\/pdf\\/pubnrpts\\/swmp-4oct\\/deis\\/chapter12.pdf#search=\'\'","ModificationDate":1099555200,"MimeType":"application\\/pdf","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBWR7dmMwF;_ylu=X3oDMTBxaHNlODZrBGNvbG8DdwRwb3MDODAEc2VjA3NyBHZ0aWQD\\/SIG=17llu5bkp\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.nyc.gov\\/html\\/dsny\\/downloads\\/pdf\\/pubnrpts\\/swmp-4oct\\/deis\\/chapter12.pdf%26w=132%26d=RPmqz0aqMiKh%26icp=1%26.intl=us","Size":"1417879"}},{"Title":"Psalms 132 \\/ Hebrew - English Bible \\/ Mechon-Mamre","Summary":"... 121 122 123 124 125 126 127 128 129 130 131 132 133 134 135 136 137 138 139 140 141 142 143 144 ... Psalms Chapter 132. \\u00e0 \\u00f9\\u00d1\\u00c4\\u00e9\\u00f8, \\u00e4\\u00c7\\u00ee\\u00cc\\u00c7\\u00f2\\u00c2\\u00ec\\u00e5\\u00c9\\u00fa ...","Url":"http:\\/\\/www.mechon-mamre.org\\/p\\/pt\\/pt26d2.htm","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBWx7dmMwF;_ylu=X3oDMTEwc3RoZXBrBGNvbG8DdwRsA1dTMQRwb3MDODEEc2VjA3NyBHZ0aWQD\\/SIG=11vhbotpk\\/EXP=1147592336\\/**http%3a\\/\\/www.mechon-mamre.org\\/p\\/pt\\/pt26d2.htm","ModificationDate":1138694400,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBYB7dmMwF;_ylu=X3oDMTBxNjUwMGs2BGNvbG8DdwRwb3MDODEEc2VjA3NyBHZ0aWQD\\/SIG=16gg7tf89\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.mechon-mamre.org\\/p\\/pt\\/pt26d2.htm%26w=132%26d=WTHLVUaqMu6s%26icp=1%26.intl=us","Size":"13881"}},{"Title":"US CODE: Title 28,132. Creation and composition of district courts","Summary":"Creation and composition of district courts. Release date: 2005-09-29. (a) There shall be in each judicial district a district court which shall be a court of record known as the United States District Court for the district.","Url":"http:\\/\\/www4.law.cornell.edu\\/uscode\\/28\\/132.html","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBYh7dmMwF;_ylu=X3oDMTEwcWlsMGMxBGNvbG8DdwRsA1dTMQRwb3MDODIEc2VjA3NyBHZ0aWQD\\/SIG=122ek55sr\\/EXP=1147592336\\/**http%3a\\/\\/www4.law.cornell.edu\\/uscode\\/28\\/132.html","ModificationDate":1143273600,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBZx7dmMwF;_ylu=X3oDMTBxYWs1NmFvBGNvbG8DdwRwb3MDODIEc2VjA3NyBHZ0aWQD\\/SIG=16jb47dcg\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www4.law.cornell.edu\\/uscode\\/28\\/132.html%26w=132%26d=QQ2S7EaqMjbv%26icp=1%26.intl=us","Size":"9107"}},{"Title":"Fiscal Note","Summary":"... Bill, Resolutions and Memorial Documents. SB05-132 ... Final Act\\/ Resolutions or Memorial: 132_enr.pdfn. 132.enrn. Preamended Documents ...","Url":"http:\\/\\/www.leg.state.co.us\\/Clics2005a\\/csl.nsf\\/fsbillcont3\\/A4058D1E27570DC987256F7E0059EAA8?Open&file=132_enr.pdf","ClickUrl":"http:\\/\\/www.leg.state.co.us\\/Clics2005a\\/csl.nsf\\/fsbillcont3\\/A4058D1E27570DC987256F7E0059EAA8?Open&file=132_enr.pdf#search=\'\'","ModificationDate":1124521200,"MimeType":"application\\/pdf","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBbB7dmMwF;_ylu=X3oDMTBxbGJmNjEwBGNvbG8DdwRwb3MDODMEc2VjA3NyBHZ0aWQD\\/SIG=191n41l4b\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.leg.state.co.us\\/Clics2005a\\/csl.nsf\\/fsbillcont3\\/A4058D1E27570DC987256F7E0059EAA8%253FOpen%2526file%253D132_enr.pdf%26w=132%26d=LViIXUaqMkKL%26icp=1%26.intl=us","Size":"87930"}},{"Title":"Development -- Table of Contents (January 1 2005, 132 [1])","Summary":"To see an article, click its [Full Text] link. To review many abstracts, check the boxes to the left of the titles you want, and click the \'Get All Checked Abstract(s)\' button. To see one abstract at a time, click its [Abstract] link.","Url":"http:\\/\\/dev.biologists.org\\/content\\/vol132\\/issue1","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBbh7dmMwF;_ylu=X3oDMTEwdWdwcnIyBGNvbG8DdwRsA1dTMQRwb3MDODQEc2VjA3NyBHZ0aWQD\\/SIG=123019ojj\\/EXP=1147592336\\/**http%3a\\/\\/dev.biologists.org\\/content\\/vol132\\/issue1","ModificationDate":1147071600,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBcx7dmMwF;_ylu=X3oDMTBxczM2ZHFvBGNvbG8DdwRwb3MDODQEc2VjA3NyBHZ0aWQD\\/SIG=16kng2m03\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=dev.biologists.org\\/content\\/vol132\\/issue1%26w=132%26d=LFOVEUaqMwR5%26icp=1%26.intl=us","Size":"25711"}},{"Title":"Winter Carnival (1939)","Summary":"Winter Carnival - Cast, Crew, Reviews, Plot Summary, Comments, Discussion, Taglines, Trailers, Posters, Photos, Showtimes, Link to Official Site, Fan Sites","Url":"http:\\/\\/www.imdb.com\\/title\\/tt0032132\\/","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBdR7dmMwF;_ylu=X3oDMTEwb3IzajNvBGNvbG8DdwRsA1dTMQRwb3MDODUEc2VjA3NyBHZ0aWQD\\/SIG=11o6bhdhm\\/EXP=1147592336\\/**http%3a\\/\\/www.imdb.com\\/title\\/tt0032132\\/","ModificationDate":1147417200,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBeh7dmMwF;_ylu=X3oDMTBxcG9jdDNjBGNvbG8DdwRwb3MDODUEc2VjA3NyBHZ0aWQD\\/SIG=1696d85k0\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.imdb.com\\/title\\/tt0032132\\/%26w=132%26d=OnC3HUaqMw5H%26icp=1%26.intl=us","Size":"44616"}},{"Title":"XM Radio - C-SPAN Radio","Summary":"... XM 132. &lt;Previous. Next ...","Url":"http:\\/\\/www.xmradio.com\\/programming\\/channel_page.jsp?ch=132","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBfB7dmMwF;_ylu=X3oDMTEwa3RyODBuBGNvbG8DdwRsA1dTMQRwb3MDODYEc2VjA3NyBHZ0aWQD\\/SIG=12gtfnvt7\\/EXP=1147592336\\/**http%3a\\/\\/www.xmradio.com\\/programming\\/channel_page.jsp%3fch=132","ModificationDate":1147158000,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBgR7dmMwF;_ylu=X3oDMTBxN24xYzc0BGNvbG8DdwRwb3MDODYEc2VjA3NyBHZ0aWQD\\/SIG=1774en6i4\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.xmradio.com\\/programming\\/channel_page.jsp%253Fch%253D132%26w=132%26d=WS_5a0aqMwE5%26icp=1%26.intl=us","Size":"23601"}},{"Title":"Al-Qaeda tape says bin Laden alive, urges Iraqis to fight - theage.com.au","Summary":"Arabic television channel Al Arabiya has aired what it says is an audiotape from an al-Qaeda spokesman who says Osama bin Laden is alive and well. - The Age","Url":"http:\\/\\/www.theage.com.au\\/articles\\/2003\\/08\\/18\\/1061059775995.html","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBgx7dmMwF;_ylu=X3oDMTEwNXU4aDFlBGNvbG8DdwRsA1dTMQRwb3MDODcEc2VjA3NyBHZ0aWQD\\/SIG=12jscc3ng\\/EXP=1147592336\\/**http%3a\\/\\/www.theage.com.au\\/articles\\/2003\\/08\\/18\\/1061059775995.html","ModificationDate":1147158000,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBiB7dmMwF;_ylu=X3oDMTBxZjFrNnYwBGNvbG8DdwRwb3MDODcEc2VjA3NyBHZ0aWQD\\/SIG=174fs4fo6\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.theage.com.au\\/articles\\/2003\\/08\\/18\\/1061059775995.html%26w=132%26d=VUVD3UaqMwJD%26icp=1%26.intl=us","Size":"25163"}},{"Title":"Psalms 132","Summary":"Psalms 132. 132:1. Lord, remember David, and all his afflictions: 132:2. How he sware unto the LORD, and vowed unto the mighty God of Jacob; 132:3 ... Psalms 132. Chapters: 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 ... 132:3. Surely I will not come into the tabernacle of my ...","Url":"http:\\/\\/www.maitreg.com\\/bible\\/view.asp?book=38&chapter=132","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBih7dmMwF;_ylu=X3oDMTEwZjVxcHI4BGNvbG8DdwRsA1dTMQRwb3MDODgEc2VjA3NyBHZ0aWQD\\/SIG=12hild8td\\/EXP=1147592336\\/**http%3a\\/\\/www.maitreg.com\\/bible\\/view.asp%3fbook=38%26chapter=132","ModificationDate":1117609200,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBjx7dmMwF;_ylu=X3oDMTBxb2JpMW5pBGNvbG8DdwRwb3MDODgEc2VjA3NyBHZ0aWQD\\/SIG=17elhve1h\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.maitreg.com\\/bible\\/view.asp%253Fbook%253D38%2526chapter%253D132%26w=132%26d=TMHn-UaqMjbU%26icp=1%26.intl=us","Size":"27216"}},{"Title":"132","Summary":"35 U.S.C. 132 Notice of rejection; reexamination. - Patent Laws. 35 U.S.C. 132 Notice of rejection; reexamination.","Url":"http:\\/\\/www.uspto.gov\\/web\\/offices\\/pac\\/mpep\\/documents\\/appxl_35_U_S_C_132.htm","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBkR7dmMwF;_ylu=X3oDMTEwNTA2aTh1BGNvbG8DdwRsA1dTMQRwb3MDODkEc2VjA3NyBHZ0aWQD\\/SIG=12ucmimjn\\/EXP=1147592336\\/**http%3a\\/\\/www.uspto.gov\\/web\\/offices\\/pac\\/mpep\\/documents\\/appxl_35_U_S_C_132.htm","ModificationDate":1133942400,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBlh7dmMwF;_ylu=X3oDMTBxNmVndjYxBGNvbG8DdwRwb3MDODkEc2VjA3NyBHZ0aWQD\\/SIG=17f2jjpsh\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.uspto.gov\\/web\\/offices\\/pac\\/mpep\\/documents\\/appxl_35_U_S_C_132.htm%26w=132%26d=Nil-N0aqMjBx%26icp=1%26.intl=us","Size":"8182"}},{"Title":"A CONCISE SUMMARY OF THE PUBLIC HEARINGS","Summary":"... hearing on Bill 132. It shows you who was for, who was ... Opposes BSL, pointed out many anomalies in Bill 132, for example you can\'t teach a pit bull to ...","Url":"http:\\/\\/www.dogwatch.net\\/bill132.pdf","ClickUrl":"http:\\/\\/www.dogwatch.net\\/bill132.pdf#search=\'\'","ModificationDate":1109232000,"MimeType":"application\\/pdf","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBmx7dmMwF;_ylu=X3oDMTBxZ2gwNnM2BGNvbG8DdwRwb3MDOTAEc2VjA3NyBHZ0aWQD\\/SIG=168j23ta7\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.dogwatch.net\\/bill132.pdf%26w=132%26d=PkjRQEaqMuwO%26icp=1%26.intl=us","Size":"1982792"}},{"Title":"JPL News -- A Galaxy Far, Far Away Eyed by Linked Hawaiian Telescopes","Summary":"... Keck Observatory, Kamuela, Hawaii. 2003-132. Site Manager: Webmasters ...","Url":"http:\\/\\/www.jpl.nasa.gov\\/releases\\/2003\\/132.cfm","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBnR7dmMwF;_ylu=X3oDMTEwaTAxcXV0BGNvbG8DdwRsA1dTMQRwb3MDOTEEc2VjA3NyBHZ0aWQD\\/SIG=12170u1vu\\/EXP=1147592336\\/**http%3a\\/\\/www.jpl.nasa.gov\\/releases\\/2003\\/132.cfm","ModificationDate":1136016000,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBoh7dmMwF;_ylu=X3oDMTBxanNkbHBvBGNvbG8DdwRwb3MDOTEEc2VjA3NyBHZ0aWQD\\/SIG=16i2p31tn\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.jpl.nasa.gov\\/releases\\/2003\\/132.cfm%26w=132%26d=VNPrSUaqMkiG%26icp=1%26.intl=us","Size":"22198"}},{"Title":"(132) Justinian I","Summary":"(132) Justinian I - AV solidus, A.D. 527-545, 4.45 g. ( inv. 91.270). Obverse: Facing helmeted and cuirassed bust of Justinian, holding globus cruciger in r.; at l.","Url":"http:\\/\\/www.lawrence.edu\\/dept\\/art\\/buerger\\/catalogue\\/132.html","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBpB7dmMwF;_ylu=X3oDMTEwamM1Y3A2BGNvbG8DdwRsA1dTMQRwb3MDOTIEc2VjA3NyBHZ0aWQD\\/SIG=12f6r1r1h\\/EXP=1147592336\\/**http%3a\\/\\/www.lawrence.edu\\/dept\\/art\\/buerger\\/catalogue\\/132.html","ModificationDate":1006848000,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBqR7dmMwF;_ylu=X3oDMTBxZWNpdmpnBGNvbG8DdwRwb3MDOTIEc2VjA3NyBHZ0aWQD\\/SIG=1709bh559\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.lawrence.edu\\/dept\\/art\\/buerger\\/catalogue\\/132.html%26w=132%26d=BJJDnkaqMjfk%26icp=1%26.intl=us","Size":"3186"}},{"Title":"131","Summary":"35 U.S.C. 131 Examination of application. - Patent Laws. 35 U.S.C. 131 Examination of application.","Url":"http:\\/\\/www.uspto.gov\\/web\\/offices\\/pac\\/mpep\\/documents\\/appxl_35_U_S_C_131.htm","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBqx7dmMwF;_ylu=X3oDMTEwdDUzZHBhBGNvbG8DdwRsA1dTMQRwb3MDOTMEc2VjA3NyBHZ0aWQD\\/SIG=12u6cdfcn\\/EXP=1147592336\\/**http%3a\\/\\/www.uspto.gov\\/web\\/offices\\/pac\\/mpep\\/documents\\/appxl_35_U_S_C_131.htm","ModificationDate":1133942400,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBsB7dmMwF;_ylu=X3oDMTBxdXZhZWxkBGNvbG8DdwRwb3MDOTMEc2VjA3NyBHZ0aWQD\\/SIG=17f8j8d98\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.uspto.gov\\/web\\/offices\\/pac\\/mpep\\/documents\\/appxl_35_U_S_C_131.htm%26w=132%26d=R2aGhUaqMj30%26icp=1%26.intl=us","Size":"7341"}},{"Title":"132 on Flickr - Photo Sharing!","Summary":"... 132. To take full advantage of Flickr, you should use a JavaScript-enabled browser and ...","Url":"http:\\/\\/www.flickr.com\\/photos\\/brettsky\\/53839790\\/","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBsh7dmMwF;_ylu=X3oDMTEwZ2lxZDhhBGNvbG8DdwRsA1dTMQRwb3MDOTQEc2VjA3NyBHZ0aWQD\\/SIG=123ojcbf0\\/EXP=1147592336\\/**http%3a\\/\\/www.flickr.com\\/photos\\/brettsky\\/53839790\\/","ModificationDate":1145862000,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBtx7dmMwF;_ylu=X3oDMTBxYTJvNGFhBGNvbG8DdwRwb3MDOTQEc2VjA3NyBHZ0aWQD\\/SIG=16ks6e563\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.flickr.com\\/photos\\/brettsky\\/53839790\\/%26w=132%26d=GA_4oEaqMq4P%26icp=1%26.intl=us","Size":"74392"}},{"Title":"Ag GPS 124 \\/ 132","Summary":"AgGPS 124 \\/ 132. Operation Manual. AgGPS Receiver Firmware Version 1.40, 1.41 and 1.42. Part Number 38747-00-ENG. Revision C. September 2000. T. Support Offices. Trimble Precision Agricultural Systems. 9290 Bond Street, Suite 102. Overland Park, KS 66214 U.S.A. ... describes how to install and configure the AgGPS_ 124, 132, and 132. Air receivers ...","Url":"http:\\/\\/www.linco.com\\/AG124132REVB.PDF","ClickUrl":"http:\\/\\/www.linco.com\\/AG124132REVB.PDF#search=\'\'","ModificationDate":986281200,"MimeType":"application\\/pdf","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBvB7dmMwF;_ylu=X3oDMTBxbDgxOWxkBGNvbG8DdwRwb3MDOTUEc2VjA3NyBHZ0aWQD\\/SIG=16ajtq3hk\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.linco.com\\/AG124132REVB.PDF%26w=132%26d=FCohUkaqMjOV%26icp=1%26.intl=us","Size":"3610097"}},{"Title":"Tehillim - Chapter 132 | Chabad.org","Summary":"Please login for more site features. Tehillim - Chapter 132. 1. A song of ascents. Remember, O Lord, onto David all his affliction. 2. That he swore to the Lord, he vowed to the Mighty One of Jacob; ... Chabad.org \\" Library \\" Classic Texts \\" The Bible (with Rashi) \\" K\'tuvim \\" Tehillim \\" Chapter 132 ...","Url":"http:\\/\\/www.chabad.org\\/library\\/article.asp?AID=16353","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBvh7dmMwF;_ylu=X3oDMTEwam44NW9vBGNvbG8DdwRsA1dTMQRwb3MDOTYEc2VjA3NyBHZ0aWQD\\/SIG=129b821nj\\/EXP=1147592336\\/**http%3a\\/\\/www.chabad.org\\/library\\/article.asp%3fAID=16353","ModificationDate":1146898800,"MimeType":"text\\/html","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBwx7dmMwF;_ylu=X3oDMTBxczRxYWlqBGNvbG8DdwRwb3MDOTYEc2VjA3NyBHZ0aWQD\\/SIG=170gmib5a\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.chabad.org\\/library\\/article.asp%253FAID%253D16353%26w=132%26d=I-adaEaqMvld%26icp=1%26.intl=us","Size":"41051"}},{"Title":"Downloaded 19 Jan 2003 to 132.77.4.43. Redistribution subject to AIP license or copyright, see http:\\/\\/ojps.aip.org\\/... ","Summary":"Downloaded 19 Jan 2003 to 132.77.4.43. Redistribution subject to AIP license or copyright, see http:\\/\\/ojps.aip.org\\/jcpo\\/jcpcr.jsp. Downloaded 19 Jan 2003 to 132.77.4.43.","Url":"http:\\/\\/www.weizmann.ac.il\\/chemphys\\/Frydman_group\\/Publications\\/ExchDynamics-JCP90.pdf","ClickUrl":"http:\\/\\/www.weizmann.ac.il\\/chemphys\\/Frydman_group\\/Publications\\/ExchDynamics-JCP90.pdf#search=\'\'","ModificationDate":1061622000,"MimeType":"application\\/pdf","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcByB7dmMwF;_ylu=X3oDMTBxZGVwcTFiBGNvbG8DdwRwb3MDOTcEc2VjA3NyBHZ0aWQD\\/SIG=17p1893is\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.weizmann.ac.il\\/chemphys\\/Frydman_group\\/Publications\\/ExchDynamics-JCP90.pdf%26w=132%26d=KPVdS0aqMkW1%26icp=1%26.intl=us","Size":"816603"}},{"Title":"Downloaded 19 May 2003 to 132.77.4.43. Redistribution subject to AIP license or copyright, see http:\\/\\/ojps.aip.org\\/... ","Summary":"Downloaded 19 May 2003 to 132.77.4.43. Redistribution subject to AIP license or copyright, see http:\\/\\/ojps.aip.org\\/japo\\/japcr.jsp. Downloaded 19 May 2003 to 132.77.4.43.","Url":"http:\\/\\/www.weizmann.ac.il\\/wagner\\/COURSES\\/Reading%20material%20(papers)\\/030_JAP_1990_ContactAngle.pdf","ClickUrl":"http:\\/\\/www.weizmann.ac.il\\/wagner\\/COURSES\\/Reading%20material%20(papers)\\/030_JAP_1990_ContactAngle.pdf#search=\'\'","ModificationDate":1136880000,"MimeType":"application\\/pdf","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcBzR7dmMwF;_ylu=X3oDMTBxMjBxZ2VoBGNvbG8DdwRwb3MDOTgEc2VjA3NyBHZ0aWQD\\/SIG=18pfdig62\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=www.weizmann.ac.il\\/wagner\\/COURSES\\/Reading%252520material%252520%2528papers%2529\\/030_JAP_1990_ContactAngle.pdf%26w=132%26d=Nf5MWEaqMkV0%26icp=1%26.intl=us","Size":"784314"}},{"Title":"Downloaded 24 Jul 2002 to 132.163.135.12. Redistribution subject to AIP license or copyright, see http:\\/\\/ojps.aip... ","Summary":"Downloaded 24 Jul 2002 to 132.163.135.12. Redistribution subject to AIP license or copyright, see http:\\/\\/ojps.aip.org\\/japo\\/japcr.jsp. Downloaded 24 Jul 2002 to 132.163.135.12.","Url":"http:\\/\\/tf.nist.gov\\/general\\/pdf\\/569.pdf","ClickUrl":"http:\\/\\/tf.nist.gov\\/general\\/pdf\\/569.pdf#search=\'\'","ModificationDate":1027494000,"MimeType":"application\\/pdf","Cache":{"Url":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcB0h7dmMwF;_ylu=X3oDMTBxNmJhcjNhBGNvbG8DdwRwb3MDOTkEc2VjA3NyBHZ0aWQD\\/SIG=16b31en6n\\/EXP=1147592336\\/**http%3a\\/\\/66.218.69.11\\/search\\/cache%3fei=UTF-8%26query=132%26output=json%26results=100%26appid=jennyhan_ac%26u=tf.nist.gov\\/general\\/pdf\\/569.pdf%26w=132%26d=IpdTwEaqMirR%26icp=1%26.intl=us","Size":"1002734"}},{"Title":"[DB] naruto 132","Summary":"","Url":"http:\\/\\/yhbt.mine.nu\\/t\\/n132.torrent","ClickUrl":"http:\\/\\/uk.wrs.yahoo.com\\/_ylt=A0Je5VwQjWVEsGcB1B7dmMwF;_ylu=X3oDMTExaW11dG45BGNvbG8DdwRsA1dTMQRwb3MDMTAwBHNlYwNzcgR2dGlkAw--\\/SIG=11m58k4sj\\/EXP=1147592336\\/**http%3a\\/\\/yhbt.mine.nu\\/t\\/n132.torrent","ModificationDate":1114671600,"MimeType":"unknown"}]}}');

  assertEquals(result.groupCount + 1, 5);
}
