# Testing file for use to debug IDL parsing and code gen in Eclipse.
# Update list of IDL files from Source/core/core.gypi and
# Source/modules/modules.gypi

import os


def full_path(paths, files):
    full_paths = []
    for relative_file in files:
        correct_relative_path = os.path.join(paths[0], paths[1], relative_file)
        full_paths.append(os.path.realpath(correct_relative_path))
    return full_paths


# This list is copied from Source/core/core.gypi 'core_idl_files'
# Core IDL files bindings (.dart, .cpp and .h files) will be generated
core_idl_files = [
            'animation/Animation.idl',
            'animation/AnimationEffect.idl',
            'animation/AnimationPlayer.idl',
            'animation/AnimationNode.idl',
            'animation/AnimationTimeline.idl',
            'animation/Timing.idl',
            'clipboard/DataTransfer.idl',
            'clipboard/DataTransferItem.idl',
            'clipboard/DataTransferItemList.idl',
            'css/CSS.idl',
            'css/CSSCharsetRule.idl',
            'css/CSSFontFaceRule.idl',
            'css/CSSImportRule.idl',
            'css/CSSKeyframeRule.idl',
            'css/CSSKeyframesRule.idl',
            'css/CSSMediaRule.idl',
            'css/CSSPageRule.idl',
            'css/CSSPrimitiveValue.idl',
            'css/CSSRule.idl',
            'css/CSSRuleList.idl',
            'css/CSSStyleDeclaration.idl',
            'css/CSSStyleRule.idl',
            'css/CSSStyleSheet.idl',
            'css/CSSSupportsRule.idl',
            'css/CSSUnknownRule.idl',
            'css/CSSValue.idl',
            'css/CSSValueList.idl',
            'css/CSSViewportRule.idl',
            'css/Counter.idl',
            'css/FontFace.idl',
            'css/FontFaceSet.idl',
            'css/FontFaceSetForEachCallback.idl',
            'css/FontFaceSetLoadEvent.idl',
            'css/MediaList.idl',
            'css/MediaQueryList.idl',
            'css/MediaQueryListEvent.idl',
            'css/RGBColor.idl',
            'css/Rect.idl',
            'css/StyleMedia.idl',
            'css/StyleSheet.idl',
            'css/StyleSheetList.idl',
            'css/WebKitCSSFilterRule.idl',
            'css/WebKitCSSFilterValue.idl',
            'css/WebKitCSSMatrix.idl',
            'css/WebKitCSSTransformValue.idl',
            'dom/Attr.idl',
            'dom/CDATASection.idl',
            'dom/CharacterData.idl',
            'dom/ClientRect.idl',
            'dom/ClientRectList.idl',
            'dom/Comment.idl',
            'dom/DOMError.idl',
            'dom/DOMException.idl',
            'dom/DOMImplementation.idl',
            'dom/DOMMatrix.idl',
            'dom/DOMMatrixReadOnly.idl',
            'dom/DOMPoint.idl',
            'dom/DOMPointReadOnly.idl',
            'dom/DOMRect.idl',
            'dom/DOMRectReadOnly.idl',
            'dom/DOMSettableTokenList.idl',
            'dom/DOMStringList.idl',
            'dom/DOMStringMap.idl',
            'dom/DOMTokenList.idl',
            'dom/Document.idl',
            'dom/DocumentFragment.idl',
            'dom/DocumentType.idl',
            'dom/Element.idl',
            'dom/Iterator.idl',
            'dom/MessageChannel.idl',
            'dom/MessagePort.idl',
            'dom/MutationObserver.idl',
            'dom/MutationRecord.idl',
            'dom/NamedNodeMap.idl',
            'dom/Node.idl',
            'dom/NodeFilter.idl',
            'dom/NodeIterator.idl',
            'dom/NodeList.idl',
            'dom/ProcessingInstruction.idl',
            'dom/Range.idl',
            'dom/RequestAnimationFrameCallback.idl',
            'dom/StringCallback.idl',
            'dom/Text.idl',
            'dom/Touch.idl',
            'dom/TouchList.idl',
            'dom/TreeWalker.idl',
            'dom/URL.idl',
            'dom/XMLDocument.idl',
            'dom/shadow/ShadowRoot.idl',
            'editing/Selection.idl',
            'events/AnimationPlayerEvent.idl',
            'events/ApplicationCacheErrorEvent.idl',
            'events/AutocompleteErrorEvent.idl',
            'events/BeforeUnloadEvent.idl',
            'events/CompositionEvent.idl',
            'events/CustomEvent.idl',
            'events/ErrorEvent.idl',
            'events/Event.idl',
            'events/EventTarget.idl',
            'events/FocusEvent.idl',
            'events/HashChangeEvent.idl',
            'events/KeyboardEvent.idl',
            'events/MessageEvent.idl',
            'events/MouseEvent.idl',
            'events/MutationEvent.idl',
            'events/OverflowEvent.idl',
            'events/PageTransitionEvent.idl',
            'events/PopStateEvent.idl',
            'events/ProgressEvent.idl',
            'events/RelatedEvent.idl',
            'events/ResourceProgressEvent.idl',
            'events/SecurityPolicyViolationEvent.idl',
            'events/TextEvent.idl',
            'events/TouchEvent.idl',
            'events/TransitionEvent.idl',
            'events/UIEvent.idl',
            'events/WebKitAnimationEvent.idl',
            'events/WheelEvent.idl',
            'fileapi/Blob.idl',
            'fileapi/File.idl',
            'fileapi/FileError.idl',
            'fileapi/FileList.idl',
            'fileapi/FileReader.idl',
            'fileapi/FileReaderSync.idl',
            'frame/BarProp.idl',
            'frame/Console.idl',
            'frame/ConsoleBase.idl',
            'frame/History.idl',
            'frame/ImageBitmap.idl',
            'frame/Location.idl',
            'frame/Navigator.idl',
            'frame/Screen.idl',
            'frame/Window.idl',
            'html/FormData.idl',
            'html/HTMLAllCollection.idl',
            'html/HTMLAnchorElement.idl',
            'html/HTMLAppletElement.idl',
            'html/HTMLAreaElement.idl',
            'html/HTMLAudioElement.idl',
            'html/HTMLBRElement.idl',
            'html/HTMLBaseElement.idl',
            'html/HTMLBodyElement.idl',
            'html/HTMLButtonElement.idl',
            'html/HTMLCanvasElement.idl',
            'html/HTMLCollection.idl',
            'html/HTMLContentElement.idl',
            'html/HTMLDListElement.idl',
            'html/HTMLDataListElement.idl',
            'html/HTMLDetailsElement.idl',
            'html/HTMLDialogElement.idl',
            'html/HTMLDirectoryElement.idl',
            'html/HTMLDivElement.idl',
            'html/HTMLDocument.idl',
            'html/HTMLElement.idl',
            'html/HTMLEmbedElement.idl',
            'html/HTMLFieldSetElement.idl',
            'html/HTMLFontElement.idl',
            'html/HTMLFormControlsCollection.idl',
            'html/HTMLFormElement.idl',
            'html/HTMLFrameElement.idl',
            'html/HTMLFrameSetElement.idl',
            'html/HTMLHRElement.idl',
            'html/HTMLHeadElement.idl',
            'html/HTMLHeadingElement.idl',
            'html/HTMLHtmlElement.idl',
            'html/HTMLIFrameElement.idl',
            'html/HTMLImageElement.idl',
            'html/HTMLInputElement.idl',
            'html/HTMLKeygenElement.idl',
            'html/HTMLLIElement.idl',
            'html/HTMLLabelElement.idl',
            'html/HTMLLegendElement.idl',
            'html/HTMLLinkElement.idl',
            'html/HTMLMapElement.idl',
            'html/HTMLMarqueeElement.idl',
            'html/HTMLMediaElement.idl',
            'html/HTMLMenuElement.idl',
            'html/HTMLMenuItemElement.idl',
            'html/HTMLMetaElement.idl',
            'html/HTMLMeterElement.idl',
            'html/HTMLModElement.idl',
            'html/HTMLOListElement.idl',
            'html/HTMLObjectElement.idl',
            'html/HTMLOptGroupElement.idl',
            'html/HTMLOptionElement.idl',
            'html/HTMLOptionsCollection.idl',
            'html/HTMLOutputElement.idl',
            'html/HTMLParagraphElement.idl',
            'html/HTMLParamElement.idl',
            'html/HTMLPictureElement.idl',
            'html/HTMLPreElement.idl',
            'html/HTMLProgressElement.idl',
            'html/HTMLQuoteElement.idl',
            'html/HTMLScriptElement.idl',
            'html/HTMLSelectElement.idl',
            'html/HTMLShadowElement.idl',
            'html/HTMLSourceElement.idl',
            'html/HTMLSpanElement.idl',
            'html/HTMLStyleElement.idl',
            'html/HTMLTableCaptionElement.idl',
            'html/HTMLTableCellElement.idl',
            'html/HTMLTableColElement.idl',
            'html/HTMLTableElement.idl',
            'html/HTMLTableRowElement.idl',
            'html/HTMLTableSectionElement.idl',
            'html/HTMLTemplateElement.idl',
            'html/HTMLTextAreaElement.idl',
            'html/HTMLTitleElement.idl',
            'html/HTMLTrackElement.idl',
            'html/HTMLUListElement.idl',
            'html/HTMLUnknownElement.idl',
            'html/HTMLVideoElement.idl',
            'html/ImageData.idl',
            'html/MediaController.idl',
            'html/MediaError.idl',
            'html/MediaKeyError.idl',
            'html/MediaKeyEvent.idl',
            'html/RadioNodeList.idl',
            'html/TextMetrics.idl',
            'html/TimeRanges.idl',
            'html/ValidityState.idl',
            'html/VoidCallback.idl',
            'html/canvas/ANGLEInstancedArrays.idl',
            'html/canvas/Canvas2DContextAttributes.idl',
            'html/canvas/CanvasGradient.idl',
            'html/canvas/CanvasPattern.idl',
            'html/canvas/CanvasRenderingContext2D.idl',
            'html/canvas/EXTBlendMinMax.idl',
            'html/canvas/EXTFragDepth.idl',
            'html/canvas/EXTShaderTextureLOD.idl',
            'html/canvas/EXTTextureFilterAnisotropic.idl',
            'html/canvas/OESElementIndexUint.idl',
            'html/canvas/OESStandardDerivatives.idl',
            'html/canvas/OESTextureFloat.idl',
            'html/canvas/OESTextureFloatLinear.idl',
            'html/canvas/OESTextureHalfFloat.idl',
            'html/canvas/OESTextureHalfFloatLinear.idl',
            'html/canvas/OESVertexArrayObject.idl',
            'html/canvas/Path2D.idl',
            'html/canvas/WebGLActiveInfo.idl',
            'html/canvas/WebGLBuffer.idl',
            'html/canvas/WebGLCompressedTextureATC.idl',
            'html/canvas/WebGLCompressedTextureETC1.idl',
            'html/canvas/WebGLCompressedTexturePVRTC.idl',
            'html/canvas/WebGLCompressedTextureS3TC.idl',
            'html/canvas/WebGLContextAttributes.idl',
            'html/canvas/WebGLContextEvent.idl',
            'html/canvas/WebGLDebugRendererInfo.idl',
            'html/canvas/WebGLDebugShaders.idl',
            'html/canvas/WebGLDepthTexture.idl',
            'html/canvas/WebGLDrawBuffers.idl',
            'html/canvas/WebGLFramebuffer.idl',
            'html/canvas/WebGLLoseContext.idl',
            'html/canvas/WebGLProgram.idl',
            'html/canvas/WebGLRenderbuffer.idl',
            'html/canvas/WebGLRenderingContext.idl',
            'html/canvas/WebGLShader.idl',
            'html/canvas/WebGLShaderPrecisionFormat.idl',
            'html/canvas/WebGLTexture.idl',
            'html/canvas/WebGLUniformLocation.idl',
            'html/canvas/WebGLVertexArrayObjectOES.idl',
            'html/ime/InputMethodContext.idl',
            'html/shadow/PluginPlaceholderElement.idl',
            'html/track/AudioTrack.idl',
            'html/track/AudioTrackList.idl',
            'html/track/TextTrack.idl',
            'html/track/TextTrackCue.idl',
            'html/track/TextTrackCueList.idl',
            'html/track/TextTrackList.idl',
            'html/track/TrackEvent.idl',
            'html/track/VideoTrack.idl',
            'html/track/VideoTrackList.idl',
            'html/track/vtt/VTTCue.idl',
            'html/track/vtt/VTTRegion.idl',
            'html/track/vtt/VTTRegionList.idl',
            'inspector/InjectedScriptHost.idl',
            'inspector/InspectorFrontendHost.idl',
            'inspector/InspectorOverlayHost.idl',
            'inspector/JavaScriptCallFrame.idl',
            'loader/appcache/ApplicationCache.idl',
            'page/EventSource.idl',
            'page/PagePopupController.idl',
            'plugins/MimeType.idl',
            'plugins/MimeTypeArray.idl',
            'plugins/Plugin.idl',
            'plugins/PluginArray.idl',
            'storage/Storage.idl',
            'storage/StorageEvent.idl',
            'streams/ReadableStream.idl',
            'streams/Stream.idl',
            'svg/SVGAElement.idl',
            'svg/SVGAltGlyphDefElement.idl',
            'svg/SVGAltGlyphElement.idl',
            'svg/SVGAltGlyphItemElement.idl',
            'svg/SVGAngle.idl',
            'svg/SVGAnimateElement.idl',
            'svg/SVGAnimateMotionElement.idl',
            'svg/SVGAnimateTransformElement.idl',
            'svg/SVGAnimatedAngle.idl',
            'svg/SVGAnimatedBoolean.idl',
            'svg/SVGAnimatedEnumeration.idl',
            'svg/SVGAnimatedInteger.idl',
            'svg/SVGAnimatedLength.idl',
            'svg/SVGAnimatedLengthList.idl',
            'svg/SVGAnimatedNumber.idl',
            'svg/SVGAnimatedNumberList.idl',
            'svg/SVGAnimatedPreserveAspectRatio.idl',
            'svg/SVGAnimatedRect.idl',
            'svg/SVGAnimatedString.idl',
            'svg/SVGAnimatedTransformList.idl',
            'svg/SVGAnimationElement.idl',
            'svg/SVGCircleElement.idl',
            'svg/SVGClipPathElement.idl',
            'svg/SVGComponentTransferFunctionElement.idl',
            'svg/SVGCursorElement.idl',
            'svg/SVGDefsElement.idl',
            'svg/SVGDescElement.idl',
            'svg/SVGDiscardElement.idl',
            'svg/SVGElement.idl',
            'svg/SVGEllipseElement.idl',
            'svg/SVGFEBlendElement.idl',
            'svg/SVGFEColorMatrixElement.idl',
            'svg/SVGFEComponentTransferElement.idl',
            'svg/SVGFECompositeElement.idl',
            'svg/SVGFEConvolveMatrixElement.idl',
            'svg/SVGFEDiffuseLightingElement.idl',
            'svg/SVGFEDisplacementMapElement.idl',
            'svg/SVGFEDistantLightElement.idl',
            'svg/SVGFEDropShadowElement.idl',
            'svg/SVGFEFloodElement.idl',
            'svg/SVGFEFuncAElement.idl',
            'svg/SVGFEFuncBElement.idl',
            'svg/SVGFEFuncGElement.idl',
            'svg/SVGFEFuncRElement.idl',
            'svg/SVGFEGaussianBlurElement.idl',
            'svg/SVGFEImageElement.idl',
            'svg/SVGFEMergeElement.idl',
            'svg/SVGFEMergeNodeElement.idl',
            'svg/SVGFEMorphologyElement.idl',
            'svg/SVGFEOffsetElement.idl',
            'svg/SVGFEPointLightElement.idl',
            'svg/SVGFESpecularLightingElement.idl',
            'svg/SVGFESpotLightElement.idl',
            'svg/SVGFETileElement.idl',
            'svg/SVGFETurbulenceElement.idl',
            'svg/SVGFilterElement.idl',
            'svg/SVGFontElement.idl',
            'svg/SVGFontFaceElement.idl',
            'svg/SVGFontFaceFormatElement.idl',
            'svg/SVGFontFaceNameElement.idl',
            'svg/SVGFontFaceSrcElement.idl',
            'svg/SVGFontFaceUriElement.idl',
            'svg/SVGForeignObjectElement.idl',
            'svg/SVGGElement.idl',
            'svg/SVGGeometryElement.idl',
            'svg/SVGGlyphElement.idl',
            'svg/SVGGlyphRefElement.idl',
            'svg/SVGGradientElement.idl',
            'svg/SVGGraphicsElement.idl',
            'svg/SVGHKernElement.idl',
            'svg/SVGImageElement.idl',
            'svg/SVGLength.idl',
            'svg/SVGLengthList.idl',
            'svg/SVGLineElement.idl',
            'svg/SVGLinearGradientElement.idl',
            'svg/SVGMPathElement.idl',
            'svg/SVGMarkerElement.idl',
            'svg/SVGMaskElement.idl',
            'svg/SVGMatrix.idl',
            'svg/SVGMetadataElement.idl',
            'svg/SVGMissingGlyphElement.idl',
            'svg/SVGNumber.idl',
            'svg/SVGNumberList.idl',
            'svg/SVGPathElement.idl',
            'svg/SVGPathSeg.idl',
            'svg/SVGPathSegArcAbs.idl',
            'svg/SVGPathSegArcRel.idl',
            'svg/SVGPathSegClosePath.idl',
            'svg/SVGPathSegCurvetoCubicAbs.idl',
            'svg/SVGPathSegCurvetoCubicRel.idl',
            'svg/SVGPathSegCurvetoCubicSmoothAbs.idl',
            'svg/SVGPathSegCurvetoCubicSmoothRel.idl',
            'svg/SVGPathSegCurvetoQuadraticAbs.idl',
            'svg/SVGPathSegCurvetoQuadraticRel.idl',
            'svg/SVGPathSegCurvetoQuadraticSmoothAbs.idl',
            'svg/SVGPathSegCurvetoQuadraticSmoothRel.idl',
            'svg/SVGPathSegLinetoAbs.idl',
            'svg/SVGPathSegLinetoHorizontalAbs.idl',
            'svg/SVGPathSegLinetoHorizontalRel.idl',
            'svg/SVGPathSegLinetoRel.idl',
            'svg/SVGPathSegLinetoVerticalAbs.idl',
            'svg/SVGPathSegLinetoVerticalRel.idl',
            'svg/SVGPathSegList.idl',
            'svg/SVGPathSegMovetoAbs.idl',
            'svg/SVGPathSegMovetoRel.idl',
            'svg/SVGPatternElement.idl',
            'svg/SVGPoint.idl',
            'svg/SVGPointList.idl',
            'svg/SVGPolygonElement.idl',
            'svg/SVGPolylineElement.idl',
            'svg/SVGPreserveAspectRatio.idl',
            'svg/SVGRadialGradientElement.idl',
            'svg/SVGRect.idl',
            'svg/SVGRectElement.idl',
            'svg/SVGRenderingIntent.idl',
            'svg/SVGSVGElement.idl',
            'svg/SVGScriptElement.idl',
            'svg/SVGSetElement.idl',
            'svg/SVGStopElement.idl',
            'svg/SVGStringList.idl',
            'svg/SVGStyleElement.idl',
            'svg/SVGSwitchElement.idl',
            'svg/SVGSymbolElement.idl',
            'svg/SVGTSpanElement.idl',
            'svg/SVGTextContentElement.idl',
            'svg/SVGTextElement.idl',
            'svg/SVGTextPathElement.idl',
            'svg/SVGTextPositioningElement.idl',
            'svg/SVGTitleElement.idl',
            'svg/SVGTransform.idl',
            'svg/SVGTransformList.idl',
            'svg/SVGUnitTypes.idl',
            'svg/SVGUseElement.idl',
            'svg/SVGVKernElement.idl',
            'svg/SVGViewElement.idl',
            'svg/SVGViewSpec.idl',
            'svg/SVGZoomEvent.idl',
            'timing/MemoryInfo.idl',
            'timing/Performance.idl',
            'timing/PerformanceEntry.idl',
            'timing/PerformanceMark.idl',
            'timing/PerformanceMeasure.idl',
            'timing/PerformanceNavigation.idl',
            'timing/PerformanceResourceTiming.idl',
            'timing/PerformanceTiming.idl',
            'workers/DedicatedWorkerGlobalScope.idl',
            'workers/SharedWorker.idl',
            'workers/SharedWorkerGlobalScope.idl',
            'workers/Worker.idl',
            'workers/WorkerConsole.idl',
            'workers/WorkerGlobalScope.idl',
            'workers/WorkerLocation.idl',
            'workers/WorkerNavigator.idl',
            'xml/DOMParser.idl',
            'xml/XMLHttpRequest.idl',
            'xml/XMLHttpRequestEventTarget.idl',
            'xml/XMLHttpRequestProgressEvent.idl',
            'xml/XMLHttpRequestUpload.idl',
            'xml/XMLSerializer.idl',
            'xml/XPathEvaluator.idl',
            'xml/XPathExpression.idl',
            'xml/XPathNSResolver.idl',
            'xml/XPathResult.idl',
            'xml/XSLTProcessor.idl',
]


def full_path_core_idl_files():
    return full_path(['Source', 'core'], core_idl_files)


# This list is copied from Source/core/core.gypi 'core_dependency_idl_files'
# 'partial interface' or target (right side of) 'implements'
core_dependency_idl_files = [
            'animation/DocumentAnimation.idl',
            'animation/ElementAnimation.idl',
            'css/DocumentFontFaceSet.idl',
            'dom/ChildNode.idl',
            'dom/DocumentFullscreen.idl',
            'dom/ElementFullscreen.idl',
            'dom/GlobalEventHandlers.idl',
            'dom/ParentNode.idl',
            'dom/URLUtils.idl',
            'dom/URLUtilsReadOnly.idl',
            'events/EventListener.idl',
            'events/NavigatorEvents.idl',
            'frame/NavigatorCPU.idl',
            'frame/NavigatorID.idl',
            'frame/NavigatorLanguage.idl',
            'frame/NavigatorOnLine.idl',
            'frame/WindowBase64.idl',
            'frame/WindowEventHandlers.idl',
            'frame/WindowTimers.idl',
            'html/canvas/CanvasPathMethods.idl',
            'html/canvas/MouseEventHitRegion.idl',
            'html/canvas/WebGLRenderingContextBase.idl',
            'imagebitmap/ImageBitmapFactories.idl',
            'imagebitmap/WindowImageBitmapFactories.idl',
            'page/WindowPagePopup.idl',
            'svg/SVGDocument.idl',
            'svg/SVGFilterPrimitiveStandardAttributes.idl',
            'svg/SVGFitToViewBox.idl',
            'svg/SVGTests.idl',
            'svg/SVGURIReference.idl',
            'svg/SVGZoomAndPan.idl',
            'workers/AbstractWorker.idl',
            'xml/DocumentXMLTreeViewer.idl',
            'xml/DocumentXPathEvaluator.idl',
]


def full_path_core_dependency_idl_files():
    return full_path(['Source', 'core'], core_dependency_idl_files)


# This list is copied from Source/modules/modules.gypi 'modules_idl_files'
# Modules IDL files bindings (.dart, .cpp and .h files) will be generated
modules_idl_files = [
      'battery/BatteryManager.idl',
      'credentialmanager/Credential.idl',
      'credentialmanager/CredentialsContainer.idl',
      'credentialmanager/FederatedCredential.idl',
      'credentialmanager/LocalCredential.idl',
      'crypto/Crypto.idl',
      'crypto/CryptoKey.idl',
      'crypto/SubtleCrypto.idl',
      'device_light/DeviceLightEvent.idl',
      'device_orientation/DeviceAcceleration.idl',
      'device_orientation/DeviceMotionEvent.idl',
      'device_orientation/DeviceOrientationEvent.idl',
      'device_orientation/DeviceRotationRate.idl',
      'encoding/TextDecoder.idl',
      'encoding/TextEncoder.idl',
      'encryptedmedia/MediaKeyMessageEvent.idl',
      'encryptedmedia/MediaKeyNeededEvent.idl',
      'encryptedmedia/MediaKeySession.idl',
      'encryptedmedia/MediaKeys.idl',
      'filesystem/DOMFileSystem.idl',
      'filesystem/DOMFileSystemSync.idl',
      'filesystem/DirectoryEntry.idl',
      'filesystem/DirectoryEntrySync.idl',
      'filesystem/DirectoryReader.idl',
      'filesystem/DirectoryReaderSync.idl',
      'filesystem/EntriesCallback.idl',
      'filesystem/Entry.idl',
      'filesystem/EntryCallback.idl',
      'filesystem/EntrySync.idl',
      'filesystem/ErrorCallback.idl',
      'filesystem/FileCallback.idl',
      'filesystem/FileEntry.idl',
      'filesystem/FileEntrySync.idl',
      'filesystem/FileSystemCallback.idl',
      'filesystem/FileWriter.idl',
      'filesystem/FileWriterCallback.idl',
      'filesystem/FileWriterSync.idl',
      'filesystem/Metadata.idl',
      'filesystem/MetadataCallback.idl',
      'gamepad/Gamepad.idl',
      'gamepad/GamepadButton.idl',
      'gamepad/GamepadEvent.idl',
      'gamepad/GamepadList.idl',
      'gamepad/WebKitGamepad.idl',
      'gamepad/WebKitGamepadList.idl',
      'geofencing/CircularGeofencingRegion.idl',
      'geofencing/Geofencing.idl',
      'geofencing/GeofencingRegion.idl',
      'geolocation/Coordinates.idl',
      'geolocation/Geolocation.idl',
      'geolocation/Geoposition.idl',
      'geolocation/PositionCallback.idl',
      'geolocation/PositionError.idl',
      'geolocation/PositionErrorCallback.idl',
      'indexeddb/IDBCursor.idl',
      'indexeddb/IDBCursorWithValue.idl',
      'indexeddb/IDBDatabase.idl',
      'indexeddb/IDBFactory.idl',
      'indexeddb/IDBIndex.idl',
      'indexeddb/IDBKeyRange.idl',
      'indexeddb/IDBObjectStore.idl',
      'indexeddb/IDBOpenDBRequest.idl',
      'indexeddb/IDBRequest.idl',
      'indexeddb/IDBTransaction.idl',
      'indexeddb/IDBVersionChangeEvent.idl',
      'mediasource/MediaSource.idl',
      'mediasource/SourceBuffer.idl',
      'mediasource/SourceBufferList.idl',
      'mediasource/VideoPlaybackQuality.idl',
      'mediastream/MediaDeviceInfo.idl',
      'mediastream/MediaDeviceInfoCallback.idl',
      'mediastream/MediaStream.idl',
      'mediastream/MediaStreamEvent.idl',
      'mediastream/MediaStreamTrack.idl',
      'mediastream/MediaStreamTrackEvent.idl',
      'mediastream/MediaStreamTrackSourcesCallback.idl',
      'mediastream/NavigatorUserMediaError.idl',
      'mediastream/NavigatorUserMediaErrorCallback.idl',
      'mediastream/NavigatorUserMediaSuccessCallback.idl',
      'mediastream/RTCDTMFSender.idl',
      'mediastream/RTCDTMFToneChangeEvent.idl',
      'mediastream/RTCDataChannel.idl',
      'mediastream/RTCDataChannelEvent.idl',
      'mediastream/RTCErrorCallback.idl',
      'mediastream/RTCIceCandidate.idl',
      'mediastream/RTCIceCandidateEvent.idl',
      'mediastream/RTCPeerConnection.idl',
      'mediastream/RTCSessionDescription.idl',
      'mediastream/RTCSessionDescriptionCallback.idl',
      'mediastream/RTCStatsCallback.idl',
      'mediastream/RTCStatsReport.idl',
      'mediastream/RTCStatsResponse.idl',
      'mediastream/SourceInfo.idl',
      'netinfo/NetworkInformation.idl',
      'notifications/Notification.idl',
      'notifications/NotificationPermissionCallback.idl',
      'performance/WorkerPerformance.idl',
      'presentation/Presentation.idl',
      'push_messaging/PushEvent.idl',
      'push_messaging/PushManager.idl',
      'push_messaging/PushRegistration.idl',
      'quota/DeprecatedStorageInfo.idl',
      'quota/DeprecatedStorageQuota.idl',
      'quota/StorageErrorCallback.idl',
      'quota/StorageInfo.idl',
      'quota/StorageQuota.idl',
      'quota/StorageQuotaCallback.idl',
      'quota/StorageUsageCallback.idl',
      'screen_orientation/ScreenOrientation.idl',
      'serviceworkers/Body.idl',
      'serviceworkers/Cache.idl',
      'serviceworkers/CacheStorage.idl',
      'serviceworkers/ExtendableEvent.idl',
      'serviceworkers/FetchEvent.idl',
      'serviceworkers/Headers.idl',
      'serviceworkers/HeadersForEachCallback.idl',
      'serviceworkers/InstallEvent.idl',
      'serviceworkers/Request.idl',
      'serviceworkers/Response.idl',
      'serviceworkers/ServiceWorker.idl',
      'serviceworkers/ServiceWorkerClient.idl',
      'serviceworkers/ServiceWorkerClients.idl',
      'serviceworkers/ServiceWorkerContainer.idl',
      'serviceworkers/ServiceWorkerGlobalScope.idl',
      'serviceworkers/ServiceWorkerRegistration.idl',
      'speech/SpeechGrammar.idl',
      'speech/SpeechGrammarList.idl',
      'speech/SpeechRecognition.idl',
      'speech/SpeechRecognitionAlternative.idl',
      'speech/SpeechRecognitionError.idl',
      'speech/SpeechRecognitionEvent.idl',
      'speech/SpeechRecognitionResult.idl',
      'speech/SpeechRecognitionResultList.idl',
      'speech/SpeechSynthesis.idl',
      'speech/SpeechSynthesisEvent.idl',
      'speech/SpeechSynthesisUtterance.idl',
      'speech/SpeechSynthesisVoice.idl',
      'webaudio/AnalyserNode.idl',
      'webaudio/AudioBuffer.idl',
      'webaudio/AudioBufferCallback.idl',
      'webaudio/AudioBufferSourceNode.idl',
      'webaudio/AudioContext.idl',
      'webaudio/AudioDestinationNode.idl',
      'webaudio/AudioListener.idl',
      'webaudio/AudioNode.idl',
      'webaudio/AudioParam.idl',
      'webaudio/AudioProcessingEvent.idl',
      'webaudio/AudioSourceNode.idl',
      'webaudio/BiquadFilterNode.idl',
      'webaudio/ChannelMergerNode.idl',
      'webaudio/ChannelSplitterNode.idl',
      'webaudio/ConvolverNode.idl',
      'webaudio/DelayNode.idl',
      'webaudio/DynamicsCompressorNode.idl',
      'webaudio/GainNode.idl',
      'webaudio/MediaElementAudioSourceNode.idl',
      'webaudio/MediaStreamAudioDestinationNode.idl',
      'webaudio/MediaStreamAudioSourceNode.idl',
      'webaudio/OfflineAudioCompletionEvent.idl',
      'webaudio/OfflineAudioContext.idl',
      'webaudio/OscillatorNode.idl',
      'webaudio/PannerNode.idl',
      'webaudio/PeriodicWave.idl',
      'webaudio/ScriptProcessorNode.idl',
      'webaudio/WaveShaperNode.idl',
      'webdatabase/Database.idl',
      'webdatabase/DatabaseCallback.idl',
      'webdatabase/SQLError.idl',
      'webdatabase/SQLResultSet.idl',
      'webdatabase/SQLResultSetRowList.idl',
      'webdatabase/SQLStatementCallback.idl',
      'webdatabase/SQLStatementErrorCallback.idl',
      'webdatabase/SQLTransaction.idl',
      'webdatabase/SQLTransactionCallback.idl',
      'webdatabase/SQLTransactionErrorCallback.idl',
      'webmidi/MIDIAccess.idl',
      'webmidi/MIDIConnectionEvent.idl',
      'webmidi/MIDIErrorCallback.idl',
      'webmidi/MIDIInput.idl',
      'webmidi/MIDIInputMap.idl',
      'webmidi/MIDIMessageEvent.idl',
      'webmidi/MIDIOutput.idl',
      'webmidi/MIDIOutputMap.idl',
      'webmidi/MIDIPort.idl',
      'webmidi/MIDISuccessCallback.idl',
      'websockets/CloseEvent.idl',
      'websockets/WebSocket.idl',
]


def full_path_modules_idl_files():
    return full_path(['Source', 'modules'], modules_idl_files)


# This list is copied from Source/modules/modules.gypi
# 'modules_dependency_idl_files'.
# 'partial interface' or target (right side of) 'implements'
modules_dependency_idl_files = [
      'battery/NavigatorBattery.idl',
      'beacon/NavigatorBeacon.idl',
      'credentialmanager/NavigatorCredentials.idl',
      'crypto/WindowCrypto.idl',
      'crypto/WorkerGlobalScopeCrypto.idl',
      'device_light/WindowDeviceLight.idl',
      'device_orientation/WindowDeviceMotion.idl',
      'device_orientation/WindowDeviceOrientation.idl',
      'donottrack/NavigatorDoNotTrack.idl',
      'encryptedmedia/HTMLMediaElementEncryptedMedia.idl',
      'filesystem/DataTransferItemFileSystem.idl',
      'filesystem/HTMLInputElementFileSystem.idl',
      'filesystem/InspectorFrontendHostFileSystem.idl',
      'filesystem/WindowFileSystem.idl',
      'filesystem/WorkerGlobalScopeFileSystem.idl',
      'gamepad/NavigatorGamepad.idl',
      'geofencing/NavigatorGeofencing.idl',
      'geofencing/WorkerNavigatorGeofencing.idl',
      'geolocation/NavigatorGeolocation.idl',
      'indexeddb/WindowIndexedDatabase.idl',
      'indexeddb/WorkerGlobalScopeIndexedDatabase.idl',
      'mediasource/HTMLVideoElementMediaSource.idl',
      'mediasource/URLMediaSource.idl',
      'mediastream/NavigatorMediaStream.idl',
      'mediastream/URLMediaStream.idl',
      'mediastream/WindowMediaStream.idl',
      'navigatorcontentutils/NavigatorContentUtils.idl',
      'netinfo/NavigatorNetworkInformation.idl',
      'netinfo/WorkerNavigatorNetworkInformation.idl',
      'performance/SharedWorkerPerformance.idl',
      'performance/WorkerGlobalScopePerformance.idl',
      'presentation/NavigatorPresentation.idl',
      'push_messaging/NavigatorPushManager.idl',
      'push_messaging/ServiceWorkerGlobalScopePush.idl',
      'quota/NavigatorStorageQuota.idl',
      'quota/WindowQuota.idl',
      'quota/WorkerNavigatorStorageQuota.idl',
      'screen_orientation/ScreenScreenOrientation.idl',
      'serviceworkers/NavigatorServiceWorker.idl',
      'speech/WindowSpeech.idl',
      'speech/WindowSpeechSynthesis.idl',
      'vibration/NavigatorVibration.idl',
      'webaudio/WindowWebAudio.idl',
      'webdatabase/WindowWebDatabase.idl',
      'webmidi/NavigatorWebMIDI.idl',
]

def full_path_modules_dependency_idl_files():
    return full_path(['Source', 'modules'], modules_dependency_idl_files)


core_dictionary_idl_files = [
          'css/FontFaceDescriptors.idl',
          'dom/DOMPointInit.idl',
          'dom/MutationObserverInit.idl',
          'frame/ScrollOptions.idl',
          'html/canvas/HitRegionOptions.idl',
          'page/EventSourceInit.idl',
]
def full_path_core_dictionary_idl_files():
    return full_path(['Source', 'core'], core_dictionary_idl_files)


modules_dictionary_idl_files = [
      'encoding/TextDecodeOptions.idl',
      'encoding/TextDecoderOptions.idl',
      'indexeddb/IDBIndexParameters.idl',
      'notifications/NotificationOptions.idl',
      'serviceworkers/QueryParams.idl',
      'serviceworkers/RegistrationOptionList.idl',
      'serviceworkers/ServiceWorkerClientQueryParams.idl',
      'webmidi/MIDIOptions.idl',
]

def full_path_modules_dictionary_idl_files():
    return full_path(['Source', 'modules'], modules_dictionary_idl_files)
