# gsutil

gsutil is a Python application that lets you access Google Cloud Storage from
the command line. You can use gsutil to do a wide range of bucket and object
management tasks, including:

* Creating and deleting buckets.
* Uploading, downloading, and deleting objects.
* Listing buckets and objects.
* Moving, copying, and renaming objects.
* Editing object and bucket ACLs.

## Installation

For installation instructions, please see:

https://developers.google.com/storage/docs/gsutil_install

## Testing / Development

The gsutil source code is available at https://github.com/GoogleCloudPlatform/gsutil

For information on developing gsutil and instructions for running the gsutil
test suite, run the "gsutil help dev" command. Instructions are also available
online at:

https://developers.google.com/storage/docs/gsutil/addlhelp/ContributingCodetogsutil

## Help and Support

Run the "gsutil help" command for a list of the built-in gsutil help topics.

You can also browse the help pages online at:

https://developers.google.com/storage/docs/gsutil

For community support, visit:

https://developers.google.com/storage/docs/resources-support#community

## Scripts

The scripts directory contains useful scripts built atop gsutil.

### Bucket Relocation

The `bucket_relocate.sh` script can be used to migrate one or more buckets to a
different location and/or storage class. Detailed instructions are provided
if you run the script with no arguments.
